/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.erd;

import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.erd.ERDConstants;
import org.jkiss.dbeaver.model.erd.ERDElement;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDLogicalPrimaryKey;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;

public class ERDLogicalAssociation
implements DBSEntityAssociation,
DBSEntityReferrer {
    private ERDElement entity;
    private final String name;
    private final String description;
    private final ERDLogicalPrimaryKey pk;

    public ERDLogicalAssociation(ERDElement<?> entity, String name, String description, ERDLogicalPrimaryKey pk) {
        this.entity = entity;
        this.name = name;
        this.description = description;
        this.pk = pk;
    }

    @Nullable
    public DBSEntityConstraint getReferencedConstraint() {
        return this.pk;
    }

    @Nullable
    public DBSEntity getAssociatedEntity() {
        return this.pk.getParentObject();
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.entity instanceof ERDEntity ? ((ERDEntity)this.entity).getDataSource() : null;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public DBSEntity getParentObject() {
        return this.entity instanceof ERDEntity ? (DBSEntity)((ERDEntity)this.entity).getObject() : null;
    }

    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return ERDConstants.CONSTRAINT_LOGICAL_FK;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return false;
    }

    public List<? extends DBSEntityAttributeRef> getAttributeReferences(@Nullable DBRProgressMonitor monitor) {
        return Collections.emptyList();
    }
}

