/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.dialogs.StandardErrorDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ConnectionLostDialog
extends StandardErrorDialog {
    private final String stopButtonName;

    public ConnectionLostDialog(Shell parentShell, DBPDataSourceContainer container, Throwable error, String stopButtonName) {
        super(parentShell, "Connection lost", "Connection to '" + container.getName() + "' was lost and cannot be re-established.\nWhat do you want to do?", GeneralUtils.makeExceptionStatus((Throwable)error), 7);
        this.stopButtonName = stopButtonName;
    }

    @Override
    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 6, this.stopButtonName, true);
        this.createButton(parent, 8, IDialogConstants.RETRY_LABEL, false);
        this.createButton(parent, 9, IDialogConstants.IGNORE_LABEL, false);
        this.createDetailsButton(parent);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            super.buttonPressed(buttonId);
            return;
        }
        this.setReturnCode(buttonId);
        this.close();
    }
}

