/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLNativeCredentialsSettings;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.tasks.nativetool.AbstractScriptExecuteSettings;
import org.jkiss.utils.CommonUtils;

public class MySQLScriptExecuteSettings
extends AbstractScriptExecuteSettings<MySQLCatalog>
implements MySQLNativeCredentialsSettings {
    private static final String PREFERENCE_PREFIX = "MySQL.script.";
    private static final String PREFERENCE_IS_IMPORT = "MySQL.script..import";
    private static final String PREFERENCE_LOG_LEVEL = "MySQL.script.logLevel";
    private static final String PREFERENCE_NO_BEEP = "MySQL.script.noBeep";
    private static final String PREFERENCE_DISABLE_FOREIGN_KEY = "MySQL.script.disableForeignKey";
    private LogLevel logLevel = LogLevel.Normal;
    private boolean noBeep = true;
    private boolean isImport;
    private boolean isForeignKeyCheckDisabled;
    private boolean overrideCredentials;

    public MySQLScriptExecuteSettings() {
    }

    public MySQLScriptExecuteSettings(@NotNull DBPProject project) {
        super(project);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isNoBeep() {
        return this.noBeep;
    }

    public void setNoBeep(boolean noBeep) {
        this.noBeep = noBeep;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public void setImport(boolean anImport) {
        this.isImport = anImport;
    }

    public boolean isVerbose() {
        return this.logLevel == LogLevel.Verbose || this.logLevel == LogLevel.Debug;
    }

    public void setIsForeignKeyCheckDisabled(boolean isForeignKeyCheckDisabled) {
        this.isForeignKeyCheckDisabled = isForeignKeyCheckDisabled;
    }

    public boolean isForeignKeyCheckDisabled() {
        return this.isForeignKeyCheckDisabled;
    }

    @Override
    public boolean isOverrideCredentials() {
        return this.overrideCredentials;
    }

    @Override
    public void setOverrideCredentials(boolean value) {
        this.overrideCredentials = value;
    }

    public DBPNativeClientLocation findNativeClientHome(String clientHomeId) {
        return MySQLDataSourceProvider.getServerHome(clientHomeId);
    }

    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) throws DBException {
        this.isImport = CommonUtils.getBoolean((String)preferenceStore.getString(PREFERENCE_IS_IMPORT), (boolean)this.isImport);
        this.logLevel = (LogLevel)CommonUtils.valueOf(LogLevel.class, (String)preferenceStore.getString(PREFERENCE_LOG_LEVEL), (Enum)LogLevel.Normal);
        this.noBeep = CommonUtils.toBoolean((Object)preferenceStore.getString(PREFERENCE_NO_BEEP));
        this.isForeignKeyCheckDisabled = CommonUtils.toBoolean((Object)preferenceStore.getString(PREFERENCE_DISABLE_FOREIGN_KEY));
        this.overrideCredentials = CommonUtils.toBoolean((Object)preferenceStore.getString("MySQL.overrideNativeCredentials"));
        super.loadSettings(runnableContext, preferenceStore);
    }

    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) {
        super.saveSettings(runnableContext, preferenceStore);
        preferenceStore.setValue(PREFERENCE_IS_IMPORT, this.isImport);
        preferenceStore.setValue(PREFERENCE_LOG_LEVEL, this.logLevel.name());
        preferenceStore.setValue(PREFERENCE_NO_BEEP, this.noBeep);
        preferenceStore.setValue(PREFERENCE_DISABLE_FOREIGN_KEY, this.isForeignKeyCheckDisabled);
        preferenceStore.setValue("MySQL.overrideNativeCredentials", this.overrideCredentials);
    }

    public static enum LogLevel {
        Normal,
        Verbose,
        Debug;

    }
}

