/* Copyright (c) 2017-2024 hors<horsicq@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#include "specabstract.h"

// TODO separate
SpecAbstract::SIGNATURE_RECORD _binary_records[]=
{
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_CERTIFICATE,      SpecAbstract::RECORD_NAME_WINAUTH,                      "2.0",              "PKCS #7"},             "........00020200"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DATABASE,         SpecAbstract::RECORD_NAME_MICROSOFTACCESS,              "",                 ""},                    "00010000'Standard Jet DB'00"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DATABASE,         SpecAbstract::RECORD_NAME_MICROSOFTACCESS,              "2010",             ""},                    "00010000'Standard ACE DB'00"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DATABASE,         SpecAbstract::RECORD_NAME_MICROSOFTLINKERDATABASE,      "",                 ""},                    "'Microsoft Linker Database\n\n'071A"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DATABASE,         SpecAbstract::RECORD_NAME_PDB,                          "2.00",             ""},                    "'Microsoft C/C++ program database 2.00\r\n'1A'JG'0000"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DATABASE,         SpecAbstract::RECORD_NAME_PDB,                          "7.00",             ""},                    "'Microsoft C/C++ MSF 7.00\r\n'1A'DS'000000"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_AUTOIT,                       "2.XX-3.XX",        "Compiled script"},     "A3484BBE986C4AA9"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_AR,                           "",                 ""},                    "'!<arch>'0A"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_COFF,                         "",                 ""},                    "'!<arch>'0A2F"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_DEX,                          "",                 ""},                    "'dex\n'......00"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_JAVACOMPILEDCLASS,            "",                 ""},                    "CAFEBABE"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_LUACOMPILED,                  "",                 ""},                    "1B'Lua'..000104040408"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_MICROSOFTCOMPILEDHTMLHELP,    "",                 ""},                    "'ITSF'03000000"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_MICROSOFTCOMPOUND,            "",                 "MSO 97-2003 or MSI"},  "D0CF11E0A1B11AE1"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_MICROSOFTWINHELP,             "",                 ""},                    "3f5f0300"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_MP3,                          "",                 ""},                    "'ID3'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_MP4,                          "",                 ""},                    "000000..'ftyp'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_PDF,                          "",                 ""},                    "'%PDF'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_RTF,                          "",                 ""},                    "'{'5C'rtf'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_SWF,                          "",                 "LZMA"},                "'ZWS'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_SWF,                          "",                 "Uncompressed"},        "'FWS'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_SWF,                          "",                 "zlib"},                "'CWS'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_WAV,                          "",                 ""},                    "................'WAVEfmt'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_DJVU,                         "",                 ""},                    "'AT&T'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_JPEG,                         "",                 ""},                    "FFD8FFE0....'JFIF'00"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_JPEG,                         "",                 "EXIF"},                "FFD8FFE1....'Exif'00"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TIFF,                         "",                 "BE"},                  "'MM'002A"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TIFF,                         "",                 "LE"},                  "'II'2A00"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_GIF,                          "",                 ""},                    "'GIF8'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_PNG,                          "",                 ""},                    "89'PNG\r\n'1A0A........'IHDR'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_WINDOWSBITMAP,                "",                 ""},                    "'BM'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_WINDOWSICON,                  "",                 ""},                    "00000100"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_WINDOWSCURSOR,                "",                 ""},                    "00000200"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_AU,                           "",                 ""},                    "'.snd'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_DEB,                          "",                 ""},                    "'!<arch>'0a'debian-binary'"}, // TODO Check
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_AVI,                          "",                 ""},                    "'RIFF'........'AVI '"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_WEBP,                         "",                 ""},                    "'RIFF'........'WEBPVP8'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'OS/2'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'BASE'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'cmap'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'DSIG'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'EBDT'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'Feat'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'FFTM'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'GPOS'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'GSUB'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_TTF,                          "",                 ""},                    "........................................................'LTSH'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_ANDROIDXML,                   "",                 ""},                    "03000800"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_ANDROIDARSC,                  "",                 ""},                    "02000C00"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_WINDOWSMEDIA,                 "",                 ""},                    "3026B2758E66CF11A6D900AA0062CE6C"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_FLASHVIDEO,                   "",                 ""},                    "'FLV'01"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_SOURCECODE,       SpecAbstract::RECORD_NAME_SHELL,                        "",                 ""},                    "'#!'"}, // "'#!c:\python\python.exe'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DEBUGDATA,        SpecAbstract::RECORD_NAME_BORLANDDEBUGINFO,             "",                 "TDS"},                 "FB52"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DEBUGDATA,        SpecAbstract::RECORD_NAME_BORLANDDEBUGINFO,             "",                 "Delphi TDS"},          "'FB09'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DEBUGDATA,        SpecAbstract::RECORD_NAME_BORLANDDEBUGINFO,             "",                 "C++ TDS"},             "'FB0A'"}
};

SpecAbstract::SIGNATURE_RECORD _debugdata_records[]=
{
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DEBUGDATA,        SpecAbstract::RECORD_NAME_PDBFILELINK,                  "7.0",              ""},                    "'RSDS'"},
};

SpecAbstract::SIGNATURE_RECORD _archive_records[]=
{
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_7Z,                           "",                 ""},                    "'7z'BCAF271C"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_ARJ,                          "",                 ""},                    "60EA"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_BZIP2,                        "",                 ""},                    "'BZh'"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_CAB,                          "",                 ""},                    "'MSCF'"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_GZIP,                         "",                 ""},                    "1F8B08"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_LHA,                          "",                 ""},                    "....'-lh'..2D"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_LHA,                          "",                 ""},                    "....'-lz'..2D"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_LZFSE,                        "",                 ""},                    "'bvxn'"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_RAR,                          "1.4",              ""},                    "'RE~^'"},
    {{1, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_RAR,                          "4.X",              ""},                    "'Rar!'1A0700"},
    {{1, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_RAR,                          "5.X",              ""},                    "'Rar!'1A070100"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_XAR,                          "",                 ""},                    "'xar!'001C00010000"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_ZLIB,                         "",                 "level 1(no/low)"},     "7801"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_ZLIB,                         "",                 "level 2-5"},           "785E"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_ZLIB,                         "",                 "level 6(default)"},    "789C"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_ZLIB,                         "",                 "level 7-9(best)"},     "78DA"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_XZ,                           "",                 ""},                    "FD'7zXZ'0000"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_MACHOFAT,                     "",                 ""},                    "CAFEBABE"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_MACHOFAT,                     "",                 ""},                    "BEBAFECA"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_ZIP,                          "",                 ""},                    "'PK'0304"},
    {{0, XBinary::FT_ARCHIVE,   SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_ZIP,                          "",                 "Empty"},               "'PK'0506"},
};

SpecAbstract::SIGNATURE_RECORD _PE_overlay_records[]=
{
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_ACTUALINSTALLER,              "",                 ""},                    "....................'MSCF'00"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_AVASTANTIVIRUS,               "",                 ""},                    "'ASWsetupFPkgFil3'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_CLICKTEAM,                    "",                 ""},                    "'wwgT)'"},
    {{1, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_CLICKTEAM,                    "",                 ""},                    "..120100....0000"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_GHOSTINSTALLER,               "1.0",              "Xored MSCF, mask: 8D"},"C0DECECB8D8D8D8D"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_GPINSTALL,                    "",                 ""},                    "........'SPIS'1a'LH5'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_INNOSETUP,                    "",                 ""},                    "'Inno Setup Setup Data'"}, // TODO Check version
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_INNOSETUP,                    "",                 "Install"},             "'idska32'1A"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_INNOSETUP,                    "",                 "Install"},             "'zlb'1A"}, // TODO none
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_INNOSETUP,                    "",                 "Uninstall"},           "'Inno Setup Messages'"},  // TODO check
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_INSTALL4J,                    "",                 ""},                    "D513E4E801000000"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_INSTALLANYWHERE,              "",                 ""},                    "5B3E"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_INSTALLSHIELD,                "",                 ""},                    "'ISSetupStream'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_INSTALLSHIELD,                "",                 "PackageForTheWeb"},    "....0000dcedbd"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_NSIS,                         "",                 ""},                    "EFBEADDE'Null'..'oftInst'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_NSIS,                         "",                 ""},                    "..000000EFBEADDE'NullsoftInst'"},
    {{1, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_NSIS,                         "",                 ""},                    "EFBEADDE'nsisinstall'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_OPERA,                        "",                 ""},                    "'OPR7z'BCAF271C"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_QTINSTALLER,                  "",                 ""},                    "'qres'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_SETUPFACTORY,                 "4.X-7.X",          ""},                    "E0E1E2E3E4E5E6"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_SETUPFACTORY,                 "8.X-9.X",          ""},                    "E0E0E1E1E2E2E3E3E4E4E5E5E6E6E7E7"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_SMARTINSTALLMAKER,            "",                 ""},                    "'Smart Install Maker v'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_TARMAINSTALLER,               "",                 "zlib"},                "'tiz1'........78DA'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_VMWARE,                       "",                 ""},                    "'RWMV'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_1337EXECRYPTER,               "1",                ""},                    "60'*[S-P-L-I-T]*'60"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_1337EXECRYPTER,               "2",                ""},                    "'~SPLIT~'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_ACTIVEMARK,                   "",                 ""},                    "00'TMSAMVOH"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_AGAINNATIVITYCRYPTER,         "",                 ""},                    "'<%*#%>'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_ARCRYPT,                      "",                 ""},                    "'@@##@@'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_FASTFILECRYPT,                "",                 ""},                    "'(==#==)'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_FISHNET,                      "1.X",              ""},                    "0800'FISH_NET'0100"},
    {{1, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_FISHNET,                      "1.X",              ""},                    "000800'FISH_NET'0100"},
    {{2, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_FISHNET,                      "1.X",              ""},                    "00000800'FISH_NET'0100"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_LIGHTNINGCRYPTERSCANTIME,     "",                 ""},                    "'F3B14NVA'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_MOLEBOXULTRA,                 "",                 ""},                    "'XOJUMANJ'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_NOXCRYPT,                     "",                 ""},                    "'|||'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_WLCRYPT,                      "",                 ""},                    "'[Crypted Key]'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_WOUTHRSEXECRYPTER,            "",                 ""},                    "'<%>'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_XENOCODE,                     "",                 ""},                    "'xvm'0001"}, // Check Turbo https://en.wikipedia.org/wiki/Turbo_(software)
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_SPOONSTUDIO,                  "",                 ""},                    "'xvm'0003"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_ZELDACRYPT,                   "",                 ""},                    "2F232F2B5C235C"}, // '/#/+\#\'
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_SFXDATA,          SpecAbstract::RECORD_NAME_7Z,                           "",                 ""},                    "';!@Install@!UTF-8!'"},
    {{1, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_SFXDATA,          SpecAbstract::RECORD_NAME_7Z,                           "",                 ""},                    "EFBBBF';!@Install@!UTF-8!'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_SFXDATA,          SpecAbstract::RECORD_NAME_SQUEEZSFX,                    "",                 ""},                    "'SQ5SFX'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_SFXDATA,          SpecAbstract::RECORD_NAME_WINRAR,                       "",                 ""},                    "'***messages***'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_ADVANCEDINSTALLER,            "",                 ""},                    "2F30EE1F5E4EE51E"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DEBUGDATA,        SpecAbstract::RECORD_NAME_MINGW,                        "",                 ""},                    "'.file'000000"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DEBUGDATA,        SpecAbstract::RECORD_NAME_PDBFILELINK,                  "2.0",              ""},                    "'NB10'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_DEBUGDATA,        SpecAbstract::RECORD_NAME_PDBFILELINK,                  "7.0",              ""},                    "'RSDS'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_DOTNETSHRINK,                 "2.01",             ""},                    "5D00000002"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_SIXXPACK,                     "",                 ""},                    "5D0000800000"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_THINSTALL,                    "",                 ""},                    "09050000"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_INSTALLERDATA,    SpecAbstract::RECORD_NAME_NOSINSTALLER,                 "",                 ""},                    "'NOS_PO'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_SECUROM,                      "",                 ""},                    "'AddD'03"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_SERGREENAPPACKER,             "",                 ""},                    "'<SerGreen>'"},
    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_PROTECTORDATA,    SpecAbstract::RECORD_NAME_NATIVECRYPTORBYDOSX,          "",                 ""},                    "'7stgc_hdr'00"},
};

//SpecAbstract::SIGNATURE_RECORD _PE_resource_records[]=
//{
//    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_RESOURCE_VERSIONINFO,         "",                 ""},                    "........0000560053005F00560045005200530049004F004E005F0049004E0046004F00"},
//    {{0, XBinary::FT_BINARY,    SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_BITMAPINFOHEADER,             "",                 ""},                    "28000000................0100"},
//};

SpecAbstract::SIGNATURE_RECORD _COM_records[]=
{
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE,                       "1.00, 1.03",       "exe2com"},             "B8....BA....8CDB03D83B1E....73..83EB..FA8ED3BC....FB83EB..8EC353B9....33FF57BE....FCF3A5CB"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE,                       "1.00c",            ""},                    "BA....A1....2D....8CCB81C3....3BC377..05....3BC377..B4..BA....CD21CD20"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE,                       "1.12, 1.20",       ""},                    "B8....BA....3BC473..8BC42D....25....8BF8B9....BE....FCF3A58BD8B1..D3EB8CD903D95333DB53CB"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE,                       "1.15",             ""},                    "B8....BA....3BC473..8BC42D....9025....8BF8B9....90BE....FCF3A58BD8B1..D3EB8CD903D95333DB53CB"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE,                       "1.50",             ""},                    "50B8....BA....3BC473..8BC42D....25....8BF8B9....BE....FCF3A58BD8B1..D3EB8CD903D95333DB53CB"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE,                       "1.1x",             ""},                    "BA....B8....05....3B06....73..2D....FA8ED0FB2D....8EC050B9....33FF57BE....FCF3A5CB"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HACKSTOP,                     "1.13cs",           ""},                    "FABD....FFE5"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HACKSTOP,                     "1.14s",            ""},                    "FABB....FFE3"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HACKSTOP,                     "1.17cr",           ""},                    "FABE....FFE6"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.30-0.40",        ""},                    "B9....BE....BF....BD....FDF3A4FCF7E19387F783C6..57E9"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.50",             ""},                    "B9....BE....BF....FDF3A4FCF7E19387F783EE..19ED57"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.81-1.20",        ""},                    "81FC....77..CD20B9....BE....BF....BB....FDF3A4FC87F783EE"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTDISMEMBER,               "1.7",              ""},                    "0E179C58F6C4..74..EB..90B4..BE....BF....B9....68....68....68....57F3A4C3"},
};

SpecAbstract::SIGNATURE_RECORD _COM_Exp_records[]=
{
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SPIRIT,                       "1.X",              ""},                    "E9$$$$B430CD21F6D12EA6E8....B462CD21E8....3636FB969034..C3"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SPIRIT,                       "1.5",              ""},                    "E9$$$$AEE8$$$$E4210C..FBE62190B8....FB5026509087C1"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SPIRIT,                       "1.5",              ""},                    "E9$$$$369F9F1C..E9$$$$E8$$$$E421F80C..E6218D06....FC505089C1FB"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SPIRIT,                       "1.5",              ""},                    "E9$$$$F8D72606B435CD2107E8$$$$1C..1C..33D226F6DA12DDFCF905....F8F5F6EA"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ICE,                          "1.0",              ""},                    "EB$$BE....8BFE8B0E....8B16....B8....50FCAD33C2AB8BD0E2"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_DIET,                         "1.00",             ""},                    "BF....3BFC72$$FDBE....B9....F3A5FC8BF7BF....ADAD8BE8B2..E9"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_DIET,                         "1.00, 1.00d",      ""},                    "BF....3BFC72$$BE....B9....FDF3A5FC8BF7BF....ADAD8BE8B2..E9"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_DIET,                         "1.02b, 1.10a",     ""},                    "......BF....B9....3BFC72$$FDF3A5FC8BF7BF....ADAD8BE8B2..E9"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_DIET,                         "1.20",             ""},                    "......BF....B9....3BFC72$$31DBEB$$FDF3A5FC8BF7BF....ADAD8BE8B2..E9"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_DIET,                         "1.44-1.45",        ""},                    "F99CEB$$55061E575652515350E8$$$$59B1..D3E98CC803C18ED88EC0"},
    {{0, XBinary::FT_COM,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTCOM,                     "2.0",              ""},                    "E9$$$$BE....56B9....C704....C644....8134....4646E2..31F631C9C3"},
};

// MSDOS,NE,LE,LX,PE
SpecAbstract::SIGNATURE_RECORD _MSDOS_linker_header_records[]=
{
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_TURBOLINKER,                  "",                 ""},                    "'MZ'50000200000004000F00FFFF0000B80000000000000040001A000000000000000000000000000000000000000000000000000000000000000000....0000BA10000E1FB409CD21B8014CCD219090'This program must be run under Win'....'\r\n$'370000000000"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_TURBOLINKER,                  "",                 "Patched"},             "'MZ'............................................................................................................................BA10000E1FB409CD21B8014CCD219090'This program must be run under Win'....'\r\n$'370000000000"},
//    {{1, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_TURBOLINKER,                  "",                 "MSDOS"},               "'MZ'........................................................FB..'jr'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_TURBOLINKER,                  "",                 ""},                    "'MZ'........................................................FB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "",                 ""},                    "'MZ'90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000....00000E1FBA0E00B409CD21B8014CCD21'This program cannot be run in DOS mode.\r\r\n$'00000000"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_GENERICLINKER,                "",                 ""},                    "'MZ'90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000800000000E1FBA0E00B409CD21B8014CCD21'This program cannot be run in DOS mode.\r\r\n$'00000000"},
    {{1, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_GENERICLINKER,                "",                 ""},                    "'MZ'78000100000004000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000000000000780000000E1FBA0E00B409CD21B8014CCD21'This program cannot be run in DOS mode.$'0000'PE'0000"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "",                 "Patched"},             "'MZ'90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000....000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"},
};

SpecAbstract::SIGNATURE_RECORD _PE_header_records[]=
{
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_FASM,                         "",                 ""},                    "'MZ'80000100000004001000FFFF00004001000000000000400000000000000000000000000000000000000000000000000000000000000000000000800000000E1FBA0E00B409CD21B8014CCD21'This program cannot be run in DOS mode.\r\n$'0000000000000000'PE'0000"}, // TODO patched
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_DMD32,                        "",                 ""},                    "'MZ'60000100000004001000FFFF0000FE0000001200000040000000000000000000000000000000000000000000000000000000000000000000000060000000'Requires Win32   $'161F33D2B409CD21B8014CCD2100'PE'0000"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_FORMAT,           SpecAbstract::RECORD_NAME_HXS,                          "",                 ""},                    "'MZ'0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000040000000'PE'00004C010200000000000000000000000000E00001200B010000000000000000000000000000000000000000000000000000000040000000000000"},
    {{1, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_NOSTUBLINKER,                 "",                 ""},                    "'MZ'....................................................................................................................40000000'PE'0000"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PRIVATEEXEPROTECTOR,          "1.90-1.95",        ""},                    "'MZ'90000300000004000000FFFF0000B80000000000000040000000000000000000000000000000000000000000000000000000000000000000000078000000BA10000E1FB409CD21B8014CCD219090'This program must be run under Win32\r\n$'37'PE'0000"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PRIVATEEXEPROTECTOR,          "1.7-1.8",          ""},                    "'MZ'50000200000004000F00FFFF0000B80000000000000040001A00000000000000000000000000000000000000000000000000000000000000000078000000BA10000E1FB409CD21B8014CCD219090'This program must be run under Win32\r\n$'37'PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "0.1X-0.24",        ""},                    "'MZKERNEL32.DLL'0000'PE'0000........'UpackByDwing'"},
    {{1, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "0.24-0.32",        ""},                    "'MZKERNEL32.DLL'0000'LoadLibraryA'00000000'GetProcAddress'"},
    {{2, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "0.33",             ""},                    "'MZLoadLibraryA'0000'PE'0000........'KERNEL32'"},
    {{3, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "0.36",             ""},                    "'MZLoadLibraryA'0000'PE'0000............................................'KERNEL32.DLL'"},
    {{4, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "0.37-0.399",       ""},                    "'MZKERNEL32.DLL'0000'PE'0000............................................'LoadLibraryA'"},
    {{4, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "0.37-0.399",       "Patched"},             "'MZKERNEL32.DLL'0000'PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "0.71-0.97",        "Win32/exe"},           "'MZ'........................................................................................'Is Win32 EXE.'24"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "0.71-0.97",        "Win64/exe"},           "'MZ'........................................................................................'Is Win64 EXE.'24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "0.71-0.97",        "Win32/dll"},           "'MZ'........................................................................................'Is Win32 DLL.'24"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "0.71-0.97",        "Win64/dll"},           "'MZ'........................................................................................'Is Win64 DLL.'24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "1.27-2.12",        "Win32/exe"},           "'MZ'........................................................................................'Win32 .EXE.\r\n'"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "1.27-2.12",        "Win64/exe"},           "'MZ'........................................................................................'Win64 .EXE.\r\n'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "1.27-2.12",        "Win32/dll"},           "'MZ'........................................................................................'Win32 .DLL.\r\n'"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "1.27-2.12",        "Win64/dll"},           "'MZ'........................................................................................'Win64 .DLL.\r\n'"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "1.27-2.12",        ".NET"},                "'MZ'........................................................................................'It'27's .NET EXE"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_INSTALLER,        SpecAbstract::RECORD_NAME_INNOSETUP,                    "1.XX-5.1.X",       "Install"},             "'MZ'............................................................................................496E6E6F"}, // TODO Versions
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_INSTALLER,        SpecAbstract::RECORD_NAME_INNOSETUP,                    "",                 "Uninstall"},           "'MZ'............................................................................................496E556E"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ANDPAKK2,                     "0.18",             ""},                    "'MZ'00'ANDpakk2'00'PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_GOLINK,                       "",                 ""},                    "'MZ'6c000100000002000000ffff000000000000110000004000000000000000'Win32 Program!\r\n$'b409ba0001cd21b44ccd2160000000'GoLink, GoAsm www.GoDevTool.com'00"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_GOLINK,                       "",                 ""},                    "'MZ'6c000100000002000000ffff000000000000110000004000000000000000'Win64 Program!\r\n$'b409ba0001cd21b44ccd2160000000'GoLink, GoAsm www.GoDevTool.com'00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NSPACK,                       "2.0-2.4",          ""},                    "'MZ'40000100000002000000FFFF00000002000000000000400000....................CD21B44CCD21'packed by nspack$'40000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_LAYHEYFORTRAN90,              "",                 ""},                    "'MZ'....................................................................................................................6C030000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HMIMYSPROTECTOR,              "0.1",              ""},                    "'MZ'............................................................'hmimys'27's ProtectV0.1'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEPACKSPROTECT,               "2.3",              ""},                    "'MZ'............................................................'pepack'27's ProtectV2.3'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FSG,                          "1.00-1.20",        ""},                    "'MZ'....................................................................................................................600000000E1FBA0E00B409CD21B8014CCD21'Windows Program'0D0A24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FSG,                          "1.30-1.32",        ""},                    "'MZ'....................................................................................................................40000000'PE'00004C01....'FSG!'"},
    {{1, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FSG,                          "1.33-2.00",        ""},                    "'MZ'....................'PE'00004C01....'FSG!'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW10,                        "1.0",              ""},                    "'MZ'00000000000000000000'PE'00004C010200000000000000000000000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW11SE,                      "1.0",              ""},                    "'MZkernel32.dll'0000'PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW11SE,                      "1.1-1.2",          ""},                    "'MZ'00000000000000000000'PE'00004C010200000000000000000000000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "1.00",             ""},                    "'MZ'52C3'(C)BeRo!PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KKRUNCHY,                     "0.23",             "farbraush"},           "'MZfarbrauschPE'"},
    {{1, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KKRUNCHY,                     "",                 "conspiracy"},          "'MZconspiracyPE'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_QUICKPACKNT,                  "0.1",              ""},                    "'MZ'90EB010052E9........'PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_GENERIC,                      "",                 ""},                    "'MZ'....................'PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_YZPACK,                       "1.1",              ""},                    "'MZ'40000100000002000400FFFF0200400000000E0000001C00000000000000'(c) UsAr 2oo6$'0EB409BA00001FCD21B8014CCD2140000000'PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_YZPACK,                       "1.2",              ""},                    "'MZ'52456083EC188BEC8BFC33C0648B4030780C8B400C8B701CAD8B4008EB098B403483C07C8B403CABE9........B409BA00001FCD21B8014CCD2140000000'PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_YZPACK,                       "2.0",              ""},                    "'MZKERNEL32'0000'PE'0000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_WATCOMLINKER,                 "",                 "WinNT/dll"},           "'MZ'80000100000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000800000000E1FBA0E00B409CD21B8014CCD21'this is a Windows NT dynamic link library\r\n'24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_WATCOMLINKER,                 "",                 "WinNT/RTL/dll"},       "'MZ'80000100000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000900000000E1FBA0E00B409CD21B8014CCD21'this is a Windows NT (own RTL) dynamic link library\r\n'24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_WATCOMLINKER,                 "",                 "WinNT/RTLexe"},        "'MZ'80000100000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000900000000E1FBA0E00B409CD21B8014CCD21'this is a Windows NT character-mode (own RTL) executable\r\n'24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_WATCOMLINKER,                 "",                 "WinNT/exe"},           "'MZ'80000100000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000800000000E1FBA0E00B409CD21B8014CCD21..'his is a Windows NT character-mode executable\r\n'24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_WATCOMLINKER,                 "",                 "Win95/exe"},           "'MZ'80000100000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000700000000E1FBA0E00B409CD21B8014CCD21'This is a Windows 95 executable\r\n'24"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_STUB,             SpecAbstract::RECORD_NAME_VALVE,                        "",                 ""},                    "'MZ'............................................................................................................................'VLV'"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_UNILINK,                      "",                 ""},                    "'MZ'....................................................'UniLink!'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_CRINKLER,                     "",                 ""},                    "'MZ'B80000420031DB43EB58'PE'0000"},
};

SpecAbstract::SIGNATURE_RECORD _PE_entrypoint_records[]=
{
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.59",             "exe"},                 "60E8000000005883E83D50"}, // mb TODO
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.60-0.69",        "exe"},                 "60E8........68........8BE88DBD........33DB033C248BF7"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.71-0.72",        "exe"},                 "60E80000000083CDFF31DB5E"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.71-0.72",        "dll"},                 "807C2408010F85........60E80000000083CDFF31DB5E"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.81-3.81+",       "exe"},                 "60BE........8DBE"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.81-3.81+",       "dll"},                 "807C2408010F85........60BE........8DBE"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "3.81+",            "exe"},                 "53565755488D35........488DBE"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "3.81+",            "dll"},                 "48894C240848895424104C8944241880FA010F85........53565755488D35........488DBE"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WWPACK32,                     "1.01-1.12",        ""},                    "53558BE833DBEB60'\r\n\r\nWWPack32 decompression routine version '........'\r\n(c) 1998 Piotr Warezak and Rafal Wierzbicki\r\n\r\n'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_BORLANDCPP,                   "",                 ""},                    "EB10'fb:C++HOOK'90"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ANDPAKK2,                     "0.06",             ""},                    "60FCBE........BF........5783CDFF33C9F9EB05A402DB7505"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ANDPAKK2,                     "0.18",             ""},                    "FCBE........BF........5783CDFF33C9F9EB05A402DB7505"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASDPACK,                      "2.0",              ""},                    "8B442404565753E8CD010000C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_REVPROT,                      "0.1a",             ""},                    "E8........8B4C240CC701........C781................31C089411489411880A1..........C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_32LITE,                       "0.03a",            ""},                    "6006FC1E07BE........6A0468........68"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ACPROTECT,                    "2.0.X",            ""},                    "68........68........C3C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALEXPROTECTOR,                "1.0",              ""},                    "60E8000000005D81ED........E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALLOY,                        "4.X",              ""},                    "9C60E8........33C08BC483C0..938BE3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_GCC,                          "3.X-4.X",          "MinGW"},               "5589E583EC08C70424..000000FF15........E8....FFFF................55"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "0.X-1.X",          ""},                    "EB0668........C39C60"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NSPACK,                       "2.9-3.7",          ""},                    "9C60E8000000005D"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NSPACK,                       "2.9-3.7",          ""},                    "4881ECC00000004883C4404889042448894C2408488954241048895C241848896C2420488974242848897C24304C894424384C894C24404C895424484C895C24504C896424584C896C24604C897424684C897C24704883EC40E8000000005D"}, // TODO version
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENIGMA,                       "1.2",              ""},                    "60E8000000005D83....81ED"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_WATCOMCCPP,                   "1994",             ""},                    "..................'WATCOM C/C++32 Run-Time system. (c) Copyright by WATCOM International Corp. 1988-1994. '"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_WATCOMCCPP,                   "1995",             ""},                    "..................'WATCOM C/C++32 Run-Time system. (c) Copyright by WATCOM International Corp. 1988-1995. '"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_WATCOMCCPP,                   "2000",             ""},                    "..................'WATCOM C/C++32 Run-Time system. (c) Copyright by Sybase, Inc. 1988-2000. All rights reserved'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_WATCOMCCPP,                   "2002",             ""},                    "..................'Open Watcom C/C++32 Run-Time system. Portions Copyright (C) Sybase, Inc. 1988-2002'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_WATCOMCCPP,                   "2002",             ""},                    "..................'Open Watcom C/C++32 Run-Time system. Portions Copyright (c) Sybase, Inc. 1988-2002'"}, // Check
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ORIEN,                        "",                 ""},                    "E95D010000CED1CE..'\r\n--------------------------------------------\r\n- ORiEN executable files protection system'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_VPACKER,                      "0.02.10",          ""},                    "60E8........C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ASPROTECT,                    "1.23-2.77",        ""},                    "6801......E801000000C3C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ASPROTECT,                    "1.1 BRS",          ""},                    "60E9..05"}, // TODO check
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ASPROTECT,                    "1.2",              ""},                    "6801......C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ASPROTECT,                    "1.0",              ""},                    "60E801000000905D81ED........BB........03DD2B9D"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EPEXEPACK,                    "1.0-1.2",          ""},                    "6068........B8........FF1068........50B8........FF10"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EPEXEPACK,                    "1.4",              ""},                    "33C08BC068........68........E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EPEXEPACK,                    "1.4",              ""},                    "EB01909068........68........E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PESPIN,                       "",                 ""},                    "EB016860E8000000008B1C2483C312812BE8B10600FE4BFD822C24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "",                 "Alt stub"},            "60E809000000..................33C95E870E"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "",                 ""},                    "BE........AD50FF7634EB7C4801"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_AHPACKER,                     "0.1",              ""},                    "6068........B8........FF10"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "1.00",             "LZBRR"},               "60BE........BF........FCB28033DBA4B302E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "1.00",             "LZBRS"},               "60BE........BF........FCAD8D1C07B0803BFB733BE8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "1.00",             "LZMA"},                "6068........68........68........E8........BE........B9"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "1.00",             "LZBRR/dll"},           "837C2408010F85........60BE........BF........FCB28033DBA4B302E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "1.00",             "LZBRS/dll"},           "837C2408010F85........60BE........BF........FCAD8D1C07B0803BFB733BE8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "1.00",             "LZMA/dll"},            "837C2408010F85........6068........68........68........E8........BE........B9"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NPACK,                        "",                 ""},                    "833D........007505E9........C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FISHPEPACKER,                 "1.02",             ""},                    "60E8........6168........C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FISHPEPACKER,                 "1.03",             ""},                    "60E8........EB"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FISHPEPACKER,                 "1.04",             ""},                    "60B8........FFD0"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KKRUNCHY,                     "0.23 alpha 1",     ""},                    "BD........C74500........FF4D08C6450C05"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KKRUNCHY,                     "0.23 alpha 2",     ""},                    "BD........C74500........B8........89450489455450C74510"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KKRUNCHY,                     "0.23 alpha 3-4",   ""},                    "BD........C74500........B8........89450489455850C74510"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PACKMAN,                      "0.0.0.1",          ""},                    "60E800000000588D..........8D..........8D"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PACKMAN,                      "1.0",              ""},                    "60E8000000005B8D5BC6011B8B138D73146A08590116AD4975FA"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PETITE,                       "2.4",              ""},                    "B8........60"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PETITE,                       "2.2-2.3",          ""},                    "B8........6A0068........64FF350000000064892500000000669C60"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PETITE,                       "2.2-2.3",          ""},                    "B8........68........64FF35........648925........669C60"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PETITE,                       "1.3-1.4",          ""},                    "B8........669C60"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PETITE,                       "1.2",              ""},                    "669C60"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PEPACK,                       "0.99",             ""},                    "60E8000000005D83ED..80BD..........0F84........C685..........8BC52B..........89..........89"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PEPACK,                       "1.0",              ""},                    "7400e9"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_XCOMP,                        "0.97-0.98",        ""},                    "68........9C60E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_XPACK,                        "0.97-0.98",        ""},                    "68........9C60E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ABCCRYPTOR,                   "1.0",              ""},                    "68FF6424F0685858585890FFD4"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EXE32PACK,                    "1.4X",             ""},                    "3BC07402"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_GENERIC,                      "",                 ""},                    "60"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SOFTWARECOMPRESS,             "1.2",              ""},                    "E9........608B7424248B7C2428FC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SOFTWARECOMPRESS,             "1.4 LITE",         ""},                    "E800000000812C24........5DE800000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SDPROTECTORPRO,               "1.1X",             ""},                    "558BEC6AFF68........688888880864A1"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_SIMPLEPACK,                   "1.0",              ""},                    "60E8000000005B8D5BFA"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NAKEDPACKER,                  "1.0",              ""},                    "60FC0FB605........85C075"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KAOSPEDLLEXECUTABLEUNDETECTER,"",                 ""},                    "60FC0FB605........85C075"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KAOSPEDLLEXECUTABLEUNDETECTER,"",                 "Modified"},            "FC0FB605........85C075"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "",                 ""},                    "60E8000000008B2C2483C404"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "",                 "dll"},                 "807C2408010F85........60E8000000008B2C2483C404"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "1.20.1",           ""},                    "57C7C7........8D3D"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "1.0 beta",         ""},                    "60E8000000008D6424048B6C24FC8DB5........8D9D........33FF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLP,                          "0.7.4b",           ""},                    "68........E8........C3C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EZIP,                         "1.0",              ""},                    "E9........E9........E9........E9........E9........E9........E9........E9........E9........E9........E9........CC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_PUREBASIC,                    "4.X",              ""},                    "68....0000680000000068......00E8......0083C40C6800000000E8......00A3"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_PUREBASIC,                    "4.X",              ""},                    "4883EC..49C7C0........4831D248B9................E8........4831C9E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_LCCWIN,                       "1.X-3.X",          ""},                    "64A1........5589E56A..68........68........506489..........83EC..53565789"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.90",             ""},                    "....E802000000E800E8000000005E2B"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.92a",            ""},                    "E97EE9FFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.95",             ""},                    "E9D5E4FFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.96",             ""},                    "E959E4FFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.98b1",           ""},                    "E925E4FFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.98b2",           ""},                    "E91BE4FFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.98",             "Special Build"},       "E999D7FFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.99",             ""},                    "E95EDFFFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.99c",            ""},                    "E93FDFFFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "1.00",             ""},                    "E9E5E2FFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KBYS,                         "0.28 Beta",        ""},                    "60E8000000005E83EE0A8B0603C28B08894EF383EE0F56528BF0ADAD03C28BD86A04BF00100000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KBYS,                         "0.28",             ""},                    "68........E801000000C3C3608B7424248B7C2428FCB28033DBA4"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KBYS,                         "0.28",             ""},                    "B8........BA........03C2FFE0........60E800000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KBYS,                         "0.28 Beta",        ""},                    "68........90B8........C3608B7424..8B7C24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SAFEENGINESHIELDEN,           "",                 ""},                    "E8........53"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTOCRACKPEPROTECTOR,       "0.9.2",            ""},                    "E801000000E8585B81E300FFFFFF66813B4D5A753784DB75338BF303....813E504500007526"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTOCRACKPEPROTECTOR,       "0.9.3",            ""},                    "5B81E300FFFFFF66813B4D5A75338BF303733C813E5045000075260FB746188BC869C0AD0B0000F7E02DAB5D414B69C9DEC0000003C1"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRUNCH,                       "1.0",              ""},                    "55E8000000005D83ED068BC55560"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MOLEBOXULTRA,                 "4.X",              ""},                    "5589E5E8........5DC3CC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "1.XX",             ""},                    "90589050908B00903C5090580F8567D6EF115068"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "1.1",              ""},                    "8B042483E84F68........FFD0"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "1.3-1.4",          ""},                    "558BEC8B44240483E84F68........FFD0585950"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "1.3b",             ""},                    "6183EF4F6068........FFD7"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "1.5",              ""},                    "832C244F68........FF542404834424044F"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "1.6",              ""},                    "33D068........FFD2"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "1.6b-1.6c",        ""},                    "8BC70304242BC78038500F851B8B1FFF68"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "1.6d",             ""},                    "60906161807FF04590600F851B8B1FFF68"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "2.0",              ""},                    "F7D183F1FF6A00F7D183F1FF810424........F7D183F1FF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KRYPTON,                      "0.2",              ""},                    "8B0C24E90A7C01..AD4240BDBE9D7A04"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KRYPTON,                      "0.3",              ""},                    "8B0C24E9C08D01..C13A6ECA5D7E796DB3645A71EA"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KRYPTON,                      "0.4",              ""},                    "54E8000000005D8BC581ED........2B85........83E806"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KRYPTON,                      "0.5",              ""},                    "54E8000000005D8BC581ED........2B85........EB"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SVKPROTECTOR,                 "1.3X-1.4X",        ""},                    "60E8000000005D81ED06000000EB05B8........64A023"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THEBESTCRYPTORBYFSK,          "1.0",              ""},                    "EB06'VRULZ'00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASCRYPTER,                 "1.X",              ""},                    "60E8000000005D81ED........B9"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASCRYPTER,                 "1.3",              ""},                    "558BEC53565760E8000000005D81ED........B9"}, // 1.3??? TODO Check
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_TPPPACK,                      "",                 ""},                    "E8000000005D81ED"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FISHPESHIELD,                 "1.12-1.16",        ""},                    "60E8........FFD0C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.2",              ""},                    "558BEC81EC....0000535657EB0C'ExPr-v.1.2.'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.3",              ""},                    "558BEC83EC..535657EB0C'ExPr-v.1.3.'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.4.5.X",          ""},                    "558BEC83EC..5356578365..00F3EB0C'eXPr-v.1.4.'00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.5.0.X",          ""},                    "558BEC81EC........53565783A5..........F3EB0C'eXPr-v.1.5.'00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.6",              ""},                    "558BEC81EC........53565783A5..........F3EB0C'eXPr-v.1.6.'00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BAMBAM,                       "0.1-0.4",          ""},                    "6A14E89A050000....5368........E86CFDFFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTFIXNICEPROTECT,            "2.1-2.5",          ""},                    "E9FF000000608B7424248B7C2428FCB28033DBA4B302E86D00000073F633C9E864000000731C33C0E85B0000007323B30241B010E84F00000012C073F7753FAAEBD4E84D0000002BCB7510E842000000EB28ACD1E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_JDPACK,                       "1.01",             ""},                    "60E8000000005D8BD581ED........2B95........81EA06......8995........83BD"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_JDPACK,                       "2.00",             ""},                    "558BEC6AFF68........68........64A1000000005064892500000000......E801000000"},
//    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VCASMPROTECTOR,               "1.0",              ""},                    "558BEC6AFF68........68........64A1000000005064892500000000E803000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VCASMPROTECTOR,               "1.X",              ""},                    "EB..'[VProtect]'00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ADVANCEDUPXSCRAMMBLER,        "0.5",              ""},                    "B8........B9........803408..E2FAEB"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_AZPROTECT,                    "0001",             ""},                    "EB70FC608C804D110070258100400D91BB608C804D11007021811D610D810040CE608C804D11007025812581258125812961418131611D610040B730"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_WINKRIPT,                     "1.0",              ""},                    "33C08BB8........8B90........85FF74..33C950EB..8A0439C0C8..34..880439413BCA72..58"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FSG,                          "1.0",              ""},                    "BB........BF........BE........53E80A00000002D275058A164612D2"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FSG,                          "1.31",             ""},                    "BE........BF........BB........53BB........B280"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FSG,                          "1.31",             ""},                    "BB........BF........BE........53BB........B280A4B680FFD373F9"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FSG,                          "1.33",             ""},                    "BE........AD93AD97AD5696B280A4B680FF1373"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FSG,                          "2.0",              ""},                    "8725......00619455A4B680FF13"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEBUNDLE,                     "",                 ""},                    "9C60E802......33C08BC483C004938BE38B5BFC81EB........87DD"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_BLADEJOINER,                  "1.5",              ""},                    "558BEC81C4E4FEFFFF53565733C08945F08985"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_NJOINER,                      "0.1",              ""},                    "6A0068........68........6A00E8140000006A00E813000000CCFF25........FF25........FF25........FF25"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_CELESTYFILEBINDER,            "1.0",              "C++ Dynamic library"}, "E896040000E963FDFFFF8BFF558BEC81EC28030000A3E8514000890DE45140008915E0514000891DDC5140008935D8514000893DD4514000668C1500"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_CELESTYFILEBINDER,            "1.0",              "C++ Static library"},  "E8261F0000E989FEFFFF8BFF558BEC83EC208B450856576A0859BE0C9240008D7DE0F3A58945F88B450C5F8945FC5E85C074"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_POLYCRYPTPE,                  "",                 ""},                    "60E8........EB"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PUNISHER,                     "1.5 demo",         ""},                    "EB0483A4BCCE60EB0480BC0411E800000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECURESHADE,                  "1.8",              ""},                    "558BEC81EC........535657BE........8D7D..8D45..A5A5A5A56A..50A4E8........8B1D........595968........FFD3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "3.2",              ""},                    "833D..........558BEC565775..68........E8........83....8B....A3........85F674..68"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "3.5",              ""},                    "833D..........558BEC565775..68........E8........83....8B....A3........85F674..83"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_YZPACK,                       "1.0-1.1",          ""},                    "6033C08D480750E2FD8BEC648B4030780C8B400C"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HIDEANDPROTECT,               "1.016",            ""},                    "909090E9D8..050095..5300954A5000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPACK,                        "0.0.3",            ""},                    "558BEC83....33C08945F0B8........E867C4FFFF33C05568........64FF306489208D55F033C0E893C8FFFF"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENCRYPTPE,                    "1.XX-2.XX",        ""},                    "609C64FF3500000000E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_EXEJOINER,                    "1.0",              ""},                    "68........6804010000E83903000005........C6005C680401000068"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASPROTECTOR,               "1.0b",             ""},                    "558BEC53565760E8000000005D81ED4C324000E803000000EB01"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASPROTECTOR,               "1.02-1.03",        ""},                    "E803000000EB01"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_AVERCRYPTOR,                  "1.XX",             ""},                    "60E8000000005D81ED........8BBD........8B8D........B8"}, // TODO version 1.00 1.02
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_VISUALCCPP,                   "3.0-3.10",         ""},                    "535657BB........8B7C....553BFB75..011D"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ACPROTECT,                    "1.09g",            ""},                    "60F950E801000000..58584950E801000000..5858790466B9B872E801000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ACPROTECT,                    "1.41",             ""},                    "E801000000..83"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ACPROTECT,                    "1.3X",             ""},                    "6050E801000000..83"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ACPROTECT,                    "1.4X",             ""},                    "60E801000000..83042406C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ACPROTECT,                    "1.90g",            ""},                    "600F87020000001BF8E801000000..83042406C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ACPROTECT,                    "2.0.X",            ""},                    "68........68........C3C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "1.00b-1.07b",      ""},                    "60E8000000005D81ED........B8........03C5"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "1.08.01-1.08.02",  ""},                    "60EB..5DEB..FF..........E9"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "1.08.03",          ""},                    "60E8000000005D............BB........03DD"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "1.08.04",          ""},                    "60E841060000EB41"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "1.08.X",           ""},                    "60E8000000005D81ED........BB........01EB"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "1.08.X",           ""},                    "60EB..5DFFE5E8........81ED........BB........03DD2B9D"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.000",            ""},                    "60E870050000EB4C"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.001",            ""},                    "60E872050000EB4C"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.1",              ""},                    "60E872050000EB3387DB9000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.11",             ""},                    "60E93D040000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.11b",            ""},                    "60E802000000EB095D5581ED39394400C3E93D040000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.11c-2.11d",      ""},                    "60E802000000EB095D5581ED39394400C3E959040000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.11d",            ""},                    "60E802000000EB095D55"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.12-2.42",        ""},                    "60E803000000E9EB045D4555C3E801"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_YZPACK,                       "1.2",              ""},                    "4D5A52456083EC188BEC8BFC33C0648B4030780C8B400C8B701CAD8B4008EB098B403483C07C8B403CABE9"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_CRINKLER,                     "0.3-0.4",          ""},                    "B8........31DB43EB58"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTER,                      "3.1",              ""},                    "68FF6424F06858585858FFD4508B40F205B095F6950F850181BBFF68"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THINSTALL,                    "2.5XX",            ""},                    "558BECB8........BB........50E800000000582D..1A0000B9..1A0000BA..1B0000BE00100000BF..530000BD..1A000003E8817500..........7504........817508........81750C........817510"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KCRYPTOR,                     "0.11",             ""},                    "558BEC83EC..53565733DB53FF15........8B3D........8945..B8........FF30BE........56E8........68........6A..E8........83C4..6A..68........5753FFD0"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DALKRYPT,                     "1.0",              ""},                    "68........5868........5F33DBEB0D8A140380EA0780F2048814034381FB........72EBFFE7"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEARMOR,                      "0.7X",             ""},                    "60E8000000005D81ED........8DB5........555681C5........55C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_CEXE,                         "1.0a",             ""},                    "558BEC81EC0C02....56BE........8D85F8FEFFFF56506A..FF15........8A8DF8FEFFFF33D284C98D85F8FEFFFF7416"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NCODE,                        "0.2",              ""},                    "9066BE....6683FE..74..66B8....66BE....6683FE..74..6683E8..66BB....6683C3..66436681FB....74..6683F8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SCOBFUSCATOR,                 "",                 ""},                    "6033C98B1D........031D........8A041984C074..3C..74..34..880419413B0D........75..A1........0105........61FF25"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCSHRINK,                     "0.71",             ""},                    "9C60BD........01AD........FF..........6A..FF..........50502D........89..........5F8D"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEDIMINISHER,                 "0.1",              ""},                    "535152565755E8000000005D8BD581ED........2B95........81EA0B0000008995........80BD"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTBJFNT,                     "1.1b",             ""},                    "EB01EA9CEB01EA53EB01EA51EB01EA52EB01EA56"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTBJFNT,                     "1.2 RC",           ""},                    "EB0269B183EC04EB03CD20EBEB01EB9CEB01EBEB"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTBJFNT,                     "1.3",              ""},                    "EB033A4D3A1EEB02CD209CEB02CD20EB02CD2060"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW11SE,                      "1.0",              ""},                    "E9........000000020000000C"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW11SE,                      "1.1-1.2",          ""},                    "E9......FF0C"}, // TODO Check
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DRAGONARMOR,                  "0.0.4.1",          ""},                    "BF........83C9FF33C068........F2AEF7D1495168........E8110A000083C40C68"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NOODLECRYPT,                  "2.0",              ""},                    "EB019AE8..000000EB019AE8....0000EB019AE8....0000EB01"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PENGUINCRYPT,                 "1.0",              ""},                    "B8........55506764FF360000676489260000BD4B484342B804000000CC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXECRYPT,                     "1.0",              ""},                    "909060E8000000005D81ED........B91500000083C10483C101EB05EBFE83C756EB00EB00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXEPASSWORDPROTECTOR,         "1.1",              ""},                    "6A606810B54000E82E020000BF940000008BC7E822F4FFFF8965E88BF4893E56FF1510B040008B4E10890D00ED40008B4604"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_GIXPROTECTOR,                 "1.2",              ""},                    "60EB05E8EB044000EBFAE80A000000"}, // CHECK MSLRH
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THEMIDAWINLICENSE,            "2.0.1.0-2.1.8.0",  ""},                    "83EC045053E801000000CC588BD840"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LAMECRYPT,                    "1.0",              ""},                    "60669CBB........80B3........904B83FBFF75F3669D61"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "1.1",              ""},                    "60E8000000005D81ED........B97B0900008BF7AC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.5",              ""},                    "6090EB22'ExeStealth'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.70-2.71",        ""},                    "EB0060EB00E8000000005D81ED"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.72-2.73",        "Shareware"},           "EB00EB2F'Shareware - ExeStealth'00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.74",             "Shareware"},           "EB00EB17'Shareware - ExeStealth'00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.75",             ""},                    "906090E8000000005D81ED........B915000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.75a",            "Shareware"},           "EB58'Shareware-Version ExeStealth'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.76",             ""},                    "EB65'ExeStealth V2 - www'"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.76",             "Shareware"},           "EB..'ExeStealth V2 Shareware '"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXECRYPTOR,                   "2.1.X",            ""},                    "E9........669C60508D88........8D90........8BDC8BE1"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_RUST,                         "",                 "i686-pc-windows-msvc"},    "E8........E9........CCCCCCCCCC"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_RUST,                         "",                 "x86_64-pc-windows-msvc"},  "4883EC28E8........4883C428E9........CCCCCCCC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ELECKEY,                      "2.00.X",           ""},                    "515257535556E8000000005BB8........2BD8"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ELECKEY,                      "2.00.X",           ""},                    "41504151515257535556E8000000005B48B8................482BD8488BEB"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_TINYC,                        "",                 ""},                    "5589e581ec........908d45..50e8........83c4..b8........8945..b8........50e8........83c4"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_TINYC,                        "",                 ""},                    "554889e54881ec........b8........8945..b8........4989c24c89d1e8"},

    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "ASPacker 2.12"},       "60E803000000E9EB045D4555C3E801"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "BJFNT 1.3"},           "EB033A4D3A1EEB02CD209CEB02CD20EB02CD2060"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "EXE Shield 0.3"},      "E8040000008360EB0C5DEB05"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "ExeCryptor 1.5.1"},    "E8240000008B4C240CC70117000100C781B80000000000000031C089411489411880A1C1000000FEC3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "PC-Guard 4.xx"},       "FC5550E8000000005DEB01E360E803000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "PEBundle 2.x"},        "9C60E802......33C08BC483C004938BE38B5BFC81EB........87DD"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "PEX 0.99"},            "60E8........E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "SVKP_1.x"},            "60E8........5D81ED06......64A023"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "Yoda's Crypter1.2"},   "60E8000000005D81ED........B9....00008DBD........8BF7"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "UPX 0.8x-1.2"},        "60BE........8DBE........5783"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "PECompact 1.4x"},      "EB06..........C39C60E80200000033C08BC483C004"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "PE-Lock Phantasm 1.0"},"5557565251536681C3EB02EBFC6681C3EB02EBFC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "Obsidium 1.3.0.4"},    "EB02....E825000000EB04........EB01..8B54240CEB01"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "Themida 1.8.0.0"},     "B8........600BC074..E8000000005805..0000008038E975"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FAKESIGNATURE,                "",                 "Visual Basic 5.0-6.0"},"6800000000E8........C0EB0F000000300000004000000000000000485858E9"},
};

SpecAbstract::SIGNATURE_RECORD _PE_entrypointExp_records[]=
{
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PEX,                          "0.99",             ""},                    "E9$$$$$$$$60E8$$$$$$$$83C404E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE32,                     "1.1",              ""},                    "68........68........68........E8$$$$$$$$558BECA1"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW10,                        "1.0",              ""},                    "33C0E9$$$$$$$$BE........AC91AD95AD92AD515687F297FCB2..33DBA4B3..FF55"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_VISUALCCPP,                   "",                 ""},                    "E8......00E9$$$$$$$$6A..68........E8"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_VISUALCCPP,                   "",                 ""},                    "4883EC28E8........4883C428E9$$$$$$$$48895C24"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_VISUALCCPP,                   "",                 ""},                    "4883EC28E8........4883C428E9$$$$$$$$488BC44889580848897010488978184C896020"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_XPACK,                        "0.97-0.98",        ""},                    "68........9C60E8$$$$$$$$E8$$$$$$$$5B5D833B00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_XCOMP,                        "0.97-0.98",        ""},                    "68........9C60E8$$$$$$$$E8$$$$$$$$5B5D833B00"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.6.1",            ""},                    "68########EB$$EB$$558BEC83EC..535657EB$$833D..........74"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.12b",            ""},                    "60E8$$$$$$$$5D4555C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.1x-2.39",        ""},                    "60E8$$$$$$$$8B2C2481ED........C3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEQUAKE,                      "0.06",             ""},                    "E8$$$$$$$$5D81ED........8D75..56FF55..8DB5........5650FF55..8985........6A..68"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MORPHNAH,                     "1.0.2",            ""},                    "60E8$$$$$$$$5D81ED........8BBD........8B8D........B8........01E88030..83F9..74..817F..........75..8B57"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MORPHNAH,                     "1.0.3",            ""},                    "60E8$$$$$$$$5D81ED........31C04083F0..403D........75..BE........EB..EB..8B85........83F8..75..31C001EE3D"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MORPHNAH,                     "1.0.7",            ""},                    "558BEC87E55DE9$$$$$$$$558BEC83EC..5356576064A1........8B40..8945..64A1........C740"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCGUARD,                      "5.04-5.05",        ""},                    "FC5550E8000000005D60E8$$$$$$$$EB$$58EB$$40EB$$FFE0"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SOFTDEFENDER,                 "1.X",              ""},                    "74$$74$$78$$68A2AF470159E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PECRYPT32,                    "1.02",             ""},                    "E8000000005B83EB..EB$$85C073..F705................58EB$$56575550E8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CODEVEIL,                     "1.2",              ""},                    "E9$$$$$$$$E9$$$$$$$$8BFF60E8$$$$$$$$5EE8"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXECRYPTOR,                   "1.5X",             ""},                    "E8$$$$$$$$31C064FF30648920CCC3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXECRYPTOR,                   "2.2.4",            ""},                    "E8$$$$$$$$E800000000............8B1C2481EB........B8........506A..68"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MOLEBOX,                      "2.3.3-2.6.4",      ""},                    "E80000000060E8$$$$$$$$E8$$$$$$$$E8$$$$$$$$558BEC83EC..56576A..FF15........8945..68........6A..FF15"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MOLEBOX,                      "2.3.3-2.6.4",      ""},                    "E80000000060E8$$$$$$$$E8$$$$$$$$8B4424..508B4424..50E8$$$$$$$$558BEC83EC..5356576A..FF15"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MOLEBOX,                      "2.0.0-2.3.0",      ""},                    "60E8$$$$$$$$E8$$$$$$$$E8$$$$$$$$558BEC83EC..56576A..FF15........8945..68........6A..FF15"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MOLEBOX,                      "2.36",             ""},                    "EB$$B8........8338..74..50FF70..FF3050830424..E8$$$$$$$$558BECA1........53568B75..85C0578BDE75..6A..68........68........FF15"},
//    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MOLEBOX,                      "4.XX",             ""},                    "6A2868........E8$$$$$$$$68........64A100000000508B442410896C24108D6C24102BE05356578B45F88965E8"}, // TODO Check CAB
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FISHPESHIELD,                 "2.0.1",            ""},                    "60E8$$$$$$$$558BEC81C470FFFFFF535657"},
//    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ZPROTECT,                     "",                 ""},                    "E8$$$$$$$$87..248D..........87..24E9$$$$$$$$60E9$$$$$$$$54E9$$$$$$$$E8$$$$$$$$87..24"},
//    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ZPROTECT,                     "",                 ""},                    "E8$$$$$$$$87..248D..........87..24E9$$$$$$$$60EB$$54E9$$$$$$$$E8$$$$$$$$87..24"},
//    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ZPROTECT,                     "",                 ""},                    "E9$$$$$$$$E8$$$$$$$$87..248D..........87..24E9$$$$$$$$60E9$$$$$$$$54E9$$$$$$$$E8$$$$$$$$87..24"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ZPROTECT,                     "",                 ""},                    "E8$$$$$$$$87..248D..........87..24E9"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ZPROTECT,                     "",                 ""},                    "E9$$$$$$$$E8$$$$$$$$87..248D..........87..24E9"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASCRYPTER,                 "1.01",             ""},                    "558BEC535657E8$$$$$$$$E8$$$$$$$$33C064FF30648920CCC3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_QRYPT0R,                      "1.0",              ""},                    "EB$$E8$$$$$$$$64FF3500000000"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DBPE,                         "2.33",             ""},                    "EB$$9C5557565251539CE8$$$$$$$$5D81ED"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PESHIELD,                     "0.25-0.26",        ""},                    "60E8$$$$$$$$5D83ED..EB$$8D....................8A....32..80....80....88......EB"}, // TODO Check!
    // VMProtect TODO Emul dynamic create signature
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "E9$$$$$$$$E9$$$$$$$$68........0F..$$$$$$$$E9$$$$$$$$68........E9$$$$$$$$E9"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "E9$$$$$$$$E9$$$$$$$$68........E9$$$$$$$$E9$$$$$$$$68........E9$$$$$$$$E9"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "E9$$$$$$$$E9$$$$$$$$68........E9$$$$$$$$E9$$$$$$$$68........E9$$$$$$$$0F"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "0F..$$$$$$$$E9$$$$$$$$68........E9$$$$$$$$68........E9$$$$$$$$E9"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "E9$$$$$$$$68........E9$$$$$$$$9CE9"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "9CE9$$$$$$$$C70424........E9$$$$$$$$E9$$$$$$$$68........9C"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "E9$$$$$$$$9CC70424........60E8$$$$$$$$E8"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "54E8$$$$$$$$60C70424........C7442424........9CC74424..........609C9C9C"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "9C55C74424..........E8$$$$$$$$C70424........9CC74424"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "60C74424..........E9$$$$$$$$E8$$$$$$$$C74424..........FF7424..8D6424..E9"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "53C70424........68........E8$$$$$$$$9C"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                     "",                ""},                    "9CE9$$$$$$$$C70424........68........53C74424..........9CC70424"},
};

SpecAbstract::CONST_RECORD _PE_importhash_records[]=
{
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KCRYPTOR,                     "0.11",             ""},                    0x0b5c121dc,    0x4dbf4081},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KKRUNCHY,                     "",                 ""},                    0x134c8cd1e,    0x29188619},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ANDPAKK2,                     "0.18",             ""},                    0x134c8cd1e,    0x29188619},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "",                 ""},                    0x134c8cd1e,    0x29188619},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FSG,                          "",                 ""},                    0x0ee8cb83a,    0xa4083f58},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DRAGONARMOR,                  "",                 ""},                    0x0ee8cb83a,    0xa4083f58},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_SCPACK,                       "0.2",              ""},                    0x184210a7f,    0x0faef25b},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KBYS,                         "1.XX-2.XX",        ""},                    0x1eb276f62,    0xdb8fbb75},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTOCRACKPEPROTECTOR,       "",                 ""},                    0xf8d21b48,     0x8137a62},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ACPROTECT,                    "1.XX-2.XX",        ""},                    0x26d690da0,    0x2301e49c},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_AHPACKER,                     "0.1",              ""},                    0x263ed9b5a,    0x117f896a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASDPACK,                      "1.00",             ""},                    0x55706e12,     0xc7af1b6},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASDPACK,                      "2.00",             ""},                    0xc3068d5e,     0x3f603725},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FISHPEPACKER,                 "1.02",             ""},                    0x1eb276f62,    0xdb8fbb75},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FISHPEPACKER,                 "1.03",             ""},                    0x13e215a53,    0xdf3c1e0},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW10,                        "1.0",              ""},                    0x13e215a53,    0x381aae8d},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW11SE,                      "",                 ""},                    0x13e215a53,    0xdf3c1e0},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "1.00",             ""},                    0x13e215a53,    0xdf3c1e0},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXECRYPT,                     "1.0",              ""},                    0x13e215a53,    0xdf3c1e0},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "",                 ""},                    0x13e215a53,    0xdf3c1e0},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EXEFOG,                       "1.1",              ""},                    0x13e215a53,    0xdf3c1e0},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EXEFOG,                       "1.2",              ""},                    0x134c8cd1e,    0x29188619},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALEXPROTECTOR,                "1.0",              ""},                    0x1d6f34b26,    0x63fe4ff9},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRUNCH,                       "1.0",              ""},                    0x90c17bc0b,    0x5e67bbdd},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALLOY,                        "4.X",              ""},                    0x6c83794a6,    0xc50dde33},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KRYPTON,                      "",                 ""},                    0x347ecf0ec,    0x4acfe8ec},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DYAMAR,                       "1.3.5",            ""},                    0xb3de9edba,    0x9346ebcd},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PEX,                          "0.99",             ""},                    0x312ac0c03,    0xbc79739a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_REVPROT,                      "0.1a",             ""},                    0x312ac0c03,    0xbc79739a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SVKPROTECTOR,                 "1.3X-1.4X",        ""},                    0x22234c932,    0xc8f3a96f},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_TPPPACK,                      "",                 ""},                    0x3f288856,     0xb8a07cc},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASCRYPTER,                 "1.X",              ""},                    0xa7382d76,     0x1303a51b},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASPROTECTOR,               "1.0b",              ""},                   0xa7382d76,     0x1303a51b},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FISHPESHIELD,                 "1.12-1.16",        ""},                    0xc485c9e2,     0xff2d65f9},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FISHPESHIELD,                 "1.12-1.16",        ""},                    0xc485c9e2,     0x860b9cf0},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.2",              ""},                    0x5b000b292,    0x66b35c6e},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.2",              ""},                    0x6f561d023,    0x32f4466c},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.3",              ""},                    0x5ca1becb0,    0x921d0280},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.3",              ""},                    0x7441e5986,    0xf51eba68},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.3",              ""},                    0x751f43a61,    0xbc84ce09},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.4.5.X",          ""},                    0x50b93d55a,    0x3c705cae},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.4.5.X",          ""},                    0x69e399a9b,    0x4d02e093}, // TODO Check
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.4.5.X",          ""},                    0x605d4706c,    0x958a9ea2}, // VB6
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.5.0.X",          ""},                    0x50b93d55a,    0x7ababb5a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.5.0.X",          ""},                    0x72af15d4f,    0x95ca15e4},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.5.0.X",          ""},                    0x76a19e5a5,    0xbd41da20},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.6",              ""},                    0x5d589502a,    0xca58fa0c},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "1.6.1",            ""},                    0x177c840f4,    0x48ffd359},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BACKDOORPECOMPRESSPROTECTOR,  "1.0",              ""},                    0x3404eaa9b,    0x3789c118},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BACKDOORPECOMPRESSPROTECTOR,  "",                 ""},                    0x231271f8e,    0x986028bf},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BAMBAM,                       "0.1-0.4",          ""},                    0x241c3b6a6,    0x81a3d66b},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTFIXNICEPROTECT,            "",                 ""},                    0x263ed9b5a,    0x117f896a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HMIMYSPROTECTOR,              "0.1",              ""},                    0x1db028dca,    0x50ca53fc},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEPACKSPROTECT,               "2.3",              ""},                    0x1db028dca,    0x50ca53fc},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_JDPACK,                       "1.01",             ""},                    0x240d976a2,    0x10c77c1b},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NAKEDPACKER,                  "1.0",              ""},                    0x241c3b6a6,    0xbf363f04},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KAOSPEDLLEXECUTABLEUNDETECTER,"",                 ""},                    0x241c3b6a6,    0xbf363f04},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VCASMPROTECTOR,               "1.X",              ""},                    0x9c94674d4,    0x6d738d20},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EPEXEPACK,                    "1.0-1.4",          ""},                    0x263ed9b5a,    0x117f896a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_AFFILLIATEEXE,                "1.0",              "TEST"},                0xaad68a6e94,   0xe7046691},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LARP64,                       "1.0.3",            "TEST"},                0x1a89b5f0f,    0xf44517d8},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_VPACKER,                      "0.02.10",          ""},                    0x3404eaa9b,    0x3789c118},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_XCOMP,                        "0.97-0.98",        ""},                    0x2f6afb438,    0xea1e66e4},
    //{{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "2.40-3.XX",        ""},                    0x1eb276f62,    0xdb8fbb75},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THEMIDAWINLICENSE,            "",                 ""},                    0x16a45c345,    0x108edf16},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NPACK,                        "",                 ""},                    0x2d86e7bf1,    0xd0c4c278},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PEPACK,                       "0.99",             ""},                    0x341f3f6e9,    0xeaf00a09},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PEPACK,                       "1.0",              ""},                    0x3be698dd2,    0x41708a45}, // 0.99?
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_SIMPLEPACK,                   "1.0",              ""},                    0x42f4ff4ba,    0x00d0e26d},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_SIMPLEPACK,                   "1.11",             ""},                    0x385a630a6,    0xc1e807a4},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_SIMPLEPACK,                   "1.2-1.3",          ""},                    0x473022e77,    0xa9e261a2},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_XPACK,                        "0.97-0.98",        ""},                    0x22224caef,    0x2ac44dd2},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ORIEN,                        "",                 ""},                    0x16fde75ea,    0xb4923b63},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SDPROTECTORPRO,               "",                 ""},                    0x193d36193,    0xcde019bc},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SOFTDEFENDER,                 "",                 ""},                    0x193d36193,    0xcde019bc}, // RECORD_NAME_SOFTDEFENDER??RECORD_NAME_SDPROTECTORPRO
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_HMIMYSPACKER,                 "",                 ""},                    0x27a6db491,    0xcee2ac8e},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SOFTWARECOMPRESS,             "1.2-1.4",          ""},                    0x2b72496f4,    0x6bfc6671},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_32LITE,                       "0.03a",            ""},                    0x20953b667,    0xf053f402},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "1.16",             ""},                    0x286d926ce,    0x4f2ced58},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "1.17",             ""},                    0x1eb276f62,    0xdb8fbb75},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "1.19-1.21",        ""},                    0x231271f8e,    0x986028bf},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "1.20.1",           ""},                    0x286d926ce,    0x69e04866},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_YZPACK,                       "1.1",              ""},                    0xb5ec8ac1,     0x54f51579},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_YZPACK,                       "1.2",              ""},                    0x4eb19904,     0x48ea1201},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_YZPACK,                       "2.0",              ""},                    0xc6f6fec9,     0x23333b97},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_QUICKPACKNT,                  "0.1",              ""},                    0x22224caef,    0x3778aab9},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLP,                          "0.7.4b",           ""},                    0x193d36193,    0x30c63d98},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "0.90-0.91",        ""},                    0x186ad3682,    0xbea416d1},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "0.92-0.94",        ""},                    0x1917b3afe,    0x93312c2e},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "0.97-0.971b",      ""},                    0x13e443f64,    0xe6aa8495},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "0.975-1.10b3",     ""},                    0x134c8cd1e,    0x29188619},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "1.10b7-1.34",      ""},                    0x212cf28ad,    0xe4c11305},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEBUNDLE,                     "",                 ""},                    0x778a92ee8,    0x6f2c367e},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_BLADEJOINER,                  "1.5",              ""},                    0x1a905fabfb,   0x05877992},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_CELESTYFILEBINDER,            "1.0",              "C++ Dynamic library"}, 0x2625a9db1f,   0x7c76448a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_CELESTYFILEBINDER,            "1.0",              "C++ Static library"},  0x245138f5a4,   0x8a50a75e},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PESHIELD,                     "0.25-0.26",        ""},                    0x16410b804,    0xf922f724},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_POLYCRYPTPE,                  "",                 ""},                    0x2870982b,     0x15bfcac8},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PUNISHER,                     "1.5 demo",         ""},                    0x1f9e3b7a1,    0x12e15bcc},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECURESHADE,                  "1.8",              ""},                    0x8c9f7bdc8,    0x21ce458d},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_INQUARTOSOBFUSCATOR,          "",                 ""},                    0x1046a0029,    0xf3f52749},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASPROTECTOR,               "",                 ""},                    0x1046a0029,    0xf3f52749},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NOODLECRYPT,                  "",                 ""},                    0x1046a0029,    0xf3f52749},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_NJOINER,                      "0.1",              ""},                    0x76b28c3da,    0x8c42943c},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HIDEANDPROTECT,               "1.016",            ""},                    0x26ff222837,   0xb136eb55},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPACK,                        "0.0.3",            ""},                    0x1d07e94aa3,   0x5c0a3750},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENCRYPTPE,                    "1.XX-2.XX",        ""},                    0x4d37b2166,    0x556688b8},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENCRYPTPE,                    "2.XX",             ""},                    0x4e0ec6281,    0x87857386},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_EXEJOINER,                    "1.0",              ""},                    0x6704c9452,    0x29aaa397},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_XTREMEPROTECTOR,              "1.06",             "TEST"},                0x12261bcdc,    0xa8689d85},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_CEXE,                         "1.0",              ""},                    0xcda93f5a0,    0x6ad5f3a1},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_CEXE,                         "1.0",              ""},                    0xd97446c35,    0x95065b94},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_CEXE,                         "1.0",              ""},                    0xc45e50e8a,    0x55e66552},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEARMOR,                      "0.7X",             ""},                    0x142446410,    0xb033da06},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MORPHNAH,                     "1.0.7",            ""},                    0x15a6ef8c3,    0x3434f1fd},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCSHRINK,                     "0.71",             ""},                    0x186ad3682,    0xbea416d1},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEDIMINISHER,                 "0.1",              ""},                    0x142446410,    0xbac6c7d8},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_EXCELSIORJET,                 "",                 ""},                    0x9f62dc5b3,    0x1c8c807a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTNETREACTOR,                "4.2",              "Native"},              0x2e307fb348,   0x4fe9aa21},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTNETREACTOR,                "4.2",              "Native"},              0x2e307fb348,   0xd840af73}, // TODO Check Version!
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PECRYPT32,                    "1.02",             ""},                    0x16410b804,    0x9d19c97a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXECRYPTOR,                   "2.1",              ""},                    0x21261d3d4,    0xddadcc96},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXECRYPTOR,                   "2.2-2.4",          ""},                    0x2bf67e8e3,    0xf219fb92},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CODEVEIL,                     "1.2",              ""},                    0x16931477,     0xfcb11e9f},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PENGUINCRYPT,                 "1.0",              ""},                    0x22224caef,    0xb65bfd43},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXEPASSWORDPROTECTOR,         "1.1",              ""},                    0x30309e68ce,   0x56ce963e},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_QRYPT0R,                      "1.0",              ""},                    0x0,            0xffffffff}, // no import
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DBPE,                         "",                 ""},                    0x35cf072d7,    0x28aa164}, // TODO Check Version TODO Check

    // VB cryptors
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARCRYPT,                      "",                 ""},                    0x608b5ca5f,    0x27f8d01f},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_AGAINNATIVITYCRYPTER,         "",                 ""},                    0x21bae50da1,   0xab934456},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_WINGSCRYPT,                   "1.0",              "TEST"},                0x216906261a,   0x86d73370},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTRROADS,                  "1.0",              "TEST"},                0x216906261a,   0x86d73370},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TSTCRYPTER,                   "1.0",              "TEST"},                0x216906261a,   0x86d73370},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TURKOJANCRYPTER,              "1.0",              "TEST"},                0x216906261a,   0x86d73370},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_WHITELLCRYPT,                 "",                 "TEST"},                0x27e360241a,   0x69740a38},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MORTALTEAMCRYPTER2,           "",                 "TEST"},                0x27e360241a,   0x69740a38},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PUSSYCRYPTER,                 "1.0",              "TEST"},                0x27e360241a,   0x69740a38},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ZELDACRYPT,                   "1.0",              ""},                    0x27e360241a,   0xffacb503},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BIOHAZARDCRYPTER,             "",                 "TEST"},                0x341d510008,   0x4c51ceec},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTABLESEDUCATION,          "1.0",              ""},                    0x379caa9586,   0x497a33ab},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTIC,                      "2.1",              ""},                    0x2551095bcf,   0x28ee87cc},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTOZ,                      "3",                "TEST"},                0x32a797d70b,   0x9ce9bc9d},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DIRTYCRYPTOR,                 "",                 "TEST"},                0x2d5043f921,   0x1278f5f4},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KIAMSCRYPTOR,                 "1.4",              "TEST"},                0x2d5043f921,   0x1278f5f4},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FAKUSCRYPTOR,                 "1.4",              "TEST"},                0x1c5896cc05,   0x660aa806},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FASTFILECRYPT,                "1.6",              ""},                    0x54fe70e1c,    0x12125e9a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FILESHIELD,                   "1.0",              "TEST"},                0x369ad56c1b,   0x907d472a},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_GHAZZACRYPTER,                "1.0",              ""},                    0x2de302f688,   0x1d13438c},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_H4CKY0UORGCRYPTER,            "",                 "TEST"},                0x68ec019f4,    0x182303e5},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HACCREWCRYPTER,               "",                 "TEST"},                0x3161aded4d,   0x02d8fada},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HALVCRYPTER,                  "",                 "TEST"},                0x3c92864a7,    0x1921b4b9},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KGBCRYPTER,                   "1.0",              "TEST"},                0x8fdee2084,    0x12e6f129},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KRATOSCRYPTER,                "",                 "TEST"},                0xFFFFFFFFFF,   0xFFFFFFFF}, // TODO
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KUR0KX2TO,                    "",                 "TEST"},                0x36d46acf30,   0xcf3805f3},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LIGHTNINGCRYPTERPRIVATE,      "1.0",              "TEST"},                0x25a8480de5,   0x208c1618},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LIGHTNINGCRYPTERSCANTIME,     "1.0",              ""},                    0x24bfbff151,   0xea84dab2},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LUCYPHER,                     "1.1",              "TEST"},                0x202da672fb,   0x3343405e},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MONEYCRYPTER,                 "1.0",              "TEST"},                0x353acba6b3,   0x53908533},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NOXCRYPT,                     "1.1",              ""},                    0x36d2a71d08,   0x9b536657},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RDGTEJONCRYPTER,              "0.1",              "TEST"},                0xFFFFFFFFFF,   0xFFFFFFFF}, // TODO
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RDGTEJONCRYPTER,              "0.8",              "TEST"},                0x2c078d7e86,   0x3c328f0c},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SMOKESCREENCRYPTER,           "2.0",              "TEST"},                0x87606a2bd,    0xcfe4cd48},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SNOOPCRYPT,                   "1.0",              "TEST"},                0x8bb735ad5,    0x22823ed8},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_STASFODIDOCRYPTOR,            "1.0",              "TEST"},                0x339880106,    0xe8805018},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TURKISHCYBERSIGNATURE,        "1.0",              "TEST"},                0x216ef51472,   0xfaacabe5},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_UNDOCRYPTER,                  "1.0",              "TEST"},                0x37b90cd5a,    0xaab92c4c},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_WLCRYPT,                      "1.0",              ""},                    0xeaeea9a42,    0x0f0642ae},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_WOUTHRSEXECRYPTER,            "1.0",              ""},                    0x1d8a9e5e20,   0xc9e08d88},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ROGUEPACK,                    "1.1",              "TEST"},                0xbb132a76d,    0xe23394a8},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ROGUEPACK,                    "3.3.1",            "TEST"},                0x855d9788c,    0x96ed2351},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "0.5X",             ""},                    0x38eada856,    0x37df662a}, // TODO All versions
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ELECKEY,                      "2.00.X",           ""},                    0x3552ed494,    0xccf98822},
    // Delphi cryptors
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ASSCRYPTER,                   "1.0",              "TEST"},                0x12d94ca858,   0x36fb88c9},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_AASE,                         "1.0",              ""},                    0xc06abc0fa,    0x77035a90},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ANSKYAPOLYMORPHICPACKER,      "1.3",              ""},                    0x120bc5fc6c,   0x50822fc0},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ANSLYMPACKER,                 "",                 "TEST"},                0xaf2e74867b,   0x51a4c42b},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CIGICIGICRYPTER,              "1.0",              ""},                    0x12998dbdd9,   0xf75643a6},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FEARZCRYPTER,                 "1.0",              ""},                    0x18fc31e7a1,   0xba67afd7},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FEARZPACKER,                  "0.3",              ""},                    0xbeb44c9f3,    0xf7a7ee23},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_GKRIPTO,                      "1.0",              "TEST"},                0x105df99f74,   0x2d62ed5d},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HOUNDHACKCRYPTER,             "1.0.4",            "TEST"},                0xc4b2710d8,    0x6c4aee3f},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ICRYPT,                       "1.0",              ""},                    0x151f5b424a,   0xdc6b4478},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_INFCRYPTOR,                   "",                 "TEST"},                0x14921fe579,   0x06dfef0b},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_UNDERGROUNDCRYPTER,           "1.0",              ""},                    0x14921fe579,   0x06dfef0b},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MALPACKER,                    "1.2",              "TEST"},                0xd0983ca0a,    0xb82a3f7c},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MINKE,                        "1.01",             "TEST"},                0x161bc831e3,   0xb1440658},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_OPENSOURCECODECRYPTER,        "1.0",              "TEST"},                0x1e843722ad,   0x6061e509},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MORTALTEAMCRYPTER,            "",                 "TEST"},                0x1e843722ad,   0x6061e509},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MORUKCREWCRYPTERPRIVATE,      "",                 "TEST"},                0x1e843722ad,   0x6061e509},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MRUNDECTETABLE,               "1.0",              "TEST"},                0x149b74637d,   0x2b12c49f},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NIDHOGG,                      "1.0",              "TEST"},                0xda5d3bb1f,    0xa52e27cc},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NME,                          "1.1",              "TEST"},                0x84313106b,    0x8d73a5b4},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_OSCCRYPTER,                   "",                 "TEST"},                0x1e67f9aa68,   0xc45e88cf},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_P0KESCRAMBLER,                "1.2",              "TEST"},                0x14017ccc57,   0x6766361e},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PANDORA,                      "1.0",              "TEST"},                0x1aa111e7ea,   0x5ee89fbb},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PFECX,                        "0.1",              ""},                    0x37c8dbb1e7,   0x161cb3f4},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PICRYPTOR,                    "3.0",              ""},                    0x22d7f64fb1,   0xfcde90f0},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_POKECRYPTER,                  "",                 "TEST"},                0x3abfae0702,   0xb99acbcc},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PUBCRYPTER,                   "",                 "TEST"},                0xFFFFFFFFFF,   0xFFFFFFFF}, // TODO
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SEXECRYPTER,                  "1.1",              "TEST"},                0x144c4ac3f1,   0xb1309fe4},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SIMCRYPTER,                   "",                 "TEST"},                0x10c6960150,   0x3070a531},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SIMPLECRYPTER,                "1.2",              "TEST"},                0x23932eb2ab,   0x01e5337f},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TGRCRYPTER,                   "1.0",              "TEST"},                0x1a0adc8c41,   0xc26df3a5},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THEZONECRYPTER,               "",                 "TEST"},                0x316e900676,   0x67850921},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_UNKOWNCRYPTER,                "1.0",              ""},                    0x19d3b4b92a,   0xeb51c252},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_WINDOFCRYPT,                  "1.0",              ""},                    0x124c114b87,   0xf7c9cbe1},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_WLGROUPCRYPTER,               "",                 ""},                    0x13bf0f6720,   0xb0f58a0d},
//    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DCRYPTPRIVATE,                "0.9b",             "TEST"},                0xde741440ed,   0x16bbbe82},
//    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DALKRYPT,                     "1.0",              "TEST"},                0xde741440ed,   0x16bbbe82},
};
SpecAbstract::CONST_RECORD _PE_importhash_records_armadillo[]=
{
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "1.XX-2.XX",        ""},                    0x2973050b33,   0x1a0c885c},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "1.XX-2.XX",        ""},                    0x2f2f1df1d1,   0x8623cf54},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.XX-3.XX",        ""},                    0x3010e1d59e,   0x834a7ecf}, // Check
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.XX-3.XX",        ""},                    0x48c1ac32d5,   0x3f2559bb}, // MSVCRT.dll
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.50Beta3",        ""},                    0x31f48f8367,   0x59d53246},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.51",             ""},                    0x32bbf3aafe,   0x5a037362}, // 2.51 28Feb2002
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "1.XX-2.XX",        ""},                    0x32c7a9336f,   0x6762fc6d},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.52",             ""},                    0x341358d6d9,   0xb256a26f},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "1.XX-2.XX",        ""},                    0x35e237026a,   0x419bf128},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.52",             ""},                    0x3606885219,   0x1d8a69ae}, // 2.52 05Apr2002 (Build 1164)
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.52",             ""},                    0x3606885219,   0x15114198}, // 2.52 05Apr2002
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "1.74-1.84",        ""},                    0x3635cf517b,   0xe6ce8a9e},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "1.XX",             ""},                    0x3b258f0a90,   0xe4bcc578},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "1.XX",             ""},                    0x3b6c8abc7b,   0x604ac20f},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "1.90",             ""},                    0x3b6e96f260,   0x927ddbdb},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "1.91c",            ""},                    0x3c61329b29,   0x7177627b},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.00",             ""},                    0x3c61329b29,   0x412e26ca},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.53",             ""},                    0x3d32f719da,   0x9de5348d}, // 2.53 15May2002 (Build 1232)
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.XX-3.XX",        ""},                    0x3d983cd830,   0xa61b1778},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.60",             ""},                    0x3fa882c0da,   0xaece7e99}, // 2.60 30Jul2002 (Build 1312)
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.60c",            ""},                    0x404c97c5fa,   0x4470cea0}, // 2.60c 17Aug2002 (Build 1431)
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.XX-3.XX",        ""},                    0x3fb526760f,   0x72359c40},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "2.XX-3.XX",        ""},                    0x3fb526760f,   0xf9f173fb},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.00-3.10",        ""},                    0x40666b9f00,   0x64c37e91},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.05",             ""},                    0x43d1d2c52f,   0xac05a698}, // 3.05 06Jun2003
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.30a",            ""},                    0x43d1d2c52f,   0x82883188},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.40",             ""},                    0x4518d21e36,   0xff5cf01b}, // 3.40 21Oct2003
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.60",             ""},                    0x4518d21e36,   0x228301a9},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.61",             ""},                    0x4518d21e36,   0xb79df9fe},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.70",             ""},                    0x4518d21e36,   0x774538e7},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.75 Beta-1.3",    ""},                    0x4580f4b95c,   0x363baa89},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.75a",            ""},                    0x4610da601a,   0x5a7b25e5},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.76a",            ""},                    0x4b5345e36c,   0x5f6ae2cf},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.76",             ""},                    0x4c0ed4e9ea,   0x251722e7},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.78",             ""},                    0x4c0ed4e9ea,   0xccda289c},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "3.78",             ""},                    0x4bdf485221,   0x21ff4a57}, // 3.78 22Sep2004
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "4.20",             ""},                    0x4fc78bc010,   0x047e53e2}, // 4.20 23May2005
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "4.00-4.40",        ""},                    0x4fc78bc010,   0x807db698},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "4.42-4.54",        ""},                    0x508175d00e,   0xb50f60e8},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "4.48",             ""},                    0x508175d00e,   0xb034772c}, // 4.48 14August2006
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "4.66",             ""},                    0x508175d00e,   0x5ca4890e},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "4.66",             ""},                    0x508175d00e,   0x1a14aa82},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "4.66",             ""},                    0x506972b7dd,   0xd09a4dc7},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "5.02",             ""},                    0x56fa69e1fe,   0xdb61d809},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "5.02",             ""},                    0x56e266c9cd,   0xd756b3c1}, // 5.02 11-07-2007
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "5.20Beta1",        ""},                    0x5670adeaf6,   0x1e178fd2},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "5.20",             ""},                    0x5670adeaf6,   0xc791b70b},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "5.20",             ""},                    0x56698f2e57,   0x56b916d1}, // 5.20 30-10-2007
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "5.40",             ""},                    0x56fa69e1fe,   0x7b44517b},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "5.42",             ""},                    0x56fa69e1fe,   0x503225ce}, // 5.42 20-02-2008
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "6.00Beta1",        ""},                    0x56fa69e1fe,   0xf35bbfc1},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "6.00",             ""},                    0x57770751cb,   0xd8505c97},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "6.04",             ""},                    0x57770751cb,   0x65f6ce6f},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "6.60-7.00",        ""},                    0x5cee9acb73,   0xa6f43b6d},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "6.24",             ""},                    0x600594c96e,   0xad072543}, // 6.24 02-12-2008
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "6.40",             ""},                    0x5f7a50e70b,   0x0ecbdf27},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "6.40",             ""},                    0x5f7a50e70b,   0xae4aa460}, // 6.40 11-02-2009
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "6.60-7.00",        ""},                    0x5d069de3a4,   0x34512142},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "7.20",             ""},                    0x79deb2e3e4,   0x2a3627b7},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ARMADILLO,                    "8.60",             ""},                    0x263ed9b5a,    0x804c7692},
};

SpecAbstract::CONST_RECORD _PE_importpositionhash_records[]=
{
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.59-0.93",        ""},                    0,              0xd4fdcab1}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.94-1.93",        "exe"},                 0,              0x1d51299a}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "1.94-2.03",        "exe"},                 0,              0xb3318086}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "1.94-2.03",        "dll"},                 0,              0x3778aab9},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "2.90-3.XX",        "exe"},                 0,              0xf375ee03}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "2.90-3.XX",        "dll"},                 0,              0xf737d853}, // Fixed
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "3.91+",            "dll"},                 0,              0xf737d853}, // Fixed // TODO Check!
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "3.91+",            "exe"},                 0xFFFFFFFF,     0x82a048fc}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "3.91+",            "dll"},                 0xFFFFFFFF,     0x554a1748}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NSPACK,                       "",                 ""},                    0,              0xf375ee03}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "1.XX-2.XX",        ""},                    0,              0x1272f45b}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ASPROTECT,                    "1.XX-2.XX",        ""},                    0,              0x1272f45b}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MKFPACK,                      "",                 ""},                    0,              0x42b3e7f9}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "",                 ""},                    0,              0x174efb84}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PACKMAN,                      "0.0.0.1",          ""},                    0,              0x174efb84}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PACKMAN,                      "1.0",              ""},                    0,              0x69076a83}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "1.30-1.40",        ""},                    0,              0x9b3305ed}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "1.40-1.84",        ""},                    0,              0xcc5b2a3c}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PECOMPACT,                    "2.40-3.XX",        ""},                    0,              0x2652ce4f}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EXE32PACK,                    "1.3X-1.4X",        ""},                    0,              0x174efb84}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EZIP,                         "1.0",              ""},                    0xFFFFFFFF,     0x051946f7}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_JDPACK,                       "2.00",             ""},                    0,              0xc002db0e}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "3.2",              ""},                    0,              0xb2a64858}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "3.2",              ""},                    0,              0x158af2d0}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "3.2",              ""},                    0,              0x49e8aa1f}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "3.5",              ""},                    0,              0xe9ea0851}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "3.5",              ""},                    0,              0x3344b95d}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "3.5",              ""},                    0,              0x586088f3}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENIGMA,                       "1.00-3.60",        ""},                    0,              0xc002db0e}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENIGMA,                       "2.XX",             ""},                    0,              0xdd92de10}, // TODO Check version
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENIGMA,                       "3.70+",            ""},                    0,              0xd04c7a50}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_CRINKLER,                     "",                 ""},                    0,              0x0b0e1fbf}, // TODO Check!!!
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCGUARD,                      "5.04-5.05",        ""},                    0,              0x5a169c7a}, // TODO Check version
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCGUARD,                      "5.04-5.05",        ""},                    0,              0x0b0b2965}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR_KERNEL32,           "1.4.5.X",          ""},                    0,              0x427816ab}, // Fixed
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR_USER32,             "1.4.5.X",          ""},                    1,              0x0c16df2d}, // Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "1.70",             ""},                    0xFFFFFFFF,     0x1ff3103f}, // 1.70.4 Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "1.70",             "Max protection"},      0xFFFFFFFF,     0x0c16df2d}, // 1.70.4 Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "2.0.3-2.13",       ""},                    0xFFFFFFFF,     0x9d12b153}, // 2.0.3-2.12 Fixed 2.09-2.13 no .vmp2
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "3.0.0",            ""},                    0xFFFFFFFF,     0x1e5500c1}, // 3.0.0 beta Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "3.0.9",            ""},                    0xFFFFFFFF,     0xc5fb6a4b}, // 3.0.9.695 Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "3.2.0-3.5.0",      ""},                    0xFFFFFFFF,     0x5caa99c7}, // 3.2.0.976 Fixed
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "3.8",              ""},                    0xFFFFFFFF,     0x66e03954}, // 3.8.4
};

SpecAbstract::PE_RESOURCES_RECORD _PE_resources_records[]=
{
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_VCL,                          "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       true,   "PACKAGEINFO",      0},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_VCL,                          "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       true,   "DVCLAL",           0},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTNETREACTOR,                "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       true,   "__",               0},    // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_WXWIDGETS,                    "",                 ""},                    false,      "",         XPE_DEF::S_RT_MENU,         true,   "WXWINDOWMENU",     0},    // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_INSTALLER,        SpecAbstract::RECORD_NAME_GENTEEINSTALLER,              "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       true,   "SETUP_TEMP",       0},    // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_SFX,              SpecAbstract::RECORD_NAME_WINRAR,                       "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       true,   "STARTDLG",         0},    // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_SFX,              SpecAbstract::RECORD_NAME_WINRAR,                       "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       true,   "LICENSEDLG",       0},    // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CIGICIGICRYPTER,              "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       true,   "AYARLAR",          0},    // TODO Version // TODO Check
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_INSTALLER,        SpecAbstract::RECORD_NAME_ALCHEMYMINDWORKS,             "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       false,  "",                 4001},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_INSTALLER,        SpecAbstract::RECORD_NAME_ALCHEMYMINDWORKS,             "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       false,  "",                 5001},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_INSTALLER,        SpecAbstract::RECORD_NAME_INNOSETUP,                    "",                 ""},                    false,      "",         XPE_DEF::S_RT_RCDATA,       false,  "",                 11111},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_CELESTYFILEBINDER,            "",                 ""},                    true,       "RBIND",    0,                          false,  "",                 (quint32)-1},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_JOINER,           SpecAbstract::RECORD_NAME_NJOINER,                      "",                 ""},                    true,       "NJ",       0,                          false,  "",                 (quint32)-1},
};

// TODO Resource version

// TODO
SpecAbstract::STRING_RECORD _PE_exportExp_records[]=
{
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_VISUALCCPP,                   "",                 ""},                    "^$"},
};

// TODO import

SpecAbstract::MSRICH_RECORD _MS_rich_records[]=
{
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "",                 ""},                    0x0001,         0},             // Linker generated import object version 0
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "5.10",             ""},                    0x0002,         (quint32)-1},   // LINK 5.10 (Visual Studio 97 SP3)
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "5.10",             ""},                    0x0003,         (quint32)-1},   // LINK 5.10 (Visual Studio 97 SP3) OMF to COFF conversion
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "6.00",             ""},                    0x0004,         (quint32)-1},   // LINK 6.00 (Visual Studio 98)
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "6.00",             ""},                    0x0005,         (quint32)-1},   // LINK 6.00 (Visual Studio 98) OMF to COFF conversion
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "5.00",             ""},                    0x0006,         (quint32)-1},   // CVTRES 5.00
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "11.00",            "Basic"},               0x0007,         (quint32)-1},   // VB 5.0 native code
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "11.00",            "C/C++"},               0x0008,         (quint32)-1},   // VC++ 5.0 C/C++
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.00",            "Basic"},               0x0009,         (quint32)-1},   // VB 6.0 native code
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.00",            "C"},                   0x000a,         (quint32)-1},   // VC++ 6.0 C
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.00",            "C++"},                 0x000b,         (quint32)-1},   // VC++ 6.0 C++
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "6.00",             ""},                    0x000c,         (quint32)-1},   // ALIASOBJ.EXE (CRT Tool that builds OLDNAMES.LIB)
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_VISUALBASIC,                  "6.00",             ""},                    0x000d,         (quint32)-1},   // VB 6.0 generated object
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "6.13",             ""},                    0x000e,         (quint32)-1},   // MASM 6.13
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "7.01",             ""},                    0x000f,         (quint32)-1},   // MASM 7.01
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "5.11",             ""},                    0x0010,         (quint32)-1},   // LINK 5.11
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "5.11",             ""},                    0x0011,         (quint32)-1},   // LINK 5.11 OMF to COFF conversion
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "6.14",             "MMX2 support"},        0x0012,         (quint32)-1},   // MASM 6.14 (MMX2 support)
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "5.12",             ""},                    0x0013,         (quint32)-1},   // LINK 5.12
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "5.12",             ""},                    0x0014,         (quint32)-1},   // LINK 5.12 OMF to COFF conversion
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.00",            "C/std"},               0x0015,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.00",            "C++/std"},             0x0016,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.00",            "C/book"},              0x0017,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.00",            "C++/book"},            0x0018,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "7.00",             ""},                    0x0019,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "7.00",             ""},                    0x001a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "Basic"},               0x001b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "C"},                   0x001c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "C++"},                 0x001d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "6.10",             ""},                    0x001e,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "6.10",             ""},                    0x001f,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "6.01",             ""},                    0x0020,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "6.01",             ""},                    0x0021,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.10",            "Basic"},               0x0022,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.10",            "C"},                   0x0023,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.10",            "C++"},                 0x0024,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "6.20",             ""},                    0x0025,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "6.20",             ""},                    0x0026,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "7.00",             ""},                    0x0027,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "6.21",             ""},                    0x0028,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "6.21",             ""},                    0x0029,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "6.15",             ""},                    0x002a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "LTCG/C"},              0x002b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "LTCG/C++"},            0x002c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "6.20",             ""},                    0x002d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_ILASM,                        "1.00",             ""},                    0x002e,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.20",            "Basic"},               0x002f,         (quint32)-1}, // 6.20 ???
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.20",            "C"},                   0x0030,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.20",            "C++"},                 0x0031,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.20",            "C/std"},               0x0032,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.20",            "C++/std"},             0x0033,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.20",            "C/book"},              0x0034,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "12.20",            "C++/book"},            0x0035,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "6.22",             ""},                    0x0036,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "6.22",             ""},                    0x0037,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "5.01",             ""},                    0x0038,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "C/std"},               0x0039,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "C++/std"},             0x003a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "13.00",            ""},                    0x003b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "6.22",             ""},                    0x003c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "7.00",             ""},                    0x003d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "6.22",             ""},                    0x003e,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "7.00",             ""},                    0x003f,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "7.00",             ""},                    0x0040,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "POGO_I_C"},            0x0041,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "POGO_I_CPP"},          0x0042,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "POGO_O_C"},            0x0043,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.00",            "POGO_O_CPP"},          0x0044,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "7.00",             ""},                    0x0045,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "7.10p",            ""},                    0x0046,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "7.10p",            ""},                    0x0047,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "7.10p",            ""},                    0x0048,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "7.10p",            ""},                    0x0049,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "7.10p",            ""},                    0x004a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "7.10p",            ""},                    0x004b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "C"},                   0x004c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "C++"},                 0x004d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "C/std"},               0x004e,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "C++/std"},             0x004f,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "LTCG/C"},              0x0050,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "LTCG/C++"},            0x0051,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "POGO_I_C"},            0x0052,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "POGO_I_CPP"},          0x0053,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "POGO_O_C"},            0x0054,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10p",           "POGO_O_CPP"},          0x0055,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "6.24",             ""},                    0x0056,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "6.24",             ""},                    0x0057,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "6.24",             ""},                    0x0058,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "6.24",             ""},                    0x0059,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "7.10",             ""},                    0x005a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "7.10",             ""},                    0x005b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "7.10",             ""},                    0x005c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "7.10",             ""},                    0x005d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "7.10",             ""},                    0x005e,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "C"},                   0x005f,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "C++"},                 0x0060,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "C/std"},               0x0061,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "C++/std"},             0x0062,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "LTCG/C"},              0x0063,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "LTCG/C++"},            0x0064,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "POGO_I_C"},            0x0065,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "POGO_I_CPP"},          0x0066,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "POGO_O_C"},            0x0067,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "13.10",            "POGO_O_CPP"},          0x0068,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "7.10",             ""},                    0x0069,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "7.10p",            ""},                    0x006a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "13.10",            ""},                    0x006b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "13.10p",           ""},                    0x006c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "C"},                   0x006d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "C++"},                 0x006e,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "C/std"},               0x006f,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "C++/std"},             0x0070,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "LTCG/C"},              0x0071,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "LTCG/C++"},            0x0072,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "POGO_I_C"},            0x0073,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "POGO_I_CPP"},          0x0074,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "POGO_O_C"},            0x0075,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "POGO_O_CPP"},          0x0076,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "14.00",            ""},                    0x0077,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "8.00",             ""},                    0x0078,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTOMF,                       "8.00",             ""},                    0x0079,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "8.00",             ""},                    0x007a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "8.00",             ""},                    0x007b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "8.00",             ""},                    0x007c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "8.00",             ""},                    0x007d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "8.00",             ""},                    0x007e,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "Prerelease",       ""},                    0x007f,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "CVTCIL/C"},            0x0080,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "CVTCIL/C++"},          0x0081,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "14.00",            "LTCG/MSIL"},           0x0082,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "C"},                   0x0083,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "C++"},                 0x0084,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "C/std"},               0x0085,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "C++/std"},             0x0086,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "CVTCIL/C"},            0x0087,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "CVTCIL/C++"},          0x0088,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "LTCG/C"},              0x0089,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "LTCG/C++"},            0x008a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "LTCG/MSIL"},           0x008b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "POGO_I_C"},            0x008c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "POGO_I_CPP"},          0x008d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "POGO_O_C"},            0x008e,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "15.00",            "POGO_O_CPP"},          0x008f,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "15.00",            ""},                    0x0090,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "9.00",             ""},                    0x0091,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "9.00",             ""},                    0x0092,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "9.00",             ""},                    0x0093,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "9.00",             ""},                    0x0094,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "9.00",             ""},                    0x0095,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "9.00",             ""},                    0x0096,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_RESOURCE,                     "9.00",             ""},                    0x0097,         (quint32)-1}, // Manifest
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "10.00",            ""},                    0x0098,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "16.00",            ""},                    0x0099,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "10.00",            ""},                    0x009a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "10.00",            ""},                    0x009b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "10.00",            ""},                    0x009c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "10.00",            ""},                    0x009d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "10.00",            ""},                    0x009e,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "C"},                   0x009f,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "C++"},                 0x00a0,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "CVTCIL/C"},            0x00a1,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "CVTCIL/C++"},          0x00a2,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "LTCG/C"},              0x00a3,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "LTCG/C++"},            0x00a4,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "LTCG/MSIL"},           0x00a5,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "POGO_I_C"},            0x00a6,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "POGO_I_CPP"},          0x00a7,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "POGO_O_C"},            0x00a8,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MICROSOFTPHOENIX,             "16.00",            "POGO_O_CPP"},          0x00a9,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "C"},                   0x00aa,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "C++"},                 0x00ab,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "CVTCIL/C"},            0x00ac,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "CVTCIL/C++"},          0x00ad,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "LTCG/C"},              0x00ae,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "LTCG/C++"},            0x00af,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "LTCG/MSIL"},           0x00b0,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "POGO_I_C"},            0x00b1,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "POGO_I_CPP"},          0x00b2,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "POGO_O_C"},            0x00b3,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.00",            "POGO_O_CPP"},          0x00b4,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "10.10",            ""},                    0x00b5,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "16.10",            ""},                    0x00b6,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "10.10",            ""},                    0x00b7,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "10.10",            ""},                    0x00b8,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "10.10",            ""},                    0x00b9,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "10.10",            ""},                    0x00ba,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "10.10",            ""},                    0x00bb,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "C"},                   0x00bc,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "C++"},                 0x00bd,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "CVTCIL/C"},            0x00be,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "CVTCIL/C++"},          0x00bf,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "LTCG/C"},              0x00c0,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "LTCG/C++"},            0x00c1,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "LTCG/MSIL"},           0x00c2,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "POGO_I_C"},            0x00c3,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "POGO_I_CPP"},          0x00c4,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "POGO_O_C"},            0x00c5,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "16.10",            "POGO_O_CPP"},          0x00c6,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "11.00",            ""},                    0x00c7,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "17.00",            ""},                    0x00c8,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "11.00",            ""},                    0x00c9,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "11.00",            ""},                    0x00ca,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "11.00",            ""},                    0x00cb,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "11.00",            ""},                    0x00cc,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "11.00",            ""},                    0x00cd,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "C"},                   0x00ce,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "C++"},                 0x00cf,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "CVTCIL/C"},            0x00d0,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "CVTCIL/C++"},          0x00d1,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "LTCG/C"},              0x00d2,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "LTCG/C++"},            0x00d3,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "LTCG/MSIL"},           0x00d4,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "POGO_I_C"},            0x00d5,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "POGO_I_CPP"},          0x00d6,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "POGO_O_C"},            0x00d7,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "17.00",            "POGO_O_CPP"},          0x00d8,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "12.00",            ""},                    0x00d9,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "18.00",            ""},                    0x00da,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "12.00",            ""},                    0x00db,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "12.00",            ""},                    0x00dc,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "12.00",            ""},                    0x00dd,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "12.00",            ""},                    0x00de,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "12.00",            ""},                    0x00df,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "C"},                   0x00e0,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "C++"},                 0x00e1,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "CVTCIL/C"},            0x00e2,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "CVTCIL/C++"},          0x00e3,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "LTCG/C"},              0x00e4,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "LTCG/C++"},            0x00e5,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "LTCG/MSIL"},           0x00e6,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "POGO_I_C"},            0x00e7,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "POGO_I_CPP"},          0x00e8,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "POGO_O_C"},            0x00e9,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.00",            "POGO_O_CPP"},          0x00ea,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "12.10",            ""},                    0x00eb,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "18.10",            ""},                    0x00ec,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "12.10",            ""},                    0x00ed,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "12.10",            ""},                    0x00ee,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "12.10",            ""},                    0x00ef,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "12.10",            ""},                    0x00f0,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "12.10",            ""},                    0x00f1,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "C"},                   0x00f2,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "C++"},                 0x00f3,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "CVTCIL/C"},            0x00f4,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "CVTCIL/C++"},          0x00f5,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "LTCG/C"},              0x00f6,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "LTCG/C++"},            0x00f7,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "LTCG/MSIL"},           0x00f8,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "POGO_I_C"},            0x00f9,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "POGO_I_CPP"},          0x00fa,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "POGO_O_C"},            0x00fb,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "18.10",            "POGO_O_CPP"},          0x00fc,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_ALIASOBJ,                     "14.00",            ""},                    0x00fd,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTPGD,                       "19.00",            ""},                    0x00fe,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_CVTRES,                       "14.00",            ""},                    0x00ff,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_EXPORT,                       "14.00",            ""},                    0x0100,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IMPORT,                       "14.00",            ""},                    0x0101,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_LINKER,           SpecAbstract::RECORD_NAME_MICROSOFTLINKER,              "14.00",            ""},                    0x0102,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_MASM,                         "14.00",            ""},                    0x0103,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "C"},                   0x0104,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "C++"},                 0x0105,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "CVTCIL/C"},            0x0106,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "CVTCIL/C++"},          0x0107,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "LTCG/C"},              0x0108,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "LTCG/C++"},            0x0109,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "LTCG/MSIL"},           0x010a,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "POGO_I_C"},            0x010b,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "POGO_I_CPP"},          0x010c,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "POGO_O_C"},            0x010d,         (quint32)-1},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_UNIVERSALTUPLECOMPILER,       "19.00",            "POGO_O_CPP"},          0x010e,         (quint32)-1},
};

// .snaker ??? tool
// .ultra custom packer?
SpecAbstract::STRING_RECORD _PE_sectionNames_records[]=
{
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_12311134,                     "",                 "TEST"},                "Xiao"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ABCCRYPTOR,                   "",                 ""},                    ".aBc  "},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ACPROTECT,                    "",                 ""},                    ".perplex"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALEXPROTECTOR,                "1.0",              ""},                    ".alex"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALLOY,                        "",                 ""},                    ".alloy32"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALIENYZE,                     "",                 ""},                    ".alien"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ANDPAKK2,                     "",                 ""},                    "ANDpakk2"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ASMGUARD,                     "2.XX",             ""},                    "ASMGUARD"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "1.08-2.XX",        ""},                    ".adata"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_ASPACK,                       "2.XX",             ""},                    ".aspack"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ASPROTECT,                    "",                 ""},                    ".adata"},  // TODO Check Version
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_AVERCRYPTOR,                  "1.0-1.02",         ""},                    ".avc"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_AZPROTECT,                    "0001",             ""},                    "AZPR0001"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BACKDOORPECOMPRESSPROTECTOR,  "1.0",              ""},                    ".BCPack"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BAMBAM,                       "",                 ""},                    ".bedrock"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "",                 ""},                    "bero^fr "},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_BEROEXEPACKER,                "",                 ""},                    "packerBY"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_CHROMIUMCRASHPAD,             "",                 ""},                    "CPADinfo"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRUNCH,                       "1.0",              ""},                    "BitArts"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTER,                      "",                 ""},                    "SCRYPT"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTER,                      "",                 ""},                    "FCKCrypt"}, // TODO Check
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTOCRACKPEPROTECTOR,       "",                 ""},                    ".ccp3p"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DALKRYPT,                     "1.0",              ""},                    ".DalKiT"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_DEPACK,                       "",                 ""},                    ".depack"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTFIXNICEPROTECT,            "",                 ""},                    ".dotfix"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTNETREACTOR,                "2.XX",             ""},                    ".reacto"}, // TODO Check Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DOTNETREACTOR,                "4.XX",             ""},                    ".sdata"}, // TODO Check Version
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DRAGONARMOR,                  "",                 ""},                    "DAStub"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DYAMAR,                       "1.3.5",            ""},                    ".dyamarC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DYAMAR,                       "1.3.5",            ""},                    ".dyamarD"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ELECKEY,                      "2.00.X",           ""},                    ".sstb"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENCRYPTPE,                    "1.XX-2.XX",        ""},                    "EPE0"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENCRYPTPE,                    "1.XX-2.XX",        ""},                    "EPE1"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENIGMAVIRTUALBOX,             "",                 ""},                    ".enigma1"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ENIGMAVIRTUALBOX,             "",                 ""},                    ".enigma2"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EPROT,                        "0.01",             ""},                    "!eprot"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EPEXEPACK,                    "1.0",              ""},                    "!EPack"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_EPEXEPACK,                    "1.4",              ""},                    ".!ep"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_EXCELSIORJET,                 "",                 ""},                    ".jidata"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_EXCELSIORJET,                 "",                 ""},                    ".jedata"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.70-2.75",        ""},                    "ExeS"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXESTEALTH,                   "2.76",             ""},                    "rsrr"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "",                 ""},                    ".ex_cod"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EXPRESSOR,                    "",                 ""},                    ".ex_rsc"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FISHPEPACKER,                 "1.02-1.04",        ""},                    ".FISHPEP"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_FISHPEPACKER,                 "1.02-1.03",        ""},                    ".PEDATA"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_FISHPESHIELD,                 "",                 ""},                    ".FishPE"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_GIXPROTECTOR,                 "",                 ""},                    ".guruX"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_GO,                           "1.XX",             ""},                    ".symtab"}, // TODO Check
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_INSTALLER,        SpecAbstract::RECORD_NAME_GENTEEINSTALLER,              "",                 ""},                    ".gentee"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HMIMYSPROTECTOR,              "0.1",              ""},                    "hmimys"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PETOOL,           SpecAbstract::RECORD_NAME_HOODLUM,                      "",                 ""},                    ".HOODLUM"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_INQUARTOSOBFUSCATOR,          "",                 ""},                    ".inq"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_JDPACK,                       "",                 ""},                    ".jdpack"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KAOSPEDLLEXECUTABLEUNDETECTER,"",                 ""},                    ".Kaos12"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KAOSPEDLLEXECUTABLEUNDETECTER,"",                 ""},                    ".Kaos2 "},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KBYS,                         "",                 ""},                    ".shoooo"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_KKRUNCHY,                     "",                 ""},                    "kkrunchy"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KRYPTON,                      "0.4-0.5",          ""},                    "_!_!_!_"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KRYPTON,                      "0.2-0.5",          ""},                    "krypton"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KRYPTON,                      "0.2-0.5",          ""},                    "YADO"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LAMECRYPT,                    "1.0",              ""},                    "lamecryp"},
    {{0, XBinary::FT_PE64,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LARP64,                       "1.0.3",            "TEST"},                ".LARP"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MASKPE,                       "2.0",              ""},                    ".MaskPE"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW10,                        "",                 ""},                    ".decode"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MEW11SE,                      "",                 ""},                    "MEW"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MOLEBOXULTRA,                 "",                 ""},                    ".ultra"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MORPHNAH,                     "",                 ""},                    ".nah"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "",                 ""},                    ".MPRESS1"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MPRESS,                       "",                 ""},                    ".MPRESS2"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MSLRH,                        "",                 ""},                    ".mslrh"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NAKEDPACKER,                  "1.0",              ""},                    ".naked1"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NAKEDPACKER,                  "1.0",              ""},                    ".naked2"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NATIVECRYPTORBYDOSX,          "",                 ""},                    "NATIVES~"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NATIVECRYPTORBYDOSX,          "",                 ""},                    "CONFIG~"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NATIVECRYPTORBYDOSX,          "",                 ""},                    "CRYPT~"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NCODE,                        "",                 ""},                    ".n-coder"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NEOLITE,                      "1.0",              ""},                    ".neolit"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NOODLECRYPT,                  "",                 ""},                    ".Ncryo  "},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NOODLECRYPT,                  "",                 ""},                    ".De-vir "},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NOSINSTALLER,                 "",                 ""},                    ".nos"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NPACK,                        "",                 ""},                    ".nPack"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NSPACK,                       "",                 ""},                    ".nsp0"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NSPACK,                       "",                 ""},                    ".nsp1"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NSPACK,                       "",                 ""},                    ".nsp2"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_OREANSCODEVIRTUALIZER,        "",                 ""},                    ".vlizer"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCSHRINK,                     "",                 ""},                    "pcs1"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCSHRINK,                     "",                 ""},                    "pcs2"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCSHRINK,                     "",                 ""},                    "pcs3"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCSHRINK,                     "",                 ""},                    "pcs4"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCSHRINK,                     "",                 ""},                    "pcs5"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCSHRINK,                     "",                 ""},                    "pcs6"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCSHRINK,                     "",                 ""},                    "pcs7"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEARMOR,                      "0.7X",             ""},                    ".ccg"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEBUNDLE,                     "",                 ""},                    "pebundle"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PECRYPT32,                    "1.02",             ""},                    ".ficken"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEDIMINISHER,                 "0.1",              ""},                    ".teraphy"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PELOCKNT,                     "",                 ""},                    "PELOCKnt"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PENGUINCRYPT,                 "1.0",              ""},                    "Pingvin"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PEPACKSPROTECT,               "2.3",              ""},                    "okpack"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PESHIELD,                     "0.25-0.26",        ""},                    "PESHiELD"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PESHIELD,                     "0.25-0.26",        ""},                    "ANAKIN2K"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PETITE,                       "",                 ""},                    ".petite"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PETITE,                       "",                 ""},                    "petite"}, // TODO Check version
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PUNISHER,                     "1.5 demo",         ""},                    "PUNiSHER"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_QT,                           "",                 ""},                    ".qtmetad"}, // TODO Version 5.x Only?
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_RCRYPTOR,                     "",                 ""},                    "RCryptor"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLP,                          "",                 ""},                    ".rlp"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "",                 ""},                    ".packed"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RLPACK,                       "",                 ""},                    ".RLPack"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SAFEENGINESHIELDEN,           "",                 ""},                    ".sedata"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_SCPACK,                       "",                 ""},                    ".scpack"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "",                 ""},                    ".shrink0"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "",                 ""},                    ".shrink1"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SHRINKER,                     "",                 ""},                    ".shrink2"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SOFTDEFENDER,                 "1.X",              ""},                    "SDPC"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SOFTDEFENDER,                 "1.X",              ""},                    "SDPD"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SOFTDEFENDER,                 "1.X",              ""},                    "SDPI"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SOFTWARECOMPRESS,             "",                 ""},                    "SoftComp"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_STARFORCE,                    "3.XX",             ""},                    ".sforce3"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_STARFORCE,                    "4.XX-5.XX",        ""},                    ".ps4"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_STONESPEENCRYPTOR,            "",                 ""},                    ".Stone"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SVKPROTECTOR,                 "1.3X-1.4X",        ""},                    ".svkp "},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SVKPROTECTOR,                 "1.1X",             ""},                    "SVKP"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TELOCK,                       "",                 ""},                    "UPX!"}, // ???
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THEMIDAWINLICENSE,            "3.X",              ""},                    ".imports"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THEMIDAWINLICENSE,            "3.X",              "Themida"},             ".themida"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THEMIDAWINLICENSE,            "3.X",              "Winlicense"},          ".winlice"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THEMIDAWINLICENSE,            "3.X",              ""},                    ".loadcon"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_THEMIDAWINLICENSE,            "3.X",              ""},                    ".boot"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_TPPPACK,                      "",                 ""},                    ".Np"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TTPROTECT,                    "",                 ""},                    ".TTP"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "",                 ""},                    ".UPX0"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "",                 ""},                    ".UPX1"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "",                 ""},                    ".UPX2"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VCASMPROTECTOR,               "1.X",              ""},                    "vcasm"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VIRTUALIZEPROTECT,            "",                 ""},                    "VProtect"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "",                 ""},                    ".vmp0"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "",                 ""},                    ".vmp1"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "",                 ""},                    ".vmp2"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VMPROTECT,                    "",                 ""},                    ".vmp3"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PETOOL,           SpecAbstract::RECORD_NAME_VMUNPACKER,                   "",                 ""},                    ".dswlab"},// TODO Check
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_WINKRIPT,                     "1.0",              ""},                    ".wkt0"},// TODO Check!
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WINUPACK,                     "",                 ""},                    ".Upack"}, // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_INSTALLER,        SpecAbstract::RECORD_NAME_WISE,                         "",                 ""},                    ".WISE"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_INSTALLER,        SpecAbstract::RECORD_NAME_WIXTOOLSET,                   "",                 ""},                    ".wixburn"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_XENOCODE,                     "",                 ""},                    ".xcpad"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_XTREMEPROTECTOR,              "",                 ""},                    "CODE    "},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_XTREMEPROTECTOR,              "",                 ""},                    ".idata  "},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_XTREMEPROTECTOR,              "",                 ""},                    "XPROT   "},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_XTREAMLOK,                    "",                 ""},                    ".xlok"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PETOOL,           SpecAbstract::RECORD_NAME_XVOLKOLAK,                    "",                 ""},                    ".xvlk"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASCRYPTER,                 "1.X",              ""},                    "yC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASPROTECTOR,               "1.0b",             ""},                    "yC"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YODASPROTECTOR,               "",                 ""},                    ".yP"},
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_YZPACK,                       "",                 ""},                    ".yzpack"},
};

SpecAbstract::STRING_RECORD _PE_dot_ansistrings_records[]=
{
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_DOTFUSCATOR,                  "",                 ""},                    "DotfuscatorAttribute"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_VCL,                          "",                 ".NET"},                 "Borland.Vcl.Types"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_VBNET,                        "",                 ""},                    "Microsoft.VisualBasic"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_JSCRIPT,                      "",                 ""},                    "Microsoft.JScript.Vsa"},
    //    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_TOOL,              SpecAbstract::RECORD_NAME_EMBARCADERODELPHIDOTNET,  "",                 ""},                    "Embarcadero."},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_YANO,                         "1.X",              ""},                    "YanoAttribute"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_AGILENET,                     "",                 ""},                    "ObfuscatedByAgileDotNetAttribute"},
    //    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_SKATERNET,                    "",             ""},                    "Skater_NET_Obfuscator"},
    //    {1, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_SKATERNET,                    "",             ""},                    "RustemSoft.Skater"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_BABELNET,                     "3.X",              ""},                    "BabelAttribute"}, // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_BABELNET,                     "1.X-2.X",         ""},                     "BabelObfuscatorAttribute"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_CLISECURE,                    "4.X-5.X",          ""},                    "ObfuscatedByCliSecureAttribute"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_CLISECURE,                    "3.X",              ""},                    "CliSecureRd.dll"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_CLISECURE,                    "3.X",              ""},                    "CliSecureRd64.dll"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_EMBARCADERODELPHIDOTNET,      "XE*",             ""},                     "Borland.Studio.Delphi"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_EMBARCADERODELPHIDOTNET,      "8",                ""},                    "Borland.Vcl.Types"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_CRYPTOOBFUSCATORFORNET,       "",                 ""},                    "CryptoObfuscator"}, // TODO Version, die
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_DEEPSEA,                      "4.X",              ""},                    "DeepSeaObfuscator"}, // TODO Version, die
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_GOLIATHNET,                   "",                 ""},                    "ObfuscatedByGoliath"}, // TODO Version, die
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_MACROBJECT,                   "",                 ""},                    "Obfuscated by Macrobject Obfuscator.NET"}, // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_SOFTWAREZATOR,                "",                 ""},                    "ObfuscatedBySoftwareZatorAttribute"}, // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_NSPACK,                       "2.X-3.X",          ".NET"},                "nsnet"}, // TODO Version
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_DNGUARD,                      "",                 ""},                    "ZYXDNGuarder"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_DNGUARD,                      "",                 ""},                    "HVMRuntm.dll"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETCOMPRESSOR,    SpecAbstract::RECORD_NAME_DOTNETZ,                      "",                 ""},                    "NetzStarter"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_MAXTOCODE,                    "",                 ""},                    "InfaceMaxtoCode"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_PHOENIXPROTECTOR,             "",                 ""},                    "?1?.?9?.resources"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETCOMPRESSOR,    SpecAbstract::RECORD_NAME_SIXXPACK,                     "",                 ""},                    "Sixxpack"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_SMARTASSEMBLY,                "",                 ""},                    "SmartAssembly.Attributes"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_SMARTASSEMBLY,                "",                 ""},                    "SmartAssembly.Attributes.PoweredByAttribute"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_CONFUSER,                     "1.X",              ""},                    "ConfusedByAttribute"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_SPICESNET,                    "",                 ""},                    "NineRays.Obfuscator"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_OBFUSCATORNET2009,            "",                 ""},                    "Macrobject.Obfuscator"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_XENOCODEPOSTBUILD,            "2.X-3.X",          ""},                    "Xenocode.Client.Attributes.AssemblyAttributes"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_CODEVEIL,                     "4.X",              ""},                    "____KILL"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_DOTNETSPIDER,                 "0.5-1.3",          ""},                    "NETSpider.Attribute"},
//    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_EAZFUSCATOR,                  "",                 ""},                    "value__"},
};

SpecAbstract::STRING_RECORD _PE_dot_unicodestrings_records[]={
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CODEVEIL,                     "3.X-4.X",          ""},                    "E_TamperDetected"}
};

SpecAbstract::SIGNATURE_RECORD _PE_codesection_records[]=
{
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_GO,                           "1.X",              ""},                    "FF' Go build ID: '22"},
};

SpecAbstract::SIGNATURE_RECORD _PE_entrypointsection_records[]=
{
    {{0, XBinary::FT_PE32,      SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_MASKPE,                       "2.0",              ""},                    "6160E8........8BC33E8B..40E8"},
};

SpecAbstract::SIGNATURE_RECORD _PE_dot_codesection_records[]=
{
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_OBFUSCAR,                     "1.0",              ""},                    "0691066120AA00000061D29C0617580A"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_SKATER,                       "",                 ""},                    "'RustemSoft.Skater'"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_CRYPTOOBFUSCATORFORNET,       "5.X",              ""},                    "000220....000A20FFFFFF0028........2A"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_CRYPTOOBFUSCATORFORNET,       "5.X",              ""},                    "0291203FFFFFFF5F1F18620A067E........021758911F1062600A067E"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_CODEWALL,                     "4.X",              ""},                    "9161D281........11..175813..11..11..32..28........11..6F........13..7E........2D..73"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_EAZFUSCATOR,                  "",                 ""},                    "2072FFFF0F5F20841A000061"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_PHOENIXPROTECTOR,             "1.7-1.8",          ""},                    "0000010B160C..........0208..........0D0906085961D21304091E630861D21305070811051E62110460D19D081758"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETCOMPRESSOR,    SpecAbstract::RECORD_NAME_SIXXPACK,                     "2.4",              ""},                    "0021......'xpack!'00................'xpack'00"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETCOMPRESSOR,    SpecAbstract::RECORD_NAME_RENETPACK,                    "2.0-3.X",          ""},                    "'Protected/Packed with ReNET-Pack by stx'"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETCOMPRESSOR,    SpecAbstract::RECORD_NAME_DOTNETSHRINK,                 "2.01 Demo",        "Password"},            "20FE2B136028........13..203B28136028........13..11..11..161F4028........26"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETCOMPRESSOR,    SpecAbstract::RECORD_NAME_DOTNETSHRINK,                 "2.01 Demo",        "Password"},            "20AD65133228........13..206866133228........13..11..11..161F4028........26"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETCOMPRESSOR,    SpecAbstract::RECORD_NAME_DOTNETSHRINK,                 "2.01 Demo",        ""},                    "20B9059F0728........13..2066059F0728........13..11..11..161F4028........26"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETCOMPRESSOR,    SpecAbstract::RECORD_NAME_DOTNETSHRINK,                 "2.01 Demo",        ""},                    "20E6EA19BE28........13..2039EA19BE28........13..11..11..161F4028........26"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_DOTNETSPIDER,                 "0.5-1.3",          ""},                    "'NETSpider.Attribute'"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETCOMPRESSOR,    SpecAbstract::RECORD_NAME_DOTNETZ,                      "",                 ""},                    "00'NetzStarter'00'netz'00"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_DEEPSEA,                      "4.X",              ""},                    "'DeepSeaObfuscator'"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_SMARTASSEMBLY,                "",                 ""},                    "'Powered by SmartAssembly '"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_SMARTASSEMBLY,                "",                 ""},                    "'Powered by {smartassembly}'"},
    {{0, XBinary::FT_PE,        SpecAbstract::RECORD_TYPE_NETOBFUSCATOR,    SpecAbstract::RECORD_NAME_FISHNET,                      "",                 ""},                    "0800'FISH_NET'"},
};

SpecAbstract::STRING_RECORD _TEXT_Exp_records[]=
{
    {{0, XBinary::FT_TEXT,      SpecAbstract::RECORD_TYPE_SOURCECODE,       SpecAbstract::RECORD_NAME_CCPP,                         "",                 ""},                    "#include [\"<].*?[>\"]"},
    {{0, XBinary::FT_TEXT,      SpecAbstract::RECORD_TYPE_SOURCECODE,       SpecAbstract::RECORD_NAME_CCPP,                         "",                 "header"},              "#ifndef (\\w+).*\\s+#define \\1"},
    {{0, XBinary::FT_TEXT,      SpecAbstract::RECORD_TYPE_SOURCECODE,       SpecAbstract::RECORD_NAME_HTML,                         "",                 ""},                    "^<(!DOCTYPE )?[Hh][Tt][Mm][Ll]"},
    {{0, XBinary::FT_TEXT,      SpecAbstract::RECORD_TYPE_SOURCECODE,       SpecAbstract::RECORD_NAME_PHP,                          "",                 ""},                    "^<\\?php"},
    {{0, XBinary::FT_TEXT,      SpecAbstract::RECORD_TYPE_SOURCECODE,       SpecAbstract::RECORD_NAME_PYTHON,                       "",                 ""},                    "import"},
    {{0, XBinary::FT_TEXT,      SpecAbstract::RECORD_TYPE_SOURCECODE,       SpecAbstract::RECORD_NAME_XML,                          "",                 ""},                    "^<\\?xml"},
    {{0, XBinary::FT_TEXT,      SpecAbstract::RECORD_TYPE_SOURCECODE,       SpecAbstract::RECORD_NAME_SHELL,                        "",                 ""},                    "#!"},
};

SpecAbstract::SIGNATURE_RECORD _MSDOS_header_records[]=
{
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYEXE,                       "4.0",              ""},                    "'MZ'....................................................'CryEXE 4.0 By Iosco^DaTo!'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LSCRYPRT,                     "1.21",             ""},                    "'MZ'....................................................'L.S.    Crypt By'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PACKWIN,                      "1.0",              ""},                    "'MZ'........................................................'YRZLITE (C) 1993 WYellow Rose'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE,                       "1.0",              ""},                    "'MZ'........................................................'PKLITE Copr. 1990 PKWARE Inc. All Rights Reserved'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE,                       "1.1",              ""},                    "'MZ'........................................................'PKLITE Copr. 1990-91 PKWARE Inc. All Rights Reserved'"}, // TODO Check Version
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PKLITE,                       "1.2",              ""},                    "'MZ'........................................................'PKLITE Copr. 1990-92 PKWARE Inc. All Rights Reserved'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_WWPACK,                       "",                 ""},                    "'MZ'....................................................'WWP'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_LZEXE,                        "0.90",             ""},                    "'MZ'....................................................'LZ09'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_LZEXE,                        "0.91",             ""},                    "'MZ'....................................................'LZ91'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RJCRUSH,                      "1.00",             ""},                    "'MZ'....................................................'RJS1'"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_SFX,              SpecAbstract::RECORD_NAME_LHASSFX,                      "2.11S",            ""},                    "'MZ'....................................................................'LHA'27's SFX 2.11S (c) Yoshi, 1991'"},
};

SpecAbstract::SIGNATURE_RECORD _MSDOS_entrypoint_records[]=
{
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_IBMPCPASCAL,                  "1.00(1981)",       ""},                    "B8....8ED88C06....BA....D1EAB9....2BCAD1EA"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_IBMPCPASCAL,                  "2.00(1984)",       ""},                    "B8....8ED88C06....FA8ED0268B1E....2BD881FB....7E..BB....D1E3"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_IBMPCPASCAL,                  "2.02(1987)",       ""},                    "2E8E1E....8CD08CDB2BC3D1E0"}, // TODO Check
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_IBMPCPASCAL,                  "2.05(1987)",       ""},                    "B8....8ED88BD08C06....268B1E....891E....2BD8F7C3....75..B1..D3E3"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PACKWIN,                      "1.0",              ""},                    "8CC0FA8ED0BC....FB060E1F2E8B0E....8BF14E8BFE8CDB2E031E....8EC3FDF3A453B8....50CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_WATCOMCCPP,                   "1994",             ""},                    "......'WATCOM C/C++16 Run-Time system. (c) Copyright by WATCOM International Corp. 1988-1994. '"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_WATCOMCCPP,                   "1995",             ""},                    "......'WATCOM C/C++16 Run-Time system. (c) Copyright by WATCOM International Corp. 1988-1995. '"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_WATCOMCCPP,                   "2.0",              ""},                    "EB....00'*** NULL assignment detected'00'"}, // TODO rename
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_DOSEXTENDER,      SpecAbstract::RECORD_NAME_CAUSEWAY,                     "3.1X-3.4X",        ""},                    "FA161F26A1....83E8..8ED0FB061607BE....8BFEB9....F3A407368C......8BD88CCA3603......368B......FD8BC53D....76"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_LZEXE,                        "0.90",             ""},                    "060E1F8B0E....8BF14E89F78CDB03......8EC3B4..31EDFDAC01C5AAE2"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_LZEXE,                        "0.91",             ""},                    "060E1F8B0E....8BF14E89F78CDB03......8EC3FDF3A453B8....50CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_AINEXE,                       "2.1",              ""},                    "A1....2D....8ED0BC....8CD836A3....05....36A3....2EA1....8AD4B1..D2EAFEC9D3E08CD336"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_AINEXE,                       "2.3",              ""},                    "0E07B9....BE....33FFFCF3A4A1....2D....8ED0BC....8CD836......05....36......2E"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_AINEXE,                       "2.22",             ""},                    "A1....2D....8ED0BC....8CD836A3....05....36A3....2EA1....8AD4B1..D2EAD3E08CD3368B2E....2E032E....FDFECA"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PGMPAK,                       "0.13",             ""},                    "FA1E1750B430CD213C..73..B44CCD21FCBE....BF....E8....E8....BB....BA....8AC38BF3"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PGMPAK,                       "0.15",             ""},                    "1E1750B430CD213C..73..B44CCD21FCBE....BF....E8....E8....BB....BA....8AC38BF3"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_TURBOCPP,                     "1988",             ""},                    "BA....2E8916....B430CD218B2E....8B1E....8EDAA3....8C06....891E....892E....C43E....8BC78BD8"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RJCRUSH,                      "1.00",             ""},                    "06FC8CC8BA....03D052BA....52BA....03C28BD805....8EDB8EC033F633FFB9"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_BAT2EXEC,                     "1.2",              ""},                    "FCBD....8B....8B......8B......B44ACD21A1....8986....8B9E....FFE3"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_JAM,                          "2.21",             ""},                    "50061607BE....8BFEB9....FDFAF32EA5FB06BD....55CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_SFX,              SpecAbstract::RECORD_NAME_PKZIPMINISFX,                 "1.1",              ""},                    "B8....A3....BF....B9....2BCF32C0F3AAB430CD21A3....A1....A3....E8....B8"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_SFX,              SpecAbstract::RECORD_NAME_PKZIPMINISFX,                 "2.04",             ""},                    "B9....BF....2BCF32C0F3AAB430CD21A3....8926....E8....B8....E8....E8"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_AVPACK,                       "1.20",             ""},                    "501E0E1F160733F68BFEB9....FCF3A506BB....53CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_LGLZ,                         "1.04",             ""},                    "FC1E060E8CC80106....BA....03C28BD805....8EDB8EC033F633FFB9....F3A54B484A79..8EC38ED8BE....AD95B2..EA"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PROPACK,                      "2.08",             ""},                    "8CD38EC38CCA8EDA8B0E....8BF183EE..8BFED1..FDF3A553B8....508B......CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_PROPACK,                      "2.13-2.14",        ""},                    "0E8CD38EC38CCA8EDA8B......8BF183....8BFED1..FDF3A553B8....508B......03......CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_TINYPROG,                     "3.X",              ""},                    "83EC..83E4..8BEC50BE....0336....8CD28CD803....33C275..FC8EC233FF"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UCEXE,                        "2.3",              ""},                    "501E0E1FFC33F6E8....160733F633FFB9....F3A506B8....50CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UCEXE,                        "2.4",              ""},                    "501E0E1FFC2BF6E8....16072BF68BFEB9....F3A406B8....50CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UCEXE,                        "3.0",              ""},                    "501E0E1FFC160733F633FFB9....F3A506B8....50CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CCBYVORONTSOV,                "1.00",             ""},                    "B8....BA....3BE073..B409BA....CD21B8....CD218BDC81EB....83E3..FCBE....8BFBB9....F3A48BC3B1..D3E88CC903C15033C050CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTORBYDISMEMBER,           "1.3",              ""},                    "1E8CDA83....8EDA8EC2BB....BA....85D274..B4..33FF33F6B9....AC32C4C0....02..2E........AAE2"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTORBYDISMEMBER,           "1.7",              ""},                    "0E179C58F6....74..E9....1EB0..E6..8CDA83....8EDA8EC2BB....BA....85D274..B4..33FF33F6B9"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTORBYDISMEMBER,           "2.0",              ""},                    "FA061E8CDD83C5..2E012E....2E012E....E8....E8....1F072E8E16....2E8B26....FB2EFF2E"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.20-0.60",        ""},                    "8CCBB9....BE....89F71EA9....8D......8ED805....8EC0FDF3A5FC"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_UPX,                          "0.82-3.XX",        ""},                    "B9....BE....89F71EA9....8CC805....8ED805....8EC0FDF3A5FC2E........73..92AFAD0E0E"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LOCKTITE,                     "",                 ""},                    "8CC88ED88CC381C3....8BC30306....8EC08B0E....8BF14E8BFEFDF3A450B8....50CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PCOM,                         "2.8b2-2.8b3",      "-e -i"},               "BE....B9....2E8A0434..2E880446E2"},

    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_APACK,                        "0.90-0.99,XE_1.3-1.4", ""},                "1E068CCBBA....03DAFC33F633FF4B8EDB8D......8EC0B9....F3A54A75..8EC38ED833FFBE....05....0E50"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_APACK,                        "0.82",             ""},                    "1E068CCBBA....03DA8D87....FC33F633FF484B8EC08EDBB9....F3A54A75..8EC38ED833FFBE....05....0E50"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_APACK,                        "0.94",             "-m -d"},               "8CC88ED805....8EC050BE....33FFFCB2..BD....33C950A4FFD5"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_APACK,                        "0.98, 0.99",       "-t"},                  "1E060E1F0E07BE....BF....8BCFFC57F3A4C3"},
    // TODO More
};

SpecAbstract::SIGNATURE_RECORD _MSDOS_entrypointExp_records[]=
{
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_COMPILER,         SpecAbstract::RECORD_NAME_BAT2EXEC,                     "1.5",              ""},                    "EB$$FCBD....8B....8B......8B......B44ACD21A1....8986....8B9E....FFE3"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_SFX,              SpecAbstract::RECORD_NAME_ICE,                          "1.0",              ""},                    "EB$$BE....8BFE8B0E....8B16....B8....50FCAD33C2AB8BD0E2"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_RELPACK,                      "1.0",              ""},                    "EB$$2E8C1E....2E8C06....8CC383C3..8CC88ED8BE....FCAD3D....75..AD3D....74..03C38EC0AD8BF826011DEB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_SCRNCH,                       "1.02",             ""},                    "EB$$BB....B44ACD2181EB....73..BA....B9....E9$$$$0E1FB440BB....CD21B8....CD21"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_TINYPROG,                     "3.X",              ""},                    "E9$$$$EB$$83EC..83E4..8BEC50BE....0336....8CD28CD803....33C275..FC8EC233FF"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_TINYPROG,                     "3.X",              ""},                    "EB$$83EC..83E4..8BEC50BE....0336....8CD28CD803....33C275..FC8EC233FF"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PACKER,           SpecAbstract::RECORD_NAME_TINYPROG,                     "3.X",              ""},                    "E9$$$$2EC606......E9$$$$83EC..83E4..8BEC50BE............8CD28CD803....33C275..FC8EC233FF"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTCOM,                     "2.0",              ""},                    "E9$$$$BE....56B9....C704....C644....8134....4646E2..31F631C9C3"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTORBYDISMEMBER,           "1.7",              ""},                    "0E179C58F6....74..EB$$B0..E6..33C9E2..B430CD213C..73..33C00650CB"},
    {{0, XBinary::FT_MSDOS,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_CRYPTORBYDISMEMBER,           "2.0",              ""},                    "E9$$$$BF....8BF7ACAD918AE157AC32C4F6D0D0C412E1AAE2"},
};

SpecAbstract::SIGNATURE_RECORD _ELF_entrypoint_records[]=
{
    {{0, XBinary::FT_ELF32,     SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BURNEYE,                      "1.00",             ""},                    "FF35........9C608B0D........E9"},
};

SpecAbstract::STRING_RECORD _APK_file_records[]=
{
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECSHELL,                     "",                 ""},                    "lib/armeabi/libSecShell-x86.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECSHELL,                     "",                 ""},                    "lib/armeabi/libSecShell.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECSHELL,                     "",                 ""},                    "assets/secData0.jar"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "Old",              ""},                    "assets/dexprotect/classes.dex.dat"}, // Old version
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "",                 ""},                    "assets/classes.dex.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "",                 ""},                    "assets/dp.arm-v7.so.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "",                 ""},                    "assets/dp.arm-v8.so.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "",                 ""},                    "assets/dp.arm.so.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "",                 ""},                    "assets/dp.mp3"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "",                 ""},                    "assets/dp.x86.so.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "",                 ""},                    "assets/dp.x86_64.so.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "",                 "Kotlin"},              "assets/dp-lib/dp.kotlin-v1.lua.mph"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "4.9.0-4.9.5",      ""},                    "lib/armeabi/libdexprotector.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXPROTECTOR,                 "4.9.0-4.9.5",      ""},                    "lib/armeabi-v7a/libdexprotector.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_JIAGU,                        "",                 ""},                    "assets/libjiagu.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_JIAGU,                        "",                 ""},                    "assets/libjiagu_a64.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_JIAGU,                        "",                 ""},                    "assets/libjiagu_ls.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_JIAGU,                        "",                 ""},                    "assets/libjiagu_x64.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_JIAGU,                        "",                 ""},                    "assets/libjiagu_x86.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "",                 ""},                    "assets/ijiami.ajm"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "",                 ""},                    "assets/ijm_lib/armeabi/libexec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "",                 ""},                    "assets/ijm_lib/armeabi/libexecmain.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "",                 ""},                    "assets/ijm_lib/x86/libexec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "",                 ""},                    "assets/ijm_lib/x86/libexecmain.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "Old",              ""},                    "assets/ijiami.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "Old",              ""},                    "lib/armeabi/libexec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "Old",              ""},                    "lib/armeabi/libexecmain.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "Old",              ""},                    "lib/armeabi-v7a/libexec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "Old",              ""},                    "lib/armeabi-v7a/libexecmain.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "Old",              ""},                    "lib/x86/libexec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_IJIAMI,                       "Old",              ""},                    "lib/x86/libexecmain.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TENCENTPROTECTION,            "",                 ""},                    "tencent_stub"}, // Check another protectors from TENCENT(Mobile Tencent Protect)
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TENCENTPROTECTION,            "",                 ""},                    "assets/tosversion"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TENCENTLEGU,                  "",                 ""},                    "assets/o0oooOO0ooOo.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TENCENTLEGU,                  "",                 ""},                    "assets/0OO00l111l1l"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TENCENTLEGU,                  "",                 ""},                    "assets/0OO00oo01l1l"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TENCENTLEGU,                  "",                 ""},                    "assets/libshellx-super.2019.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TENCENTLEGU,                  "",                 ""},                    "lib/armeabi/libshell-super.2019.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TENCENTLEGU,                  "",                 ""},                    "lib/arm64-v8a/libshell-super.2019.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APPGUARD,                     "",                 ""},                    "lib/armeabi-v7a/libAppGuard.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APPGUARD,                     "",                 ""},                    "lib/armeabi/libAppGuard.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APPGUARD,                     "",                 ""},                    "lib/armeabi/libAppGuard-x86.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APPGUARD,                     "",                 ""},                    "assets/AppGuard0.jar"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APPGUARD,                     "",                 ""},                    "assets/AppGuard.dgc"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KIRO,                         "",                 ""},                    "lib/armeabi/libkiroro.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DXSHIELD,                     "",                 ""},                    "lib/armeabi/libdxbase.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECT,                   "",                 ""},                    "lib/armeabi/libAPKProtect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECT,                   "",                 ""},                    "lib/armeabi-v7a/libAPKProtect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECT,                   "",                 ""},                    "apkprotect.com/key.dat"}, // TODO Version
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECTOR,                 "",                 ""},                    "assets/ap.others/apkprotect.bin"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECTOR,                 "",                 ""},                    "assets/ap.src/apkprotect-v1.bin"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECTOR,                 "",                 ""},                    "assets/ap.src/apkprotect-v2.bin"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECTOR,                 "",                 ""},                    "assets/ap.src/apkprotect-v3.bin"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECTOR,                 "",                 ""},                    "lib/arm64-v8a/libapkprotect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECTOR,                 "",                 ""},                    "lib/armeabi-v7a/libapkprotect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECTOR,                 "",                 ""},                    "lib/x86/libapkprotect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECTOR,                 "",                 ""},                    "lib/x86_64/libapkprotect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_QDBH,                         "",                 ""},                    "assets/qdbh"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BANGCLEPROTECTION,            "",                 ""},                    "lib/armeabi/libsecexe.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BANGCLEPROTECTION,            "",                 ""},                    "lib/x86/libsecexe.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_QIHOO360PROTECTION,           "",                 ""},                    "lib/armeabi/libprotectClass.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_QIHOO360PROTECTION,           "",                 ""},                    "lib/armeabi-v7a/libprotectClass.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_QIHOO360PROTECTION,           "",                 ""},                    "lib/x86/libprotectClass.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALIBABAPROTECTION,            "",                 ""},                    "lib/armeabi/libmobisec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALIBABAPROTECTION,            "",                 ""},                    "lib/armeabi-v7a/libmobisec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALIBABAPROTECTION,            "",                 ""},                    "lib/x86/libmobisec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BAIDUPROTECTION,              "",                 ""},                    "assets/libbaiduprotect_x86.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BAIDUPROTECTION,              "",                 ""},                    "assets/baiduprotect.jar"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BAIDUPROTECTION,              "",                 ""},                    "lib/armeabi-v7a/libbaiduprotect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BAIDUPROTECTION,              "",                 ""},                    "lib/armeabi/libbaiduprotect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BAIDUPROTECTION,              "",                 ""},                    "lib/mips/libbaiduprotect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BAIDUPROTECTION,              "",                 ""},                    "lib/x86/libbaiduprotect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NQSHIELD,                     "",                 ""},                    "assets/libnqshieldx86.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NQSHIELD,                     "",                 ""},                    "assets/nqdata"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NQSHIELD,                     "",                 ""},                    "lib/armeabi/libnqshield.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NAGAPTPROTECTION,             "",                 ""},                    "lib/armeabi/libddog.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NAGAPTPROTECTION,             "",                 ""},                    "lib/armeabi/libfdog.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECNEO,                       "",                 ""},                    "lib/armeabi-v7a/libDexHelper.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECNEO,                       "",                 ""},                    "lib/armeabi-v7a/libDexHelper-x86.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECNEO,                       "",                 ""},                    "lib/arm64-v8a/libDexHelper.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECNEO,                       "",                 ""},                    "lib/arm64-v8a/libDexHelper-x86_64.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECNEO,                       "",                 ""},                    "lib/armeabi/libDexHelper.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECNEO,                       "",                 ""},                    "lib/armeabi/libDexHelper-x86.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECNEO,                       "",                 ""},                    "lib/x86/libDexHelper.so"},
//    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECNEO,                       "",                 ""},                    "lib/armeabi/libdexjni.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LIAPP,                        "",                 ""},                    "assets/LIAPPClient.sc"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LIAPP,                        "",                 ""},                    "assets/LIAPPClient_x86.sc"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LIAPP,                        "",                 ""},                    "assets/LIAPPEgg_x86.sc"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LIAPP,                        "",                 ""},                    "assets/LIAPPEgg.sc"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_SANDHOOK,                     "",                 ""},                    "lib/armeabi-v7a/libsandhook-native.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_SANDHOOK,                     "",                 ""},                    "lib/armeabi-v7a/libsandhook.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_SANDHOOK,                     "",                 ""},                    "lib/arm64-v8a/libsandhook-native.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_SANDHOOK,                     "",                 ""},                    "lib/arm64-v8a/libsandhook.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YIDUN,                        "",                 ""},                    "lib/arm64-v8a/libnesec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YIDUN,                        "",                 ""},                    "lib/x86/libnesec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YIDUN,                        "",                 ""},                    "lib/armeabi-v7a/libnesec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YIDUN,                        "",                 ""},                    "lib/armeabi/libnesec.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "assets/classes.jar"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "assets/unicom_resource.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "assets/arm64-v8a/libunicomSimplesdk.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "assets/arm64-v8a/libunicomsdk.jar"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "assets/arm64-v8a/libdecrypt.jar"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "assets/armeabi-v7a/libdecrypt.jar"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "assets/x86/libunicomSimplesdk.dat"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "assets/x86/libunicomsdk.jar"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "assets/x86/libdecrypt.jar"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MOBILETENCENTPROTECT,         "",                 ""},                    "lib/armeabi/mix.dex"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MOBILETENCENTPROTECT,         "",                 ""},                    "lib/armeabi-v7a/mix.dex"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PANGXIE,                      "",                 ""},                    "lib/armeabi-v7a/libnsecure.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PANGXIE,                      "",                 ""},                    "lib/armeabi/libnsecure.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VDOG,                         "",                 ""},                    "assets/main000/libhdog.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VDOG,                         "",                 ""},                    "assets/main000/libhdog-x86.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VDOG,                         "",                 ""},                    "assets/main000/libvdog.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VDOG,                         "",                 ""},                    "assets/main000/libvdog-x86.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_APKTOOLPLUS,                  "",                 ""},                    "lib/armeabi-v7a/libapktoolplus_jiagu.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HDUS_WJUS,                    "",                 ""},                    "lib/armeabi/libhdus.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_HDUS_WJUS,                    "",                 ""},                    "lib/armeabi/libwjus.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MEDUSAH,                      "",                 ""},                    "lib/armeabi-v7a/libmd.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APPSOLID,                     "",                 ""},                    "assets/high_resolution.png"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_OBFUSCATOR,       SpecAbstract::RECORD_NAME_PROGUARD,                     "",                 ""},                    "META-INF/proguard/androidx-annotations.pro"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNITY,                        "",                 ""},                    "lib/armeabi-v7a/libunity.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_IL2CPP,                       "",                 ""},                    "lib/armeabi-v7a/libil2cpp.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_OLLVMTLL,                     "",                 ""},                    "lib/armeabi-v7a/libmtprotect.so"},
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_OLLVMTLL,                     "",                 ""},                    "lib/x86/libmtprotect.so"},
};

SpecAbstract::STRING_RECORD _APK_fileExp_records[]=
{
    {{0, XBinary::FT_APK,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_BASIC4ANDROID,                "",                 ""},                    "assets\\/(.*).bal"},
};

SpecAbstract::STRING_RECORD _DEX_string_records[]=
{
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALLATORIOBFUSCATOR,           "",                 "Demo"},                "ALLATORIxDEMO"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_EASYPROTECTOR,                "",                 ""},                    "com.easyprotector.android"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_QDBH,                         "",                 ""},                    "/qdbh"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_JIAGU,                        "",                 ""},                    "/.jiagu"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BANGCLEPROTECTION,            "",                 ""},                    "apkFilePath"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PANGXIE,                      "",                 ""},                    "PangXie"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_PANGXIE,                      "",                 ""},                    "nsecure"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NAGAPTPROTECTION,             "",                 ""},                    "LIBRARY_DDOG"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NAGAPTPROTECTION,             "",                 ""},                    "LIBRARY_FDOG"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKPROTECT,                   "",                 ""},                    "APKProtect"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_AESOBFUSCATOR,                "",                 ""},                    "AESObfuscator.java"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MODGUARD,                     "1.2",              ""},                    "ModGuard - Protect Your Piracy v1.2 by ill420smoker"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MODGUARD,                     "1.3",              ""},                    "ModGuard - Protect Your Piracy v1.3 by ill420smoker"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_KIWIVERSIONOBFUSCATOR,        "",                 ""},                    "Kiwi__Version__Obfuscator"},
};

SpecAbstract::STRING_RECORD _DEX_type_records[]=
{
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_TOOL,             SpecAbstract::RECORD_NAME_APKTOOLPLUS,                  "",                 ""},                    "Lcom/linchaolong/apktoolplus/jiagu/utils/ApkToolPlus;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_LIBRARY,          SpecAbstract::RECORD_NAME_UNICOMSDK,                    "",                 ""},                    "Lcom/unicom/dcLoader/Utils;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Lo/CON;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Lo/AUX;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Lcon;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Laux;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Lo/con;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Lo/aux;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Lcom/guardsquare/dexguard/runtime/detection/DebugDetector;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Lcom/guardsquare/dexguard/runtime/detection/EmulatorDetector;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Lcom/guardsquare/dexguard/runtime/detection/RootDetector;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_DEXGUARD,                     "",                 ""},                    "Lcom/guardsquare/dexguard/runtime/detection/TamperDetector;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BTWORKSCODEGUARD,             "",                 ""},                    "Lbtworks/codeguard/agent/A;"},
//    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_QIHOO360PROTECTION,           "",                 ""},                    "Lcom/qihoo/util/StubApplication;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_ALIBABAPROTECTION,            "",                 ""},                    "Lcom/ali/mobisecenhance/StubApplication;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_BAIDUPROTECTION,              "",                 ""},                    "Lcom/baidu/protect/StubApplication;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_TENCENTPROTECTION,            "",                 ""},                    "Lcom/tencent/StubShell/TxAppEntry;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_SECNEO,                       "",                 ""},                    "Lcom/secneo/apkwrapper/ApplicationWrapper;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_LIAPP,                        "",                 ""},                    "Lcom/lockincomp/liapp/LiappClassLoader;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_VDOG,                         "",                 ""},                    "Lcom/vdog/Common;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_MEDUSAH,                      "",                 ""},                    "Lcom/seworks/medusah/MedusahDex;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_NQSHIELD,                     "",                 ""},                    "Lcom/nqshield/Common;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YIDUN,                        "",                 ""},                    "La/_;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_YIDUN,                        "",                 ""},                    "Lcom/_;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APPSOLID,                     "",                 ""},                    "Lweb/apache/sax/app;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_PROTECTOR,        SpecAbstract::RECORD_NAME_APKENCRYPTOR,                 "",                 ""},                    "Lcn/beingyi/sub/utils/Native;"},
    {{0, XBinary::FT_DEX,       SpecAbstract::RECORD_TYPE_OBFUSCATOR,       SpecAbstract::RECORD_NAME_PROGUARD,                     "",                 ""},                    "Lcom/google/android/gms/common/ProGuardCanary;"},
};
// CHECK nqshield
