#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from enum import Enum

from fenrirscreenreader.core import debug


class FenrirEventType(Enum):
    ignore = 0
    stop_main_loop = 1
    screen_update = 2
    keyboard_input = 3
    plug_input_device = 4
    screen_changed = 5
    heart_beat = 6
    execute_command = 7
    byte_input = 8
    remote_incomming = 9

    def __int__(self):
        return self.value

    def __str__(self):
        return self.name
