// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: encryptionpb.proto

package encryptionpb

import (
	"fmt"
	"io"
	"math"

	proto "github.com/golang/protobuf/proto"

	_ "github.com/gogo/protobuf/gogoproto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type EncryptionMethod int32

const (
	EncryptionMethod_UNKNOWN    EncryptionMethod = 0
	EncryptionMethod_PLAINTEXT  EncryptionMethod = 1
	EncryptionMethod_AES128_CTR EncryptionMethod = 2
	EncryptionMethod_AES192_CTR EncryptionMethod = 3
	EncryptionMethod_AES256_CTR EncryptionMethod = 4
)

var EncryptionMethod_name = map[int32]string{
	0: "UNKNOWN",
	1: "PLAINTEXT",
	2: "AES128_CTR",
	3: "AES192_CTR",
	4: "AES256_CTR",
}
var EncryptionMethod_value = map[string]int32{
	"UNKNOWN":    0,
	"PLAINTEXT":  1,
	"AES128_CTR": 2,
	"AES192_CTR": 3,
	"AES256_CTR": 4,
}

func (x EncryptionMethod) String() string {
	return proto.EnumName(EncryptionMethod_name, int32(x))
}
func (EncryptionMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{0}
}

// General encryption metadata for any data type.
type EncryptionMeta struct {
	// ID of the key used to encrypt the data.
	KeyId uint64 `protobuf:"varint,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Initialization vector (IV) of the data.
	Iv                   []byte   `protobuf:"bytes,2,opt,name=iv,proto3" json:"iv,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptionMeta) Reset()         { *m = EncryptionMeta{} }
func (m *EncryptionMeta) String() string { return proto.CompactTextString(m) }
func (*EncryptionMeta) ProtoMessage()    {}
func (*EncryptionMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{0}
}
func (m *EncryptionMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EncryptionMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EncryptionMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *EncryptionMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptionMeta.Merge(dst, src)
}
func (m *EncryptionMeta) XXX_Size() int {
	return m.Size()
}
func (m *EncryptionMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptionMeta.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptionMeta proto.InternalMessageInfo

func (m *EncryptionMeta) GetKeyId() uint64 {
	if m != nil {
		return m.KeyId
	}
	return 0
}

func (m *EncryptionMeta) GetIv() []byte {
	if m != nil {
		return m.Iv
	}
	return nil
}

// Information about an encrypted file.
type FileInfo struct {
	// ID of the key used to encrypt the file.
	KeyId uint64 `protobuf:"varint,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// Initialization vector (IV) of the file.
	Iv []byte `protobuf:"bytes,2,opt,name=iv,proto3" json:"iv,omitempty"`
	// Method of encryption algorithm used to encrypted the file.
	Method               EncryptionMethod `protobuf:"varint,3,opt,name=method,proto3,enum=encryptionpb.EncryptionMethod" json:"method,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *FileInfo) Reset()         { *m = FileInfo{} }
func (m *FileInfo) String() string { return proto.CompactTextString(m) }
func (*FileInfo) ProtoMessage()    {}
func (*FileInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{1}
}
func (m *FileInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FileInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FileInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *FileInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileInfo.Merge(dst, src)
}
func (m *FileInfo) XXX_Size() int {
	return m.Size()
}
func (m *FileInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_FileInfo.DiscardUnknown(m)
}

var xxx_messageInfo_FileInfo proto.InternalMessageInfo

func (m *FileInfo) GetKeyId() uint64 {
	if m != nil {
		return m.KeyId
	}
	return 0
}

func (m *FileInfo) GetIv() []byte {
	if m != nil {
		return m.Iv
	}
	return nil
}

func (m *FileInfo) GetMethod() EncryptionMethod {
	if m != nil {
		return m.Method
	}
	return EncryptionMethod_UNKNOWN
}

type FileDictionary struct {
	// A map of file name to file info.
	Files                map[string]*FileInfo `protobuf:"bytes,1,rep,name=files" json:"files,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *FileDictionary) Reset()         { *m = FileDictionary{} }
func (m *FileDictionary) String() string { return proto.CompactTextString(m) }
func (*FileDictionary) ProtoMessage()    {}
func (*FileDictionary) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{2}
}
func (m *FileDictionary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FileDictionary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FileDictionary.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *FileDictionary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileDictionary.Merge(dst, src)
}
func (m *FileDictionary) XXX_Size() int {
	return m.Size()
}
func (m *FileDictionary) XXX_DiscardUnknown() {
	xxx_messageInfo_FileDictionary.DiscardUnknown(m)
}

var xxx_messageInfo_FileDictionary proto.InternalMessageInfo

func (m *FileDictionary) GetFiles() map[string]*FileInfo {
	if m != nil {
		return m.Files
	}
	return nil
}

// The key used to encrypt the user data.
type DataKey struct {
	// A sequence of secret bytes used to encrypt data.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Method of encryption algorithm used to encrypted data.
	Method EncryptionMethod `protobuf:"varint,2,opt,name=method,proto3,enum=encryptionpb.EncryptionMethod" json:"method,omitempty"`
	// Creation time of the key.
	CreationTime uint64 `protobuf:"varint,3,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// A flag for the key have ever been exposed.
	WasExposed           bool     `protobuf:"varint,4,opt,name=was_exposed,json=wasExposed,proto3" json:"was_exposed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataKey) Reset()         { *m = DataKey{} }
func (m *DataKey) String() string { return proto.CompactTextString(m) }
func (*DataKey) ProtoMessage()    {}
func (*DataKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{3}
}
func (m *DataKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DataKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DataKey.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *DataKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataKey.Merge(dst, src)
}
func (m *DataKey) XXX_Size() int {
	return m.Size()
}
func (m *DataKey) XXX_DiscardUnknown() {
	xxx_messageInfo_DataKey.DiscardUnknown(m)
}

var xxx_messageInfo_DataKey proto.InternalMessageInfo

func (m *DataKey) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *DataKey) GetMethod() EncryptionMethod {
	if m != nil {
		return m.Method
	}
	return EncryptionMethod_UNKNOWN
}

func (m *DataKey) GetCreationTime() uint64 {
	if m != nil {
		return m.CreationTime
	}
	return 0
}

func (m *DataKey) GetWasExposed() bool {
	if m != nil {
		return m.WasExposed
	}
	return false
}

type KeyDictionary struct {
	// A map of key ID to dat key.
	Keys map[uint64]*DataKey `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// ID of a key currently in use.
	CurrentKeyId         uint64   `protobuf:"varint,2,opt,name=current_key_id,json=currentKeyId,proto3" json:"current_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyDictionary) Reset()         { *m = KeyDictionary{} }
func (m *KeyDictionary) String() string { return proto.CompactTextString(m) }
func (*KeyDictionary) ProtoMessage()    {}
func (*KeyDictionary) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{4}
}
func (m *KeyDictionary) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KeyDictionary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KeyDictionary.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *KeyDictionary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyDictionary.Merge(dst, src)
}
func (m *KeyDictionary) XXX_Size() int {
	return m.Size()
}
func (m *KeyDictionary) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyDictionary.DiscardUnknown(m)
}

var xxx_messageInfo_KeyDictionary proto.InternalMessageInfo

func (m *KeyDictionary) GetKeys() map[uint64]*DataKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *KeyDictionary) GetCurrentKeyId() uint64 {
	if m != nil {
		return m.CurrentKeyId
	}
	return 0
}

// Master key config.
type MasterKey struct {
	// Types that are valid to be assigned to Backend:
	//	*MasterKey_Plaintext
	//	*MasterKey_File
	//	*MasterKey_Kms
	Backend              isMasterKey_Backend `protobuf_oneof:"backend"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *MasterKey) Reset()         { *m = MasterKey{} }
func (m *MasterKey) String() string { return proto.CompactTextString(m) }
func (*MasterKey) ProtoMessage()    {}
func (*MasterKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{5}
}
func (m *MasterKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MasterKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MasterKey.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *MasterKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterKey.Merge(dst, src)
}
func (m *MasterKey) XXX_Size() int {
	return m.Size()
}
func (m *MasterKey) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterKey.DiscardUnknown(m)
}

var xxx_messageInfo_MasterKey proto.InternalMessageInfo

type isMasterKey_Backend interface {
	isMasterKey_Backend()
	MarshalTo([]byte) (int, error)
	Size() int
}

type MasterKey_Plaintext struct {
	Plaintext *MasterKeyPlaintext `protobuf:"bytes,1,opt,name=plaintext,oneof"`
}
type MasterKey_File struct {
	File *MasterKeyFile `protobuf:"bytes,2,opt,name=file,oneof"`
}
type MasterKey_Kms struct {
	Kms *MasterKeyKms `protobuf:"bytes,3,opt,name=kms,oneof"`
}

func (*MasterKey_Plaintext) isMasterKey_Backend() {}
func (*MasterKey_File) isMasterKey_Backend()      {}
func (*MasterKey_Kms) isMasterKey_Backend()       {}

func (m *MasterKey) GetBackend() isMasterKey_Backend {
	if m != nil {
		return m.Backend
	}
	return nil
}

func (m *MasterKey) GetPlaintext() *MasterKeyPlaintext {
	if x, ok := m.GetBackend().(*MasterKey_Plaintext); ok {
		return x.Plaintext
	}
	return nil
}

func (m *MasterKey) GetFile() *MasterKeyFile {
	if x, ok := m.GetBackend().(*MasterKey_File); ok {
		return x.File
	}
	return nil
}

func (m *MasterKey) GetKms() *MasterKeyKms {
	if x, ok := m.GetBackend().(*MasterKey_Kms); ok {
		return x.Kms
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MasterKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MasterKey_OneofMarshaler, _MasterKey_OneofUnmarshaler, _MasterKey_OneofSizer, []interface{}{
		(*MasterKey_Plaintext)(nil),
		(*MasterKey_File)(nil),
		(*MasterKey_Kms)(nil),
	}
}

func _MasterKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MasterKey)
	// backend
	switch x := m.Backend.(type) {
	case *MasterKey_Plaintext:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Plaintext); err != nil {
			return err
		}
	case *MasterKey_File:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.File); err != nil {
			return err
		}
	case *MasterKey_Kms:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Kms); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MasterKey.Backend has unexpected type %T", x)
	}
	return nil
}

func _MasterKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MasterKey)
	switch tag {
	case 1: // backend.plaintext
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MasterKeyPlaintext)
		err := b.DecodeMessage(msg)
		m.Backend = &MasterKey_Plaintext{msg}
		return true, err
	case 2: // backend.file
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MasterKeyFile)
		err := b.DecodeMessage(msg)
		m.Backend = &MasterKey_File{msg}
		return true, err
	case 3: // backend.kms
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MasterKeyKms)
		err := b.DecodeMessage(msg)
		m.Backend = &MasterKey_Kms{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MasterKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MasterKey)
	// backend
	switch x := m.Backend.(type) {
	case *MasterKey_Plaintext:
		s := proto.Size(x.Plaintext)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MasterKey_File:
		s := proto.Size(x.File)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MasterKey_Kms:
		s := proto.Size(x.Kms)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// MasterKeyPlaintext indicates content is stored as plaintext.
type MasterKeyPlaintext struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterKeyPlaintext) Reset()         { *m = MasterKeyPlaintext{} }
func (m *MasterKeyPlaintext) String() string { return proto.CompactTextString(m) }
func (*MasterKeyPlaintext) ProtoMessage()    {}
func (*MasterKeyPlaintext) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{6}
}
func (m *MasterKeyPlaintext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MasterKeyPlaintext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MasterKeyPlaintext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *MasterKeyPlaintext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterKeyPlaintext.Merge(dst, src)
}
func (m *MasterKeyPlaintext) XXX_Size() int {
	return m.Size()
}
func (m *MasterKeyPlaintext) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterKeyPlaintext.DiscardUnknown(m)
}

var xxx_messageInfo_MasterKeyPlaintext proto.InternalMessageInfo

// MasterKeyFile is a master key backed by a file containing encryption key in human-readable
// hex format.
type MasterKeyFile struct {
	// Local file path.
	Path                 string   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterKeyFile) Reset()         { *m = MasterKeyFile{} }
func (m *MasterKeyFile) String() string { return proto.CompactTextString(m) }
func (*MasterKeyFile) ProtoMessage()    {}
func (*MasterKeyFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{7}
}
func (m *MasterKeyFile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MasterKeyFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MasterKeyFile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *MasterKeyFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterKeyFile.Merge(dst, src)
}
func (m *MasterKeyFile) XXX_Size() int {
	return m.Size()
}
func (m *MasterKeyFile) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterKeyFile.DiscardUnknown(m)
}

var xxx_messageInfo_MasterKeyFile proto.InternalMessageInfo

func (m *MasterKeyFile) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// MasterKeyKms is a master key backed by KMS service that manages the encryption key,
// and provide API to encrypt and decrypt a data key, which is used to encrypt the content.
type MasterKeyKms struct {
	// KMS vendor.
	Vendor string `protobuf:"bytes,1,opt,name=vendor,proto3" json:"vendor,omitempty"`
	// KMS key id.
	KeyId string `protobuf:"bytes,2,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// KMS region.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// KMS endpoint. Normally not needed.
	Endpoint             string   `protobuf:"bytes,4,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MasterKeyKms) Reset()         { *m = MasterKeyKms{} }
func (m *MasterKeyKms) String() string { return proto.CompactTextString(m) }
func (*MasterKeyKms) ProtoMessage()    {}
func (*MasterKeyKms) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{8}
}
func (m *MasterKeyKms) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MasterKeyKms) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MasterKeyKms.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *MasterKeyKms) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MasterKeyKms.Merge(dst, src)
}
func (m *MasterKeyKms) XXX_Size() int {
	return m.Size()
}
func (m *MasterKeyKms) XXX_DiscardUnknown() {
	xxx_messageInfo_MasterKeyKms.DiscardUnknown(m)
}

var xxx_messageInfo_MasterKeyKms proto.InternalMessageInfo

func (m *MasterKeyKms) GetVendor() string {
	if m != nil {
		return m.Vendor
	}
	return ""
}

func (m *MasterKeyKms) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *MasterKeyKms) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *MasterKeyKms) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

type EncryptedContent struct {
	// Metadata of the encrypted content.
	// Eg. IV, method and KMS key ID
	// It is preferred to define new fields for extra metadata than using this metadata map.
	Metadata map[string][]byte `protobuf:"bytes,1,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Encrypted content.
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Master key used to encrypt the content.
	MasterKey *MasterKey `protobuf:"bytes,3,opt,name=master_key,json=masterKey" json:"master_key,omitempty"`
	// Initilization vector (IV) used.
	Iv []byte `protobuf:"bytes,4,opt,name=iv,proto3" json:"iv,omitempty"`
	// Encrypted data key generated by KMS and used to actually encrypt data.
	// Valid only when KMS is used.
	CiphertextKey        []byte   `protobuf:"bytes,5,opt,name=ciphertext_key,json=ciphertextKey,proto3" json:"ciphertext_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EncryptedContent) Reset()         { *m = EncryptedContent{} }
func (m *EncryptedContent) String() string { return proto.CompactTextString(m) }
func (*EncryptedContent) ProtoMessage()    {}
func (*EncryptedContent) Descriptor() ([]byte, []int) {
	return fileDescriptor_encryptionpb_d841ba3dd655e1a0, []int{9}
}
func (m *EncryptedContent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EncryptedContent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EncryptedContent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *EncryptedContent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EncryptedContent.Merge(dst, src)
}
func (m *EncryptedContent) XXX_Size() int {
	return m.Size()
}
func (m *EncryptedContent) XXX_DiscardUnknown() {
	xxx_messageInfo_EncryptedContent.DiscardUnknown(m)
}

var xxx_messageInfo_EncryptedContent proto.InternalMessageInfo

func (m *EncryptedContent) GetMetadata() map[string][]byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *EncryptedContent) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *EncryptedContent) GetMasterKey() *MasterKey {
	if m != nil {
		return m.MasterKey
	}
	return nil
}

func (m *EncryptedContent) GetIv() []byte {
	if m != nil {
		return m.Iv
	}
	return nil
}

func (m *EncryptedContent) GetCiphertextKey() []byte {
	if m != nil {
		return m.CiphertextKey
	}
	return nil
}

func init() {
	proto.RegisterType((*EncryptionMeta)(nil), "encryptionpb.EncryptionMeta")
	proto.RegisterType((*FileInfo)(nil), "encryptionpb.FileInfo")
	proto.RegisterType((*FileDictionary)(nil), "encryptionpb.FileDictionary")
	proto.RegisterMapType((map[string]*FileInfo)(nil), "encryptionpb.FileDictionary.FilesEntry")
	proto.RegisterType((*DataKey)(nil), "encryptionpb.DataKey")
	proto.RegisterType((*KeyDictionary)(nil), "encryptionpb.KeyDictionary")
	proto.RegisterMapType((map[uint64]*DataKey)(nil), "encryptionpb.KeyDictionary.KeysEntry")
	proto.RegisterType((*MasterKey)(nil), "encryptionpb.MasterKey")
	proto.RegisterType((*MasterKeyPlaintext)(nil), "encryptionpb.MasterKeyPlaintext")
	proto.RegisterType((*MasterKeyFile)(nil), "encryptionpb.MasterKeyFile")
	proto.RegisterType((*MasterKeyKms)(nil), "encryptionpb.MasterKeyKms")
	proto.RegisterType((*EncryptedContent)(nil), "encryptionpb.EncryptedContent")
	proto.RegisterMapType((map[string][]byte)(nil), "encryptionpb.EncryptedContent.MetadataEntry")
	proto.RegisterEnum("encryptionpb.EncryptionMethod", EncryptionMethod_name, EncryptionMethod_value)
}
func (m *EncryptionMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncryptionMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.KeyId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.KeyId))
	}
	if len(m.Iv) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Iv)))
		i += copy(dAtA[i:], m.Iv)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FileInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FileInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.KeyId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.KeyId))
	}
	if len(m.Iv) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Iv)))
		i += copy(dAtA[i:], m.Iv)
	}
	if m.Method != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.Method))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *FileDictionary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FileDictionary) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Files) > 0 {
		for k, _ := range m.Files {
			dAtA[i] = 0xa
			i++
			v := m.Files[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovEncryptionpb(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovEncryptionpb(uint64(len(k))) + msgSize
			i = encodeVarintEncryptionpb(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintEncryptionpb(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintEncryptionpb(dAtA, i, uint64(v.Size()))
				n1, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n1
			}
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DataKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.Method != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.Method))
	}
	if m.CreationTime != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.CreationTime))
	}
	if m.WasExposed {
		dAtA[i] = 0x20
		i++
		if m.WasExposed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *KeyDictionary) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyDictionary) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for k, _ := range m.Keys {
			dAtA[i] = 0xa
			i++
			v := m.Keys[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovEncryptionpb(uint64(msgSize))
			}
			mapSize := 1 + sovEncryptionpb(uint64(k)) + msgSize
			i = encodeVarintEncryptionpb(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintEncryptionpb(dAtA, i, uint64(k))
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintEncryptionpb(dAtA, i, uint64(v.Size()))
				n2, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n2
			}
		}
	}
	if m.CurrentKeyId != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.CurrentKeyId))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MasterKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Backend != nil {
		nn3, err := m.Backend.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn3
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MasterKey_Plaintext) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Plaintext != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.Plaintext.Size()))
		n4, err := m.Plaintext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *MasterKey_File) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.File != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.File.Size()))
		n5, err := m.File.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *MasterKey_Kms) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Kms != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.Kms.Size()))
		n6, err := m.Kms.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *MasterKeyPlaintext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterKeyPlaintext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MasterKeyFile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterKeyFile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Path) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MasterKeyKms) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MasterKeyKms) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Vendor) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Vendor)))
		i += copy(dAtA[i:], m.Vendor)
	}
	if len(m.KeyId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.KeyId)))
		i += copy(dAtA[i:], m.KeyId)
	}
	if len(m.Region) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *EncryptedContent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncryptedContent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Metadata) > 0 {
		for k, _ := range m.Metadata {
			dAtA[i] = 0xa
			i++
			v := m.Metadata[k]
			byteSize := 0
			if len(v) > 0 {
				byteSize = 1 + len(v) + sovEncryptionpb(uint64(len(v)))
			}
			mapSize := 1 + len(k) + sovEncryptionpb(uint64(len(k))) + byteSize
			i = encodeVarintEncryptionpb(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintEncryptionpb(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if len(v) > 0 {
				dAtA[i] = 0x12
				i++
				i = encodeVarintEncryptionpb(dAtA, i, uint64(len(v)))
				i += copy(dAtA[i:], v)
			}
		}
	}
	if len(m.Content) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Content)))
		i += copy(dAtA[i:], m.Content)
	}
	if m.MasterKey != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(m.MasterKey.Size()))
		n7, err := m.MasterKey.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if len(m.Iv) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.Iv)))
		i += copy(dAtA[i:], m.Iv)
	}
	if len(m.CiphertextKey) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintEncryptionpb(dAtA, i, uint64(len(m.CiphertextKey)))
		i += copy(dAtA[i:], m.CiphertextKey)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintEncryptionpb(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *EncryptionMeta) Size() (n int) {
	var l int
	_ = l
	if m.KeyId != 0 {
		n += 1 + sovEncryptionpb(uint64(m.KeyId))
	}
	l = len(m.Iv)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FileInfo) Size() (n int) {
	var l int
	_ = l
	if m.KeyId != 0 {
		n += 1 + sovEncryptionpb(uint64(m.KeyId))
	}
	l = len(m.Iv)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.Method != 0 {
		n += 1 + sovEncryptionpb(uint64(m.Method))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FileDictionary) Size() (n int) {
	var l int
	_ = l
	if len(m.Files) > 0 {
		for k, v := range m.Files {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovEncryptionpb(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovEncryptionpb(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovEncryptionpb(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DataKey) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.Method != 0 {
		n += 1 + sovEncryptionpb(uint64(m.Method))
	}
	if m.CreationTime != 0 {
		n += 1 + sovEncryptionpb(uint64(m.CreationTime))
	}
	if m.WasExposed {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *KeyDictionary) Size() (n int) {
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for k, v := range m.Keys {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovEncryptionpb(uint64(l))
			}
			mapEntrySize := 1 + sovEncryptionpb(uint64(k)) + l
			n += mapEntrySize + 1 + sovEncryptionpb(uint64(mapEntrySize))
		}
	}
	if m.CurrentKeyId != 0 {
		n += 1 + sovEncryptionpb(uint64(m.CurrentKeyId))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterKey) Size() (n int) {
	var l int
	_ = l
	if m.Backend != nil {
		n += m.Backend.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterKey_Plaintext) Size() (n int) {
	var l int
	_ = l
	if m.Plaintext != nil {
		l = m.Plaintext.Size()
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	return n
}
func (m *MasterKey_File) Size() (n int) {
	var l int
	_ = l
	if m.File != nil {
		l = m.File.Size()
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	return n
}
func (m *MasterKey_Kms) Size() (n int) {
	var l int
	_ = l
	if m.Kms != nil {
		l = m.Kms.Size()
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	return n
}
func (m *MasterKeyPlaintext) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterKeyFile) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MasterKeyKms) Size() (n int) {
	var l int
	_ = l
	l = len(m.Vendor)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.KeyId)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EncryptedContent) Size() (n int) {
	var l int
	_ = l
	if len(m.Metadata) > 0 {
		for k, v := range m.Metadata {
			_ = k
			_ = v
			l = 0
			if len(v) > 0 {
				l = 1 + len(v) + sovEncryptionpb(uint64(len(v)))
			}
			mapEntrySize := 1 + len(k) + sovEncryptionpb(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovEncryptionpb(uint64(mapEntrySize))
		}
	}
	l = len(m.Content)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.MasterKey != nil {
		l = m.MasterKey.Size()
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.Iv)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	l = len(m.CiphertextKey)
	if l > 0 {
		n += 1 + l + sovEncryptionpb(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovEncryptionpb(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozEncryptionpb(x uint64) (n int) {
	return sovEncryptionpb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *EncryptionMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptionMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptionMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyId", wireType)
			}
			m.KeyId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iv", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Iv = append(m.Iv[:0], dAtA[iNdEx:postIndex]...)
			if m.Iv == nil {
				m.Iv = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyId", wireType)
			}
			m.KeyId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iv", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Iv = append(m.Iv[:0], dAtA[iNdEx:postIndex]...)
			if m.Iv == nil {
				m.Iv = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= (EncryptionMethod(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FileDictionary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FileDictionary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FileDictionary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Files == nil {
				m.Files = make(map[string]*FileInfo)
			}
			var mapkey string
			var mapvalue *FileInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEncryptionpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &FileInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEncryptionpb(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Files[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= (EncryptionMethod(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreationTime", wireType)
			}
			m.CreationTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreationTime |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WasExposed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WasExposed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyDictionary) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyDictionary: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyDictionary: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Keys == nil {
				m.Keys = make(map[uint64]*DataKey)
			}
			var mapkey uint64
			var mapvalue *DataKey
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEncryptionpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &DataKey{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEncryptionpb(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Keys[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentKeyId", wireType)
			}
			m.CurrentKeyId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CurrentKeyId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MasterKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MasterKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MasterKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Plaintext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MasterKeyPlaintext{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &MasterKey_Plaintext{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field File", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MasterKeyFile{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &MasterKey_File{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kms", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MasterKeyKms{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &MasterKey_Kms{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MasterKeyPlaintext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MasterKeyPlaintext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MasterKeyPlaintext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MasterKeyFile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MasterKeyFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MasterKeyFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MasterKeyKms) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MasterKeyKms: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MasterKeyKms: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Vendor", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Vendor = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EncryptedContent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptedContent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptedContent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = make(map[string][]byte)
			}
			var mapkey string
			mapvalue := []byte{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowEncryptionpb
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapbyteLen uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowEncryptionpb
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapbyteLen |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intMapbyteLen := int(mapbyteLen)
					if intMapbyteLen < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					postbytesIndex := iNdEx + intMapbyteLen
					if postbytesIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = make([]byte, mapbyteLen)
					copy(mapvalue, dAtA[iNdEx:postbytesIndex])
					iNdEx = postbytesIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipEncryptionpb(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthEncryptionpb
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Metadata[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Content", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Content = append(m.Content[:0], dAtA[iNdEx:postIndex]...)
			if m.Content == nil {
				m.Content = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MasterKey", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MasterKey == nil {
				m.MasterKey = &MasterKey{}
			}
			if err := m.MasterKey.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iv", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Iv = append(m.Iv[:0], dAtA[iNdEx:postIndex]...)
			if m.Iv == nil {
				m.Iv = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CiphertextKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CiphertextKey = append(m.CiphertextKey[:0], dAtA[iNdEx:postIndex]...)
			if m.CiphertextKey == nil {
				m.CiphertextKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEncryptionpb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEncryptionpb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEncryptionpb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEncryptionpb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEncryptionpb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthEncryptionpb
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowEncryptionpb
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipEncryptionpb(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthEncryptionpb = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEncryptionpb   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("encryptionpb.proto", fileDescriptor_encryptionpb_d841ba3dd655e1a0) }

var fileDescriptor_encryptionpb_d841ba3dd655e1a0 = []byte{
	// 761 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x5b, 0x6f, 0xd3, 0x48,
	0x14, 0xce, 0x38, 0xce, 0xc5, 0x27, 0x97, 0x8d, 0x46, 0x6d, 0x37, 0xca, 0x4a, 0xd9, 0xc8, 0xdd,
	0xee, 0x46, 0xbb, 0x55, 0x56, 0x35, 0xa2, 0xb4, 0x20, 0x24, 0x7a, 0x09, 0x4a, 0x15, 0x1a, 0x2a,
	0x13, 0x04, 0x4f, 0x44, 0x6e, 0x3c, 0x4d, 0x2c, 0xc7, 0x17, 0xec, 0x69, 0x5a, 0xff, 0x13, 0x78,
	0x84, 0x27, 0xfe, 0x03, 0x2f, 0x3c, 0xf2, 0xc8, 0x23, 0x8f, 0xa8, 0xfc, 0x11, 0xe4, 0xf1, 0xc4,
	0xb1, 0xd5, 0x56, 0x82, 0x27, 0xcf, 0x39, 0xf3, 0x7d, 0xc7, 0x67, 0xbe, 0xf9, 0xe6, 0x00, 0x26,
	0xf6, 0xd8, 0x0b, 0x5c, 0x6a, 0x38, 0xb6, 0x7b, 0xda, 0x71, 0x3d, 0x87, 0x3a, 0xb8, 0x9c, 0xcc,
	0x35, 0x56, 0x26, 0xce, 0xc4, 0x61, 0x1b, 0xff, 0x87, 0xab, 0x08, 0xd3, 0xf8, 0xcd, 0x3b, 0xf7,
	0x29, 0x5b, 0x46, 0x09, 0xf9, 0x1e, 0x54, 0xbb, 0x31, 0xed, 0x98, 0x50, 0x0d, 0xaf, 0x42, 0xde,
	0x24, 0xc1, 0xc8, 0xd0, 0xeb, 0xa8, 0x85, 0xda, 0xa2, 0x9a, 0x33, 0x49, 0x70, 0xa4, 0xe3, 0x2a,
	0x08, 0xc6, 0xbc, 0x2e, 0xb4, 0x50, 0xbb, 0xac, 0x0a, 0xc6, 0x5c, 0x36, 0xa0, 0xf8, 0xd8, 0x98,
	0x91, 0x23, 0xfb, 0xcc, 0xf9, 0x49, 0x0a, 0xde, 0x86, 0xbc, 0x45, 0xe8, 0xd4, 0xd1, 0xeb, 0xd9,
	0x16, 0x6a, 0x57, 0x95, 0x66, 0x27, 0x75, 0x8a, 0x54, 0x1f, 0x53, 0x47, 0x57, 0x39, 0x5a, 0x7e,
	0x87, 0xa0, 0x1a, 0xfe, 0xeb, 0xd0, 0x18, 0x87, 0xbb, 0x9a, 0x17, 0xe0, 0x87, 0x90, 0x3b, 0x33,
	0x66, 0xc4, 0xaf, 0xa3, 0x56, 0xb6, 0x5d, 0x52, 0xfe, 0x49, 0x57, 0x4a, 0x83, 0x59, 0xe8, 0x77,
	0x6d, 0xea, 0x05, 0x6a, 0xc4, 0x6a, 0x9c, 0x00, 0x2c, 0x93, 0xb8, 0x06, 0x59, 0x93, 0x04, 0xac,
	0x77, 0x49, 0x0d, 0x97, 0x78, 0x13, 0x72, 0x73, 0x6d, 0x76, 0x4e, 0x58, 0xf3, 0x25, 0x65, 0xed,
	0x7a, 0xf9, 0xf0, 0xdc, 0x6a, 0x04, 0xba, 0x2f, 0xec, 0x20, 0xf9, 0x2d, 0x82, 0xc2, 0xa1, 0x46,
	0xb5, 0x3e, 0x49, 0xd5, 0x2b, 0x47, 0xf5, 0x96, 0x27, 0x17, 0x7e, 0xe5, 0xe4, 0x78, 0x1d, 0x2a,
	0x63, 0x8f, 0x68, 0xe1, 0xce, 0x88, 0x1a, 0x16, 0x61, 0xc2, 0x89, 0x6a, 0x79, 0x91, 0x1c, 0x1a,
	0x16, 0xc1, 0x7f, 0x42, 0xe9, 0x42, 0xf3, 0x47, 0xe4, 0xd2, 0x75, 0x7c, 0xa2, 0xd7, 0xc5, 0x16,
	0x6a, 0x17, 0x55, 0xb8, 0xd0, 0xfc, 0x6e, 0x94, 0x91, 0x3f, 0x21, 0xa8, 0xf4, 0x49, 0x90, 0x90,
	0x6f, 0x17, 0x44, 0x93, 0x04, 0x0b, 0xf5, 0x36, 0xd2, 0xdd, 0xa4, 0xa0, 0x61, 0xc4, 0xb5, 0x63,
	0x14, 0xfc, 0x17, 0x54, 0xc7, 0xe7, 0x9e, 0x47, 0x6c, 0x3a, 0xe2, 0x77, 0x2e, 0xf0, 0x9e, 0xa2,
	0x6c, 0x3f, 0xbc, 0xfa, 0xc6, 0x00, 0xa4, 0x98, 0x98, 0xd4, 0x43, 0x8c, 0xf4, 0xf8, 0x2f, 0xad,
	0xef, 0x6a, 0xba, 0x01, 0xae, 0x63, 0x52, 0xde, 0x8f, 0x08, 0xa4, 0x63, 0xcd, 0xa7, 0xc4, 0x0b,
	0x05, 0x7e, 0x04, 0x92, 0x3b, 0xd3, 0x0c, 0x9b, 0x92, 0x4b, 0xca, 0xca, 0x96, 0x94, 0x56, 0xba,
	0x44, 0x8c, 0x3d, 0x59, 0xe0, 0x7a, 0x19, 0x75, 0x49, 0xc2, 0x5b, 0x20, 0x86, 0x4e, 0xe0, 0xff,
	0xff, 0xe3, 0x16, 0x72, 0x78, 0xd1, 0xbd, 0x8c, 0xca, 0xa0, 0xb8, 0x03, 0x59, 0xd3, 0xf2, 0xd9,
	0x0d, 0x94, 0x94, 0xc6, 0x2d, 0x8c, 0xbe, 0xe5, 0xf7, 0x32, 0x6a, 0x08, 0xdc, 0x97, 0xa0, 0x70,
	0xaa, 0x8d, 0x4d, 0x62, 0xeb, 0xf2, 0x0a, 0xe0, 0xeb, 0x0d, 0xc9, 0xeb, 0x50, 0x49, 0xfd, 0x09,
	0x63, 0x10, 0x5d, 0x8d, 0x4e, 0xb9, 0x11, 0xd9, 0x5a, 0x7e, 0x0d, 0xe5, 0x64, 0x71, 0xbc, 0x06,
	0xf9, 0x39, 0xb1, 0x75, 0xc7, 0xe3, 0x28, 0x1e, 0x25, 0x9e, 0xa0, 0xc0, 0xf2, 0xfc, 0x09, 0xae,
	0x41, 0xde, 0x23, 0x13, 0xc3, 0xb1, 0x59, 0xdf, 0x92, 0xca, 0x23, 0xdc, 0x80, 0x22, 0xb1, 0x75,
	0xd7, 0x31, 0x6c, 0xca, 0x0c, 0x23, 0xa9, 0x71, 0x2c, 0xbf, 0x17, 0xa0, 0xc6, 0x1d, 0x49, 0xf4,
	0x03, 0xc7, 0xa6, 0xc4, 0xa6, 0xb8, 0x07, 0x45, 0x8b, 0x50, 0x4d, 0xd7, 0xa8, 0xc6, 0x5d, 0xb3,
	0x79, 0xa3, 0x87, 0x63, 0x46, 0xe7, 0x98, 0xc3, 0x23, 0xf3, 0xc4, 0x6c, 0x5c, 0x87, 0xc2, 0x38,
	0x82, 0xf0, 0xd1, 0xb0, 0x08, 0xf1, 0x36, 0x80, 0xc5, 0xce, 0x1a, 0x3a, 0x8b, 0x0b, 0xfd, 0xfb,
	0x2d, 0x42, 0xab, 0x92, 0x15, 0xdb, 0x21, 0x9a, 0x33, 0x62, 0x3c, 0x67, 0x36, 0xa0, 0x3a, 0x36,
	0xdc, 0x29, 0xf1, 0x42, 0x99, 0x59, 0xad, 0x1c, 0xdb, 0xab, 0x2c, 0xb3, 0x7d, 0x12, 0x34, 0x1e,
	0x40, 0x25, 0xd5, 0xe3, 0x0d, 0x73, 0x60, 0x25, 0xe9, 0xd3, 0x72, 0xc2, 0x90, 0xff, 0xbe, 0x8a,
	0x35, 0x8a, 0x5f, 0x2d, 0x2e, 0x41, 0xe1, 0xf9, 0xa0, 0x3f, 0x78, 0xfa, 0x62, 0x50, 0xcb, 0xe0,
	0x0a, 0x48, 0x27, 0x4f, 0xf6, 0x8e, 0x06, 0xc3, 0xee, 0xcb, 0x61, 0x0d, 0xe1, 0x2a, 0xc0, 0x5e,
	0xf7, 0xd9, 0x96, 0xb2, 0x33, 0x3a, 0x18, 0xaa, 0x35, 0x61, 0x11, 0xef, 0x2a, 0x2c, 0xce, 0xf2,
	0x58, 0xb9, 0xbb, 0xcd, 0x62, 0x71, 0xff, 0xef, 0xaf, 0x1f, 0x8a, 0xe8, 0xf3, 0x55, 0x13, 0x7d,
	0xb9, 0x6a, 0xa2, 0x6f, 0x57, 0x4d, 0xf4, 0xe6, 0x7b, 0x33, 0x03, 0x35, 0xc7, 0x9b, 0x74, 0xa8,
	0x61, 0xce, 0x3b, 0xe6, 0x9c, 0xcd, 0xef, 0xd3, 0x3c, 0xfb, 0xdc, 0xf9, 0x11, 0x00, 0x00, 0xff,
	0xff, 0xee, 0x30, 0x0c, 0x4a, 0x11, 0x06, 0x00, 0x00,
}
