//
// $Id$
//
//
// Original author: Darren Kessner <darren@proteowizard.org>
//
// Copyright 2007 Louis Warschaw Prostate Cancer Center
//   Cedars Sinai Medical Center, Los Angeles, California  90048
//
// Licensed under the Apache License, Version 2.0 (the "License"); 
// you may not use this file except in compliance with the License. 
// You may obtain a copy of the License at 
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software 
// distributed under the License is distributed on an "AS IS" BASIS, 
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
// See the License for the specific language governing permissions and 
// limitations under the License.
//


#include "PeakDetectorMatchedFilterTestData.hpp"


TestDatum testData_[] = 
{
	{158924.479167, 676.621975, 1552.547983, -2682.222457, 3099.148681},
	{158925.781250, 676.616432, -2267.116166, 8075.459330, 8387.661122},
	{158927.083333, 676.610888, 2637.143266, -376.670591, 2663.907907},
	{158928.385417, 676.605345, -2966.482326, -111.090462, 2968.561686},
	{158929.687500, 676.599802, -1439.020214, 1683.521757, 2214.729031},
	{158930.989583, 676.594259, -4288.122826, 4713.021168, 6371.857336},
	{158932.291667, 676.588716, 2263.600777, 4124.507542, 4704.832722},
	{158933.593750, 676.583173, -2447.772441, 4581.166781, 5194.100404},
	{158934.895833, 676.577630, -2805.671900, -754.146423, 2905.259306},
	{158936.197917, 676.572087, 1546.476836, 683.394126, 1690.744846},
	{158937.500000, 676.566545, 2765.248779, 4211.822244, 5038.456849},
	{158938.802083, 676.561002, 2772.005644, 2079.031908, 3465.023660},
	{158940.104167, 676.555460, -1641.998072, 185.384123, 1652.430011},
	{158941.406250, 676.549917, 93.476681, 3570.858000, 3572.081291},
	{158942.708333, 676.544375, -2702.870764, -399.328155, 2732.210340},
	{158944.010417, 676.538833, 2461.390082, -245.513190, 2473.604226},
	{158945.312500, 676.533291, 2568.927170, 4627.679964, 5292.901724},
	{158946.614583, 676.527749, -3064.934127, 7847.573230, 8424.857672},
	{158947.916667, 676.522207, 1334.379824, -2639.777793, 2957.870232},
	{158949.218750, 676.516665, 3992.413965, 4930.342261, 6344.103095},
	{158950.520833, 676.511123, 157.507439, 4044.274278, 4047.340241},
	{158951.822917, 676.505581, -3100.171374, 535.839254, 3146.138308},
	{158953.125000, 676.500040, -3402.530520, 525.014414, 3442.797420},
	{158954.427083, 676.494498, -3990.717812, 2521.419185, 4720.527869},
	{158955.729167, 676.488957, -1807.093183, -1589.934744, 2406.964533},
	{158957.031250, 676.483416, 427.970343, 1597.487085, 1653.820909},
	{158958.333333, 676.477875, 57.031399, -914.857266, 916.633186},
	{158959.635417, 676.472333, 1218.939556, -3320.167191, 3536.852247},
	{158960.937500, 676.466792, 1449.819410, 2187.650845, 2624.460429},
	{158962.239583, 676.461251, 3995.809997, -727.544462, 4061.504460},
	{158963.541667, 676.455711, -2228.772800, 2240.467627, 3160.241033},
	{158964.843750, 676.450170, -6821.385032, 2452.631049, 7248.909767},
	{158966.145833, 676.444629, -1262.062080, -2732.365017, 3009.754023},
	{158967.447917, 676.439089, -455.391586, -815.306337, 933.866115},
	{158968.750000, 676.433548, 632.360429, 468.784997, 787.171573},
	{158970.052083, 676.428008, 186.618176, -4034.913791, 4039.227110},
	{158971.354167, 676.422468, 1987.130221, -558.931046, 2064.240885},
	{158972.656250, 676.416927, -2341.237787, -5258.558214, 5756.199169},
	{158973.958333, 676.411387, -1662.030643, 6353.166513, 6566.968143},
	{158975.260417, 676.405847, 108.512081, 310.024898, 328.466603},
	{158976.562500, 676.400307, 3038.613063, 9437.883331, 9914.979129},
	{158977.864583, 676.394767, -3652.957382, -509.144776, 3688.268705},
	{158979.166667, 676.389228, 842.433735, 6427.511425, 6482.483915},
	{158980.468750, 676.383688, -7875.128773, 8216.996335, 11381.418276},
	{158981.770833, 676.378148, -5439.968005, 19698.313354, 20435.674711},
	{158983.072917, 676.372609, 16855.795546, 11971.275417, 20674.362834},
	{158984.375000, 676.367070, 7579.862497, -8411.025030, 11322.528761},
	{158985.677083, 676.361530, 1495.080128, -684.037850, 1644.132710},
	{158986.979167, 676.355991, -583.143160, -1294.620782, 1419.893980},
	{158988.281250, 676.350452, -3191.215007, -2123.965274, 3833.416454},
	{158989.583333, 676.344913, 6288.097808, 13471.747777, 14867.015915},
	{158990.885417, 676.339374, 281.171354, -2368.558610, 2385.189137},
	{158992.187500, 676.333835, 6727.998171, -637.150071, 6758.100295},
	{158993.489583, 676.328296, 90.481062, -2645.529419, 2647.076261},
	{158994.791667, 676.322758, -1910.952406, 462.415227, 1966.104508},
	{158996.093750, 676.317219, 2059.954130, -556.405563, 2133.775566},
	{158997.395833, 676.311681, -853.281447, -976.494563, 1296.777104},
	{158998.697917, 676.306142, 427.634375, -5805.819177, 5821.546828},
	{159000.000000, 676.300604, 1995.541301, 684.000628, 2109.512252},
	{159001.302083, 676.295066, 371.037816, 710.206471, 801.287897},
	{159002.604167, 676.289528, 230.993848, 2576.541884, 2586.875767},
	{159003.906250, 676.283990, 2991.913376, -3229.454358, 4402.376756},
	{159005.208333, 676.278452, 10.089849, 4874.712579, 4874.723021},
	{159006.510417, 676.272914, 671.270338, -3402.210367, 3467.800348},
	{159007.812500, 676.267376, -4667.111008, 394.130011, 4683.723265},
	{159009.114583, 676.261839, 2042.160737, 1476.737853, 2520.153797},
	{159010.416667, 676.256301, 1027.787493, -224.256592, 1051.968702},
	{159011.718750, 676.250763, 921.559699, 1753.042683, 1980.512794},
	{159013.020833, 676.245226, -2079.934743, 2446.940865, 3211.486903},
	{159014.322917, 676.239689, -2668.935351, 950.226079, 2833.045272},
	{159015.625000, 676.234152, -391.739889, 5028.884809, 5044.119602},
	{159016.927083, 676.228614, 267.066230, 3494.638846, 3504.828816},
	{159018.229167, 676.223077, 643.189814, 4288.823088, 4336.784133},
	{159019.531250, 676.217540, -1866.926347, -1788.491729, 2585.365864},
	{159020.833333, 676.212004, 1787.937165, 2285.628296, 2901.864231},
	{159022.135417, 676.206467, -1073.928213, 2224.735823, 2470.378775},
	{159023.437500, 676.200930, 588.943389, -2456.921213, 2526.522543},
	{159024.739583, 676.195394, 3023.425549, -1034.720299, 3195.582599},
	{159026.041667, 676.189857, 2176.762945, 5880.419895, 6270.377585},
	{159027.343750, 676.184321, 641.724507, -1220.473197, 1378.899985},
	{159028.645833, 676.178784, -444.786594, -2747.717675, 2783.484783},
	{159029.947917, 676.173248, -709.886620, 340.651628, 787.389703},
	{159031.250000, 676.167712, 3528.362712, -3680.032188, 5098.233059},
	{159032.552083, 676.162176, -233.347710, 1986.951261, 2000.606525},
	{159033.854167, 676.156640, -1867.005685, 1201.270154, 2220.081127},
	{159035.156250, 676.151104, -2138.743297, 2104.050522, 3000.208574},
	{159036.458333, 676.145569, 1129.120536, -373.835411, 1189.397368},
	{159037.760417, 676.140033, 1411.508988, -2314.103875, 2710.615127},
	{159039.062500, 676.134497, 459.005526, 342.158393, 572.501912},
	{159040.364583, 676.128962, 6649.260712, -1753.456769, 6876.574631},
	{159041.666667, 676.123426, -4340.430084, -256.547987, 4348.005311},
	{159042.968750, 676.117891, -395.890304, 320.711706, 509.494977},
	{159044.270833, 676.112356, -1369.574330, 2257.823209, 2640.738436},
	{159045.572917, 676.106821, 1465.305975, -2808.272431, 3167.572517},
	{159046.875000, 676.101286, 3357.053714, 93.570172, 3358.357488},
	{159048.177083, 676.095751, 1569.162340, -1683.677327, 2301.529880},
	{159049.479167, 676.090216, 1133.972086, -1496.256356, 1877.411988},
	{159050.781250, 676.084681, -3324.508009, 1612.518525, 3694.938362},
	{159052.083333, 676.079147, -1561.238172, 552.300996, 1656.049824},
	{159053.385417, 676.073612, 497.701663, -663.419031, 829.356230},
	{159054.687500, 676.068077, 891.910214, 3334.854884, 3452.066182},
	{159055.989583, 676.062543, -1779.677159, 1211.342366, 2152.812374},
	{159057.291667, 676.057009, 1656.064322, 869.604477, 1870.497524},
	{159058.593750, 676.051475, 2140.570945, 5954.845552, 6327.892976},
	{159059.895833, 676.045940, 1959.202585, -1749.406764, 2626.575488},
	{159061.197917, 676.040406, 5719.167019, -4067.657528, 7018.169929},
	{159062.500000, 676.034872, 2346.107840, 2731.616492, 3600.826385},
	{159063.802083, 676.029339, -589.045973, 2030.711877, 2114.418569},
	{159065.104167, 676.023805, 3019.165763, -3643.967824, 4732.215486},
	{159066.406250, 676.018271, 1875.484670, -1332.308318, 2300.540850},
	{159067.708333, 676.012738, -395.486642, -806.344388, 898.109657},
	{159069.010417, 676.007204, 639.592737, -3750.512656, 3804.658204},
	{159070.312500, 676.001671, 3374.705947, 4023.004262, 5251.019284},
	{159071.614583, 675.996137, -3720.138802, -1426.572017, 3984.286689},
	{159072.916667, 675.990604, 2905.031755, -2311.905988, 3712.696971},
	{159074.218750, 675.985071, -723.991388, 43.232600, 725.281040},
	{159075.520833, 675.979538, 2011.255325, 2387.881853, 3122.039033},
	{159076.822917, 675.974005, -788.267597, -853.484402, 1161.809550},
	{159078.125000, 675.968472, 2661.376320, 1226.661472, 2930.464517},
	{159079.427083, 675.962939, 728.053285, -2941.263977, 3030.032239},
	{159080.729167, 675.957407, 1850.278674, 102.167454, 1853.097234},
	{159082.031250, 675.951874, 1370.047440, -5141.024415, 5320.447539},
	{159083.333333, 675.946342, 865.889278, -1267.050352, 1534.659844},
	{159084.635417, 675.940809, 4339.020751, -3524.042993, 5589.810381},
	{159085.937500, 675.935277, 2367.898540, -2418.438207, 3384.639841},
	{159087.239583, 675.929745, -1774.361566, -6306.716212, 6551.566861},
	{159088.541667, 675.924213, 3742.813018, -1302.626339, 3963.014594},
	{159089.843750, 675.918681, 3464.434756, -5646.707620, 6624.772835},
	{159091.145833, 675.913149, 4275.161007, -3577.038735, 5574.245038},
	{159092.447917, 675.907617, 820.318085, -7627.831353, 7671.814186},
	{159093.750000, 675.902085, 4975.180414, -5661.637546, 7537.012661},
	{159095.052083, 675.896553, 5474.716606, -7742.121772, 9482.245064},
	{159096.354167, 675.891022, 6110.160151, -1859.085474, 6386.724972},
	{159097.656250, 675.885490, 10821.048334, -11266.123780, 15621.159754},
	{159098.958333, 675.879959, 28641.276321, -30905.514876, 42136.368603},
	{159100.260417, 675.874427, -84678.853342, -40217.694596, 93744.179350},
	{159101.562500, 675.868896, -56285.994110, 4998.112006, 56507.470803},
	{159102.864583, 675.863365, -18005.111729, 17583.779355, 25166.909718},
	{159104.166667, 675.857834, -7501.423711, 11341.664313, 13597.967020},
	{159105.468750, 675.852303, -6187.376492, 8297.369033, 10350.360415},
	{159106.770833, 675.846772, -4992.361000, 10888.878590, 11978.787305},
	{159108.072917, 675.841241, -8844.919803, 10622.088070, 13822.494756},
	{159109.375000, 675.835711, -3937.349522, 4689.713808, 6123.408924},
	{159110.677083, 675.830180, -3430.424072, 6209.074338, 7093.688283},
	{159111.979167, 675.824650, -5541.112901, 4662.864005, 7241.977141},
	{159113.281250, 675.819119, -2434.716269, 6077.530887, 6547.077592},
	{159114.583333, 675.813589, -3145.571507, 5518.571998, 6352.106501},
	{159115.885417, 675.808059, -1714.773982, 1972.806516, 2613.888934},
	{159117.187500, 675.802529, -5581.757849, 4031.096278, 6885.183940},
	{159118.489583, 675.796998, -2211.040419, 6795.404906, 7146.063781},
	{159119.791667, 675.791469, -1203.705045, 4841.569662, 4988.958071},
	{159121.093750, 675.785939, -4335.241713, 1049.150308, 4460.385306},
	{159122.395833, 675.780409, 4943.052879, 5312.172365, 7256.235043},
	{159123.697917, 675.774879, -1440.849153, 6557.797553, 6714.220358},
	{159125.000000, 675.769350, -640.387790, 4691.759996, 4735.262230},
	{159126.302083, 675.763820, -3954.283811, 4475.147649, 5971.876334},
	{159127.604167, 675.758291, -3690.752905, 7641.730382, 8486.324306},
	{159128.906250, 675.752761, -1200.793208, 4074.824688, 4248.070216},
	{159130.208333, 675.747232, -3462.686251, 973.835413, 3597.019806},
	{159131.510417, 675.741703, 3454.157540, 85.662417, 3455.219582},
	{159132.812500, 675.736174, -4904.355428, 4712.140154, 6801.247459},
	{159134.114583, 675.730645, -4188.123617, 5752.255884, 7115.393678},
	{159135.416667, 675.725116, 1760.812170, 6184.060635, 6429.857342},
	{159136.718750, 675.719587, 781.766563, 6340.400148, 6388.413966},
	{159138.020833, 675.714059, 1499.869462, 6369.819641, 6544.020986},
	{159139.322917, 675.708530, -2942.217750, 3860.610281, 4853.963023},
	{159140.625000, 675.703001, -6807.281153, 6453.963792, 9380.443770},
	{159141.927083, 675.697473, -629.052800, 3185.250377, 3246.771841},
	{159143.229167, 675.691945, 1624.110304, 2658.798529, 3115.596876},
	{159144.531250, 675.686416, 147.687087, 1255.038198, 1263.697889},
	{159145.833333, 675.680888, -6118.284961, 4702.102864, 7716.422889},
	{159147.135417, 675.675360, 1185.673543, 3408.352342, 3608.696085},
	{159148.437500, 675.669832, -5252.093269, 1350.906877, 5423.046478},
	{159149.739583, 675.664304, 813.367279, 735.779308, 1096.785084},
	{159151.041667, 675.658777, -1202.886100, 1500.271293, 1922.953178},
	{159152.343750, 675.653249, -3037.066664, 6633.504803, 7295.694613},
	{159153.645833, 675.647721, -4058.074852, 3654.688066, 5461.201000},
	{159154.947917, 675.642194, 1563.077856, 1260.102095, 2007.752393},
	{159156.250000, 675.636666, -5887.581550, 1610.692100, 6103.928698},
	{159157.552083, 675.631139, 767.861333, 1714.276245, 1878.391352},
	{159158.854167, 675.625612, 870.064588, 61.929656, 872.265826},
	{159160.156250, 675.620085, -2578.993837, -1755.504983, 3119.776748},
	{159161.458333, 675.614558, -6210.994979, 2935.083000, 6869.583018},
	{159162.760417, 675.609031, 895.058631, 5523.714674, 5595.762124},
	{159164.062500, 675.603504, 1735.383535, 6750.773795, 6970.258449},
	{159165.364583, 675.597977, -3627.940900, 4553.592212, 5822.126519},
	{159166.666667, 675.592450, 4086.802120, 31.520526, 4086.923673},
	{159167.968750, 675.586924, -4072.988175, 6367.422998, 7558.657837},
	{159169.270833, 675.581397, 106.220232, 2127.072071, 2129.722595},
	{159170.572917, 675.575871, -3300.432149, 2859.806769, 4367.075351},
	{159171.875000, 675.570344, -8688.687337, -1228.448340, 8775.099599},
	{159173.177083, 675.564818, -1782.111055, 752.812408, 1934.592033},
	{159174.479167, 675.559292, 53.870446, 3484.151425, 3484.567861},
	{159175.781250, 675.553766, -188.513038, 1072.991758, 1089.425756},
	{159177.083333, 675.548240, -1583.972480, 4180.451185, 4470.474352},
	{159178.385417, 675.542714, -2785.405137, 4231.601326, 5066.056806},
	{159179.687500, 675.537188, 656.560564, 4150.241225, 4201.853638},
	{159180.989583, 675.531662, -487.628122, 6740.784678, 6758.399164},
	{159182.291667, 675.526137, -767.033722, 1256.392951, 1472.027166},
	{159183.593750, 675.520611, -4311.453629, 6605.107654, 7887.717003},
	{159184.895833, 675.515086, -1871.469309, 8137.431442, 8349.861547},
	{159186.197917, 675.509560, -1239.425311, 4526.802799, 4693.412264},
	{159187.500000, 675.504035, -225.425146, 6784.393319, 6788.137388},
	{159188.802083, 675.498510, -3432.968781, -161.261639, 3436.754278},
	{159190.104167, 675.492985, -1909.941585, 8936.563229, 9138.382746},
	{159191.406250, 675.487460, -3430.958675, 9239.555367, 9856.006332},
	{159192.708333, 675.481935, 1010.657817, 9537.311164, 9590.710790},
	{159194.010417, 675.476410, -1658.679193, 5498.717861, 5743.441023},
	{159195.312500, 675.470886, -4773.350496, 7992.304522, 9309.232328},
	{159196.614583, 675.465361, -4021.448387, 1709.859543, 4369.858898},
	{159197.916667, 675.459836, -3107.202019, 9788.097869, 10269.448100},
	{159199.218750, 675.454312, -4228.733507, 9815.415781, 10687.589720},
	{159200.520833, 675.448788, -2651.270427, 12357.926989, 12639.129494},
	{159201.822917, 675.443263, 3851.298487, 9064.783009, 9848.999494},
	{159203.125000, 675.437739, -1924.542150, 11609.087830, 11767.530868},
	{159204.427083, 675.432215, -5825.604783, 12069.921888, 13402.264192},
	{159205.729167, 675.426691, -1600.976854, 16263.997288, 16342.604892},
	{159207.031250, 675.421167, -3599.867111, 12784.867078, 13282.013003},
	{159208.333333, 675.415643, -2938.354155, 16039.149887, 16306.080284},
	{159209.635417, 675.410120, -7267.016397, 20478.321397, 21729.500099},
	{159210.937500, 675.404596, -8427.080759, 23473.785595, 24940.615475},
	{159212.239583, 675.399072, -10474.948517, 22788.628444, 25080.792109},
	{159213.541667, 675.393549, -4489.906265, 36117.666086, 36395.673669},
	{159214.843750, 675.388026, -12436.337765, 49901.294539, 51427.635506},
	{159216.145833, 675.382502, -13427.643391, 79766.286267, 80888.577882},
	{159217.447917, 675.376979, -6343.080666, 233755.228014, 233841.273722},
	{159218.750000, 675.371456, 186155.668261, -40556.199418, 190522.277272},
	{159220.052083, 675.365933, 64189.621572, -91295.687307, 111602.912320},
	{159221.354167, 675.360410, 32424.211963, -52622.907172, 61810.192368},
	{159222.656250, 675.354887, 18946.522486, -37732.999752, 42222.624085},
	{159223.958333, 675.349365, 12784.366659, -34534.137266, 36824.538933},
	{159225.260417, 675.343842, 9098.126127, -27882.109594, 29328.960678},
	{159226.562500, 675.338319, 4195.754231, -22873.668287, 23255.301642},
	{159227.864583, 675.332797, 9319.097090, -16410.661245, 18872.079193},
	{159229.166667, 675.327275, 4467.122137, -18129.474846, 18671.717607},
	{159230.468750, 675.321752, -24.479607, -17886.409124, 17886.425876},
	{159231.770833, 675.316230, 4279.244923, -9310.987306, 10247.264110},
	{159233.072917, 675.310708, 1920.153196, -15702.715963, 15819.680051},
	{159234.375000, 675.305186, 2877.375034, -8318.654343, 8802.232510},
	{159235.677083, 675.299664, 3457.597124, -14376.066456, 14786.015847},
	{159236.979167, 675.294142, 4012.857036, -8963.765447, 9821.003645},
	{159238.281250, 675.288621, 3778.415246, -9591.893603, 10309.260142},
	{159239.583333, 675.283099, 3701.717212, -10664.411331, 11288.595101},
	{159240.885417, 675.277577, 1151.368415, -9719.520455, 9787.478077},
	{159242.187500, 675.272056, 2966.087089, -8103.541129, 8629.313498},
	{159243.489583, 675.266535, 1436.212500, -7982.315732, 8110.491402},
	{159244.791667, 675.261013, 2343.765434, -7666.413792, 8016.678667},
	{159246.093750, 675.255492, 1488.237202, -6059.628145, 6239.706982},
	{159247.395833, 675.249971, 1704.206576, -8349.027693, 8521.184393},
	{159248.697917, 675.244450, -85.107272, -12149.848748, 12150.146824},
	{159250.000000, 675.238929, 1632.378781, -2673.930787, 3132.820828},
	{159251.302083, 675.233408, 416.391576, -9485.246062, 9494.381222},
	{159252.604167, 675.227887, -4854.707157, -5884.444406, 7628.556059},
	{159253.906250, 675.222367, 1962.092267, -7319.054784, 7577.490943},
	{159255.208333, 675.216846, 2611.355820, -5796.919636, 6357.944360},
	{159256.510417, 675.211326, 629.767142, -3323.924640, 3383.058034},
	{159257.812500, 675.205805, 4347.692973, -3310.141103, 5464.381786},
	{159259.114583, 675.200285, 3732.282400, -2696.092226, 4604.220369},
	{159260.416667, 675.194765, 1470.871277, -7447.247763, 7591.110694},
	{159261.718750, 675.189245, 430.955976, -11183.078151, 11191.378824},
	{159263.020833, 675.183725, -1177.646709, -6366.481012, 6474.483164},
	{159264.322917, 675.178205, 1662.812113, -5041.883845, 5309.005258},
	{159265.625000, 675.172685, -2056.862302, -4255.986240, 4726.954771},
	{159266.927083, 675.167165, 3222.592947, -3993.875189, 5131.875323},
	{159268.229167, 675.161646, 343.662135, -5592.187310, 5602.737061},
	{159269.531250, 675.156126, 1665.777689, -6885.102869, 7083.745960},
	{159270.833333, 675.150607, -1076.962602, -3906.347238, 4052.085536},
	{159272.135417, 675.145087, 1180.640529, -6193.647436, 6305.170943},
	{159273.437500, 675.139568, 2714.383691, -6273.368245, 6835.424490},
	{159274.739583, 675.134049, 316.460424, -3462.245398, 3476.678069},
	{159276.041667, 675.128530, 1485.881866, -5327.106641, 5530.452973},
	{159277.343750, 675.123011, 1971.431973, -5872.258807, 6194.349645},
	{159278.645833, 675.117492, 2047.312724, -3882.807649, 4389.497082},
	{159279.947917, 675.111973, 193.293208, -8648.575640, 8650.735394},
	{159281.250000, 675.106454, 442.595552, -8246.945573, 8258.813601},
	{159282.552083, 675.100935, -740.978824, -4126.048160, 4192.054751},
	{159283.854167, 675.095417, 6216.864780, -6265.622693, 8826.518873},
	{159285.156250, 675.089898, -1097.916956, -7309.903843, 7391.895280},
	{159286.458333, 675.084380, -1448.970643, -6690.837424, 6845.934659},
	{159287.760417, 675.078862, 3712.870417, -9411.523403, 10117.419606},
	{159289.062500, 675.073343, 560.668359, -4795.552450, 4828.216266},
	{159290.364583, 675.067825, 2544.618706, -12069.870370, 12335.187680},
	{159291.666667, 675.062307, 3228.511729, -5598.378573, 6462.594729},
	{159292.968750, 675.056789, 8115.521285, -3562.990038, 8863.215203},
	{159294.270833, 675.051271, 2427.692111, -8242.402241, 8592.489959},
	{159295.572917, 675.045754, -423.122160, -8657.554595, 8667.888089},
	{159296.875000, 675.040236, 1421.960140, -9889.042938, 9990.752768},
	{159298.177083, 675.034718, 1321.828343, -3798.104906, 4021.545853},
	{159299.479167, 675.029201, -1376.640023, -9441.653413, 9541.486096},
	{159300.781250, 675.023684, -5289.218497, -15331.860702, 16218.562972},
	{159302.083333, 675.018166, -2331.869584, -11567.711796, 11800.405584},
	{159303.385417, 675.012649, -1056.435526, -13510.613120, 13551.853116},
	{159304.687500, 675.007132, -1731.216734, -12417.323890, 12537.425732},
	{159305.989583, 675.001615, -1115.927554, -12630.150288, 12679.352925},
	{159307.291667, 674.996098, -2184.059829, -11215.706017, 11426.380827},
	{159308.593750, 674.990581, 2547.786122, -12107.242043, 12372.409790},
	{159309.895833, 674.985064, 3388.769320, -14377.311591, 14771.284510},
	{159311.197917, 674.979548, 532.782648, -11016.397213, 11029.273091},
	{159312.500000, 674.974031, -3306.963338, -15289.013066, 15642.567790},
	{159313.802083, 674.968514, 2957.774203, -17201.439697, 17453.880826},
	{159315.104167, 674.962998, 1323.364878, -17794.044511, 17843.186786},
	{159316.406250, 674.957482, 2415.941356, -16071.043031, 16251.621357},
	{159317.708333, 674.951965, 5632.335146, -21132.168521, 21869.882158},
	{159319.010417, 674.946449, -805.629233, -17789.569736, 17807.802499},
	{159320.312500, 674.940933, 4050.437556, -22366.137429, 22729.939460},
	{159321.614583, 674.935417, -2050.155004, -29216.775303, 29288.617151},
	{159322.916667, 674.929901, 2646.775097, -25968.076926, 26102.613618},
	{159324.218750, 674.924386, -2594.470687, -29517.088164, 29630.892188},
	{159325.520833, 674.918870, 162.084295, -34808.531583, 34808.908950},
	{159326.822917, 674.913354, 1066.760777, -36977.019936, 36992.404382},
	{159328.125000, 674.907839, 2438.146470, -45765.562068, 45830.461808},
	{159329.427083, 674.902323, -4959.946379, -50662.135898, 50904.352288},
	{159330.729167, 674.896808, -4482.799904, -61652.462405, 61815.221552},
	{159332.031250, 674.891293, -8066.221272, -79942.851833, 80348.761564},
	{159333.333333, 674.885778, -10594.081744, -119636.552889, 120104.701637},
	{159334.635417, 674.880263, -25691.005049, -200410.834777, 202050.811522},
	{159335.937500, 674.874748, -213658.594544, -659934.363245, 693659.396832},
	{159337.239583, 674.869233, -195277.448404, 381806.735568, 428846.901796},
	{159338.541667, 674.863718, -3607.814104, 174096.698707, 174134.077145},
	{159339.843750, 674.858203, -20174.582827, 107351.229188, 109230.491166},
	{159341.145833, 674.852689, -6489.370161, 89465.967770, 89701.010664},
	{159342.447917, 674.847174, -10065.636758, 79291.198418, 79927.537119},
	{159343.750000, 674.841660, -3053.407326, 60874.219414, 60950.749672},
	{159345.052083, 674.836145, -568.638097, 51714.699568, 51717.825754},
	{159346.354167, 674.830631, -954.716555, 44697.791941, 44707.986849},
	{159347.656250, 674.825117, 2457.422718, 40989.867112, 41063.464689},
	{159348.958333, 674.819603, -1137.727536, 36115.555166, 36133.471310},
	{159350.260417, 674.814089, 777.406151, 28617.133272, 28627.690739},
	{159351.562500, 674.808575, 590.494564, 30001.331609, 30007.142186},
	{159352.864583, 674.803061, 175.131267, 27711.513633, 27712.067025},
	{159354.166667, 674.797548, -2963.681502, 24936.186581, 25111.686706},
	{159355.468750, 674.792034, 1870.842411, 26613.483305, 26679.159374},
	{159356.770833, 674.786520, 3266.462896, 26342.258937, 26544.008472},
	{159358.072917, 674.781007, 2869.948307, 23894.122544, 24065.861618},
	{159359.375000, 674.775494, 4622.374623, 18137.151438, 18716.907048},
	{159360.677083, 674.769980, 1027.487194, 19740.217964, 19766.940461},
	{159361.979167, 674.764467, -2276.143617, 22751.449918, 22865.023576},
	{159363.281250, 674.758954, 2568.704705, 20532.513668, 20692.567782},
	{159364.583333, 674.753441, -1651.158674, 20017.495251, 20085.478363},
	{159365.885417, 674.747928, 4164.543009, 17838.274643, 18317.954599},
	{159367.187500, 674.742416, -1679.470525, 14917.731736, 15011.973268},
	{159368.489583, 674.736903, -2000.857508, 19807.544813, 19908.346548},
	{159369.791667, 674.731390, -51.237545, 21050.681955, 21050.744311},
	{159371.093750, 674.725878, -473.687647, 19895.121748, 19900.760019},
	{159372.395833, 674.720365, 2666.925339, 20566.692748, 20738.884767},
	{159373.697917, 674.714853, -2243.690458, 18252.294125, 18389.681555},
	{159375.000000, 674.709341, 1946.285694, 20794.426279, 20885.310443},
	{159376.302083, 674.703828, 2510.830953, 17605.611176, 17783.751487},
	{159377.604167, 674.698316, 2140.181099, 13032.226928, 13206.790445},
	{159378.906250, 674.692804, -485.580520, 17249.702248, 17256.535460},
	{159380.208333, 674.687292, 258.969393, 16760.700024, 16762.700571},
	{159381.510417, 674.681781, -739.481390, 16072.127044, 16089.129884},
	{159382.812500, 674.676269, -1277.497733, 12950.309490, 13013.167037},
	{159384.114583, 674.670757, 3716.176611, 15534.955676, 15973.253158},
	{159385.416667, 674.665246, 1245.826083, 24235.335485, 24267.335426},
	{159386.718750, 674.659734, 1173.111379, 9968.588994, 10037.377987},
	{159388.020833, 674.654223, 2353.787670, 15302.046562, 15482.020068},
	{159389.322917, 674.648712, 3051.853397, 15779.747673, 16072.157471},
	{159390.625000, 674.643200, -86.058751, 13718.586820, 13718.856747},
	{159391.927083, 674.637689, -316.311728, 15412.776158, 15416.021601},
	{159393.229167, 674.632178, 2753.906724, 14500.974562, 14760.158044},
	{159394.531250, 674.626667, -762.264559, 13490.965482, 13512.483002},
	{159395.833333, 674.621157, 1038.288211, 12146.380049, 12190.676384},
	{159397.135417, 674.615646, 2089.210506, 9333.127557, 9564.103227},
	{159398.437500, 674.610135, 2069.171408, 18204.429241, 18321.646059},
	{159399.739583, 674.604625, 870.096511, 14824.452056, 14849.964535},
	{159401.041667, 674.599114, 272.972679, 16110.248282, 16112.560745},
	{159402.343750, 674.593604, -2183.150454, 16170.548981, 16317.254679},
	{159403.645833, 674.588094, 3815.840070, 17776.030456, 18180.976162},
	{159404.947917, 674.582583, -66.503788, 9233.706607, 9233.946093},
	{159406.250000, 674.577073, -2706.892541, 20304.237837, 20483.880037},
	{159407.552083, 674.571563, 1148.909600, 13902.286780, 13949.679960},
	{159408.854167, 674.566053, -1044.981140, 15580.827210, 15615.830498},
	{159410.156250, 674.560543, 1557.583388, 15674.443001, 15751.642118},
	{159411.458333, 674.555034, 1420.642527, 18389.776045, 18444.567986},
	{159412.760417, 674.549524, -1094.786294, 19843.799372, 19873.976213},
	{159414.062500, 674.544015, 4896.668391, 13128.510717, 14011.964708},
	{159415.364583, 674.538505, 108.289618, 17463.498595, 17463.834339},
	{159416.666667, 674.532996, 3186.277183, 19436.678440, 19696.112080},
	{159417.968750, 674.527486, 1081.737916, 21716.285126, 21743.210356},
	{159419.270833, 674.521977, 1328.018494, 20008.046953, 20052.071614},
	{159420.572917, 674.516468, 3325.989555, 19880.576638, 20156.873120},
	{159421.875000, 674.510959, -2644.088666, 19243.843652, 19424.642169},
	{159423.177083, 674.505450, 922.144370, 21196.913042, 21216.961912},
	{159424.479167, 674.499941, 2723.078015, 22766.318384, 22928.593647},
	{159425.781250, 674.494432, 1446.660903, 20234.297582, 20285.946525},
	{159427.083333, 674.488924, 1371.925129, 27403.440394, 27437.760915},
	{159428.385417, 674.483415, 3808.706272, 22703.076668, 23020.337392},
	{159429.687500, 674.477907, -1428.961239, 25113.191767, 25153.813447},
	{159430.989583, 674.472398, 7822.295405, 27516.223447, 28606.482800},
	{159432.291667, 674.466890, 4996.267312, 28721.847575, 29153.168185},
	{159433.593750, 674.461382, 1761.480415, 35031.878635, 35076.136246},
	{159434.895833, 674.455874, 1261.978898, 31675.732634, 31700.861638},
	{159436.197917, 674.450366, 1145.721734, 34949.097559, 34967.872375},
	{159437.500000, 674.444858, 3586.332328, 36847.600875, 37021.716192},
	{159438.802083, 674.439350, 1564.219364, 37959.416526, 37991.631779},
	{159440.104167, 674.433842, 158.173057, 41454.351337, 41454.653098},
	{159441.406250, 674.428334, 7524.639829, 42235.338989, 42900.397015},
	{159442.708333, 674.422827, 4877.101315, 44697.124217, 44962.417979},
	{159444.010417, 674.417319, 4080.603141, 50558.420708, 50722.827469},
	{159445.312500, 674.411812, 6577.789977, 58423.297650, 58792.423230},
	{159446.614583, 674.406305, 12831.995705, 62206.404665, 63516.115240},
	{159447.916667, 674.400797, 12432.574746, 78692.367571, 79668.423034},
	{159449.218750, 674.395290, 14863.217739, 97002.269609, 98134.374970},
	{159450.520833, 674.389783, 20799.473077, 118598.677810, 120408.739129},
	{159451.822917, 674.384276, 22593.311980, 165638.891700, 167172.665797},
	{159453.125000, 674.378769, 47599.335835, 277486.399768, 281539.337976},
	{159454.427083, 674.373263, 286144.990423, 833086.497152, 880858.710169},
	{159455.729167, 674.367756, 185071.679625, -646557.315691, 672523.523063},
	{159457.031250, 674.362249, -17704.581444, -233633.298854, 234303.159470},
	{159458.333333, 674.356743, 12582.540060, -142740.249764, 143293.751493},
	{159459.635417, 674.351236, -4281.026921, -119490.160741, 119566.825271},
	{159460.937500, 674.345730, -2407.375413, -104118.820903, 104146.648158},
	{159462.239583, 674.340224, -6020.466709, -71343.604496, 71597.178170},
	{159463.541667, 674.334718, -6861.637568, -64726.618339, 65089.301669},
	{159464.843750, 674.329212, 4448.264865, -50486.194871, 50681.781074},
	{159466.145833, 674.323706, -2683.225884, -43254.466923, 43337.611955},
	{159467.447917, 674.318200, -1409.582306, -46362.112562, 46383.535909},
	{159468.750000, 674.312694, -901.917142, -39197.029138, 39207.404247},
	{159470.052083, 674.307188, -726.541158, -34237.362550, 34245.070542},
	{159471.354167, 674.301683, 352.485137, -32437.557045, 32439.472142},
	{159472.656250, 674.296177, -2127.182747, -33974.198589, 34040.726729},
	{159473.958333, 674.290672, -3242.789607, -27050.131795, 27243.812409},
	{159475.260417, 674.285166, -1547.455150, -23083.704946, 23135.514938},
	{159476.562500, 674.279661, -935.286804, -20857.628785, 20878.588073},
	{159477.864583, 674.274156, -612.779078, -22032.472193, 22040.992018},
	{159479.166667, 674.268651, 452.453592, -23621.175919, 23625.508800},
	{159480.468750, 674.263146, -1525.529117, -17904.755700, 17969.627592},
	{159481.770833, 674.257641, -3100.586634, -19514.288390, 19759.076113},
	{159483.072917, 674.252136, 1008.758808, -15846.074869, 15878.151123},
	{159484.375000, 674.246632, -127.895811, -14624.515227, 14625.074460},
	{159485.677083, 674.241127, 165.146018, -16758.957650, 16759.771320},
	{159486.979167, 674.235622, -700.841593, -14797.912349, 14814.499277},
	{159488.281250, 674.230118, 511.814166, -12086.065759, 12096.897919},
	{159489.583333, 674.224614, -234.976704, -7792.639622, 7796.181522},
	{159490.885417, 674.219109, 232.878319, -17402.849940, 17404.408015},
	{159492.187500, 674.213605, -907.310367, -14336.829843, 14365.510853},
	{159493.489583, 674.208101, -56.307938, -11496.904200, 11497.042087},
	{159494.791667, 674.202597, -4488.884838, -13671.545783, 14389.623038},
	{159496.093750, 674.197093, -1537.873247, -13450.963807, 13538.592300},
	{159497.395833, 674.191590, -1269.353491, -9392.217590, 9477.605686},
	{159498.697917, 674.186086, -3329.717995, -8884.638460, 9488.088453},
	{159500.000000, 674.180582, -2548.554362, -9054.318285, 9406.158033},
	{159501.302083, 674.175079, 356.446580, -6484.250542, 6494.040288},
	{159502.604167, 674.169575, -2093.093433, -7514.297621, 7800.365944},
	{159503.906250, 674.164072, 76.349843, -10190.160149, 10190.446171},
	{159505.208333, 674.158569, 368.091387, -7901.348925, 7909.918211},
	{159506.510417, 674.153065, 1136.846862, -8966.137390, 9037.922354},
	{159507.812500, 674.147562, -3421.439131, -11906.911111, 12388.735930},
	{159509.114583, 674.142059, 4180.383572, -10307.527545, 11122.982105},
	{159510.416667, 674.136556, 1098.526119, -7472.453313, 7552.768906},
	{159511.718750, 674.131054, -369.327262, -8346.637434, 8354.804551},
	{159513.020833, 674.125551, 1233.861802, -6290.960060, 6410.818467},
	{159514.322917, 674.120048, -2639.342820, -6260.011947, 6793.664703},
	{159515.625000, 674.114546, 3864.767793, -6636.383515, 7679.714595},
	{159516.927083, 674.109043, -3769.148438, -6986.464212, 7938.334972},
	{159518.229167, 674.103541, -635.477924, -8819.456939, 8842.321691},
	{159519.531250, 674.098039, -1044.541484, -7989.777441, 8057.767090},
	{159520.833333, 674.092536, -1079.298437, -8769.949667, 8836.113528},
	{159522.135417, 674.087034, -215.466848, -4330.371898, 4335.729089},
	{159523.437500, 674.081532, -961.581268, -6154.600524, 6229.265297},
	{159524.739583, 674.076030, -3940.764238, -10223.271770, 10956.500740},
	{159526.041667, 674.070528, -376.770403, -6940.595355, 6950.814327},
	{159527.343750, 674.065027, -2650.722101, -3603.928142, 4473.770860},
	{159528.645833, 674.059525, -399.944733, -5303.995691, 5319.053119},
	{159529.947917, 674.054023, 1449.245652, -5796.593595, 5975.015504},
	{159531.250000, 674.048522, -891.474849, -3515.267543, 3626.545643},
	{159532.552083, 674.043021, 2034.532694, -5561.745413, 5922.190078},
	{159533.854167, 674.037519, -327.464439, -1401.321585, 1439.074405},
	{159535.156250, 674.032018, -2604.135031, -8559.828372, 8947.188442},
	{159536.458333, 674.026517, -854.079618, -2473.551958, 2616.851407},
	{159537.760417, 674.021016, 877.477740, -2005.068660, 2188.667978},
	{159539.062500, 674.015515, 447.877941, -4758.213608, 4779.245902},
	{159540.364583, 674.010014, 3182.238834, -4033.452087, 5137.643403},
	{159541.666667, 674.004513, 125.690950, -6004.211682, 6005.527133},
	{159542.968750, 673.999013, 472.321287, -3782.142445, 3811.520546},
	{159544.270833, 673.993512, -2322.356411, -4523.148313, 5084.506855},
	{159545.572917, 673.988012, -1544.541889, -4125.527520, 4405.177291},
	{159546.875000, 673.982511, 2744.024998, -124.498868, 2746.847859},
	{159548.177083, 673.977011, 1214.952943, -4915.178682, 5063.110914},
	{159549.479167, 673.971511, -1851.299452, -3969.540991, 4380.018874},
	{159550.781250, 673.966011, 1929.802295, -6993.515114, 7254.887356},
	{159552.083333, 673.960511, -2383.743053, -4257.875278, 4879.726717},
	{159553.385417, 673.955011, -1565.992999, -2133.806117, 2646.783448},

/*
    // original data 
	{159554.687500, 673.949511, 335.881485, -1297.322869, 1340.098130},
	{159555.989583, 673.944011, 309.204915, -4467.843686, 4478.530437},
	{159557.291667, 673.938511, 838.688853, -3988.710243, 4075.930372},
	{159558.593750, 673.933012, 2048.608531, -1501.838855, 2540.141110},
	{159559.895833, 673.927512, -2828.295503, 222.822320, 2837.059259},
	{159561.197917, 673.922013, -704.390913, -2799.147518, 2886.415318},
	{159562.500000, 673.916514, -3114.714576, -4921.409029, 5824.235033},
	{159563.802083, 673.911014, 2186.784077, -1939.786003, 2923.148018},
	{159565.104167, 673.905515, -2875.736581, -1628.718419, 3304.933369},
	{159566.406250, 673.900016, -1778.128652, -4624.060459, 4954.157510},
*/
    // zeroes to mark hole
	{159554.687500, 673.949511, 0, 0, 0},
	{159555.989583, 673.944011, 0, 0, 0},
    // ...
    // hole added here (6 entries removed)
    // ...
	{159565.104167, 673.905515, 0, 0, 0}, 
	{159566.406250, 673.900016, 0, 0, 0},
    // zeroes to mark hole

	{159567.708333, 673.894517, 799.193453, -3489.320834, 3579.674574},
	{159569.010417, 673.889018, -3150.952047, -863.600811, 3267.155516},
	{159570.312500, 673.883520, -1998.770790, -5792.065542, 6127.243092},
	{159571.614583, 673.878021, -879.658616, -448.552976, 987.420404},
	{159572.916667, 673.872522, -2396.033737, -2984.724288, 3827.473937},
	{159574.218750, 673.867024, -3262.600456, 615.228843, 3320.100641},
	{159575.520833, 673.861525, -2021.925379, -2605.136607, 3297.714205},
};


const unsigned int testDataSize_ = sizeof(testData_)/sizeof(TestDatum);



