# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicefabricmanagedclusters import ServiceFabricManagedClustersManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceFabricManagedClustersManagementManagedClustersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceFabricManagedClustersManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_get(self, resource_group):
        response = self.client.managed_clusters.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_begin_create_or_update(self, resource_group):
        response = self.client.managed_clusters.begin_create_or_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={
                "location": "str",
                "sku": {"name": "str"},
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "adminUserName": "str",
                    "dnsName": "str",
                    "VMImage": "str",
                    "addonFeatures": ["str"],
                    "adminPassword": "str",
                    "allocatedOutboundPorts": 0,
                    "allowRdpAccess": bool,
                    "applicationTypeVersionsCleanupPolicy": {"maxUnusedVersionsToKeep": 0},
                    "autoGeneratedDomainNameLabelScope": "str",
                    "auxiliarySubnets": [
                        {
                            "name": "str",
                            "enableIpv6": bool,
                            "networkSecurityGroupId": "str",
                            "privateEndpointNetworkPolicies": "str",
                            "privateLinkServiceNetworkPolicies": "str",
                        }
                    ],
                    "azureActiveDirectory": {
                        "clientApplication": "str",
                        "clusterApplication": "str",
                        "tenantId": "str",
                    },
                    "clientConnectionPort": 0,
                    "clients": [{"isAdmin": bool, "commonName": "str", "issuerThumbprint": "str", "thumbprint": "str"}],
                    "clusterCertificateThumbprints": ["str"],
                    "clusterCodeVersion": "str",
                    "clusterId": "str",
                    "clusterState": "str",
                    "clusterUpgradeCadence": "str",
                    "clusterUpgradeMode": "str",
                    "ddosProtectionPlanId": "str",
                    "enableAutoOSUpgrade": bool,
                    "enableHttpGatewayExclusiveAuthMode": bool,
                    "enableIpv6": bool,
                    "enableServicePublicIP": bool,
                    "fabricSettings": [{"name": "str", "parameters": [{"name": "str", "value": "str"}]}],
                    "fqdn": "str",
                    "httpGatewayConnectionPort": 0,
                    "httpGatewayTokenAuthConnectionPort": 0,
                    "ipTags": [{"ipTagType": "str", "tag": "str"}],
                    "ipv4Address": "str",
                    "ipv6Address": "str",
                    "loadBalancingRules": [
                        {
                            "backendPort": 0,
                            "frontendPort": 0,
                            "probeProtocol": "str",
                            "protocol": "str",
                            "loadDistribution": "str",
                            "probePort": 0,
                            "probeRequestPath": "str",
                        }
                    ],
                    "networkSecurityRules": [
                        {
                            "access": "str",
                            "direction": "str",
                            "name": "str",
                            "priority": 0,
                            "protocol": "str",
                            "description": "str",
                            "destinationAddressPrefix": "str",
                            "destinationAddressPrefixes": ["str"],
                            "destinationPortRange": "str",
                            "destinationPortRanges": ["str"],
                            "sourceAddressPrefix": "str",
                            "sourceAddressPrefixes": ["str"],
                            "sourcePortRange": "str",
                            "sourcePortRanges": ["str"],
                        }
                    ],
                    "provisioningState": "str",
                    "publicIPPrefixId": "str",
                    "publicIPv6PrefixId": "str",
                    "serviceEndpoints": [{"service": "str", "locations": ["str"]}],
                    "subnetId": "str",
                    "upgradeDescription": {
                        "deltaHealthPolicy": {
                            "maxPercentDeltaUnhealthyNodes": 0,
                            "maxPercentDeltaUnhealthyApplications": 0,
                            "maxPercentUpgradeDomainDeltaUnhealthyNodes": 0,
                        },
                        "forceRestart": bool,
                        "healthPolicy": {"maxPercentUnhealthyApplications": 0, "maxPercentUnhealthyNodes": 0},
                        "monitoringPolicy": {
                            "healthCheckRetryTimeout": "str",
                            "healthCheckStableDuration": "1 day, 0:00:00",
                            "healthCheckWaitDuration": "1 day, 0:00:00",
                            "upgradeDomainTimeout": "str",
                            "upgradeTimeout": "str",
                        },
                        "upgradeReplicaSetCheckTimeout": "str",
                    },
                    "useCustomVnet": bool,
                    "zonalResiliency": bool,
                    "zonalUpdateMode": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_update(self, resource_group):
        response = self.client.managed_clusters.update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={"tags": {"str": "str"}},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_begin_delete(self, resource_group):
        response = self.client.managed_clusters.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_list_by_resource_group(self, resource_group):
        response = self.client.managed_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_list_by_subscription(self, resource_group):
        response = self.client.managed_clusters.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_get_fault_simulation(self, resource_group):
        response = self.client.managed_clusters.get_fault_simulation(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={"simulationId": "str"},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_list_fault_simulation(self, resource_group):
        response = self.client.managed_clusters.list_fault_simulation(
            resource_group_name=resource_group.name,
            cluster_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_begin_start_fault_simulation(self, resource_group):
        response = self.client.managed_clusters.begin_start_fault_simulation(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={"parameters": "fault_simulation_content"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_clusters_begin_stop_fault_simulation(self, resource_group):
        response = self.client.managed_clusters.begin_stop_fault_simulation(
            resource_group_name=resource_group.name,
            cluster_name="str",
            parameters={"simulationId": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
