# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.applicationinsights import ApplicationInsightsManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApplicationInsightsManagementComponentLinkedStorageAccountsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApplicationInsightsManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_component_linked_storage_accounts_get(self, resource_group):
        response = self.client.component_linked_storage_accounts.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            storage_type="str",
            api_version="2020-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_component_linked_storage_accounts_create_and_update(self, resource_group):
        response = self.client.component_linked_storage_accounts.create_and_update(
            resource_group_name=resource_group.name,
            resource_name="str",
            storage_type="str",
            linked_storage_accounts_properties={
                "id": "str",
                "linkedStorageAccount": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2020-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_component_linked_storage_accounts_update(self, resource_group):
        response = self.client.component_linked_storage_accounts.update(
            resource_group_name=resource_group.name,
            resource_name="str",
            storage_type="str",
            linked_storage_accounts_properties={"linkedStorageAccount": "str"},
            api_version="2020-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_component_linked_storage_accounts_delete(self, resource_group):
        response = self.client.component_linked_storage_accounts.delete(
            resource_group_name=resource_group.name,
            resource_name="str",
            storage_type="str",
            api_version="2020-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...
