% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar_widen}
\alias{calendar_widen}
\title{Widen a calendar to a more precise precision}
\usage{
calendar_widen(x, precision)
}
\arguments{
\item{x}{\verb{[calendar]}

A calendar vector.}

\item{precision}{\verb{[character(1)]}

A precision. Allowed precisions are dependent on the calendar used.}
}
\value{
\code{x} widened to the supplied \code{precision}.
}
\description{
\code{calendar_widen()} widens \code{x} to the specified \code{precision}. It does so
by setting new components to their smallest value.

Each calendar has its own help page describing the precisions that you
can widen to:
\itemize{
\item \link[=year-month-day-widen]{year-month-day}
\item \link[=year-month-weekday-widen]{year-month-weekday}
\item \link[=year-week-day-widen]{year-week-day}
\item \link[=iso-year-week-day-widen]{iso-year-week-day}
\item \link[=year-quarter-day-widen]{year-quarter-day}
\item \link[=year-day-widen]{year-day}
}
}
\details{
A subsecond precision \code{x} cannot be widened. You cannot widen from, say,
\code{"millisecond"} to \code{"nanosecond"} precision. clock operates under the
philosophy that once you have set the subsecond precision of a calendar,
it is "locked in" at that precision. If you expected this to multiply
the milliseconds by 1e6 to get to nanosecond precision, you probably
want to convert to a time point first, and use \code{\link[=time_point_cast]{time_point_cast()}}.

Generally, clock treats calendars at a specific precision as a \emph{range} of
values. For example, a month precision year-month-day is treated as a range
over \verb{[yyyy-mm-01, yyyy-mm-last]}, with no assumption about the day of the
month. However, occasionally it is useful to quickly widen a calendar,
assuming that you want the beginning of this range to be used for each
component. This is where \code{calendar_widen()} can come in handy.
}
\examples{
# Month precision
x <- year_month_day(2019, 1)
x

# Widen to day precision
calendar_widen(x, "day")

# Or second precision
calendar_widen(x, "second")
}
