// Copyright (c) 2024 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCRAND_RNG_CONFIG_THREEFRY2_32_20_CONFIG_HPP_
#define ROCRAND_RNG_CONFIG_THREEFRY2_32_20_CONFIG_HPP_

#include "config_defaults.hpp"
#include <rocrand/rocrand.h>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/config-tuning/select_best_config.py`.
 */

namespace rocrand_impl::host
{

template<class T>
struct generator_config_selector<ROCRAND_RNG_PSEUDO_THREEFRY2_32_20, T>
{
    __host__ __device__ static constexpr unsigned int get_threads(const target_arch arch)
    {
        switch(arch)
        {
            case target_arch::gfx1102: return 1024;
            case target_arch::gfx1101: return 256;
            case target_arch::gfx1100: return 1024;
            case target_arch::gfx1030: return 256;
            case target_arch::gfx942: return 256;
            case target_arch::gfx90a: return 512;
            case target_arch::gfx908: return 512;
            case target_arch::gfx906: return 256;
            default:
                return generator_config_defaults<ROCRAND_RNG_PSEUDO_THREEFRY2_32_20, T>::threads;
        }
    }

    __host__ __device__ static constexpr unsigned int get_blocks(const target_arch arch)
    {
        switch(arch)
        {
            case target_arch::gfx1102: return 128;
            case target_arch::gfx1101: return 2048;
            case target_arch::gfx1100: return 2048;
            case target_arch::gfx1030: return 2304;
            case target_arch::gfx942: return 2048;
            case target_arch::gfx90a: return 2048;
            case target_arch::gfx908: return 1200;
            case target_arch::gfx906: return 896;
            default:
                return generator_config_defaults<ROCRAND_RNG_PSEUDO_THREEFRY2_32_20, T>::blocks;
        }
    }
};

} // end namespace rocrand_impl::host

#endif // ROCRAND_RNG_CONFIG_THREEFRY2_32_20_HPP_
