#!/usr/bin/perl

use strict;
use warnings;
use NGCP::Rtpengine::Test;
use NGCP::Rtpclient::SRTP;
use NGCP::Rtpengine::AutoTest;
use Test::More;
use POSIX;


autotest_start(qw(--config-file=none -t -1 -i 203.0.113.1 -i 2001:db8:4321::1
			-n 2223 -c 12345 -f -L 7 -E -u 2222 --silence-detect=1 --dtx-delay=10
			--dtx-shift=0))
		or die;


my $amr_tests = $ENV{RTPENGINE_EXTENDED_TESTS};
#my $amr_tests = 0;



my ($sock_a, $sock_b, $sock_c, $sock_d, $port_a, $port_b, $ssrc, $ssrc_b, $resp,
	$sock_ax, $sock_bx, $port_ax, $port_bx,
	$srtp_ctx_a, $srtp_ctx_b, $srtp_ctx_a_rev, $srtp_ctx_b_rev,
	@ret1, @ret2, @ret3, @ret4, $srtp_key_a, $srtp_key_b, $ts, $seq);




if ($amr_tests) {

($sock_a, $sock_b) = new_call([qw(198.51.100.10 5210)], [qw(198.51.100.10 5212)]);

($port_a) = offer('packet loss',
	{ codec => { transcode => ['L16/16000/1'], } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5210 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 8 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:96 L16/16000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('packet loss', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5212 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 L16/16000
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

# start @ 0 ms
snd($sock_a, $port_b,  rtp(8, 2000, 4000, 0x5678, "\x20" x 160));
# consumed by resampler @ 10 ms
Time::HiRes::usleep(20000);
# RTP in @ 20 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 1, 4000 + 160*1, 0x5678, "\x20" x 160));
# RTP out @ 30 ms
($seq) = rcv($sock_b, $port_a, rtpm(96, -1, 4000, 0x5678, "\xaa\x00" x 320));
# RTP in @ 30 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 2, 4000 + 160*2, 0x5678, "\x20" x 160));
# RTP out @ 50 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 1, 4000 + 320*1, 0x5678, "\xaa\x00" x 320));
# no RTP in @ 50 ms, DTX
# RTP out w/ some silence @ 70 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 2, 4000 + 320*2, 0x5678, "\xaa\x00" x 289 . "\xa9\xff\xaa\x00\xaa\x03\xaa\x00\xa9\xf8\xaa\x00\xaa\x11\xaa\x00\xa9\xe1\xaa\x00\xaa\x36\xaa\x00\xa9\xa8\xaa\x00\xaa\x8b\xaa\x00\xa9\x2e\xaa\x00\xab\x36\xaa\x00\xa8\x3d\xaa\x00\xac\x90\xaa\x00\xa6\x31\xaa\x00\xb0\x0f\xaa\x00\x9e\x7a\xaa\x00\xd5\x00"));
# no RTP in @ 70 ms, DTX
# silence RTP out @ 90 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 3, 4000 + 320*3, 0x5678, "\x00\x00\x0b\x86\x00\x00\xf9\xf1\x00\x00\x03\xcf\x00\x00\xfd\x71\x00\x00\x01\xc3\x00\x00\xfe\xca\x00\x00\x00\xd2\x00\x00\xff\x75\x00\x00\x00\x59\x00\x00\xff\xca\x00\x00\x00\x1f\x00\x00\xff\xf0\x00\x00\x00\x08\x00\x00\xff\xfd\x00\x00\x00\x01" . "\x00" x 580));
# RTP in @ 90 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 3, 4000 + 160*5, 0x5678, "\x90" x 160));
# remaining silence RTP out @ 110 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 4, 4000 + 320*4, 0x5678, "\x00" x 586 . "\xff\xff\x00\x00\x00\x02\x00\x00\xff\xfc\x00\x00\x00\x07\x00\x00\xff\xf5\x00\x00\x00\x11\x00\x00\xff\xe6\x00\x00\x00\x27\x00\x00\xff\xc8\x00\x00\x00\x52\x00\x00\xff\x86\x00\x00\x00\xc2\x00\x00\xfe\x8f\x00\x00\x05\x60"));
# RTP in @ 110 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 4, 4000 + 160*6, 0x5678, "\x90" x 160));
# RTP out @ 130 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 5, 4000 + 320*5, 0x5678, "\x0a\xc0\x0c\x31\x0a\xc0\x09\xfe\x0a\xc0\x0b\x3a\x0a\xc0\x0a\x6e\x0a\xc0\x0a\xf8\x0a\xc0\x0a\x99\x0a\xc0\x0a\xda\x0a\xc0\x0a\xaf\x0a\xc0\x0a\xcb\x0a\xc0\x0a\xb9\x0a\xc0\x0a\xc4\x0a\xc0\x0a\xbe\x0a\xc0\x0a\xc1" . "\x0a\xc0" x 294));
# lost RTP in packet @ 130, seq +5
# RTP out w/ some silence @ 150 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 6, 4000 + 320*6, 0x5678, "\x0a\xc0" x 293 . "\x0a\xc1\x0a\xc0\x0a\xbe\x0a\xc0\x0a\xc4\x0a\xc0\x0a\xb9\x0a\xc0\x0a\xcb\x0a\xc0\x0a\xaf\x0a\xc0\x0a\xda\x0a\xc0\x0a\x99\x0a\xc0\x0a\xf8\x0a\xc0\x0a\x6e\x0a\xc0\x0b\x3a\x0a\xc0\x09\xfe\x0a\xc0\x0c\x31\x0a\xc0\x05\x60"));
# resume RTP in @ 150
snd($sock_a, $port_b,  rtp(8,  2000 + 6, 4000 + 160*8, 0x5678, "\x90" x 160));
# sequencer waiting for seq +5, silence RTP out @ 170
rcv($sock_b, $port_a, rtpm(96, $seq + 7, 4000 + 320*7, 0x5678, "\x00\x00\xfe\x8f\x00\x00\x00\xc2\x00\x00\xff\x86\x00\x00\x00\x52\x00\x00\xff\xc8\x00\x00\x00\x27\x00\x00\xff\xe6\x00\x00\x00\x11\x00\x00\xff\xf5\x00\x00\x00\x07\x00\x00\xff\xfc\x00\x00\x00\x02\x00\x00\xff\xff" . "\x00" x 588));
# RTP in @ 170
snd($sock_a, $port_b,  rtp(8,  2000 + 7, 4000 + 160*9, 0x5678, "\xe0" x 160));
# silence RTP out @ 190, still waiting for seq +5
rcv($sock_b, $port_a, rtpm(96, $seq + 8, 4000 + 320*8, 0x5678, "\x00" x 586 . "\xff\xff\x00\x00\x00\x02\x00\x00\xff\xfc\x00\x00\x00\x07\x00\x00\xff\xf5\x00\x00\x00\x11\x00\x00\xff\xe6\x00\x00\x00\x27\x00\x00\xff\xc8\x00\x00\x00\x52\x00\x00\xff\x86\x00\x00\x00\xc2\x00\x00\xfe\x8f\x00\x00\x05\x60"));
# RTP in @ 190
snd($sock_a, $port_b,  rtp(8,  2000 + 8, 4000 + 160*10, 0x5678, "\xe0" x 160));
# silence RTP out @ 210, still waiting for seq +5
rcv($sock_b, $port_a, rtpm(96, $seq + 9, 4000 + 320*9, 0x5678, "\x0a\xc0\x0c\x31\x0a\xc0\x09\xfe\x0a\xc0\x0b\x3a\x0a\xc0\x0a\x6e\x0a\xc0\x0a\xf8\x0a\xc0\x0a\x99\x0a\xc0\x0a\xda\x0a\xc0\x0a\xaf\x0a\xc0\x0a\xcb\x0a\xc0\x0a\xb9\x0a\xc0\x0a\xc4\x0a\xc0\x0a\xbe\x0a\xc0\x0a\xc1" . "\x0a\xc0" x 267 . "\x0a\xc1\x0a\xc0\x0a\xbe\x0a\xc0\x0a\xc4\x0a\xc0\x0a\xb9\x0a\xc0\x0a\xcb\x0a\xc0\x0a\xaf\x0a\xc0\x0a\xda\x0a\xc0\x0a\x99\x0a\xc0\x0a\xf8\x0a\xc0\x0a\x6e\x0a\xc0\x0b\x3a\x0a\xc0\x09\xfe\x0a\xc0\x0c\x31\x0a\xc0\x05\x60"));
# RTP in @ 210
snd($sock_a, $port_b,  rtp(8,  2000 + 9, 4000 + 160*11, 0x5678, "\xe0" x 160));
# silence RTP out @ 230, still waiting for seq +5
rcv($sock_b, $port_a, rtpm(96, $seq + 10, 4000 + 320*10, 0x5678, "\x00\x00\xfe\x8f\x00\x00\x00\xc2\x00\x00\xff\x86\x00\x00\x00\x52\x00\x00\xff\xc8\x00\x00\x00\x27\x00\x00\xff\xe6\x00\x00\x00\x11\x00\x00\xff\xf5\x00\x00\x00\x07\x00\x00\xff\xfc\x00\x00\x00\x02\x00\x00\xff\xff" . "\x00" x 534 . "\xff\xff\x00\x00\x00\x01\x00\x00\xff\xfe\x00\x00\x00\x03\x00\x00\xff\xfa\x00\x00\x00\x09\x00\x00\xff\xf3\x00\x00\x00\x13\x00\x00\xff\xe4\x00\x00\x00\x29\x00\x00\xff\xc3\x00\x00\x00\x61\x00\x00\xff\x48\x00\x00\x02\xb0"));
# RTP in @ 230
snd($sock_a, $port_b,  rtp(8,  2000 + 10, 4000 + 160*12, 0x5678, "\xe0" x 160));
# partial silence RTP out @ 250, switching to decoding
rcv($sock_b, $port_a, rtpm(96, $seq + 11, 4000 + 320*11, 0x5678, "\x05\x60\x06\x18\x05\x60\x04\xff\x05\x60\x05\x9d\x05\x60\x05\x37\x05\x60\x05\x7c\x05\x60\x05\x4d\x05\x60\x05\x6d\x05\x60\x05\x57\x05\x60\x05\x66\x05\x60\x05\x5d\x05\x60\x05\x62\x05\x60\x05\x5f\x05\x60" . "\x05\x60" x 295));
# RTP in @ 250
snd($sock_a, $port_b,  rtp(8,  2000 + 11, 4000 + 160*13, 0x5678, "\xe0" x 160));
# RTP out @ 270
rcv($sock_b, $port_a, rtpm(96, $seq + 12, 4000 + 320*12, 0x5678, "\x05\x60" x 320));
# RTP in @ 270
snd($sock_a, $port_b,  rtp(8,  2000 + 12, 4000 + 160*14, 0x5678, "\xe0" x 160));
# RTP out @ 290
rcv($sock_b, $port_a, rtpm(96, $seq + 13, 4000 + 320*13, 0x5678, "\x05\x60" x 320));
# RTP in @ 290
snd($sock_a, $port_b,  rtp(8,  2000 + 13, 4000 + 160*15, 0x5678, "\xe0" x 160));
# RTP out @ 310
rcv($sock_b, $port_a, rtpm(96, $seq + 14, 4000 + 320*14, 0x5678, "\x05\x60" x 320));
# RTP in @ 310
snd($sock_a, $port_b,  rtp(8,  2000 + 14, 4000 + 160*16, 0x5678, "\xe0" x 160));
# RTP out @ 330
rcv($sock_b, $port_a, rtpm(96, $seq + 15, 4000 + 320*15, 0x5678, "\x05\x60" x 320));
# RTP in @ 330
snd($sock_a, $port_b,  rtp(8,  2000 + 15, 4000 + 160*17, 0x5678, "\xe0" x 160));
# RTP out @ 350
rcv($sock_b, $port_a, rtpm(96, $seq + 16, 4000 + 320*16, 0x5678, "\x05\x60" x 320));

rtpe_req('delete', 'delete');


($sock_a, $sock_b) = new_call([qw(198.51.100.10 5196)], [qw(198.51.100.10 5198)]);

($port_a) = offer('dtx-shift',
	{ codec => { transcode => ['L16/16000/1'], } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5196 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 8 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:96 L16/16000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('dtx-shift', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5198 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 L16/16000
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

# start @ 0 ms
snd($sock_a, $port_b,  rtp(8, 2000, 4000, 0x5678, "\x20" x 160));
# consumed by resampler @ 10 ms
# no RTP @ 20 ms
# DTX @ 30 ms
($seq) = rcv($sock_b, $port_a, rtpm(96, -1, 4000, 0x5678, "\xaa\x00" x 289 . "\xa9\xff\xaa\x00\xaa\x03\xaa\x00\xa9\xf8\xaa\x00\xaa\x11\xaa\x00\xa9\xe1\xaa\x00\xaa\x36\xaa\x00\xa9\xa8\xaa\x00\xaa\x8b\xaa\x00\xa9\x2e\xaa\x00\xab\x36\xaa\x00\xa8\x3d\xaa\x00\xac\x90\xaa\x00\xa6\x31\xaa\x00\xb0\x0f\xaa\x00\x9e\x7a\xaa\x00\xd5\x00"));
# RTP in @ 30 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 1, 4000 + 160*1, 0x5678, "\x20" x 160));
# RTP out @ 50 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 1, 4000 + 320*1, 0x5678, "\x00\x00\x0b\x86\x00\x00\xf9\xf1\x00\x00\x03\xcf\x00\x00\xfd\x71\x00\x00\x01\xc3\x00\x00\xfe\xca\x00\x00\x00\xd2\x00\x00\xff\x75\x00\x00\x00\x59\x00\x00\xff\xca\x00\x00\x00\x1f\x00\x00\xff\xf0\x00\x00\x00\x08\x00\x00\xff\xfd\x00\x00\x00\x01" . ("\x00" x 519) . "\x01\x00\x00\xff\xfd\x00\x00\x00\x08\x00\x00\xff\xf0\x00\x00\x00\x1f\x00\x00\xff\xca\x00\x00\x00\x59\x00\x00\xff\x75\x00\x00\x00\xd2\x00\x00\xfe\xca\x00\x00\x01\xc3\x00\x00\xfd\x71\x00\x00\x03\xcf\x00\x00\xf9\xf1\x00\x00\x0b\x86\x00\x00\xd5\x00"));
# RTP in @ 50 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 2, 4000 + 160*2, 0x5678, "\x20" x 160));
# RTP out @ 70 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 2, 4000 + 320*2, 0x5678, "\xaa\x00\x9e\x7a\xaa\x00\xb0\x0f\xaa\x00\xa6\x31\xaa\x00\xac\x90\xaa\x00\xa8\x3d\xaa\x00\xab\x36\xaa\x00\xa9\x2e\xaa\x00\xaa\x8b\xaa\x00\xa9\xa8\xaa\x00\xaa\x36\xaa\x00\xa9\xe1\xaa\x00\xaa\x11\xaa\x00\xa9\xf8\xaa\x00\xaa\x03\xaa\x00\xa9\xff" . "\xaa\x00" x 259 . "\xa9\xff\xaa\x00\xaa\x03\xaa\x00\xa9\xf8\xaa\x00\xaa\x11\xaa\x00\xa9\xe1\xaa\x00\xaa\x36\xaa\x00\xa9\xa8\xaa\x00\xaa\x8b\xaa\x00\xa9\x2e\xaa\x00\xab\x36\xaa\x00\xa8\x3d\xaa\x00\xac\x90\xaa\x00\xa6\x31\xaa\x00\xb0\x0f\xaa\x00\x9e\x7a\xaa\x00\xd5\x00"));
# RTP in @ 70 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 3, 4000 + 160*3, 0x5678, "\x20" x 160));
# DTX RTP out @ 90 ms (skipped TS +160)
rcv($sock_b, $port_a, rtpm(96, $seq + 3, 4000 + 320*3, 0x5678, "\x00\x00\x0b\x86\x00\x00\xf9\xf1\x00\x00\x03\xcf\x00\x00\xfd\x71\x00\x00\x01\xc3\x00\x00\xfe\xca\x00\x00\x00\xd2\x00\x00\xff\x75\x00\x00\x00\x59\x00\x00\xff\xca\x00\x00\x00\x1f\x00\x00\xff\xf0\x00\x00\x00\x08\x00\x00\xff\xfd\x00\x00\x00\x01" . ("\x00" x 519) . "\x01\x00\x00\xff\xfd\x00\x00\x00\x08\x00\x00\xff\xf0\x00\x00\x00\x1f\x00\x00\xff\xca\x00\x00\x00\x59\x00\x00\xff\x75\x00\x00\x00\xd2\x00\x00\xfe\xca\x00\x00\x01\xc3\x00\x00\xfd\x71\x00\x00\x03\xcf\x00\x00\xf9\xf1\x00\x00\x0b\x86\x00\x00\xd5\x00"));
# RTP in @ 90
snd($sock_a, $port_b,  rtp(8,  2000 + 4, 4000 + 160*4, 0x5678, "\x20" x 160));
# RTP out @ 110
rcv($sock_b, $port_a, rtpm(96, $seq + 4, 4000 + 320*4, 0x5678, "\xaa\x00\x9e\x7a\xaa\x00\xb0\x0f\xaa\x00\xa6\x31\xaa\x00\xac\x90\xaa\x00\xa8\x3d\xaa\x00\xab\x36\xaa\x00\xa9\x2e\xaa\x00\xaa\x8b\xaa\x00\xa9\xa8\xaa\x00\xaa\x36\xaa\x00\xa9\xe1\xaa\x00\xaa\x11\xaa\x00\xa9\xf8\xaa\x00\xaa\x03\xaa\x00\xa9\xff" . "\xaa\x00" x 290));
# RTP in @ 110
snd($sock_a, $port_b,  rtp(8,  2000 + 5, 4000 + 160*5, 0x5678, "\x20" x 160));
# RTP out @ 130
rcv($sock_b, $port_a, rtpm(96, $seq + 5, 4000 + 320*5, 0x5678, "\xaa\x00" x 320));

rtpe_req('delete', 'delete');




($sock_a, $sock_b) = new_call([qw(198.51.100.10 5272)], [qw(198.51.100.10 5274)]);

($port_a) = offer('packet loss w/ high TS',
	{ codec => { transcode => ['L16/16000/1'], } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5272 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 8 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:96 L16/16000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('packet loss w/ high TS', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5274 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 L16/16000
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

# start @ 0 ms
snd($sock_a, $port_b,  rtp(8, 2000, 3800000000, 0x5678, "\x20" x 160));
# consumed by resampler @ 10 ms
Time::HiRes::usleep(20000);
# RTP in @ 20 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 1, 3800000000 + 160*1, 0x5678, "\x20" x 160));
# RTP out @ 30 ms
($seq) = rcv($sock_b, $port_a, rtpm(96, -1, 3800000000, 0x5678, "\xaa\x00" x 320));
# RTP in @ 30 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 2, 3800000000 + 160*2, 0x5678, "\x20" x 160));
# RTP out @ 50 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 1, 3800000000 + 320*1, 0x5678, "\xaa\x00" x 320));
# no RTP in @ 50 ms, DTX
# RTP out w/ some silence @ 70 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 2, 3800000000 + 320*2, 0x5678, "\xaa\x00" x 289 . "\xa9\xff\xaa\x00\xaa\x03\xaa\x00\xa9\xf8\xaa\x00\xaa\x11\xaa\x00\xa9\xe1\xaa\x00\xaa\x36\xaa\x00\xa9\xa8\xaa\x00\xaa\x8b\xaa\x00\xa9\x2e\xaa\x00\xab\x36\xaa\x00\xa8\x3d\xaa\x00\xac\x90\xaa\x00\xa6\x31\xaa\x00\xb0\x0f\xaa\x00\x9e\x7a\xaa\x00\xd5\x00"));
# no RTP in @ 70 ms, DTX
# silence RTP out @ 90 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 3, 3800000000 + 320*3, 0x5678, "\x00\x00\x0b\x86\x00\x00\xf9\xf1\x00\x00\x03\xcf\x00\x00\xfd\x71\x00\x00\x01\xc3\x00\x00\xfe\xca\x00\x00\x00\xd2\x00\x00\xff\x75\x00\x00\x00\x59\x00\x00\xff\xca\x00\x00\x00\x1f\x00\x00\xff\xf0\x00\x00\x00\x08\x00\x00\xff\xfd\x00\x00\x00\x01" . "\x00" x 580));
# RTP in @ 90 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 3, 3800000000 + 160*5, 0x5678, "\x90" x 160));
# remaining silence RTP out @ 110 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 4, 3800000000 + 320*4, 0x5678, "\x00" x 586 . "\xff\xff\x00\x00\x00\x02\x00\x00\xff\xfc\x00\x00\x00\x07\x00\x00\xff\xf5\x00\x00\x00\x11\x00\x00\xff\xe6\x00\x00\x00\x27\x00\x00\xff\xc8\x00\x00\x00\x52\x00\x00\xff\x86\x00\x00\x00\xc2\x00\x00\xfe\x8f\x00\x00\x05\x60"));
# RTP in @ 110 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 4, 3800000000 + 160*6, 0x5678, "\x90" x 160));
# RTP out @ 130 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 5, 3800000000 + 320*5, 0x5678, "\x0a\xc0\x0c\x31\x0a\xc0\x09\xfe\x0a\xc0\x0b\x3a\x0a\xc0\x0a\x6e\x0a\xc0\x0a\xf8\x0a\xc0\x0a\x99\x0a\xc0\x0a\xda\x0a\xc0\x0a\xaf\x0a\xc0\x0a\xcb\x0a\xc0\x0a\xb9\x0a\xc0\x0a\xc4\x0a\xc0\x0a\xbe\x0a\xc0\x0a\xc1" . "\x0a\xc0" x 294));
# lost RTP in packet @ 130, seq +5
# RTP out w/ some silence @ 150 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 6, 3800000000 + 320*6, 0x5678, "\x0a\xc0" x 293 . "\x0a\xc1\x0a\xc0\x0a\xbe\x0a\xc0\x0a\xc4\x0a\xc0\x0a\xb9\x0a\xc0\x0a\xcb\x0a\xc0\x0a\xaf\x0a\xc0\x0a\xda\x0a\xc0\x0a\x99\x0a\xc0\x0a\xf8\x0a\xc0\x0a\x6e\x0a\xc0\x0b\x3a\x0a\xc0\x09\xfe\x0a\xc0\x0c\x31\x0a\xc0\x05\x60"));
# resume RTP in @ 150
snd($sock_a, $port_b,  rtp(8,  2000 + 6, 3800000000 + 160*8, 0x5678, "\x90" x 160));
# sequencer waiting for seq +5, silence RTP out @ 170
rcv($sock_b, $port_a, rtpm(96, $seq + 7, 3800000000 + 320*7, 0x5678, "\x00\x00\xfe\x8f\x00\x00\x00\xc2\x00\x00\xff\x86\x00\x00\x00\x52\x00\x00\xff\xc8\x00\x00\x00\x27\x00\x00\xff\xe6\x00\x00\x00\x11\x00\x00\xff\xf5\x00\x00\x00\x07\x00\x00\xff\xfc\x00\x00\x00\x02\x00\x00\xff\xff" . "\x00" x 588));
# RTP in @ 170
snd($sock_a, $port_b,  rtp(8,  2000 + 7, 3800000000 + 160*9, 0x5678, "\xe0" x 160));
# silence RTP out @ 190, still waiting for seq +5
rcv($sock_b, $port_a, rtpm(96, $seq + 8, 3800000000 + 320*8, 0x5678, "\x00" x 586 . "\xff\xff\x00\x00\x00\x02\x00\x00\xff\xfc\x00\x00\x00\x07\x00\x00\xff\xf5\x00\x00\x00\x11\x00\x00\xff\xe6\x00\x00\x00\x27\x00\x00\xff\xc8\x00\x00\x00\x52\x00\x00\xff\x86\x00\x00\x00\xc2\x00\x00\xfe\x8f\x00\x00\x05\x60"));
# RTP in @ 190
snd($sock_a, $port_b,  rtp(8,  2000 + 8, 3800000000 + 160*10, 0x5678, "\xe0" x 160));
# silence RTP out @ 210, still waiting for seq +5
rcv($sock_b, $port_a, rtpm(96, $seq + 9, 3800000000 + 320*9, 0x5678, "\x0a\xc0\x0c\x31\x0a\xc0\x09\xfe\x0a\xc0\x0b\x3a\x0a\xc0\x0a\x6e\x0a\xc0\x0a\xf8\x0a\xc0\x0a\x99\x0a\xc0\x0a\xda\x0a\xc0\x0a\xaf\x0a\xc0\x0a\xcb\x0a\xc0\x0a\xb9\x0a\xc0\x0a\xc4\x0a\xc0\x0a\xbe\x0a\xc0\x0a\xc1" . "\x0a\xc0" x 267 . "\x0a\xc1\x0a\xc0\x0a\xbe\x0a\xc0\x0a\xc4\x0a\xc0\x0a\xb9\x0a\xc0\x0a\xcb\x0a\xc0\x0a\xaf\x0a\xc0\x0a\xda\x0a\xc0\x0a\x99\x0a\xc0\x0a\xf8\x0a\xc0\x0a\x6e\x0a\xc0\x0b\x3a\x0a\xc0\x09\xfe\x0a\xc0\x0c\x31\x0a\xc0\x05\x60"));
# RTP in @ 210
snd($sock_a, $port_b,  rtp(8,  2000 + 9, 3800000000 + 160*11, 0x5678, "\xe0" x 160));
# silence RTP out @ 230, still waiting for seq +5
rcv($sock_b, $port_a, rtpm(96, $seq + 10, 3800000000 + 320*10, 0x5678, "\x00\x00\xfe\x8f\x00\x00\x00\xc2\x00\x00\xff\x86\x00\x00\x00\x52\x00\x00\xff\xc8\x00\x00\x00\x27\x00\x00\xff\xe6\x00\x00\x00\x11\x00\x00\xff\xf5\x00\x00\x00\x07\x00\x00\xff\xfc\x00\x00\x00\x02\x00\x00\xff\xff" . "\x00" x 534 . "\xff\xff\x00\x00\x00\x01\x00\x00\xff\xfe\x00\x00\x00\x03\x00\x00\xff\xfa\x00\x00\x00\x09\x00\x00\xff\xf3\x00\x00\x00\x13\x00\x00\xff\xe4\x00\x00\x00\x29\x00\x00\xff\xc3\x00\x00\x00\x61\x00\x00\xff\x48\x00\x00\x02\xb0"));
# RTP in @ 230
snd($sock_a, $port_b,  rtp(8,  2000 + 10, 3800000000 + 160*12, 0x5678, "\xe0" x 160));
# partial silence RTP out @ 250, switching to decoding
rcv($sock_b, $port_a, rtpm(96, $seq + 11, 3800000000 + 320*11, 0x5678, "\x05\x60\x06\x18\x05\x60\x04\xff\x05\x60\x05\x9d\x05\x60\x05\x37\x05\x60\x05\x7c\x05\x60\x05\x4d\x05\x60\x05\x6d\x05\x60\x05\x57\x05\x60\x05\x66\x05\x60\x05\x5d\x05\x60\x05\x62\x05\x60\x05\x5f\x05\x60" . "\x05\x60" x 295));
# RTP in @ 250
snd($sock_a, $port_b,  rtp(8,  2000 + 11, 3800000000 + 160*13, 0x5678, "\xe0" x 160));
# RTP out @ 270
rcv($sock_b, $port_a, rtpm(96, $seq + 12, 3800000000 + 320*12, 0x5678, "\x05\x60" x 320));
# RTP in @ 270
snd($sock_a, $port_b,  rtp(8,  2000 + 12, 3800000000 + 160*14, 0x5678, "\xe0" x 160));
# RTP out @ 290
rcv($sock_b, $port_a, rtpm(96, $seq + 13, 3800000000 + 320*13, 0x5678, "\x05\x60" x 320));
# RTP in @ 290
snd($sock_a, $port_b,  rtp(8,  2000 + 13, 3800000000 + 160*15, 0x5678, "\xe0" x 160));
# RTP out @ 310
rcv($sock_b, $port_a, rtpm(96, $seq + 14, 3800000000 + 320*14, 0x5678, "\x05\x60" x 320));
# RTP in @ 310
snd($sock_a, $port_b,  rtp(8,  2000 + 14, 3800000000 + 160*16, 0x5678, "\xe0" x 160));
# RTP out @ 330
rcv($sock_b, $port_a, rtpm(96, $seq + 15, 3800000000 + 320*15, 0x5678, "\x05\x60" x 320));
# RTP in @ 330
snd($sock_a, $port_b,  rtp(8,  2000 + 15, 3800000000 + 160*17, 0x5678, "\xe0" x 160));
# RTP out @ 350
rcv($sock_b, $port_a, rtpm(96, $seq + 16, 3800000000 + 320*16, 0x5678, "\x05\x60" x 320));

rtpe_req('delete', 'delete');


($sock_a, $sock_b) = new_call([qw(198.51.100.10 5258)], [qw(198.51.100.10 5260)]);

($port_a) = offer('dtx-shift w/ high TS',
	{ codec => { transcode => ['L16/16000/1'], } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5258 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 8 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:96 L16/16000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('dtx-shift w/ high TS', { }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5260 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 L16/16000
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

# start @ 0 ms
snd($sock_a, $port_b,  rtp(8, 2000, 3800000000, 0x5678, "\x20" x 160));
# consumed by resampler @ 10 ms
# no RTP @ 20 ms
# DTX @ 30 ms
($seq) = rcv($sock_b, $port_a, rtpm(96, -1, 3800000000, 0x5678, "\xaa\x00" x 289 . "\xa9\xff\xaa\x00\xaa\x03\xaa\x00\xa9\xf8\xaa\x00\xaa\x11\xaa\x00\xa9\xe1\xaa\x00\xaa\x36\xaa\x00\xa9\xa8\xaa\x00\xaa\x8b\xaa\x00\xa9\x2e\xaa\x00\xab\x36\xaa\x00\xa8\x3d\xaa\x00\xac\x90\xaa\x00\xa6\x31\xaa\x00\xb0\x0f\xaa\x00\x9e\x7a\xaa\x00\xd5\x00"));
# RTP in @ 30 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 1, 3800000000 + 160*1, 0x5678, "\x20" x 160));
# RTP out @ 50 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 1, 3800000000 + 320*1, 0x5678, "\x00\x00\x0b\x86\x00\x00\xf9\xf1\x00\x00\x03\xcf\x00\x00\xfd\x71\x00\x00\x01\xc3\x00\x00\xfe\xca\x00\x00\x00\xd2\x00\x00\xff\x75\x00\x00\x00\x59\x00\x00\xff\xca\x00\x00\x00\x1f\x00\x00\xff\xf0\x00\x00\x00\x08\x00\x00\xff\xfd\x00\x00\x00\x01" . ("\x00" x 519) . "\x01\x00\x00\xff\xfd\x00\x00\x00\x08\x00\x00\xff\xf0\x00\x00\x00\x1f\x00\x00\xff\xca\x00\x00\x00\x59\x00\x00\xff\x75\x00\x00\x00\xd2\x00\x00\xfe\xca\x00\x00\x01\xc3\x00\x00\xfd\x71\x00\x00\x03\xcf\x00\x00\xf9\xf1\x00\x00\x0b\x86\x00\x00\xd5\x00"));
# RTP in @ 50 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 2, 3800000000 + 160*2, 0x5678, "\x20" x 160));
# RTP out @ 70 ms
rcv($sock_b, $port_a, rtpm(96, $seq + 2, 3800000000 + 320*2, 0x5678, "\xaa\x00\x9e\x7a\xaa\x00\xb0\x0f\xaa\x00\xa6\x31\xaa\x00\xac\x90\xaa\x00\xa8\x3d\xaa\x00\xab\x36\xaa\x00\xa9\x2e\xaa\x00\xaa\x8b\xaa\x00\xa9\xa8\xaa\x00\xaa\x36\xaa\x00\xa9\xe1\xaa\x00\xaa\x11\xaa\x00\xa9\xf8\xaa\x00\xaa\x03\xaa\x00\xa9\xff" . "\xaa\x00" x 259 . "\xa9\xff\xaa\x00\xaa\x03\xaa\x00\xa9\xf8\xaa\x00\xaa\x11\xaa\x00\xa9\xe1\xaa\x00\xaa\x36\xaa\x00\xa9\xa8\xaa\x00\xaa\x8b\xaa\x00\xa9\x2e\xaa\x00\xab\x36\xaa\x00\xa8\x3d\xaa\x00\xac\x90\xaa\x00\xa6\x31\xaa\x00\xb0\x0f\xaa\x00\x9e\x7a\xaa\x00\xd5\x00"));
# RTP in @ 70 ms
snd($sock_a, $port_b,  rtp(8,  2000 + 3, 3800000000 + 160*3, 0x5678, "\x20" x 160));
# DTX RTP out @ 90 ms (skipped TS +160)
rcv($sock_b, $port_a, rtpm(96, $seq + 3, 3800000000 + 320*3, 0x5678, "\x00\x00\x0b\x86\x00\x00\xf9\xf1\x00\x00\x03\xcf\x00\x00\xfd\x71\x00\x00\x01\xc3\x00\x00\xfe\xca\x00\x00\x00\xd2\x00\x00\xff\x75\x00\x00\x00\x59\x00\x00\xff\xca\x00\x00\x00\x1f\x00\x00\xff\xf0\x00\x00\x00\x08\x00\x00\xff\xfd\x00\x00\x00\x01" . ("\x00" x 519) . "\x01\x00\x00\xff\xfd\x00\x00\x00\x08\x00\x00\xff\xf0\x00\x00\x00\x1f\x00\x00\xff\xca\x00\x00\x00\x59\x00\x00\xff\x75\x00\x00\x00\xd2\x00\x00\xfe\xca\x00\x00\x01\xc3\x00\x00\xfd\x71\x00\x00\x03\xcf\x00\x00\xf9\xf1\x00\x00\x0b\x86\x00\x00\xd5\x00"));
# RTP in @ 90
snd($sock_a, $port_b,  rtp(8,  2000 + 4, 3800000000 + 160*4, 0x5678, "\x20" x 160));
# RTP out @ 110
rcv($sock_b, $port_a, rtpm(96, $seq + 4, 3800000000 + 320*4, 0x5678, "\xaa\x00\x9e\x7a\xaa\x00\xb0\x0f\xaa\x00\xa6\x31\xaa\x00\xac\x90\xaa\x00\xa8\x3d\xaa\x00\xab\x36\xaa\x00\xa9\x2e\xaa\x00\xaa\x8b\xaa\x00\xa9\xa8\xaa\x00\xaa\x36\xaa\x00\xa9\xe1\xaa\x00\xaa\x11\xaa\x00\xa9\xf8\xaa\x00\xaa\x03\xaa\x00\xa9\xff" . "\xaa\x00" x 290));
# RTP in @ 110
snd($sock_a, $port_b,  rtp(8,  2000 + 5, 3800000000 + 160*5, 0x5678, "\x20" x 160));
# RTP out @ 130
rcv($sock_b, $port_a, rtpm(96, $seq + 5, 3800000000 + 320*5, 0x5678, "\xaa\x00" x 320));

rtpe_req('delete', 'delete');



($sock_a, $sock_b) = new_call([qw(198.51.100.10 5128)], [qw(198.51.100.10 5130)]);

($port_a) = offer('G.711/AMR-WB codec change reverse',
	{ replace => ['origin'], codec => {
			transcode => ['AMR-WB'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5128 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 96
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1;mode-change-capability=2
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711/AMR-WB codec change reverse',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5130 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1;mode-change-capability=2
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(0, 2000, 4000, 0x5678, "\x40" x 160));
($seq, $ssrc) = rcv($sock_b, $port_a, rtpm(96, -1, 4000, -1, "\xf0\x1c\xd2\x46\x09\x00\xc5\x53\x22\x71\x71\x02\x0a\x16\x87\x74\x6a\xe2\x8c\x8e\xef\xe7\x6c\x7d\x6f\x6c\xd5\xe5\x55\xc4\xfc\x40\x04\x7c\x55\x44\x6c\x48"));
snd($sock_a, $port_b, rtp(0, 2001, 4160, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(96, $seq + 1, 4320, $ssrc, "\xf0\x1c\xca\xe6\x0e\x86\xbb\xd1\xe3\x5d\x72\x4a\xb0\x71\x89\xc4\xc1\x87\x7a\xb4\x6d\xf5\xec\x54\x4f\xfd\x4f\xd6\x54\x4c\x76\xdd\x86\x7f\xd4\x85\x88\x40"));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(96, $seq + 2, 4640, $ssrc, "\xf0\x1c\xc6\x84\x08\x40\x76\xe2\x23\x4d\x50\x5a\x76\x65\xf8\xc4\xeb\x7d\x0c\xce\xef\xcc\xd5\x4c\xd5\xdc\x17\x36\x45\xdd\xdf\xd5\x19\x56\xe5\x1b\x6d\xf0"));
rcv($sock_b, $port_a, rtpm(96, $seq + 3, 4960, $ssrc, "\xf0\x1c\xd2\x80\x02\x4a\x32\xe2\x4b\x5d\x50\x1c\x67\x71\x20\xc4\x45\x4b\x53\xb4\xf4\x4d\x5c\x64\x7e\x61\xc9\x8e\xec\xc7\x45\x64\xcf\x75\x7d\x02\xce\xf8"));
# start audio again
snd($sock_a, $port_b, rtp(0, 2002, 4640, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(96, $seq + 4, 5280, $ssrc, "\xf0\x1c\xe4\xd0\x00\xd9\xf3\xe5\x96\xf1\x71\xa5\x82\x8e\xea\x20\x5f\x58\xa0\xf5\x92\x97\x34\x82\x69\x98\x62\x13\x36\x06\x16\x0c\xc7\xcc\x4f\xa3\x4e\xf0"));
# interject unknown payload type
snd($sock_a, $port_b, rtp(9, 2003, 4800, 0x5678, "\x40" x 160));
# no passthrough, get more DTX
rcv($sock_b, $port_a, rtpm(96, $seq + 5, 5600, $ssrc, "\xf0\x1c\xc1\x46\x30\xff\xf7\xff\x22\x56\x7f\xf7\x0a\xf3\xde\x0a\x80\xb0\xfa\xbe\xcb\xd8\xb6\xb4\x1a\x0d\xce\x92\xd2\x86\x50\xe4\x9b\x50\x31\x32\x34\x30"));
snd($sock_a, $port_b, rtp(9, 2004, 4960, 0x5678, "\x40" x 160));
# back to normal media
snd($sock_a, $port_b, rtp(0, 2003, 4960, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(96, $seq + 6, 5920, $ssrc, "\xf0\x1c\x90\xc6\x08\x73\x3a\xff\x06\x0c\x65\x1c\xe4\x51\xb9\xc4\x66\xfa\x8d\xdb\xc2\xcd\xd5\xcd\xed\x65\x94\xd7\x65\xdd\xf6\xf4\x45\xcc\x5c\xdc\x5c\xc8"));

# reinvite to PCMA

($port_a) = offer('G.711/AMR-WB codec change reverse',
	{ replace => ['origin'], codec => {
			transcode => ['AMR-WB'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5128 RTP/AVP 8 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 8 0 96
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1;mode-change-capability=2
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711/AMR-WB codec change reverse',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5130 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1;mode-change-capability=2
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 8
c=IN IP4 203.0.113.1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(8, 2004, 5120, 0x5678, "\x33" x 160));
rcv($sock_b, $port_a, rtpm(96, $seq + 7, 6240, 0x5678, "\xf0\x1c\xd0\x46\x09\x29\x51\x53\x02\x71\x71\x00\x0a\x16\x87\x74\xea\x6a\x0c\x8e\x6e\x7e\x65\x64\xfe\x4d\x4c\x64\xd4\x5d\x6d\xc0\x95\x7c\xcc\xd4\x7d\x58"));
snd($sock_a, $port_b, rtp(8, 2005, 5280, 0x5678, "\x33" x 160));
rcv($sock_b, $port_a, rtpm(96, $seq + 8, 6560, 0x5678, "\xf0\x1c\xca\xe6\x0e\x2e\xd8\x73\xe3\x5d\x70\x8a\xb8\x61\xa9\xc4\x6c\x1a\xf3\x34\xec\x65\xdd\x45\x5f\xed\xcc\x74\xd1\x45\x7d\xd5\x99\xfc\xc9\x08\xb2\x50"));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(96, $seq + 9, 6880, 0x5678, "\xf0\x1c\xd6\x84\x0a\x42\x3f\x62\x23\x4d\x50\x9f\x6e\x75\xc8\xc0\xc7\xac\x85\xd2\xe5\xd2\x7c\xc9\x53\xf5\x92\xa4\xe5\xdf\xdd\xcd\xda\x6e\xe0\x12\x44\xe8"));
rcv($sock_b, $port_a, rtpm(96, $seq + 10, 7200, 0x5678, "\xf0\x1c\xd2\x86\x0a\x40\x39\x61\x8e\xcd\x70\x5c\x4e\x53\xa0\xe4\x4d\xda\xf3\x34\xc4\xcc\x4c\x54\x46\xd1\xcb\x2e\xed\x55\x5d\xc0\x5b\x4e\xfd\x18\xce\x70"));

# inject old PCM
snd($sock_a, $port_b, rtp(0, 2004, 5120, 0x5678, "\x40" x 160));
snd($sock_a, $port_b, rtp(0, 2006, 5440, 0x5678, "\x40" x 160));
# packet dropped
rcv_no($sock_b);

# reinvite back to PCMU

($port_a) = offer('G.711/AMR-WB codec change reverse',
	{ replace => ['origin'], codec => {
			transcode => ['AMR-WB'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5128 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 96
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1;mode-change-capability=2
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711/AMR-WB codec change reverse',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5130 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1;mode-change-capability=2
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(0, 2007, 5760, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(96, $seq + 11, 7520, $ssrc, "\xf0\x1c\xd2\x80\x00\x60\x30\x6a\x57\xcd\x36\x3c\x6e\x42\x23\x04\x79\x43\xf3\x3d\x45\xc4\x54\xcc\x46\xc4\x49\x3e\xf4\xc4\x76\x65\x4f\xe6\xe9\x80\x06\xf8"));
snd($sock_a, $port_b, rtp(0, 2007, 5920, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(96, $seq + 12, 7840, $ssrc, "\xf0\x1c\xd2\xc4\x12\x08\x1b\xe1\x92\x5d\x70\x4e\xe0\x49\x20\xe4\x42\xa5\x86\xcc\xc6\xfd\xc5\xc4\xe6\x68\xdb\x8c\x7c\xd4\x65\x45\xc3\xcc\xe0\x14\xff\x40"));

rtpe_req('delete', 'G.711/AMR-WB codec change reverse', { 'from-tag' => ft() });


($sock_a, $sock_b) = new_call([qw(198.51.100.10 5098)], [qw(198.51.100.10 5100)]);

($port_a) = offer('G.711/AMR-WB codec change with timing',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5098 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 8
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711/AMR-WB codec change with timing',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5100 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(0, 2000, 4000, 0x5678, "\x40" x 160));
($seq, $ts, $ssrc) = rcv($sock_b, $port_a, rtpm(8, -1, -1, -1, "\x68" x 160));
snd($sock_a, $port_b, rtp(0, 2001, 4160, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 1, 4160, $ssrc, "\x68" x 160));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(8, $seq + 2, 4320, $ssrc, "\xd5" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 3, 4480, $ssrc, "\xd5" x 160));
# start audio again
snd($sock_a, $port_b, rtp(0, 2002, 4640, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 4, 4640, $ssrc, "\x68" x 160));
# interject unknown payload type
snd($sock_a, $port_b, rtp(9, 2003, 4800, 0x5678, "\x40" x 160));
# no passthrough, get more DTX
rcv($sock_b, $port_a, rtpm(8, $seq + 5, 4800, $ssrc, "\xd5" x 160));
snd($sock_a, $port_b, rtp(9, 2004, 4960, 0x5678, "\x40" x 160));
# back to normal media
snd($sock_a, $port_b, rtp(0, 2003, 4960, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 6, 4960, $ssrc, "\x68" x 160));

# reinvite to AMR-WB

($port_a) = offer('G.711/AMR-WB codec change with timing',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5098 RTP/AVP 96 0
c=IN IP4 198.51.100.10
a=rtpmap:96 AMR-WB/16000
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 96 0 8
c=IN IP4 203.0.113.1
a=rtpmap:96 AMR-WB/16000
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711/AMR-WB codec change with timing',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5100 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 AMR-WB/16000
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(96, 2004, 5120, 0x5678, "\xf0\x1c\xd0\x46\x09\xa1\xf1\x73\x02\x71\x71\x00\x0a\x16\x87\x74\xea\x6a\x8c\x06\x67\x66\xec\xf5\x67\x6c\x54\x6d\x45\x4c\x7c\x59\x8d\x7c\x55\xc4\x6c\x50"));
rcv($sock_b, $port_a, rtpm(8, $seq + 7, 5120, 0x5678, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\xd6\xdc\xd8\xc5\xc4\xc7\xdb\xdf\xd1\x54\x53\x5e\x58\x5a\x5b\x58\x5f\x53\x56\xd5\xd7\xd1\xd1\xd1\xd6\xd7\xd4\xdf\xc4\xc2\xcf\xc8\xc9\xc1\xd8\xd1\x54\x5d\x5e\x5b\x5a\x5b\x58\x5e\x5f\x5d\x53\x51\x51\x56\x56\x51\x56\xd7\xdf\xc5\xc3\xc9\xcb\xc9\xc3\xdb\xd0\x54\x5c\x45\x41\x42\x4d\x42\x41\x45\x58\x5d\x53\xdb\xf0\xf8\xe7\xe1\xe6\xfa\xf1\xf5\xf5\xc3\xc5\xdf\xd3\x52\x44\x49\x76\x7d\x7f\x7e\x7f\x7d\x71\x74\x5d\xc6\xf1\xfe\xe5\xe5\xff\xf5\xc0\xc0\xd2\x55\xd5\xcd\xf7\xf0\xff\xf1\xf3\x65\x0f\x30\x39\x3a\x24\x3b\x32\x08\x14\x9d\xb5\xb3\xbe\xbe\xbf\xb0\x8b\x85\xe7\x63\x1f\x04\x05"));
snd($sock_a, $port_b, rtp(96, 2005, 5440, 0x5678, "\xf0\x1c\xd0\x46\x09\xa1\xf1\x73\x02\x71\x71\x00\x0a\x16\x87\x74\xea\x6a\x8c\x06\x67\x66\xec\xf5\x67\x6c\x54\x6d\x45\x4c\x7c\x59\x8d\x7c\x55\xc4\x6c\x50"));
rcv($sock_b, $port_a, rtpm(8, $seq + 8, 5280, 0x5678, "\x1c\x68\x71\x92\xb7\xbe\xbf\xb3\xb4\x9b\x63\x0d\x34\x33\x33\x36\x08\x04\x60\xe9\x9a\x80\x8d\x82\x86\x99\xea\xc1\x64\x14\x10\x12\x10\x14\x62\x73\xd0\xf2\xe7\xe3\xe3\xe1\xfa\xf1\xdb\x52\x4f\x76\x73\x73\x76\x48\x44\x53\xd1\xd9\xc4\xc7\xc4\xdb\xdc\xd1\x54\x50\x5c\x5f\x5e\x5f\x5c\x53\x51\x57\x55\xd5\xd4\xd4\xd4\xd5\x54\x57\x56\x56\x51\x51\x51\x51\x56\x56\x56\x57\x57\x57\x57\x57\x57\x57\x57\x57\x56\x56\x56\x56\x56\x56\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54"));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(8, $seq + 9, 5440, 0x5678, "\x54\x54\x54\x54\x54\x54\x54\x54\xd4\xd6\xd0\xd0\xd3\xd0\xd0\xd7\x55\xf5\xe1\xef\xea\x94\x94\xef\xe4\xc9\x44\x78\x63\x6e\x68\x6e\x6d\x64\x7d\x46\xd7\xc1\xca\xf5\xf4\xc3\xd8\xda\xed\x97\x9d\x9e\x98\x9f\x96\xed\xda\x70\x6e\x14\x10\x13\x11\x17\x69\x60\x73\x47\xdd\xc7\xce\xcc\xd8\xdb\xe7\x97\x9d\x98\x85\x84\x99\x90\xe3\xd6\x61\x17\x1f\x1b\x1a\x1b\x1f\x10\x15\x63\x70\x5f\xcd\xf9\xe7\xe3\xe2\xe3\xe4\xfd\xc2\xdc\x58\x76\x78\x64\x60\x62\x6d\x6c\x62\x63\x61\x64\x7a\x7d\x71\x4d\x51\xdb\xf7\xff\xe5\xe5\xfa\xfe\xfc\xca\xd8\xd4\xd7\x51\x44\x47\x41\x4b\x7d\x66\x69\x14\x16\x10\x10\x17\x6b\x60\x73\xd8\xfb\xef\x97\x90\x90\x91\x97\xeb\xe6\xf1\xd0\x5a"));
rcv($sock_b, $port_a, rtpm(8, $seq + 10, 5600, 0x5678, "\x77\x72\x7c\x70\x5b\xde\xc1\xd3\xd4\x40\x73\x67\x63\x6c\x6f\x6c\x63\x64\x7f\x48\x5e\xd0\xdb\xc1\xc1\xda\xd2\x56\x59\x42\x4b\x77\x77\x77\x75\x4e\x41\x59\x53\xd5\xd1\xd2\xdd\xdd\xd3\xd6\xd5\x57\x51\x53\x52\x52\x53\x51\x57\xd5\xd7\xd0\xd3\xdd\xdc\xdc\xdc\xdd\xd2\xd2\xd3\xd0\xd0\xd0\xd0\xd3\xd3\xd2\xdd\xdc\xdc\xdf\xdf\xdf\xde\xdf\xdf\xdf\xdf\xdf\xdc\xdc\xdc\xdc\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdf\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdc\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xdd\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd3\xd3\xd3\xd3\xd3\xd3\xd3\xd3\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd0\xd1\xd1\xd1\xd1\xd1\xd1"));

# inject old PCM
snd($sock_a, $port_b, rtp(0, 2006, 5760, 0x5678, "\x40" x 160));
# packet dropped
rcv_no($sock_b);

# reinvite back to PCM

($port_a) = offer('G.711/AMR-WB codec change with timing',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5098 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 8
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711/AMR-WB codec change with timing',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5100 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(0, 2007, 5920, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 11, 5760, $ssrc, "\x68" x 160));
snd($sock_a, $port_b, rtp(0, 2008, 6080, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 12, 5920, $ssrc, "\x68" x 160));

rtpe_req('delete', 'G.711/AMR-WB codec change with timing', { 'from-tag' => ft() });





($sock_a, $sock_b) = new_call([qw(198.51.100.10 5068)], [qw(198.51.100.10 5070)]);

($port_a) = offer('G.711/AMR codec change with timing',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5068 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 8
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711/AMR codec change with timing',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5070 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(0, 2000, 4000, 0x5678, "\x40" x 160));
($seq, $ssrc) = rcv($sock_b, $port_a, rtpm(8, -1, 4000, -1, "\x68" x 160));
snd($sock_a, $port_b, rtp(0, 2001, 4160, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 1, 4160, $ssrc, "\x68" x 160));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(8, $seq + 2, 4320, $ssrc, "\xd5" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 3, 4480, $ssrc, "\xd5" x 160));
# start audio again
snd($sock_a, $port_b, rtp(0, 2002, 4640, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 4, 4640, $ssrc, "\x68" x 160));
# interject unknown payload type
snd($sock_a, $port_b, rtp(9, 2003, 4800, 0x5678, "\x40" x 160));
# no passthrough, get more DTX
rcv($sock_b, $port_a, rtpm(8, $seq + 5, 4800, $ssrc, "\xd5" x 160));
snd($sock_a, $port_b, rtp(9, 2004, 4960, 0x5678, "\x40" x 160));
# back to normal media
snd($sock_a, $port_b, rtp(0, 2003, 4960, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 6, 4960, $ssrc, "\x68" x 160));

# reinvite to AMR

($port_a) = offer('G.711/AMR codec change with timing',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5068 RTP/AVP 96 0
c=IN IP4 198.51.100.10
a=rtpmap:96 AMR/8000
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 96 0 8
c=IN IP4 203.0.113.1
a=rtpmap:96 AMR/8000
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711/AMR codec change with timing',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5070 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 AMR/8000
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(96, 2004, 5120, 0x5678, "\xf1\xfc\x2e\x6d\xbf\xda\x20\x1c\x82\x70\xb4\xb2\xb1\x13\x33\x0b\x27\x00"));
rcv($sock_b, $port_a, rtpm(8, $seq + 7, 5120, 0x5678, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\xd5\xd5\xd5\x55\x55\xd5\xd5\xd5\xd5\xd5\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5"));
snd($sock_a, $port_b, rtp(96, 2005, 5280, 0x5678, "\xf1\xfc\x2e\x6d\xbf\xda\x20\x1c\x82\x70\xb4\xb2\xb1\x13\x33\x0b\x27\x00"));
rcv($sock_b, $port_a, rtpm(8, $seq + 8, 5280, 0x5678, "\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5"));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(8, $seq + 9, 5440, 0x5678, "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5"));
rcv($sock_b, $port_a, rtpm(8, $seq + 10, 5600, 0x5678, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5"));

# inject old PCM
snd($sock_a, $port_b, rtp(0, 2006, 5600, 0x5678, "\x40" x 160));
# packet dropped
rcv_no($sock_b);

# reinvite back to PCM

($port_a) = offer('G.711/AMR codec change with timing',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5068 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 8
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711/AMR codec change with timing',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5070 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP


snd($sock_a, $port_b, rtp(0, 2007, 5760, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 11, 5760, $ssrc, "\x68" x 160));

rtpe_req('delete', 'G.711/AMR codec change with timing', { 'from-tag' => ft() });



($sock_a, $sock_b) = new_call([qw(198.51.100.10 4024)], [qw(198.51.100.10 4026)]);

($port_a) = offer('AMR SID',
	{ ICE => 'remove', replace => ['origin'], codec => { transcode => ['PCMA'],
	'set' => ['AMR-WB/16000/1/23850'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4024 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8
c=IN IP4 203.0.113.1
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('AMR SID',
	{ ICE => 'remove', replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4026 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(96, 2000, 4000, 0x5678, "\xf0\x1c\xd0\x46\x09\xa1\xf1\x73\x02\x71\x71\x00\x0a\x16\x87\x74\xea\x6a\x8c\x06\x67\x66\xec\xf5\x67\x6c\x54\x6d\x45\x4c\x7c\x59\x8d\x7c\x55\xc4\x6c\x50"));
Time::HiRes::usleep(20000); # 20 ms
snd($sock_a, $port_b, rtp(96, 2001, 4240, 0x5678, "\xf0\x1c\xe0\x92\x30\xf3\xf4\xff\x3d\x23\xdb\x6b\x59\x4f\xd5\x12\xad\xff\x5b\xf8\x88\x53\x85\x74\x19\x6d\x65\x63\x6e\x94\xbb\x5b\x9f\x7d\x97\x3c\x28\xe8"));
($seq, $ssrc) = rcv($sock_b, $port_a, rtpm(8, -1, 4000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\xd5\x55\xd4\xd4\xd7\xd4\xd7\xd5\xd0\x52\x72\x64\x66\x66\x66\x66\x67\x67\x67\x65\x7a\x79\x7c\x72\x70\x77\x75\x4e\x43\x47\x5b\x5c\x5d\x55\x5d\x71\x7e\x7b\x79\x7e\x7c\x7d\x73\x70\x77\x4b\x4c\x45\xc1\xf0\xf1\xfd\xf8\xfa\xe5\xe7\xe6\xe6\xe1\xe6\xe0\xe0\xe1\xe0\xe3\xe2\xe2\xe2\xed\xec\xef\xec\xec\xec\xed\xe2\xe3\xe3\xe1\xe1\xe7\xe7\xe7\xe5\xe5\xfa\xfa\xfb\xfb\xfb\xff\xfc\xf2\xf3\xf1\xf6\xf7\xf4\xf5\xcb\xce\xcd\xc3\xc1\xc7\xd8\xd9\xdf\xdc\xd3\xd3\xd7\x54\x51\x53\x5c\x5c\x5f\x5e\x58\x5a\x44"));
snd($sock_a, $port_b, rtp(96, 2002, 4560, 0x5678, "\xf0\x1c\x41\x42\x00\xd9\xd7\x64\x3c\xb0\x51\xe7\x1f\x95\x56\x3b\x34\x76\x35\x73\x46\x32\x16\x72\x67\xc4\x54\x16\x02\x64\x30\x36\x34\x18\xba\x14\xce\xd8"));
rcv($sock_b, $port_a, rtpm(8, $seq + 1, 4160, $ssrc, "\x47\x47\x40\x43\x4c\x4f\x48\x49\x4f\x4d\x42\x42\x42\x43\x41\x41\x41\x40\x40\x40\x43\x4d\x4f\x49\x48\x75\x74\x74\x77\x77\x76\x76\x76\x76\x76\x71\x71\x70\x70\x70\x70\x70\x73\x72\x73\x72\x72\x72\x72\x73\x70\x70\x71\x71\x71\x71\x76\x76\x76\x77\x77\x77\x74\x74\x74\x75\x75\x4a\x4b\x48\x48\x4b\x4b\x4b\x48\x48\x48\x49\x49\x49\x49\x4f\x4f\x4c\x4c\x4d\x43\x40\x41\x46\x47\x45\x5a\x5b\x58\x59\x5e\x5f\x5c\x5d\x52\x52\x53\x53\x53\x53\x53\x53\x53\x50\x53\x50\x50\x51\x51\x51\x56\x56\x57\x54\x54\xd5\xd5\xd4\xd7\xd7\xd6\xd1\xd0\xd0\xd3\xd2\xdd\xdd\xdc\xdf\xdf\xde\xde\xd9\xd9\xd9\xd9\xd9\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8", "\x47\x47\x40\x43\x4c\x4f\x48\x49\x4f\x4d\x42\x42\x42\x43\x41\x41\x41\x40\x40\x40\x43\x4d\x4f\x49\x48\x75\x75\x74\x77\x77\x76\x76\x76\x76\x76\x71\x71\x70\x70\x70\x70\x70\x73\x72\x73\x72\x72\x72\x72\x73\x70\x70\x71\x71\x71\x71\x76\x76\x76\x77\x77\x77\x74\x74\x74\x75\x75\x4a\x4b\x48\x48\x4b\x4b\x4b\x48\x48\x48\x49\x49\x49\x49\x4f\x4f\x4c\x4c\x4d\x43\x40\x41\x46\x47\x45\x5a\x5b\x58\x59\x5e\x5f\x5c\x5d\x52\x52\x53\x53\x53\x53\x53\x53\x53\x50\x50\x50\x50\x51\x51\x51\x56\x56\x57\x54\x54\xd5\xd5\xd4\xd7\xd7\xd6\xd1\xd0\xd0\xd3\xd2\xdd\xdd\xdc\xdf\xdf\xde\xde\xd9\xd9\xd9\xd9\xd9\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8"));
snd($sock_a, $port_b, rtp(96, $seq + 3, 4880, 0x5678, "\xf0\x1c\x41\x46\x30\xff\xf7\xfc\x31\x15\x57\x3b\x0a\x1e\x44\xcd\x5e\x0e\xa7\xe4\x3a\x1b\xb5\x7b\x38\x2a\x90\x13\x08\xf3\x5f\xaa\xba\x57\xb0\x30\xd3\xe8"));
rcv($sock_b, $port_a, rtpm(8, $seq + 2, 4320, $ssrc, "\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd8\xd9\xd9\xd8\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xde\xde\xde\xde\xde\xdf\xdf\xdf\xdf\xdc\xdc\xdc\xdc\xdd\xdd\xdd\xd2\xd2\xd2\xd3\xd3\xd3\xd0\xd0\xd0\xd0\xd1\xd1\xd1\xd6\xd6\xd6\xd7\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x55\x54\x55\x55\x55\x55\x54\x55\x54\x55\x54\x55\x55\x54\x55\x54\x55\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54"));
# no snd, trigger DTX
rcv($sock_b, $port_a, rtpm(8, $seq + 3, 4480, $ssrc, "\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x54\x54\x54\x54\x54\x54\x54\x54\x55\x55\x55\x55\x55\xd5\xd5\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x54\x54\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5"));
rcv($sock_b, $port_a, rtpm(8, $seq + 4, 4640, $ssrc, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55"));
rcv($sock_b, $port_a, rtpm(8, $seq + 5, 4800, $ssrc, "\x55\x55\x55\xd5\xd5\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\xd5\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\xd5\xd5\x55\x55\x55\x55\xd5\xd5\x55\xd5\x55\x55\xd5\xd5\x55\xd5\x55\xd5\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\xd5\x55\xd5\xd5\x55\x55\xd5\xd5\xd5\xd5\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\xd5\x55\xd5\xd5\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\xd5\x55\x55\x55\x55\x55\x55"));
# continue AMR
snd($sock_a, $port_b, rtp(96, 2004, 6160, 0x5678, "\xf0\x1c\x41\x46\x30\xff\xf7\xfc\x31\x15\x57\x3b\x0a\x1e\x44\xcd\x5e\x0e\xa7\xe4\x3a\x1b\xb5\x7b\x38\x2a\x90\x13\x08\xf3\x5f\xaa\xba\x57\xb0\x30\xd3\xe8"));
rcv($sock_b, $port_a, rtpm(8, $seq + 6, 4960, $ssrc, "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\xd5\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55"));
snd($sock_a, $port_b, rtp(96, 2005, 6480, 0x5678, "\xf0\x1c\x41\x46\x30\xff\xf7\xfc\x31\x15\x57\x3b\x0a\x1e\x44\xcd\x5e\x0e\xa7\xe4\x3a\x1b\xb5\x7b\x38\x2a\x90\x13\x08\xf3\x5f\xaa\xba\x57\xb0\x30\xd3\xe8"));
rcv($sock_b, $port_a, rtpm(8, $seq + 7, 5120, $ssrc, "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55"));



rtpe_req('delete', 'AMR SID', { 'from-tag' => ft() });



($sock_a, $sock_b) = new_call([qw(198.51.100.10 4026)], [qw(198.51.100.10 4028)]);

($port_a) = offer('AMR SID TS gap',
	{ ICE => 'remove', replace => ['origin'], codec => { transcode => ['PCMA'],
	'set' => ['AMR-WB/16000/1/23850'] } }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4026 RTP/AVP 96
c=IN IP4 198.51.100.10
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8
c=IN IP4 203.0.113.1
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('AMR SID TS gap',
	{ ICE => 'remove', replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4028 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 96
c=IN IP4 203.0.113.1
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 octet-align=1
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(96, 2000, 4000, 0x5678, "\xf0\x1c\xd0\x46\x09\xa1\xf1\x73\x02\x71\x71\x00\x0a\x16\x87\x74\xea\x6a\x8c\x06\x67\x66\xec\xf5\x67\x6c\x54\x6d\x45\x4c\x7c\x59\x8d\x7c\x55\xc4\x6c\x50"));
Time::HiRes::usleep(20000); # 20 ms
snd($sock_a, $port_b, rtp(96, 2001, 4240, 0x5678, "\xf0\x1c\xe0\x92\x30\xf3\xf4\xff\x3d\x23\xdb\x6b\x59\x4f\xd5\x12\xad\xff\x5b\xf8\x88\x53\x85\x74\x19\x6d\x65\x63\x6e\x94\xbb\x5b\x9f\x7d\x97\x3c\x28\xe8"));
($seq, $ssrc) = rcv($sock_b, $port_a, rtpm(8, -1, 4000, -1, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\xd5\x55\xd4\xd4\xd7\xd4\xd7\xd5\xd0\x52\x72\x64\x66\x66\x66\x66\x67\x67\x67\x65\x7a\x79\x7c\x72\x70\x77\x75\x4e\x43\x47\x5b\x5c\x5d\x55\x5d\x71\x7e\x7b\x79\x7e\x7c\x7d\x73\x70\x77\x4b\x4c\x45\xc1\xf0\xf1\xfd\xf8\xfa\xe5\xe7\xe6\xe6\xe1\xe6\xe0\xe0\xe1\xe0\xe3\xe2\xe2\xe2\xed\xec\xef\xec\xec\xec\xed\xe2\xe3\xe3\xe1\xe1\xe7\xe7\xe7\xe5\xe5\xfa\xfa\xfb\xfb\xfb\xff\xfc\xf2\xf3\xf1\xf6\xf7\xf4\xf5\xcb\xce\xcd\xc3\xc1\xc7\xd8\xd9\xdf\xdc\xd3\xd3\xd7\x54\x51\x53\x5c\x5c\x5f\x5e\x58\x5a\x44"));
snd($sock_a, $port_b, rtp(96, 2002, 4560, 0x5678, "\xf0\x1c\x41\x42\x00\xd9\xd7\x64\x3c\xb0\x51\xe7\x1f\x95\x56\x3b\x34\x76\x35\x73\x46\x32\x16\x72\x67\xc4\x54\x16\x02\x64\x30\x36\x34\x18\xba\x14\xce\xd8"));
rcv($sock_b, $port_a, rtpm(8, $seq + 1, 4160, $ssrc, "\x47\x47\x40\x43\x4c\x4f\x48\x49\x4f\x4d\x42\x42\x42\x43\x41\x41\x41\x40\x40\x40\x43\x4d\x4f\x49\x48\x75\x74\x74\x77\x77\x76\x76\x76\x76\x76\x71\x71\x70\x70\x70\x70\x70\x73\x72\x73\x72\x72\x72\x72\x73\x70\x70\x71\x71\x71\x71\x76\x76\x76\x77\x77\x77\x74\x74\x74\x75\x75\x4a\x4b\x48\x48\x4b\x4b\x4b\x48\x48\x48\x49\x49\x49\x49\x4f\x4f\x4c\x4c\x4d\x43\x40\x41\x46\x47\x45\x5a\x5b\x58\x59\x5e\x5f\x5c\x5d\x52\x52\x53\x53\x53\x53\x53\x53\x53\x50\x53\x50\x50\x51\x51\x51\x56\x56\x57\x54\x54\xd5\xd5\xd4\xd7\xd7\xd6\xd1\xd0\xd0\xd3\xd2\xdd\xdd\xdc\xdf\xdf\xde\xde\xd9\xd9\xd9\xd9\xd9\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8", "\x47\x47\x40\x43\x4c\x4f\x48\x49\x4f\x4d\x42\x42\x42\x43\x41\x41\x41\x40\x40\x40\x43\x4d\x4f\x49\x48\x75\x75\x74\x77\x77\x76\x76\x76\x76\x76\x71\x71\x70\x70\x70\x70\x70\x73\x72\x73\x72\x72\x72\x72\x73\x70\x70\x71\x71\x71\x71\x76\x76\x76\x77\x77\x77\x74\x74\x74\x75\x75\x4a\x4b\x48\x48\x4b\x4b\x4b\x48\x48\x48\x49\x49\x49\x49\x4f\x4f\x4c\x4c\x4d\x43\x40\x41\x46\x47\x45\x5a\x5b\x58\x59\x5e\x5f\x5c\x5d\x52\x52\x53\x53\x53\x53\x53\x53\x53\x50\x50\x50\x50\x51\x51\x51\x56\x56\x57\x54\x54\xd5\xd5\xd4\xd7\xd7\xd6\xd1\xd0\xd0\xd3\xd2\xdd\xdd\xdc\xdf\xdf\xde\xde\xd9\xd9\xd9\xd9\xd9\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8"));
snd($sock_a, $port_b, rtp(96, 2003, 4880, 0x5678, "\xf0\x1c\x41\x46\x30\xff\xf7\xfc\x31\x15\x57\x3b\x0a\x1e\x44\xcd\x5e\x0e\xa7\xe4\x3a\x1b\xb5\x7b\x38\x2a\x90\x13\x08\xf3\x5f\xaa\xba\x57\xb0\x30\xd3\xe8"));
rcv($sock_b, $port_a, rtpm(8, $seq + 2, 4320, $ssrc, "\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd8\xd9\xd9\xd8\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xd9\xde\xde\xde\xde\xde\xdf\xdf\xdf\xdf\xdc\xdc\xdc\xdc\xdd\xdd\xdd\xd2\xd2\xd2\xd3\xd3\xd3\xd0\xd0\xd0\xd0\xd1\xd1\xd1\xd6\xd6\xd6\xd7\xd7\xd7\xd7\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x55\x54\x55\x55\x55\x55\x54\x55\x54\x55\x54\x55\x55\x54\x55\x54\x55\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54"));
# no snd, trigger DTX
rcv($sock_b, $port_a, rtpm(8, $seq + 3, 4480, $ssrc, "\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x54\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x57\x54\x54\x54\x54\x54\x54\x54\x54\x55\x55\x55\x55\x55\xd5\xd5\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd4\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x54\x54\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5"));
rcv($sock_b, $port_a, rtpm(8, $seq + 4, 4640, $ssrc, "\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55"));
rcv($sock_b, $port_a, rtpm(8, $seq + 5, 4800, $ssrc, "\x55\x55\x55\xd5\xd5\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\xd5\x55\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x55\xd5\xd5\x55\x55\x55\x55\xd5\xd5\x55\xd5\x55\x55\xd5\xd5\x55\xd5\x55\xd5\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\xd5\x55\xd5\xd5\x55\x55\xd5\xd5\xd5\xd5\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\xd5\x55\xd5\xd5\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\xd5\x55\x55\x55\x55\x55\x55"));
# continue AMR
snd($sock_a, $port_b, rtp(96, 2004, 5200, 0x5678, "\xf0\x1c\x41\x46\x30\xff\xf7\xfc\x31\x15\x57\x3b\x0a\x1e\x44\xcd\x5e\x0e\xa7\xe4\x3a\x1b\xb5\x7b\x38\x2a\x90\x13\x08\xf3\x5f\xaa\xba\x57\xb0\x30\xd3\xe8"));
rcv($sock_b, $port_a, rtpm(8, $seq + 6, 4960, $ssrc, "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\xd5\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55"));
snd($sock_a, $port_b, rtp(96, 2005, 5520, 0x5678, "\xf0\x1c\x41\x46\x30\xff\xf7\xfc\x31\x15\x57\x3b\x0a\x1e\x44\xcd\x5e\x0e\xa7\xe4\x3a\x1b\xb5\x7b\x38\x2a\x90\x13\x08\xf3\x5f\xaa\xba\x57\xb0\x30\xd3\xe8"));
rcv($sock_b, $port_a, rtpm(8, $seq + 7, 5120, $ssrc, "\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\xd5\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\xd5\xd5\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\xd5\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\x55\xd5"));



rtpe_req('delete', 'AMR SID', { 'from-tag' => ft() });



($sock_a, $sock_b) = new_call([qw(198.51.100.10 4034)], [qw(198.51.100.10 4036)]);

($port_a) = offer('AMR w DTMF',
	{
		codec => {
			mask => ['all'],
			transcode => [
				'G722',
				'AMR-WB/16000/1///mode-set--0,1,2;mode-change-period--2;mode-change-capability--2',
				'AMR',
				'PCMA',
				'telephone-event'
			],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4034 RTP/AVP 111 108 8 101 96
c=IN IP4 198.51.100.10
a=ptime:20
a=rtpmap:111 AMR-WB/16000
a=fmtp:111 mode-set=0,1,2; mode-change-period=2; mode-change-capability=2
a=rtpmap:108 AMR/8000
a=fmtp:108 mode-set=7
a=rtpmap:8 PCMA/8000
a=rtpmap:101 telephone-event/16000
a=rtpmap:96 telephone-event/8000
a=fmtp:96 0-15
a=fmtp:101 0-15
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 9 97 108 8 96 101
c=IN IP4 203.0.113.1
a=rtpmap:9 G722/8000
a=rtpmap:97 AMR-WB/16000
a=fmtp:97 mode-set=0,1,2;mode-change-period=2;mode-change-capability=2
a=rtpmap:108 AMR/8000
a=fmtp:108 mode-set=7
a=rtpmap:8 PCMA/8000
a=rtpmap:96 telephone-event/8000
a=fmtp:96 0-15
a=rtpmap:101 telephone-event/16000
a=fmtp:101 0-15
a=sendrecv
a=rtcp:PORT
a=ptime:20
SDP

($port_b) = answer('AMR w DTMF',
	{ flags => ['single codec'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4036 RTP/AVP 9 96
c=IN IP4 198.51.100.10
a=sendrecv
a=rtpmap:9 G722/8000
a=rtpmap:96 telephone-event/8000
a=fmtp:96 0-16
a=silenceSupp:off - - - -
a=ptime:20
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 111 101
c=IN IP4 203.0.113.1
a=rtpmap:111 AMR-WB/16000
a=fmtp:111 mode-set=0,1,2; mode-change-period=2; mode-change-capability=2
a=rtpmap:101 telephone-event/16000
a=fmtp:101 0-15
a=silenceSupp:off - - - -
a=sendrecv
a=rtcp:PORT
a=ptime:20
SDP

snd($sock_a, $port_b, rtp(111, 1, 640, 0x5678, "\xf0\x48\x0c\x40\x0e\x47\x46\x0c\xa1\xf8\xc3\x65\x24\x2d\x34\x0d\x11\x04"));
($seq, $ssrc) = rcv($sock_b, $port_a, rtpm(9, -1, 640, -1, "\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xde\x74\xb7\xb7\xba\xb2\xae\xf3\xf4\xf2\xf4\x79\xb6\xf6\xb9\xf6\xfb\xdf\xf6\xf9\xb9\xf6\x7b\xbb\xdf\xf6\xfb\xb9\xf8\xf8\xf8\xdf\x76\xbb\xf8\xbb\xdc\xf8\xf8\xde\xf8\xb3\xf8\xf8\x7a\xb8\xfa\xfa\xba\xfa\xfa\xde\xf4\xba\xf8\xf7\xf5\xf5\xf1\x6c\xb3\xf9\xf9\xb9\xfb\xf6\xb6\xf9\x76\xfb\x9f\xf9\xf6\xbb\xfb\xdd\xf8\x7b\x9c\x76\xfb\x9f\xfb\xfb\xdf\x5a\xdf\xf8\x9c\xf5\xb8\x7a\xdc\xde\xba\xde\x75\xba\xf8\xf5\x5e\xf3\xba\x5e\xba\x78\xf8\xf8\xf8\xf5\xde\xb1\xf5\x78\xf5\xf5\xf4\xbb\xf8\xbb\x78\xde\xf5\x75\xb8\xb1\x72\xf9\xf9\xfb\x5f\xf8\xb2\xfb\xf6\xdf\xf6\x5f\xf6\xfb\xdf\xb4\xfb\xbb\xfb\xf8\xdf\xf8\xf8\xfb\xf5\xb2"));
Time::HiRes::usleep(10000); # 10 ms
snd($sock_a, $port_b, rtp(111, 2, 960, 0x5678, "\xf0\x44\x08\x00\x08\x47\x2d\x75\x44\x75\xc7\x54\x58\x1c\x08\x04\x00\x34"));
rcv($sock_b, $port_a, rtpm(9, $seq + 1, 800, $ssrc, "\x5f\xb4\xdf\xf4\x9f\xf4\xbb\x5f\xf2\xdf\x5f\xdf\xb6\xf6\xbb\xf4\xf9\x5a\xfb\xb6\x7b\xfb\x9f\xf2\x5a\xf6\xfb\xfb\xdd\xb6\x79\x9f\x7b\xf6\xb3\xdd\x74\xf9\x9f\xfb\x7b\xf9\xfb\xfb\xfb\x9f\xf8\xfb\x78\xdf\xf6\xf8\xdf\xb2\xdf\x78\xf6\xb8\xdf\xf8\xf8\xbb\x5c\xb5\xf5\xbb\xf8\x7a\xfa\x9e\xf8\xf8\x7a\xb8\xf5\x5e\xf5\xb8\xf8\xf5\xfa\x7a\xba\xfa\xde\xf4\x77\xba\xfa\xf7\xde\x77\xf8\xf1\xfa\xf8\xba\x9c\x78\x9e\xf4\xf8\xf5\xf3\xde\xf5\x5e\xf3\xf8\xb8\xf5\xbb\xf8\xdc\xf5\x73\xf8\x9f\xf6\xfb\xbb\x9c\xf6\x78\xda\xf2\xf4\xdf\xdd\xb8\x72\x9a\xf6\x5d\xf9\xb6\xf9\xf4\xdf\xbb\x7b\x9d\xf9\xf6\x76\xfb\x9d\x7b\x9f\x7b\xf8\xf6\xf4\xdf\xbb\xfb\xdc\x7b\xf6\xf8"));
Time::HiRes::usleep(10000); # 10 ms
# DTMF
snd($sock_a, $port_b, rtp(101, 3, 1280, 0x5678, "\x01\x07\x01\x40"));
rcv($sock_b, $port_a, rtpm(96, $seq + 2, 960, $ssrc, "\x01\x07\x00\xa0"));
Time::HiRes::usleep(10000); # 10 ms
snd($sock_a, $port_b, rtp(101, 4, 1280, 0x5678, "\x01\x07\x02\x80"));
rcv($sock_b, $port_a, rtpm(96, $seq + 3, 960, $ssrc, "\x01\x07\x01\x40"));
Time::HiRes::usleep(10000); # 10 ms
snd($sock_a, $port_b, rtp(101, 5, 1280, 0x5678, "\x01\x07\x03\xc0"));
rcv($sock_b, $port_a, rtpm(96, $seq + 4, 960, $ssrc, "\x01\x07\x01\xe0"));
Time::HiRes::usleep(10000); # 10 ms
# end
snd($sock_a, $port_b, rtp(101, 6, 1280, 0x5678, "\x01\x87\x05\x00"));
Time::HiRes::usleep(1000); # 1 ms
snd($sock_a, $port_b, rtp(101, 7, 1280, 0x5678, "\x01\x87\x05\x00"));
Time::HiRes::usleep(1000); # 1 ms
snd($sock_a, $port_b, rtp(101, 8, 1280, 0x5678, "\x01\x87\x05\x00"));
rcv($sock_b, $port_a, rtpm(96, $seq + 5, 960, $ssrc, "\x01\x87\x02\x80"));
rcv($sock_b, $port_a, rtpm(96, $seq + 6, 960, $ssrc, "\x01\x87\x02\x80"));
rcv($sock_b, $port_a, rtpm(96, $seq + 7, 960, $ssrc, "\x01\x87\x02\x80"));
Time::HiRes::usleep(10000); # 10 ms
# audio
snd($sock_a, $port_b, rtp(111, 9, 2560, 0x5678, "\xf0\x44\x0c\x00\x0a\x07\x41\x71\xa0\xf8\xc1\x54\x3c\x00\x00\x00\x00\x20"));
rcv($sock_b, $port_a, rtpm(9, $seq + 8, 1600, $ssrc, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7", "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xfb\xda\x7b\xb6\xb8\x9f\xf0\x34\xdd\x78\xbb\x9f\xfb\xf8\x38\x76\xfb\xb8\xfa\xde\xfa\x7a\x7a\xfa\xba\x7a\xde\xf7\xf8\xfa\x74\xf8\xf7\xde\xb3\xba\x7a\x5e\x78\xb5\x78\xf8\xfa\xb7\x5e\xf8\xb7\xf8\x78\x77\xfa\x9e\xf7\x78\xf2\x9c\x78\xb8\x7a\xfa\x7a\xde\xf4\xf4\xb5\xfa\x7a\x5c\xf7\x78\xb7\xb8\xfa\x5b\xf8\x78\xf7\xf3\xf8\x9e\xde\x73\x5e\xb5\xb8\xef\x5f\xdf\xf4\xdf\xb8\x7b\x74\x78\xbb\x9f\xf8\x5f\x78\xb3\xf8\x76\xdf\x9f\xf8\x7b\xf8\xf8\xf1\xb6\xdf\xdf\x78\x78\xfa\xb5\xb1\xf8\x5c\x7b\x7b\x9f\xb8\xf5\xf3\xdf\x78\xf8\xf8\xf8\x7a\xfa\x9e\xba\x75\x78\xba\xf8\x78\x7a\xde\xb7\xde\xf1\xfa\xfa\xf8\xf8\xf8\x5e\xf4"));

# reverse flow
snd($sock_b, $port_a, rtp(9, 100, 7000, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
($seq, $ssrc) = rcv($sock_a, $port_b, rtpm(111, -1, 7000, -1, "\xf1\x54\x54\x3c\x58\x28\x92\xb6\x34\x42\x0b\x59\x8b\x52\x1c\x0d\xa0\xa6\x70\x16\xf8\x9a\x2d\x5e\xf0\x53\xb6\x78\x02\x1d\xff\x54\x12"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(9, 101, 7160, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(111, $seq + 1, 7320, $ssrc, "\xf1\x58\x42\x86\x17\xb7\xe1\xa2\x9c\x79\x5b\x43\x82\x64\xcc\xd1\xe0\xe4\xf8\x67\x69\x3d\x3e\x9e\xd8\x75\x34\xa9\xb2\xa5\x47\x81\x32"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(9, 102, 7320, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(111, $seq + 2, 7640, $ssrc, "\xf1\x50\x42\xfe\x51\x93\xf0\x66\xe8\x59\xeb\xb8\x05\x4a\x5a\x01\xa2\x3d\xf0\x29\x4d\xbd\x9c\x2e\x9f\x2d\x3f\x85\xfa\x1d\x47\x1f\xfa"));
# DTMF
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 103, 7480, 0x9876, "\x01\x07\x00\xa0"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 3, 7960, $ssrc, "\x01\x07\x01\x40"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 104, 7480, 0x9876, "\x01\x07\x01\x40"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 4, 7960, $ssrc, "\x01\x07\x02\x80"));
# end
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 105, 7480, 0x9876, "\x01\x87\x01\xe0"));
Time::HiRes::usleep(1000);
snd($sock_b, $port_a, rtp(96, 106, 7480, 0x9876, "\x01\x87\x01\xe0"));
Time::HiRes::usleep(1000);
snd($sock_b, $port_a, rtp(96, 107, 7480, 0x9876, "\x01\x87\x01\xe0"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 5, 7960, $ssrc, "\x01\x87\x03\xc0"));
Time::HiRes::usleep(1000);
rcv($sock_a, $port_b, rtpm(101, $seq + 6, 7960, $ssrc, "\x01\x87\x03\xc0"));
Time::HiRes::usleep(1000);
rcv($sock_a, $port_b, rtpm(101, $seq + 7, 7960, $ssrc, "\x01\x87\x03\xc0"));
Time::HiRes::usleep(9000);
# more audio
snd($sock_b, $port_a, rtp(9, 108, 7960, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(111, $seq + 8, 8920, $ssrc, "\xf1\x50\x42\x86\xbe\xb7\x49\xe3\x7c\x53\x43\x18\x47\xe1\x6c\x71\xa2\xf6\x76\x20\xcd\x3f\x1f\x7a\x9e\x17\x06\xdc\x72\xf4\xf4\x5f\x7a", "\xf1\x50\x48\x7c\x22\x20\x80\x00\xcd\x74\xa2\x2d\x11\x43\x52\x01\xbe\x17\x02\x01\x6b\x25\x5a\x46\x03\x06\x35\x43\x00\x32\xf5\x5d\x12"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(9, 109, 8120, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(111, $seq + 9, 9240, $ssrc, "\xf1\x58\x43\x82\x36\x15\x27\x26\xb5\x6a\xfb\x25\xc1\x21\x4c\x69\xe5\x76\x06\x4a\xe0\x6e\x9a\xbe\x9c\x87\x52\x8c\xf7\x67\xe5\xa7\xf6", "\xf1\x50\x11\x80\x0c\xcd\x33\xc8\x58\x5f\xca\xe0\x34\xf9\xb6\xc4\x1e\x80\x80\x11\x90\x01\x83\x02\x08\x81\x01\x05\x98\x80\x01\x09\x16"));
# more DTMF
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 110, 8280, 0x9876, "\x01\x07\x00\xa0"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(111, $seq + 10, 9560, $ssrc, "\xf1\x51\x41\x51\x59\x4c\x14\xe2\x95\x09\x0a\x1a\x05\x2c\xdc\xc9\xa2\x63\x71\x29\xdc\xc2\x6d\xff\xb2\x41\x77\xdd\xb4\x67\x5f\xd7\xb4"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 111, 8280, 0x9876, "\x01\x07\x01\x40"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(111, $seq + 11, 9880, $ssrc, "\xf1\x58\x43\x02\x1c\x1c\x85\x3a\x34\x8a\x7b\x93\xa1\x16\xac\xe1\xa4\x76\x66\x00\xed\x7f\x9f\xce\x9e\x87\x96\xec\xfa\x65\xec\xe7\x7a"));



rtpe_req('delete', 'AMR w DTMF', { 'from-tag' => ft() });





($sock_a, $sock_b) = new_call([qw(198.51.100.10 4042)], [qw(198.51.100.10 4044)]);

($port_a) = offer('AMR w reverse DTMF',
	{
		codec => {
			mask => ['all'],
			transcode => [
				'AMR-WB/16000/1///mode-set--0,1,2;mode-change-period--2;mode-change-capability--2/dtx--1',
				'PCMA',
				'telephone-event'
			],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4042 RTP/AVP 9 8 101
c=IN IP4 198.51.100.10
a=rtpmap:9 G722/8000
a=rtpmap:8 PCMA/8000
a=rtpmap:101 telephone-event/8000
a=fmtp:101 0-16
a=rtcp-mux
a=silenceSupp:off - - - -
a=ptime:20
----------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 96 8 97 101
c=IN IP4 203.0.113.1
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 mode-set=0,1,2;mode-change-period=2;mode-change-capability=2
a=rtpmap:8 PCMA/8000
a=rtpmap:97 telephone-event/16000
a=fmtp:97 0-15
a=rtpmap:101 telephone-event/8000
a=fmtp:101 0-16
a=silenceSupp:off - - - -
a=sendrecv
a=rtcp:PORT
a=rtcp-mux
a=ptime:20
SDP

($port_b) = answer('AMR w reverse DTMF',
	{ flags => [] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 4044 RTP/AVP 96 97
c=IN IP4 198.51.100.10
a=ptime:20
a=rtpmap:96 AMR-WB/16000
a=fmtp:96 mode-set=0,1,2; mode-change-period=2; mode-change-capability=2
a=rtpmap:97 telephone-event/16000
a=fmtp:97 0-15
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio PORT RTP/AVP 9 101
c=IN IP4 203.0.113.1
a=rtpmap:9 G722/8000
a=rtpmap:101 telephone-event/8000
a=fmtp:101 0-16
a=sendrecv
a=rtcp:PORT
a=ptime:20
SDP

snd($sock_b, $port_a, rtp(96 | 0x80, 4662, 3784304100, 0x5678, "\x21\x6c\xc3\x07\x29\x9b\x71\x04\x34\x59\x59\x10\x17\x8f\x1d\x62\x3e\x91\x85\xb7\x78\xa6\xfa\xf3\x48\x98\x5d\x66\x8a\x92\x65\x0a\xcd"));
Time::HiRes::usleep(9000);
($seq, $ssrc) = rcv($sock_a, $port_b, rtpm(9, -1, 3784304100, -1, "\xfa\xfa\xfa\xfa\xfa\xfa\x7a\x9e\xb4\xb7\xb7\xba\xde\x7a\xb7\xf7\xf4\xf4\xb7\xf7\xfa\x5e\xb7\xf8\xf7\xfa\xfa\xf4\x9e\xf4\x78\xf8\xb7\x75\x73\xb8\x9e\x78\xb3\xf8\xfa\xba\xf8\x78\xdc\xf8\x78\xf8\xb5\xf8\x78\xf7\xba\xde\xf7\xf8\xba\x74\x38\xf4\xb8\xf5\xdc\xf5\xf8\x73\xfa\xb5\xfa\xde\xf8\xf5\x73\xf6\x9f\xf6\xfb\x9f\xf6\xf6\x76\xfb\x9f\xf2\xf6\xdd\x79\xb6\xf9\xfb\x74\x7b\x9f\xb6\x78\xfb\xb6\xf8\x78\x9f\xf8\x7b\x76\xb8\xf6\x5f\xf6\xbb\xfb\xfb\x78\xb8\x5c\xf5\xde\xf3\xf8\xf6\xb6\x7b\x5a\xb2\xf6\xdd\xb9\xf9\x74\x5f\xb1\xdf\x76\x9d\xf6\xf9\xfb\xf6\xf9\xf9\x7b\x7b\x9f\xfb\xdf\x32\xb4\x9d\x5d\xf3\xf9\xfb\xfb\x5f\xf9\xf9\xbb\x78\xf8\xf8\x7b\xfb"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 4663, 3784304420, 0x5678, "\xf1\x70\xcc\x2c\xb0\xbe\x3c\x2b\x21\x51\x80\x0c\x35\xf1\xf0\xef\xf5\x4c\x56\xe1\xad\x13\x8f\x83\x6a\xad\x1f\x1a\xec\x90\x25\x17\x36"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 1, 3784304260, $ssrc, "\xba\xfa\xf8\x7a\xf8\xf8\xb5\xb8\x5c\x5c\xb3\xba\x78\xfa\xb8\x5e\xde\xf1\x5e\xf3\xde\x6f\xf9\x9a\x7b\xfb\xb8\xf8\xbb\x76\x78\xda\xf6\xf6\xbb\xdc\xfb\x34\xda\xf9\xf4\xf4\xf6\xfb\x5d\xdd\xfb\xdf\xb4\xf2\x79\xdf\xb9\xf9\x9f\xf4\x74\x79\xb9\xb8\x7b\x5f\xb8\xfb\xfb\x38\xde\xf3\xdc\xfb\x78\xb5\xf8\xfb\xf5\xfb\x78\x78\xb5\xdc\x7a\xb8\xf8\xf8\xde\xb5\x73\x7a\xde\xba\xf8\xf5\x9e\x73\xf6\x7b\x78\x9f\xf8\xf8\xde\xf5\xf3\x7b\xfb\x9f\xf8\xba\x78\x9e\x73\xf8\xde\x7a\x7a\xb5\xde\xb3\x5f\xb6\xf6\x78\xd8\xf8\xf4\xf8\xfb\xfb\x78\x9c\xfa\x5e\xb3\xbb\xf8\xf3\x9f\x7b\x5c\xf8\xb3\xf8\xf8\x38\xf6\xdc\xfb\xdf\xf5\xf4\xf8\x76\xbb\xdf\xdc\xf6\xf8\x7b\xf8\xfa"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 4664, 3784304740, 0x5678, "\x24\xc0\x00\x00\x00\x00\xa0"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 2, 3784304420, $ssrc, "\xde\xf8\xba\xf8\xf8\xfa\xf8\xb7\xf8\x38\x0e\x21\x89\x20\x9a\xf1\x21\x33\x10\x8c\xb8\x33\x92\x30\xea\x1c\xbc\xdb\x4e\xf7\x31\xd9\x59\xbe\x3c\x78\xf7\xf4\x3b\x90\x8d\x3b\xf7\x6e\x5c\xf9\x5e\xcf\x77\xb1\x2c\xfb\x4e\xde\x7b\x53\xb6\xbd\x34\x7f\xd5\xf5\x39\xf5\xda\xf6\x77\x9d\x1d\x57\xea\x17\xd8\xf4\x9e\xdb\x1d\xfa\x57\x39\xfb\xd5\xf4\xfe\x56\xed\x1c\x99\xd1\xfb\x6e\x76\x6f\xf5\x70\x98\x99\x17\xdb\xee\x75\x77\x10\xdb\xb1\x9d\x73\xd5\x35\x1e\xd9\x53\xd8\xf0\xef\xf4\x37\x99\xd2\xfa\x31\x55\x72\x5a\xb4\xf3\x5d\xf8\x5a\x36\x53\xbb\xb6\x5e\xf0\xd4\x58\xdb\xdf\x3b\x31\x79\x99\x58\x18\xd7\xb7\x58\x37\xf2\x77\xb4\xfd\x7f\xd4\x7a\xf6\xef\xd8\x3c"));
Time::HiRes::usleep(19000);
rcv($sock_a, $port_b, rtpm(9, $seq + 3, 3784304580, $ssrc, "\x70\xd5\x39\xdc\x98\xb7\xfc\xf0\xdd\x70\xfe\x2d\xd2\xd4\xb8\x7c\x55\xee\xd9\x7d\xf5\x6f\x9a\x9e\x37\x11\xfc\xdf\xf0\x5a\xfb\xce\xff\x31\xd5\x3f\xfe\x95\xf2\x78\xf4\x6e\x75\x78\x9e\x50\xd0\xbd\x73\xec\xb8\x14\xda\xbd\xd0\xfc\x2f\x7d\xf6\x36\x59\xb4\xb7\x7f\xfa\xd4\xd8\xd7\x4f\xdb\x2d\xd9\xfb\x2d\xd9\xd4\xb8\x35\xf8\x59\x3b\xf4\x51\x94\xdc\x3b\x73\xbc\xd2\x3f\xdf\x4f\xd3\x79\xda\x3c\x5d\xdb\x34\x71\xf1\xf2\x59\x97\x71\xda\xbe\x37\x1a\xdc\xf1\xb0\x37\x7f\x5d\x6c\xdc\x7f\xbd\xf1\xfb\xdd\x53\x16\x56\x37\xb8\x7a\xf8\x74\xf4\xb5\x73\x73\xd6\xb9\x79\xd8\x36\x5e\x6c\x33\x9d\x93\xd2\xde\x2d\x7f\xf8\xd1\x7c\x73\xfd\x8f\x6e\xf9\xd3\x5b\xb2\x75"));
Time::HiRes::usleep(19000);
rcv($sock_a, $port_b, rtpm(9, $seq + 4, 3784304740, $ssrc, "\xd5\x1c\x75\x96\xf4\xf0\x2b\xde\xba\x9f\x7f\x5b\x58\xfd\x73\xdf\x9a\xaf\x3c\x77\x73\xf5\x51\xce\x76\x70\xbb\x57\x99\x7e\x5b\xba\xde\xf1\x2b\x5f\x58\x71\x56\xd9\xd3\x3d\x95\xfc\xd8\xde\xf9\x70\x2d\xb9\x78\x9f\x5f\xd5\x56\xb9\xf2\x1e\xf6\x1a\x7a\xb4\x5b\x75\xdd\x7a\x5a\xd2\xb8\x73\x34\x70\x34\xb5\xf5\xf0\x6e\xdb\xd5\x70\x9f\x7a\xf7\x14\x50\x74\x8f\xfe\x55\xd4\xd5\x3e\x3b\xf6\xd9\x7c\xbe\xd7\x1f\xdc\xb0\x6a\x58\x71\xef\x7a\xbc\x7e\xee\xf7\x3a\xb6\xdd\xf8\x17\x52\x16\xbe\xb5\x74\x0e\x7d\xed\xba\xf6\x70\x5e\x58\xbf\xfe\xef\x1d\x9b\xd4\xfd\xdd\xfd\xdb\x1d\x2c\xd7\xde\xd0\x6f\xcf\xf5\x70\xd6\x38\x77\xb3\x3b\x5d\x17\x75\x58\x55\x94\xde\xfb"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 4665, 3784305700, 0x5678, "\xf4\xfb\xff\xef\x7c\x3c\x91"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 5, 3784304900, $ssrc, "\x17\xb0\xf1\x58\xd7\x76\xd8\x5c\xbd\x3f\x15\xd7\x56\xd4\x5d\x96\x37\x52\xdb\xd5\xec\xb1\x73\x3e\x6e\xbb\x70\xde\x5a\xd8\x9a\xb7\x5b\xbf\xdf\x7c\x2d\x72\xdf\xfb\xec\x59\xba\x7b\xef\xbf\x1c\xfa\xee\x76\xd6\x71\x35\x2b\xfa\xbc\x56\x75\xdf\x50\x7b\x52\x74\xde\x5c\xd0\xb8\xae\x37\x5c\x9a\xb1\xde\xb1\xfe\x56\xd5\x36\x75\xb3\x7b\x1e\xd8\xd1\xdf\x5c\xfb\x4e\xdc\xd0\x73\xfc\x3b\xd7\xb8\xbe\x9f\x7f\xd1\xec\xd8\xcf\x36\xd7\xb4\x37\x2e\x7d\xfd\x54\x7f\xf2\xd7\xf2\x1c\xf4\xfa\x76\x36\xdd\xb5\x2c\xf8\xfa\xd6\x79\xb0\x76\xf7\x58\x14\x3e\x7b\x9a\x73\x9f\xb4\x7f\x57\x3b\xff\x74\xd5\xae\x4d\x59\xf7\x32\x55\xb6\xf7\x3b\x6e\x39\x5f\xda\xea\x71\x6e\x70"));
Time::HiRes::usleep(19000);
rcv($sock_a, $port_b, rtpm(9, $seq + 6, 3784305060, $ssrc, "\x7e\xdc\xfb\xb7\x36\x30\xb8\xfc\xcf\x7e\xff\xef\xdf\xfe\xdf\x7b\x3f\xd8\xd9\x5c\x5d\xd9\xdf\xdd\xfe\xde\xfe\x7e\xdf\xfe\xdb\x1d\x59\xde\x5b\x1c\xde\xda\x5c\xdd\xde\xdf\x57\x3d\x9b\xdf\x9d\x5c\x5f\xff\xfc\xd7\xb8\xdf\x36\xd8\x5c\xfc\xfa\xbf\x59\x7d\xff\x1a\xdf\x5c\xfd\xff\x59\xbf\xd6\xf3\xd4\xf4\x3e\xbb\xd8\x9e\x7f\xdc\xf9\x7c\x39\x7b\x55\x78\xd9\xba\xda\x18\xbc\xda\xea\xdc\x14\x5d\xf5\x7f\x5c\xb1\xde\x59\x76\x75\xb2\xd6\xb2\xdd\x5e\x77\xb4\xbf\x77\xb8\xfb\x79\x7a\x79\xde\x56\xdd\xb7\xf2\xdd\xb5\x76\xfb\xf5\x55\x5f\x78\xb1\x59\x98\xf1\xec\xd9\xbb\xd5\x7f\xbb\x31\xdb\x3b\x9d\x79\xf3\x5c\xef\xda\xf8\xd4\x7e\xdc\x59\xee\xf7\x9c\x7e\xbd"));
Time::HiRes::usleep(19000);
rcv($sock_a, $port_b, rtpm(9, $seq + 7, 3784305220, $ssrc, "\x7c\x19\xf4\xf4\xdf\x7d\x79\xbe\x95\x5e\xeb\xdf\x35\x77\xf6\xfa\xfa\xfb\xfe\xf7\xfd\xfb\xfb\xf9\xf8\xba\xf9\x7b\xf9\xfa\xf8\xfa\xfa\xf9\xfc\xf9\xfa\xf9\x7c\x77\xbf\xdf\xb9\xf7\xba\xfc\xfd\xf9\x3c\xbd\xfd\xf7\x9e\x7c\xfd\x7c\xf8\xfa\xf9\xde\x74\xbe\xfe\x9f\xf7\xdd\xfc\x78\x77\xfe\xba\xfb\xf6\xb9\xdc\xf7\xfa\x37\xdf\xfc\xfc\x9c\xf2\xdf\x76\xf8\xf9\xf3\x9c\xf9\xdf\xf4\x9b\x75\xf8\xf4\xdf\x7c\xb1\xbe\x9f\x5d\xf1\xfb\x7b\x7e\xbb\xdc\x9e\x75\xf9\xfe\x7a\xb7\xde\x7c\xde\xda\xfe\xbe\xf3\xde\xde\x7e\xfa\xb5\x73\xbe\x98\xde\x73\x7a\xfa\x74\xbc\xfc\x9c\xfa\x5e\x72\xf7\xfa\xda\xfe\xfe\xba\xf7\xf8\x9c\x5f\xdf\xdc\x5e\xfb\xf0\x9f\xb8\xf3\x5e\x5f"));
Time::HiRes::usleep(19000);
rcv($sock_a, $port_b, rtpm(9, $seq + 8, 3784305380, $ssrc, "\xfa\x78\xde\xb7\xb2\xf6\xf5\xfa\x35\xfc\xd9\xf5\xdb\xf7\xba\x7c\xf8\xdf\xf3\xfe\xdf\xf8\xfa\xfa\x7a\xf6\xdf\xba\xfb\xb9\xfb\xfb\xf9\x5f\x79\xb9\xb9\xb7\xbb\xf9\xf9\x79\x76\xfb\xdf\xbb\xf6\xfb\xdf\x74\xf9\xf6\xf9\xb9\xfb\xbb\xf8\xf8\x76\xdf\xb6\xfb\x9f\xf4\xf4\x73\x5d\xb9\xf9\xdf\xf6\xfb\xf3\xfb\x5f\xbb\xb9\xf9\xf6\xf9\xf9\xf6\x5f\xf8\xb4\xf8\xf8\xfb\xfb\xf8\x5c\xb6\xbb\xb8\xb8\xfa\xf8\x5e\xf5\xf8\xb8\xfa\xf8\xfa\x7a\xd9\xb1\xde\xf5\xb5\xf8\x75\xfb\xb8\xde\xfa\xfa\x78\xf5\xde\xb3\xde\xf8\xb8\xf5\xf5\xde\x71\xfb\xbb\xb8\xf8\xf8\x5c\xf3\x9f\xf6\xf6\xda\xf8\xb8\x76\xf6\x9f\xf8\xf8\xdf\xf6\x74\xfb\xdf\xbb\xf8\xfb\xb8\xfa\xde\xf5\x75\xf8"));
Time::HiRes::usleep(19000);
rcv($sock_a, $port_b, rtpm(9, $seq + 9, 3784305540, $ssrc, "\xba\xba\xf8\xde\xf3\xf8\x5e\xf5\xb8\xf8\xb5\xf8\xf8\xf5\xde\xb5\x78\xb5\xf8\xfa\xf8\xfa\x5e\xf3\xba\xfa\xb8\xde\xf5\x5e\xf3\xf5\xf8\xf8\x9e\xf5\xfa\xf8\x9e\x75\xb1\xfb\xfb\x9c\x5e\xf8\xba\xf5\x71\xf8\xdf\xdf\xf8\x9e\xf5\x75\xb4\xf4\xfb\x78\xd6\xb8\xf6\xf6\xf6\x9f\x79\x9d\xdf\xf4\x76\xf3\x9a\x76\xb7\xdf\xdf\x7b\xf9\xfb\xf6\xb9\xf6\xdd\x5d\xf6\xf9\xdf\xf3\xb6\xdf\x79\xb9\xfb\xdf\xb3\xf9\xf9\xfb\xdf\xf9\xb9\x7b\xfb\xb8\x7b\xbb\xdf\xfb\xf4\xbb\x7b\xfb\xfa\x57\xb6\xf6\xfb\xfb\xb6\x5f\xda\xf6\xf8\xb8\xf8\xf6\x5f\x78\x9f\xf8\xb8\xf5\xf4\x78\xfb\xbb\x5e\xba\xde\xf3\x78\xf8\xf5\xf8\xba\xfa\xde\x75\x75\xb3\xfb\xbb\xdf\xf8\xf8\x7a\xf8\xfa\xb8"));
Time::HiRes::usleep(19000);
rcv($sock_a, $port_b, rtpm(9, $seq + 10, 3784305700, $ssrc, "\xde\xf5\xba\x7a\xf8\xba\xf8\xdb\x73\xba\xf8\x78\xf5\xba\xdc\xf5\xfa\x7a\xf5\xba\xde\xfa\xf8\xb8\xf7\x7a\xfa\xd8\xb5\xf8\xf8\xf4\xf8\xb3\x7a\x9c\x7a\xde\xf5\xfa\xb3\xf8\xfa\x5c\xde\xf5\x75\xb5\xb5\xf1\x76\xdf\x9f\xf6\xdc\x7b\xb8\x76\xdf\xbb\xfb\x7b\xde\xf3\xf6\xdc\xb8\xfb\xfb\x9c\x75\xb6\x5f\xdf\xf2\xf8\xdc\xf8\xb4\xfb\xda\x74\xfb\x9f\xb8\x76\xf6\xdf\xf8\xb6\x7b\x9c\x5f\xf4\xfb\xfb\xf6\xdf\xf8\xdc\xf5\xb4\xf8\xf6\xdf\xfb\xfb\x9c\xf8\xf8\xb3\xdf\xb8\x75\xf6\xbb\x7b\xde\xb8\xf8\x7a\xf8\xfa\xf8\x9e\x75\xb8\xde\x71\xf3\xfb\xd7\xf8\xb8\xf6\xf6\xdc\x76\xbb\xdc\xbb\x7b\xf8\x9f\x7a\xf1\xfb\xdf\xdf\xf8\xb3\x7b\xb4\x7b\xd8\xfb\xb8\xfb\xf6\x78"));
Time::HiRes::usleep(19000);
rcv($sock_a, $port_b, rtpm(9, $seq + 11, 3784305860, $ssrc, "\xf2\xdc\xfb\x9c\xfb\xb6\x76\xf4\x76\x9d\xfb\xd6\x5f\xb6\xf1\xf5\x7b\xbb\xda\xdf\x77\xb7\x77\xf9\xf7\xd9\xb9\xf9\xdd\x77\xf9\xb3\x5b\xf7\x9f\xdd\xf3\x5d\xf7\xdb\xf6\xbb\xde\xb7\x5f\xf7\x5f\xf9\xb9\xf7\xf7\xda\xfa\x7b\xfb\xdf\xb6\xf6\xbb\xdf\xf9\xfb\x5f\xf9\xf3\xb9\xfb\xdf\xfb\xbb\x5f\xb5\xf5\xf9\xf9\xdf\xbb\x7b\xbb\xf9\x7b\xb9\xdf\xf8\x74\xb9\xf8\xfb\xf8\x5c\xb4\xfb\x7b\xf8\x9f\xf5\xf8\xf4\xfb\x7b\xf5\xdf\xb8\xf8\xb5\xf8\x75\xf5\x5f\xb6\xf8\xb8\xfa\xfa\xfa\x7a\xde\xf5\xb8\xf5\xb8\xf5\x5e\xf8\xb5\xfa\x73\xdf\xb5\xfb\x7a\x99\xfb\x6f\xdf\xf9\xb8\xf8\x5c\xfb\xf6\xbb\xf8\xdf\xf6\xfb\xdc\x75\xb8\xf6\xbb\xdf\xde\xf5\x78\xb8\xf5\xf5\xb8\xf8"));
Time::HiRes::usleep(19000);
rcv($sock_a, $port_b, rtpm(9, $seq + 12, 3784306020, $ssrc, "\xf8\x7a\x5c\xb8\xf5\xb3\xfb\xfb\xfa\x57\xf8\xbb\xf6\xf2\xf8\x76\xd5\xdf\xb6\xf9\xf3\xb7\x79\x99\xdd\x79\xf9\xb9\xf1\x77\xdf\x9d\x7b\xdb\xdf\xf3\xb9\xf9\x79\xfb\x9d\xda\x75\xbb\xf7\xfb\xf9\x5d\x9a\xf7\x5f\xf5\xb7\xf9\x79\x9d\xfb\x58\xf9\xf3\xb9\xf3\xdb\xf7\x5b\xf9\xf9\xb7\xfb\xfb\xb7\x5b\xf9\xfb\xf7\xfb\xbb\xf9\xdf\xfb\xf9\xf9\xbb\xf9\xfb\xdf\xfb\xb9\x76\xdf\xbb\xfb\xdf\xf8\xb8\x76\xb8\xf8\xfb\xdc\xf6\xdc\x7b\xb8\xf5\xb6\x7b\x9f\xdc\xf3\xfb\x7b\x9f\xf6\xfb\xd8\xfb\x76\xf8\x9c\x78\xb8\xfa\xfa\xfa\xf8\xde\xf8\x75\xba\xfa\xb8\xfa\xba\xde\x72\x5e\xf8\xb3\xfa\xde\xb8\x78\xdc\x78\xb0\xf8\x7a\xba\xdc\x5c\xf7\xf5\xf8\xf3\xba\xdc\x7a\x9e\xf8"));
Time::HiRes::usleep(9000);
# new SSRC, reset seq/TS
snd($sock_b, $port_a, rtp(96, 1, 960, 0x6543, "\xf0\x44\x08\x00\x08\x47\x2d\x75\x44\x75\xc7\x54\x58\x1c\x08\x04\x00\x34"));
Time::HiRes::usleep(9000);
($seq, $ssrc) = rcv($sock_a, $port_b, rtpm(9, -1, 960, -1, "\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xfa\xde\x74\xb7\xb7\xb7\xb4\xb7\xfa\xde\xf4\xfa\x5e\xb4\xf2\xb8\xf8\xf8\xb5\xf8\xf5\x7a\xfa\xfa\x9e\xf4\xf7\xf8\xf8\xba\xf7\xde\x5e\xb4\xf7\xf5\xb8\xf3\xfa\xde\xf5\xf8\xb3\xf8\xf3\x78\xf8\xbb\xdf\xb6\xf8\xfb\xf8\xfa\xf8\xfa\xde\xf5\xba\x78\xb3\xfa\xfa\xde\xde\xaf\xfb\xf8\xf6\xfb\xf8\xdc\xf6\xb8\x74\x9c\xf6\xb2\xdf\xf6\xbb\xf8\xf8\xfb\xf4\xf8\xfb\xfb\x9f\x74\x9f\xf8\xf8\xf5\xf8\xba\x75\xdf\xf5\xf6\xbb\x7b\xb8\xf5\xfb\xba\xdc\xf3\xfb\x5f\xbb\xf5\xfb\xf8\xb8\x5e\xf5\xf3\xdf\xf8\xb4\xf8\xfb\xdc\xdc\xf8\xf5\xb5\x74\xbb\xfb\xba\x7a\xba\xde\x75\xfa\xfa\xf8\xfa\xfa\x9e\xf8\xfa\xf7\xfa\xf7\xde\xf4\xb5\x7a"));
Time::HiRes::usleep(9000);
# DTMF
snd($sock_b, $port_a, rtp(97, 2, 1280, 0x6543, "\x01\x07\x01\x40"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 1, 1120, $ssrc, "\x01\x07\x00\xa0"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(97, 3, 1280, 0x6543, "\x01\x07\x02\x80"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 2, 1120, $ssrc, "\x01\x07\x01\x40"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(97, 4, 1280, 0x6543, "\x01\x07\x03\xc0"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 3, 1120, $ssrc, "\x01\x07\x01\xe0"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(97, 5, 1280, 0x6543, "\x01\x07\x05\x00"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 4, 1120, $ssrc, "\x01\x07\x02\x80"));
Time::HiRes::usleep(9000);
# end
snd($sock_b, $port_a, rtp(97, 6, 1280, 0x6543, "\x01\x87\x06\x40"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 5, 1120, $ssrc, "\x01\x87\x03\x20"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(97, 7, 1280, 0x6543, "\x01\x87\x06\x40"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 6, 1120, $ssrc, "\x01\x87\x03\x20"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(97, 8, 1280, 0x6543, "\x01\x87\x06\x40"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(101, $seq + 7, 1120, $ssrc, "\x01\x87\x03\x20"));
Time::HiRes::usleep(9000);
# some audio
snd($sock_b, $port_a, rtp(96, 9, 2880, 0x6543, "\xf1\x70\xcc\x2c\xb0\xbe\x3c\x2b\x21\x51\x80\x0c\x35\xf1\xf0\xef\xf5\x4c\x56\xe1\xad\x13\x8f\x83\x6a\xad\x1f\x1a\xec\x90\x25\x17\x36"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 8, 1920, $ssrc, "\xb8\xf8\xfa\x9e\xf4\xfa\xf7\xfa\xf7\xf8\xde\xf7\xb8\x7a\xba\xf7\x9b\xec\xfb\xb8\xfa\x78\xf8\xdc\x75\x9e\xb3\xf8\xde\xf8\xf5\xfa\x5e\xf3\xb8\xdf\xb8\xf5\xde\x78\xf5\xf5\xf8\xb3\xdf\xb6\xdf\xdf\xfb\x78\xbb\xfa\xba\xf8\xf8\x7a\xde\xfa\xba\xb5\x75\xf8\xf5\xdc\xfa\xf8\xb8\x78\xba\xfa\xfa\x5e\xf4\xba\x77\xfa\xfa\xba\xf7\xdb\x74\xb7\xf8\x78\xde\xb4\xf5\xf3\x5e\xba\x59\xf3\xfb\xdc\xb8\xf5\x71\xdc\xf8\xfb\xb8\xdf\xf5\xf8\xb5\x76\x9c\xdf\xf4\xdc\x3b\xb8\xf8\xd9\xfa\xf8\xf3\x5f\x7b\xb8\xfa\xfa\xdc\xb5\x78\xf5\xfa\xfa\x78\xba\xde\xfa\xb8\xf8\x77\xf8\xb8\x5e\x7a\xb7\xfa\xf7\x7a\x74\xba\xde\xf4\xdb\xb3\x73\xfb\x74\x9c\xf8\x5f\xb8\xfa\xf8\x78\xfa", "\xb8\xf8\xfa\x9e\xf4\xfa\xf7\xfa\xf7\xf8\xde\x77\xba\xba\x7a\xba\x9e\xb7\x77\x5e\x72\x7a\xba\xde\xba\x7a\xfa\xfa\x7a\x7a\x9e\xf7\xfa\xba\xfa\x7a\x1e\xb4\xf7\xde\xf2\x7a\xfa\x5b\xf2\x9e\xf5\xb5\x75\x78\x7a\xde\xb5\xfa\xfa\x7a\x5e\xb3\xde\xf3\x7a\x9c\xfa\xf8\x75\xfa\xb5\x75\x78\xba\xf8\xf8\x5e\xb5\xf8\xf8\x7a\xf8\xf5\x9c\x78\x78\xf7\xb8\xba\x5e\x74\xf7\xba\x7a\xde\xf4\xba\x7a\x5e\xf4\xf2\x99\x78\xf8\xb3\x5c\x5e\xf3\x9f\xf8\xf8\xf3\x5c\xfb\xf8\xdf\xf5\x78\xb3\xdf\xf8\xb8\x5f\x78\xb8\xb5\xfa\xf8\xde\xf5\x7a\xf8\x7a\xb8\xf5\x9e\xf8\x78\xf5\xf8\x5e\xb8\xb8\xf4\xfa\xfa\x7a\x5e\xb7\x9b\xf1\x75\x78\xb5\x7a\xfa\x97\xf6\xf8\x78\xf4\xf8\xf6\xd8"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 10, 3200, 0x6543, "\xf1\x70\xcc\x2c\xb0\xbe\x3c\x2b\x21\x51\x80\x0c\x35\xf1\xf0\xef\xf5\x4c\x56\xe1\xad\x13\x8f\x83\x6a\xad\x1f\x1a\xec\x90\x25\x17\x36"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 9, 2080, $ssrc, "\x9c\x7a\xb5\xf5\xf5\x7a\xf5\xf8\x78\x9c\xba\xf5\x78\xf8\xfa\x7a\xba\xf4\x7a\x9b\xf1\xf3\x7b\xda\xf8\xfb\xbb\x78\xba\xf3\x5f\x9c\x78\xf5\xf4\xf8\xf6\xdc\x9c\xdc\x78\xf5\xf5\xb0\xf8\xfb\xdc\x5a\xb6\x7b\xb8\xf4\xb4\xfb\x5a\xf6\x5d\xf8\xb6\xb8\x74\x5a\xb4\xd8\x79\x74\xb9\xf4\xdd\xf9\x79\xdf\xf6\xfb\xf6\x5f\xfb\xbb\x9f\x7b\xf6\xfb\xfb\xdf\x5f\xb8\xfb\xf3\xb8\x7b\xdc\xf8\x78\x9e\xf5\xb5\x74\x9f\xf8\x7b\xfa\x7a\xde\xb3\xdc\xfa\x75\xb6\x7b\xda\xf6\xfb\xdf\x7b\x9f\xf3\xfb\xf8\x5c\xb6\xf6\xdf\xdf\xb8\xf6\xfb\xfb\xfb\x7a\x9c\xfa\xfa\xb8\xf5\x75\xb3\xfb\xdc\x1f\xb3\xfb\xdf\xf6\x7b\xbb\xdc\x75\xfb\xfb\x7a\xb8\xf8\x9e\xf5\x7a\xf5\x7a\xfa\xf8\x9c", "\xbb\x5f\xf6\xf8\xf8\x72\xdf\x9c\xdf\xf6\xfb\x9f\x74\xb6\xdf\xdf\x76\x7b\xdc\xbb\xb4\xf8\xdf\x76\x38\x9f\xf8\xf8\xf5\xf8\xf5\x75\xb8\xfb\xde\xfa\xf5\xf3\x7b\x9f\x7b\xdf\xb8\xf5\xb3\x78\x7b\xbb\xda\x78\xf6\xf6\xdf\xf8\x76\x9a\xfb\x7b\xf6\xb6\xdc\xf8\x7b\xfb\xdc\xb8\xf1\xf8\x5f\xf8\xb8\x78\xb5\xb6\xfb\x5a\x7b\xf8\x78\xb5\xb4\xf6\xd8\xdf\x78\x76\xf6\xb8\xfb\xdf\x7b\x5f\xb8\xb3\x7b\xfb\xf8\xf8\x7b\x9e\x78\x75\xf5\xb4\xb8\x7b\xdc\x7a\xfa\x78\x78\xb8\xf5\xb8\x78\xfa\xde\xfa\xf2\xf8\x78\x5e\xf5\xba\xb5\xf8\xf8\x7a\x1c\xf7\xba\xf5\xba\x7a\xfa\xdb\x78\xf4\xf5\x75\xf8\xba\x95\x78\xf5\xb5\xf3\x7b\x5c\xd8\xbb\xf8\xf4\xb2\x7b\xfb\xd8\xdf\x7b\xf8"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 11, 3520, 0x6543, "\xf1\x70\xcc\x2c\xb0\xbe\x3c\x2b\x21\x51\x80\x0c\x35\xf1\xf0\xef\xf5\x4c\x56\xe1\xad\x13\x8f\x83\x6a\xad\x1f\x1a\xec\x90\x25\x17\x36"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 10, 2240, $ssrc, "\xdc\xfa\xf5\x78\xf8\xba\xfa\xba\x77\x9b\xf3\xf8\xf3\x78\xfa\x9e\xfa\xf5\x5e\xb5\xf5\x71\xbb\xfb\x7b\xd6\xb2\x5f\xfb\xb9\x76\xdf\xdf\x74\xbb\xdf\xf8\x78\x9f\xf8\x76\xbb\x5f\xb8\xf8\x78\x7a\xde\xf1\x78\x9e\xf8\xfa\xb5\xde\x75\x75\xfa\xf5\xf8\x75\x9f\xb3\xda\xf4\x36\xdd\x79\x9f\xf4\xf8\xfb\xf8\x7b\x78\xfb\xbb\xde\xb5\xf8\x7a\x75\xf8\xf8\xde\xb5\xf8\xf3\xfb\x5c\x5e\xf5\xb6\xdf\xb2\xfb\xf8\xdc\xdc\x7b\xf8\xf5\xb6\x9f\xf6\xdc\x78\xf8\xb8\xf5\xfa\xf8\x9e\x5e\xfa\xb5\xf5\xf8\x3a\xba\xfa\xde\x7a\xba\x74\x78\xfa\xba\xfa\xde\xf2\x5c\xf5\x78\xf8\xb8\xba\xde\x34\xf7\xf8\xfa\xba\x5e\xb2\xde\x73\x5e\xf5\xf5\xf8\xf3\xbb\x7b\x5c\xb8\xfa\x5e\xf5\xf5", "\xf2\xf4\xf9\x9f\x9d\xfb\xdc\x76\xf6\xf3\xdd\x5d\xb9\x9d\x7b\xfb\xf8\xf6\x1f\xf6\x9f\xbb\xfb\xdf\x78\x76\xbb\xf8\xfb\xde\xfa\xfa\xfa\xfa\x7a\x5e\xb8\xb8\xf4\x75\xf3\xf8\x5e\x78\x9e\xb5\xf5\xf3\xf6\x5a\x7b\xf8\xfb\xb8\xb6\x76\x98\x7b\x1f\xf8\xf6\xbb\xf8\xf8\xf8\x5e\xf8\xf5\x75\xf6\xdf\xbb\x78\xfa\xb8\xde\xf8\xf5\x75\x73\xf8\xb8\x9f\xfa\xdc\x38\xb3\x74\xdc\xf8\xf8\x9e\x78\xf3\x78\xfb\xfb\x3a\xd9\xf8\xb5\xf6\xfb\xbb\xfa\x59\x7a\xf8\xb3\xfb\xf8\x78\xde\x5e\xb8\xf5\xf8\xf3\xf8\xf8\x5c\x9e\x75\xf5\xb6\xb8\xf8\xfb\xdc\x5e\x75\x75\xf6\xbb\xbb\xde\xde\xf5\xf8\x35\xf5\xf6\x9f\xdf\xb6\x5f\x78\xf8\xf8\xf8\x7a\x9e\x75\xfa\xb8\x78\xf8\xf5\xfa\xdc"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 12, 3840, 0x6543, "\xf1\x70\xcc\x2c\xb0\xbe\x3c\x2b\x21\x51\x80\x0c\x35\xf1\xf0\xef\xf5\x4c\x56\xe1\xad\x13\x8f\x83\x6a\xad\x1f\x1a\xec\x90\x25\x17\x36"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 11, 2400, $ssrc, "\xf8\xf8\xf8\xf5\x7a\xdc\xb5\xb5\x71\xfb\x9f\x78\xf2\x7b\x9a\xf6\xbb\x7b\x5c\xf8\xf4\x78\xb6\xdc\xf8\xdc\xf8\x78\x9e\xf1\x76\xbb\xdc\xf8\xf8\x7a\xde\xf8\xba\xf5\x75\xb8\x78\x9e\xfa\x78\xf8\xba\xf8\x73\xdc\xb5\x7a\xde\xf5\xf8\xf3\xfa\xde\xb5\x78\xdc\xb3\xfb\x7b\xf8\x9e\xde\xfa\xf8\x35\xf3\xf8\xfa\x9c\xba\xfa\x5e\xf3\x78\x5e\xb8\xb8\xf5\x5e\xf8\x75\x75\xb8\xfa\xba\x7a\xde\x78\xb5\xf5\xf1\x7b\xde\xf8\xf8\xba\xfa\xf8\xde\x78\xf8\xb7\xf5\xf5\x5e\x9e\xb8\x5c\x75\xf3\xf3\xdc\xda\xb6\xfb\x78\xdc\xb4\xf6\x5f\xf8\x9f\xf6\xdf\x76\x7b\x9f\xf8\x9e\xf1\xf8\xdf\x36\xf6\xfb\x9a\xf8\xf8\xf6\xf6\x38\xdf\xfb\x9f\xbb\xf8\xf5\x32\xfb\xdf\xdf\x9f\xf8\xf8", "\x78\x77\xba\x9e\x77\xf3\x9c\x78\xfa\xf5\xde\x75\x35\xf8\xba\xfa\xb5\x5e\xf8\x7a\xfa\xb8\x78\xf4\x5e\xf4\xf8\xb8\xf7\x5c\xf8\xba\x7a\xf7\xde\xf4\x77\xfa\xba\xfa\x77\xdb\xb5\xb8\xf5\xf8\xf8\x78\x5c\xfa\xb7\xfa\xf7\xde\xb0\x5e\xf8\xfa\x1e\xf5\xb5\xb5\x78\xf5\xfa\xd9\x78\xf5\xf8\xb5\x75\xf8\xdc\xba\xfa\xfa\xde\x71\x7a\x9e\xfa\xf8\xf8\xf8\xf8\xb8\xf7\xde\xf8\xb7\x7a\x7a\xb7\xfa\x9e\xf7\xfa\x7a\xd8\xf2\xba\x75\xfa\x9c\xfa\x5e\xb8\xf1\xf3\x78\xfa\x9c\x59\xfa\x73\xb6\xf8\xf6\x5f\x5a\xb8\xf6\xb8\xf8\xf0\xf9\x1c\xdf\xf8\xfb\xfb\xf6\xb6\xdc\xdf\xf8\x5f\x78\x75\xb2\x9f\xf8\xb8\x5f\xfb\xdf\x75\x74\xf8\xb6\x9f\x7b\xdf\x78\x78\xba\xb5\xf5\xf5\xfb"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 13, 4160, 0x6543, "\xf1\x70\xcc\x2c\xb0\xbe\x3c\x2b\x21\x51\x80\x0c\x35\xf1\xf0\xef\xf5\x4c\x56\xe1\xad\x13\x8f\x83\x6a\xad\x1f\x1a\xec\x90\x25\x17\x36"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 12, 2560, $ssrc, "\x78\x78\x75\xf8\x9e\xde\xb3\xfa\x78\x5e\xf8\xf8\xf8\xf8\xba\xfa\x5e\x72\xde\xb8\xf8\xf5\xf8\xde\x75\x9e\xf8\x75\xb8\xf8\xf7\xba\x5e\xf7\xfa\xfa\x7a\xde\xba\xf7\xfa\x9e\x74\xb4\x74\x7a\x7a\x9b\xba\x74\xf5\xf8\x75\xf3\xdc\xf8\xf8\xde\xb5\xf8\x73\xdf\xb5\x7b\xde\xf8\xde\xf5\xba\xf8\x78\xb8\xfa\xde\xf8\x78\xb7\x7a\xb7\xfa\x5e\xba\xfa\xfa\x5b\xba\x74\xf4\xf5\xf8\xfa\xfa\x9e\x74\xba\x7a\x74\xf4\xba\xfa\xfa\xdb\x74\xf5\xf8\xf8\xf5\xb8\xde\xf8\x77\xde\xba\x7a\x9e\xba\xf2\x5e\x5e\xb4\xf5\xf5\xde\xb5\x75\xf5\xf8\xfa\x78\x9c\xf5\x5c\xf8\xb5\xf5\xf3\xfb\x7b\x5c\xba\xde\xb8\xf5\x78\xb3\xfb\x78\xdc\x9e\x78\xb8\x71\xba\x75\x5c\xf8\xde\xf8\xf3\xdf", "\x76\x5f\xfb\xfa\xde\xb8\xf8\xf3\xdf\x78\x75\xf8\xb5\xdf\xb8\x78\xb5\x6f\xdf\xb6\x5a\xf6\xb9\x7b\xfb\xdd\x7b\xf8\xdc\xf8\xf2\xbb\x58\xb6\xf9\xdf\x78\x74\xbb\x5a\xb6\xfb\xfb\xb8\x38\xb6\x5a\xfb\xf8\xfb\xf6\x5f\xb4\x78\xdc\xf8\xf8\x78\xf8\xf1\xf6\xf8\xf8\x9c\x5a\xb8\xf6\xf8\xfb\x5f\xb6\xdc\xfb\xdf\xf1\xf4\x78\xf8\xb6\xdc\x58\xbb\xf8\xf2\x9f\xfb\xfb\x5f\xf6\xdf\x5f\xb4\xf6\xbb\xda\xf6\xf6\xdf\x7b\x78\xbb\xdc\xb4\xf8\xbb\x78\xfb\x5f\xf8\xb5\x7b\xba\xfa\xd5\xdc\x78\xb0\x76\xdc\xb6\xf8\x78\xdc\xdc\xf4\xf4\xf4\xf6\xfb\xda\x5f\xdf\xb4\xf4\xb3\xf3\x9d\x5b\xdf\xbb\x79\xb3\xf5\xdf\xf7\xfb\x5f\xdd\xb7\xf7\xfb\x77\xb9\x79\xdb\xb5\xf9\x5f\xf5\xb7"));
Time::HiRes::usleep(9000);
snd($sock_b, $port_a, rtp(96, 14, 4480, 0x6543, "\xf1\x70\xcc\x2c\xb0\xbe\x3c\x2b\x21\x51\x80\x0c\x35\xf1\xf0\xef\xf5\x4c\x56\xe1\xad\x13\x8f\x83\x6a\xad\x1f\x1a\xec\x90\x25\x17\x36"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 13, 2720, $ssrc, "\xfa\xdc\xf5\x7a\xfa\xba\xf8\xb8\x75\xdc\xf8\xf8\xf3\x7a\xf8\xfa\x9c\xb5\x7a\x9e\xf1\xf5\x75\xdf\x75\x9f\xb8\xf5\x9f\xf5\x36\xfb\xdf\xf8\xb8\xfa\xde\x78\xde\xf5\x78\xb5\xf5\xb8\xf8\x78\x7a\x5c\xb8\xf5\xfa\xf8\xfa\x7a\x7a\xde\xb2\xde\xb5\xf5\x75\x7a\xfa\x9e\xfa\x78\xfa\xfa\x9e\xf4\x77\xde\xb7\xf8\xf5\xf5\xf5\xfa\xfa\xde\x38\xb8\xfa\xf7\xde\xb7\xf8\x7a\xde\xf7\xfa\xb7\xb5\x78\xf8\xdc\x77\xf8\xb7\xf8\xfa\x77\xd9\x7a\xfa\xba\xb7\xf5\xf3\xd7\x5a\xf6\xb8\xdf\xf8\xad\xf9\x5a\x5a\xb6\xbb\x79\xf3\xf7\xdf\xdd\xdf\xfb\xfb\xb6\x76\xdd\xbb\xdd\x79\x9f\xb6\x76\x79\xb9\xf9\x7b\xd8\xfb\xf3\xb6\x5d\xfb\xf9\x5f\xbb\x74\xb4\x7b\x5d\xfb\xdf\xfb\xfb\xf8", "\x5f\x9f\xf5\x79\xdf\xdd\xf5\xf9\x73\xbb\xf9\xf9\x9f\xfb\x5f\x73\xbb\xf5\x79\xbb\xfb\xdf\xf6\xdf\x75\xfb\xb7\x5f\x9f\xf6\x5f\xb6\x73\xf7\xfb\xb9\xdf\x5f\x9f\x75\x77\xfb\xf7\xb9\xf7\xdf\xf7\xdd\xf9\x75\xf9\xf7\x9f\xf5\xf9\xfb\xf9\xfb\xbb\xfb\x79\xfb\xbb\x9a\xf6\x76\xdf\xf3\xbb\x7b\xdf\xfb\xb9\x7b\xfb\xf9\xf8\xfb\xb8\xdf\x74\xfb\xbb\xf8\xda\xb8\xf6\xf8\x74\xdc\xf6\x9f\xb6\xfb\xfb\xf8\x36\xbb\xfb\xfb\x9e\x7a\xfa\x7a\xde\xf5\x73\x9c\xf3\xdc\x7b\xfb\xfb\x5f\x9e\xb3\xf8\xfb\x1c\xf5\xf8\xfb\xde\xb5\xf5\xf6\x7b\xf8\x74\x9a\xf6\xdc\xb6\xf6\x38\xf8\xb8\x5f\x76\xbb\xdf\xf6\xf8\x7b\xf4\xfb\x5f\x9f\xb8\xf8\x78\x71\xfb\x78\xd9\xb6\xdc\xf8\x70\xdc"));
Time::HiRes::usleep(9000);
# more DTMF
snd($sock_b, $port_a, rtp(97, 15, 4800, 0x6543, "\x02\x07\x01\x40"));
Time::HiRes::usleep(9000);
rcv($sock_a, $port_b, rtpm(9, $seq + 14, 2880, $ssrc, "\x7b\xf8\xb8\xdc\xb5\x78\xf6\xfb\x76\xdc\xbb\xba\x7a\x7a\xdc\xb3\xfb\xf8\x5e\xb8\xf5\xf5\xf5\x7b\x5e\x9c\xf1\x78\xdf\xb6\x74\xbb\xdf\xf8\xf8\xfa\xde\x73\xdf\xf6\x78\xb8\xf8\xba\xf8\xde\x75\xde\xb3\x76\xfb\xfb\xdf\xb8\xde\xf5\x71\xf8\xf8\xf6\x38\xda\xb8\xbb\xf6\xf8\xfb\x34\xdf\xdc\x74\xb8\xbb\xf8\xf5\x78\xfa\x7a\xba\xde\x78\xf8\xb8\x75\x7a\xfa\xfa\x5e\xf7\x9e\xf7\xf5\xf3\xb8\xf8\x5e\x75\xba\x9e\xf8\xf3\xf5\x5f\xf8\xf8\xfa\xfa\xba\xfa\xdc\x3a\xf8\xde\xfa\x9e\xb2\xfa\xfa\x1e\xf7\xf5\xfa\x9e\xb2\xf8\x78\x5e\x78\xf5\xfa\xb8\xfa\xfa\xde\x77\x7a\xba\xfa\xfa\xf7\xde\xf4\xf7\x1b\xb1\xb5\x78\xde\xfa\xf8\xfa\x75\xba\xf8\x5c\xf8\xfa\xde\x70\xfa"));
Time::HiRes::usleep(9000);

# reverse flow
snd($sock_a, $port_b, rtp(9, 100, 7000, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
($seq, $ssrc) = rcv($sock_b, $port_a, rtpm(96, -1, 7000, -1, "\xf1\x54\x54\x3c\x58\x28\x92\xb6\x34\x42\x0b\x59\x8b\x52\x1c\x0d\xa0\xa6\x70\x16\xf8\x9a\x2d\x5e\xf0\x53\xb6\x78\x02\x1d\xff\x54\x12"));
Time::HiRes::usleep(9000);
snd($sock_a, $port_b, rtp(9, 101, 7160, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
rcv($sock_b, $port_a, rtpm(96, $seq + 1, 7320, $ssrc, "\xf1\x58\x42\x86\x17\xb7\xe1\xa2\x9c\x79\x5b\x43\x82\x64\xcc\xd1\xe0\xe4\xf8\x67\x69\x3d\x3e\x9e\xd8\x75\x34\xa9\xb2\xa5\x47\x81\x32"));
Time::HiRes::usleep(9000);
snd($sock_a, $port_b, rtp(9, 102, 7320, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
rcv($sock_b, $port_a, rtpm(96, $seq + 2, 7640, $ssrc, "\xf1\x50\x42\xfe\x51\x93\xf0\x66\xe8\x59\xeb\xb8\x05\x4a\x5a\x01\xa2\x3d\xf0\x29\x4d\xbd\x9c\x2e\x9f\x2d\x3f\x85\xfa\x1d\x47\x1f\xfa"));
# DTMF
Time::HiRes::usleep(9000);
snd($sock_a, $port_b, rtp(101, 103, 7480, 0x9876, "\x01\x07\x00\xa0"));
Time::HiRes::usleep(9000);
rcv($sock_b, $port_a, rtpm(97, $seq + 3, 7960, $ssrc, "\x01\x07\x01\x40"));
Time::HiRes::usleep(9000);
snd($sock_a, $port_b, rtp(101, 104, 7480, 0x9876, "\x01\x07\x01\x40"));
Time::HiRes::usleep(9000);
rcv($sock_b, $port_a, rtpm(97, $seq + 4, 7960, $ssrc, "\x01\x07\x02\x80"));
# end
Time::HiRes::usleep(9000);
snd($sock_a, $port_b, rtp(101, 105, 7480, 0x9876, "\x01\x87\x01\xe0"));
Time::HiRes::usleep(1000);
snd($sock_a, $port_b, rtp(101, 106, 7480, 0x9876, "\x01\x87\x01\xe0"));
Time::HiRes::usleep(1000);
snd($sock_a, $port_b, rtp(101, 107, 7480, 0x9876, "\x01\x87\x01\xe0"));
Time::HiRes::usleep(9000);
rcv($sock_b, $port_a, rtpm(97, $seq + 5, 7960, $ssrc, "\x01\x87\x03\xc0"));
Time::HiRes::usleep(1000);
rcv($sock_b, $port_a, rtpm(97, $seq + 6, 7960, $ssrc, "\x01\x87\x03\xc0"));
Time::HiRes::usleep(1000);
rcv($sock_b, $port_a, rtpm(97, $seq + 7, 7960, $ssrc, "\x01\x87\x03\xc0"));
Time::HiRes::usleep(9000);
# more audio
snd($sock_a, $port_b, rtp(9, 108, 7960, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
rcv($sock_b, $port_a, rtpm(96, $seq + 8, 8920, $ssrc, "\xf1\x50\x42\x86\xbe\xb7\x49\xe3\x7c\x53\x43\x18\x47\xe1\x6c\x71\xa2\xf6\x76\x20\xcd\x3f\x1f\x7a\x9e\x17\x06\xdc\x72\xf4\xf4\x5f\x7a", "\xf1\x50\x48\x7c\x22\x20\x80\x00\xcd\x74\xa2\x2d\x11\x43\x52\x01\xbe\x17\x02\x01\x6b\x25\x5a\x46\x03\x06\x35\x43\x00\x32\xf5\x5d\x12"));
Time::HiRes::usleep(9000);
snd($sock_a, $port_b, rtp(9, 109, 8120, 0x9876, "\xfb\xb8\xde\xde\x71\xb6\xfb\xdf\xf6\xf8\x9a\xfb\xf4\xf4\x78\xf6\x9f\x5f\xb8\xbb\xfb\x78\xf8\xfa\xfa\xb8\xfa\xfa\xf8\x7a\x5e\xb4\xb8\xfa\xb7\x5e\xec\x78\xf8\xba\xde\x78\xba\xde\x78\x73\xde\xb8\xf5\xb5\x7a\xde\xf1\x70\xf6\xdf\xdf\x9f\xfb\xb8\x74\xf6\x76\xdf\xdc\xb8\xdc\x9f\x70\x74\x76\xdf\xdf\x9f\xb8\xfb\x78\x74\xf6\xfb\xdc\xb2\xdc\xdc\x5f\xf4\xf2\xfb\xdd\xb9\xf8\xfb\x9f\xdc\x7b\xb6\xfb\xf8\xf8\x9e\xfa\x78\xdc\xf5\xb8\x75\xb5\xfa\x5c\xf5\xf5\x9f\xf8\xf5\xf5\x76\x9c\x70\x96\xdf\xf9\x76\xf6\xb9\x73\x9b\x7b\xdf\xfb\xf4\xf4\xf7\x9d\xdd\x59\xf7\x77\xb5\xf9\xf9\xb9\xfb\xd9\x77\xf5\xf9\xf7\xb9\xf7\xdd\xdf\xf7\xb9\xf7\x9d\x5f\xf7\xf9\xf9\xf7"));
Time::HiRes::usleep(9000);
rcv($sock_b, $port_a, rtpm(96, $seq + 9, 9240, $ssrc, "\xf1\x58\x43\x82\x36\x15\x27\x26\xb5\x6a\xfb\x25\xc1\x21\x4c\x69\xe5\x76\x06\x4a\xe0\x6e\x9a\xbe\x9c\x87\x52\x8c\xf7\x67\xe5\xa7\xf6", "\xf1\x50\x11\x80\x0c\xcd\x33\xc8\x58\x5f\xca\xe0\x34\xf9\xb6\xc4\x1e\x80\x80\x11\x90\x01\x83\x02\x08\x81\x01\x05\x98\x80\x01\x09\x16"));
# more DTMF
Time::HiRes::usleep(9000);
snd($sock_a, $port_b, rtp(101, 110, 8280, 0x9876, "\x01\x07\x00\xa0"));
Time::HiRes::usleep(9000);
rcv($sock_b, $port_a, rtpm(96, $seq + 10, 9560, $ssrc, "\xf1\x51\x41\x51\x59\x4c\x14\xe2\x95\x09\x0a\x1a\x05\x2c\xdc\xc9\xa2\x63\x71\x29\xdc\xc2\x6d\xff\xb2\x41\x77\xdd\xb4\x67\x5f\xd7\xb4"));
Time::HiRes::usleep(9000);
snd($sock_a, $port_b, rtp(101, 111, 8280, 0x9876, "\x01\x07\x01\x40"));
Time::HiRes::usleep(9000);
rcv($sock_b, $port_a, rtpm(96, $seq + 11, 9880, $ssrc, "\xf1\x58\x43\x02\x1c\x1c\x85\x3a\x34\x8a\x7b\x93\xa1\x16\xac\xe1\xa4\x76\x66\x00\xed\x7f\x9f\xce\x9e\x87\x96\xec\xfa\x65\xec\xe7\x7a"));





rtpe_req('delete', 'AMR w reverse DTMF', { 'from-tag' => ft() });

}


($sock_a, $sock_b) = new_call([qw(198.51.100.10 5000)], [qw(198.51.100.10 5002)]);

($port_a) = offer('G.711 DTX',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5000 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 8
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711 DTX',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5002 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(0, 2000, 4000, 0x5678, "\x40" x 160));
($seq, $ssrc) = rcv($sock_b, $port_a, rtpm(8, -1, 4000, -1, "\x68" x 160));
snd($sock_a, $port_b, rtp(0, 2001, 4160, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 1, 4160, $ssrc, "\x68" x 160));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(8, $seq + 2, 4320, $ssrc, "\xd5" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 3, 4480, $ssrc, "\xd5" x 160));
# start audio again
snd($sock_a, $port_b, rtp(0, 2002, 4640, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 4, 4640, $ssrc, "\x68" x 160));

rtpe_req('delete', 'G.711 DTX', { 'from-tag' => ft() });



($sock_a, $sock_b) = new_call([qw(198.51.100.10 5032)], [qw(198.51.100.10 5034)]);

($port_a) = offer('G.711 DTX with seq skips',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5032 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 8
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711 DTX with seq skips',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5034 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

$ts = 2000;
snd($sock_a, $port_b, rtp(0,       4000, $ts +      0, 0x5678, "\x40" x 160));
($seq, $ssrc) = rcv($sock_b, $port_a,
                      rtpm(8,        -1, $ts +      0, -1, "\x68" x 160));
snd($sock_a, $port_b, rtp(0,       4001, $ts +    160, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq +  1, $ts +    160, $ssrc, "\x68" x 160));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(8, $seq +  2, $ts +    320, $ssrc, "\xd5" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq +  3, $ts +    480, $ssrc, "\xd5" x 160));
# start audio again
snd($sock_a, $port_b, rtp(0,       4002, $ts +    640, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq +  4, $ts +    640, $ssrc, "\x68" x 160));
snd($sock_a, $port_b, rtp(0,       4003, $ts +    800, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq +  5, $ts +    800, $ssrc, "\x68" x 160));
snd($sock_a, $port_b, rtp(0,       4004, $ts +    960, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq +  6, $ts +    960, $ssrc, "\x68" x 160));
snd($sock_a, $port_b, rtp(0,       4005, $ts +   1120, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq +  7, $ts +   1120, $ssrc, "\x68" x 160));
snd($sock_a, $port_b, rtp(0,       4006, $ts +   1280, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq +  8, $ts +   1280, $ssrc, "\x68" x 160));
snd($sock_a, $port_b, rtp(0,       4007, $ts +   1440, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq +  9, $ts +   1440, $ssrc, "\x68" x 160));
# lost packet 4008 (skip seq), trigger DTX
rcv($sock_b, $port_a, rtpm(8, $seq + 10, $ts +   1600, $ssrc, "\xd5" x 160));
# resume
snd($sock_a, $port_b, rtp(0,       4009, $ts +   1760, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 11, $ts +   1760, $ssrc, "\xd5" x 160));
snd($sock_a, $port_b, rtp(0,       4010, $ts +   1920, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 12, $ts +   1920, $ssrc, "\x68" x 160));
snd($sock_a, $port_b, rtp(0,       4011, $ts +   2080, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 13, $ts +   2080, $ssrc, "\xd5" x 160));
snd($sock_a, $port_b, rtp(0,       4012, $ts +   2240, 0x5678, "\x40" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 14, $ts +   2240, $ssrc, "\x68" x 160));

rtpe_req('delete', 'G.711 DTX with seq skips', { 'from-tag' => ft() });



($sock_a, $sock_b) = new_call([qw(198.51.100.10 5004)], [qw(198.51.100.10 5006)]);

($port_a) = offer('G.711 DTX ptime=30',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5004 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
a=ptime:30
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 8
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
a=ptime:30
SDP

($port_b) = answer('G.711 DTX ptime=30',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5006 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
a=ptime:30
SDP

snd($sock_a, $port_b, rtp(0, 2000, 4000, 0x5678, "\x40" x 240));
($seq, $ssrc) = rcv($sock_b, $port_a, rtpm(8, -1, 4000, -1, "\x68" x 240));
snd($sock_a, $port_b, rtp(0, 2001, 4240, 0x5678, "\x40" x 240));
rcv($sock_b, $port_a, rtpm(8, $seq + 1, 4240, $ssrc, "\x68" x 240));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(8, $seq + 2, 4480, $ssrc, "\xd5" x 240));
rcv($sock_b, $port_a, rtpm(8, $seq + 3, 4720, $ssrc, "\xd5" x 240));
# start audio again
snd($sock_a, $port_b, rtp(0, 2002, 4960, 0x5678, "\x40" x 240));
rcv($sock_b, $port_a, rtpm(8, $seq + 4, 4960, $ssrc, "\x68" x 240));

rtpe_req('delete', 'G.711 DTX ptime=30', { 'from-tag' => ft() });




($sock_a, $sock_b) = new_call([qw(198.51.100.10 5008)], [qw(198.51.100.10 5010)]);

($port_a) = offer('G.711 DTX ptime change',
	{ replace => ['origin'], codec => {
			transcode => ['PCMA'],
	} }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5008 RTP/AVP 0
c=IN IP4 198.51.100.10
a=sendrecv
----------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0 8
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=rtpmap:8 PCMA/8000
a=sendrecv
a=rtcp:PORT
SDP

($port_b) = answer('G.711 DTX ptime change',
	{ replace => ['origin'] }, <<SDP);
v=0
o=- 1545997027 1 IN IP4 198.51.100.10
s=tester
t=0 0
m=audio 5010 RTP/AVP 8
c=IN IP4 198.51.100.10
a=sendrecv
--------------------------------------
v=0
o=- 1545997027 1 IN IP4 203.0.113.1
s=tester
t=0 0
m=audio PORT RTP/AVP 0
c=IN IP4 203.0.113.1
a=rtpmap:0 PCMU/8000
a=sendrecv
a=rtcp:PORT
SDP

snd($sock_a, $port_b, rtp(0, 2000, 4000, 0x5678, "\x40" x 240));
($seq, $ssrc) = rcv($sock_b, $port_a, rtpm(8, -1, 4000, -1, "\x68" x 160));
snd($sock_a, $port_b, rtp(0, 2001, 4240, 0x5678, "\x40" x 240));
rcv($sock_b, $port_a, rtpm(8, $seq + 1, 4160, $ssrc, "\x68" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 2, 4320, $ssrc, "\x68" x 160));
# DTX -> silence
rcv($sock_b, $port_a, rtpm(8, $seq + 3, 4480, $ssrc, "\xd5" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 4, 4640, $ssrc, "\xd5" x 160));
rcv($sock_b, $port_a, rtpm(8, $seq + 5, 4800, $ssrc, "\xd5" x 160));
# start audio again
snd($sock_a, $port_b, rtp(0, 2002, 4960, 0x5678, "\x40" x 240));
rcv($sock_b, $port_a, rtpm(8, $seq + 6, 4960, $ssrc, "\x68" x 160));

rtpe_req('delete', 'G.711 DTX ptime change', { 'from-tag' => ft() });



#done_testing;NGCP::Rtpengine::AutoTest::terminate('f00');exit;
done_testing();
