/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef STATIC_TABLES_H
#define STATIC_TABLES_H

#include "common/array.h"

// Static data tables for Teenagent engine

// Unpacked Executable MD5sum - 51b6d64721f7c4b498bfc0f323013e36

// Code Segment
// starts at offset 0x0200 in original executable
#define CSEG_SIZE 46000 // 0xb3b0

const static uint8 cseg[CSEG_SIZE] = {
	0xb8, 0x3b, 0x0b, 0x8e, 0xd8, 0x8e, 0xc0, 0xe9,
	0xd2, 0x00, 0x9c, 0xfa, 0x60, 0x1e, 0x06, 0xb8,
	0x3b, 0x0b, 0x8e, 0xd8, 0xeb, 0x0e, 0xa0, 0x48,
	0x32, 0xb4, 0x03, 0xff, 0x1e, 0x4a, 0x32, 0xb8,
	0x3b, 0x0b, 0x8e, 0xd8, 0x8e, 0xc0, 0xbb, 0x86,
	0x32, 0xff, 0x07, 0x75, 0x03, 0xff, 0x47, 0x02,
	0x33, 0xc0, 0xe8, 0xce, 0xa4, 0xff, 0x0e, 0x7f,
	0x32, 0x75, 0x14, 0xa1, 0x81, 0x32, 0xa3, 0x7f,
	0x32, 0x33, 0xc0, 0x8e, 0xd8, 0xbb, 0x6c, 0x04,
	0xff, 0x07, 0x75, 0x03, 0xff, 0x47, 0x02, 0xb0,
	0x20, 0xe6, 0x20, 0x07, 0x1f, 0x61, 0xfb, 0x9d,
	0xcf, 0x9c, 0xfa, 0x60, 0x1e, 0x06, 0xb8, 0x3b,
	0x0b, 0x8e, 0xd8, 0xeb, 0x15, 0x80, 0x3e, 0x47,
	0x32, 0x00, 0x74, 0x0e, 0xa0, 0x48, 0x32, 0xb4,
	0x03, 0xff, 0x1e, 0x4a, 0x32, 0xb8, 0x3b, 0x0b,
	0x8e, 0xd8, 0x8e, 0xc0, 0xfe, 0x0e, 0x83, 0x32,
	0x75, 0x14, 0xc6, 0x06, 0x83, 0x32, 0x6e, 0xbb,
	0x86, 0x32, 0xff, 0x07, 0x75, 0x03, 0xff, 0x47,
	0x02, 0x33, 0xc0, 0xe8, 0x6d, 0xa4, 0xff, 0x0e,
	0x7f, 0x32, 0x75, 0x14, 0xa1, 0x81, 0x32, 0xa3,
	0x7f, 0x32, 0x33, 0xc0, 0x8e, 0xd8, 0xbb, 0x6c,
	0x04, 0xff, 0x07, 0x75, 0x03, 0xff, 0x47, 0x02,
	0xb0, 0x20, 0xe6, 0x20, 0x07, 0x1f, 0x61, 0xfb,
	0x9d, 0xcf, 0x9c, 0x50, 0xe4, 0x60, 0x2e, 0xa2,
	0xd7, 0x00, 0xe4, 0x61, 0x8a, 0xe0, 0x0c, 0x80,
	0xe6, 0x61, 0x86, 0xe0, 0xe6, 0x61, 0xeb, 0x00,
	0xb0, 0x20, 0xe6, 0x20, 0x58, 0x9d, 0xcf, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xb4, 0x2c, 0xcd, 0x21,
	0xbb, 0x5f, 0xb1, 0x2e, 0x89, 0x0f, 0x2e, 0x89,
	0x57, 0x02, 0xe8, 0xfc, 0xa3, 0xe8, 0xb1, 0xb0,
	0xe8, 0xce, 0xaf, 0xe8, 0xee, 0xb0, 0xe8, 0x18,
	0xa8, 0xe8, 0x4d, 0xb2, 0xe8, 0xde, 0xa4, 0xb9,
	0x01, 0x00, 0xe8, 0x46, 0xb0, 0xfa, 0xb8, 0x88,
	0xc0, 0xbb, 0x14, 0x00, 0x2e, 0x89, 0x07, 0xbb,
	0x63, 0x00, 0x2e, 0x89, 0x07, 0xfb, 0xe8, 0x38,
	0x0a, 0xe8, 0x49, 0x0a, 0xe8, 0x6f, 0x0a, 0xe8,
	0x79, 0x0a, 0xe8, 0x9a, 0x0a, 0xe8, 0xb5, 0x0a,
	0xb8, 0x3b, 0x0b, 0xa3, 0xac, 0x00, 0xb8, 0x3a,
	0x01, 0xa3, 0xaa, 0x00, 0xb9, 0x07, 0x00, 0xba,
	0x54, 0x00, 0xe8, 0x33, 0xae, 0xa1, 0xbf, 0x32,
	0xa3, 0xac, 0x00, 0x33, 0xc0, 0xa3, 0xaa, 0x00,
	0xb9, 0x01, 0x00, 0xba, 0x54, 0x00, 0xe8, 0x1f,
	0xae, 0xe8, 0x82, 0x05, 0xe8, 0xf5, 0x00, 0xb9,
	0x04, 0x00, 0xe8, 0xee, 0xaf, 0xb8, 0x88, 0x00,
	0xbb, 0x99, 0x00, 0xbf, 0x8b, 0x00, 0xbe, 0x9c,
	0x00, 0xb5, 0x03, 0xb1, 0x0b, 0xc7, 0x06, 0xf3,
	0xb4, 0x0a, 0x00, 0xe8, 0x6d, 0xaa, 0xe8, 0x86,
	0xa4, 0xe8, 0x04, 0x07, 0xe8, 0xa0, 0x1e, 0xe8,
	0x03, 0x2a, 0xe8, 0x94, 0x33, 0xe8, 0xc8, 0x34,
	0xe8, 0x22, 0x33, 0xe8, 0x57, 0x33, 0xe8, 0xe5,
	0x1d, 0xe8, 0x12, 0x27, 0xe8, 0x0d, 0xa5, 0xb3,
	0x01, 0x72, 0x07, 0xe8, 0x35, 0xa5, 0xb3, 0x00,
	0x73, 0xd7, 0xe8, 0xf6, 0xa1, 0xeb, 0xd2, 0xb8,
	0x03, 0x00, 0xcd, 0x10, 0xb4, 0x02, 0xff, 0x1e,
	0x4a, 0x32, 0xb8, 0x3b, 0x0b, 0x8e, 0xd8, 0x8e,
	0xc0, 0xe9, 0xd8, 0xb1, 0xe8, 0x86, 0x9a, 0xe8,
	0x77, 0x00, 0xe8, 0x8f, 0x9a, 0xbb, 0x88, 0xe4,
	0x33, 0xf6, 0x33, 0xff, 0x06, 0xa1, 0xb1, 0x32,
	0x8e, 0xc0, 0x53, 0xe8, 0x26, 0x00, 0xe8, 0x19,
	0x00, 0x5b, 0x53, 0xe8, 0xca, 0xa2, 0xbe, 0x40,
	0x01, 0x2b, 0xf0, 0xd1, 0xee, 0x5b, 0xe8, 0x6c,
	0xa2, 0x43, 0x8a, 0x07, 0x0a, 0xc0, 0x75, 0xe2,
	0x07, 0xc3, 0xa1, 0xb1, 0x32, 0xb9, 0xe0, 0x06,
	0xe8, 0x05, 0xab, 0xc3, 0x1e, 0x06, 0x8c, 0xc0,
	0x8e, 0xd8, 0xb8, 0x00, 0xa0, 0x8e, 0xc0, 0x33,
	0xf6, 0xbf, 0xbf, 0xf8, 0xb9, 0x0b, 0x00, 0x51,
	0xb9, 0xa0, 0x00, 0x57, 0xf3, 0xa5, 0x56, 0xe8,
	0x08, 0x00, 0x5e, 0x5f, 0x59, 0xe2, 0xf0, 0x07,
	0x1f, 0xc3, 0xe8, 0xeb, 0xa4, 0xe8, 0xe8, 0xa4,
	0x1e, 0x8c, 0xc0, 0x8e, 0xd8, 0x33, 0xff, 0xbe,
	0x40, 0x01, 0xb9, 0x00, 0x7d, 0xf3, 0xa5, 0x1f,
	0xc3, 0xb8, 0x00, 0xa0, 0xb9, 0x00, 0x7d, 0xe8,
	0xbe, 0xaa, 0xa1, 0xb1, 0x32, 0xb9, 0x00, 0x7d,
	0xe8, 0xb5, 0xaa, 0xc3, 0xe8, 0x7c, 0x03, 0xe8,
	0x6c, 0x03, 0xc7, 0x06, 0xf3, 0xb4, 0x29, 0x00,
	0xb8, 0x8b, 0x00, 0xbb, 0x9c, 0x00, 0x8b, 0xf8,
	0x8b, 0xf3, 0xb5, 0x03, 0xb1, 0x0b, 0xe8, 0x8c,
	0xa9, 0xe8, 0xfc, 0xa9, 0xe8, 0x5c, 0x03, 0xe8,
	0x4c, 0x03, 0xe8, 0x97, 0xaa, 0xe8, 0x46, 0x03,
	0xb8, 0xc8, 0x00, 0xe8, 0xbc, 0x1c, 0xe8, 0x3d,
	0x03, 0xb9, 0x29, 0x00, 0xb0, 0x0c, 0xb4, 0x04,
	0xe8, 0x72, 0xa7, 0xbb, 0x47, 0x33, 0xc7, 0x47,
	0x02, 0x90, 0x03, 0xb0, 0x02, 0xe8, 0xca, 0x17,
	0xe8, 0x23, 0x03, 0xe8, 0x4a, 0x3d, 0xc6, 0x07,
	0x6c, 0xe8, 0xfe, 0xab, 0xb9, 0x3e, 0x00, 0xb0,
	0x08, 0xb4, 0x04, 0xe8, 0x4f, 0xa7, 0xb9, 0x3a,
	0x00, 0xb0, 0x28, 0xb4, 0x0a, 0xe8, 0x4e, 0xa7,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0x91, 0x03,
	0xb0, 0x02, 0xe8, 0x9d, 0x17, 0xe8, 0xf6, 0x02,
	0xe8, 0x1d, 0x3d, 0xc6, 0x47, 0x01, 0x6d, 0xe8,
	0xd0, 0xab, 0xc6, 0x06, 0x45, 0x33, 0xe7, 0xc6,
	0x06, 0x46, 0x33, 0xd7, 0xb0, 0x02, 0xb4, 0x01,
	0xbe, 0x92, 0x03, 0xbf, 0x93, 0x03, 0xbb, 0x8e,
	0x74, 0xe8, 0x82, 0x11, 0xe8, 0xcf, 0x02, 0xbb,
	0xc2, 0xe3, 0xe8, 0xe9, 0x02, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0x94, 0x03, 0xc7, 0x06, 0xf3,
	0xb4, 0x2a, 0x00, 0xe8, 0x06, 0xaa, 0xe8, 0xb5,
	0x02, 0xb9, 0x0f, 0x00, 0xb0, 0x14, 0xb4, 0x03,
	0xe8, 0xea, 0xa6, 0xbb, 0x47, 0x33, 0xc7, 0x47,
	0x02, 0x94, 0x03, 0xb0, 0x02, 0xe8, 0x42, 0x17,
	0xe8, 0x9b, 0x02, 0xb9, 0x28, 0x00, 0xb0, 0x12,
	0xb4, 0x0e, 0xe8, 0xd0, 0xa6, 0xb0, 0x16, 0xe8,
	0xd4, 0xa6, 0xb0, 0x1b, 0xe8, 0xd6, 0xa6, 0xb0,
	0x1d, 0xe8, 0xd8, 0xa6, 0xb0, 0x1f, 0xe8, 0xda,
	0xa6, 0xb0, 0x21, 0xe8, 0xe3, 0xa6, 0xb0, 0x23,
	0xe8, 0xe5, 0xa6, 0xb0, 0x25, 0xe8, 0xe7, 0xa6,
	0xb9, 0x1d, 0x00, 0xb0, 0x2c, 0xe8, 0xe6, 0xa6,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x96, 0x03, 0xc7,
	0x47, 0x02, 0x95, 0x03, 0xb0, 0x01, 0xe8, 0xf9,
	0x16, 0xe8, 0x52, 0x02, 0xbb, 0xe6, 0xe3, 0xe8,
	0x6c, 0x02, 0xb9, 0x03, 0x00, 0xe8, 0xd3, 0xad,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x98, 0x03, 0xc7,
	0x47, 0x02, 0x9c, 0x03, 0xc7, 0x06, 0xf3, 0xb4,
	0x28, 0x00, 0xe8, 0x7f, 0xa9, 0xe8, 0x2e, 0x02,
	0xc6, 0x06, 0x45, 0x33, 0xe7, 0xc6, 0x06, 0x46,
	0x33, 0xeb, 0xb0, 0x01, 0xb4, 0x02, 0xbe, 0x98,
	0x03, 0xbf, 0x9c, 0x03, 0xbb, 0x0d, 0x75, 0xe8,
	0xc4, 0x10, 0xe8, 0x11, 0x02, 0xb9, 0x1a, 0x00,
	0xb0, 0x32, 0xb4, 0x0a, 0xe8, 0x46, 0xa6, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0x9d, 0x03, 0xc7, 0x47,
	0x02, 0x9e, 0x03, 0xb0, 0x01, 0xe8, 0x9a, 0x16,
	0xe8, 0xf3, 0x01, 0xc6, 0x06, 0x45, 0x33, 0xeb,
	0xb0, 0x02, 0xb4, 0x01, 0xbe, 0x9f, 0x03, 0xbf,
	0x98, 0x03, 0xbb, 0xa6, 0x78, 0xe8, 0x8e, 0x10,
	0xe8, 0xdb, 0x01, 0xbb, 0xff, 0xe3, 0xe8, 0xf5,
	0x01, 0xb9, 0x0b, 0x00, 0xe8, 0x5c, 0xad, 0xc7,
	0x06, 0xf3, 0xb4, 0x27, 0x00, 0xe8, 0x14, 0xa9,
	0xe8, 0xc3, 0x01, 0xb8, 0xc8, 0x00, 0xe8, 0x39,
	0x1b, 0xe8, 0xba, 0x01, 0xb9, 0x51, 0x00, 0xb0,
	0x02, 0xb4, 0x0e, 0xe8, 0xef, 0xa5, 0xb0, 0x05,
	0xb4, 0x0b, 0xe8, 0xf1, 0xa5, 0xb0, 0x08, 0xb4,
	0x08, 0xe8, 0xf1, 0xa5, 0xb0, 0x0b, 0xb4, 0x06,
	0xe8, 0xf1, 0xa5, 0xb0, 0x0e, 0xb4, 0x05, 0xe8,
	0xf1, 0xa5, 0xb0, 0x10, 0xb4, 0x03, 0xe8, 0xf1,
	0xa5, 0xb0, 0x10, 0xe8, 0xf3, 0xa5, 0xb0, 0x12,
	0xe8, 0xf5, 0xa5, 0xb0, 0x14, 0xe8, 0xf7, 0xa5,
	0xb0, 0x15, 0xe8, 0xf9, 0xa5, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0xa0, 0x03, 0xb0, 0x02, 0xe8,
	0x10, 0x16, 0xe8, 0x49, 0xa6, 0xe8, 0x66, 0x01,
	0xe8, 0x8d, 0x3b, 0xc6, 0x07, 0x70, 0xe8, 0x41,
	0xaa, 0xe8, 0xf1, 0x1a, 0xe8, 0x57, 0x01, 0xc6,
	0x06, 0x45, 0x33, 0xd1, 0xb0, 0x01, 0xbe, 0xa1,
	0x03, 0xbb, 0xe1, 0x78, 0xe8, 0x80, 0x11, 0xe8,
	0x44, 0x01, 0xe8, 0xd8, 0x1a, 0xe8, 0x3e, 0x01,
	0xc6, 0x06, 0xdc, 0x1c, 0x02, 0xc7, 0x06, 0xaf,
	0x64, 0x3f, 0x01, 0xc7, 0x06, 0xb1, 0x64, 0x96,
	0x00, 0xbe, 0x3f, 0x00, 0xbf, 0x96, 0x00, 0xc6,
	0x06, 0xc3, 0x64, 0x01, 0xe8, 0x8c, 0x31, 0xe8,
	0x1c, 0x01, 0xc6, 0x06, 0x35, 0x33, 0x12, 0xc6,
	0x06, 0x36, 0x33, 0x24, 0xb8, 0xa8, 0x5d, 0xa3,
	0x37, 0x33, 0xb8, 0x84, 0x4d, 0xa3, 0x39, 0x33,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x53, 0x03, 0xb9,
	0xa2, 0x03, 0xe8, 0xaa, 0x16, 0xe8, 0xf6, 0x00,
	0xb9, 0x18, 0x00, 0xb0, 0x0b, 0xb4, 0x02, 0xe8,
	0x2b, 0xa5, 0xb9, 0xa3, 0x03, 0xe8, 0x1a, 0x16,
	0xe8, 0xb8, 0xa6, 0xe8, 0xe0, 0x00, 0xbb, 0x2f,
	0xe4, 0xe8, 0xfa, 0x00, 0xb9, 0x03, 0x00, 0xe8,
	0x61, 0xac, 0xc7, 0x06, 0xaf, 0x64, 0x32, 0x00,
	0xc7, 0x06, 0xb1, 0x64, 0xba, 0x00, 0xc6, 0x06,
	0xcc, 0x64, 0x01, 0xc6, 0x06, 0xdc, 0x64, 0x00,
	0xc6, 0x06, 0xcb, 0x64, 0x00, 0xe8, 0x71, 0x39,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x97, 0x03, 0xc7,
	0x06, 0xf3, 0xb4, 0x28, 0x00, 0xe8, 0xd0, 0x3a,
	0xc6, 0x07, 0x71, 0xe8, 0xf7, 0xa7, 0xe8, 0x9d,
	0x00, 0xc6, 0x06, 0x45, 0x33, 0xe7, 0xb0, 0x01,
	0xbe, 0x97, 0x03, 0xbb, 0xf1, 0x78, 0xe8, 0xc6,
	0x10, 0xe8, 0x8a, 0x00, 0xbe, 0xc6, 0x00, 0xbf,
	0xba, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x01, 0xe8,
	0xe9, 0x30, 0xe8, 0x79, 0x00, 0xe8, 0x8f, 0x11,
	0xbb, 0x58, 0x79, 0xe8, 0x77, 0x0c, 0xb9, 0xa4,
	0x03, 0xe8, 0xc3, 0x15, 0xe8, 0x67, 0x00, 0xe8,
	0x7d, 0x11, 0xbb, 0x07, 0x7e, 0xe8, 0x65, 0x0c,
	0xb9, 0xa4, 0x03, 0xe8, 0xb1, 0x15, 0xe8, 0x55,
	0x00, 0xe8, 0x6b, 0x11, 0xbb, 0x1a, 0x7e, 0xe8,
	0x53, 0x0c, 0xb9, 0xa4, 0x03, 0xe8, 0x9f, 0x15,
	0xe8, 0x43, 0x00, 0xe8, 0x7c, 0x11, 0xbb, 0x2c,
	0x7e, 0xe8, 0x41, 0x0c, 0xb9, 0xa5, 0x03, 0xe8,
	0x8d, 0x15, 0xe8, 0x31, 0x00, 0xe8, 0x47, 0x11,
	0xbb, 0x70, 0x7e, 0xe8, 0x2f, 0x0c, 0xbe, 0xae,
	0x00, 0xbf, 0xba, 0x00, 0xc6, 0x06, 0xc3, 0x64,
	0x01, 0xe8, 0x87, 0x30, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x53, 0x03, 0xb9, 0xa6, 0x03, 0xe8, 0x66,
	0x15, 0xe8, 0x91, 0x96, 0xe8, 0x14, 0x00, 0xb8,
	0x64, 0x00, 0xe8, 0x9f, 0x19, 0xc3, 0x2e, 0x80,
	0x3e, 0xd7, 0x00, 0x01, 0x75, 0x04, 0x58, 0xe8,
	0xd4, 0xa4, 0xc3, 0x06, 0xa1, 0xb3, 0x32, 0x8e,
	0xc0, 0xbf, 0x00, 0xfa, 0xb9, 0x80, 0x01, 0x33,
	0xc0, 0xfc, 0xf3, 0xab, 0x07, 0xc3, 0x53, 0xe8,
	0x63, 0x96, 0xe8, 0x54, 0xfc, 0xa1, 0xb5, 0x32,
	0xa3, 0xac, 0x00, 0x33, 0xc0, 0xa3, 0xaa, 0x00,
	0xb9, 0x08, 0x00, 0xba, 0x54, 0x00, 0xe8, 0x77,
	0xa9, 0x5b, 0x8b, 0x17, 0x83, 0xc3, 0x02, 0x52,
	0x8a, 0x07, 0x32, 0xe4, 0xf7, 0x26, 0xb6, 0x00,
	0x8b, 0xf0, 0x53, 0xe8, 0x9b, 0x00, 0x5b, 0x5a,
	0x2d, 0x40, 0x01, 0xf7, 0xd8, 0xd1, 0xe8, 0x03,
	0xf0, 0x43, 0xe8, 0x25, 0x00, 0x43, 0x80, 0x3f,
	0x00, 0x75, 0xdc, 0xe8, 0x2e, 0x96, 0xbb, 0x92,
	0x32, 0xb9, 0x90, 0x01, 0xe8, 0xb4, 0xa2, 0xbb,
	0x92, 0x32, 0xe8, 0xc1, 0xa2, 0x72, 0x0a, 0xe8,
	0x99, 0xa0, 0x72, 0x05, 0xe8, 0x65, 0xa0, 0x73,
	0xee, 0xc3, 0x1e, 0x06, 0xb8, 0x00, 0xa0, 0x8e,
	0xc0, 0xa1, 0xb5, 0x32, 0x8e, 0xd8, 0xe8, 0x03,
	0x00, 0x07, 0x1f, 0xc3, 0x1e, 0xb8, 0x3b, 0x0b,
	0x8e, 0xd8, 0x8a, 0x0f, 0x1f, 0x0a, 0xc9, 0x74,
	0x47, 0x80, 0xe9, 0x1f, 0xb5, 0x00, 0xbf, 0xfe,
	0xff, 0xd1, 0xe1, 0x03, 0xf9, 0x8b, 0x3d, 0x8b,
	0x0d, 0x83, 0xc7, 0x02, 0x51, 0x56, 0x51, 0x56,
	0x8a, 0x05, 0x0a, 0xc0, 0x74, 0x0d, 0xfe, 0xc8,
	0x0a, 0xc0, 0x8a, 0xc2, 0x74, 0x02, 0x8a, 0xc6,
	0x26, 0x88, 0x04, 0x47, 0x46, 0xfe, 0xcd, 0x75,
	0xe7, 0x5e, 0x59, 0x81, 0xc6, 0x40, 0x01, 0xfe,
	0xc9, 0x75, 0xdb, 0x5e, 0x59, 0x8a, 0xc5, 0xb4,
	0x00, 0x03, 0xf0, 0x46, 0x46, 0x43, 0xeb, 0xac,
	0xc3, 0x33, 0xc0, 0x8a, 0x0f, 0x0a, 0xc9, 0x74,
	0x24, 0x42, 0x80, 0xe9, 0x1f, 0xb5, 0x00, 0xbf,
	0xfe, 0xff, 0xd1, 0xe1, 0x03, 0xf9, 0x1e, 0x8b,
	0x16, 0xb5, 0x32, 0x8e, 0xda, 0x8b, 0x3d, 0x8b,
	0x0d, 0x1f, 0x8a, 0xcd, 0xb5, 0x00, 0x03, 0xc1,
	0x40, 0x40, 0x43, 0xeb, 0xd6, 0xc3, 0xe8, 0x60,
	0xfb, 0xa1, 0xb5, 0x32, 0xa3, 0xac, 0x00, 0x33,
	0xc0, 0xa3, 0xaa, 0x00, 0xb9, 0x06, 0x00, 0xba,
	0x54, 0x00, 0xe8, 0x83, 0xa8, 0xa1, 0xb3, 0x32,
	0xa3, 0xac, 0x00, 0xb8, 0x00, 0xfa, 0xa3, 0xaa,
	0x00, 0xb9, 0x05, 0x00, 0xba, 0x54, 0x00, 0xe8,
	0x6e, 0xa8, 0x8b, 0x16, 0xb3, 0x32, 0xbe, 0x00,
	0xfa, 0xb0, 0x40, 0xe8, 0x14, 0xa0, 0xa1, 0xb3,
	0x32, 0xa3, 0xac, 0x00, 0x2e, 0xa3, 0x53, 0x08,
	0xb8, 0x00, 0x1e, 0xa3, 0xaa, 0x00, 0xb9, 0x09,
	0x00, 0xba, 0x54, 0x00, 0xe8, 0x49, 0xa8, 0x1e,
	0x06, 0x8b, 0x2e, 0xb5, 0x32, 0xa1, 0xb1, 0x32,
	0x8e, 0xc0, 0x8e, 0xd8, 0xfc, 0xb9, 0x58, 0x02,
	0xe8, 0x0f, 0x00, 0x07, 0x1f, 0x8b, 0x16, 0xb3,
	0x32, 0xbe, 0x00, 0xfa, 0xb0, 0xc0, 0xe8, 0xd9,
	0x9f, 0xc3, 0x2e, 0x80, 0x3e, 0xd7, 0x00, 0x00,
	0x75, 0x07, 0x51, 0xe8, 0x04, 0x00, 0x59, 0xe2,
	0xf1, 0xc3, 0xb8, 0xa0, 0x00, 0xbf, 0x00, 0x00,
	0x03, 0xf8, 0x03, 0xf8, 0x8b, 0xf7, 0x03, 0xf0,
	0xb9, 0x90, 0x10, 0xf3, 0xa5, 0x83, 0xc7, 0x00,
	0xb9, 0x11, 0x00, 0x51, 0x57, 0xb8, 0x9f, 0x00,
	0xe8, 0xe8, 0xa9, 0x03, 0xf8, 0xb8, 0xb9, 0x00,
	0xe8, 0xe0, 0xa9, 0x04, 0x05, 0x8a, 0xe0, 0x89,
	0x05, 0x5f, 0x59, 0xe2, 0xe6, 0xb9, 0x01, 0x00,
	0xbe, 0x01, 0x00, 0x8b, 0xc6, 0xbb, 0xa0, 0x00,
	0xf7, 0xe3, 0x8b, 0xf8, 0x03, 0xf9, 0x33, 0xc0,
	0x33, 0xdb, 0x8a, 0x9d, 0x5f, 0xff, 0x8a, 0x85,
	0x60, 0xff, 0x03, 0xd8, 0x8a, 0x85, 0x61, 0xff,
	0x03, 0xd8, 0x8a, 0x45, 0xff, 0x03, 0xd8, 0x8a,
	0x45, 0x01, 0x03, 0xd8, 0x8a, 0x85, 0x9f, 0x00,
	0x03, 0xd8, 0x8a, 0x85, 0xa0, 0x00, 0x03, 0xd8,
	0x8a, 0x85, 0xa1, 0x00, 0x03, 0xd8, 0xc1, 0xeb,
	0x03, 0x88, 0x9d, 0x00, 0x23, 0x41, 0x81, 0xf9,
	0xa0, 0x00, 0x72, 0xb7, 0xb9, 0x01, 0x00, 0x46,
	0x83, 0xfe, 0x38, 0x72, 0xae, 0xbf, 0x00, 0x00,
	0xbe, 0x00, 0x23, 0xb9, 0x80, 0x11, 0xf3, 0xa5,
	0x06, 0xb8, 0x00, 0xa0, 0x8e, 0xc0, 0x33, 0xdb,
	0xbe, 0x00, 0x00, 0xbf, 0xc0, 0x6c, 0xb9, 0x2c,
	0x00, 0xb8, 0x40, 0x01, 0xf7, 0xe1, 0x03, 0xf8,
	0xd1, 0xe9, 0x8b, 0xd1, 0x83, 0xea, 0x04, 0xb8,
	0xa0, 0x00, 0xf7, 0xe2, 0x03, 0xf0, 0xb8, 0x38,
	0x00, 0x2b, 0xc1, 0x8b, 0xc8, 0xe8, 0xf0, 0x9e,
	0x56, 0xe8, 0x0b, 0x00, 0x5e, 0xe8, 0x07, 0x00,
	0xe2, 0xf6, 0xe8, 0x28, 0x00, 0x07, 0xc3, 0xba,
	0xa0, 0x00, 0x8a, 0x04, 0x1e, 0x8e, 0xdd, 0x80,
	0x3f, 0x01, 0x75, 0x03, 0x26, 0x88, 0x05, 0x43,
	0x47, 0x80, 0x3f, 0x01, 0x1f, 0x75, 0x03, 0x26,
	0x88, 0x05, 0x43, 0x47, 0x46, 0x4a, 0x75, 0xe2,
	0xc3, 0x80, 0x66, 0x00, 0x00, 0x2e, 0x81, 0x2e,
	0x51, 0x08, 0x80, 0x02, 0x73, 0x08, 0x2e, 0x81,
	0x06, 0x51, 0x08, 0x80, 0x02, 0xc3, 0x2e, 0x8b,
	0x36, 0x51, 0x08, 0x1e, 0x2e, 0xa1, 0x53, 0x08,
	0x8e, 0xd8, 0x33, 0xff, 0xfc, 0xb9, 0x80, 0x66,
	0x2b, 0xce, 0xd1, 0xe9, 0xf3, 0xa5, 0x1f, 0xc3,
	0x80, 0x3e, 0x95, 0x60, 0x01, 0x74, 0x0a, 0xe8,
	0x32, 0x00, 0x80, 0x3e, 0x95, 0x60, 0x01, 0x75,
	0x2a, 0xc6, 0x06, 0x95, 0x60, 0x00, 0xe8, 0xa1,
	0x18, 0xe8, 0xf8, 0x06, 0xe8, 0x35, 0x00, 0xe8,
	0x05, 0xa0, 0xc6, 0x06, 0xdc, 0x1c, 0x03, 0xc6,
	0x06, 0xda, 0x1c, 0x00, 0xe8, 0xc7, 0x1f, 0xe8,
	0x5e, 0x9e, 0xe8, 0x27, 0xa0, 0xc7, 0x06, 0x52,
	0x72, 0x00, 0x00, 0xc3, 0x2e, 0xa0, 0xd7, 0x00,
	0x3c, 0x3b, 0x72, 0x0a, 0x3c, 0x44, 0x77, 0x06,
	0xc6, 0x06, 0x95, 0x60, 0x01, 0xc3, 0xc6, 0x06,
	0x95, 0x60, 0x00, 0xc3, 0xc7, 0x06, 0x96, 0x60,
	0x00, 0x00, 0xc6, 0x06, 0x98, 0x60, 0x00, 0xbb,
	0x99, 0x60, 0xe8, 0x0e, 0x00, 0x72, 0x01, 0xc3,
	0xe8, 0x2d, 0x01, 0x80, 0x3e, 0x98, 0x60, 0x01,
	0x75, 0xe2, 0xc3, 0x83, 0xeb, 0x05, 0x89, 0x1e,
	0x93, 0x60, 0x2e, 0x80, 0x3e, 0xd7, 0x00, 0x01,
	0x75, 0x03, 0xe9, 0xb4, 0x00, 0x33, 0xc9, 0x8b,
	0x1e, 0x93, 0x60, 0x41, 0x83, 0xc3, 0x05, 0x8a,
	0x47, 0x04, 0x3c, 0x03, 0x74, 0xf5, 0x8b, 0x07,
	0x0a, 0xc0, 0x75, 0x28, 0x8b, 0x0e, 0x96, 0x60,
	0x0b, 0xc9, 0x74, 0xd6, 0x8b, 0x1e, 0x93, 0x60,
	0x83, 0xc3, 0x05, 0xe2, 0xfb, 0x8b, 0x07, 0xe8,
	0x8f, 0x00, 0x8a, 0x57, 0x02, 0xb6, 0x00, 0xb4,
	0xe0, 0xe8, 0x96, 0x00, 0xc7, 0x06, 0x96, 0x60,
	0x00, 0x00, 0xeb, 0xb6, 0x53, 0x51, 0xe8, 0x78,
	0x00, 0x8a, 0x4f, 0x02, 0xbb, 0x0e, 0x00, 0xe8,
	0x24, 0x1b, 0x59, 0x5b, 0x72, 0x02, 0xeb, 0xb3,
	0xa1, 0x96, 0x60, 0x3b, 0xc8, 0x74, 0x37, 0x0b,
	0xc0, 0x74, 0x1e, 0x53, 0x51, 0x8b, 0xc8, 0x8b,
	0x1e, 0x93, 0x60, 0x83, 0xc3, 0x05, 0xe2, 0xfb,
	0x8b, 0x07, 0xe8, 0x4c, 0x00, 0x8a, 0x57, 0x02,
	0xb6, 0x00, 0xb4, 0xe0, 0xe8, 0x53, 0x00, 0x59,
	0x5b, 0x89, 0x0e, 0x96, 0x60, 0x8b, 0x07, 0xe8,
	0x37, 0x00, 0x8a, 0x57, 0x02, 0xb6, 0x00, 0xb4,
	0xd1, 0x56, 0xe8, 0x3d, 0x00, 0x5e, 0xe8, 0x3a,
	0x9d, 0x72, 0x08, 0xe8, 0x06, 0x9d, 0x72, 0x03,
	0xe9, 0x57, 0xff, 0x8b, 0x0e, 0x96, 0x60, 0x8b,
	0x1e, 0x93, 0x60, 0x83, 0xc3, 0x05, 0xe2, 0xfb,
	0x8b, 0x47, 0x03, 0x3c, 0x0a, 0x74, 0x02, 0xf9,
	0xc3, 0xc7, 0x06, 0x96, 0x60, 0x00, 0x00, 0xf8,
	0xc3, 0x8a, 0xc8, 0xb5, 0x00, 0x8a, 0xc4, 0xb4,
	0x00, 0xf7, 0x26, 0xb6, 0x00, 0x03, 0xc1, 0x8b,
	0xf0, 0xc3, 0x06, 0x8b, 0x0e, 0xb1, 0x32, 0x8e,
	0xc1, 0x50, 0x56, 0xe8, 0x0f, 0x00, 0x5e, 0x58,
	0xb9, 0x00, 0xa0, 0x8e, 0xc1, 0xe8, 0x05, 0x00,
	0xe8, 0xec, 0x9b, 0x07, 0xc3, 0x8b, 0xca, 0x26,
	0x88, 0x24, 0x46, 0xe2, 0xfa, 0x81, 0xc6, 0x40,
	0x01, 0x2b, 0xf2, 0xb9, 0x0c, 0x00, 0x26, 0x88,
	0x24, 0x03, 0xf2, 0x26, 0x88, 0x64, 0xff, 0x2b,
	0xf2, 0x81, 0xc6, 0x40, 0x01, 0xe2, 0xef, 0x8b,
	0xca, 0x26, 0x88, 0x24, 0x46, 0xe2, 0xfa, 0xc3,
	0xbb, 0x94, 0x60, 0x83, 0xc3, 0x05, 0x3a, 0x47,
	0x03, 0x75, 0xf8, 0x80, 0x7f, 0x04, 0x03, 0x74,
	0x06, 0x80, 0x7f, 0x04, 0x00, 0x75, 0xec, 0x50,
	0x8b, 0x07, 0xe8, 0x8c, 0xff, 0x58, 0xb9, 0x0e,
	0x00, 0x8a, 0x57, 0x02, 0xb6, 0x00, 0x3c, 0x01,
	0x75, 0x04, 0xe8, 0xb9, 0x01, 0xc3, 0x3c, 0x02,
	0x75, 0x04, 0xe8, 0x8f, 0x02, 0xc3, 0x3c, 0x03,
	0x75, 0x24, 0x80, 0xfc, 0x01, 0x75, 0x0d, 0xa0,
	0xa8, 0x64, 0x3c, 0x0a, 0x74, 0x17, 0xfe, 0x06,
	0xa8, 0x64, 0xeb, 0x0b, 0xa0, 0xa8, 0x64, 0x0a,
	0xc0, 0x74, 0x0a, 0xfe, 0x0e, 0xa8, 0x64, 0xe8,
	0xa4, 0x05, 0xe8, 0xdc, 0x00, 0xc3, 0x3c, 0x04,
	0x75, 0x24, 0x80, 0xfc, 0x01, 0x75, 0x0d, 0xa0,
	0xa9, 0x64, 0x3c, 0x0a, 0x74, 0x17, 0xfe, 0x06,
	0xa9, 0x64, 0xeb, 0x0b, 0xa0, 0xa9, 0x64, 0x0a,
	0xc0, 0x74, 0x0a, 0xfe, 0x0e, 0xa9, 0x64, 0xe8,
	0x9e, 0x05, 0xe8, 0xc8, 0x00, 0xc3, 0x3c, 0x05,
	0x75, 0x24, 0x80, 0xfc, 0x01, 0x75, 0x0d, 0xa0,
	0xaa, 0x64, 0x3c, 0x03, 0x74, 0x17, 0xfe, 0x06,
	0xaa, 0x64, 0xeb, 0x0b, 0xa0, 0xaa, 0x64, 0x0a,
	0xc0, 0x74, 0x0a, 0xfe, 0x0e, 0xaa, 0x64, 0xe8,
	0x98, 0x05, 0xe8, 0xc9, 0x00, 0xc3, 0x3c, 0x06,
	0x75, 0x24, 0x80, 0xfc, 0x01, 0x75, 0x0d, 0xa0,
	0xab, 0x64, 0x3c, 0x03, 0x74, 0x17, 0xfe, 0x06,
	0xab, 0x64, 0xeb, 0x0b, 0xa0, 0xab, 0x64, 0x0a,
	0xc0, 0x74, 0x0a, 0xfe, 0x0e, 0xab, 0x64, 0xe8,
	0x92, 0x05, 0xe8, 0xd2, 0x00, 0xc3, 0x3c, 0x07,
	0x75, 0x24, 0x80, 0xfc, 0x01, 0x75, 0x0d, 0xa0,
	0xac, 0x64, 0x3c, 0x04, 0x74, 0x17, 0xfe, 0x06,
	0xac, 0x64, 0xeb, 0x0b, 0xa0, 0xac, 0x64, 0x0a,
	0xc0, 0x74, 0x0a, 0xfe, 0x0e, 0xac, 0x64, 0xe8,
	0x8c, 0x05, 0xe8, 0x86, 0x00, 0xc3, 0x3c, 0x08,
	0x75, 0x24, 0x80, 0xfc, 0x01, 0x75, 0x0d, 0xa0,
	0xad, 0x64, 0x3c, 0x01, 0x74, 0x17, 0xfe, 0x06,
	0xad, 0x64, 0xeb, 0x0b, 0xa0, 0xad, 0x64, 0x0a,
	0xc0, 0x74, 0x0a, 0xfe, 0x0e, 0xad, 0x64, 0xe8,
	0x86, 0x05, 0xe8, 0xa0, 0x00, 0xc3, 0x3c, 0x0b,
	0x75, 0x04, 0xe8, 0x9c, 0x03, 0xc3, 0x3c, 0x0d,
	0x75, 0x02, 0xc3, 0xc3, 0xb0, 0x3c, 0xe9, 0x17,
	0xa8, 0xa0, 0xa8, 0x64, 0x0a, 0xc0, 0x75, 0x06,
	0xc6, 0x06, 0x48, 0x32, 0x00, 0xc3, 0xe8, 0x22,
	0x00, 0xa2, 0x48, 0x32, 0xc3, 0xa0, 0xa9, 0x64,
	0x0a, 0xc0, 0x75, 0x0b, 0xc6, 0x06, 0x49, 0x32,
	0x00, 0xc6, 0x06, 0x47, 0x32, 0x00, 0xc3, 0xc6,
	0x06, 0x47, 0x32, 0x01, 0xe8, 0x04, 0x00, 0xa2,
	0x49, 0x32, 0xc3, 0x8a, 0xc8, 0xb5, 0x00, 0xb0,
	0x04, 0x04, 0x06, 0xe2, 0xfc, 0xc3, 0xb0, 0x03,
	0x2a, 0x06, 0xaa, 0x64, 0xc0, 0xe0, 0x02, 0xa2,
	0x8e, 0x32, 0xc3, 0xa0, 0xac, 0x64, 0x0a, 0xc0,
	0x74, 0x19, 0x8a, 0xe0, 0xb0, 0x64, 0x80, 0xfc,
	0x01, 0x74, 0x10, 0xb0, 0x32, 0x80, 0xfc, 0x02,
	0x74, 0x09, 0xb0, 0x14, 0x80, 0xfc, 0x03, 0x74,
	0x02, 0xb0, 0x01, 0xa2, 0x96, 0x32, 0xc3, 0x8a,
	0x26, 0xab, 0x64, 0xb0, 0x10, 0x0a, 0xe4, 0x74,
	0x10, 0xb0, 0x0b, 0x80, 0xfc, 0x01, 0x74, 0x09,
	0xb0, 0x05, 0x80, 0xfc, 0x02, 0x74, 0x02, 0xb0,
	0x01, 0xa2, 0x90, 0x32, 0xc3, 0x80, 0x3e, 0xad,
	0x64, 0x01, 0x75, 0x0e, 0x8b, 0x16, 0xb3, 0x32,
	0xbe, 0x00, 0xfa, 0xb0, 0x40, 0xe8, 0x32, 0x9b,
	0xeb, 0x03, 0xe8, 0xcc, 0xa0, 0xc6, 0x06, 0x08,
	0x66, 0x00, 0xe8, 0xdc, 0x9b, 0xc3, 0xc7, 0x06,
	0x96, 0x60, 0x00, 0x00, 0xe8, 0x23, 0x02, 0xbb,
	0x32, 0x64, 0xe8, 0xe6, 0xfc, 0x72, 0x0a, 0xc7,
	0x06, 0x96, 0x60, 0x00, 0x00, 0xe8, 0x7c, 0x03,
	0xc3, 0x8b, 0x0e, 0x96, 0x60, 0x49, 0xe8, 0xa5,
	0x02, 0x0b, 0xc9, 0x74, 0xd9, 0xb8, 0xa6, 0x64,
	0x8b, 0xd8, 0x8b, 0x1f, 0x3b, 0xc3, 0x75, 0x1e,
	0xbb, 0xa4, 0x64, 0x8b, 0x07, 0xbb, 0xaf, 0xb3,
	0x81, 0xeb, 0x00, 0x00, 0x3b, 0xc3, 0x75, 0x0e,
	0xb8, 0xf2, 0xdb, 0xbb, 0x78, 0x64, 0x2b, 0xc3,
	0x3b, 0xc1, 0x75, 0x02, 0xeb, 0x35, 0xb8, 0xa6,
	0x64, 0xa3, 0xa6, 0x64, 0xb8, 0xaf, 0xb3, 0xa3,
	0xa4, 0x64, 0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0,
	0xbe, 0x79, 0x51, 0xb0, 0xdb, 0xb4, 0x00, 0xb9,
	0x46, 0x00, 0xba, 0xce, 0x00, 0xe8, 0x07, 0x05,
	0xbb, 0xc3, 0x62, 0xbe, 0xbb, 0x62, 0xe8, 0x9f,
	0x04, 0xe8, 0x60, 0x9c, 0x07, 0xe8, 0x82, 0x9a,
	0xe9, 0x7b, 0xff, 0x89, 0x1e, 0xaa, 0x00, 0x8c,
	0x1e, 0xac, 0x00, 0xba, 0x95, 0x00, 0xe8, 0x56,
	0xa3, 0x58, 0x81, 0xfc, 0x00, 0x02, 0x72, 0xf9,
	0xe8, 0xb6, 0xfe, 0xe8, 0xc7, 0xfe, 0xe8, 0xed,
	0xfe, 0xe8, 0xf7, 0xfe, 0xe8, 0x18, 0xff, 0xe8,
	0x33, 0xff, 0x8b, 0x0e, 0x90, 0xdb, 0xe8, 0x9a,
	0xa4, 0x83, 0x3e, 0xf3, 0xb4, 0x18, 0x75, 0x0b,
	0xe8, 0xe0, 0x4c, 0xc6, 0x06, 0xdc, 0x1c, 0x02,
	0xe9, 0xb6, 0xf4, 0xa1, 0xaf, 0x64, 0x8b, 0x1e,
	0xb1, 0x64, 0x8b, 0xf8, 0x8b, 0xf3, 0x8a, 0x0e,
	0x07, 0x66, 0x8a, 0x2e, 0xc3, 0x64, 0xe8, 0x0a,
	0x9f, 0xe9, 0x9d, 0xf4, 0xc7, 0x06, 0x96, 0x60,
	0x00, 0x00, 0xe8, 0x45, 0x01, 0xbb, 0x32, 0x64,
	0xe8, 0x08, 0xfc, 0x72, 0x0a, 0xc7, 0x06, 0x96,
	0x60, 0x00, 0x00, 0xe8, 0x9e, 0x02, 0xc3, 0x56,
	0xe8, 0xe2, 0x98, 0x5e, 0xe8, 0x38, 0x00, 0x73,
	0x29, 0xba, 0x95, 0x00, 0x8b, 0xda, 0xa1, 0x96,
	0x60, 0x48, 0x04, 0x30, 0x88, 0x47, 0x07, 0xb8,
	0x78, 0x64, 0xb9, 0xf2, 0xdb, 0x2b, 0xc8, 0xa3,
	0xaa, 0x00, 0x8c, 0x1e, 0xac, 0x00, 0xe8, 0x6d,
	0xa3, 0xc6, 0x06, 0x98, 0x60, 0x01, 0xe8, 0xd6,
	0x98, 0xc3, 0xc7, 0x06, 0x96, 0x60, 0x00, 0x00,
	0xe8, 0x61, 0x02, 0xe8, 0xc9, 0x98, 0xc3, 0x81,
	0xc6, 0x85, 0x02, 0x8b, 0x0e, 0x96, 0x60, 0x49,
	0x56, 0xc7, 0x06, 0xa6, 0x00, 0x18, 0x00, 0xe8,
	0x30, 0x01, 0x5e, 0xbb, 0x78, 0x64, 0x80, 0x3f,
	0x28, 0x74, 0x0b, 0x33, 0xc9, 0x41, 0x43, 0x80,
	0x3f, 0x00, 0x75, 0xf9, 0xeb, 0x08, 0xbb, 0x78,
	0x64, 0xc6, 0x07, 0x00, 0x33, 0xc9, 0xe8, 0x48,
	0x00, 0x33, 0xc0, 0x2e, 0xa0, 0xd7, 0x00, 0x3a,
	0xc4, 0x8a, 0xe0, 0x74, 0xf6, 0x3c, 0x80, 0x73,
	0xf2, 0x3c, 0x1c, 0x74, 0x1c, 0x3c, 0x01, 0x74,
	0x14, 0x3c, 0x0e, 0x74, 0x1a, 0x83, 0xf9, 0x16,
	0x73, 0xe1, 0xe8, 0x61, 0x00, 0x73, 0xdc, 0x41,
	0xe8, 0x1e, 0x00, 0xeb, 0xd6, 0x33, 0xc9, 0xf8,
	0xc3, 0x0b, 0xc9, 0x74, 0xce, 0xf9, 0xc3, 0x0b,
	0xc9, 0x74, 0xc8, 0x49, 0xbb, 0x78, 0x64, 0x03,
	0xd9, 0xc6, 0x07, 0x00, 0xe8, 0x02, 0x00, 0xeb,
	0xba, 0x50, 0x51, 0x06, 0xb8, 0x00, 0xa0, 0x8e,
	0xc0, 0x56, 0xe8, 0x13, 0x00, 0x5e, 0x56, 0xbb,
	0x78, 0x64, 0xe8, 0x90, 0x96, 0xbb, 0x90, 0x64,
	0xe8, 0x8a, 0x96, 0x5e, 0x07, 0x59, 0x58, 0xc3,
	0xbb, 0x78, 0x64, 0xe8, 0xd2, 0x96, 0x03, 0xf0,
	0xb9, 0x0b, 0x00, 0x51, 0xb9, 0x14, 0x00, 0x26,
	0xc6, 0x04, 0xe8, 0x46, 0xe2, 0xf9, 0x59, 0x81,
	0xc6, 0x2c, 0x01, 0xe2, 0xee, 0xc3, 0xbb, 0x3f,
	0x60, 0x3a, 0x07, 0x74, 0x0b, 0x83, 0xc3, 0x02,
	0x81, 0xfb, 0x93, 0x60, 0x72, 0xf3, 0xf8, 0xc3,
	0x50, 0x53, 0x51, 0x06, 0x56, 0xb8, 0x00, 0xa0,
	0x8e, 0xc0, 0xe8, 0xc3, 0xff, 0x5e, 0x56, 0xbb,
	0x78, 0x64, 0xe8, 0x40, 0x96, 0x5e, 0x07, 0x59,
	0x5b, 0x58, 0x8a, 0x5f, 0x01, 0xbf, 0x78, 0x64,
	0x03, 0xf9, 0x88, 0x1d, 0xc6, 0x45, 0x01, 0x00,
	0xf9, 0xc3, 0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0,
	0xe8, 0xb7, 0x02, 0xbb, 0x70, 0x64, 0xbe, 0x6e,
	0x64, 0xe8, 0xdc, 0x02, 0xe8, 0x0b, 0x00, 0xbb,
	0x32, 0x64, 0xe8, 0xb6, 0x02, 0xe8, 0x94, 0x9a,
	0x07, 0xc3, 0x33, 0xc9, 0x51, 0xc7, 0x06, 0xa6,
	0x00, 0x18, 0x00, 0xe8, 0x24, 0x00, 0x59, 0x51,
	0xbe, 0x3b, 0x0f, 0x8b, 0xc1, 0xb9, 0x0f, 0x00,
	0xf7, 0xe1, 0xf7, 0x26, 0xb6, 0x00, 0x03, 0xf0,
	0x81, 0xc6, 0x85, 0x02, 0xbb, 0x78, 0x64, 0xe8,
	0xe3, 0x95, 0x59, 0x41, 0x83, 0xf9, 0x0a, 0x72,
	0xd3, 0xc3, 0xba, 0x95, 0x00, 0x8b, 0xda, 0x8a,
	0xc1, 0x04, 0x30, 0x88, 0x47, 0x07, 0xb8, 0x00,
	0x3d, 0xb1, 0x00, 0xcd, 0x21, 0x72, 0x1c, 0x8b,
	0xd8, 0xb4, 0x3e, 0xcd, 0x21, 0x72, 0x2c, 0x8c,
	0x1e, 0xac, 0x00, 0xb8, 0x78, 0x64, 0xa3, 0xaa,
	0x00, 0xc7, 0x06, 0xa8, 0x00, 0x00, 0x00, 0xe8,
	0x9d, 0xa1, 0xc3, 0x3d, 0x02, 0x00, 0x75, 0x13,
	0xbb, 0x78, 0x64, 0xc6, 0x07, 0x28, 0xc6, 0x47,
	0x01, 0x2d, 0xc6, 0x47, 0x02, 0x29, 0xc6, 0x47,
	0x03, 0x00, 0xc3, 0xe9, 0xa2, 0xa4, 0xb8, 0x2f,
	0x00, 0xa3, 0xa6, 0x00, 0xe8, 0xab, 0xff, 0xbb,
	0x78, 0x64, 0x80, 0x3f, 0x28, 0x75, 0x03, 0x33,
	0xc9, 0xc3, 0xba, 0x95, 0x00, 0xe8, 0x48, 0xa0,
	0xc3, 0xe8, 0xf9, 0x96, 0xe8, 0x1e, 0x12, 0xe8,
	0x15, 0x97, 0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0,
	0xbe, 0x26, 0x54, 0xb0, 0xe8, 0xb4, 0x00, 0xb9,
	0x42, 0x00, 0xba, 0x74, 0x00, 0xe8, 0x77, 0x02,
	0xbb, 0x27, 0x62, 0xbe, 0x21, 0x62, 0xe8, 0x0f,
	0x02, 0xe8, 0xd0, 0x99, 0x07, 0x2e, 0x8a, 0x26,
	0xd7, 0x00, 0xe8, 0x8f, 0x97, 0x72, 0x1c, 0xe8,
	0xb9, 0x97, 0x72, 0x17, 0x2e, 0xa0, 0xd7, 0x00,
	0x3c, 0x80, 0x73, 0xee, 0x0a, 0xc0, 0x74, 0xea,
	0x3a, 0xc4, 0x74, 0xe6, 0x3c, 0x15, 0x75, 0x03,
	0xe9, 0x74, 0xf2, 0xc7, 0x06, 0x96, 0x60, 0x00,
	0x00, 0xe8, 0xa1, 0x96, 0xe8, 0xfb, 0x11, 0xe8,
	0xbd, 0x96, 0xe8, 0x4f, 0x00, 0xc3, 0xe8, 0x94,
	0x96, 0xe8, 0xb9, 0x11, 0xe8, 0xb0, 0x96, 0x06,
	0xa1, 0xb1, 0x32, 0x8e, 0xc0, 0xbe, 0x6d, 0x51,
	0xb0, 0xe8, 0xb4, 0x00, 0xb9, 0x46, 0x00, 0xba,
	0xe6, 0x00, 0xe8, 0x12, 0x02, 0xbb, 0x52, 0x62,
	0xbe, 0x4a, 0x62, 0xe8, 0xaa, 0x01, 0xe8, 0x6b,
	0x99, 0x07, 0x2e, 0x8a, 0x26, 0xd7, 0x00, 0xe8,
	0x2a, 0x97, 0x72, 0x05, 0xe8, 0x54, 0x97, 0x73,
	0xf6, 0xc7, 0x06, 0x96, 0x60, 0x00, 0x00, 0xe8,
	0x53, 0x96, 0xe8, 0xad, 0x11, 0xe8, 0x6f, 0x96,
	0xe8, 0x01, 0x00, 0xc3, 0xc6, 0x06, 0xe6, 0x1c,
	0xd1, 0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0, 0xe8,
	0x48, 0x01, 0xbb, 0x29, 0x61, 0xbe, 0x11, 0x61,
	0xe8, 0x6d, 0x01, 0xbb, 0x99, 0x60, 0xe8, 0x4a,
	0x01, 0xe8, 0x14, 0x00, 0xe8, 0x1e, 0x00, 0xe8,
	0x28, 0x00, 0xe8, 0x32, 0x00, 0xe8, 0x3c, 0x00,
	0xe8, 0x46, 0x00, 0xe8, 0x16, 0x99, 0x07, 0xc3,
	0xb0, 0x06, 0xbb, 0x29, 0x63, 0x8a, 0x0e, 0xa8,
	0x64, 0xe8, 0x54, 0x01, 0xc3, 0xb0, 0x06, 0xbb,
	0x6b, 0x63, 0x8a, 0x0e, 0xa9, 0x64, 0xe8, 0x47,
	0x01, 0xc3, 0xb0, 0x09, 0xbb, 0xad, 0x63, 0x8a,
	0x0e, 0xaa, 0x64, 0xe8, 0x3a, 0x01, 0xc3, 0xb0,
	0x09, 0xbb, 0xd1, 0x63, 0x8a, 0x0e, 0xab, 0x64,
	0xe8, 0x2d, 0x01, 0xc3, 0xb0, 0x09, 0xbb, 0xf5,
	0x63, 0x8a, 0x0e, 0xac, 0x64, 0xe8, 0x20, 0x01,
	0xc3, 0xb0, 0x08, 0xbb, 0x22, 0x64, 0x8a, 0x0e,
	0xad, 0x64, 0xe8, 0x13, 0x01, 0xc3, 0x06, 0xa1,
	0xb1, 0x32, 0x8e, 0xc0, 0x51, 0x52, 0x56, 0xe8,
	0xc0, 0x00, 0xe8, 0xa3, 0xff, 0xb8, 0x00, 0xa0,
	0x8e, 0xc0, 0x5e, 0x5a, 0x59, 0xe8, 0xb2, 0x00,
	0xe8, 0x95, 0xff, 0x07, 0xe8, 0xa0, 0x95, 0xc3,
	0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0, 0x51, 0x52,
	0x56, 0xe8, 0x9e, 0x00, 0xe8, 0x8e, 0xff, 0xb8,
	0x00, 0xa0, 0x8e, 0xc0, 0x5e, 0x5a, 0x59, 0xe8,
	0x90, 0x00, 0xe8, 0x80, 0xff, 0x07, 0xe8, 0x7e,
	0x95, 0xc3, 0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0,
	0x51, 0x52, 0x56, 0xe8, 0x7c, 0x00, 0xe8, 0x79,
	0xff, 0xb8, 0x00, 0xa0, 0x8e, 0xc0, 0x5e, 0x5a,
	0x59, 0xe8, 0x6e, 0x00, 0xe8, 0x6b, 0xff, 0x07,
	0xe8, 0x5c, 0x95, 0xc3, 0x06, 0xa1, 0xb1, 0x32,
	0x8e, 0xc0, 0x51, 0x52, 0x56, 0xe8, 0x5a, 0x00,
	0xe8, 0x64, 0xff, 0xb8, 0x00, 0xa0, 0x8e, 0xc0,
	0x5e, 0x5a, 0x59, 0xe8, 0x4c, 0x00, 0xe8, 0x56,
	0xff, 0x07, 0xe8, 0x3a, 0x95, 0xc3, 0x06, 0xa1,
	0xb1, 0x32, 0x8e, 0xc0, 0x51, 0x52, 0x56, 0xe8,
	0x38, 0x00, 0xe8, 0x4f, 0xff, 0xb8, 0x00, 0xa0,
	0x8e, 0xc0, 0x5e, 0x5a, 0x59, 0xe8, 0x2a, 0x00,
	0xe8, 0x41, 0xff, 0x07, 0xe8, 0x18, 0x95, 0xc3,
	0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0, 0x51, 0x52,
	0x56, 0xe8, 0x16, 0x00, 0xe8, 0x3a, 0xff, 0xb8,
	0x00, 0xa0, 0x8e, 0xc0, 0x5e, 0x5a, 0x59, 0xe8,
	0x08, 0x00, 0xe8, 0x2c, 0xff, 0x07, 0xe8, 0xf6,
	0x94, 0xc3, 0xb0, 0xe8, 0xb4, 0xe0, 0xe8, 0x8e,
	0x00, 0xc3, 0xbe, 0x32, 0x05, 0xb0, 0xe8, 0xb4,
	0x00, 0xb9, 0xc0, 0x00, 0xba, 0xdc, 0x00, 0xe8,
	0x7d, 0x00, 0xc3, 0x53, 0x8b, 0x07, 0xe8, 0xc0,
	0xf8, 0xb9, 0x0e, 0x00, 0x8a, 0x57, 0x02, 0xb6,
	0x00, 0xb4, 0xe0, 0xe8, 0x38, 0x00, 0x5b, 0x83,
	0xc3, 0x05, 0x80, 0x3f, 0x00, 0x75, 0xe4, 0xc3,
	0x56, 0x8b, 0x34, 0xe8, 0x37, 0x93, 0x5e, 0x43,
	0x46, 0x46, 0x80, 0x3f, 0x00, 0x75, 0xf1, 0xc3,
	0xb4, 0x00, 0xb5, 0x00, 0x2b, 0xd8, 0x41, 0x03,
	0xd8, 0xe2, 0xfc, 0x8a, 0x47, 0x01, 0xf7, 0x26,
	0xb6, 0x00, 0x8a, 0x0f, 0x03, 0xc1, 0x8b, 0xf0,
	0x43, 0x43, 0xe8, 0x10, 0x93, 0xc3, 0x8b, 0xda,
	0x26, 0x88, 0x24, 0x46, 0x4a, 0x75, 0xf9, 0x81,
	0xc6, 0x40, 0x01, 0x2b, 0xf3, 0x83, 0xe9, 0x02,
	0x8b, 0xd3, 0x26, 0x88, 0x24, 0x46, 0x83, 0xea,
	0x02, 0x03, 0xf2, 0x26, 0x88, 0x24, 0x46, 0x81,
	0xc6, 0x40, 0x01, 0x2b, 0xf3, 0xe2, 0xe9, 0x26,
	0x88, 0x24, 0x46, 0x4b, 0x75, 0xf9, 0xc3, 0x8b,
	0xda, 0x26, 0x88, 0x24, 0x46, 0x4a, 0x75, 0xf9,
	0x81, 0xc6, 0x40, 0x01, 0x2b, 0xf3, 0x83, 0xe9,
	0x02, 0x8b, 0xd3, 0x26, 0x88, 0x24, 0x46, 0x83,
	0xea, 0x02, 0x26, 0x88, 0x04, 0x46, 0x4a, 0x75,
	0xf9, 0x26, 0x88, 0x24, 0x46, 0x81, 0xc6, 0x40,
	0x01, 0x2b, 0xf3, 0xe2, 0xe4, 0x26, 0x88, 0x24,
	0x46, 0x4b, 0x75, 0xf9, 0xc3, 0x8b, 0x07, 0x0b,
	0xc0, 0x74, 0x0d, 0x83, 0x7f, 0x02, 0xff, 0x74,
	0x04, 0xc7, 0x07, 0x00, 0x00, 0x8b, 0xd8, 0xc3,
	0x83, 0xc3, 0x02, 0xeb, 0xe8, 0xe8, 0xed, 0x00,
	0xbb, 0xf2, 0xdb, 0x80, 0x3f, 0x00, 0x74, 0x2f,
	0x83, 0xeb, 0x02, 0x83, 0xc3, 0x02, 0x53, 0x80,
	0x3f, 0xff, 0x75, 0x05, 0x53, 0xe8, 0x75, 0x0d,
	0x5b, 0xe8, 0x71, 0x8e, 0x5b, 0x2e, 0x80, 0x3e,
	0xd7, 0x00, 0x01, 0x74, 0x09, 0xe8, 0xad, 0x00,
	0x80, 0x7f, 0x03, 0x00, 0x75, 0x03, 0xe9, 0xa0,
	0x00, 0x80, 0x7f, 0x02, 0x00, 0x75, 0xd4, 0x53,
	0x8a, 0x26, 0x96, 0xda, 0xa0, 0x97, 0xda, 0xe8,
	0x04, 0x0d, 0xe8, 0x4f, 0x98, 0xa0, 0x96, 0xda,
	0x8b, 0x0e, 0x98, 0xda, 0x8b, 0x16, 0x9a, 0xda,
	0xe8, 0xd3, 0x00, 0x5b, 0x43, 0xe8, 0x4d, 0x0d,
	0x83, 0xc3, 0x02, 0x53, 0xa0, 0x96, 0xda, 0x8b,
	0x0e, 0x9c, 0xda, 0x8b, 0x16, 0x9e, 0xda, 0x80,
	0x3f, 0xff, 0x75, 0x03, 0xe8, 0x74, 0x00, 0xe8,
	0xb7, 0x01, 0x5b, 0x2e, 0x80, 0x3e, 0xd7, 0x00,
	0x01, 0x74, 0x3b, 0xe8, 0x57, 0x00, 0x80, 0x7f,
	0x02, 0x00, 0x75, 0xd4, 0x80, 0x7f, 0x03, 0x00,
	0x74, 0x2c, 0xe8, 0x18, 0x0d, 0x43, 0x83, 0xc3,
	0x02, 0x53, 0x80, 0x3f, 0xff, 0x75, 0x03, 0xe8,
	0x49, 0x00, 0xe8, 0x16, 0x8f, 0x5b, 0x2e, 0x80,
	0x3e, 0xd7, 0x00, 0x01, 0x74, 0x10, 0xe8, 0x2c,
	0x00, 0x80, 0x7f, 0x02, 0x00, 0x75, 0xdf, 0x43,
	0x80, 0x7f, 0x02, 0x00, 0x75, 0x9f, 0xa0, 0x96,
	0xda, 0x8b, 0x0e, 0xa0, 0xda, 0x8b, 0x16, 0xa2,
	0xda, 0xe8, 0x62, 0x00, 0xe8, 0x0f, 0x98, 0xc6,
	0x06, 0x33, 0x33, 0x01, 0xc6, 0x06, 0xdd, 0x1c,
	0x02, 0xe8, 0x50, 0x98, 0xc3, 0x4b, 0x43, 0x80,
	0x3f, 0x00, 0x75, 0xfa, 0x80, 0x7f, 0x01, 0x00,
	0x75, 0xf4, 0xc3, 0x60, 0xb8, 0x5a, 0x00, 0xe8,
	0xaa, 0x0c, 0x61, 0x43, 0xc3, 0x06, 0xb8, 0x69,
	0x1c, 0x8e, 0xc0, 0xbe, 0xf2, 0xdb, 0x33, 0xc9,
	0x26, 0x8a, 0x07, 0x8a, 0xe0, 0x26, 0x0a, 0x67,
	0x01, 0x26, 0x0a, 0x67, 0x02, 0x26, 0x0a, 0x67,
	0x03, 0x74, 0x12, 0x88, 0x04, 0x41, 0x81, 0xf9,
	0xcc, 0x07, 0x72, 0x05, 0xb0, 0x39, 0xe9, 0x87,
	0xa0, 0x43, 0x46, 0xeb, 0xdb, 0x33, 0xc0, 0x89,
	0x04, 0x89, 0x44, 0x02, 0x07, 0xc3, 0xe8, 0x0e,
	0x00, 0xc6, 0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x7d,
	0x15, 0xc6, 0x06, 0xdc, 0x1c, 0x03, 0xc3, 0xbf,
	0xc7, 0x32, 0xb3, 0x1b, 0x48, 0xf6, 0xe3, 0x03,
	0xf8, 0x89, 0x0d, 0xc6, 0x06, 0x34, 0x33, 0x00,
	0x52, 0x57, 0xe8, 0x9e, 0x96, 0x5f, 0x5a, 0x52,
	0x57, 0xe8, 0x69, 0x18, 0x5f, 0x57, 0xa1, 0x7a,
	0x32, 0x0b, 0xc0, 0x74, 0x1f, 0x40, 0x3b, 0x05,
	0x75, 0x1a, 0xe8, 0x48, 0x96, 0xa0, 0x49, 0x32,
	0xb4, 0x04, 0x8a, 0x2e, 0x7c, 0x32, 0x06, 0xff,
	0x1e, 0x4a, 0x32, 0x07, 0xb8, 0x3b, 0x0b, 0x8e,
	0xd8, 0xe8, 0x6f, 0x96, 0x5f, 0x5a, 0x39, 0x15,
	0x76, 0xcd, 0xc6, 0x06, 0x34, 0x33, 0x01, 0xc7,
	0x06, 0x7a, 0x32, 0x00, 0x00, 0xc3, 0x60, 0xe8,
	0xa5, 0x92, 0x61, 0xbf, 0xc7, 0x32, 0xb3, 0x1b,
	0x48, 0xf6, 0xe3, 0x03, 0xf8, 0x89, 0x0d, 0xc6,
	0x06, 0x34, 0x33, 0x00, 0x52, 0x57, 0xe8, 0x42,
	0x96, 0x5f, 0x5a, 0x52, 0x57, 0xe8, 0x08, 0xf5,
	0xe8, 0xa4, 0x0c, 0xe8, 0x07, 0x18, 0xe8, 0x25,
	0x15, 0x5f, 0x57, 0xa1, 0x7a, 0x32, 0x0b, 0xc0,
	0x74, 0x1f, 0x40, 0x3b, 0x05, 0x75, 0x1a, 0xe8,
	0xe3, 0x95, 0xa0, 0x49, 0x32, 0xb4, 0x04, 0x8a,
	0x2e, 0x7c, 0x32, 0x06, 0xff, 0x1e, 0x4a, 0x32,
	0x07, 0xb8, 0x3b, 0x0b, 0x8e, 0xd8, 0xe8, 0x0a,
	0x96, 0x5f, 0x5a, 0x33, 0xc0, 0x80, 0x3e, 0xe1,
	0xc3, 0x00, 0x75, 0x1f, 0x8b, 0x05, 0xe8, 0x1a,
	0x93, 0xc6, 0x06, 0xcf, 0x00, 0x04, 0x72, 0x13,
	0xe8, 0xe1, 0x92, 0xc6, 0x06, 0xcf, 0x00, 0x02,
	0x72, 0x09, 0x33, 0xc0, 0xa2, 0xcf, 0x00, 0x39,
	0x15, 0x76, 0xa0, 0x50, 0xc6, 0x06, 0x34, 0x33,
	0x01, 0xc7, 0x06, 0x7a, 0x32, 0x00, 0x00, 0xc6,
	0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x8f, 0x14, 0xc6,
	0x06, 0xdc, 0x1c, 0x03, 0xe8, 0xee, 0x91, 0x58,
	0xc3, 0x53, 0xbf, 0xc7, 0x32, 0xb3, 0x1b, 0x48,
	0xf6, 0xe3, 0x03, 0xf8, 0x89, 0x0d, 0x5b, 0x51,
	0x52, 0x57, 0xe8, 0xc6, 0x8d, 0x5f, 0x5a, 0x59,
	0x51, 0x52, 0x57, 0xe8, 0x77, 0x17, 0x2e, 0x80,
	0x3e, 0xd7, 0x00, 0x01, 0x74, 0x24, 0x80, 0x3e,
	0x96, 0x32, 0x00, 0x74, 0x08, 0xbb, 0x92, 0x32,
	0xe8, 0xd3, 0x94, 0x72, 0x15, 0xe8, 0xab, 0x92,
	0x72, 0x10, 0xe8, 0x77, 0x92, 0x72, 0x0b, 0x5f,
	0x5a, 0x59, 0x39, 0x15, 0x76, 0xd2, 0x89, 0x0d,
	0xeb, 0xce, 0x5f, 0x5a, 0x59, 0xa1, 0xa4, 0xda,
	0x89, 0x05, 0xc6, 0x06, 0x33, 0x33, 0x01, 0xc6,
	0x06, 0xdd, 0x1c, 0x02, 0xc6, 0x06, 0xdb, 0x1c,
	0x01, 0xc6, 0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x1d,
	0x14, 0xc6, 0x06, 0x33, 0x33, 0x00, 0xc6, 0x06,
	0xdc, 0x1c, 0x03, 0xc6, 0x06, 0xdd, 0x1c, 0x03,
	0xc6, 0x06, 0xdb, 0x1c, 0x00, 0xc3, 0x50, 0x57,
	0x56, 0xe8, 0x41, 0xfe, 0x5e, 0x5f, 0x58, 0x50,
	0x33, 0xd2, 0x8a, 0xd0, 0x4a, 0xd1, 0xe2, 0xbb,
	0x47, 0x33, 0x03, 0xda, 0x89, 0x37, 0x2b, 0xda,
	0x8a, 0xd4, 0x4a, 0xd1, 0xe2, 0x03, 0xda, 0x89,
	0x3f, 0xe8, 0xc8, 0x95, 0xc6, 0x06, 0x33, 0x33,
	0x01, 0xc6, 0x06, 0xdd, 0x1c, 0x02, 0xe8, 0xd5,
	0x13, 0xc6, 0x06, 0x33, 0x33, 0x00, 0xc6, 0x06,
	0xdd, 0x1c, 0x03, 0x58, 0x50, 0x98, 0xbf, 0xc7,
	0x32, 0xb3, 0x1b, 0x48, 0xf6, 0xe3, 0x03, 0xf8,
	0x89, 0x3e, 0x41, 0x33, 0xc7, 0x05, 0x01, 0x00,
	0x58, 0x8a, 0xc4, 0x98, 0xbf, 0xc7, 0x32, 0xb3,
	0x1b, 0x48, 0xf6, 0xe3, 0x03, 0xf8, 0x89, 0x3e,
	0x43, 0x33, 0xc7, 0x05, 0x01, 0x00, 0xbb, 0xf2,
	0xdb, 0x83, 0xeb, 0x02, 0x83, 0xc3, 0x02, 0x53,
	0xa0, 0x45, 0x33, 0xa2, 0xe7, 0x1c, 0xe8, 0x6e,
	0x06, 0x80, 0x3f, 0xff, 0x75, 0x03, 0xe8, 0xc5,
	0x00, 0x8b, 0x3e, 0x41, 0x33, 0xe8, 0xd3, 0x8c,
	0x5b, 0x53, 0xe8, 0x88, 0x16, 0x8b, 0x3e, 0x43,
	0x33, 0xc7, 0x05, 0x01, 0x00, 0x2e, 0x80, 0x3e,
	0xd7, 0x00, 0x01, 0x74, 0x19, 0x80, 0x3e, 0x96,
	0x32, 0x00, 0x74, 0x08, 0xbb, 0x92, 0x32, 0xe8,
	0xdc, 0x93, 0x72, 0x0a, 0xe8, 0xb4, 0x91, 0x72,
	0x05, 0xe8, 0x80, 0x91, 0x73, 0xd4, 0x5b, 0x2e,
	0x80, 0x3e, 0xd7, 0x00, 0x01, 0x74, 0x76, 0xe8,
	0x6b, 0xfd, 0x80, 0x7f, 0x02, 0x00, 0x75, 0xa4,
	0x80, 0x7f, 0x03, 0x00, 0x74, 0x67, 0x43, 0x83,
	0xc3, 0x02, 0x53, 0xa0, 0x46, 0x33, 0xa2, 0xe7,
	0x1c, 0xe8, 0x0b, 0x06, 0x80, 0x3f, 0xff, 0x75,
	0x03, 0xe8, 0x62, 0x00, 0x8b, 0x3e, 0x43, 0x33,
	0xe8, 0x70, 0x8c, 0x5b, 0x53, 0xe8, 0x25, 0x16,
	0x8b, 0x3e, 0x41, 0x33, 0xc7, 0x05, 0x01, 0x00,
	0x2e, 0x80, 0x3e, 0xd7, 0x00, 0x01, 0x74, 0x19,
	0x80, 0x3e, 0x96, 0x32, 0x00, 0x74, 0x08, 0xbb,
	0x92, 0x32, 0xe8, 0x79, 0x93, 0x72, 0x0a, 0xe8,
	0x51, 0x91, 0x72, 0x05, 0xe8, 0x1d, 0x91, 0x73,
	0xd4, 0x5b, 0x2e, 0x80, 0x3e, 0xd7, 0x00, 0x01,
	0x74, 0x13, 0xe8, 0x08, 0xfd, 0x80, 0x7f, 0x02,
	0x00, 0x75, 0xa4, 0x43, 0x80, 0x7f, 0x02, 0x00,
	0x74, 0x03, 0xe9, 0x37, 0xff, 0xe8, 0xaf, 0x05,
	0xe8, 0xf3, 0x94, 0xc6, 0x06, 0x33, 0x33, 0x01,
	0xc6, 0x06, 0xdd, 0x1c, 0x02, 0xc3, 0x60, 0x8b,
	0x3e, 0x41, 0x33, 0xc7, 0x05, 0x01, 0x00, 0x8b,
	0x3e, 0x43, 0x33, 0xc7, 0x05, 0x01, 0x00, 0xc6,
	0x06, 0x33, 0x33, 0x01, 0xc6, 0x06, 0xdd, 0x1c,
	0x02, 0xe8, 0xa2, 0x12, 0xc6, 0x06, 0x33, 0x33,
	0x00, 0xc6, 0x06, 0xdd, 0x1c, 0x03, 0xb8, 0x5a,
	0x00, 0xe8, 0x78, 0x09, 0x8b, 0x3e, 0x41, 0x33,
	0xc7, 0x05, 0x01, 0x00, 0x8b, 0x3e, 0x43, 0x33,
	0xc7, 0x05, 0x01, 0x00, 0x61, 0x43, 0xc3, 0x98,
	0x50, 0x56, 0xe8, 0xb8, 0xfc, 0x5e, 0x58, 0x50,
	0x48, 0xd1, 0xe0, 0xbb, 0x47, 0x33, 0x03, 0xd8,
	0x89, 0x37, 0xe8, 0x4f, 0x94, 0xc6, 0x06, 0x33,
	0x33, 0x01, 0xc6, 0x06, 0xdd, 0x1c, 0x02, 0xe8,
	0x5c, 0x12, 0xc6, 0x06, 0x33, 0x33, 0x00, 0xc6,
	0x06, 0xdd, 0x1c, 0x03, 0x58, 0xbf, 0xc7, 0x32,
	0xb3, 0x1b, 0x48, 0xf6, 0xe3, 0x03, 0xf8, 0x89,
	0x3e, 0x41, 0x33, 0xc7, 0x05, 0x01, 0x00, 0xbb,
	0xf0, 0xdb, 0x83, 0xc3, 0x02, 0x53, 0xa0, 0x45,
	0x33, 0xa2, 0xe7, 0x1c, 0xe8, 0x10, 0x05, 0x80,
	0x3f, 0xff, 0x75, 0x03, 0xe8, 0x53, 0x00, 0x8b,
	0x3e, 0x41, 0x33, 0xe8, 0x75, 0x8b, 0x5b, 0x53,
	0xe8, 0x2a, 0x15, 0x2e, 0x80, 0x3e, 0xd7, 0x00,
	0x01, 0x74, 0x19, 0x80, 0x3e, 0x96, 0x32, 0x00,
	0x74, 0x08, 0xbb, 0x92, 0x32, 0xe8, 0x86, 0x92,
	0x72, 0x0a, 0xe8, 0x5e, 0x90, 0x72, 0x05, 0xe8,
	0x2a, 0x90, 0x73, 0xdc, 0x5b, 0x2e, 0x80, 0x3e,
	0xd7, 0x00, 0x01, 0x74, 0x09, 0xe8, 0x15, 0xfc,
	0x80, 0x7f, 0x02, 0x00, 0x75, 0xac, 0xe8, 0x26,
	0x00, 0xe8, 0xc3, 0x04, 0xe8, 0x07, 0x94, 0xc6,
	0x06, 0x33, 0x33, 0x01, 0xc6, 0x06, 0xdd, 0x1c,
	0x02, 0xc3, 0x60, 0xe8, 0x11, 0x00, 0xb8, 0x5a,
	0x00, 0xe8, 0xb0, 0x08, 0x8b, 0x3e, 0x41, 0x33,
	0xc7, 0x05, 0x01, 0x00, 0x61, 0x43, 0xc3, 0x8b,
	0x3e, 0x41, 0x33, 0xc7, 0x05, 0x01, 0x00, 0xc6,
	0x06, 0x33, 0x33, 0x01, 0xc6, 0x06, 0xdd, 0x1c,
	0x02, 0xe8, 0xaa, 0x11, 0xc6, 0x06, 0x33, 0x33,
	0x00, 0xc6, 0x06, 0xdd, 0x1c, 0x03, 0xc3, 0xb0,
	0xe7, 0xb4, 0x00, 0xbf, 0x01, 0x00, 0xb3, 0x01,
	0xb7, 0x01, 0xb1, 0x01, 0xb5, 0x15, 0xb2, 0x01,
	0xb6, 0x01, 0xe8, 0x9b, 0x02, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x98, 0x03, 0xc6, 0x06, 0x96, 0xda,
	0x01, 0xc3, 0xe8, 0xda, 0xff, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x9a, 0x03, 0xc3, 0xe8, 0xcf, 0xff,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x99, 0x03, 0xc3,
	0xb0, 0xef, 0xb4, 0x00, 0xbf, 0x01, 0x00, 0xb3,
	0x01, 0xb7, 0x01, 0xb1, 0x01, 0xb5, 0x14, 0xb2,
	0x01, 0xb6, 0x01, 0xe8, 0x62, 0x02, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0x59, 0x03, 0xc6, 0x06, 0x96,
	0xda, 0x01, 0xc3, 0xb0, 0xec, 0xb4, 0x01, 0xbf,
	0x01, 0x00, 0xb3, 0x01, 0xb7, 0x01, 0xb1, 0x01,
	0xb5, 0x14, 0xb2, 0x01, 0xb6, 0x01, 0xe8, 0x3f,
	0x02, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x2d, 0x03,
	0xc6, 0x06, 0x96, 0xda, 0x01, 0xc3, 0xb0, 0xec,
	0xb4, 0x00, 0xbf, 0x01, 0x00, 0xb3, 0x01, 0xb7,
	0x01, 0xb1, 0x01, 0xb5, 0x14, 0xb2, 0x01, 0xb6,
	0x01, 0xe8, 0x1c, 0x02, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x2e, 0x03, 0xc6, 0x06, 0x96, 0xda, 0x01,
	0xc3, 0xe8, 0xda, 0xff, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x40, 0x03, 0xc3, 0xe8, 0xcf, 0xff, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0x58, 0x03, 0xc3, 0xe8,
	0xc4, 0xff, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xaa,
	0x03, 0xc3, 0xb0, 0xd0, 0xb4, 0x02, 0xbf, 0x01,
	0x00, 0xb3, 0x01, 0xb7, 0x01, 0xb1, 0x01, 0xb5,
	0x22, 0xb2, 0x01, 0xb6, 0x01, 0xe8, 0xd8, 0x01,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x29, 0x03, 0xc6,
	0x06, 0x96, 0xda, 0x01, 0xc3, 0xb0, 0xe5, 0xb4,
	0x01, 0xb3, 0x01, 0xb7, 0x01, 0xb1, 0x02, 0xb5,
	0x13, 0xb2, 0x14, 0xb6, 0x14, 0xbf, 0x01, 0x00,
	0xe8, 0xb5, 0x01, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0x0b, 0x02, 0xc6, 0x06, 0x96, 0xda, 0x01, 0xc3,
	0xb0, 0xd8, 0xb4, 0x01, 0xb3, 0x01, 0xb7, 0x01,
	0xb1, 0x01, 0xb5, 0x18, 0xb2, 0x18, 0xb6, 0x18,
	0xbf, 0x01, 0x00, 0xe8, 0x92, 0x01, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0x0a, 0x02, 0xc6, 0x06, 0x96,
	0xda, 0x01, 0xc3, 0xb0, 0xe5, 0xb4, 0x07, 0xb3,
	0x01, 0xb7, 0x02, 0xb1, 0x03, 0xb5, 0x20, 0xb2,
	0x21, 0xb6, 0x22, 0xbf, 0x03, 0x00, 0xe8, 0x6f,
	0x01, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xf6, 0x01,
	0xc6, 0x06, 0x96, 0xda, 0x01, 0xc3, 0xb0, 0xd9,
	0xb4, 0x01, 0xb3, 0x01, 0xb7, 0x01, 0xb1, 0x01,
	0xb5, 0x14, 0xb2, 0x15, 0xb6, 0x15, 0xbf, 0x01,
	0x00, 0xe8, 0x4c, 0x01, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x11, 0x02, 0xc6, 0x06, 0x96, 0xda, 0x01,
	0xc3, 0xb0, 0xd9, 0xb4, 0x00, 0xb3, 0x01, 0xb7,
	0x01, 0xb1, 0x01, 0xb5, 0x09, 0xb2, 0x09, 0xb6,
	0x09, 0xbf, 0x01, 0x00, 0xe8, 0x29, 0x01, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0x22, 0x02, 0xc6, 0x06,
	0x96, 0xda, 0x01, 0xc3, 0xb0, 0xe5, 0xb4, 0x01,
	0xbf, 0x01, 0x00, 0xb3, 0x01, 0xb7, 0x01, 0xb1,
	0x01, 0xb5, 0x14, 0xb2, 0x15, 0xb6, 0x15, 0xe8,
	0x06, 0x01, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0x0c, 0x02, 0xc6, 0x06, 0x96, 0xda, 0x02, 0xc3,
	0xb0, 0xe5, 0xb4, 0x04, 0xbf, 0x01, 0x00, 0xb3,
	0x01, 0xb7, 0x01, 0xb1, 0x01, 0xb5, 0x1f, 0xb2,
	0x01, 0xb6, 0x01, 0xe8, 0xe2, 0x00, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x02, 0xa0, 0x02, 0xc6, 0x06,
	0x96, 0xda, 0x02, 0xc3, 0xb0, 0xd0, 0xb4, 0x01,
	0xbf, 0x03, 0x00, 0xb3, 0x03, 0xb7, 0x03, 0xb1,
	0x01, 0xb5, 0x0d, 0xb2, 0x03, 0xb6, 0x03, 0xe8,
	0xbe, 0x00, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0x9a, 0x02, 0xc6, 0x06, 0x96, 0xda, 0x02, 0xc3,
	0xb0, 0xd0, 0xb4, 0x06, 0xbf, 0x01, 0x00, 0xb3,
	0x01, 0xb7, 0x01, 0xb1, 0x01, 0xb5, 0x12, 0xb2,
	0x01, 0xb6, 0x01, 0xe8, 0x9a, 0x00, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0x1d, 0x03, 0xc6, 0x06, 0x96,
	0xda, 0x01, 0xc3, 0xb0, 0xd0, 0xb4, 0x01, 0xbf,
	0x01, 0x00, 0xb3, 0x01, 0xb7, 0x01, 0xb1, 0x01,
	0xb5, 0x14, 0xb2, 0x01, 0xb6, 0x01, 0xe8, 0x77,
	0x00, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xbe, 0x02,
	0xc6, 0x06, 0x96, 0xda, 0x01, 0xc3, 0xb0, 0xef,
	0xb4, 0x01, 0xbf, 0x01, 0x00, 0xb3, 0x01, 0xb7,
	0x01, 0xb1, 0x01, 0xb5, 0x14, 0xb2, 0x01, 0xb6,
	0x01, 0xe8, 0x54, 0x00, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0xc5, 0x02, 0xc6, 0x06, 0x96, 0xda, 0x01,
	0xc3, 0xb0, 0xef, 0xb4, 0x01, 0xbf, 0x01, 0x00,
	0xb3, 0x01, 0xb7, 0x01, 0xb1, 0x01, 0xb5, 0x03,
	0xb2, 0x01, 0xb6, 0x01, 0xe8, 0x31, 0x00, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0xd7, 0x02, 0xc6, 0x06,
	0x96, 0xda, 0x01, 0xc3, 0xb0, 0xd0, 0xb4, 0x00,
	0xb3, 0x01, 0xb7, 0x01, 0xb1, 0x01, 0xb5, 0x18,
	0xb2, 0x01, 0xb6, 0x01, 0xbf, 0x01, 0x00, 0xe8,
	0x0e, 0x00, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x06,
	0x17, 0x03, 0xc6, 0x06, 0x96, 0xda, 0x04, 0xc3,
	0xa2, 0xe7, 0x1c, 0x88, 0x26, 0x97, 0xda, 0x89,
	0x3e, 0xa4, 0xda, 0x88, 0x1e, 0x98, 0xda, 0x88,
	0x3e, 0x9a, 0xda, 0x88, 0x0e, 0x9c, 0xda, 0x88,
	0x2e, 0x9e, 0xda, 0x88, 0x16, 0xa0, 0xda, 0x88,
	0x36, 0xa2, 0xda, 0xc3, 0x26, 0x8b, 0x0f, 0x26,
	0x8b, 0x57, 0x02, 0x26, 0x8b, 0x77, 0x04, 0x8b,
	0xf9, 0x83, 0xc3, 0x06, 0x1e, 0x8e, 0xd8, 0x8b,
	0xcf, 0x26, 0x8a, 0x07, 0x3c, 0xff, 0x74, 0x02,
	0x88, 0x04, 0x43, 0x46, 0xe2, 0xf3, 0x81, 0xc6,
	0x40, 0x01, 0x2b, 0xf7, 0x4a, 0x75, 0xe8, 0x1f,
	0xc3, 0x50, 0x32, 0xe4, 0xe8, 0x66, 0x8a, 0x58,
	0xc6, 0x47, 0x12, 0x01, 0xc3, 0x50, 0x32, 0xe4,
	0xe8, 0x5a, 0x8a, 0x58, 0xc6, 0x47, 0x12, 0x00,
	0xc3, 0xb4, 0x00, 0xe8, 0x4f, 0x8a, 0x83, 0xc3,
	0x13, 0xfc, 0xac, 0x3c, 0xff, 0x74, 0x05, 0x88,
	0x07, 0x43, 0xeb, 0xf6, 0xc3, 0x50, 0x51, 0x52,
	0xb4, 0x00, 0xe8, 0x38, 0x8a, 0x5a, 0x59, 0x58,
	0x89, 0x4f, 0x09, 0x89, 0x57, 0x0b, 0x89, 0x4f,
	0x0d, 0x89, 0x57, 0x0f, 0x88, 0x67, 0x11, 0xc3,
	0xe8, 0x04, 0x00, 0xe8, 0xc8, 0xf8, 0xc3, 0x32,
	0xe4, 0x50, 0xe8, 0x2f, 0x90, 0x58, 0x50, 0xbe,
	0xc7, 0x32, 0xbb, 0x47, 0x33, 0x48, 0xb1, 0x1b,
	0xf6, 0xe1, 0x03, 0xf0, 0x06, 0x8b, 0x44, 0x16,
	0x8e, 0xc0, 0xba, 0x02, 0x00, 0xbe, 0x00, 0x00,
	0x26, 0x8b, 0x34, 0x2b, 0xf2, 0x8b, 0xc6, 0xb1,
	0x03, 0xf6, 0xf1, 0x07, 0x8b, 0xd0, 0xb9, 0x01,
	0x00, 0x51, 0x52, 0xe8, 0x75, 0x8f, 0x5a, 0x59,
	0x58, 0xc3, 0xe8, 0xc2, 0xff, 0xe8, 0x97, 0xf8,
	0xc3, 0xe8, 0xeb, 0x00, 0xe8, 0xb1, 0xff, 0xe8,
	0x2c, 0x90, 0xc6, 0x06, 0x33, 0x33, 0x01, 0xc6,
	0x06, 0xdd, 0x1c, 0x02, 0xc3, 0xc6, 0x06, 0x27,
	0xc4, 0x00, 0xe8, 0xd2, 0x00, 0xe8, 0x9f, 0xff,
	0xe8, 0xcb, 0xf8, 0xa3, 0x3f, 0x33, 0x0b, 0xc0,
	0x74, 0x4d, 0xa1, 0x52, 0x72, 0xa3, 0x50, 0x72,
	0xa1, 0x50, 0x72, 0x3b, 0x06, 0x23, 0xc4, 0x75,
	0x3e, 0xa1, 0x1f, 0xc4, 0xe8, 0xbd, 0x0d, 0x3b,
	0x06, 0x25, 0xc4, 0x75, 0x32, 0xa0, 0xce, 0x00,
	0x0a, 0xc0, 0x74, 0x06, 0x3a, 0x06, 0xcf, 0x00,
	0x75, 0x25, 0xc6, 0x06, 0x27, 0xc4, 0x01, 0xa1,
	0x3f, 0x33, 0x3b, 0x06, 0x3b, 0x33, 0x72, 0x17,
	0x3b, 0x06, 0x3d, 0x33, 0x77, 0x11, 0xe8, 0x0e,
	0x00, 0xa3, 0x52, 0x72, 0xa3, 0x50, 0x72, 0xa3,
	0x1f, 0xc4, 0xa2, 0xcf, 0x00, 0xf9, 0xc3, 0x33,
	0xc0, 0xa3, 0x23, 0xc4, 0xa3, 0x25, 0xc4, 0xa3,
	0x3b, 0x33, 0xa3, 0x3d, 0x33, 0xf8, 0xc3, 0xe8,
	0x65, 0x00, 0xe8, 0x50, 0x8f, 0xe8, 0x64, 0x8f,
	0xe8, 0xd8, 0x8e, 0xe8, 0x38, 0x01, 0xc3, 0xe8,
	0x55, 0x00, 0xc6, 0x06, 0xdc, 0x64, 0x00, 0xe8,
	0xe8, 0xff, 0xc6, 0x06, 0xdc, 0x64, 0x01, 0xc3,
	0xe8, 0xdc, 0xff, 0xe8, 0x16, 0x00, 0xc3, 0xe8,
	0xd8, 0xff, 0xe8, 0x0f, 0x00, 0xc3, 0xe8, 0xde,
	0xff, 0xe8, 0x08, 0x00, 0xc3, 0xe8, 0xda, 0xff,
	0xe8, 0x01, 0x00, 0xc3, 0xe8, 0x64, 0x90, 0xe8,
	0x6c, 0x8f, 0xe8, 0x44, 0x23, 0xc6, 0x06, 0x33,
	0x33, 0x01, 0xc6, 0x06, 0xdd, 0x1c, 0x02, 0xc6,
	0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x2f, 0x0d, 0xc6,
	0x06, 0x33, 0x33, 0x00, 0xc6, 0x06, 0xdd, 0x1c,
	0x03, 0xc6, 0x06, 0xdc, 0x1c, 0x03, 0xc3, 0xc6,
	0x06, 0xda, 0x1c, 0x01, 0xc6, 0x06, 0xdb, 0x1c,
	0x01, 0xe8, 0x12, 0x0d, 0xc6, 0x06, 0xda, 0x1c,
	0x00, 0xc6, 0x06, 0xdb, 0x1c, 0x00, 0xc3, 0xe8,
	0xd3, 0x8e, 0xe8, 0xe7, 0x8e, 0xe8, 0x5b, 0x8e,
	0xe8, 0x47, 0x24, 0xc6, 0x06, 0x07, 0x66, 0x01,
	0xa1, 0x7a, 0x32, 0x3a, 0x06, 0x07, 0x66, 0x75,
	0x03, 0xe8, 0xe9, 0x8d, 0xbb, 0xa4, 0x32, 0xe8,
	0x64, 0x8d, 0x73, 0xf8, 0x8b, 0x0e, 0x90, 0x32,
	0xe8, 0x48, 0x8d, 0xc6, 0x06, 0x33, 0x33, 0x01,
	0xc6, 0x06, 0xdd, 0x1c, 0x02, 0xc6, 0x06, 0xdc,
	0x1c, 0x02, 0xe8, 0x1f, 0x13, 0xe8, 0xfc, 0x0f,
	0xe8, 0x13, 0x0f, 0xe8, 0x4d, 0x13, 0x72, 0x77,
	0xe8, 0x40, 0x10, 0xe8, 0xa9, 0x11, 0xa0, 0x07,
	0x66, 0xfe, 0xc8, 0x3a, 0x06, 0x35, 0x33, 0x75,
	0x12, 0x8b, 0x1e, 0x37, 0x33, 0x8b, 0x36, 0x39,
	0x33, 0xe8, 0xfb, 0x86, 0xc6, 0x06, 0xdb, 0x1c,
	0x02, 0xeb, 0x0b, 0x3a, 0x06, 0x36, 0x33, 0x75,
	0x05, 0xc6, 0x06, 0xdb, 0x1c, 0x01, 0xe8, 0xf5,
	0x0e, 0xa1, 0x7a, 0x32, 0x0b, 0xc0, 0x74, 0x1e,
	0x40, 0x3a, 0x06, 0x07, 0x66, 0x75, 0x17, 0xa0,
	0x49, 0x32, 0xb4, 0x04, 0x8a, 0x2e, 0x7c, 0x32,
	0xff, 0x1e, 0x4a, 0x32, 0xb8, 0x3b, 0x0b, 0x8e,
	0xd8, 0x8e, 0xc0, 0xe8, 0xa5, 0x8d, 0xe8, 0xff,
	0x8a, 0xe8, 0x45, 0x18, 0xe8, 0xf8, 0x11, 0xe8,
	0x10, 0x0f, 0xe8, 0xba, 0x89, 0xc6, 0x06, 0x33,
	0x33, 0x00, 0xc6, 0x06, 0xdd, 0x1c, 0x03, 0xc6,
	0x06, 0xdc, 0x1c, 0x03, 0xe9, 0x51, 0xff, 0xc7,
	0x06, 0x7a, 0x32, 0x00, 0x00, 0xc3, 0xe8, 0x7d,
	0x90, 0xe8, 0x86, 0x23, 0xc6, 0x06, 0x07, 0x66,
	0x01, 0xa1, 0x7a, 0x32, 0x3a, 0x06, 0x07, 0x66,
	0x75, 0x03, 0xe8, 0x28, 0x8d, 0xbb, 0xa4, 0x32,
	0xe8, 0xa3, 0x8c, 0x73, 0xf8, 0x8b, 0x0e, 0x90,
	0x32, 0xe8, 0x87, 0x8c, 0xc6, 0x06, 0x33, 0x33,
	0x01, 0xc6, 0x06, 0xdd, 0x1c, 0x02, 0xc6, 0x06,
	0xdc, 0x1c, 0x02, 0xe8, 0x5e, 0x12, 0xe8, 0x3b,
	0x0f, 0xe8, 0x8f, 0x12, 0x72, 0x48, 0xe8, 0x82,
	0x0f, 0xe8, 0xeb, 0x10, 0xa1, 0x7a, 0x32, 0x0b,
	0xc0, 0x74, 0x1e, 0x40, 0x3a, 0x06, 0x07, 0x66,
	0x75, 0x17, 0xa0, 0x49, 0x32, 0xb4, 0x04, 0x8a,
	0x2e, 0x7c, 0x32, 0xff, 0x1e, 0x4a, 0x32, 0xb8,
	0x3b, 0x0b, 0x8e, 0xd8, 0x8e, 0xc0, 0xe8, 0x12,
	0x8d, 0xe8, 0x6c, 0x8a, 0xe8, 0xb2, 0x17, 0xe8,
	0x65, 0x11, 0xe8, 0x2a, 0x89, 0xc6, 0x06, 0x33,
	0x33, 0x00, 0xc6, 0x06, 0xdd, 0x1c, 0x03, 0xc6,
	0x06, 0xdc, 0x1c, 0x03, 0xeb, 0x83, 0xc7, 0x06,
	0x7a, 0x32, 0x00, 0x00, 0xc3, 0xc6, 0x06, 0x27,
	0xc4, 0x00, 0xe8, 0x32, 0x89, 0xe8, 0xf2, 0x22,
	0xc6, 0x06, 0x07, 0x66, 0x01, 0xa1, 0x7a, 0x32,
	0x3a, 0x06, 0x07, 0x66, 0x75, 0x03, 0xe8, 0x94,
	0x8c, 0xc6, 0x06, 0xdd, 0x1c, 0x03, 0xc6, 0x06,
	0xdc, 0x1c, 0x03, 0xc6, 0x06, 0xda, 0x1c, 0x01,
	0xe8, 0xe0, 0x0b, 0x3d, 0x01, 0x00, 0x76, 0x05,
	0xc6, 0x06, 0xda, 0x1c, 0x02, 0xe8, 0xcc, 0x11,
	0xe8, 0xa9, 0x0e, 0xe8, 0xff, 0x0c, 0xe8, 0x5e,
	0x10, 0xe8, 0x11, 0x0d, 0xe8, 0x01, 0x8a, 0xe8,
	0x47, 0x17, 0xe8, 0xfa, 0x10, 0xe8, 0x48, 0x0d,
	0xe8, 0xbc, 0x88, 0xa0, 0x07, 0x66, 0x32, 0xe4,
	0xe8, 0xb0, 0x89, 0xc6, 0x06, 0xcf, 0x00, 0x04,
	0x73, 0x03, 0xe9, 0x8f, 0x00, 0xe8, 0x74, 0x89,
	0xc6, 0x06, 0xcf, 0x00, 0x02, 0x73, 0x03, 0xe9,
	0x82, 0x00, 0x33, 0xc0, 0xa2, 0xcf, 0x00, 0xbb,
	0xa4, 0x32, 0xe8, 0xb1, 0x8b, 0x73, 0x9a, 0x50,
	0x8b, 0x0e, 0x90, 0x32, 0xe8, 0x94, 0x8b, 0xc6,
	0x06, 0x33, 0x33, 0x01, 0xc6, 0x06, 0xdd, 0x1c,
	0x02, 0xc6, 0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x6b,
	0x11, 0xe8, 0x48, 0x0e, 0xe8, 0x9e, 0x0c, 0xe8,
	0x99, 0x11, 0x58, 0x72, 0x4f, 0xe8, 0x8b, 0x0e,
	0xe8, 0xf4, 0x0f, 0xe8, 0xa7, 0x0c, 0xa1, 0x7a,
	0x32, 0x0b, 0xc0, 0x74, 0x1e, 0x40, 0x3a, 0x06,
	0x07, 0x66, 0x75, 0x17, 0xa0, 0x49, 0x32, 0xb4,
	0x04, 0x8a, 0x2e, 0x7c, 0x32, 0xff, 0x1e, 0x4a,
	0x32, 0xb8, 0x3b, 0x0b, 0x8e, 0xd8, 0x8e, 0xc0,
	0xe8, 0x18, 0x8c, 0xe8, 0x72, 0x89, 0xe8, 0xb8,
	0x16, 0xe8, 0x6b, 0x10, 0xe8, 0xb9, 0x0c, 0xe8,
	0x2d, 0x88, 0xc6, 0x06, 0x33, 0x33, 0x00, 0xc6,
	0x06, 0xdd, 0x1c, 0x03, 0xc6, 0x06, 0xdc, 0x1c,
	0x03, 0xe9, 0x19, 0xff, 0x50, 0xc6, 0x06, 0xda,
	0x1c, 0x01, 0xe8, 0x40, 0x0c, 0xe8, 0x55, 0x0c,
	0xe8, 0x45, 0x89, 0xe8, 0x92, 0x0c, 0xe8, 0x06,
	0x88, 0xe8, 0x09, 0x88, 0x58, 0x8b, 0x0e, 0x52,
	0x72, 0x8b, 0x16, 0x3d, 0x33, 0x51, 0x52, 0xe8,
	0xa9, 0xfc, 0x72, 0x07, 0xe8, 0x5a, 0xfe, 0x5a,
	0x59, 0xf8, 0xc3, 0x89, 0x16, 0x3d, 0x33, 0xa1,
	0x7a, 0x32, 0x3a, 0x06, 0x07, 0x66, 0x75, 0x03,
	0xe8, 0x7a, 0x8b, 0xbb, 0xa4, 0x32, 0xe8, 0xf5,
	0x8a, 0x73, 0xf8, 0x8b, 0x0e, 0x90, 0x32, 0xe8,
	0xd9, 0x8a, 0xc6, 0x06, 0x33, 0x33, 0x01, 0xc6,
	0x06, 0xdd, 0x1c, 0x02, 0xc6, 0x06, 0xdc, 0x1c,
	0x02, 0xe8, 0xb0, 0x10, 0xe8, 0x8d, 0x0d, 0xe8,
	0xe1, 0x10, 0x72, 0x54, 0xa0, 0x07, 0x66, 0x32,
	0xe4, 0x3b, 0x06, 0x3d, 0x33, 0x73, 0x49, 0xe8,
	0xc9, 0x0d, 0xe8, 0x32, 0x0f, 0xa1, 0x7a, 0x32,
	0x0b, 0xc0, 0x74, 0x1e, 0x40, 0x3a, 0x06, 0x07,
	0x66, 0x75, 0x17, 0xa0, 0x49, 0x32, 0xb4, 0x04,
	0x8a, 0x2e, 0x7c, 0x32, 0xff, 0x1e, 0x4a, 0x32,
	0xb8, 0x3b, 0x0b, 0x8e, 0xd8, 0x8e, 0xc0, 0xe8,
	0x59, 0x8b, 0xe8, 0xb3, 0x88, 0xe8, 0xf9, 0x15,
	0xe8, 0xac, 0x0f, 0xe8, 0x71, 0x87, 0xc6, 0x06,
	0x33, 0x33, 0x00, 0xc6, 0x06, 0xdd, 0x1c, 0x03,
	0xc6, 0x06, 0xdc, 0x1c, 0x03, 0xe9, 0x77, 0xff,
	0x33, 0xc0, 0xa3, 0x7a, 0x32, 0xa3, 0x3d, 0x33,
	0x5a, 0x59, 0xf9, 0xc3, 0xb9, 0xe8, 0x03, 0xbb,
	0xac, 0x32, 0xe8, 0x56, 0x8a, 0xc7, 0x06, 0x52,
	0x72, 0x00, 0x00, 0xc7, 0x06, 0x50, 0x72, 0x00,
	0x00, 0xc7, 0x06, 0x1f, 0xc4, 0x00, 0x00, 0xe8,
	0x5d, 0x87, 0xe8, 0x7a, 0x01, 0x73, 0x09, 0xb9,
	0xe8, 0x03, 0xbb, 0xac, 0x32, 0xe8, 0x33, 0x8a,
	0xe8, 0xd2, 0x0c, 0xe8, 0xf0, 0x09, 0x33, 0xc0,
	0xa2, 0xcf, 0x00, 0xbb, 0xac, 0x32, 0xe8, 0x35,
	0x8a, 0x72, 0x1c, 0xe8, 0x0d, 0x88, 0xc6, 0x06,
	0xcf, 0x00, 0x04, 0x72, 0x0a, 0xe8, 0xd4, 0x87,
	0xc6, 0x06, 0xcf, 0x00, 0x02, 0x73, 0xcb, 0xe8,
	0x03, 0x87, 0xe8, 0x7a, 0xfc, 0xf9, 0xc3, 0xe8,
	0xfb, 0x86, 0xe8, 0x72, 0xfc, 0xf8, 0xc3, 0x0b,
	0xc0, 0x75, 0x01, 0xc3, 0x33, 0xdb, 0x8a, 0xd8,
	0x43, 0xbf, 0xc7, 0x32, 0xb0, 0x1b, 0xfe, 0xcc,
	0xf6, 0xe4, 0x03, 0xf8, 0x53, 0x57, 0x8b, 0x05,
	0x3b, 0xc3, 0x74, 0x07, 0xe8, 0x7e, 0x0c, 0x5f,
	0x5b, 0xeb, 0xf1, 0x5f, 0x5b, 0xc3, 0x0b, 0xc0,
	0x75, 0x01, 0xc3, 0x0a, 0xc0, 0x75, 0x01, 0xc3,
	0x33, 0xdb, 0x8a, 0xd8, 0xbf, 0xc7, 0x32, 0xb0,
	0x1b, 0xfe, 0xcc, 0xf6, 0xe4, 0x03, 0xf8, 0x53,
	0x57, 0x8a, 0x45, 0x1a, 0x3a, 0xc3, 0x74, 0x07,
	0xe8, 0x52, 0x0c, 0x5f, 0x5b, 0xeb, 0xf0, 0x5f,
	0x5b, 0xc3, 0xbb, 0xa8, 0x32, 0x8b, 0xc8, 0xe8,
	0xa1, 0x89, 0xe8, 0x40, 0x0c, 0xbb, 0xa8, 0x32,
	0xe8, 0xab, 0x89, 0x73, 0xf5, 0xc3, 0xb8, 0x32,
	0x00, 0xe8, 0xe6, 0xff, 0xc3, 0xb8, 0x64, 0x00,
	0xe8, 0xdf, 0xff, 0xc3, 0xbb, 0xa8, 0x32, 0x8b,
	0xc8, 0xe8, 0x7f, 0x89, 0xbb, 0xa8, 0x32, 0xe8,
	0x8c, 0x89, 0x73, 0xf8, 0xc3, 0x53, 0xb8, 0x10,
	0x00, 0xe8, 0xe8, 0xff, 0x5b, 0xc3, 0xa0, 0xe1,
	0xc3, 0x0a, 0xc0, 0x74, 0x14, 0xbb, 0x6f, 0xbb,
	0x83, 0xc3, 0x03, 0x8a, 0x27, 0x3a, 0xc4, 0x75,
	0xf7, 0x8b, 0x47, 0x01, 0xa3, 0xdc, 0xbb, 0xeb,
	0x1d, 0x80, 0x3e, 0x3d, 0x66, 0x06, 0x74, 0x01,
	0xc3, 0x80, 0x3e, 0xdb, 0xbb, 0x01, 0x74, 0x0e,
	0xbb, 0x57, 0x34, 0xe8, 0xaf, 0x80, 0xc7, 0x06,
	0x1f, 0xc4, 0x00, 0x00, 0xeb, 0x10, 0xe8, 0x2c,
	0x86, 0xc7, 0x06, 0x1f, 0xc4, 0x00, 0x00, 0xff,
	0x16, 0xdc, 0xbb, 0xe8, 0x41, 0x86, 0xc6, 0x06,
	0x3d, 0x66, 0x00, 0x33, 0xc0, 0xa3, 0x50, 0x72,
	0xa3, 0x52, 0x72, 0xa2, 0xe1, 0xc3, 0xe8, 0x7f,
	0x15, 0xc3, 0xc6, 0x06, 0xdb, 0xbb, 0x00, 0xbb,
	0x87, 0xbb, 0xe8, 0xfd, 0x1f, 0x8a, 0x07, 0x0a,
	0xc0, 0x74, 0x31, 0x8a, 0xc8, 0xa1, 0x1f, 0xc4,
	0xe8, 0x79, 0x08, 0x3a, 0xc1, 0x75, 0x26, 0x8a,
	0x67, 0x01, 0x3a, 0x26, 0x50, 0x72, 0x75, 0x1d,
	0xc6, 0x06, 0xdb, 0xbb, 0x01, 0x8b, 0x77, 0x03,
	0x8b, 0x7f, 0x05, 0x8a, 0x47, 0x02, 0xa2, 0xc3,
	0x64, 0x8b, 0x47, 0x07, 0xa3, 0xdc, 0xbb, 0xe8,
	0xc8, 0x1b, 0x72, 0x06, 0xc3, 0x83, 0xc3, 0x09,
	0xeb, 0xc3, 0xb0, 0x36, 0xe9, 0x49, 0x93, 0x83,
	0x3e, 0xc2, 0x00, 0x00, 0x74, 0x05, 0xe8, 0x21,
	0x00, 0xf8, 0xc3, 0xbb, 0x98, 0x32, 0x8b, 0x07,
	0x0b, 0x47, 0x02, 0x75, 0x06, 0xb9, 0x32, 0x00,
	0xe8, 0xa8, 0x88, 0xe8, 0xb8, 0x88, 0x72, 0x02,
	0xf8, 0xc3, 0xe8, 0x05, 0x00, 0xe8, 0x66, 0x00,
	0xf9, 0xc3, 0xbb, 0x98, 0x32, 0x33, 0xc0, 0x89,
	0x07, 0x89, 0x47, 0x02, 0xc3, 0xb8, 0x11, 0x00,
	0xba, 0x0c, 0x00, 0x8b, 0x1e, 0xc0, 0x00, 0x8b,
	0x0e, 0xc2, 0x00, 0x3b, 0xd8, 0x72, 0x1d, 0x3b,
	0xca, 0x72, 0x19, 0x05, 0x1e, 0x01, 0x81, 0xc2,
	0x8d, 0x00, 0x3b, 0xd8, 0x77, 0x0e, 0x3b, 0xca,
	0x77, 0x0a, 0xc6, 0x06, 0x6e, 0xc4, 0x01, 0xe8,
	0xc8, 0xff, 0xf8, 0xc3, 0xbb, 0x6e, 0xc4, 0x80,
	0x3f, 0x01, 0x74, 0x05, 0xc6, 0x07, 0x00, 0xf8,
	0xc3, 0xbb, 0x98, 0x32, 0x8b, 0x07, 0x0b, 0x47,
	0x02, 0xe8, 0xae, 0xff, 0xc6, 0x06, 0x6e, 0xc4,
	0x00, 0xf9, 0xc3, 0xb9, 0x19, 0x00, 0xbb, 0x98,
	0x32, 0xe8, 0x37, 0x88, 0xf8, 0xc3, 0xc6, 0x06,
	0xe1, 0xc3, 0x00, 0xc6, 0x06, 0xda, 0x1c, 0x01,
	0xe8, 0x4a, 0x09, 0xe8, 0x2d, 0x09, 0xe8, 0x79,
	0x00, 0xbf, 0x75, 0xc4, 0xb0, 0x01, 0xb9, 0x18,
	0x00, 0xfc, 0xf3, 0xaa, 0xa1, 0xbf, 0x32, 0xa3,
	0xac, 0x00, 0x33, 0xc0, 0xa3, 0xaa, 0x00, 0xb9,
	0x04, 0x00, 0xba, 0x54, 0x00, 0xe8, 0x90, 0x8e,
	0xe8, 0x9c, 0x00, 0xe8, 0x45, 0x02, 0xe8, 0xf4,
	0x84, 0xe8, 0xbc, 0x8a, 0xe8, 0xa4, 0x8a, 0xe8,
	0x13, 0x00, 0xe8, 0x1b, 0x86, 0xe8, 0x9a, 0x00,
	0xe8, 0x6f, 0x00, 0xe8, 0x01, 0x85, 0xc7, 0x06,
	0x52, 0x72, 0x00, 0x00, 0xc3, 0xe8, 0x9f, 0x87,
	0x80, 0x3e, 0xb0, 0x32, 0x01, 0x74, 0x05, 0xc6,
	0x06, 0xdc, 0x1c, 0x03, 0xc6, 0x06, 0xda, 0x1c,
	0x01, 0x83, 0x3e, 0x1f, 0xc4, 0x00, 0x74, 0x05,
	0xc6, 0x06, 0xda, 0x1c, 0x02, 0xe8, 0x4e, 0x07,
	0xc6, 0x06, 0xda, 0x1c, 0x00, 0x83, 0x3e, 0x1f,
	0xc4, 0x00, 0x74, 0x05, 0xc6, 0x06, 0xda, 0x1c,
	0x03, 0xc3, 0xc6, 0x06, 0x3d, 0x66, 0x00, 0xc7,
	0x06, 0x1f, 0xc4, 0x00, 0x00, 0xc6, 0x06, 0xc3,
	0x64, 0x00, 0xe8, 0x75, 0x1e, 0x80, 0x3e, 0xb0,
	0x32, 0x01, 0x74, 0x15, 0xe8, 0x22, 0x1d, 0xc6,
	0x06, 0xdc, 0x1c, 0x02, 0xc6, 0x06, 0xda, 0x1c,
	0x01, 0xe8, 0x12, 0x07, 0xc6, 0x06, 0xdc, 0x1c,
	0x03, 0xc3, 0x06, 0x1e, 0xb8, 0x00, 0xa0, 0x8e,
	0xc0, 0xa1, 0xb1, 0x32, 0x8e, 0xd8, 0xfc, 0xf3,
	0xa5, 0x1f, 0xe8, 0x5a, 0x84, 0x07, 0xc3, 0xe8,
	0x13, 0x01, 0xe8, 0x4c, 0x00, 0xe8, 0x2f, 0x01,
	0xe8, 0x07, 0x00, 0xe8, 0x82, 0x85, 0xe8, 0xd9,
	0xff, 0xc3, 0xb8, 0x0c, 0x00, 0xbb, 0x40, 0x01,
	0xf7, 0xe3, 0x8b, 0xf0, 0x8b, 0xf8, 0xb8, 0x0c,
	0x00, 0x05, 0x8d, 0x00, 0xf7, 0xe3, 0x2b, 0xc6,
	0x8b, 0xc8, 0xd1, 0xe9, 0xc3, 0xe8, 0x60, 0x85,
	0xe8, 0x2a, 0x84, 0xe8, 0xdc, 0xff, 0xe8, 0xb1,
	0xff, 0xe8, 0x43, 0x84, 0xc7, 0x06, 0x52, 0x72,
	0x00, 0x00, 0xbf, 0x75, 0xc4, 0xb0, 0x01, 0xb9,
	0x18, 0x00, 0xfc, 0xf3, 0xaa, 0xe8, 0xaf, 0xff,
	0xc3, 0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0, 0x33,
	0xc9, 0x3b, 0x0e, 0x73, 0xc4, 0x73, 0x20, 0x41,
	0x51, 0xe8, 0x1d, 0x00, 0x89, 0x36, 0x71, 0xc4,
	0xb9, 0x1a, 0x00, 0xba, 0x28, 0x00, 0xe8, 0x4f,
	0x00, 0xb4, 0xea, 0xe8, 0x37, 0x02, 0xc7, 0x06,
	0x71, 0xc4, 0x00, 0x00, 0x59, 0xeb, 0xda, 0x07,
	0xc3, 0x33, 0xd2, 0x49, 0xfe, 0xce, 0xfe, 0xc6,
	0x83, 0xe9, 0x06, 0x73, 0xf9, 0x83, 0xc1, 0x06,
	0xbe, 0x11, 0x0f, 0x81, 0xc6, 0x45, 0x06, 0x81,
	0xc6, 0x45, 0x06, 0x33, 0xc0, 0x0a, 0xf6, 0x74,
	0x0a, 0x05, 0x1a, 0x00, 0x05, 0x05, 0x00, 0xfe,
	0xce, 0xeb, 0xf2, 0xf7, 0x26, 0xb6, 0x00, 0x03,
	0xf0, 0x0a, 0xc9, 0x74, 0x0a, 0x83, 0xc6, 0x28,
	0x83, 0xc6, 0x05, 0xfe, 0xc9, 0xeb, 0xf2, 0xc3,
	0x1e, 0x52, 0xbb, 0x40, 0x01, 0xa1, 0xb5, 0x32,
	0x8e, 0xd8, 0x8b, 0xc6, 0x2d, 0x11, 0x0f, 0x33,
	0xd2, 0xf7, 0xf3, 0x8b, 0xfa, 0x83, 0xc7, 0x06,
	0xbb, 0x1e, 0x01, 0xf7, 0xe3, 0x03, 0xf8, 0x5a,
	0x81, 0xc6, 0x41, 0x01, 0x81, 0xc7, 0x1f, 0x01,
	0x49, 0x49, 0x4a, 0x4a, 0x8b, 0xd9, 0x8b, 0xca,
	0x8a, 0x05, 0x3c, 0xe8, 0x75, 0x06, 0x26, 0xc6,
	0x04, 0xd6, 0xeb, 0x04, 0x26, 0xc6, 0x04, 0xe0,
	0x46, 0x47, 0xe2, 0xec, 0x81, 0xc6, 0x40, 0x01,
	0x2b, 0xf2, 0x81, 0xc7, 0x1e, 0x01, 0x2b, 0xfa,
	0x4b, 0x75, 0xdb, 0x1f, 0xc3, 0x06, 0xa1, 0xb5,
	0x32, 0x8e, 0xc0, 0xa3, 0xac, 0x00, 0xc7, 0x06,
	0xaa, 0x00, 0x00, 0x00, 0xb9, 0x03, 0x00, 0xba,
	0x54, 0x00, 0xe8, 0xc3, 0x8c, 0xa1, 0xb1, 0x32,
	0x33, 0xdb, 0xe8, 0xf7, 0xf6, 0x07, 0xc3, 0x06,
	0xa1, 0xbf, 0x32, 0x8e, 0xc0, 0x33, 0xc9, 0x3b,
	0x0e, 0x73, 0xc4, 0x73, 0x45, 0x41, 0x51, 0xbb,
	0x8c, 0xc4, 0x03, 0xd9, 0x33, 0xc9, 0x8a, 0x0f,
	0xbf, 0xfe, 0xff, 0xbe, 0xa4, 0xc4, 0xd1, 0xe1,
	0x03, 0xf9, 0x03, 0xf1, 0xd1, 0xe9, 0x8b, 0x34,
	0x47, 0x26, 0x8b, 0x3d, 0x80, 0x7c, 0x01, 0x00,
	0x74, 0x04, 0x26, 0x03, 0x7d, 0x01, 0x59, 0x51,
	0xe8, 0x0e, 0xff, 0x26, 0x8b, 0x0d, 0x26, 0x8b,
	0x55, 0x02, 0x26, 0x03, 0x75, 0x04, 0x83, 0xc7,
	0x06, 0xa1, 0xb1, 0x32, 0xe8, 0x05, 0x00, 0x59,
	0xeb, 0xb5, 0x07, 0xc3, 0x1e, 0x8e, 0xd8, 0x8b,
	0xd9, 0x8b, 0xcb, 0x26, 0x8a, 0x05, 0x3c, 0xff,
	0x74, 0x02, 0x88, 0x04, 0x47, 0x46, 0xe2, 0xf3,
	0x81, 0xc6, 0x40, 0x01, 0x2b, 0xf3, 0x4a, 0x75,
	0xe8, 0x1f, 0xc3, 0xbb, 0xa0, 0x32, 0xb9, 0x0b,
	0x00, 0xe8, 0xaf, 0x85, 0xe8, 0x91, 0x00, 0xe8,
	0x20, 0x02, 0xe8, 0x18, 0xfd, 0x72, 0x5b, 0xe8,
	0x91, 0x83, 0x72, 0x35, 0xe8, 0x5d, 0x83, 0x73,
	0xeb, 0xe8, 0x4f, 0x00, 0x72, 0xe6, 0x83, 0x3e,
	0x1f, 0xc4, 0x00, 0x74, 0x14, 0xa1, 0x6f, 0xc4,
	0x3b, 0x06, 0x1f, 0xc4, 0x74, 0xd6, 0xa3, 0x21,
	0xc4, 0xe8, 0x80, 0x04, 0xe8, 0x45, 0x00, 0xeb,
	0xcb, 0xa1, 0x6f, 0xc4, 0xa3, 0x1f, 0xc4, 0xe8,
	0x20, 0x04, 0x72, 0x26, 0xe8, 0x27, 0x01, 0xeb,
	0xbb, 0xe8, 0x1f, 0x00, 0x72, 0xb6, 0x83, 0x3e,
	0x1f, 0xc4, 0x00, 0x75, 0xd0, 0xe8, 0x3f, 0x04,
	0x72, 0x10, 0xe8, 0xb9, 0x02, 0xb4, 0xea, 0xe8,
	0x9b, 0x00, 0xc7, 0x06, 0x6f, 0xc4, 0x00, 0x00,
	0xeb, 0x9a, 0xc3, 0x83, 0x3e, 0x6f, 0xc4, 0x00,
	0x74, 0x02, 0xf8, 0xc3, 0xe8, 0x05, 0x00, 0xe8,
	0xe9, 0x06, 0xf9, 0xc3, 0x33, 0xc0, 0xa3, 0x6f,
	0xc4, 0xa3, 0x1f, 0xc4, 0xa3, 0x21, 0xc4, 0xc3,
	0xbb, 0xe2, 0xc3, 0xe8, 0x01, 0x00, 0xc3, 0x53,
	0xe8, 0x7e, 0x07, 0x5b, 0xe8, 0x93, 0x02, 0xc3,
	0x33, 0xc9, 0x3b, 0x0e, 0x73, 0xc4, 0x73, 0x13,
	0x41, 0x51, 0xe8, 0x2c, 0xfe, 0xbb, 0x1a, 0x00,
	0xb9, 0x28, 0x00, 0xe8, 0x98, 0x00, 0x59, 0x72,
	0x2b, 0xeb, 0xe7, 0x8b, 0x0e, 0x6f, 0xc4, 0x0b,
	0xc9, 0x74, 0x20, 0xb4, 0xea, 0xe8, 0x3d, 0x00,
	0xc7, 0x06, 0x6f, 0xc4, 0x00, 0x00, 0xc7, 0x06,
	0x71, 0xc4, 0x00, 0x00, 0x83, 0x3e, 0x1f, 0xc4,
	0x00, 0x74, 0x05, 0xe8, 0x98, 0x00, 0xeb, 0x03,
	0xe8, 0x88, 0x06, 0xc3, 0x3b, 0x0e, 0x6f, 0xc4,
	0x75, 0x01, 0xc3, 0x51, 0x56, 0xb4, 0xea, 0xe8,
	0x13, 0x00, 0x5e, 0x59, 0x89, 0x0e, 0x6f, 0xc4,
	0x89, 0x36, 0x71, 0xc4, 0xb4, 0xe9, 0xe8, 0x04,
	0x00, 0xe8, 0x72, 0x00, 0xc3, 0x8b, 0x0e, 0xb1,
	0x32, 0x50, 0xe8, 0x0b, 0x00, 0x58, 0xb9, 0x00,
	0xa0, 0xe8, 0x04, 0x00, 0xe8, 0x98, 0x81, 0xc3,
	0x06, 0x8e, 0xc1, 0x8b, 0x36, 0x71, 0xc4, 0x0b,
	0xf6, 0x74, 0x29, 0xb9, 0x28, 0x00, 0x26, 0x88,
	0x24, 0x46, 0xe2, 0xfa, 0x81, 0xc6, 0x40, 0x01,
	0x83, 0xee, 0x28, 0xb9, 0x18, 0x00, 0x26, 0x88,
	0x24, 0x26, 0x88, 0x64, 0x27, 0x81, 0xc6, 0x40,
	0x01, 0xe2, 0xf3, 0xb9, 0x28, 0x00, 0x26, 0x88,
	0x24, 0x46, 0xe2, 0xfa, 0x07, 0xc3, 0x8b, 0xc6,
	0x33, 0xd2, 0xf7, 0x36, 0xb6, 0x00, 0x3b, 0x06,
	0xc2, 0x00, 0x77, 0x18, 0x3b, 0x16, 0xc0, 0x00,
	0x77, 0x12, 0x03, 0xc3, 0x3b, 0x06, 0xc2, 0x00,
	0x76, 0x0a, 0x03, 0xd1, 0x3b, 0x16, 0xc0, 0x00,
	0x76, 0x02, 0xf9, 0xc3, 0xf8, 0xc3, 0xe8, 0xf2,
	0x05, 0xe8, 0x47, 0x05, 0xe8, 0x48, 0x00, 0xbb,
	0x28, 0xc4, 0xbe, 0xe8, 0x1c, 0x81, 0xc6, 0x85,
	0x02, 0x56, 0xc6, 0x06, 0xe6, 0x1c, 0xd1, 0xe8,
	0x9b, 0x7f, 0x8b, 0xc6, 0x5e, 0x2b, 0xc6, 0xbe,
	0x05, 0x00, 0x03, 0xc6, 0x03, 0xc6, 0x40, 0x0c,
	0x01, 0x3d, 0x40, 0x01, 0x76, 0x03, 0xb8, 0x40,
	0x01, 0xa3, 0xe0, 0x1c, 0xb9, 0x40, 0x01, 0x2b,
	0xc8, 0xd1, 0xe9, 0xb8, 0xb4, 0x00, 0xbb, 0x40,
	0x01, 0xf7, 0xe3, 0x03, 0xc1, 0xa3, 0xde, 0x1c,
	0xb8, 0x00, 0xa0, 0xe8, 0x3f, 0x05, 0xc3, 0xbf,
	0x28, 0xc4, 0xb9, 0x46, 0x00, 0x32, 0xc0, 0xfc,
	0xf3, 0xaa, 0x8b, 0x0e, 0x6f, 0xc4, 0x0b, 0xc9,
	0x74, 0x06, 0xe8, 0x44, 0x00, 0x83, 0xc3, 0x02,
	0xbe, 0x28, 0xc4, 0x8b, 0x0e, 0x1f, 0xc4, 0x0b,
	0xc9, 0x74, 0x2b, 0x53, 0xe8, 0x32, 0x00, 0x83,
	0xc3, 0x02, 0xe8, 0x21, 0x00, 0x4e, 0xb0, 0x20,
	0xb4, 0x26, 0x88, 0x04, 0x88, 0x64, 0x01, 0x88,
	0x44, 0x02, 0x83, 0xc6, 0x03, 0x5b, 0xa1, 0x1f,
	0xc4, 0x8b, 0x0e, 0x6f, 0xc4, 0x0b, 0xc9, 0x74,
	0x04, 0x3b, 0xc1, 0x75, 0x01, 0xc3, 0x8a, 0x07,
	0x88, 0x04, 0x43, 0x46, 0x0a, 0xc0, 0x75, 0xf6,
	0xc3, 0xbb, 0x8c, 0xc4, 0x03, 0xd9, 0x8a, 0x0f,
	0xbb, 0xa4, 0xc4, 0xd1, 0xe1, 0x03, 0xd9, 0x8b,
	0x1f, 0xc3, 0xbb, 0xa0, 0x32, 0xe8, 0x96, 0x83,
	0x72, 0x01, 0xc3, 0xb9, 0x0b, 0x00, 0xe8, 0x7a,
	0x83, 0x06, 0xa1, 0xbf, 0x32, 0x8e, 0xc0, 0x33,
	0xc9, 0x3b, 0x0e, 0x73, 0xc4, 0x73, 0x6d, 0x41,
	0x51, 0xbb, 0x8c, 0xc4, 0x03, 0xd9, 0x8a, 0x07,
	0xbb, 0x74, 0xc4, 0x03, 0xd9, 0x33, 0xc9, 0x8a,
	0xc8, 0xbf, 0xfe, 0xff, 0xbe, 0xa4, 0xc4, 0xd1,
	0xe1, 0x03, 0xf9, 0x03, 0xf1, 0x8b, 0x34, 0x47,
	0x26, 0x8b, 0x3d, 0x80, 0x7c, 0x01, 0x00, 0x74,
	0x40, 0x33, 0xc9, 0x8a, 0x0f, 0xfe, 0xc1, 0x26,
	0x3a, 0x0d, 0x76, 0x02, 0xb1, 0x01, 0x88, 0x0f,
	0x49, 0xd1, 0xe1, 0x03, 0xf9, 0x26, 0x03, 0x7d,
	0x01, 0x2b, 0xf9, 0x59, 0x51, 0xe8, 0x41, 0xfc,
	0xe8, 0x23, 0x00, 0x56, 0x26, 0x8b, 0x0d, 0x26,
	0x8b, 0x55, 0x02, 0x26, 0x03, 0x75, 0x04, 0x83,
	0xc7, 0x06, 0xa1, 0xb1, 0x32, 0xe8, 0x34, 0xfd,
	0x5e, 0x56, 0xe8, 0x1e, 0x00, 0x5e, 0xe8, 0x44,
	0x00, 0x59, 0xeb, 0x8d, 0x07, 0xc3, 0x57, 0x56,
	0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0, 0xb9, 0x1a,
	0x00, 0xba, 0x28, 0x00, 0xe8, 0x49, 0xfc, 0x07,
	0x5e, 0x5f, 0xc3, 0x1e, 0x06, 0x81, 0xc6, 0x41,
	0x01, 0x8b, 0xfe, 0xb8, 0x00, 0xa0, 0x8e, 0xc0,
	0xa1, 0xb1, 0x32, 0x8e, 0xd8, 0xfc, 0xb9, 0x18,
	0x00, 0x51, 0xb9, 0x26, 0x00, 0xf3, 0xa4, 0x81,
	0xc6, 0x1a, 0x01, 0x81, 0xc7, 0x1a, 0x01, 0x59,
	0xe2, 0xef, 0x07, 0x1f, 0xc3, 0xbb, 0x1a, 0x00,
	0xb9, 0x28, 0x00, 0xb8, 0x0c, 0x00, 0x03, 0xd8,
	0xf7, 0x26, 0xb6, 0x00, 0x2b, 0xf0, 0xb8, 0x08,
	0x00, 0x2b, 0xf0, 0x03, 0xc8, 0xe8, 0x36, 0xfe,
	0x73, 0x03, 0xe8, 0x92, 0x7f, 0xc3, 0xe8, 0xf8,
	0x04, 0x8b, 0x0e, 0x6f, 0xc4, 0xe8, 0xf9, 0xfe,
	0x83, 0xc3, 0x02, 0x43, 0x80, 0x3f, 0x00, 0x75,
	0xfa, 0x43, 0x06, 0xb8, 0xd4, 0x19, 0x8e, 0xc0,
	0x33, 0xc0, 0x26, 0xa3, 0x0c, 0x00, 0x26, 0xa3,
	0x0a, 0x00, 0xbe, 0x04, 0x00, 0x53, 0xe8, 0x37,
	0x7e, 0x26, 0x01, 0x0e, 0x0c, 0x00, 0x26, 0x89,
	0x04, 0x26, 0xff, 0x06, 0x0a, 0x00, 0x83, 0xc6,
	0x02, 0x43, 0x8a, 0x07, 0x0a, 0xc0, 0x75, 0xe6,
	0x5b, 0x8b, 0xce, 0x33, 0xc0, 0x83, 0xee, 0x02,
	0x81, 0xfe, 0x04, 0x00, 0x72, 0x0b, 0x26, 0x8b,
	0x14, 0x3b, 0xc2, 0x73, 0xf0, 0x8b, 0xc2, 0xeb,
	0xec, 0x8b, 0xf1, 0xb9, 0x40, 0x01, 0x2b, 0xc8,
	0xd1, 0xe9, 0x81, 0xc1, 0xc0, 0xcb, 0x26, 0x89,
	0x0e, 0x00, 0x00, 0x83, 0xee, 0x02, 0x81, 0xfe,
	0x04, 0x00, 0x72, 0x0e, 0x26, 0x8b, 0x14, 0x8b,
	0xc8, 0x2b, 0xca, 0xd1, 0xe9, 0x26, 0x89, 0x0c,
	0xeb, 0xe9, 0xbf, 0x04, 0x00, 0xbe, 0x0e, 0x00,
	0x57, 0x56, 0x26, 0x03, 0x35, 0xc6, 0x06, 0xe6,
	0x1c, 0xd1, 0xe8, 0x78, 0x7d, 0x5e, 0x5f, 0x81,
	0xc6, 0xc0, 0x0d, 0x83, 0xc7, 0x02, 0x43, 0x8a,
	0x07, 0x0a, 0xc0, 0x75, 0xe3, 0xe8, 0xed, 0x7e,
	0xe8, 0x1d, 0x80, 0xe8, 0x9d, 0x03, 0xb8, 0x00,
	0xa0, 0xe8, 0xf2, 0x03, 0xbb, 0x92, 0x32, 0xa1,
	0x96, 0x32, 0x26, 0x8b, 0x0e, 0x0c, 0x00, 0xf7,
	0xe1, 0x8b, 0xc8, 0xc1, 0xe9, 0x03, 0x83, 0xc1,
	0x3c, 0xe8, 0xcf, 0x81, 0xe8, 0x43, 0xfe, 0x80,
	0x3e, 0x96, 0x32, 0x00, 0x74, 0x08, 0xbb, 0x92,
	0x32, 0xe8, 0xd2, 0x81, 0x72, 0x0a, 0xe8, 0xaa,
	0x7f, 0x72, 0x05, 0xe8, 0x76, 0x7f, 0x73, 0xe4,
	0xe8, 0x04, 0x04, 0xe8, 0xc9, 0x7e, 0x07, 0xc3,
	0xbb, 0x8d, 0xc4, 0x8b, 0x0e, 0x73, 0xc4, 0x03,
	0xd9, 0x88, 0x07, 0xff, 0x06, 0x73, 0xc4, 0xc3,
	0xbb, 0x8d, 0xc4, 0x8b, 0x0e, 0x73, 0xc4, 0x3a,
	0x07, 0x74, 0x08, 0x43, 0xe2, 0xf9, 0xb0, 0x3b,
	0xe9, 0x0d, 0x8c, 0x8a, 0x47, 0x01, 0x88, 0x07,
	0x43, 0xe2, 0xf8, 0xc6, 0x47, 0x01, 0x00, 0xff,
	0x0e, 0x73, 0xc4, 0xc3, 0xbb, 0x8d, 0xc4, 0x8b,
	0x0e, 0x73, 0xc4, 0x3a, 0x07, 0x74, 0x05, 0x43,
	0xe2, 0xf9, 0xf8, 0xc3, 0xf9, 0xc3, 0xbb, 0x8d,
	0xc4, 0x8b, 0x0e, 0x73, 0xc4, 0xc6, 0x07, 0x00,
	0x43, 0xe2, 0xfa, 0xc7, 0x06, 0x73, 0xc4, 0x00,
	0x00, 0xc3, 0xa1, 0x1f, 0xc4, 0xe8, 0xcc, 0x00,
	0x3c, 0x03, 0x74, 0x1e, 0x3c, 0x29, 0x74, 0x1a,
	0x3c, 0x25, 0x74, 0x16, 0x3c, 0x48, 0x74, 0x12,
	0xb0, 0xff, 0x83, 0x3e, 0xf3, 0xb4, 0x18, 0x75,
	0x07, 0x80, 0x3e, 0xa4, 0xdb, 0x00, 0x74, 0x02,
	0xf8, 0xc3, 0xa2, 0xe1, 0xc3, 0xe8, 0x8a, 0xf8,
	0xc6, 0x06, 0x6e, 0xc4, 0x00, 0xf9, 0xc3, 0xa1,
	0x6f, 0xc4, 0xe8, 0x97, 0x00, 0x3c, 0x04, 0x74,
	0x06, 0x3c, 0x33, 0x74, 0x02, 0xf8, 0xc3, 0xa2,
	0xe1, 0xc3, 0xe8, 0x6d, 0xf8, 0xc6, 0x06, 0x6e,
	0xc4, 0x00, 0xf9, 0xc3, 0xa1, 0x1f, 0xc4, 0xe8,
	0x7a, 0x00, 0x8a, 0xc8, 0xa1, 0x21, 0xc4, 0xe8,
	0x72, 0x00, 0x8a, 0xd0, 0xbb, 0x35, 0xc3, 0x8b,
	0x07, 0x3a, 0xc1, 0x75, 0x04, 0x3a, 0xe2, 0x74,
	0x08, 0x3a, 0xc2, 0x75, 0x53, 0x3a, 0xe1, 0x75,
	0x4f, 0x80, 0x7f, 0x02, 0x00, 0x74, 0x42, 0x60,
	0xb9, 0x45, 0x00, 0xb0, 0x01, 0xb4, 0x05, 0xff,
	0x1e, 0x4a, 0x32, 0xb8, 0x3b, 0x0b, 0x8e, 0xd8,
	0x8e, 0xc0, 0xa0, 0x49, 0x32, 0xb4, 0x04, 0xb5,
	0x07, 0xff, 0x1e, 0x4a, 0x32, 0xb8, 0x3b, 0x0b,
	0x8e, 0xd8, 0x8e, 0xc0, 0x61, 0x53, 0x8a, 0x07,
	0xe8, 0x0d, 0xff, 0x5b, 0x53, 0x8a, 0x47, 0x01,
	0xe8, 0x05, 0xff, 0x5b, 0x53, 0x8a, 0x47, 0x02,
	0xe8, 0xed, 0xfe, 0x5b, 0x53, 0xe8, 0x5d, 0xf9,
	0x5b, 0x8b, 0x5f, 0x03, 0xe8, 0x68, 0xfb, 0xc3,
	0x83, 0xc3, 0x05, 0x83, 0x3f, 0x00, 0x75, 0x97,
	0xe8, 0x55, 0xfb, 0xc3, 0x0b, 0xc0, 0x75, 0x01,
	0xc3, 0x53, 0x48, 0xbb, 0x8d, 0xc4, 0x03, 0xd8,
	0x8a, 0x07, 0x32, 0xe4, 0x5b, 0xc3, 0x60, 0xe8,
	0x52, 0x06, 0xe8, 0x2f, 0x03, 0xe8, 0x85, 0x01,
	0xe8, 0x43, 0x02, 0xe8, 0xf2, 0x06, 0xe8, 0x72,
	0x03, 0xe8, 0xdb, 0x04, 0xe8, 0x8e, 0x01, 0xe8,
	0x4c, 0x02, 0xe8, 0x7b, 0x7e, 0xe8, 0xc1, 0x0b,
	0xe8, 0x74, 0x05, 0xe8, 0xc2, 0x01, 0xe8, 0x89,
	0x02, 0xe8, 0x33, 0x7d, 0x61, 0xc3, 0xe8, 0x2a,
	0x00, 0x0b, 0xc0, 0x74, 0x17, 0x3d, 0x03, 0x00,
	0x74, 0x12, 0x3d, 0x01, 0x00, 0x74, 0x0e, 0xc6,
	0x06, 0xda, 0x1c, 0x02, 0xe8, 0xb7, 0xff, 0xc6,
	0x06, 0xda, 0x1c, 0x03, 0xc3, 0xc6, 0x06, 0xda,
	0x1c, 0x01, 0xe8, 0xa9, 0xff, 0xc6, 0x06, 0xda,
	0x1c, 0x00, 0xc3, 0xbb, 0x54, 0x72, 0xe8, 0x01,
	0x17, 0x8b, 0xf3, 0x8b, 0x1c, 0x0b, 0xdb, 0x74,
	0x0a, 0xe8, 0xd3, 0x00, 0x72, 0x20, 0x83, 0xc6,
	0x02, 0xeb, 0xf0, 0x83, 0x3e, 0x52, 0x72, 0x00,
	0x75, 0x03, 0x33, 0xc0, 0xc3, 0xc7, 0x06, 0x52,
	0x72, 0x00, 0x00, 0x83, 0x3e, 0x1f, 0xc4, 0x00,
	0x75, 0x11, 0xb8, 0x01, 0x00, 0xc3, 0x3b, 0x06,
	0x52, 0x72, 0x75, 0x04, 0xb8, 0x03, 0x00, 0xc3,
	0xa3, 0x52, 0x72, 0xa1, 0xde, 0x1c, 0xa3, 0xe2,
	0x1c, 0xa1, 0xe0, 0x1c, 0xa3, 0xe4, 0x1c, 0x53,
	0xc6, 0x06, 0xda, 0x1c, 0x01, 0xe8, 0xdd, 0x00,
	0xe8, 0xc0, 0x00, 0x5b, 0x83, 0xc3, 0x13, 0xe8,
	0x45, 0x00, 0xbb, 0x28, 0xc4, 0xbe, 0xe8, 0x1c,
	0x81, 0xc6, 0x85, 0x02, 0x56, 0xc6, 0x06, 0xe6,
	0x1c, 0xd1, 0xe8, 0x10, 0x7b, 0x8b, 0xc6, 0x5e,
	0x2b, 0xc6, 0xbe, 0x05, 0x00, 0x03, 0xc6, 0x03,
	0xc6, 0x40, 0x0c, 0x01, 0x3d, 0x40, 0x01, 0x76,
	0x03, 0xb8, 0x40, 0x01, 0xa3, 0xe0, 0x1c, 0xb9,
	0x40, 0x01, 0x2b, 0xc8, 0xd1, 0xe9, 0xb8, 0xb4,
	0x00, 0xbb, 0x40, 0x01, 0xf7, 0xe3, 0x03, 0xc1,
	0xa3, 0xde, 0x1c, 0xb8, 0x02, 0x00, 0xc3, 0xbf,
	0x28, 0xc4, 0xb9, 0x46, 0x00, 0x32, 0xc0, 0xfc,
	0xf3, 0xaa, 0xbe, 0x28, 0xc4, 0x8b, 0x0e, 0x1f,
	0xc4, 0x0b, 0xc9, 0x74, 0x26, 0x53, 0xe8, 0xb8,
	0xfb, 0x83, 0xc3, 0x02, 0xe8, 0xa7, 0xfb, 0x4e,
	0xb0, 0x20, 0xb4, 0x26, 0x88, 0x04, 0x88, 0x64,
	0x01, 0x88, 0x44, 0x02, 0x83, 0xc6, 0x03, 0x5b,
	0xa1, 0x1f, 0xc4, 0x8b, 0x0e, 0x52, 0x72, 0x0b,
	0xc9, 0x74, 0x03, 0xe8, 0x88, 0xfb, 0xc3, 0x8a,
	0x47, 0x12, 0x0a, 0xc0, 0x74, 0x29, 0xa1, 0xc0,
	0x00, 0x8b, 0x16, 0xc2, 0x00, 0x8b, 0x4f, 0x01,
	0x3b, 0xc1, 0x72, 0x1b, 0x8b, 0x4f, 0x03, 0x3b,
	0xd1, 0x72, 0x14, 0x8b, 0x4f, 0x05, 0x3b, 0xc1,
	0x77, 0x0d, 0x8b, 0x4f, 0x07, 0x3b, 0xd1, 0x77,
	0x06, 0x33, 0xc0, 0x8a, 0x07, 0xf9, 0xc3, 0x33,
	0xc0, 0xf8, 0xc3, 0xbe, 0xe8, 0x1c, 0xb9, 0x0f,
	0x00, 0xb0, 0xff, 0xb4, 0xe0, 0xba, 0x40, 0x01,
	0x88, 0x04, 0x86, 0xc4, 0x46, 0x4a, 0x75, 0xf8,
	0x86, 0xc4, 0xe2, 0xf1, 0xc3, 0xa0, 0xda, 0x1c,
	0x3c, 0x00, 0x75, 0x01, 0xc3, 0x3c, 0x03, 0x75,
	0x01, 0xc3, 0xa1, 0xb3, 0x32, 0x8b, 0x1e, 0xb1,
	0x32, 0xe8, 0x81, 0x00, 0xc3, 0xa0, 0xda, 0x1c,
	0x3c, 0x00, 0x75, 0x01, 0xc3, 0x3c, 0x01, 0x75,
	0x01, 0xc3, 0xa1, 0xb1, 0x32, 0x06, 0x8e, 0xc0,
	0x8b, 0x36, 0xde, 0x1c, 0x8b, 0x16, 0xe0, 0x1c,
	0xbf, 0xe8, 0x1c, 0xb9, 0x0f, 0x00, 0x8b, 0xda,
	0x8a, 0x05, 0x3c, 0xff, 0x74, 0x03, 0x26, 0x88,
	0x04, 0x46, 0x47, 0x4a, 0x75, 0xf2, 0x8b, 0xd3,
	0x81, 0xc6, 0x40, 0x01, 0x2b, 0xf2, 0x81, 0xc7,
	0x40, 0x01, 0x2b, 0xfa, 0xe2, 0xe0, 0x07, 0xc3,
	0xa0, 0xda, 0x1c, 0x3c, 0x00, 0x75, 0x01, 0xc3,
	0x3c, 0x03, 0x75, 0x01, 0xc3, 0xa1, 0xe4, 0x1c,
	0x3b, 0x06, 0xe0, 0x1c, 0x72, 0x1d, 0xff, 0x36,
	0xe0, 0x1c, 0xff, 0x36, 0xde, 0x1c, 0xa3, 0xe0,
	0x1c, 0xa1, 0xe2, 0x1c, 0xa3, 0xde, 0x1c, 0xe8,
	0x09, 0x00, 0x8f, 0x06, 0xde, 0x1c, 0x8f, 0x06,
	0xe0, 0x1c, 0xc3, 0xa1, 0xb1, 0x32, 0xbb, 0x00,
	0xa0, 0xe8, 0x01, 0x00, 0xc3, 0x8b, 0x36, 0xde,
	0x1c, 0x8b, 0x16, 0xe0, 0x1c, 0xb9, 0x0f, 0x00,
	0x1e, 0x06, 0x8e, 0xdb, 0x8e, 0xc0, 0x8b, 0xda,
	0x26, 0x8a, 0x04, 0x88, 0x04, 0x46, 0x4a, 0x75,
	0xf7, 0x8b, 0xd3, 0x81, 0xc6, 0x40, 0x01, 0x2b,
	0xf2, 0xe2, 0xeb, 0x07, 0x1f, 0xc3, 0xa0, 0xdb,
	0x1c, 0x3c, 0x00, 0x75, 0x01, 0xc3, 0x3c, 0x03,
	0x75, 0x01, 0xc3, 0xa1, 0xb3, 0x32, 0x8b, 0x1e,
	0xb1, 0x32, 0xe8, 0x78, 0x00, 0xc3, 0xa0, 0xdb,
	0x1c, 0x3c, 0x00, 0x75, 0x01, 0xc3, 0x3c, 0x01,
	0x75, 0x01, 0xc3, 0xa1, 0xb1, 0x32, 0x1e, 0x06,
	0xba, 0xd4, 0x19, 0x8e, 0xc2, 0x26, 0x8b, 0x36,
	0x00, 0x00, 0x26, 0x8b, 0x16, 0x02, 0x00, 0xbf,
	0x0e, 0x00, 0xb9, 0x21, 0x00, 0x8e, 0xd8, 0x8b,
	0xda, 0x26, 0x8a, 0x05, 0x3c, 0xff, 0x74, 0x02,
	0x88, 0x04, 0x46, 0x47, 0x4a, 0x75, 0xf2, 0x8b,
	0xd3, 0x81, 0xc6, 0x40, 0x01, 0x2b, 0xf2, 0x81,
	0xc7, 0x40, 0x01, 0x2b, 0xfa, 0xe2, 0xe0, 0x07,
	0x1f, 0xc3, 0xa0, 0xdb, 0x1c, 0x3c, 0x00, 0x75,
	0x01, 0xc3, 0x3c, 0x03, 0x75, 0x01, 0xc3, 0xa1,
	0xb1, 0x32, 0xbb, 0x00, 0xa0, 0xe8, 0x15, 0x00,
	0xc3, 0x1e, 0xb9, 0xd4, 0x19, 0x8e, 0xd9, 0xbb,
	0x0e, 0x00, 0xb9, 0x40, 0x29, 0xc6, 0x07, 0xff,
	0x43, 0xe2, 0xfa, 0x1f, 0xc3, 0x1e, 0xb9, 0xd4,
	0x19, 0x8e, 0xd9, 0x8b, 0x36, 0x00, 0x00, 0x8b,
	0x16, 0x02, 0x00, 0xb9, 0x21, 0x00, 0x1f, 0x1e,
	0x06, 0x8e, 0xdb, 0x8e, 0xc0, 0x8b, 0xda, 0x26,
	0x8a, 0x04, 0x88, 0x04, 0x46, 0x4a, 0x75, 0xf7,
	0x8b, 0xd3, 0x81, 0xc6, 0x40, 0x01, 0x2b, 0xf2,
	0xe2, 0xeb, 0x07, 0x1f, 0xc3, 0xbb, 0xa4, 0x32,
	0xe8, 0x6b, 0x7d, 0x73, 0x1e, 0x8b, 0x0e, 0x90,
	0x32, 0xe8, 0x4f, 0x7d, 0xc6, 0x06, 0x33, 0x33,
	0x01, 0xc6, 0x06, 0xdd, 0x1c, 0x02, 0xe8, 0xd5,
	0xfc, 0xc6, 0x06, 0x33, 0x33, 0x00, 0xc6, 0x06,
	0xdd, 0x1c, 0x03, 0xc3, 0xb9, 0x01, 0x00, 0xbb,
	0xc7, 0x32, 0x53, 0x51, 0x49, 0xb0, 0x1b, 0xf6,
	0xe1, 0x03, 0xd8, 0x8b, 0x07, 0x0b, 0xc0, 0x74,
	0x0c, 0x8b, 0x7f, 0x12, 0x8b, 0x4f, 0x14, 0x8b,
	0x5f, 0x10, 0xe8, 0x09, 0x00, 0x59, 0x5b, 0x41,
	0x80, 0xf9, 0x04, 0x76, 0xdd, 0xc3, 0x1e, 0x06,
	0xa1, 0xb3, 0x32, 0x8e, 0xc0, 0xa1, 0xb1, 0x32,
	0x8e, 0xd8, 0x8b, 0xd1, 0x8b, 0xcf, 0x26, 0x8a,
	0x07, 0x88, 0x07, 0x43, 0xe2, 0xf8, 0x8b, 0xca,
	0x81, 0xc3, 0x40, 0x01, 0x2b, 0xdf, 0xe2, 0xea,
	0x07, 0x1f, 0xc3, 0x80, 0x3e, 0x33, 0x33, 0x01,
	0x74, 0x01, 0xc3, 0xb9, 0x01, 0x00, 0xbf, 0xc7,
	0x32, 0x57, 0x51, 0x49, 0xb0, 0x1b, 0xf6, 0xe1,
	0x03, 0xf8, 0x8b, 0x05, 0x0b, 0xc0, 0x74, 0x06,
	0x8b, 0x45, 0x16, 0xe8, 0x09, 0x00, 0x59, 0x5f,
	0x41, 0x80, 0xf9, 0x04, 0x76, 0xe3, 0xc3, 0x06,
	0x8e, 0xc0, 0x51, 0xbb, 0xff, 0xff, 0x8b, 0x05,
	0xb9, 0x03, 0x00, 0xf7, 0xe1, 0x03, 0xd8, 0xbe,
	0x00, 0x00, 0x26, 0x8b, 0x34, 0x8b, 0xd6, 0x3b,
	0xde, 0x72, 0x06, 0xc7, 0x05, 0x01, 0x00, 0xeb,
	0xe2, 0xff, 0x05, 0x33, 0xc9, 0x26, 0x8a, 0x0f,
	0x88, 0x4d, 0x1a, 0x26, 0x8b, 0x77, 0x01, 0x89,
	0x75, 0x0a, 0x8b, 0xda, 0x43, 0x83, 0xeb, 0x02,
	0xd1, 0xe1, 0x03, 0xd9, 0x26, 0x8b, 0x1f, 0x03,
	0xda, 0x26, 0x8b, 0x07, 0x89, 0x45, 0x0c, 0x26,
	0x8b, 0x47, 0x02, 0x89, 0x45, 0x0e, 0x83, 0xc3,
	0x04, 0x89, 0x5d, 0x18, 0x33, 0xd2, 0x8b, 0xc6,
	0xf7, 0x36, 0xb6, 0x00, 0x89, 0x16, 0x4f, 0x33,
	0xa3, 0x57, 0x33, 0x03, 0x55, 0x0c, 0x03, 0x45,
	0x0e, 0x89, 0x16, 0x51, 0x33, 0xa3, 0x59, 0x33,
	0x59, 0xe8, 0x85, 0x00, 0x33, 0xd2, 0x8b, 0x45,
	0x10, 0xf7, 0x36, 0xb6, 0x00, 0x89, 0x16, 0x53,
	0x33, 0xa3, 0x5b, 0x33, 0x03, 0x55, 0x12, 0x03,
	0x45, 0x14, 0x89, 0x16, 0x55, 0x33, 0xa3, 0x5d,
	0x33, 0xa1, 0x4f, 0x33, 0x8b, 0x1e, 0x53, 0x33,
	0x3b, 0xc3, 0x76, 0x04, 0x89, 0x1e, 0x4f, 0x33,
	0xa1, 0x51, 0x33, 0x8b, 0x1e, 0x55, 0x33, 0x3b,
	0xc3, 0x77, 0x04, 0x89, 0x1e, 0x51, 0x33, 0xa1,
	0x57, 0x33, 0x8b, 0x1e, 0x5b, 0x33, 0x3b, 0xc3,
	0x76, 0x04, 0x89, 0x1e, 0x57, 0x33, 0xa1, 0x59,
	0x33, 0x8b, 0x1e, 0x5d, 0x33, 0x3b, 0xc3, 0x77,
	0x04, 0x89, 0x1e, 0x59, 0x33, 0x07, 0xa1, 0x4f,
	0x33, 0x89, 0x45, 0x02, 0xa1, 0x57, 0x33, 0x89,
	0x45, 0x04, 0xa1, 0x51, 0x33, 0x89, 0x45, 0x06,
	0xa1, 0x59, 0x33, 0x89, 0x45, 0x08, 0x8b, 0x45,
	0x0c, 0x89, 0x45, 0x12, 0x8b, 0x45, 0x0e, 0x89,
	0x45, 0x14, 0x8b, 0x45, 0x0a, 0x89, 0x45, 0x10,
	0xc3, 0x80, 0x3e, 0x34, 0x33, 0x01, 0x74, 0x01,
	0xc3, 0xbb, 0x9e, 0xd8, 0x8b, 0x16, 0xf3, 0xb4,
	0x4a, 0xc1, 0xe2, 0x02, 0x03, 0xda, 0x03, 0xd9,
	0x33, 0xc9, 0x8a, 0x0f, 0x80, 0xf9, 0xff, 0x74,
	0x25, 0x49, 0xbb, 0x54, 0x72, 0xe8, 0x92, 0x12,
	0xd1, 0xe1, 0x03, 0xd9, 0x8b, 0x1f, 0x43, 0xa1,
	0x4f, 0x33, 0x89, 0x07, 0xa1, 0x57, 0x33, 0x89,
	0x47, 0x02, 0xa1, 0x51, 0x33, 0x89, 0x47, 0x04,
	0xa1, 0x59, 0x33, 0x89, 0x47, 0x06, 0xc3, 0xb9,
	0x01, 0x00, 0xbf, 0xc7, 0x32, 0x57, 0x51, 0x49,
	0xb0, 0x1b, 0xf6, 0xe1, 0x03, 0xf8, 0x8b, 0x05,
	0x0b, 0xc0, 0x74, 0x15, 0x8b, 0x45, 0x0a, 0x33,
	0xd2, 0xf7, 0x36, 0xb6, 0x00, 0x03, 0x45, 0x0e,
	0x3b, 0x06, 0xb1, 0x64, 0x73, 0x03, 0xe8, 0x48,
	0x00, 0x59, 0x5f, 0x41, 0x80, 0xf9, 0x04, 0x76,
	0xd4, 0x80, 0x3e, 0xdc, 0x1c, 0x01, 0x74, 0x03,
	0xe8, 0x6c, 0x03, 0xe8, 0x9f, 0x05, 0xb9, 0x01,
	0x00, 0xbf, 0xc7, 0x32, 0x57, 0x51, 0x49, 0xb0,
	0x1b, 0xf6, 0xe1, 0x03, 0xf8, 0x8b, 0x05, 0x0b,
	0xc0, 0x74, 0x15, 0x8b, 0x45, 0x0a, 0x33, 0xd2,
	0xf7, 0x36, 0xb6, 0x00, 0x03, 0x45, 0x0e, 0x3b,
	0x06, 0xb1, 0x64, 0x72, 0x03, 0xe8, 0x09, 0x00,
	0x59, 0x5f, 0x41, 0x80, 0xf9, 0x04, 0x76, 0xd4,
	0xc3, 0x8b, 0x45, 0x16, 0x8b, 0x5d, 0x0a, 0x8b,
	0x55, 0x0c, 0x8b, 0x4d, 0x0e, 0x8b, 0x75, 0x18,
	0x1e, 0x06, 0x8e, 0xc0, 0xa1, 0xb1, 0x32, 0x8e,
	0xd8, 0x8b, 0xf9, 0x8b, 0xca, 0x26, 0x8a, 0x04,
	0x3c, 0xff, 0x74, 0x02, 0x88, 0x07, 0x46, 0x43,
	0xe2, 0xf3, 0x8b, 0xcf, 0x81, 0xc3, 0x40, 0x01,
	0x2b, 0xda, 0xe2, 0xe5, 0x07, 0x1f, 0xc3, 0x80,
	0x3e, 0xdd, 0x1c, 0x02, 0x74, 0x01, 0xc3, 0xb9,
	0x01, 0x00, 0xbf, 0xc7, 0x32, 0x57, 0x51, 0x49,
	0xb0, 0x1b, 0xf6, 0xe1, 0x03, 0xf8, 0x8b, 0x05,
	0x0b, 0xc0, 0x74, 0x0f, 0x8b, 0x45, 0x04, 0x8b,
	0x5d, 0x02, 0x8b, 0x4d, 0x08, 0x8b, 0x7d, 0x06,
	0xe8, 0x09, 0x00, 0x59, 0x5f, 0x41, 0x80, 0xf9,
	0x04, 0x76, 0xda, 0xc3, 0x1e, 0x06, 0x8b, 0x16,
	0xb1, 0x32, 0x8e, 0xc2, 0x50, 0xba, 0x40, 0x01,
	0xf7, 0xe2, 0x03, 0xc3, 0x2b, 0xfb, 0x5a, 0x2b,
	0xca, 0x8b, 0xd8, 0xb8, 0x00, 0xa0, 0x8e, 0xd8,
	0x8b, 0xd1, 0x8b, 0xcf, 0x26, 0x8a, 0x07, 0x88,
	0x07, 0x43, 0xe2, 0xf8, 0x8b, 0xca, 0x81, 0xc3,
	0x40, 0x01, 0x2b, 0xdf, 0xe2, 0xea, 0x07, 0x1f,
	0xc3, 0x50, 0x32, 0xe4, 0x48, 0xbb, 0x9e, 0xd8,
	0x8b, 0x16, 0xf3, 0xb4, 0x4a, 0xc1, 0xe2, 0x02,
	0x03, 0xda, 0x03, 0xd8, 0x58, 0x88, 0x27, 0xc3,
	0x50, 0xe8, 0x18, 0xfd, 0xe8, 0x35, 0x00, 0x58,
	0x32, 0xe4, 0xbb, 0xc7, 0x32, 0xb1, 0x1b, 0x48,
	0xf6, 0xe1, 0x03, 0xd8, 0xc7, 0x07, 0x00, 0x00,
	0x53, 0xe8, 0xcc, 0x00, 0xe8, 0xb8, 0xfe, 0xe8,
	0x5e, 0x78, 0x5b, 0x53, 0xff, 0x07, 0xff, 0x36,
	0xdd, 0x1c, 0xc6, 0x06, 0xdd, 0x1c, 0x02, 0xe8,
	0x4d, 0xff, 0x8f, 0x06, 0xdd, 0x1c, 0x5b, 0xc7,
	0x07, 0x00, 0x00, 0xc3, 0x8b, 0x1e, 0x30, 0x32,
	0x8b, 0x3e, 0x2e, 0x32, 0x8b, 0x0e, 0x2c, 0x32,
	0x1e, 0x06, 0xa1, 0xb3, 0x32, 0x8e, 0xc0, 0xa1,
	0xb1, 0x32, 0x8e, 0xd8, 0x8b, 0xd1, 0x8b, 0xcf,
	0x81, 0xfb, 0xff, 0xf9, 0x77, 0x05, 0x26, 0x8a,
	0x07, 0x88, 0x07, 0x43, 0xe2, 0xf2, 0x8b, 0xca,
	0x81, 0xc3, 0x40, 0x01, 0x2b, 0xdf, 0xe2, 0xe4,
	0x07, 0x1f, 0xc3, 0x06, 0xa1, 0xbf, 0x32, 0x8e,
	0xc0, 0x33, 0xc0, 0xa3, 0x28, 0x32, 0xa3, 0x2a,
	0x32, 0xbb, 0xff, 0xff, 0x8a, 0x0e, 0x07, 0x66,
	0xb8, 0x03, 0x00, 0xf6, 0xe1, 0x03, 0xd8, 0xbe,
	0x00, 0x00, 0x26, 0x8b, 0x34, 0x8b, 0xd6, 0x3b,
	0xde, 0x72, 0x03, 0x07, 0xf9, 0xc3, 0xfe, 0x06,
	0x07, 0x66, 0x33, 0xc9, 0x26, 0x8a, 0x0f, 0x26,
	0x8b, 0x77, 0x01, 0x8b, 0xda, 0x43, 0x83, 0xeb,
	0x02, 0xd1, 0xe1, 0x03, 0xd9, 0x26, 0x8b, 0x1f,
	0x03, 0xda, 0x26, 0x8b, 0x3f, 0x26, 0x8b, 0x4f,
	0x02, 0x83, 0xc3, 0x04, 0x89, 0x1e, 0xde, 0x64,
	0x89, 0x0e, 0xe2, 0x64, 0x89, 0x3e, 0xe0, 0x64,
	0x89, 0x36, 0xe4, 0x64, 0x51, 0xe8, 0x31, 0x01,
	0x59, 0x89, 0x0e, 0x2c, 0x32, 0x89, 0x3e, 0x2e,
	0x32, 0x89, 0x36, 0x30, 0x32, 0x07, 0xf8, 0xc3,
	0x06, 0xa1, 0xbf, 0x32, 0x8e, 0xc0, 0x8b, 0x1e,
	0xe6, 0x64, 0x26, 0x8b, 0x3f, 0x43, 0x43, 0x26,
	0x8b, 0x0f, 0x43, 0x43, 0xa1, 0xb1, 0x64, 0x2d,
	0x3e, 0x00, 0xba, 0x40, 0x01, 0xf7, 0xe2, 0x03,
	0x06, 0xaf, 0x64, 0x8b, 0xd7, 0xd1, 0xea, 0x52,
	0x2b, 0xc2, 0x8b, 0xf0, 0x26, 0x8b, 0x07, 0x03,
	0xf0, 0x33, 0xd2, 0xf7, 0x36, 0xb6, 0x00, 0x89,
	0x16, 0x28, 0x32, 0xa3, 0x2a, 0x32, 0x5a, 0x43,
	0x43, 0x89, 0x1e, 0xde, 0x64, 0x89, 0x0e, 0xe2,
	0x64, 0x89, 0x3e, 0xe0, 0x64, 0x89, 0x36, 0xe4,
	0x64, 0x51, 0x57, 0x56, 0x51, 0x52, 0xe8, 0xc8,
	0x00, 0x5a, 0x59, 0xc6, 0x06, 0xae, 0x64, 0x00,
	0xc7, 0x06, 0xba, 0x00, 0x3f, 0x01, 0xc7, 0x06,
	0xb8, 0x00, 0x00, 0x00, 0xc7, 0x06, 0xbc, 0x00,
	0x00, 0x00, 0xc7, 0x06, 0xbe, 0x00, 0xc7, 0x00,
	0xa1, 0xaf, 0x64, 0x2b, 0xc2, 0x72, 0x09, 0x03,
	0x06, 0x28, 0x32, 0x3d, 0x00, 0x00, 0x73, 0x1b,
	0xc6, 0x06, 0xae, 0x64, 0x01, 0xa1, 0xaf, 0x64,
	0x03, 0xc2, 0x03, 0x06, 0x28, 0x32, 0x8b, 0x1e,
	0x34, 0x32, 0x3b, 0xc3, 0x76, 0x02, 0x8b, 0xc3,
	0xa3, 0xba, 0x00, 0xa1, 0xaf, 0x64, 0x03, 0xc2,
	0x03, 0x06, 0x28, 0x32, 0x3d, 0x3f, 0x01, 0x76,
	0x16, 0xc6, 0x06, 0xae, 0x64, 0x01, 0x2b, 0xc2,
	0x2b, 0xc2, 0x8b, 0x1e, 0x32, 0x32, 0x3b, 0xc3,
	0x76, 0x02, 0x8b, 0xc3, 0xa3, 0xb8, 0x00, 0xa1,
	0xb1, 0x64, 0x2b, 0xc1, 0x72, 0x09, 0x03, 0x06,
	0x2a, 0x32, 0x3d, 0x00, 0x00, 0x73, 0x19, 0xc6,
	0x06, 0xae, 0x64, 0x01, 0xa1, 0xb1, 0x64, 0x03,
	0x06, 0x2a, 0x32, 0x8b, 0x1e, 0x3c, 0x32, 0x3b,
	0xc3, 0x76, 0x02, 0x8b, 0xc3, 0xa3, 0xbe, 0x00,
	0xa1, 0xb1, 0x64, 0x03, 0x06, 0x2a, 0x32, 0x3d,
	0xc7, 0x00, 0x76, 0x14, 0xc6, 0x06, 0xae, 0x64,
	0x01, 0x2b, 0xc1, 0x8b, 0x1e, 0x3a, 0x32, 0x3b,
	0xc3, 0x73, 0x02, 0x8b, 0xc3, 0xa3, 0xbc, 0x00,
	0x5e, 0x5f, 0x59, 0x89, 0x0e, 0x2c, 0x32, 0x89,
	0x3e, 0x2e, 0x32, 0x89, 0x36, 0x30, 0x32, 0x07,
	0xc3, 0x33, 0xd2, 0x8b, 0xc6, 0xf7, 0x36, 0xb6,
	0x00, 0x89, 0x16, 0x32, 0x32, 0xa3, 0x3a, 0x32,
	0x03, 0xd7, 0x03, 0xc1, 0x89, 0x16, 0x34, 0x32,
	0xa3, 0x3c, 0x32, 0x33, 0xd2, 0xa1, 0x30, 0x32,
	0xf7, 0x36, 0xb6, 0x00, 0x89, 0x16, 0x36, 0x32,
	0xa3, 0x3e, 0x32, 0x03, 0x16, 0x2e, 0x32, 0x03,
	0x06, 0x2c, 0x32, 0x89, 0x16, 0x38, 0x32, 0xa3,
	0x40, 0x32, 0xa1, 0x32, 0x32, 0x8b, 0x1e, 0x36,
	0x32, 0x3b, 0xc3, 0x76, 0x04, 0x89, 0x1e, 0x32,
	0x32, 0xa1, 0x34, 0x32, 0x8b, 0x1e, 0x38, 0x32,
	0x3b, 0xc3, 0x77, 0x04, 0x89, 0x1e, 0x34, 0x32,
	0xa1, 0x3a, 0x32, 0x8b, 0x1e, 0x3e, 0x32, 0x3b,
	0xc3, 0x76, 0x04, 0x89, 0x1e, 0x3a, 0x32, 0xa1,
	0x3c, 0x32, 0x8b, 0x1e, 0x40, 0x32, 0x3b, 0xc3,
	0x77, 0x04, 0x89, 0x1e, 0x3c, 0x32, 0xc3, 0x55,
	0x1e, 0x06, 0xe8, 0x04, 0x00, 0x07, 0x1f, 0x5d,
	0xc3, 0x8b, 0x1e, 0xde, 0x64, 0x8b, 0x0e, 0xe2,
	0x64, 0x8b, 0x3e, 0xe0, 0x64, 0x8b, 0x36, 0xe4,
	0x64, 0xa1, 0xbf, 0x32, 0x8e, 0xc0, 0x8b, 0xc1,
	0x03, 0xdf, 0x81, 0xc6, 0x40, 0x01, 0xe2, 0xf8,
	0x8b, 0xc8, 0x81, 0xee, 0x40, 0x01, 0x03, 0xf7,
	0x4e, 0x4b, 0x8b, 0xc7, 0xf7, 0x26, 0xd8, 0x64,
	0x33, 0xd2, 0xf7, 0x36, 0xda, 0x64, 0xd1, 0xe8,
	0x2b, 0xf0, 0xa0, 0xae, 0x64, 0x8a, 0x26, 0xdc,
	0x64, 0x8a, 0x16, 0xcb, 0x64, 0x8b, 0x2e, 0xb1,
	0x32, 0x8e, 0xdd, 0xbd, 0x00, 0xfa, 0x0a, 0xc0,
	0x74, 0x03, 0xe9, 0xa8, 0x00, 0x0a, 0xe4, 0x74,
	0x56, 0x80, 0xfa, 0x01, 0x74, 0x51, 0x3e, 0x8b,
	0x56, 0x00, 0x3e, 0x03, 0x56, 0x02, 0x43, 0x2b,
	0xdf, 0x51, 0x56, 0x8b, 0xcf, 0x83, 0xea, 0x64,
	0x77, 0x0c, 0x3e, 0x03, 0x56, 0x00, 0x3e, 0x03,
	0x56, 0x02, 0x5e, 0x59, 0xeb, 0x2e, 0x52, 0x3e,
	0x8b, 0x56, 0x00, 0x3e, 0x03, 0x56, 0x02, 0x83,
	0xea, 0x64, 0x77, 0x0a, 0x3e, 0x03, 0x56, 0x00,
	0x3e, 0x03, 0x56, 0x02, 0xeb, 0x0a, 0x26, 0x8a,
	0x07, 0x3c, 0xff, 0x74, 0x02, 0x88, 0x04, 0x4e,
	0x43, 0xe2, 0xe4, 0x5a, 0x5e, 0x59, 0x81, 0xee,
	0x40, 0x01, 0x2b, 0xdf, 0xe2, 0xb9, 0xc3, 0x3e,
	0x8b, 0x56, 0x00, 0x3e, 0x03, 0x56, 0x02, 0x51,
	0x56, 0x8b, 0xcf, 0x83, 0xea, 0x64, 0x77, 0x0e,
	0x3e, 0x03, 0x56, 0x00, 0x3e, 0x03, 0x56, 0x02,
	0x2b, 0xd9, 0x5e, 0x59, 0xeb, 0x2c, 0x52, 0x3e,
	0x8b, 0x56, 0x00, 0x3e, 0x03, 0x56, 0x02, 0x83,
	0xea, 0x64, 0x77, 0x0a, 0x3e, 0x03, 0x56, 0x00,
	0x3e, 0x03, 0x56, 0x02, 0xeb, 0x0a, 0x26, 0x8a,
	0x07, 0x3c, 0xff, 0x74, 0x02, 0x88, 0x04, 0x4e,
	0x4b, 0xe2, 0xe4, 0x5a, 0x5e, 0x59, 0x81, 0xee,
	0x40, 0x01, 0xe2, 0xbb, 0xc3, 0x0a, 0xe4, 0x75,
	0x03, 0xe9, 0x8d, 0x00, 0x80, 0xfa, 0x01, 0x75,
	0x03, 0xe9, 0x85, 0x00, 0xe8, 0x04, 0x01, 0x43,
	0xba, 0x3b, 0x0b, 0x8e, 0xda, 0x8b, 0x16, 0xb1,
	0x32, 0x8e, 0xda, 0x2b, 0xdf, 0x51, 0x56, 0x8b,
	0xcf, 0x3e, 0x83, 0x6e, 0x04, 0x64, 0x77, 0x07,
	0xe8, 0xf5, 0x00, 0x5e, 0x59, 0xeb, 0x5f, 0x3e,
	0xff, 0x76, 0x04, 0xe8, 0xdd, 0x00, 0x1e, 0x3e,
	0x83, 0x6e, 0x04, 0x64, 0x77, 0x05, 0xe8, 0xdf,
	0x00, 0xeb, 0x3b, 0x26, 0x8a, 0x07, 0x3c, 0xff,
	0x74, 0x33, 0xba, 0x3b, 0x0b, 0x8e, 0xda, 0xa2,
	0x27, 0x32, 0x8b, 0xc6, 0x33, 0xd2, 0xf7, 0x36,
	0xb6, 0x00, 0x3b, 0x16, 0xba, 0x00, 0x77, 0x1d,
	0x3b, 0x16, 0xb8, 0x00, 0x72, 0x17, 0x3b, 0x06,
	0xbe, 0x00, 0x77, 0x11, 0x3b, 0x06, 0xbc, 0x00,
	0x72, 0x0b, 0xa0, 0x27, 0x32, 0x8b, 0x16, 0xb1,
	0x32, 0x8e, 0xda, 0x88, 0x04, 0x4e, 0x43, 0x1f,
	0xe2, 0xb4, 0x3e, 0x8f, 0x46, 0x04, 0x5e, 0x59,
	0x81, 0xee, 0x40, 0x01, 0x2b, 0xdf, 0xe2, 0x80,
	0xc3, 0xe8, 0x7f, 0x00, 0xba, 0x3b, 0x0b, 0x8e,
	0xda, 0x8b, 0x16, 0xb1, 0x32, 0x8e, 0xda, 0x51,
	0x56, 0x8b, 0xcf, 0x3e, 0x83, 0x6e, 0x04, 0x64,
	0x77, 0x09, 0xe8, 0x73, 0x00, 0x2b, 0xd9, 0x5e,
	0x59, 0xeb, 0x5d, 0x3e, 0xff, 0x76, 0x04, 0xe8,
	0x59, 0x00, 0x1e, 0x3e, 0x83, 0x6e, 0x04, 0x64,
	0x77, 0x05, 0xe8, 0x5b, 0x00, 0xeb, 0x3b, 0x26,
	0x8a, 0x07, 0x3c, 0xff, 0x74, 0x33, 0xba, 0x3b,
	0x0b, 0x8e, 0xda, 0xa2, 0x27, 0x32, 0x8b, 0xc6,
	0x33, 0xd2, 0xf7, 0x36, 0xb6, 0x00, 0x3b, 0x16,
	0xba, 0x00, 0x77, 0x1d, 0x3b, 0x16, 0xb8, 0x00,
	0x72, 0x17, 0x3b, 0x06, 0xbe, 0x00, 0x77, 0x11,
	0x3b, 0x06, 0xbc, 0x00, 0x72, 0x0b, 0xa0, 0x27,
	0x32, 0x8b, 0x16, 0xb1, 0x32, 0x8e, 0xda, 0x88,
	0x04, 0x4e, 0x4b, 0x1f, 0xe2, 0xb4, 0x3e, 0x8f,
	0x46, 0x04, 0x5e, 0x59, 0x81, 0xee, 0x40, 0x01,
	0xe2, 0x82, 0xc3, 0x3e, 0x8b, 0x56, 0x00, 0x3e,
	0x03, 0x56, 0x02, 0x3e, 0x89, 0x56, 0x04, 0xc3,
	0x3e, 0x8b, 0x56, 0x00, 0x3e, 0x03, 0x56, 0x02,
	0x3e, 0x01, 0x56, 0x04, 0xc3, 0x06, 0xa1, 0xb5,
	0x32, 0x8e, 0xc0, 0x33, 0xdb, 0x26, 0x8a, 0x0f,
	0xb5, 0x00, 0x43, 0x51, 0x0a, 0xc9, 0x75, 0x03,
	0xe9, 0xfb, 0x00, 0x53, 0x26, 0x8b, 0x1f, 0x26,
	0x8b, 0x47, 0x04, 0x33, 0xd2, 0xf7, 0x36, 0xb6,
	0x00, 0x26, 0x8b, 0x37, 0x03, 0xf2, 0x4e, 0x26,
	0x8b, 0x7f, 0x02, 0x03, 0xf8, 0x4f, 0xe8, 0x10,
	0x0c, 0x72, 0x03, 0xe9, 0xd0, 0x00, 0x53, 0x8a,
	0x1e, 0xae, 0x64, 0x89, 0x16, 0xb7, 0x32, 0x8b,
	0x0e, 0x32, 0x32, 0x0a, 0xdb, 0x74, 0x04, 0x8b,
	0x0e, 0xb8, 0x00, 0x3b, 0xca, 0x72, 0x04, 0x89,
	0x0e, 0xb7, 0x32, 0xa3, 0xb9, 0x32, 0x8b, 0x0e,
	0x3a, 0x32, 0x0a, 0xdb, 0x74, 0x04, 0x8b, 0x0e,
	0xbc, 0x00, 0x3b, 0xc8, 0x72, 0x04, 0x89, 0x0e,
	0xb9, 0x32, 0x89, 0x36, 0xbb, 0x32, 0x8b, 0x0e,
	0x34, 0x32, 0x0a, 0xdb, 0x74, 0x04, 0x8b, 0x0e,
	0xba, 0x00, 0x3b, 0xce, 0x77, 0x04, 0x89, 0x0e,
	0xbb, 0x32, 0x89, 0x3e, 0xbd, 0x32, 0x8b, 0x0e,
	0x3c, 0x32, 0x0a, 0xdb, 0x74, 0x04, 0x8b, 0x0e,
	0xbe, 0x00, 0x3b, 0xcf, 0x77, 0x04, 0x89, 0x0e,
	0xbd, 0x32, 0x5b, 0x26, 0x8b, 0x3f, 0x83, 0xc3,
	0x06, 0x8b, 0xc8, 0x3b, 0x0e, 0xb9, 0x32, 0x73,
	0x05, 0x03, 0xdf, 0x41, 0xeb, 0xf5, 0x8b, 0xca,
	0x3b, 0x0e, 0xb7, 0x32, 0x73, 0x04, 0x43, 0x41,
	0xeb, 0xf6, 0xa1, 0xb9, 0x32, 0xf7, 0x26, 0xb6,
	0x00, 0x03, 0x06, 0xb7, 0x32, 0x8b, 0xf0, 0x55,
	0xa1, 0xbd, 0x32, 0x8b, 0x0e, 0xb9, 0x32, 0x8b,
	0x16, 0xbb, 0x32, 0x8b, 0x2e, 0xb7, 0x32, 0x1e,
	0x50, 0xa1, 0xb1, 0x32, 0x8e, 0xd8, 0x58, 0x50,
	0x53, 0x51, 0x56, 0x8b, 0xcd, 0x26, 0x8a, 0x07,
	0x3c, 0xff, 0x74, 0x02, 0x88, 0x04, 0x46, 0x43,
	0x41, 0x3b, 0xca, 0x76, 0xf0, 0x5e, 0x59, 0x5b,
	0x58, 0x81, 0xc6, 0x40, 0x01, 0x03, 0xdf, 0x41,
	0x3b, 0xc8, 0x76, 0xdb, 0x1f, 0x5d, 0x5b, 0x43,
	0x43, 0x59, 0x49, 0xe9, 0xfd, 0xfe, 0x59, 0x07,
	0xc3, 0xe8, 0x7d, 0x73, 0xa0, 0xdc, 0x1c, 0x3c,
	0x02, 0x74, 0x01, 0xc3, 0x1e, 0x06, 0xa1, 0xb1,
	0x32, 0x8e, 0xc0, 0xa1, 0x3a, 0x32, 0x8b, 0x1e,
	0x32, 0x32, 0x8b, 0x0e, 0x3c, 0x32, 0x8b, 0x3e,
	0x34, 0x32, 0xba, 0x40, 0x01, 0xf7, 0xe2, 0x03,
	0xc3, 0x2b, 0xfb, 0x2b, 0x0e, 0x3a, 0x32, 0x8b,
	0xd8, 0xb8, 0x00, 0xa0, 0x8e, 0xd8, 0x8b, 0xd1,
	0x8b, 0xcf, 0x81, 0xfb, 0xff, 0xf9, 0x77, 0x05,
	0x26, 0x8a, 0x07, 0x88, 0x07, 0x43, 0xe2, 0xf2,
	0x8b, 0xca, 0x81, 0xc3, 0x40, 0x01, 0x2b, 0xdf,
	0xe2, 0xe4, 0x07, 0x1f, 0xc3, 0x80, 0x3e, 0x3d,
	0x66, 0x02, 0x74, 0x01, 0xc3, 0xbb, 0xce, 0xb5,
	0xe8, 0x1f, 0x0b, 0x8b, 0x0e, 0x50, 0x72, 0x49,
	0xd1, 0xe1, 0x03, 0xd9, 0x83, 0x3f, 0x00, 0x74,
	0x04, 0xff, 0x17, 0xeb, 0x03, 0xe8, 0x68, 0x6b,
	0xc6, 0x06, 0x3d, 0x66, 0x00, 0xc7, 0x06, 0x50,
	0x72, 0x00, 0x00, 0xc7, 0x06, 0x52, 0x72, 0x00,
	0x00, 0xe8, 0x6c, 0x00, 0xc3, 0x80, 0x3e, 0x3d,
	0x66, 0x04, 0x74, 0x01, 0xc3, 0xe8, 0xed, 0x70,
	0xbb, 0x9c, 0xb8, 0xe8, 0xe4, 0x0a, 0x8b, 0x0e,
	0x50, 0x72, 0x49, 0xd1, 0xe1, 0x03, 0xd9, 0xff,
	0x17, 0xe8, 0xfb, 0x70, 0xc6, 0x06, 0x3d, 0x66,
	0x00, 0xc7, 0x06, 0x50, 0x72, 0x00, 0x00, 0xc7,
	0x06, 0x52, 0x72, 0xff, 0x00, 0xe8, 0x38, 0x00,
	0xc3, 0xa1, 0xaf, 0x64, 0x3b, 0x06, 0xbb, 0x64,
	0x74, 0x04, 0xe8, 0x2b, 0x00, 0xc3, 0xa1, 0xb1,
	0x64, 0x3b, 0x06, 0xbd, 0x64, 0x74, 0x04, 0xe8,
	0x1e, 0x00, 0xc3, 0xbb, 0x9c, 0x32, 0x8b, 0x07,
	0x0b, 0x47, 0x02, 0x75, 0x06, 0xb9, 0xf4, 0x01,
	0xe8, 0xa0, 0x73, 0xe8, 0xb0, 0x73, 0x72, 0x01,
	0xc3, 0xe8, 0x0f, 0x00, 0xe8, 0x01, 0x00, 0xc3,
	0xbb, 0x9c, 0x32, 0x33, 0xc0, 0x89, 0x07, 0x89,
	0x47, 0x02, 0xc3, 0xa1, 0xbf, 0x32, 0xa3, 0xac,
	0x00, 0x33, 0xc0, 0xa3, 0xaa, 0x00, 0xb9, 0x02,
	0x00, 0xba, 0x54, 0x00, 0xe8, 0x01, 0x7a, 0xbb,
	0x8a, 0x32, 0x33, 0xc0, 0x89, 0x07, 0x89, 0x47,
	0x02, 0xc6, 0x06, 0xcd, 0x64, 0x01, 0xc6, 0x06,
	0xcb, 0x64, 0x01, 0xc6, 0x06, 0x3f, 0x65, 0x01,
	0xe8, 0x22, 0x08, 0x83, 0x3e, 0xc2, 0x00, 0x00,
	0x74, 0x05, 0xe8, 0xb5, 0xea, 0xeb, 0x15, 0xbb,
	0x98, 0x32, 0x8b, 0x07, 0x0b, 0x47, 0x02, 0x75,
	0x06, 0xb9, 0x32, 0x00, 0xe8, 0x3c, 0x73, 0xe8,
	0x4c, 0x73, 0x72, 0x21, 0xe8, 0x32, 0x00, 0xe8,
	0xd3, 0xf5, 0xe8, 0xf1, 0xf2, 0xe8, 0x04, 0xd3,
	0x80, 0x3e, 0x95, 0x60, 0x01, 0x74, 0x0e, 0x80,
	0x3e, 0xca, 0x00, 0x01, 0x74, 0x07, 0x80, 0x3e,
	0xcb, 0x00, 0x01, 0x75, 0xbe, 0xe8, 0xc3, 0x75,
	0xe8, 0xa6, 0x08, 0xc6, 0x06, 0xdc, 0x1c, 0x02,
	0xe8, 0x9b, 0xf2, 0xc6, 0x06, 0xdc, 0x1c, 0x03,
	0xc3, 0x06, 0xbb, 0x8a, 0x32, 0xe8, 0x0e, 0x73,
	0x73, 0x1a, 0x8b, 0x0e, 0x90, 0x32, 0xe8, 0xf2,
	0x72, 0xe8, 0x1a, 0x06, 0xe8, 0x8d, 0x07, 0xc6,
	0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x77, 0xf2, 0xc6,
	0x06, 0xdc, 0x1c, 0x03, 0x07, 0xc3, 0x06, 0xbb,
	0x8a, 0x32, 0xe8, 0xe9, 0x72, 0x73, 0x1a, 0x8b,
	0x0e, 0x90, 0x32, 0xe8, 0xcd, 0x72, 0xe8, 0xf5,
	0x05, 0xe8, 0xa4, 0x07, 0xc6, 0x06, 0xdc, 0x1c,
	0x02, 0xe8, 0x52, 0xf2, 0xc6, 0x06, 0xdc, 0x1c,
	0x03, 0x07, 0xc3, 0xe8, 0xcc, 0x6d, 0xe8, 0x54,
	0xf5, 0xe8, 0x1c, 0x00, 0x80, 0x3e, 0xc6, 0x64,
	0x00, 0x75, 0xf3, 0xc3, 0xe8, 0xbb, 0x6d, 0xe8,
	0x43, 0xf5, 0xe8, 0x0b, 0x00, 0xe8, 0x5e, 0xf2,
	0x80, 0x3e, 0xc6, 0x64, 0x00, 0x75, 0xf0, 0xc3,
	0x06, 0xa0, 0xc6, 0x64, 0x3c, 0x00, 0x75, 0x03,
	0xe9, 0xc3, 0x00, 0x3c, 0x03, 0x74, 0x39, 0xe8,
	0x0c, 0x02, 0x73, 0x0d, 0xe8, 0x84, 0x01, 0x72,
	0xf6, 0xc6, 0x06, 0xc6, 0x64, 0x00, 0xe9, 0xad,
	0x00, 0xc6, 0x06, 0xc4, 0x64, 0x00, 0xc6, 0x06,
	0xc6, 0x64, 0x03, 0xe8, 0x22, 0x08, 0x73, 0x0e,
	0xc6, 0x06, 0xc6, 0x64, 0x02, 0xc6, 0x06, 0xe2,
	0x65, 0x01, 0xff, 0x06, 0xce, 0x64, 0xbb, 0x8a,
	0x32, 0x33, 0xc0, 0x89, 0x07, 0x89, 0x47, 0x02,
	0xbb, 0x8a, 0x32, 0xe8, 0x58, 0x72, 0x72, 0x02,
	0xeb, 0x7c, 0x8b, 0x0e, 0x8e, 0x32, 0xe8, 0x3a,
	0x72, 0xe8, 0xbd, 0x05, 0xe8, 0x5f, 0x05, 0x72,
	0xae, 0xe8, 0xb0, 0x02, 0x72, 0xa9, 0xe8, 0x6f,
	0x06, 0xc6, 0x06, 0xc6, 0x64, 0x03, 0xff, 0x0e,
	0xce, 0x64, 0x7f, 0x4d, 0x80, 0x3e, 0xc5, 0x64,
	0x01, 0x75, 0x2e, 0x8b, 0x3e, 0xb7, 0x64, 0x8b,
	0x36, 0xb9, 0x64, 0x8b, 0x0e, 0xbb, 0x64, 0x8b,
	0x16, 0xbd, 0x64, 0x3b, 0xf9, 0x75, 0x04, 0x3b,
	0xf2, 0x74, 0x16, 0xe8, 0x3a, 0x00, 0x89, 0x3e,
	0xaf, 0x64, 0x89, 0x36, 0xb1, 0x64, 0x89, 0x0e,
	0xb7, 0x64, 0x89, 0x16, 0xb9, 0x64, 0xe9, 0x66,
	0xff, 0xe8, 0xc6, 0x08, 0xe8, 0x7c, 0x00, 0xe8,
	0x77, 0x07, 0xa1, 0xb7, 0x64, 0xa3, 0xaf, 0x64,
	0xa1, 0xb9, 0x64, 0xa3, 0xb1, 0x64, 0xe8, 0xb4,
	0x00, 0xc6, 0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x5d,
	0xf1, 0xc6, 0x06, 0xdc, 0x1c, 0x03, 0x07, 0xc3,
	0x8b, 0x1e, 0x44, 0x67, 0x43, 0x43, 0xa0, 0x40,
	0x67, 0x3c, 0x00, 0x75, 0x1b, 0x3b, 0xd6, 0x76,
	0x0e, 0x8b, 0xd6, 0x3b, 0x3f, 0x77, 0x09, 0x8b,
	0x4f, 0x04, 0xc6, 0x06, 0x40, 0x67, 0x01, 0xc3,
	0x8b, 0x0f, 0xc6, 0x06, 0x40, 0x67, 0x03, 0xc3,
	0x3c, 0x02, 0x75, 0x05, 0x3b, 0xd6, 0x72, 0xe1,
	0xc3, 0x3c, 0x01, 0x75, 0x1d, 0x3b, 0xcf, 0x73,
	0xe6, 0x8b, 0xcf, 0x3b, 0x77, 0x02, 0x77, 0x09,
	0x8b, 0x57, 0x06, 0xc6, 0x06, 0x40, 0x67, 0x02,
	0xc3, 0x8b, 0x57, 0x02, 0xc6, 0x06, 0x40, 0x67,
	0x00, 0xc3, 0x3c, 0x03, 0x75, 0xc9, 0x3b, 0xcf,
	0x77, 0xdf, 0xc3, 0xa0, 0xc3, 0x64, 0x0a, 0xc0,
	0x74, 0x42, 0x3c, 0x01, 0x75, 0x0a, 0xc6, 0x06,
	0xcb, 0x64, 0x01, 0xc6, 0x06, 0xcd, 0x64, 0x00,
	0x3c, 0x03, 0x75, 0x0a, 0xc6, 0x06, 0xcb, 0x64,
	0x01, 0xc6, 0x06, 0xcd, 0x64, 0x01, 0x3c, 0x02,
	0x75, 0x0f, 0xc6, 0x06, 0xcb, 0x64, 0x00, 0xc6,
	0x06, 0xcc, 0x64, 0x01, 0xc6, 0x06, 0xdc, 0x64,
	0x00, 0x3c, 0x04, 0x75, 0x0f, 0xc6, 0x06, 0xcb,
	0x64, 0x00, 0xc6, 0x06, 0xcc, 0x64, 0x00, 0xc6,
	0x06, 0xdc, 0x64, 0x01, 0xc3, 0xc6, 0x06, 0xc3,
	0x64, 0x00, 0xa0, 0x3d, 0x66, 0x3c, 0x01, 0x75,
	0x06, 0xc6, 0x06, 0x3d, 0x66, 0x02, 0xc3, 0x3c,
	0x03, 0x75, 0x06, 0xc6, 0x06, 0x3d, 0x66, 0x04,
	0xc3, 0x3c, 0x05, 0x75, 0x05, 0xc6, 0x06, 0x3d,
	0x66, 0x06, 0xc3, 0x8a, 0x0e, 0xc3, 0x64, 0x0a,
	0xc9, 0x74, 0x69, 0xa0, 0xcc, 0x64, 0x8a, 0x26,
	0xcd, 0x64, 0x8a, 0x2e, 0xcb, 0x64, 0x80, 0xf9,
	0x01, 0x75, 0x13, 0x80, 0xfc, 0x00, 0x75, 0x05,
	0x80, 0xfd, 0x01, 0x74, 0x4f, 0xe8, 0x51, 0x00,
	0xff, 0x06, 0xb1, 0x64, 0xf9, 0xc3, 0x80, 0xf9,
	0x03, 0x75, 0x13, 0x80, 0xfc, 0x01, 0x75, 0x05,
	0x80, 0xfd, 0x01, 0x74, 0x37, 0xe8, 0x39, 0x00,
	0xff, 0x0e, 0xb1, 0x64, 0xf9, 0xc3, 0x80, 0xf9,
	0x02, 0x75, 0x12, 0x3c, 0x01, 0x75, 0x05, 0x80,
	0xfd, 0x00, 0x74, 0x20, 0xe8, 0x22, 0x00, 0xff,
	0x0e, 0xaf, 0x64, 0xf9, 0xc3, 0x80, 0xf9, 0x04,
	0x75, 0x12, 0x3c, 0x00, 0x75, 0x05, 0x80, 0xfd,
	0x00, 0x74, 0x09, 0xe8, 0x0b, 0x00, 0xff, 0x06,
	0xaf, 0x64, 0xf9, 0xc3, 0xe8, 0x66, 0xff, 0xf8,
	0xc3, 0xa1, 0xaf, 0x64, 0xa3, 0xb7, 0x64, 0xa1,
	0xb1, 0x64, 0xa3, 0xb9, 0x64, 0xc3, 0x33, 0xc9,
	0xa1, 0xb7, 0x64, 0x8b, 0x1e, 0xaf, 0x64, 0x3b,
	0xc3, 0x77, 0x03, 0xfe, 0xc1, 0x93, 0x2b, 0xc3,
	0xa3, 0xc7, 0x64, 0xa1, 0xb9, 0x64, 0x8b, 0x1e,
	0xb1, 0x64, 0x3b, 0xc3, 0x77, 0x03, 0xfe, 0xc5,
	0x93, 0x2b, 0xc3, 0xa3, 0xc9, 0x64, 0x8b, 0x1e,
	0xc7, 0x64, 0xa1, 0xc9, 0x64, 0x0b, 0xdb, 0x74,
	0x0d, 0xc6, 0x06, 0xcc, 0x64, 0x01, 0x0a, 0xc9,
	0x74, 0x04, 0xfe, 0x0e, 0xcc, 0x64, 0x0b, 0xc0,
	0x74, 0x0d, 0xc6, 0x06, 0xcd, 0x64, 0x01, 0x0a,
	0xed, 0x74, 0x04, 0xfe, 0x0e, 0xcd, 0x64, 0x8b,
	0xd0, 0x0b, 0xc0, 0x0b, 0xc3, 0x75, 0x02, 0xf9,
	0xc3, 0x8b, 0xc2, 0xb9, 0x10, 0x00, 0xf7, 0xe1,
	0xb9, 0x0a, 0x00, 0xf7, 0xf1, 0x3b, 0xc3, 0x77,
	0x3e, 0xa0, 0xdc, 0x64, 0xa2, 0xdd, 0x64, 0xc6,
	0x06, 0xdc, 0x64, 0x00, 0xc6, 0x06, 0xcb, 0x64,
	0x00, 0x80, 0x3e, 0xcc, 0x64, 0x01, 0x74, 0x05,
	0xc6, 0x06, 0xdc, 0x64, 0x01, 0xa1, 0xc7, 0x64,
	0x8b, 0x1e, 0xb5, 0x64, 0x33, 0xd2, 0xf7, 0xf3,
	0xa3, 0xce, 0x64, 0xa1, 0xb5, 0x64, 0x8b, 0x1e,
	0xc9, 0x64, 0xb9, 0xe8, 0x03, 0xf7, 0xe3, 0xf7,
	0xe1, 0x8b, 0x1e, 0xc7, 0x64, 0xeb, 0x25, 0xc6,
	0x06, 0xcb, 0x64, 0x01, 0xa1, 0xc9, 0x64, 0x8b,
	0x1e, 0xb3, 0x64, 0x33, 0xd2, 0xf7, 0xf3, 0xa3,
	0xce, 0x64, 0xa1, 0xb3, 0x64, 0x8b, 0x1e, 0xc7,
	0x64, 0xb9, 0xe8, 0x03, 0xf7, 0xe3, 0xf7, 0xe1,
	0x8b, 0x1e, 0xc9, 0x64, 0xf7, 0xf3, 0xbb, 0xd0,
	0x64, 0x89, 0x07, 0xc7, 0x47, 0x02, 0x00, 0x00,
	0xbb, 0xd4, 0x64, 0x89, 0x07, 0xc7, 0x47, 0x02,
	0x00, 0x00, 0x80, 0x3e, 0xc4, 0x64, 0x01, 0x75,
	0x05, 0xc6, 0x06, 0xe2, 0x65, 0x01, 0xff, 0x06,
	0xce, 0x64, 0xf8, 0xc3, 0x83, 0x3e, 0xce, 0x64,
	0x01, 0x75, 0x02, 0xf8, 0xc3, 0x8b, 0x36, 0xaf,
	0x64, 0x8b, 0x3e, 0xb1, 0x64, 0xe8, 0x2e, 0x02,
	0x72, 0x01, 0xc3, 0x8b, 0x36, 0x44, 0x67, 0x3b,
	0xde, 0x74, 0x0f, 0x89, 0x1e, 0x44, 0x67, 0x8a,
	0x04, 0x3a, 0x07, 0x74, 0x05, 0xc6, 0x06, 0x40,
	0x67, 0xff, 0xc6, 0x06, 0xc5, 0x64, 0x01, 0xa0,
	0xcc, 0x64, 0x8a, 0x26, 0xcd, 0x64, 0x0a, 0xe4,
	0x74, 0x15, 0xc6, 0x06, 0x42, 0x67, 0x01, 0xc6,
	0x06, 0x43, 0x67, 0x01, 0x0a, 0xc0, 0x74, 0x1a,
	0xc6, 0x06, 0x43, 0x67, 0x00, 0xeb, 0x13, 0xc6,
	0x06, 0x42, 0x67, 0x00, 0xc6, 0x06, 0x43, 0x67,
	0x01, 0x0a, 0xc0, 0x74, 0x05, 0xc6, 0x06, 0x43,
	0x67, 0x00, 0x43, 0x43, 0x53, 0x8b, 0x0f, 0x41,
	0x8b, 0x7f, 0x02, 0x47, 0x8b, 0x77, 0x04, 0x4e,
	0x8b, 0x5f, 0x06, 0x4b, 0xa1, 0xbf, 0x64, 0x8b,
	0x16, 0xc1, 0x64, 0x3b, 0xc1, 0x72, 0x17, 0x3b,
	0xc6, 0x77, 0x13, 0xc6, 0x06, 0x41, 0x67, 0x00,
	0x80, 0x3e, 0x42, 0x67, 0x01, 0x74, 0x4f, 0xc6,
	0x06, 0x41, 0x67, 0x02, 0xeb, 0x48, 0x3b, 0xd7,
	0x72, 0x17, 0x3b, 0xd3, 0x77, 0x13, 0xc6, 0x06,
	0x41, 0x67, 0x01, 0x80, 0x3e, 0x43, 0x67, 0x01,
	0x74, 0x34, 0xc6, 0x06, 0x41, 0x67, 0x03, 0xeb,
	0x2d, 0x80, 0x3e, 0xcb, 0x64, 0x00, 0x75, 0x13,
	0xc6, 0x06, 0x41, 0x67, 0x01, 0x80, 0x3e, 0x43,
	0x67, 0x01, 0x74, 0x1a, 0xc6, 0x06, 0x41, 0x67,
	0x03, 0xeb, 0x13, 0xc6, 0x06, 0x41, 0x67, 0x00,
	0x80, 0x3e, 0x42, 0x67, 0x01, 0x74, 0x07, 0xc6,
	0x06, 0x41, 0x67, 0x02, 0xeb, 0x00, 0x5b, 0x53,
	0x83, 0xc3, 0x08, 0xa0, 0x41, 0x67, 0xb4, 0x00,
	0x03, 0xd8, 0x8a, 0x07, 0x5b, 0x8a, 0x36, 0x40,
	0x67, 0x0a, 0xc0, 0x74, 0x18, 0x3c, 0x01, 0x74,
	0x35, 0x3c, 0x02, 0x74, 0x56, 0x3c, 0x03, 0x74,
	0x77, 0x3c, 0x04, 0x75, 0x03, 0xe9, 0x95, 0x00,
	0xb0, 0x34, 0xe9, 0xf3, 0x78, 0xa0, 0xcd, 0x64,
	0x8a, 0x26, 0xcc, 0x64, 0x8a, 0x16, 0x41, 0x67,
	0x80, 0xfa, 0x01, 0x74, 0x05, 0x80, 0xfa, 0x03,
	0x75, 0x06, 0x0a, 0xc0, 0x74, 0x08, 0xeb, 0x50,
	0x0a, 0xe4, 0x75, 0x27, 0xeb, 0x6f, 0x80, 0xfe,
	0x02, 0x75, 0x09, 0x80, 0x3e, 0xcc, 0x64, 0x01,
	0x74, 0x19, 0xeb, 0x61, 0x80, 0xfe, 0x00, 0x74,
	0xf2, 0xa1, 0xbf, 0x64, 0xa3, 0xb7, 0x64, 0x83,
	0xc3, 0x02, 0x8b, 0x07, 0xa3, 0xb9, 0x64, 0xb0,
	0x00, 0xeb, 0x6a, 0x80, 0xfe, 0x03, 0x75, 0x09,
	0x80, 0x3e, 0xcd, 0x64, 0x01, 0x75, 0xcf, 0xeb,
	0x17, 0x80, 0xfe, 0x01, 0x74, 0xf2, 0xa1, 0xc1,
	0x64, 0xa3, 0xb9, 0x64, 0x83, 0xc3, 0x04, 0x8b,
	0x07, 0xa3, 0xb7, 0x64, 0xb0, 0x01, 0xeb, 0x45,
	0x80, 0xfe, 0x00, 0x75, 0x09, 0x80, 0x3e, 0xcc,
	0x64, 0x01, 0x75, 0x19, 0xeb, 0xcd, 0x80, 0xfe,
	0x02, 0x74, 0xf2, 0xa1, 0xbf, 0x64, 0xa3, 0xb7,
	0x64, 0x83, 0xc3, 0x06, 0x8b, 0x07, 0xa3, 0xb9,
	0x64, 0xb0, 0x02, 0xeb, 0x20, 0x80, 0xfe, 0x01,
	0x75, 0x09, 0x80, 0x3e, 0xcd, 0x64, 0x01, 0x74,
	0xcf, 0xeb, 0x83, 0x80, 0xfe, 0x03, 0x74, 0xf2,
	0xa1, 0xc1, 0x64, 0xa3, 0xb9, 0x64, 0x8b, 0x07,
	0xa3, 0xb7, 0x64, 0xb0, 0x03, 0xa2, 0x40, 0x67,
	0xa1, 0xbf, 0x64, 0xa3, 0xaf, 0x64, 0xa1, 0xc1,
	0x64, 0xa3, 0xb1, 0x64, 0xf9, 0xc3, 0x81, 0xfe,
	0x3f, 0x01, 0x75, 0x01, 0x4e, 0x0b, 0xf6, 0x75,
	0x01, 0x46, 0x81, 0xff, 0xc7, 0x00, 0x75, 0x01,
	0x4f, 0x0b, 0xff, 0x75, 0x01, 0x47, 0xe8, 0x89,
	0x00, 0x73, 0x29, 0x43, 0x8a, 0x07, 0x0a, 0xc0,
	0x74, 0x08, 0xe8, 0x20, 0x00, 0xe8, 0x7a, 0x00,
	0x73, 0x1a, 0xe8, 0x14, 0x03, 0xc6, 0x06, 0xdc,
	0x1c, 0x02, 0xe8, 0x09, 0xed, 0xc6, 0x06, 0xdc,
	0x1c, 0x03, 0xa1, 0xaf, 0x64, 0x8b, 0xf0, 0xa1,
	0xb1, 0x64, 0x8b, 0xf8, 0xc3, 0x43, 0x3c, 0x01,
	0x75, 0x05, 0x8b, 0x7f, 0x02, 0x4f, 0xc3, 0x3c,
	0x03, 0x75, 0x05, 0x8b, 0x7f, 0x06, 0x47, 0xc3,
	0x3c, 0x02, 0x75, 0x05, 0x8b, 0x77, 0x04, 0x46,
	0xc3, 0x3c, 0x04, 0x75, 0x04, 0x8b, 0x37, 0x4e,
	0xc3, 0xb0, 0x3a, 0xe9, 0xc2, 0x77, 0xbb, 0x46,
	0x67, 0xe8, 0x2e, 0x04, 0x8a, 0x0f, 0x0a, 0xc9,
	0x74, 0x24, 0xb5, 0x00, 0x43, 0x8b, 0x47, 0x02,
	0x8b, 0x57, 0x06, 0x3b, 0xf0, 0x76, 0x12, 0x3b,
	0xf2, 0x73, 0x0e, 0x8b, 0x47, 0x04, 0x8b, 0x57,
	0x08, 0x3b, 0xf8, 0x76, 0x04, 0x3b, 0xfa, 0x72,
	0x07, 0x83, 0xc3, 0x0e, 0xe2, 0xdf, 0xf8, 0xc3,
	0xf9, 0xc3, 0xbb, 0x46, 0x67, 0xe8, 0xfa, 0x03,
	0x8a, 0x0f, 0x0a, 0xc9, 0x74, 0x24, 0xb5, 0x00,
	0x43, 0x8b, 0x47, 0x02, 0x8b, 0x57, 0x06, 0x3b,
	0xf0, 0x72, 0x12, 0x3b, 0xf2, 0x77, 0x0e, 0x8b,
	0x47, 0x04, 0x8b, 0x57, 0x08, 0x3b, 0xf8, 0x72,
	0x04, 0x3b, 0xfa, 0x76, 0x07, 0x83, 0xc3, 0x0e,
	0xe2, 0xdf, 0xf8, 0xc3, 0xf9, 0xc3, 0xbb, 0xf4,
	0x70, 0xe8, 0xc6, 0x03, 0x8b, 0x07, 0x3d, 0xff,
	0xff, 0x74, 0x4c, 0x43, 0x43, 0x8b, 0x0e, 0xb1,
	0x64, 0x3a, 0xc8, 0x77, 0xef, 0x8a, 0xc4, 0xb4,
	0x00, 0xa3, 0xd8, 0x64, 0xe8, 0x25, 0x03, 0x83,
	0x3e, 0xce, 0x64, 0x02, 0x76, 0x31, 0x83, 0x3e,
	0xd8, 0x64, 0x1e, 0x72, 0x15, 0x83, 0x3e, 0xb3,
	0x64, 0x01, 0x74, 0x23, 0xc7, 0x06, 0xb3, 0x64,
	0x01, 0x00, 0xc7, 0x06, 0xb5, 0x64, 0x04, 0x00,
	0xf9, 0xc3, 0x83, 0x3e, 0xb3, 0x64, 0x03, 0x74,
	0x0e, 0xc7, 0x06, 0xb3, 0x64, 0x03, 0x00, 0xc7,
	0x06, 0xb5, 0x64, 0x08, 0x00, 0xf9, 0xc3, 0xf8,
	0xc3, 0x80, 0x3e, 0xc6, 0x64, 0x02, 0x75, 0x01,
	0xc3, 0xa1, 0xaf, 0x64, 0xa3, 0xbf, 0x64, 0xa1,
	0xb1, 0x64, 0xa3, 0xc1, 0x64, 0x80, 0x3e, 0xcb,
	0x64, 0x00, 0x75, 0x36, 0xa1, 0xb5, 0x64, 0x80,
	0x3e, 0xcc, 0x64, 0x01, 0x75, 0x06, 0x01, 0x06,
	0xaf, 0x64, 0xeb, 0x04, 0x29, 0x06, 0xaf, 0x64,
	0xbb, 0xd4, 0x64, 0x8b, 0x07, 0x8b, 0x57, 0x02,
	0xb9, 0xe8, 0x03, 0xf7, 0xf1, 0x80, 0x3e, 0xcd,
	0x64, 0x01, 0x75, 0x06, 0x01, 0x06, 0xb1, 0x64,
	0xeb, 0x04, 0x29, 0x06, 0xb1, 0x64, 0xe8, 0x37,
	0x00, 0xc3, 0xa1, 0xb3, 0x64, 0x80, 0x3e, 0xcd,
	0x64, 0x01, 0x75, 0x06, 0x01, 0x06, 0xb1, 0x64,
	0xeb, 0x04, 0x29, 0x06, 0xb1, 0x64, 0xbb, 0xd4,
	0x64, 0x8b, 0x07, 0x8b, 0x57, 0x02, 0xb9, 0xe8,
	0x03, 0xf7, 0xf1, 0x80, 0x3e, 0xcc, 0x64, 0x01,
	0x75, 0x06, 0x01, 0x06, 0xaf, 0x64, 0xeb, 0x04,
	0x29, 0x06, 0xaf, 0x64, 0xe8, 0x01, 0x00, 0xc3,
	0x50, 0xbb, 0xd4, 0x64, 0x8b, 0x07, 0x8b, 0x57,
	0x02, 0xbe, 0xd0, 0x64, 0x8b, 0x1c, 0x8b, 0x4c,
	0x02, 0x03, 0xc3, 0x83, 0xd2, 0x00, 0x03, 0xd1,
	0xbb, 0xd4, 0x64, 0x89, 0x07, 0x89, 0x57, 0x02,
	0x58, 0xb9, 0xe8, 0x03, 0xf7, 0xe1, 0x8b, 0xc8,
	0x8b, 0x07, 0x8b, 0x57, 0x02, 0x2b, 0xc1, 0x83,
	0xda, 0x00, 0x89, 0x07, 0x89, 0x57, 0x02, 0xc3,
	0x8a, 0x0e, 0x07, 0x66, 0x80, 0x3e, 0xc6, 0x64,
	0x02, 0x74, 0x4d, 0x80, 0x3e, 0xcb, 0x64, 0x00,
	0x75, 0x0f, 0xbb, 0xed, 0x65, 0x80, 0x3e, 0xcc,
	0x64, 0x01, 0x74, 0x1e, 0xbb, 0xe3, 0x65, 0xeb,
	0x19, 0x80, 0x3e, 0xe2, 0x65, 0x07, 0x76, 0x05,
	0xc6, 0x06, 0xe2, 0x65, 0x01, 0xbb, 0xff, 0x65,
	0x80, 0x3e, 0xcd, 0x64, 0x01, 0x74, 0x03, 0xbb,
	0xf7, 0x65, 0x8a, 0x0e, 0xe2, 0x65, 0xb5, 0x00,
	0x49, 0x03, 0xd9, 0x8a, 0x0f, 0x0a, 0xc9, 0x75,
	0x07, 0xc6, 0x06, 0xe2, 0x65, 0x01, 0xeb, 0xbb,
	0x88, 0x0e, 0x07, 0x66, 0xfe, 0x06, 0xe2, 0x65,
	0xe8, 0xdd, 0x00, 0xc3, 0x8b, 0x1e, 0x3d, 0x65,
	0x8a, 0x0e, 0x3f, 0x65, 0xb5, 0x00, 0x49, 0x03,
	0xd9, 0x8a, 0x0f, 0x0a, 0xc9, 0x75, 0x0a, 0xc6,
	0x06, 0x3f, 0x65, 0x04, 0xe8, 0x0e, 0x00, 0xeb,
	0xe3, 0x88, 0x0e, 0x07, 0x66, 0xfe, 0x06, 0x3f,
	0x65, 0xe8, 0xb4, 0x00, 0xc3, 0xb8, 0x03, 0x00,
	0xe8, 0xb0, 0x73, 0xbb, 0x40, 0x65, 0xd1, 0xe0,
	0x03, 0xd8, 0x8b, 0x07, 0xa3, 0x3d, 0x65, 0xc3,
	0x80, 0x3e, 0xcb, 0x64, 0x00, 0x75, 0x13, 0xbb,
	0xfe, 0x64, 0xb2, 0x01, 0x80, 0x3e, 0xcc, 0x64,
	0x01, 0x74, 0x18, 0xbb, 0xe9, 0x64, 0xb2, 0x01,
	0xeb, 0x11, 0xbb, 0x28, 0x65, 0xb2, 0x0b, 0x80,
	0x3e, 0xcd, 0x64, 0x01, 0x74, 0x05, 0xbb, 0x13,
	0x65, 0xb2, 0x13, 0x8a, 0x0e, 0xe8, 0x64, 0xb5,
	0x00, 0x49, 0x03, 0xd9, 0x8a, 0x0f, 0x0a, 0xc9,
	0x75, 0x07, 0xc6, 0x06, 0xe8, 0x64, 0x01, 0xeb,
	0xbf, 0xfe, 0x06, 0xe8, 0x64, 0xe8, 0x58, 0x00,
	0x1e, 0x53, 0x8a, 0xca, 0x88, 0x0e, 0x07, 0x66,
	0xe8, 0x4d, 0x00, 0x8b, 0xf3, 0x5b, 0xa1, 0xbf,
	0x32, 0x8e, 0xd8, 0x8b, 0x07, 0x8b, 0x4f, 0x02,
	0xf7, 0xe1, 0x8b, 0xc8, 0xb8, 0x06, 0x00, 0x03,
	0xd8, 0x03, 0xf0, 0x8a, 0x07, 0x88, 0x04, 0x43,
	0x46, 0xe2, 0xf8, 0x1f, 0xc3, 0x33, 0xc9, 0x80,
	0x3e, 0xcb, 0x64, 0x00, 0x75, 0x11, 0xb2, 0x01,
	0xb1, 0x28, 0x80, 0x3e, 0xcc, 0x64, 0x01, 0x74,
	0xb8, 0xb2, 0x01, 0xb1, 0x28, 0xeb, 0xb2, 0xb2,
	0x0b, 0xb1, 0x29, 0x80, 0x3e, 0xcd, 0x64, 0x01,
	0x74, 0xa7, 0xb2, 0x13, 0xb1, 0x2a, 0xeb, 0xa1,
	0x06, 0xa1, 0xbf, 0x32, 0x8e, 0xc0, 0x32, 0xed,
	0xbb, 0x01, 0x00, 0x49, 0xd1, 0xe1, 0x03, 0xd9,
	0x26, 0x8b, 0x1f, 0x89, 0x1e, 0xe6, 0x64, 0x07,
	0xc3, 0x80, 0x3e, 0xcb, 0x64, 0x00, 0x75, 0x0d,
	0xb1, 0x01, 0x80, 0x3e, 0xcc, 0x64, 0x01, 0x74,
	0x0f, 0xb1, 0x01, 0xeb, 0x0b, 0xb1, 0x0b, 0x80,
	0x3e, 0xcd, 0x64, 0x01, 0x74, 0x02, 0xb1, 0x13,
	0x88, 0x0e, 0x07, 0x66, 0xe8, 0xc1, 0xff, 0xc3,
	0xa0, 0x07, 0x66, 0x8a, 0x26, 0xcb, 0x64, 0x8a,
	0x1e, 0xcc, 0x64, 0x8a, 0x3e, 0xcd, 0x64, 0x83,
	0x3e, 0xce, 0x64, 0x01, 0x75, 0x44, 0x3c, 0x13,
	0x75, 0x0f, 0x80, 0xfc, 0x01, 0x75, 0x3b, 0x80,
	0xff, 0x00, 0x75, 0x36, 0xb1, 0x14, 0xe9, 0x85,
	0x00, 0x3c, 0x0b, 0x75, 0x0e, 0x80, 0xfc, 0x01,
	0x75, 0x28, 0x80, 0xff, 0x01, 0x75, 0x23, 0xb1,
	0x0c, 0xeb, 0x73, 0x3c, 0x01, 0x75, 0x1b, 0xa0,
	0xdd, 0x64, 0x3a, 0x06, 0xdc, 0x64, 0x75, 0x12,
	0x80, 0xfc, 0x00, 0x75, 0x0d, 0x80, 0xfb, 0x01,
	0x75, 0x04, 0xb1, 0x02, 0xeb, 0x58, 0xb1, 0x02,
	0xeb, 0x54, 0xa0, 0x07, 0x66, 0x3c, 0x13, 0x72,
	0x12, 0x3c, 0x1a, 0x77, 0x0e, 0x80, 0xfc, 0x01,
	0x75, 0x42, 0x80, 0xff, 0x01, 0x75, 0x3d, 0xb1,
	0x02, 0xeb, 0x3b, 0x3c, 0x01, 0x72, 0x1f, 0x3c,
	0x0a, 0x77, 0x1b, 0x80, 0xfc, 0x00, 0x75, 0x2c,
	0xa0, 0xdd, 0x64, 0x38, 0x06, 0xdc, 0x64, 0x74,
	0x23, 0x80, 0xfb, 0x01, 0x75, 0x04, 0xb1, 0x0c,
	0xeb, 0x1c, 0xb1, 0x0c, 0xeb, 0x18, 0x3c, 0x0b,
	0x72, 0x12, 0x3c, 0x12, 0x77, 0x0e, 0x80, 0xfc,
	0x01, 0x75, 0x09, 0x80, 0xff, 0x00, 0x75, 0x04,
	0xb1, 0x02, 0xeb, 0x02, 0xf8, 0xc3, 0x88, 0x0e,
	0x07, 0x66, 0xf9, 0xc3, 0xa1, 0xd8, 0x64, 0x3d,
	0x64, 0x00, 0x77, 0x28, 0x53, 0x1e, 0x8b, 0x16,
	0xb1, 0x32, 0x8e, 0xda, 0xbb, 0x00, 0xfa, 0xba,
	0xff, 0xff, 0x0b, 0xc0, 0x74, 0x09, 0x8b, 0xc8,
	0xb8, 0x64, 0x00, 0x33, 0xd2, 0xf7, 0xf1, 0x89,
	0x57, 0x02, 0xb9, 0x64, 0x00, 0xf7, 0xe1, 0x89,
	0x07, 0x1f, 0x5b, 0xc3, 0xb0, 0x35, 0xe9, 0xdf,
	0x73, 0x80, 0x3e, 0xae, 0x64, 0x01, 0x75, 0x08,
	0x81, 0x3e, 0xba, 0x00, 0x3f, 0x01, 0x75, 0x18,
	0x8b, 0x0e, 0x32, 0x32, 0x3b, 0xca, 0x77, 0x0a,
	0x8b, 0x0e, 0x34, 0x32, 0x3b, 0xca, 0x73, 0x08,
	0xf8, 0xc3, 0x3b, 0xce, 0x76, 0x02, 0xf8, 0xc3,
	0x8b, 0x0e, 0xb1, 0x64, 0x3b, 0xcf, 0x76, 0x02,
	0xf8, 0xc3, 0x3b, 0xc8, 0x73, 0x02, 0xf8, 0xc3,
	0xf9, 0xc3, 0xc6, 0x06, 0xc6, 0x64, 0x00, 0xc6,
	0x06, 0x40, 0x67, 0xff, 0xc6, 0x06, 0xc4, 0x64,
	0x01, 0xc6, 0x06, 0xc5, 0x64, 0x00, 0xe8, 0x77,
	0xf5, 0xc3, 0x51, 0x8b, 0x0e, 0xf3, 0xb4, 0x49,
	0xd1, 0xe1, 0x03, 0xd9, 0x8b, 0x1f, 0x59, 0xc3,
	0xbb, 0xf5, 0xb4, 0xeb, 0xed, 0xc7, 0x06, 0xf3,
	0xb4, 0x03, 0x00, 0xb8, 0x3f, 0x01, 0xbb, 0x68,
	0x00, 0xbf, 0x22, 0x01, 0xbe, 0x76, 0x00, 0xb1,
	0x01, 0xb5, 0x04, 0xe8, 0xdd, 0x6b, 0xc3, 0xc7,
	0x06, 0xf3, 0xb4, 0x05, 0x00, 0xb8, 0x2c, 0x01,
	0xbb, 0x83, 0x00, 0xbf, 0x2c, 0x01, 0xbe, 0x87,
	0x00, 0xb1, 0x0b, 0xb5, 0x03, 0xe8, 0xc3, 0x6b,
	0xc3, 0x80, 0x3e, 0xe1, 0xdb, 0x01, 0x74, 0x07,
	0xbb, 0x0f, 0x57, 0xe8, 0x27, 0x60, 0xc3, 0xb9,
	0x4c, 0x03, 0xe8, 0xba, 0xda, 0xb9, 0x4e, 0x03,
	0xe8, 0xb7, 0xda, 0xb9, 0x4d, 0x03, 0xe8, 0xd6,
	0xda, 0xbb, 0x96, 0x56, 0xe8, 0x0e, 0x60, 0xc3,
	0xbb, 0xac, 0x56, 0xe8, 0x07, 0x60, 0xc3, 0xbb,
	0xf7, 0x56, 0xe8, 0x00, 0x60, 0xc3, 0xbb, 0x7a,
	0xdb, 0xe8, 0x51, 0xd1, 0xe8, 0x66, 0xd1, 0xc3,
	0xc7, 0x06, 0xf3, 0xb4, 0x02, 0x00, 0xb8, 0x00,
	0x00, 0xbb, 0xb4, 0x00, 0xbf, 0x38, 0x00, 0xbe,
	0xb4, 0x00, 0xb1, 0x01, 0xb5, 0x02, 0xe8, 0x6a,
	0x6b, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x04, 0x00,
	0xb8, 0x3f, 0x01, 0xbb, 0x80, 0x00, 0xbf, 0x13,
	0x01, 0xbe, 0x89, 0x00, 0xb1, 0x01, 0xb5, 0x04,
	0xe8, 0x50, 0x6b, 0xc3, 0x80, 0x3e, 0xe4, 0xdb,
	0x01, 0x75, 0x07, 0xbb, 0xb2, 0x57, 0xe8, 0xb4,
	0x5f, 0xc3, 0xb9, 0x4c, 0x00, 0xb0, 0x0b, 0xb4,
	0x07, 0xe8, 0x51, 0x69, 0xb0, 0x0f, 0xe8, 0x55,
	0x69, 0xb0, 0x13, 0xe8, 0x57, 0x69, 0xb0, 0x17,
	0xe8, 0x59, 0x69, 0xb0, 0x1b, 0xe8, 0x5b, 0x69,
	0xb9, 0x38, 0x00, 0xb0, 0x23, 0xe8, 0x5a, 0x69,
	0xb9, 0x13, 0x00, 0xb0, 0x3b, 0xe8, 0x59, 0x69,
	0xb9, 0x60, 0x03, 0xe8, 0x19, 0xda, 0xe8, 0xba,
	0x6a, 0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x02, 0x61, 0x03, 0xb0, 0x02,
	0xe8, 0x3c, 0xd9, 0xc6, 0x06, 0xb0, 0x32, 0x01,
	0xe8, 0x91, 0xdd, 0xc6, 0x06, 0xb0, 0x32, 0x00,
	0x9c, 0xe8, 0xa2, 0x69, 0xb9, 0x62, 0x03, 0xc6,
	0x06, 0xdc, 0x1c, 0x02, 0xe8, 0xeb, 0xd9, 0x9d,
	0x73, 0x4c, 0xa1, 0x1f, 0xc4, 0xe8, 0x54, 0xe7,
	0x3c, 0x55, 0x75, 0x42, 0x83, 0x3e, 0x52, 0x72,
	0x05, 0x75, 0x3b, 0xc6, 0x06, 0xcf, 0x00, 0x00,
	0xc7, 0x06, 0x1f, 0xc4, 0x00, 0x00, 0xb9, 0x05,
	0x00, 0xb0, 0x04, 0xb4, 0x06, 0xe8, 0xcd, 0x68,
	0xb0, 0x13, 0xe8, 0xd8, 0x68, 0xb9, 0x40, 0x00,
	0xb0, 0x0b, 0xe8, 0xc9, 0x68, 0xb9, 0x63, 0x03,
	0xe8, 0xaf, 0xd9, 0xb0, 0x55, 0xe8, 0x00, 0xe6,
	0xb0, 0x56, 0xe8, 0xeb, 0xe5, 0xc6, 0x06, 0xe4,
	0xdb, 0x01, 0xe8, 0x1e, 0x00, 0xc3, 0xe8, 0x1a,
	0x00, 0xff, 0x36, 0xcf, 0x00, 0xc6, 0x06, 0xcf,
	0x00, 0x00, 0xbb, 0x72, 0xdb, 0xe8, 0x45, 0xd0,
	0xe8, 0x5a, 0xd0, 0x8f, 0x06, 0xcf, 0x00, 0xe8,
	0xdc, 0xdd, 0xc3, 0xc7, 0x06, 0xaf, 0x64, 0x56,
	0x00, 0xc7, 0x06, 0xb1, 0x64, 0xc3, 0x00, 0xc6,
	0x06, 0xcc, 0x64, 0x00, 0xc6, 0x06, 0xcd, 0x64,
	0x01, 0xc6, 0x06, 0xcb, 0x64, 0x01, 0xb9, 0x64,
	0x03, 0xe8, 0x83, 0xd9, 0xc3, 0xbb, 0xb7, 0x58,
	0xe8, 0xba, 0x5e, 0xc3, 0xb9, 0x38, 0x00, 0xb0,
	0x0a, 0xb4, 0x09, 0xe8, 0x57, 0x68, 0xe8, 0xae,
	0xd9, 0xe8, 0x3c, 0xfe, 0xc6, 0x07, 0x00, 0xe8,
	0xc2, 0x6c, 0xb9, 0x6b, 0x03, 0xe8, 0x6d, 0xd9,
	0xb0, 0x06, 0xe8, 0x28, 0xd8, 0xb0, 0x5c, 0xe8,
	0x76, 0xe5, 0xc3, 0xbb, 0x0f, 0x57, 0xe8, 0x8c,
	0x5e, 0xc3, 0xe8, 0x09, 0x63, 0xc3, 0xe8, 0x86,
	0xd9, 0xbb, 0x46, 0x67, 0xe8, 0x03, 0xfe, 0x83,
	0xc3, 0x03, 0xff, 0x37, 0x53, 0xc7, 0x07, 0x3f,
	0x01, 0xbe, 0xc5, 0x00, 0xbf, 0x9f, 0x00, 0xc6,
	0x06, 0xc3, 0x64, 0x04, 0xe8, 0x3c, 0xf4, 0xe8,
	0xf6, 0xfd, 0xc6, 0x07, 0x00, 0xe8, 0x7c, 0x6c,
	0xb9, 0x47, 0x00, 0xb0, 0x08, 0xb4, 0x07, 0xe8,
	0xfb, 0x67, 0xb9, 0x05, 0x00, 0xb0, 0x0d, 0xe8,
	0xfc, 0x67, 0xb9, 0x41, 0x03, 0xe8, 0x15, 0xd9,
	0xbe, 0xe1, 0x00, 0xbf, 0x9f, 0x00, 0xc6, 0x06,
	0xc3, 0x64, 0x04, 0xe8, 0x0d, 0xf4, 0x5b, 0x8f,
	0x07, 0xb0, 0x4e, 0xe8, 0x12, 0xe5, 0xb0, 0x03,
	0xe8, 0xba, 0xd7, 0xc3, 0xbb, 0xc8, 0x58, 0xe8,
	0x23, 0x5e, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x03,
	0x00, 0xb8, 0xd6, 0x00, 0xbb, 0xc7, 0x00, 0xbf,
	0xda, 0x00, 0xbe, 0xbf, 0x00, 0xb1, 0x13, 0xb5,
	0x01, 0xe8, 0x97, 0x69, 0xc3, 0xc7, 0x06, 0xf3,
	0xb4, 0x05, 0x00, 0xb8, 0x00, 0x00, 0xbb, 0xae,
	0x00, 0xbf, 0x23, 0x00, 0xbe, 0xae, 0x00, 0xb1,
	0x01, 0xb5, 0x02, 0xe8, 0x7d, 0x69, 0xc3, 0xe8,
	0xed, 0xd8, 0xc6, 0x06, 0xdc, 0x64, 0x00, 0xb9,
	0x17, 0x00, 0xb0, 0x08, 0xb4, 0x07, 0xe8, 0x84,
	0x67, 0xb9, 0x18, 0x00, 0xb0, 0x0d, 0xe8, 0x85,
	0x67, 0xe8, 0x64, 0xfd, 0xc6, 0x47, 0x01, 0x00,
	0x53, 0xe8, 0xe8, 0x6b, 0xb9, 0x49, 0x03, 0xe8,
	0x60, 0xd8, 0x5b, 0xc6, 0x47, 0x01, 0x61, 0xc6,
	0x47, 0x02, 0x00, 0xe8, 0x92, 0x6b, 0xe8, 0x84,
	0x00, 0xe8, 0xb1, 0xdc, 0xb9, 0x3f, 0x00, 0xb0,
	0x0c, 0xb4, 0x07, 0xe8, 0x4f, 0x67, 0xb9, 0x05,
	0x00, 0xb0, 0x1a, 0xe8, 0x50, 0x67, 0xb9, 0x4a,
	0x03, 0xe8, 0x36, 0xd8, 0xe8, 0x66, 0x00, 0xe8,
	0x93, 0xdc, 0xc6, 0x06, 0xe6, 0x1c, 0xd1, 0xbb,
	0x56, 0x56, 0xbe, 0x10, 0x55, 0xe8, 0x2e, 0x60,
	0xe8, 0x7b, 0xdc, 0xbb, 0x7a, 0x56, 0xbe, 0x5c,
	0x55, 0xe8, 0x22, 0x60, 0xe8, 0x6f, 0xdc, 0xbb,
	0x82, 0x56, 0xbe, 0x3e, 0x55, 0xe8, 0x16, 0x60,
	0xe8, 0x63, 0xdc, 0xb9, 0x4b, 0x03, 0xe8, 0x01,
	0xd8, 0xc7, 0x06, 0xaf, 0x64, 0xdf, 0x00, 0xc7,
	0x06, 0xb1, 0x64, 0x95, 0x00, 0xc6, 0x06, 0xcb,
	0x64, 0x00, 0xc6, 0x06, 0xcc, 0x64, 0x01, 0xc6,
	0x06, 0xcd, 0x64, 0x00, 0xe8, 0x1d, 0xd8, 0xb0,
	0x07, 0xe8, 0xd1, 0xd6, 0xb0, 0x01, 0xe8, 0xcc,
	0xd6, 0xb0, 0x51, 0xe8, 0x1a, 0xe4, 0xbb, 0x46,
	0x56, 0xe8, 0x31, 0x5d, 0xc3, 0xe8, 0x6b, 0x68,
	0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xe8, 0x9c, 0xeb,
	0xe8, 0x45, 0xec, 0xe8, 0xda, 0x63, 0xe8, 0x2b,
	0xf1, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x0a, 0x00,
	0xb8, 0x3f, 0x01, 0xbb, 0xb7, 0x00, 0xbf, 0x0d,
	0x01, 0xbe, 0xaf, 0x00, 0xb1, 0x01, 0xb5, 0x04,
	0xe8, 0x90, 0x68, 0xc3, 0xc7, 0x06, 0xf3, 0xb4,
	0x04, 0x00, 0xb8, 0x3f, 0x01, 0xbb, 0xb9, 0x00,
	0xbf, 0x18, 0x01, 0xbe, 0xb9, 0x00, 0xb1, 0x01,
	0xb5, 0x04, 0xe8, 0x76, 0x68, 0xc3, 0xc7, 0x06,
	0xf3, 0xb4, 0x02, 0x00, 0xb8, 0xdd, 0x00, 0xbb,
	0xc7, 0x00, 0xbf, 0xd9, 0x00, 0xbe, 0xc1, 0x00,
	0xb1, 0x13, 0xb5, 0x01, 0xe8, 0x5c, 0x68, 0xc3,
	0xb9, 0x50, 0x00, 0xb0, 0x04, 0xb4, 0x02, 0xe8,
	0x6b, 0x66, 0xb9, 0xc1, 0x03, 0xe8, 0x57, 0xd7,
	0xe8, 0xf8, 0x67, 0xc7, 0x06, 0xf3, 0xb4, 0x08,
	0x00, 0xb8, 0x9b, 0x00, 0xbb, 0xc7, 0x00, 0xbf,
	0x9e, 0x00, 0xbe, 0xb8, 0x00, 0xb1, 0x13, 0xb5,
	0x01, 0xe8, 0x2f, 0x68, 0xc3, 0xb9, 0x46, 0x00,
	0xb0, 0x06, 0xb4, 0x09, 0xe8, 0x3e, 0x66, 0xb9,
	0xc2, 0x03, 0xe8, 0x2a, 0xd7, 0xe8, 0xcb, 0x67,
	0xc7, 0x06, 0xf3, 0xb4, 0x07, 0x00, 0xb8, 0x1e,
	0x00, 0xbb, 0xb8, 0x00, 0xbf, 0x32, 0x00, 0xbe,
	0xb8, 0x00, 0xb1, 0x01, 0xb5, 0x02, 0xe8, 0x02,
	0x68, 0x80, 0x3e, 0xdf, 0xdb, 0x02, 0x72, 0x01,
	0xc3, 0xb8, 0x96, 0x00, 0xe8, 0x4b, 0xdb, 0xbe,
	0x86, 0x00, 0xbf, 0xa7, 0x00, 0xc6, 0x06, 0xc3,
	0x64, 0x02, 0xe8, 0x2e, 0xf2, 0xbb, 0xf7, 0x54,
	0xe8, 0x52, 0x5c, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0x2c, 0x03, 0xb9, 0x2b, 0x03, 0xe8, 0xdf, 0xd6,
	0xe8, 0x80, 0x67, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0x2d, 0x03, 0xb0, 0x01, 0xe8, 0x08, 0xd6, 0xe8,
	0x11, 0xd3, 0xbb, 0x17, 0x61, 0xe8, 0x9d, 0xcd,
	0xc7, 0x06, 0xaf, 0x64, 0xe6, 0x00, 0xc7, 0x06,
	0xb1, 0x64, 0xb8, 0x00, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x2e, 0x03, 0xc7, 0x06, 0xf3, 0xb4, 0x06,
	0x00, 0xe8, 0xd1, 0x68, 0xe8, 0x0f, 0xd3, 0xbb,
	0x6a, 0x62, 0xe8, 0x78, 0xcd, 0xb9, 0x04, 0x00,
	0xb0, 0x0e, 0xb4, 0x0e, 0xe8, 0xa6, 0x65, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0x2f, 0x03, 0xb0, 0x01,
	0xe8, 0xbd, 0xd5, 0xe8, 0x82, 0xfb, 0xc6, 0x47,
	0x01, 0x00, 0xe8, 0x07, 0x6a, 0xe8, 0x2e, 0x66,
	0xbb, 0xdc, 0x62, 0xe8, 0x4f, 0xcd, 0xc6, 0x06,
	0xdf, 0xdb, 0x01, 0xb9, 0x05, 0x00, 0xe8, 0xca,
	0x6c, 0xc3, 0x80, 0x3e, 0xdf, 0xdb, 0x00, 0x75,
	0x0d, 0xb9, 0xc8, 0x03, 0xe8, 0x8f, 0xd6, 0xbb,
	0x11, 0x55, 0xe8, 0xc0, 0x5b, 0xc3, 0xb9, 0x50,
	0x00, 0xb0, 0x03, 0xb4, 0x0c, 0xe8, 0x5d, 0x65,
	0xb9, 0x4f, 0x00, 0xb0, 0x04, 0xe8, 0x5e, 0x65,
	0xb9, 0xc8, 0x03, 0xe8, 0x51, 0xd6, 0xe8, 0xe2,
	0x66, 0xc7, 0x06, 0xf3, 0xb4, 0x06, 0x00, 0xb8,
	0x18, 0x01, 0xbb, 0xba, 0x00, 0xbf, 0x09, 0x01,
	0xbe, 0xb4, 0x00, 0xb1, 0x01, 0xb5, 0x04, 0xe8,
	0x19, 0x67, 0xc3, 0x80, 0x3e, 0xe5, 0xdb, 0x01,
	0x75, 0x07, 0xbb, 0xc0, 0x57, 0xe8, 0x7d, 0x5b,
	0xc3, 0xb9, 0x31, 0x00, 0xb0, 0x0e, 0xb4, 0x07,
	0xe8, 0x1a, 0x65, 0xb9, 0x05, 0x00, 0xb0, 0x15,
	0xe8, 0x1b, 0x65, 0xb9, 0x65, 0x03, 0xe8, 0x2d,
	0xd6, 0xb0, 0x58, 0xe8, 0x42, 0xe2, 0xc6, 0x06,
	0xe5, 0xdb, 0x01, 0xc3, 0xb9, 0x35, 0x00, 0xb0,
	0x14, 0xb4, 0x05, 0xe8, 0xf7, 0x64, 0xb9, 0x18,
	0x00, 0xb0, 0x1b, 0xb4, 0x0e, 0xe8, 0xf6, 0x64,
	0xb9, 0x05, 0x00, 0xb0, 0x24, 0xe8, 0xf5, 0x64,
	0xb9, 0x47, 0x03, 0xe8, 0xe1, 0xd5, 0xc7, 0x06,
	0xaf, 0x64, 0x16, 0x01, 0xe8, 0x05, 0xd6, 0xb0,
	0x50, 0xe8, 0x0c, 0xe2, 0xb0, 0x01, 0xe8, 0xb4,
	0xd4, 0xc3, 0xbb, 0xe3, 0x58, 0xe8, 0x1d, 0x5b,
	0xc3, 0x80, 0x3e, 0xdd, 0xdb, 0x02, 0x74, 0x7f,
	0xbb, 0x5c, 0xdb, 0xe8, 0x67, 0xcc, 0x53, 0xe8,
	0x7b, 0xcc, 0x5b, 0x81, 0xfb, 0x6b, 0x63, 0x75,
	0x6d, 0xe8, 0x01, 0xda, 0xb9, 0x34, 0x00, 0xb0,
	0x08, 0xb4, 0x0c, 0xe8, 0x9f, 0x64, 0xb0, 0x0d,
	0xe8, 0xa3, 0x64, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0x34, 0x03, 0xb0, 0x01, 0xe8, 0xb1, 0xd4, 0xe8,
	0x76, 0xfa, 0xc6, 0x47, 0x03, 0x59, 0xe8, 0xfb,
	0x68, 0xe8, 0x22, 0x65, 0xc6, 0x06, 0x33, 0x33,
	0x01, 0xc6, 0x06, 0xdd, 0x1c, 0x02, 0xe8, 0xc5,
	0xd9, 0x8b, 0x36, 0xaf, 0x64, 0x8b, 0x3e, 0xb1,
	0x64, 0x56, 0x57, 0xc6, 0x06, 0xc3, 0x64, 0x03,
	0xe8, 0x90, 0xf0, 0xe8, 0xb7, 0xd9, 0xe8, 0xad,
	0xd9, 0x5f, 0x5e, 0xc6, 0x06, 0xc3, 0x64, 0x02,
	0xe8, 0x80, 0xf0, 0xe8, 0xa7, 0xd9, 0xbb, 0x1f,
	0x55, 0xe8, 0xa1, 0x5a, 0xb0, 0x04, 0xe8, 0x20,
	0xd4, 0xc6, 0x06, 0xdc, 0xdb, 0x01, 0xc3, 0xbb,
	0xc0, 0x55, 0xe8, 0x90, 0x5a, 0xbe, 0x32, 0x01,
	0xbf, 0xc4, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x02,
	0xe8, 0x58, 0xf0, 0xe8, 0x78, 0xd9, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0x39, 0x03, 0xb0, 0x01, 0xe8,
	0x45, 0xd4, 0xe8, 0x07, 0x65, 0xe8, 0x66, 0xd9,
	0xb9, 0x47, 0x00, 0xb0, 0x04, 0xb4, 0x0e, 0xe8,
	0x0b, 0x64, 0xb9, 0x37, 0x03, 0xe8, 0x1f, 0xd5,
	0xb9, 0x4a, 0x00, 0xb0, 0x01, 0xb4, 0x0a, 0xe8,
	0xfb, 0x63, 0xb0, 0x03, 0xe8, 0xff, 0x63, 0xb0,
	0x06, 0xe8, 0x01, 0x64, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x3a, 0x03, 0xc7, 0x06, 0xf3, 0xb4, 0x05,
	0x00, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x3a, 0x03,
	0xe8, 0xe9, 0x66, 0xb0, 0x01, 0xe8, 0x3a, 0xd4,
	0xe8, 0x73, 0x64, 0xc7, 0x06, 0xf3, 0xb4, 0x06,
	0x00, 0xe8, 0xb4, 0xf9, 0xc6, 0x47, 0x03, 0x5b,
	0xe8, 0xda, 0x66, 0x8b, 0x36, 0xaf, 0x64, 0x8b,
	0x3e, 0xb1, 0x64, 0xc6, 0x06, 0xc3, 0x64, 0x01,
	0xe8, 0xe0, 0xef, 0xe8, 0x00, 0xd9, 0xbb, 0xdb,
	0x55, 0xe8, 0x01, 0x5a, 0xc6, 0x06, 0xdd, 0xdb,
	0x03, 0xb0, 0x04, 0xbe, 0xc7, 0x78, 0xe8, 0x90,
	0xd3, 0xc3, 0x80, 0x3e, 0xdd, 0xdb, 0x03, 0x74,
	0x07, 0xbb, 0x05, 0x59, 0xe8, 0xe6, 0x59, 0xc3,
	0x80, 0x3e, 0xde, 0xdb, 0x01, 0x74, 0x31, 0xbe,
	0x18, 0x01, 0xbf, 0xb3, 0x00, 0xc6, 0x06, 0xc3,
	0x64, 0x02, 0xe8, 0xa6, 0xef, 0xb9, 0x31, 0x00,
	0xb0, 0x07, 0xb4, 0x0c, 0xe8, 0x6e, 0x63, 0xb9,
	0x05, 0x00, 0xb0, 0x11, 0xe8, 0x6f, 0x63, 0xb9,
	0x3b, 0x03, 0xe8, 0x73, 0xd4, 0xb0, 0x4d, 0xe8,
	0x96, 0xe0, 0xc6, 0x06, 0xde, 0xdb, 0x01, 0xc3,
	0xbb, 0x08, 0x56, 0xe8, 0xa7, 0x59, 0xc3, 0x80,
	0x3e, 0xdc, 0xdb, 0x01, 0x74, 0x07, 0xbb, 0x28,
	0x55, 0xe8, 0x99, 0x59, 0xc3, 0xe8, 0x97, 0xd4,
	0xbb, 0x5d, 0x55, 0xe8, 0x8f, 0x59, 0xe8, 0x1f,
	0xf9, 0xc6, 0x47, 0x02, 0x00, 0xe8, 0xa4, 0x67,
	0xb9, 0x35, 0x03, 0xe8, 0x1c, 0xd4, 0xe8, 0x0f,
	0xf9, 0xc6, 0x47, 0x02, 0x5a, 0xc6, 0x47, 0x03,
	0x00, 0xe8, 0x4c, 0x67, 0xb9, 0x16, 0x00, 0xb0,
	0x02, 0xb4, 0x0b, 0xe8, 0x0f, 0x63, 0xb9, 0x36,
	0x03, 0xe8, 0x23, 0xd4, 0xbb, 0x77, 0x55, 0xe8,
	0x5b, 0x59, 0xb0, 0x05, 0xe8, 0xe6, 0xd2, 0xc6,
	0x06, 0xdd, 0xdb, 0x01, 0xc3, 0xe8, 0x4f, 0xd4,
	0xe8, 0x43, 0xd8, 0xbe, 0x90, 0x00, 0xbf, 0xb9,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x04, 0xe8, 0x12,
	0xef, 0xe8, 0xcc, 0xf8, 0xc6, 0x07, 0x56, 0xe8,
	0x52, 0x67, 0xb9, 0x38, 0x00, 0xb0, 0x0f, 0xb4,
	0x07, 0xe8, 0xd1, 0x62, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x31, 0x03, 0xb9, 0x30, 0x03, 0xe8, 0xc9,
	0xd3, 0xe8, 0xac, 0xf8, 0xc6, 0x07, 0x57, 0xe8,
	0xee, 0x66, 0xb9, 0x22, 0x00, 0xb0, 0x01, 0xb4,
	0x08, 0xe8, 0xb1, 0x62, 0xb9, 0x05, 0x00, 0xb0,
	0x0f, 0xe8, 0xb2, 0x62, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x33, 0x03, 0xb9, 0x32, 0x03, 0xe8, 0xa1,
	0xd3, 0xe8, 0x84, 0xf8, 0xc6, 0x47, 0x02, 0x58,
	0xe8, 0xc5, 0x66, 0xc7, 0x06, 0xaf, 0x64, 0xa0,
	0x00, 0xc7, 0x06, 0xb1, 0x64, 0xbc, 0x00, 0xc6,
	0x06, 0xcc, 0x64, 0x01, 0xc6, 0x06, 0xdc, 0x64,
	0x00, 0xe8, 0xa8, 0xd3, 0xb0, 0x06, 0xe8, 0x5c,
	0xd2, 0xb0, 0x05, 0xe8, 0x4b, 0xd2, 0xb0, 0x4c,
	0xe8, 0xa5, 0xdf, 0xc3, 0x80, 0x3e, 0xdf, 0xdb,
	0x02, 0x73, 0x07, 0xbb, 0x2f, 0x59, 0xe8, 0xb4,
	0x58, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x05, 0x00,
	0xb8, 0x1f, 0x01, 0xbb, 0x8f, 0x00, 0xbf, 0x22,
	0x01, 0xbe, 0x8f, 0x00, 0xb1, 0x01, 0xb5, 0x02,
	0xe8, 0x28, 0x64, 0xc3, 0xb9, 0x4f, 0x00, 0xb0,
	0x05, 0xb4, 0x0b, 0xe8, 0x37, 0x62, 0xb9, 0x01,
	0x00, 0xb0, 0x0e, 0xe8, 0x38, 0x62, 0xb9, 0xc6,
	0x03, 0xe8, 0x3c, 0xd3, 0xbb, 0x55, 0x59, 0xe8,
	0x7b, 0x58, 0xc3, 0x80, 0x3e, 0xdf, 0xdb, 0x01,
	0x74, 0x07, 0xbb, 0xf6, 0x52, 0xe8, 0x6d, 0x58,
	0xc3, 0xb9, 0x47, 0x00, 0xb0, 0x04, 0xb4, 0x0e,
	0xe8, 0x0a, 0x62, 0xb9, 0x37, 0x03, 0xe8, 0x17,
	0xd3, 0x80, 0x3e, 0xdd, 0xdb, 0x00, 0x75, 0x07,
	0xbb, 0x80, 0x4d, 0xe8, 0x4f, 0x58, 0xc3, 0xb9,
	0x4a, 0x00, 0xb0, 0x01, 0xb4, 0x0e, 0xe8, 0xec,
	0x61, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x38, 0x03,
	0xb0, 0x01, 0xe8, 0x03, 0xd2, 0xe8, 0x7e, 0x62,
	0x80, 0x3e, 0xdd, 0xdb, 0x01, 0x75, 0x0e, 0xe8,
	0x2b, 0xd7, 0xbb, 0x9a, 0x55, 0xe8, 0x25, 0x58,
	0xc6, 0x06, 0xdd, 0xdb, 0x02, 0xc3, 0xe8, 0x9d,
	0x5c, 0xc3, 0xbb, 0x82, 0xdb, 0xe8, 0x6d, 0xc9,
	0xe8, 0x82, 0xc9, 0xc3, 0xb9, 0x50, 0x00, 0xb0,
	0x04, 0xb4, 0x02, 0xe8, 0xaf, 0x61, 0xb9, 0xc3,
	0x03, 0xe8, 0xab, 0xd2, 0xe8, 0x3c, 0x63, 0xc7,
	0x06, 0xf3, 0xb4, 0x05, 0x00, 0xb8, 0xa6, 0x00,
	0xbb, 0x9e, 0x00, 0xbf, 0xa6, 0x00, 0xbe, 0xa1,
	0x00, 0xb1, 0x0b, 0xb5, 0x03, 0xe8, 0x73, 0x63,
	0xc3, 0xb9, 0xc5, 0x03, 0xe8, 0x99, 0xd2, 0xbb,
	0x11, 0x55, 0xe8, 0xd8, 0x57, 0xc3, 0xbb, 0x62,
	0x59, 0xe8, 0xd1, 0x57, 0xc3, 0xbb, 0x9d, 0x59,
	0xe8, 0xca, 0x57, 0xc3, 0xbb, 0xb6, 0x59, 0xe8,
	0xc3, 0x57, 0xc3, 0x80, 0x3e, 0xe6, 0xdb, 0x01,
	0x75, 0x2d, 0xc6, 0x06, 0xe6, 0xdb, 0x02, 0xe8,
	0xb5, 0xd2, 0xe8, 0x43, 0xf7, 0xc6, 0x47, 0x01,
	0x67, 0xe8, 0xc8, 0x65, 0xb9, 0x05, 0x00, 0xb0,
	0x09, 0xb4, 0x09, 0xe8, 0x47, 0x61, 0xb9, 0x68,
	0x03, 0xe8, 0x5b, 0xd2, 0xb0, 0x5a, 0xe8, 0x77,
	0xde, 0xb0, 0x07, 0xe8, 0x1f, 0xd1, 0xc3, 0xb9,
	0xc4, 0x03, 0xe8, 0x43, 0xd2, 0xbb, 0x11, 0x55,
	0xe8, 0x82, 0x57, 0xc3, 0xbb, 0xdb, 0x59, 0xe8,
	0x7b, 0x57, 0xc3, 0xbb, 0x01, 0x5a, 0xe8, 0x74,
	0x57, 0xc3, 0xe8, 0xf1, 0x5b, 0xc3, 0xe8, 0xed,
	0x5b, 0xc3, 0xe8, 0x6a, 0xd2, 0xe8, 0xf8, 0xf6,
	0xc6, 0x07, 0x00, 0xe8, 0x7e, 0x65, 0xb9, 0x05,
	0x00, 0xb0, 0x09, 0xb4, 0x07, 0xe8, 0xfd, 0x60,
	0xb9, 0x44, 0x03, 0xe8, 0x11, 0xd2, 0xb0, 0x4f,
	0xe8, 0x2d, 0xde, 0xb0, 0x0c, 0xe8, 0xd5, 0xd0,
	0xc3, 0xbb, 0x20, 0x5a, 0xe8, 0x3e, 0x57, 0xc3,
	0x80, 0x3e, 0xe7, 0xdb, 0x01, 0x74, 0x03, 0xe9,
	0x83, 0x00, 0xbe, 0x8c, 0x00, 0xbf, 0x98, 0x00,
	0xc6, 0x06, 0xc3, 0x64, 0x01, 0xe8, 0xfb, 0xec,
	0x80, 0x3e, 0xe8, 0xdb, 0x01, 0x74, 0x07, 0xbb,
	0x55, 0x58, 0xe8, 0x18, 0x57, 0xc3, 0xbb, 0x20,
	0x6f, 0xe8, 0x81, 0xc8, 0xc6, 0x06, 0xe6, 0x1c,
	0xef, 0xbe, 0xe0, 0x53, 0xbb, 0x83, 0x58, 0xe8,
	0xac, 0x59, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x72,
	0x03, 0xb0, 0x01, 0xe8, 0xc2, 0xd0, 0xe8, 0x87,
	0xf6, 0xc6, 0x47, 0x02, 0x00, 0xe8, 0x0c, 0x65,
	0xb9, 0x4b, 0x00, 0xb0, 0x0a, 0xb4, 0x0a, 0xe8,
	0x8b, 0x60, 0xb9, 0x18, 0x00, 0xb0, 0x0f, 0xe8,
	0x8c, 0x60, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x73,
	0x03, 0xb0, 0x01, 0xe8, 0x9a, 0xd0, 0xe8, 0x63,
	0x61, 0xe8, 0x87, 0x00, 0xb8, 0x01, 0x00, 0xe8,
	0xe7, 0xe4, 0xe8, 0xfb, 0xe4, 0xb0, 0x02, 0xe8,
	0x4b, 0xd0, 0xb0, 0x01, 0xe8, 0x46, 0xd0, 0xc6,
	0x06, 0xe9, 0xdb, 0x01, 0xc3, 0xe8, 0x68, 0xcd,
	0x80, 0x3e, 0xdf, 0xdb, 0x03, 0x74, 0x0a, 0xbb,
	0x68, 0xdb, 0xe8, 0xf8, 0xc7, 0xe8, 0x0d, 0xc8,
	0xc3, 0x80, 0x3e, 0xe3, 0xdb, 0x01, 0x75, 0x07,
	0xbb, 0xd6, 0x6b, 0xe8, 0xff, 0xc7, 0xc3, 0xbb,
	0xb5, 0x69, 0xe8, 0xf8, 0xc7, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x5a, 0x03, 0xb9, 0x5b, 0x03, 0xe8,
	0x18, 0xd1, 0xe8, 0xc1, 0x60, 0xb9, 0x4b, 0x00,
	0xb0, 0x06, 0xb4, 0x08, 0xe8, 0x16, 0x60, 0xb0,
	0x0a, 0xe8, 0x1a, 0x60, 0xb9, 0x05, 0x00, 0xb0,
	0x0f, 0xe8, 0x19, 0x60, 0xb9, 0x5c, 0x03, 0xe8,
	0x1d, 0xd1, 0xe8, 0x13, 0xcd, 0xbb, 0xc2, 0x69,
	0xe8, 0xc2, 0xc7, 0xb0, 0x55, 0xe8, 0x30, 0xdd,
	0xc6, 0x06, 0xe3, 0xdb, 0x01, 0xc6, 0x06, 0xf0,
	0xdb, 0x00, 0xc3, 0xe8, 0x00, 0x00, 0x1e, 0x06,
	0xa1, 0xb1, 0x32, 0x8e, 0xd8, 0xb8, 0x00, 0xa0,
	0x8e, 0xc0, 0xfc, 0xe8, 0xea, 0x5c, 0xe8, 0xe7,
	0x5c, 0xbe, 0x00, 0x0a, 0x33, 0xff, 0xb9, 0x00,
	0x78, 0xf3, 0xa5, 0xe8, 0xda, 0x5c, 0xe8, 0xd7,
	0x5c, 0x33, 0xf6, 0x33, 0xff, 0xb9, 0x00, 0x7d,
	0xf3, 0xa5, 0xe8, 0xcb, 0x5c, 0xe8, 0xc8, 0x5c,
	0xbe, 0x00, 0x05, 0x33, 0xff, 0xb9, 0x80, 0x7a,
	0xf3, 0xa5, 0xe8, 0xbb, 0x5c, 0xe8, 0xb8, 0x5c,
	0x33, 0xf6, 0x33, 0xff, 0xb9, 0x00, 0x7d, 0xf3,
	0xa5, 0x07, 0x1f, 0xc3, 0x80, 0x3e, 0xf0, 0xdb,
	0x01, 0x75, 0x07, 0xbb, 0x25, 0x5e, 0xe8, 0xe4,
	0x55, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x05, 0x00,
	0xb8, 0x23, 0x00, 0xbb, 0xa2, 0x00, 0xbf, 0x23,
	0x00, 0xbe, 0xae, 0x00, 0xb1, 0x0b, 0xb5, 0x03,
	0xe8, 0x58, 0x61, 0xc3, 0x80, 0x3e, 0xe9, 0xdb,
	0x01, 0x75, 0x3f, 0xb9, 0x59, 0x00, 0xb0, 0x05,
	0xb4, 0x02, 0xe8, 0x60, 0x5f, 0xb9, 0xbe, 0x03,
	0xe8, 0x4c, 0xd0, 0xe8, 0xed, 0x60, 0xc6, 0x06,
	0xcc, 0x64, 0x00, 0xc6, 0x06, 0xdc, 0x64, 0x01,
	0xc6, 0x06, 0xcb, 0x64, 0x00, 0xe8, 0xc1, 0xf3,
	0xc7, 0x06, 0xf3, 0xb4, 0x09, 0x00, 0xb8, 0xf0,
	0x00, 0xbb, 0xb6, 0x00, 0xbf, 0xe0, 0x00, 0xbe,
	0xb6, 0x00, 0xb1, 0x01, 0xb5, 0x04, 0xe8, 0x12,
	0x61, 0xc3, 0x80, 0x3e, 0xe7, 0xdb, 0x01, 0x74,
	0x0d, 0xe8, 0x34, 0xcc, 0xbb, 0x8a, 0xdb, 0xe8,
	0xcb, 0xc6, 0xe8, 0xe0, 0xc6, 0xc3, 0xbb, 0x94,
	0x58, 0xe8, 0x69, 0x55, 0xc3, 0xbb, 0x1e, 0x43,
	0xe8, 0x62, 0x55, 0xc3, 0xe8, 0x60, 0xd0, 0xe8,
	0xee, 0xf4, 0xc6, 0x07, 0x00, 0xe8, 0x74, 0x63,
	0xb9, 0x31, 0x00, 0xb0, 0x06, 0xb4, 0x0b, 0xe8,
	0xf3, 0x5e, 0xb9, 0x05, 0x00, 0xb0, 0x0d, 0xe8,
	0xf4, 0x5e, 0xb9, 0x5d, 0x03, 0xe8, 0xff, 0xcf,
	0xb0, 0x57, 0xe8, 0x1b, 0xdc, 0xb0, 0x06, 0xe8,
	0xc3, 0xce, 0xc3, 0xe8, 0xb0, 0x59, 0xc3, 0xbb,
	0x51, 0x5a, 0xe8, 0x28, 0x55, 0xc3, 0xbb, 0x98,
	0x5a, 0xe8, 0x21, 0x55, 0xc3, 0xb9, 0x0f, 0x00,
	0xb0, 0x07, 0xb4, 0x04, 0xe8, 0xbe, 0x5e, 0xb9,
	0x74, 0x03, 0xe8, 0xcb, 0xcf, 0xb9, 0x37, 0x00,
	0xb0, 0x01, 0xb4, 0x04, 0xe8, 0xae, 0x5e, 0xb9,
	0x18, 0x00, 0xb0, 0x0c, 0xe8, 0xaf, 0x5e, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0x75, 0x03, 0xb0, 0x01,
	0xe8, 0xbd, 0xce, 0xc6, 0x06, 0x45, 0x33, 0xd0,
	0xb0, 0x01, 0xbe, 0x76, 0x03, 0xbb, 0xe5, 0x67,
	0xe8, 0x84, 0xca, 0xc7, 0x06, 0xaf, 0x64, 0xc6,
	0x00, 0xc7, 0x06, 0xb1, 0x64, 0xba, 0x00, 0xc6,
	0x06, 0xcd, 0x64, 0x00, 0xc6, 0x06, 0xdc, 0x64,
	0x00, 0xc6, 0x06, 0xcb, 0x64, 0x01, 0xe8, 0xe8,
	0xf2, 0xb9, 0x03, 0x00, 0xe8, 0xb4, 0x65, 0xe8,
	0xab, 0x50, 0xe8, 0x2e, 0xba, 0xb8, 0x64, 0x00,
	0xe8, 0xb9, 0xd3, 0xc7, 0x06, 0xf3, 0xb4, 0x28,
	0x00, 0xe8, 0x69, 0x61, 0xe8, 0x28, 0xcb, 0xbb,
	0x20, 0x7f, 0xe8, 0x10, 0xc6, 0xe8, 0xc6, 0xdb,
	0xb0, 0x1d, 0xe8, 0x7b, 0xdb, 0xbb, 0x5c, 0xe4,
	0xe8, 0x1b, 0xba, 0xb9, 0x06, 0x00, 0xe8, 0x82,
	0x65, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xbc, 0x03,
	0xc7, 0x06, 0xf3, 0xb4, 0x01, 0x00, 0xe8, 0x33,
	0x61, 0xb0, 0x01, 0xe8, 0x84, 0xce, 0xc6, 0x06,
	0x45, 0x33, 0xd1, 0xb0, 0x01, 0xbe, 0xbd, 0x03,
	0xbb, 0xc4, 0x8b, 0xe8, 0x09, 0xca, 0xe8, 0xad,
	0x5e, 0xe8, 0x60, 0x0c, 0xc3, 0xb9, 0xbf, 0x03,
	0xe8, 0xf4, 0xce, 0xe8, 0x95, 0x5f, 0xc7, 0x06,
	0xf3, 0xb4, 0x08, 0x00, 0xb8, 0x28, 0x00, 0xbb,
	0x98, 0x00, 0xbf, 0x28, 0x00, 0xbe, 0x9b, 0x00,
	0xb1, 0x0b, 0xb5, 0x03, 0xe8, 0xcc, 0x5f, 0xc3,
	0xe8, 0xbb, 0x58, 0xc3, 0xb9, 0xc0, 0x03, 0xe8,
	0xee, 0xce, 0xbb, 0x11, 0x55, 0xe8, 0x2d, 0x54,
	0xc3, 0xbb, 0xc6, 0x5a, 0xe8, 0x26, 0x54, 0xc3,
	0xbb, 0xed, 0x5a, 0xe8, 0x1f, 0x54, 0xc3, 0xbb,
	0xed, 0x5a, 0xe8, 0x18, 0x54, 0xc3, 0xb9, 0x20,
	0x00, 0xb0, 0x18, 0xb4, 0x05, 0xe8, 0xb5, 0x5d,
	0xb9, 0x5e, 0x03, 0xe8, 0xa1, 0xce, 0xe8, 0x42,
	0x5f, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x5f, 0x03,
	0xb0, 0x01, 0xe8, 0xca, 0xcd, 0xe8, 0x8c, 0x5e,
	0xb0, 0x54, 0xe8, 0xd3, 0xda, 0xb0, 0x01, 0xe8,
	0x7b, 0xcd, 0xc6, 0x06, 0xe2, 0xdb, 0x02, 0xc3,
	0x80, 0x3e, 0xe2, 0xdb, 0x00, 0x74, 0x10, 0xbb,
	0x22, 0x57, 0xe8, 0xd8, 0x53, 0xe8, 0xd5, 0xd2,
	0xbb, 0x2a, 0x57, 0xe8, 0xcf, 0x53, 0xc3, 0xe8,
	0x10, 0xcb, 0x80, 0x3e, 0xda, 0xdb, 0x01, 0x74,
	0x0a, 0xbb, 0x40, 0xdb, 0xe8, 0x16, 0xc5, 0xe8,
	0x2b, 0xc5, 0xc3, 0xbb, 0x4c, 0xdb, 0xe8, 0x0c,
	0xc5, 0xe8, 0x21, 0xc5, 0xc3, 0xbb, 0x27, 0x5b,
	0xe8, 0xaa, 0x53, 0xc3, 0x80, 0x3e, 0xda, 0xdb,
	0x01, 0x75, 0x1a, 0xc7, 0x06, 0xf3, 0xb4, 0x05,
	0x00, 0xb8, 0x78, 0x00, 0xbb, 0xc7, 0x00, 0xbf,
	0x80, 0x00, 0xbe, 0xb0, 0x00, 0xb1, 0x13, 0xb5,
	0x01, 0xe8, 0x17, 0x5f, 0xc3, 0xe8, 0xca, 0xca,
	0xbb, 0xe9, 0x5f, 0xe8, 0xef, 0xc4, 0xbe, 0x0d,
	0x01, 0xbf, 0xaf, 0x00, 0xc6, 0x06, 0xc3, 0x64,
	0x04, 0xe8, 0x47, 0xe9, 0xe8, 0xb3, 0xca, 0xbb,
	0x56, 0xdb, 0xe8, 0xc0, 0xc4, 0xe8, 0xd5, 0xc4,
	0xc3, 0xe8, 0x32, 0xcb, 0xbb, 0xa6, 0xda, 0xe8,
	0xb3, 0xc4, 0x53, 0xe8, 0xc7, 0xc4, 0x5b, 0x81,
	0xfb, 0xb4, 0x01, 0x75, 0x50, 0x8b, 0x3e, 0xb1,
	0x64, 0x8b, 0x36, 0xaf, 0x64, 0x57, 0x56, 0xbf,
	0x9f, 0x00, 0xbe, 0xbd, 0x00, 0xe8, 0x13, 0xe9,
	0xb8, 0x01, 0x01, 0xe8, 0xf0, 0xd1, 0xb9, 0x05,
	0x00, 0xb0, 0x02, 0xb4, 0x0a, 0xe8, 0xd5, 0x5c,
	0xb0, 0x13, 0xe8, 0xd9, 0x5c, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x27, 0x02, 0xb9, 0x26, 0x02, 0xe8,
	0xd6, 0xcd, 0x5e, 0x5f, 0xc6, 0x06, 0xc3, 0x64,
	0x02, 0xe8, 0xe7, 0xe8, 0xb0, 0x13, 0xe8, 0xef,
	0xd9, 0xe8, 0xda, 0xca, 0xbb, 0xa6, 0xda, 0xe8,
	0x5b, 0xc4, 0xe8, 0x70, 0xc4, 0xc3, 0xe8, 0xfe,
	0xcd, 0xb0, 0x10, 0xe8, 0xda, 0xd9, 0xb0, 0x02,
	0xe8, 0x82, 0xcc, 0xe8, 0x82, 0xf2, 0xc6, 0x07,
	0x00, 0xe8, 0x08, 0x61, 0xb9, 0x05, 0x00, 0xb0,
	0x0c, 0xb4, 0x06, 0xe8, 0x87, 0x5c, 0xb9, 0x23,
	0x02, 0xe8, 0x9b, 0xcd, 0xc3, 0xe8, 0x56, 0x57,
	0xc3, 0xe8, 0x52, 0x57, 0xc3, 0xe8, 0x4e, 0x57,
	0xc3, 0xbb, 0xd6, 0x3e, 0xe8, 0xc6, 0x52, 0xc3,
	0xe8, 0x43, 0x57, 0xc3, 0xe8, 0x1d, 0xcb, 0xbb,
	0xbd, 0x33, 0xe8, 0x28, 0xc4, 0xc6, 0x06, 0xe6,
	0x1c, 0xd0, 0xbe, 0xe4, 0x61, 0xbb, 0xae, 0x49,
	0xe8, 0xd5, 0x54, 0xb9, 0x05, 0x00, 0xb0, 0x03,
	0xb4, 0x07, 0xe8, 0x48, 0x5c, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0x9b, 0x02, 0xb0, 0x02, 0xe8,
	0x5e, 0xcc, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0x9c, 0x02, 0xb0, 0x02, 0xe8, 0x51, 0xcc, 0xe8,
	0xcc, 0x5c, 0xc6, 0x06, 0x33, 0x33, 0x01, 0xc6,
	0x06, 0xdd, 0x1c, 0x02, 0xc6, 0x06, 0xdb, 0x1c,
	0x01, 0xe8, 0x04, 0xf2, 0xc6, 0x47, 0x02, 0x32,
	0xe8, 0x89, 0x60, 0xc7, 0x06, 0x30, 0x32, 0x78,
	0x00, 0xc7, 0x06, 0x2e, 0x32, 0x5a, 0x00, 0xc7,
	0x06, 0x2c, 0x32, 0xae, 0x00, 0xe8, 0x76, 0xda,
	0xe8, 0xbd, 0x5a, 0xe8, 0xae, 0xca, 0xbb, 0xc7,
	0x36, 0xe8, 0xb9, 0xc3, 0xb9, 0x52, 0x00, 0xb0,
	0x13, 0xb4, 0x0e, 0xe8, 0xe7, 0x5b, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x02, 0x9d, 0x02, 0xb0, 0x02,
	0xe8, 0x3f, 0xcc, 0xe8, 0xc2, 0xf1, 0xc6, 0x47,
	0x03, 0x00, 0xe8, 0x75, 0x60, 0xc7, 0x06, 0xec,
	0xdb, 0x00, 0x00, 0xe8, 0x68, 0x5c, 0xbb, 0x79,
	0x37, 0xe8, 0x89, 0xc3, 0xb0, 0x0f, 0xe8, 0x98,
	0xcb, 0xb0, 0x08, 0xe8, 0x9f, 0xcb, 0xc3, 0xc7,
	0x06, 0xf3, 0xb4, 0x0d, 0x00, 0xb8, 0x00, 0x00,
	0xbb, 0xac, 0x00, 0xbf, 0x12, 0x00, 0xbe, 0xad,
	0x00, 0xb1, 0x01, 0xb5, 0x02, 0xe8, 0x83, 0x5d,
	0xc3, 0xc6, 0x06, 0xdc, 0x64, 0x01, 0xc6, 0x06,
	0xcb, 0x64, 0x00, 0xc7, 0x06, 0xf3, 0xb4, 0x0e,
	0x00, 0xb8, 0x18, 0x01, 0xbb, 0xc6, 0x00, 0xbf,
	0xe3, 0x00, 0xbe, 0xb8, 0x00, 0xb1, 0x01, 0xb5,
	0x04, 0xe8, 0x5f, 0x5d, 0xc3, 0xc7, 0x06, 0xf3,
	0xb4, 0x0f, 0x00, 0xb8, 0x3f, 0x01, 0xbb, 0xa2,
	0x00, 0xbf, 0x06, 0x01, 0xbe, 0xb0, 0x00, 0xb1,
	0x01, 0xb5, 0x04, 0xe8, 0x45, 0x5d, 0xc3, 0xc7,
	0x06, 0xf3, 0xb4, 0x0c, 0x00, 0xb8, 0x3f, 0x01,
	0xbb, 0x98, 0x00, 0xbf, 0x2d, 0x01, 0xbe, 0xaf,
	0x00, 0xb1, 0x01, 0xb5, 0x04, 0xe8, 0x2b, 0x5d,
	0xc3, 0xe8, 0x9b, 0xcc, 0xb9, 0x05, 0x00, 0xb0,
	0x0c, 0xb4, 0x09, 0xe8, 0x37, 0x5b, 0xb0, 0x12,
	0xe8, 0x6d, 0xd8, 0xb0, 0x0d, 0xe8, 0x15, 0xcb,
	0xe8, 0x15, 0xf1, 0xc6, 0x47, 0x01, 0x00, 0xe8,
	0x9a, 0x5f, 0xb9, 0x25, 0x02, 0xe8, 0x37, 0xcc,
	0xc3, 0xe8, 0xf2, 0x55, 0xc3, 0xe8, 0x6f, 0xcc,
	0xe8, 0xfd, 0xf0, 0xc6, 0x47, 0x02, 0x00, 0xe8,
	0x82, 0x5f, 0xb9, 0x05, 0x00, 0xb0, 0x0c, 0xb4,
	0x07, 0xe8, 0x01, 0x5b, 0xb9, 0xa4, 0x02, 0xe8,
	0x15, 0xcc, 0xbb, 0xb0, 0x4a, 0xe8, 0x4d, 0x51,
	0xb0, 0x0f, 0xe8, 0xd8, 0xca, 0xb0, 0x33, 0xe8,
	0x26, 0xd8, 0xc3, 0xc3, 0xbb, 0x0f, 0x37, 0x80,
	0x3e, 0xa1, 0xdb, 0x01, 0x74, 0x03, 0xbb, 0xc2,
	0x36, 0xe8, 0x31, 0x51, 0xc3, 0xb9, 0xc7, 0x03,
	0xe8, 0xe5, 0xcb, 0xbb, 0x42, 0x35, 0xe8, 0x24,
	0x51, 0xc3, 0x80, 0x3e, 0xa1, 0xdb, 0x01, 0x74,
	0x53, 0xb9, 0x38, 0x00, 0xb0, 0x08, 0xb4, 0x0e,
	0xe8, 0xba, 0x5a, 0xb0, 0x0c, 0xe8, 0xc5, 0x5a,
	0xb9, 0x31, 0x00, 0xb0, 0x0a, 0xe8, 0xb6, 0x5a,
	0xc6, 0x06, 0x35, 0x33, 0x10, 0xc6, 0x06, 0x36,
	0x33, 0x18, 0xb8, 0x52, 0x46, 0xa3, 0x37, 0x33,
	0xb8, 0x5b, 0x7b, 0xa3, 0x39, 0x33, 0xe8, 0xee,
	0xcb, 0xb9, 0x4b, 0x02, 0xe8, 0x00, 0xcc, 0xe8,
	0xba, 0xcb, 0x8b, 0x36, 0xaf, 0x64, 0x8b, 0x3e,
	0xb1, 0x64, 0xc6, 0x06, 0xc3, 0x64, 0x02, 0xe8,
	0xa9, 0xe6, 0xe8, 0xd0, 0xcf, 0xbb, 0x68, 0x36,
	0xe8, 0xca, 0x50, 0xc3, 0x80, 0x3e, 0xa2, 0xdb,
	0x01, 0x74, 0x73, 0xb9, 0x1a, 0x00, 0xb0, 0x0d,
	0xb4, 0x0c, 0xe8, 0x60, 0x5a, 0xb0, 0x0f, 0xe8,
	0x64, 0x5a, 0xb0, 0x17, 0xe8, 0x66, 0x5a, 0xb0,
	0x19, 0xe8, 0x68, 0x5a, 0xb0, 0x20, 0xe8, 0x6a,
	0x5a, 0xb0, 0x22, 0xe8, 0x6c, 0x5a, 0xb0, 0x24,
	0xe8, 0x6e, 0x5a, 0xb9, 0x4e, 0x02, 0xe8, 0x2e,
	0xcb, 0xc7, 0x06, 0xaf, 0x64, 0xcc, 0x00, 0xc7,
	0x06, 0xb1, 0x64, 0xb2, 0x00, 0xc6, 0x06, 0xc3,
	0x64, 0x03, 0xc6, 0x06, 0xcb, 0x64, 0x01, 0xc6,
	0x06, 0xcd, 0x64, 0x01, 0xb9, 0x3b, 0x00, 0xb0,
	0x01, 0xb4, 0x0a, 0xe8, 0x17, 0x5a, 0xb9, 0x3c,
	0x00, 0xb0, 0x10, 0xe8, 0x18, 0x5a, 0xb9, 0x4f,
	0x02, 0xe8, 0x23, 0xcb, 0xe8, 0x57, 0xcf, 0xbb,
	0x2e, 0x37, 0xe8, 0x58, 0x50, 0xc6, 0x06, 0xa2,
	0xdb, 0x01, 0xe8, 0x40, 0x4d, 0xc3, 0xbb, 0x66,
	0x37, 0xe8, 0x49, 0x50, 0xc3, 0x80, 0x3e, 0x9e,
	0xdb, 0x01, 0x75, 0x07, 0xbb, 0xe8, 0x35, 0xe8,
	0x3b, 0x50, 0xc3, 0xc6, 0x06, 0x9e, 0xdb, 0x01,
	0xe8, 0x34, 0xcb, 0xe8, 0xc2, 0xef, 0xc6, 0x47,
	0x02, 0x00, 0x53, 0xe8, 0x46, 0x5e, 0xb9, 0x15,
	0x00, 0xb0, 0x09, 0xb4, 0x02, 0xe8, 0xc5, 0x59,
	0xb9, 0x22, 0x00, 0xb0, 0x15, 0xe8, 0xc6, 0x59,
	0xb9, 0x1a, 0x00, 0xb0, 0x1e, 0xe8, 0xc5, 0x59,
	0xb9, 0x28, 0x02, 0xe8, 0xb4, 0xca, 0x5b, 0xc6,
	0x47, 0x02, 0x12, 0xe8, 0xda, 0x5d, 0xe8, 0xd3,
	0xca, 0xb0, 0x14, 0xe8, 0xda, 0xd6, 0xc3, 0xbb,
	0x2a, 0x3f, 0xe8, 0xf0, 0x4f, 0xc3, 0xc7, 0x06,
	0xf3, 0xb4, 0x0b, 0x00, 0xb8, 0xe4, 0x00, 0xbb,
	0x6d, 0x00, 0xbf, 0x8a, 0x00, 0xbe, 0xa3, 0x00,
	0xb1, 0x0b, 0xb5, 0x03, 0xe8, 0x64, 0x5b, 0xc3,
	0xc7, 0x06, 0xf3, 0xb4, 0x0d, 0x00, 0xb8, 0x3f,
	0x01, 0xbb, 0xb5, 0x00, 0xbf, 0x05, 0x01, 0xbe,
	0xb7, 0x00, 0xb1, 0x01, 0xb5, 0x04, 0xe8, 0x4a,
	0x5b, 0xc3, 0xe8, 0x28, 0x00, 0xe8, 0xb7, 0xca,
	0xe8, 0x45, 0xef, 0xc6, 0x47, 0x01, 0x00, 0xe8,
	0xca, 0x5d, 0xb9, 0x05, 0x00, 0xb0, 0x0a, 0xb4,
	0x09, 0xe8, 0x49, 0x59, 0xb9, 0x1f, 0x02, 0xe8,
	0x5d, 0xca, 0xb0, 0x0f, 0xe8, 0x79, 0xd6, 0xb0,
	0x09, 0xe8, 0x21, 0xc9, 0xc3, 0xbe, 0xcb, 0x00,
	0xbf, 0xa9, 0x00, 0x81, 0x3e, 0xaf, 0x64, 0xcb,
	0x00, 0x75, 0x1a, 0x81, 0x3e, 0xb1, 0x64, 0xab,
	0x00, 0x75, 0x12, 0xc6, 0x06, 0xc3, 0x64, 0x01,
	0x57, 0x56, 0xe8, 0x46, 0xe5, 0xb8, 0x09, 0x00,
	0xe8, 0x4f, 0xce, 0x5e, 0x5f, 0xc6, 0x06, 0xc3,
	0x64, 0x02, 0xe8, 0x36, 0xe5, 0xc3, 0xbb, 0x54,
	0x3f, 0xe8, 0x59, 0x4f, 0xc3, 0xbb, 0x85, 0x3f,
	0xe8, 0x52, 0x4f, 0xc3, 0xc7, 0x06, 0xf3, 0xb4,
	0x0b, 0x00, 0xb8, 0x3f, 0x01, 0xbb, 0xc6, 0x00,
	0xbf, 0x2c, 0x01, 0xbe, 0xc4, 0x00, 0xb1, 0x01,
	0xb5, 0x04, 0xe8, 0xc6, 0x5a, 0x80, 0x3e, 0x9c,
	0xdb, 0x01, 0x74, 0x64, 0xe8, 0xd8, 0x54, 0xe8,
	0x26, 0xe5, 0x80, 0x3e, 0xc6, 0x64, 0x00, 0x75,
	0xf6, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x20, 0x02,
	0xb0, 0x01, 0xc7, 0x06, 0x23, 0xc4, 0x01, 0x00,
	0xc7, 0x06, 0x3b, 0x33, 0x15, 0x00, 0xc7, 0x06,
	0x3d, 0x33, 0x2a, 0x00, 0xc6, 0x06, 0xce, 0x00,
	0x02, 0xe8, 0x29, 0xc9, 0x72, 0x33, 0xa1, 0x3f,
	0x33, 0x0b, 0xc0, 0x74, 0x10, 0x3d, 0x30, 0x00,
	0x77, 0x0b, 0xb0, 0x01, 0xb9, 0x2c, 0x00, 0xba,
	0x33, 0x00, 0xe8, 0x81, 0xc1, 0xe8, 0x2e, 0x59,
	0x80, 0x3e, 0x27, 0xc4, 0x01, 0x75, 0x11, 0xc6,
	0x06, 0xcf, 0x00, 0x00, 0xe8, 0xca, 0xc6, 0xbb,
	0xb2, 0xda, 0xe8, 0x28, 0xc0, 0xe8, 0x3d, 0xc0,
	0xc3, 0xc6, 0x06, 0x9c, 0xdb, 0x01, 0xbb, 0x63,
	0x35, 0xb9, 0x3c, 0x00, 0xe8, 0xbd, 0x4f, 0xe8,
	0x04, 0x59, 0xb9, 0x11, 0x00, 0xb0, 0x05, 0xb4,
	0x08, 0xe8, 0x59, 0x58, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x21, 0x02, 0xb0, 0x01, 0xe8, 0xb9, 0xc8,
	0xe8, 0x35, 0xee, 0xc6, 0x07, 0x10, 0xe8, 0xbb,
	0x5c, 0xb0, 0x02, 0xe8, 0x1b, 0xc8, 0xe8, 0x88,
	0xc6, 0xbb, 0x17, 0x09, 0xe8, 0xfe, 0xbf, 0xc3,
	0xbb, 0x2a, 0x3f, 0xe8, 0x87, 0x4e, 0xc3, 0xc7,
	0x06, 0xf3, 0xb4, 0x0c, 0x00, 0xb8, 0x00, 0x00,
	0xbb, 0xbd, 0x00, 0xbf, 0x1e, 0x00, 0xbe, 0xbd,
	0x00, 0xb1, 0x01, 0xb5, 0x02, 0xe8, 0xfb, 0x59,
	0xc3, 0xbb, 0xec, 0x3f, 0xe8, 0x66, 0x4e, 0xc3,
	0xe8, 0x64, 0xc9, 0xe8, 0xf2, 0xed, 0xc6, 0x07,
	0x00, 0xe8, 0x78, 0x5c, 0xb9, 0x05, 0x00, 0xb0,
	0x0b, 0xb4, 0x09, 0xe8, 0xf7, 0x57, 0xb9, 0x7d,
	0x02, 0xe8, 0x0b, 0xc9, 0xb0, 0x07, 0xe8, 0xd4,
	0xc7, 0xb0, 0x31, 0xe8, 0x22, 0xd5, 0xc3, 0x80,
	0x3e, 0x9f, 0xdb, 0x01, 0x74, 0x07, 0xbb, 0xe1,
	0x34, 0xe8, 0x31, 0x4e, 0xc3, 0xbb, 0x2e, 0x40,
	0xe8, 0x2a, 0x4e, 0xc3, 0xbb, 0xe1, 0x34, 0xe8,
	0x23, 0x4e, 0xc3, 0xe8, 0xa0, 0x52, 0xc3, 0x80,
	0x3e, 0x9f, 0xdb, 0x01, 0x74, 0x07, 0xbb, 0xe1,
	0x34, 0xe8, 0x11, 0x4e, 0xc3, 0x80, 0x3e, 0xa0,
	0xdb, 0x01, 0x75, 0x07, 0xbb, 0x31, 0x3e, 0xe8,
	0x03, 0x4e, 0xc3, 0xbe, 0xad, 0x00, 0xbf, 0x8a,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x02, 0xe8, 0xca,
	0xe3, 0xb9, 0x1c, 0x00, 0xb0, 0x05, 0xb4, 0x08,
	0xe8, 0x92, 0x57, 0xb9, 0x47, 0x02, 0xe8, 0x7e,
	0xc8, 0xb9, 0x48, 0x02, 0xe8, 0x7b, 0xc8, 0xe8,
	0x52, 0x5a, 0xb8, 0x00, 0xa0, 0xb9, 0x00, 0x7d,
	0xe8, 0x7d, 0x5a, 0xa1, 0xb1, 0x32, 0xb9, 0x00,
	0x7d, 0xe8, 0x74, 0x5a, 0xa1, 0xb3, 0x32, 0xb9,
	0x00, 0x7d, 0xe8, 0x6b, 0x5a, 0xa1, 0xb5, 0x32,
	0xb9, 0x00, 0x7d, 0xe8, 0x62, 0x5a, 0xb8, 0x64,
	0x00, 0xe8, 0xb8, 0xcc, 0xe8, 0x32, 0x5a, 0xb9,
	0x48, 0x00, 0xb0, 0x12, 0xb4, 0x08, 0xe8, 0x4c,
	0x57, 0xb9, 0x49, 0x00, 0xb0, 0x27, 0xe8, 0x4d,
	0x57, 0xb9, 0x49, 0x02, 0xe8, 0x33, 0xc8, 0xe8,
	0xd1, 0x58, 0xc7, 0x06, 0xf3, 0xb4, 0x0b, 0x00,
	0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xe8, 0x57, 0x59,
	0xc7, 0x06, 0xaf, 0x64, 0xc2, 0x00, 0xc7, 0x06,
	0xb1, 0x64, 0xa0, 0x00, 0xc6, 0x06, 0xc3, 0x64,
	0x02, 0xc6, 0x06, 0xcb, 0x64, 0x00, 0xc6, 0x06,
	0xcd, 0x64, 0x00, 0xe8, 0x20, 0xe9, 0xb9, 0x1c,
	0x00, 0xb0, 0x02, 0xb4, 0x08, 0xe8, 0x05, 0x57,
	0xb9, 0x4a, 0x02, 0xc6, 0x06, 0xdc, 0x1c, 0x01,
	0xe8, 0x0d, 0xc8, 0xbe, 0x8a, 0x00, 0xbf, 0xa3,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x03, 0xe8, 0x1a,
	0xe3, 0xbb, 0x50, 0x36, 0xe8, 0x3e, 0x4d, 0xc6,
	0x06, 0xa0, 0xdb, 0x01, 0xe8, 0x26, 0x4a, 0xc3,
	0xc7, 0x06, 0xf3, 0xb4, 0x0b, 0x00, 0xb8, 0x00,
	0x00, 0xbb, 0x7c, 0x00, 0xbf, 0x3c, 0x00, 0xbe,
	0xaa, 0x00, 0xb1, 0x01, 0xb5, 0x02, 0xe8, 0xaa,
	0x58, 0xc3, 0xbb, 0x47, 0x40, 0xe8, 0x15, 0x4d,
	0xc3, 0xbb, 0x6d, 0x40, 0xe8, 0x0e, 0x4d, 0xc3,
	0x80, 0x3e, 0x99, 0xdb, 0x01, 0x75, 0x07, 0xbb,
	0x1f, 0x35, 0xe8, 0x00, 0x4d, 0xc3, 0xc6, 0x06,
	0x99, 0xdb, 0x01, 0xb9, 0x39, 0x00, 0xb0, 0x06,
	0xb4, 0x06, 0xe8, 0x98, 0x56, 0xb0, 0x0c, 0xe8,
	0x9c, 0x56, 0xb9, 0x3a, 0x00, 0xb0, 0x11, 0xe8,
	0x9b, 0x56, 0xb9, 0x05, 0x00, 0xb0, 0x25, 0xe8,
	0x9a, 0x56, 0xb9, 0x18, 0x02, 0xe8, 0x7f, 0xc7,
	0xe8, 0xa9, 0xc7, 0xb8, 0x0a, 0x00, 0xe8, 0xb1,
	0xcb, 0x8b, 0x3e, 0xb1, 0x64, 0x47, 0x8b, 0x36,
	0xaf, 0x64, 0xe8, 0x96, 0xe2, 0xbb, 0xc3, 0x30,
	0xe8, 0x2a, 0xbe, 0xb0, 0x08, 0xe8, 0x98, 0xd3,
	0xc3, 0x80, 0x3e, 0xb2, 0xdb, 0x01, 0x75, 0x0a,
	0xbb, 0x1d, 0x41, 0xe8, 0xa7, 0x4c, 0xe8, 0x43,
	0x00, 0xc3, 0xbb, 0x8a, 0x40, 0xe8, 0x9d, 0x4c,
	0xe8, 0x39, 0x00, 0xbb, 0x98, 0x40, 0xe8, 0x94,
	0x4c, 0xbb, 0xa7, 0x40, 0xbe, 0xe1, 0xcd, 0xe8,
	0x30, 0x00, 0xbb, 0xb6, 0x40, 0xe8, 0x85, 0x4c,
	0xbb, 0xce, 0x40, 0xbe, 0xac, 0xcd, 0xe8, 0x21,
	0x00, 0xbb, 0xe8, 0x40, 0xe8, 0x76, 0x4c, 0xbb,
	0x0f, 0x41, 0xbe, 0xe8, 0xcd, 0xe8, 0x12, 0x00,
	0xe8, 0x6a, 0xcb, 0xe8, 0x06, 0x00, 0xc6, 0x06,
	0xb2, 0xdb, 0x01, 0xc3, 0xbb, 0x91, 0x40, 0xbe,
	0xf8, 0xcd, 0xc6, 0x06, 0xe6, 0x1c, 0xe5, 0xe8,
	0xfc, 0x4e, 0xc3, 0xbb, 0x33, 0x41, 0xe8, 0x4c,
	0x4c, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x14, 0x00,
	0xb8, 0x00, 0x00, 0xbb, 0xb9, 0x00, 0xbf, 0x14,
	0x00, 0xbe, 0xb9, 0x00, 0xb1, 0x01, 0xb5, 0x02,
	0xe8, 0xc0, 0x57, 0xc3, 0xc7, 0x06, 0xf3, 0xb4,
	0x0b, 0x00, 0xb8, 0x00, 0x00, 0xbb, 0xaa, 0x00,
	0xbf, 0x3c, 0x00, 0xbe, 0xaa, 0x00, 0xb1, 0x01,
	0xb5, 0x02, 0xe8, 0xa6, 0x57, 0xc3, 0xc7, 0x06,
	0xf3, 0xb4, 0x12, 0x00, 0xb8, 0xf6, 0x00, 0xbb,
	0xc7, 0x00, 0xbf, 0xc9, 0x00, 0xbe, 0xc0, 0x00,
	0xb1, 0x01, 0xb5, 0x04, 0xe8, 0x8c, 0x57, 0xc3,
	0xe8, 0xfc, 0xc6, 0xe8, 0x8a, 0xeb, 0xc6, 0x47,
	0x02, 0x00, 0xe8, 0x0f, 0x5a, 0xb9, 0x22, 0x00,
	0xb0, 0x06, 0xb4, 0x06, 0xe8, 0x8e, 0x55, 0xb9,
	0x17, 0x02, 0xe8, 0xa2, 0xc6, 0xb0, 0x0b, 0xe8,
	0xbe, 0xd2, 0xb0, 0x01, 0xe8, 0x66, 0xc5, 0xc7,
	0x06, 0xf3, 0xb4, 0x0f, 0x00, 0xe8, 0x60, 0xeb,
	0xc6, 0x07, 0x00, 0xc7, 0x06, 0xf3, 0xb4, 0x10,
	0x00, 0xe8, 0x01, 0x00, 0xc3, 0xfe, 0x06, 0x98,
	0xdb, 0x80, 0x3e, 0x98, 0xdb, 0x02, 0x73, 0x01,
	0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x0f, 0x00, 0xb0,
	0x01, 0xe8, 0x39, 0xc5, 0xc7, 0x06, 0xf3, 0xb4,
	0x10, 0x00, 0xc3, 0xe8, 0xa1, 0xc6, 0xe8, 0x2f,
	0xeb, 0xc6, 0x47, 0x01, 0x00, 0xc6, 0x47, 0x03,
	0x00, 0xe8, 0xb0, 0x59, 0xb9, 0x21, 0x00, 0xb0,
	0x07, 0xb4, 0x09, 0xe8, 0x2f, 0x55, 0xb9, 0x16,
	0x02, 0xe8, 0x2e, 0xc6, 0xb0, 0x0a, 0xe8, 0x5f,
	0xd2, 0xb0, 0x02, 0xe8, 0x07, 0xc5, 0xe8, 0x07,
	0xeb, 0xc6, 0x47, 0x01, 0x0a, 0xe8, 0x48, 0x59,
	0xe8, 0x41, 0xc6, 0xc7, 0x06, 0xf3, 0xb4, 0x0f,
	0x00, 0xe8, 0xf4, 0xea, 0xc6, 0x47, 0x01, 0x00,
	0xc7, 0x06, 0xf3, 0xb4, 0x10, 0x00, 0xe8, 0x94,
	0xff, 0xc3, 0xe8, 0xe3, 0xea, 0xb0, 0x00, 0x88,
	0x07, 0xc7, 0x06, 0xf3, 0xb4, 0x0f, 0x00, 0xc6,
	0x06, 0xdc, 0x1c, 0x01, 0xe8, 0x10, 0x57, 0xb9,
	0x38, 0x02, 0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xe8,
	0xcd, 0xc5, 0xc7, 0x06, 0xaf, 0x64, 0x73, 0x00,
	0xc7, 0x06, 0xb1, 0x64, 0xb4, 0x00, 0xc6, 0x06,
	0xc3, 0x64, 0x03, 0xc6, 0x06, 0xcb, 0x64, 0x01,
	0xc6, 0x06, 0xcd, 0x64, 0x01, 0xe8, 0xec, 0xc5,
	0xb9, 0x06, 0x00, 0xe8, 0x05, 0x5c, 0xc3, 0xc7,
	0x06, 0xf3, 0xb4, 0x0f, 0x00, 0xb8, 0x00, 0x00,
	0xbb, 0xac, 0x00, 0xbf, 0x1e, 0x00, 0xbe, 0xac,
	0x00, 0xb1, 0x01, 0xb5, 0x02, 0xe8, 0x83, 0x56,
	0xc3, 0xe8, 0x1a, 0x00, 0xc7, 0x06, 0xf3, 0xb4,
	0x13, 0x00, 0xb8, 0xdf, 0x00, 0xbb, 0xc7, 0x00,
	0xbf, 0xdf, 0x00, 0xbe, 0xc1, 0x00, 0xb1, 0x13,
	0xb5, 0x01, 0xe8, 0x66, 0x56, 0xc3, 0xe8, 0x7e,
	0x50, 0x81, 0x3e, 0xb1, 0x64, 0x95, 0x00, 0x76,
	0x09, 0xbe, 0x33, 0x00, 0xbf, 0x95, 0x00, 0xe8,
	0xaa, 0xe0, 0xbe, 0x5e, 0x00, 0xbf, 0x73, 0x00,
	0xc6, 0x06, 0xc3, 0x64, 0x04, 0xe8, 0x9c, 0xe0,
	0xc3, 0xe8, 0xda, 0xff, 0xe8, 0x2f, 0x4f, 0xc3,
	0xbb, 0x08, 0xdb, 0xe8, 0xff, 0xbb, 0x53, 0xe8,
	0x13, 0xbc, 0x5b, 0x81, 0xfb, 0x5d, 0x2c, 0x74,
	0x2e, 0x81, 0xfb, 0x9b, 0x2c, 0x75, 0x01, 0xc3,
	0xb8, 0x23, 0x01, 0xe8, 0x48, 0xc9, 0xb9, 0x34,
	0x00, 0xb0, 0x09, 0xb4, 0x0a, 0xe8, 0x2d, 0x54,
	0xb0, 0x0b, 0xe8, 0x31, 0x54, 0xb0, 0x0d, 0xe8,
	0x33, 0x54, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x39,
	0x02, 0xb0, 0x01, 0xe8, 0x83, 0xc4, 0xc3, 0xb8,
	0x23, 0x01, 0xe8, 0x21, 0xc9, 0xe8, 0xf8, 0xe9,
	0xc6, 0x07, 0x00, 0xe8, 0x7e, 0x58, 0xb9, 0x34,
	0x00, 0xb0, 0x09, 0xb4, 0x0a, 0xe8, 0xfd, 0x53,
	0xb0, 0x0b, 0xe8, 0x01, 0x54, 0xb0, 0x0d, 0xe8,
	0x03, 0x54, 0xb9, 0x35, 0x00, 0xb0, 0x20, 0xb4,
	0x0a, 0xe8, 0x00, 0x54, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x3a, 0x02, 0xb0, 0x01, 0xe8, 0x49, 0xc4,
	0xe8, 0x2b, 0xc9, 0xbb, 0x1f, 0x55, 0xe8, 0x2c,
	0x4a, 0xb0, 0x05, 0xe8, 0xb7, 0xc3, 0xc6, 0x06,
	0xb0, 0xdb, 0x01, 0xc3, 0xbb, 0x0f, 0x57, 0xe8,
	0x1b, 0x4a, 0xc3, 0xe8, 0x19, 0xc5, 0xe8, 0xa7,
	0xe9, 0xc6, 0x47, 0x01, 0x00, 0xe8, 0x2c, 0x58,
	0xb9, 0x05, 0x00, 0xb0, 0x0a, 0xb4, 0x08, 0xe8,
	0xab, 0x53, 0xb9, 0x31, 0x02, 0xe8, 0xcd, 0xc4,
	0xb0, 0x1a, 0xe8, 0xdb, 0xd0, 0xb0, 0x06, 0xe8,
	0x83, 0xc3, 0xc3, 0xbb, 0x7e, 0x41, 0x80, 0x3e,
	0xb0, 0xdb, 0x01, 0x75, 0x03, 0xbb, 0xb1, 0x41,
	0xe8, 0xe2, 0x49, 0xc3, 0xc7, 0x06, 0xf3, 0xb4,
	0x12, 0x00, 0xb8, 0x5e, 0x00, 0xbb, 0x73, 0x00,
	0xbf, 0x5e, 0x00, 0xbe, 0x73, 0x00, 0xb1, 0x0b,
	0xb5, 0x03, 0xe8, 0x56, 0x55, 0xc3, 0xbb, 0xef,
	0x41, 0xe8, 0xc1, 0x49, 0xc3, 0xbb, 0x64, 0x41,
	0xe8, 0xba, 0x49, 0xc3, 0xb9, 0x43, 0x00, 0xb0,
	0x05, 0xb4, 0x03, 0xe8, 0x57, 0x53, 0xb9, 0xd7,
	0x03, 0xe8, 0x64, 0xc4, 0xbb, 0x55, 0x59, 0xe8,
	0xa3, 0x49, 0xc3, 0xe8, 0x20, 0x4e, 0xc3, 0xb9,
	0x42, 0x00, 0xb0, 0x05, 0xb4, 0x08, 0xe8, 0x3c,
	0x53, 0xb9, 0x43, 0x00, 0xb0, 0x0b, 0xe8, 0x3d,
	0x53, 0xb9, 0xd8, 0x03, 0xe8, 0x41, 0xc4, 0xbb,
	0x55, 0x59, 0xe8, 0x80, 0x49, 0xc3, 0xbb, 0xff,
	0x41, 0xe8, 0x79, 0x49, 0xc3, 0xbb, 0x3f, 0x42,
	0xe8, 0x72, 0x49, 0xc3, 0xbb, 0x51, 0x42, 0xe8,
	0x6b, 0x49, 0xc3, 0xbb, 0x67, 0x42, 0xe8, 0x64,
	0x49, 0xc3, 0xe8, 0xe1, 0x4d, 0xc3, 0xb9, 0x20,
	0x00, 0xb0, 0x07, 0xb4, 0x04, 0xe8, 0xfd, 0x52,
	0xb9, 0x72, 0x02, 0xe8, 0x0a, 0xc4, 0xe8, 0xdf,
	0xe8, 0xc6, 0x47, 0x01, 0x00, 0xe8, 0x64, 0x57,
	0xb0, 0x0c, 0xe8, 0xd0, 0xc2, 0xb0, 0x2d, 0xe8,
	0x1e, 0xd0, 0xbb, 0x04, 0x3b, 0xe8, 0x35, 0x49,
	0xc3, 0xbb, 0x3f, 0x42, 0xe8, 0x2e, 0x49, 0xc3,
	0xe8, 0x2c, 0xc4, 0xb0, 0x0d, 0xe8, 0x08, 0xd0,
	0xb0, 0x0e, 0xe8, 0xb0, 0xc2, 0xb9, 0x05, 0x00,
	0xb0, 0x0a, 0xb4, 0x08, 0xe8, 0xbe, 0x52, 0xe8,
	0xa6, 0xe8, 0xc6, 0x07, 0x00, 0xe8, 0x2c, 0x57,
	0xb9, 0x36, 0x02, 0xe8, 0xd7, 0xc3, 0xc3, 0xbb,
	0x89, 0x42, 0xe8, 0x00, 0x49, 0xc3, 0xb9, 0x0b,
	0x00, 0xb0, 0x04, 0xb4, 0x0c, 0xe8, 0x9d, 0x52,
	0xb9, 0x02, 0x02, 0xe8, 0x89, 0xc3, 0xe8, 0x7f,
	0xe8, 0xb0, 0x05, 0x88, 0x47, 0x02, 0x53, 0xe8,
	0x88, 0x57, 0x5b, 0xb0, 0x08, 0x88, 0x47, 0x04,
	0xe8, 0xa6, 0x57, 0xe8, 0xae, 0xc3, 0xb0, 0x0e,
	0xe8, 0x56, 0xc2, 0xb0, 0x0f, 0xe8, 0x51, 0xc2,
	0xb0, 0x10, 0xe8, 0x4c, 0xc2, 0xb0, 0x01, 0xe8,
	0x53, 0xc2, 0xc3, 0x80, 0x3e, 0x94, 0xdb, 0x01,
	0x74, 0x07, 0xbb, 0x63, 0x3e, 0xe8, 0xb5, 0x48,
	0xc3, 0x80, 0x3e, 0x95, 0xdb, 0x01, 0x75, 0x07,
	0xbb, 0x75, 0x3e, 0xe8, 0xa7, 0x48, 0xc3, 0xc6,
	0x06, 0x95, 0xdb, 0x01, 0xbb, 0x46, 0x67, 0xe8,
	0x20, 0xe8, 0x83, 0xc3, 0x03, 0xff, 0x37, 0x53,
	0xc7, 0x07, 0x3f, 0x01, 0xbe, 0xbc, 0x00, 0xbf,
	0xb3, 0x00, 0xe8, 0x5e, 0xde, 0xb9, 0x07, 0x00,
	0xb0, 0x10, 0xb4, 0x07, 0xe8, 0x26, 0x52, 0xb9,
	0x07, 0x02, 0xe8, 0x33, 0xc3, 0xb8, 0x96, 0x00,
	0xe8, 0x57, 0xc7, 0xbe, 0xa8, 0x00, 0xbf, 0xb3,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x02, 0xe8, 0x3a,
	0xde, 0x5b, 0x8f, 0x07, 0xb0, 0x03, 0xe8, 0x3f,
	0xcf, 0xc3, 0xbb, 0x3f, 0x42, 0xe8, 0x55, 0x48,
	0xc3, 0xe8, 0xd2, 0x4c, 0xc3, 0xb9, 0x46, 0x00,
	0xb0, 0x06, 0xb4, 0x06, 0xe8, 0xee, 0x51, 0xb9,
	0x01, 0x02, 0xe8, 0xda, 0xc2, 0xe8, 0x7b, 0x53,
	0xc7, 0x06, 0xf3, 0xb4, 0x16, 0x00, 0xb8, 0x33,
	0x00, 0xbb, 0xb4, 0x00, 0xbf, 0x4e, 0x00, 0xbe,
	0xb4, 0x00, 0xb1, 0x01, 0xb5, 0x02, 0xe8, 0xb2,
	0x53, 0xc3, 0xb9, 0xfd, 0x01, 0xe8, 0xd8, 0xc2,
	0xbb, 0xce, 0x5d, 0xe8, 0x17, 0x48, 0xc3, 0xbb,
	0x64, 0x41, 0xe8, 0x10, 0x48, 0xc3, 0xbb, 0x64,
	0x41, 0xe8, 0x09, 0x48, 0xc3, 0xbb, 0x0f, 0x57,
	0xe8, 0x02, 0x48, 0xc3, 0xc7, 0x06, 0xf3, 0xb4,
	0x0f, 0x00, 0xb8, 0x9d, 0x00, 0xbb, 0xc7, 0x00,
	0xbf, 0x9d, 0x00, 0xbe, 0xb4, 0x00, 0xb1, 0x13,
	0xb5, 0x01, 0xe8, 0x76, 0x53, 0xc3, 0xc7, 0x06,
	0xf3, 0xb4, 0x15, 0x00, 0xb8, 0x00, 0x00, 0xbb,
	0xbb, 0x00, 0xbf, 0x30, 0x00, 0xbe, 0xbe, 0x00,
	0xb1, 0x01, 0xb5, 0x02, 0xe8, 0x5c, 0x53, 0xc3,
	0xc7, 0x06, 0xf3, 0xb4, 0x1b, 0x00, 0xb8, 0x54,
	0x00, 0xbb, 0xc7, 0x00, 0xbf, 0x84, 0x00, 0xbe,
	0xbe, 0x00, 0xb1, 0x01, 0xb5, 0x02, 0xe8, 0x42,
	0x53, 0xc3, 0xe8, 0x5e, 0xbf, 0xbb, 0xba, 0xda,
	0xe8, 0x02, 0xb9, 0xe8, 0x17, 0xb9, 0xbe, 0xe5,
	0x92, 0xb0, 0x0d, 0xe8, 0x3b, 0xc1, 0xc3, 0xb0,
	0x0e, 0xe8, 0x29, 0xc1, 0xb0, 0x06, 0xe8, 0x77,
	0xce, 0xb9, 0x05, 0x00, 0xb0, 0x07, 0xb4, 0x0c,
	0xe8, 0x32, 0x51, 0xb9, 0x09, 0x02, 0xe8, 0x1e,
	0xc2, 0xe8, 0x14, 0xe7, 0xc6, 0x47, 0x04, 0x00,
	0xe8, 0x4e, 0x55, 0xe8, 0x4e, 0xc2, 0xc3, 0xc6,
	0x06, 0x94, 0xdb, 0x01, 0xb9, 0x06, 0x00, 0xb0,
	0x04, 0xb4, 0x0b, 0xe8, 0x0f, 0x51, 0xb9, 0x03,
	0x02, 0xe8, 0xfb, 0xc1, 0xe8, 0xf1, 0xe6, 0xb0,
	0x06, 0x88, 0x47, 0x03, 0xe8, 0x22, 0x56, 0xe8,
	0x2a, 0xc2, 0xc3, 0xbb, 0xac, 0x42, 0xe8, 0x4c,
	0x47, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x14, 0x00,
	0xb8, 0x3f, 0x01, 0xbb, 0xbe, 0x00, 0xbf, 0x21,
	0x01, 0xbe, 0xbe, 0x00, 0xb1, 0x01, 0xb5, 0x04,
	0xe8, 0xc0, 0x52, 0xc3, 0xc7, 0x06, 0xf3, 0xb4,
	0x19, 0x00, 0xb8, 0x3f, 0x01, 0xbb, 0x92, 0x00,
	0xbf, 0x14, 0x01, 0xbe, 0x92, 0x00, 0xb1, 0x01,
	0xb5, 0x04, 0xe8, 0xa6, 0x52, 0xc3, 0xb9, 0x59,
	0x00, 0xb0, 0x04, 0xb4, 0x06, 0xe8, 0xb5, 0x50,
	0xb9, 0xd4, 0x03, 0xe8, 0xa1, 0xc1, 0xe8, 0x42,
	0x52, 0x80, 0x3e, 0xee, 0xdb, 0x01, 0x75, 0x06,
	0xb9, 0x07, 0x00, 0xe8, 0xed, 0x57, 0xc7, 0x06,
	0xf3, 0xb4, 0x17, 0x00, 0xb8, 0x4c, 0x00, 0xbb,
	0xc7, 0x00, 0xbf, 0x5e, 0x00, 0xbe, 0xbe, 0x00,
	0xb1, 0x13, 0xb5, 0x01, 0xe8, 0x6c, 0x52, 0xc3,
	0xbb, 0xc7, 0x42, 0xe8, 0xd7, 0x46, 0xc3, 0xbb,
	0x64, 0x41, 0xe8, 0xd0, 0x46, 0xc3, 0xbb, 0x64,
	0x41, 0xe8, 0xc9, 0x46, 0xc3, 0xbb, 0x64, 0x41,
	0xe8, 0xc2, 0x46, 0xc3, 0xe8, 0x04, 0x00, 0xe8,
	0x87, 0x00, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x18,
	0x00, 0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xc6, 0x06,
	0xc5, 0x64, 0x00, 0xc6, 0x06, 0x3d, 0x66, 0x00,
	0xc6, 0x06, 0x40, 0x67, 0xff, 0xc6, 0x06, 0xc4,
	0x64, 0x01, 0xe8, 0x93, 0xdb, 0x80, 0x3e, 0xad,
	0x64, 0x01, 0x75, 0x05, 0xe8, 0x05, 0x53, 0xeb,
	0x03, 0xe8, 0x1a, 0x53, 0xe8, 0x3e, 0x54, 0x80,
	0x3e, 0xa4, 0xdb, 0x01, 0x74, 0x1c, 0xa1, 0xb3,
	0x32, 0xbb, 0x00, 0xfa, 0x1e, 0x53, 0x8e, 0xd8,
	0xb9, 0x70, 0x02, 0xe8, 0x2d, 0x00, 0x5b, 0x81,
	0xc3, 0xd6, 0x02, 0xb9, 0x27, 0x00, 0xe8, 0x22,
	0x00, 0x1f, 0xe8, 0x7a, 0x52, 0x80, 0x3e, 0xad,
	0x64, 0x01, 0x75, 0x04, 0xe8, 0xda, 0x52, 0xc3,
	0xb8, 0x00, 0xa0, 0xb9, 0x00, 0x7d, 0xe8, 0xf7,
	0x52, 0xe8, 0xe7, 0x52, 0xe8, 0xb2, 0x52, 0xe8,
	0xae, 0x4e, 0xc3, 0x8a, 0x07, 0x2c, 0x20, 0x73,
	0x02, 0xb0, 0x00, 0x88, 0x07, 0x43, 0xe2, 0xf3,
	0xc3, 0xc7, 0x06, 0xaf, 0x64, 0xe6, 0x00, 0xc7,
	0x06, 0xb1, 0x64, 0xaa, 0x00, 0xc6, 0x06, 0xc3,
	0x64, 0x01, 0xc6, 0x06, 0xcb, 0x64, 0x01, 0xc6,
	0x06, 0xcd, 0x64, 0x01, 0xb9, 0x34, 0x00, 0xb0,
	0x03, 0xb4, 0x0b, 0xe8, 0xb7, 0x4f, 0xb0, 0x07,
	0xe8, 0xbb, 0x4f, 0xb0, 0x0b, 0xe8, 0xbd, 0x4f,
	0xb0, 0x0e, 0xe8, 0xbf, 0x4f, 0xb0, 0x12, 0xe8,
	0xc1, 0x4f, 0xb0, 0x15, 0xe8, 0xc3, 0x4f, 0xb0,
	0x19, 0xe8, 0xc5, 0x4f, 0xb9, 0x59, 0x02, 0xc6,
	0x06, 0xdc, 0x1c, 0x01, 0xe8, 0xa1, 0xc0, 0xbe,
	0xe6, 0x00, 0xbf, 0xb3, 0x00, 0xc6, 0x06, 0xc3,
	0x64, 0x03, 0xe8, 0xae, 0xdb, 0x80, 0x3e, 0xa4,
	0xdb, 0x01, 0x74, 0x06, 0xbb, 0xea, 0x37, 0xe8,
	0xcb, 0x45, 0xc3, 0x80, 0x3e, 0xad, 0xdb, 0x01,
	0x74, 0x32, 0xb9, 0x2b, 0x00, 0xb0, 0x04, 0xb4,
	0x0b, 0xe8, 0x61, 0x4f, 0xb9, 0x2a, 0x00, 0xb0,
	0x0f, 0xe8, 0x62, 0x4f, 0xb0, 0x11, 0xe8, 0x64,
	0x4f, 0xb0, 0x13, 0xe8, 0x66, 0x4f, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0x90, 0x02, 0xb0, 0x01, 0xe8,
	0xaf, 0xbf, 0xe8, 0x91, 0xc4, 0xbb, 0x16, 0x3c,
	0xe8, 0x92, 0x45, 0xc3, 0x80, 0x3e, 0xa3, 0xdb,
	0x01, 0x74, 0x29, 0xb9, 0x1c, 0x00, 0xb0, 0x03,
	0xb4, 0x0e, 0xe8, 0x28, 0x4f, 0xb9, 0x54, 0x02,
	0xe8, 0x14, 0xc0, 0xe8, 0x0a, 0xe5, 0xb0, 0x1e,
	0x88, 0x47, 0x01, 0xe8, 0x3b, 0x54, 0xe8, 0x43,
	0xc0, 0xc6, 0x06, 0xa3, 0xdb, 0x01, 0xb0, 0x08,
	0xe8, 0xe6, 0xbe, 0xc3, 0xe8, 0x60, 0xc0, 0xe8,
	0xee, 0xe4, 0xc6, 0x47, 0x01, 0x00, 0xe8, 0x73,
	0x53, 0xb9, 0x04, 0x00, 0xb0, 0x04, 0xb4, 0x0e,
	0xe8, 0xf2, 0x4e, 0xb9, 0x55, 0x02, 0xe8, 0x06,
	0xc0, 0xc6, 0x06, 0xa3, 0xdb, 0x00, 0xb0, 0x08,
	0xe8, 0xca, 0xbe, 0xbb, 0xb8, 0x37, 0xe8, 0x34,
	0x45, 0xc7, 0x06, 0xf3, 0xb4, 0x18, 0x00, 0xe8,
	0xbe, 0xe4, 0xc6, 0x47, 0x01, 0x20, 0xb0, 0x04,
	0xe8, 0xa6, 0xbe, 0xc7, 0x06, 0xf3, 0xb4, 0x15,
	0x00, 0xc3, 0xbb, 0x14, 0xdb, 0xe8, 0x6d, 0xb6,
	0xe8, 0x82, 0xb6, 0xc3, 0xb9, 0xfe, 0x01, 0xe8,
	0xc6, 0xbf, 0xc6, 0x06, 0xe6, 0x1c, 0xe5, 0xbb,
	0xc2, 0x5d, 0xbe, 0x8c, 0x7d, 0xe8, 0xa6, 0x47,
	0xc3, 0xbb, 0xbd, 0x2c, 0xe8, 0x66, 0xb6, 0xb8,
	0x96, 0x00, 0xe8, 0xd5, 0xc3, 0xbb, 0xc2, 0x2d,
	0xe8, 0x5a, 0xb6, 0x8b, 0x36, 0xaf, 0x64, 0x8b,
	0x3e, 0xb1, 0x64, 0x83, 0xef, 0x0c, 0xe8, 0xb2,
	0xda, 0xb9, 0x22, 0x00, 0xb0, 0x05, 0xb4, 0x03,
	0xe8, 0x7a, 0x4e, 0xb9, 0x5f, 0x02, 0xe8, 0x66,
	0xbf, 0xe8, 0x5c, 0xe4, 0xc6, 0x07, 0x00, 0xe8,
	0x9e, 0x52, 0xb9, 0x60, 0x02, 0xe8, 0x5a, 0xbf,
	0xb9, 0x61, 0x02, 0xe8, 0x54, 0xbf, 0xb9, 0x62,
	0x02, 0xe8, 0x4e, 0xbf, 0xb9, 0x05, 0x00, 0xb0,
	0x19, 0xb4, 0x00, 0xe8, 0x4f, 0x4e, 0xb9, 0x63,
	0x02, 0xe8, 0x3e, 0xbf, 0xc7, 0x06, 0xaf, 0x64,
	0x10, 0x00, 0xc6, 0x06, 0xcc, 0x64, 0x00, 0xc6,
	0x06, 0xcd, 0x64, 0x00, 0xc6, 0x06, 0xcb, 0x64,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x04, 0xc6, 0x06,
	0xdc, 0x64, 0x01, 0xe8, 0x56, 0xbf, 0xb0, 0x26,
	0xe8, 0x5d, 0xcb, 0xb0, 0x0c, 0xe8, 0x05, 0xbe,
	0xc3, 0xe8, 0xfc, 0xbb, 0xbb, 0xc4, 0xda, 0xe8,
	0xc3, 0xb5, 0xe8, 0xd8, 0xb5, 0xc3, 0xb9, 0x59,
	0x00, 0xb0, 0x05, 0xb4, 0x06, 0xe8, 0x05, 0x4e,
	0xb9, 0x43, 0x00, 0xb0, 0x0b, 0xe8, 0x06, 0x4e,
	0xb9, 0xd6, 0x03, 0xe8, 0x0a, 0xbf, 0xbb, 0x55,
	0x59, 0xe8, 0x49, 0x44, 0xc3, 0x80, 0x3e, 0xa7,
	0xdb, 0x01, 0x75, 0x07, 0xbb, 0xac, 0x3b, 0xe8,
	0x3b, 0x44, 0xc3, 0x80, 0x3e, 0x92, 0xdb, 0x01,
	0x74, 0x25, 0x8b, 0x36, 0xaf, 0x64, 0x8b, 0x3e,
	0xb1, 0x64, 0x56, 0x57, 0xc6, 0x06, 0xc3, 0x64,
	0x03, 0xe8, 0xf7, 0xd9, 0xe8, 0xa9, 0xbb, 0xbb,
	0xa0, 0x15, 0xe8, 0x88, 0xb5, 0x5f, 0x5e, 0xc6,
	0x06, 0xc3, 0x64, 0x01, 0xe8, 0xe4, 0xd9, 0xb9,
	0x42, 0x00, 0xb0, 0x05, 0xb4, 0x07, 0xe8, 0xac,
	0x4d, 0xb9, 0x43, 0x00, 0xb0, 0x14, 0xe8, 0xad,
	0x4d, 0xb9, 0x05, 0x00, 0xb0, 0x17, 0xe8, 0xac,
	0x4d, 0xb9, 0x77, 0x02, 0xe8, 0xa9, 0xbe, 0xb0,
	0x2f, 0xe8, 0xcc, 0xca, 0xc6, 0x06, 0xa7, 0xdb,
	0x01, 0xc3, 0xbb, 0x06, 0x43, 0xe8, 0xdd, 0x43,
	0xc3, 0xbb, 0x64, 0x41, 0xe8, 0xd6, 0x43, 0xc3,
	0xe8, 0x53, 0x48, 0xc3, 0x80, 0x3e, 0x92, 0xdb,
	0x01, 0x74, 0x29, 0x8b, 0x36, 0xaf, 0x64, 0x8b,
	0x3e, 0xb1, 0x64, 0xc6, 0x06, 0xc3, 0x64, 0x03,
	0x57, 0x56, 0xe8, 0x8e, 0xd9, 0xe8, 0x40, 0xbb,
	0xbb, 0xce, 0xda, 0xe8, 0x07, 0xb5, 0xe8, 0x1c,
	0xb5, 0x5e, 0x5f, 0xc6, 0x06, 0xc3, 0x64, 0x01,
	0xe8, 0x78, 0xd9, 0xc3, 0xe8, 0xa0, 0xbe, 0xb0,
	0x02, 0xe8, 0x7c, 0xca, 0xb0, 0x07, 0xe8, 0x24,
	0xbd, 0xe8, 0x24, 0xe3, 0xc6, 0x07, 0x00, 0xe8,
	0xaa, 0x51, 0xb9, 0x20, 0x00, 0xb0, 0x07, 0xb4,
	0x09, 0xe8, 0x29, 0x4d, 0xb9, 0x08, 0x02, 0xe8,
	0x3d, 0xbe, 0xc3, 0xbb, 0x3f, 0x42, 0xe8, 0x74,
	0x43, 0xc3, 0xbb, 0x3f, 0x42, 0xe8, 0x6d, 0x43,
	0xc3, 0xbb, 0x1e, 0x43, 0xe8, 0x66, 0x43, 0xc3,
	0xb9, 0x58, 0x00, 0xb0, 0x05, 0xb4, 0x03, 0xe8,
	0x03, 0x4d, 0xb9, 0xd5, 0x03, 0xe8, 0xff, 0xbd,
	0xe8, 0x90, 0x4e, 0xc7, 0x06, 0xf3, 0xb4, 0x14,
	0x00, 0xb8, 0xa0, 0x00, 0xbb, 0xa5, 0x00, 0xbf,
	0xa0, 0x00, 0xbe, 0xb9, 0x00, 0xb1, 0x0b, 0xb5,
	0x03, 0xe8, 0xc7, 0x4e, 0xc3, 0xbb, 0xff, 0x41,
	0xe8, 0x32, 0x43, 0xc3, 0x80, 0x3e, 0x92, 0xdb,
	0x01, 0x74, 0x29, 0x8b, 0x36, 0xaf, 0x64, 0x8b,
	0x3e, 0xb1, 0x64, 0x56, 0x57, 0xc6, 0x06, 0xc3,
	0x64, 0x03, 0xe8, 0xee, 0xd8, 0xe8, 0xa0, 0xba,
	0xbb, 0xd4, 0xda, 0xe8, 0x67, 0xb4, 0xe8, 0x7c,
	0xb4, 0x5f, 0x5e, 0xc6, 0x06, 0xc3, 0x64, 0x01,
	0xe8, 0xd8, 0xd8, 0xc3, 0xe8, 0x00, 0xbe, 0xb8,
	0x02, 0x00, 0xe8, 0x1c, 0xd1, 0x32, 0xe4, 0xbb,
	0xc7, 0x32, 0xb1, 0x1b, 0x48, 0xf6, 0xe1, 0x03,
	0xd8, 0xc7, 0x07, 0x00, 0x00, 0xb9, 0x20, 0x00,
	0xb0, 0x07, 0xb4, 0x08, 0xe8, 0x86, 0x4c, 0xb9,
	0xfc, 0x01, 0xe8, 0x9a, 0xbd, 0xb0, 0x0d, 0xe8,
	0x63, 0xbc, 0xb0, 0x07, 0xe8, 0xb1, 0xc9, 0xc3,
	0x80, 0x3e, 0xa5, 0xdb, 0x01, 0x74, 0x37, 0xe8,
	0x2b, 0xba, 0xbb, 0xda, 0xda, 0xe8, 0x15, 0xb4,
	0x53, 0xe8, 0x29, 0xb4, 0x5b, 0x81, 0xfb, 0x13,
	0x19, 0x75, 0x22, 0xb8, 0x64, 0x00, 0xe8, 0x91,
	0xc1, 0x8b, 0x3e, 0xb1, 0x64, 0x8b, 0x36, 0xaf,
	0x64, 0xc6, 0x06, 0xc3, 0x64, 0x03, 0xe8, 0x72,
	0xd8, 0xe8, 0x92, 0xc1, 0xbb, 0xd5, 0x34, 0xe8,
	0x93, 0x42, 0xe8, 0x89, 0xc1, 0xc3, 0xc6, 0x06,
	0xa5, 0xdb, 0x02, 0xe8, 0xef, 0xb9, 0xbb, 0x4f,
	0x1f, 0xe8, 0xf1, 0xb3, 0xb8, 0x01, 0x01, 0xe8,
	0x34, 0xc1, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x5c,
	0x02, 0xb0, 0x01, 0xe8, 0x3a, 0xbc, 0xe8, 0x03,
	0x4d, 0xc7, 0x06, 0xf3, 0xb4, 0x15, 0x00, 0xb0,
	0x04, 0xe8, 0xf1, 0xbb, 0xb0, 0x0c, 0xe8, 0xe0,
	0xbb, 0xe8, 0xec, 0xe1, 0x53, 0xc6, 0x07, 0x00,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0x5e, 0x02,
	0xe8, 0x01, 0x4f, 0xb9, 0x2e, 0x00, 0xb0, 0x05,
	0xb4, 0x02, 0xe8, 0xe8, 0x4b, 0xb0, 0x02, 0xe8,
	0x48, 0xbc, 0xe8, 0xcf, 0x4c, 0x5b, 0xc6, 0x07,
	0x21, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x5d, 0x02,
	0xc7, 0x06, 0xf3, 0xb4, 0x17, 0x00, 0xe8, 0xe4,
	0x4e, 0xb0, 0x01, 0xe8, 0x2c, 0xbc, 0xe8, 0x65,
	0x4c, 0xc6, 0x06, 0x33, 0x33, 0x01, 0xc6, 0x06,
	0xdd, 0x1c, 0x02, 0xe8, 0x77, 0xb9, 0xbb, 0x02,
	0x20, 0xe8, 0x79, 0xb3, 0xc3, 0x80, 0x3e, 0x97,
	0xdb, 0x00, 0x74, 0x07, 0xbb, 0x59, 0x3d, 0xe8,
	0xfb, 0x41, 0xc3, 0xbe, 0xf5, 0x00, 0xbf, 0xc6,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x01, 0xe8, 0xc2,
	0xd7, 0xe8, 0x00, 0xba, 0xbb, 0xd7, 0x21, 0xe8,
	0x53, 0xb3, 0xc6, 0x06, 0x97, 0xdb, 0x01, 0xb8,
	0x01, 0x02, 0xe8, 0x91, 0xc0, 0xb9, 0x0d, 0x00,
	0xb0, 0x0a, 0xb4, 0x0c, 0xe8, 0x76, 0x4b, 0xb0,
	0x0c, 0xe8, 0x7a, 0x4b, 0xb0, 0x0e, 0xe8, 0x7c,
	0x4b, 0xb0, 0x10, 0xe8, 0x7e, 0x4b, 0xb0, 0x12,
	0xe8, 0x80, 0x4b, 0xb0, 0x14, 0xe8, 0x82, 0x4b,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0x10, 0x02,
	0xb0, 0x02, 0xe8, 0xbc, 0xbb, 0xb8, 0x32, 0x00,
	0xe8, 0x87, 0xc0, 0xb9, 0x07, 0x00, 0xe8, 0x92,
	0x52, 0xc6, 0x06, 0xee, 0xdb, 0x01, 0xb9, 0x38,
	0x00, 0xb0, 0x03, 0xb4, 0x0a, 0xe8, 0x35, 0x4b,
	0xb0, 0x05, 0xe8, 0x39, 0x4b, 0xb0, 0x07, 0xe8,
	0x3b, 0x4b, 0xb0, 0x09, 0xe8, 0x3d, 0x4b, 0xb0,
	0x0b, 0xe8, 0x3f, 0x4b, 0xb0, 0x0d, 0xe8, 0x41,
	0x4b, 0xb0, 0x0f, 0xe8, 0x43, 0x4b, 0xb0, 0x11,
	0xe8, 0x45, 0x4b, 0xb9, 0x0d, 0x02, 0xe8, 0xfe,
	0xbb, 0xb9, 0x38, 0x00, 0xb0, 0x01, 0xb4, 0x0a,
	0xe8, 0x02, 0x4b, 0xb0, 0x03, 0xe8, 0x06, 0x4b,
	0xb0, 0x05, 0xe8, 0x08, 0x4b, 0xb0, 0x07, 0xe8,
	0x0a, 0x4b, 0xb0, 0x09, 0xe8, 0x0c, 0x4b, 0xb0,
	0x0b, 0xe8, 0x0e, 0x4b, 0xb0, 0x0d, 0xe8, 0x10,
	0x4b, 0xb9, 0x28, 0x00, 0xb0, 0x0f, 0xe8, 0x0f,
	0x4b, 0xb0, 0x12, 0xe8, 0x11, 0x4b, 0xb0, 0x16,
	0xe8, 0x13, 0x4b, 0xb9, 0x0e, 0x02, 0xe8, 0xc1,
	0xbb, 0xb9, 0x36, 0x00, 0xb0, 0x01, 0xb4, 0x0a,
	0xe8, 0xc2, 0x4a, 0xb9, 0x37, 0x00, 0xb0, 0x05,
	0xe8, 0xc3, 0x4a, 0xb9, 0x38, 0x00, 0xb0, 0x09,
	0xe8, 0xc2, 0x4a, 0xb0, 0x0d, 0xe8, 0xc4, 0x4a,
	0xb9, 0x18, 0x00, 0xb0, 0x10, 0xe8, 0xc3, 0x4a,
	0xb9, 0x0f, 0x02, 0xe8, 0x94, 0xbb, 0xe8, 0xcb,
	0xbb, 0xe8, 0xea, 0xbf, 0xbb, 0x19, 0x22, 0xe8,
	0x5b, 0xb2, 0xb0, 0x02, 0xbe, 0x20, 0x98, 0xe8,
	0x7f, 0xba, 0xc3, 0x80, 0x3e, 0xee, 0xdb, 0x01,
	0x75, 0x06, 0xb9, 0x06, 0x00, 0xe8, 0xcb, 0x51,
	0xc7, 0x06, 0xf3, 0xb4, 0x15, 0x00, 0xb8, 0x63,
	0x00, 0xbb, 0xb4, 0x00, 0xbf, 0x63, 0x00, 0xbe,
	0xba, 0x00, 0xb1, 0x0b, 0xb5, 0x03, 0xe8, 0x4a,
	0x4c, 0xc3, 0xbb, 0x64, 0x41, 0xe8, 0xb5, 0x40,
	0xc3, 0xbb, 0x64, 0x41, 0xe8, 0xae, 0x40, 0xc3,
	0xbb, 0xff, 0x41, 0xe8, 0xa7, 0x40, 0xc3, 0xbb,
	0x4e, 0x43, 0xe8, 0xa0, 0x40, 0xc3, 0xe8, 0x1d,
	0x45, 0xc3, 0x80, 0x3e, 0xb1, 0xdb, 0x01, 0x75,
	0x07, 0xbb, 0x80, 0x43, 0xe8, 0x8e, 0x40, 0xc3,
	0x8b, 0x36, 0xaf, 0x64, 0x8b, 0x3e, 0xb1, 0x64,
	0xc6, 0x06, 0xc3, 0x64, 0x04, 0xe8, 0x53, 0xd6,
	0xe8, 0xe2, 0xb7, 0xbb, 0xfc, 0xda, 0xe8, 0xcc,
	0xb1, 0xe8, 0xe1, 0xb1, 0xc3, 0xbb, 0xac, 0x43,
	0xe8, 0x6a, 0x40, 0xc3, 0xbb, 0xce, 0x43, 0xe8,
	0x63, 0x40, 0xc3, 0x80, 0x3e, 0x9a, 0xdb, 0x00,
	0x75, 0x0d, 0xe8, 0xc0, 0xb7, 0xbb, 0xf6, 0xda,
	0xe8, 0xaa, 0xb1, 0xe8, 0xbf, 0xb1, 0xc3, 0xe8,
	0xb3, 0xb7, 0xbb, 0x1e, 0x1e, 0xe8, 0xb5, 0xb1,
	0xe8, 0x3b, 0xbf, 0xe8, 0x41, 0xbb, 0xb0, 0x0c,
	0xe8, 0x1d, 0xc7, 0xb0, 0x0c, 0xe8, 0xc5, 0xb9,
	0xe8, 0xc5, 0xdf, 0xc6, 0x07, 0x00, 0xe8, 0x4b,
	0x4e, 0xb9, 0x05, 0x00, 0xb0, 0x06, 0xb4, 0x04,
	0xe8, 0xca, 0x49, 0xb9, 0x1d, 0x02, 0xe8, 0xec,
	0xba, 0xc3, 0xe8, 0x99, 0x44, 0xc3, 0x80, 0x3e,
	0xb3, 0xdb, 0x01, 0x75, 0x07, 0xbb, 0xa7, 0x44,
	0xe8, 0x0a, 0x40, 0xc3, 0xbb, 0x12, 0x44, 0xe8,
	0x18, 0x00, 0xbb, 0x4f, 0x44, 0xe8, 0x12, 0x00,
	0xbb, 0x6b, 0x44, 0xe8, 0x0c, 0x00, 0xbb, 0x92,
	0x44, 0xe8, 0xf1, 0x3f, 0xc6, 0x06, 0xb3, 0xdb,
	0x01, 0xc3, 0xe8, 0xe8, 0x3f, 0xb8, 0x96, 0x00,
	0xe8, 0xc7, 0xbe, 0xc3, 0xe8, 0x5f, 0x44, 0xc3,
	0xbb, 0x1e, 0x43, 0xe8, 0xd7, 0x3f, 0xc3, 0xe8,
	0x33, 0x00, 0xc3, 0x80, 0x3e, 0xa4, 0xdb, 0x01,
	0x74, 0x04, 0xe8, 0x28, 0x00, 0xc3, 0xe8, 0xc6,
	0xba, 0xe8, 0x54, 0xdf, 0xc6, 0x07, 0x00, 0xe8,
	0xda, 0x4d, 0xb9, 0x38, 0x00, 0xb0, 0x0a, 0xb4,
	0x02, 0xe8, 0x59, 0x49, 0xb9, 0x57, 0x02, 0xe8,
	0x7b, 0xba, 0xb0, 0x25, 0xe8, 0x89, 0xc6, 0xb0,
	0x02, 0xe8, 0x31, 0xb9, 0xc3, 0x80, 0x3e, 0xae,
	0xdb, 0x01, 0x75, 0x0a, 0xe8, 0x1a, 0x00, 0xbb,
	0xdd, 0x2f, 0xe8, 0x00, 0xb1, 0xc3, 0xbb, 0x41,
	0x2e, 0xe8, 0xf9, 0xb0, 0xe8, 0x0a, 0x00, 0xe8,
	0x83, 0xbe, 0xbb, 0x6d, 0x2e, 0xe8, 0xed, 0xb0,
	0xc3, 0xa0, 0xab, 0x64, 0x8a, 0x26, 0xaa, 0x64,
	0x50, 0xc6, 0x06, 0xab, 0x64, 0x02, 0xc6, 0x06,
	0xaa, 0x64, 0x02, 0xe8, 0xd1, 0xaa, 0xe8, 0x9d,
	0xaa, 0xb8, 0x03, 0x00, 0xe8, 0x4e, 0x43, 0x8b,
	0x77, 0x0d, 0x8b, 0x7f, 0x0f, 0x8a, 0x47, 0x11,
	0xa2, 0xc3, 0x64, 0xe8, 0x25, 0xd5, 0xe8, 0x22,
	0x00, 0xbe, 0x30, 0x00, 0xbf, 0xbe, 0x00, 0xc6,
	0x06, 0xc3, 0x64, 0x03, 0xe8, 0x14, 0xd5, 0x58,
	0xa2, 0xab, 0x64, 0x88, 0x26, 0xaa, 0x64, 0xe8,
	0x9d, 0xaa, 0xe8, 0x69, 0xaa, 0xc6, 0x06, 0xae,
	0xdb, 0x01, 0xc3, 0xb9, 0x34, 0x00, 0xb0, 0x0a,
	0xb4, 0x0b, 0xe8, 0xc8, 0x48, 0xb0, 0x0e, 0xe8,
	0xcc, 0x48, 0xb0, 0x12, 0xe8, 0xce, 0x48, 0xb0,
	0x15, 0xe8, 0xd0, 0x48, 0xb0, 0x19, 0xe8, 0xd2,
	0x48, 0xb0, 0x1c, 0xe8, 0xd4, 0x48, 0xb0, 0x20,
	0xe8, 0xd6, 0x48, 0xb9, 0x58, 0x02, 0xe8, 0x96,
	0xb9, 0xe8, 0x37, 0x4a, 0xc7, 0x06, 0xf3, 0xb4,
	0x15, 0x00, 0xb8, 0x29, 0x01, 0xbb, 0xb2, 0x00,
	0xbf, 0x29, 0x01, 0xbe, 0xb5, 0x00, 0xb1, 0x0b,
	0xb5, 0x03, 0xe8, 0x6e, 0x4a, 0xc3, 0x80, 0x3e,
	0xa4, 0xdb, 0x01, 0x75, 0x07, 0xbb, 0x01, 0x38,
	0xe8, 0xd2, 0x3e, 0xc3, 0xb9, 0x47, 0x00, 0xb0,
	0x06, 0xb4, 0x0c, 0xe8, 0x6f, 0x48, 0xb9, 0x56,
	0x02, 0xe8, 0x5b, 0xb9, 0xe8, 0x76, 0x4c, 0x80,
	0x3e, 0xad, 0x64, 0x01, 0x75, 0x0e, 0x8b, 0x16,
	0xb3, 0x32, 0xbe, 0x00, 0xfa, 0xb0, 0x40, 0xe8,
	0x78, 0x45, 0xeb, 0x0c, 0x8b, 0x16, 0xb3, 0x32,
	0xbe, 0x00, 0xfa, 0xb0, 0x40, 0xe8, 0x6a, 0x45,
	0xe8, 0x71, 0xb9, 0xe8, 0x2a, 0xde, 0xc6, 0x47,
	0x02, 0x00, 0xe8, 0xaf, 0x4c, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x94, 0x02, 0xb0, 0x01, 0xe8, 0x4f,
	0xb8, 0xe8, 0x18, 0x49, 0xb0, 0x01, 0xe8, 0x0c,
	0xb8, 0xb0, 0x01, 0xb4, 0x00, 0xe8, 0x99, 0xcc,
	0xe8, 0xad, 0xcc, 0xc6, 0x06, 0xa4, 0xdb, 0x01,
	0xc3, 0x80, 0x3e, 0xa4, 0xdb, 0x01, 0x74, 0x04,
	0xe8, 0x0b, 0x00, 0xc3, 0xbb, 0x1e, 0xdb, 0xe8,
	0xb3, 0xaf, 0xe8, 0xc8, 0xaf, 0xc3, 0xbb, 0x1d,
	0x46, 0xe8, 0x51, 0x3e, 0xc3, 0x80, 0x3e, 0xa4,
	0xdb, 0x01, 0x74, 0x04, 0xe8, 0xef, 0xff, 0xc3,
	0xbb, 0x0e, 0x45, 0xe8, 0x3f, 0x3e, 0xc3, 0x80,
	0x3e, 0xa4, 0xdb, 0x01, 0x74, 0x04, 0xe8, 0xdd,
	0xff, 0xc3, 0xbb, 0xd6, 0x44, 0xe8, 0x2d, 0x3e,
	0xc3, 0x80, 0x3e, 0xa4, 0xdb, 0x01, 0x74, 0x04,
	0xe8, 0xcb, 0xff, 0xc3, 0xa0, 0xb4, 0xdb, 0x0a,
	0xc0, 0x74, 0x20, 0x3c, 0x01, 0x74, 0x07, 0xbb,
	0x03, 0x46, 0xe8, 0x10, 0x3e, 0xc3, 0xbb, 0xb8,
	0x45, 0xe8, 0x09, 0x3e, 0xe8, 0x06, 0xbd, 0xbb,
	0xda, 0x45, 0xe8, 0x00, 0x3e, 0xc6, 0x06, 0xb4,
	0xdb, 0x02, 0xc3, 0xbb, 0x32, 0x45, 0xe8, 0xf4,
	0x3d, 0x8b, 0x36, 0xaf, 0x64, 0x8b, 0x3e, 0xb1,
	0x64, 0x83, 0xee, 0x1e, 0xc6, 0x06, 0xc3, 0x64,
	0x01, 0xe8, 0xb7, 0xd3, 0xbb, 0x55, 0x45, 0xe8,
	0xdb, 0x3d, 0xbb, 0x68, 0x45, 0xe8, 0x28, 0x00,
	0xbb, 0x7b, 0x45, 0xe8, 0x22, 0x00, 0xbb, 0x8e,
	0x45, 0xe8, 0x1c, 0x00, 0x8b, 0x36, 0xaf, 0x64,
	0x8b, 0x3e, 0xb1, 0x64, 0xc6, 0x06, 0xc3, 0x64,
	0x03, 0xe8, 0x8f, 0xd3, 0xbb, 0x9f, 0x45, 0xe8,
	0xb3, 0x3d, 0xc6, 0x06, 0xb4, 0xdb, 0x01, 0xc3,
	0x53, 0x8b, 0x36, 0xaf, 0x64, 0x8b, 0x3e, 0xb1,
	0x64, 0x83, 0xc6, 0x14, 0xc6, 0x06, 0xc3, 0x64,
	0x01, 0xe8, 0x6f, 0xd3, 0x5b, 0xe8, 0x95, 0x3d,
	0xc3, 0x80, 0x3e, 0xa4, 0xdb, 0x01, 0x74, 0x04,
	0xe8, 0x33, 0xff, 0xc3, 0xe8, 0x69, 0x3d, 0xc3,
	0xe8, 0x84, 0xb8, 0xb9, 0x1a, 0x00, 0xb0, 0x06,
	0xb4, 0x09, 0xe8, 0x20, 0x47, 0xb0, 0x0a, 0xe8,
	0x24, 0x47, 0xb9, 0x18, 0x00, 0xb0, 0x0d, 0xe8,
	0x23, 0x47, 0xb9, 0x2e, 0x00, 0xb0, 0x25, 0xe8,
	0x22, 0x47, 0xe8, 0xf3, 0xdc, 0xc6, 0x07, 0x00,
	0x53, 0xe8, 0x34, 0x4b, 0xc6, 0x06, 0x35, 0x33,
	0x10, 0xc6, 0x06, 0x36, 0x33, 0x18, 0xb8, 0x3c,
	0x46, 0xa3, 0x37, 0x33, 0xb8, 0xda, 0x78, 0xa3,
	0x39, 0x33, 0xc6, 0x06, 0xdc, 0x64, 0x00, 0xb9,
	0x52, 0x02, 0xe8, 0x52, 0xb8, 0xc6, 0x06, 0xdc,
	0x64, 0x01, 0x5b, 0xc6, 0x07, 0x1d, 0xe8, 0x07,
	0x4b, 0xb9, 0x05, 0x00, 0xb0, 0x02, 0xb4, 0x0a,
	0xe8, 0xca, 0x46, 0xb9, 0x53, 0x02, 0xe8, 0xec,
	0xb7, 0xb0, 0x01, 0xe8, 0xa7, 0xb6, 0xb0, 0x24,
	0xe8, 0xf5, 0xc3, 0xbb, 0x90, 0x37, 0xe8, 0x0c,
	0x3d, 0xc3, 0xbb, 0x5e, 0x46, 0xe8, 0x05, 0x3d,
	0xc3, 0x80, 0x3e, 0xac, 0xdb, 0x01, 0x74, 0x07,
	0xbb, 0xd2, 0x3b, 0xe8, 0xf7, 0x3c, 0xc3, 0xb9,
	0x08, 0x00, 0xe8, 0xe6, 0x4d, 0xc7, 0x06, 0xf3,
	0xb4, 0x1a, 0x00, 0xb8, 0x3f, 0x01, 0xbb, 0xa9,
	0x00, 0xbf, 0x14, 0x01, 0xbe, 0xa9, 0x00, 0xb1,
	0x01, 0xb5, 0x04, 0xe8, 0x65, 0x48, 0xc3, 0xc7,
	0x06, 0xf3, 0xb4, 0x15, 0x00, 0xb8, 0xce, 0x00,
	0xbb, 0xc7, 0x00, 0xbf, 0xc4, 0x00, 0xbe, 0xc2,
	0x00, 0xb1, 0x13, 0xb5, 0x01, 0xe8, 0x4b, 0x48,
	0xc3, 0xbb, 0xf7, 0x46, 0xe8, 0xb6, 0x3c, 0xc3,
	0xbb, 0x3d, 0x47, 0xe8, 0xaf, 0x3c, 0xc3, 0xbb,
	0x3d, 0x47, 0xe8, 0xa8, 0x3c, 0xc3, 0xbb, 0x7b,
	0x47, 0xe8, 0xa1, 0x3c, 0xc3, 0xbb, 0x98, 0x47,
	0xe8, 0x9a, 0x3c, 0xc3, 0xb9, 0x06, 0x00, 0xe8,
	0x89, 0x4d, 0xc7, 0x06, 0xf3, 0xb4, 0x19, 0x00,
	0xb8, 0x97, 0x00, 0xbb, 0x9c, 0x00, 0xbf, 0xea,
	0x00, 0xbe, 0x98, 0x00, 0xb1, 0x01, 0xb5, 0x02,
	0xe8, 0x08, 0x48, 0xc3, 0xbb, 0x75, 0x33, 0xe8,
	0xe3, 0xad, 0xc3, 0xbb, 0xbf, 0x47, 0xe8, 0x6c,
	0x3c, 0xc3, 0xb9, 0x05, 0x00, 0xb0, 0x0a, 0xb4,
	0x0c, 0xe8, 0x09, 0x46, 0xe8, 0x60, 0xb7, 0xe8,
	0xee, 0xdb, 0xc6, 0x07, 0x00, 0xe8, 0x74, 0x4a,
	0xb9, 0x80, 0x02, 0xe8, 0x11, 0xb7, 0xb0, 0x32,
	0xe8, 0x2d, 0xc3, 0xb0, 0x06, 0xe8, 0xd5, 0xb5,
	0xc3, 0x80, 0x3e, 0x93, 0xdb, 0x01, 0x75, 0x07,
	0xbb, 0x08, 0x3e, 0xe8, 0x37, 0x3c, 0xc3, 0xc6,
	0x06, 0x93, 0xdb, 0x01, 0xbb, 0xc6, 0x3d, 0xe8,
	0x2b, 0x3c, 0xb9, 0x1e, 0x00, 0xb0, 0x1a, 0xb4,
	0x0a, 0xe8, 0xc9, 0x45, 0xb9, 0x1d, 0x00, 0xb0,
	0x31, 0xb4, 0x0f, 0xe8, 0xc8, 0x45, 0xe8, 0x16,
	0xb7, 0xb4, 0x01, 0xb0, 0x57, 0xe8, 0x9f, 0xba,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0xf5, 0x01, 0xb9,
	0xf4, 0x01, 0xe8, 0x9d, 0xb6, 0xe8, 0x90, 0xdb,
	0xb0, 0x01, 0x88, 0x07, 0xe8, 0xc2, 0x4a, 0xb0,
	0x0e, 0xe8, 0x75, 0xb5, 0xe8, 0xc5, 0xb6, 0xbb,
	0xf4, 0x3d, 0xe8, 0xe8, 0x3b, 0xc3, 0xbb, 0xc1,
	0x32, 0xe8, 0x51, 0xad, 0xc3, 0xe8, 0xf6, 0xff,
	0xc3, 0xbb, 0x5e, 0x32, 0xe8, 0x46, 0xad, 0xc3,
	0x80, 0x3e, 0x96, 0xdb, 0x01, 0x74, 0x07, 0xbb,
	0xb2, 0x3e, 0xe8, 0xc8, 0x3b, 0xc3, 0xb9, 0x38,
	0x00, 0xb0, 0x07, 0xb4, 0x09, 0xe8, 0x65, 0x45,
	0xb9, 0x05, 0x00, 0xb0, 0x0f, 0xe8, 0x66, 0x45,
	0xb9, 0x65, 0x02, 0xe8, 0x49, 0xb6, 0xe8, 0x3f,
	0xdb, 0xc6, 0x47, 0x03, 0x24, 0xe8, 0x80, 0x49,
	0xe8, 0x79, 0xb6, 0xb0, 0x27, 0xe8, 0x80, 0xc2,
	0xb0, 0x05, 0xe8, 0x28, 0xb5, 0xbb, 0x7c, 0x38,
	0xe8, 0x92, 0x3b, 0xc3, 0x80, 0x3e, 0x96, 0xdb,
	0x01, 0x74, 0x07, 0xbb, 0xb2, 0x3e, 0xe8, 0x84,
	0x3b, 0xc3, 0xe8, 0x82, 0xb6, 0x83, 0x06, 0xaf,
	0x64, 0x04, 0xe8, 0x0b, 0xdb, 0xc6, 0x47, 0x02,
	0x23, 0xe8, 0x90, 0x49, 0xb9, 0x3f, 0x00, 0xb0,
	0x08, 0xb4, 0x09, 0xe8, 0x0f, 0x45, 0xb9, 0x18,
	0x00, 0xb0, 0x0a, 0xe8, 0x10, 0x45, 0xb9, 0x64,
	0x02, 0xe8, 0x1b, 0xb6, 0xb0, 0x28, 0xe8, 0x37,
	0xc2, 0xb0, 0x06, 0xe8, 0xdf, 0xb4, 0xc3, 0x80,
	0x3e, 0x96, 0xdb, 0x01, 0x74, 0x07, 0xbb, 0xe7,
	0x47, 0xe8, 0x41, 0x3b, 0xc3, 0xe8, 0xbe, 0x3f,
	0xc3, 0xe8, 0x3b, 0xb6, 0xe8, 0xc9, 0xda, 0xc6,
	0x47, 0x04, 0x00, 0xe8, 0x4e, 0x49, 0xb9, 0x05,
	0x00, 0xb0, 0x0b, 0xb4, 0x05, 0xe8, 0xcd, 0x44,
	0xb9, 0x71, 0x02, 0xe8, 0xef, 0xb5, 0xb0, 0x2c,
	0xe8, 0xfd, 0xc1, 0xb0, 0x08, 0xe8, 0xa5, 0xb4,
	0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x14, 0x00, 0xb8,
	0x05, 0x00, 0xbb, 0x83, 0x00, 0xbf, 0x0e, 0x00,
	0xbe, 0xb9, 0x00, 0xb1, 0x0b, 0xb5, 0x03, 0xe8,
	0x89, 0x46, 0xc3, 0x80, 0x3e, 0x9d, 0xdb, 0x01,
	0x75, 0x07, 0xbb, 0x6a, 0x35, 0xe8, 0xed, 0x3a,
	0xc3, 0xc6, 0x06, 0x9d, 0xdb, 0x01, 0xb0, 0x11,
	0xe8, 0xc5, 0xc1, 0xb9, 0x31, 0x00, 0xb0, 0x03,
	0xb4, 0x05, 0xe8, 0x80, 0x44, 0xb9, 0x05, 0x00,
	0xb0, 0x1a, 0xe8, 0x81, 0x44, 0xb9, 0x24, 0x02,
	0xe8, 0x93, 0xb5, 0xbb, 0xb2, 0x35, 0xe8, 0xc4,
	0x3a, 0xc3, 0xe8, 0xc2, 0xb5, 0xb9, 0x12, 0x00,
	0xb0, 0x0a, 0xb4, 0x05, 0xe8, 0x5e, 0x44, 0xe8,
	0x46, 0xda, 0xc6, 0x47, 0x01, 0x00, 0xe8, 0xcb,
	0x48, 0xb9, 0x29, 0x02, 0xe8, 0x76, 0xb5, 0xb0,
	0x15, 0xe8, 0x84, 0xc1, 0xb0, 0x0b, 0xe8, 0x2c,
	0xb4, 0xe8, 0x92, 0xb9, 0xbb, 0x05, 0x36, 0xe8,
	0x93, 0x3a, 0xc3, 0x80, 0x3e, 0xa9, 0xdb, 0x01,
	0x74, 0x07, 0xbb, 0x08, 0x48, 0xe8, 0x85, 0x3a,
	0xc3, 0xb9, 0x7b, 0x02, 0xe8, 0x28, 0xb5, 0xe8,
	0x0e, 0xda, 0xc6, 0x47, 0x05, 0x00, 0xe8, 0x4f,
	0x48, 0xb9, 0x3f, 0x00, 0xb0, 0x0b, 0xb4, 0x06,
	0xe8, 0x12, 0x44, 0xb9, 0x0f, 0x00, 0xb0, 0x14,
	0xe8, 0x13, 0x44, 0xb9, 0x20, 0x00, 0xb0, 0x1f,
	0xb4, 0x09, 0xe8, 0x10, 0x44, 0xb9, 0x7c, 0x02,
	0xe8, 0xff, 0xb4, 0xff, 0x0e, 0xaf, 0x64, 0xc7,
	0x06, 0xb1, 0x64, 0x8b, 0x00, 0xc6, 0x06, 0xcc,
	0x64, 0x01, 0xc6, 0x06, 0xdc, 0x64, 0x00, 0xe8,
	0x12, 0xb5, 0xb0, 0x30, 0xe8, 0x19, 0xc1, 0xb0,
	0x2f, 0xe8, 0x14, 0xc1, 0xbb, 0x83, 0x3b, 0xe8,
	0x2b, 0x3a, 0xc6, 0x06, 0xa9, 0xdb, 0x02, 0xc6,
	0x06, 0xa8, 0xdb, 0x00, 0xc3, 0xbb, 0x28, 0x48,
	0xe8, 0x1a, 0x3a, 0xc3, 0xe8, 0x18, 0xb5, 0xe8,
	0xa6, 0xd9, 0xc6, 0x07, 0x00, 0xe8, 0x2c, 0x48,
	0xb9, 0x05, 0x00, 0xb0, 0x09, 0xb4, 0x0b, 0xe8,
	0xab, 0x43, 0xb9, 0xff, 0x01, 0xe8, 0xbf, 0xb4,
	0xb0, 0x01, 0xe8, 0xdb, 0xc0, 0xb0, 0x0e, 0xe8,
	0x83, 0xb3, 0xc3, 0xbb, 0x28, 0x48, 0xe8, 0xec,
	0x39, 0xc3, 0xbb, 0x60, 0x48, 0xe8, 0xe5, 0x39,
	0xc3, 0xbb, 0x3f, 0x5b, 0xe8, 0xde, 0x39, 0xc3,
	0xe8, 0x5b, 0x3e, 0xc3, 0xb9, 0x46, 0x00, 0xb0,
	0x04, 0xb4, 0x0c, 0xe8, 0x77, 0x43, 0xb9, 0xcc,
	0x03, 0xe8, 0x63, 0xb4, 0xe8, 0x04, 0x45, 0xc7,
	0x06, 0xf3, 0xb4, 0x1d, 0x00, 0xb8, 0xa0, 0x00,
	0xbb, 0xc7, 0x00, 0xbf, 0xa0, 0x00, 0xbe, 0xbc,
	0x00, 0xb1, 0x13, 0xb5, 0x01, 0xe8, 0x3b, 0x45,
	0xc3, 0xbb, 0x7e, 0x4a, 0xe8, 0xa6, 0x39, 0xb0,
	0x04, 0xe8, 0x31, 0xb3, 0xc3, 0xb9, 0x59, 0x00,
	0xb0, 0x05, 0xb4, 0x0b, 0xe8, 0x3e, 0x43, 0xb9,
	0xc9, 0x03, 0xe8, 0x3a, 0xb4, 0xe8, 0xcb, 0x44,
	0xc7, 0x06, 0xf3, 0xb4, 0x21, 0x00, 0xb8, 0x3f,
	0x01, 0xbb, 0xb5, 0x00, 0xbf, 0x2d, 0x01, 0xbe,
	0xb5, 0x00, 0xb1, 0x01, 0xb5, 0x04, 0xe8, 0x02,
	0x45, 0xc3, 0xb9, 0x58, 0x00, 0xb0, 0x04, 0xb4,
	0x02, 0xe8, 0x11, 0x43, 0xb9, 0xca, 0x03, 0xe8,
	0xfd, 0xb3, 0xe8, 0x9e, 0x44, 0xc7, 0x06, 0xf3,
	0xb4, 0x23, 0x00, 0xb8, 0xa0, 0x00, 0xbb, 0xc7,
	0x00, 0xbf, 0xa0, 0x00, 0xbe, 0xbb, 0x00, 0xb1,
	0x13, 0xb5, 0x01, 0xe8, 0xd5, 0x44, 0xc3, 0xbb,
	0x51, 0x5b, 0xe8, 0x40, 0x39, 0xc3, 0xbb, 0x0f,
	0x57, 0xe8, 0x39, 0x39, 0xc3, 0xbb, 0x46, 0x67,
	0xe8, 0xb7, 0xd8, 0x83, 0xc3, 0x03, 0xff, 0x37,
	0x53, 0xc7, 0x07, 0x3f, 0x01, 0xbe, 0x99, 0x00,
	0xbf, 0xa3, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x04,
	0xe8, 0xf0, 0xce, 0xb9, 0xcd, 0x03, 0xe8, 0xbe,
	0xb3, 0xe8, 0x4f, 0x44, 0x5b, 0x8f, 0x07, 0x80,
	0x3e, 0xc1, 0xdb, 0x00, 0x75, 0x0a, 0xb8, 0x06,
	0x00, 0xe8, 0x0f, 0x4a, 0x40, 0xa2, 0xc1, 0xdb,
	0xc7, 0x06, 0xf3, 0xb4, 0x1e, 0x00, 0xb8, 0x12,
	0x00, 0xbb, 0x9f, 0x00, 0xbf, 0x31, 0x00, 0xbe,
	0xb4, 0x00, 0xb1, 0x01, 0xb5, 0x02, 0xe8, 0x72,
	0x44, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x1f, 0x00,
	0xb8, 0x00, 0x00, 0xbb, 0xbc, 0x00, 0xbf, 0x28,
	0x00, 0xbe, 0xbc, 0x00, 0xb1, 0x01, 0xb5, 0x02,
	0xe8, 0x58, 0x44, 0xc3, 0xc7, 0x06, 0xf3, 0xb4,
	0x1c, 0x00, 0xb8, 0xd0, 0x00, 0xbb, 0x99, 0x00,
	0xbf, 0xaa, 0x00, 0xbe, 0x99, 0x00, 0xb1, 0x01,
	0xb5, 0x04, 0xe8, 0x3e, 0x44, 0xc3, 0xc7, 0x06,
	0xaf, 0x64, 0x95, 0x00, 0xc7, 0x06, 0xb1, 0x64,
	0xa3, 0x00, 0xc6, 0x06, 0xcc, 0x64, 0x01, 0xc6,
	0x06, 0xdc, 0x64, 0x00, 0xc6, 0x06, 0xcb, 0x64,
	0x00, 0xe8, 0xb5, 0xd6, 0xc7, 0x06, 0xf3, 0xb4,
	0x1d, 0x00, 0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xe8,
	0x55, 0x44, 0xbb, 0x46, 0x67, 0xe8, 0x02, 0xd8,
	0x83, 0xc3, 0x03, 0xff, 0x37, 0x53, 0xc7, 0x07,
	0x3f, 0x01, 0xb9, 0xce, 0x03, 0xc6, 0x06, 0xdc,
	0x1c, 0x01, 0xe8, 0x23, 0xb3, 0xbe, 0xa0, 0x00,
	0xbf, 0xbc, 0x00, 0xe8, 0x35, 0xce, 0x5b, 0x8f,
	0x07, 0xc3, 0xe8, 0xd9, 0x3c, 0xc3, 0xbb, 0xab,
	0x5b, 0xe8, 0x51, 0x38, 0xc3, 0xe8, 0x41, 0x00,
	0xb9, 0x20, 0x00, 0xb0, 0x0c, 0xb4, 0x09, 0xe8,
	0xeb, 0x41, 0xb9, 0xb6, 0x02, 0xe8, 0xf8, 0xb2,
	0xb9, 0x0f, 0x00, 0xb0, 0x08, 0xb4, 0x09, 0xe8,
	0xdb, 0x41, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xb5,
	0x02, 0xb0, 0x01, 0xe8, 0x3b, 0xb2, 0xe8, 0xb7,
	0xd7, 0xc6, 0x47, 0x06, 0x00, 0xe8, 0x3c, 0x46,
	0xbb, 0xc7, 0x4c, 0xe8, 0x17, 0x38, 0xb0, 0x36,
	0xe8, 0xf5, 0xbe, 0xb0, 0x04, 0xe8, 0x9d, 0xb1,
	0xc3, 0xbe, 0xd3, 0x00, 0xbf, 0x97, 0x00, 0x81,
	0x3e, 0xaf, 0x64, 0xd0, 0x00, 0x75, 0x1a, 0x81,
	0x3e, 0xb1, 0x64, 0x97, 0x00, 0x75, 0x12, 0xc6,
	0x06, 0xc3, 0x64, 0x02, 0x57, 0x56, 0xe8, 0xc2,
	0xcd, 0xb8, 0x09, 0x00, 0xe8, 0xcb, 0xb6, 0x5e,
	0x5f, 0xc6, 0x06, 0xc3, 0x64, 0x01, 0xe8, 0xb2,
	0xcd, 0xc3, 0x80, 0x3e, 0xc2, 0xdb, 0x01, 0x75,
	0x07, 0xbb, 0xa0, 0x4c, 0xe8, 0xce, 0x37, 0xc3,
	0xb9, 0x31, 0x00, 0xb0, 0x05, 0xb4, 0x09, 0xe8,
	0x6b, 0x41, 0xb0, 0x11, 0xe8, 0x6f, 0x41, 0xb9,
	0xb3, 0x02, 0xe8, 0x73, 0xb2, 0xe8, 0x46, 0x00,
	0x73, 0x31, 0xb9, 0x0f, 0x00, 0xb0, 0x08, 0xb4,
	0x09, 0xe8, 0x51, 0x41, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0xb4, 0x02, 0xb0, 0x01, 0xe8, 0xb1, 0xb1,
	0xe8, 0x2d, 0xd7, 0xc6, 0x47, 0x06, 0x3b, 0xe8,
	0xb2, 0x45, 0xb0, 0x04, 0xe8, 0x12, 0xb1, 0xbb,
	0x84, 0x4c, 0xe8, 0x88, 0x37, 0xc6, 0x06, 0xc2,
	0xdb, 0x01, 0xc3, 0x80, 0x3e, 0xc0, 0xdb, 0x01,
	0x74, 0x0b, 0xc6, 0x06, 0xc0, 0xdb, 0x01, 0xbb,
	0x61, 0x4c, 0xe8, 0x70, 0x37, 0xc3, 0xa0, 0xc1,
	0xdb, 0x98, 0x48, 0xbb, 0xb7, 0xdb, 0x53, 0x03,
	0xd8, 0x80, 0x3f, 0x01, 0x5b, 0x75, 0x18, 0x8b,
	0x07, 0x8b, 0x4f, 0x02, 0x8b, 0x57, 0x04, 0x02,
	0xc4, 0x02, 0xc1, 0x02, 0xc5, 0x02, 0xc2, 0x02,
	0xc6, 0x3c, 0x01, 0x75, 0x02, 0xf9, 0xc3, 0xf8,
	0xc3, 0xbb, 0xe7, 0x5b, 0xe8, 0x3e, 0x37, 0xc3,
	0xb0, 0x37, 0xe8, 0x4f, 0xbe, 0x73, 0x07, 0xbb,
	0xd9, 0x4c, 0xe8, 0x30, 0x37, 0xc3, 0x80, 0x3e,
	0xc3, 0xdb, 0x01, 0x74, 0x11, 0xc6, 0x06, 0xc3,
	0xdb, 0x01, 0xb9, 0xb7, 0x02, 0xe8, 0xe6, 0xb1,
	0xbb, 0x6a, 0x38, 0xe8, 0x87, 0xa8, 0xb9, 0x05,
	0x00, 0xb0, 0x0b, 0xb4, 0x0a, 0xe8, 0xb5, 0x40,
	0xb9, 0xb8, 0x02, 0xe8, 0xd0, 0xb1, 0xb0, 0x37,
	0xe8, 0xe5, 0xbd, 0xc3, 0xbb, 0x0b, 0x5c, 0xe8,
	0xfb, 0x36, 0xc3, 0xbb, 0x26, 0x5c, 0xe8, 0xf4,
	0x36, 0xc3, 0x80, 0x3e, 0xb7, 0xdb, 0x01, 0x74,
	0x2d, 0x80, 0x3e, 0xb8, 0xdb, 0x01, 0x75, 0x04,
	0xe8, 0x13, 0x02, 0xc3, 0xb9, 0x42, 0x00, 0xb0,
	0x04, 0xb4, 0x07, 0xe8, 0x7f, 0x40, 0xb9, 0xa5,
	0x02, 0xe8, 0x6b, 0xb1, 0xe8, 0x61, 0xd6, 0xc6,
	0x07, 0x35, 0xe8, 0xa3, 0x44, 0xe8, 0x9c, 0xb1,
	0xc6, 0x06, 0xb7, 0xdb, 0x01, 0xc3, 0xe8, 0xbe,
	0xb1, 0xe8, 0x4c, 0xd6, 0xc6, 0x07, 0x00, 0xe8,
	0xd2, 0x44, 0xb9, 0x43, 0x00, 0xb0, 0x04, 0xb4,
	0x07, 0xe8, 0x51, 0x40, 0xb9, 0xa6, 0x02, 0xe8,
	0x65, 0xb1, 0xc6, 0x06, 0xb7, 0xdb, 0x00, 0xc3,
	0x80, 0x3e, 0xb8, 0xdb, 0x01, 0x74, 0x39, 0x80,
	0x3e, 0xb7, 0xdb, 0x01, 0x75, 0x04, 0xe8, 0xbd,
	0x01, 0xc3, 0x80, 0x3e, 0xb9, 0xdb, 0x01, 0x75,
	0x04, 0xe8, 0xb2, 0x01, 0xc3, 0xb9, 0x42, 0x00,
	0xb0, 0x05, 0xb4, 0x07, 0xe8, 0x1e, 0x40, 0xb9,
	0xa7, 0x02, 0xe8, 0x0a, 0xb1, 0xe8, 0x00, 0xd6,
	0xc6, 0x47, 0x01, 0x36, 0xe8, 0x41, 0x44, 0xe8,
	0x3a, 0xb1, 0xc6, 0x06, 0xb8, 0xdb, 0x01, 0xc3,
	0xe8, 0x5c, 0xb1, 0xe8, 0xea, 0xd5, 0xc6, 0x47,
	0x01, 0x00, 0xe8, 0x6f, 0x44, 0xb9, 0x43, 0x00,
	0xb0, 0x04, 0xb4, 0x07, 0xe8, 0xee, 0x3f, 0xb9,
	0xa8, 0x02, 0xe8, 0x02, 0xb1, 0xc6, 0x06, 0xb8,
	0xdb, 0x00, 0xc3, 0x80, 0x3e, 0xb9, 0xdb, 0x01,
	0x74, 0x2e, 0x80, 0x3e, 0xb8, 0xdb, 0x01, 0x75,
	0x04, 0xe8, 0x5a, 0x01, 0xc3, 0xb9, 0x43, 0x00,
	0xb0, 0x05, 0xb4, 0x07, 0xe8, 0xc6, 0x3f, 0xb9,
	0xa9, 0x02, 0xe8, 0xb2, 0xb0, 0xe8, 0xa8, 0xd5,
	0xc6, 0x47, 0x02, 0x37, 0xe8, 0xe9, 0x43, 0xe8,
	0xe2, 0xb0, 0xc6, 0x06, 0xb9, 0xdb, 0x01, 0xc3,
	0xe8, 0x04, 0xb1, 0xe8, 0x92, 0xd5, 0xc6, 0x47,
	0x02, 0x00, 0xe8, 0x17, 0x44, 0xb9, 0x43, 0x00,
	0xb0, 0x05, 0xb4, 0x07, 0xe8, 0x96, 0x3f, 0xb9,
	0xaa, 0x02, 0xe8, 0xaa, 0xb0, 0xc6, 0x06, 0xb9,
	0xdb, 0x00, 0xc3, 0x80, 0x3e, 0xba, 0xdb, 0x01,
	0x74, 0x2e, 0x80, 0x3e, 0xbb, 0xdb, 0x01, 0x75,
	0x04, 0xe8, 0x02, 0x01, 0xc3, 0xb9, 0x42, 0x00,
	0xb0, 0x04, 0xb4, 0x07, 0xe8, 0x6e, 0x3f, 0xb9,
	0xab, 0x02, 0xe8, 0x5a, 0xb0, 0xe8, 0x50, 0xd5,
	0xc6, 0x47, 0x03, 0x38, 0xe8, 0x91, 0x43, 0xe8,
	0x8a, 0xb0, 0xc6, 0x06, 0xba, 0xdb, 0x01, 0xc3,
	0xe8, 0xac, 0xb0, 0xe8, 0x3a, 0xd5, 0xc6, 0x47,
	0x03, 0x00, 0xe8, 0xbf, 0x43, 0xb9, 0x43, 0x00,
	0xb0, 0x04, 0xb4, 0x07, 0xe8, 0x3e, 0x3f, 0xb9,
	0xac, 0x02, 0xe8, 0x52, 0xb0, 0xc6, 0x06, 0xba,
	0xdb, 0x00, 0xc3, 0x80, 0x3e, 0xbb, 0xdb, 0x01,
	0x74, 0x39, 0x80, 0x3e, 0xba, 0xdb, 0x01, 0x75,
	0x04, 0xe8, 0xaa, 0x00, 0xc3, 0x80, 0x3e, 0xbc,
	0xdb, 0x01, 0x75, 0x04, 0xe8, 0x9f, 0x00, 0xc3,
	0xb9, 0x42, 0x00, 0xb0, 0x05, 0xb4, 0x07, 0xe8,
	0x0b, 0x3f, 0xb9, 0xad, 0x02, 0xe8, 0xf7, 0xaf,
	0xe8, 0xed, 0xd4, 0xc6, 0x47, 0x04, 0x39, 0xe8,
	0x2e, 0x43, 0xe8, 0x27, 0xb0, 0xc6, 0x06, 0xbb,
	0xdb, 0x01, 0xc3, 0xe8, 0x49, 0xb0, 0xe8, 0xd7,
	0xd4, 0xc6, 0x47, 0x04, 0x00, 0xe8, 0x5c, 0x43,
	0xb9, 0x43, 0x00, 0xb0, 0x04, 0xb4, 0x07, 0xe8,
	0xdb, 0x3e, 0xb9, 0xae, 0x02, 0xe8, 0xef, 0xaf,
	0xc6, 0x06, 0xbb, 0xdb, 0x00, 0xc3, 0x80, 0x3e,
	0xbc, 0xdb, 0x01, 0x74, 0x2e, 0x80, 0x3e, 0xbb,
	0xdb, 0x01, 0x75, 0x04, 0xe8, 0x47, 0x00, 0xc3,
	0xb9, 0x42, 0x00, 0xb0, 0x06, 0xb4, 0x07, 0xe8,
	0xb3, 0x3e, 0xb9, 0xaf, 0x02, 0xe8, 0x9f, 0xaf,
	0xe8, 0x95, 0xd4, 0xc6, 0x47, 0x05, 0x3a, 0xe8,
	0xd6, 0x42, 0xe8, 0xcf, 0xaf, 0xc6, 0x06, 0xbc,
	0xdb, 0x01, 0xc3, 0xe8, 0xf1, 0xaf, 0xe8, 0x7f,
	0xd4, 0xc6, 0x47, 0x05, 0x00, 0xe8, 0x04, 0x43,
	0xb9, 0x43, 0x00, 0xb0, 0x05, 0xb4, 0x07, 0xe8,
	0x83, 0x3e, 0xb9, 0xb0, 0x02, 0xe8, 0x97, 0xaf,
	0xc6, 0x06, 0xbc, 0xdb, 0x00, 0xc3, 0x80, 0x3e,
	0xbd, 0xdb, 0x01, 0x74, 0x12, 0xbb, 0xcd, 0x4a,
	0xe8, 0xc2, 0x34, 0xbb, 0x0d, 0x4b, 0xe8, 0xbc,
	0x34, 0xc6, 0x06, 0xbd, 0xdb, 0x01, 0xc3, 0xbb,
	0x39, 0x4b, 0xe8, 0xb0, 0x34, 0xc3, 0xbb, 0x46,
	0x5c, 0xe8, 0xa9, 0x34, 0xc3, 0xb9, 0x50, 0x00,
	0xb0, 0x04, 0xb4, 0x0a, 0xe8, 0x46, 0x3e, 0xb9,
	0xcb, 0x03, 0xe8, 0x32, 0xaf, 0xe8, 0xd3, 0x3f,
	0xc7, 0x06, 0xf3, 0xb4, 0x20, 0x00, 0xb8, 0x8b,
	0x00, 0xbb, 0xc7, 0x00, 0xbf, 0x8b, 0x00, 0xbe,
	0xbc, 0x00, 0xb1, 0x13, 0xb5, 0x01, 0xe8, 0x0a,
	0x40, 0xc3, 0xbb, 0x65, 0x5b, 0xe8, 0x75, 0x34,
	0xc3, 0x80, 0x3e, 0xd9, 0xdb, 0x01, 0x75, 0x07,
	0xbb, 0x26, 0x53, 0xe8, 0x67, 0x34, 0xc3, 0xb9,
	0x58, 0x00, 0xb0, 0x04, 0xb4, 0x0e, 0xe8, 0x04,
	0x3e, 0xb9, 0x28, 0x03, 0xe8, 0xf0, 0xae, 0xe8,
	0x91, 0x3f, 0xc7, 0x06, 0xf3, 0xb4, 0x24, 0x00,
	0xb8, 0x29, 0x00, 0xbb, 0xc3, 0x00, 0xbf, 0x32,
	0x00, 0xbe, 0xc3, 0x00, 0xb1, 0x01, 0xb5, 0x02,
	0xe8, 0xc8, 0x3f, 0xc3, 0xe8, 0xb7, 0x38, 0xc3,
	0xe8, 0xb3, 0x38, 0xc3, 0xbb, 0x51, 0x5b, 0xe8,
	0x2b, 0x34, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x1d,
	0x00, 0xb8, 0x3f, 0x01, 0xbb, 0xbc, 0x00, 0xbf,
	0x18, 0x01, 0xbe, 0xbc, 0x00, 0xb1, 0x01, 0xb5,
	0x04, 0xe8, 0x9f, 0x3f, 0xc3, 0xb9, 0x59, 0x00,
	0xb0, 0x06, 0xb4, 0x0c, 0xe8, 0xae, 0x3d, 0xb9,
	0x26, 0x03, 0x80, 0x3e, 0xef, 0xdb, 0x01, 0x75,
	0x03, 0xb9, 0xd9, 0x03, 0xe8, 0x90, 0xae, 0xe8,
	0x31, 0x3f, 0xc7, 0x06, 0xf3, 0xb4, 0x22, 0x00,
	0xb8, 0x28, 0x00, 0xbb, 0x85, 0x00, 0xbf, 0x34,
	0x00, 0xbe, 0x85, 0x00, 0xb1, 0x01, 0xb5, 0x02,
	0xe8, 0x68, 0x3f, 0xc3, 0xbb, 0x80, 0x5b, 0xe8,
	0xd3, 0x33, 0xc3, 0xe8, 0xbb, 0xac, 0xbb, 0x2e,
	0xdb, 0xe8, 0x21, 0xa5, 0xe8, 0x36, 0xa5, 0xb0,
	0x01, 0xbe, 0x94, 0xaa, 0xe8, 0x5a, 0xad, 0xc6,
	0x06, 0xd1, 0xdb, 0x01, 0xc3, 0xe8, 0xb7, 0xae,
	0xe8, 0x45, 0xd3, 0xc6, 0x07, 0x47, 0xe8, 0xcb,
	0x41, 0xb9, 0x20, 0x00, 0xb0, 0x05, 0xb4, 0x04,
	0xe8, 0x4a, 0x3d, 0xb9, 0xdc, 0x02, 0xe8, 0x5e,
	0xae, 0xb0, 0x02, 0xe8, 0x27, 0xad, 0xb0, 0x48,
	0xe8, 0x75, 0xba, 0xc3, 0xb9, 0xf2, 0x02, 0xe8,
	0x25, 0xae, 0xe8, 0xc6, 0x3e, 0xbe, 0xde, 0x76,
	0xbb, 0x7b, 0x51, 0x06, 0x53, 0x56, 0xb8, 0x00,
	0xa0, 0x8e, 0xc0, 0xe8, 0x67, 0x2f, 0xb8, 0x00,
	0xa0, 0xb9, 0x00, 0x7d, 0xe8, 0x19, 0x40, 0x5e,
	0x5b, 0xe8, 0x69, 0x37, 0xe8, 0x65, 0x2f, 0xb8,
	0x0e, 0x01, 0xe8, 0x67, 0xb2, 0xe8, 0x4d, 0x2f,
	0xa1, 0xb3, 0x32, 0x8e, 0xc0, 0xbf, 0x00, 0xfa,
	0xb9, 0x80, 0x01, 0x33, 0xc0, 0xfc, 0xf3, 0xab,
	0x07, 0xb9, 0x03, 0x00, 0xe8, 0x3c, 0x44, 0xc7,
	0x06, 0xf3, 0xb4, 0x0b, 0x00, 0xe8, 0xf4, 0x3f,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0xee, 0x02,
	0xb0, 0x02, 0xe8, 0x3d, 0xad, 0xc6, 0x06, 0x45,
	0x33, 0xe5, 0xc6, 0x06, 0x46, 0x33, 0xd9, 0xb0,
	0x02, 0xb4, 0x01, 0xbe, 0xef, 0x02, 0xbf, 0x11,
	0x02, 0xbb, 0x50, 0x4f, 0xe8, 0x2f, 0xa7, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0xf0, 0x02, 0xc7, 0x47,
	0x02, 0xf1, 0x02, 0xb0, 0x01, 0xe8, 0x12, 0xad,
	0xc6, 0x06, 0x45, 0x33, 0xd9, 0xc6, 0x06, 0x46,
	0x33, 0xe5, 0xb0, 0x01, 0xb4, 0x02, 0xbe, 0x11,
	0x02, 0xbf, 0xef, 0x02, 0xbb, 0x68, 0x51, 0xe8,
	0x04, 0xa7, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0xdd, 0x02, 0xc7, 0x47, 0x04, 0xde, 0x02, 0xc7,
	0x06, 0xf3, 0xb4, 0x1e, 0x00, 0xe8, 0x8c, 0x3f,
	0xc6, 0x06, 0x45, 0x33, 0xe5, 0xc6, 0x06, 0x46,
	0x33, 0xd0, 0xb0, 0x02, 0xb4, 0x03, 0xbe, 0xdd,
	0x02, 0xbf, 0xde, 0x02, 0xbb, 0x9e, 0x44, 0xe8,
	0xd4, 0xa6, 0xb9, 0x4b, 0x00, 0xb0, 0x0d, 0xb4,
	0x04, 0xe8, 0x59, 0x3c, 0xb9, 0x20, 0x00, 0xb0,
	0x16, 0xe8, 0x5a, 0x3c, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x02, 0xdf, 0x02, 0xc7, 0x47, 0x04, 0xe0,
	0x02, 0xb0, 0x02, 0xe8, 0xa4, 0xac, 0xc6, 0x06,
	0x46, 0x33, 0xe5, 0xc6, 0x06, 0x45, 0x33, 0xd0,
	0xb0, 0x03, 0xb4, 0x02, 0xbe, 0xe1, 0x02, 0xbf,
	0xe2, 0x02, 0xbb, 0xcf, 0x46, 0xe8, 0x96, 0xa6,
	0xb9, 0x20, 0x00, 0xb0, 0x01, 0xb4, 0x04, 0xe8,
	0x1b, 0x3c, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0xe3, 0x02, 0xc7, 0x47, 0x04, 0xe4, 0x02, 0xb0,
	0x02, 0xe8, 0x6e, 0xac, 0xc6, 0x06, 0x45, 0x33,
	0xe5, 0xc6, 0x06, 0x46, 0x33, 0xd0, 0xb0, 0x02,
	0xb4, 0x03, 0xbe, 0xdd, 0x02, 0xbf, 0xde, 0x02,
	0xbb, 0x72, 0x47, 0xe8, 0x60, 0xa6, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x02, 0xe6, 0x02, 0xc7, 0x47,
	0x04, 0xe5, 0x02, 0xb0, 0x02, 0xe8, 0x42, 0xac,
	0xc6, 0x06, 0x46, 0x33, 0xe5, 0xc6, 0x06, 0x45,
	0x33, 0xd0, 0xb0, 0x03, 0xb4, 0x02, 0xbe, 0xe7,
	0x02, 0xbf, 0xdd, 0x02, 0xbb, 0x1c, 0x48, 0xe8,
	0x34, 0xa6, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0xe8, 0x02, 0xc7, 0x47, 0x04, 0xe9, 0x02, 0xb0,
	0x02, 0xe8, 0x16, 0xac, 0xb0, 0x03, 0xb4, 0x02,
	0xbe, 0xde, 0x02, 0xbf, 0xdd, 0x02, 0xbb, 0x73,
	0x48, 0xe8, 0x12, 0xa6, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x02, 0xea, 0x02, 0xc7, 0x47, 0x04, 0xeb,
	0x02, 0xb0, 0x02, 0xe8, 0xf4, 0xab, 0xe8, 0x2d,
	0x3c, 0xb0, 0x03, 0xbe, 0xde, 0x02, 0xbb, 0xa5,
	0x4d, 0xe8, 0x7b, 0xa7, 0xb0, 0x03, 0xbe, 0xec,
	0x02, 0xbb, 0xb9, 0x4e, 0xe8, 0x70, 0xa7, 0xb0,
	0x03, 0xbe, 0xed, 0x02, 0xbb, 0x15, 0x4f, 0xe8,
	0x65, 0xa7, 0xb0, 0x03, 0xbe, 0xec, 0x02, 0xbb,
	0x2f, 0x4f, 0xe8, 0x5a, 0xa7, 0xb9, 0x0a, 0x00,
	0xe8, 0xa8, 0x42, 0xc7, 0x06, 0xf3, 0xb4, 0x20,
	0x00, 0xe8, 0x60, 0x3e, 0xb9, 0x1a, 0x00, 0xb0,
	0x0a, 0xb4, 0x04, 0xe8, 0x47, 0x3b, 0xb9, 0xf3,
	0x02, 0xe8, 0x5b, 0xac, 0x8b, 0x36, 0xaf, 0x64,
	0x8b, 0x3e, 0xb1, 0x64, 0xc6, 0x06, 0xc3, 0x64,
	0x03, 0xe8, 0x5f, 0xc7, 0xbb, 0xbf, 0x51, 0xe8,
	0xf3, 0xa2, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xfb,
	0x02, 0xc7, 0x47, 0x02, 0xfc, 0x02, 0xc7, 0x06,
	0xf3, 0xb4, 0x1f, 0x00, 0xe8, 0x25, 0x3e, 0xc6,
	0x06, 0x45, 0x33, 0xd9, 0xc6, 0x06, 0x46, 0x33,
	0xd0, 0xb0, 0x01, 0xb4, 0x02, 0xbe, 0xfb, 0x02,
	0xbf, 0xfc, 0x02, 0xbb, 0x9f, 0x53, 0xe8, 0x6d,
	0xa5, 0xc7, 0x06, 0xf3, 0xb4, 0x20, 0x00, 0xe8,
	0x1d, 0x3d, 0xbb, 0xc3, 0x52, 0xe8, 0xb5, 0xa2,
	0xb0, 0x03, 0xe8, 0xd0, 0xaa, 0xb0, 0x07, 0xe8,
	0xbf, 0xaa, 0xc6, 0x06, 0xd5, 0xdb, 0x01, 0xc3,
	0x80, 0x3e, 0xd5, 0xdb, 0x01, 0x75, 0x07, 0xbb,
	0xa7, 0x51, 0xe8, 0x28, 0x31, 0xc3, 0xe8, 0xa5,
	0x35, 0xc3, 0x80, 0x3e, 0xd5, 0xdb, 0x01, 0x75,
	0x07, 0xbb, 0xa7, 0x51, 0xe8, 0x16, 0x31, 0xc3,
	0xb9, 0xd1, 0x03, 0xe8, 0xca, 0xab, 0xbb, 0x11,
	0x55, 0xe8, 0x09, 0x31, 0xc3, 0x80, 0x3e, 0xd5,
	0xdb, 0x01, 0x75, 0x07, 0xbb, 0xbb, 0x51, 0xe8,
	0xfb, 0x30, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x1f,
	0x00, 0xb8, 0x8b, 0x00, 0xbb, 0xac, 0x00, 0xbf,
	0x8b, 0x00, 0xbe, 0xb5, 0x00, 0xb1, 0x0b, 0xb5,
	0x03, 0xe8, 0x6f, 0x3c, 0xc3, 0xe8, 0xdf, 0xab,
	0x8b, 0x36, 0xaf, 0x64, 0x8b, 0x3e, 0xb1, 0x64,
	0xc6, 0x06, 0xc3, 0x64, 0x03, 0xe8, 0xa3, 0xc6,
	0xb9, 0xf4, 0x02, 0xe8, 0x64, 0xab, 0xe8, 0x02,
	0x3c, 0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x02, 0xf6, 0x02, 0xb0, 0x02,
	0xe8, 0xbf, 0xaa, 0xc6, 0x06, 0x45, 0x33, 0xd0,
	0xb0, 0x02, 0xbe, 0xf7, 0x02, 0xbb, 0xe6, 0x52,
	0xe8, 0x44, 0xa6, 0xb9, 0x28, 0x00, 0xb0, 0x05,
	0xb4, 0x04, 0xe8, 0x40, 0x3a, 0xb9, 0x34, 0x00,
	0xb0, 0x0d, 0xe8, 0x41, 0x3a, 0xb0, 0x11, 0xe8,
	0x43, 0x3a, 0xb0, 0x15, 0xe8, 0x45, 0x3a, 0xbb,
	0x47, 0x33, 0xc7, 0x47, 0x02, 0xf8, 0x02, 0xb0,
	0x02, 0xe8, 0x86, 0xaa, 0xe8, 0x0d, 0x3b, 0xe8,
	0x06, 0xd0, 0xc6, 0x47, 0x01, 0x48, 0xc6, 0x47,
	0x02, 0x49, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xfd,
	0x02, 0xc7, 0x06, 0xf3, 0xb4, 0x1f, 0x00, 0xe8,
	0x12, 0x3d, 0xb9, 0x3a, 0x00, 0xb0, 0x05, 0xb4,
	0x07, 0xe8, 0xf9, 0x39, 0xb0, 0x08, 0xe8, 0xfd,
	0x39, 0xb0, 0x0a, 0xe8, 0xff, 0x39, 0xb0, 0x0c,
	0xe8, 0x01, 0x3a, 0xb0, 0x0e, 0xe8, 0x03, 0x3a,
	0xb0, 0x01, 0xe8, 0x45, 0xaa, 0xc6, 0x06, 0x45,
	0x33, 0xd9, 0xb0, 0x01, 0xbe, 0xfe, 0x02, 0xbb,
	0x43, 0x54, 0xe8, 0xca, 0xa5, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0xf9, 0x02, 0xc7, 0x06, 0xf3,
	0xb4, 0x20, 0x00, 0xe8, 0xce, 0x3c, 0xc6, 0x06,
	0x45, 0x33, 0xd0, 0xb0, 0x02, 0xbe, 0xf9, 0x02,
	0xbb, 0x58, 0x53, 0xe8, 0xa9, 0xa5, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x02, 0xfa, 0x02, 0xb0, 0x02,
	0xe8, 0x07, 0xaa, 0xe8, 0x40, 0x3a, 0xe8, 0x87,
	0xcf, 0xc6, 0x47, 0x02, 0x00, 0xe8, 0xa5, 0x3d,
	0xb9, 0xf5, 0x02, 0xe8, 0x84, 0xaa, 0xc6, 0x06,
	0xcd, 0x64, 0x01, 0xc6, 0x06, 0xcc, 0x64, 0x01,
	0xc6, 0x06, 0xcb, 0x64, 0x01, 0xe8, 0xac, 0xaa,
	0xbb, 0xe7, 0x51, 0xe8, 0xcf, 0x2f, 0xb0, 0x08,
	0xe8, 0x4e, 0xa9, 0xb0, 0x07, 0xe8, 0x55, 0xa9,
	0xc6, 0x06, 0xd5, 0xdb, 0x00, 0xc3, 0xb9, 0x20,
	0x00, 0xb0, 0x05, 0xb4, 0x08, 0xe8, 0x5d, 0x39,
	0xb9, 0xff, 0x02, 0xe8, 0x6a, 0xaa, 0xe8, 0x3f,
	0xcf, 0xc6, 0x47, 0x01, 0x00, 0xe8, 0xc4, 0x3d,
	0xb0, 0x49, 0xe8, 0x83, 0xb6, 0xb0, 0x08, 0xe8,
	0x2b, 0xa9, 0xc3, 0xe8, 0x60, 0xa8, 0xbb, 0x24,
	0xdb, 0xe8, 0xe9, 0xa0, 0xe8, 0xfe, 0xa0, 0xc3,
	0xe8, 0x15, 0x00, 0xbe, 0x51, 0x00, 0xbf, 0xa0,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x04, 0xe8, 0x52,
	0xc5, 0xbb, 0xac, 0x5c, 0xe8, 0x76, 0x2f, 0xc3,
	0x80, 0x3e, 0xcc, 0xdb, 0x01, 0x74, 0x07, 0xbb,
	0xce, 0x4e, 0xe8, 0x68, 0x2f, 0x58, 0xc3, 0xe8,
	0xee, 0xff, 0xbb, 0x46, 0x50, 0xe8, 0x5d, 0x2f,
	0xc3, 0xb0, 0x44, 0xe8, 0x6e, 0xb6, 0x73, 0x12,
	0xb0, 0x44, 0xe8, 0x43, 0xb6, 0xe8, 0x0a, 0x00,
	0xe8, 0x23, 0xc5, 0xbb, 0x0a, 0x50, 0xe8, 0x44,
	0x2f, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x1d, 0x00,
	0xb8, 0x28, 0x00, 0xbb, 0xb0, 0x00, 0xbf, 0x3e,
	0x00, 0xbe, 0xb7, 0x00, 0xb1, 0x01, 0xb5, 0x02,
	0xe8, 0xb8, 0x3a, 0xc3, 0xe8, 0xb1, 0xff, 0x80,
	0x3e, 0xcf, 0xdb, 0x01, 0x74, 0x48, 0xe8, 0x1e,
	0xaa, 0xc6, 0x06, 0xe6, 0x1c, 0xe5, 0xc6, 0x06,
	0x35, 0x33, 0x0b, 0xc6, 0x06, 0x36, 0x33, 0x23,
	0xb8, 0xcb, 0x4f, 0xa3, 0x37, 0x33, 0xb8, 0x70,
	0x87, 0xa3, 0x39, 0x33, 0xb9, 0x59, 0x00, 0xb0,
	0x04, 0xb4, 0x09, 0xe8, 0x9f, 0x38, 0xb9, 0x57,
	0x00, 0xb0, 0x2d, 0xe8, 0xa0, 0x38, 0xb9, 0xce,
	0x02, 0xe8, 0x03, 0xaa, 0xe8, 0xbd, 0xa9, 0xe8,
	0xe3, 0xad, 0xbb, 0xe2, 0x4f, 0xe8, 0xdd, 0x2e,
	0xc6, 0x06, 0xcf, 0xdb, 0x01, 0xc3, 0xb9, 0x59,
	0x00, 0xb0, 0x04, 0xb4, 0x09, 0xe8, 0x75, 0x38,
	0xb9, 0xcf, 0x02, 0xe8, 0x61, 0xa9, 0xe8, 0x57,
	0xce, 0xc6, 0x47, 0x04, 0x43, 0xe8, 0x98, 0x3c,
	0xe8, 0x91, 0xa9, 0xbb, 0x46, 0x67, 0xe8, 0x39,
	0xce, 0xfe, 0x07, 0xb0, 0x05, 0xe8, 0x3d, 0xa8,
	0xb0, 0x0c, 0xe8, 0x2c, 0xa8, 0xc3, 0x80, 0x3e,
	0xcd, 0xdb, 0x01, 0x74, 0x07, 0xbb, 0x9d, 0x3c,
	0xe8, 0x0a, 0xa0, 0xc3, 0x80, 0x3e, 0xce, 0xdb,
	0x01, 0x75, 0x07, 0xbb, 0x9b, 0x4f, 0xe8, 0x8c,
	0x2e, 0xc3, 0xbb, 0xb1, 0x4f, 0xe8, 0x85, 0x2e,
	0xb9, 0x20, 0x00, 0xb0, 0x06, 0xb4, 0x07, 0xe8,
	0x23, 0x38, 0xb9, 0xcd, 0x02, 0xe8, 0x30, 0xa9,
	0xb0, 0x42, 0xe8, 0x53, 0xb5, 0xc6, 0x06, 0xce,
	0xdb, 0x01, 0xc3, 0xe8, 0x69, 0xa9, 0xe8, 0xf7,
	0xcd, 0xc6, 0x47, 0x02, 0x00, 0xe8, 0x7c, 0x3c,
	0xb9, 0x20, 0x00, 0xb0, 0x07, 0xb4, 0x08, 0xe8,
	0xfb, 0x37, 0xb9, 0xc6, 0x02, 0xe8, 0x0f, 0xa9,
	0xb0, 0x3e, 0xe8, 0x2b, 0xb5, 0xb0, 0x07, 0xe8,
	0xd3, 0xa7, 0xb0, 0x08, 0xe8, 0xc2, 0xa7, 0xc3,
	0xe8, 0xbb, 0x32, 0xc3, 0xe8, 0x38, 0xa9, 0xe8,
	0xc6, 0xcd, 0xc6, 0x47, 0x03, 0x00, 0xe8, 0x4b,
	0x3c, 0xb9, 0x20, 0x00, 0xb0, 0x07, 0xb4, 0x0b,
	0xe8, 0xca, 0x37, 0xb9, 0xcb, 0x02, 0xe8, 0xde,
	0xa8, 0xb0, 0x3f, 0xe8, 0xfa, 0xb4, 0xb0, 0x09,
	0xe8, 0xa2, 0xa7, 0xc3, 0xe8, 0x99, 0xfe, 0xbb,
	0x60, 0x5c, 0xe8, 0x08, 0x2e, 0xc3, 0xbb, 0x82,
	0x5c, 0xe8, 0x01, 0x2e, 0xc3, 0x80, 0x3e, 0xd0,
	0xdb, 0x01, 0x74, 0x0d, 0xb9, 0xd1, 0x02, 0xe8,
	0xae, 0xa8, 0xbb, 0x5e, 0x50, 0xe8, 0xed, 0x2d,
	0xc3, 0xe8, 0xeb, 0xa8, 0xe8, 0x79, 0xcd, 0xc6,
	0x47, 0x04, 0x45, 0xe8, 0xfe, 0x3b, 0xb9, 0x20,
	0x00, 0xb0, 0x05, 0xb4, 0x08, 0xe8, 0x7d, 0x37,
	0xb9, 0xd5, 0x02, 0xe8, 0x91, 0xa8, 0xb0, 0x0c,
	0xe8, 0x5a, 0xa7, 0xb0, 0x45, 0xe8, 0xa8, 0xb4,
	0xc3, 0xb9, 0x59, 0x00, 0xb0, 0x03, 0xb4, 0x01,
	0xe8, 0x62, 0x37, 0xb9, 0xcf, 0x03, 0xe8, 0x5e,
	0xa8, 0xe8, 0xef, 0x38, 0xc7, 0x06, 0xf3, 0xb4,
	0x1f, 0x00, 0xb8, 0x2a, 0x01, 0xbb, 0xb1, 0x00,
	0xbf, 0x16, 0x01, 0xbe, 0xb1, 0x00, 0xb1, 0x01,
	0xb5, 0x04, 0xe8, 0x26, 0x39, 0xc3, 0xe8, 0x15,
	0x32, 0xc3, 0x80, 0x3e, 0xd6, 0xdb, 0x02, 0x75,
	0x07, 0xbb, 0x2c, 0x52, 0xe8, 0x86, 0x2d, 0xc3,
	0xb9, 0x4f, 0x00, 0xb0, 0x06, 0xb4, 0x0e, 0xe8,
	0x23, 0x37, 0xb9, 0x54, 0x00, 0xb0, 0x09, 0xe8,
	0x24, 0x37, 0xb9, 0x21, 0x03, 0xe8, 0x28, 0xa8,
	0xe8, 0x63, 0xac, 0x80, 0x3e, 0xd6, 0xdb, 0x01,
	0x74, 0x07, 0xbb, 0x72, 0x53, 0xe8, 0x5d, 0x2d,
	0xc3, 0xbb, 0x8d, 0x53, 0xe8, 0x56, 0x2d, 0xc6,
	0x06, 0xd6, 0xdb, 0x02, 0xc3, 0xe8, 0xce, 0x31,
	0xc3, 0xb9, 0x42, 0x00, 0xb0, 0x05, 0xb4, 0x03,
	0xe8, 0xea, 0x36, 0xb9, 0x43, 0x00, 0xb0, 0x0b,
	0xe8, 0xeb, 0x36, 0xb9, 0xd0, 0x03, 0xe8, 0xef,
	0xa7, 0xbb, 0x55, 0x59, 0xe8, 0x2e, 0x2d, 0xc3,
	0xbb, 0xdb, 0x5c, 0xe8, 0x27, 0x2d, 0xc3, 0xbb,
	0xfd, 0x5c, 0xe8, 0x20, 0x2d, 0xc3, 0xe8, 0x1e,
	0xa8, 0xe8, 0xac, 0xcc, 0xc6, 0x47, 0x01, 0x00,
	0xe8, 0x31, 0x3b, 0xb9, 0x05, 0x00, 0xb0, 0x2a,
	0xb4, 0x07, 0xe8, 0xb0, 0x36, 0xc6, 0x06, 0x35,
	0x33, 0x14, 0xc6, 0x06, 0x36, 0x33, 0x26, 0xb8,
	0x02, 0x4d, 0xa3, 0x37, 0x33, 0xb8, 0x82, 0x7f,
	0xa3, 0x39, 0x33, 0xc6, 0x06, 0xdc, 0x64, 0x00,
	0xb9, 0xb9, 0x02, 0xe8, 0x01, 0xa8, 0xc6, 0x06,
	0xdc, 0x64, 0x01, 0xe8, 0xb6, 0xa7, 0xb0, 0x38,
	0xe8, 0xbd, 0xb3, 0xb0, 0x01, 0xe8, 0x65, 0xa6,
	0xc3, 0xb9, 0x05, 0x00, 0xb0, 0x0c, 0xb4, 0x07,
	0xe8, 0x72, 0x36, 0xb9, 0xc0, 0x02, 0xe8, 0x8d,
	0xa7, 0xb0, 0x02, 0xe8, 0x4f, 0xa6, 0xb0, 0x3a,
	0xe8, 0x9d, 0xb3, 0xc3, 0xbb, 0x2c, 0x5d, 0xe8,
	0xb3, 0x2c, 0xc3, 0x80, 0x3e, 0xc5, 0xdb, 0x01,
	0x74, 0x20, 0xc6, 0x06, 0xc5, 0xdb, 0x01, 0x80,
	0x3e, 0xc6, 0xdb, 0x00, 0x74, 0x05, 0xb8, 0xbe,
	0x02, 0xeb, 0x03, 0xb8, 0xbd, 0x02, 0xe8, 0x25,
	0x00, 0xb0, 0x01, 0xe8, 0x61, 0xa6, 0xe8, 0x23,
	0x37, 0xc3, 0xc6, 0x06, 0xc5, 0xdb, 0x00, 0xb8,
	0xbd, 0x02, 0xe8, 0x11, 0x00, 0xe8, 0xc6, 0x36,
	0x80, 0x3e, 0xc6, 0xdb, 0x01, 0x75, 0x06, 0xbb,
	0xa6, 0x4d, 0xe8, 0x70, 0x2c, 0xc3, 0x50, 0xb9,
	0x47, 0x00, 0xb0, 0x03, 0xb4, 0x06, 0xe8, 0x0c,
	0x36, 0xb9, 0xbc, 0x02, 0xe8, 0xf8, 0xa6, 0xe8,
	0x99, 0x37, 0x58, 0xbb, 0x47, 0x33, 0x89, 0x07,
	0xc3, 0xbb, 0x41, 0x5d, 0xe8, 0x4e, 0x2c, 0xc3,
	0x80, 0x3e, 0xc4, 0xdb, 0x01, 0x75, 0x07, 0xbb,
	0x2a, 0x4d, 0xe8, 0x40, 0x2c, 0xc3, 0xe8, 0x3e,
	0xa7, 0xe8, 0xcc, 0xcb, 0xc6, 0x07, 0x00, 0xe8,
	0x52, 0x3a, 0xb9, 0x1a, 0x00, 0xb0, 0x11, 0xb4,
	0x0a, 0xe8, 0xd1, 0x35, 0xb0, 0x17, 0xe8, 0xd5,
	0x35, 0xb0, 0x1e, 0xe8, 0xd7, 0x35, 0xb0, 0x25,
	0xe8, 0xe0, 0x35, 0xb0, 0x2b, 0xe8, 0xe2, 0x35,
	0xb9, 0x34, 0x00, 0xb0, 0x22, 0xe8, 0xcc, 0x35,
	0xb9, 0xba, 0x02, 0xe8, 0xa4, 0xa6, 0xe8, 0x97,
	0xcb, 0xc6, 0x07, 0x34, 0xc6, 0x47, 0x02, 0x3d,
	0xe8, 0xd5, 0x39, 0xe8, 0xce, 0xa6, 0xbb, 0xb6,
	0x38, 0xe8, 0x61, 0x9d, 0xb0, 0x0b, 0xe8, 0x70,
	0xa5, 0xc6, 0x06, 0xc4, 0xdb, 0x01, 0xc3, 0xbb,
	0x6e, 0x5d, 0xe8, 0xe0, 0x2b, 0xc3, 0x80, 0x3e,
	0xc9, 0xdb, 0x01, 0x75, 0x07, 0xbb, 0xbb, 0x4d,
	0xe8, 0xd2, 0x2b, 0xc3, 0xc6, 0x06, 0xc9, 0xdb,
	0x01, 0xbb, 0xca, 0x3a, 0xe8, 0x36, 0x9d, 0xb9,
	0x3d, 0x00, 0xb0, 0x05, 0xb4, 0x09, 0xe8, 0x64,
	0x35, 0xb9, 0x05, 0x00, 0xb0, 0x0e, 0xe8, 0x65,
	0x35, 0xb9, 0xc1, 0x02, 0xe8, 0x69, 0xa6, 0xbb,
	0xd3, 0x4d, 0xe8, 0xa8, 0x2b, 0xb0, 0x3b, 0xe8,
	0x86, 0xb2, 0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x1d,
	0x00, 0xb8, 0x00, 0x01, 0xbb, 0xab, 0x00, 0xbf,
	0x00, 0x01, 0xbe, 0xb2, 0x00, 0xb1, 0x0b, 0xb5,
	0x03, 0xe8, 0x17, 0x37, 0xc3, 0xe8, 0x06, 0x30,
	0xc3, 0xe8, 0x83, 0xa6, 0xe8, 0x11, 0xcb, 0xc6,
	0x47, 0x02, 0x00, 0xe8, 0x96, 0x39, 0xb9, 0x05,
	0x00, 0xb0, 0x0c, 0xb4, 0x07, 0xe8, 0x15, 0x35,
	0xb9, 0xbb, 0x02, 0xe8, 0x29, 0xa6, 0xb0, 0x39,
	0xe8, 0x45, 0xb2, 0xb0, 0x0b, 0xe8, 0xed, 0xa4,
	0xc3, 0xc7, 0x06, 0xf3, 0xb4, 0x26, 0x00, 0xb8,
	0xa0, 0x00, 0xbb, 0xc7, 0x00, 0xbf, 0xa0, 0x00,
	0xbe, 0xbe, 0x00, 0xb1, 0x13, 0xb5, 0x01, 0xe8,
	0xd1, 0x36, 0xc3, 0x80, 0x3e, 0xd7, 0xdb, 0x01,
	0x74, 0x07, 0xbb, 0xcb, 0x52, 0xe8, 0x35, 0x2b,
	0xc3, 0x80, 0x3e, 0xd8, 0xdb, 0x01, 0x74, 0x07,
	0xbb, 0xfe, 0x52, 0xe8, 0x27, 0x2b, 0xc3, 0xb9,
	0x58, 0x00, 0xb0, 0x04, 0xb4, 0x0c, 0xe8, 0xc4,
	0x34, 0xb9, 0xd3, 0x03, 0xe8, 0xb0, 0xa5, 0xe8,
	0x51, 0x36, 0xc7, 0x06, 0xaf, 0x64, 0x33, 0x00,
	0xc7, 0x06, 0xb1, 0x64, 0xb7, 0x00, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0x00, 0x03, 0xc7, 0x47, 0x02,
	0x01, 0x03, 0xc7, 0x06, 0xf3, 0xb4, 0x25, 0x00,
	0xe8, 0xb2, 0x37, 0xc6, 0x06, 0x45, 0x33, 0xd9,
	0xc6, 0x06, 0x46, 0x33, 0xe5, 0xb0, 0x01, 0xb4,
	0x02, 0xbe, 0x00, 0x03, 0xbf, 0x01, 0x03, 0xbb,
	0xea, 0x54, 0xe8, 0xf1, 0x9e, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x02, 0x03, 0xc7, 0x47, 0x02, 0x03,
	0x03, 0xe8, 0xd0, 0x34, 0xbb, 0x23, 0x55, 0xe8,
	0x33, 0x9c, 0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4,
	0x02, 0xe8, 0x61, 0x34, 0xb9, 0x38, 0x00, 0xb0,
	0x0c, 0xe8, 0x62, 0x34, 0xb9, 0x17, 0x00, 0xb0,
	0x14, 0xe8, 0x61, 0x34, 0xb9, 0x4b, 0x00, 0xb0,
	0x19, 0xe8, 0x60, 0x34, 0xb9, 0x04, 0x03, 0xe8,
	0x38, 0xa5, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x06,
	0x03, 0xb9, 0x05, 0x03, 0xe8, 0x2b, 0xa5, 0xe8,
	0xc9, 0x35, 0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xe8,
	0x16, 0xca, 0xc6, 0x07, 0x4a, 0xe8, 0xeb, 0x38,
	0xe8, 0xcd, 0x35, 0xb0, 0x01, 0xbe, 0x07, 0x03,
	0xbb, 0x56, 0x55, 0xe8, 0x11, 0xa0, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0x08, 0x03, 0xb0, 0x01, 0xe8,
	0x70, 0xa4, 0xb0, 0x01, 0xb4, 0x02, 0xbe, 0x09,
	0x03, 0xbf, 0x0a, 0x03, 0xbb, 0xf7, 0x55, 0xe8,
	0x6c, 0x9e, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x0b,
	0x03, 0xc7, 0x47, 0x02, 0x0c, 0x03, 0xe8, 0x4b,
	0x34, 0xe8, 0xd8, 0x34, 0xb9, 0x3a, 0x00, 0xb0,
	0x01, 0xb4, 0x04, 0xe8, 0xdf, 0x33, 0xb0, 0x02,
	0xe8, 0xe3, 0x33, 0xb0, 0x03, 0xe8, 0xe5, 0x33,
	0xb0, 0x04, 0xe8, 0xe7, 0x33, 0xb0, 0x05, 0xe8,
	0xe9, 0x33, 0xb0, 0x06, 0xe8, 0xeb, 0x33, 0xb0,
	0x0a, 0xe8, 0xf4, 0x33, 0xb9, 0x02, 0x00, 0xb0,
	0x07, 0xe8, 0xe5, 0x33, 0xb9, 0x37, 0x00, 0xb0,
	0x0b, 0xe8, 0xeb, 0x33, 0xb9, 0x36, 0x00, 0xb0,
	0x0f, 0xb4, 0x0a, 0xe8, 0xe8, 0x33, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x04, 0x0d, 0x03, 0xc7, 0x47,
	0x06, 0x0e, 0x03, 0xb0, 0x03, 0xe8, 0xfa, 0xa3,
	0xe8, 0x7d, 0xc9, 0xc6, 0x47, 0x01, 0x4b, 0xc6,
	0x47, 0x02, 0x4c, 0xe8, 0x4d, 0x38, 0xe8, 0x2f,
	0x35, 0xb9, 0x3a, 0x00, 0xb0, 0x01, 0xb4, 0x04,
	0xe8, 0x7a, 0x33, 0xb0, 0x02, 0xe8, 0x7e, 0x33,
	0xb0, 0x03, 0xe8, 0x80, 0x33, 0xb0, 0x04, 0xe8,
	0x82, 0x33, 0xb0, 0x05, 0xe8, 0x84, 0x33, 0xb0,
	0x06, 0xe8, 0x86, 0x33, 0xb0, 0x09, 0xe8, 0x8f,
	0x33, 0xb9, 0x02, 0x00, 0xb0, 0x07, 0xe8, 0x80,
	0x33, 0xb0, 0x0f, 0xb4, 0x07, 0xe8, 0x8e, 0x33,
	0xb9, 0x37, 0x00, 0xb0, 0x0a, 0xe8, 0x7f, 0x33,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x04, 0x0f, 0x03,
	0xc7, 0x47, 0x06, 0x10, 0x03, 0xb0, 0x03, 0xe8,
	0x98, 0xa3, 0xe8, 0x1b, 0xc9, 0xc6, 0x47, 0x01,
	0x4d, 0xc6, 0x47, 0x02, 0x4e, 0xe8, 0xeb, 0x37,
	0xe8, 0xcd, 0x34, 0xbb, 0x47, 0x33, 0xc7, 0x47,
	0x04, 0x11, 0x03, 0xc7, 0x47, 0x06, 0x12, 0x03,
	0xb0, 0x03, 0xe8, 0x75, 0xa3, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0xff, 0xff, 0xe8, 0xa7, 0x33, 0xc7,
	0x06, 0xaf, 0x64, 0x70, 0x00, 0xc6, 0x06, 0xdc,
	0x1c, 0x02, 0xe8, 0xe3, 0xc8, 0xc6, 0x47, 0x03,
	0x4f, 0xc6, 0x07, 0x00, 0xe8, 0xb4, 0x37, 0xe8,
	0x96, 0x34, 0xe8, 0x5f, 0x37, 0xc7, 0x06, 0x30,
	0x32, 0x96, 0x97, 0xc7, 0x06, 0x2e, 0x32, 0x2a,
	0x00, 0xc7, 0x06, 0x2c, 0x32, 0x3e, 0x00, 0xe8,
	0x4c, 0xb1, 0xe8, 0x93, 0x31, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x04, 0x13, 0x03, 0xc7, 0x47, 0x06,
	0x14, 0x03, 0xb0, 0x03, 0xe8, 0x23, 0xa3, 0xbb,
	0x47, 0x33, 0xc7, 0x47, 0x02, 0xff, 0xff, 0xe8,
	0x54, 0x33, 0xb9, 0x20, 0x00, 0xb0, 0x02, 0xb4,
	0x0c, 0xe8, 0xa9, 0x32, 0xb9, 0x18, 0x00, 0xb0,
	0x07, 0xe8, 0xaa, 0x32, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x15, 0x03, 0xc7, 0x47, 0x06, 0x16, 0x03,
	0xb0, 0x01, 0xe8, 0xf5, 0xa2, 0xbb, 0x47, 0x33,
	0xe8, 0x2b, 0x33, 0xe8, 0x72, 0xc8, 0xc6, 0x07,
	0x50, 0xe8, 0x47, 0x37, 0xe8, 0x29, 0x34, 0xe8,
	0xe2, 0xa1, 0xbb, 0x65, 0x56, 0xe8, 0x3d, 0x9a,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x06, 0x18, 0x03,
	0xe8, 0xc9, 0x32, 0xe8, 0x56, 0x33, 0xbe, 0x28,
	0x00, 0xbf, 0xab, 0x00, 0xc6, 0x06, 0xc3, 0x64,
	0x04, 0xe8, 0x87, 0xbe, 0xc7, 0x06, 0xf3, 0xb4,
	0x23, 0x00, 0xe8, 0x3b, 0xc8, 0xc6, 0x47, 0x03,
	0x51, 0xb0, 0x0c, 0xe8, 0x23, 0xa2, 0xc7, 0x06,
	0xf3, 0xb4, 0x1f, 0x00, 0xb8, 0x2a, 0x01, 0xbb,
	0xb1, 0x00, 0xbf, 0x16, 0x01, 0xbe, 0xb1, 0x00,
	0xb1, 0x01, 0xb5, 0x04, 0xe8, 0x14, 0x34, 0xc6,
	0x06, 0xd9, 0xdb, 0x01, 0xc3, 0xb9, 0x59, 0x00,
	0xb0, 0x06, 0xb4, 0x02, 0xe8, 0x1e, 0x32, 0xb9,
	0xd2, 0x03, 0xe8, 0x1a, 0xa3, 0xe8, 0xab, 0x33,
	0xc7, 0x06, 0xf3, 0xb4, 0x1f, 0x00, 0xb8, 0x2a,
	0x01, 0xbb, 0xb1, 0x00, 0xbf, 0x16, 0x01, 0xbe,
	0xb1, 0x00, 0xb1, 0x01, 0xb5, 0x04, 0xe8, 0xe2,
	0x33, 0xc3, 0x80, 0x3e, 0xd7, 0xdb, 0x01, 0x74,
	0x07, 0xbb, 0xcb, 0x52, 0xe8, 0x46, 0x28, 0xc3,
	0x80, 0x3e, 0xd8, 0xdb, 0x01, 0x75, 0x07, 0xbb,
	0xf6, 0x52, 0xe8, 0x38, 0x28, 0xc3, 0xb9, 0x47,
	0x00, 0xb0, 0x04, 0xb4, 0x0c, 0xe8, 0xd5, 0x31,
	0xb9, 0x1c, 0x03, 0xe8, 0xe2, 0xa2, 0xb8, 0x01,
	0x00, 0xe8, 0x45, 0xb6, 0xe8, 0x59, 0xb6, 0xc6,
	0x06, 0xd8, 0xdb, 0x01, 0xc3, 0xe8, 0x98, 0xa0,
	0xbb, 0x36, 0xdb, 0xe8, 0x67, 0x99, 0xe8, 0x7c,
	0x99, 0xc3, 0xbb, 0x87, 0x5d, 0xe8, 0x05, 0x28,
	0xc3, 0xbb, 0x11, 0x55, 0xe8, 0xfe, 0x27, 0xc3,
	0xbb, 0x11, 0x55, 0xe8, 0xf7, 0x27, 0xc3, 0xbb,
	0x0f, 0x57, 0xe8, 0xf0, 0x27, 0xc3, 0x80, 0x3e,
	0xdd, 0xdb, 0x03, 0x75, 0x07, 0xbb, 0xff, 0x55,
	0xe8, 0xe2, 0x27, 0xc3, 0xe8, 0xc1, 0x27, 0xc3,
	0xfe, 0x06, 0xdb, 0xdb, 0xa0, 0xdb, 0xdb, 0xbb,
	0x11, 0x54, 0x3c, 0x01, 0x74, 0x1f, 0xbb, 0x63,
	0x54, 0x3c, 0x02, 0x74, 0x18, 0xbb, 0x75, 0x54,
	0x3c, 0x03, 0x74, 0x11, 0xbb, 0x84, 0x54, 0x3c,
	0x04, 0x74, 0x0a, 0xbb, 0xc4, 0x54, 0x3c, 0x05,
	0x74, 0x03, 0xbb, 0xd5, 0x54, 0xe8, 0xad, 0x27,
	0xc3, 0x80, 0x3e, 0xe6, 0xdb, 0x01, 0x75, 0x07,
	0xbb, 0x27, 0x58, 0xe8, 0x9f, 0x27, 0xc3, 0xe8,
	0x7e, 0x27, 0xc3, 0x80, 0x3e, 0xe8, 0xdb, 0x01,
	0x74, 0x04, 0xe8, 0x73, 0x27, 0xc3, 0xbb, 0xb0,
	0x58, 0xe8, 0x89, 0x27, 0xc3, 0xc3, 0x80, 0x3e,
	0xa1, 0xdb, 0x01, 0x74, 0x07, 0xbb, 0x94, 0x36,
	0xe8, 0x7a, 0x27, 0xc3, 0xe8, 0x59, 0x27, 0xc3,
	0xe8, 0xe2, 0xd7, 0xe8, 0x52, 0x27, 0xc3, 0xe8,
	0x94, 0xdc, 0xe8, 0x4b, 0x27, 0xc3, 0xe8, 0x8d,
	0xdc, 0xe8, 0x44, 0x27, 0xc3, 0x80, 0x3e, 0x95,
	0xdb, 0x01, 0x75, 0x07, 0xbb, 0x75, 0x3e, 0xe8,
	0x53, 0x27, 0xc3, 0xe8, 0x32, 0x27, 0xc3, 0x80,
	0x3e, 0x94, 0xdb, 0x01, 0x75, 0x07, 0xbb, 0x4f,
	0x3e, 0xe8, 0x41, 0x27, 0xc3, 0xe8, 0x20, 0x27,
	0xc3, 0x80, 0x3e, 0xa5, 0xdb, 0x01, 0x75, 0x07,
	0xbb, 0x98, 0x3e, 0xe8, 0x2f, 0x27, 0xc3, 0xe8,
	0x0e, 0x27, 0xc3, 0xbe, 0xf5, 0x00, 0xbf, 0xc6,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x01, 0xe8, 0xf2,
	0xbc, 0x80, 0x3e, 0xaf, 0xdb, 0x01, 0x74, 0x0c,
	0xbb, 0x93, 0x21, 0xe8, 0x7f, 0x98, 0xc6, 0x06,
	0xaf, 0xdb, 0x01, 0xc3, 0xe8, 0xe9, 0x26, 0xc3,
	0x80, 0x3e, 0xb1, 0xdb, 0x01, 0x75, 0x07, 0xbb,
	0xaf, 0x3d, 0xe8, 0xf8, 0x26, 0xc3, 0xe8, 0xd7,
	0x26, 0xc3, 0xe8, 0x50, 0xe7, 0xc3, 0x80, 0x3e,
	0xa4, 0xdb, 0x01, 0x74, 0x04, 0xe8, 0x45, 0xe7,
	0xc3, 0xe8, 0xc4, 0x26, 0xc3, 0x80, 0x3e, 0xa4,
	0xdb, 0x01, 0x74, 0x07, 0xbb, 0x32, 0x38, 0xe8,
	0xd3, 0x26, 0xc3, 0xe8, 0xb2, 0x26, 0xc3, 0x80,
	0x3e, 0xa4, 0xdb, 0x01, 0x74, 0x04, 0xe8, 0x6d,
	0xe8, 0xc3, 0xe8, 0xa3, 0x26, 0xc3, 0x80, 0x3e,
	0xa4, 0xdb, 0x01, 0x74, 0x04, 0xe8, 0x5e, 0xe8,
	0xc3, 0xe8, 0x94, 0x26, 0xc3, 0x80, 0x3e, 0xa4,
	0xdb, 0x01, 0x74, 0x04, 0xe8, 0x4f, 0xe8, 0xc3,
	0xe8, 0x85, 0x26, 0xc3, 0x80, 0x3e, 0xa4, 0xdb,
	0x01, 0x74, 0x04, 0xe8, 0x40, 0xe8, 0xc3, 0xe8,
	0x76, 0x26, 0xc3, 0x80, 0x3e, 0xa4, 0xdb, 0x01,
	0x74, 0x04, 0xe8, 0x31, 0xe8, 0xc3, 0xe8, 0x67,
	0x26, 0xc3, 0x80, 0x3e, 0x9d, 0xdb, 0x01, 0x75,
	0x07, 0xbb, 0x90, 0x35, 0xe8, 0x76, 0x26, 0xc3,
	0xe8, 0x55, 0x26, 0xc3, 0xe8, 0x62, 0xee, 0xe8,
	0x4e, 0x26, 0xc3, 0xa0, 0xc1, 0xdb, 0x98, 0x48,
	0xd1, 0xe0, 0xbb, 0x3c, 0x5f, 0x03, 0xd8, 0x8b,
	0x1f, 0xe8, 0x59, 0x26, 0xc3, 0x80, 0x3e, 0xb7,
	0xdb, 0x01, 0x74, 0x04, 0xe8, 0x31, 0x26, 0xc3,
	0xbb, 0x6c, 0x4b, 0xe8, 0x47, 0x26, 0xc3, 0x80,
	0x3e, 0xb8, 0xdb, 0x01, 0x74, 0x04, 0xe8, 0x1f,
	0x26, 0xc3, 0x80, 0x3e, 0xbf, 0xdb, 0x01, 0x74,
	0x21, 0xbb, 0x32, 0x4c, 0xe8, 0x2e, 0x26, 0xb9,
	0x05, 0x00, 0xb0, 0x0b, 0xb4, 0x07, 0xe8, 0xcc,
	0x2f, 0xb9, 0xb2, 0x02, 0xe8, 0xd9, 0xa0, 0xb0,
	0x35, 0xe8, 0xfc, 0xac, 0xc6, 0x06, 0xbf, 0xdb,
	0x01, 0xc3, 0xbb, 0x87, 0x4b, 0xe8, 0x0d, 0x26,
	0xc3, 0x80, 0x3e, 0xb9, 0xdb, 0x01, 0x74, 0x04,
	0xe8, 0xe5, 0x25, 0xc3, 0xbb, 0xa1, 0x4b, 0xe8,
	0xfb, 0x25, 0xc3, 0x80, 0x3e, 0xba, 0xdb, 0x01,
	0x74, 0x04, 0xe8, 0xd3, 0x25, 0xc3, 0xbb, 0xbc,
	0x4b, 0xe8, 0xe9, 0x25, 0xc3, 0x80, 0x3e, 0xbb,
	0xdb, 0x01, 0x74, 0x04, 0xe8, 0xc1, 0x25, 0xc3,
	0xbb, 0xd8, 0x4b, 0xe8, 0xd7, 0x25, 0xc3, 0x80,
	0x3e, 0xbc, 0xdb, 0x01, 0x74, 0x04, 0xe8, 0xaf,
	0x25, 0xc3, 0x80, 0x3e, 0xbe, 0xdb, 0x01, 0x74,
	0x21, 0xbb, 0x0f, 0x4c, 0xe8, 0xbe, 0x25, 0xb9,
	0x05, 0x00, 0xb0, 0x0c, 0xb4, 0x07, 0xe8, 0x5c,
	0x2f, 0xb9, 0xb1, 0x02, 0xe8, 0x69, 0xa0, 0xb0,
	0x34, 0xe8, 0x8c, 0xac, 0xc6, 0x06, 0xbe, 0xdb,
	0x01, 0xc3, 0xbb, 0xf4, 0x4b, 0xe8, 0x9d, 0x25,
	0xc3, 0x80, 0x3e, 0xb6, 0xdb, 0x01, 0x74, 0x0c,
	0xbb, 0xd0, 0x37, 0xe8, 0xff, 0x96, 0xc6, 0x06,
	0xb6, 0xdb, 0x01, 0xc3, 0xe8, 0x69, 0x25, 0xc3,
	0xe8, 0x0d, 0xf6, 0xe8, 0x62, 0x25, 0xc3, 0xe8,
	0x06, 0xf6, 0xe8, 0x5b, 0x25, 0xc3, 0x80, 0x3e,
	0xcd, 0xdb, 0x01, 0x74, 0x04, 0xe8, 0x50, 0x25,
	0xc3, 0xbb, 0x69, 0x4f, 0xe8, 0x66, 0x25, 0xc3,
	0xe8, 0xed, 0xf5, 0xe8, 0x42, 0x25, 0xc3, 0x80,
	0x3e, 0xd0, 0xdb, 0x01, 0x74, 0x04, 0xe8, 0x37,
	0x25, 0xc3, 0xbb, 0x82, 0x50, 0xe8, 0x4d, 0x25,
	0xc3, 0xa0, 0xd6, 0xdb, 0x3c, 0x01, 0x74, 0x08,
	0x3c, 0x02, 0x74, 0x0b, 0xe8, 0x21, 0x25, 0xc3,
	0xbb, 0xf8, 0x51, 0xe8, 0x37, 0x25, 0xc3, 0xbb,
	0x8d, 0x53, 0xe8, 0x30, 0x25, 0xc3, 0xe8, 0x2e,
	0xa0, 0xe8, 0xbc, 0xc4, 0xc6, 0x07, 0x00, 0xe8,
	0x42, 0x33, 0xb9, 0x05, 0x00, 0xb0, 0x02, 0xb4,
	0x0c, 0xe8, 0xc1, 0x2e, 0xb9, 0x33, 0x00, 0xb0,
	0x0b, 0xe8, 0xc2, 0x2e, 0xb0, 0x17, 0xe8, 0xc4,
	0x2e, 0xb9, 0x45, 0x03, 0xe8, 0xa3, 0x9f, 0xb9,
	0x33, 0x00, 0xb0, 0x03, 0xb4, 0x0d, 0xe8, 0xa4,
	0x2e, 0xb0, 0x13, 0xe8, 0xa8, 0x2e, 0xb9, 0x17,
	0x00, 0xb0, 0x1a, 0xe8, 0xa7, 0x2e, 0xb9, 0x46,
	0x03, 0xe8, 0x86, 0x9f, 0xe8, 0x79, 0xc4, 0xc6,
	0x07, 0x60, 0xe8, 0xbb, 0x32, 0xc7, 0x06, 0xaf,
	0x64, 0x19, 0x01, 0xe8, 0xae, 0x9f, 0xb0, 0x04,
	0xe8, 0x62, 0x9e, 0xc6, 0x06, 0xe1, 0xdb, 0x01,
	0xc3, 0x80, 0x3e, 0xe1, 0xdb, 0x01, 0x74, 0x07,
	0xbb, 0xda, 0x56, 0xe8, 0xbf, 0x24, 0xc3, 0xb9,
	0x4c, 0x03, 0xe8, 0x52, 0x9f, 0xe8, 0x48, 0xc4,
	0xc6, 0x47, 0x01, 0x00, 0x53, 0xe8, 0x88, 0x32,
	0xb9, 0x05, 0x00, 0xb0, 0x05, 0xb4, 0x0a, 0xe8,
	0x4b, 0x2e, 0xb9, 0x1a, 0x00, 0xb0, 0x13, 0xe8,
	0x4c, 0x2e, 0xb9, 0x18, 0x00, 0xb0, 0x19, 0xe8,
	0x4b, 0x2e, 0xb9, 0x4f, 0x03, 0xe8, 0x2a, 0x9f,
	0xb9, 0x05, 0x00, 0xb0, 0x0b, 0xb4, 0x09, 0xe8,
	0x2b, 0x2e, 0xb9, 0x50, 0x03, 0xe8, 0x1a, 0x9f,
	0x5b, 0xc6, 0x47, 0x01, 0x64, 0xe8, 0x50, 0x32,
	0xb9, 0x4d, 0x03, 0xe8, 0x31, 0x9f, 0xb0, 0x03,
	0xe8, 0xfa, 0x9d, 0xb0, 0x52, 0xe8, 0x48, 0xab,
	0xb0, 0x51, 0xe8, 0x53, 0xab, 0xc3, 0xbb, 0x54,
	0x5e, 0xe8, 0x59, 0x24, 0xc3, 0xb9, 0x4c, 0x00,
	0xb0, 0x12, 0xb4, 0x08, 0xe8, 0xf6, 0x2d, 0xb0,
	0x16, 0xe8, 0xfa, 0x2d, 0xb0, 0x1a, 0xe8, 0xfc,
	0x2d, 0xb0, 0x1e, 0xe8, 0xfe, 0x2d, 0xb0, 0x22,
	0xe8, 0x00, 0x2e, 0xb0, 0x2f, 0xe8, 0x02, 0x2e,
	0xb0, 0x33, 0xe8, 0x04, 0x2e, 0xb0, 0x37, 0xe8,
	0x06, 0x2e, 0xb0, 0x3b, 0xe8, 0x08, 0x2e, 0xb0,
	0x3f, 0xe8, 0x0a, 0x2e, 0xb9, 0x69, 0x03, 0xe8,
	0xd6, 0x9e, 0xbe, 0xf0, 0x00, 0xbf, 0xa3, 0x00,
	0xc6, 0x06, 0xc3, 0x64, 0x04, 0xe8, 0xe3, 0xb9,
	0xbb, 0x37, 0x58, 0xe8, 0x07, 0x24, 0xb4, 0x01,
	0xb0, 0x22, 0xe8, 0xb9, 0xa2, 0xb9, 0x4d, 0x00,
	0xb0, 0x02, 0xb4, 0x08, 0xe8, 0x9e, 0x2d, 0xb0,
	0x0c, 0xe8, 0xa2, 0x2d, 0xb0, 0x10, 0xe8, 0xa4,
	0x2d, 0xb0, 0x14, 0xe8, 0xa6, 0x2d, 0xb0, 0x22,
	0xe8, 0xa8, 0x2d, 0xb9, 0x4e, 0x00, 0xb0, 0x29,
	0xe8, 0xa7, 0x2d, 0xb0, 0x33, 0xe8, 0xa9, 0x2d,
	0xb9, 0x38, 0x00, 0xb0, 0x3f, 0xe8, 0xa8, 0x2d,
	0xb9, 0x18, 0x00, 0xb0, 0x43, 0xe8, 0xa7, 0x2d,
	0xb9, 0x17, 0x00, 0xb0, 0x4c, 0xe8, 0xa6, 0x2d,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x6a, 0x03, 0xb0,
	0x01, 0xe8, 0x7c, 0x9d, 0xe8, 0x45, 0x2e, 0xe8,
	0x3e, 0xc3, 0xc6, 0x07, 0x68, 0xe8, 0xc4, 0x31,
	0xb8, 0x01, 0x00, 0xe8, 0xc3, 0xb1, 0xe8, 0xd7,
	0xb1, 0xb0, 0x5b, 0xe8, 0x8a, 0xaa, 0xb0, 0x06,
	0xe8, 0x16, 0x9d, 0xb0, 0x01, 0xe8, 0x1d, 0x9d,
	0xc3, 0xbb, 0xbe, 0x5e, 0xe8, 0x86, 0x23, 0xc3,
	0xbb, 0xbe, 0x5e, 0xe8, 0x7f, 0x23, 0xc3, 0xbb,
	0xe6, 0x5e, 0xe8, 0x78, 0x23, 0xc3, 0xbb, 0x11,
	0x5f, 0xe8, 0x71, 0x23, 0xc3, 0xb9, 0x05, 0x00,
	0xb0, 0x02, 0xb4, 0x07, 0xe8, 0x0e, 0x2d, 0xb9,
	0x13, 0x00, 0xb0, 0x0b, 0xe8, 0x0f, 0x2d, 0xb9,
	0x48, 0x03, 0xe8, 0x02, 0x9e, 0xe8, 0xe8, 0xc2,
	0xc6, 0x47, 0x01, 0x61, 0xe8, 0x29, 0x31, 0xe8,
	0x22, 0x9e, 0xb0, 0x50, 0xe8, 0x39, 0xaa, 0xb0,
	0x02, 0xe8, 0xd1, 0x9c, 0xb0, 0x07, 0xe8, 0xc0,
	0x9c, 0xc3, 0x80, 0x3e, 0xdf, 0xdb, 0x01, 0x76,
	0x07, 0xbb, 0xf6, 0x52, 0xe8, 0x2e, 0x23, 0xc3,
	0xb9, 0x05, 0x00, 0xb0, 0x02, 0xb4, 0x0c, 0xe8,
	0xcb, 0x2c, 0xb9, 0x39, 0x00, 0xb0, 0x0c, 0xe8,
	0xcc, 0x2c, 0xb9, 0x46, 0x00, 0xb0, 0x13, 0xe8,
	0xcb, 0x2c, 0xb9, 0x3c, 0x03, 0xe8, 0xa7, 0x9d,
	0xe8, 0x48, 0x2e, 0xc7, 0x06, 0xaf, 0x64, 0x06,
	0x01, 0xc7, 0x06, 0xb1, 0x64, 0xa0, 0x00, 0xc6,
	0x06, 0xcc, 0x64, 0x01, 0xc6, 0x06, 0xcd, 0x64,
	0x00, 0xc6, 0x06, 0xcb, 0x64, 0x01, 0xe8, 0x10,
	0xc1, 0xb0, 0x04, 0xe8, 0x77, 0x9c, 0xb0, 0x03,
	0xe8, 0x72, 0x9c, 0xe8, 0x72, 0xc2, 0xc6, 0x07,
	0x00, 0xc6, 0x47, 0x02, 0x00, 0xc6, 0x47, 0x03,
	0x00, 0xc6, 0x47, 0x01, 0x55, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x3d, 0x03, 0xc7, 0x06, 0xf3, 0xb4,
	0x05, 0x00, 0xe8, 0x53, 0xc2, 0xc6, 0x07, 0x5c,
	0xe8, 0x7a, 0x2f, 0xe8, 0x4a, 0xc2, 0xc6, 0x07,
	0x00, 0xb8, 0xc8, 0x00, 0xe8, 0x93, 0xa1, 0xc6,
	0x06, 0x45, 0x33, 0xd0, 0xb0, 0x01, 0xbe, 0x3e,
	0x03, 0xbb, 0xa5, 0x63, 0xe8, 0x40, 0x98, 0xb9,
	0x04, 0x00, 0xe8, 0x8e, 0x33, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x3f, 0x03, 0xc7, 0x06, 0xf3, 0xb4,
	0x07, 0x00, 0xe8, 0x3f, 0x2f, 0xc7, 0x06, 0xaf,
	0x64, 0x82, 0x00, 0xc7, 0x06, 0xb1, 0x64, 0xc3,
	0x00, 0xc6, 0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x95,
	0xaa, 0xe8, 0x71, 0xa1, 0xe8, 0x92, 0x99, 0xbb,
	0x06, 0x64, 0xe8, 0xd8, 0x93, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x3f, 0x03, 0xb0, 0x01, 0xe8, 0x2e,
	0x9c, 0xe8, 0xf0, 0x2c, 0xc6, 0x06, 0xdf, 0xdb,
	0x02, 0xc3, 0x80, 0x3e, 0xe0, 0xdb, 0x01, 0x75,
	0x07, 0xbb, 0x32, 0x56, 0xe8, 0x46, 0x22, 0xc3,
	0xb9, 0x05, 0x00, 0xb0, 0x06, 0xb4, 0x05, 0xe8,
	0xe3, 0x2b, 0xb9, 0x1b, 0x00, 0xb0, 0x31, 0xe8,
	0xe4, 0x2b, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x43,
	0x03, 0xb9, 0x42, 0x03, 0xe8, 0xc0, 0x9c, 0xe8,
	0xb6, 0xc1, 0xc6, 0x07, 0x5e, 0xe8, 0xf8, 0x2f,
	0xe8, 0xf1, 0x9c, 0xe8, 0x3b, 0x99, 0xbb, 0xe9,
	0x65, 0xe8, 0x81, 0x93, 0xb0, 0x0c, 0xe8, 0x90,
	0x9b, 0xc6, 0x06, 0xe0, 0xdb, 0x01, 0xc3, 0xe8,
	0x32, 0x99, 0xbb, 0xc0, 0x66, 0xe8, 0x6d, 0x93,
	0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4, 0x03, 0xe8,
	0x9b, 0x2b, 0xb9, 0x54, 0x03, 0xe8, 0x8a, 0x9c,
	0xe8, 0x28, 0x2d, 0xc6, 0x06, 0xdc, 0x1c, 0x01,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x55, 0x03, 0xb0,
	0x01, 0xe8, 0xab, 0x9b, 0xe8, 0x6d, 0x2c, 0xa0,
	0xac, 0x64, 0x50, 0xc6, 0x06, 0xac, 0x64, 0x04,
	0xe8, 0x10, 0x8d, 0xbb, 0x42, 0x57, 0xbe, 0x13,
	0x8c, 0xe8, 0x6a, 0x24, 0xbb, 0x57, 0x57, 0xbe,
	0x12, 0x8c, 0xe8, 0x61, 0x24, 0xbb, 0x70, 0x57,
	0xbe, 0x1d, 0x8c, 0xe8, 0x58, 0x24, 0xbb, 0x82,
	0x57, 0xbe, 0x0f, 0x8c, 0xe8, 0x4f, 0x24, 0xbb,
	0x99, 0x57, 0xbe, 0x07, 0x8c, 0xe8, 0x46, 0x24,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x58, 0x03, 0xb0,
	0x01, 0xe8, 0x63, 0x9b, 0xb9, 0x05, 0x00, 0xb0,
	0x03, 0xb4, 0x03, 0xe8, 0x2f, 0x2b, 0xb9, 0x56,
	0x03, 0xe8, 0x1e, 0x9c, 0xe8, 0xbc, 0x2c, 0x58,
	0xa2, 0xac, 0x64, 0xe8, 0xbd, 0x8c, 0xe8, 0xa3,
	0x98, 0xbb, 0xfe, 0x66, 0xe8, 0xde, 0x92, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0x57, 0x03, 0xb0, 0x01,
	0xe8, 0x34, 0x9b, 0xb8, 0xc8, 0x00, 0xe8, 0x41,
	0xa0, 0xbe, 0x1e, 0x00, 0xbf, 0xb5, 0x00, 0xe8,
	0x29, 0xb7, 0xe8, 0x99, 0x2b, 0xb0, 0x01, 0xe8,
	0xdb, 0x9a, 0xb8, 0x01, 0x00, 0xe8, 0x69, 0xaf,
	0xc6, 0x06, 0xdf, 0xdb, 0x03, 0xc6, 0x06, 0xf0,
	0xdb, 0x01, 0xc6, 0x06, 0xdc, 0x1c, 0x02, 0xe8,
	0x79, 0xc4, 0xc3, 0x80, 0x3e, 0xdf, 0xdb, 0x03,
	0x74, 0x07, 0xbb, 0xe2, 0x5d, 0xe8, 0x25, 0x21,
	0xc3, 0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4, 0x09,
	0xe8, 0xc2, 0x2a, 0xb9, 0x3a, 0x00, 0xb0, 0x0b,
	0xe8, 0xc3, 0x2a, 0xb9, 0x2e, 0x00, 0xb0, 0x38,
	0xe8, 0xc2, 0x2a, 0xb0, 0x55, 0xe8, 0xc4, 0x2a,
	0xb0, 0x75, 0xe8, 0xc6, 0x2a, 0xb9, 0x66, 0x03,
	0xe8, 0x94, 0x9b, 0xb9, 0x36, 0x00, 0xb0, 0x0f,
	0xb4, 0x09, 0xe8, 0x98, 0x2a, 0xb9, 0x67, 0x03,
	0xe8, 0x87, 0x9b, 0xe8, 0x25, 0x2c, 0xc6, 0x06,
	0xe6, 0xdb, 0x01, 0xe8, 0x72, 0xc0, 0xc6, 0x47,
	0x01, 0x66, 0xe8, 0xf7, 0x2e, 0xb8, 0x32, 0x00,
	0xe8, 0xd9, 0x9f, 0xc7, 0x06, 0xaf, 0x64, 0xe0,
	0x00, 0xc7, 0x06, 0xb1, 0x64, 0xc2, 0x00, 0xc6,
	0x06, 0xcc, 0x64, 0x00, 0xc6, 0x06, 0xdc, 0x64,
	0x01, 0xc6, 0x06, 0xcb, 0x64, 0x00, 0xe8, 0xd8,
	0xbe, 0xc6, 0x06, 0xdc, 0x1c, 0x03, 0xe8, 0xcd,
	0xa8, 0xbe, 0xd7, 0x76, 0xbb, 0xdf, 0x57, 0xc6,
	0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x5e, 0x1c, 0xb0,
	0x59, 0xe8, 0x8c, 0xa7, 0xc3, 0xb9, 0x05, 0x00,
	0xb0, 0x03, 0xb4, 0x06, 0xe8, 0x36, 0x2a, 0xb9,
	0x6c, 0x03, 0xe8, 0x32, 0x9b, 0xe8, 0xc3, 0x2b,
	0xe8, 0x15, 0xc0, 0xc6, 0x47, 0x01, 0x00, 0xe8,
	0x9a, 0x2e, 0xb9, 0x1a, 0x00, 0xb0, 0x07, 0xb4,
	0x04, 0xe8, 0x19, 0x2a, 0xb9, 0x4f, 0x00, 0xb0,
	0x0f, 0xe8, 0x1a, 0x2a, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x02, 0x6d, 0x03, 0xb0, 0x02, 0xe8, 0x27,
	0x9a, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0x70,
	0x03, 0xb0, 0x02, 0xe8, 0x21, 0x9a, 0xe8, 0xe3,
	0x2a, 0xe8, 0x04, 0x97, 0xbb, 0x0e, 0x6f, 0xe8,
	0xb3, 0x91, 0xe8, 0xd3, 0xbf, 0xc6, 0x47, 0x02,
	0x6a, 0xe8, 0x58, 0x2e, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x6e, 0x03, 0xb0, 0x01, 0xe8, 0xf8, 0x99,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x6f, 0x03, 0xb0,
	0x01, 0xe8, 0xf3, 0x99, 0xe8, 0xb5, 0x2a, 0xb0,
	0x5c, 0xe8, 0x0c, 0xa7, 0xb0, 0x01, 0xe8, 0x98,
	0x99, 0xc6, 0x06, 0xe7, 0xdb, 0x01, 0xc3, 0xb9,
	0x20, 0x00, 0xb0, 0x05, 0xb4, 0x0a, 0xe8, 0xac,
	0x29, 0xb9, 0x05, 0x00, 0xb0, 0x11, 0xe8, 0xad,
	0x29, 0xb9, 0x34, 0x00, 0xb0, 0x17, 0xe8, 0xac,
	0x29, 0xb9, 0x71, 0x03, 0xe8, 0x88, 0x9a, 0xe8,
	0x7e, 0xbf, 0xc6, 0x47, 0x02, 0x6b, 0xe8, 0xbf,
	0x2d, 0xe8, 0xb8, 0x9a, 0xb0, 0x56, 0xe8, 0xcf,
	0xa6, 0xb0, 0x55, 0xe8, 0xba, 0xa6, 0xc6, 0x06,
	0xe8, 0xdb, 0x01, 0xc3, 0xbb, 0x8f, 0x5e, 0xe8,
	0xcb, 0x1f, 0xc3, 0x80, 0x3e, 0xda, 0xdb, 0x01,
	0x75, 0x07, 0xbb, 0xf2, 0x53, 0xe8, 0xbd, 0x1f,
	0xc3, 0xbb, 0xdd, 0x53, 0xe8, 0xb6, 0x1f, 0xb9,
	0x05, 0x00, 0xb0, 0x02, 0xb4, 0x07, 0xe8, 0x54,
	0x29, 0xb0, 0x12, 0xe8, 0x58, 0x29, 0xb9, 0x2a,
	0x03, 0xe8, 0x5c, 0x9a, 0xe8, 0xe3, 0x96, 0xbb,
	0xbf, 0x60, 0xe8, 0x08, 0x91, 0xc6, 0x06, 0xda,
	0xdb, 0x01, 0xc3, 0xe8, 0xd4, 0x96, 0xbb, 0x11,
	0x68, 0xe8, 0xf9, 0x90, 0xb9, 0x05, 0x00, 0xb0,
	0x03, 0xb4, 0x05, 0xe8, 0x27, 0x29, 0xb0, 0x1e,
	0xe8, 0x32, 0x29, 0xb9, 0x1a, 0x00, 0xb0, 0x0e,
	0xe8, 0x23, 0x29, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0x53, 0x03, 0xb9, 0x51, 0x03, 0xe8, 0x02, 0x9a,
	0xe8, 0xa0, 0x2a, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0x52, 0x03, 0xb0, 0x01, 0xe8, 0x28, 0x99, 0xe8,
	0xea, 0x29, 0xb0, 0x53, 0xe8, 0x31, 0xa6, 0xb0,
	0x52, 0xe8, 0x3c, 0xa6, 0xb0, 0x01, 0xe8, 0xc8,
	0x98, 0xc6, 0x06, 0xe2, 0xdb, 0x01, 0xc3, 0xe8,
	0x0c, 0x97, 0xbb, 0x41, 0x0a, 0xe8, 0xa5, 0x90,
	0xb9, 0x05, 0x00, 0xb0, 0x02, 0xb4, 0x0a, 0xe8,
	0xd3, 0x28, 0xb0, 0x2c, 0xe8, 0xd7, 0x28, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0x82, 0x02, 0xb9, 0x81,
	0x02, 0xe8, 0xd4, 0x99, 0xe8, 0xe7, 0x96, 0xbb,
	0xff, 0x0a, 0xe8, 0x80, 0x90, 0xb8, 0xaa, 0x00,
	0xe8, 0xef, 0x9d, 0xe8, 0xd8, 0x96, 0xbb, 0xa0,
	0x0b, 0xe8, 0x71, 0x90, 0x8b, 0x36, 0xaf, 0x64,
	0xbb, 0xb1, 0x64, 0x8b, 0x3f, 0xff, 0x0f, 0xe8,
	0xc9, 0xb4, 0xe8, 0xf0, 0x9d, 0xbb, 0x10, 0x0c,
	0xe8, 0x5a, 0x90, 0xb0, 0x32, 0xe8, 0xd8, 0xa5,
	0xe8, 0xd2, 0x1b, 0xc3, 0xe8, 0xe0, 0x99, 0xe8,
	0x6e, 0xbe, 0xc6, 0x07, 0x00, 0x53, 0xe8, 0xf3,
	0x2c, 0xb9, 0x05, 0x00, 0xb0, 0x02, 0xb4, 0x09,
	0xe8, 0x72, 0x28, 0xb0, 0x05, 0xe8, 0x76, 0x28,
	0xb0, 0x09, 0xe8, 0x78, 0x28, 0xb9, 0x0e, 0x00,
	0xb0, 0x13, 0xe8, 0x77, 0x28, 0xb9, 0x05, 0x00,
	0xb0, 0x32, 0xe8, 0x76, 0x28, 0xb9, 0x1e, 0x02,
	0xe8, 0x47, 0x99, 0x5b, 0xb0, 0x0f, 0x88, 0x47,
	0x01, 0xe8, 0x6d, 0x2d, 0xb0, 0x03, 0xe8, 0x2c,
	0x98, 0xb0, 0x09, 0xe8, 0x1b, 0x98, 0xe8, 0x6b,
	0x99, 0xc3, 0xb9, 0x38, 0x00, 0xb0, 0x0b, 0xb4,
	0x08, 0xe8, 0x31, 0x28, 0xb9, 0x24, 0x00, 0xb0,
	0x0d, 0xb4, 0x0c, 0xe8, 0x30, 0x28, 0xb9, 0x30,
	0x00, 0xb0, 0x16, 0xb4, 0x0a, 0xe8, 0x2d, 0x28,
	0xb9, 0x38, 0x00, 0xb0, 0x39, 0xb4, 0x08, 0xe8,
	0x2a, 0x28, 0xb9, 0x24, 0x00, 0xb0, 0x3b, 0xb4,
	0x0c, 0xe8, 0x27, 0x28, 0xb9, 0x30, 0x00, 0xb0,
	0x44, 0xb4, 0x0a, 0xe8, 0x24, 0x28, 0xb9, 0x36,
	0x00, 0xb0, 0x78, 0xb4, 0x08, 0xe8, 0x21, 0x28,
	0xb9, 0x38, 0x00, 0xb0, 0x8d, 0xb4, 0x0a, 0xe8,
	0x1e, 0x28, 0xb0, 0x90, 0xe8, 0x20, 0x28, 0xb0,
	0x93, 0xe8, 0x22, 0x28, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x4d, 0x02, 0xb9, 0x4c, 0x02, 0xe8, 0xe7,
	0x98, 0xe8, 0x22, 0x9d, 0xbb, 0x7f, 0x36, 0xe8,
	0x23, 0x1e, 0xb0, 0x22, 0xe8, 0x11, 0xa5, 0xc6,
	0x06, 0xa1, 0xdb, 0x01, 0xc3, 0xb9, 0x05, 0x00,
	0xb0, 0x03, 0xb4, 0x03, 0xe8, 0xb6, 0x27, 0xb9,
	0x41, 0x00, 0xb0, 0x10, 0xe8, 0xb7, 0x27, 0xb0,
	0x12, 0xe8, 0xb9, 0x27, 0xb0, 0x14, 0xe8, 0xbb,
	0x27, 0xb0, 0x16, 0xe8, 0xbd, 0x27, 0xb0, 0x18,
	0xe8, 0xbf, 0x27, 0xb0, 0x1a, 0xe8, 0xc1, 0x27,
	0xb0, 0x1c, 0xe8, 0xc3, 0x27, 0xb9, 0x2f, 0x00,
	0xb0, 0x21, 0xe8, 0xc2, 0x27, 0xb9, 0x6c, 0x02,
	0xe8, 0x74, 0x98, 0xb9, 0x38, 0x00, 0xb0, 0x03,
	0xb4, 0x03, 0xe8, 0x78, 0x27, 0xb0, 0x06, 0xe8,
	0x7c, 0x27, 0xb0, 0x09, 0xe8, 0x7e, 0x27, 0xb0,
	0x0c, 0xe8, 0x80, 0x27, 0xb0, 0x0f, 0xe8, 0x82,
	0x27, 0xb0, 0x12, 0xe8, 0x84, 0x27, 0xc6, 0x06,
	0xe6, 0x1c, 0xd9, 0xc6, 0x06, 0x35, 0x33, 0x14,
	0xc6, 0x06, 0x36, 0x33, 0x25, 0xb8, 0xce, 0x3a,
	0xa3, 0x37, 0x33, 0xb8, 0x26, 0x0f, 0xa3, 0x39,
	0x33, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x6f, 0x02,
	0xb9, 0x6d, 0x02, 0xe8, 0xa9, 0x98, 0xc6, 0x06,
	0x35, 0x33, 0x01, 0xc6, 0x06, 0x36, 0x33, 0x09,
	0xb8, 0xe6, 0x3a, 0xa3, 0x37, 0x33, 0xb8, 0x1e,
	0x0f, 0xa3, 0x39, 0x33, 0xb9, 0x23, 0x00, 0xb0,
	0x01, 0xb4, 0x03, 0xe8, 0x17, 0x27, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0x70, 0x02, 0xb9, 0x6e, 0x02,
	0xe8, 0x7c, 0x98, 0xe8, 0x36, 0x98, 0xb8, 0x96,
	0x00, 0xe8, 0x3e, 0x9c, 0xbb, 0xfd, 0x3a, 0xe8,
	0x53, 0x1d, 0xb0, 0x2b, 0xe8, 0x41, 0xa4, 0xe8,
	0x3b, 0x1a, 0xc3, 0xbb, 0xa1, 0x46, 0xe8, 0x44,
	0x1d, 0xc3, 0xbb, 0x00, 0x30, 0xe8, 0xad, 0x8e,
	0xb9, 0x05, 0x00, 0xb0, 0x18, 0xb4, 0x03, 0xe8,
	0xdb, 0x26, 0xb9, 0x1a, 0x00, 0xb0, 0x20, 0xe8,
	0xdc, 0x26, 0xb9, 0x05, 0x00, 0xb0, 0x2a, 0xe8,
	0xdb, 0x26, 0xb9, 0x0f, 0x00, 0xb0, 0x4d, 0xe8,
	0xda, 0x26, 0xb0, 0x4f, 0xe8, 0xdc, 0x26, 0xb0,
	0x52, 0xe8, 0xde, 0x26, 0xb9, 0x16, 0x00, 0xb0,
	0x5b, 0xe8, 0xdd, 0x26, 0xb9, 0x16, 0x00, 0xb0,
	0x66, 0xe8, 0xdc, 0x26, 0xb9, 0x1a, 0x00, 0xb0,
	0x72, 0xe8, 0xdb, 0x26, 0xb9, 0x18, 0x00, 0xb0,
	0x7c, 0xe8, 0xda, 0x26, 0xb0, 0x1a, 0xb4, 0x01,
	0xe8, 0xa3, 0x9b, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0x33, 0x02, 0xb9, 0x32, 0x02, 0xe8, 0xa6, 0x97,
	0xb0, 0x06, 0xe8, 0x68, 0x96, 0xb0, 0x01, 0xb4,
	0x00, 0xe8, 0xf5, 0xaa, 0xe8, 0x09, 0xab, 0xbb,
	0x3f, 0x36, 0xe8, 0xc8, 0x1c, 0xb0, 0x1b, 0xe8,
	0xb6, 0xa3, 0xb0, 0x1c, 0xe8, 0xa1, 0xa3, 0xc3,
	0xbb, 0x13, 0x49, 0xe8, 0xb7, 0x1c, 0xc3, 0xb0,
	0x20, 0xe8, 0xa4, 0xa3, 0xb9, 0x25, 0x00, 0xb0,
	0x0e, 0xb4, 0x04, 0xe8, 0x4f, 0x26, 0xb9, 0x10,
	0x00, 0xb0, 0x11, 0xb4, 0x09, 0xe8, 0x4e, 0x26,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0x35, 0x02,
	0xb9, 0x34, 0x02, 0xe8, 0x29, 0x97, 0xe8, 0x1f,
	0xbc, 0xc6, 0x07, 0x18, 0xe8, 0x5a, 0x2a, 0xe8,
	0xcc, 0x26, 0xb9, 0x27, 0x00, 0xb0, 0x05, 0xb4,
	0x00, 0xe8, 0x21, 0x26, 0xb9, 0x46, 0x02, 0xe8,
	0x10, 0x97, 0xe8, 0x47, 0x97, 0xbe, 0x3f, 0x00,
	0xbf, 0xc3, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x01,
	0xe8, 0x38, 0xb2, 0xbb, 0x47, 0x33, 0xc7, 0x47,
	0x02, 0x3b, 0x02, 0xb0, 0x02, 0xe8, 0x20, 0x96,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0x3c, 0x02,
	0xb0, 0x02, 0xe8, 0x13, 0x96, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0x3d, 0x02, 0xb0, 0x02, 0xe8,
	0x06, 0x96, 0xb9, 0x28, 0x00, 0xb0, 0x01, 0xb4,
	0x08, 0xe8, 0xd9, 0x25, 0xb0, 0x03, 0xe8, 0xdd,
	0x25, 0xb0, 0x05, 0xe8, 0xdf, 0x25, 0xb0, 0x07,
	0xe8, 0xe1, 0x25, 0xbb, 0x47, 0x33, 0xc7, 0x47,
	0x02, 0x3e, 0x02, 0xb0, 0x02, 0xe8, 0xe0, 0x95,
	0xb0, 0x01, 0xb4, 0x00, 0xe8, 0x32, 0xaa, 0xe8,
	0x46, 0xaa, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0x3f, 0x02, 0xb0, 0x02, 0xe8, 0xc9, 0x95, 0xbb,
	0x47, 0x33, 0xc7, 0x47, 0x02, 0x40, 0x02, 0xb0,
	0x02, 0xe8, 0xbc, 0x95, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x02, 0x41, 0x02, 0xb0, 0x02, 0xe8, 0xaf,
	0x95, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0x42,
	0x02, 0xb0, 0x02, 0xe8, 0xa2, 0x95, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x02, 0x43, 0x02, 0xb0, 0x02,
	0xe8, 0x95, 0x95, 0xbb, 0x47, 0x33, 0xc7, 0x47,
	0x02, 0x44, 0x02, 0xb0, 0x02, 0xe8, 0x88, 0x95,
	0xb9, 0x37, 0x00, 0xb0, 0x12, 0xb4, 0x01, 0xe8,
	0x5b, 0x25, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0x45, 0x02, 0xb0, 0x02, 0xe8, 0x71, 0x95, 0xe8,
	0xec, 0x25, 0xc6, 0x06, 0x33, 0x33, 0x01, 0xc6,
	0x06, 0xdd, 0x1c, 0x02, 0xb0, 0x02, 0xe8, 0x24,
	0x95, 0xc6, 0x06, 0x9f, 0xdb, 0x01, 0xc3, 0xb9,
	0x14, 0x00, 0xb0, 0x09, 0xb4, 0x06, 0xe8, 0x2c,
	0x25, 0xb9, 0x12, 0x02, 0xe8, 0x18, 0x96, 0xe8,
	0xb9, 0x26, 0xc7, 0x06, 0xf3, 0xb4, 0x10, 0x00,
	0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xe8, 0x3f, 0x27,
	0xb9, 0x13, 0x02, 0xc6, 0x06, 0xdc, 0x1c, 0x01,
	0xe8, 0xfc, 0x95, 0xb9, 0x24, 0x00, 0xb0, 0x04,
	0xb4, 0x0c, 0xe8, 0x00, 0x25, 0xb9, 0x14, 0x02,
	0xe8, 0xef, 0x95, 0xb9, 0x15, 0x02, 0xe8, 0xe9,
	0x95, 0xe8, 0xdc, 0xba, 0xb0, 0x09, 0x88, 0x07,
	0xe8, 0x0e, 0x2a, 0xc7, 0x06, 0xaf, 0x64, 0xec,
	0x00, 0xc7, 0x06, 0xb1, 0x64, 0x5f, 0x00, 0xc6,
	0x06, 0xc3, 0x64, 0x01, 0xc6, 0x06, 0xcb, 0x64,
	0x01, 0xc6, 0x06, 0xcd, 0x64, 0x00, 0xe8, 0xfb,
	0x95, 0xb9, 0x09, 0x00, 0xe8, 0x14, 0x2c, 0xc3,
	0xbb, 0x46, 0x67, 0xe8, 0x9c, 0xba, 0x83, 0xc3,
	0x03, 0xff, 0x37, 0x53, 0xc7, 0x07, 0x3f, 0x01,
	0xbe, 0xec, 0x00, 0xbf, 0xbe, 0x00, 0xe8, 0xda,
	0xb0, 0xb9, 0x05, 0x00, 0xb0, 0x04, 0xb4, 0x0b,
	0xe8, 0xa2, 0x24, 0xb9, 0x0e, 0x00, 0xb0, 0x0e,
	0xe8, 0xa3, 0x24, 0xb0, 0x21, 0xe8, 0xa5, 0x24,
	0xb9, 0x05, 0x00, 0xb0, 0x2b, 0xe8, 0xa4, 0x24,
	0xe8, 0xe4, 0x95, 0xe8, 0x72, 0xba, 0x53, 0xc6,
	0x47, 0x02, 0x00, 0xe8, 0xf6, 0x28, 0xe8, 0x30,
	0x00, 0xb9, 0x83, 0x02, 0xe8, 0x6b, 0x95, 0x5b,
	0xc6, 0x47, 0x02, 0x2b, 0xe8, 0xa1, 0x28, 0xe8,
	0x32, 0x00, 0xe8, 0x97, 0x95, 0xbe, 0xec, 0x00,
	0xbf, 0xb3, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x03,
	0xe8, 0x88, 0xb0, 0x5b, 0x8f, 0x07, 0xb0, 0x2c,
	0xe8, 0x9d, 0xa1, 0xb0, 0x2e, 0xe8, 0x88, 0xa1,
	0xc3, 0x1e, 0xa1, 0xb5, 0x32, 0x8e, 0xd8, 0x33,
	0xdb, 0x8a, 0x07, 0xc6, 0x07, 0x00, 0x1f, 0x2e,
	0xa2, 0xd5, 0x85, 0xc3, 0x2e, 0xa0, 0xd5, 0x85,
	0x1e, 0x8b, 0x1e, 0xb5, 0x32, 0x8e, 0xdb, 0x33,
	0xdb, 0x88, 0x07, 0x1f, 0xc3, 0x00, 0xbb, 0xbf,
	0x48, 0xe8, 0x79, 0x1a, 0xc3, 0xbb, 0xd6, 0x48,
	0xe8, 0x72, 0x1a, 0xc3, 0xbb, 0x5c, 0x49, 0xe8,
	0x6b, 0x1a, 0xc3, 0x80, 0x3e, 0xb0, 0xdb, 0x01,
	0x74, 0x07, 0xbb, 0x86, 0x3d, 0xe8, 0x5d, 0x1a,
	0xc3, 0xb0, 0x06, 0xe8, 0xdb, 0x93, 0xb9, 0x19,
	0x00, 0xb0, 0x0a, 0xb4, 0x0a, 0xe8, 0xf5, 0x23,
	0xb0, 0x0e, 0xe8, 0xf9, 0x23, 0xb0, 0x12, 0xe8,
	0xfb, 0x23, 0xb9, 0x2f, 0x02, 0xe8, 0xe7, 0x94,
	0xe8, 0xcd, 0xb9, 0xb0, 0x17, 0x88, 0x47, 0x01,
	0xe8, 0xfe, 0x28, 0xe8, 0x06, 0x95, 0xc6, 0x06,
	0xb0, 0xdb, 0x02, 0xc3, 0xbb, 0x57, 0x34, 0x80,
	0x3e, 0xb0, 0xdb, 0x01, 0x75, 0x03, 0xbb, 0x82,
	0x48, 0xe8, 0x19, 0x1a, 0xc3, 0xb9, 0x0c, 0x00,
	0xb0, 0x04, 0xb4, 0x08, 0xe8, 0xb6, 0x23, 0xb9,
	0x32, 0x00, 0xb0, 0x14, 0xe8, 0xb7, 0x23, 0xb0,
	0x1d, 0xe8, 0xb9, 0x23, 0xb9, 0x2a, 0x02, 0xe8,
	0xb6, 0x94, 0xb0, 0x13, 0xe8, 0xe9, 0xa0, 0xb0,
	0x16, 0xe8, 0xd4, 0xa0, 0xc3, 0xb9, 0x05, 0x00,
	0xb0, 0x03, 0xb4, 0x0c, 0xe8, 0x8e, 0x23, 0xb9,
	0x38, 0x00, 0xb0, 0x0c, 0xe8, 0x8f, 0x23, 0xb0,
	0x0e, 0xe8, 0x91, 0x23, 0xb0, 0x10, 0xe8, 0x93,
	0x23, 0xb0, 0x12, 0xe8, 0x95, 0x23, 0xb0, 0x16,
	0xe8, 0x97, 0x23, 0xb0, 0x18, 0xe8, 0x99, 0x23,
	0xb9, 0x05, 0x00, 0xb0, 0x1c, 0xe8, 0x98, 0x23,
	0xb9, 0x37, 0x02, 0xe8, 0x72, 0x94, 0xb0, 0x0c,
	0xe8, 0xa5, 0xa0, 0xb0, 0x21, 0xe8, 0x90, 0xa0,
	0xc3, 0x80, 0x3e, 0x92, 0xdb, 0x01, 0x75, 0x07,
	0xbb, 0x40, 0x3d, 0xe8, 0x9f, 0x19, 0xc3, 0xc6,
	0x06, 0x92, 0xdb, 0x01, 0xe8, 0x44, 0x91, 0xbb,
	0xcd, 0x0f, 0xe8, 0x00, 0x8b, 0xc6, 0x06, 0xe6,
	0x1c, 0xd1, 0xb8, 0x07, 0x01, 0xe8, 0x3e, 0x98,
	0xb9, 0x05, 0x00, 0xb0, 0x10, 0xb4, 0x06, 0xe8,
	0x23, 0x23, 0xb9, 0x01, 0x00, 0xb0, 0x19, 0xe8,
	0x24, 0x23, 0xb0, 0x1d, 0xe8, 0x26, 0x23, 0xb0,
	0x22, 0xe8, 0x28, 0x23, 0xc6, 0x06, 0xdc, 0x64,
	0x00, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xfa, 0x01,
	0xb9, 0xf8, 0x01, 0xe8, 0xf4, 0x93, 0xe8, 0xe7,
	0xb8, 0xc6, 0x07, 0x00, 0xe8, 0x29, 0x27, 0xc7,
	0x06, 0x30, 0x32, 0x00, 0x00, 0xc7, 0x06, 0x2e,
	0x32, 0x72, 0x00, 0xc7, 0x06, 0x2c, 0x32, 0xae,
	0x00, 0xb9, 0x18, 0x00, 0xb0, 0x02, 0xb4, 0x06,
	0xe8, 0xda, 0x22, 0xb9, 0x16, 0x00, 0xb0, 0x18,
	0xe8, 0xdb, 0x22, 0xb9, 0x01, 0x00, 0xb0, 0x1c,
	0xe8, 0xda, 0x22, 0xb0, 0x20, 0xe8, 0xdc, 0x22,
	0xb0, 0x25, 0xe8, 0xde, 0x22, 0xb9, 0x05, 0x00,
	0xb0, 0x2b, 0xe8, 0xdd, 0x22, 0xb9, 0x3d, 0x00,
	0xb0, 0x46, 0xe8, 0xdc, 0x22, 0xb9, 0x3d, 0x00,
	0xb0, 0x5b, 0xe8, 0xdb, 0x22, 0xc6, 0x06, 0x35,
	0x33, 0x06, 0xc6, 0x06, 0x36, 0x33, 0x11, 0xb8,
	0xfb, 0x3c, 0xa3, 0x37, 0x33, 0xb8, 0xcd, 0x70,
	0xa3, 0x39, 0x33, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0xfb, 0x01, 0xb9, 0xf9, 0x01, 0xe8, 0xf7, 0x93,
	0xe8, 0x6d, 0xb8, 0xb0, 0x04, 0x88, 0x07, 0xe8,
	0x9f, 0x27, 0xb8, 0x03, 0x00, 0xe8, 0xbd, 0x1c,
	0xb8, 0x14, 0x00, 0x01, 0x47, 0x03, 0x01, 0x47,
	0x07, 0xc6, 0x06, 0xcd, 0x64, 0x00, 0xc6, 0x06,
	0xcc, 0x64, 0x01, 0xc6, 0x06, 0xcb, 0x64, 0x01,
	0xff, 0x06, 0xaf, 0x64, 0xe8, 0xec, 0x23, 0xe8,
	0xcf, 0xb6, 0xb9, 0x0a, 0x00, 0xb0, 0x03, 0xb4,
	0x02, 0xe8, 0x49, 0x22, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0xf7, 0x01, 0xb0, 0x01, 0xe8, 0x60, 0x92,
	0xe8, 0xdb, 0x22, 0xc7, 0x06, 0xf3, 0xb4, 0x16,
	0x00, 0xb8, 0x01, 0x00, 0xe8, 0xaa, 0xa6, 0xb0,
	0x01, 0xe8, 0x11, 0x92, 0xc7, 0x06, 0xf3, 0xb4,
	0x14, 0x00, 0xb0, 0x0d, 0xe8, 0x06, 0x92, 0xb8,
	0x01, 0x00, 0xe8, 0x94, 0xa6, 0xe8, 0xa8, 0xa6,
	0xb0, 0x01, 0xe8, 0xf8, 0x91, 0xb0, 0x02, 0xe8,
	0xf3, 0x91, 0xb0, 0x0e, 0xe8, 0xee, 0x91, 0xb0,
	0x0f, 0xe8, 0xe9, 0x91, 0xb0, 0x10, 0xe8, 0xe4,
	0x91, 0xe8, 0x41, 0x14, 0xb8, 0x32, 0x00, 0xe8,
	0x52, 0x97, 0xe8, 0x47, 0x14, 0xbe, 0xa2, 0x00,
	0xbf, 0xa4, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x02,
	0xe8, 0x10, 0xae, 0xc6, 0x06, 0xe6, 0x1c, 0xe5,
	0xbb, 0x01, 0x3d, 0xbe, 0x46, 0x5f, 0xe8, 0xd5,
	0x1a, 0xc6, 0x06, 0xe6, 0x1c, 0xd8, 0xbb, 0x20,
	0x3d, 0xbe, 0x5a, 0x5f, 0xe8, 0xc7, 0x1a, 0xbe,
	0xa2, 0x00, 0xbf, 0xbf, 0x00, 0xc6, 0x06, 0xc3,
	0x64, 0x02, 0xe8, 0xe6, 0xad, 0xe8, 0xfd, 0x13,
	0xb8, 0x32, 0x00, 0xe8, 0x0e, 0x97, 0xe8, 0x97,
	0xb7, 0x32, 0xc0, 0x88, 0x47, 0x01, 0x88, 0x47,
	0x02, 0x88, 0x47, 0x03, 0x88, 0x47, 0x04, 0xc6,
	0x06, 0xdc, 0x1c, 0x03, 0xe8, 0x0d, 0x26, 0xbb,
	0x46, 0x67, 0xe8, 0x6d, 0xb7, 0x43, 0x33, 0xc0,
	0x89, 0x47, 0x02, 0x89, 0x47, 0x04, 0x89, 0x47,
	0x06, 0x89, 0x47, 0x08, 0xb9, 0x3e, 0x00, 0xb0,
	0x01, 0xb4, 0x0e, 0xe8, 0x77, 0x21, 0xb9, 0x09,
	0x00, 0xb0, 0x08, 0xe8, 0x78, 0x21, 0xe8, 0xc3,
	0x13, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x00, 0x02,
	0xb0, 0x01, 0xe8, 0x83, 0x91, 0xe8, 0x4c, 0x22,
	0xb0, 0x01, 0xb4, 0x00, 0xe8, 0xd2, 0xa5, 0xe8,
	0xe6, 0xa5, 0xe8, 0xa8, 0x96, 0xbb, 0x3a, 0x3d,
	0xe8, 0xa2, 0x17, 0xb0, 0x07, 0xb4, 0x01, 0xb9,
	0xe4, 0x00, 0xba, 0xab, 0x00, 0xe8, 0x45, 0x91,
	0xb0, 0x08, 0xb9, 0x22, 0x01, 0xe8, 0x3d, 0x91,
	0xc3, 0x80, 0x3e, 0x9a, 0xdb, 0x01, 0x74, 0x3b,
	0xe8, 0x0b, 0x00, 0xb0, 0x0a, 0xe8, 0x70, 0x9e,
	0xc6, 0x06, 0x9a, 0xdb, 0x01, 0xc3, 0xe8, 0xdc,
	0x8e, 0xbb, 0x5f, 0x1b, 0xe8, 0xde, 0x88, 0xb9,
	0x05, 0x00, 0xb0, 0x02, 0xb4, 0x03, 0xe8, 0x0c,
	0x21, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x1a, 0x02,
	0xb9, 0x19, 0x02, 0xe8, 0x27, 0x92, 0xe8, 0x54,
	0x96, 0xe8, 0xb9, 0x8e, 0xbb, 0xe0, 0x1b, 0xe8,
	0xbb, 0x88, 0xc3, 0xe8, 0xaf, 0x8e, 0xbb, 0xf0,
	0xda, 0xe8, 0x99, 0x88, 0xe8, 0xae, 0x88, 0xc3,
	0x80, 0x3e, 0x9a, 0xdb, 0x01, 0x74, 0xec, 0xe8,
	0xbc, 0xff, 0xb0, 0x0b, 0xe8, 0x21, 0x9e, 0xc6,
	0x06, 0x9a, 0xdb, 0x01, 0xc3, 0x80, 0x3e, 0x9b,
	0xdb, 0x01, 0x74, 0x76, 0xe8, 0x0b, 0x00, 0xb0,
	0x0a, 0xe8, 0x0c, 0x9e, 0xc6, 0x06, 0x9b, 0xdb,
	0x01, 0xc3, 0xe8, 0x27, 0x8f, 0xbb, 0x93, 0x22,
	0xe8, 0x7a, 0x88, 0xb9, 0x05, 0x00, 0xb0, 0x0a,
	0xb4, 0x03, 0xe8, 0xa8, 0x20, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0x1b, 0x02, 0xb9, 0x1c, 0x02,
	0xe8, 0xc2, 0x91, 0xb8, 0x64, 0x00, 0xe8, 0xd1,
	0x95, 0xe8, 0x00, 0x8f, 0xbb, 0xb1, 0x24, 0xe8,
	0x53, 0x88, 0xe8, 0xd9, 0x95, 0xe8, 0x45, 0x8e,
	0xbb, 0xd7, 0x24, 0xe8, 0x47, 0x88, 0xe8, 0xeb,
	0x8e, 0xbb, 0x14, 0x25, 0xe8, 0x3e, 0x88, 0xe8,
	0xc4, 0x95, 0x8b, 0x3e, 0xb1, 0x64, 0x8b, 0x36,
	0xaf, 0x64, 0x57, 0x56, 0x47, 0xe8, 0x93, 0xac,
	0xe8, 0xb3, 0x95, 0xbb, 0x70, 0x25, 0xe8, 0x24,
	0x88, 0xe8, 0xaa, 0x95, 0x5e, 0x5f, 0xe8, 0x82,
	0xac, 0xc3, 0xe8, 0xbf, 0x8e, 0xbb, 0x02, 0xdb,
	0xe8, 0xfa, 0x87, 0xe8, 0x0f, 0x88, 0xc3, 0x80,
	0x3e, 0x9b, 0xdb, 0x01, 0x74, 0xec, 0xe8, 0x81,
	0xff, 0xb0, 0x0b, 0xe8, 0x82, 0x9d, 0xc6, 0x06,
	0x9b, 0xdb, 0x01, 0xc3, 0xb0, 0x17, 0xe8, 0x77,
	0x9d, 0xe8, 0x98, 0x8e, 0xbb, 0x34, 0x26, 0xe8,
	0xeb, 0x87, 0xb9, 0x05, 0x00, 0xb0, 0x06, 0xb4,
	0x0c, 0xe8, 0x19, 0x20, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x02, 0x2c, 0x02, 0xb9, 0x2b, 0x02, 0xe8,
	0x33, 0x91, 0xe8, 0x77, 0x8e, 0xbb, 0x0a, 0x28,
	0xe8, 0xca, 0x87, 0xb9, 0x05, 0x00, 0xb0, 0x0a,
	0xb4, 0x0c, 0xe8, 0xf8, 0x1f, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0x2e, 0x02, 0xb9, 0x2d, 0x02,
	0xe8, 0x12, 0x91, 0xe8, 0x56, 0x8e, 0xbb, 0x71,
	0x29, 0xe8, 0xa9, 0x87, 0xb0, 0x18, 0xe8, 0x17,
	0x9d, 0xc3, 0xb9, 0x2d, 0x00, 0xb0, 0x10, 0xb4,
	0x06, 0xe8, 0xd1, 0x1f, 0xe8, 0x28, 0x91, 0xe8,
	0x7f, 0xfb, 0xb9, 0x30, 0x02, 0xe8, 0xba, 0x90,
	0xe8, 0x89, 0xfb, 0xe8, 0xee, 0x90, 0xb0, 0x1a,
	0xe8, 0x05, 0x9d, 0xb0, 0x1b, 0xe8, 0xf0, 0x9c,
	0xe8, 0x03, 0x95, 0xe8, 0x6f, 0x8d, 0xbb, 0xcd,
	0x1e, 0xe8, 0x71, 0x87, 0x8b, 0x3e, 0xb1, 0x64,
	0x8b, 0x36, 0xaf, 0x64, 0x4e, 0xe8, 0xcb, 0xab,
	0xe8, 0x5a, 0x8d, 0xbb, 0x09, 0x1f, 0xe8, 0x5c,
	0x87, 0xc6, 0x06, 0xb1, 0xdb, 0x01, 0xc3, 0x80,
	0x3e, 0xb5, 0xdb, 0x01, 0x74, 0x07, 0xbb, 0x29,
	0x4a, 0xe8, 0xd9, 0x15, 0xc3, 0xe8, 0xec, 0x8d,
	0xbb, 0x92, 0x29, 0xe8, 0x3f, 0x87, 0xb9, 0x05,
	0x00, 0xb0, 0x03, 0xb4, 0x0e, 0xe8, 0x6d, 0x1f,
	0xb0, 0x14, 0xe8, 0x71, 0x1f, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0x9f, 0x02, 0xb9, 0x9e, 0x02,
	0xe8, 0x5f, 0x90, 0xe8, 0xed, 0x20, 0xe8, 0xcb,
	0x00, 0xe8, 0xe4, 0x8d, 0xbb, 0x00, 0x2a, 0xe8,
	0x13, 0x87, 0xe8, 0xbf, 0x00, 0xc6, 0x06, 0xe6,
	0x1c, 0xe5, 0xc6, 0x06, 0x35, 0x33, 0x17, 0xc6,
	0x06, 0x36, 0x33, 0x26, 0xb8, 0x5b, 0x4a, 0xa3,
	0x37, 0x33, 0xb8, 0x4c, 0x8f, 0xa3, 0x39, 0x33,
	0xb9, 0x53, 0x00, 0xb0, 0x0c, 0xb4, 0x0c, 0xe8,
	0x23, 0x1f, 0xc6, 0x06, 0xdc, 0x64, 0x00, 0xb9,
	0xa1, 0x02, 0xe8, 0x8a, 0x90, 0xe8, 0xab, 0x20,
	0xe8, 0x01, 0x20, 0xc7, 0x06, 0xf3, 0xb4, 0x0b,
	0x00, 0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xe8, 0x2e,
	0x21, 0xb9, 0x18, 0x00, 0xb0, 0x1f, 0xb4, 0x09,
	0xe8, 0xfa, 0x1e, 0xb0, 0x30, 0xe8, 0xfe, 0x1e,
	0xb9, 0x4f, 0x00, 0xb0, 0x32, 0xb4, 0x0c, 0xe8,
	0xfb, 0x1e, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xa3,
	0x02, 0xb9, 0xa2, 0x02, 0xc6, 0x06, 0xdc, 0x1c,
	0x01, 0xe8, 0xce, 0x8f, 0xe8, 0x6c, 0x20, 0xe8,
	0xc2, 0x1f, 0xc7, 0x06, 0xf3, 0xb4, 0x1c, 0x00,
	0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xe8, 0xef, 0x20,
	0xc7, 0x06, 0xaf, 0x64, 0x00, 0x00, 0xc7, 0x06,
	0xb1, 0x64, 0xa7, 0x00, 0xc6, 0x06, 0xc3, 0x64,
	0x02, 0xc6, 0x06, 0xcb, 0x64, 0x00, 0xc6, 0x06,
	0xcd, 0x64, 0x00, 0xe8, 0xd6, 0x8f, 0xbe, 0x42,
	0x00, 0xbf, 0xa7, 0x00, 0xe8, 0xcc, 0xaa, 0xbb,
	0x6f, 0x4a, 0xe8, 0xf0, 0x14, 0xe8, 0x16, 0x9c,
	0xb0, 0x1d, 0xe8, 0xcb, 0x9b, 0xb9, 0x0a, 0x00,
	0xe8, 0xd8, 0x25, 0xc3, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x02, 0xa0, 0x02, 0xb0, 0x02, 0xe8, 0xa6,
	0x8e, 0xc3, 0xe8, 0xd2, 0x8f, 0xe8, 0x60, 0xb4,
	0xc6, 0x07, 0x00, 0xe8, 0xe6, 0x22, 0xb9, 0x05,
	0x00, 0xb0, 0x03, 0xb4, 0x05, 0xe8, 0x65, 0x1e,
	0xb0, 0x06, 0xe8, 0x69, 0x1e, 0xb0, 0x0a, 0xe8,
	0x6b, 0x1e, 0xb9, 0x5c, 0x00, 0xb0, 0x14, 0xe8,
	0x6a, 0x1e, 0xb0, 0x26, 0xe8, 0x6c, 0x1e, 0xb0,
	0x3a, 0xe8, 0x6e, 0x1e, 0xc6, 0x06, 0x35, 0x33,
	0x3a, 0xc6, 0x06, 0x36, 0x33, 0x43, 0xb8, 0x4a,
	0x46, 0xa3, 0x37, 0x33, 0xb8, 0x9e, 0x8e, 0xa3,
	0x39, 0x33, 0xc6, 0x06, 0xdc, 0x64, 0x00, 0xb9,
	0x5a, 0x02, 0xe8, 0x9a, 0x8f, 0xc6, 0x06, 0xdc,
	0x64, 0x01, 0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4,
	0x04, 0xe8, 0x19, 0x1e, 0xb9, 0x5b, 0x02, 0xe8,
	0x18, 0x8f, 0xe8, 0xfb, 0xb3, 0xc6, 0x07, 0x1b,
	0xe8, 0x3d, 0x22, 0xe8, 0x36, 0x8f, 0xc6, 0x06,
	0xa5, 0xdb, 0x01, 0xc3, 0xbb, 0x31, 0x3c, 0xe8,
	0x53, 0x14, 0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4,
	0x0a, 0xe8, 0xf1, 0x1d, 0xb9, 0x1a, 0x00, 0xb0,
	0x0d, 0xe8, 0xf2, 0x1d, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x92, 0x02, 0xb9, 0x91, 0x02, 0xe8, 0xce,
	0x8e, 0xe8, 0x6f, 0x1f, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x93, 0x02, 0xb0, 0x01, 0xe8, 0xf7, 0x8d,
	0xe8, 0xb9, 0x1e, 0xe8, 0x1f, 0x93, 0xbb, 0x3d,
	0x3c, 0xe8, 0x19, 0x14, 0xb0, 0x24, 0xe8, 0x07,
	0x9b, 0xb0, 0x09, 0xe8, 0x1c, 0x00, 0xb0, 0x07,
	0xe8, 0x17, 0x00, 0xbb, 0x46, 0x67, 0xe8, 0x89,
	0xb3, 0x43, 0xc7, 0x47, 0x06, 0x0a, 0x01, 0xc7,
	0x47, 0x08, 0xc1, 0x00, 0xc6, 0x06, 0xad, 0xdb,
	0x01, 0xc3, 0xb4, 0x01, 0xb9, 0x29, 0x01, 0xba,
	0xb5, 0x00, 0xe8, 0x98, 0x8d, 0xc3, 0xb9, 0x05,
	0x00, 0xb0, 0x03, 0xb4, 0x09, 0xe8, 0x85, 0x1d,
	0xb9, 0x1a, 0x00, 0xb0, 0x0d, 0xe8, 0x86, 0x1d,
	0xb9, 0x18, 0x00, 0xb0, 0x16, 0xe8, 0x85, 0x1d,
	0xb9, 0x50, 0x02, 0xe8, 0x71, 0x8e, 0xe8, 0x57,
	0xb3, 0xc6, 0x07, 0x00, 0xe8, 0x99, 0x21, 0xb9,
	0x01, 0x00, 0xb0, 0x05, 0xb4, 0x09, 0xe8, 0x5c,
	0x1d, 0xb0, 0x09, 0xe8, 0x60, 0x1d, 0xb0, 0x0d,
	0xe8, 0x62, 0x1d, 0xb9, 0x51, 0x02, 0xe8, 0x51,
	0x8e, 0xe8, 0x34, 0xb3, 0xc6, 0x07, 0x1c, 0xe8,
	0x76, 0x21, 0xe8, 0x6f, 0x8e, 0xb0, 0x23, 0xe8,
	0x86, 0x9a, 0xb0, 0x01, 0xe8, 0x12, 0x8d, 0xc3,
	0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4, 0x09, 0xe8,
	0x2b, 0x1d, 0xb9, 0x84, 0x02, 0xe8, 0x27, 0x8e,
	0xe8, 0x0d, 0xb3, 0xc6, 0x47, 0x01, 0x2d, 0xe8,
	0x4e, 0x21, 0xb9, 0x38, 0x00, 0xb0, 0x02, 0xb4,
	0x08, 0xe8, 0x11, 0x1d, 0xb9, 0x1a, 0x00, 0xb0,
	0x04, 0xe8, 0x12, 0x1d, 0xb9, 0x85, 0x02, 0xe8,
	0x08, 0x8e, 0xb9, 0x38, 0x00, 0xb0, 0x01, 0xb4,
	0x08, 0xe8, 0xf9, 0x1c, 0xb0, 0x06, 0xe8, 0x04,
	0x1d, 0xb9, 0x1a, 0x00, 0xb0, 0x03, 0xe8, 0xf5,
	0x1c, 0xb0, 0x08, 0xe8, 0xfe, 0x1c, 0xb9, 0x86,
	0x02, 0xe8, 0xe6, 0x8d, 0xb9, 0x05, 0x00, 0xb0,
	0x15, 0xb4, 0x09, 0xe8, 0xd7, 0x1c, 0xb9, 0x87,
	0x02, 0xe8, 0xf9, 0x8d, 0xb0, 0x02, 0xe8, 0xb4,
	0x8c, 0xb8, 0x03, 0x00, 0xe8, 0x0e, 0x17, 0xc7,
	0x47, 0x0d, 0x9c, 0x00, 0xc6, 0x06, 0xac, 0xdb,
	0x01, 0xc3, 0xbb, 0x0b, 0x5e, 0xe8, 0x0d, 0x13,
	0xc3, 0xbb, 0xa1, 0x46, 0xe8, 0x06, 0x13, 0xc3,
	0xbb, 0xc3, 0x46, 0xe8, 0xff, 0x12, 0xc3, 0xb9,
	0x05, 0x00, 0xb0, 0x02, 0xb4, 0x07, 0xe8, 0x9c,
	0x1c, 0xb9, 0x0f, 0x00, 0xb0, 0x0c, 0xe8, 0x9d,
	0x1c, 0xb9, 0x7e, 0x02, 0xe8, 0xa1, 0x8d, 0xb0,
	0x30, 0xe8, 0xd4, 0x99, 0xe8, 0x0d, 0x91, 0x72,
	0x1e, 0xb0, 0x30, 0xe8, 0xba, 0x99, 0xb9, 0x18,
	0x00, 0xb0, 0x1a, 0xb4, 0x07, 0xe8, 0x75, 0x1c,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x04, 0x8b, 0x02,
	0xb9, 0x8a, 0x02, 0xe8, 0x7a, 0x8d, 0xc3, 0xa1,
	0x1f, 0xc4, 0xe8, 0xc7, 0x9a, 0x3c, 0x31, 0x75,
	0xd8, 0x83, 0x3e, 0x52, 0x72, 0x05, 0x75, 0xd1,
	0xc6, 0x06, 0xcf, 0x00, 0x00, 0xb9, 0x05, 0x00,
	0xb0, 0x02, 0xb4, 0x07, 0xe8, 0x46, 0x1c, 0xb9,
	0x34, 0x00, 0xb0, 0x0d, 0xe8, 0x47, 0x1c, 0xb9,
	0x88, 0x02, 0xe8, 0x2a, 0x8d, 0xe8, 0x20, 0xb2,
	0xc6, 0x47, 0x01, 0x2e, 0xe8, 0x61, 0x20, 0xe8,
	0x5a, 0x8d, 0xb0, 0x31, 0xe8, 0x71, 0x99, 0xe8,
	0xaa, 0x90, 0x73, 0x03, 0xe9, 0x91, 0x00, 0xb9,
	0x1b, 0x00, 0xb0, 0x05, 0xb4, 0x07, 0xe8, 0x14,
	0x1c, 0xe8, 0xfc, 0xb1, 0xc6, 0x47, 0x01, 0x00,
	0xe8, 0x81, 0x20, 0xb9, 0x8c, 0x02, 0xe8, 0xf9,
	0x8c, 0xb9, 0x18, 0x00, 0xb0, 0x04, 0xb4, 0x07,
	0xe8, 0xfa, 0x1b, 0xb9, 0x05, 0x00, 0xb0, 0x0c,
	0xe8, 0xfb, 0x1b, 0xc7, 0x06, 0xaf, 0x64, 0xbb,
	0x00, 0xc7, 0x06, 0xb1, 0x64, 0xb3, 0x00, 0xc6,
	0x06, 0xcc, 0x64, 0x01, 0xc6, 0x06, 0xcb, 0x64,
	0x00, 0xc6, 0x06, 0xdc, 0x64, 0x00, 0xb9, 0x8d,
	0x02, 0xe8, 0xc6, 0x8c, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x04, 0x8f, 0x02, 0xb9, 0x8e, 0x02, 0xe8,
	0xdd, 0x8c, 0xff, 0x36, 0xcf, 0x00, 0xc6, 0x06,
	0xcf, 0x00, 0x00, 0xbb, 0xf6, 0x3b, 0xe8, 0x0c,
	0x12, 0x8f, 0x06, 0xcf, 0x00, 0xb0, 0x31, 0xe8,
	0xe6, 0x98, 0xc7, 0x06, 0xf3, 0xb4, 0x1b, 0x00,
	0xb0, 0x02, 0xb4, 0x04, 0xe8, 0x1a, 0xa0, 0xb0,
	0x04, 0xe8, 0x75, 0x8b, 0xc6, 0x06, 0xa9, 0xdb,
	0x00, 0xc7, 0x06, 0xf3, 0xb4, 0x1a, 0x00, 0xc3,
	0xa1, 0x1f, 0xc4, 0xe8, 0xee, 0x99, 0x3c, 0x1d,
	0x74, 0x03, 0xe9, 0x62, 0xff, 0x83, 0x3e, 0x52,
	0x72, 0x05, 0x74, 0x03, 0xe9, 0x58, 0xff, 0xc6,
	0x06, 0xcf, 0x00, 0x00, 0xc7, 0x06, 0x1f, 0xc4,
	0x00, 0x00, 0xb9, 0x05, 0x00, 0xb0, 0x02, 0xb4,
	0x07, 0xe8, 0x61, 0x1b, 0xb9, 0x13, 0x00, 0xb0,
	0x0c, 0xe8, 0x62, 0x1b, 0xb9, 0x89, 0x02, 0xe8,
	0x48, 0x8c, 0xe8, 0x3b, 0xb1, 0xc6, 0x47, 0x01,
	0x2f, 0xe8, 0xc0, 0x1f, 0xe8, 0x75, 0x8c, 0xb8,
	0x2c, 0x01, 0xe8, 0x7d, 0x90, 0xb9, 0x44, 0x00,
	0xb0, 0x01, 0xb4, 0x0c, 0xe8, 0x36, 0x1b, 0xb0,
	0x05, 0xe8, 0x3a, 0x1b, 0xb0, 0x09, 0xe8, 0x3c,
	0x1b, 0xb0, 0x0d, 0xe8, 0x3e, 0x1b, 0xb0, 0x11,
	0xe8, 0x40, 0x1b, 0xb0, 0x15, 0xe8, 0x42, 0x1b,
	0xb0, 0x19, 0xe8, 0x44, 0x1b, 0xb0, 0x1d, 0xe8,
	0x46, 0x1b, 0xb0, 0x21, 0xe8, 0x48, 0x1b, 0xb0,
	0x25, 0xe8, 0x4a, 0x1b, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x04, 0x7f, 0x02, 0xb0, 0x03, 0xe8, 0x68,
	0x8b, 0xe8, 0xe4, 0xb0, 0xc6, 0x07, 0x2a, 0xe8,
	0x6a, 0x1f, 0xe8, 0x1f, 0x8c, 0xb0, 0x06, 0xe8,
	0xc7, 0x8a, 0xb0, 0x05, 0xe8, 0xce, 0x8a, 0xc6,
	0x06, 0xab, 0xdb, 0x01, 0xc3, 0xbb, 0xd6, 0x2d,
	0xe8, 0xa2, 0x82, 0xe8, 0x31, 0x8c, 0xb9, 0x38,
	0x00, 0xb0, 0x10, 0xb4, 0x07, 0xe8, 0xcd, 0x1a,
	0xb0, 0x12, 0xe8, 0xd1, 0x1a, 0xb0, 0x14, 0xe8,
	0xd3, 0x1a, 0xb0, 0x16, 0xe8, 0xd5, 0x1a, 0xb0,
	0x18, 0xe8, 0xd7, 0x1a, 0xb0, 0x1a, 0xe8, 0xd9,
	0x1a, 0xb0, 0x1c, 0xe8, 0xdb, 0x1a, 0xb0, 0x1e,
	0xe8, 0xdd, 0x1a, 0xb9, 0x02, 0x00, 0xb0, 0x40,
	0xe8, 0xdc, 0x1a, 0xb9, 0x03, 0x00, 0xb0, 0x4a,
	0xe8, 0xdb, 0x1a, 0xc6, 0x06, 0x35, 0x33, 0x23,
	0xc6, 0x06, 0x36, 0x33, 0x32, 0xb8, 0xc7, 0x34,
	0xa3, 0x37, 0x33, 0xb8, 0xd4, 0x64, 0xa3, 0x39,
	0x33, 0xc6, 0x06, 0xe6, 0x1c, 0xd1, 0xb0, 0x01,
	0xb4, 0x03, 0xe8, 0x62, 0x8f, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x04, 0x05, 0x02, 0xc7, 0x47, 0x06,
	0x06, 0x02, 0xb9, 0x04, 0x02, 0xe8, 0xd7, 0x8b,
	0xe8, 0xf8, 0x1b, 0xe8, 0x4e, 0x1b, 0xe8, 0xd8,
	0xae, 0xb0, 0x02, 0xe8, 0x3f, 0x8a, 0xb0, 0x03,
	0xe8, 0x3a, 0x8a, 0xb8, 0x03, 0x00, 0xe8, 0xc8,
	0x9e, 0xe8, 0xdc, 0x9e, 0xb8, 0x04, 0x00, 0xe8,
	0xbf, 0x9e, 0xe8, 0xd3, 0x9e, 0xb0, 0x02, 0xe8,
	0x86, 0x97, 0xc6, 0x06, 0x96, 0xdb, 0x01, 0xc3,
	0xbb, 0x2f, 0x3b, 0xe8, 0x87, 0x10, 0xe8, 0x86,
	0x8b, 0xb4, 0x02, 0xb0, 0x04, 0xe8, 0x36, 0x8f,
	0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4, 0x08, 0xe8,
	0x1b, 0x1a, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0x75, 0x02, 0xb9, 0x73, 0x02, 0xe8, 0x12, 0x8b,
	0xb9, 0x29, 0x00, 0xb0, 0x0a, 0xb4, 0x06, 0xe8,
	0x03, 0x1a, 0xb0, 0x2f, 0xe8, 0x07, 0x1a, 0xb9,
	0x37, 0x00, 0xb0, 0x34, 0xe8, 0x06, 0x1a, 0x80,
	0x3e, 0xa8, 0xdb, 0x01, 0x74, 0x15, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x02, 0x76, 0x02, 0xb9, 0x74,
	0x02, 0xe8, 0x09, 0x8b, 0xbb, 0x59, 0x3b, 0xe8,
	0x33, 0x10, 0xc3, 0xbb, 0x47, 0x33, 0xc7, 0x47,
	0x02, 0x7a, 0x02, 0xb9, 0x74, 0x02, 0xe8, 0xd1,
	0x8a, 0xb0, 0x04, 0xe8, 0xaf, 0x89, 0xe8, 0x5a,
	0x1b, 0xe8, 0x62, 0x1a, 0xe8, 0x3a, 0xae, 0xb8,
	0x02, 0x00, 0xe8, 0x34, 0x9e, 0xe8, 0x48, 0x9e,
	0xbb, 0x6c, 0x3b, 0xe8, 0x07, 0x10, 0xc6, 0x06,
	0xa9, 0xdb, 0x01, 0xc3, 0x80, 0x3e, 0xab, 0xdb,
	0x01, 0x75, 0x07, 0xbb, 0x0b, 0x3c, 0xe8, 0xf4,
	0x0f, 0xc3, 0xb9, 0x05, 0x00, 0xb0, 0x0b, 0xb4,
	0x06, 0xe8, 0x91, 0x19, 0xb9, 0x31, 0x00, 0xb0,
	0x15, 0xe8, 0x92, 0x19, 0xe8, 0xe0, 0x8a, 0xc7,
	0x06, 0xb1, 0x64, 0x63, 0x00, 0xb9, 0x78, 0x02,
	0xe8, 0x7f, 0x8a, 0xe8, 0x62, 0xaf, 0xc6, 0x47,
	0x05, 0x28, 0xe8, 0xa3, 0x1d, 0xc7, 0x06, 0xaf,
	0x64, 0xe9, 0x00, 0xc7, 0x06, 0xb1, 0x64, 0x8b,
	0x00, 0xb9, 0x79, 0x02, 0xe8, 0x86, 0x8a, 0xc6,
	0x06, 0xa8, 0xdb, 0x01, 0xb0, 0x2f, 0xe8, 0x9f,
	0x96, 0x80, 0x3e, 0xaa, 0xdb, 0x01, 0x74, 0x0b,
	0xc6, 0x06, 0xaa, 0xdb, 0x01, 0xbb, 0x8b, 0x3b,
	0xe8, 0x9a, 0x0f, 0xc3, 0xb9, 0x05, 0x00, 0xb0,
	0x03, 0xb4, 0x0c, 0xe8, 0x37, 0x19, 0xb9, 0x06,
	0x00, 0xb0, 0x09, 0xe8, 0x38, 0x19, 0xb9, 0x27,
	0x03, 0xe8, 0x1b, 0x8a, 0xe8, 0x11, 0xaf, 0xc6,
	0x07, 0x53, 0xe8, 0x53, 0x1d, 0xe8, 0x4c, 0x8a,
	0xb0, 0x49, 0xe8, 0x63, 0x96, 0xb0, 0x02, 0xe8,
	0xfb, 0x88, 0xb0, 0x03, 0xe8, 0xea, 0x88, 0xc6,
	0x06, 0xef, 0xdb, 0x01, 0xc3, 0xbb, 0x8e, 0x4e,
	0xe8, 0x5a, 0x0f, 0xc3, 0xe8, 0x67, 0x00, 0x80,
	0x3e, 0xd2, 0xdb, 0x01, 0x75, 0x07, 0xbb, 0xc3,
	0x50, 0xe8, 0x49, 0x0f, 0xc3, 0x80, 0x3e, 0xcb,
	0xdb, 0x01, 0x74, 0x07, 0xbb, 0x01, 0x51, 0xe8,
	0x3b, 0x0f, 0xc3, 0xbb, 0xe1, 0x50, 0xe8, 0x34,
	0x0f, 0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4, 0x04,
	0xe8, 0xd2, 0x18, 0xb0, 0x27, 0xe8, 0xd6, 0x18,
	0xc6, 0x06, 0xe6, 0x1c, 0xd0, 0xc6, 0x06, 0x35,
	0x33, 0x09, 0xc6, 0x06, 0x36, 0x33, 0x23, 0xb8,
	0x24, 0x51, 0xa3, 0x37, 0x33, 0xb8, 0xc4, 0x9d,
	0xa3, 0x39, 0x33, 0xb9, 0xd8, 0x02, 0xe8, 0x1e,
	0x8a, 0xe8, 0xd8, 0x89, 0xe8, 0xea, 0x87, 0xbb,
	0x17, 0x3d, 0xe8, 0x68, 0x80, 0xc6, 0x06, 0xd2,
	0xdb, 0x01, 0xe8, 0x10, 0x00, 0xc3, 0x80, 0x3e,
	0xd1, 0xdb, 0x01, 0x74, 0x07, 0xbb, 0xa6, 0x50,
	0xe8, 0xe2, 0x0e, 0x58, 0xc3, 0x80, 0x3e, 0xd2,
	0xdb, 0x00, 0x74, 0x4e, 0x80, 0x3e, 0xd3, 0xdb,
	0x00, 0x74, 0x47, 0x80, 0x3e, 0xd4, 0xdb, 0x00,
	0x74, 0x40, 0xb8, 0x01, 0x01, 0xe8, 0x7e, 0x8d,
	0xb9, 0x59, 0x00, 0xb0, 0x02, 0xb4, 0x03, 0xe8,
	0x63, 0x18, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xdb,
	0x02, 0xb0, 0x01, 0xe8, 0x7a, 0x88, 0xe8, 0x43,
	0x19, 0xe8, 0x3c, 0xae, 0xc6, 0x07, 0x46, 0xe8,
	0xc2, 0x1c, 0xb8, 0x01, 0x00, 0xe8, 0xc1, 0x9c,
	0xe8, 0xd5, 0x9c, 0xb0, 0x01, 0xe8, 0x25, 0x88,
	0xb0, 0x02, 0xe8, 0x14, 0x88, 0xb0, 0x03, 0xe8,
	0x0f, 0x88, 0xc3, 0xe8, 0x98, 0xff, 0x80, 0x3e,
	0xd3, 0xdb, 0x01, 0x75, 0x07, 0xbb, 0xc3, 0x50,
	0xe8, 0x7a, 0x0e, 0xc3, 0xbb, 0x38, 0x51, 0xe8,
	0x73, 0x0e, 0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4,
	0x04, 0xe8, 0x11, 0x18, 0xb0, 0x17, 0xe8, 0x15,
	0x18, 0xb9, 0xd9, 0x02, 0xe8, 0x19, 0x89, 0xe8,
	0x47, 0x87, 0xbb, 0x70, 0x3d, 0xe8, 0xc5, 0x7f,
	0xc6, 0x06, 0xd3, 0xdb, 0x01, 0xe8, 0x6d, 0xff,
	0xc3, 0xe8, 0x5a, 0xff, 0x80, 0x3e, 0xd4, 0xdb,
	0x01, 0x75, 0x07, 0xbb, 0xc3, 0x50, 0xe8, 0x3c,
	0x0e, 0xc3, 0xbb, 0x61, 0x51, 0xe8, 0x35, 0x0e,
	0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4, 0x04, 0xe8,
	0xd3, 0x17, 0xb0, 0x19, 0xe8, 0xd7, 0x17, 0xb9,
	0xda, 0x02, 0xe8, 0xdb, 0x88, 0xe8, 0x09, 0x87,
	0xbb, 0xd6, 0x3d, 0xe8, 0x87, 0x7f, 0xc6, 0x06,
	0xd4, 0xdb, 0x01, 0xe8, 0x2f, 0xff, 0xc3, 0xbb,
	0xfa, 0x4e, 0xe8, 0x08, 0x0e, 0xc3, 0xe8, 0x06,
	0x89, 0xe8, 0x94, 0xad, 0xc6, 0x47, 0x02, 0x40,
	0xe8, 0x19, 0x1c, 0xb9, 0x05, 0x00, 0xb0, 0x03,
	0xb4, 0x0a, 0xe8, 0x98, 0x17, 0xb9, 0x34, 0x00,
	0xb0, 0x0a, 0xe8, 0x99, 0x17, 0xb9, 0xc7, 0x02,
	0xe8, 0xa4, 0x88, 0x8b, 0x36, 0xaf, 0x64, 0x8b,
	0x3e, 0xb1, 0x64, 0xc6, 0x06, 0xc3, 0x64, 0x04,
	0xe8, 0xa8, 0xa3, 0xe8, 0x98, 0x86, 0xbb, 0x21,
	0x3b, 0xe8, 0x39, 0x7f, 0xbe, 0x2c, 0x01, 0xbf,
	0xbe, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x04, 0xe8,
	0x91, 0xa3, 0xb0, 0x40, 0xe8, 0xa9, 0x94, 0xb0,
	0x08, 0xe8, 0x41, 0x87, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0xc8, 0x02, 0xb0, 0x01, 0xe8, 0x70, 0x87,
	0xe8, 0x35, 0xad, 0xc6, 0x47, 0x02, 0x00, 0xe8,
	0xba, 0x1b, 0xb9, 0x0f, 0x00, 0xb0, 0x1a, 0xb4,
	0x02, 0xe8, 0x39, 0x17, 0xb0, 0x1c, 0xe8, 0x3d,
	0x17, 0xb9, 0x10, 0x00, 0xb0, 0x25, 0xe8, 0x3c,
	0x17, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xc9, 0x02,
	0xb0, 0x01, 0xe8, 0x43, 0x87, 0xe8, 0xbe, 0x17,
	0xe8, 0x3b, 0x86, 0xbb, 0x0d, 0x3c, 0xe8, 0xdc,
	0x7e, 0xb9, 0x55, 0x00, 0xb0, 0x02, 0xb4, 0x03,
	0xe8, 0x0a, 0x17, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0xca, 0x02, 0xb0, 0x01, 0xe8, 0x21, 0x87, 0xe8,
	0xea, 0x17, 0xb8, 0x01, 0x00, 0xe8, 0x71, 0x9b,
	0xe8, 0x85, 0x9b, 0xb0, 0x01, 0xe8, 0xd5, 0x86,
	0xb9, 0x51, 0x00, 0xba, 0xa0, 0x00, 0xb0, 0x02,
	0xb4, 0x04, 0xe8, 0xe8, 0x86, 0xb9, 0x3f, 0x00,
	0xba, 0xa8, 0x00, 0xb0, 0x03, 0xb4, 0x04, 0xe8,
	0xdb, 0x86, 0xb9, 0x69, 0x00, 0xba, 0xa0, 0x00,
	0xb0, 0x0a, 0xb4, 0x01, 0xe8, 0xce, 0x86, 0xc6,
	0x06, 0xcc, 0xdb, 0x01, 0xc3, 0xe8, 0xa0, 0xdd,
	0x80, 0x3e, 0xcd, 0xdb, 0x01, 0x75, 0x07, 0xbb,
	0x3d, 0x4f, 0xe8, 0x08, 0x0d, 0xc3, 0xe8, 0x06,
	0x88, 0xe8, 0x94, 0xac, 0xc6, 0x47, 0x01, 0x00,
	0xe8, 0x19, 0x1b, 0xb9, 0x05, 0x00, 0xb0, 0x03,
	0xb4, 0x07, 0xe8, 0x98, 0x16, 0xb0, 0x21, 0xe8,
	0xcd, 0x16, 0xb9, 0x18, 0x00, 0xb0, 0x0d, 0xe8,
	0x94, 0x16, 0xb0, 0x13, 0xe8, 0x96, 0x16, 0xb0,
	0x17, 0xe8, 0x9f, 0x16, 0xb0, 0x1a, 0xe8, 0xa8,
	0x16, 0xb0, 0x1d, 0xe8, 0xaa, 0x16, 0xb9, 0x17,
	0x00, 0xb0, 0x15, 0xe8, 0x86, 0x16, 0xb9, 0x4a,
	0x00, 0xb0, 0x19, 0xe8, 0x8c, 0x16, 0xb9, 0xcc,
	0x02, 0xe8, 0x56, 0x87, 0xe8, 0x49, 0xac, 0xc6,
	0x47, 0x01, 0x42, 0xe8, 0x8a, 0x1a, 0xe8, 0x83,
	0x87, 0xc6, 0x06, 0xcd, 0xdb, 0x01, 0xc3, 0xe8,
	0x2e, 0xdd, 0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4,
	0x03, 0xe8, 0x41, 0x16, 0xb9, 0x56, 0x00, 0xb0,
	0x0b, 0xe8, 0x42, 0x16, 0xb9, 0xd0, 0x02, 0xe8,
	0x54, 0x87, 0xb0, 0x44, 0xe8, 0x69, 0x93, 0xb0,
	0x37, 0xe8, 0x74, 0x93, 0xc3, 0xe8, 0x7f, 0x87,
	0xe8, 0x0d, 0xac, 0xc6, 0x47, 0x04, 0x00, 0xe8,
	0x92, 0x1a, 0xb9, 0x57, 0x00, 0xb0, 0x07, 0xb4,
	0x08, 0xe8, 0x11, 0x16, 0xb9, 0xd2, 0x02, 0xe8,
	0x25, 0x87, 0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4,
	0x09, 0xe8, 0x01, 0x16, 0xb9, 0x58, 0x00, 0xb0,
	0x0c, 0xe8, 0x02, 0x16, 0xb9, 0x57, 0x00, 0xb0,
	0x18, 0xe8, 0x01, 0x16, 0xb9, 0xd3, 0x02, 0xe8,
	0x05, 0x87, 0xbb, 0x2b, 0x50, 0xe8, 0x3d, 0x0c,
	0xe8, 0x3a, 0x8b, 0xb9, 0x59, 0x00, 0xb0, 0x04,
	0xb4, 0x08, 0xe8, 0xd8, 0x15, 0xb9, 0xd4, 0x02,
	0xe8, 0xc7, 0x86, 0xe8, 0xba, 0xab, 0xc6, 0x47,
	0x04, 0x44, 0xe8, 0xfb, 0x19, 0xe8, 0xf4, 0x86,
	0xbb, 0x3e, 0x50, 0xe8, 0x17, 0x0c, 0xb0, 0x44,
	0xe8, 0x05, 0x93, 0xc6, 0x06, 0xd0, 0xdb, 0x01,
	0xc3, 0xb9, 0x05, 0x00, 0xb0, 0x04, 0xb4, 0x03,
	0xe8, 0xaa, 0x15, 0xb9, 0x3f, 0x00, 0xb0, 0x0c,
	0xe8, 0xab, 0x15, 0xb9, 0xd6, 0x02, 0xe8, 0xbd,
	0x86, 0xbb, 0x8a, 0x50, 0xe8, 0xee, 0x0b, 0xb0,
	0x45, 0xe8, 0xdc, 0x92, 0xb0, 0x46, 0xe8, 0xc7,
	0x92, 0xc3, 0xb9, 0x05, 0x00, 0xb0, 0x04, 0xb4,
	0x0e, 0xe8, 0x81, 0x15, 0xb9, 0x13, 0x00, 0xb0,
	0x0e, 0xe8, 0x82, 0x15, 0xb9, 0x19, 0x03, 0xe8,
	0x86, 0x86, 0xbb, 0x18, 0x52, 0xe8, 0xc5, 0x0b,
	0xb0, 0x3c, 0xe8, 0xb3, 0x92, 0xc6, 0x06, 0xd6,
	0xdb, 0x01, 0xc3, 0x80, 0x3e, 0xd6, 0xdb, 0x02,
	0x74, 0x07, 0xbb, 0x4f, 0x52, 0xe8, 0xad, 0x0b,
	0xc3, 0xb9, 0x05, 0x00, 0xb0, 0x04, 0xb4, 0x0e,
	0xe8, 0x4a, 0x15, 0xb0, 0x19, 0xe8, 0x4e, 0x15,
	0xb9, 0x22, 0x03, 0xe8, 0x52, 0x86, 0xbb, 0x72,
	0x52, 0xe8, 0x91, 0x0b, 0xb0, 0x3e, 0xe8, 0x7f,
	0x92, 0xb0, 0x4a, 0xe8, 0x6a, 0x92, 0xb0, 0x41,
	0xe8, 0x65, 0x92, 0xc3, 0xb0, 0x46, 0xe8, 0x93,
	0x92, 0x73, 0x39, 0xe8, 0x79, 0x86, 0xe8, 0x07,
	0xab, 0xc6, 0x07, 0x00, 0xe8, 0x8d, 0x19, 0xb9,
	0x05, 0x00, 0xb0, 0x03, 0xb4, 0x04, 0xe8, 0x0c,
	0x15, 0xb0, 0x12, 0xe8, 0x17, 0x15, 0xb9, 0x0d,
	0x00, 0xb0, 0x0c, 0xe8, 0x08, 0x15, 0xb9, 0x23,
	0x03, 0xe8, 0x21, 0x86, 0xb0, 0x07, 0xe8, 0xdc,
	0x84, 0xb0, 0x46, 0xe8, 0x3a, 0x92, 0xb0, 0x47,
	0xe8, 0x25, 0x92, 0xc3, 0xbb, 0xad, 0x53, 0xe8,
	0x3b, 0x0b, 0xc3, 0xb9, 0x05, 0x00, 0xb0, 0x04,
	0xb4, 0x0e, 0xe8, 0xd8, 0x14, 0xb0, 0x16, 0xe8,
	0xdc, 0x14, 0xb9, 0x24, 0x03, 0xe8, 0xe0, 0x85,
	0xbb, 0x8b, 0x52, 0xe8, 0x1f, 0x0b, 0xc3, 0xb9,
	0x05, 0x00, 0xb0, 0x03, 0xb4, 0x04, 0xe8, 0xbc,
	0x14, 0xb0, 0x10, 0xe8, 0xc0, 0x14, 0xb9, 0xbf,
	0x02, 0xe8, 0xc4, 0x85, 0x80, 0x3e, 0xc8, 0xdb,
	0x01, 0x74, 0x07, 0xbb, 0x80, 0x4d, 0xe8, 0xfc,
	0x0a, 0xc3, 0x80, 0x3e, 0xc6, 0xdb, 0x00, 0x74,
	0x22, 0xc6, 0x06, 0xc6, 0xdb, 0x00, 0x80, 0x3e,
	0xc5, 0xdb, 0x01, 0x75, 0x15, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0xbd, 0x02, 0xb0, 0x01, 0xe8, 0xae,
	0x84, 0xe8, 0x70, 0x15, 0xbb, 0xa6, 0x4d, 0xe8,
	0xd3, 0x0a, 0xc3, 0x80, 0x3e, 0xc5, 0xdb, 0x01,
	0x74, 0x07, 0xbb, 0x5b, 0x4d, 0xe8, 0xc5, 0x0a,
	0xc3, 0x80, 0x3e, 0xc7, 0xdb, 0x01, 0x74, 0x06,
	0xbb, 0x93, 0x4d, 0xe8, 0xb7, 0x0a, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0xbe, 0x02, 0xb0, 0x01, 0xe8,
	0x7d, 0x84, 0xe8, 0x3f, 0x15, 0xc6, 0x06, 0xc6,
	0xdb, 0x01, 0x80, 0x3e, 0xc7, 0xdb, 0x01, 0x74,
	0x0e, 0xe8, 0x3f, 0x83, 0xbb, 0x2c, 0x39, 0xe8,
	0x03, 0x7c, 0xc6, 0x06, 0xc7, 0xdb, 0x01, 0xc3,
	0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4, 0x06, 0xe8,
	0x2b, 0x14, 0xb9, 0x5b, 0x00, 0xb0, 0x0c, 0xe8,
	0x2c, 0x14, 0xb9, 0xc2, 0x02, 0xe8, 0x30, 0x85,
	0xb0, 0x36, 0xe8, 0x63, 0x91, 0xc6, 0x06, 0xc8,
	0xdb, 0x01, 0xc3, 0x80, 0x3e, 0xc6, 0xdb, 0x01,
	0x74, 0x07, 0xbb, 0xa5, 0x4e, 0xe8, 0x5d, 0x0a,
	0xc3, 0x80, 0x3e, 0xca, 0xdb, 0x01, 0x75, 0x07,
	0xbb, 0xe6, 0x4d, 0xe8, 0x4f, 0x0a, 0xc3, 0xb9,
	0x05, 0x00, 0xb0, 0x03, 0xb4, 0x04, 0xe8, 0xec,
	0x13, 0xb0, 0x18, 0xe8, 0xf7, 0x13, 0xb9, 0x5a,
	0x00, 0xb0, 0x12, 0xe8, 0xe8, 0x13, 0xb9, 0xc3,
	0x02, 0xe8, 0xec, 0x84, 0xb0, 0x3d, 0xe8, 0x0f,
	0x91, 0xc6, 0x06, 0xca, 0xdb, 0x01, 0xc3, 0x80,
	0x3e, 0xc6, 0xdb, 0x01, 0x74, 0x07, 0xbb, 0xa5,
	0x4e, 0xe8, 0x19, 0x0a, 0xc3, 0x80, 0x3e, 0xcb,
	0xdb, 0x01, 0x75, 0x07, 0xbb, 0x32, 0x4e, 0xe8,
	0x0b, 0x0a, 0xc3, 0xbb, 0x05, 0x4e, 0xe8, 0x04,
	0x0a, 0xb9, 0x05, 0x00, 0xb0, 0x03, 0xb4, 0x04,
	0xe8, 0xa2, 0x13, 0xb0, 0x1b, 0xe8, 0xa6, 0x13,
	0xb9, 0xc4, 0x02, 0xe8, 0xaa, 0x84, 0xc6, 0x06,
	0xcb, 0xdb, 0x01, 0xc3, 0xbb, 0x58, 0x4e, 0xe8,
	0xe3, 0x09, 0xc3, 0xb9, 0x05, 0x00, 0xb0, 0x03,
	0xb4, 0x05, 0xe8, 0x80, 0x13, 0xb9, 0x18, 0x00,
	0xb0, 0x0a, 0xe8, 0x81, 0x13, 0xb9, 0x1e, 0x03,
	0xe8, 0x85, 0x84, 0xb9, 0x3f, 0x00, 0xb0, 0x0b,
	0xb4, 0x05, 0xe8, 0x68, 0x13, 0xb9, 0x13, 0x00,
	0xb0, 0x14, 0xe8, 0x69, 0x13, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0x1f, 0x03, 0xb0, 0x01, 0xe8, 0x7e,
	0x83, 0x50, 0x52, 0xbe, 0x32, 0x00, 0xbf, 0xaa,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x01, 0xe8, 0x72,
	0x9f, 0x5a, 0x58, 0xbf, 0xc7, 0x32, 0xb3, 0x1b,
	0x48, 0xf6, 0xe3, 0x03, 0xf8, 0xe8, 0x43, 0x7c,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x20, 0x03, 0xb0,
	0x01, 0xe8, 0x53, 0x83, 0xe8, 0x15, 0x14, 0xe8,
	0x7b, 0x88, 0xb9, 0x25, 0x03, 0xe8, 0x12, 0x84,
	0xe8, 0xb0, 0x14, 0xbe, 0x32, 0x00, 0xbf, 0xaa,
	0x00, 0xc6, 0x06, 0xc3, 0x64, 0x03, 0xe8, 0x3a,
	0x9f, 0xbb, 0x49, 0x53, 0xe8, 0x5e, 0x09, 0xc7,
	0x06, 0xaf, 0x64, 0x69, 0x00, 0xc7, 0x06, 0xb1,
	0x64, 0x9d, 0x00, 0xc6, 0x06, 0xcb, 0x64, 0x00,
	0xc6, 0x06, 0xcc, 0x64, 0x00, 0xc6, 0x06, 0xdc,
	0x64, 0x01, 0xe8, 0x64, 0xa7, 0xb9, 0x03, 0x00,
	0xe8, 0x30, 0x1a, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0xaa, 0x03, 0xc7, 0x06, 0xf3, 0xb4, 0x0b, 0x00,
	0xe8, 0xea, 0x15, 0xe8, 0x61, 0x80, 0xbb, 0x09,
	0x84, 0xe8, 0x91, 0x7a, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0xab, 0x03, 0xb9, 0xae, 0x03, 0xe8, 0xc1,
	0x83, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xab, 0x03,
	0xc7, 0x47, 0x02, 0xa7, 0x03, 0xb9, 0xaf, 0x03,
	0xe8, 0xaf, 0x83, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0xac, 0x03, 0xc7, 0x47, 0x02, 0xa8, 0x03, 0xb9,
	0xb0, 0x03, 0xe8, 0x9d, 0x83, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0xad, 0x03, 0xc7, 0x47, 0x02, 0xa9,
	0x03, 0xb9, 0xb1, 0x03, 0xe8, 0x8b, 0x83, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0x00, 0x00, 0xe8, 0xab,
	0x83, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xb2, 0x03,
	0xb0, 0x01, 0xe8, 0xd5, 0x82, 0xe8, 0xff, 0x7f,
	0xbb, 0x4f, 0x84, 0xe8, 0x2f, 0x7a, 0xbb, 0x47,
	0x33, 0xc7, 0x07, 0xb2, 0x03, 0xb0, 0x01, 0xe8,
	0xc0, 0x82, 0xe8, 0xea, 0x7f, 0xbb, 0xc7, 0x87,
	0xe8, 0x1a, 0x7a, 0xb9, 0x18, 0x00, 0xb0, 0x07,
	0xb4, 0x05, 0xe8, 0x48, 0x12, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0xb4, 0x03, 0xb9, 0xb3, 0x03, 0xe8,
	0x40, 0x83, 0xe8, 0xce, 0x13, 0xe8, 0xd6, 0x12,
	0xc7, 0x06, 0xaf, 0x64, 0xc6, 0x00, 0xc7, 0x06,
	0xb1, 0x64, 0xba, 0x00, 0xc6, 0x06, 0xcd, 0x64,
	0x00, 0xc6, 0x06, 0xdc, 0x64, 0x00, 0xc6, 0x06,
	0xcb, 0x64, 0x01, 0xe8, 0x93, 0xa6, 0xc7, 0x06,
	0xf3, 0xb4, 0x28, 0x00, 0xe8, 0x26, 0x15, 0xe8,
	0xe5, 0x7e, 0xbb, 0x90, 0x88, 0xe8, 0xcd, 0x79,
	0xe8, 0x0a, 0x7f, 0xbb, 0x2f, 0x8a, 0xe8, 0xc4,
	0x79, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0x9b, 0x03,
	0xb0, 0x01, 0xe8, 0x55, 0x82, 0xe8, 0xc7, 0x7e,
	0xbb, 0xa7, 0x8a, 0xe8, 0xaf, 0x79, 0xbe, 0xed,
	0x00, 0xbf, 0xba, 0x00, 0xe8, 0x0c, 0x9e, 0xbe,
	0xed, 0x00, 0xbf, 0xb1, 0x00, 0xe8, 0x03, 0x9e,
	0xbe, 0xc0, 0x00, 0xbf, 0xb1, 0x00, 0xe8, 0xfa,
	0x9d, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xb5, 0x03,
	0xb0, 0x01, 0xe8, 0x25, 0x82, 0xc6, 0x06, 0x45,
	0x33, 0xe7, 0xb0, 0x01, 0xbe, 0xb6, 0x03, 0xbb,
	0xf6, 0x8a, 0xe8, 0xaa, 0x7d, 0xb9, 0x20, 0x00,
	0xb0, 0x05, 0xb4, 0x09, 0xe8, 0xa6, 0x11, 0xb9,
	0x28, 0x00, 0xb0, 0x0e, 0xe8, 0xa7, 0x11, 0xbb,
	0x47, 0x33, 0xc7, 0x07, 0xb7, 0x03, 0xb9, 0xb8,
	0x03, 0xe8, 0x96, 0x82, 0xe8, 0x24, 0x13, 0xb9,
	0x0b, 0x00, 0xe8, 0xd6, 0x18, 0xe8, 0x44, 0x69,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0xb9, 0x03, 0xc7,
	0x06, 0xf3, 0xb4, 0x27, 0x00, 0xe8, 0x84, 0x14,
	0xc6, 0x06, 0x45, 0x33, 0xe3, 0xb0, 0x01, 0xbe,
	0xb9, 0x03, 0xbb, 0x4d, 0x8b, 0xe8, 0x5f, 0x7d,
	0xb9, 0x05, 0x00, 0xb0, 0x0f, 0xb4, 0x08, 0xe8,
	0x5b, 0x11, 0xbb, 0x47, 0x33, 0xc7, 0x07, 0xba,
	0x03, 0xb0, 0x01, 0xe8, 0xb4, 0x81, 0xb0, 0x01,
	0xbe, 0xbb, 0x03, 0xbb, 0x7a, 0x8b, 0xe8, 0x3e,
	0x7d, 0x8b, 0x16, 0xb3, 0x32, 0xbe, 0x00, 0xfa,
	0xb0, 0xfe, 0xe8, 0x5d, 0x0e, 0xff, 0x36, 0xa8,
	0x64, 0xc6, 0x06, 0xa8, 0x64, 0x00, 0xb8, 0x64,
	0x00, 0xe8, 0x88, 0x86, 0xe8, 0x62, 0x69, 0x8f,
	0x06, 0xa8, 0x64, 0xb9, 0x02, 0x00, 0xe8, 0x6a,
	0x18, 0xbb, 0x7c, 0xe4, 0xe8, 0xf7, 0x6c, 0x2e,
	0x80, 0x3e, 0xd7, 0x00, 0x80, 0x73, 0xf8, 0x2e,
	0x80, 0x3e, 0xd7, 0x00, 0x00, 0x74, 0xf0, 0xe9,
	0xad, 0x68, 0xb0, 0x03, 0xe8, 0x49, 0x8e, 0xb0,
	0x04, 0xe8, 0x34, 0x8e, 0xb0, 0x23, 0xe8, 0x2f,
	0x8e, 0xbb, 0x68, 0x34, 0xe8, 0x46, 0x07, 0xc3,
	0xb0, 0x04, 0xe8, 0x33, 0x8e, 0xb0, 0x05, 0xe8,
	0x1e, 0x8e, 0xbb, 0x90, 0x34, 0xe8, 0x35, 0x07,
	0xc3, 0xa1, 0xf3, 0xb4, 0x3d, 0x0f, 0x00, 0x74,
	0x0f, 0xbb, 0xce, 0x38, 0x3d, 0x10, 0x00, 0x74,
	0x03, 0xbb, 0xa7, 0x38, 0xe8, 0x1e, 0x07, 0xc3,
	0xbe, 0x9c, 0x00, 0xbf, 0xb4, 0x00, 0xc6, 0x06,
	0xc3, 0x64, 0x03, 0xe8, 0xe5, 0x9c, 0xb9, 0x05,
	0x00, 0xb0, 0x03, 0xb4, 0x07, 0xe8, 0xad, 0x10,
	0xb9, 0x26, 0x00, 0xb0, 0x10, 0xe8, 0xae, 0x10,
	0xb0, 0x16, 0xe8, 0xb0, 0x10, 0xb9, 0x66, 0x02,
	0xe8, 0x8c, 0x81, 0xb9, 0x05, 0x00, 0xb0, 0x03,
	0xb4, 0x07, 0xe8, 0x90, 0x10, 0xb9, 0x2c, 0x00,
	0xb0, 0x0a, 0xe8, 0x91, 0x10, 0xb9, 0x14, 0x00,
	0xb0, 0x1a, 0xe8, 0x90, 0x10, 0xb9, 0x67, 0x02,
	0xe8, 0x6f, 0x81, 0xe8, 0x0d, 0x12, 0xc7, 0x06,
	0xf3, 0xb4, 0x11, 0x00, 0xc6, 0x06, 0xdc, 0x1c,
	0x01, 0xe8, 0x93, 0x12, 0xb9, 0x40, 0x00, 0xb4,
	0x07, 0xb0, 0x01, 0xe8, 0x5f, 0x10, 0xb0, 0x15,
	0xe8, 0x63, 0x10, 0xb0, 0x2a, 0xe8, 0x65, 0x10,
	0xb0, 0x3f, 0xe8, 0x67, 0x10, 0xb9, 0x69, 0x02,
	0xc6, 0x06, 0xdc, 0x1c, 0x01, 0xc7, 0x06, 0x1f,
	0xc4, 0x00, 0x00, 0xe8, 0x87, 0x10, 0xe8, 0x9b,
	0x10, 0xe8, 0x0f, 0x10, 0xc7, 0x06, 0x23, 0xc4,
	0x05, 0x00, 0xc7, 0x06, 0x3b, 0x33, 0x00, 0x00,
	0xc7, 0x06, 0x3d, 0x33, 0x14, 0x00, 0xc6, 0x06,
	0xce, 0x00, 0x02, 0xe8, 0xe7, 0x82, 0x73, 0x3d,
	0xb9, 0x40, 0x00, 0xb4, 0x07, 0xb0, 0x01, 0xe8,
	0x13, 0x10, 0xb9, 0x6a, 0x02, 0xe8, 0x02, 0x81,
	0xb0, 0x05, 0xe8, 0xf0, 0x7f, 0xe8, 0xf0, 0xa5,
	0xc6, 0x07, 0x00, 0xe8, 0x32, 0x14, 0xb9, 0x1f,
	0x00, 0xb0, 0x01, 0xb4, 0x07, 0xe8, 0xf5, 0x0f,
	0xb9, 0x6b, 0x02, 0xe8, 0xe4, 0x80, 0xe8, 0x69,
	0x00, 0xb0, 0x2a, 0xe8, 0x22, 0x8d, 0xbb, 0x89,
	0x39, 0xe8, 0x39, 0x06, 0xc3, 0x51, 0xe8, 0x59,
	0x00, 0x59, 0x80, 0x3e, 0xcf, 0x00, 0x00, 0x74,
	0x20, 0x80, 0x3e, 0xcf, 0x00, 0x04, 0x74, 0x0d,
	0xbb, 0x32, 0x39, 0x83, 0xf9, 0x05, 0x74, 0x08,
	0xbb, 0xff, 0x38, 0xeb, 0x03, 0xbb, 0xdb, 0x38,
	0xc6, 0x06, 0xcf, 0x00, 0x00, 0xe8, 0x0d, 0x06,
	0xc3, 0xfe, 0x06, 0xa6, 0xdb, 0xa0, 0xa6, 0xdb,
	0xbb, 0xae, 0x39, 0x3c, 0x01, 0x74, 0x1f, 0xbb,
	0xf6, 0x39, 0x3c, 0x02, 0x74, 0x18, 0xbb, 0x28,
	0x3a, 0x3c, 0x03, 0x74, 0x11, 0xbb, 0x5a, 0x3a,
	0x3c, 0x04, 0x74, 0x0a, 0xbb, 0x85, 0x3a, 0x3c,
	0x05, 0x74, 0x03, 0xbb, 0xb7, 0x3a, 0xe8, 0xdc,
	0x05, 0xc3, 0xe8, 0x16, 0x11, 0xc7, 0x06, 0xf3,
	0xb4, 0x0f, 0x00, 0xe8, 0x86, 0x12, 0xc7, 0x06,
	0xaf, 0x64, 0x9c, 0x00, 0xc7, 0x06, 0xb1, 0x64,
	0xb4, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x03, 0xc6,
	0x06, 0xcb, 0x64, 0x01, 0xc6, 0x06, 0xcd, 0x64,
	0x01, 0xb9, 0x05, 0x00, 0xb0, 0x05, 0xb4, 0x07,
	0xe8, 0x52, 0x0f, 0xb9, 0x26, 0x00, 0xb0, 0x0e,
	0xe8, 0x53, 0x0f, 0xb9, 0x26, 0x00, 0xb0, 0x14,
	0xe8, 0x52, 0x0f, 0xb9, 0x05, 0x00, 0xb0, 0x19,
	0xe8, 0x51, 0x0f, 0xb9, 0x68, 0x02, 0xe8, 0x47,
	0x80, 0xc3, 0xa1, 0xf3, 0xb4, 0x3d, 0x0d, 0x00,
	0x74, 0x07, 0xbb, 0x58, 0x3c, 0xe8, 0x7d, 0x05,
	0xc3, 0xe8, 0x7b, 0x80, 0xbe, 0xac, 0x00, 0xbf,
	0xb5, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x01, 0xe8,
	0x41, 0x9b, 0xb9, 0x1a, 0x00, 0xb0, 0x13, 0xb4,
	0x07, 0xe8, 0x09, 0x0f, 0xb0, 0x1e, 0xe8, 0x14,
	0x0f, 0xb0, 0x29, 0xe8, 0x1d, 0x0f, 0xb0, 0x34,
	0xe8, 0x26, 0x0f, 0xb0, 0x3f, 0xe8, 0x2f, 0x0f,
	0xb9, 0x38, 0x00, 0xb0, 0x17, 0xe8, 0xf6, 0x0e,
	0xb0, 0x22, 0xe8, 0xff, 0x0e, 0xb0, 0x2d, 0xe8,
	0x08, 0x0f, 0xb0, 0x38, 0xe8, 0x11, 0x0f, 0xb9,
	0x95, 0x02, 0xe8, 0xcd, 0x7f, 0xbe, 0x14, 0x77,
	0xbb, 0x80, 0x3c, 0xc6, 0x06, 0xdc, 0x1c, 0x01,
	0xe8, 0xe2, 0x00, 0xb9, 0x38, 0x00, 0xb0, 0x0a,
	0xb4, 0x07, 0xe8, 0xc0, 0x0e, 0xb0, 0x15, 0xe8,
	0xc4, 0x0e, 0xb9, 0x08, 0x00, 0xb0, 0x30, 0xe8,
	0xc3, 0x0e, 0xb9, 0x38, 0x00, 0xb0, 0x75, 0xe8,
	0xc2, 0x0e, 0xb0, 0x80, 0xe8, 0xc4, 0x0e, 0xb0,
	0x8b, 0xe8, 0xc6, 0x0e, 0xb0, 0x96, 0xe8, 0xc8,
	0x0e, 0xb0, 0xa1, 0xe8, 0xca, 0x0e, 0xb0, 0xac,
	0xe8, 0xcc, 0x0e, 0xb0, 0xb7, 0xe8, 0xce, 0x0e,
	0x83, 0x2e, 0xb1, 0x64, 0x14, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0x97, 0x02, 0xb9, 0x96, 0x02,
	0xe8, 0x6f, 0x7f, 0xe8, 0x18, 0x0f, 0xe8, 0x5f,
	0xa4, 0xc6, 0x47, 0x01, 0x31, 0xe8, 0xa0, 0x12,
	0xbe, 0xf5, 0x76, 0xbb, 0x9a, 0x3c, 0xc6, 0x06,
	0xdc, 0x1c, 0x01, 0xe8, 0x77, 0x00, 0xc7, 0x06,
	0xaf, 0x64, 0xa2, 0x00, 0xc7, 0x06, 0xb1, 0x64,
	0xb8, 0x00, 0xb9, 0x1a, 0x00, 0xb0, 0x06, 0xb4,
	0x07, 0xe8, 0x49, 0x0e, 0xb0, 0x11, 0xe8, 0x54,
	0x0e, 0xb9, 0x38, 0x00, 0xb0, 0x0a, 0xe8, 0x45,
	0x0e, 0xb0, 0x15, 0xe8, 0x4e, 0x0e, 0xb9, 0x13,
	0x00, 0xb0, 0x1b, 0xe8, 0x4d, 0x0e, 0xb9, 0x18,
	0x00, 0xb0, 0x26, 0xe8, 0x4c, 0x0e, 0xb9, 0x17,
	0x00, 0xb0, 0x2c, 0xe8, 0x4b, 0x0e, 0xb9, 0x98,
	0x02, 0xe8, 0x0e, 0x7f, 0xe8, 0xac, 0x0f, 0xbb,
	0x47, 0x33, 0xc7, 0x47, 0x02, 0x99, 0x02, 0xb0,
	0x02, 0xe8, 0x2c, 0x7e, 0xe8, 0x5e, 0x83, 0xbb,
	0xbc, 0x3c, 0xe8, 0x58, 0x04, 0xe8, 0x55, 0x83,
	0xe8, 0x29, 0x7f, 0xe8, 0x4f, 0x83, 0xbb, 0xea,
	0x3c, 0xe8, 0x49, 0x04, 0xb0, 0x25, 0xe8, 0x37,
	0x8b, 0xe8, 0x31, 0x01, 0xc3, 0x06, 0x53, 0x56,
	0xb8, 0x00, 0xa0, 0x8e, 0xc0, 0xe8, 0x25, 0x00,
	0xb8, 0x00, 0xa0, 0xb9, 0x00, 0x7d, 0xe8, 0xd7,
	0x10, 0x5e, 0x5b, 0xe8, 0x27, 0x08, 0xe8, 0x23,
	0x00, 0xb8, 0x96, 0x00, 0xe8, 0x25, 0x83, 0xe8,
	0x0b, 0x00, 0xe8, 0x2a, 0x91, 0xe8, 0x80, 0x0c,
	0xe8, 0x11, 0x00, 0x07, 0xc3, 0x80, 0x3e, 0xad,
	0x64, 0x01, 0x75, 0x04, 0xe8, 0x7d, 0x10, 0xc3,
	0xe8, 0x93, 0x10, 0xc3, 0x80, 0x3e, 0xad, 0x64,
	0x01, 0x75, 0x04, 0xe8, 0x7b, 0x10, 0xc3, 0xe8,
	0x91, 0x10, 0xe8, 0x5c, 0x10, 0xc3, 0xbb, 0x84,
	0x49, 0xe8, 0xe9, 0x03, 0xc3, 0xbb, 0xd1, 0x49,
	0xe8, 0xe2, 0x03, 0xc6, 0x06, 0xb5, 0xdb, 0x01,
	0xc3, 0x83, 0x3e, 0xf3, 0xb4, 0x24, 0x74, 0x07,
	0xbb, 0xa9, 0x52, 0xe8, 0xcf, 0x03, 0xc3, 0x80,
	0x3e, 0xf1, 0xdb, 0x01, 0x75, 0x07, 0xbb, 0xf6,
	0x52, 0xe8, 0xc1, 0x03, 0xc3, 0xc6, 0x06, 0xf1,
	0xdb, 0x01, 0xe8, 0xba, 0x7e, 0xbe, 0x66, 0x00,
	0xbf, 0xc3, 0x00, 0xc6, 0x06, 0xc3, 0x64, 0x02,
	0xe8, 0x80, 0x99, 0xb9, 0x05, 0x00, 0xb0, 0x03,
	0xb4, 0x05, 0xe8, 0x48, 0x0d, 0xb9, 0x4b, 0x00,
	0xb0, 0x0c, 0xe8, 0x49, 0x0d, 0xb9, 0x1a, 0x03,
	0xe8, 0x54, 0x7e, 0xb8, 0x01, 0x00, 0xe8, 0xc7,
	0x91, 0x53, 0xe8, 0x88, 0x82, 0xbb, 0x46, 0x67,
	0xe8, 0x07, 0xa3, 0x83, 0xc3, 0x03, 0xc7, 0x07,
	0x00, 0x00, 0xc7, 0x47, 0x04, 0x00, 0x00, 0x53,
	0xbe, 0x97, 0x00, 0xbf, 0xc5, 0x00, 0xc6, 0x06,
	0xc3, 0x64, 0x02, 0xe8, 0x3d, 0x99, 0xb9, 0x1b,
	0x03, 0xe8, 0xfe, 0x7d, 0xc7, 0x06, 0xaf, 0x64,
	0xba, 0x00, 0xff, 0x06, 0xb1, 0x64, 0xe8, 0x2b,
	0x7e, 0xbe, 0xdc, 0x00, 0xbf, 0xc6, 0x00, 0xc6,
	0x06, 0xc3, 0x64, 0x04, 0xe8, 0x1c, 0x99, 0x5b,
	0xc7, 0x47, 0x04, 0xc8, 0x00, 0x5b, 0xc7, 0x07,
	0x01, 0x00, 0xb0, 0x02, 0xe8, 0xc6, 0x7c, 0xbb,
	0xa9, 0x58, 0xe8, 0xa0, 0x74, 0xb0, 0x01, 0xb4,
	0x02, 0xb9, 0x0e, 0x01, 0xba, 0xc1, 0x00, 0xe8,
	0xd3, 0x7c, 0xb0, 0x03, 0xb4, 0x01, 0xb9, 0xfe,
	0x00, 0xba, 0xc1, 0x00, 0xe8, 0xc6, 0x7c, 0xc6,
	0x06, 0xd7, 0xdb, 0x01, 0xc3, 0xe8, 0x06, 0x82,
	0xff, 0x06, 0xea, 0xdb, 0xa1, 0xea, 0xdb, 0x3d,
	0x07, 0x00, 0x73, 0x3b, 0x2d, 0x02, 0x00, 0xbb,
	0x35, 0x60, 0xd1, 0xe0, 0x03, 0xd8, 0xff, 0x36,
	0xf3, 0xb4, 0x53, 0xb9, 0x0b, 0x00, 0xe8, 0xe2,
	0x13, 0xe8, 0x85, 0x02, 0x5b, 0xff, 0x17, 0xc6,
	0x06, 0xdc, 0x1c, 0x02, 0x8f, 0x06, 0xf3, 0xb4,
	0xb9, 0x06, 0x00, 0xe8, 0xcd, 0x13, 0x83, 0x3e,
	0xf3, 0xb4, 0x0b, 0x75, 0x07, 0x83, 0x3e, 0xec,
	0xdb, 0x01, 0x74, 0x03, 0xe8, 0x98, 0x0e, 0xc3,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0xda, 0x03, 0xc7,
	0x47, 0x02, 0xdb, 0x03, 0xc7, 0x06, 0xf3, 0xb4,
	0x22, 0x00, 0xe8, 0x67, 0x0f, 0xbb, 0x47, 0x33,
	0xc7, 0x07, 0xda, 0x03, 0xc7, 0x47, 0x02, 0xdb,
	0x03, 0xb0, 0x01, 0xe8, 0xac, 0x7c, 0xc6, 0x06,
	0x45, 0x33, 0xd9, 0xc6, 0x06, 0x46, 0x33, 0xd0,
	0xb0, 0x01, 0xb4, 0x02, 0xbe, 0xdc, 0x03, 0xbf,
	0xdd, 0x03, 0xbb, 0x60, 0x6f, 0xe8, 0x9e, 0x76,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0xde, 0x03, 0xc7,
	0x47, 0x02, 0xdf, 0x03, 0xb0, 0x01, 0xe8, 0x81,
	0x7c, 0xe8, 0xba, 0x0c, 0xc3, 0xbb, 0x47, 0x33,
	0xc7, 0x47, 0x02, 0x77, 0x03, 0xc7, 0x47, 0x04,
	0x78, 0x03, 0xc7, 0x06, 0xf3, 0xb4, 0x1e, 0x00,
	0xe8, 0x11, 0x0f, 0xbb, 0x47, 0x33, 0xc7, 0x47,
	0x02, 0x77, 0x03, 0xc7, 0x47, 0x04, 0x78, 0x03,
	0xb0, 0x02, 0xe8, 0x55, 0x7c, 0xc6, 0x06, 0x45,
	0x33, 0xd9, 0xb0, 0x02, 0xbe, 0x79, 0x03, 0xbb,
	0xb8, 0x6f, 0xe8, 0xda, 0x77, 0xb9, 0x1a, 0x00,
	0xb0, 0x03, 0xb4, 0x0a, 0xe8, 0xd6, 0x0b, 0xbb,
	0x47, 0x33, 0xc7, 0x47, 0x02, 0x7b, 0x03, 0xc7,
	0x47, 0x04, 0x7c, 0x03, 0xb0, 0x03, 0xe8, 0x29,
	0x7c, 0xc6, 0x06, 0x45, 0x33, 0xd0, 0xc6, 0x06,
	0x46, 0x33, 0xd9, 0xb0, 0x03, 0xb4, 0x02, 0xbe,
	0x7a, 0x03, 0xbf, 0x79, 0x03, 0xbb, 0xf0, 0x6f,
	0xe8, 0x1b, 0x76, 0xc3, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x02, 0x7e, 0x03, 0xc7, 0x47, 0x04, 0x7d,
	0x03, 0xc7, 0x06, 0xf3, 0xb4, 0x20, 0x00, 0xe8,
	0xa2, 0x0e, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0x7e, 0x03, 0xc7, 0x47, 0x04, 0x7d, 0x03, 0xb0,
	0x02, 0xe8, 0xe6, 0x7b, 0xc6, 0x06, 0x45, 0x33,
	0xd9, 0xb0, 0x03, 0xbe, 0x7f, 0x03, 0xbb, 0x6e,
	0x70, 0xe8, 0x6b, 0x77, 0xb9, 0x4b, 0x00, 0xb0,
	0x09, 0xb4, 0x0b, 0xe8, 0x67, 0x0b, 0xbb, 0x47,
	0x33, 0xc7, 0x47, 0x02, 0x82, 0x03, 0xc7, 0x47,
	0x04, 0x81, 0x03, 0xb0, 0x02, 0xe8, 0xba, 0x7b,
	0xc6, 0x06, 0x45, 0x33, 0xd0, 0xc6, 0x06, 0x46,
	0x33, 0xd9, 0xb0, 0x02, 0xb4, 0x03, 0xbe, 0x80,
	0x03, 0xbf, 0x7f, 0x03, 0xbb, 0x96, 0x70, 0xe8,
	0xac, 0x75, 0xc3, 0xbb, 0x47, 0x33, 0xc7, 0x07,
	0x85, 0x03, 0xc7, 0x47, 0x02, 0x84, 0x03, 0xc7,
	0x06, 0xf3, 0xb4, 0x1d, 0x00, 0xe8, 0x34, 0x0e,
	0xbb, 0x47, 0x33, 0xc7, 0x07, 0x85, 0x03, 0xc7,
	0x47, 0x02, 0x84, 0x03, 0xb0, 0x02, 0xe8, 0x79,
	0x7b, 0xc6, 0x06, 0x45, 0x33, 0xd0, 0xc6, 0x06,
	0x46, 0x33, 0xd9, 0xb0, 0x01, 0xb4, 0x02, 0xbe,
	0x87, 0x03, 0xbf, 0x86, 0x03, 0xbb, 0x61, 0x71,
	0xe8, 0x6b, 0x75, 0xb9, 0x38, 0x00, 0xb0, 0x03,
	0xb4, 0x04, 0xe8, 0xf0, 0x0a, 0xb0, 0x05, 0xe8,
	0xf4, 0x0a, 0xb0, 0x07, 0xe8, 0xf6, 0x0a, 0xb0,
	0x09, 0xe8, 0xf8, 0x0a, 0xbb, 0x47, 0x33, 0xc7,
	0x07, 0x89, 0x03, 0xc7, 0x47, 0x02, 0x88, 0x03,
	0xb0, 0x01, 0xe8, 0x35, 0x7b, 0xb0, 0x01, 0xb4,
	0x02, 0xbe, 0x87, 0x03, 0xbf, 0x86, 0x03, 0xbb,
	0xc6, 0x71, 0xe8, 0x31, 0x75, 0xc3, 0xff, 0x36,
	0xf3, 0xb4, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02,
	0x8b, 0x03, 0xc7, 0x47, 0x04, 0x8a, 0x03, 0xc7,
	0x06, 0xf3, 0xb4, 0x23, 0x00, 0xe8, 0xb4, 0x0d,
	0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0x8b, 0x03,
	0xc7, 0x47, 0x04, 0x8a, 0x03, 0xb0, 0x03, 0xe8,
	0xf8, 0x7a, 0xc6, 0x06, 0x45, 0x33, 0xd9, 0xc6,
	0x06, 0x46, 0x33, 0xd0, 0xb0, 0x03, 0xb4, 0x02,
	0xbe, 0x8c, 0x03, 0xbf, 0x8d, 0x03, 0xbb, 0x43,
	0x72, 0xe8, 0xea, 0x74, 0xc6, 0x06, 0x46, 0x33,
	0xd9, 0xc6, 0x06, 0x45, 0x33, 0xd0, 0xb0, 0x02,
	0xb4, 0x03, 0xbe, 0x8e, 0x03, 0xbf, 0x8c, 0x03,
	0xbb, 0x18, 0x73, 0xe8, 0xd0, 0x74, 0xc7, 0x06,
	0xf3, 0xb4, 0x0b, 0x00, 0xe8, 0x41, 0xa0, 0xc6,
	0x47, 0x03, 0x33, 0xe8, 0x5e, 0x0d, 0x58, 0x3d,
	0x0b, 0x00, 0x75, 0x08, 0xc6, 0x06, 0xdc, 0x1c,
	0x02, 0xe8, 0xba, 0x88, 0xbb, 0x47, 0x33, 0xc7,
	0x47, 0x02, 0x8f, 0x03, 0xb0, 0x02, 0xe8, 0x99,
	0x7a, 0xbb, 0x47, 0x33, 0xc7, 0x47, 0x02, 0x83,
	0x03, 0xb0, 0x02, 0xe8, 0x51, 0x7a, 0xe8, 0x13,
	0x0b, 0xb8, 0xc8, 0x00, 0xe8, 0x5b, 0x7f, 0xb0,
	0x08, 0xe8, 0xf5, 0x79, 0xb8, 0x02, 0x08, 0xe8,
	0x8f, 0x8e, 0xc7, 0x06, 0xec, 0xdb, 0x01, 0x00,
	0xc3, 0x06, 0xb8, 0x00, 0xa0, 0x8e, 0xc0, 0xe8,
	0x1d, 0x00, 0xb8, 0x00, 0xa0, 0xb9, 0x00, 0x7d,
	0xe8, 0xfd, 0x0c, 0xbe, 0x14, 0x77, 0xbb, 0x0a,
	0x58, 0xe8, 0x49, 0x04, 0xe8, 0x17, 0x00, 0xb8,
	0x96, 0x00, 0xe8, 0x47, 0x7f, 0x07, 0xc3, 0x80,
	0x3e, 0xad, 0x64, 0x01, 0x75, 0x04, 0xe8, 0xab,
	0x0c, 0xc3, 0xe8, 0xc1, 0x0c, 0xc3, 0x80, 0x3e,
	0xad, 0x64, 0x01, 0x75, 0x04, 0xe8, 0xa9, 0x0c,
	0xc3, 0xe8, 0xbf, 0x0c, 0xe8, 0x8a, 0x0c, 0xc3,
	0xa1, 0x50, 0x72, 0xe8, 0x07, 0x04, 0x83, 0xc3,
	0x13, 0x8a, 0x07, 0x43, 0x0a, 0xc0, 0x75, 0xf9,
	0x80, 0x3f, 0x00, 0x74, 0xf4, 0x80, 0x3f, 0x01,
	0x75, 0x03, 0xbb, 0x50, 0x34, 0xe8, 0x04, 0x00,
	0xe8, 0xb4, 0x00, 0xc3, 0x06, 0xb8, 0xd4, 0x19,
	0x8e, 0xc0, 0xe8, 0xe0, 0x02, 0x8b, 0x0e, 0xaf,
	0x64, 0x8b, 0xd0, 0x52, 0xd1, 0xea, 0x2b, 0xca,
	0x73, 0x03, 0xb9, 0x02, 0x00, 0x26, 0x89, 0x0e,
	0x00, 0x00, 0x5a, 0x03, 0xca, 0x81, 0xf9, 0x3f,
	0x01, 0x76, 0x0d, 0xb9, 0x3f, 0x01, 0x2b, 0xca,
	0x83, 0xe9, 0x02, 0x26, 0x89, 0x0e, 0x00, 0x00,
	0x83, 0xee, 0x02, 0x81, 0xfe, 0x04, 0x00, 0x72,
	0x0e, 0x26, 0x8b, 0x14, 0x8b, 0xc8, 0x2b, 0xca,
	0xd1, 0xe9, 0x26, 0x89, 0x0c, 0xeb, 0xe9, 0xc6,
	0x06, 0xe6, 0x1c, 0xd1, 0xe8, 0x77, 0x02, 0xb8,
	0x3e, 0x00, 0x8b, 0xc8, 0xf7, 0x26, 0xd8, 0x64,
	0xf7, 0x36, 0xda, 0x64, 0x2b, 0xc8, 0xa1, 0xb1,
	0x64, 0x2b, 0xc1, 0x72, 0x12, 0x05, 0x08, 0x00,
	0x26, 0x8b, 0x0e, 0x0a, 0x00, 0x41, 0x2d, 0x0b,
	0x00, 0x72, 0x04, 0xe2, 0xf9, 0xeb, 0x03, 0xb8,
	0x01, 0x00, 0xf7, 0x26, 0xb6, 0x00, 0x26, 0x01,
	0x06, 0x00, 0x00, 0xc6, 0x06, 0xdb, 0x1c, 0x02,
	0xe8, 0x8b, 0x87, 0xc6, 0x06, 0xdb, 0x1c, 0x03,
	0xbb, 0x92, 0x32, 0xa1, 0x96, 0x32, 0x26, 0x8b,
	0x0e, 0x0c, 0x00, 0xf7, 0xe1, 0x8b, 0xc8, 0xc1,
	0xe9, 0x03, 0x83, 0xc1, 0x3c, 0xe8, 0xdb, 0x07,
	0x07, 0xc6, 0x06, 0xe8, 0x64, 0x01, 0xc3, 0xe8,
	0xf4, 0x94, 0xe8, 0x70, 0x8a, 0x2e, 0x80, 0x3e,
	0xd7, 0x00, 0x01, 0x74, 0x19, 0x80, 0x3e, 0x96,
	0x32, 0x00, 0x74, 0x08, 0xbb, 0x92, 0x32, 0xe8,
	0xcc, 0x07, 0x72, 0x0a, 0xe8, 0xa4, 0x05, 0x72,
	0x05, 0xe8, 0x70, 0x05, 0x73, 0xd9, 0xe8, 0xfc,
	0x9c, 0xe8, 0x3d, 0x9d, 0xc6, 0x06, 0xdb, 0x1c,
	0x01, 0xc6, 0x06, 0xdc, 0x1c, 0x02, 0xe8, 0x2d,
	0x87, 0xc6, 0x06, 0xdc, 0x1c, 0x03, 0xc6, 0x06,
	0xdb, 0x1c, 0x00, 0xc3, 0x51, 0xe8, 0x04, 0xff,
	0x59, 0xbb, 0x92, 0x32, 0xe8, 0x84, 0x07, 0xe8,
	0xa4, 0x94, 0xe8, 0x20, 0x8a, 0xbb, 0x92, 0x32,
	0xe8, 0x8b, 0x07, 0x72, 0x0a, 0xe8, 0x63, 0x05,
	0x72, 0x05, 0xe8, 0x2f, 0x05, 0x73, 0xe8, 0xe8,
	0xbc, 0xff, 0xc3, 0xa0, 0x96, 0xda, 0xbf, 0xc7,
	0x32, 0xb1, 0x1b, 0x48, 0xf6, 0xe1, 0x03, 0xf8,
	0xa1, 0xa4, 0xda, 0x89, 0x05, 0x57, 0xe8, 0xcb,
	0xfe, 0x5f, 0x57, 0xa1, 0xa4, 0xda, 0x89, 0x05,
	0xe8, 0x6b, 0x94, 0xe8, 0xe7, 0x89, 0x5f, 0x57,
	0xa1, 0xa4, 0xda, 0x89, 0x05, 0x2e, 0x80, 0x3e,
	0xd7, 0x00, 0x01, 0x74, 0x19, 0x80, 0x3e, 0x96,
	0x32, 0x00, 0x74, 0x08, 0xbb, 0x92, 0x32, 0xe8,
	0x3c, 0x07, 0x72, 0x0a, 0xe8, 0x14, 0x05, 0x72,
	0x05, 0xe8, 0xe0, 0x04, 0x73, 0xcb, 0x5f, 0xe8,
	0x6c, 0xff, 0xc3, 0x06, 0xb8, 0xd4, 0x19, 0x8e,
	0xc0, 0x57, 0xe8, 0x70, 0x01, 0x5f, 0x50, 0x8b,
	0x45, 0x0a, 0x33, 0xd2, 0xf7, 0x36, 0xb6, 0x00,
	0x8b, 0x45, 0x0c, 0xd1, 0xe8, 0x03, 0xd0, 0x58,
	0x8b, 0xca, 0x8b, 0xd0, 0x52, 0xd1, 0xea, 0x2b,
	0xca, 0x73, 0x03, 0xb9, 0x02, 0x00, 0x26, 0x89,
	0x0e, 0x00, 0x00, 0x5a, 0x03, 0xca, 0x81, 0xf9,
	0x3f, 0x01, 0x76, 0x0b, 0xb9, 0x3f, 0x01, 0x2b,
	0xca, 0x49, 0x26, 0x89, 0x0e, 0x00, 0x00, 0x83,
	0xee, 0x02, 0x81, 0xfe, 0x04, 0x00, 0x72, 0x0e,
	0x26, 0x8b, 0x14, 0x8b, 0xc8, 0x2b, 0xca, 0xd1,
	0xe9, 0x26, 0x89, 0x0c, 0xeb, 0xe9, 0x57, 0xa0,
	0xe7, 0x1c, 0xa2, 0xe6, 0x1c, 0xe8, 0xf6, 0x00,
	0x5f, 0x8b, 0x45, 0x0a, 0x33, 0xd2, 0xf7, 0x36,
	0xb6, 0x00, 0x05, 0x08, 0x00, 0x26, 0x8b, 0x0e,
	0x0a, 0x00, 0x41, 0x2d, 0x0b, 0x00, 0x72, 0x04,
	0xe2, 0xf9, 0xeb, 0x03, 0xb8, 0x01, 0x00, 0xb9,
	0x40, 0x01, 0xf7, 0xe1, 0x26, 0x01, 0x06, 0x00,
	0x00, 0xc6, 0x06, 0xdb, 0x1c, 0x02, 0xe8, 0x15,
	0x86, 0xc6, 0x06, 0xdb, 0x1c, 0x03, 0xbb, 0x92,
	0x32, 0xa1, 0x96, 0x32, 0x26, 0x8b, 0x0e, 0x0c,
	0x00, 0xf7, 0xe1, 0x8b, 0xc8, 0xc1, 0xe9, 0x03,
	0x83, 0xc1, 0x3c, 0xe8, 0x65, 0x06, 0x07, 0xc3,
	0x06, 0xb8, 0xd4, 0x19, 0x8e, 0xc0, 0x26, 0x89,
	0x36, 0x00, 0x00, 0xe8, 0xb7, 0x00, 0x83, 0xee,
	0x02, 0x81, 0xfe, 0x04, 0x00, 0x72, 0x0e, 0x26,
	0x8b, 0x14, 0x8b, 0xc8, 0x2b, 0xca, 0xd1, 0xe9,
	0x26, 0x89, 0x0c, 0xeb, 0xe9, 0xe8, 0x7e, 0x00,
	0xc6, 0x06, 0xdb, 0x1c, 0x02, 0xe8, 0xc6, 0x85,
	0xc6, 0x06, 0xdb, 0x1c, 0x03, 0xbb, 0x92, 0x32,
	0xa1, 0x96, 0x32, 0x26, 0x8b, 0x0e, 0x0c, 0x00,
	0xf7, 0xe1, 0x8b, 0xc8, 0xc1, 0xe9, 0x03, 0x83,
	0xc1, 0x3c, 0xe8, 0x16, 0x06, 0x07, 0xc3, 0x06,
	0xb8, 0xd4, 0x19, 0x8e, 0xc0, 0x26, 0x89, 0x36,
	0x00, 0x00, 0x53, 0xe8, 0x63, 0x88, 0x5b, 0xe8,
	0x75, 0x00, 0x83, 0xee, 0x02, 0x81, 0xfe, 0x04,
	0x00, 0x72, 0x0e, 0x26, 0x8b, 0x14, 0x8b, 0xc8,
	0x2b, 0xca, 0xd1, 0xe9, 0x26, 0x89, 0x0c, 0xeb,
	0xe9, 0xe8, 0x2a, 0x00, 0x07, 0xc3, 0xe8, 0x7f,
	0xff, 0xe8, 0x81, 0x88, 0x80, 0x3e, 0x96, 0x32,
	0x00, 0x74, 0x08, 0xbb, 0x92, 0x32, 0xe8, 0xe5,
	0x05, 0x72, 0x0a, 0xe8, 0x8e, 0x03, 0x72, 0x05,
	0xe8, 0xb8, 0x03, 0x73, 0xe4, 0xc6, 0x06, 0xdb,
	0x1c, 0x01, 0xe8, 0x51, 0x85, 0xc3, 0xbf, 0x04,
	0x00, 0xbe, 0x0e, 0x00, 0x57, 0x56, 0x26, 0x03,
	0x35, 0xe8, 0x21, 0x01, 0x5e, 0x5f, 0x81, 0xc6,
	0xc0, 0x0d, 0x83, 0xc7, 0x02, 0x43, 0x8a, 0x07,
	0x0a, 0xc0, 0x75, 0xe8, 0xc3, 0x53, 0xc6, 0x06,
	0xda, 0x1c, 0x01, 0xe8, 0x28, 0x85, 0xc6, 0x06,
	0xda, 0x1c, 0x00, 0xe8, 0xeb, 0x87, 0x5b, 0x33,
	0xc0, 0x26, 0xa3, 0x0c, 0x00, 0x26, 0xa3, 0x0a,
	0x00, 0xbe, 0x04, 0x00, 0x53, 0xe8, 0x40, 0x01,
	0x26, 0x01, 0x0e, 0x0c, 0x00, 0x26, 0x89, 0x04,
	0x26, 0xff, 0x06, 0x0a, 0x00, 0x83, 0xc6, 0x02,
	0x43, 0x8a, 0x07, 0x0a, 0xc0, 0x75, 0xe6, 0x5b,
	0x8b, 0xce, 0x33, 0xc0, 0x83, 0xee, 0x02, 0x81,
	0xfe, 0x04, 0x00, 0x72, 0x0b, 0x26, 0x8b, 0x14,
	0x3b, 0xc2, 0x73, 0xf0, 0x8b, 0xc2, 0xeb, 0xec,
	0x8b, 0xf1, 0xc3, 0x8b, 0x0e, 0xc0, 0x00, 0x8b,
	0x16, 0xc2, 0x00, 0xa1, 0x52, 0x72, 0xa3, 0x50,
	0x72, 0x0b, 0xc0, 0x74, 0x54, 0xc6, 0x06, 0x3d,
	0x66, 0x05, 0x83, 0x3e, 0x1f, 0xc4, 0x00, 0x74,
	0x12, 0xe8, 0x16, 0x7c, 0x80, 0x3e, 0xdb, 0xbb,
	0x01, 0x74, 0x4f, 0xa1, 0x50, 0x72, 0xe8, 0x7c,
	0x00, 0xeb, 0x18, 0xc6, 0x06, 0x3d, 0x66, 0x01,
	0x0a, 0xdb, 0x74, 0x05, 0xc6, 0x06, 0x3d, 0x66,
	0x03, 0xe8, 0x69, 0x00, 0x80, 0x3e, 0x3d, 0x66,
	0x01, 0x75, 0x08, 0x8b, 0x77, 0x09, 0x8b, 0x7f,
	0x0b, 0xeb, 0x06, 0x8b, 0x77, 0x0d, 0x8b, 0x7f,
	0x0f, 0x8a, 0x47, 0x11, 0xa2, 0xc3, 0x64, 0xe8,
	0x38, 0x00, 0xe8, 0xa9, 0x97, 0x72, 0x2e, 0xeb,
	0x11, 0xc6, 0x06, 0x3d, 0x66, 0x00, 0xc6, 0x06,
	0xc3, 0x64, 0x00, 0x8b, 0xf1, 0x8b, 0xfa, 0xe8,
	0x24, 0x97, 0xc6, 0x06, 0xc5, 0x64, 0x00, 0xc6,
	0x06, 0xc6, 0x64, 0x01, 0x89, 0x36, 0xb7, 0x64,
	0x89, 0x3e, 0xb9, 0x64, 0x89, 0x36, 0xbb, 0x64,
	0x89, 0x3e, 0xbd, 0x64, 0xc3, 0xb0, 0x36, 0xe9,
	0x36, 0x0f, 0x83, 0xfe, 0xff, 0x75, 0x0d, 0x83,
	0xff, 0xff, 0x75, 0x08, 0x8b, 0x3e, 0xb1, 0x64,
	0x8b, 0x36, 0xaf, 0x64, 0xc3, 0x48, 0xbb, 0x54,
	0x72, 0x50, 0xe8, 0x8d, 0x9b, 0x58, 0xd1, 0xe0,
	0x03, 0xd8, 0x8b, 0x1f, 0xc3, 0x8a, 0x0f, 0x0a,
	0xc9, 0x74, 0x4c, 0x80, 0xe9, 0x1f, 0xb5, 0x00,
	0xbf, 0x38, 0x01, 0xd1, 0xe1, 0x03, 0xf9, 0x8b,
	0x3d, 0x81, 0xc7, 0x3a, 0x01, 0x8b, 0x0d, 0x83,
	0xc7, 0x02, 0x8a, 0x26, 0xe6, 0x1c, 0x51, 0x56,
	0x51, 0x56, 0x8a, 0x05, 0x0a, 0xc0, 0x74, 0x0b,
	0xfe, 0xc8, 0x0a, 0xc0, 0x74, 0x02, 0x8a, 0xc4,
	0x26, 0x88, 0x04, 0x47, 0x46, 0xfe, 0xcd, 0x75,
	0xe9, 0x5e, 0x59, 0x81, 0xc6, 0x40, 0x01, 0xfe,
	0xc9, 0x75, 0xdd, 0x5e, 0x59, 0x8a, 0xc5, 0xb4,
	0x00, 0x03, 0xf0, 0x4e, 0x43, 0xeb, 0xae, 0xc3,
	0x52, 0x33, 0xc0, 0x8b, 0xd0, 0x8a, 0x0f, 0x0a,
	0xc9, 0x74, 0x1f, 0x42, 0x80, 0xe9, 0x1f, 0xb5,
	0x00, 0xbf, 0x38, 0x01, 0xd1, 0xe1, 0x03, 0xf9,
	0x8b, 0x3d, 0x81, 0xc7, 0x3a, 0x01, 0x8b, 0x0d,
	0x8a, 0xcd, 0xb5, 0x00, 0x03, 0xc1, 0x48, 0x43,
	0xeb, 0xdb, 0x8b, 0xca, 0x5a, 0xc3, 0xb8, 0x04,
	0x00, 0xe8, 0x87, 0x0c, 0xbb, 0x9e, 0x33, 0xd1,
	0xe0, 0x03, 0xd8, 0x8b, 0x1f, 0xe8, 0x6d, 0xfb,
	0xc3, 0x33, 0xc0, 0xcd, 0x33, 0x0b, 0xc0, 0x74,
	0x01, 0xc3, 0xc6, 0x06, 0xd9, 0x00, 0x01, 0xba,
	0x5f, 0x33, 0xb4, 0x09, 0xcd, 0x21, 0xb4, 0x08,
	0xcd, 0x21, 0xc3, 0x06, 0xba, 0x00, 0xa0, 0x8e,
	0xc2, 0x50, 0xe8, 0xfe, 0x00, 0x58, 0x80, 0x3e,
	0xd8, 0x00, 0x00, 0x74, 0x02, 0x07, 0xc3, 0x0a,
	0xc0, 0x75, 0x12, 0xa1, 0xc0, 0x00, 0x3b, 0x06,
	0xc4, 0x00, 0x75, 0x09, 0xa1, 0xc2, 0x00, 0x3b,
	0x06, 0xc6, 0x00, 0x74, 0x58, 0xe8, 0x57, 0x00,
	0xba, 0x40, 0x01, 0xa1, 0xc2, 0x00, 0xa3, 0xc6,
	0x00, 0xf7, 0xe2, 0x8b, 0xf0, 0xa1, 0xc0, 0x00,
	0xa3, 0xc4, 0x00, 0x03, 0xf0, 0x89, 0x36, 0xc8,
	0x00, 0xba, 0x08, 0x00, 0xb8, 0x40, 0x01, 0x2b,
	0x06, 0xc0, 0x00, 0x3b, 0xc2, 0x77, 0x02, 0x8b,
	0xd0, 0xbb, 0xda, 0x00, 0xb9, 0x0c, 0x00, 0x8b,
	0xf9, 0x8b, 0xca, 0x8a, 0x07, 0x3c, 0x01, 0x74,
	0x03, 0x26, 0x88, 0x04, 0x43, 0x46, 0xe2, 0xf3,
	0x8b, 0xcf, 0x81, 0xc6, 0x40, 0x01, 0x83, 0xc3,
	0x08, 0x2b, 0xf2, 0x2b, 0xda, 0x81, 0xfe, 0xff,
	0xf9, 0x73, 0x02, 0xe2, 0xda, 0x07, 0xc3, 0x1e,
	0xba, 0x40, 0x01, 0xa1, 0xc6, 0x00, 0xf7, 0xe2,
	0x8b, 0xf0, 0x03, 0x36, 0xc4, 0x00, 0xba, 0x08,
	0x00, 0xb8, 0x40, 0x01, 0x2b, 0x06, 0xc4, 0x00,
	0x3b, 0xc2, 0x77, 0x02, 0x8b, 0xd0, 0x8b, 0x1e,
	0xc8, 0x00, 0xb9, 0x0c, 0x00, 0xa1, 0xb1, 0x32,
	0x8e, 0xd8, 0x8b, 0xf9, 0x8b, 0xca, 0x8a, 0x07,
	0x26, 0x88, 0x04, 0x43, 0x46, 0xe2, 0xf7, 0x8b,
	0xcf, 0x81, 0xc3, 0x40, 0x01, 0x81, 0xc6, 0x40,
	0x01, 0x2b, 0xda, 0x2b, 0xf2, 0x81, 0xfe, 0xff,
	0xf9, 0x73, 0x02, 0xe2, 0xdd, 0x1f, 0xc3, 0xb0,
	0x01, 0xe8, 0x27, 0xff, 0xc3, 0xc6, 0x06, 0xd8,
	0x00, 0x01, 0x06, 0x9c, 0xb8, 0x00, 0xa0, 0x8e,
	0xc0, 0xfa, 0xe8, 0x9a, 0xff, 0xa1, 0xc0, 0x00,
	0xa3, 0xc4, 0x00, 0xa1, 0xc2, 0x00, 0xa3, 0xc6,
	0x00, 0xe8, 0x8b, 0xff, 0x9d, 0x07, 0xc3, 0xc6,
	0x06, 0xd8, 0x00, 0x00, 0x9c, 0xfa, 0xe8, 0xce,
	0xff, 0x9d, 0xc3, 0xc6, 0x06, 0xca, 0x00, 0x00,
	0xc6, 0x06, 0xcb, 0x00, 0x00, 0x8b, 0x0e, 0xc0,
	0x00, 0x8b, 0x16, 0xc2, 0x00, 0x33, 0xdb, 0x2e,
	0xa0, 0xd7, 0x00, 0x3c, 0x4d, 0x75, 0x09, 0x81,
	0xf9, 0x3f, 0x01, 0x73, 0x36, 0x41, 0xeb, 0x33,
	0x3c, 0x4b, 0x75, 0x07, 0x0b, 0xc9, 0x74, 0x2b,
	0x49, 0xeb, 0x28, 0x3c, 0x48, 0x75, 0x07, 0x0b,
	0xd2, 0x74, 0x20, 0x4a, 0xeb, 0x1d, 0x3c, 0x50,
	0x75, 0x09, 0x81, 0xfa, 0xc7, 0x00, 0x73, 0x13,
	0x42, 0xeb, 0x10, 0x3c, 0x1d, 0x75, 0x05, 0x80,
	0xcb, 0x01, 0xeb, 0x07, 0x3c, 0x38, 0x75, 0x19,
	0x80, 0xcb, 0x02, 0x80, 0x3e, 0xd9, 0x00, 0x01,
	0x74, 0x1d, 0x53, 0x51, 0x52, 0xd1, 0xe1, 0xb8,
	0x04, 0x00, 0xcd, 0x33, 0x5a, 0x59, 0x5b, 0xeb,
	0x0e, 0x80, 0x3e, 0xd9, 0x00, 0x01, 0x74, 0x07,
	0xb8, 0x03, 0x00, 0xcd, 0x33, 0xd1, 0xe9, 0x89,
	0x0e, 0xc0, 0x00, 0x89, 0x16, 0xc2, 0x00, 0xf6,
	0xc3, 0x02, 0x74, 0x05, 0xc6, 0x06, 0xcb, 0x00,
	0x01, 0xf6, 0xc3, 0x01, 0x74, 0x05, 0xc6, 0x06,
	0xca, 0x00, 0x01, 0xc3, 0x80, 0x3e, 0xcf, 0x00,
	0x02, 0x75, 0x07, 0xc6, 0x06, 0xcf, 0x00, 0x00,
	0xeb, 0x0e, 0x80, 0x3e, 0xcb, 0x00, 0x00, 0x74,
	0x13, 0x80, 0x3e, 0xcd, 0x00, 0x01, 0x74, 0x11,
	0xc6, 0x06, 0xcb, 0x00, 0x01, 0xc6, 0x06, 0xcd,
	0x00, 0x01, 0xf9, 0xc3, 0xc6, 0x06, 0xcd, 0x00,
	0x00, 0xf8, 0xc3, 0x80, 0x3e, 0xcf, 0x00, 0x04,
	0x75, 0x07, 0xc6, 0x06, 0xcf, 0x00, 0x00, 0xeb,
	0x0e, 0x80, 0x3e, 0xca, 0x00, 0x00, 0x74, 0x13,
	0x80, 0x3e, 0xcc, 0x00, 0x01, 0x74, 0x11, 0xc6,
	0x06, 0xca, 0x00, 0x01, 0xc6, 0x06, 0xcc, 0x00,
	0x01, 0xf9, 0xc3, 0xc6, 0x06, 0xcc, 0x00, 0x00,
	0xf8, 0xc3, 0xe8, 0x06, 0xff, 0xe8, 0xcb, 0xff,
	0x72, 0x05, 0xe8, 0x97, 0xff, 0x73, 0xf3, 0xc3,
	0x50, 0x52, 0xba, 0xda, 0x03, 0xec, 0xa8, 0x08,
	0x75, 0xf8, 0xec, 0xa8, 0x08, 0x74, 0xfb, 0x5a,
	0x58, 0xc3, 0x1e, 0x8e, 0xda, 0xb7, 0x00, 0x2a,
	0xf8, 0x8a, 0xe7, 0xf6, 0xc7, 0x80, 0x74, 0x04,
	0xb4, 0x40, 0x02, 0xe7, 0x50, 0xa8, 0x80, 0x74,
	0x04, 0x34, 0xff, 0xfe, 0xc0, 0xb4, 0x00, 0x8b,
	0xc8, 0xb8, 0x40, 0x00, 0x33, 0xd2, 0xf7, 0xf1,
	0x8b, 0xc8, 0x58, 0xfc, 0x50, 0x51, 0x56, 0xb9,
	0x40, 0x00, 0xfb, 0xe8, 0xba, 0xff, 0xfa, 0xba,
	0xc8, 0x03, 0x32, 0xc0, 0xee, 0x42, 0xfa, 0xac,
	0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0, 0xee, 0xac,
	0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0, 0xee, 0xac,
	0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0, 0xee, 0xac,
	0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0, 0xee, 0xac,
	0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0, 0xee, 0xac,
	0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0, 0xee, 0xe2,
	0xce, 0xfb, 0xb9, 0x40, 0x00, 0xe8, 0x78, 0xff,
	0xfa, 0xac, 0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0,
	0xee, 0xac, 0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0,
	0xee, 0xac, 0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0,
	0xee, 0xac, 0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0,
	0xee, 0xac, 0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0,
	0xee, 0xac, 0x2a, 0xc4, 0x73, 0x02, 0x32, 0xc0,
	0xee, 0xe2, 0xce, 0xfb, 0x5e, 0x59, 0x58, 0x02,
	0xe7, 0x49, 0x74, 0x03, 0xe9, 0x75, 0xff, 0x1f,
	0xc3, 0xbb, 0x3e, 0x66, 0xe8, 0xfb, 0x97, 0x8b,
	0x36, 0xaf, 0x64, 0x8b, 0x3e, 0xb1, 0x64, 0x8b,
	0x07, 0x3d, 0xff, 0xff, 0x74, 0x25, 0x53, 0x8b,
	0x4f, 0x04, 0x8b, 0x57, 0x06, 0x8b, 0x5f, 0x02,
	0xe8, 0x1c, 0x00, 0x5b, 0x72, 0x05, 0x83, 0xc3,
	0x09, 0xeb, 0xe4, 0x8a, 0x47, 0x08, 0x3a, 0x06,
	0x08, 0x66, 0x74, 0x06, 0xa2, 0x08, 0x66, 0xe8,
	0x19, 0x00, 0xc3, 0x32, 0xc0, 0xeb, 0xef, 0x3b,
	0xf0, 0x72, 0x0e, 0x3b, 0xf1, 0x77, 0x0a, 0x3b,
	0xfb, 0x72, 0x06, 0x3b, 0xfa, 0x77, 0x02, 0xf9,
	0xc3, 0xf8, 0xc3, 0x80, 0x3e, 0xad, 0x64, 0x00,
	0x74, 0x31, 0xbe, 0x09, 0x66, 0xb9, 0x0d, 0x00,
	0xb3, 0xf2, 0x51, 0x8a, 0x24, 0x8a, 0x6c, 0x01,
	0x8a, 0x4c, 0x02, 0x2a, 0xe0, 0x73, 0x02, 0x32,
	0xe4, 0x2a, 0xe8, 0x73, 0x02, 0x32, 0xed, 0x2a,
	0xc8, 0x73, 0x02, 0x32, 0xc9, 0x50, 0xe8, 0x37,
	0x00, 0x58, 0x83, 0xc6, 0x03, 0xfe, 0xc3, 0x59,
	0xe2, 0xd8, 0xc3, 0xbe, 0x30, 0x66, 0xb9, 0x0d,
	0x00, 0xb3, 0xf2, 0x51, 0x8a, 0x24, 0x8a, 0xec,
	0x8a, 0xcc, 0x2a, 0xe0, 0x73, 0x02, 0x32, 0xe4,
	0x2a, 0xe8, 0x73, 0x02, 0x32, 0xed, 0x2a, 0xc8,
	0x73, 0x02, 0x32, 0xc9, 0x50, 0xe8, 0x08, 0x00,
	0x58, 0x46, 0xfe, 0xc3, 0x59, 0xe2, 0xdc, 0xc3,
	0xba, 0xc8, 0x03, 0x8a, 0xc3, 0xee, 0xeb, 0x00,
	0x42, 0x8a, 0xc4, 0xee, 0xeb, 0x00, 0x8a, 0xc5,
	0xee, 0xeb, 0x00, 0x8a, 0xc1, 0xee, 0xc3, 0x1e,
	0x06, 0xa1, 0xb1, 0x32, 0x8e, 0xc0, 0xa1, 0xb3,
	0x32, 0x8e, 0xd8, 0x33, 0xff, 0x33, 0xf6, 0xb9,
	0x00, 0x7d, 0xfc, 0xf3, 0xa5, 0x07, 0x1f, 0xc3,
	0x1e, 0x06, 0xe8, 0x4b, 0xfe, 0xb8, 0x00, 0xa0,
	0x8e, 0xc0, 0xa1, 0xb1, 0x32, 0x8e, 0xd8, 0x33,
	0xff, 0x33, 0xf6, 0xb9, 0x00, 0x7d, 0xfc, 0xf3,
	0xa5, 0x07, 0x1f, 0xc3, 0xe8, 0xe1, 0xff, 0xe8,
	0xf5, 0xfc, 0xc3, 0xbe, 0x86, 0x32, 0x8b, 0x04,
	0x8b, 0x54, 0x02, 0x03, 0xc1, 0x73, 0x01, 0x42,
	0x89, 0x07, 0x89, 0x57, 0x02, 0xc3, 0xbe, 0x86,
	0x32, 0x8b, 0x04, 0x8b, 0x54, 0x02, 0x8b, 0x4f,
	0x02, 0x8b, 0x37, 0x3b, 0xd1, 0x77, 0x08, 0x72,
	0x04, 0x3b, 0xc6, 0x73, 0x02, 0xf8, 0xc3, 0xf9,
	0xc3, 0x8a, 0x0e, 0x42, 0x32, 0xb5, 0x00, 0x80,
	0xf9, 0x01, 0x75, 0x05, 0xc6, 0x06, 0xa8, 0x64,
	0x04, 0x80, 0xf9, 0x03, 0x75, 0x05, 0xc6, 0x06,
	0xa8, 0x64, 0x05, 0x80, 0xf9, 0x04, 0x75, 0x05,
	0xc6, 0x06, 0xa8, 0x64, 0x05, 0xba, 0x44, 0x00,
	0xa1, 0xc1, 0x32, 0xa3, 0xac, 0x00, 0xc7, 0x06,
	0xaa, 0x00, 0x00, 0x01, 0xe8, 0x29, 0x06, 0xb8,
	0x00, 0x01, 0xa3, 0x4a, 0x32, 0xa1, 0xc1, 0x32,
	0xa3, 0x4c, 0x32, 0xb4, 0x01, 0x8b, 0x1e, 0x43,
	0x32, 0x8b, 0x0e, 0xc3, 0x32, 0x8b, 0x3e, 0xc5,
	0x32, 0x8a, 0x16, 0x45, 0x32, 0x8a, 0x36, 0x46,
	0x32, 0xff, 0x1e, 0x4a, 0x32, 0xb8, 0x3b, 0x0b,
	0x8e, 0xd8, 0x8e, 0xc0, 0xc3, 0xe8, 0x3b, 0x00,
	0xbb, 0x4e, 0x32, 0xba, 0x0a, 0x00, 0x8b, 0x3e,
	0x7d, 0x32, 0x8b, 0x0f, 0x0b, 0xc9, 0x74, 0x25,
	0x8a, 0x47, 0x03, 0xa2, 0x7c, 0x32, 0x33, 0xc0,
	0x89, 0x07, 0x89, 0x47, 0x02, 0x3b, 0xf9, 0x74,
	0x13, 0x89, 0x0e, 0x7d, 0x32, 0xb0, 0x01, 0xb4,
	0x05, 0xff, 0x1e, 0x4a, 0x32, 0xb8, 0x3b, 0x0b,
	0x8e, 0xd8, 0x8e, 0xc0, 0xc3, 0x83, 0xc3, 0x04,
	0x4a, 0x75, 0xcf, 0xc7, 0x06, 0x7a, 0x32, 0x00,
	0x00, 0xba, 0x0a, 0x00, 0xbb, 0x4e, 0x32, 0x8b,
	0x0f, 0x0b, 0xc9, 0x74, 0x07, 0x8a, 0x47, 0x02,
	0xa2, 0x7a, 0x32, 0xc3, 0x83, 0xc3, 0x04, 0x4a,
	0x75, 0xed, 0xc3, 0xe8, 0xdd, 0xff, 0xbb, 0x4e,
	0x32, 0xba, 0x0a, 0x00, 0x8b, 0x0f, 0x0b, 0xc9,
	0x74, 0x14, 0x89, 0x0e, 0x7d, 0x32, 0xb0, 0x01,
	0xb4, 0x05, 0xff, 0x1e, 0x4a, 0x32, 0xb8, 0x3b,
	0x0b, 0x8e, 0xd8, 0x8e, 0xc0, 0xc3, 0x83, 0xc3,
	0x04, 0x4a, 0x75, 0xe0, 0xc3, 0xbb, 0x4e, 0x32,
	0x89, 0x0f, 0x89, 0x47, 0x02, 0xc3, 0x89, 0x4f,
	0x04, 0x89, 0x47, 0x06, 0xc3, 0x89, 0x4f, 0x08,
	0x89, 0x47, 0x0a, 0xc3, 0x89, 0x4f, 0x0c, 0x89,
	0x47, 0x0e, 0xc3, 0x89, 0x4f, 0x10, 0x89, 0x47,
	0x12, 0xc3, 0x89, 0x4f, 0x14, 0x89, 0x47, 0x16,
	0xc3, 0x89, 0x4f, 0x18, 0x89, 0x47, 0x1a, 0xc3,
	0x89, 0x4f, 0x1c, 0x89, 0x47, 0x1e, 0xc3, 0x89,
	0x4f, 0x20, 0x89, 0x47, 0x22, 0xc3, 0x89, 0x4f,
	0x24, 0x89, 0x47, 0x26, 0xc3, 0x81, 0xe9, 0xf3,
	0x01, 0xba, 0x2c, 0x00, 0xa1, 0xbf, 0x32, 0xa3,
	0xac, 0x00, 0xc7, 0x06, 0xaa, 0x00, 0x00, 0x00,
	0xe8, 0x15, 0x05, 0xc3, 0xbe, 0xc7, 0x32, 0xbb,
	0x47, 0x33, 0xb9, 0x01, 0x00, 0x53, 0x51, 0x56,
	0x49, 0xb0, 0x1b, 0xf6, 0xe1, 0x03, 0xf0, 0xd1,
	0xe1, 0x03, 0xd9, 0x8b, 0x0f, 0x0b, 0xc9, 0x74,
	0x1b, 0x81, 0xe9, 0xf3, 0x01, 0xba, 0x2c, 0x00,
	0x8b, 0x44, 0x16, 0xa3, 0xac, 0x00, 0xc7, 0x06,
	0xaa, 0x00, 0x00, 0x00, 0xe8, 0xe1, 0x04, 0xb8,
	0x01, 0x00, 0x89, 0x04, 0x5e, 0x59, 0x5b, 0x41,
	0x80, 0xf9, 0x04, 0x76, 0xc8, 0xc3, 0xbe, 0xc7,
	0x32, 0xbb, 0x47, 0x33, 0xb9, 0x01, 0x00, 0x53,
	0x51, 0x56, 0x8b, 0xd1, 0x49, 0xb0, 0x1b, 0xf6,
	0xe1, 0x03, 0xf0, 0xd1, 0xe1, 0x03, 0xd9, 0x8b,
	0x07, 0x0b, 0xc0, 0x74, 0x26, 0x8b, 0x0e, 0xf3,
	0xb4, 0x49, 0xc1, 0xe1, 0x02, 0x03, 0xca, 0xba,
	0x38, 0x00, 0xe8, 0x2b, 0x00, 0x8b, 0x44, 0x16,
	0xa3, 0xac, 0x00, 0xc7, 0x06, 0xaa, 0x00, 0x00,
	0x00, 0x56, 0xe8, 0x93, 0x04, 0x5e, 0xb8, 0x01,
	0x00, 0x89, 0x04, 0x5e, 0x59, 0x5b, 0x41, 0x80,
	0xf9, 0x04, 0x76, 0xbb, 0xbf, 0x47, 0x33, 0xb9,
	0x08, 0x00, 0x33, 0xc0, 0xfc, 0xf3, 0xab, 0xc3,
	0x83, 0xf9, 0x51, 0x75, 0x0e, 0x80, 0x3e, 0xad,
	0xdb, 0x01, 0x75, 0x07, 0xb9, 0xa0, 0x00, 0xba,
	0x2c, 0x00, 0xc3, 0x81, 0xf9, 0x89, 0x00, 0x75,
	0x1c, 0x80, 0x3e, 0xc5, 0xdb, 0x01, 0x75, 0x15,
	0x80, 0x3e, 0xc6, 0xdb, 0x01, 0x75, 0x07, 0xb9,
	0xcb, 0x00, 0xba, 0x2c, 0x00, 0xc3, 0xb9, 0xca,
	0x00, 0xba, 0x2c, 0x00, 0xc3, 0x83, 0xf9, 0x19,
	0x75, 0x0e, 0x80, 0x3e, 0xdf, 0xdb, 0x02, 0x75,
	0x07, 0xb9, 0x4c, 0x01, 0xba, 0x2c, 0x00, 0xc3,
	0x83, 0xf9, 0x25, 0x75, 0x1c, 0x80, 0x3e, 0xe2,
	0xdb, 0x01, 0x75, 0x07, 0xb9, 0x5f, 0x01, 0xba,
	0x2c, 0x00, 0xc3, 0x80, 0x3e, 0xe2, 0xdb, 0x02,
	0x75, 0x07, 0xb9, 0x6c, 0x01, 0xba, 0x2c, 0x00,
	0xc3, 0x80, 0x3e, 0xe7, 0xdb, 0x01, 0x75, 0x18,
	0x83, 0xf9, 0x1d, 0x75, 0x07, 0xb9, 0x7c, 0x01,
	0xba, 0x2c, 0x00, 0xc3, 0x83, 0xf9, 0x1e, 0x75,
	0x07, 0xb9, 0x7d, 0x01, 0xba, 0x2c, 0x00, 0xc3,
	0x83, 0x3e, 0xec, 0xdb, 0x01, 0x75, 0x0b, 0x83,
	0xf9, 0x2a, 0x75, 0x06, 0xb9, 0x90, 0x01, 0xba,
	0x2c, 0x00, 0xc3, 0xa1, 0xbf, 0x32, 0xa3, 0xac,
	0x00, 0x33, 0xc0, 0xa3, 0xaa, 0x00, 0xb9, 0x01,
	0x00, 0xba, 0x54, 0x00, 0xe8, 0xc9, 0x03, 0xc3,
	0x8b, 0x0e, 0xf3, 0xb4, 0xba, 0x25, 0x00, 0xa1,
	0xb5, 0x32, 0xa3, 0xac, 0x00, 0x33, 0xc0, 0xa3,
	0xaa, 0x00, 0xe8, 0xb3, 0x03, 0x83, 0x3e, 0xf3,
	0xb4, 0x07, 0x75, 0x11, 0xa0, 0xe6, 0xdb, 0x3c,
	0x02, 0x74, 0x0a, 0xe8, 0x08, 0x00, 0x3c, 0x01,
	0x74, 0x03, 0xe8, 0x01, 0x00, 0xc3, 0x1e, 0x8b,
	0x16, 0xb5, 0x32, 0x8e, 0xda, 0x33, 0xdb, 0xff,
	0x0f, 0x1f, 0xc3, 0xe8, 0x0f, 0x00, 0xe8, 0xf0,
	0xfb, 0xe8, 0x3b, 0x00, 0xc6, 0x06, 0x08, 0x66,
	0xfe, 0xe8, 0xe5, 0xfb, 0xc3, 0x89, 0x3e, 0xb7,
	0x64, 0x89, 0x36, 0xb9, 0x64, 0x89, 0x3e, 0xbb,
	0x64, 0x89, 0x36, 0xbd, 0x64, 0xa3, 0xaf, 0x64,
	0x89, 0x1e, 0xb1, 0x64, 0x88, 0x2e, 0xc3, 0x64,
	0x88, 0x0e, 0x07, 0x66, 0xe8, 0x49, 0x92, 0xc6,
	0x06, 0xdc, 0x1c, 0x02, 0xc6, 0x06, 0xda, 0x1c,
	0x01, 0xc6, 0x06, 0xc6, 0x64, 0x01, 0xc3, 0xc6,
	0x06, 0xc5, 0x64, 0x00, 0xc6, 0x06, 0x3d, 0x66,
	0x00, 0xc6, 0x06, 0x40, 0x67, 0xff, 0xc6, 0x06,
	0xc4, 0x64, 0x01, 0xe8, 0x12, 0x89, 0x80, 0x3e,
	0xad, 0x64, 0x01, 0x75, 0x0a, 0xe8, 0x84, 0x00,
	0xe8, 0x1d, 0x00, 0xe8, 0x8b, 0x00, 0xc3, 0xe8,
	0x94, 0x00, 0xe8, 0x13, 0x00, 0xb8, 0x00, 0xa0,
	0xb9, 0x00, 0x7d, 0xe8, 0xa2, 0x00, 0xe8, 0x92,
	0x00, 0xe8, 0x5d, 0x00, 0xe8, 0x59, 0xfc, 0xc3,
	0xe8, 0xa2, 0x01, 0xe8, 0x01, 0x00, 0xc3, 0xe8,
	0xf0, 0x05, 0xe8, 0x0f, 0x01, 0xe8, 0x2f, 0xfc,
	0xe8, 0x45, 0xfc, 0xff, 0x36, 0xce, 0x64, 0xc7,
	0x06, 0xce, 0x64, 0xff, 0xff, 0xe8, 0x86, 0x8f,
	0x8f, 0x06, 0xce, 0x64, 0xc6, 0x06, 0x33, 0x33,
	0x01, 0xe8, 0x22, 0x00, 0xc6, 0x06, 0xdd, 0x1c,
	0x02, 0xe8, 0xda, 0x7b, 0xbb, 0xa4, 0x32, 0x8b,
	0x0e, 0x90, 0x32, 0xe8, 0x3d, 0xfc, 0xc6, 0x06,
	0x33, 0x33, 0x00, 0xc6, 0x06, 0xdc, 0x1c, 0x03,
	0xc6, 0x06, 0xdd, 0x1c, 0x03, 0xc3, 0xbb, 0xa4,
	0x32, 0x33, 0xc0, 0x89, 0x07, 0x89, 0x47, 0x02,
	0xc3, 0xb8, 0x1b, 0x10, 0x33, 0xdb, 0xb9, 0xff,
	0x00, 0xcd, 0x10, 0xc3, 0x8b, 0x16, 0xb3, 0x32,
	0xbe, 0x00, 0xfa, 0xb0, 0xf0, 0xe8, 0x4a, 0xfa,
	0xc3, 0x8b, 0x16, 0xb3, 0x32, 0xbe, 0x00, 0xfa,
	0xb0, 0x10, 0xe8, 0x3d, 0xfa, 0xc3, 0x8b, 0x16,
	0xb3, 0x32, 0xbe, 0x00, 0xfa, 0xb0, 0xc0, 0xe8,
	0x30, 0xfa, 0xc3, 0x8b, 0x16, 0xb3, 0x32, 0xbe,
	0x00, 0xfa, 0xb0, 0x20, 0xe8, 0x23, 0xfa, 0xc3,
	0x06, 0x8e, 0xc0, 0x33, 0xc0, 0x8b, 0xf8, 0xfc,
	0xf3, 0xab, 0x07, 0xc3, 0xc6, 0x06, 0xdc, 0x1c,
	0x01, 0xe8, 0x0f, 0x00, 0xc3, 0xc6, 0x06, 0xdc,
	0x1c, 0x02, 0xe8, 0x06, 0x00, 0xc6, 0x06, 0xdc,
	0x1c, 0x03, 0xc3, 0x80, 0x3e, 0xad, 0x64, 0x01,
	0x75, 0x0a, 0xe8, 0x9f, 0xff, 0xe8, 0x1d, 0x00,
	0xe8, 0xa6, 0xff, 0xc3, 0xe8, 0xaf, 0xff, 0xe8,
	0x13, 0x00, 0xb8, 0x00, 0xa0, 0xb9, 0x00, 0x7d,
	0xe8, 0xbd, 0xff, 0xe8, 0xad, 0xff, 0xe8, 0x78,
	0xff, 0xe8, 0x74, 0xfb, 0xc3, 0xe8, 0xbd, 0x00,
	0xe8, 0x0f, 0x05, 0xe8, 0x2e, 0x00, 0xe8, 0x03,
	0xfd, 0xe8, 0x4b, 0xfb, 0xe8, 0x61, 0xfb, 0xe8,
	0x54, 0xff, 0xc6, 0x06, 0x33, 0x33, 0x01, 0xc6,
	0x06, 0xdd, 0x1c, 0x02, 0xe8, 0x07, 0x7b, 0xbb,
	0xa4, 0x32, 0x8b, 0x0e, 0x90, 0x32, 0xe8, 0x6a,
	0xfb, 0xc6, 0x06, 0x33, 0x33, 0x00, 0xc6, 0x06,
	0xdd, 0x1c, 0x03, 0xc3, 0x55, 0xbf, 0xc7, 0x32,
	0xb9, 0x36, 0x00, 0x33, 0xc0, 0xfc, 0xf3, 0xab,
	0xbe, 0xc7, 0x32, 0xbb, 0x9e, 0xd8, 0xbd, 0x46,
	0xd9, 0xb9, 0x01, 0x00, 0x53, 0x51, 0x56, 0x55,
	0x8b, 0x16, 0xf3, 0xb4, 0x4a, 0xc1, 0xe2, 0x02,
	0x03, 0xda, 0x03, 0xd9, 0x4b, 0xd1, 0xe2, 0x03,
	0xea, 0x49, 0x03, 0xe9, 0x03, 0xe9, 0xb0, 0x1b,
	0xf6, 0xe1, 0x41, 0x03, 0xf0, 0x8a, 0x2f, 0x0a,
	0xed, 0x74, 0x3e, 0x8a, 0xd1, 0xb6, 0x00, 0x8b,
	0x0e, 0xf3, 0xb4, 0x49, 0xc1, 0xe1, 0x02, 0x03,
	0xca, 0x51, 0x3e, 0x8b, 0x5e, 0x00, 0x83, 0xc6,
	0x16, 0xe8, 0x4f, 0x04, 0x59, 0xba, 0x38, 0x00,
	0xe8, 0x15, 0xfd, 0x8b, 0x04, 0xa3, 0xac, 0x00,
	0xc7, 0x06, 0xaa, 0x00, 0x00, 0x00, 0x56, 0xe8,
	0x7e, 0x01, 0x5e, 0x83, 0xee, 0x16, 0xb8, 0x01,
	0x00, 0x89, 0x04, 0x89, 0x44, 0x12, 0x89, 0x44,
	0x14, 0x5d, 0x5e, 0x59, 0x5b, 0x41, 0x80, 0xf9,
	0x04, 0x76, 0x91, 0x5d, 0xc3, 0x8b, 0x0e, 0xf3,
	0xb4, 0xba, 0x1d, 0x00, 0xa1, 0xb3, 0x32, 0xa3,
	0xac, 0x00, 0x33, 0xc0, 0xa3, 0xaa, 0x00, 0xe8,
	0x4e, 0x01, 0xe8, 0x9e, 0x00, 0xe8, 0x80, 0xfd,
	0xc3, 0xe8, 0x04, 0x00, 0xe8, 0x91, 0xfa, 0xc3,
	0xe8, 0xda, 0xff, 0xff, 0x36, 0x33, 0x33, 0xff,
	0x36, 0xdc, 0x1c, 0xff, 0x36, 0xdd, 0x1c, 0xc6,
	0x06, 0x33, 0x33, 0x00, 0xc6, 0x06, 0xdc, 0x1c,
	0x03, 0xc6, 0x06, 0xdd, 0x1c, 0x03, 0xfe, 0x0e,
	0x07, 0x66, 0xe8, 0xae, 0x80, 0xe8, 0xa3, 0x7d,
	0xe8, 0x0c, 0x7f, 0xe8, 0xb2, 0xf8, 0xe8, 0xf8,
	0x85, 0xe8, 0xab, 0x7f, 0xe8, 0x70, 0xf7, 0x8f,
	0x06, 0xdd, 0x1c, 0x8f, 0x06, 0xdc, 0x1c, 0x8f,
	0x06, 0x33, 0x33, 0xc3, 0xe8, 0x96, 0xff, 0xff,
	0x36, 0x33, 0x33, 0xff, 0x36, 0xdc, 0x1c, 0xff,
	0x36, 0xdd, 0x1c, 0xc6, 0x06, 0x33, 0x33, 0x00,
	0xc6, 0x06, 0xdc, 0x1c, 0x03, 0xc6, 0x06, 0xdd,
	0x1c, 0x03, 0xe8, 0xe1, 0x79, 0x8f, 0x06, 0xdd,
	0x1c, 0x8f, 0x06, 0xdc, 0x1c, 0x8f, 0x06, 0x33,
	0x33, 0xc3, 0xe8, 0x68, 0xff, 0xff, 0x36, 0x33,
	0x33, 0xff, 0x36, 0xdd, 0x1c, 0xc6, 0x06, 0x33,
	0x33, 0x00, 0xc6, 0x06, 0xdd, 0x1c, 0x03, 0xe8,
	0xbc, 0x79, 0x8f, 0x06, 0xdd, 0x1c, 0x8f, 0x06,
	0x33, 0x33, 0xc3, 0x06, 0xa1, 0xb5, 0x32, 0x8e,
	0xc0, 0xa3, 0xac, 0x00, 0xc7, 0x06, 0xaa, 0x00,
	0x00, 0x00, 0xe8, 0x13, 0x91, 0x53, 0x8a, 0x0f,
	0x0a, 0xc9, 0x74, 0x17, 0x80, 0xf9, 0xff, 0x74,
	0x16, 0xb5, 0x00, 0xba, 0x4c, 0x00, 0xe8, 0x87,
	0x00, 0xa1, 0xb3, 0x32, 0x8b, 0x1e, 0xaa, 0x00,
	0xe8, 0xb9, 0x6a, 0x5b, 0x43, 0xeb, 0xde, 0x5b,
	0x07, 0xc3, 0x06, 0x8b, 0x16, 0xb5, 0x32, 0x8e,
	0xc2, 0x89, 0x16, 0xac, 0x00, 0xc7, 0x06, 0xaa,
	0x00, 0x00, 0x00, 0x8a, 0xc8, 0xb5, 0x00, 0xba,
	0x4c, 0x00, 0xe8, 0x5b, 0x00, 0xa1, 0xb3, 0x32,
	0x8b, 0x1e, 0xaa, 0x00, 0xe8, 0x8d, 0x6a, 0x07,
	0xc3, 0xe8, 0xd6, 0xff, 0xe8, 0x81, 0xfc, 0xc3,
	0xb8, 0x00, 0x3d, 0xb1, 0x00, 0xcd, 0x21, 0x72,
	0x3c, 0xa3, 0xa2, 0x00, 0xb8, 0x02, 0x42, 0x33,
	0xc9, 0x33, 0xd2, 0x8b, 0x1e, 0xa2, 0x00, 0xcd,
	0x21, 0x72, 0x2a, 0x8b, 0xd8, 0xb0, 0x33, 0x0b,
	0xd2, 0x75, 0x22, 0x89, 0x1e, 0xa4, 0x00, 0xb8,
	0x00, 0x42, 0x33, 0xc9, 0x33, 0xd2, 0x8b, 0x1e,
	0xa2, 0x00, 0xcd, 0x21, 0x72, 0x0f, 0xb4, 0x3e,
	0x8b, 0x1e, 0xa2, 0x00, 0xcd, 0x21, 0x72, 0x05,
	0x8b, 0x0e, 0xa4, 0x00, 0xc3, 0xe9, 0xf8, 0x03,
	0x51, 0xb8, 0x00, 0x3d, 0xb1, 0x00, 0xcd, 0x21,
	0x72, 0x6a, 0xa3, 0xa2, 0x00, 0x59, 0xb8, 0x04,
	0x00, 0xf7, 0xe1, 0x8b, 0xca, 0x8b, 0xd0, 0x8b,
	0x1e, 0xa2, 0x00, 0xb8, 0x00, 0x42, 0xcd, 0x21,
	0x72, 0x52, 0x8b, 0x1e, 0xa2, 0x00, 0xb9, 0x08,
	0x00, 0xba, 0xae, 0x00, 0xb4, 0x3f, 0xcd, 0x21,
	0x72, 0x42, 0xbb, 0xae, 0x00, 0x8b, 0x17, 0x8b,
	0x4f, 0x02, 0x8b, 0x47, 0x04, 0x2b, 0xc2, 0xa3,
	0xa4, 0x00, 0x8b, 0x1e, 0xa2, 0x00, 0xb8, 0x00,
	0x42, 0xcd, 0x21, 0x72, 0x27, 0x8b, 0x1e, 0xa2,
	0x00, 0x8b, 0x0e, 0xa4, 0x00, 0x8b, 0x16, 0xaa,
	0x00, 0xa1, 0xac, 0x00, 0x8e, 0xd8, 0xb4, 0x3f,
	0xcd, 0x21, 0x72, 0x10, 0xb8, 0x3b, 0x0b, 0x8e,
	0xd8, 0xb4, 0x3e, 0x8b, 0x1e, 0xa2, 0x00, 0xcd,
	0x21, 0x72, 0x01, 0xc3, 0xe9, 0x81, 0x03, 0xb8,
	0x00, 0x3d, 0xb1, 0x00, 0xcd, 0x21, 0x72, 0x54,
	0xa3, 0xa2, 0x00, 0xb8, 0x02, 0x42, 0x33, 0xc9,
	0x33, 0xd2, 0x8b, 0x1e, 0xa2, 0x00, 0xcd, 0x21,
	0x72, 0x42, 0x8b, 0xd8, 0xb0, 0x33, 0x0b, 0xd2,
	0x75, 0x3a, 0x89, 0x1e, 0xa4, 0x00, 0xb8, 0x00,
	0x42, 0x33, 0xc9, 0x33, 0xd2, 0x8b, 0x1e, 0xa2,
	0x00, 0xcd, 0x21, 0x72, 0x27, 0x8b, 0x1e, 0xa2,
	0x00, 0x8b, 0x0e, 0xa4, 0x00, 0x8b, 0x16, 0xaa,
	0x00, 0xa1, 0xac, 0x00, 0x8e, 0xd8, 0xb4, 0x3f,
	0xcd, 0x21, 0x72, 0x10, 0xb8, 0x3b, 0x0b, 0x8e,
	0xd8, 0xb4, 0x3e, 0x8b, 0x1e, 0xa2, 0x00, 0xcd,
	0x21, 0x72, 0x01, 0xc3, 0xe9, 0x21, 0x03, 0xb8,
	0x00, 0x3d, 0xb1, 0x00, 0xcd, 0x21, 0x72, 0x3b,
	0xa3, 0xa2, 0x00, 0xb8, 0x00, 0x42, 0x33, 0xc9,
	0x8b, 0x16, 0xa8, 0x00, 0x8b, 0x1e, 0xa2, 0x00,
	0xcd, 0x21, 0x72, 0x27, 0x8b, 0x1e, 0xa2, 0x00,
	0x8b, 0x0e, 0xa6, 0x00, 0x8b, 0x16, 0xaa, 0x00,
	0xa1, 0xac, 0x00, 0x8e, 0xd8, 0xb4, 0x3f, 0xcd,
	0x21, 0x72, 0x10, 0xb8, 0x3b, 0x0b, 0x8e, 0xd8,
	0xb4, 0x3e, 0x8b, 0x1e, 0xa2, 0x00, 0xcd, 0x21,
	0x72, 0x01, 0xc3, 0xe9, 0xda, 0x02, 0x51, 0xb4,
	0x3c, 0xb1, 0x00, 0xcd, 0x21, 0x59, 0x72, 0x26,
	0xa3, 0xa2, 0x00, 0x8b, 0x1e, 0xa2, 0x00, 0x8b,
	0x16, 0xaa, 0x00, 0xa1, 0xac, 0x00, 0x8e, 0xd8,
	0xb4, 0x40, 0xcd, 0x21, 0x72, 0x10, 0xb8, 0x3b,
	0x0b, 0x8e, 0xd8, 0xb4, 0x3e, 0x8b, 0x1e, 0xa2,
	0x00, 0xcd, 0x21, 0x72, 0x01, 0xc3, 0xe9, 0xa7,
	0x02, 0xba, 0x13, 0x00, 0xb8, 0x00, 0x3d, 0xb1,
	0x00, 0xcd, 0x21, 0x72, 0x19, 0x8b, 0xd8, 0xb4,
	0x3e, 0xcd, 0x21, 0x72, 0x73, 0x8c, 0x1e, 0xac,
	0x00, 0xb8, 0x42, 0x32, 0xa3, 0xaa, 0x00, 0xba,
	0x13, 0x00, 0xe8, 0x02, 0xff, 0xc3, 0x3d, 0x02,
	0x00, 0x75, 0x5d, 0xb8, 0x03, 0x00, 0xcd, 0x10,
	0x8c, 0xc8, 0x8e, 0xd8, 0xba, 0x00, 0xb1, 0xb4,
	0x09, 0xcd, 0x21, 0xb8, 0x00, 0x4c, 0xcd, 0x21,
	0x53, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x66, 0x69, 0x6c, 0x65,
	0x3a, 0x20, 0x53, 0x4f, 0x55, 0x4e, 0x44, 0x2e,
	0x53, 0x45, 0x54, 0x20, 0x6e, 0x6f, 0x74, 0x20,
	0x66, 0x6f, 0x75, 0x6e, 0x64, 0x2e, 0x20, 0x50,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x20, 0x72, 0x75,
	0x6e, 0x20, 0x53, 0x4f, 0x55, 0x4e, 0x44, 0x53,
	0x45, 0x54, 0x2e, 0x45, 0x58, 0x45, 0x2e, 0x24,
	0xe9, 0x1d, 0x02, 0x89, 0x0e, 0x90, 0xdb, 0xb0,
	0x00, 0xb4, 0x05, 0xff, 0x1e, 0x4a, 0x32, 0xb8,
	0x3b, 0x0b, 0x8e, 0xd8, 0x8e, 0xc0, 0xc3, 0x00,
	0x00, 0x00, 0x00, 0x57, 0x8b, 0xc8, 0xbb, 0x5f,
	0xb1, 0x2e, 0x8b, 0x47, 0x02, 0x2e, 0x8b, 0x1f,
	0x8b, 0xf0, 0x8b, 0xfb, 0x8a, 0xd4, 0x8a, 0xe0,
	0x8a, 0xc7, 0x8a, 0xfb, 0x32, 0xdb, 0xd0, 0xda,
	0xd1, 0xd8, 0xd1, 0xdb, 0x03, 0xdf, 0x13, 0xc6,
	0x81, 0xc3, 0xe9, 0x62, 0x15, 0x19, 0x36, 0xbf,
	0x5f, 0xb1, 0x2e, 0x89, 0x1d, 0x2e, 0x89, 0x45,
	0x02, 0x33, 0xd2, 0xf7, 0xf1, 0x8b, 0xc2, 0x5f,
	0xc3, 0xb4, 0x62, 0xcd, 0x21, 0x53, 0xba, 0x28,
	0x25, 0x2b, 0xd3, 0x33, 0xc0, 0xe8, 0x1c, 0x00,
	0x05, 0x0f, 0x00, 0x83, 0xd2, 0x00, 0xbb, 0x10,
	0x00, 0xf7, 0xf3, 0x8b, 0xd8, 0x58, 0x06, 0x8e,
	0xc0, 0xb4, 0x4a, 0xcd, 0x21, 0x07, 0x72, 0x01,
	0xc3, 0xe9, 0x9c, 0x01, 0x53, 0xd1, 0xc2, 0xd1,
	0xc2, 0xd1, 0xc2, 0xd1, 0xc2, 0x8b, 0xda, 0x83,
	0xe2, 0x0f, 0x83, 0xe3, 0xf0, 0x03, 0xc3, 0x83,
	0xd2, 0x00, 0x5b, 0xc3, 0xbb, 0x06, 0xfa, 0xbe,
	0xb1, 0x32, 0xe8, 0x3e, 0x00, 0xbb, 0x00, 0xfd,
	0xbe, 0xb3, 0x32, 0xe8, 0x35, 0x00, 0xbb, 0x00,
	0xfa, 0xbe, 0xb5, 0x32, 0xe8, 0x2c, 0x00, 0xbb,
	0x00, 0xfd, 0xbe, 0xbf, 0x32, 0xe8, 0x23, 0x00,
	0xbb, 0x88, 0x14, 0xbe, 0xc1, 0x32, 0xe8, 0x1a,
	0x00, 0x80, 0x3e, 0x42, 0x32, 0x06, 0x74, 0x12,
	0xbb, 0x4e, 0x80, 0xbe, 0xc3, 0x32, 0xe8, 0x0a,
	0x00, 0xbb, 0xb8, 0x88, 0xbe, 0xc5, 0x32, 0xe8,
	0x01, 0x00, 0xc3, 0x53, 0x56, 0xe8, 0x11, 0x00,
	0xb4, 0x48, 0xcd, 0x21, 0x5e, 0x59, 0x72, 0x06,
	0x89, 0x04, 0xe8, 0x19, 0x00, 0xc3, 0xe9, 0x27,
	0x01, 0x8b, 0xc3, 0x05, 0x0f, 0x00, 0x73, 0x04,
	0xb0, 0x38, 0xeb, 0xf2, 0x33, 0xd2, 0xbb, 0x10,
	0x00, 0xf7, 0xf3, 0x8b, 0xd8, 0xc3, 0x06, 0x8e,
	0xc0, 0x33, 0xc0, 0x33, 0xff, 0xfc, 0xf3, 0xaa,
	0x07, 0xc3, 0x06, 0xbe, 0xc7, 0x32, 0xb9, 0x01,
	0x00, 0x51, 0x56, 0x49, 0xb0, 0x1b, 0xf6, 0xe1,
	0x03, 0xf0, 0x8b, 0x44, 0x16, 0x0b, 0xc0, 0x74,
	0x0b, 0x8e, 0xc0, 0xb4, 0x49, 0xcd, 0x21, 0x73,
	0x03, 0xe9, 0xe4, 0x00, 0x5e, 0x59, 0x41, 0x80,
	0xf9, 0x04, 0x76, 0xdd, 0x07, 0xc3, 0xa0, 0x42,
	0x32, 0x3c, 0x01, 0x74, 0x1d, 0x3c, 0x06, 0x74,
	0x19, 0x3c, 0x07, 0x74, 0x15, 0x3c, 0x03, 0x74,
	0x11, 0x3c, 0x04, 0x74, 0x0d, 0xc7, 0x06, 0x84,
	0x32, 0x6c, 0x00, 0xb8, 0x59, 0x00, 0xa3, 0x04,
	0x00, 0xc3, 0xc7, 0x06, 0x84, 0x32, 0x9c, 0x2e,
	0xb8, 0x0a, 0x00, 0xa3, 0x04, 0x00, 0xc3, 0x33,
	0xd2, 0xb8, 0xff, 0xff, 0xf7, 0x36, 0x84, 0x32,
	0xa3, 0x7f, 0x32, 0xa3, 0x81, 0x32, 0xc3, 0xb0,
	0x36, 0xe6, 0x43, 0xa1, 0x84, 0x32, 0xe6, 0x40,
	0x8a, 0xc4, 0xe6, 0x40, 0xc3, 0xb0, 0x36, 0xe6,
	0x43, 0x32, 0xc0, 0xe6, 0x40, 0xe6, 0x40, 0xc3,
	0x06, 0xb8, 0x08, 0x35, 0xcd, 0x21, 0x89, 0x1e,
	0x00, 0x00, 0x8c, 0x06, 0x02, 0x00, 0x07, 0x8b,
	0x16, 0x04, 0x00, 0x1e, 0x0e, 0x1f, 0xb8, 0x08,
	0x25, 0xcd, 0x21, 0x1f, 0xc3, 0x1e, 0x8b, 0x16,
	0x00, 0x00, 0x8b, 0x1e, 0x02, 0x00, 0x8e, 0xdb,
	0xb8, 0x08, 0x25, 0xcd, 0x21, 0x1f, 0xc3, 0x06,
	0xb8, 0x09, 0x35, 0xcd, 0x21, 0x2e, 0x89, 0x1e,
	0xd8, 0x00, 0x2e, 0x8c, 0x06, 0xda, 0x00, 0x07,
	0x1e, 0x0e, 0x1f, 0xba, 0xba, 0x00, 0xb8, 0x09,
	0x25, 0xcd, 0x21, 0x1f, 0xc3, 0x1e, 0x2e, 0x8b,
	0x16, 0xd8, 0x00, 0x2e, 0x8b, 0x1e, 0xda, 0x00,
	0x8e, 0xdb, 0xb8, 0x09, 0x25, 0xcd, 0x21, 0x1f,
	0xc3, 0xe8, 0x42, 0xff, 0xe8, 0xc8, 0xff, 0xfa,
	0xb0, 0xff, 0xe6, 0x21, 0xe8, 0x91, 0xff, 0xe8,
	0x75, 0xff, 0xb0, 0x00, 0xe6, 0x21, 0xfb, 0xb8,
	0x13, 0x00, 0xcd, 0x10, 0xe8, 0x58, 0xff, 0xc3,
	0x50, 0xb8, 0x03, 0x00, 0xcd, 0x10, 0x58, 0xb4,
	0x00, 0xbb, 0xa6, 0x2f, 0xd1, 0xe0, 0x03, 0xd8,
	0x8b, 0x17, 0xb4, 0x09, 0xcd, 0x21, 0x80, 0x3e,
	0x42, 0x32, 0x00, 0x74, 0x0d, 0xb4, 0x02, 0xff,
	0x1e, 0x4a, 0x32, 0xb8, 0x3b, 0x0b, 0x8e, 0xd8,
	0x8e, 0xc0, 0xeb, 0x00, 0xfa, 0xe4, 0x21, 0x50,
	0xb0, 0xff, 0xe6, 0x21, 0xfa, 0xe8, 0x3d, 0xff,
	0xe8, 0x62, 0xff, 0xe8, 0x8f, 0xff, 0x58, 0xe6,
	0x21, 0xfb, 0xb8, 0x00, 0x4c, 0xcd, 0x21, 0x00
};

// Data Segment
// starts at offset 0xb5b0 in original executable
#define DSEG_STARTBLK_SIZE 13214

const static uint8 dsegStartBlock[DSEG_STARTBLK_SIZE] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x73, 0x6f, 0x75, 0x6e, 0x64,
	0x2e, 0x73, 0x65, 0x74, 0x00, 0x6f, 0x66, 0x66,
	0x2e, 0x72, 0x65, 0x73, 0x00, 0x6f, 0x6e, 0x2e,
	0x72, 0x65, 0x73, 0x00, 0x6c, 0x61, 0x6e, 0x5f,
	0x35, 0x30, 0x30, 0x2e, 0x72, 0x65, 0x73, 0x00,
	0x6c, 0x61, 0x6e, 0x5f, 0x30, 0x30, 0x30, 0x2e,
	0x72, 0x65, 0x73, 0x00, 0x73, 0x64, 0x72, 0x2e,
	0x72, 0x65, 0x73, 0x00, 0x6f, 0x6e, 0x73, 0x2e,
	0x72, 0x65, 0x73, 0x00, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x2e, 0x72, 0x65, 0x73, 0x00, 0x6d, 0x6d,
	0x6d, 0x2e, 0x72, 0x65, 0x73, 0x00, 0x73, 0x61,
	0x6d, 0x5f, 0x73, 0x61, 0x6d, 0x2e, 0x72, 0x65,
	0x73, 0x00, 0x73, 0x61, 0x6d, 0x5f, 0x6d, 0x6d,
	0x6d, 0x2e, 0x72, 0x65, 0x73, 0x00, 0x75, 0x6e,
	0x6c, 0x6f, 0x67, 0x69, 0x63, 0x2e, 0x72, 0x65,
	0x73, 0x00, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74,
	0x2e, 0x72, 0x65, 0x73, 0x00, 0x74, 0x65, 0x65,
	0x6e, 0x61, 0x67, 0x65, 0x30, 0x2e, 0x73, 0x61,
	0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xa0, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc7, 0x00, 0x00, 0x00, 0x3f, 0x01,
	0x00, 0x00, 0xdf, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0xdf, 0x00, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0xdf, 0xff, 0x00, 0x01, 0x01, 0x01,
	0x01, 0x01, 0xdf, 0xff, 0xff, 0x00, 0x01, 0x01,
	0x01, 0x01, 0xdf, 0xff, 0xff, 0xff, 0x00, 0x01,
	0x01, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x00,
	0x01, 0x01, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x01, 0xdf, 0xff, 0xdf, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xdf, 0xdf, 0x01, 0xdf, 0xff, 0x00,
	0x01, 0x01, 0x01, 0x01, 0x01, 0xdf, 0xff, 0x00,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xdf, 0xff,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xdf,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x32, 0xe1,
	0x40, 0x01, 0x00, 0x00, 0x00, 0x00, 0xd1, 0xe0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x20, 0x30, 0x25, 0x30, 0x34, 0x30, 0x39, 0x30,
	0x4d, 0x30, 0x52, 0x30, 0x57, 0x30, 0x76, 0x30,
	0x8a, 0x30, 0xa7, 0x30, 0xac, 0x30, 0xb1, 0x30,
	0xb6, 0x30, 0xbb, 0x30, 0xc0, 0x30, 0xc5, 0x30,
	0xca, 0x30, 0xcf, 0x30, 0xd4, 0x30, 0xd9, 0x30,
	0xde, 0x30, 0xe3, 0x30, 0xe8, 0x30, 0xed, 0x30,
	0xf2, 0x30, 0xf7, 0x30, 0xfc, 0x30, 0x01, 0x31,
	0x06, 0x31, 0x0b, 0x31, 0x10, 0x31, 0x15, 0x31,
	0x1a, 0x31, 0x1f, 0x31, 0x24, 0x31, 0x29, 0x31,
	0x2e, 0x31, 0x33, 0x31, 0x38, 0x31, 0x3d, 0x31,
	0x42, 0x31, 0x47, 0x31, 0x4c, 0x31, 0x51, 0x31,
	0x56, 0x31, 0x5b, 0x31, 0x60, 0x31, 0x65, 0x31,
	0x6a, 0x31, 0x6f, 0x31, 0xbd, 0x31, 0xc1, 0x31,
	0xc5, 0x31, 0xc9, 0x31, 0xcd, 0x31, 0xce, 0x31,
	0xd2, 0x31, 0xd6, 0x31, 0xda, 0x31, 0xde, 0x31,
	0x45, 0x30, 0x31, 0x68, 0x24, 0x46, 0x69, 0x6c,
	0x65, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x66, 0x6f,
	0x75, 0x6e, 0x64, 0x24, 0x45, 0x30, 0x33, 0x68,
	0x24, 0x54, 0x6f, 0x6f, 0x20, 0x6d, 0x61, 0x6e,
	0x79, 0x20, 0x6f, 0x70, 0x65, 0x6e, 0x20, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x24, 0x45, 0x30, 0x35,
	0x68, 0x24, 0x45, 0x30, 0x36, 0x68, 0x24, 0x4d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x20, 0x63, 0x6f,
	0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x20, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x20, 0x64, 0x65, 0x73, 0x74,
	0x72, 0x6f, 0x79, 0x65, 0x64, 0x24, 0x49, 0x6e,
	0x73, 0x75, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65,
	0x6e, 0x74, 0x20, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x24, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x20, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x20, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x69,
	0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x24, 0x45,
	0x30, 0x41, 0x68, 0x24, 0x45, 0x30, 0x42, 0x68,
	0x24, 0x45, 0x30, 0x43, 0x68, 0x24, 0x45, 0x30,
	0x44, 0x68, 0x24, 0x45, 0x30, 0x45, 0x68, 0x24,
	0x45, 0x30, 0x46, 0x68, 0x24, 0x45, 0x31, 0x30,
	0x68, 0x24, 0x45, 0x31, 0x31, 0x68, 0x24, 0x45,
	0x31, 0x32, 0x68, 0x24, 0x45, 0x31, 0x33, 0x68,
	0x24, 0x45, 0x31, 0x34, 0x68, 0x24, 0x45, 0x31,
	0x35, 0x68, 0x24, 0x45, 0x31, 0x36, 0x68, 0x24,
	0x45, 0x31, 0x37, 0x68, 0x24, 0x45, 0x31, 0x38,
	0x68, 0x24, 0x45, 0x31, 0x39, 0x68, 0x24, 0x45,
	0x31, 0x41, 0x68, 0x24, 0x45, 0x31, 0x42, 0x68,
	0x24, 0x45, 0x31, 0x43, 0x68, 0x24, 0x45, 0x31,
	0x44, 0x68, 0x24, 0x45, 0x31, 0x45, 0x68, 0x24,
	0x45, 0x31, 0x46, 0x68, 0x24, 0x45, 0x32, 0x30,
	0x68, 0x24, 0x45, 0x32, 0x31, 0x68, 0x24, 0x45,
	0x32, 0x32, 0x68, 0x24, 0x45, 0x32, 0x33, 0x68,
	0x24, 0x45, 0x32, 0x34, 0x68, 0x24, 0x45, 0x32,
	0x35, 0x68, 0x24, 0x45, 0x32, 0x36, 0x68, 0x24,
	0x45, 0x32, 0x37, 0x68, 0x24, 0x45, 0x32, 0x38,
	0x68, 0x24, 0x45, 0x32, 0x39, 0x68, 0x24, 0x45,
	0x32, 0x41, 0x68, 0x24, 0x45, 0x32, 0x42, 0x68,
	0x24, 0x45, 0x32, 0x43, 0x68, 0x24, 0x45, 0x32,
	0x44, 0x68, 0x24, 0x45, 0x32, 0x45, 0x68, 0x24,
	0x45, 0x32, 0x46, 0x68, 0x24, 0x45, 0x33, 0x30,
	0x68, 0x24, 0x45, 0x33, 0x31, 0x68, 0x24, 0x44,
	0x75, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x6e,
	0x74, 0x69, 0x2d, 0x76, 0x69, 0x72, 0x75, 0x73,
	0x20, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x61, 0x64,
	0x65, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x67, 0x61, 0x6d, 0x65, 0x20,
	0x66, 0x72, 0x6f, 0x6d, 0x20, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x20, 0x64, 0x69,
	0x73, 0x6b, 0x73, 0x2e, 0x24, 0x47, 0x45, 0x31,
	0x24, 0x47, 0x45, 0x32, 0x24, 0x47, 0x45, 0x33,
	0x24, 0x47, 0x45, 0x34, 0x24, 0x24, 0x47, 0x45,
	0x35, 0x24, 0x47, 0x45, 0x36, 0x24, 0x47, 0x45,
	0x37, 0x24, 0x47, 0x45, 0x38, 0x24, 0x47, 0x45,
	0x39, 0x24, 0x43, 0x61, 0x6c, 0x6c, 0x20, 0x79,
	0x6f, 0x75, 0x72, 0x73, 0x65, 0x6c, 0x66, 0x20,
	0x70, 0x69, 0x72, 0x61, 0x74, 0x65, 0x2c, 0x20,
	0x68, 0x61, 0x63, 0x6b, 0x65, 0x72, 0x2c, 0x20,
	0x65, 0x6c, 0x69, 0x74, 0x65, 0x20, 0x6f, 0x72,
	0x20, 0x77, 0x68, 0x61, 0x74, 0x65, 0x76, 0x65,
	0x72, 0x2e, 0x20, 0x42, 0x75, 0x74, 0x20, 0x79,
	0x6f, 0x75, 0x20, 0x61, 0x72, 0x65, 0x20, 0x61,
	0x20, 0x54, 0x48, 0x49, 0x45, 0x46, 0x2e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x6e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
	0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d,
	0x6f, 0x75, 0x73, 0x65, 0x20, 0x6e, 0x6f, 0x74,
	0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x3a, 0x20,
	0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x6b, 0x65,
	0x79, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x2e,
	0x2e, 0x0d, 0x0a, 0x50, 0x72, 0x65, 0x73, 0x73,
	0x20, 0x61, 0x6e, 0x79, 0x20, 0x6b, 0x65, 0x79,
	0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6e, 0x74,
	0x69, 0x6e, 0x75, 0x65, 0x2e, 0x24
};

const uint kNumMessages = 333 + 1; // Plus one to account for combine error message

const static char *englishMessages[kNumMessages] = {
	"I have no idea what to do with it.", // 0
	"I can't imagine what I could do with\nthis.", // 1
	"I can't figure out what I should do\nwith this.", // 2
	"I can't find any reason to mess\nwith it.", // 3
	"Cool.", // 4
	"That's no good.", // 5
	"Wow! There's a car jack inside!\nGreat!", // 6
	"There's something else inside the toolbox!\nA spanner!", // 7
	"Last\nchance?", // 8
	"I give up.", // 9
	"I'm going to stay at least five meters\naway from these bees!", // 10
	"There's nothing else in the boat.", // 11
	"This wood is too hard to break.", // 12
	"Booo!", // 13
	"I don't think I should push\nmy luck.", // 14
	"Just an ordinary hay stack. Now.", // 15
	"And they say you can't find a needle\nin a hay stack.", // 16
	"There are no more\npotatoes.", // 17
	"Good I always asked mum for\ntrousers with BIG pockets...", // 18
	"Life is brutal.", // 19
	"Life is really brutal.", // 20
	"Something tickled\nme!", // 21
	"At least it's gone.", // 22
	"Who knows what monsters\nmay live in there...", // 23
	"I'd better not put my hands in there.\nSomething might bite them off\n(yuck)!", // 24
	"I can see it's totally\nempty.", // 25
	"One small step for man,\none big pain in the ...head...", // 26
	"I won't take my chances\na second time...", // 27
	"I really hope this is DINOSAUR\nbone...", // 28
	"Wow! This must have shaken\nall the nearby walls!", // 29
	"It's kinda dark here.", // 30
	"I'm not going to wander here\nin the dark again.", // 31
	"Shutting the valve shook the dirt from the wall\nand revealed the switch!", // 32
	"Sorry, buddy, but I need your\nsunglasses.", // 33
	"It's not the best place for diving...", // 34
	"Not here...", // 35
	"I really can't talk underwater!...", // 36
	"I don't think swimming there is worth the effort.", // 37
	"If I want to get this anchor I have to swim there\nwhen I have more air in my lungs...", // 38
	"I was really hooked on this anchor!", // 39
	"This seaweed is just like the flowers\nI gave mum on her last birthday.", // 40
	"I wonder what fish do inside\nthis boat at night.", // 41
	"I think I have to fish out something down\nthere.", // 42
	"At least fish don't worry about the rain.", // 43
	"I hope all this fish stuff is not a red herring.", // 44
	"It's nice down there.", // 45
	"Hey, let go, will ya?!", // 46
	"Aaaaaaaaaaaaaahhh!...", // 47
	"Oops.", // 48
	"People leave food in unbelievable places.", // 49
	"Come here, I've got something for\nyou...", // 50
	"I can't catch it!", // 51
	"The mouse is trapped!", // 52
	"Yikes!", // 53
	"Boy, this mouse has some nerve!", // 54
	"There's nothing else in the drawers.", // 55
	"I must get rid of this bush first.", // 56
	"The mouse has gone!", // 57
	"Nonsense.", // 58
	"I understand. Good doggy.", // 59
	"Here, boy.", // 60
	"I hope we're friends now.", // 61
	"I don't think this is the right place.", // 62
	"Hundred moments later...", // 63
	"Another hundred moments later...", // 64
	"At least I found crude-oil and I'll be\nrich.", // 65
	"That's my life.", // 66
	"!?&!", // 67
	"But grandpa, you promised!...", // 68
	"Oh, all right. Let's go.", // 69
	"Bye.", // 70
	"No need to do it again.", // 71
	"I really don't know how to talk to\ngirls...", // 72
	"I usually don't work without a purpose.", // 73
	"Only the nut is real.", // 74
	"I wonder if hens can fly. Come here,\nbaby...", // 75
	"First test failed.", // 76
	"I'd already got rid of my frustrations.", // 77
	"Nah, it's a road to nowhere.", // 78
	"It opens the boot.", // 79
	"It's shut tight.", // 80
	"There's nothing else in the boot.", // 81
	"The clothes are dry now.", // 82
	"I'm sure these crows will kill me!", // 83
	"If I want to get inside I must get rid of\nthis guard first or find some other\nway.", // 84
	"The wall surface is too smooth to climb.", // 85
	"I could climb it\nif there wasn't\nso much resin.", // 86
	"The only green stuff I like is that rectangular\npiece of paper with some important-looking\nguy on it.", // 87
	"I don't wanna touch it. Its spines could\nhurt my delicate hands.", // 88
	"Thanks, I'm not hungry.", // 89
	"I really don't have such long hands.", // 90
	"It's too far to swim there.", // 91
	"Echo!", // 92
	"ECHO!", // 93
	"Who's there?!", // 94
	"WHO'S THERE?!", // 95
	"     DON'T COPY ME!...", // 96
	"        DON'T COPY ME!!!", // 97
	"...OR I WILL THROW A ROCK DOWN THERE!", // 98
	"OR I WILL...", // 99
	"Are you still there?", // 100
	"It's not a barrel-organ. And there's\nno bucket.", // 101
	"I don't need to open it.", // 102
	"Hmmm... Grass... Nah, children might\nbe watching.", // 103
	"I won't find the nut just like that.\nThe grass is too dense.", // 104
	"I'm not horny.", // 105
	"No way I can jump so high,\ncause, er..., white men\ncan't jump.", // 106
	"I don't need it.", // 107
	"I'm not Santa Claus.", // 108
	"I don't need plastic imitations.", // 109
	"It's too fragile to carry around.", // 110
	"I'd like to keep it open.", // 111
	"I really don't want to walk around with\nsomeone else's socks.", // 112
	"Thanks, I'm not tired.", // 113
	"It's too big and I doubt if I'll ever\nneed it.", // 114
	"I don't think there's any secret passage\ninside.", // 115
	"There are no more interesting fruits here.", // 116
	"They can jug me if I steal this.", // 117
	"I'd better leave it. Women are really\noversensitive about flowers.", // 118
	"Mirror, mirror on the wall,\nwho's the smartest of them all?", // 119
	"Hey, don't think too long.", // 120
	"A hint: someone in this room,\na male.", // 121
	"OK, take your time.", // 122
	"I'd better not interrupt its\nthought process.", // 123
	"I don't want to have anything in common\nwith dentists.", // 124
	"It's too heavy. Not that I'm wimp.", // 125
	"Let's look what we've got here...", // 126
	"'Strawberry jam'.", // 127
	"'Gooseberry jam'.", // 128
	"'Blackberry jam'.", // 129
	"'Bilberry jam'.", // 130
	"Get me out of this jam!", // 131
	"Oh, and there is 'Rosemary jam'.", // 132
	"I used to know someone called Rosemary.", // 133
	"I don't want those jams.", // 134
	"It's too dark to see clearly.", // 135
	"YEEEOOOWWWW!", // 136
	"(yawn)", // 137
	"(laughter)", // 138
	"I can't remove it with my hands - these\nthorns look really sharp.", // 139
	"There's no fuel in the chainsaw.", // 140
	"Thorns are too thin, the chainsaw\nis useless here.", // 141
	"Yeah, great idea. Let's take this rock and\nwalk around a bit. Gee...", // 142
	"I'd better leave them alone, they make\nthis place beautiful.", // 143
	"I'm not sure if it's alive.", // 144
	"I don't know what language it speaks.", // 145
	"The hole is too narrow to fit my hand.", // 146
	"Hey, you! Wake up! Bird attack!", // 147
	"I don't have a search-warrant.", // 148
	"I don't see anything interesting\nabout this hay stack.", // 149
	"It's more complicated than that.", // 150
	"It's pointless, the nut will slip between\nthe rake's teeth.", // 151
	"The paddle is BROKEN.", // 152
	"This branch is not a paddle. It doesn't\neven look like one.", // 153
	"I'd better try somewhere else - I suppose this\nside is heavily guarded.", // 154
	"I needed to sharpen it, not pulverize.", // 155
	"I can't do anything here, it's too dark.", // 156
	"Here, let's make your\npocket fat.", // 157
	"It's a note from some bank. Strange,\nbut someone has also written \"NEVER! ANNE\"\non it.", // 158
	"If I just show her the money,\nshe might take it.", // 159
	"A hundred bucks!!!", // 160
	"I want blood!", // 161
	"I don't want to leave the mansion,\nI want blood!", // 162
	"I'm a pathetic little wimp.", // 163
	"Strange, but the drawer is stuck\nif the next drawer is open...", // 164
	"Maybe these are not just ordinary\ndrawers!", // 165
	"I cannot open the drawer\nif the next one is open!", // 166
	"It's got a blue interior.", // 167
	"It's got a red interior.", // 168
	"It's got a grey interior.", // 169
	"It's got a green interior.", // 170
	"It's got a brown interior.", // 171
	"It's got a pink interior.", // 172
	"Wow! There's a dictaphone inside!", // 173
	"There's a polaroid inside!\nI might need that.", // 174
	"Something's got hold of the book!", // 175
	"Wow! A secret compartment!", // 176
	"I don't need to mess with it\nanymore.", // 177
	"Fully automatic.", // 178
	"Right now I don't need any more\nsheets.", // 179
	"Nah, I don't want to deprave the kids.", // 180
	"I don't want to read it again.\nI might like it.", // 181
	"I just realised that the TV is off.", // 182
	"Nothing happened.", // 183
	"The tape started!", // 184
	"That's much better.", // 185
	"I don't want to sleep.", // 186
	"It's just a cork.", // 187
	"I don't need any more photos.", // 188
	"Yeah, I can record this and scare\nthe cats.", // 189
	"I already recorded what I wanted to.", // 190
	"I can't record anything until I find some\nbatteries.", // 191
	"No batteries, no fun.", // 192
	"I don't think this is the right moment.", // 193
	"I can't do anything with\nthis cook around.", // 194
	"The bottle's the same, but\nI doubt if it's enough to\nfool anyone.", // 195
	"I wanted to break it, not to\nflatten it!..", // 196
	"I was always curious what's inside\nthese things.", // 197
	"The rest is useless.", // 198
	"Wow! Two 1.5V batteries!", // 199
	"This one's taken, OK?", // 200
	"It finally happened. I'm slightly mad.", // 201
	"The paper burnt out completely!", // 202
	"Burn, baby, burn!", // 203
	"Voila.", // 204
	"It's too hot to touch!", // 205
	"It has frozen hard onto the shelf!", // 206
	"Yummy.", // 207
	"I never liked veal anyway.", // 208
	"There's no reason to do it.", // 209
	"I'd already fooled him once.", // 210
	"Mike, activate the voice test.", // 211
	"I won't cheat Mike with MY voice.", // 212
	"...siiiiinging!...", // 213
	"Mike, let's get on with the scent\ntest.", // 214
	"Mike, run the view test.", // 215
	"'A secret diary of John Noty. Authorised.'", // 216
	"I can't hide here!", // 217
	"There's John Noty outside! I can't go out!", // 218
	"That was close.", // 219
	"The cork is stuck in the hole.", // 220
	"It fits perfectly!", // 221
	"There's enough water in the sink.", // 222
	"There's no hot water in the sink.", // 223
	"The label has come off!", // 224
	"The cork is a bit too small.", // 225
	"There's no need to try them now.", // 226
	"I don't want to turn myself into a salad.", // 227
	"Nah...", // 228
	"I'd better stop this ventilator first.", // 229
	"I'd better catch John Noty first.", // 230
	"Good this red stuff is only a chilli...", // 231
	"The water looks very hot.", // 232
	"The sink is full of hot water.", // 233
	"I don't have anything\nto store these socks in.", // 234
	"Here are my papers.", // 235
	"I already got the permission.", // 236
	"'Saving is a very fine thing. Especially\nwhen your parents have done it for you'", // 237
	"'I love captain'", // 238
	"'Soccer rulz'", // 239
	"'Don't cut the trees, cuz one\nday you may become partisan\ntoo'", // 240
	"'VISA accepted'", // 241
	"The rest of graffiti is obscene.", // 242
	"Sir, I'm Mark. A rookie.", // 243
	"It's locked!", // 244
	"Thanks.", // 245
	"I don't have any idea what\nto do with it right\nnow.", // 246
	"That gives me an idea...", // 247
	"Now I got to check if it works...", // 248
	"I think it's time to call captain...", // 249
	"Hey! I finished the meal!", // 250
	"Wow, he got welded to the bowl!...", // 251
	"Gotcha.", // 252
	"I don't want to touch\nhis pockets again.", // 253
	"That doesn't work.", // 254
	"Piece of cake.", // 255
	"And how am I supposed to get back?", // 256
	"Great.", // 257
	"Oh, yeah, right...", // 258
	"I can't pull it out.", // 259
	"I don't want to touch it - I might get hurt.", // 260
	"The fence blocks the way...", // 261
	"I don't want to sleep.", // 262
	"I can't reach it.", // 263
	"Hello?", // 264
	"He's totally addicted.", // 265
	"What about a new...", // 266
	"...hot off the press...", // 267
	"...full-color...", // 268
	"...special edition...", // 269
	"... of 'Soldier News'?!", // 270
	"Never again!", // 271
	"What am I? A vacuum cleaner?!", // 272
	"          Sixty seven rude words later...", // 273
	"Meanwhile in the mansion...", // 274
	"Now it's open.", // 275
	"C'mon, baby, it's all yours!", // 276
	"I've got no reason to talk to him\nright now.", // 277
	"Yeah, right!...", // 278
	"The barman is too close...", // 279
	"Yuck!", // 280
	"I prefer water.", // 281
	"I'm too weak to climb it.", // 282
	"The springs would prick my back.", // 283
	"No, thanks. This food seems still alive.", // 284
	"The door is closed. What a surprise.", // 285
	"It's empty.", // 286
	"I should have paid more attention\nin geography classes...", // 287
	"I don't need this mess.", // 288
	"Thanks, but I've seen softer rocks.", // 289
	"They are too blunt to be of any use.", // 290
	"What's the use of the models?", // 291
	"The barman will surely notice its\ndisappearing.", // 292
	"It'd take too much time to drink it all.\nMaybe after the mission...", // 293
	// Two extra null bytes  at are removed from here.
	"I'm not a thief. And it's empty, by the way.", // 294
	"There are too many of them to search.", // 295
	"Captain surely wouldn't fit them.\nI must look elsewhere.", // 296
	"Chickening? Me? Never!", // 297
	"I can't open it.", // 298
	"I don't need them.", // 299
	"What am I? A Peeping Tom?", // 300
	"I have big pockets, but there are limits.", // 301
	"If I put it on I might have trouble walking\nup the stairs.", // 302
	"I'd need 9 lives to read them all.", // 303
	"Thanks, I'm not so tired.", // 304
	"There's no need to turn it on.", // 305
	"It won't bear my weight.", // 306
	"I never learnt to how use one...", // 307
	"They're so sharp they'd rip my trousers!", // 308
	"Pfui! The cognac really didn't do any good...", // 309
	"I don't have time for pleasures.", // 310
	"I won't touch these socks with my bare hands!", // 311
	"It's not Halloween.", // 312
	"It can't be controlled manually! I hate it!", // 313
	"I have nothing to play.", // 314
	"I can't take it. It's not mine.", // 315
	"Hey! What's the matter?!", // 316
	"It's open!", // 317
	"It's out of order.", // 318
	"With captain watching?...\nBetter not...", // 319
	"The sickle is too blunt.", // 320
	"First I've got some business to take care of.", // 321
	"Digging it out with the knife could\ntake a hundred years.", // 322
	"I don't want to make more\nmess on this table.", // 323
	"Should I throw the crumbs to the bird?", // 324
	"I don't want to waste these tasty crumbs.", // 325
	"Better not... I might slip and fall in...", // 326
	"\"The history of blues\".", // 327
	"\"Manchester United, or the Red Devils story\".", // 328
	"\"Greyhounds and other hunting dogs\".", // 329
	"\"Greenhorn, or my adventures in the Wild West\".", // 330
	"\"Charlie Brown and his company\".", // 331
	"\"Pink Panther: an unauthorised biography\".", // 332

	// Combine error message.
	// NOTE: This string is stored separately from
	// the rest of the messages above in the executable.
	"Using these two objects together won't\naccomplish anything.",
};

const static char *polishMessages[kNumMessages] = {
	"Nie mam poj#cia, co z tym zrobi^.", // 0
	"Nic mi nie przychodzi na my$l.", // 1
	"Nie mam <adnego pomys%u...", // 2
	"Nie ma powodu, <eby co$ z tym\npr*bowa^ robi^.", // 3
	"Miodzio.", // 4
	"To raczej nic nie da.", // 5
	"]a%! W $rodku jest podno$nik!\nEkstra!", // 6
	"W skrzynce jest co$ jeszcze!\nTo klucz francuski!", // 7
	"Ostatnia\nszansa?", // 8
	"Poddaj# si#.", // 9
	"Nie zamierzam podchodzi^ do tych pszcz*%\nbli<ej ni< pi#^ metr*w!", // 10
	"W %*dce niczego wi#cej nie ma.", // 11
	"Drewno jest za twarde jak dla mnie.", // 12
	"Bum!", // 13
	"Nie powinienem przepracowywa^ swojego\nszcz#$cia.", // 14
	"To zwyk%y st*g siana. Teraz.", // 15
	"A m*wi@, <e nie mo<na znale>^ ig%y\nw stogu siana.", // 16
	"Nie ma tam ju< wi#cej ziemniak*w.", // 17
	"Dobrze, <e zawsze cisn@%em mam#\no spodnie z du<ymi kieszeniami...", // 18
	"Lajf is brutal.", // 19
	"Lajf is naprawd# brutal.", // 20
	"Co$ mnie po%askota%o!", // 21
	"Przynajmniej odlecia%o.", // 22
	"Kto wie, co za potwory mog@\n<y^ w $rodku...", // 23
	"Lepiej nie b#d# tam wsadza% r@k.\nCo$ mo<e mi je odgry>^\n(ble)!", // 24
	"Wida^, <e jest kompletnie\npusta.", // 25
	"Ma%y krok dla cz%owieka...\nDu<y b*l w ...g%owie..", // 26
	"Wola%bym nie ryzykowa^\npo raz drugi...", // 27
	"Naprawd# mam nadziej#, <e to ko$^\nDINOZAURA...", // 28
	"Ooo! Chyba wstrz@sn@%em wszystkimi\n$cianami w pobli<u!", // 29
	"Deko tu ciemnawo.", // 30
	"Nie mam zamiaru gania^ tu\nznowu w ciemno$ciach.", // 31
	"Zamkni#cie klapy strz@sn#%o kurz\nze $ciany i ods%oni%o w%@cznik!", // 32
	"Sorry, kole$, ale potrzebuj#\ntwoich okulark*w.", // 33
	"To nie najlepsze miejsce na nurkowanie...", // 34
	"Lepiej b#d# nurkowa% tylko w pobli<u\nbrzegu...", // 35
	"Naprawd# nie umiem gada^ pod wod@!...", // 36
	"Pop%yni#cie tam chyba nie jest warte wysi%ku.", // 37
	"Je$li chc# dorwa^ t# kotwiczk#, to musz# mie^\ntroch# wi#cej powietrza w p%ucach...", // 38
	"Ta kotwiczka to by% niez%y haczyk!", // 39
	"Te wodorosty wygl@daj@ idealnie jak kwiatki,\nkt*re da%em mamie na jej urodziny.", // 40
	"Ciekawe, co ryby robi@ nocami\nwewn@trz tej %*dki.", // 41
	"Chyba musz# wy|LEDZI\\ co$ tam na dole.", // 42
	"Ryby przynajmniej nie przejmuj@ si# deszczem.", // 43
	"To p%ywanie pod wod@ to chyba jedno\nwielkie lanie wody.", // 44
	"Fajnie tam w dole.", // 45
	"Ej, ty, popu$^, co?!", // 46
	"Aaaaaaaaaaaaaahhh!...", // 47
	"Oops.", // 48
	"Ludzie zostawiaj@ jedzenie w niewiarygodnych\nmiejscach.", // 49
	"Chod> tutaj, mam co$ specjalnego\ndla ciebie...", // 50
	"Jest za szybka!", // 51
	"Myszka wpad%a w pu%apk#!", // 52
	"Ojej!", // 53
	"Ch%opie, ta mysz to ma nerwy!...", // 54
	"W szufladach nie ma nic wi#cej.", // 55
	"Najpierw musz# pozby^ si# tego krzaka.", // 56
	"Myszka uciek%a!", // 57
	"Nonsens.", // 58
	"Rozumiem. Dobry piesek.", // 59
	"Tutaj, Burek.", // 60
	"Chyba zostali$my przyjaci*%mi, co?", // 61
	"To raczej nie jest w%a$ciwe miejsce.", // 62
	"Sto moment*w p*>niej...", // 63
	"Nast#pne sto moment*w p*>niej...", // 64
	"Przynajmniej znalaz%em rop# i zostan# bogaty!", // 65
	"Ca%e moje <ycie.", // 66
	"!?&!", // 67
	"Ale dziadku, obieca%e$!...", // 68
	"Och, dobrze. Pojedziemy.", // 69
	"Baj-baj.", // 70
	"Nie ma powodu m#czy^ si# znowu.", // 71
	"Naprawd# nie wiem, jak si# rozmawia\nz dziewczynami...", // 72
	"Zwykle nie pracuj# bez powodu.", // 73
	"Tylko orzech jest tu prawdziwy.", // 74
	"Ciekawe, czy kury lataj@. Podejd> no,\ndziecinko...", // 75
	"Pierwszy test oblany.", // 76
	"Ju< si# pozby%em swoich frustracji.", // 77
	"Eee tam, to droga do nik@d.", // 78
	"Otwiera baga<nik.", // 79
	"Jest zatrza$ni#ty.", // 80
	"Nie ma tam ju< nic wi#cej.", // 81
	"Ciuchy s@ ju< suche.", // 82
	"Te wrony na pewno mnie zabij@!", // 83
	"Jak chc# wej$^, to albo musz# pozby^ si#\ntego stra<nika, albo znale>^ jaki$\ninny spos*b.", // 84
	"Powierzchnia muru jest zbyt g%adka, nie\ndam rady si# wspi@^.", // 85
	"M*g%bym si# na nie\nwspi@^, gdyby nie\nby%o tu tyle <ywicy.", // 86
	"Jedyna zielona rzecz, jak@ bym chcia% mie^, to\ntaki prostok@tny kawa%ek papieru z narysowanym\njakim$ wa<niakiem.", // 87
	"Nie chc# go dotyka^. Jego kolce mog@\nmi zrani^ moje delikatne d%onie.", // 88
	"Dzi#ki, nie jestem g%odny.", // 89
	"Naprawd# nie mam tak d%ugich r@k.", // 90
	"Nie dop%yn# tak daleko.", // 91
	"Echo!", // 92
	"ECHO!", // 93
	"Kto tam jest?!", // 94
	"KTO TAM JEST?!", // 95
	"NIE POWTARZAJ PO MNIE!...", // 96
	"NIE POWTARZAJ PO MNIE!!!", // 97
	"...ALBO WRZUC[ CI TAM JAKIEGO| KAMOLA!", // 98
	"ALBO WRZU...", // 99
	"Jeste$ tam jeszcze?", // 100
	"To nie katarynka. No i nie ma wiadra.", // 101
	"Nie musz# go otwiera^.", // 102
	"Hmmm... Trawka... Eh, jeszcze dzieci\nb#d@ patrze^.", // 103
	"Nie znajd# orzecha ot tak sobie...", // 104
	"Nie jestem rogaczem.", // 105
	"Tak wysoko to nikt nie\npodskoczy.", // 106
	"Nie potrzebuj# tego.", // 107
	"Nie jestem |wi#tym Miko%ajem.", // 108
	"Nie potrzebuj# plastikowych imitacji.", // 109
	"Boj# si# nosi^ tak delikatne rzeczy.", // 110
	"Lepiej niech zostan@ otwarte.", // 111
	"Czu%bym si# g%upio ganiaj@c tam i nazad\nz cudzymi gaciami w kieszeni.", // 112
	"Nie jestem zm#czony.", // 113
	"W@tpi#, bym kiedykolwiek tego potrzebowa%.", // 114
	"Tu chyba nie ma <adnego tajnego\nprzej$cia.", // 115
	"Nie ma tu ju< wi#cej <adnych fajnych owoc*w.", // 116
	"Kto$ mi mo<e oberwa^ UCHO za ten\nDZBANEK.", // 117
	"Lepiej je zostawi#. Kobiety s@ lekko\nprzewra<liwione na punkcie\nkwiat*w.", // 118
	"Lustereczko, lustereczko,\nkto tu jest najlepszy zdeczko?", // 119
	"Hej, nie my$l tak d%ugo.", // 120
	"Podpowied>: kto$ w tym pokoju,\np%ci m#skiej.", // 121
	"OK, namy$l si#.", // 122
	"Lepiej nie b#d# przerywa% jego\nproces*w my$lowych.", // 123
	"Nie chc# mie^ nic wsp*lnego z dentystami.", // 124
	"Jest za ci#<ki. Nie to, <e jestem\nrzadziak.", // 125
	"Zobaczmy co tu mamy...", // 126
	"\'Marmolada truskawkowa\'.", // 127
	"\'Marmolada porzeczkowa\'.", // 128
	"\'Marmolada jagodowa\'.", // 129
	"\'Marmolada malinowa\'.", // 130
	"Zabierzcie mnie st@d, albo zrobi#\nz kogo$ marmolad#!", // 131
	"Och, i jest \'Marmolada z r*<y\'.", // 132
	"Zna%em kiedy$ pewn@ R*<#.", // 133
	"Nie chc# si# upapra^.", // 134
	"Nie widz# dok%adnie, jest tu zbyt ciemno.", // 135
	"JAAAAAAAA]]!", // 136
	"(ziew)", // 137
	"($mieszek)", // 138
	"Nie wyrw# go r#koma - te ciernie s@\nostre jak szpilki.", // 139
	"Pi%a nie ma paliwa.", // 140
	"Ciernie s@ za cienkie, pi%a jest\ntu bezu<yteczna.", // 141
	"Tak, $wietny pomys%. We>my sobie t#\nska%# i pospacerujmy. Jezu...", // 142
	"Nie chc# ich p%oszy^. Dzi#ki nim to\nmiejsce wygl@da $licznie.", // 143
	"Nawet nie wiem, czy toto <yje.", // 144
	"Nie znam jego j#zyka.", // 145
	"Moja d%o= nie zmie$ci si# w t# dziur#.", // 146
	"Ej, ty! Obud> si#! Ptaki atakuj@!", // 147
	"Nie mam nakazu rewizji.", // 148
	"Nie widz# nic ciekawego w tym stogu.", // 149
	"Dostanie si# tam wymaga chyba nieco\nwi#kszego wysi%ku.", // 150
	"To bezcelowe, orzech prze$lizgnie si#\npomi#dzy drutami.", // 151
	"Wios%o jest Z]AMANE.", // 152
	"Ta ga%@> to nie wios%o. Nawet go nie\nprzypomina.", // 153
	"Lepiej spr*buj# gdzie indziej - ta strona wygl@da\nna silniej strze<on@.", // 154
	"Mia%em go naostrzy^, a nie zetrze^ w py%.", // 155
	"Nie mog# tu nic u<y^, jest za ciemno.", // 156
	"Dalej, niech ci kiesze=\ntroch# przytyje.", // 157
	"To jaka$ nota z banku. Dziwne, ale kto$\ndopisa% na niej \"NIGDY! ANNA\"", // 158
	"Jak poka<# jej fors# bez powodu,\nto mo<e j@ przyj@^.", // 159
	"Sto dolc*w!!!", // 160
	"Krwi!!!", // 161
	"Nie chc# wyj$^, chc# krwi!", // 162
	"Jestem <a%osnym pajacem.", // 163
	"Dziwne, ale ta szuflada si# zacina,\nje$li szuflada obok jest otwarta...", // 164
	"Mo<e to nie s@ zwyk%e szuflady!", // 165
	"Nie mog# otworzy^ szuflady, je$li\njaka$ obok jest otwarta!", // 166
	"Ma niebieskie wn#trze.", // 167
	"Ma czerwone wn#trze.", // 168
	"Ma szare wn#trze.", // 169
	"Ma zielone wn#trze.", // 170
	"Ma br@zowe wn#trze.", // 171
	"Ma r*<owe wn#trze.", // 172
	"]a%! W $rodku jest dyktafon!", // 173
	"Le<y tu polaroid!\nMog# go potrzebowa^.", // 174
	"Co$ nie puszcza ksi@<ki!", // 175
	"]a%! Tajna skrytka!", // 176
	"Nie musz# ju< z tym nic miesza^.", // 177
	"Pe%na automatyzacja.", // 178
	"Na razie nie potrzebuj#\ndalszych kartek.", // 179
	"Nie, nie chc# deprawowa^ ma%oletnich.", // 180
	"Nie chc# czyta^ jej znowu.\nJeszcze mi si# spodoba.", // 181
	"W%a$nie skojarzy%em, <e telewizor jest\nwy%@czony.", // 182
	"Nic si# nie sta%o.", // 183
	"Ta$ma odpali%a!", // 184
	"Znacznie lepiej.", // 185
	"Nie chc# i$^ spa^.", // 186
	"To tylko jaki$ korek.", // 187
	"Nie potrzebuj# wi#cej zdj#^.", // 188
	"Taaa, mog# to nagra^ i straszy^\ntym koty.", // 189
	"Ju< nagra%em to, co chcia%em.", // 190
	"Nie mog# nic nagra^, dop*ki nie znajd#\njakich$ baterii.", // 191
	"Nie ma baterii, nie ma zabawy.", // 192
	"Teraz chyba nie jest najlepszy moment.", // 193
	"Dop*ki ten kuchcik jest tutaj,\nnie mog# nic zrobi^.", // 194
	"Butelka jest podobna, ale\nto raczej nikogo nie oszuka.", // 195
	"Chcia%em je rozwali^, a nie\nrozwa%kowa^!..", // 196
	"Zawsze by%em ciekawy, co jest w $rodku\ntakich rzeczy.", // 197
	"Inne resztki nie s@ interesuj@ce.", // 198
	"]a%! P*%torej-woltowe baterie!", // 199
	"To jest ju< zaj#te, OK?", // 200
	"To si# w ko=cu sta%o. Oszala%em.", // 201
	"Papier kompletnie si# spali%!", // 202
	"P%o=, kochanie, p%o=!", // 203
	"Voila.", // 204
	"Za gor@ce!", // 205
	"Przymarz%o do p*%ki!", // 206
	"Pychota.", // 207
	"I tak nie lubi# wo%owiny.", // 208
	"Nie ma powodu, <eby to robi^.", // 209
	"Ju< go oszuka%em \'w tym temacie\'.", // 210
	"Czesiu, przeprowad> test g%osu.", // 211
	"Nie oszukam Czesia MOIM g%osem.", // 212
	"...laseczkaaaa!...", // 213
	"Czesiu, pu$^ szybko test zapachu.", // 214
	"Czesiu, dawaj no test wygl@du.", // 215
	"\'Sekretny dziennik Ci@gwy. Autoryzowany.\'", // 216
	"Nie mog# si# tu schowa^!", // 217
	"Ci@gwa jest na zewn@trz! Nie mog# wyj$^!", // 218
	"Ma%o brakowa%o.", // 219
	"Korek twardo siedzi w zlewie.", // 220
	"Pasuje idealnie!", // 221
	"W zlewie jest ju< do$^ wody.", // 222
	"W zlewie nie ma gor@cej wody.", // 223
	"Naklejka odpad%a!", // 224
	"Korek jest troch# za ma%y.", // 225
	"Nie musz# ich pr*bowa^ teraz.", // 226
	"Nie chc# zrobi^ z siebie sa%atki.", // 227
	"Eee tam...", // 228
	"Lepiej najpierw zatrzyma^ wentylator.", // 229
	"Najpierw musz# z%apa^ Ci@gw#.", // 230
	"Dobrze, <e to czerwone, to tylko chilli...", // 231
	"Woda wygl@da na bardzo gor@c@.", // 232
	"Zlew jest pe%en gor@cej wody.", // 233
	"Nie mam niczego, w co\nm*g%bym zapakowa^ te\nskarpetki.", // 234
	"Oto moje papiery.", // 235
	"Ju< dosta%em zezwolenie.", // 236
	"\'Oszcz#dzanie jest wspania%e. Zw%aszcza, je$li\nto zrobili ju< za ciebie rodzice\'", // 237
	"\'Kocham kapitana\'", // 238
	"\'MKS rz@dzi\'", // 239
	"\'Nie wycinaj drzew, bo i ty mo<esz\nzosta^ partyzantem\'", // 240
	"\'Przyjmujemy karty VISA\'", // 241
	"Reszta graffiti jest wulgarna.", // 242
	"Szpana, jestem Marek. Nowy.", // 243
	"Zamkni#te!", // 244
	"Dzi#ki.", // 245
	"Teraz nie mam poj#cia, co\nm*g%bym z tym zrobi^.", // 246
	"Mam pewien pomys%...", // 247
	"Jeszcze musz# sprawdzi^, czy to dzia%a...", // 248
	"Chyba czas zawo%a^ kapitana...", // 249
	"Hej! Sko=czy%em je$^!", // 250
	"Rany, przysma<y% si# do miski!...", // 251
	"Mam ci#.", // 252
	"Nie chc# mu wi#cej szpera^\nw kieszeniach.", // 253
	"To nie dzia%a.", // 254
	"Piku$.", // 255
	"No i jak ja mam teraz wr*ci^?", // 256
	"Ekstra.", // 257
	"No tak, racja...", // 258
	"Nie mog# go wyci@gn@^.", // 259
	"Nie chc# go dotyka^ - mo<na %atwo si# skaleczy^.", // 260
	"Ogrodzenie blokuje dost#p...", // 261
	"Nie potrzebuj# snu.", // 262
	"Nie mog# dosi#gn@^.", // 263
	"Halo?", // 264
	"Totalnie si# uzale<ni%.", // 265
	"A co z nowym...", // 266
	"...gor@cym...", // 267
	"...kolorowym...", // 268
	"...specjalnym wydaniem...", // 269
	"...\'Tygodnia }o%nierza\'?!", // 270
	"Nigdy wi#cej!", // 271
	"Jeden raz wystarczy. W ko=cu nie jestem\na< tak zdesperowany...", // 272
	"Trzydzie$ci siedem przekle=stw p*>niej...", // 273
	"mczasem w posiad%o$ci...", // 274
	"Teraz jest otwarta.", // 275
	"Dawaj, dziecinko, to wszystko\ntwoje!", // 276
	"Na razie nie mam z nim o czym\nrozmawia^.", // 277
	"Ta... Racja!...", // 278
	"Barman jest za blisko...", // 279
	"Ble!", // 280
	"Wol# wod#.", // 281
	"Nie dam rady si# na ni@ wdrapa^.", // 282
	"Spr#<yny k%u%yby mnie w plecki.", // 283
	"Nie, dzi#ki. To <arcie chyba jeszcze <yje.", // 284
	"Drzwi s@ zamkni#te. Co za niespodzianka.", // 285
	"W $rodku nie ma nic ciekawego.", // 286
	"Powinienem bardziej uwa<a^ na gegrze...", // 287
	"Niczego st@d nie potrzebuj#.", // 288
	"Dzi#ki, widzia%em ju< bardziej mi#kkie kamienie.", // 289
	"}aden z nich u<ytek, s@ zbyt t#pe.", // 290
	"Jaka pociecha z modeli?", // 291
	"Barman na pewno zauwa<y%by jego\nznikni#cie.", // 292
	"Nie dam rady wypi^ tego wszystkiego.\nMo<e na koniec...", // 293
	"Nie jestem z%odziejem. Zreszt@,\ni tak jest pusta.", // 294
	"Nie mam ochoty ich przeszukiwa^.", // 295
	"Kapitan na pewno si# w nich nie zmie$ci%.\nMusz# szuka^ gdzie indziej.", // 296
	"Stch*rzy^? Ja? Nigdy!", // 297
	"Nie mog# otworzy^.", // 298
	"Nie potrzebuj# ich.", // 299
	"Brzydko jest podgl@da^.", // 300
	"Kieszenie mam du<e, ale istniej@ jakie$ granice.", // 301
	"Jak j@ za%o<#, mog# mie^\nk%opoty z wchodzeniem\npo schodach.", // 302
	"}eby je wszystkie przeczyta^, musia%bym\nmie^ z 9 <y^!", // 303
	"Nie potrzebuj# odpoczynku.", // 304
	"W pokoju jest wystarczaj@co jasno.", // 305
	"Nie uniesie mojej wagi.", // 306
	"Nigdy si# nie nauczy%em obs%ugiwa^\ntakich rzeczy...", // 307
	"S@ tak ostre, <e poprzecina%yby mi kieszenie!", // 308
	"Pfuj! Ten koniak na pewno zepsu% ca%y smak...", // 309
	"Nie mam czasu na przyjemno$ci.", // 310
	"Nie dotkn# tych skarpetek go%ymi r#kami!", // 311
	"To nie Halloween.", // 312
	"Nie da si# sterowa^ r#cznie. Nienawidz# go!", // 313
	"Nie mam nic do puszczenia.", // 314
	"Nie mog# go wzi@^. Nie jest moje.", // 315
	"Hej! O co chodzi?!", // 316
	"Otwarte!", // 317
	"Zepsuty.", // 318
	"Przy kapitanie?... Lepiej nie...", // 319
	"Sierp jest za t#py.", // 320
	"Najpierw mam tu co$ do za%atwienia.", // 321
	"Wydziabanie tego no<em mog%oby\ntrwa^ sto lat.", // 322
	"Nie mam zamiaru dodatkowo\nza$mieca^ stolik.", // 323
	"Mam rzuca^ mu okruszki\nwprost do dziubka?!\nNie trafi#!", // 324
	"Szkoda takich fajnych okruszk*w.", // 325
	"Lepiej nie... Jeszcze podczas nabierania\npo$lizgn# si# i wpadn#...", // 326
	// "Sk@d ja znam ten g%os?... Ach, te firmy\nsoftware\'owe i ich niski bud<et...",
	"\"Niebieskie ko%nierzyki\".", // 327
	"\"Manchester United, czyli historia\nCzerwonych Diab%*w\".", // 328
	"\"Jak zrobi^ Urz@d Skarbowy na szaro\".", // 329
	"\"Zielone ludziki s@ w$r*d nas\".", // 330
	"\"Odbr@zawianie mit*w\".", // 331
	"\"R*<owa Pantera: nieautoryzowana biografia\".", // 332

	"(U<ycie tych dw*ch rzeczy razem nie\nprzyniesie korzy$ci).",
};

const static char *czechMessages[kNumMessages] = {
	"Nem#m tu@en;, co bych s t;m mohl d+lat.", // 0
	"Mu$te m+, ale nevim co by s t;mhle @lo\nud+lat.", // 1
	"Nejde mi do hlavy, na co by tohle bylo\ndobr*. Hmm...", // 2
	"Tohle rad@i nech#m b^t jak to je.", // 3
	"Bezva.", // 4
	"To je na nic.", // 5
	"Bezva! V bedn+ se v#lel hever!\nChe!", // 6
	"Ah#, je tam schovan^ je@t+ n+co! Polez ven...\nFrancouzskej kl;$!", // 7
	"Posledn;\n@ance?", // 8
	"Vzd#v#m to.", // 9
	"Ne, ne, od t+ch vos si m;n;m dr{et\naspo< p+timetrovej odstup!", // 10
	"V lo%ce je u{ jenom tma.", // 11
	"P>;li@ tuh^ d>evo na to, aby se dalo zlomit.", // 12
	"Baf!", // 13
	"Nemysl;m si, {e bych m+l pokou@et\nsv* @t+st;.", // 14
	"Jenom takov# oby$ejn# kupa sena.", // 15
	"Che, a to se >;k#, {e jehlu\nv kupce sena nenajde@.", // 16
	"~#dn^ dal@; raj$ata\nu{ se nekonaj.", // 17
	"No jo, v{dycky jsem po mamce cht+l\nkalhoty s velk^ma kapsama...", // 18
	"~ivot je n+kdy tvrdej.", // 19
	"~ivot je n+kdy fakticky tvrdej.", // 20
	"N+co m+ lochtalo!\nNo co $um;te? N+co m+ lochtalo!", // 21
	"Kone$n+ je ta \\chyln# v+c pry$.", // 22
	"Kdo v; co se tam kr$; za p>;@eru\nmo{n# n+jakej Beast...", // 23
	"Rad@i tam nebudu strkat ruce, nejsem masochista.\nN+co by mi je mohlo ukousnout\n(bl**)!", // 24
	"Vidim, {e nic nevidim...", // 25
	"Ruka, noha, hlava OK, nic zlomen^ho.\nAle na dal@; pokus to nevidim.", // 26
	"Podruh^ u{ ani zlat^ pr..\nza modr^ z nebe!", // 27
	"To vypad# na kost n+jk^ho po>#dn^ho macka.", // 28
	"Uh! To muselo set>#st om;tku\nze v@ech st+n okolo!", // 29
	"Je tu jak v Jir#skov+ temnu.", // 30
	"No podruh^ u{ tu potm+ @#trat\nrozhodn+ nebudu.", // 31
	"To, {e jsem naho>e zabouchnul poklop odlepilo\nn+jakej plivanec ze st+ny a je tu tla$;tko!", // 32
	"Promi<, ale musim si p]j$it\ntvoje fe@n^ brejle.", // 33
	"M-mmm, tady se {#dn^ pot#p+n; konat nebude...", // 34
	"Tady ne...", // 35
	"Pod vodou mi n+jak ne@lo mluvit...", // 36
	"Tam p>eci v]bec nic nebylo, pro$ bych tam m+l plavat?", // 37
	"To vypadalo zaj;mav+, ale bohu{el u{ se mi jaksi\nnedost#valo vzduchu, abych se tam pod;val...", // 38
	"...a po velk*m z#polen; jsem vylovil kotvu!", // 39
	"Mo>sk^ >asy mi nejedou od t^ doby, co jsem vid+l,\njak si v^chodn; N+mci ulevuj; do mo>e...", // 40
	"Mo{n# v t*hle lo%ce ryby v noci\npo>#daj; mal* ryb; orgie.", // 41
	"}ekl bych, {e tam dole mus;m n+co ulovit.\nAle co?", // 42
	"Mysl;te, {e si ryby n+kdy kupujou de@tn;ky?", // 43
	"Douf#m, {e tohle plav#n; nen; jen takov#\nslep# uli$ka.", // 44
	"Tam dole je to p+kn^.", // 45
	"Magore, co to d+l#@?!", // 46
	"Aaaaaaaaaaaaaahhh!...", // 47
	"Je{i@!", // 48
	"Lidi nechaj j;dlo tam, kde jim \nod huby upadne.", // 49
	"P==[, m#m tu pro tebe n+co m==c\ndobr^ho...", // 50
	"Tu ne$apnu!", // 51
	"Zamotala se do kapesn;ku!", // 52
	"OH!", // 53
	"Ta m# ale nervy, mrcha, j# m#m ale del@;!", // 54
	"V t+ch @upl;k#ch se u{ kr$; jen tma.", // 55
	"Nejd>;v si to mus;m vy>;dit s t;mhle ke>;kem.", // 56
	"My@ pr#skla do tlapek!", // 57
	"Nesmysl.", // 58
	"Kl;dek, j# tu jenom lap#m vzduch...", // 59
	"Tum#@, papej.", // 60
	"A te% u{ jsme k#mo@i, ale nic intimn;ho!", // 61
	"Taky si m]{u leda tak vykopat hrob.", // 62
	"O sto uhynul^ch minut pozd+ji...", // 63
	"A dal@;ch sto uhynul^ch minut pozd+ji...", // 64
	"Kone$n+ jsem na@el lo{isko ropy, sem \nbohatej!", // 65
	"Hmmm, bohatej, kulov^!", // 66
	"!?&!", // 67
	"Ale d+do, p>ece si mi sl;bil..", // 68
	"Ach no jo, tak teda jdeme.", // 69
	"Nashle.", // 70
	"Ermm, tak teda navid+nou.", // 71
	"Probl*m: nikdy jsem nev+d+l, jak\nkecat s holkama...", // 72
	"Oby$ejn+ ned+l#m v+ci, kter* ned#vaj; smysl.", // 73
	"Jenom o>ech je pravej.", // 74
	"Zaj;malo by m+, jestli slepice opravdu l;taj.\nPoj% ke m+ mil#@ku...", // 75
	"Prvn; test ne\\sp+@n^.", // 76
	"U{ sem se mindr#k] zbavil a druh^ test by stejn+\ndopadl stejn+.", // 77
	"Ne ne, tahle cesta nikam nevede.", // 78
	"Otev;r# kufr.", // 79
	"Pevn+ zav>enej.", // 80
	"Nic jin*ho u{ v kufru nen;.", // 81
	"Pr#dlo je te% such*, koho by to tak mohlo zaj;mat?", // 82
	"Ty vr#ny m+ pravd+podobn+ oklobou na kost!", // 83
	"Jestli se chci dostat dovnit>, mus;m se\nnejd>;v zbavit str#{n*ho, ale i kdy{ m#m\nmotorovou pilu, @el bych na to trochu jinak.", // 84
	"St+na je p>;li@ hladk#, aby se po n; dalo l*zt.", // 85
	"Mohl bych po n+m vyl*zt, ale na\nkmeni je n+jakej\nzelenej fujtabl, bl***.", // 86
	"Jedin* zelen^ v+ci, kter* je@t+ snesu, jsou takov*\nobd*ln;kov* pap;rky s d]le{it+ vypadaj;c;mi\nosobnostmi $um;c;mi na m+ mezi kulat^mi $;sly.", // 87
	"Nechci se toho dot^kat, mohl bych se po@kr#bat\na pak bych se nemohl... po@kr#bat.", // 88
	"D;k, ale nem#m hlad.", // 89
	"Tak dlouh* ruce opravdu nem#m.", // 90
	"Ostrov je moc daleko, abych tam mohl doplavat.", // 91
	"Ozv+na!", // 92
	"Ozv+na!", // 93
	"Kdo je tam?!", // 94
	"KDO JE TAM?!", // 95
	"     Neopakuj to po m+!...", // 96
	"        Neopakuj po mn+!!!", // 97
	"...Nebo tam dolu hodim k#men!", // 98
	"NEBO TAM...", // 99
	"Se@ po>#d tam?", // 100
	"Chyb; tu kompletn; kladka a nav;c\nnem#m {#dnej kybl;k.", // 101
	"Nepot>ebuju otev;rat okno, je@t+ d^ch#m.", // 102
	"Hmmm... Tr#va... Ale ne, mohly by to vid+t\n n+jak* mal* d+ti.", // 103
	"Takhle ten o>ech nenajdu.\nTr#va je p>;li@ hust#.", // 104
	"Nebudu tu troubit jen tak pro srandu kr#l;k]m.", // 105
	"Tak vysoko nevysko$im,\nproto{e b;l; mu{i er..., b;l; mu{i\nneum+j; sk#kat.", // 106
	"To nepot>ebuju (a vy taky ne).", // 107
	"Nejsem mikul#@.", // 108
	"Atrapy m+ z bryndy nepom]{ou.", // 109
	"Je p>;li@ k>ehk^, nem# smysl ho br#t s sebou.", // 110
	"Rad+ji je nech#m otev>en*.", // 111
	"Nejsem na tom tak b;dn+, abych se musel\nproch#zet v ciz;ch pono{k#ch.", // 112
	"A{ um>u.", // 113
	"Je to moc velk*, t+{ko n+co takov*ho\nbudu pot>ebovat.", // 114
	"~#dnej tajnej vchod za nima asi nebude\nLeda tak hejno plesnivejch pavouk].", // 115
	"~#dn* dal@; ovoce nevypad# zaj;mav+.", // 116
	"Malovan^ d{b#nku, te% m#@ na kah#nku,\nukradnu t+ a rozbiju t+!", // 117
	"Rad@i ho nech#m bejt, kdo v;, jestli\nta babka necvi$ila d{udo.", // 118
	"Zrcadlo, zrcadlo na st+n+,\nkdo je ze v@ech lid; nejchyt>ej@;?", // 119
	"Hej, nep>em^@lej tak dlouho.", // 120
	"Napov;m: n+kdo v tomhle pokoji...\na je mu{sk*ho pohlav;.", // 121
	"OK, nech#m ti $as na rozmy@lenou.", // 122
	"Rad@i ho nebudu vyru@ovat z p>em^@len;,\nmohlo by rupnout.", // 123
	"Se zuba>ema nechci m;t nic spole$n*ho,\nned#vno jsem hr#l hru Hell.", // 124
	"Moc t+{kej. Tykat si nebudeme.", // 125
	"Mrkneme se, co to tady m#me...", // 126
	"\'Jahodevej d{em\'.", // 127
	"\'Malinovej d{em\'.", // 128
	"\'Bor]vkovej d{em\'.", // 129
	"\'~ampi=novej d{em (?)\'.", // 130
	"Oupln# d{em#rna!", // 131
	"O==, a tady je poloplesnivej \'Veverkovej d{em!\'.", // 132
	"Jednu docela hodnou veverku zn#m,\n mo{n# z jej;ch sester.", // 133
	"Asi budu blinkat. Najd+te rychle n+jakej igeli[#k!", // 134
	"Vidim, {e nic nevidim.", // 135
	"AAA########!", // 136
	"U#u#u#u# (z;v#n;)", // 137
	"Che, che. H# ha H####.. CHE!", // 138
	"Moc ostr^ trny, po@kr#bal bych si ruce\na nemohl bych se.. v@ak v;te.", // 139
	"V pile bohu{el nen; palivo, tak{e trucuje.", // 140
	"Trny jsou moc tenk^, tady motorov#\npila nepom]{e. M-mmm.", // 141
	"No, mohl byl vz;t ten k#men a b+hat s n;m\ndokola. Hele, a nen; n+co pod n;m...?", // 142
	"Rad@i je nech#m b^t, mohli by m+ pokousat\nnebo dokonce zn#silnit!", // 143
	"Mo{n# u{ je tuhej, chov# se tak.", // 144
	"B]hv; jak^m jazykem tohle mluv;.", // 145
	"Musel bych dlouho hubnout, ne{ bych\ntam dok#zal str$it ruku.", // 146
	"Hej, vy! Vst#vat, bude pogroma na vr#ny!", // 147
	"Nem#m povolen; k prohl;dce.", // 148
	"Na t^hle kupce nevidim ani zbla zaj;mav*ho. Sorry.", // 149
	"Dostat se dovnit> nebude @#dn# @vanda.", // 150
	"Nem# to smysl, o>ech by mezi vyl#man^mi\nzuby ur$it+ proklouzl.", // 151
	"P#dlo je p>ece rozbit^.", // 152
	"Tahle v+tev nen; {#dn^ p#dlo, jak v#s to\nv]bec mohlo napadnout?", // 153
	"Rad@i to zkusim vedle, m#m takovej pocit, {e\nje tahle $#st st+ny dob>e hl;dan#.", // 154
	"Chci to nabrousit, ne rozdrtit.", // 155
	"K ni$emu m+ nedonut;te, je tady moc tma.", // 156
	"Hele, chce@ si trochu\np>ivyd+lat?", // 157
	"Je to oby$ejn# bankovka, ale n+kdo\nna n; zezadu napsal \"Nezapome< Ani$ko!\".\nAsi n+jakej \\chyl, nebo...?", // 158
	"Kdyby j; ty pen;ze jen tak uk#zal,,\nmohla by si myslet, {e si j; chci koupit.", // 159
	"P+t tis;c, to jest asi dva\na p]l tis;ce rohl;k]!!!", // 160
	"Chci krev!", // 161
	"Neodejdu z vily, dokud neproliju\nPankr#covu krev!", // 162
	"Tum de dum, tu de d###... nic jste nevid+li!", // 163
	"Divn^, kdy{ je jedno @uple otev>en^,\njin^ nejde otev>;t, hmm..", // 164
	"Mo{n# to nejsou jen tak oby$ejn^\n@uplata!", // 165
	"Nem]{u otev>;t druh* @uple,\nkdy{ u{ je jedno otev>en*. Pro$?", // 166
	"M# modr^ vnit>ek.", // 167
	"M# $erven^ vnit>ek.", // 168
	"M# @ed^ vnit>ek.", // 169
	"M# zelen^ vnit>ek.", // 170
	"M# hn+d^ vnit>ek.", // 171
	"M# r]{ovou$kou$k^ vnit>ek.", // 172
	"Ale ale! Tady se v#l; diktafon!", // 173
	"Vzadu n+co je. Fo[#k polaroid!\nM]{e se hodit.", // 174
	"N+co knihu dr{;, nem]{u s n; pohnout!", // 175
	"Vida! Tajn# skr^@, copak skr^v#@, tajn# skr^@i?", // 176
	"U{ se s nem#m na co d;vat.\nCopak doma nem#te video?", // 177
	"Pln+ automatick*.", // 178
	"Jeden pap;r mi sta$; ke @t+st;.\nJsem jednoduch^ $lov+k.", // 179
	"Opil bych se a mlel bych spros[#rny,\nco{ mi auto>i zak#zali.", // 180
	"Vsad;m se, {e tam bude naps#no to sam*,\nco minule.", // 181
	"Osah#v#n; vypnut* televize? Hmm, takov^ maniak nejsem.", // 182
	"Nic. V]bec nic.", // 183
	"P#ska se spustila!", // 184
	"To u{ je lep@;.", // 185
	"Korek vod vokurek.", // 186
	"Prachoby$ejn^ korek. Z korku, kulat^ a nez#{ivn^.", // 187
	"Jedna fotografie sta$;.", // 188
	"Jo, to si teda nahraju na zastra@ov#n;\npotuln^ch jehovist].", // 189
	"U{ jsem nahr#l, co byla pot>eba nahr#t.", // 190
	"Bez bateri; v diktafonu se {#dn* nahr#v#n;\nkonat nebude.", // 191
	"~#dn* baterie, {#dn# @vanda.", // 192
	"Ne>ekl bych, {e je pr#v+ te%\nten spr#vn^ moment.", // 193
	"Dokud tu oxiduje ten zpropadenej\nkucha>, nem]{u nic d+lat.", // 194
	"Lahev je to sice stejn#,\nale pochybuju, {e by na to kucha>\njen tak sko$il.", // 195
	"Cht+l jsem to jenom rozb;t,\na ne rozpl#cnout!..", // 196
	"V{dycky jsem byl zv+davej, co se\nv t+chto v+ci$k#ch skr^v#.", // 197
	"Z toho u{ {#dnej Gott nikdy >v#t nebude.", // 198
	"Ga ga ga! Dv+ 1.5-voltov* baterie!", // 199
	"Tahle lednice je u{ zabran#, OK?", // 200
	"Kone$n+ se to stalo, jsem @;len^!", // 201
	"Kurnik, pap;r doho>el!", // 202
	"Pap;r chytil a ho>;.\nRychle, kam s n;m?!", // 203
	"Gut.", // 204
	"Haisss, haisss, p#l; to!", // 205
	"P>imrzlo to k Poli$ce, mrcha jedna!", // 206
	"M<am.", // 207
	"Pol;vka \'Vyblitka\' bude tahkhle\nje@t+ pikantn+j@;.", // 208
	"~#dn^ d]vod pro$ tohle d+lat\nnikde bl;zko nepoletuje.", // 209
	"U{ jsem ho obelhal jednou.", // 210
	"Ludv;ku, aktivuj test hlasu.", // 211
	"Sv^m vlastn;m hlasem Ludv;ka neo@#l;m.", // 212
	"...zp;;;v###n;;;..", // 213
	"Ludv;ku, pust;me se do testu smradu,\nvlastn+ testu pachu.", // 214
	"Ludv;ku, je% vizu#ln; test!", // 215
	"\'Tajn^ di#> Pankr#ce Oblouka. Top Secret.\'", // 216
	"Tam se neschov#m!", // 217
	"Nem]{u ven, $apli by m+ a sn+dli!", // 218
	"Jen tak tak.", // 219
	"Korek zapadl do d;ry.", // 220
	"Pasuje perfektn+!", // 221
	"V umyvadle u{ je dost vody.", // 222
	"V umyvadle nen; {#dn# voda!", // 223
	"N#lepka se odlepila!", // 224
	"Korek je moc malej, neucpe to.", // 225
	"Te% sp;@ n+co na hlavu,\nt>eba heroin.", // 226
	"U{ takhle jsem sal#t, nechci bejt @pen#t.", // 227
	"Ne.", // 228
	"Byla by ze m+ fa@;rka.\nBlb+ by se to ukl;zelo ze st+n.", // 229
	"Rad@i nejd>;v $apnu Pankr#ce Oblouka.", // 230
	"Douf#m, {e to $erven^ je jenom chilli...", // 231
	"Voda vypad# opravdu \'horce\'.", // 232
	"Do umyvadla natekla hork# voda.", // 233
	"Nem#m nic, do $eho bych\nty plesniv* pono{ky mohl zabalit.", // 234
	"Tady jsou moje pap;ry.", // 235
	"Nen; t>eba vytahovat se\ns povolen;m dvakr#t.", // 236
	"\'Ahoj brou$ku, m#m r]{ovou$k^ pr#dlo\na hlav$u plnou bezvadnejch my@lenek.\nCinkni na 05 535 113\'", // 237
	"\'Dungeon Master II je bomba!\'", // 238
	"\'Vochozka je.. (cenzurov#no)\'", // 239
	"\'Je to $erven^ a je to na p=diu?\nCo je to?\nKULTURN; VLO~KA!\'", // 240
	"\'Orgie po>#dan* redakc; Score\nse konaj; v{dy ve $tvrtek...\'", // 241
	"Zbytek n#pis] je p>;li@ perverzn;.", // 242
	"Pane veliteli, jsem Marek. Zelen#$.", // 243
	"Hrome, zam$eno!", // 244
	"D;k.", // 245
	"No, nev;m co bych s t;m mohl d+lat\npr#v+ te%.\nLeda tak ob+sit se.", // 246
	"M#m n#pad, sledujte m+..", // 247
	"Te%ko mus;m vyzkou@et, jestli to funguje...", // 248
	"}ekl bych, {e je $as zavolat kapit#na...", // 249
	"Hej! U{ jsem to vyl;zal do sucha!", // 250
	"Tak a te% se p>ifa>il k misce!...", // 251
	"N+co m#m!", // 252
	"Na jeho kapsy\nu{ nem;n;m @matat.", // 253
	"To asi nep]jde.", // 254
	"Levou rukou.", // 255
	"A jak se m#m dostat zp#tky?", // 256
	"Taky to @lo.", // 257
	"Jo, j# vim...", // 258
	"Nejde to vyt#hnout.", // 259
	"Hal=, vy tam p>ed obrazovkou, u{ jste n+kdy,\nrukama p#rali dr#t+nej plot?", // 260
	"Plot stoj; v cest+\nJen tak si stoj;, stoj; si tam...", // 261
	"Rad@i ne, co kdy{ je to sklad mrtv^ch.", // 262
	"Nedos#hnu tam.", // 263
	"Hal=?", // 264
	"Je \\pln+ mimo.", // 265
	"Co{ takhle d#t si..", // 266
	"...$erstv+ vy@l*...", // 267
	"...pln+ barevn*...", // 268
	"...extra vzru@uj;c;..", // 269
	"... \'Vojensk* Noviny\'?!", // 270
	"Roch<a$ka!", // 271
	"Jsem snad n+jakej vysava$?!", // 272
	"          Po dlouh*m a ohavn*m klen;...", // 273
	"Zat;m ve vile...", // 274
	"Te% je otev>eno.", // 275
	"Poj%, ptakovit* stvo>en;, je to ba@ta!", // 276
	"Te% zrovna nevypad# p>;li@ konzerva$n+,\nehm, konverza$n+.", // 277
	"Tak, te% to jenom nepokazit...", // 278
	"Barman je moc bl;zko...", // 279
	"Fuj!", // 280
	"J# rad@i vodu.", // 281
	"Nejsem kobylka, sko$te si to sami.", // 282
	"Lezouc; p*ra by ze m+ nad+laly >e@eto.", // 283
	"Ne d;ky, to j;dlo je po>#d je@t+ {iv^.", // 284
	"To je ale p>ekvapen;, nejdou otev>;t!", // 285
	"Jenom t>i kr#li$; bobky a pou{it^ toaletn; pap;r.\nNez#jem.", // 286
	"Nem]{u naj;t Prahu, mo{n# u{ ji p>ejmenovali\nna n+co, co se N+mc]m l*pe vyslovuje.", // 287
	"Binec, {e by se dal fotit do aktualit.", // 288
	"D;k, ale u{ jsem vid+l m+k$; kameny.", // 289
	"Tup^ a m#lo zahnut^. Turci vym;raj.", // 290
	"Na co by mi byly mod^lky zbran;?", // 291
	"Barman by si ur$it+ v@iml, {e hrn;$ek\nvzal roha.", // 292
	"Vo{;rat se budu, a{ tuhle hru dohraju.\nPak si tu d#me zpicha a vypijem to v@echno!", // 293
	"J# nekradu! A nav;c je stejn+ pr#zdn#.", // 294
	"Toho je na mn+ trochu moc a nem#m lupu.", // 295
	"Na ty je kapit#n moc tlustej.\nKdo hled# najde, ale ne tady.", // 296
	"Pr#sknout do bot? Nikdy!", // 297
	"Nejde to otev>;t.", // 298
	"Nepot>ebuju.", // 299
	"Nejsem {#dnej sebeukaje$ $um+n;m do d+r!", // 300
	"Kapsy m#m sice po>#dn^, ale maj sv]j limit.", // 301
	"Kdybych si to obl*kl, cesta ze schod] by se\npravd+podobn+ stala osudovou.", // 302
	"Bohu{el nejsem knihomol, aspo< bych si mohl\njuchnout radost;.", // 303
	"Tv#>; se l#kav+. Ale j# nechci j;t \'sed+t\'.", // 304
	"Sv+tla dost, sta$; jen nezav;rat o$i.", // 305
	"Moje @peky tahle @unka neunese.", // 306
	"Nem#m r#d mikrovlnky, tak{e\ns nima neum;m zach#zet.", // 307
	"Jsou tak ostr^, {e by mi pro>ezaly kapsy.", // 308
	"Ko<ak se sna{il, ale moc tomu nepomohl..", // 309
	"C;tite po>ebu zbavit se @p;ny {ivota?\nJ# ne.", // 310
	"Nejsem masochista, ty pono{ky jsou ve\nst#diu rozkladu. Rukama ne!", // 311
	"Na Masku p]jdu rad@i do kina.", // 312
	"Sakra, je to JENOM na d#lkov* ovl#d#n;!", // 313
	"Nem#m s sebou ani Depe@#ky ani Oldfielda.", // 314
	"Nen; to moje. Sta$ilo,\n {e jsem zvedl tu bankovku.", // 315
	"Hej! Co je?!", // 316
	"Je otev>eno!", // 317
	"Nefunguje.", // 318
	"Kdy{ se d+dek d;v#?...\nRad@i ne...", // 319
	"Srp je tupej, mus; se o n+co nabrousit.", // 320
	"Nejd>;ve je tu n+co jin*ho,\no co se mus;m postarat.", // 321
	"Rejpat do toho no{ejkem by trvalo\ntak sto - dv+ st+ let.", // 322
	"Na stole je u{ takhle p+knej\nbinec, net>eba tomu pom#hat.", // 323
	"To m#m ty drobky jako HODIT nahoru?\nTo snad ne.", // 324
	"Takov^ p+kn^ drobky, p>ece bych je \nnevyplejtval takhle zbrkle.", // 325
	"Rad@i ne, mohl bych tam spadnout a obahnit se.", // 326
	"\"Historie Blues\".", // 327
	"\"Manchester United neboli p>;b+h Rud*ho %#bla\".", // 328
	"\"Vl$#ci a jin; love$t; psi\".", // 329
	"\"Zelen#$ neboli moje dob^v#n; divok*ho z#padu\".", // 330
	"\"Charlie Brown and jeho spole$nost\".", // 331
	"\"R]{ov^ Panter: neleg#ln; biografie\".", // 332

	// Combine error message
	"Tyto dva p>edm+ty nejdou dohromady,\nnejdou a nejdou a nejdou. GRR! (to chce klid) ",
};

const static char *russianMessages[kNumMessages] = {
	"Bfh pon\200si\200, xso r ~sim eflas}.\x1f\x1f\x1f", // 0
	"Mnf sqteno pqietmas}, xso r ~sim\neflas}.\x1f\x1f", // 1
	"Nf modt pqfersacis}, xso r\n~sim eflas}.\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 2
	"Nt i na koj mnf r ~sim\nrc\200h|cas}r\200.\x1f\x1f\x1f\x1f\x1f", // 3
	"Cfz}.", // 4
	"Sak nf poje>s.\x1f", // 5
	"Tv s|! Cntsqi eomkqas!\nHeoqoco!\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 6
	"Cntsqi \200zika fz> xso-so frs}!\nKl\177x!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 7
	"Bfh\nobie?\x1f\x1f\x1f", // 8
	"Rea\177r}.\x1f\x1f\x1f", // 9
	"` nf poeojet k ~sim px>lam bligf xfm\nna p\200s} mfsqoc!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 10
	"C loekf bol}yf nixfdo nfs.\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 11
	"^so efqfco oxfn} rlogno lomas}.", // 12
	"^j!\x1f\x1f", // 13
	"Cq\200e li rsois pqocfq\200s}\nteaxt.\x1f\x1f\x1f\x1f\x1f\x1f", // 14
	"Ob|xn|j rsod rfna. Sfpfq}.\x1f\x1f\x1f\x1f\x1f\x1f", // 15
	"A fz> docoq\200s, xso nfl}h\200 najsi\nidlt c rsodf rfna.\x1f\x1f", // 16
	"Hefr} bol}yf nfs\nkaqsoyki.\x1f", // 17
	"Nf hq\200 \200 pqoril t mam|\nysan| r bol}yimi kaqmanami...\x1f\x1f\x1f\x1f", // 18
	"Sakoca gihn}.\x1f\x1f", // 19
	"Gihn} cpqacet gfrsoka.", // 20
	"Mfn\200 xso-so\nzfkoxfs!\x1f", // 21
	"Cqoef pqonfrlo.\x1f\x1f\x1f\x1f", // 22
	"Kso hnafs, kakif xteiza\nsts modts obisas}...", // 23
	"Qtki ltxyf stea nf rocas}.\nA so fz> kso-nibte} tktris\n(b-q-q)!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 24
	"Kak cieim, sts rocrfm\nptrso.\x1f", // 25
	"Oein yad el\200 xflocfka\ni odqomna\200 bol} el\200 doloc|.\x1f\x1f\x1f\x1f\x1f", // 26
	"Nf voxt rnoca irp|s|cas}\nrte}bt...\x1f\x1f\x1f\x1f\x1f\x1f", // 27
	"^so kors} einohacqa, \200\nnaef\177r}...\x1f\x1f\x1f\x1f\x1f", // 28
	"Odo! ^so eolgno qaryasas}\ncrf rorfenif rsfn|!\x1f\x1f\x1f", // 29
	"Hefr} sfmnocaso.\x1f\x1f\x1f\x1f\x1f", // 30
	"Nf robiqa\177r} rnoca bqoeis} sts\nc pos>mkav.\x1f\x1f\x1f\x1f\x1f", // 31
	"Os vlopka ecfqwfj oscalilar} dq\200h},\nrkq|cacya\200 c|kl\177xasfl} na rsfnf!\x1f\x1f\x1f\x1f", // 32
	"Pqorsi, pqi\200sfl}, no mnf ntgn|\nscoi oxki.", // 33
	"Nf ramof ltxyff mfrso el\200 n|q\200ni\200...\x1f", // 34
	"Nf hefr}...", // 35
	"` nf modt docoqis} poe coeoj!..\x1f\x1f\x1f", // 36
	"Cq\200e li ktpanif sam rsois posqaxfnn|v trilij.\x1f\x1f\x1f\x1f", // 37
	"Frli \200 voxt eorsas} \200koq}, ntgno pl|s} stea r\nbol}yim haparom cohetva c l>dkiv...\x1f\x1f\x1f\x1f", // 38
	"` rmod hawfpis}r\200 ha \200koq}!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 39
	"^si coeoqorli povogi na wcfs|, xso\n\200 eaqil mamf na efn} qogefni\200.\x1f\x1f\x1f\x1f\x1f", // 40
	"Insfqfrno, xso eflafs q|ba\nc loekf nox}\177.\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 41
	"Nacfqn\200ka, \200 rmodt sts xso-nibte}\nc|teis}.\x1f\x1f\x1f\x1f\x1f\x1f", // 42
	"Vos\200 b| q|bt eoge>m nf naptdas}.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 43
	"Naef\177r}, ~si rnarsi nf osclfka\177zij man>cq.\x1f\x1f\x1f\x1f\x1f\x1f", // 44
	"Voqoyo sam, cniht.\x1f\x1f\x1f", // 45
	"^j, osptrsi, a?!\x1f\x1f\x1f\x1f\x1f\x1f", // 46
	"A-a-a!..\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 47
	"Oj.\x1f\x1f", // 48
	"L\177ei orsacl\200\177s fet c nfcfqo\200sn|v mfrsav.\x1f", // 49
	"Iei r\177ea, t mfn\200 kof-xso frs}\nel\200 sfb\200.\x1f", // 50
	"Nf modt pojmas}!\x1f", // 51
	"M|y} c loctykf!\x1f\x1f\x1f\x1f\x1f\x1f", // 52
	"Oj!\x1f\x1f\x1f", // 53
	"A m|y} nf saka\200 i sqtrlica\200!\x1f\x1f\x1f", // 54
	"C \200zikav bol}yf nixfdo nfs.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 55
	"Rpfqca naeo ihbacis}r\200 os ktrsa.\x1f\x1f", // 56
	"M|y} tbfgala!\x1f\x1f\x1f\x1f\x1f\x1f", // 57
	"Bqfe.\x1f\x1f\x1f\x1f", // 58
	"` pon\200l. Voqoyij p>rik.\x1f\x1f", // 59
	"Efqgi.\x1f\x1f\x1f\x1f", // 60
	"Naef\177r}, m| eqth}\200.\x1f\x1f\x1f\x1f\x1f\x1f", // 61
	"Romnfca\177r}, xso ~so ntgnof mfrso.\x1f\x1f\x1f\x1f\x1f", // 62
	"Rso mdnocfnij rptrs\200...\x1f", // 63
	"I fz> rso mdnocfnij rptrs\200...\x1f\x1f\x1f", // 64
	"Vos\200 b| nay>l nfus} i rkoqo\nqahbodasf\177.\x1f\x1f\x1f\x1f\x1f", // 65
	"Iqoni\200 rte}b|.\x1f", // 66
	"!?&!", // 67
	"No efea, s| gf obfzal!..\x1f\x1f\x1f\x1f\x1f", // 68
	"Ov, nt laeno. Poyli.\x1f\x1f\x1f\x1f", // 69
	"Pa.\x1f", // 70
	"Nfhaxfm pocsoq\200s}.\x1f\x1f\x1f\x1f\x1f", // 71
	"` cpqacet nf tmf\177 docoqis} r\nefctykami...\x1f\x1f", // 72
	"` ob|xno nf qabosa\177 bfh x>skoj wfli.\x1f\x1f\x1f", // 73
	"Rtzfrsctfs liy} oqfv.", // 74
	"Thnafm, lfsa\177s li ktq|. Iei-ka\nr\177ea...\x1f\x1f\x1f\x1f\x1f\x1f", // 75
	"Nf hax>s.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 76
	"` tgf c|ptrsil paq.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 77
	"Nfs, ~so eoqoda c niktea.\x1f\x1f\x1f", // 78
	"Oskqofs badagnik.\x1f", // 79
	"On hapfqs.\x1f\x1f\x1f\x1f\x1f\x1f", // 80
	"C badagnikf bol}yf nixfdo nfs.\x1f\x1f\x1f", // 81
	"Oefgea tgf c|rovla.\x1f\x1f\x1f\x1f\x1f", // 82
	"Tcfqfn, coqon| mfn\200 hakl\177\177s!\x1f\x1f\x1f\x1f\x1f\x1f", // 83
	"Frli \200 voxt popars} cntsq}, ntgno ihbacis}r\200\nos ovqannika ili najsi eqtdoj\npts}.\x1f\x1f", // 84
	"Rsfna rliykom dlaeka\200, xsob| poen\200s}r\200.\x1f", // 85
	"` rmod b|\nhabqas}r\200, bte}\nsts mfn}yf rmol|.\x1f\x1f\x1f\x1f", // 86
	"` l\177bl\177 liy} oent hfl>nt\177 cfz}, pq\200motdol}n|j\nktroxfk btmadi r kakim-libo cagn|m\npolisikom c wfnsqf.\x1f", // 87
	"Nf voxt fdo sqodas}. Kol\177xki modts\npokolos} moi nfgn|f qtki.\x1f\x1f\x1f\x1f", // 88
	"Rparibo, \200 nf doloefn.\x1f", // 89
	"Moi qtki nf narsol}ko elinn|f.\x1f\x1f\x1f\x1f\x1f\x1f", // 90
	"Stea ealfkocaso pl|s}.\x1f\x1f\x1f\x1f\x1f", // 91
	"^vo!\x1f", // 92
	"^VO!\x1f", // 93
	"Kso hefr}?!\x1f\x1f", // 94
	"KSO HEFR]?!\x1f\x1f", // 95
	"NF POCSOQ`J!..\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 96
	"NF POCSOQ`J!!!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 97
	"...ILI ` BQOYT STEA KAMFN]!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 98
	"ILI `...\x1f\x1f\x1f\x1f", // 99
	"Cr> fz> hefr}?\x1f\x1f\x1f\x1f\x1f\x1f", // 100
	"^so nf yaqmanka. I cfeqa\nhefr} nfs.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 101
	"Nfhaxfm ~so oskq|cas}.\x1f\x1f", // 102
	"Vm-m... sqacka... Nf, modts tciefs}\nefsi.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 103
	"Sak mnf oqfv nf najsi.\nSqaca rliykom dtrsa\200.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 104
	"Nf rsois.\x1f\x1f\x1f\x1f\x1f", // 105
	"Nikodea nf eopq|dnt,\n~-~... cfe} bfl|f\nnf tmf\177s pq|das}.\x1f\x1f\x1f\x1f\x1f\x1f", // 106
	"Mnf nf ntgno.\x1f\x1f\x1f", // 107
	"` nf Ransa-Klatr.\x1f\x1f\x1f", // 108
	"Plarsikoc|f kopii nf insfqfrt\177s.", // 109
	"Vqtpkof oparno noris} r roboj.\x1f\x1f\x1f", // 110
	"Ptrs} btefs oskq|so.\x1f\x1f\x1f\x1f\x1f", // 111
	"` nf robiqa\177r} qarvagicas}\nr xtgimi norkami.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 112
	"Rparibo, \200 nf trsal.\x1f\x1f", // 113
	"Oxfn} bol}yoj - i cq\200e li\nponaeobisr\200.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 114
	"Romnfca\177r}, xso cntsqi frs} sajn|j\nvoe.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 115
	"Sts bol}yf nfs insfqfrn|v uqtksoc.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 116
	"Frli ~so tkqaet, mfn\200 porae\200s.\x1f\x1f", // 117
	"Ltxyf orsacl\177. Gfnzin| rliykom\nxtcrscisfl}n| k wcfsam.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 118
	"Rcfs moj, hfqkal}wf, rkagi,\nkso crfv tmnff, pokagi?\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 119
	"^j, nf etmaj sak eoldo.\x1f\x1f\x1f", // 120
	"Poerkahka: kof-kso c komnasf,\npaqfn}.", // 121
	"Laeno, nf soqopir}.", // 122
	"Ltxyf nf btet\nmfyas}.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 123
	"` nf voxt imfs} nixfdo obzfdo\nr eansirsami.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 124
	"S\200gflfnna\200. I \200 cocrf nf plakra.\x1f\x1f", // 125
	"Ea t nar sts halfgi pociela...\x1f\x1f\x1f", // 126
	"Kltbnixnof.\x1f\x1f\x1f\x1f\x1f\x1f", // 127
	"`bloxnof.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 128
	"Fgfcixnof.\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 129
	"Rlicocof.\x1f\x1f\x1f\x1f\x1f\x1f", // 130
	"Nt \200 i clip!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 131
	"O, fz> sts qohmaqinocof.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 132
	"Hnacal \200 oent Qohmaqi.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 133
	"Nfnacigt ~si \"halipon|\".", // 134
	"Sfmno, vos} dlah c|koli.\x1f\x1f\x1f\x1f\x1f", // 135
	"T-A-A-A!\x1f\x1f\x1f\x1f", // 136
	"(rson)", // 137
	"(rmfv)\x1f\x1f\x1f\x1f", // 138
	"` nf modt ihbacis}r\200 os niv qtkami -\nyip| na cie oxfn} orsq|f.\x1f\x1f\x1f", // 139
	"C bfnhopilf nfs soplica.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 140
	"Yip| rliykom sonkif, bfnhopila\nsts bfrpolfhna.\x1f\x1f\x1f\x1f", // 141
	"Ea, oslixna\200 m|rl}. Ch\200s} kamfn} i\ndtl\200s} r nim. M-ea...\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 142
	"Ltxyf nf btet iv sqodas}, oni oxfn}\ntkqaya\177s ~so mfrso.\x1f\x1f\x1f\x1f\x1f", // 143
	"Romnfca\177r}, xso ono gicof.\x1f", // 144
	"Nf hna\177, na kakom \200h|kf ona docoqis.\x1f", // 145
	"E|qa rliykom thka\200 el\200 mofj qtki.\x1f\x1f\x1f\x1f\x1f", // 146
	"^j! Pqornir}! Psiw| napaea\177s!\x1f\x1f", // 147
	"T mfn\200 nfs oqefqa na ob|rk.\x1f\x1f\x1f", // 148
	"Nf cigt c ~som rsodf rfna\nnixfdo insfqfrnodo.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 149
	"Cr> nfmnodo rlognff.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 150
	"Bfrpolfhno, oqfv pqorkol}hn>s mfg\nhtb}fc dqabfl}.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 151
	"Cfrlo RLOMANO.\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 152
	"^sa cfska nf cfrlo. Ona na nfdo\neagf nf povoga.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 153
	"Ltxyf pop|sas}r\200 inaxf - ~sa rsoqona\nvoqoyo ovqan\200fsr\200.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 154
	"Ntgno fdo hasoxis}, a nf ihmfl}xis}.\x1f\x1f", // 155
	"Nf modt nixfdo sts eflas}, oxfn} sfmno.\x1f", // 156
	"Cos, eacaj nab}>m scoj\nkaqman.\x1f\x1f\x1f", // 157
	"^so kaka\200-so banknosa. Rsqanno,\nna nfj kso-so napiral \"NIKODEA!\nANNA\".\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 158
	"Frli \200 pokagt fj efn}di,\nona mogfs iv habqas}.\x1f\x1f", // 159
	"Rosn\200 bakroc!!!\x1f\x1f\x1f", // 160
	"Gaget kqoci!\x1f", // 161
	"` nf robiqa\177r} pokieas} orobn\200k,\n\200 gaget kqoci!\x1f", // 162
	"` galka\200 malfn}ka\200 plakra.\x1f", // 163
	"Rsqanno, no \200zik hafeafs, kodea\noskq|s rorfenij...\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 164
	"Cohmogno, ~so nf rocrfm ob|xn|f\n\200ziki!\x1f\x1f\x1f\x1f", // 165
	"` nf modt oskq|s} \200zik,\nfrli oskq|s rorfenij!\x1f\x1f\x1f\x1f", // 166
	"On cntsqi rinij.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 167
	"On cntsqi kqarn|j.\x1f\x1f\x1f\x1f\x1f\x1f", // 168
	"On cntsqi rfq|j.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 169
	"On cntsqi hfl>n|j.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 170
	"On cntsqi koqixnfc|j.\x1f\x1f\x1f\x1f\x1f", // 171
	"On cntsqi qohoc|j.\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 172
	"Odo! Cntsqi lfgis eiksouon!\x1f\x1f\x1f\x1f\x1f\x1f", // 173
	"Sts lfgis polaqoie!\nOn mogfs mnf pqidoeis}r\200.", // 174
	"C knidf xso-so pq\200sali!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 175
	"Tv s|! Sajn|j osrfk!\x1f\x1f\x1f\x1f\x1f\x1f", // 176
	"Mnf tgf nf ntgno r nim\ncohis}r\200.\x1f\x1f\x1f\x1f\x1f", // 177
	"O, acsomasika.\x1f\x1f", // 178
	"Maktlastq| mnf poka\nvcasis.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 179
	"Nfs, nf voxt poqsis} efsfj.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 180
	"Nfs gflani\200 xisas} rnoca.\nModlo ponqacis}r\200.\x1f\x1f\x1f", // 181
	"` pon\200l, xso sflfcihoq c|kl\177xfn.\x1f\x1f\x1f", // 182
	"Bfh solkt.\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 183
	"Karrfsa ckl\177xfna!", // 184
	"Sak namnodo ltxyf.\x1f", // 185
	"Nf voxt rpas}.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 186
	"Pqorso pqobka.\x1f\x1f\x1f", // 187
	"Bol}yf uoso mnf nf ntgno.\x1f\x1f\x1f\x1f", // 188
	"Ea, \200 modt ~so hapiras} i ptdas}\nkoyfk.\x1f\x1f\x1f\x1f", // 189
	"` tgf hapiral so, xso vosfl.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 190
	"` nixfdo nf rmodt hapiras}, poka nf najet\nbasaqfjki.", // 191
	"Bfh basaqffk nikak.\x1f\x1f", // 192
	"Nf etma\177, xso momfns poevoeis.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 193
	"Nixfdo nf poltxisr\200,\npoka pocaq q\200eom.\x1f\x1f\x1f\x1f", // 194
	"Vos} i bts|lka sa gf, cq\200e\nli \200 sak rmodt kodo-nibte}\nobmants}.\x1f\x1f", // 195
	"` voxt fdo qahbis}, a nf\nqaheacis}!..\x1f\x1f\x1f\x1f\x1f", // 196
	"Crfdea insfqfrocalo, xso cntsqi\nsakiv ystk.\x1f\x1f\x1f\x1f\x1f", // 197
	"Orsal}nof liynff.\x1f\x1f\x1f", // 198
	"O! 2 basaqfjki na 1,5C!\x1f", // 199
	"Hefr} han\200so, \200rno?\x1f\x1f", // 200
	"Nakonfw ~so pqoihoylo. ` roy>l r tma.\x1f", // 201
	"Btmada polnors}\177 rdoqfla!\x1f\x1f\x1f\x1f\x1f\x1f", // 202
	"Doqi, efska!\x1f\x1f\x1f\x1f\x1f", // 203
	"Ctal\200.", // 204
	"Nf kornts}r\200, gaqko!\x1f\x1f", // 205
	"Ono pqim>qhlo k polkf!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 206
	"N\200mki.", // 207
	"Nikodea nf l\177bil sfl\200sint.", // 208
	"Nfhaxfm sak eflas}.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 209
	"Oenage| \200 fdo tgf obmantl.\x1f\x1f", // 210
	"Majk, ckl\177xi pqocfqkt dolora.\x1f", // 211
	"Moim dolorom Majka nf obmants}.\x1f\x1f", // 212
	"...pooooo>s!...\x1f\x1f\x1f", // 213
	"Majk, haptrsi pqocfqkt\nhapava.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 214
	"Eacaj pqocfqkt obqaha.\x1f\x1f", // 215
	"\"Sajn|j enfcnik Egona Nosi\". R poepir}\177.\x1f\x1f", // 216
	"Sts nf rpq\200sas}r\200!", // 217
	"Rnaqtgi Egon Nosi! ` nf modt c|jsi!\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 218
	"Pqonfrlo!\x1f\x1f\x1f\x1f\x1f\x1f", // 219
	"Pqobka harsq\200la c oscfqrsii.\x1f\x1f", // 220
	"Oslixno poeoyla!\x1f\x1f", // 221
	"C qakocinf eorsasoxno coe|.\x1f\x1f\x1f\x1f\x1f\x1f", // 222
	"C qakocinf nfs doq\200xfj coe|.\x1f\x1f\x1f\x1f\x1f", // 223
	"^sikfska osrsala!\x1f\x1f\x1f\x1f\x1f\x1f", // 224
	"Pqobka rliykom mflka\200.\x1f\x1f\x1f\x1f\x1f\x1f", // 225
	"Rfjxar nf rsois i p|sas}r\200.\x1f\x1f\x1f\x1f\x1f", // 226
	"Xso-so nf voxfsr\200 pqfcqasis}r\200 c ralas.\x1f\x1f", // 227
	"Nfs...", // 228
	"Rnaxala rsois orsanocis} cfnsil\200soq.\x1f\x1f", // 229
	"Rnaxala ntgno pojmas} Egona Nosi.", // 230
	"Voqoyo, xso ~so crfdo liy} xili...\x1f\x1f\x1f\x1f\x1f", // 231
	"Coea, povogf, kip\200sok.\x1f\x1f\x1f", // 232
	"Qakocina polna doq\200xfj coe|.\x1f\x1f", // 233
	"Mnf nfktea pologis}\n~si norki.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 234
	"Cos moi btmadi.\x1f\x1f\x1f\x1f", // 235
	"` tgf poltxil qahqfyfnif.\x1f\x1f\x1f\x1f", // 236
	"\"Rbfqfgfni\200 - cfz} voqoya\200. Orobfnno\nfrli ha sfb\200 kop\200s qoeisfli\"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 237
	"\"L\177bl\177 kapisana\"", // 238
	"\"Utsbol qtlh\"", // 239
	"\"Nf qtbisf efqfc}\200, ceqtd\noenage| havosisf tjsi\nc paqsihan|\"\x1f\x1f", // 240
	"\"Crsac} kaqst\"\x1f", // 241
	"Orsal}n|f dqauuisi nfpqilixn|f.\x1f", // 242
	"R~q, \200 Maqk. Nocobqanfw.", // 243
	"Hapfqso!\x1f\x1f\x1f\x1f", // 244
	"Rparib.", // 245
	"Bfh pon\200si\200, xso rfjxar\nr ~sim\neflas}.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 246
	"Nasalkicafs na m|rl}...\x1f", // 247
	"Pqocfq\177, kak ~so qabosafs...\x1f\x1f\x1f\x1f\x1f", // 248
	"Ramof cqfm\200 hcas} kapisana...\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 249
	"^j! ` tgf poktyal!\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 250
	"Odo, on pqicaqilr\200 k mirkf!...\x1f\x1f\x1f\x1f", // 251
	"Rwapan.", // 252
	"Nf voxt bol}yf q|s}r\200\nc fdo kaqmanav.\x1f\x1f\x1f", // 253
	"^so nf qabosafs.\x1f\x1f", // 254
	"Paqa ptrs\200koc.", // 255
	"I kak \200 eolgfn cfqnts}r\200?\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 256
	"Laeno.", // 257
	"Nt ea, cfqno...\x1f\x1f\x1f", // 258
	"Nf modt c|sazis}.\x1f\x1f\x1f", // 259
	"Nf voxt pqikaras}r\200, a so fz> poqan\177r}.\x1f\x1f\x1f\x1f\x1f", // 260
	"Qfy>ska pqfdqageafs pts}...", // 261
	"` nf voxt rpas}.\x1f\x1f\x1f\x1f\x1f\x1f", // 262
	"Nf modt eorsas}.\x1f", // 263
	"^j?\x1f\x1f\x1f", // 264
	"On rliykom tclfx>n.\x1f\x1f\x1f", // 265
	"Kak narx>s...\x1f\x1f\x1f\x1f\x1f\x1f", // 266
	"nocodo rcfgfdo...\x1f\x1f\x1f\x1f\x1f\x1f", // 267
	"polnowcfsnodo...", // 268
	"rpfwc|ptrka...\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 269
	"\"Roleasrkiv nocorsfj\"?\x1f", // 270
	"Vcasis!\x1f\x1f\x1f\x1f\x1f", // 271
	"` sfbf kso? P|lfror?!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 272
	"Rptrs\200 67 bqann|v rloc...\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 273
	"C so gf cqfm\200 c orobn\200kf...", // 274
	"Tqa, oskq|so.\x1f", // 275
	"Eacaj, kqoyka, cr> el\200 sfb\200!", // 276
	"Nf cigt pqixin| docoqis} r nim\nrfjxar.\x1f\x1f\x1f\x1f\x1f\x1f", // 277
	"Ada, pqacea!..\x1f", // 278
	"Baqmfn oxfn} blihko...\x1f\x1f\x1f\x1f", // 279
	"S}ut!", // 280
	"Ltxyf b| coea.\x1f", // 281
	"Mnf ril nf vcasis clfhs}.", // 282
	"Pqtgin| modts pokolos} rpint.\x1f\x1f\x1f", // 283
	"Nfs, rparibo. Fea, povogf, fz> gica\200.\x1f\x1f\x1f", // 284
	"Ecfq} hapfqsa. Kaka\200 nfogieannors}.\x1f", // 285
	"Sts ptrso.\x1f", // 286
	"Rsoilo b|s} bolff cnimasfl}n|m\nna tqokav dfodqauii...\x1f\x1f\x1f\x1f", // 287
	"Mnf nfhaxfm ~sos vlam.\x1f", // 288
	"Rparibo, \200 ciefl kamni pom\200dxf.\x1f\x1f\x1f\x1f", // 289
	"Oxfn} stp|f - i cq\200e li pqidoe\200sr\200.\x1f", // 290
	"Kaka\200 os niv pol}ha?\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 291
	"Baqmfn nacfqn\200ka hamfsis\npqopagt.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 292
	"Ntgno nfmalo cqfmfni, xsob| cr> c|pis}.\nMogfs, porlf haeani\200...\x1f\x1f\x1f\x1f", // 293
	"` cfe} nf coq. I cr> qacno hefr} ptrso.\x1f\x1f\x1f\x1f\x1f", // 294
	"Iv rliykom mnodo, xsob pqocfqis} crf.", // 295
	"Kapisan r\177ea nf pomfrsisr\200.\nPoizt c eqtdom mfrsf.\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 296
	"Rsqtril? `? Nikodea!\x1f\x1f", // 297
	"Nf modt oskq|s}.", // 298
	"Oni mnf nf ntgn|.\x1f", // 299
	"` L\177bop|sna\200 Caqcaqa?\x1f\x1f\x1f\x1f", // 300
	"T mfn\200 bol}yif kaqman|, no nf bfheonn|f.\x1f", // 301
	"Frli \200 iv naefnt, btefs rlogno iesi\npo lfrsniwf.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 302
	"Xsob iv pqoxisas}, ntgno 9 gihnfj.", // 303
	"Rparibo, \200 fz> nf trsal.\x1f", // 304
	"Nfs ntge| ~so ckl\177xas}.\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 305
	"Ona cfris bol}yf mfn\200.\x1f\x1f", // 306
	"Nikodea nf tmfl fj pol}hocas}r\200.", // 307
	"Sakif orsq|f, xso ysan| modts qahqfhas}!", // 308
	"Ut! Os kon}\200ka nixfdo voqoyfdo nf gei...\x1f\x1f\x1f\x1f\x1f", // 309
	"Nfs cqfmfni qarrlabl\200s}r\200.\x1f\x1f\x1f\x1f\x1f\x1f", // 310
	"` nf btet sqodas} ~si norki dol|mi qtkami!\x1f\x1f\x1f", // 311
	"N|nf nf V~llotin.\x1f\x1f", // 312
	"Na n>m nfs knopok! Nfnacigt!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 313
	"Mnf nfxfdo porsacis}.\x1f\x1f", // 314
	"` nf coh}mt so, xso nf mo>.\x1f\x1f\x1f\x1f", // 315
	"^j! C x>m eflo?!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 316
	"Oskq|so!\x1f\x1f", // 317
	"Nf qabosafs.\x1f\x1f\x1f\x1f\x1f\x1f", // 318
	"Poka kapisan nabl\177eafs?..\nNf rsois...\x1f\x1f", // 319
	"Rfqp rliykom stpoj.\x1f\x1f\x1f\x1f\x1f", // 320
	"Co-pfqc|v, t mfn\200 vcasafs eqtdiv habos.\x1f\x1f\x1f\x1f\x1f\x1f", // 321
	"Na poekop r pomoz}\177 noga tje>s\neobqa\200 rosn\200 lfs.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 322
	"Nfs gflani\200 fz> i trtdtbl\200s}\n~sos bfrpoq\200eok.", // 323
	"Rsois li bqoras} iv psiwf natdae?\x1f\x1f\x1f\x1f\x1f", // 324
	"Nf voxt posqasis} sakif cktrn|f kqoyki.\x1f\x1f", // 325
	"Nf rsois... Modt rorkol}hnts} c...\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 326
	"\"Irsoqi\200 bl\177ha\".\x1f\x1f\x1f\x1f\x1f\x1f\x1f", // 327
	"\"Manxfrsfq _najsfe: idqa kqarn|v e}\200coloc\".\x1f\x1f", // 328
	"\"Boqh|f i eqtdif ovosnix}i robaki\".\x1f", // 329
	"\"Molokoror, ili mo\200 gihn} na Eikom Hapaef\".\x1f\x1f\x1f\x1f", // 330
	"\"Xaqli Bqatn i fdo kompani\200\".\x1f\x1f\x1f", // 331
	"\"Qohoca\200 pansfqa: nfihcfrsna\200 biodqaui\200\".\x1f", // 332

	"Irpol}hocanif ~siv ectv pqfemfsoc cmfrsf\nnixfdo nf ears.",
};

#define DSEG_ENDBLK_SIZE 34651

const static uint8 dsegEndBlock[DSEG_ENDBLK_SIZE] = {
	0x90, 0x9d, 0xe5, 0x9d, 0x54, 0x9e, 0xc3, 0x9e,
	0x3e, 0x9f, 0x0b, 0x30, 0x02, 0x31, 0x03, 0x32,
	0x04, 0x33, 0x05, 0x34, 0x06, 0x35, 0x07, 0x36,
	0x08, 0x37, 0x09, 0x38, 0x0a, 0x39, 0x0c, 0x2d,
	0x1e, 0x41, 0x30, 0x42, 0x2e, 0x43, 0x20, 0x44,
	0x12, 0x45, 0x21, 0x46, 0x22, 0x47, 0x23, 0x48,
	0x17, 0x49, 0x24, 0x4a, 0x25, 0x4b, 0x26, 0x4c,
	0x32, 0x4d, 0x31, 0x4e, 0x18, 0x4f, 0x19, 0x50,
	0x10, 0x51, 0x13, 0x52, 0x1f, 0x53, 0x14, 0x54,
	0x16, 0x55, 0x2f, 0x56, 0x11, 0x57, 0x2d, 0x58,
	0x15, 0x59, 0x2c, 0x5a, 0x33, 0x2c, 0x34, 0x2e,
	0x35, 0x3f, 0x39, 0x20, 0x28, 0x27, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0x0a, 0x48, 0x01,
	0x00, 0x7c, 0x19, 0x48, 0x02, 0x00, 0xaf, 0x30,
	0x0e, 0x03, 0x02, 0xbe, 0x30, 0x26, 0x03, 0x03,
	0xe5, 0x30, 0x0e, 0x03, 0x01, 0xaf, 0x3f, 0x0e,
	0x04, 0x02, 0xbe, 0x3f, 0x26, 0x04, 0x03, 0xe5,
	0x3f, 0x0e, 0x04, 0x01, 0x9f, 0x4e, 0x0e, 0x05,
	0x02, 0xae, 0x4e, 0x36, 0x05, 0x03, 0xe5, 0x4e,
	0x0e, 0x05, 0x01, 0x9f, 0x5d, 0x0e, 0x06, 0x02,
	0xae, 0x5d, 0x36, 0x06, 0x03, 0xe5, 0x5d, 0x0e,
	0x06, 0x01, 0x9f, 0x6c, 0x0e, 0x07, 0x02, 0xae,
	0x6c, 0x36, 0x07, 0x03, 0xe5, 0x6c, 0x0e, 0x07,
	0x01, 0xa7, 0x7b, 0x0e, 0x08, 0x02, 0xb6, 0x7b,
	0x2e, 0x08, 0x03, 0xe5, 0x7b, 0x0e, 0x08, 0x01,
	0x8d, 0x94, 0x25, 0x0b, 0x00, 0x6c, 0xa3, 0x69,
	0x0a, 0x00, 0x79, 0xb2, 0x50, 0x0d, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x81, 0x0f, 0x41, 0x22,
	0xd3, 0x3e, 0x92, 0x51, 0x50, 0x64, 0x0e, 0x77,
	0xd0, 0x89, 0x8a, 0x9c, 0x00, 0x00, 0x52, 0xbd,
	0xb1, 0xce, 0x81, 0xe1, 0x4c, 0x6f, 0x61, 0x64,
	0x20, 0x67, 0x61, 0x6d, 0x65, 0x00, 0x53, 0x61,
	0x76, 0x65, 0x20, 0x67, 0x61, 0x6d, 0x65, 0x00,
	0x4d, 0x75, 0x73, 0x69, 0x63, 0x20, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x20, 0x20, 0x20, 0x20,
	0x2d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7f, 0x00, 0x53,
	0x6f, 0x75, 0x6e, 0x64, 0x20, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x20, 0x20, 0x20, 0x20, 0x2d,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x7f, 0x00, 0x48, 0x65,
	0x72, 0x6f, 0x20, 0x73, 0x70, 0x65, 0x65, 0x64,
	0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x7f, 0x00, 0x47,
	0x61, 0x6d, 0x65, 0x20, 0x73, 0x70, 0x65, 0x65,
	0x64, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7f, 0x00,
	0x54, 0x65, 0x78, 0x74, 0x20, 0x73, 0x70, 0x65,
	0x65, 0x64, 0x20, 0x20, 0x20, 0x20, 0x2d, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x7f,
	0x00, 0x47, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63,
	0x20, 0x6d, 0x6f, 0x64, 0x65, 0x20, 0x20, 0x20,
	0x20, 0x2d, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
	0x7f, 0x00, 0x20, 0x00, 0x51, 0x75, 0x69, 0x74,
	0x00, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20,
	0x74, 0x6f, 0x20, 0x67, 0x61, 0x6d, 0x65, 0x00,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x20, 0x69, 0x6e,
	0x66, 0x6f, 0x00, 0x00, 0x77, 0x64, 0x39, 0x77,
	0x0f, 0x8a, 0x44, 0x6f, 0x20, 0x79, 0x6f, 0x75,
	0x20, 0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79, 0x00,
	0x77, 0x61, 0x6e, 0x74, 0x20, 0x74, 0x6f, 0x20,
	0x71, 0x75, 0x69, 0x74, 0x00, 0x28, 0x59, 0x2f,
	0x4e, 0x29, 0x3f, 0x00, 0x00, 0xf7, 0x57, 0x83,
	0x6a, 0x43, 0x7d, 0x03, 0x90, 0x46, 0x6f, 0x72,
	0x20, 0x69, 0x6e, 0x66, 0x6f, 0x20, 0x63, 0x61,
	0x6c, 0x6c, 0x3a, 0x00, 0x55, 0x4b, 0x3a, 0x20,
	0x50, 0x44, 0x20, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x30, 0x31,
	0x34, 0x37, 0x34, 0x20, 0x33, 0x32, 0x35, 0x38,
	0x30, 0x32, 0x00, 0x55, 0x53, 0x41, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72,
	0x65, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64,
	0x3a, 0x00, 0x55, 0x6e, 0x69, 0x6f, 0x6e, 0x20,
	0x4c, 0x6f, 0x67, 0x69, 0x63, 0x20, 0x28, 0x38,
	0x30, 0x30, 0x29, 0x20, 0x35, 0x38, 0x33, 0x2d,
	0x34, 0x38, 0x33, 0x38, 0x00, 0x00, 0x44, 0x5f,
	0x04, 0x77, 0xc4, 0x84, 0x84, 0x92, 0x49, 0x20,
	0x63, 0x61, 0x6e, 0x27, 0x74, 0x20, 0x75, 0x73,
	0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x73,
	0x61, 0x76, 0x65, 0x67, 0x61, 0x6d, 0x65, 0x21,
	0x00, 0x28, 0x54, 0x68, 0x65, 0x20, 0x66, 0x69,
	0x6c, 0x65, 0x20, 0x69, 0x73, 0x20, 0x63, 0x6f,
	0x72, 0x72, 0x75, 0x70, 0x74, 0x65, 0x64, 0x20,
	0x6f, 0x72, 0x20, 0x77, 0x61, 0x73, 0x00, 0x73,
	0x61, 0x76, 0x65, 0x64, 0x20, 0x75, 0x6e, 0x64,
	0x65, 0x72, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x74, 0x20, 0x67, 0x61, 0x6d,
	0x65, 0x00, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x20, 0x53, 0x6f, 0x72, 0x72, 0x79,
	0x2e, 0x29, 0x00, 0x00, 0xc7, 0x32, 0x4f, 0x46,
	0x46, 0x00, 0xc7, 0x32, 0x31, 0x30, 0x80, 0x00,
	0xc6, 0x32, 0x32, 0x30, 0x80, 0x00, 0xc6, 0x32,
	0x33, 0x30, 0x80, 0x00, 0xc6, 0x32, 0x34, 0x30,
	0x80, 0x00, 0xc6, 0x32, 0x35, 0x30, 0x80, 0x00,
	0xc6, 0x32, 0x36, 0x30, 0x80, 0x00, 0xc6, 0x32,
	0x37, 0x30, 0x80, 0x00, 0xc6, 0x32, 0x38, 0x30,
	0x80, 0x00, 0xc6, 0x32, 0x39, 0x30, 0x80, 0x00,
	0xc5, 0x32, 0x4d, 0x41, 0x58, 0x00, 0xc7, 0x41,
	0x4f, 0x46, 0x46, 0x00, 0xc7, 0x41, 0x31, 0x30,
	0x80, 0x00, 0xc6, 0x41, 0x32, 0x30, 0x80, 0x00,
	0xc6, 0x41, 0x33, 0x30, 0x80, 0x00, 0xc6, 0x41,
	0x34, 0x30, 0x80, 0x00, 0xc6, 0x41, 0x35, 0x30,
	0x80, 0x00, 0xc6, 0x41, 0x36, 0x30, 0x80, 0x00,
	0xc6, 0x41, 0x37, 0x30, 0x80, 0x00, 0xc6, 0x41,
	0x38, 0x30, 0x80, 0x00, 0xc6, 0x41, 0x39, 0x30,
	0x80, 0x00, 0xc5, 0x41, 0x4d, 0x41, 0x58, 0x00,
	0xbb, 0x50, 0x53, 0x4c, 0x4f, 0x57, 0x20, 0x20,
	0x00, 0xb4, 0x50, 0x4e, 0x4f, 0x52, 0x4d, 0x41,
	0x4c, 0x00, 0xbb, 0x50, 0x46, 0x41, 0x53, 0x54,
	0x20, 0x20, 0x00, 0xb7, 0x50, 0x43, 0x52, 0x41,
	0x5a, 0x59, 0x20, 0x00, 0xbb, 0x5f, 0x53, 0x4c,
	0x4f, 0x57, 0x20, 0x20, 0x00, 0xb4, 0x5f, 0x4e,
	0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x00, 0xbb, 0x5f,
	0x46, 0x41, 0x53, 0x54, 0x20, 0x20, 0x00, 0xb7,
	0x5f, 0x43, 0x52, 0x41, 0x5a, 0x59, 0x20, 0x00,
	0xb8, 0x6e, 0x43, 0x4c, 0x49, 0x43, 0x4b, 0x20,
	0x00, 0xbb, 0x6e, 0x53, 0x4c, 0x4f, 0x57, 0x20,
	0x20, 0x00, 0xb4, 0x6e, 0x4e, 0x4f, 0x52, 0x4d,
	0x41, 0x4c, 0x00, 0xbb, 0x6e, 0x46, 0x41, 0x53,
	0x54, 0x20, 0x20, 0x00, 0xb7, 0x6e, 0x43, 0x52,
	0x41, 0x5a, 0x59, 0x20, 0x00, 0xbe, 0x7d, 0x4d,
	0x4f, 0x4e, 0x4f, 0x20, 0x00, 0xbb, 0x7d, 0x43,
	0x4f, 0x4c, 0x4f, 0x52, 0x00, 0x3b, 0x0c, 0xca,
	0x0c, 0x00, 0x3b, 0x1b, 0xca, 0x0c, 0x00, 0x3b,
	0x2a, 0xca, 0x0c, 0x00, 0x3b, 0x39, 0xca, 0x0c,
	0x00, 0x3b, 0x48, 0xca, 0x0c, 0x00, 0x3b, 0x57,
	0xca, 0x0c, 0x00, 0x3b, 0x66, 0xca, 0x0c, 0x00,
	0x3b, 0x75, 0xca, 0x0c, 0x00, 0x3b, 0x84, 0xca,
	0x0c, 0x00, 0x3b, 0x93, 0xca, 0x0c, 0x00, 0x6e,
	0xaf, 0x64, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xcc, 0xdd, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x5f, 0x00, 0x0d, 0x0a, 0x48,
	0x45, 0x4c, 0x4c, 0x4f, 0x2c, 0x20, 0x56, 0x4f,
	0x59, 0x45, 0x55, 0x52, 0x21, 0x0d, 0x0a, 0xaf,
	0xb3, 0xa6, 0x64, 0x00, 0x0a, 0x01, 0x01, 0x02,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x28, 0x1b, 0x1c, 0x28,
	0x1d, 0x1e, 0x28, 0x1b, 0x28, 0x1f, 0x20, 0x28,
	0x1b, 0x1c, 0x28, 0x1d, 0x28, 0x1f, 0x28, 0x1b,
	0x00, 0x28, 0x1b, 0x1c, 0x28, 0x1d, 0x1e, 0x28,
	0x1b, 0x28, 0x1f, 0x20, 0x28, 0x1b, 0x1c, 0x28,
	0x1d, 0x28, 0x1f, 0x28, 0x1b, 0x00, 0x2a, 0x26,
	0x2a, 0x2a, 0x27, 0x2a, 0x27, 0x2a, 0x2a, 0x26,
	0x2a, 0x26, 0x2a, 0x2a, 0x2a, 0x27, 0x26, 0x2a,
	0x2a, 0x27, 0x00, 0x21, 0x22, 0x23, 0x24, 0x29,
	0x25, 0x29, 0x29, 0x25, 0x29, 0x21, 0x22, 0x21,
	0x24, 0x29, 0x21, 0x29, 0x29, 0x21, 0x29, 0x00,
	0x00, 0x00, 0x01, 0x46, 0x65, 0x82, 0x65, 0xb2,
	0x65, 0x01, 0x02, 0x03, 0x04, 0x04, 0x04, 0x04,
	0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06,
	0x06, 0x06, 0x06, 0x07, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x00, 0x01, 0x02, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x08, 0x08, 0x08, 0x09, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x00, 0x01, 0x02, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x04, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x00, 0x01, 0x02, 0x03,
	0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x00,
	0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
	0x0a, 0x00, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19,
	0x1a, 0x00, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11,
	0x12, 0x00, 0x00, 0x00, 0x3a, 0x0d, 0x28, 0x2e,
	0x00, 0x20, 0x31, 0x18, 0x10, 0x3a, 0x23, 0x14,
	0x3f, 0x2b, 0x17, 0x3f, 0x30, 0x22, 0x3f, 0x34,
	0x21, 0x3f, 0x00, 0x00, 0x36, 0x00, 0x00, 0x28,
	0x00, 0x00, 0x11, 0x2f, 0x3f, 0x11, 0x24, 0x3f,
	0x11, 0x16, 0x3f, 0x1d, 0x11, 0x1f, 0x28, 0x2f,
	0x33, 0x35, 0x13, 0x10, 0x0c, 0x28, 0x21, 0x19,
	0x00, 0x92, 0x66, 0x94, 0x66, 0x96, 0x66, 0x98,
	0x66, 0x9a, 0x66, 0x9c, 0x66, 0x9e, 0x66, 0xa0,
	0x66, 0xa2, 0x66, 0xa4, 0x66, 0xa6, 0x66, 0xb1,
	0x66, 0xbc, 0x66, 0xbe, 0x66, 0xc9, 0x66, 0xcb,
	0x66, 0xd6, 0x66, 0xd8, 0x66, 0xe3, 0x66, 0xe5,
	0x66, 0xf0, 0x66, 0xf2, 0x66, 0xf4, 0x66, 0xf6,
	0x66, 0xf8, 0x66, 0xfa, 0x66, 0x20, 0x67, 0x22,
	0x67, 0x24, 0x67, 0x26, 0x67, 0x28, 0x67, 0x2a,
	0x67, 0x2c, 0x67, 0x2e, 0x67, 0x30, 0x67, 0x32,
	0x67, 0x34, 0x67, 0x36, 0x67, 0x38, 0x67, 0x3a,
	0x67, 0x3c, 0x67, 0x3e, 0x67, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x00, 0x00, 0x5c, 0x00, 0x50, 0x00, 0x97,
	0x00, 0x0f, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0xab, 0x00, 0x09, 0xff, 0xff, 0xff,
	0xff, 0x1f, 0x00, 0xb7, 0x00, 0x55, 0x00, 0xc4,
	0x00, 0x0c, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xd2, 0x00, 0xc7, 0x00, 0x08, 0xff,
	0xff, 0xff, 0xff, 0x3a, 0x00, 0x9e, 0x00, 0x3f,
	0x01, 0xc7, 0x00, 0x0a, 0xff, 0xff, 0xff, 0xff,
	0x82, 0x00, 0xa0, 0x00, 0x3f, 0x01, 0xa9, 0x00,
	0x0a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x86, 0x00, 0xc7, 0x00, 0x12, 0x00, 0x00,
	0x00, 0x00, 0xaf, 0x00, 0xae, 0x00, 0x10, 0x00,
	0x00, 0x00, 0x00, 0xdb, 0x00, 0xa9, 0x00, 0x0e,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0x01, 0xc7, 0x00,
	0x06, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x9a, 0x67, 0x9b, 0x67, 0xf0, 0x67, 0x29,
	0x68, 0x70, 0x68, 0xc5, 0x68, 0xfe, 0x68, 0x37,
	0x69, 0x8c, 0x69, 0xc5, 0x69, 0x1a, 0x6a, 0x6f,
	0x6a, 0xc4, 0x6a, 0xfd, 0x6a, 0x6e, 0x6b, 0xdf,
	0x6b, 0x18, 0x6c, 0x19, 0x6c, 0x6e, 0x6c, 0xa7,
	0x6c, 0xee, 0x6c, 0x35, 0x6d, 0x7c, 0x6d, 0xb5,
	0x6d, 0xee, 0x6d, 0x19, 0x6e, 0x36, 0x6e, 0xd1,
	0x6e, 0xfc, 0x6e, 0x27, 0x6f, 0x6e, 0x6f, 0x8b,
	0x6f, 0xd2, 0x6f, 0x0b, 0x70, 0x6e, 0x70, 0x99,
	0x70, 0xb6, 0x70, 0xb7, 0x70, 0xf0, 0x70, 0xf1,
	0x70, 0xf2, 0x70, 0xf3, 0x70, 0x00, 0x06, 0x01,
	0x03, 0x00, 0x00, 0x00, 0x00, 0xd2, 0x00, 0xb1,
	0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xe4, 0x00, 0x9b, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0x00, 0x8e, 0x00, 0x00, 0x03, 0x00,
	0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x3f,
	0x01, 0x5e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x00, 0x00, 0xc0, 0x00, 0xa2, 0x00, 0xc7,
	0x00, 0x02, 0x01, 0x00, 0x00, 0x03, 0x00, 0xff,
	0x00, 0x9c, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0x04,
	0x00, 0x00, 0x01, 0x04, 0x01, 0x03, 0x00, 0x00,
	0x00, 0x00, 0xcb, 0x00, 0xbf, 0x00, 0x00, 0x03,
	0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xe8, 0x00, 0x99, 0x00, 0x00, 0x03, 0x02, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x01,
	0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0xe5, 0x00, 0xb9, 0x00, 0x3f, 0x01, 0xc7, 0x00,
	0x04, 0x00, 0x00, 0x01, 0x05, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xde, 0x00, 0xaf, 0x00, 0x00,
	0x03, 0x02, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7b, 0x00, 0xc7, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,
	0x01, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x03, 0x01,
	0x00, 0x00, 0x00, 0xc0, 0x00, 0x3f, 0x01, 0xc7,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0xf4,
	0x00, 0x93, 0x00, 0x3f, 0x01, 0xb0, 0x00, 0x04,
	0x00, 0x04, 0x00, 0x06, 0x01, 0x03, 0x00, 0x00,
	0x00, 0x00, 0xf9, 0x00, 0x9c, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x01, 0x00, 0xf9, 0x00, 0x00, 0x00,
	0x08, 0x01, 0x9b, 0x00, 0x00, 0x03, 0x00, 0x03,
	0x01, 0x00, 0x08, 0x01, 0x00, 0x00, 0x3f, 0x01,
	0x7c, 0x00, 0x00, 0x03, 0x00, 0x03, 0x01, 0x03,
	0x46, 0x00, 0x00, 0x00, 0x6c, 0x00, 0xa4, 0x00,
	0x00, 0x03, 0x00, 0x03, 0x02, 0x01, 0x00, 0x00,
	0xb5, 0x00, 0x6b, 0x00, 0xc7, 0x00, 0x02, 0x01,
	0x00, 0x00, 0x03, 0x00, 0x87, 0x00, 0xb7, 0x00,
	0x3f, 0x01, 0xc7, 0x00, 0x04, 0x00, 0x00, 0x01,
	0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x00, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x01, 0xac,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x8f, 0x00, 0xbc, 0x00, 0x00,
	0x03, 0x02, 0x00, 0x01, 0x00, 0x33, 0x01, 0x00,
	0x00, 0x3f, 0x01, 0xc7, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x00, 0xc7, 0x00, 0x00, 0x03, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x01,
	0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0xfa, 0x00, 0x00, 0x00, 0x3f, 0x01, 0xc7, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x02, 0x00, 0x53, 0x00,
	0xaf, 0x00, 0xe6, 0x00, 0xbe, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x01, 0x00, 0xce, 0x00, 0xb3,
	0x00, 0x3f, 0x01, 0xc1, 0x00, 0x04, 0x00, 0x04,
	0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x3f,
	0x01, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0xb6, 0x00, 0x5e, 0x00, 0xc1,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x00, 0xc7, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x05, 0x01, 0x00,
	0x00, 0x3f, 0x01, 0xc7, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0xff, 0x00, 0x00, 0x00, 0x3f,
	0x01, 0xc1, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04,
	0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x5d, 0x00,
	0xb2, 0x00, 0x00, 0x03, 0x02, 0x00, 0x01, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0x01, 0xac, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xf1, 0x00,
	0x00, 0x00, 0x3f, 0x01, 0xbc, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x01, 0x00, 0x16, 0x01, 0x00, 0x00,
	0x3f, 0x01, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59,
	0x00, 0x8a, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01,
	0x00, 0x59, 0x00, 0x00, 0x00, 0x3f, 0x01, 0x94,
	0x00, 0x00, 0x00, 0x04, 0x03, 0x01, 0x00, 0xec,
	0x00, 0x00, 0x00, 0x3f, 0x01, 0xa2, 0x00, 0x00,
	0x00, 0x04, 0x03, 0x02, 0x00, 0x00, 0x00, 0x94,
	0x00, 0x3e, 0x00, 0xc7, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x00, 0xa6, 0x00, 0x71,
	0x00, 0xc7, 0x00, 0x02, 0x01, 0x00, 0x00, 0x02,
	0x00, 0x00, 0x00, 0xbd, 0x00, 0x3f, 0x01, 0xc7,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x00,
	0x00, 0x00, 0x91, 0x00, 0x1a, 0x00, 0xa3, 0x00,
	0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00,
	0xb3, 0x00, 0xa4, 0x00, 0xc7, 0x00, 0x02, 0x01,
	0x00, 0x00, 0x02, 0x00, 0xa5, 0x00, 0xbd, 0x00,
	0xc8, 0x00, 0xc7, 0x00, 0x02, 0x01, 0x00, 0x00,
	0x03, 0x00, 0xaf, 0x00, 0x83, 0x00, 0x3f, 0x01,
	0x97, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03, 0x00,
	0xc3, 0x00, 0x98, 0x00, 0x3f, 0x01, 0xb3, 0x00,
	0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x42, 0x00,
	0x00, 0x00, 0x7c, 0x00, 0x99, 0x00, 0x00, 0x03,
	0x00, 0x03, 0x06, 0x01, 0x03, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0x00, 0xa8, 0x00, 0x00, 0x03, 0x02,
	0x00, 0x01, 0x03, 0x00, 0x00, 0xa9, 0x00, 0x30,
	0x00, 0xb8, 0x00, 0x00, 0x03, 0x02, 0x00, 0x01,
	0x00, 0xfd, 0x00, 0x00, 0x00, 0x1f, 0x01, 0xac,
	0x00, 0x00, 0x03, 0x02, 0x03, 0x01, 0x00, 0x20,
	0x01, 0x00, 0x00, 0x2c, 0x01, 0xa2, 0x00, 0x00,
	0x03, 0x02, 0x03, 0x01, 0x00, 0x2d, 0x01, 0x00,
	0x00, 0x3f, 0x01, 0x87, 0x00, 0x00, 0x03, 0x02,
	0x03, 0x02, 0x01, 0x00, 0x00, 0xc2, 0x00, 0x3f,
	0x01, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x01, 0x01, 0x00, 0x00, 0xba, 0x00, 0x4b, 0x00,
	0xc7, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x01,
	0xe6, 0x00, 0xba, 0x00, 0x3f, 0x01, 0xc7, 0x00,
	0x04, 0x00, 0x04, 0x01, 0x02, 0x00, 0x3e, 0x00,
	0x00, 0x00, 0x70, 0x00, 0xaf, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x02, 0x00, 0x70, 0x00, 0x00, 0x00,
	0x3f, 0x01, 0xb2, 0x00, 0x00, 0x00, 0x04, 0x03,
	0x08, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x3f,
	0x01, 0x6e, 0x00, 0x00, 0x03, 0x04, 0x03, 0x01,
	0x00, 0x7a, 0x00, 0x6f, 0x00, 0x3f, 0x01, 0x89,
	0x00, 0x04, 0x00, 0x04, 0x03, 0x01, 0x00, 0xfc,
	0x00, 0x8d, 0x00, 0x3f, 0x01, 0xb8, 0x00, 0x04,
	0x00, 0x04, 0x03, 0x01, 0x00, 0x1c, 0x01, 0xb9,
	0x00, 0x3f, 0x01, 0xc7, 0x00, 0x04, 0x00, 0x04,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x9e, 0x00, 0x8a,
	0x00, 0xb2, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x00, 0x00, 0xb3, 0x00, 0x23, 0x00, 0xc7,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x24,
	0x00, 0xb3, 0x00, 0x6d, 0x00, 0xbe, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x03, 0x00, 0x77, 0x00, 0xbc,
	0x00, 0xe8, 0x00, 0xc7, 0x00, 0x00, 0x01, 0x00,
	0x01, 0x08, 0x03, 0x01, 0xde, 0x00, 0xb4, 0x00,
	0x2c, 0x01, 0xc7, 0x00, 0x04, 0x00, 0x00, 0x01,
	0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x6e, 0x00,
	0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03,
	0x6f, 0x00, 0x00, 0x00, 0xef, 0x00, 0xb1, 0x00,
	0x00, 0x03, 0x00, 0x03, 0x01, 0x03, 0xf0, 0x00,
	0x00, 0x00, 0x22, 0x01, 0xa5, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x01, 0x03, 0x23, 0x01, 0x00, 0x00,
	0x3f, 0x01, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x02, 0x01, 0x00, 0x00, 0xb8, 0x00, 0x8b, 0x00,
	0xc7, 0x00, 0x02, 0x01, 0x00, 0x00, 0x03, 0x01,
	0xa3, 0x00, 0xb8, 0x00, 0xdd, 0x00, 0xc7, 0x00,
	0x04, 0x00, 0x00, 0x01, 0x03, 0x01, 0x2d, 0x01,
	0xaf, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3f, 0x01, 0x50, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5b,
	0x00, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x14, 0x01, 0x00, 0x00, 0x3f, 0x01, 0xc7,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x65, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x00, 0x61,
	0x00, 0x00, 0x00, 0x3f, 0x01, 0xa3, 0x00, 0x00,
	0x00, 0x04, 0x03, 0x01, 0x00, 0x34, 0x00, 0x85,
	0x00, 0x63, 0x00, 0x97, 0x00, 0x04, 0x00, 0x04,
	0x00, 0x01, 0x00, 0xab, 0x00, 0xa4, 0x00, 0x3f,
	0x01, 0xb6, 0x00, 0x00, 0x00, 0x04, 0x03, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x72,
	0x00, 0x00, 0x03, 0x02, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x72, 0x00, 0x19, 0x00, 0xaa, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0xaa,
	0x00, 0x45, 0x00, 0xc7, 0x00, 0x02, 0x01, 0x00,
	0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0xa3, 0x00,
	0x2c, 0x00, 0xc7, 0x00, 0x02, 0x01, 0x00, 0x00,
	0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x01,
	0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04,
	0x0f, 0x01, 0xa3, 0x00, 0x3f, 0x01, 0xbd, 0x00,
	0x04, 0x00, 0x04, 0x03, 0x01, 0x00, 0xe2, 0x00,
	0x00, 0x00, 0x3f, 0x01, 0xaa, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x05, 0x01, 0x03, 0xb0, 0x00, 0xa4,
	0x00, 0x3f, 0x01, 0xbc, 0x00, 0x04, 0x00, 0x04,
	0x00, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x0e,
	0x00, 0x82, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
	0x03, 0x0f, 0x00, 0x00, 0x00, 0x88, 0x00, 0xb4,
	0x00, 0x00, 0x03, 0x00, 0x03, 0x01, 0x03, 0x89,
	0x00, 0x00, 0x00, 0x3f, 0x01, 0xa3, 0x00, 0x00,
	0x00, 0x04, 0x00, 0x02, 0x01, 0x00, 0x00, 0xc4,
	0x00, 0x93, 0x00, 0xc7, 0x00, 0x02, 0x01, 0x00,
	0x00, 0x05, 0x01, 0x00, 0xdc, 0x00, 0x00, 0x00,
	0x3f, 0x01, 0xc7, 0x00, 0x00, 0x03, 0x00, 0x03,
	0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00,
	0xae, 0x00, 0x00, 0x03, 0x02, 0x00, 0x01, 0x03,
	0x51, 0x00, 0x00, 0x00, 0x78, 0x00, 0xab, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x79, 0x00,
	0x00, 0x00, 0x3f, 0x01, 0xb1, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x02, 0x01, 0x00, 0x00, 0xc0, 0x00,
	0xa9, 0x00, 0xc7, 0x00, 0x02, 0x01, 0x00, 0x00,
	0x05, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f,
	0x01, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0xaa, 0x00, 0x29, 0x00, 0xbf,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x01, 0x00,
	0x00, 0xbf, 0x00, 0x9e, 0x00, 0xc7, 0x00, 0x02,
	0x01, 0x00, 0x00, 0x01, 0x01, 0xc5, 0x00, 0xaf,
	0x00, 0x3f, 0x01, 0xc7, 0x00, 0x04, 0x00, 0x00,
	0x01, 0x01, 0x04, 0x00, 0x01, 0xa8, 0x00, 0x3f,
	0x01, 0xae, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04,
	0x01, 0x00, 0x00, 0x00, 0xaa, 0x00, 0x52, 0x00,
	0xba, 0x00, 0x00, 0x03, 0x02, 0x00, 0x01, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0x01, 0xa9, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0xe0, 0x00,
	0xaa, 0x00, 0x3f, 0x01, 0xb2, 0x00, 0x00, 0x00,
	0x04, 0x03, 0x01, 0x00, 0x12, 0x01, 0xb3, 0x00,
	0x3f, 0x01, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x47,
	0x00, 0xc7, 0x00, 0x00, 0x03, 0x00, 0x00, 0x01,
	0x03, 0x47, 0x00, 0x00, 0x00, 0x12, 0x01, 0xa6,
	0x00, 0x00, 0x03, 0x00, 0x03, 0x01, 0x03, 0x63,
	0x00, 0x00, 0x00, 0xd3, 0x00, 0xaa, 0x00, 0x00,
	0x03, 0x00, 0x03, 0x01, 0x00, 0x12, 0x01, 0x00,
	0x00, 0x3f, 0x01, 0xc7, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x96, 0x00, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x03, 0x79, 0x00, 0x00, 0x00, 0x3f, 0x01,
	0x90, 0x00, 0x00, 0x00, 0x00, 0x03, 0x01, 0x01,
	0x79, 0x00, 0xa4, 0x00, 0x3f, 0x01, 0xc7, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x69, 0x00, 0xc7, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x03, 0x6a, 0x00, 0x00,
	0x00, 0x3f, 0x01, 0xa5, 0x00, 0x00, 0x03, 0x02,
	0x03, 0x0b, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0x01, 0x83, 0x00, 0x00, 0x00, 0x04, 0x00,
	0x01, 0x03, 0x00, 0x00, 0x84, 0x00, 0xda, 0x00,
	0x9e, 0x00, 0x02, 0x03, 0x02, 0x00, 0x01, 0x03,
	0x00, 0x00, 0x9f, 0x00, 0xc2, 0x00, 0xa9, 0x00,
	0x00, 0x03, 0x02, 0x00, 0x01, 0x03, 0x00, 0x00,
	0xaa, 0x00, 0xa4, 0x00, 0xaf, 0x00, 0x00, 0x03,
	0x02, 0x00, 0x01, 0x03, 0x00, 0x00, 0xb0, 0x00,
	0x7f, 0x00, 0xbb, 0x00, 0x00, 0x03, 0x02, 0x00,
	0x01, 0x03, 0x00, 0x00, 0xbc, 0x00, 0x5e, 0x00,
	0xc3, 0x00, 0x00, 0x03, 0x02, 0x00, 0x01, 0x02,
	0x00, 0x00, 0xc4, 0x00, 0x4b, 0x00, 0xc7, 0x00,
	0x00, 0x03, 0x02, 0x00, 0x01, 0x03, 0xef, 0x00,
	0x84, 0x00, 0x3f, 0x01, 0xa4, 0x00, 0x04, 0x00,
	0x00, 0x01, 0x01, 0x03, 0xdb, 0x00, 0xa5, 0x00,
	0x3f, 0x01, 0xb4, 0x00, 0x04, 0x00, 0x00, 0x01,
	0x01, 0x03, 0xc2, 0x00, 0xb5, 0x00, 0x3f, 0x01,
	0xbe, 0x00, 0x04, 0x00, 0x00, 0x01, 0x01, 0x04,
	0xa2, 0x00, 0xbf, 0x00, 0x3f, 0x01, 0xc7, 0x00,
	0x04, 0x00, 0x00, 0x01, 0x03, 0x01, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x93, 0x00, 0x8c, 0x00, 0x00,
	0x03, 0x00, 0x03, 0x01, 0x03, 0x94, 0x00, 0x00,
	0x00, 0x3f, 0x01, 0x94, 0x00, 0x00, 0x00, 0x04,
	0x03, 0x01, 0x00, 0xe9, 0x00, 0x95, 0x00, 0x3f,
	0x01, 0xc7, 0x00, 0x04, 0x00, 0x04, 0x00, 0x03,
	0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x01,
	0xa5, 0x00, 0x00, 0x03, 0x00, 0x03, 0x01, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0xc7, 0x00,
	0x02, 0x00, 0x02, 0x00, 0x01, 0x03, 0x30, 0x00,
	0x00, 0x00, 0x4f, 0x00, 0xab, 0x00, 0x00, 0x03,
	0x00, 0x03, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3f, 0x01, 0x95, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0xf1, 0x00, 0x00, 0x00, 0x3f,
	0x01, 0x9a, 0x00, 0x00, 0x00, 0x04, 0x03, 0x01,
	0x04, 0x22, 0x01, 0x00, 0x00, 0x3f, 0x01, 0xc7,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x75,
	0x00, 0x9c, 0x00, 0xe9, 0x00, 0xbf, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x11, 0x00, 0xc7, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0x01, 0xa5, 0x00, 0x00, 0x03, 0x00, 0x03,
	0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x37, 0x00,
	0xb0, 0x00, 0x02, 0x03, 0x02, 0x00, 0x05, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0xc7,
	0x00, 0x00, 0x03, 0x02, 0x00, 0x01, 0x03, 0x28,
	0x00, 0x00, 0x00, 0x8e, 0x00, 0xa9, 0x00, 0x00,
	0x03, 0x02, 0x03, 0x01, 0x03, 0x8e, 0x00, 0x00,
	0x00, 0x07, 0x01, 0xa1, 0x00, 0x00, 0x03, 0x00,
	0x03, 0x01, 0x00, 0x08, 0x01, 0x00, 0x00, 0x3f,
	0x01, 0xc7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x00, 0xdf, 0x00, 0xb7, 0x00, 0x3f, 0x01, 0xc7,
	0x00, 0x04, 0x00, 0x04, 0x01, 0x03, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0xaf, 0x00,
	0x00, 0x03, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x00, 0xa7, 0x00, 0x00, 0x03,
	0x02, 0x00, 0x01, 0x03, 0x50, 0x00, 0x00, 0x00,
	0x3f, 0x01, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x01, 0x03, 0x97, 0x00, 0x00, 0x00, 0xb4, 0x00,
	0xa2, 0x00, 0x00, 0x03, 0x00, 0x03, 0x07, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x80,
	0x00, 0x00, 0x03, 0x00, 0x00, 0x01, 0x03, 0x45,
	0x00, 0x00, 0x00, 0x78, 0x00, 0x86, 0x00, 0x00,
	0x03, 0x00, 0x03, 0x01, 0x03, 0x78, 0x00, 0x00,
	0x00, 0x07, 0x01, 0xa8, 0x00, 0x00, 0x03, 0x00,
	0x03, 0x01, 0x03, 0x07, 0x01, 0x00, 0x00, 0x3f,
	0x01, 0x9e, 0x00, 0x00, 0x03, 0x00, 0x03, 0x02,
	0x00, 0x00, 0x00, 0xb4, 0x00, 0x4d, 0x00, 0xc7,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x0c,
	0x01, 0xbe, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0a, 0x00, 0xc7, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x01, 0x03, 0x64, 0x00, 0x00, 0x00,
	0x3f, 0x01, 0xa8, 0x00, 0x00, 0x03, 0x00, 0x03,
	0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x63, 0x00,
	0xb7, 0x00, 0x00, 0x03, 0x02, 0x00, 0x02, 0x00,
	0xb6, 0x00, 0xb2, 0x00, 0x3f, 0x01, 0xc7, 0x00,
	0x00, 0x00, 0x03, 0x00, 0x02, 0x01, 0x00, 0x7d,
	0x00, 0x00, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x3f, 0x01, 0xbe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x28, 0x00, 0xc7, 0x00, 0x00, 0x03, 0x00,
	0x00, 0x01, 0x03, 0x29, 0x00, 0x00, 0x00, 0x5f,
	0x00, 0xa2, 0x00, 0x00, 0x03, 0x00, 0x03, 0x01,
	0x03, 0x5f, 0x00, 0x00, 0x00, 0xc8, 0x00, 0x9b,
	0x00, 0x00, 0x03, 0x00, 0x03, 0x01, 0x00, 0xc8,
	0x00, 0x00, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x48,
	0x71, 0x4c, 0x71, 0x50, 0x71, 0x54, 0x71, 0x58,
	0x71, 0x5c, 0x71, 0x60, 0x71, 0x64, 0x71, 0x68,
	0x71, 0x6c, 0x71, 0x70, 0x71, 0x84, 0x71, 0x88,
	0x71, 0x8c, 0x71, 0x9c, 0x71, 0xa0, 0x71, 0xa4,
	0x71, 0xa8, 0x71, 0xd0, 0x71, 0xd4, 0x71, 0xee,
	0x71, 0xf2, 0x71, 0xf6, 0x71, 0xfa, 0x71, 0xfe,
	0x71, 0x02, 0x72, 0x06, 0x72, 0x0a, 0x72, 0x18,
	0x72, 0x1c, 0x72, 0x20, 0x72, 0x24, 0x72, 0x28,
	0x72, 0x2c, 0x72, 0x30, 0x72, 0x34, 0x72, 0x38,
	0x72, 0x3c, 0x72, 0x40, 0x72, 0x44, 0x72, 0x48,
	0x72, 0x4c, 0x72, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0x67, 0x2d, 0x6a, 0x28, 0x70,
	0x23, 0x79, 0x1e, 0x7f, 0x19, 0x82, 0x14, 0x87,
	0x0f, 0x8c, 0x0a, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0x6e,
	0x17, 0x73, 0x15, 0x78, 0x13, 0x7d, 0x11, 0x82,
	0x0f, 0x85, 0x0c, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0x7a, 0x32, 0x7c, 0x30, 0x7e,
	0x2e, 0x80, 0x2c, 0x82, 0x2a, 0x84, 0x28, 0x86,
	0x24, 0x88, 0x20, 0x8a, 0x1d, 0x8c, 0x1a, 0x8e,
	0x17, 0x90, 0x14, 0x92, 0x11, 0x94, 0x0e, 0x96,
	0x0b, 0x98, 0x08, 0x9a, 0x05, 0x9c, 0x03, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0x83,
	0x12, 0x85, 0x10, 0x87, 0x0e, 0x89, 0x0c, 0x8b,
	0x0b, 0x8d, 0x0a, 0x8f, 0x09, 0x91, 0x08, 0x93,
	0x06, 0x95, 0x04, 0x97, 0x02, 0xc7, 0x00, 0xff,
	0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7, 0x00, 0xff,
	0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7, 0x00, 0xff,
	0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7, 0x00, 0xff,
	0xff, 0xc7, 0x00, 0xff, 0xff, 0x8e, 0x0c, 0x90,
	0x0a, 0x92, 0x08, 0x94, 0x06, 0x96, 0x04, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0xc7, 0x00, 0xff, 0xff, 0xc7,
	0x00, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xa8,
	0x72, 0xaa, 0x72, 0xc7, 0x73, 0x34, 0x75, 0xca,
	0x76, 0xda, 0x77, 0xbe, 0x79, 0x52, 0x7c, 0xe7,
	0x7e, 0x3e, 0x80, 0x1a, 0x81, 0x2c, 0x84, 0xd9,
	0x85, 0x20, 0x87, 0x06, 0x88, 0xd9, 0x89, 0x6d,
	0x8a, 0xca, 0x8b, 0xec, 0x8c, 0x19, 0x90, 0x6f,
	0x93, 0x2c, 0x95, 0x9c, 0x97, 0x08, 0x9b, 0x22,
	0x9d, 0x00, 0x9f, 0x10, 0xa0, 0xc0, 0xa3, 0x82,
	0xa4, 0xde, 0xa5, 0xc1, 0xa8, 0x5c, 0xaa, 0x12,
	0xac, 0x46, 0xaf, 0x5c, 0xb0, 0xa5, 0xb3, 0xfa,
	0xb3, 0xfc, 0xb3, 0xeb, 0xb4, 0xed, 0xb4, 0xef,
	0xb4, 0xf1, 0xb4, 0x00, 0x00, 0xb6, 0x72, 0xcf,
	0x72, 0xe8, 0x72, 0x38, 0x73, 0x7f, 0x73, 0x00,
	0x00, 0x01, 0x00, 0x00, 0xa6, 0x00, 0x38, 0x00,
	0xc7, 0x00, 0x38, 0x00, 0xb4, 0x00, 0x00, 0x00,
	0xb4, 0x00, 0x04, 0x01, 0x70, 0x61, 0x74, 0x68,
	0x00, 0x01, 0x02, 0xb6, 0x00, 0xb5, 0x00, 0x10,
	0x01, 0xc7, 0x00, 0xd9, 0x00, 0xc1, 0x00, 0xdd,
	0x00, 0xc7, 0x00, 0x03, 0x01, 0x70, 0x61, 0x74,
	0x68, 0x00, 0x01, 0x03, 0x20, 0x01, 0x4c, 0x00,
	0x2f, 0x01, 0x59, 0x00, 0x10, 0x01, 0x64, 0x00,
	0x10, 0x01, 0x64, 0x00, 0x01, 0x01, 0x6d, 0x79,
	0x73, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x75, 0x73,
	0x20, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x00,
	0x42, 0x6f, 0x79, 0x2c, 0x20, 0x74, 0x68, 0x61,
	0x74, 0x20, 0x63, 0x6f, 0x75, 0x6c, 0x64, 0x20,
	0x62, 0x65, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20,
	0x6b, 0x69, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x72, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
	0x21, 0x00, 0x00, 0x04, 0xf1, 0x00, 0x0e, 0x00,
	0x3f, 0x01, 0x5f, 0x00, 0x10, 0x01, 0x64, 0x00,
	0x10, 0x01, 0x64, 0x00, 0x01, 0x01, 0x66, 0x65,
	0x6e, 0x63, 0x65, 0x00, 0x54, 0x68, 0x69, 0x73,
	0x20, 0x69, 0x73, 0x20, 0x6d, 0x61, 0x64, 0x65,
	0x20, 0x6f, 0x66, 0x20, 0x62, 0x61, 0x72, 0x62,
	0x65, 0x64, 0x20, 0x77, 0x69, 0x72, 0x65, 0x2c,
	0x00, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x74, 0x27,
	0x73, 0x20, 0x72, 0x75, 0x73, 0x74, 0x79, 0x2e,
	0x00, 0x00, 0x05, 0x40, 0x00, 0x5a, 0x00, 0xb9,
	0x00, 0xa6, 0x00, 0x7c, 0x00, 0xb7, 0x00, 0x7c,
	0x00, 0xb7, 0x00, 0x01, 0x01, 0x74, 0x65, 0x6e,
	0x74, 0x00, 0x54, 0x68, 0x65, 0x20, 0x63, 0x61,
	0x6d, 0x6f, 0x75, 0x66, 0x6c, 0x61, 0x67, 0x65,
	0x20, 0x69, 0x73, 0x6e, 0x27, 0x74, 0x20, 0x71,
	0x75, 0x69, 0x74, 0x65, 0x20, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x2d, 0x6f, 0x66, 0x2d, 0x74, 0x68,
	0x65, 0x2d, 0x61, 0x72, 0x74, 0x2e, 0x2e, 0x2e,
	0x00, 0x00, 0xd5, 0x73, 0xf7, 0x73, 0x10, 0x74,
	0x29, 0x74, 0x5c, 0x74, 0xd0, 0x74, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xf0, 0x00, 0xa3, 0x00, 0xf0, 0x00, 0xa3,
	0x00, 0x04, 0x01, 0x62, 0x69, 0x72, 0x64, 0x00,
	0x42, 0x69, 0x67, 0x20, 0x62, 0x6f, 0x79, 0x2e,
	0x00, 0x00, 0x02, 0x16, 0x01, 0x55, 0x00, 0x3f,
	0x01, 0x7a, 0x00, 0x22, 0x01, 0x76, 0x00, 0x3f,
	0x01, 0x68, 0x00, 0x02, 0x01, 0x70, 0x61, 0x74,
	0x68, 0x00, 0x01, 0x03, 0x50, 0x00, 0xbd, 0x00,
	0xe6, 0x00, 0xc7, 0x00, 0xda, 0x00, 0xbf, 0x00,
	0xd6, 0x00, 0xc7, 0x00, 0x03, 0x01, 0x70, 0x61,
	0x74, 0x68, 0x00, 0x01, 0x04, 0xc6, 0x00, 0x23,
	0x00, 0xdc, 0x00, 0x96, 0x00, 0xd1, 0x00, 0x9a,
	0x00, 0xd1, 0x00, 0x9a, 0x00, 0x01, 0x01, 0x70,
	0x6f, 0x73, 0x74, 0x00, 0x54, 0x68, 0x61, 0x74,
	0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x65,
	0x61, 0x73, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x63,
	0x6c, 0x69, 0x6d, 0x62, 0x2e, 0x00, 0x00, 0x05,
	0x38, 0x00, 0x65, 0x00, 0xac, 0x00, 0xbc, 0x00,
	0x73, 0x00, 0xc2, 0x00, 0x73, 0x00, 0xc2, 0x00,
	0x01, 0x01, 0x6d, 0x75, 0x64, 0x20, 0x70, 0x6f,
	0x6f, 0x6c, 0x00, 0x48, 0x65, 0x61, 0x76, 0x65,
	0x6e, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x57, 0x6f,
	0x6f, 0x64, 0x73, 0x74, 0x6f, 0x63, 0x6b, 0x20,
	0x66, 0x61, 0x6e, 0x73, 0x2c, 0x20, 0x61, 0x6c,
	0x6c, 0x69, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x73,
	0x00, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x6f,
	0x73, 0x65, 0x20, 0x74, 0x6f, 0x75, 0x67, 0x68,
	0x20, 0x77, 0x6f, 0x6d, 0x65, 0x6e, 0x20, 0x66,
	0x69, 0x67, 0x68, 0x74, 0x69, 0x6e, 0x67, 0x20,
	0x6f, 0x6e, 0x20, 0x6c, 0x61, 0x74, 0x65, 0x20,
	0x54, 0x56, 0x00, 0x73, 0x68, 0x6f, 0x77, 0x73,
	0x2e, 0x00, 0x00, 0x06, 0xb8, 0x00, 0x90, 0x00,
	0xe4, 0x00, 0xa0, 0x00, 0xf0, 0x00, 0xa3, 0x00,
	0xdc, 0x00, 0xa1, 0x00, 0x04, 0x00, 0x62, 0x69,
	0x72, 0x64, 0x00, 0x49, 0x74, 0x20, 0x74, 0x6f,
	0x6f, 0x6b, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20,
	0x64, 0x72, 0x75, 0x67, 0x73, 0x20, 0x74, 0x68,
	0x65, 0x6e, 0x20, 0x66, 0x65, 0x6c, 0x6c, 0x20,
	0x35, 0x20, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x2e, 0x00, 0x57, 0x68, 0x6f, 0x20, 0x77, 0x6f,
	0x75, 0x6c, 0x64, 0x6e, 0x27, 0x74, 0x20, 0x74,
	0x61, 0x6b, 0x65, 0x20, 0x61, 0x20, 0x6e, 0x61,
	0x70, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x61, 0x74, 0x3f, 0x00, 0x00, 0x44,
	0x75, 0x7d, 0x75, 0xd0, 0x75, 0x0a, 0x76, 0x5a,
	0x76, 0x73, 0x76, 0x8c, 0x76, 0x00, 0x00, 0x01,
	0x04, 0x00, 0x77, 0x00, 0x14, 0x00, 0x8d, 0x00,
	0xca, 0x00, 0xb3, 0x00, 0xca, 0x00, 0xb3, 0x00,
	0x04, 0x01, 0x73, 0x68, 0x6f, 0x76, 0x65, 0x6c,
	0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x61, 0x20,
	0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x20, 0x6d, 0x69,
	0x6c, 0x69, 0x74, 0x61, 0x72, 0x79, 0x20, 0x73,
	0x68, 0x6f, 0x76, 0x65, 0x6c, 0x2e, 0x00, 0x00,
	0x02, 0x7c, 0x00, 0xaa, 0x00, 0xcf, 0x00, 0xc0,
	0x00, 0xca, 0x00, 0xb3, 0x00, 0xca, 0x00, 0xb3,
	0x00, 0x04, 0x01, 0x73, 0x6f, 0x6c, 0x69, 0x64,
	0x20, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x00,
	0x49, 0x27, 0x76, 0x65, 0x20, 0x67, 0x6f, 0x74,
	0x20, 0x61, 0x20, 0x66, 0x65, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x20, 0x49, 0x27, 0x6d, 0x20, 0x67,
	0x6f, 0x6e, 0x6e, 0x61, 0x20, 0x6e, 0x65, 0x65,
	0x64, 0x20, 0x74, 0x68, 0x69, 0x73, 0x00, 0x73,
	0x6f, 0x6d, 0x65, 0x68, 0x6f, 0x77, 0x2e, 0x2e,
	0x2e, 0x00, 0x00, 0x03, 0xab, 0x00, 0x63, 0x00,
	0xba, 0x00, 0x97, 0x00, 0xe1, 0x00, 0x9f, 0x00,
	0xe1, 0x00, 0x9f, 0x00, 0x04, 0x01, 0x70, 0x6c,
	0x61, 0x6e, 0x74, 0x00, 0x49, 0x74, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65,
	0x20, 0x61, 0x20, 0x76, 0x65, 0x72, 0x79, 0x20,
	0x73, 0x6f, 0x66, 0x74, 0x20, 0x74, 0x6f, 0x75,
	0x63, 0x68, 0x2e, 0x00, 0x00, 0x04, 0x27, 0x00,
	0x53, 0x00, 0xaa, 0x00, 0xa1, 0x00, 0xca, 0x00,
	0xb3, 0x00, 0xca, 0x00, 0xb3, 0x00, 0x04, 0x01,
	0x62, 0x72, 0x69, 0x63, 0x6b, 0x20, 0x77, 0x61,
	0x6c, 0x6c, 0x00, 0x54, 0x68, 0x65, 0x20, 0x62,
	0x72, 0x69, 0x63, 0x6b, 0x2d, 0x6c, 0x61, 0x79,
	0x65, 0x72, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65,
	0x6e, 0x00, 0x61, 0x20, 0x50, 0x69, 0x6e, 0x6b,
	0x20, 0x46, 0x6c, 0x6f, 0x79, 0x64, 0x20, 0x66,
	0x61, 0x6e, 0x2e, 0x00, 0x00, 0x05, 0xe0, 0x00,
	0x7a, 0x00, 0x3f, 0x01, 0x9b, 0x00, 0x13, 0x01,
	0x89, 0x00, 0x3f, 0x01, 0x80, 0x00, 0x02, 0x01,
	0x70, 0x61, 0x74, 0x68, 0x00, 0x01, 0x06, 0xfa,
	0x00, 0x9c, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0x18,
	0x01, 0xb9, 0x00, 0x3f, 0x01, 0xb9, 0x00, 0x02,
	0x01, 0x70, 0x61, 0x74, 0x68, 0x00, 0x01, 0x07,
	0xb2, 0x00, 0xa1, 0x00, 0xc0, 0x00, 0xb4, 0x00,
	0xcb, 0x00, 0xb6, 0x00, 0xcb, 0x00, 0xb6, 0x00,
	0x04, 0x00, 0x73, 0x70, 0x72, 0x69, 0x6e, 0x67,
	0x00, 0x49, 0x27, 0x76, 0x65, 0x20, 0x73, 0x65,
	0x65, 0x6e, 0x20, 0x62, 0x65, 0x74, 0x74, 0x65,
	0x72, 0x20, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x20, 0x74, 0x6f, 0x20, 0x73, 0x69, 0x74, 0x20,
	0x6f, 0x6e, 0x2e, 0x00, 0x00, 0xda, 0x76, 0xf3,
	0x76, 0x0c, 0x77, 0x25, 0x77, 0x56, 0x77, 0x6f,
	0x77, 0xb1, 0x77, 0x00, 0x00, 0x01, 0x5c, 0x00,
	0xb4, 0x00, 0x92, 0x00, 0xc7, 0x00, 0x80, 0x00,
	0xb0, 0x00, 0x74, 0x00, 0xc7, 0x00, 0x03, 0x01,
	0x70, 0x61, 0x74, 0x68, 0x00, 0x01, 0x02, 0x00,
	0x00, 0x9c, 0x00, 0x2d, 0x00, 0xb6, 0x00, 0x23,
	0x00, 0xae, 0x00, 0x00, 0x00, 0xae, 0x00, 0x04,
	0x01, 0x70, 0x61, 0x74, 0x68, 0x00, 0x01, 0x03,
	0x23, 0x01, 0x00, 0x00, 0x3f, 0x01, 0x82, 0x00,
	0x2c, 0x01, 0x87, 0x00, 0x2c, 0x01, 0x87, 0x00,
	0x01, 0x01, 0x70, 0x61, 0x74, 0x68, 0x00, 0x01,
	0x04, 0x0b, 0x00, 0x47, 0x00, 0x42, 0x00, 0x9b,
	0x00, 0x28, 0x00, 0x9d, 0x00, 0x28, 0x00, 0x9d,
	0x00, 0x01, 0x01, 0x63, 0x61, 0x6e, 0x74, 0x65,
	0x65, 0x6e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x20,
	0x64, 0x6f, 0x6f, 0x72, 0x00, 0x4e, 0x69, 0x63,
	0x65, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x2e, 0x00,
	0x00, 0x05, 0x8c, 0x00, 0x47, 0x00, 0xbf, 0x00,
	0x9b, 0x00, 0xa6, 0x00, 0x9e, 0x00, 0xa6, 0x00,
	0x9e, 0x00, 0x01, 0x01, 0x64, 0x6f, 0x6f, 0x72,
	0x00, 0x01, 0x06, 0x04, 0x01, 0x35, 0x00, 0x22,
	0x01, 0x94, 0x00, 0x22, 0x01, 0x8f, 0x00, 0x14,
	0x01, 0x8f, 0x00, 0x04, 0x01, 0x6a, 0x61, 0x69,
	0x6c, 0x20, 0x64, 0x6f, 0x6f, 0x72, 0x00, 0x4e,
	0x6f, 0x77, 0x20, 0x74, 0x68, 0x61, 0x74, 0x27,
	0x73, 0x20, 0x77, 0x68, 0x61, 0x74, 0x00, 0x49,
	0x20, 0x63, 0x61, 0x6c, 0x6c, 0x20, 0x61, 0x20,
	0x67, 0x6f, 0x6f, 0x64, 0x00, 0x64, 0x6f, 0x6f,
	0x72, 0x2e, 0x00, 0x00, 0x07, 0x4b, 0x00, 0x65,
	0x00, 0x65, 0x00, 0xa0, 0x00, 0x6d, 0x00, 0xa1,
	0x00, 0x6d, 0x00, 0xa1, 0x00, 0x04, 0x01, 0x74,
	0x72, 0x61, 0x73, 0x68, 0x20, 0x63, 0x61, 0x6e,
	0x00, 0x49, 0x74, 0x20, 0x73, 0x74, 0x69, 0x6e,
	0x6b, 0x73, 0x2e, 0x00, 0x00, 0xf0, 0x77, 0x2c,
	0x78, 0x4f, 0x78, 0x96, 0x78, 0xcd, 0x78, 0x03,
	0x79, 0x3e, 0x79, 0x68, 0x79, 0x86, 0x79, 0xa1,
	0x79, 0x00, 0x00, 0x01, 0x6b, 0x00, 0x9c, 0x00,
	0x84, 0x00, 0xa9, 0x00, 0x91, 0x00, 0xb3, 0x00,
	0x91, 0x00, 0xb3, 0x00, 0x04, 0x01, 0x73, 0x70,
	0x72, 0x69, 0x6e, 0x67, 0x00, 0x59, 0x65, 0x61,
	0x68, 0x2c, 0x20, 0x49, 0x20, 0x64, 0x65, 0x66,
	0x69, 0x6e, 0x65, 0x74, 0x65, 0x6c, 0x79, 0x20,
	0x67, 0x6f, 0x74, 0x74, 0x61, 0x20, 0x73, 0x70,
	0x72, 0x69, 0x6e, 0x67, 0x2e, 0x00, 0x00, 0x02,
	0x1f, 0x00, 0x9c, 0x00, 0x90, 0x00, 0xbb, 0x00,
	0x50, 0x00, 0xc0, 0x00, 0x50, 0x00, 0xc0, 0x00,
	0x01, 0x01, 0x62, 0x65, 0x64, 0x00, 0x4c, 0x6f,
	0x6f, 0x6b, 0x73, 0x20, 0x62, 0x61, 0x64, 0x2e,
	0x00, 0x00, 0x03, 0x1e, 0x01, 0x71, 0x00, 0x32,
	0x01, 0x7e, 0x00, 0x09, 0x01, 0xb4, 0x00, 0x09,
	0x01, 0xb4, 0x00, 0x02, 0x01, 0x63, 0x72, 0x61,
	0x74, 0x65, 0x73, 0x00, 0x54, 0x68, 0x65, 0x20,
	0x77, 0x6f, 0x72, 0x6c, 0x64, 0x20, 0x6c, 0x6f,
	0x6f, 0x6b, 0x73, 0x20, 0x62, 0x65, 0x74, 0x74,
	0x65, 0x72, 0x00, 0x66, 0x72, 0x6f, 0x6d, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65,
	0x72, 0x20, 0x73, 0x69, 0x64, 0x65, 0x2e, 0x00,
	0x00, 0x04, 0x1b, 0x01, 0x87, 0x00, 0x2d, 0x01,
	0x92, 0x00, 0x09, 0x01, 0xb4, 0x00, 0x09, 0x01,
	0xb4, 0x00, 0x02, 0x00, 0x62, 0x6f, 0x77, 0x6c,
	0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x6d, 0x61,
	0x64, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x6c,
	0x75, 0x6d, 0x69, 0x6e, 0x69, 0x75, 0x6d, 0x2e,
	0x00, 0x00, 0x62, 0x6f, 0x64, 0x79, 0x00, 0xff,
	0x05, 0x0a, 0x01, 0xaa, 0x00, 0x20, 0x01, 0xbe,
	0x00, 0x0a, 0x01, 0xbd, 0x00, 0x0a, 0x01, 0xbd,
	0x00, 0x02, 0x00, 0x6c, 0x69, 0x76, 0x65, 0x20,
	0x63, 0x61, 0x62, 0x6c, 0x65, 0x00, 0x54, 0x68,
	0x65, 0x20, 0x77, 0x69, 0x72, 0x65, 0x73, 0x20,
	0x61, 0x72, 0x65, 0x20, 0x65, 0x78, 0x70, 0x6f,
	0x73, 0x65, 0x64, 0x21, 0x00, 0x00, 0x06, 0x9b,
	0x00, 0x5a, 0x00, 0xa4, 0x00, 0x6b, 0x00, 0x9f,
	0x00, 0xc2, 0x00, 0x9f, 0x00, 0xc2, 0x00, 0x01,
	0x01, 0x62, 0x75, 0x6c, 0x62, 0x00, 0x49, 0x74,
	0x27, 0x73, 0x20, 0x6e, 0x61, 0x6b, 0x65, 0x64,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x74, 0x27,
	0x73, 0x20, 0x6f, 0x75, 0x74, 0x20, 0x6f, 0x66,
	0x20, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x2e, 0x00,
	0x00, 0x07, 0x15, 0x01, 0x62, 0x00, 0x35, 0x01,
	0xbd, 0x00, 0x09, 0x01, 0xb4, 0x00, 0x09, 0x01,
	0xb4, 0x00, 0x02, 0x01, 0x64, 0x6f, 0x6f, 0x72,
	0x00, 0x48, 0x65, 0x61, 0x76, 0x79, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x73, 0x6f, 0x6c, 0x69, 0x64,
	0x2e, 0x00, 0x00, 0x08, 0xfa, 0x00, 0x93, 0x00,
	0x0e, 0x01, 0xad, 0x00, 0xf2, 0x00, 0xad, 0x00,
	0xf2, 0x00, 0xad, 0x00, 0x02, 0x01, 0x74, 0x72,
	0x61, 0x73, 0x68, 0x20, 0x63, 0x61, 0x6e, 0x00,
	0x01, 0x09, 0x38, 0x01, 0x8a, 0x00, 0x3f, 0x01,
	0x91, 0x00, 0x32, 0x01, 0xc4, 0x00, 0x32, 0x01,
	0xc4, 0x00, 0x02, 0x01, 0x73, 0x77, 0x69, 0x74,
	0x63, 0x68, 0x00, 0x01, 0x0a, 0x38, 0x00, 0x7a,
	0x00, 0xd0, 0x00, 0x9a, 0x00, 0x99, 0x00, 0xb2,
	0x00, 0x99, 0x00, 0xb2, 0x00, 0x01, 0x01, 0x67,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x74, 0x69, 0x00,
	0x01, 0xd8, 0x79, 0x08, 0x7a, 0x21, 0x7a, 0x61,
	0x7a, 0x82, 0x7a, 0xbb, 0x7a, 0xf2, 0x7a, 0x1a,
	0x7b, 0x94, 0x7b, 0xd1, 0x7b, 0xed, 0x7b, 0x17,
	0x7c, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x82, 0x00, 0xc3, 0x00,
	0x82, 0x00, 0xc3, 0x00, 0x01, 0x01, 0x63, 0x61,
	0x70, 0x74, 0x61, 0x69, 0x6e, 0x00, 0x48, 0x65,
	0x27, 0x73, 0x20, 0x73, 0x69, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x20, 0x74, 0x69, 0x67, 0x68, 0x74,
	0x2e, 0x00, 0x00, 0x02, 0x00, 0x00, 0x50, 0x00,
	0x23, 0x00, 0xbc, 0x00, 0x32, 0x00, 0xb8, 0x00,
	0x13, 0x00, 0xb8, 0x00, 0x04, 0x01, 0x64, 0x6f,
	0x6f, 0x72, 0x00, 0x01, 0x03, 0x2c, 0x00, 0x61,
	0x00, 0x4e, 0x00, 0xa4, 0x00, 0x40, 0x00, 0xa6,
	0x00, 0x40, 0x00, 0xa6, 0x00, 0x01, 0x01, 0x6c,
	0x6f, 0x63, 0x6b, 0x65, 0x72, 0x00, 0x49, 0x74,
	0x27, 0x73, 0x20, 0x63, 0x6c, 0x6f, 0x73, 0x65,
	0x64, 0x2e, 0x20, 0x4e, 0x6f, 0x74, 0x20, 0x74,
	0x68, 0x61, 0x74, 0x00, 0x49, 0x27, 0x6d, 0x20,
	0x73, 0x75, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x64, 0x2e, 0x00, 0x00, 0x04, 0x6b, 0x00, 0x51,
	0x00, 0xcd, 0x00, 0x8c, 0x00, 0x9e, 0x00, 0xa8,
	0x00, 0x9e, 0x00, 0xa8, 0x00, 0x01, 0x01, 0x6d,
	0x61, 0x70, 0x00, 0x50, 0x69, 0x63, 0x61, 0x73,
	0x73, 0x6f, 0x3f, 0x00, 0x00, 0x05, 0x8c, 0x00,
	0x94, 0x00, 0xd6, 0x00, 0x9e, 0x00, 0xa4, 0x00,
	0xc6, 0x00, 0xa4, 0x00, 0xc6, 0x00, 0x01, 0x01,
	0x64, 0x65, 0x73, 0x6b, 0x00, 0x54, 0x68, 0x61,
	0x74, 0x27, 0x73, 0x20, 0x6a, 0x75, 0x73, 0x74,
	0x20, 0x61, 0x20, 0x6c, 0x6f, 0x61, 0x64, 0x20,
	0x6f, 0x66, 0x20, 0x6f, 0x6c, 0x64, 0x20, 0x6a,
	0x75, 0x6e, 0x6b, 0x2e, 0x00, 0x00, 0x06, 0xee,
	0x00, 0x83, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0xf1,
	0x00, 0xb5, 0x00, 0xf1, 0x00, 0xb5, 0x00, 0x02,
	0x01, 0x62, 0x65, 0x64, 0x00, 0x54, 0x68, 0x61,
	0x74, 0x20, 0x64, 0x6f, 0x65, 0x73, 0x6e, 0x27,
	0x74, 0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x20, 0x63,
	0x6f, 0x6d, 0x66, 0x6f, 0x72, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x00, 0x00, 0x07, 0xbf, 0x00,
	0xa2, 0x00, 0xd9, 0x00, 0xb9, 0x00, 0xcc, 0x00,
	0xc2, 0x00, 0xcc, 0x00, 0xc2, 0x00, 0x01, 0x01,
	0x64, 0x72, 0x61, 0x77, 0x65, 0x72, 0x00, 0x49,
	0x74, 0x27, 0x73, 0x20, 0x63, 0x6c, 0x6f, 0x73,
	0x65, 0x64, 0x21, 0x00, 0x00, 0x08, 0xd5, 0x00,
	0x5d, 0x00, 0xe8, 0x00, 0x8a, 0x00, 0xf1, 0x00,
	0xb5, 0x00, 0xf1, 0x00, 0xb5, 0x00, 0x01, 0x01,
	0x73, 0x61, 0x62, 0x72, 0x65, 0x73, 0x00, 0x4d,
	0x79, 0x20, 0x67, 0x72, 0x61, 0x6e, 0x64, 0x70,
	0x61, 0x20, 0x68, 0x61, 0x64, 0x20, 0x6f, 0x6e,
	0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x6f,
	0x73, 0x65, 0x20, 0x6f, 0x6e, 0x63, 0x65, 0x2e,
	0x00, 0x49, 0x20, 0x65, 0x78, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x64, 0x20, 0x69, 0x74, 0x20,
	0x66, 0x6f, 0x72, 0x20, 0x61, 0x20, 0x6a, 0x6f,
	0x79, 0x73, 0x74, 0x69, 0x63, 0x6b, 0x2e, 0x00,
	0x47, 0x72, 0x61, 0x6e, 0x64, 0x70, 0x61, 0x20,
	0x64, 0x69, 0x64, 0x6e, 0x27, 0x74, 0x20, 0x6c,
	0x69, 0x6b, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x69, 0x64, 0x65, 0x61, 0x2e, 0x00, 0x00, 0x09,
	0xef, 0x00, 0x5e, 0x00, 0x15, 0x01, 0x7a, 0x00,
	0xf1, 0x00, 0xb5, 0x00, 0xf1, 0x00, 0xb5, 0x00,
	0x01, 0x01, 0x67, 0x75, 0x6e, 0x73, 0x00, 0x57,
	0x68, 0x61, 0x74, 0x20, 0x61, 0x20, 0x70, 0x69,
	0x74, 0x79, 0x20, 0x74, 0x68, 0x65, 0x79, 0x20,
	0x61, 0x72, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79,
	0x00, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2e,
	0x2e, 0x2e, 0x00, 0x00, 0x0a, 0x2d, 0x00, 0x27,
	0x00, 0x53, 0x00, 0x56, 0x00, 0x32, 0x00, 0xb5,
	0x00, 0x32, 0x00, 0xb5, 0x00, 0x01, 0x01, 0x70,
	0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x00, 0x01,
	0x0b, 0xde, 0x00, 0x2b, 0x00, 0x1d, 0x01, 0x53,
	0x00, 0xf1, 0x00, 0xb5, 0x00, 0xf1, 0x00, 0xb5,
	0x00, 0x01, 0x01, 0x70, 0x69, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x00, 0x4e, 0x69, 0x63, 0x65, 0x20,
	0x63, 0x68, 0x6f, 0x70, 0x70, 0x65, 0x72, 0x2e,
	0x00, 0x00, 0x0c, 0x7b, 0x00, 0xac, 0x00, 0x89,
	0x00, 0xbb, 0x00, 0x81, 0x00, 0xbf, 0x00, 0x81,
	0x00, 0xbf, 0x00, 0x01, 0x00, 0x20, 0x53, 0x77,
	0x69, 0x73, 0x73, 0x20, 0x41, 0x72, 0x6d, 0x79,
	0x20, 0x6b, 0x6e, 0x69, 0x66, 0x65, 0x00, 0x54,
	0x68, 0x61, 0x74, 0x27, 0x73, 0x20, 0x6d, 0x6f,
	0x72, 0x65, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x20,
	0x69, 0x74, 0x2e, 0x00, 0x00, 0x66, 0x7c, 0xa8,
	0x7c, 0xe0, 0x7c, 0xf9, 0x7c, 0x34, 0x7d, 0x9b,
	0x7d, 0xf7, 0x7d, 0x3a, 0x7e, 0xba, 0x7e, 0x00,
	0x00, 0x01, 0xbb, 0x00, 0x63, 0x00, 0xc4, 0x00,
	0x6b, 0x00, 0xc0, 0x00, 0x98, 0x00, 0xc0, 0x00,
	0x98, 0x00, 0x01, 0x00, 0x6d, 0x75, 0x67, 0x00,
	0x54, 0x68, 0x61, 0x74, 0x27, 0x73, 0x20, 0x73,
	0x75, 0x72, 0x70, 0x72, 0x69, 0x73, 0x69, 0x6e,
	0x67, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x74,
	0x68, 0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x74,
	0x65, 0x61, 0x00, 0x69, 0x6e, 0x20, 0x69, 0x74,
	0x2e, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xb1, 0x00, 0x98, 0x00,
	0xb1, 0x00, 0x98, 0x00, 0x01, 0x01, 0x62, 0x61,
	0x72, 0x6d, 0x61, 0x6e, 0x00, 0x57, 0x68, 0x61,
	0x74, 0x20, 0x61, 0x20, 0x68, 0x61, 0x72, 0x64,
	0x20, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67,
	0x20, 0x63, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x6e,
	0x2e, 0x00, 0x00, 0x03, 0x5e, 0x00, 0xb6, 0x00,
	0xce, 0x00, 0xc7, 0x00, 0x9e, 0x00, 0xb8, 0x00,
	0x9b, 0x00, 0xc7, 0x00, 0x03, 0x01, 0x65, 0x78,
	0x69, 0x74, 0x00, 0x01, 0x04, 0x10, 0x00, 0x34,
	0x00, 0x26, 0x00, 0x92, 0x00, 0x28, 0x00, 0x98,
	0x00, 0x28, 0x00, 0x98, 0x00, 0x01, 0x01, 0x64,
	0x6f, 0x6f, 0x72, 0x00, 0x54, 0x68, 0x69, 0x73,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x6c, 0x65,
	0x61, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x20,
	0x72, 0x6f, 0x6f, 0x6d, 0x2e, 0x00, 0x00, 0x05,
	0x34, 0x00, 0x2b, 0x00, 0x59, 0x00, 0x48, 0x00,
	0x4d, 0x00, 0x98, 0x00, 0x4d, 0x00, 0x98, 0x00,
	0x01, 0x01, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x00,
	0x54, 0x68, 0x65, 0x20, 0x72, 0x61, 0x64, 0x69,
	0x6f, 0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x73, 0x20,
	0x6c, 0x69, 0x6b, 0x65, 0x20, 0x61, 0x20, 0x72,
	0x61, 0x64, 0x69, 0x6f, 0x2c, 0x20, 0x62, 0x75,
	0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x00, 0x69, 0x73, 0x20,
	0x6d, 0x61, 0x64, 0x65, 0x20, 0x6f, 0x66, 0x20,
	0x73, 0x6f, 0x6d, 0x65, 0x20, 0x6b, 0x69, 0x6e,
	0x64, 0x20, 0x6f, 0x66, 0x20, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x72, 0x2e, 0x00, 0x00, 0x06, 0x0a,
	0x01, 0x9f, 0x00, 0x17, 0x01, 0xa6, 0x00, 0x04,
	0x01, 0xc2, 0x00, 0x04, 0x01, 0xc2, 0x00, 0x02,
	0x01, 0x63, 0x72, 0x75, 0x6d, 0x62, 0x73, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x64, 0x69, 0x73,
	0x67, 0x75, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x20, 0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20,
	0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x73,
	0x68, 0x6f, 0x75, 0x6c, 0x64, 0x00, 0x63, 0x6c,
	0x65, 0x61, 0x6e, 0x20, 0x75, 0x70, 0x20, 0x61,
	0x66, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65,
	0x6d, 0x73, 0x65, 0x6c, 0x76, 0x65, 0x73, 0x2e,
	0x00, 0x00, 0x07, 0x62, 0x00, 0x23, 0x00, 0x75,
	0x00, 0x35, 0x00, 0x6e, 0x00, 0x98, 0x00, 0x6e,
	0x00, 0x98, 0x00, 0x01, 0x01, 0x63, 0x6c, 0x6f,
	0x63, 0x6b, 0x00, 0x49, 0x74, 0x20, 0x6c, 0x6f,
	0x6f, 0x6b, 0x73, 0x20, 0x6c, 0x69, 0x6b, 0x65,
	0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x27, 0x73,
	0x20, 0x61, 0x20, 0x70, 0x72, 0x6f, 0x62, 0x6c,
	0x65, 0x6d, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20,
	0x69, 0x74, 0x2e, 0x00, 0x00, 0x08, 0x7e, 0x00,
	0x22, 0x00, 0x00, 0x01, 0x69, 0x00, 0xc8, 0x00,
	0x98, 0x00, 0xc8, 0x00, 0x98, 0x00, 0x01, 0x01,
	0x73, 0x68, 0x65, 0x6c, 0x76, 0x65, 0x73, 0x00,
	0x49, 0x20, 0x77, 0x6f, 0x6e, 0x64, 0x65, 0x72,
	0x20, 0x77, 0x68, 0x79, 0x20, 0x74, 0x68, 0x65,
	0x72, 0x65, 0x27, 0x73, 0x20, 0x73, 0x75, 0x63,
	0x68, 0x20, 0x61, 0x20, 0x6c, 0x61, 0x72, 0x67,
	0x65, 0x20, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65,
	0x00, 0x6f, 0x66, 0x20, 0x61, 0x6c, 0x63, 0x6f,
	0x68, 0x6f, 0x6c, 0x20, 0x61, 0x74, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x20, 0x63, 0x61, 0x6d, 0x70,
	0x2e, 0x00, 0x54, 0x6f, 0x20, 0x6b, 0x65, 0x65,
	0x70, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x72,
	0x6f, 0x6f, 0x70, 0x73, 0x20, 0x68, 0x61, 0x70,
	0x70, 0x79, 0x3f, 0x00, 0x00, 0x09, 0x41, 0x00,
	0x59, 0x00, 0x5b, 0x00, 0x69, 0x00, 0x4d, 0x00,
	0x98, 0x00, 0x4d, 0x00, 0x98, 0x00, 0x01, 0x01,
	0x63, 0x61, 0x73, 0x68, 0x20, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x65, 0x72, 0x00, 0x49, 0x20,
	0x6c, 0x6f, 0x76, 0x65, 0x20, 0x69, 0x74, 0x2e,
	0x00, 0x00, 0xf7, 0x7e, 0x29, 0x7f, 0x42, 0x7f,
	0x8b, 0x7f, 0xc4, 0x7f, 0xfc, 0x7f, 0x1d, 0x80,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0x00, 0xb4, 0x00, 0x32,
	0x00, 0xb4, 0x00, 0x01, 0x01, 0x62, 0x6c, 0x69,
	0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x68, 0x6f,
	0x6c, 0x65, 0x00, 0x54, 0x68, 0x61, 0x74, 0x27,
	0x73, 0x20, 0x77, 0x65, 0x69, 0x72, 0x64, 0x2e,
	0x2e, 0x2e, 0x00, 0x00, 0x02, 0x0c, 0x01, 0x55,
	0x00, 0x29, 0x01, 0xaa, 0x00, 0xf0, 0x00, 0xb6,
	0x00, 0xf0, 0x00, 0xb6, 0x00, 0x02, 0x01, 0x64,
	0x6f, 0x6f, 0x72, 0x00, 0x01, 0x03, 0x04, 0x00,
	0x6c, 0x00, 0x5b, 0x00, 0xb2, 0x00, 0x32, 0x00,
	0xb4, 0x00, 0x32, 0x00, 0xb4, 0x00, 0x01, 0x01,
	0x62, 0x61, 0x72, 0x72, 0x65, 0x6c, 0x73, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x67, 0x6f, 0x6f,
	0x64, 0x20, 0x74, 0x6f, 0x20, 0x6b, 0x6e, 0x6f,
	0x77, 0x20, 0x6f, 0x75, 0x72, 0x20, 0x61, 0x72,
	0x6d, 0x79, 0x20, 0x69, 0x73, 0x20, 0x77, 0x65,
	0x6c, 0x6c, 0x20, 0x65, 0x71, 0x75, 0x69, 0x70,
	0x70, 0x65, 0x64, 0x2e, 0x00, 0x00, 0x04, 0x5a,
	0x00, 0x5f, 0x00, 0x78, 0x00, 0xa8, 0x00, 0x70,
	0x00, 0xad, 0x00, 0x70, 0x00, 0xad, 0x00, 0x01,
	0x01, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x61, 0x20, 0x6c,
	0x6f, 0x63, 0x6b, 0x65, 0x64, 0x20, 0x6b, 0x69,
	0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x6c, 0x6f,
	0x63, 0x6b, 0x65, 0x72, 0x2e, 0x00, 0x00, 0x05,
	0x96, 0x00, 0x6b, 0x00, 0xd6, 0x00, 0xa4, 0x00,
	0xb7, 0x00, 0xb2, 0x00, 0xb7, 0x00, 0xb2, 0x00,
	0x01, 0x01, 0x6c, 0x6f, 0x74, 0x73, 0x20, 0x6f,
	0x66, 0x20, 0x64, 0x72, 0x61, 0x77, 0x65, 0x72,
	0x73, 0x00, 0x49, 0x20, 0x68, 0x61, 0x74, 0x65,
	0x20, 0x62, 0x75, 0x72, 0x65, 0x61, 0x75, 0x63,
	0x72, 0x61, 0x63, 0x79, 0x2e, 0x00, 0x00, 0x06,
	0x7e, 0x00, 0x8f, 0x00, 0x97, 0x00, 0xaa, 0x00,
	0x8d, 0x00, 0xb1, 0x00, 0x8d, 0x00, 0xb1, 0x00,
	0x01, 0x01, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x00,
	0x27, 0x50, 0x65, 0x70, 0x61, 0x27, 0x00, 0x00,
	0x07, 0xd7, 0x00, 0x81, 0x00, 0xea, 0x00, 0xaa,
	0x00, 0xe0, 0x00, 0xb6, 0x00, 0xe0, 0x00, 0xb6,
	0x00, 0x01, 0x01, 0x62, 0x6f, 0x78, 0x65, 0x73,
	0x00, 0x27, 0x53, 0x61, 0x6c, 0x74, 0x27, 0x00,
	0x00, 0x48, 0x80, 0x87, 0x80, 0xd1, 0x80, 0x01,
	0x81, 0x00, 0x00, 0x01, 0x7e, 0x00, 0x5f, 0x00,
	0x86, 0x00, 0x69, 0x00, 0x8b, 0x00, 0x9c, 0x00,
	0x84, 0x00, 0x95, 0x00, 0x01, 0x00, 0x67, 0x72,
	0x65, 0x6e, 0x61, 0x64, 0x65, 0x00, 0x57, 0x6f,
	0x77, 0x21, 0x20, 0x49, 0x20, 0x61, 0x6c, 0x77,
	0x61, 0x79, 0x73, 0x20, 0x77, 0x61, 0x6e, 0x74,
	0x65, 0x64, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f,
	0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x2e,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x8b, 0x00, 0x9c, 0x00, 0x8b,
	0x00, 0x9c, 0x00, 0x01, 0x01, 0x67, 0x75, 0x61,
	0x72, 0x64, 0x00, 0x49, 0x20, 0x64, 0x6f, 0x6e,
	0x27, 0x74, 0x20, 0x74, 0x68, 0x69, 0x6e, 0x6b,
	0x20, 0x68, 0x65, 0x27, 0x73, 0x20, 0x6d, 0x61,
	0x6b, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x69,
	0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x00, 0x00, 0x03, 0x00, 0x00, 0x6f,
	0x00, 0x54, 0x00, 0xa2, 0x00, 0x53, 0x00, 0x95,
	0x00, 0x53, 0x00, 0x95, 0x00, 0x04, 0x01, 0x77,
	0x61, 0x79, 0x20, 0x6f, 0x75, 0x74, 0x00, 0x48,
	0x6f, 0x6d, 0x65, 0x2c, 0x20, 0x73, 0x77, 0x65,
	0x65, 0x74, 0x20, 0x68, 0x6f, 0x6d, 0x65, 0x2e,
	0x2e, 0x2e, 0x00, 0x00, 0x04, 0x10, 0x01, 0x95,
	0x00, 0x3f, 0x01, 0xc7, 0x00, 0x0d, 0x01, 0xaf,
	0x00, 0x3f, 0x01, 0xb7, 0x00, 0x02, 0x01, 0x70,
	0x61, 0x74, 0x68, 0x00, 0x01, 0x3a, 0x81, 0x79,
	0x81, 0xa3, 0x81, 0xc0, 0x81, 0xdd, 0x81, 0x11,
	0x82, 0x3d, 0x82, 0x7f, 0x82, 0xa4, 0x82, 0xcc,
	0x82, 0x1a, 0x83, 0x3c, 0x83, 0x64, 0x83, 0xb8,
	0x83, 0xea, 0x83, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8a, 0x00,
	0xa3, 0x00, 0x8a, 0x00, 0xa3, 0x00, 0x02, 0x01,
	0x67, 0x75, 0x61, 0x72, 0x64, 0x00, 0x48, 0x65,
	0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x6c,
	0x69, 0x6b, 0x65, 0x20, 0x61, 0x20, 0x70, 0x65,
	0x61, 0x73, 0x61, 0x6e, 0x74, 0x20, 0x69, 0x6e,
	0x00, 0x64, 0x69, 0x73, 0x67, 0x75, 0x69, 0x73,
	0x65, 0x2e, 0x00, 0x00, 0x02, 0x70, 0x00, 0xa0,
	0x00, 0x7b, 0x00, 0xa8, 0x00, 0x68, 0x00, 0xab,
	0x00, 0x68, 0x00, 0xab, 0x00, 0x02, 0x00, 0x62,
	0x6f, 0x74, 0x74, 0x6c, 0x65, 0x00, 0x49, 0x74,
	0x27, 0x73, 0x20, 0x77, 0x68, 0x69, 0x73, 0x6b,
	0x79, 0x21, 0x2e, 0x2e, 0x00, 0x00, 0x03, 0xd2,
	0x00, 0x77, 0x00, 0xf6, 0x00, 0x98, 0x00, 0x8a,
	0x00, 0xa3, 0x00, 0x8a, 0x00, 0xa3, 0x00, 0x02,
	0x01, 0x67, 0x61, 0x72, 0x67, 0x6f, 0x79, 0x6c,
	0x65, 0x00, 0x01, 0x04, 0x09, 0x01, 0x80, 0x00,
	0x2f, 0x01, 0xad, 0x00, 0x8a, 0x00, 0xa3, 0x00,
	0x8a, 0x00, 0xa3, 0x00, 0x02, 0x01, 0x67, 0x61,
	0x72, 0x67, 0x6f, 0x79, 0x6c, 0x65, 0x00, 0x01,
	0x05, 0x12, 0x01, 0x39, 0x00, 0x23, 0x01, 0x48,
	0x00, 0x8a, 0x00, 0xa3, 0x00, 0x8a, 0x00, 0xa3,
	0x00, 0x02, 0x01, 0x73, 0x63, 0x75, 0x6c, 0x70,
	0x74, 0x75, 0x72, 0x65, 0x00, 0x52, 0x65, 0x61,
	0x6c, 0x6c, 0x79, 0x20, 0x73, 0x6f, 0x70, 0x68,
	0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x21, 0x00, 0x00, 0x06, 0xfc, 0x00, 0x33,
	0x00, 0x32, 0x01, 0xa1, 0x00, 0x8a, 0x00, 0xa3,
	0x00, 0x8a, 0x00, 0xa3, 0x00, 0x02, 0x01, 0x64,
	0x6f, 0x6f, 0x72, 0x00, 0x53, 0x6f, 0x6c, 0x69,
	0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6d, 0x61,
	0x73, 0x73, 0x69, 0x76, 0x65, 0x2e, 0x00, 0x00,
	0x07, 0xe5, 0x00, 0x00, 0x00, 0x3f, 0x01, 0x98,
	0x00, 0x8a, 0x00, 0xa3, 0x00, 0x8a, 0x00, 0xa3,
	0x00, 0x02, 0x01, 0x6d, 0x61, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x20, 0x77, 0x61, 0x6c, 0x6c, 0x00,
	0x49, 0x74, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x33, 0x20, 0x6b, 0x69, 0x6c,
	0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x20,
	0x74, 0x68, 0x69, 0x63, 0x6b, 0x2e, 0x2e, 0x2e,
	0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb5, 0x00, 0xb0, 0x00, 0xb5,
	0x00, 0xb0, 0x00, 0x01, 0x00, 0x4a, 0x6f, 0x68,
	0x6e, 0x20, 0x4e, 0x6f, 0x74, 0x79, 0x00, 0x46,
	0x61, 0x74, 0x73, 0x6f, 0x2e, 0x00, 0x00, 0x09,
	0x9c, 0x00, 0xae, 0x00, 0x3f, 0x01, 0xc7, 0x00,
	0x8a, 0x00, 0xa3, 0x00, 0x3f, 0x01, 0xc6, 0x00,
	0x02, 0x01, 0x70, 0x61, 0x74, 0x68, 0x20, 0x61,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x6d, 0x61,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x00, 0x01, 0x0a,
	0x00, 0x00, 0x73, 0x00, 0x46, 0x00, 0x98, 0x00,
	0x3c, 0x00, 0xab, 0x00, 0x00, 0x00, 0x7c, 0x00,
	0x01, 0x01, 0x70, 0x61, 0x74, 0x68, 0x20, 0x74,
	0x6f, 0x20, 0x6d, 0x65, 0x61, 0x64, 0x6f, 0x77,
	0x00, 0x49, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x20, 0x69, 0x6e, 0x73, 0x69, 0x64, 0x65,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x61, 0x72,
	0x6b, 0x20, 0x61, 0x6e, 0x64, 0x00, 0x73, 0x63,
	0x61, 0x72, 0x79, 0x20, 0x66, 0x6f, 0x72, 0x65,
	0x73, 0x74, 0x2e, 0x00, 0x00, 0x0b, 0x00, 0x00,
	0xa1, 0x00, 0x39, 0x00, 0xbe, 0x00, 0x3c, 0x00,
	0xab, 0x00, 0x00, 0x00, 0xab, 0x00, 0x04, 0x01,
	0x70, 0x61, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x20,
	0x73, 0x68, 0x6f, 0x72, 0x65, 0x00, 0x01, 0x0c,
	0x8c, 0x00, 0x68, 0x00, 0xe4, 0x00, 0x98, 0x00,
	0x8a, 0x00, 0xa3, 0x00, 0xe4, 0x00, 0x6d, 0x00,
	0x02, 0x01, 0x70, 0x61, 0x74, 0x68, 0x20, 0x61,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x6d, 0x61,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x00, 0x01, 0x0d,
	0xbf, 0x00, 0xa6, 0x00, 0xc8, 0x00, 0xae, 0x00,
	0x8a, 0x00, 0xa3, 0x00, 0xb5, 0x00, 0xb0, 0x00,
	0x02, 0x01, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x72, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x61,
	0x20, 0x63, 0x65, 0x6c, 0x6c, 0x6f, 0x70, 0x68,
	0x61, 0x6e, 0x65, 0x20, 0x77, 0x72, 0x61, 0x70,
	0x70, 0x65, 0x72, 0x20, 0x66, 0x72, 0x6f, 0x6d,
	0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x63, 0x61,
	0x6e, 0x64, 0x79, 0x00, 0x6f, 0x72, 0x20, 0x73,
	0x6f, 0x6d, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x2e, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0xe4, 0x00, 0x98, 0x00, 0x3c, 0x00, 0xab, 0x00,
	0x3c, 0x00, 0xab, 0x00, 0x01, 0x01, 0x66, 0x6f,
	0x72, 0x65, 0x73, 0x74, 0x00, 0x49, 0x74, 0x20,
	0x67, 0x69, 0x76, 0x65, 0x73, 0x20, 0x6d, 0x65,
	0x20, 0x74, 0x68, 0x72, 0x69, 0x6c, 0x6c, 0x73,
	0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x0f, 0x78, 0x00,
	0x9a, 0x00, 0x85, 0x00, 0xa0, 0x00, 0x70, 0x00,
	0xa3, 0x00, 0x70, 0x00, 0xa3, 0x00, 0x02, 0x00,
	0x62, 0x61, 0x6e, 0x6b, 0x6e, 0x6f, 0x74, 0x65,
	0x00, 0x49, 0x27, 0x6d, 0x20, 0x72, 0x65, 0x61,
	0x6c, 0x6c, 0x79, 0x20, 0x70, 0x72, 0x6f, 0x75,
	0x64, 0x20, 0x49, 0x20, 0x64, 0x69, 0x64, 0x6e,
	0x27, 0x74, 0x20, 0x54, 0x41, 0x4b, 0x45, 0x20,
	0x54, 0x48, 0x41, 0x54, 0x2e, 0x00, 0x00, 0x40,
	0x84, 0x56, 0x84, 0x87, 0x84, 0xb6, 0x84, 0xf2,
	0x84, 0x29, 0x85, 0x66, 0x85, 0x8e, 0x85, 0xb6,
	0x85, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x04, 0x01, 0x74, 0x00, 0x13, 0x01,
	0x8a, 0x00, 0x02, 0x01, 0xbd, 0x00, 0x02, 0x01,
	0xbd, 0x00, 0x01, 0x01, 0x68, 0x6f, 0x6c, 0x6c,
	0x6f, 0x77, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x20, 0x72, 0x69,
	0x67, 0x68, 0x74, 0x20, 0x6e, 0x6f, 0x77, 0x2e,
	0x00, 0x00, 0x03, 0xd0, 0x00, 0x6e, 0x00, 0xf8,
	0x00, 0x7e, 0x00, 0xcb, 0x00, 0xab, 0x00, 0xcb,
	0x00, 0xab, 0x00, 0x02, 0x01, 0x62, 0x72, 0x61,
	0x6e, 0x63, 0x68, 0x00, 0x49, 0x74, 0x20, 0x63,
	0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62, 0x65, 0x20,
	0x75, 0x73, 0x65, 0x66, 0x75, 0x6c, 0x2e, 0x00,
	0x00, 0x04, 0xe4, 0x00, 0x3c, 0x00, 0x2d, 0x01,
	0xaa, 0x00, 0x02, 0x01, 0xbd, 0x00, 0xfc, 0x00,
	0xab, 0x00, 0x01, 0x01, 0x74, 0x72, 0x65, 0x65,
	0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x68, 0x69,
	0x67, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x61,
	0x6c, 0x6c, 0x21, 0x00, 0x00, 0x05, 0x0c, 0x00,
	0x8a, 0x00, 0x33, 0x00, 0xad, 0x00, 0x31, 0x00,
	0xac, 0x00, 0x31, 0x00, 0xac, 0x00, 0x04, 0x01,
	0x77, 0x69, 0x6c, 0x64, 0x20, 0x70, 0x6c, 0x61,
	0x6e, 0x74, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20,
	0x73, 0x6f, 0x6d, 0x65, 0x20, 0x77, 0x69, 0x6c,
	0x64, 0x20, 0x70, 0x6f, 0x74, 0x61, 0x74, 0x6f,
	0x65, 0x2e, 0x00, 0x00, 0x06, 0x00, 0x00, 0x22,
	0x00, 0x04, 0x01, 0xa0, 0x00, 0xa6, 0x00, 0xbd,
	0x00, 0xa6, 0x00, 0xbd, 0x00, 0x01, 0x01, 0x77,
	0x61, 0x6c, 0x6c, 0x00, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64,
	0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x73, 0x6f,
	0x6d, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20,
	0x73, 0x6d, 0x6f, 0x6f, 0x74, 0x68, 0x2e, 0x00,
	0x00, 0x07, 0x25, 0x01, 0x5c, 0x00, 0x3f, 0x01,
	0xaa, 0x00, 0x2a, 0x01, 0xaf, 0x00, 0x3f, 0x01,
	0x98, 0x00, 0x01, 0x01, 0x70, 0x61, 0x74, 0x68,
	0x20, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20,
	0x6d, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x00,
	0x01, 0x08, 0x00, 0x00, 0xae, 0x00, 0x3c, 0x00,
	0xc7, 0x00, 0x1e, 0x00, 0xbd, 0x00, 0x00, 0x00,
	0xbd, 0x00, 0x04, 0x01, 0x70, 0x61, 0x74, 0x68,
	0x20, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20,
	0x6d, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x00,
	0x01, 0x09, 0xd0, 0x00, 0x9c, 0x00, 0xec, 0x00,
	0xa8, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x62, 0x72, 0x61, 0x6e,
	0x63, 0x68, 0x00, 0x47, 0x6f, 0x74, 0x63, 0x68,
	0x61, 0x2e, 0x00, 0x00, 0xe9, 0x85, 0x0d, 0x86,
	0x42, 0x86, 0x6a, 0x86, 0xa7, 0x86, 0xcf, 0x86,
	0x07, 0x87, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x31, 0x00, 0x9d, 0x00, 0x12, 0x00, 0xad,
	0x00, 0x12, 0x00, 0xad, 0x00, 0x01, 0x01, 0x74,
	0x72, 0x65, 0x65, 0x00, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x68, 0x69, 0x67, 0x68, 0x2e, 0x00, 0x00,
	0x02, 0xf6, 0x00, 0x7c, 0x00, 0x35, 0x01, 0xa6,
	0x00, 0x05, 0x01, 0xb7, 0x00, 0x05, 0x01, 0xb7,
	0x00, 0x01, 0x01, 0x77, 0x69, 0x6c, 0x64, 0x20,
	0x70, 0x6c, 0x61, 0x6e, 0x74, 0x00, 0x4f, 0x72,
	0x64, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x20, 0x67,
	0x72, 0x65, 0x65, 0x6e, 0x20, 0x73, 0x74, 0x75,
	0x66, 0x66, 0x2e, 0x00, 0x00, 0x03, 0x00, 0x00,
	0x9e, 0x00, 0x2f, 0x00, 0xba, 0x00, 0x12, 0x00,
	0xad, 0x00, 0x00, 0x00, 0xac, 0x00, 0x04, 0x01,
	0x70, 0x61, 0x74, 0x68, 0x20, 0x61, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x20, 0x6d, 0x61, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x00, 0x01, 0x04, 0x00, 0x00,
	0x20, 0x00, 0x3f, 0x01, 0xa6, 0x00, 0xc5, 0x00,
	0xb7, 0x00, 0xc5, 0x00, 0xb7, 0x00, 0x01, 0x01,
	0x77, 0x61, 0x6c, 0x6c, 0x00, 0x49, 0x74, 0x27,
	0x73, 0x20, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65,
	0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x73,
	0x6f, 0x6d, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x20, 0x73, 0x6d, 0x6f, 0x6f, 0x74, 0x68, 0x2e,
	0x00, 0x00, 0x05, 0x06, 0x01, 0xa6, 0x00, 0x3f,
	0x01, 0xc7, 0x00, 0x05, 0x01, 0xb7, 0x00, 0x3f,
	0x01, 0xb5, 0x00, 0x02, 0x01, 0x70, 0x61, 0x74,
	0x68, 0x20, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x20, 0x6d, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x67, 0x00, 0xc0, 0x00, 0x67,
	0x00, 0xc0, 0x00, 0x04, 0x01, 0x68, 0x65, 0x64,
	0x67, 0x65, 0x68, 0x6f, 0x67, 0x00, 0x49, 0x73,
	0x20, 0x68, 0x61, 0x73, 0x20, 0x61, 0x20, 0x63,
	0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x6e, 0x20, 0x69,
	0x74, 0x73, 0x20, 0x62, 0x61, 0x63, 0x6b, 0x2e,
	0x00, 0x00, 0x07, 0xdb, 0x00, 0xba, 0x00, 0xeb,
	0x00, 0xc3, 0x00, 0xd7, 0x00, 0xc3, 0x00, 0xd7,
	0x00, 0xc3, 0x00, 0x02, 0x01, 0x72, 0x6f, 0x63,
	0x6b, 0x00, 0x01, 0x2c, 0x87, 0x59, 0x87, 0x7f,
	0x87, 0xac, 0x87, 0xe2, 0x87, 0x00, 0x00, 0x01,
	0xb2, 0x00, 0x24, 0x00, 0xbe, 0x00, 0x36, 0x00,
	0xbc, 0x00, 0x96, 0x00, 0xbc, 0x00, 0x96, 0x00,
	0x01, 0x01, 0x62, 0x65, 0x65, 0x73, 0x20, 0x6e,
	0x65, 0x73, 0x74, 0x00, 0x48, 0x6f, 0x6e, 0x65,
	0x79, 0x20, 0x62, 0x61, 0x6c, 0x6c, 0x6f, 0x6f,
	0x6e, 0x2e, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xbc, 0x00, 0x96,
	0x00, 0xbc, 0x00, 0x96, 0x00, 0x01, 0x01, 0x62,
	0x65, 0x65, 0x73, 0x00, 0x49, 0x20, 0x48, 0x41,
	0x54, 0x45, 0x20, 0x54, 0x48, 0x45, 0x4d, 0x21,
	0x00, 0x00, 0x03, 0x1c, 0x00, 0x5d, 0x00, 0x72,
	0x00, 0xc1, 0x00, 0x3f, 0x00, 0xc3, 0x00, 0x3f,
	0x00, 0xc3, 0x00, 0x01, 0x01, 0x62, 0x75, 0x73,
	0x68, 0x00, 0x4e, 0x69, 0x63, 0x65, 0x20, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x20, 0x74, 0x6f, 0x20,
	0x68, 0x69, 0x64, 0x65, 0x2e, 0x00, 0x00, 0x04,
	0xa6, 0x00, 0x76, 0x00, 0xe6, 0x00, 0x8d, 0x00,
	0xbc, 0x00, 0x96, 0x00, 0xbc, 0x00, 0x96, 0x00,
	0x01, 0x01, 0x76, 0x61, 0x6c, 0x76, 0x65, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x72, 0x75, 0x73,
	0x74, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x68,
	0x61, 0x73, 0x20, 0x6e, 0x6f, 0x20, 0x6c, 0x6f,
	0x63, 0x6b, 0x2e, 0x00, 0x00, 0x05, 0xd6, 0x00,
	0xb4, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0xdb, 0x00,
	0xb7, 0x00, 0x0e, 0x01, 0xc7, 0x00, 0x02, 0x01,
	0x70, 0x61, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x20,
	0x6d, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x00,
	0x01, 0x18, 0x88, 0x6f, 0x88, 0xad, 0x88, 0xf4,
	0x88, 0x40, 0x89, 0x6e, 0x89, 0x92, 0x89, 0xb6,
	0x89, 0x00, 0x00, 0x01, 0x90, 0x00, 0x0f, 0x00,
	0xa3, 0x00, 0x1d, 0x00, 0x9d, 0x00, 0xb4, 0x00,
	0x9d, 0x00, 0xb4, 0x00, 0x01, 0x01, 0x66, 0x6c,
	0x6f, 0x77, 0x65, 0x72, 0x00, 0x49, 0x74, 0x27,
	0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x61, 0x75, 0x74,
	0x69, 0x66, 0x75, 0x6c, 0x20, 0x66, 0x6c, 0x6f,
	0x77, 0x65, 0x72, 0x20, 0x49, 0x27, 0x76, 0x65,
	0x20, 0x73, 0x65, 0x65, 0x6e, 0x00, 0x69, 0x6e,
	0x20, 0x6d, 0x79, 0x20, 0x65, 0x6e, 0x74, 0x69,
	0x72, 0x65, 0x20, 0x6c, 0x69, 0x66, 0x65, 0x21,
	0x00, 0x00, 0x02, 0x69, 0x00, 0x00, 0x00, 0xcf,
	0x00, 0x27, 0x00, 0x9d, 0x00, 0xb4, 0x00, 0x9d,
	0x00, 0xb4, 0x00, 0x01, 0x01, 0x69, 0x73, 0x6c,
	0x65, 0x00, 0x4e, 0x65, 0x61, 0x74, 0x20, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x20, 0x74, 0x6f, 0x20,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x20, 0x65, 0x63,
	0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c,
	0x20, 0x6c, 0x69, 0x66, 0x65, 0x2e, 0x00, 0x00,
	0x03, 0x3c, 0x00, 0x88, 0x00, 0x7b, 0x00, 0xa7,
	0x00, 0x6b, 0x00, 0xa9, 0x00, 0x6b, 0x00, 0xa9,
	0x00, 0x04, 0x01, 0x62, 0x6f, 0x61, 0x74, 0x00,
	0x49, 0x20, 0x63, 0x61, 0x6e, 0x27, 0x74, 0x20,
	0x62, 0x65, 0x6c, 0x69, 0x65, 0x76, 0x65, 0x20,
	0x69, 0x74, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x62, 0x6f, 0x61, 0x74,
	0x20, 0x68, 0x61, 0x73, 0x20, 0x6e, 0x6f, 0x20,
	0x68, 0x6f, 0x6c, 0x65, 0x2e, 0x00, 0x00, 0x04,
	0xec, 0x00, 0xa4, 0x00, 0x20, 0x01, 0xc3, 0x00,
	0xec, 0x00, 0xb3, 0x00, 0xec, 0x00, 0xb3, 0x00,
	0x03, 0x01, 0x77, 0x65, 0x6c, 0x6c, 0x00, 0x49,
	0x20, 0x72, 0x65, 0x66, 0x75, 0x73, 0x65, 0x20,
	0x74, 0x6f, 0x20, 0x74, 0x65, 0x6c, 0x6c, 0x20,
	0x63, 0x68, 0x65, 0x61, 0x70, 0x20, 0x6a, 0x6f,
	0x6b, 0x65, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68,
	0x00, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72,
	0x64, 0x20, 0x22, 0x77, 0x65, 0x6c, 0x6c, 0x22,
	0x2e, 0x00, 0x00, 0x05, 0xdd, 0x00, 0x96, 0x00,
	0xe8, 0x00, 0xa2, 0x00, 0xc8, 0x00, 0xb3, 0x00,
	0xc8, 0x00, 0xb3, 0x00, 0x02, 0x01, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x00, 0x49, 0x20, 0x63,
	0x61, 0x6e, 0x20, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x00,
	0x00, 0x06, 0x88, 0x00, 0xb7, 0x00, 0xa5, 0x00,
	0xc7, 0x00, 0x9d, 0x00, 0xb4, 0x00, 0x99, 0x00,
	0xc7, 0x00, 0x03, 0x01, 0x70, 0x61, 0x74, 0x68,
	0x20, 0x74, 0x6f, 0x20, 0x76, 0x69, 0x6c, 0x6c,
	0x61, 0x67, 0x65, 0x00, 0x01, 0x07, 0x25, 0x01,
	0x96, 0x00, 0x3f, 0x01, 0xb6, 0x00, 0x06, 0x01,
	0xb0, 0x00, 0x3f, 0x01, 0xa2, 0x00, 0x02, 0x01,
	0x70, 0x61, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x20,
	0x6d, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x00,
	0x01, 0x08, 0x00, 0x00, 0x96, 0x00, 0x20, 0x00,
	0xb5, 0x00, 0x1e, 0x00, 0xac, 0x00, 0x00, 0x00,
	0xac, 0x00, 0x04, 0x01, 0x70, 0x61, 0x74, 0x68,
	0x20, 0x74, 0x6f, 0x20, 0x66, 0x6f, 0x72, 0x65,
	0x73, 0x74, 0x00, 0x01, 0xe1, 0x89, 0x0c, 0x8a,
	0x3c, 0x8a, 0x00, 0x00, 0x01, 0x7d, 0x00, 0x3b,
	0x00, 0x8c, 0x00, 0x59, 0x00, 0x7b, 0x00, 0x5e,
	0x00, 0x7b, 0x00, 0x5e, 0x00, 0x02, 0x01, 0x66,
	0x6c, 0x6f, 0x77, 0x65, 0x72, 0x00, 0x49, 0x74,
	0x27, 0x73, 0x20, 0x62, 0x65, 0x61, 0x75, 0x74,
	0x69, 0x66, 0x75, 0x6c, 0x21, 0x00, 0x00, 0x02,
	0x8d, 0x00, 0x3b, 0x00, 0x9e, 0x00, 0x57, 0x00,
	0xa0, 0x00, 0x5a, 0x00, 0xa0, 0x00, 0x5a, 0x00,
	0x04, 0x01, 0x66, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x00, 0x49, 0x74, 0x20, 0x73, 0x6d, 0x65, 0x6c,
	0x6c, 0x73, 0x20, 0x76, 0x65, 0x72, 0x79, 0x20,
	0x6e, 0x69, 0x63, 0x65, 0x21, 0x00, 0x00, 0x03,
	0xd2, 0x00, 0x4c, 0x00, 0x38, 0x01, 0x7b, 0x00,
	0xec, 0x00, 0x5f, 0x00, 0xec, 0x00, 0x5f, 0x00,
	0x03, 0x01, 0x62, 0x6f, 0x61, 0x74, 0x00, 0x4e,
	0x6f, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20, 0x6e,
	0x65, 0x77, 0x2e, 0x20, 0x4c, 0x69, 0x74, 0x65,
	0x72, 0x61, 0x6c, 0x6c, 0x79, 0x2e, 0x00, 0x00,
	0x87, 0x8a, 0xa1, 0x8a, 0xbb, 0x8a, 0xd2, 0x8a,
	0xe9, 0x8a, 0x05, 0x8b, 0x3c, 0x8b, 0x1f, 0x8b,
	0x59, 0x8b, 0x76, 0x8b, 0x93, 0x8b, 0xae, 0x8b,
	0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x01, 0x66, 0x69, 0x73,
	0x68, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x66,
	0x69, 0x73, 0x68, 0x00, 0x00, 0x00, 0x03, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x3f, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x3f, 0x00, 0x00, 0x00, 0x05, 0x21, 0x00, 0xb1,
	0x00, 0x2b, 0x00, 0xbb, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x61,
	0x6e, 0x63, 0x68, 0x6f, 0x72, 0x00, 0x00, 0x00,
	0x06, 0x29, 0x00, 0x90, 0x00, 0x99, 0x00, 0xba,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x01, 0x62, 0x6f, 0x61, 0x74, 0x00,
	0x00, 0x00, 0x08, 0x0f, 0x00, 0x90, 0x00, 0x2d,
	0x00, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x01, 0x73, 0x65, 0x61,
	0x77, 0x65, 0x65, 0x64, 0x00, 0x00, 0x00, 0x07,
	0x00, 0x00, 0x56, 0x00, 0x22, 0x00, 0x97, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x01, 0x73, 0x65, 0x61, 0x77, 0x65, 0x65,
	0x64, 0x00, 0x00, 0x00, 0x09, 0xce, 0x00, 0xa3,
	0x00, 0xfc, 0x00, 0xc7, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x73,
	0x65, 0x61, 0x77, 0x65, 0x65, 0x64, 0x00, 0x00,
	0x00, 0x0a, 0xde, 0x00, 0x3c, 0x00, 0x08, 0x01,
	0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x73, 0x65, 0x61, 0x77,
	0x65, 0x65, 0x64, 0x00, 0x00, 0x00, 0x0b, 0x98,
	0x00, 0x96, 0x00, 0xbb, 0x00, 0xb5, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
	0x01, 0x70, 0x6c, 0x61, 0x6e, 0x74, 0x00, 0x00,
	0x00, 0x0c, 0x68, 0x00, 0x7a, 0x00, 0xe0, 0x00,
	0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x01, 0x73, 0x74, 0x6f, 0x6e,
	0x65, 0x73, 0x00, 0x00, 0x00, 0xda, 0x8b, 0x01,
	0x8c, 0x39, 0x8c, 0x63, 0x8c, 0x90, 0x8c, 0xb2,
	0x8c, 0xd2, 0x8c, 0x00, 0x00, 0x01, 0xbd, 0x00,
	0xaf, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0xc9, 0x00,
	0xc0, 0x00, 0xec, 0x00, 0xc7, 0x00, 0x02, 0x01,
	0x70, 0x61, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x20,
	0x6c, 0x61, 0x6b, 0x65, 0x20, 0x73, 0x68, 0x6f,
	0x72, 0x65, 0x00, 0x01, 0x02, 0x37, 0x00, 0x50,
	0x00, 0x50, 0x00, 0x69, 0x00, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0x04, 0x01, 0x64,
	0x6f, 0x6f, 0x72, 0x00, 0x54, 0x68, 0x65, 0x72,
	0x65, 0x27, 0x73, 0x20, 0x6e, 0x6f, 0x20, 0x6e,
	0x61, 0x6d, 0x65, 0x20, 0x6f, 0x6e, 0x20, 0x74,
	0x68, 0x65, 0x00, 0x64, 0x6f, 0x6f, 0x72, 0x2e,
	0x2e, 0x2e, 0x00, 0x00, 0x03, 0x67, 0x00, 0x46,
	0x00, 0x85, 0x00, 0x5d, 0x00, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0x77,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x00, 0x49,
	0x20, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x20,
	0x44, 0x4f, 0x53, 0x2e, 0x00, 0x00, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc9,
	0x00, 0xc0, 0x00, 0xc9, 0x00, 0xc0, 0x00, 0x01,
	0x01, 0x73, 0x71, 0x75, 0x69, 0x72, 0x72, 0x65,
	0x6c, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x76,
	0x65, 0x72, 0x79, 0x20, 0x66, 0x61, 0x73, 0x74,
	0x2e, 0x00, 0x00, 0x05, 0x92, 0x00, 0x35, 0x00,
	0x99, 0x00, 0x3c, 0x00, 0xc9, 0x00, 0xc0, 0x00,
	0xc9, 0x00, 0xc0, 0x00, 0x01, 0x01, 0x6e, 0x75,
	0x74, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x62,
	0x69, 0x67, 0x2e, 0x00, 0x00, 0x06, 0x8c, 0x00,
	0xbb, 0x00, 0x92, 0x00, 0xc1, 0x00, 0x9c, 0x00,
	0xc2, 0x00, 0x9c, 0x00, 0xc2, 0x00, 0x04, 0x00,
	0x6e, 0x75, 0x74, 0x00, 0x47, 0x6f, 0x74, 0x63,
	0x68, 0x61, 0x2e, 0x00, 0x00, 0x07, 0x48, 0x00,
	0xb4, 0x00, 0xaa, 0x00, 0xc7, 0x00, 0xa2, 0x00,
	0xc2, 0x00, 0xa2, 0x00, 0xc2, 0x00, 0x04, 0x01,
	0x67, 0x72, 0x61, 0x73, 0x73, 0x00, 0x01, 0x0c,
	0x8d, 0x28, 0x8d, 0x6f, 0x8d, 0xcb, 0x8d, 0xe8,
	0x8d, 0x22, 0x8e, 0x3f, 0x8e, 0x5e, 0x8e, 0x99,
	0x8e, 0xd7, 0x8e, 0x12, 0x8f, 0x2c, 0x8f, 0x54,
	0x8f, 0x71, 0x8f, 0xcc, 0x8f, 0x00, 0x00, 0x01,
	0x90, 0x00, 0xbd, 0x00, 0x3f, 0x01, 0xc7, 0x00,
	0xdf, 0x00, 0xc1, 0x00, 0xdf, 0x00, 0xc7, 0x00,
	0x03, 0x01, 0x77, 0x61, 0x79, 0x20, 0x6f, 0x75,
	0x74, 0x00, 0x01, 0x02, 0xcc, 0x00, 0x75, 0x00,
	0xe0, 0x00, 0x83, 0x00, 0xd8, 0x00, 0xa7, 0x00,
	0xd8, 0x00, 0xa7, 0x00, 0x01, 0x01, 0x68, 0x6f,
	0x72, 0x6e, 0x00, 0x49, 0x74, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x20,
	0x61, 0x20, 0x62, 0x69, 0x67, 0x20, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x20, 0x6f, 0x6e, 0x00, 0x74, 0x68, 0x65, 0x20,
	0x61, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x73, 0x2e,
	0x00, 0x00, 0x03, 0x00, 0x00, 0x47, 0x00, 0x1c,
	0x00, 0x94, 0x00, 0x51, 0x00, 0xa7, 0x00, 0x51,
	0x00, 0xa7, 0x00, 0x04, 0x01, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x00, 0x49, 0x27, 0x6d, 0x20,
	0x6e, 0x6f, 0x74, 0x20, 0x73, 0x75, 0x72, 0x65,
	0x20, 0x69, 0x66, 0x20, 0x69, 0x74, 0x20, 0x73,
	0x68, 0x6f, 0x75, 0x6c, 0x64, 0x6e, 0x27, 0x74,
	0x20, 0x62, 0x65, 0x20, 0x6f, 0x6e, 0x00, 0x74,
	0x68, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72,
	0x20, 0x73, 0x69, 0x64, 0x65, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x61, 0x6c,
	0x6c, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x04, 0x2e,
	0x00, 0x86, 0x00, 0x72, 0x00, 0x98, 0x00, 0x4e,
	0x00, 0xa4, 0x00, 0x4e, 0x00, 0xa4, 0x00, 0x01,
	0x01, 0x63, 0x75, 0x70, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x00, 0x01, 0x05, 0x81, 0x00, 0x67, 0x00,
	0x9a, 0x00, 0x70, 0x00, 0x8b, 0x00, 0xa5, 0x00,
	0x8b, 0x00, 0xa5, 0x00, 0x01, 0x01, 0x68, 0x65,
	0x61, 0x72, 0x74, 0x2d, 0x73, 0x68, 0x61, 0x70,
	0x65, 0x64, 0x20, 0x68, 0x6f, 0x6c, 0x65, 0x00,
	0x57, 0x68, 0x61, 0x74, 0x20, 0x61, 0x20, 0x6c,
	0x6f, 0x76, 0x65, 0x6c, 0x79, 0x20, 0x68, 0x6f,
	0x6c, 0x65, 0x2e, 0x00, 0x00, 0x06, 0x7d, 0x00,
	0x8c, 0x00, 0x9e, 0x00, 0x9b, 0x00, 0x8f, 0x00,
	0xa4, 0x00, 0x8f, 0x00, 0xa4, 0x00, 0x01, 0x01,
	0x63, 0x75, 0x70, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x00, 0x01, 0x07, 0x89, 0x00, 0x06, 0x00, 0xb6,
	0x00, 0x29, 0x00, 0xa2, 0x00, 0xbb, 0x00, 0xa2,
	0x00, 0xbb, 0x00, 0x01, 0x01, 0x63, 0x68, 0x61,
	0x6e, 0x64, 0x65, 0x6c, 0x69, 0x65, 0x72, 0x00,
	0x01, 0x08, 0x13, 0x01, 0x5e, 0x00, 0x3f, 0x01,
	0x81, 0x00, 0xd8, 0x00, 0xa7, 0x00, 0xd8, 0x00,
	0xa7, 0x00, 0x02, 0x01, 0x70, 0x69, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x00, 0x49, 0x74, 0x20, 0x6c,
	0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x61, 0x6c, 0x6d,
	0x6f, 0x73, 0x74, 0x20, 0x6c, 0x69, 0x6b, 0x65,
	0x20, 0x61, 0x20, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x2e, 0x00, 0x00, 0x09, 0x11, 0x01, 0x8c,
	0x00, 0x25, 0x01, 0xb7, 0x00, 0x0e, 0x01, 0xb6,
	0x00, 0x0e, 0x01, 0xb6, 0x00, 0x02, 0x01, 0x66,
	0x69, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x00, 0x54, 0x68, 0x65, 0x72, 0x65, 0x27, 0x73,
	0x20, 0x61, 0x20, 0x6c, 0x6f, 0x74, 0x20, 0x6f,
	0x66, 0x20, 0x73, 0x6f, 0x6f, 0x74, 0x20, 0x69,
	0x6e, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x2e,
	0x00, 0x00, 0x0a, 0xb9, 0x00, 0x60, 0x00, 0xe8,
	0x00, 0x83, 0x00, 0xd8, 0x00, 0xa7, 0x00, 0xd8,
	0x00, 0xa7, 0x00, 0x01, 0x01, 0x67, 0x75, 0x6e,
	0x73, 0x00, 0x54, 0x68, 0x65, 0x79, 0x20, 0x61,
	0x72, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20,
	0x70, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x20,
	0x69, 0x6d, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x00, 0x00, 0x0b, 0x37, 0x00,
	0xa5, 0x00, 0x8c, 0x00, 0xc7, 0x00, 0x51, 0x00,
	0xa7, 0x00, 0x51, 0x00, 0xa7, 0x00, 0x03, 0x01,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x00, 0x01, 0x0c,
	0x68, 0x00, 0x71, 0x00, 0x6f, 0x00, 0x77, 0x00,
	0x6d, 0x00, 0xa4, 0x00, 0x6d, 0x00, 0xa4, 0x00,
	0x01, 0x01, 0x72, 0x6f, 0x74, 0x74, 0x65, 0x6e,
	0x20, 0x63, 0x68, 0x65, 0x65, 0x73, 0x65, 0x00,
	0x50, 0x66, 0x75, 0x69, 0x21, 0x00, 0x00, 0x0d,
	0xa9, 0x00, 0x2f, 0x00, 0x3f, 0x01, 0x5d, 0x00,
	0xd8, 0x00, 0xa7, 0x00, 0xd8, 0x00, 0xa7, 0x00,
	0x01, 0x01, 0x74, 0x72, 0x6f, 0x70, 0x68, 0x69,
	0x65, 0x73, 0x00, 0x01, 0x0e, 0xa2, 0x00, 0x8b,
	0x00, 0xb6, 0x00, 0xa9, 0x00, 0xc1, 0x00, 0xa4,
	0x00, 0xc1, 0x00, 0xa4, 0x00, 0x04, 0x01, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x73, 0x61, 0x77, 0x00,
	0x49, 0x20, 0x64, 0x6f, 0x6e, 0x27, 0x74, 0x20,
	0x6b, 0x6e, 0x6f, 0x77, 0x20, 0x77, 0x68, 0x79,
	0x20, 0x62, 0x75, 0x74, 0x20, 0x69, 0x74, 0x20,
	0x72, 0x65, 0x6d, 0x69, 0x6e, 0x64, 0x73, 0x20,
	0x6f, 0x66, 0x00, 0x73, 0x6f, 0x6d, 0x65, 0x20,
	0x54, 0x65, 0x78, 0x61, 0x73, 0x20, 0x67, 0x75,
	0x79, 0x20, 0x49, 0x20, 0x6d, 0x65, 0x74, 0x20,
	0x6f, 0x6e, 0x63, 0x65, 0x2e, 0x00, 0x00, 0x0f,
	0x2d, 0x00, 0x6c, 0x00, 0x72, 0x00, 0x84, 0x00,
	0x51, 0x00, 0xa7, 0x00, 0x51, 0x00, 0xa7, 0x00,
	0x01, 0x01, 0x70, 0x6f, 0x72, 0x63, 0x65, 0x6c,
	0x61, 0x69, 0x6e, 0x00, 0x49, 0x27, 0x6d, 0x20,
	0x61, 0x66, 0x72, 0x61, 0x69, 0x64, 0x20, 0x65,
	0x76, 0x65, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x62,
	0x72, 0x65, 0x61, 0x74, 0x68, 0x20, 0x61, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65,
	0x73, 0x65, 0x00, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x73, 0x2e, 0x00, 0x00, 0x3b, 0x90, 0x67, 0x90,
	0xaf, 0x90, 0x01, 0x91, 0x55, 0x91, 0x6e, 0x91,
	0xc0, 0x91, 0xdb, 0x91, 0xf6, 0x91, 0x17, 0x92,
	0x38, 0x92, 0x51, 0x92, 0x73, 0x92, 0xf8, 0x92,
	0x20, 0x93, 0x52, 0x93, 0x00, 0x00, 0x01, 0x1d,
	0x01, 0x87, 0x00, 0x3b, 0x01, 0xaa, 0x00, 0x16,
	0x01, 0xbd, 0x00, 0x16, 0x01, 0xbd, 0x00, 0x02,
	0x01, 0x63, 0x61, 0x72, 0x20, 0x64, 0x6f, 0x6f,
	0x72, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x75,
	0x6e, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x2e,
	0x00, 0x00, 0x02, 0xbf, 0x00, 0x88, 0x00, 0xe6,
	0x00, 0x9c, 0x00, 0xa8, 0x00, 0xb3, 0x00, 0xa8,
	0x00, 0xb3, 0x00, 0x02, 0x01, 0x74, 0x72, 0x75,
	0x6e, 0x6b, 0x00, 0x54, 0x68, 0x65, 0x72, 0x65,
	0x27, 0x73, 0x20, 0x61, 0x6c, 0x77, 0x61, 0x79,
	0x73, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x74, 0x68,
	0x69, 0x6e, 0x67, 0x20, 0x75, 0x73, 0x65, 0x66,
	0x75, 0x6c, 0x00, 0x69, 0x6e, 0x20, 0x61, 0x20,
	0x74, 0x72, 0x75, 0x6e, 0x6b, 0x2e, 0x2e, 0x2e,
	0x00, 0x00, 0x03, 0x50, 0x00, 0x47, 0x00, 0x64,
	0x00, 0x51, 0x00, 0x51, 0x00, 0xb5, 0x00, 0x51,
	0x00, 0xb5, 0x00, 0x01, 0x01, 0x62, 0x61, 0x73,
	0x6b, 0x65, 0x74, 0x00, 0x49, 0x74, 0x20, 0x67,
	0x69, 0x76, 0x65, 0x73, 0x20, 0x6d, 0x65, 0x20,
	0x61, 0x6d, 0x62, 0x69, 0x76, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0x20, 0x66, 0x65, 0x65, 0x6c, 0x69,
	0x6e, 0x67, 0x73, 0x3a, 0x00, 0x72, 0x65, 0x6d,
	0x69, 0x6e, 0x64, 0x73, 0x20, 0x6d, 0x65, 0x20,
	0x6f, 0x66, 0x20, 0x73, 0x63, 0x68, 0x6f, 0x6f,
	0x6c, 0x2e, 0x00, 0x00, 0x04, 0x65, 0x00, 0x3c,
	0x00, 0x69, 0x00, 0xa0, 0x00, 0x65, 0x00, 0xb5,
	0x00, 0x65, 0x00, 0xb5, 0x00, 0x01, 0x01, 0x70,
	0x6f, 0x6c, 0x65, 0x00, 0x41, 0x62, 0x6f, 0x75,
	0x74, 0x20, 0x34, 0x20, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x20, 0x70, 0x6f, 0x6c,
	0x65, 0x00, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61,
	0x20, 0x62, 0x61, 0x73, 0x6b, 0x65, 0x74, 0x20,
	0x73, 0x63, 0x72, 0x65, 0x77, 0x65, 0x64, 0x20,
	0x74, 0x6f, 0x20, 0x69, 0x74, 0x2e, 0x00, 0x00,
	0x05, 0x90, 0x00, 0x5a, 0x00, 0xb7, 0x00, 0x9f,
	0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa1, 0x00, 0xa5,
	0x00, 0x01, 0x01, 0x64, 0x6f, 0x6f, 0x72, 0x00,
	0x01, 0x06, 0xbe, 0x00, 0x71, 0x00, 0xc5, 0x00,
	0x7c, 0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa1, 0x00,
	0xa5, 0x00, 0x02, 0x01, 0x64, 0x6f, 0x6f, 0x72,
	0x2d, 0x62, 0x65, 0x6c, 0x6c, 0x00, 0x4f, 0x6e,
	0x65, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x75, 0x73,
	0x65, 0x20, 0x69, 0x74, 0x20, 0x74, 0x6f, 0x20,
	0x73, 0x63, 0x61, 0x72, 0x65, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65,
	0x00, 0x62, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x64, 0x6f, 0x6f, 0x72,
	0x2e, 0x00, 0x00, 0x07, 0xd0, 0x00, 0x4b, 0x00,
	0xfd, 0x00, 0x7e, 0x00, 0xa9, 0x00, 0xae, 0x00,
	0xa9, 0x00, 0xae, 0x00, 0x02, 0x01, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x00, 0x01, 0x08, 0x10,
	0x01, 0x4b, 0x00, 0x3d, 0x01, 0x7d, 0x00, 0xa9,
	0x00, 0xae, 0x00, 0xa9, 0x00, 0xae, 0x00, 0x02,
	0x01, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x00,
	0x01, 0x09, 0x4b, 0x00, 0x02, 0x00, 0x58, 0x00,
	0x1b, 0x00, 0x51, 0x00, 0xb5, 0x00, 0x51, 0x00,
	0xb5, 0x00, 0x01, 0x01, 0x61, 0x74, 0x74, 0x69,
	0x63, 0x20, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x00, 0x01, 0x0a, 0x00, 0x00, 0xaa, 0x00, 0x21,
	0x00, 0xc7, 0x00, 0x30, 0x00, 0xbb, 0x00, 0x00,
	0x00, 0xbb, 0x00, 0x04, 0x01, 0x70, 0x61, 0x74,
	0x68, 0x20, 0x74, 0x6f, 0x20, 0x6c, 0x61, 0x6b,
	0x65, 0x00, 0x01, 0x0b, 0x17, 0x01, 0xaa, 0x00,
	0x3f, 0x01, 0xc7, 0x00, 0x21, 0x01, 0xbe, 0x00,
	0x3f, 0x01, 0xbe, 0x00, 0x02, 0x01, 0x70, 0x61,
	0x74, 0x68, 0x00, 0x01, 0x0c, 0x00, 0x00, 0x74,
	0x00, 0x1c, 0x00, 0xa9, 0x00, 0x30, 0x00, 0xbb,
	0x00, 0x05, 0x00, 0x83, 0x00, 0x01, 0x01, 0x70,
	0x61, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x20, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x00, 0x01, 0x0d, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
	0x00, 0xbb, 0x00, 0x40, 0x00, 0xbb, 0x00, 0x01,
	0x01, 0x62, 0x6f, 0x79, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x48, 0x65, 0x27, 0x73, 0x20,
	0x74, 0x72, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x68,
	0x61, 0x72, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x2c, 0x00, 0x62, 0x75,
	0x74, 0x20, 0x68, 0x65, 0x27, 0x73, 0x20, 0x74,
	0x6f, 0x6f, 0x20, 0x77, 0x65, 0x61, 0x6b, 0x20,
	0x74, 0x6f, 0x20, 0x74, 0x68, 0x72, 0x6f, 0x77,
	0x00, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x6c,
	0x6c, 0x20, 0x68, 0x69, 0x67, 0x68, 0x20, 0x65,
	0x6e, 0x6f, 0x75, 0x67, 0x68, 0x21, 0x00, 0x00,
	0x53, 0x6f, 0x6e, 0x6e, 0x79, 0x20, 0x6f, 0x72,
	0x20, 0x77, 0x68, 0x61, 0x74, 0x65, 0x76, 0x65,
	0x72, 0x00, 0xff, 0x0e, 0x1d, 0x01, 0x91, 0x00,
	0x23, 0x01, 0x9b, 0x00, 0x16, 0x01, 0xbd, 0x00,
	0x16, 0x01, 0xbd, 0x00, 0x02, 0x00, 0x63, 0x6f,
	0x6d, 0x62, 0x00, 0x53, 0x74, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x20, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x2e, 0x00, 0x00, 0x0f, 0x1e, 0x01, 0xa5, 0x00,
	0x24, 0x01, 0xa9, 0x00, 0x16, 0x01, 0xbd, 0x00,
	0x16, 0x01, 0xbd, 0x00, 0x02, 0x00, 0x6c, 0x65,
	0x76, 0x65, 0x72, 0x00, 0x49, 0x20, 0x77, 0x6f,
	0x6e, 0x64, 0x65, 0x72, 0x20, 0x77, 0x68, 0x61,
	0x74, 0x00, 0x69, 0x74, 0x27, 0x73, 0x20, 0x66,
	0x6f, 0x72, 0x3f, 0x00, 0x00, 0x10, 0x26, 0x01,
	0x85, 0x00, 0x3b, 0x01, 0xac, 0x00, 0x16, 0x01,
	0xbd, 0x00, 0x16, 0x01, 0xbd, 0x00, 0x02, 0x00,
	0x63, 0x61, 0x72, 0x20, 0x64, 0x6f, 0x6f, 0x72,
	0x00, 0x01, 0x89, 0x93, 0xa2, 0x93, 0xc3, 0x93,
	0xdc, 0x93, 0x27, 0x94, 0x42, 0x94, 0x5d, 0x94,
	0x78, 0x94, 0xa6, 0x94, 0xda, 0x94, 0xfa, 0x94,
	0x13, 0x95, 0x00, 0x00, 0x01, 0x00, 0x00, 0xac,
	0x00, 0x2b, 0x00, 0xc3, 0x00, 0x30, 0x00, 0xbe,
	0x00, 0x00, 0x00, 0xbb, 0x00, 0x04, 0x01, 0x70,
	0x61, 0x74, 0x68, 0x00, 0x01, 0x02, 0xb0, 0x00,
	0xb6, 0x00, 0xdd, 0x00, 0xc7, 0x00, 0xc4, 0x00,
	0xc2, 0x00, 0xce, 0x00, 0xc7, 0x00, 0x03, 0x01,
	0x70, 0x61, 0x74, 0x68, 0x20, 0x74, 0x6f, 0x20,
	0x63, 0x61, 0x76, 0x65, 0x00, 0x01, 0x03, 0x50,
	0x00, 0x68, 0x00, 0x79, 0x00, 0xa9, 0x00, 0x64,
	0x00, 0xb0, 0x00, 0x64, 0x00, 0xb0, 0x00, 0x01,
	0x01, 0x64, 0x6f, 0x6f, 0x72, 0x00, 0x01, 0x04,
	0x00, 0x00, 0x82, 0x00, 0x3f, 0x00, 0xab, 0x00,
	0x30, 0x00, 0xbe, 0x00, 0x30, 0x00, 0xbe, 0x00,
	0x04, 0x01, 0x6c, 0x61, 0x75, 0x6e, 0x64, 0x72,
	0x79, 0x00, 0x54, 0x68, 0x65, 0x20, 0x61, 0x69,
	0x72, 0x20, 0x69, 0x73, 0x20, 0x74, 0x6f, 0x6f,
	0x20, 0x64, 0x61, 0x6d, 0x70, 0x20, 0x74, 0x6f,
	0x20, 0x64, 0x72, 0x79, 0x00, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x77, 0x65, 0x74, 0x20, 0x6c, 0x61,
	0x75, 0x6e, 0x64, 0x72, 0x79, 0x2e, 0x2e, 0x2e,
	0x00, 0x00, 0x05, 0x8d, 0x00, 0x58, 0x00, 0xba,
	0x00, 0x90, 0x00, 0x9f, 0x00, 0xbd, 0x00, 0x9f,
	0x00, 0xbd, 0x00, 0x01, 0x01, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x00, 0x01, 0x06, 0xce, 0x00,
	0x58, 0x00, 0xfb, 0x00, 0x90, 0x00, 0x9f, 0x00,
	0xbd, 0x00, 0x9f, 0x00, 0xbd, 0x00, 0x02, 0x01,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x00, 0x01,
	0x07, 0x15, 0x01, 0x55, 0x00, 0x36, 0x01, 0x82,
	0x00, 0xc4, 0x00, 0xc2, 0x00, 0xc4, 0x00, 0xc2,
	0x00, 0x02, 0x01, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x00, 0x01, 0x08, 0x1a, 0x01, 0x9c, 0x00,
	0x38, 0x01, 0xab, 0x00, 0x29, 0x01, 0xb5, 0x00,
	0x29, 0x01, 0xb2, 0x00, 0x01, 0x00, 0x68, 0x6f,
	0x6c, 0x65, 0x00, 0x41, 0x20, 0x77, 0x61, 0x79,
	0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x72, 0x2e, 0x00,
	0x00, 0x09, 0x0b, 0x01, 0x83, 0x00, 0x3f, 0x01,
	0xb0, 0x00, 0xc4, 0x00, 0xc2, 0x00, 0xc4, 0x00,
	0xc2, 0x00, 0x02, 0x01, 0x76, 0x61, 0x6c, 0x76,
	0x65, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x61,
	0x20, 0x68, 0x65, 0x61, 0x76, 0x79, 0x20, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x20, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x2e, 0x00, 0x00, 0x0a, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc4, 0x00,
	0xc2, 0x00, 0xc4, 0x00, 0xc2, 0x00, 0x02, 0x01,
	0x64, 0x6f, 0x67, 0x00, 0x53, 0x6e, 0x6f, 0x6f,
	0x70, 0x79, 0x2e, 0x00, 0x00, 0x0b, 0x7c, 0x00,
	0x84, 0x00, 0x81, 0x00, 0x8e, 0x00, 0x64, 0x00,
	0xb0, 0x00, 0x64, 0x00, 0xb0, 0x00, 0x02, 0x01,
	0x62, 0x65, 0x6c, 0x6c, 0x00, 0x01, 0x0c, 0x00,
	0x00, 0x82, 0x00, 0x3f, 0x00, 0xa1, 0x00, 0x3f,
	0x00, 0xbb, 0x00, 0x3f, 0x00, 0xbb, 0x00, 0x01,
	0x01, 0x72, 0x6f, 0x70, 0x65, 0x00, 0x01, 0x48,
	0x95, 0x86, 0x95, 0xa3, 0x95, 0xd2, 0x95, 0xfe,
	0x95, 0x2e, 0x96, 0x48, 0x96, 0x88, 0x96, 0xae,
	0x96, 0x0f, 0x97, 0x36, 0x97, 0x4f, 0x97, 0x6e,
	0x97, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xe6, 0x00, 0xac, 0x00,
	0xe6, 0x00, 0xac, 0x00, 0x03, 0x01, 0x6f, 0x6c,
	0x64, 0x20, 0x6d, 0x61, 0x6e, 0x00, 0x48, 0x65,
	0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x6c,
	0x69, 0x6b, 0x65, 0x20, 0x61, 0x20, 0x72, 0x65,
	0x74, 0x69, 0x72, 0x65, 0x64, 0x00, 0x73, 0x65,
	0x61, 0x20, 0x77, 0x6f, 0x6c, 0x66, 0x2e, 0x00,
	0x00, 0x02, 0x60, 0x00, 0x5e, 0x00, 0x7a, 0x00,
	0x7f, 0x00, 0x6d, 0x00, 0xa9, 0x00, 0x6d, 0x00,
	0xa9, 0x00, 0x01, 0x01, 0x63, 0x75, 0x70, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x00, 0x01, 0x03, 0x63,
	0x00, 0x83, 0x00, 0xb2, 0x00, 0x97, 0x00, 0xa3,
	0x00, 0xab, 0x00, 0xa3, 0x00, 0xab, 0x00, 0x01,
	0x01, 0x64, 0x72, 0x61, 0x77, 0x65, 0x72, 0x73,
	0x00, 0x42, 0x6f, 0x79, 0x21, 0x20, 0x4c, 0x6f,
	0x74, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
	0x65, 0x6d, 0x21, 0x00, 0x00, 0x04, 0x00, 0x00,
	0xb7, 0x00, 0x8e, 0x00, 0xc7, 0x00, 0x63, 0x00,
	0xb4, 0x00, 0x63, 0x00, 0xb4, 0x00, 0x03, 0x01,
	0x62, 0x65, 0x64, 0x00, 0x48, 0x6f, 0x6d, 0x65,
	0x2c, 0x20, 0x73, 0x77, 0x65, 0x65, 0x74, 0x20,
	0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x2e, 0x2e, 0x00,
	0x00, 0x05, 0x13, 0x01, 0x51, 0x00, 0x28, 0x01,
	0x92, 0x00, 0xf4, 0x00, 0xac, 0x00, 0xf4, 0x00,
	0xac, 0x00, 0x02, 0x01, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x00, 0x41, 0x20, 0x76, 0x69, 0x65,
	0x77, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x00,
	0x00, 0x06, 0xc8, 0x00, 0x87, 0x00, 0xf4, 0x00,
	0x9b, 0x00, 0xd2, 0x00, 0xac, 0x00, 0xd2, 0x00,
	0xac, 0x00, 0x01, 0x01, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x00, 0x01, 0x07, 0xc0, 0x00, 0x68, 0x00,
	0xec, 0x00, 0x7f, 0x00, 0xd2, 0x00, 0xac, 0x00,
	0xd2, 0x00, 0xac, 0x00, 0x01, 0x01, 0x73, 0x68,
	0x6f, 0x74, 0x67, 0x75, 0x6e, 0x00, 0x47, 0x65,
	0x65, 0x2c, 0x20, 0x69, 0x74, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x66, 0x6f,
	0x72, 0x00, 0x64, 0x69, 0x6e, 0x6f, 0x73, 0x61,
	0x75, 0x72, 0x75, 0x73, 0x65, 0x73, 0x21, 0x2e,
	0x2e, 0x00, 0x00, 0x08, 0xbd, 0x00, 0x38, 0x00,
	0xe6, 0x00, 0x65, 0x00, 0xd2, 0x00, 0xac, 0x00,
	0xd2, 0x00, 0xac, 0x00, 0x01, 0x01, 0x70, 0x69,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x00, 0x43, 0x68,
	0x61, 0x72, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x00,
	0x00, 0x09, 0x87, 0x00, 0x47, 0x00, 0xb8, 0x00,
	0x6a, 0x00, 0x96, 0x00, 0xac, 0x00, 0x96, 0x00,
	0xac, 0x00, 0x01, 0x01, 0x66, 0x61, 0x6d, 0x69,
	0x6c, 0x79, 0x20, 0x70, 0x69, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x00, 0x49, 0x20, 0x77, 0x6f,
	0x75, 0x6c, 0x64, 0x6e, 0x27, 0x74, 0x20, 0x6c,
	0x69, 0x6b, 0x65, 0x20, 0x68, 0x61, 0x76, 0x69,
	0x6e, 0x67, 0x20, 0x6d, 0x79, 0x20, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x20,
	0x68, 0x61, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x00,
	0x6c, 0x69, 0x6b, 0x65, 0x20, 0x74, 0x72, 0x6f,
	0x70, 0x68, 0x69, 0x65, 0x73, 0x2e, 0x2e, 0x2e,
	0x00, 0x00, 0x0a, 0x37, 0x00, 0x56, 0x00, 0x57,
	0x00, 0x89, 0x00, 0x46, 0x00, 0xac, 0x00, 0x46,
	0x00, 0xac, 0x00, 0x01, 0x01, 0x66, 0x6c, 0x6f,
	0x77, 0x65, 0x72, 0x00, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x2e, 0x00,
	0x00, 0x0b, 0x0d, 0x00, 0x60, 0x00, 0x2c, 0x00,
	0xac, 0x00, 0x3d, 0x00, 0xaf, 0x00, 0x3d, 0x00,
	0xaf, 0x00, 0x04, 0x01, 0x64, 0x6f, 0x6f, 0x72,
	0x00, 0x01, 0x0c, 0x94, 0x00, 0x04, 0x00, 0xb6,
	0x00, 0x37, 0x00, 0xa3, 0x00, 0xab, 0x00, 0xa3,
	0x00, 0xab, 0x00, 0x01, 0x01, 0x63, 0x68, 0x61,
	0x6e, 0x64, 0x65, 0x6c, 0x69, 0x65, 0x72, 0x00,
	0x01, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x00, 0xaa, 0x00, 0xb7, 0x00,
	0xaa, 0x00, 0x01, 0x01, 0x66, 0x61, 0x6e, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x62, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x79, 0x20, 0x70, 0x6f, 0x77,
	0x65, 0x72, 0x65, 0x64, 0x2e, 0x00, 0x00, 0xbe,
	0x97, 0xfb, 0x97, 0x26, 0x98, 0x42, 0x98, 0x5d,
	0x98, 0x78, 0x98, 0x97, 0x98, 0xcb, 0x98, 0xe1,
	0x98, 0x23, 0x99, 0x51, 0x99, 0x97, 0x99, 0xdb,
	0x99, 0x3f, 0x9a, 0x7d, 0x9a, 0xe2, 0x9a, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x5d, 0x00, 0xba, 0x00, 0x5d, 0x00,
	0xba, 0x00, 0x04, 0x01, 0x6f, 0x6c, 0x64, 0x20,
	0x6c, 0x61, 0x64, 0x79, 0x00, 0x53, 0x68, 0x65,
	0x20, 0x6b, 0x6e, 0x69, 0x74, 0x73, 0x20, 0x69,
	0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x74,
	0x65, 0x61, 0x6d, 0x2e, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0x01, 0x67, 0x69, 0x72, 0x6c, 0x00, 0x53, 0x68,
	0x65, 0x27, 0x73, 0x20, 0x63, 0x6f, 0x6f, 0x6c,
	0x2e, 0x00, 0x00, 0x41, 0x6e, 0x6e, 0x65, 0x00,
	0xff, 0x03, 0x00, 0x00, 0xbc, 0x00, 0x6b, 0x00,
	0xc7, 0x00, 0x5e, 0x00, 0xbe, 0x00, 0x4c, 0x00,
	0xc7, 0x00, 0x03, 0x01, 0x77, 0x61, 0x79, 0x20,
	0x6f, 0x75, 0x74, 0x00, 0x01, 0x04, 0x02, 0x00,
	0x48, 0x00, 0x30, 0x00, 0x84, 0x00, 0x5d, 0x00,
	0xba, 0x00, 0x5d, 0x00, 0xba, 0x00, 0x01, 0x01,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x00, 0x01,
	0x05, 0x84, 0x00, 0x48, 0x00, 0xb0, 0x00, 0x84,
	0x00, 0x9b, 0x00, 0xac, 0x00, 0x9b, 0x00, 0xac,
	0x00, 0x01, 0x01, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x00, 0x01, 0x06, 0x4b, 0x00, 0x0a, 0x00,
	0x78, 0x00, 0x38, 0x00, 0x5d, 0x00, 0xba, 0x00,
	0x5d, 0x00, 0xba, 0x00, 0x01, 0x01, 0x63, 0x68,
	0x61, 0x6e, 0x64, 0x65, 0x6c, 0x69, 0x65, 0x72,
	0x00, 0x01, 0x07, 0x4d, 0x00, 0x61, 0x00, 0x6f,
	0x00, 0xa5, 0x00, 0x5d, 0x00, 0xab, 0x00, 0x5d,
	0x00, 0xab, 0x00, 0x01, 0x01, 0x63, 0x6c, 0x6f,
	0x63, 0x6b, 0x00, 0x52, 0x65, 0x61, 0x6c, 0x6c,
	0x79, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x20,
	0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x70, 0x69,
	0x65, 0x63, 0x65, 0x2e, 0x00, 0x00, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x86, 0x00, 0x9f,
	0x00, 0x97, 0x00, 0xad, 0x00, 0x9e, 0x00, 0xc6,
	0x00, 0x9e, 0x00, 0xc6, 0x00, 0x03, 0x01, 0x69,
	0x6d, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x66, 0x72, 0x75, 0x69, 0x74, 0x73, 0x00,
	0x54, 0x68, 0x65, 0x20, 0x61, 0x70, 0x70, 0x6c,
	0x65, 0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x73, 0x20,
	0x61, 0x6c, 0x6d, 0x6f, 0x73, 0x74, 0x00, 0x72,
	0x65, 0x61, 0x6c, 0x21, 0x00, 0x00, 0x0a, 0xac,
	0x00, 0x9f, 0x00, 0xb6, 0x00, 0xae, 0x00, 0x9e,
	0x00, 0xc6, 0x00, 0x9e, 0x00, 0xc6, 0x00, 0x03,
	0x01, 0x6a, 0x75, 0x67, 0x00, 0x49, 0x74, 0x20,
	0x68, 0x6f, 0x6c, 0x64, 0x73, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x66, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x73, 0x2e, 0x00, 0x00, 0x0b, 0xa1, 0x00, 0x89,
	0x00, 0xc2, 0x00, 0x9e, 0x00, 0x9e, 0x00, 0xc6,
	0x00, 0x9e, 0x00, 0xc6, 0x00, 0x03, 0x01, 0x66,
	0x6c, 0x6f, 0x77, 0x65, 0x72, 0x73, 0x00, 0x49,
	0x20, 0x68, 0x6f, 0x70, 0x65, 0x20, 0x74, 0x68,
	0x65, 0x73, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20,
	0x6e, 0x6f, 0x74, 0x20, 0x66, 0x72, 0x6f, 0x6d,
	0x20, 0x73, 0x6f, 0x6d, 0x65, 0x00, 0x61, 0x64,
	0x6d, 0x69, 0x72, 0x65, 0x72, 0x2e, 0x2e, 0x2e,
	0x00, 0x00, 0x0c, 0x3c, 0x00, 0xa1, 0x00, 0x4c,
	0x00, 0xa8, 0x00, 0x5d, 0x00, 0xba, 0x00, 0x4e,
	0x00, 0xbc, 0x00, 0x04, 0x01, 0x66, 0x65, 0x61,
	0x74, 0x68, 0x65, 0x72, 0x20, 0x64, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x00, 0x49, 0x74, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64,
	0x75, 0x73, 0x74, 0x20, 0x70, 0x72, 0x6f, 0x62,
	0x6c, 0x65, 0x6d, 0x2e, 0x00, 0x00, 0x0d, 0x7d,
	0x00, 0xa7, 0x00, 0xc2, 0x00, 0xc7, 0x00, 0x9e,
	0x00, 0xc6, 0x00, 0x9e, 0x00, 0xc6, 0x00, 0x03,
	0x01, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x00, 0x49,
	0x74, 0x27, 0x73, 0x20, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x49,
	0x20, 0x64, 0x6f, 0x75, 0x62, 0x74, 0x20, 0x69,
	0x74, 0x20, 0x68, 0x61, 0x73, 0x20, 0x61, 0x6e,
	0x79, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20, 0x74,
	0x6f, 0x20, 0x64, 0x6f, 0x00, 0x77, 0x69, 0x74,
	0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x65,
	0x64, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x20, 0x6c,
	0x65, 0x67, 0x65, 0x6e, 0x64, 0x2e, 0x2e, 0x2e,
	0x00, 0x00, 0x0e, 0xf1, 0x00, 0x60, 0x00, 0x1a,
	0x01, 0x94, 0x00, 0x02, 0x01, 0xb8, 0x00, 0x02,
	0x01, 0xb8, 0x00, 0x01, 0x01, 0x6d, 0x69, 0x72,
	0x72, 0x6f, 0x72, 0x00, 0x49, 0x20, 0x63, 0x61,
	0x6e, 0x20, 0x73, 0x65, 0x65, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x67, 0x69, 0x72, 0x6c, 0x27, 0x73,
	0x00, 0x66, 0x61, 0x63, 0x65, 0x20, 0x69, 0x6e,
	0x20, 0x69, 0x74, 0x2e, 0x2e, 0x2e, 0x00, 0x00,
	0x0f, 0x1d, 0x01, 0x3e, 0x00, 0x3f, 0x01, 0x68,
	0x00, 0x02, 0x01, 0xb8, 0x00, 0x02, 0x01, 0xb8,
	0x00, 0x02, 0x01, 0x70, 0x69, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20,
	0x6e, 0x69, 0x63, 0x65, 0x20, 0x74, 0x6f, 0x20,
	0x6c, 0x69, 0x76, 0x65, 0x20, 0x69, 0x6e, 0x20,
	0x61, 0x20, 0x76, 0x69, 0x6c, 0x6c, 0x61, 0x67,
	0x65, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x20, 0x76, 0x69, 0x6c, 0x6c, 0x61,
	0x67, 0x65, 0x00, 0x6c, 0x61, 0x6e, 0x64, 0x73,
	0x63, 0x61, 0x70, 0x65, 0x73, 0x20, 0x6f, 0x6e,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x61, 0x6c,
	0x6c, 0x73, 0x2e, 0x00, 0x00, 0x10, 0x18, 0x01,
	0xa1, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0xf5, 0x00,
	0xc6, 0x00, 0xf5, 0x00, 0xc6, 0x00, 0x02, 0x01,
	0x70, 0x6c, 0x61, 0x6e, 0x74, 0x00, 0x49, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x76, 0x65,
	0x2e, 0x00, 0x00, 0x1c, 0x9b, 0x3f, 0x9b, 0x77,
	0x9b, 0x9b, 0x9b, 0xd1, 0x9b, 0x2d, 0x9c, 0x47,
	0x9c, 0xa4, 0x9c, 0xf4, 0x9c, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x5e, 0x00, 0xaa, 0x00, 0x5e, 0x00, 0xaa, 0x00,
	0x04, 0x01, 0x73, 0x70, 0x69, 0x64, 0x65, 0x72,
	0x00, 0x49, 0x74, 0x27, 0x73, 0x2e, 0x2e, 0x2e,
	0x00, 0x00, 0x02, 0x38, 0x00, 0x86, 0x00, 0x4e,
	0x00, 0xa9, 0x00, 0x5e, 0x00, 0xaa, 0x00, 0x4e,
	0x00, 0xaa, 0x00, 0x04, 0x01, 0x73, 0x68, 0x6f,
	0x76, 0x65, 0x6c, 0x00, 0x49, 0x20, 0x63, 0x6f,
	0x75, 0x6c, 0x64, 0x20, 0x70, 0x6c, 0x61, 0x79,
	0x20, 0x64, 0x69, 0x67, 0x67, 0x65, 0x72, 0x20,
	0x77, 0x69, 0x74, 0x68, 0x20, 0x69, 0x74, 0x2e,
	0x00, 0x00, 0x03, 0xd5, 0x00, 0x15, 0x00, 0xf8,
	0x00, 0xa5, 0x00, 0xe6, 0x00, 0xaa, 0x00, 0xe6,
	0x00, 0xaa, 0x00, 0x01, 0x01, 0x6c, 0x61, 0x64,
	0x64, 0x65, 0x72, 0x00, 0x57, 0x61, 0x79, 0x20,
	0x6f, 0x75, 0x74, 0x2e, 0x00, 0x00, 0x04, 0xf7,
	0x00, 0x70, 0x00, 0xfe, 0x00, 0x7a, 0x00, 0x05,
	0x01, 0xa8, 0x00, 0x05, 0x01, 0xa8, 0x00, 0x01,
	0x00, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x6c, 0x69, 0x74,
	0x74, 0x6c, 0x65, 0x2c, 0x20, 0x62, 0x75, 0x74,
	0x20, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x66, 0x75,
	0x6c, 0x2e, 0x00, 0x00, 0x05, 0x05, 0x00, 0x5a,
	0x00, 0x1e, 0x00, 0x77, 0x00, 0x53, 0x00, 0xb4,
	0x00, 0x53, 0x00, 0xb4, 0x00, 0x04, 0x01, 0x61,
	0x78, 0x65, 0x00, 0x49, 0x20, 0x68, 0x6f, 0x70,
	0x65, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x20,
	0x73, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x20, 0x6f,
	0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x61,
	0x6c, 0x6c, 0x20, 0x68, 0x61, 0x76, 0x65, 0x00,
	0x6e, 0x6f, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20,
	0x74, 0x6f, 0x20, 0x64, 0x6f, 0x20, 0x77, 0x69,
	0x74, 0x68, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x61, 0x78, 0x65, 0x2e, 0x2e, 0x2e, 0x00, 0x00,
	0x06, 0x1c, 0x01, 0x38, 0x00, 0x28, 0x01, 0x62,
	0x00, 0xf5, 0x00, 0xb2, 0x00, 0xf5, 0x00, 0xb2,
	0x00, 0x02, 0x01, 0x63, 0x68, 0x61, 0x69, 0x6e,
	0x00, 0x01, 0x07, 0x2e, 0x01, 0x50, 0x00, 0x36,
	0x01, 0x62, 0x00, 0xf5, 0x00, 0xb2, 0x00, 0xf5,
	0x00, 0xb2, 0x00, 0x02, 0x01, 0x74, 0x6f, 0x6e,
	0x67, 0x73, 0x00, 0x47, 0x65, 0x65, 0x2c, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x73,
	0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x6c, 0x69,
	0x6b, 0x65, 0x20, 0x61, 0x00, 0x74, 0x6f, 0x72,
	0x74, 0x75, 0x72, 0x65, 0x20, 0x63, 0x68, 0x61,
	0x6d, 0x62, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61,
	0x6e, 0x20, 0x61, 0x20, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x72, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x08,
	0x6b, 0x00, 0x59, 0x00, 0xcc, 0x00, 0xa9, 0x00,
	0x99, 0x00, 0xb0, 0x00, 0x99, 0x00, 0xb0, 0x00,
	0x01, 0x01, 0x73, 0x68, 0x65, 0x6c, 0x76, 0x65,
	0x73, 0x00, 0x4c, 0x6f, 0x74, 0x73, 0x20, 0x6f,
	0x66, 0x20, 0x6a, 0x61, 0x72, 0x73, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x73, 0x74, 0x75, 0x66, 0x66,
	0x2e, 0x20, 0x4e, 0x6f, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x00, 0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79,
	0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x00, 0x00, 0x09,
	0x17, 0x01, 0x8c, 0x00, 0x3f, 0x01, 0xc2, 0x00,
	0xf5, 0x00, 0xb2, 0x00, 0xf5, 0x00, 0xb2, 0x00,
	0x02, 0x01, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x73, 0x00, 0x54, 0x68, 0x65,
	0x79, 0x27, 0x72, 0x65, 0x20, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x00, 0x00, 0x32, 0x9d, 0x90,
	0x9d, 0x07, 0x9e, 0x29, 0x9e, 0x42, 0x9e, 0x9e,
	0x9e, 0xcf, 0x9e, 0x00, 0x00, 0x01, 0xe1, 0x00,
	0x8b, 0x00, 0xf6, 0x00, 0x91, 0x00, 0x0c, 0x01,
	0x91, 0x00, 0x0c, 0x01, 0x91, 0x00, 0x04, 0x00,
	0x62, 0x6f, 0x6e, 0x65, 0x00, 0x44, 0x75, 0x65,
	0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x61, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x72, 0x6f, 0x63, 0x6b, 0x20,
	0x49, 0x20, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x00,
	0x69, 0x74, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20,
	0x64, 0x69, 0x6e, 0x6f, 0x73, 0x61, 0x75, 0x72,
	0x20, 0x62, 0x6f, 0x6e, 0x65, 0x2e, 0x2e, 0x2e,
	0x2e, 0x00, 0x00, 0x02, 0x90, 0x00, 0x49, 0x00,
	0xcb, 0x00, 0x9e, 0x00, 0xea, 0x00, 0x98, 0x00,
	0xea, 0x00, 0x98, 0x00, 0x04, 0x01, 0x62, 0x75,
	0x73, 0x68, 0x00, 0x49, 0x74, 0x20, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x73, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x77, 0x61, 0x79, 0x20, 0x74, 0x6f, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x63, 0x61, 0x76, 0x65,
	0x2e, 0x00, 0x4d, 0x61, 0x79, 0x62, 0x65, 0x20,
	0x73, 0x6f, 0x6d, 0x65, 0x6f, 0x6e, 0x65, 0x20,
	0x70, 0x6c, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x20,
	0x69, 0x74, 0x20, 0x68, 0x65, 0x72, 0x65, 0x20,
	0x74, 0x6f, 0x00, 0x6b, 0x65, 0x65, 0x70, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x63, 0x61, 0x76, 0x65,
	0x20, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73,
	0x20, 0x73, 0x61, 0x66, 0x65, 0x2e, 0x2e, 0x2e,
	0x00, 0x00, 0x03, 0x79, 0x00, 0x34, 0x00, 0xae,
	0x00, 0x9e, 0x00, 0xea, 0x00, 0x98, 0x00, 0xea,
	0x00, 0x98, 0x00, 0x04, 0x01, 0x63, 0x61, 0x76,
	0x65, 0x20, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6e,
	0x63, 0x65, 0x00, 0x01, 0x04, 0x15, 0x01, 0x7a,
	0x00, 0x3f, 0x01, 0xa9, 0x00, 0x14, 0x01, 0x93,
	0x00, 0x3f, 0x01, 0x93, 0x00, 0x02, 0x01, 0x70,
	0x61, 0x74, 0x68, 0x00, 0x01, 0x05, 0xdd, 0x00,
	0x7a, 0x00, 0xfe, 0x00, 0x94, 0x00, 0xed, 0x00,
	0x98, 0x00, 0xed, 0x00, 0x98, 0x00, 0x01, 0x01,
	0x72, 0x6f, 0x63, 0x6b, 0x00, 0x49, 0x74, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x68, 0x61, 0x76,
	0x65, 0x20, 0x66, 0x61, 0x6c, 0x6c, 0x65, 0x6e,
	0x20, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x67,
	0x65, 0x73, 0x20, 0x61, 0x67, 0x6f, 0x2e, 0x00,
	0x49, 0x20, 0x77, 0x6f, 0x6e, 0x64, 0x65, 0x72,
	0x20, 0x69, 0x66, 0x20, 0x61, 0x6e, 0x79, 0x62,
	0x6f, 0x64, 0x79, 0x20, 0x67, 0x6f, 0x74, 0x20,
	0x68, 0x75, 0x72, 0x74, 0x2e, 0x2e, 0x2e, 0x00,
	0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xed, 0x00, 0x98, 0x00, 0xed, 0x00,
	0x98, 0x00, 0x01, 0x01, 0x62, 0x75, 0x74, 0x74,
	0x65, 0x72, 0x66, 0x6c, 0x79, 0x00, 0x49, 0x73,
	0x6e, 0x27, 0x74, 0x20, 0x74, 0x68, 0x61, 0x74,
	0x20, 0x6c, 0x6f, 0x76, 0x65, 0x6c, 0x79, 0x3f,
	0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xed, 0x00, 0x98, 0x00, 0xed,
	0x00, 0x98, 0x00, 0x01, 0x01, 0x62, 0x75, 0x74,
	0x74, 0x65, 0x72, 0x66, 0x6c, 0x79, 0x00, 0x49,
	0x73, 0x6e, 0x27, 0x74, 0x20, 0x74, 0x68, 0x61,
	0x74, 0x20, 0x6c, 0x6f, 0x76, 0x65, 0x6c, 0x79,
	0x3f, 0x00, 0x00, 0x0e, 0x9f, 0x29, 0x9f, 0x4e,
	0x9f, 0x6a, 0x9f, 0xbd, 0x9f, 0xea, 0x9f, 0x00,
	0x00, 0x01, 0x03, 0x01, 0xa4, 0x00, 0x1d, 0x01,
	0xb6, 0x00, 0xf8, 0x00, 0xa9, 0x00, 0xf8, 0x00,
	0xa9, 0x00, 0x03, 0x01, 0x6c, 0x69, 0x7a, 0x61,
	0x72, 0x64, 0x00, 0x01, 0x02, 0x3f, 0x00, 0x8a,
	0x00, 0x5c, 0x00, 0xbc, 0x00, 0x6e, 0x00, 0xaa,
	0x00, 0x6e, 0x00, 0xaa, 0x00, 0x03, 0x00, 0x3f,
	0x3f, 0x3f, 0x00, 0x57, 0x68, 0x61, 0x74, 0x20,
	0x49, 0x53, 0x20, 0x49, 0x54, 0x3f, 0x21, 0x00,
	0x00, 0x03, 0x11, 0x01, 0x70, 0x00, 0x3f, 0x01,
	0xc7, 0x00, 0xf8, 0x00, 0xa9, 0x00, 0x3f, 0x01,
	0xa9, 0x00, 0x02, 0x01, 0x77, 0x61, 0x79, 0x20,
	0x6f, 0x75, 0x74, 0x00, 0x01, 0x04, 0x97, 0x00,
	0x54, 0x00, 0xad, 0x00, 0x5d, 0x00, 0x9f, 0x00,
	0xaa, 0x00, 0x9f, 0x00, 0xaa, 0x00, 0x01, 0x01,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x00,
	0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x69, 0x73, 0x20, 0x76, 0x65, 0x72, 0x79,
	0x20, 0x6f, 0x6c, 0x64, 0x2c, 0x20, 0x62, 0x75,
	0x74, 0x20, 0x49, 0x20, 0x63, 0x61, 0x6e, 0x20,
	0x73, 0x74, 0x69, 0x6c, 0x6c, 0x00, 0x72, 0x65,
	0x61, 0x64, 0x20, 0x69, 0x74, 0x2e, 0x00, 0x00,
	0x05, 0x9a, 0x00, 0x5e, 0x00, 0xa6, 0x00, 0x67,
	0x00, 0x9f, 0x00, 0xaa, 0x00, 0x9f, 0x00, 0xaa,
	0x00, 0x01, 0x01, 0x68, 0x6f, 0x6c, 0x65, 0x00,
	0x49, 0x74, 0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x73,
	0x20, 0x76, 0x65, 0x72, 0x79, 0x20, 0x64, 0x65,
	0x65, 0x70, 0x2e, 0x00, 0x00, 0x06, 0xf9, 0x00,
	0x9d, 0x00, 0xff, 0x00, 0xa3, 0x00, 0xee, 0x00,
	0xa8, 0x00, 0xee, 0x00, 0xa8, 0x00, 0x02, 0x00,
	0x6e, 0x75, 0x67, 0x67, 0x65, 0x74, 0x00, 0x50,
	0x75, 0x72, 0x65, 0x20, 0x67, 0x6f, 0x6c, 0x64,
	0x21, 0x00, 0x00, 0x32, 0xa0, 0x5e, 0xa0, 0x8d,
	0xa0, 0xb9, 0xa0, 0xe6, 0xa0, 0x1c, 0xa1, 0x51,
	0xa1, 0xb1, 0xa1, 0xe3, 0xa1, 0x07, 0xa2, 0x64,
	0xa2, 0xad, 0xa2, 0xe6, 0xa2, 0x21, 0xa3, 0x5f,
	0xa3, 0x7d, 0xa3, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0x00,
	0xc3, 0x00, 0x96, 0x00, 0xc3, 0x00, 0x02, 0x01,
	0x68, 0x65, 0x6e, 0x00, 0x41, 0x20, 0x6c, 0x69,
	0x74, 0x74, 0x6c, 0x65, 0x20, 0x73, 0x74, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x2e, 0x2e, 0x2e, 0x00,
	0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xe0, 0x00, 0x87, 0x00, 0xe0, 0x00,
	0x87, 0x00, 0x01, 0x01, 0x63, 0x72, 0x6f, 0x77,
	0x00, 0x45, 0x78, 0x74, 0x72, 0x65, 0x6d, 0x65,
	0x6c, 0x79, 0x20, 0x75, 0x6e, 0x66, 0x72, 0x69,
	0x65, 0x6e, 0x64, 0x6c, 0x79, 0x2e, 0x00, 0x00,
	0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xe0, 0x00, 0x87, 0x00, 0xe0, 0x00, 0x87,
	0x00, 0x01, 0x01, 0x63, 0x72, 0x6f, 0x77, 0x00,
	0x4c, 0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x64, 0x61,
	0x6e, 0x67, 0x65, 0x72, 0x6f, 0x75, 0x73, 0x2e,
	0x2e, 0x2e, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xec, 0x00, 0x8e,
	0x00, 0xec, 0x00, 0x8e, 0x00, 0x04, 0x01, 0x6d,
	0x6f, 0x75, 0x73, 0x65, 0x00, 0x49, 0x74, 0x27,
	0x73, 0x20, 0x76, 0x65, 0x72, 0x79, 0x20, 0x6e,
	0x65, 0x72, 0x76, 0x6f, 0x75, 0x73, 0x2e, 0x00,
	0x00, 0x05, 0xdb, 0x00, 0x41, 0x00, 0xe9, 0x00,
	0x47, 0x00, 0xe0, 0x00, 0x87, 0x00, 0xe0, 0x00,
	0x87, 0x00, 0x01, 0x01, 0x64, 0x69, 0x76, 0x65,
	0x20, 0x6d, 0x61, 0x73, 0x6b, 0x00, 0x59, 0x65,
	0x61, 0x68, 0x2c, 0x20, 0x69, 0x74, 0x20, 0x61,
	0x6d, 0x61, 0x7a, 0x65, 0x73, 0x20, 0x6d, 0x65,
	0x20, 0x74, 0x6f, 0x6f, 0x2e, 0x00, 0x00, 0x06,
	0xc9, 0x00, 0x72, 0x00, 0xf1, 0x00, 0x80, 0x00,
	0xe0, 0x00, 0x87, 0x00, 0xde, 0x00, 0x8f, 0x00,
	0x01, 0x01, 0x66, 0x69, 0x6e, 0x73, 0x00, 0x54,
	0x68, 0x65, 0x79, 0x20, 0x77, 0x69, 0x6c, 0x6c,
	0x20, 0x66, 0x69, 0x74, 0x20, 0x6d, 0x65, 0x20,
	0x70, 0x65, 0x72, 0x66, 0x65, 0x63, 0x74, 0x6c,
	0x79, 0x2e, 0x00, 0x00, 0x07, 0xc8, 0x00, 0x3a,
	0x00, 0xf5, 0x00, 0x80, 0x00, 0xe0, 0x00, 0x87,
	0x00, 0xe0, 0x00, 0x87, 0x00, 0x01, 0x01, 0x73,
	0x63, 0x61, 0x72, 0x65, 0x63, 0x72, 0x6f, 0x77,
	0x00, 0x41, 0x20, 0x74, 0x68, 0x69, 0x6e, 0x67,
	0x20, 0x74, 0x6f, 0x20, 0x73, 0x63, 0x61, 0x72,
	0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x72,
	0x6f, 0x77, 0x73, 0x2e, 0x00, 0x41, 0x74, 0x20,
	0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x74, 0x68,
	0x61, 0x74, 0x27, 0x73, 0x20, 0x77, 0x68, 0x61,
	0x74, 0x20, 0x74, 0x68, 0x65, 0x00, 0x74, 0x68,
	0x65, 0x6f, 0x72, 0x79, 0x20, 0x73, 0x61, 0x79,
	0x73, 0x2e, 0x00, 0x00, 0x08, 0x7a, 0x00, 0xa7,
	0x00, 0x87, 0x00, 0xb3, 0x00, 0x90, 0x00, 0xb5,
	0x00, 0x90, 0x00, 0xb5, 0x00, 0x04, 0x01, 0x73,
	0x69, 0x63, 0x6b, 0x6c, 0x65, 0x00, 0x41, 0x20,
	0x76, 0x65, 0x72, 0x79, 0x20, 0x64, 0x61, 0x6e,
	0x67, 0x65, 0x72, 0x6f, 0x75, 0x73, 0x20, 0x74,
	0x6f, 0x6f, 0x6c, 0x2e, 0x00, 0x00, 0x09, 0x3d,
	0x00, 0xb6, 0x00, 0x8d, 0x00, 0xc7, 0x00, 0x84,
	0x00, 0xbe, 0x00, 0x7e, 0x00, 0xc7, 0x00, 0x03,
	0x01, 0x70, 0x61, 0x74, 0x68, 0x20, 0x74, 0x6f,
	0x20, 0x76, 0x69, 0x6c, 0x6c, 0x61, 0x67, 0x65,
	0x00, 0x01, 0x0a, 0x7b, 0x00, 0x7a, 0x00, 0x99,
	0x00, 0xa8, 0x00, 0xa2, 0x00, 0xb5, 0x00, 0xa2,
	0x00, 0xb5, 0x00, 0x04, 0x01, 0x68, 0x61, 0x79,
	0x20, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x00, 0x54,
	0x68, 0x65, 0x72, 0x65, 0x20, 0x6d, 0x75, 0x73,
	0x74, 0x20, 0x62, 0x65, 0x20, 0x73, 0x6f, 0x6d,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20, 0x6d,
	0x65, 0x74, 0x61, 0x6c, 0x20, 0x69, 0x6e, 0x73,
	0x69, 0x64, 0x65, 0x2c, 0x00, 0x49, 0x20, 0x63,
	0x61, 0x6e, 0x20, 0x73, 0x65, 0x65, 0x20, 0x69,
	0x74, 0x20, 0x67, 0x6c, 0x69, 0x74, 0x74, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x21, 0x00, 0x00, 0x0b,
	0x6a, 0x00, 0x94, 0x00, 0x7d, 0x00, 0xb3, 0x00,
	0x81, 0x00, 0xbf, 0x00, 0x81, 0x00, 0xbf, 0x00,
	0x04, 0x01, 0x72, 0x61, 0x6b, 0x65, 0x00, 0x49,
	0x74, 0x27, 0x73, 0x20, 0x76, 0x65, 0x72, 0x79,
	0x20, 0x6f, 0x6c, 0x64, 0x20, 0x61, 0x6e, 0x64,
	0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61,
	0x72, 0x65, 0x6e, 0x27, 0x74, 0x00, 0x6d, 0x61,
	0x6e, 0x79, 0x20, 0x74, 0x65, 0x65, 0x74, 0x68,
	0x20, 0x6c, 0x65, 0x66, 0x74, 0x2e, 0x00, 0x00,
	0x0c, 0xa2, 0x00, 0x73, 0x00, 0xb6, 0x00, 0x80,
	0x00, 0xec, 0x00, 0x8e, 0x00, 0xec, 0x00, 0x8e,
	0x00, 0x04, 0x01, 0x6d, 0x6f, 0x75, 0x73, 0x65,
	0x20, 0x68, 0x6f, 0x6c, 0x65, 0x00, 0x48, 0x6f,
	0x6d, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70,
	0x61, 0x6e, 0x74, 0x72, 0x79, 0x20, 0x69, 0x6e,
	0x20, 0x6f, 0x6e, 0x65, 0x2e, 0x2e, 0x2e, 0x00,
	0x00, 0x0d, 0xa5, 0x00, 0x5c, 0x00, 0xbf, 0x00,
	0x80, 0x00, 0xec, 0x00, 0x8e, 0x00, 0xec, 0x00,
	0x8e, 0x00, 0x04, 0x01, 0x68, 0x61, 0x79, 0x20,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x00, 0x54, 0x68,
	0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x61, 0x20,
	0x6d, 0x6f, 0x75, 0x73, 0x65, 0x20, 0x68, 0x6f,
	0x6c, 0x65, 0x20, 0x69, 0x6e, 0x73, 0x69, 0x64,
	0x65, 0x21, 0x00, 0x00, 0x0e, 0xae, 0x00, 0xbc,
	0x00, 0xb4, 0x00, 0xc2, 0x00, 0xa1, 0x00, 0xc3,
	0x00, 0xa1, 0x00, 0xc3, 0x00, 0x02, 0x00, 0x66,
	0x65, 0x61, 0x74, 0x68, 0x65, 0x72, 0x00, 0x49,
	0x74, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x68,
	0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e,
	0x20, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64,
	0x20, 0x62, 0x79, 0x20, 0x68, 0x65, 0x6e, 0x2e,
	0x00, 0x00, 0x0f, 0x51, 0x00, 0x89, 0x00, 0x70,
	0x00, 0xb6, 0x00, 0x84, 0x00, 0xbe, 0x00, 0x84,
	0x00, 0xbe, 0x00, 0x04, 0x01, 0x68, 0x61, 0x79,
	0x20, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x00, 0x01,
	0x10, 0x04, 0x01, 0x0d, 0x00, 0x3f, 0x01, 0x5d,
	0x00, 0xe8, 0x00, 0x86, 0x00, 0xe8, 0x00, 0x86,
	0x00, 0x02, 0x01, 0x6d, 0x61, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x00, 0x47, 0x65, 0x65, 0x2c, 0x20,
	0x73, 0x6f, 0x6d, 0x65, 0x20, 0x70, 0x65, 0x6f,
	0x70, 0x6c, 0x65, 0x20, 0x72, 0x65, 0x61, 0x6c,
	0x6c, 0x79, 0x00, 0x68, 0x61, 0x76, 0x65, 0x20,
	0x6e, 0x6f, 0x20, 0x74, 0x61, 0x73, 0x74, 0x65,
	0x2e, 0x00, 0x00, 0xca, 0xa3, 0x0d, 0xa4, 0x3e,
	0xa4, 0x57, 0xa4, 0x00, 0x00, 0x01, 0x55, 0x00,
	0x35, 0x00, 0x79, 0x00, 0x56, 0x00, 0x67, 0x00,
	0x8f, 0x00, 0x67, 0x00, 0x8f, 0x00, 0x01, 0x01,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x00, 0x54,
	0x68, 0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x61,
	0x20, 0x73, 0x68, 0x75, 0x74, 0x74, 0x65, 0x72,
	0x2c, 0x20, 0x49, 0x20, 0x63, 0x61, 0x6e, 0x27,
	0x74, 0x20, 0x73, 0x65, 0x65, 0x20, 0x61, 0x20,
	0x74, 0x68, 0x69, 0x6e, 0x67, 0x2e, 0x00, 0x00,
	0x02, 0xaa, 0x00, 0x63, 0x00, 0xbd, 0x00, 0x7b,
	0x00, 0x8f, 0x00, 0x8f, 0x00, 0x8f, 0x00, 0x8f,
	0x00, 0x02, 0x01, 0x73, 0x63, 0x75, 0x6c, 0x70,
	0x74, 0x75, 0x72, 0x65, 0x00, 0x54, 0x68, 0x65,
	0x20, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x20, 0x69,
	0x73, 0x20, 0x73, 0x69, 0x63, 0x6b, 0x2e, 0x00,
	0x00, 0x03, 0xc6, 0x00, 0x53, 0x00, 0xf0, 0x00,
	0xa4, 0x00, 0xaa, 0x00, 0x99, 0x00, 0xd1, 0x00,
	0x99, 0x00, 0x02, 0x01, 0x64, 0x6f, 0x6f, 0x72,
	0x00, 0x01, 0x04, 0x00, 0x00, 0x8b, 0x00, 0x22,
	0x00, 0xc7, 0x00, 0x42, 0x00, 0xa7, 0x00, 0x42,
	0x00, 0xa7, 0x00, 0x04, 0x01, 0x77, 0x61, 0x79,
	0x20, 0x6f, 0x75, 0x74, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x00, 0x01, 0x92, 0xa4, 0xab,
	0xa4, 0xc4, 0xa4, 0x09, 0xa5, 0x3d, 0xa5, 0x8e,
	0xa5, 0xbd, 0xa5, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x5b, 0x00, 0x1a, 0x00, 0xae, 0x00, 0x2b, 0x00,
	0xaa, 0x00, 0x2b, 0x00, 0xaa, 0x00, 0x04, 0x01,
	0x64, 0x6f, 0x6f, 0x72, 0x00, 0x01, 0x02, 0xe8,
	0x00, 0x5b, 0x00, 0x17, 0x01, 0xa8, 0x00, 0xff,
	0x00, 0xb2, 0x00, 0xff, 0x00, 0xa6, 0x00, 0x01,
	0x01, 0x64, 0x6f, 0x6f, 0x72, 0x00, 0x01, 0x03,
	0x2b, 0x00, 0x74, 0x00, 0x4f, 0x00, 0xae, 0x00,
	0x3e, 0x00, 0xb7, 0x00, 0x3e, 0x00, 0xb7, 0x00,
	0x01, 0x01, 0x66, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x73, 0x00, 0x53, 0x75, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2c, 0x20, 0x73, 0x75, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2c, 0x20, 0x74, 0x68,
	0x65, 0x79, 0x20, 0x61, 0x72, 0x65, 0x6e, 0x27,
	0x74, 0x00, 0x70, 0x6c, 0x61, 0x73, 0x74, 0x69,
	0x63, 0x2e, 0x00, 0x00, 0x04, 0x82, 0x00, 0x32,
	0x00, 0xab, 0x00, 0x69, 0x00, 0xa2, 0x00, 0xad,
	0x00, 0xa2, 0x00, 0xad, 0x00, 0x01, 0x01, 0x70,
	0x6c, 0x61, 0x6e, 0x74, 0x00, 0x48, 0x6f, 0x77,
	0x27, 0x73, 0x20, 0x69, 0x74, 0x20, 0x68, 0x61,
	0x6e, 0x67, 0x69, 0x6e, 0x27, 0x2c, 0x20, 0x52,
	0x6f, 0x62, 0x62, 0x69, 0x65, 0x3f, 0x00, 0x00,
	0x05, 0x1e, 0x00, 0x49, 0x00, 0x9d, 0x00, 0xa8,
	0x00, 0xa2, 0x00, 0xad, 0x00, 0xa2, 0x00, 0xad,
	0x00, 0x01, 0x01, 0x73, 0x74, 0x61, 0x69, 0x72,
	0x73, 0x00, 0x54, 0x68, 0x65, 0x79, 0x20, 0x73,
	0x61, 0x79, 0x20, 0x65, 0x76, 0x65, 0x72, 0x79,
	0x20, 0x73, 0x74, 0x65, 0x70, 0x20, 0x6d, 0x61,
	0x6b, 0x65, 0x73, 0x20, 0x79, 0x6f, 0x75, 0x72,
	0x20, 0x6c, 0x69, 0x66, 0x65, 0x00, 0x33, 0x20,
	0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x20,
	0x6c, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x2e, 0x00,
	0x00, 0x06, 0x1f, 0x01, 0xa8, 0x00, 0x3f, 0x01,
	0xc7, 0x00, 0x18, 0x01, 0xbc, 0x00, 0x3f, 0x01,
	0xbc, 0x00, 0x02, 0x01, 0x6f, 0x74, 0x68, 0x65,
	0x72, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f,
	0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f,
	0x72, 0x72, 0x69, 0x64, 0x6f, 0x72, 0x00, 0x01,
	0x07, 0x00, 0x00, 0xc0, 0x00, 0x3f, 0x01, 0xc7,
	0x00, 0xa0, 0x00, 0xbc, 0x00, 0xa0, 0x00, 0xc7,
	0x00, 0x03, 0x01, 0x77, 0x61, 0x79, 0x20, 0x74,
	0x6f, 0x20, 0x70, 0x6f, 0x72, 0x63, 0x68, 0x00,
	0x01, 0x00, 0xa6, 0x1f, 0xa6, 0x4d, 0xa6, 0x84,
	0xa6, 0xd4, 0xa6, 0xee, 0xa6, 0x11, 0xa7, 0x51,
	0xa7, 0x72, 0xa7, 0x8b, 0xa7, 0xb3, 0xa7, 0xdb,
	0xa7, 0x03, 0xa8, 0x2b, 0xa8, 0x53, 0xa8, 0x7b,
	0xa8, 0x00, 0x00, 0x01, 0x00, 0x00, 0x78, 0x00,
	0x51, 0x00, 0x9c, 0x00, 0x12, 0x00, 0x9f, 0x00,
	0x12, 0x00, 0x9f, 0x00, 0x01, 0x01, 0x64, 0x6f,
	0x77, 0x6e, 0x73, 0x74, 0x61, 0x69, 0x72, 0x73,
	0x00, 0x01, 0x02, 0x14, 0x00, 0x3f, 0x00, 0x55,
	0x00, 0x6a, 0x00, 0x34, 0x00, 0xa5, 0x00, 0x34,
	0x00, 0xa5, 0x00, 0x01, 0x01, 0x70, 0x69, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x00, 0x49, 0x74, 0x27,
	0x73, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x63,
	0x61, 0x73, 0x74, 0x6c, 0x65, 0x2e, 0x00, 0x00,
	0x03, 0x29, 0x01, 0x5f, 0x00, 0x3f, 0x01, 0xb0,
	0x00, 0x0f, 0x01, 0xae, 0x00, 0x0f, 0x01, 0xae,
	0x00, 0x02, 0x01, 0x61, 0x72, 0x6d, 0x6f, 0x75,
	0x72, 0x00, 0x54, 0x68, 0x65, 0x20, 0x62, 0x65,
	0x74, 0x61, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20,
	0x74, 0x61, 0x6e, 0x6b, 0x2e, 0x00, 0x00, 0x04,
	0xcf, 0x00, 0x63, 0x00, 0xda, 0x00, 0x67, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x01, 0x00, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x20,
	0x74, 0x61, 0x70, 0x65, 0x00, 0x57, 0x68, 0x61,
	0x74, 0x20, 0x6b, 0x69, 0x6e, 0x64, 0x20, 0x6f,
	0x66, 0x20, 0x6d, 0x6f, 0x76, 0x69, 0x65, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x69, 0x74, 0x20,
	0x62, 0x65, 0x00, 0x68, 0x69, 0x64, 0x64, 0x65,
	0x6e, 0x20, 0x73, 0x6f, 0x20, 0x77, 0x65, 0x6c,
	0x6c, 0x3f, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x05,
	0xc3, 0x00, 0x54, 0x00, 0xc7, 0x00, 0x5d, 0x00,
	0xd0, 0x00, 0x97, 0x00, 0xd0, 0x00, 0x97, 0x00,
	0x01, 0x01, 0x62, 0x6f, 0x6f, 0x6b, 0x00, 0x00,
	0x00, 0x06, 0x6f, 0x00, 0x2f, 0x00, 0x3f, 0x01,
	0x6e, 0x00, 0xdd, 0x00, 0x9b, 0x00, 0xdd, 0x00,
	0x9b, 0x00, 0x01, 0x01, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x00, 0x4f, 0x68, 0x2c, 0x20, 0x62, 0x6f,
	0x79, 0x21, 0x00, 0x00, 0x07, 0xd5, 0x00, 0xab,
	0x00, 0xe3, 0x00, 0xbd, 0x00, 0xea, 0x00, 0xbd,
	0x00, 0xea, 0x00, 0xbd, 0x00, 0x04, 0x01, 0x74,
	0x72, 0x61, 0x73, 0x68, 0x20, 0x63, 0x61, 0x6e,
	0x00, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61,
	0x72, 0x65, 0x20, 0x61, 0x20, 0x6c, 0x6f, 0x74,
	0x20, 0x6f, 0x66, 0x20, 0x70, 0x61, 0x70, 0x65,
	0x72, 0x73, 0x20, 0x69, 0x6e, 0x73, 0x69, 0x64,
	0x65, 0x2e, 0x00, 0x00, 0x08, 0x98, 0x00, 0x8d,
	0x00, 0xb2, 0x00, 0xc1, 0x00, 0xa5, 0x00, 0xc6,
	0x00, 0xa5, 0x00, 0xc6, 0x00, 0x01, 0x01, 0x63,
	0x68, 0x61, 0x69, 0x72, 0x00, 0x53, 0x6f, 0x66,
	0x74, 0x79, 0x2e, 0x00, 0x00, 0x09, 0x87, 0x00,
	0x86, 0x00, 0xa2, 0x00, 0x99, 0x00, 0x88, 0x00,
	0xc1, 0x00, 0x88, 0x00, 0xc1, 0x00, 0x01, 0x01,
	0x6c, 0x61, 0x6d, 0x70, 0x00, 0x01, 0x0a, 0x7c,
	0x00, 0x9e, 0x00, 0x95, 0x00, 0xa6, 0x00, 0x88,
	0x00, 0xc1, 0x00, 0x88, 0x00, 0xc1, 0x00, 0x01,
	0x01, 0x64, 0x72, 0x61, 0x77, 0x65, 0x72, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x63, 0x6c, 0x6f,
	0x73, 0x65, 0x64, 0x2e, 0x00, 0x00, 0x0b, 0x7c,
	0x00, 0xa8, 0x00, 0x95, 0x00, 0xaf, 0x00, 0x88,
	0x00, 0xc1, 0x00, 0x88, 0x00, 0xc1, 0x00, 0x01,
	0x01, 0x64, 0x72, 0x61, 0x77, 0x65, 0x72, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x63, 0x6c, 0x6f,
	0x73, 0x65, 0x64, 0x2e, 0x00, 0x00, 0x0c, 0x7c,
	0x00, 0xb1, 0x00, 0x95, 0x00, 0xb8, 0x00, 0x88,
	0x00, 0xc1, 0x00, 0x88, 0x00, 0xc1, 0x00, 0x01,
	0x01, 0x64, 0x72, 0x61, 0x77, 0x65, 0x72, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x63, 0x6c, 0x6f,
	0x73, 0x65, 0x64, 0x2e, 0x00, 0x00, 0x0d, 0xb6,
	0x00, 0x9e, 0x00, 0xd0, 0x00, 0xa6, 0x00, 0xc4,
	0x00, 0xc0, 0x00, 0xc4, 0x00, 0xc0, 0x00, 0x01,
	0x01, 0x64, 0x72, 0x61, 0x77, 0x65, 0x72, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x63, 0x6c, 0x6f,
	0x73, 0x65, 0x64, 0x2e, 0x00, 0x00, 0x0e, 0xb6,
	0x00, 0xa8, 0x00, 0xd0, 0x00, 0xaf, 0x00, 0xc4,
	0x00, 0xc0, 0x00, 0xc4, 0x00, 0xc0, 0x00, 0x01,
	0x01, 0x64, 0x72, 0x61, 0x77, 0x65, 0x72, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x63, 0x6c, 0x6f,
	0x73, 0x65, 0x64, 0x2e, 0x00, 0x00, 0x0f, 0xb6,
	0x00, 0xb1, 0x00, 0xd0, 0x00, 0xb8, 0x00, 0xc4,
	0x00, 0xc0, 0x00, 0xc4, 0x00, 0xc0, 0x00, 0x01,
	0x01, 0x64, 0x72, 0x61, 0x77, 0x65, 0x72, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x63, 0x6c, 0x6f,
	0x73, 0x65, 0x64, 0x2e, 0x00, 0x00, 0x10, 0xf3,
	0x00, 0x71, 0x00, 0x18, 0x01, 0x98, 0x00, 0x06,
	0x01, 0x9e, 0x00, 0x06, 0x01, 0x9e, 0x00, 0x01,
	0x01, 0x6c, 0x61, 0x64, 0x64, 0x65, 0x72, 0x00,
	0x49, 0x6e, 0x64, 0x69, 0x73, 0x70, 0x65, 0x6e,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74,
	0x6f, 0x20, 0x67, 0x69, 0x72, 0x6c, 0x73, 0x20,
	0x69, 0x6e, 0x20, 0x73, 0x6b, 0x69, 0x72, 0x74,
	0x73, 0x2e, 0x00, 0x00, 0xd5, 0xa8, 0xee, 0xa8,
	0x1e, 0xa9, 0x58, 0xa9, 0x96, 0xa9, 0xcc, 0xa9,
	0xf4, 0xa9, 0x1f, 0xaa, 0x38, 0xaa, 0x00, 0x00,
	0x01, 0x73, 0x00, 0x5b, 0x00, 0xa3, 0x00, 0xa7,
	0x00, 0x8c, 0x00, 0xac, 0x00, 0x8c, 0x00, 0xa6,
	0x00, 0x01, 0x01, 0x64, 0x6f, 0x6f, 0x72, 0x00,
	0x01, 0x02, 0x36, 0x01, 0x8c, 0x00, 0x3b, 0x01,
	0x91, 0x00, 0x2c, 0x01, 0xb2, 0x00, 0x2c, 0x01,
	0xb2, 0x00, 0x02, 0x01, 0x68, 0x6f, 0x6c, 0x65,
	0x00, 0x49, 0x74, 0x20, 0x68, 0x61, 0x73, 0x20,
	0x61, 0x20, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65,
	0x20, 0x73, 0x68, 0x61, 0x70, 0x65, 0x2e, 0x00,
	0x00, 0x03, 0x31, 0x01, 0x8b, 0x00, 0x3b, 0x01,
	0x91, 0x00, 0x2c, 0x01, 0xb2, 0x00, 0x2c, 0x01,
	0xb2, 0x00, 0x02, 0x00, 0x68, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x00, 0x49, 0x74, 0x20, 0x66, 0x69,
	0x74, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x68, 0x6f, 0x6c, 0x65, 0x20, 0x70,
	0x65, 0x72, 0x66, 0x65, 0x63, 0x74, 0x6c, 0x79,
	0x2e, 0x00, 0x00, 0x04, 0x04, 0x00, 0x3f, 0x00,
	0x64, 0x00, 0x61, 0x00, 0x3b, 0x00, 0xb2, 0x00,
	0x3b, 0x00, 0xb2, 0x00, 0x01, 0x01, 0x70, 0x69,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x00, 0x49, 0x20,
	0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x20, 0x6c,
	0x69, 0x6b, 0x65, 0x64, 0x20, 0x53, 0x60, 0x54,
	0x60, 0x41, 0x60, 0x52, 0x60, 0x20, 0x57, 0x60,
	0x41, 0x60, 0x52, 0x60, 0x53, 0x60, 0x2e, 0x00,
	0x00, 0x05, 0xd8, 0x00, 0x4d, 0x00, 0x09, 0x01,
	0x79, 0x00, 0xf3, 0x00, 0xb5, 0x00, 0xf3, 0x00,
	0xb5, 0x00, 0x01, 0x01, 0x70, 0x69, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x00, 0x41, 0x6e, 0x64, 0x20,
	0x49, 0x20, 0x74, 0x6f, 0x75, 0x67, 0x68, 0x74,
	0x20, 0x49, 0x20, 0x77, 0x61, 0x73, 0x20, 0x77,
	0x65, 0x69, 0x72, 0x64, 0x2e, 0x00, 0x00, 0x06,
	0xf3, 0x00, 0x91, 0x00, 0x15, 0x01, 0xc7, 0x00,
	0xf3, 0x00, 0xb5, 0x00, 0xf3, 0x00, 0xb5, 0x00,
	0x03, 0x01, 0x66, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x73, 0x00, 0x4e, 0x69, 0x63, 0x65, 0x20, 0x73,
	0x6d, 0x65, 0x6c, 0x6c, 0x2e, 0x00, 0x00, 0x07,
	0x00, 0x00, 0xa8, 0x00, 0x1a, 0x00, 0xc7, 0x00,
	0x28, 0x00, 0xbc, 0x00, 0x00, 0x00, 0xbc, 0x00,
	0x04, 0x01, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20,
	0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20,
	0x63, 0x6f, 0x72, 0x72, 0x69, 0x64, 0x6f, 0x72,
	0x00, 0x01, 0x08, 0x25, 0x01, 0x5f, 0x00, 0x3f,
	0x01, 0xb6, 0x00, 0x11, 0x01, 0xab, 0x00, 0x11,
	0x01, 0xab, 0x00, 0x02, 0x01, 0x64, 0x6f, 0x6f,
	0x72, 0x00, 0x01, 0x09, 0x0e, 0x00, 0x5a, 0x00,
	0x32, 0x00, 0xb0, 0x00, 0x28, 0x00, 0xbc, 0x00,
	0x28, 0x00, 0xbc, 0x00, 0x01, 0x01, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x65, 0x00, 0x42, 0x69, 0x7a,
	0x61, 0x72, 0x72, 0x65, 0x2e, 0x00, 0x00, 0x6e,
	0xaa, 0x9a, 0xaa, 0xcd, 0xaa, 0x12, 0xab, 0x5d,
	0xab, 0x79, 0xab, 0x92, 0xab, 0xda, 0xab, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x52, 0x00, 0xb6, 0x00, 0x52, 0x00,
	0xb6, 0x00, 0x01, 0x01, 0x72, 0x6f, 0x62, 0x6f,
	0x74, 0x00, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x76, 0x65, 0x2e, 0x00, 0x00, 0x4d,
	0x69, 0x6b, 0x65, 0x00, 0xff, 0x02, 0x2d, 0x00,
	0x75, 0x00, 0x37, 0x00, 0x83, 0x00, 0x33, 0x00,
	0xaa, 0x00, 0x33, 0x00, 0xaa, 0x00, 0x01, 0x00,
	0x6a, 0x61, 0x72, 0x00, 0x54, 0x68, 0x69, 0x73,
	0x20, 0x6a, 0x61, 0x72, 0x20, 0x69, 0x73, 0x20,
	0x66, 0x75, 0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x20,
	0x70, 0x69, 0x6c, 0x6c, 0x73, 0x2e, 0x00, 0x00,
	0x03, 0x2d, 0x00, 0x75, 0x00, 0x37, 0x00, 0x83,
	0x00, 0x33, 0x00, 0xaa, 0x00, 0x33, 0x00, 0xaa,
	0x00, 0x01, 0x00, 0x62, 0x6f, 0x6f, 0x6b, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x62, 0x69, 0x67,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x6f, 0x6f,
	0x6b, 0x73, 0x00, 0x6c, 0x69, 0x6b, 0x65, 0x20,
	0x73, 0x6f, 0x6d, 0x65, 0x20, 0x6b, 0x69, 0x6e,
	0x64, 0x20, 0x6f, 0x66, 0x00, 0x64, 0x69, 0x61,
	0x72, 0x79, 0x2e, 0x00, 0x00, 0x04, 0x74, 0x00,
	0x2d, 0x00, 0xb9, 0x00, 0x7e, 0x00, 0x98, 0x00,
	0xa5, 0x00, 0x98, 0x00, 0xa5, 0x00, 0x01, 0x01,
	0x70, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x00,
	0x54, 0x68, 0x61, 0x74, 0x20, 0x6f, 0x6e, 0x65,
	0x27, 0x73, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x2e, 0x20, 0x49, 0x27, 0x64, 0x20, 0x6c, 0x69,
	0x6b, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x68, 0x61,
	0x76, 0x65, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6d,
	0x79, 0x73, 0x65, 0x6c, 0x66, 0x2e, 0x00, 0x00,
	0x05, 0x88, 0x00, 0x88, 0x00, 0xa5, 0x00, 0x9f,
	0x00, 0x98, 0x00, 0xa5, 0x00, 0x98, 0x00, 0xa5,
	0x00, 0x01, 0x01, 0x63, 0x61, 0x62, 0x69, 0x6e,
	0x65, 0x74, 0x00, 0x01, 0x06, 0x4e, 0x00, 0xbd,
	0x00, 0xe0, 0x00, 0xc7, 0x00, 0x8b, 0x00, 0xbc,
	0x00, 0x8b, 0x00, 0xc7, 0x00, 0x03, 0x01, 0x65,
	0x78, 0x69, 0x74, 0x00, 0x01, 0x07, 0x00, 0x00,
	0xc7, 0x00, 0x4d, 0x00, 0xc7, 0x00, 0x8b, 0x00,
	0xbc, 0x00, 0x39, 0x00, 0xc6, 0x00, 0x03, 0x00,
	0x6c, 0x65, 0x66, 0x74, 0x20, 0x6c, 0x6f, 0x77,
	0x65, 0x72, 0x20, 0x65, 0x64, 0x67, 0x65, 0x20,
	0x6f, 0x66, 0x20, 0x73, 0x63, 0x72, 0x65, 0x65,
	0x6e, 0x00, 0x49, 0x20, 0x63, 0x6f, 0x75, 0x6c,
	0x64, 0x20, 0x74, 0x72, 0x79, 0x20, 0x74, 0x6f,
	0x20, 0x68, 0x69, 0x64, 0x65, 0x20, 0x68, 0x65,
	0x72, 0x65, 0x21, 0x00, 0x00, 0x08, 0x89, 0x00,
	0x7e, 0x00, 0x93, 0x00, 0x85, 0x00, 0x8f, 0x00,
	0xa3, 0x00, 0x8f, 0x00, 0xa3, 0x00, 0x01, 0x00,
	0x64, 0x6f, 0x6f, 0x72, 0x20, 0x68, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x00, 0x4a, 0x6f, 0x68, 0x6e,
	0x20, 0x4e, 0x6f, 0x74, 0x79, 0x20, 0x6c, 0x65,
	0x66, 0x74, 0x20, 0x69, 0x74, 0x20, 0x68, 0x65,
	0x72, 0x65, 0x2e, 0x00, 0x00, 0x2c, 0xac, 0x6b,
	0xac, 0xb8, 0xac, 0xe3, 0xac, 0xff, 0xac, 0x43,
	0xad, 0x8d, 0xad, 0xcc, 0xad, 0x1d, 0xae, 0x6e,
	0xae, 0xbe, 0xae, 0xf8, 0xae, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x8d, 0x00, 0x9f, 0x00, 0x8d, 0x00, 0x9f, 0x00,
	0x04, 0x01, 0x63, 0x6f, 0x6f, 0x6b, 0x00, 0x48,
	0x65, 0x27, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x6c, 0x79, 0x20, 0x61,
	0x64, 0x64, 0x69, 0x63, 0x74, 0x65, 0x64, 0x20,
	0x74, 0x6f, 0x20, 0x68, 0x69, 0x73, 0x20, 0x77,
	0x6f, 0x72, 0x6b, 0x2e, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x04,
	0x01, 0x73, 0x74, 0x65, 0x77, 0x00, 0x49, 0x74,
	0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65,
	0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x6b, 0x69,
	0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x73, 0x6f,
	0x75, 0x70, 0x2e, 0x00, 0x4e, 0x6f, 0x77, 0x20,
	0x77, 0x69, 0x74, 0x68, 0x20, 0x65, 0x78, 0x74,
	0x72, 0x61, 0x20, 0x70, 0x6f, 0x77, 0x65, 0x72,
	0x2e, 0x00, 0x00, 0x03, 0x26, 0x00, 0x84, 0x00,
	0x30, 0x00, 0x8e, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0x04, 0x01, 0x68, 0x6f,
	0x74, 0x20, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x00,
	0x54, 0x68, 0x61, 0x74, 0x27, 0x73, 0x20, 0x43,
	0x4f, 0x4f, 0x4c, 0x2e, 0x00, 0x00, 0x04, 0x1c,
	0x01, 0x9c, 0x00, 0x3f, 0x01, 0xc7, 0x00, 0x0b,
	0x01, 0xb2, 0x00, 0x3f, 0x01, 0xb2, 0x00, 0x02,
	0x01, 0x77, 0x61, 0x79, 0x20, 0x6f, 0x75, 0x74,
	0x00, 0x01, 0x05, 0x9e, 0x00, 0x7f, 0x00, 0xc1,
	0x00, 0x9b, 0x00, 0xc0, 0x00, 0xa0, 0x00, 0xc0,
	0x00, 0xa0, 0x00, 0x01, 0x01, 0x72, 0x65, 0x66,
	0x72, 0x69, 0x67, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x00, 0x4d, 0x79, 0x20, 0x66, 0x61, 0x76,
	0x6f, 0x75, 0x72, 0x69, 0x74, 0x65, 0x20, 0x74,
	0x68, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x6b, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x6e, 0x2e, 0x00, 0x00, 0x06, 0x81,
	0x00, 0x74, 0x00, 0x9c, 0x00, 0x7c, 0x00, 0x8d,
	0x00, 0x9f, 0x00, 0x8d, 0x00, 0x9f, 0x00, 0x01,
	0x01, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x00, 0x49,
	0x74, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x20,
	0x77, 0x69, 0x74, 0x68, 0x20, 0x62, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x20,
	0x4a, 0x75, 0x73, 0x74, 0x20, 0x6c, 0x69, 0x6b,
	0x65, 0x00, 0x74, 0x68, 0x65, 0x20, 0x77, 0x61,
	0x6c, 0x6b, 0x6d, 0x61, 0x6e, 0x2e, 0x00, 0x00,
	0x07, 0xdb, 0x00, 0x70, 0x00, 0xe0, 0x00, 0x7c,
	0x00, 0xdd, 0x00, 0xa0, 0x00, 0xdd, 0x00, 0xa0,
	0x00, 0x01, 0x01, 0x63, 0x68, 0x69, 0x6c, 0x6c,
	0x69, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x72,
	0x65, 0x64, 0x2c, 0x20, 0x69, 0x74, 0x27, 0x73,
	0x20, 0x68, 0x6f, 0x74, 0x2c, 0x20, 0x69, 0x74,
	0x27, 0x73, 0x20, 0x2e, 0x2e, 0x2e, 0x43, 0x48,
	0x49, 0x4c, 0x4c, 0x49, 0x21, 0x00, 0x00, 0x08,
	0xd5, 0x00, 0x77, 0x00, 0xe6, 0x00, 0x7e, 0x00,
	0xdd, 0x00, 0xa0, 0x00, 0xdd, 0x00, 0xa0, 0x00,
	0x01, 0x00, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x20,
	0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x63, 0x68,
	0x69, 0x6c, 0x6c, 0x69, 0x20, 0x62, 0x6f, 0x74,
	0x74, 0x6c, 0x65, 0x20, 0x73, 0x74, 0x6f, 0x6f,
	0x64, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x20, 0x77, 0x68, 0x65, 0x72, 0x65, 0x2e, 0x2e,
	0x2e, 0x20, 0x65, 0x74, 0x63, 0x2e, 0x00, 0x00,
	0x09, 0x23, 0x01, 0x77, 0x00, 0x2f, 0x01, 0x7e,
	0x00, 0x28, 0x01, 0xa0, 0x00, 0x28, 0x01, 0xa0,
	0x00, 0x01, 0x01, 0x70, 0x61, 0x73, 0x74, 0x72,
	0x79, 0x20, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x72,
	0x00, 0x4d, 0x65, 0x6e, 0x20, 0x75, 0x73, 0x65,
	0x20, 0x67, 0x75, 0x6e, 0x73, 0x2e, 0x20, 0x57,
	0x6f, 0x6d, 0x65, 0x6e, 0x20, 0x75, 0x73, 0x65,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x00, 0x31,
	0x20, 0x3a, 0x20, 0x30, 0x20, 0x66, 0x6f, 0x72,
	0x20, 0x77, 0x6f, 0x6d, 0x65, 0x6e, 0x2e, 0x00,
	0x00, 0x0a, 0x59, 0x00, 0x70, 0x00, 0x6d, 0x00,
	0x7d, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x01, 0x01, 0x6d, 0x69, 0x63, 0x72,
	0x6f, 0x77, 0x61, 0x76, 0x65, 0x00, 0x49, 0x74,
	0x27, 0x73, 0x20, 0x61, 0x20, 0x6d, 0x61, 0x67,
	0x69, 0x63, 0x20, 0x74, 0x6f, 0x6f, 0x6c, 0x2e,
	0x20, 0x49, 0x74, 0x20, 0x74, 0x75, 0x72, 0x6e,
	0x73, 0x00, 0x61, 0x6e, 0x79, 0x20, 0x64, 0x69,
	0x73, 0x68, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x20,
	0x72, 0x75, 0x62, 0x62, 0x65, 0x72, 0x2e, 0x00,
	0x00, 0x0b, 0xb4, 0x00, 0x67, 0x00, 0xd5, 0x00,
	0x74, 0x00, 0xc7, 0x00, 0xa2, 0x00, 0xc7, 0x00,
	0xa2, 0x00, 0x01, 0x01, 0x6b, 0x6e, 0x69, 0x76,
	0x65, 0x73, 0x00, 0x41, 0x20, 0x76, 0x65, 0x72,
	0x79, 0x20, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x63, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x00, 0x00, 0x0c, 0xad, 0x00, 0x82, 0x00,
	0xb8, 0x00, 0x8c, 0x00, 0xc0, 0x00, 0xa0, 0x00,
	0xc0, 0x00, 0xa0, 0x00, 0x01, 0x01, 0x6d, 0x65,
	0x61, 0x74, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20,
	0x69, 0x6e, 0x20, 0x61, 0x20, 0x70, 0x6c, 0x61,
	0x73, 0x74, 0x69, 0x63, 0x20, 0x62, 0x61, 0x67,
	0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x68,
	0x61, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x7a, 0x65,
	0x6e, 0x20, 0x74, 0x6f, 0x00, 0x74, 0x68, 0x65,
	0x20, 0x73, 0x68, 0x65, 0x6c, 0x66, 0x2e, 0x00,
	0x00, 0x56, 0xaf, 0x6f, 0xaf, 0x97, 0xaf, 0xaf,
	0xaf, 0xe4, 0xaf, 0x00, 0xb0, 0x29, 0xb0, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x2d, 0x00, 0x23, 0x00,
	0x82, 0x00, 0x34, 0x00, 0x85, 0x00, 0x28, 0x00,
	0x80, 0x00, 0x04, 0x01, 0x64, 0x6f, 0x6f, 0x72,
	0x00, 0x01, 0x02, 0x15, 0x01, 0x7d, 0x00, 0x36,
	0x01, 0x9e, 0x00, 0x25, 0x01, 0xa6, 0x00, 0x25,
	0x01, 0xa6, 0x00, 0x01, 0x01, 0x73, 0x69, 0x6e,
	0x6b, 0x00, 0x49, 0x74, 0x20, 0x68, 0x61, 0x73,
	0x20, 0x61, 0x20, 0x68, 0x6f, 0x6c, 0x65, 0x2e,
	0x00, 0x00, 0x03, 0x1e, 0x01, 0x70, 0x00, 0x2c,
	0x01, 0x7c, 0x00, 0x14, 0x01, 0x9f, 0x00, 0x14,
	0x01, 0x9f, 0x00, 0x02, 0x01, 0x74, 0x61, 0x70,
	0x00, 0x01, 0x04, 0x55, 0x00, 0x2e, 0x00, 0x76,
	0x00, 0x67, 0x00, 0x60, 0x00, 0x8c, 0x00, 0x60,
	0x00, 0x8c, 0x00, 0x01, 0x01, 0x6d, 0x69, 0x72,
	0x72, 0x6f, 0x72, 0x00, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64,
	0x20, 0x69, 0x6e, 0x20, 0x6f, 0x6c, 0x64, 0x20,
	0x64, 0x69, 0x72, 0x74, 0x2e, 0x00, 0x00, 0x05,
	0x4a, 0x00, 0x6c, 0x00, 0x74, 0x00, 0x86, 0x00,
	0x62, 0x00, 0x87, 0x00, 0x62, 0x00, 0x87, 0x00,
	0x01, 0x01, 0x63, 0x61, 0x62, 0x69, 0x6e, 0x65,
	0x74, 0x00, 0x01, 0x06, 0x7a, 0x00, 0x82, 0x00,
	0xff, 0x00, 0xa4, 0x00, 0xc0, 0x00, 0xae, 0x00,
	0xc0, 0x00, 0xae, 0x00, 0x01, 0x01, 0x62, 0x61,
	0x74, 0x68, 0x00, 0x57, 0x68, 0x6f, 0x61, 0x21,
	0x20, 0x49, 0x74, 0x27, 0x73, 0x20, 0x62, 0x69,
	0x67, 0x21, 0x00, 0x00, 0x07, 0x34, 0x00, 0x72,
	0x00, 0x3a, 0x00, 0x7d, 0x00, 0x44, 0x00, 0x81,
	0x00, 0x44, 0x00, 0x81, 0x00, 0x04, 0x01, 0x73,
	0x6f, 0x63, 0x6b, 0x00, 0x49, 0x74, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x4a,
	0x6f, 0x68, 0x6e, 0x20, 0x4e, 0x6f, 0x74, 0x79,
	0x27, 0x73, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x76,
	0xb0, 0xb4, 0xb0, 0xf9, 0xb0, 0x3b, 0xb1, 0x84,
	0xb1, 0xe6, 0xb1, 0x2a, 0xb2, 0x7d, 0xb2, 0xc3,
	0xb2, 0xdf, 0xb2, 0x1b, 0xb3, 0x6c, 0xb3, 0x00,
	0x00, 0x01, 0x52, 0x00, 0x8a, 0x00, 0x5e, 0x00,
	0x9b, 0x00, 0x68, 0x00, 0xb5, 0x00, 0x68, 0x00,
	0xb5, 0x00, 0x04, 0x01, 0x63, 0x6f, 0x67, 0x6e,
	0x61, 0x63, 0x00, 0x42, 0x6f, 0x74, 0x74, 0x6c,
	0x65, 0x20, 0x61, 0x73, 0x20, 0x62, 0x69, 0x67,
	0x20, 0x61, 0x73, 0x20, 0x4e, 0x61, 0x70, 0x6f,
	0x6c, 0x65, 0x6f, 0x6e, 0x20, 0x68, 0x69, 0x6d,
	0x73, 0x65, 0x6c, 0x66, 0x2e, 0x00, 0x00, 0x02,
	0x52, 0x00, 0x8a, 0x00, 0x5e, 0x00, 0x96, 0x00,
	0x68, 0x00, 0xb5, 0x00, 0x68, 0x00, 0xb5, 0x00,
	0x04, 0x01, 0x70, 0x69, 0x6e, 0x63, 0x65, 0x72,
	0x73, 0x00, 0x54, 0x68, 0x65, 0x72, 0x65, 0x27,
	0x73, 0x20, 0x61, 0x20, 0x70, 0x61, 0x69, 0x72,
	0x20, 0x6f, 0x66, 0x20, 0x70, 0x69, 0x6e, 0x63,
	0x65, 0x72, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x62, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x2e, 0x00, 0x00, 0x03, 0x71, 0x00, 0x27,
	0x00, 0x91, 0x00, 0x72, 0x00, 0x84, 0x00, 0xaf,
	0x00, 0x84, 0x00, 0xaf, 0x00, 0x01, 0x01, 0x6d,
	0x61, 0x73, 0x6b, 0x00, 0x54, 0x68, 0x69, 0x73,
	0x20, 0x69, 0x73, 0x20, 0x73, 0x6f, 0x6d, 0x65,
	0x20, 0x6b, 0x69, 0x6e, 0x64, 0x20, 0x6f, 0x66,
	0x20, 0x63, 0x6f, 0x6f, 0x6c, 0x20, 0x70, 0x72,
	0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x20,
	0x61, 0x72, 0x74, 0x2e, 0x00, 0x00, 0x04, 0x6c,
	0x00, 0x73, 0x00, 0x9e, 0x00, 0x91, 0x00, 0x87,
	0x00, 0xab, 0x00, 0x87, 0x00, 0xab, 0x00, 0x01,
	0x01, 0x54, 0x56, 0x00, 0x4f, 0x6e, 0x65, 0x20,
	0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x6b, 0x69,
	0x6c, 0x6c, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20,
	0x74, 0x69, 0x6d, 0x65, 0x20, 0x61, 0x6e, 0x64,
	0x00, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x2e, 0x00, 0x00, 0x05,
	0x78, 0x00, 0x94, 0x00, 0x92, 0x00, 0x9a, 0x00,
	0x84, 0x00, 0xaf, 0x00, 0x84, 0x00, 0xaf, 0x00,
	0x01, 0x01, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x20,
	0x70, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x00, 0x49,
	0x74, 0x20, 0x68, 0x61, 0x73, 0x20, 0x6e, 0x6f,
	0x20, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x20,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2c, 0x00, 0x62, 0x75, 0x74, 0x20, 0x74, 0x68,
	0x61, 0x74, 0x20, 0x64, 0x6f, 0x65, 0x73, 0x6e,
	0x27, 0x74, 0x20, 0x6d, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x00, 0x74, 0x6f, 0x20, 0x6d, 0x65, 0x20,
	0x61, 0x6e, 0x79, 0x77, 0x61, 0x79, 0x2e, 0x00,
	0x00, 0x06, 0xb9, 0x00, 0x98, 0x00, 0xcb, 0x00,
	0xa4, 0x00, 0xc1, 0x00, 0xa9, 0x00, 0xc1, 0x00,
	0xa9, 0x00, 0x01, 0x01, 0x6e, 0x65, 0x77, 0x73,
	0x70, 0x61, 0x70, 0x65, 0x72, 0x00, 0x54, 0x68,
	0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x73, 0x6f,
	0x6d, 0x65, 0x20, 0x6b, 0x69, 0x6e, 0x64, 0x20,
	0x6f, 0x66, 0x20, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x20, 0x6e, 0x65, 0x77, 0x73, 0x70, 0x61, 0x70,
	0x65, 0x72, 0x2e, 0x00, 0x00, 0x07, 0xd2, 0x00,
	0x93, 0x00, 0xe4, 0x00, 0xa0, 0x00, 0xdb, 0x00,
	0xaa, 0x00, 0xdb, 0x00, 0xaa, 0x00, 0x01, 0x01,
	0x68, 0x69, 0x2d, 0x66, 0x69, 0x00, 0x57, 0x68,
	0x61, 0x74, 0x20, 0x61, 0x20, 0x62, 0x61, 0x62,
	0x79, 0x21, 0x20, 0x49, 0x74, 0x20, 0x63, 0x6f,
	0x75, 0x6c, 0x64, 0x20, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x00, 0x61, 0x6c, 0x6c, 0x20, 0x6d, 0x79,
	0x20, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f,
	0x75, 0x72, 0x73, 0x20, 0x69, 0x6e, 0x73, 0x61,
	0x6e, 0x65, 0x21, 0x2e, 0x2e, 0x2e, 0x00, 0x00,
	0x08, 0xc0, 0x00, 0xa4, 0x00, 0x3f, 0x01, 0xc7,
	0x00, 0xa5, 0x00, 0xc4, 0x00, 0xa5, 0x00, 0xc4,
	0x00, 0x02, 0x01, 0x63, 0x6f, 0x75, 0x63, 0x68,
	0x00, 0x49, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64,
	0x20, 0x6e, 0x65, 0x76, 0x65, 0x72, 0x20, 0x6b,
	0x6e, 0x6f, 0x77, 0x20, 0x77, 0x68, 0x65, 0x72,
	0x65, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x00, 0x61, 0x20, 0x70, 0x69, 0x6c,
	0x6c, 0x6f, 0x77, 0x2e, 0x00, 0x00, 0x09, 0x00,
	0x00, 0xbe, 0x00, 0xbf, 0x00, 0xc7, 0x00, 0x9c,
	0x00, 0xbd, 0x00, 0x9c, 0x00, 0xc7, 0x00, 0x03,
	0x01, 0x77, 0x61, 0x79, 0x20, 0x6f, 0x75, 0x74,
	0x00, 0x01, 0x0a, 0xad, 0x00, 0x25, 0x00, 0x25,
	0x01, 0x79, 0x00, 0xdb, 0x00, 0xaa, 0x00, 0xdb,
	0x00, 0xaa, 0x00, 0x01, 0x01, 0x70, 0x69, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x00, 0x54, 0x68, 0x61,
	0x74, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x69, 0x73,
	0x20, 0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79, 0x20,
	0x69, 0x6d, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x2e, 0x00, 0x00, 0x0b, 0xa1,
	0x00, 0xa5, 0x00, 0xac, 0x00, 0xaa, 0x00, 0x98,
	0x00, 0xad, 0x00, 0x98, 0x00, 0xad, 0x00, 0x02,
	0x00, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x20,
	0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c,
	0x65, 0x72, 0x00, 0x49, 0x74, 0x20, 0x77, 0x61,
	0x73, 0x20, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e,
	0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x65, 0x77,
	0x73, 0x70, 0x61, 0x70, 0x65, 0x72, 0x20, 0x70,
	0x61, 0x67, 0x65, 0x73, 0x2e, 0x00, 0x00, 0x0c,
	0x2f, 0x00, 0x4f, 0x00, 0x57, 0x00, 0xaf, 0x00,
	0x68, 0x00, 0xb5, 0x00, 0x64, 0x00, 0xb5, 0x00,
	0x04, 0x00, 0x6f, 0x70, 0x65, 0x6e, 0x20, 0x77,
	0x61, 0x72, 0x64, 0x72, 0x6f, 0x62, 0x65, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x61, 0x20, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x20, 0x70, 0x61,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x21, 0x00, 0x00,
	0xad, 0xb3, 0xc6, 0xb3, 0xdf, 0xb3, 0x00, 0x00,
	0x01, 0x11, 0x01, 0x72, 0x00, 0x3f, 0x01, 0xc7,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0x02, 0x01, 0x64, 0x6f, 0x6f, 0x72, 0x00,
	0x01, 0x02, 0x00, 0x00, 0x73, 0x00, 0x2a, 0x00,
	0xc7, 0x00, 0x2e, 0x00, 0xc1, 0x00, 0x2e, 0x00,
	0xc1, 0x00, 0x04, 0x01, 0x64, 0x6f, 0x6f, 0x72,
	0x00, 0x01, 0x03, 0xf2, 0x00, 0x89, 0x00, 0xf6,
	0x00, 0x8e, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0x00, 0x01, 0x73, 0x77, 0x69,
	0x74, 0x63, 0x68, 0x00, 0x01, 0x00, 0x00, 0x08,
	0xb4, 0x4c, 0xb4, 0x74, 0xb4, 0x8d, 0xb4, 0xa6,
	0xb4, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xa0, 0x00,
	0x78, 0x00, 0xa0, 0x00, 0x04, 0x01, 0x4a, 0x6f,
	0x68, 0x6e, 0x20, 0x4e, 0x6f, 0x74, 0x79, 0x00,
	0x48, 0x65, 0x27, 0x73, 0x20, 0x6f, 0x62, 0x73,
	0x65, 0x73, 0x73, 0x65, 0x64, 0x20, 0x77, 0x69,
	0x74, 0x68, 0x20, 0x70, 0x61, 0x63, 0x6b, 0x69,
	0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d,
	0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x00, 0x00, 0x02,
	0xcf, 0x00, 0x6c, 0x00, 0x3f, 0x01, 0xc1, 0x00,
	0xc1, 0x00, 0xae, 0x00, 0xc1, 0x00, 0xae, 0x00,
	0x02, 0x01, 0x74, 0x6f, 0x6e, 0x73, 0x20, 0x6f,
	0x66, 0x20, 0x67, 0x6f, 0x6c, 0x64, 0x00, 0x28,
	0x67, 0x75, 0x6c, 0x70, 0x29, 0x00, 0x00, 0x03,
	0x06, 0x00, 0x5c, 0x00, 0x24, 0x00, 0x96, 0x00,
	0x58, 0x00, 0xad, 0x00, 0x58, 0x00, 0xad, 0x00,
	0x04, 0x01, 0x73, 0x61, 0x66, 0x65, 0x00, 0x01,
	0x04, 0x72, 0x00, 0x5e, 0x00, 0xb0, 0x00, 0x8d,
	0x00, 0x8c, 0x00, 0x9e, 0x00, 0x8c, 0x00, 0x9e,
	0x00, 0x01, 0x01, 0x73, 0x61, 0x66, 0x65, 0x00,
	0x01, 0x05, 0x0b, 0x01, 0x36, 0x00, 0x1c, 0x01,
	0x47, 0x00, 0xc1, 0x00, 0xae, 0x00, 0xc1, 0x00,
	0xae, 0x00, 0x02, 0x01, 0x63, 0x61, 0x6d, 0x65,
	0x72, 0x61, 0x00, 0x49, 0x74, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20,
	0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x20, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x2e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x49, 0xb5, 0x4a, 0xb5, 0x4d, 0xb5, 0x4f, 0xb5,
	0x53, 0xb5, 0x55, 0xb5, 0x5a, 0xb5, 0x5d, 0xb5,
	0x61, 0xb5, 0x62, 0xb5, 0x63, 0xb5, 0x68, 0xb5,
	0x6c, 0xb5, 0x6f, 0xb5, 0x71, 0xb5, 0x75, 0xb5,
	0x7a, 0xb5, 0x7c, 0xb5, 0x7f, 0xb5, 0x82, 0xb5,
	0x88, 0xb5, 0x8b, 0xb5, 0x8d, 0xb5, 0x8f, 0xb5,
	0x93, 0xb5, 0x96, 0xb5, 0x99, 0xb5, 0xa0, 0xb5,
	0xa1, 0xb5, 0xa2, 0xb5, 0xaa, 0xb5, 0xac, 0xb5,
	0xb0, 0xb5, 0xb6, 0xb5, 0xb8, 0xb5, 0xbd, 0xb5,
	0xbe, 0xb5, 0xc3, 0xb5, 0xc4, 0xb5, 0xc6, 0xb5,
	0xc8, 0xb5, 0xcb, 0xb5, 0xff, 0x5f, 0x63, 0xff,
	0x00, 0xff, 0x5d, 0x00, 0x62, 0xff, 0x00, 0xff,
	0x54, 0x55, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff,
	0x65, 0x69, 0x00, 0xff, 0xff, 0xff, 0x00, 0x11,
	0x00, 0x00, 0xff, 0x0e, 0x00, 0x12, 0xff, 0x29,
	0x00, 0xff, 0x00, 0xff, 0x14, 0x15, 0x2b, 0xff,
	0x00, 0x0a, 0x0b, 0x0c, 0xff, 0x25, 0xff, 0x16,
	0x00, 0xff, 0x19, 0x27, 0xff, 0x02, 0x03, 0x00,
	0x00, 0x00, 0xff, 0x1b, 0x00, 0xff, 0x07, 0xff,
	0x0d, 0xff, 0x1f, 0x00, 0x30, 0xff, 0x1a, 0x2c,
	0xff, 0x00, 0x00, 0xff, 0x00, 0x13, 0x22, 0x00,
	0x26, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x00,
	0x00, 0x00, 0xff, 0x3e, 0x3f, 0x40, 0x41, 0x00,
	0xff, 0x52, 0xff, 0x34, 0x3c, 0x00, 0x00, 0xff,
	0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0x6e, 0x6f,
	0xff, 0x22, 0xb6, 0x24, 0xb6, 0x2e, 0xb6, 0x3a,
	0xb6, 0x48, 0xb6, 0x56, 0xb6, 0x6a, 0xb6, 0x7a,
	0xb6, 0x8c, 0xb6, 0x9a, 0xb6, 0xa2, 0xb6, 0xc0,
	0xb6, 0xd2, 0xb6, 0xe0, 0xb6, 0xea, 0xb6, 0xfa,
	0xb6, 0x00, 0xb7, 0x02, 0xb7, 0x10, 0xb7, 0x2e,
	0xb7, 0x4e, 0xb7, 0x66, 0xb7, 0x80, 0xb7, 0xa0,
	0xb7, 0xb2, 0xb7, 0xc0, 0xb7, 0xcc, 0xb7, 0xec,
	0xb7, 0xf4, 0xb7, 0x02, 0xb8, 0x22, 0xb8, 0x34,
	0xb8, 0x44, 0xb8, 0x5c, 0xb8, 0x6a, 0xb8, 0x82,
	0xb8, 0x88, 0xb8, 0x8a, 0xb8, 0x94, 0xb8, 0x96,
	0xb8, 0x98, 0xb8, 0x9a, 0xb8, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x66,
	0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x78, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xa9, 0x78, 0x00, 0x00, 0xbb, 0x78, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xcd, 0x78, 0xce, 0x78, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xe0, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7,
	0x78, 0xee, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xf5, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x79, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19,
	0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x2b, 0x79, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0x79, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x62, 0x79, 0x66, 0x79, 0x00,
	0x00, 0x75, 0x79, 0x87, 0x79, 0x96, 0x79, 0xa5,
	0x79, 0xb4, 0x79, 0xc3, 0x79, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xd2, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xe4, 0x79, 0xeb, 0x79, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfd,
	0x79, 0x0f, 0x7a, 0x49, 0x7a, 0x5b, 0x7a, 0x6d,
	0x7a, 0x7f, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xb9, 0x7a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xd0, 0x7a, 0xd7, 0x7a, 0x00, 0x00, 0x00,
	0x00, 0xde, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xf0, 0x7a, 0x00, 0x00, 0xf7, 0x7a, 0x00,
	0x00, 0x09, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0,
	0xb8, 0xf2, 0xb8, 0xfc, 0xb8, 0x08, 0xb9, 0x16,
	0xb9, 0x24, 0xb9, 0x38, 0xb9, 0x50, 0xb9, 0x62,
	0xb9, 0x70, 0xb9, 0x78, 0xb9, 0x96, 0xb9, 0xa8,
	0xb9, 0xb6, 0xb9, 0xc0, 0xb9, 0xd0, 0xb9, 0xd6,
	0xb9, 0xd8, 0xb9, 0xe6, 0xb9, 0x04, 0xba, 0x24,
	0xba, 0x3c, 0xba, 0x56, 0xba, 0x76, 0xba, 0x88,
	0xba, 0x96, 0xba, 0xa2, 0xba, 0xc2, 0xba, 0xca,
	0xba, 0xd8, 0xba, 0xf8, 0xba, 0x0a, 0xbb, 0x1a,
	0xbb, 0x32, 0xbb, 0x40, 0xbb, 0x58, 0xbb, 0x5e,
	0xbb, 0x60, 0xbb, 0x6a, 0xbb, 0x6c, 0xbb, 0x6e,
	0xbb, 0x70, 0xbb, 0x00, 0x00, 0xed, 0x3f, 0x07,
	0x40, 0x21, 0x40, 0x48, 0x40, 0x4f, 0x40, 0x56,
	0x40, 0x60, 0x40, 0x7a, 0x40, 0x94, 0x40, 0x95,
	0x41, 0x9c, 0x41, 0xc3, 0x41, 0xca, 0x41, 0xce,
	0x41, 0x2c, 0x42, 0x33, 0x42, 0x4d, 0x42, 0x67,
	0x42, 0x3a, 0x43, 0x54, 0x43, 0x6e, 0x43, 0x88,
	0x43, 0xb5, 0x43, 0x82, 0x44, 0xcb, 0x44, 0xfc,
	0x44, 0x32, 0x45, 0x39, 0x45, 0x62, 0x46, 0xaf,
	0x46, 0x05, 0x47, 0x94, 0x47, 0xbc, 0x47, 0xdb,
	0x47, 0x36, 0x48, 0x3a, 0x48, 0x44, 0x48, 0x71,
	0x48, 0x7e, 0x48, 0x85, 0x48, 0x8c, 0x48, 0x93,
	0x48, 0xd4, 0x48, 0xdb, 0x48, 0xe2, 0x48, 0xe6,
	0x48, 0xea, 0x48, 0x11, 0x49, 0x18, 0x49, 0x64,
	0x4a, 0x8c, 0x4a, 0xed, 0x4a, 0xf4, 0x4a, 0x23,
	0x4b, 0x27, 0x4b, 0x2e, 0x4b, 0x35, 0x4b, 0xf5,
	0x4b, 0x18, 0x4c, 0x1c, 0x4c, 0x29, 0x4c, 0x30,
	0x4c, 0x37, 0x4c, 0x3e, 0x4c, 0x70, 0x4c, 0xa5,
	0x4c, 0xac, 0x4c, 0xf1, 0x4c, 0x56, 0x4d, 0x7d,
	0x4d, 0x81, 0x4d, 0x85, 0x4d, 0x89, 0x4d, 0x90,
	0x4d, 0x94, 0x4d, 0x47, 0x4e, 0x61, 0x4e, 0x85,
	0x4e, 0x9f, 0x4e, 0xb9, 0x4e, 0xe1, 0x4e, 0xe5,
	0x4e, 0x13, 0x4f, 0x14, 0x4f, 0x25, 0x4f, 0x32,
	0x4f, 0x0d, 0x50, 0x5f, 0x50, 0x66, 0x50, 0x80,
	0x50, 0x9a, 0x50, 0xf6, 0x50, 0xfd, 0x50, 0x04,
	0x51, 0xc8, 0x51, 0xcf, 0x51, 0xe9, 0x51, 0xf0,
	0x51, 0x17, 0x52, 0x2c, 0x52, 0x33, 0x52, 0x37,
	0x52, 0x20, 0x53, 0x3a, 0x53, 0x41, 0x53, 0x48,
	0x53, 0xa1, 0x53, 0x03, 0x54, 0x0a, 0x54, 0x24,
	0x54, 0x3e, 0x54, 0x58, 0x54, 0xb3, 0x54, 0x02,
	0x55, 0x00, 0x00, 0x47, 0x55, 0x61, 0x55, 0xa1,
	0x55, 0xa8, 0x55, 0x34, 0x56, 0x3b, 0x56, 0x63,
	0x56, 0x74, 0x56, 0x8e, 0x56, 0x95, 0x56, 0x9c,
	0x56, 0xb3, 0x56, 0xb7, 0x56, 0xd6, 0x56, 0xdd,
	0x56, 0xe4, 0x56, 0xeb, 0x56, 0xf2, 0x56, 0xf6,
	0x56, 0x21, 0x57, 0x28, 0x57, 0x4f, 0x57, 0x56,
	0x57, 0x93, 0x57, 0xfa, 0x57, 0x01, 0x58, 0x05,
	0x58, 0x32, 0x58, 0x3f, 0x58, 0x46, 0x58, 0x4d,
	0x58, 0x54, 0x58, 0x6e, 0x58, 0x88, 0x58, 0xa2,
	0x58, 0xb7, 0x58, 0xdf, 0x58, 0x03, 0x59, 0x0a,
	0x59, 0x24, 0x59, 0x3e, 0x59, 0x78, 0x59, 0x7f,
	0x59, 0x86, 0x59, 0x8d, 0x59, 0x94, 0x59, 0x8b,
	0x5a, 0x3a, 0x5b, 0x44, 0x5b, 0x59, 0x5b, 0xe1,
	0x5b, 0xee, 0x5b, 0x0d, 0x5c, 0x72, 0x5c, 0x79,
	0x5c, 0x80, 0x5c, 0x84, 0x5c, 0xdb, 0x5c, 0xe2,
	0x5c, 0xe9, 0x5c, 0xf0, 0x5c, 0x1d, 0x5d, 0x24,
	0x5d, 0x88, 0x5d, 0x4d, 0x5e, 0x73, 0x5f, 0x9a,
	0x5f, 0xa1, 0x5f, 0xa8, 0x5f, 0xaf, 0x5f, 0xb6,
	0x5f, 0xba, 0x5f, 0xe5, 0x5f, 0xec, 0x5f, 0xf3,
	0x5f, 0x3a, 0x60, 0x3e, 0x60, 0x74, 0x60, 0x78,
	0x60, 0x7f, 0x60, 0x83, 0x60, 0x2b, 0x61, 0x76,
	0x61, 0xe9, 0x61, 0x05, 0x62, 0x17, 0x62, 0x29,
	0x62, 0xc1, 0x62, 0xd0, 0x62, 0x4a, 0x63, 0x51,
	0x63, 0x7f, 0x63, 0x99, 0x63, 0xa0, 0x63, 0xa7,
	0x63, 0xae, 0x63, 0xb5, 0x63, 0xbc, 0x63, 0xdc,
	0x63, 0xe3, 0x63, 0xea, 0x63, 0x11, 0x64, 0x6e,
	0x64, 0x75, 0x64, 0x79, 0x64, 0x80, 0x64, 0xc4,
	0x64, 0x07, 0x65, 0x19, 0x65, 0x41, 0x65, 0x5b,
	0x65, 0x92, 0x65, 0xc3, 0x65, 0x35, 0x66, 0x3c,
	0x66, 0x63, 0x66, 0x6a, 0x66, 0x71, 0x66, 0x78,
	0x66, 0x7c, 0x66, 0xa9, 0x66, 0xb5, 0x66, 0xe2,
	0x66, 0x0f, 0x67, 0x16, 0x67, 0x1d, 0x67, 0x72,
	0x67, 0x8c, 0x67, 0xa6, 0x67, 0xfa, 0x67, 0xfe,
	0x67, 0x05, 0x68, 0x7a, 0x68, 0x11, 0x69, 0x18,
	0x69, 0x54, 0x69, 0x5b, 0x69, 0x62, 0x69, 0xb8,
	0x69, 0x1b, 0x6a, 0x73, 0x6a, 0xcb, 0x6a, 0x2e,
	0x6b, 0xa6, 0x6b, 0xad, 0x6b, 0xda, 0x6b, 0xe1,
	0x6b, 0x1c, 0x6c, 0x20, 0x6c, 0x24, 0x6c, 0x2b,
	0x6c, 0x45, 0x6c, 0x7c, 0x6c, 0x83, 0x6c, 0x9d,
	0x6c, 0xc4, 0x6c, 0x20, 0x6f, 0x32, 0x6f, 0x4d,
	0x6f, 0x75, 0x6f, 0x96, 0x70, 0xbb, 0x70, 0xc8,
	0x70, 0xef, 0x70, 0xf9, 0x70, 0x2c, 0x71, 0xae,
	0x71, 0xeb, 0x71, 0x18, 0x72, 0x1c, 0x72, 0x44,
	0x72, 0x4e, 0x72, 0x55, 0x72, 0x91, 0x72, 0xbe,
	0x72, 0xc2, 0x72, 0x05, 0x73, 0x09, 0x73, 0x28,
	0x73, 0x2f, 0x73, 0x36, 0x73, 0x81, 0x73, 0x9c,
	0x73, 0xa3, 0x73, 0x01, 0x74, 0x08, 0x74, 0x6f,
	0x74, 0x76, 0x74, 0xb3, 0x74, 0xcd, 0x74, 0xd1,
	0x74, 0xf9, 0x74, 0x13, 0x75, 0xd5, 0x77, 0x02,
	0x78, 0x00, 0x00, 0x3d, 0x78, 0x4a, 0x78, 0x51,
	0x78, 0x58, 0x78, 0x5f, 0x78, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xfa, 0x98,
	0x04, 0x10, 0x99, 0x29, 0x21, 0x99, 0x25, 0xca,
	0x9a, 0xff, 0x66, 0x9c, 0x33, 0x6d, 0x9c, 0x48,
	0x79, 0x9c, 0xde, 0xbb, 0xdf, 0xbb, 0xfb, 0xbb,
	0x29, 0xbc, 0x33, 0xbc, 0x34, 0xbc, 0x3e, 0xbc,
	0x5a, 0xbc, 0x76, 0xbc, 0x77, 0xbc, 0x8a, 0xbc,
	0x94, 0xbc, 0xb9, 0xbc, 0xcc, 0xbc, 0xd6, 0xbc,
	0x04, 0xbd, 0x05, 0xbd, 0x06, 0xbd, 0x19, 0xbd,
	0x2c, 0xbd, 0x36, 0xbd, 0x49, 0xbd, 0x4a, 0xbd,
	0x8a, 0xbd, 0x8b, 0xbd, 0xb9, 0xbd, 0xc3, 0xbd,
	0xe8, 0xbd, 0xe9, 0xbd, 0xea, 0xbd, 0xeb, 0xbd,
	0xf5, 0xbd, 0x1a, 0xbe, 0x51, 0xbe, 0x76, 0xbe,
	0xa4, 0xbe, 0xa5, 0xbe, 0xa6, 0xbe, 0xb0, 0xbe,
	0xb1, 0xbe, 0xb2, 0xbe, 0xb3, 0xbe, 0x00, 0x00,
	0x00, 0x00, 0x4f, 0x04, 0x02, 0x00, 0x01, 0x5f,
	0x00, 0x26, 0x7b, 0x51, 0x03, 0x01, 0x10, 0x01,
	0x64, 0x00, 0x89, 0x7b, 0x4f, 0x03, 0x02, 0x19,
	0x01, 0x5f, 0x00, 0xf6, 0x7b, 0x00, 0x5b, 0x04,
	0x01, 0xd1, 0x00, 0x9a, 0x00, 0xfd, 0x7b, 0x5b,
	0x01, 0x04, 0xf0, 0x00, 0xa3, 0x00, 0xc9, 0x7c,
	0x57, 0x01, 0x04, 0xf0, 0x00, 0xa3, 0x00, 0xd0,
	0x7c, 0x57, 0x04, 0x04, 0xd1, 0x00, 0x9a, 0x00,
	0xd7, 0x7c, 0x55, 0x05, 0x01, 0x73, 0x00, 0xc2,
	0x00, 0xde, 0x7c, 0x00, 0x50, 0x02, 0x04, 0xc7,
	0x00, 0xb3, 0x00, 0xe5, 0x7c, 0x00, 0x00, 0x4d,
	0x07, 0x02, 0x23, 0x01, 0xb9, 0x00, 0x1a, 0x7d,
	0x00, 0x4e, 0x01, 0x02, 0x52, 0x00, 0xb8, 0x00,
	0x02, 0x7e, 0x53, 0x01, 0x02, 0x49, 0x00, 0xbc,
	0x00, 0x4f, 0x7e, 0x59, 0x07, 0x01, 0xce, 0x00,
	0xc2, 0x00, 0x23, 0x7f, 0x00, 0x5c, 0x05, 0x04,
	0x6e, 0x00, 0x98, 0x00, 0xbd, 0x7f, 0x56, 0x01,
	0x01, 0xc0, 0x00, 0x98, 0x00, 0x47, 0x80, 0x5a,
	0x06, 0x02, 0x04, 0x01, 0xc2, 0x00, 0x84, 0x80,
	0x00, 0x00, 0x4b, 0x02, 0x01, 0x7a, 0x00, 0x97,
	0x00, 0x8b, 0x80, 0x52, 0x02, 0x01, 0x8b, 0x00,
	0x9c, 0x00, 0xc3, 0x80, 0x00, 0x32, 0x01, 0x02,
	0xbd, 0x00, 0x9f, 0x00, 0x17, 0x81, 0x00, 0x0e,
	0x03, 0x02, 0xcb, 0x00, 0xab, 0x00, 0x74, 0x81,
	0x22, 0x02, 0x02, 0x94, 0x00, 0xbd, 0x00, 0xc2,
	0x81, 0x2b, 0x06, 0x01, 0x5a, 0x00, 0xbc, 0x00,
	0x3d, 0x82, 0x0d, 0x03, 0x02, 0xcb, 0x00, 0xab,
	0x00, 0x0b, 0x83, 0x00, 0x1b, 0x06, 0x04, 0x67,
	0x00, 0xc0, 0x00, 0x12, 0x83, 0x2b, 0x04, 0x01,
	0xc5, 0x00, 0xb7, 0x00, 0x98, 0x83, 0x00, 0x20,
	0x01, 0x02, 0x6e, 0x00, 0xb9, 0x00, 0x9f, 0x83,
	0x00, 0x09, 0x03, 0x02, 0x2c, 0x00, 0xa8, 0x00,
	0xc7, 0x84, 0x2c, 0x04, 0x03, 0xec, 0x00, 0xb3,
	0x00, 0x38, 0x85, 0x08, 0x03, 0x02, 0x2c, 0x00,
	0xa8, 0x00, 0xd6, 0x85, 0x0f, 0x03, 0x02, 0x2c,
	0x00, 0xa8, 0x00, 0xdd, 0x85, 0x2e, 0x04, 0x03,
	0xec, 0x00, 0xb3, 0x00, 0xe4, 0x85, 0x00, 0x00,
	0x00, 0x19, 0x07, 0x04, 0xa2, 0x00, 0xc2, 0x00,
	0xeb, 0x85, 0x15, 0x07, 0x04, 0xa2, 0x00, 0xc2,
	0x00, 0x2c, 0x86, 0x00, 0x13, 0x05, 0x01, 0x8b,
	0x00, 0xa5, 0x00, 0x3d, 0x86, 0x0c, 0x09, 0x02,
	0x0e, 0x01, 0xb6, 0x00, 0x65, 0x86, 0x00, 0x05,
	0x03, 0x04, 0x57, 0x00, 0xb9, 0x00, 0xa9, 0x86,
	0x00, 0x07, 0x04, 0x04, 0x30, 0x00, 0xbe, 0x00,
	0x82, 0x8b, 0x24, 0x0a, 0x02, 0xcf, 0x00, 0xc2,
	0x00, 0xfc, 0x8b, 0x00, 0x00, 0x0a, 0x01, 0x04,
	0x3d, 0x00, 0xbb, 0x00, 0xc9, 0x88, 0x0b, 0x01,
	0x04, 0x3d, 0x00, 0xbb, 0x00, 0x18, 0x89, 0x0a,
	0x02, 0x04, 0x02, 0x01, 0xb5, 0x00, 0x2d, 0x89,
	0x0b, 0x02, 0x04, 0x02, 0x01, 0xb5, 0x00, 0xb7,
	0x89, 0x17, 0x02, 0x04, 0x02, 0x01, 0xb5, 0x00,
	0xcc, 0x89, 0x1a, 0x09, 0x03, 0x9e, 0x00, 0xc6,
	0x00, 0x22, 0x8a, 0x33, 0x02, 0x04, 0x02, 0x01,
	0xb5, 0x00, 0x6f, 0x8a, 0x00, 0x00, 0x23, 0x05,
	0x04, 0x0c, 0x01, 0x91, 0x00, 0x6e, 0x8c, 0x2e,
	0x02, 0x04, 0xcd, 0x00, 0x99, 0x00, 0xc8, 0x8c,
	0x2c, 0x02, 0x04, 0xea, 0x00, 0x98, 0x00, 0x42,
	0x8d, 0x0d, 0x02, 0x04, 0xea, 0x00, 0x98, 0x00,
	0x49, 0x8d, 0x0e, 0x02, 0x04, 0xea, 0x00, 0x98,
	0x00, 0x50, 0x8d, 0x00, 0x30, 0x05, 0x01, 0x9f,
	0x00, 0xa6, 0x00, 0x57, 0x8d, 0x00, 0x02, 0x02,
	0x01, 0xe6, 0x00, 0xa4, 0x00, 0x1d, 0x8f, 0x02,
	0x03, 0x01, 0xe6, 0x00, 0xa4, 0x00, 0x1d, 0x8f,
	0x2d, 0x04, 0x04, 0xec, 0x00, 0x8e, 0x00, 0xc8,
	0x8f, 0x2f, 0x0c, 0x04, 0xec, 0x00, 0x8e, 0x00,
	0x54, 0x90, 0x00, 0x00, 0x00, 0x00, 0x49, 0x02,
	0x02, 0x2c, 0x01, 0xb2, 0x00, 0xbc, 0x90, 0x00,
	0x34, 0x01, 0x01, 0x3d, 0x00, 0xaf, 0x00, 0xf5,
	0x90, 0x43, 0x01, 0x01, 0x3d, 0x00, 0xaf, 0x00,
	0xfc, 0x90, 0x47, 0x01, 0x01, 0x3d, 0x00, 0xaf,
	0x00, 0xcb, 0x91, 0x3d, 0x01, 0x01, 0x3d, 0x00,
	0xaf, 0x00, 0x09, 0x92, 0x00, 0x38, 0x08, 0x01,
	0xdd, 0x00, 0xa0, 0x00, 0x47, 0x92, 0x40, 0x08,
	0x01, 0xdd, 0x00, 0xa0, 0x00, 0x4e, 0x92, 0x3f,
	0x06, 0x01, 0x8d, 0x00, 0x9f, 0x00, 0x3d, 0x93,
	0x37, 0x03, 0x04, 0x3f, 0x00, 0xa8, 0x00, 0xaf,
	0x93, 0x44, 0x0c, 0x01, 0xc0, 0x00, 0xa0, 0x00,
	0xd5, 0x93, 0x45, 0x02, 0x04, 0x51, 0x00, 0xa0,
	0x00, 0x49, 0x94, 0x00, 0x3c, 0x02, 0x02, 0x14,
	0x01, 0x9f, 0x00, 0x72, 0x94, 0x3e, 0x02, 0x02,
	0x14, 0x01, 0x9f, 0x00, 0x9b, 0x94, 0x3a, 0x07,
	0x04, 0x44, 0x00, 0x81, 0x00, 0xd4, 0x94, 0x3b,
	0x02, 0x02, 0x14, 0x01, 0x9f, 0x00, 0x1b, 0x95,
	0x00, 0x39, 0x05, 0x01, 0x91, 0x00, 0xc5, 0x00,
	0x37, 0x95, 0x36, 0x05, 0x01, 0x81, 0x00, 0xad,
	0x00, 0xc8, 0x95, 0x35, 0x04, 0x01, 0x74, 0x00,
	0xbf, 0x00, 0xeb, 0x95, 0x43, 0x04, 0x01, 0x74,
	0x00, 0xbf, 0x00, 0x2f, 0x96, 0x34, 0x04, 0x01,
	0x74, 0x00, 0xbf, 0x00, 0x6c, 0x96, 0x00, 0x00,
	0x00, 0x4a, 0x01, 0x01, 0x3b, 0x00, 0xa3, 0x00,
	0x73, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57,
	0x6f, 0x77, 0x2c, 0x20, 0x6e, 0x6f, 0x77, 0x20,
	0x69, 0x74, 0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x73,
	0x20, 0x6c, 0x69, 0x6b, 0x65, 0x20, 0x69, 0x74,
	0x20, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x00, 0x66,
	0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x21, 0x00, 0x00,
	0x54, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x72, 0x69, 0x62, 0x62, 0x6f, 0x6e,
	0x20, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x72, 0x61, 0x6b, 0x65,
	0x20, 0x6e, 0x61, 0x72, 0x72, 0x6f, 0x77, 0x65,
	0x64, 0x00, 0x74, 0x68, 0x65, 0x20, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x20, 0x62, 0x65, 0x74, 0x77,
	0x65, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x74, 0x65, 0x65, 0x74, 0x68, 0x21, 0x00, 0x00,
	0x57, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x68, 0x65, 0x6c, 0x70, 0x20, 0x6f, 0x66,
	0x20, 0x73, 0x75, 0x70, 0x65, 0x72, 0x20, 0x67,
	0x6c, 0x75, 0x65, 0x20, 0x49, 0x20, 0x6d, 0x61,
	0x64, 0x65, 0x2e, 0x2e, 0x2e, 0x00, 0x73, 0x6f,
	0x6d, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x2e,
	0x2e, 0x2e, 0x00, 0x00, 0x55, 0x73, 0x69, 0x6e,
	0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x75,
	0x70, 0x65, 0x72, 0x20, 0x67, 0x6c, 0x75, 0x65,
	0x20, 0x6f, 0x6e, 0x63, 0x65, 0x20, 0x61, 0x67,
	0x61, 0x69, 0x6e, 0x2e, 0x2e, 0x2e, 0x00, 0x00,
	0x54, 0x68, 0x65, 0x20, 0x77, 0x68, 0x69, 0x73,
	0x6b, 0x79, 0x20, 0x69, 0x73, 0x20, 0x73, 0x74,
	0x72, 0x6f, 0x6e, 0x67, 0x20, 0x65, 0x6e, 0x6f,
	0x75, 0x67, 0x68, 0x20, 0x74, 0x6f, 0x20, 0x75,
	0x73, 0x65, 0x20, 0x61, 0x73, 0x00, 0x66, 0x75,
	0x65, 0x6c, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20,
	0x49, 0x20, 0x77, 0x6f, 0x6e, 0x64, 0x65, 0x72,
	0x20, 0x69, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x63, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x61, 0x77,
	0x00, 0x63, 0x61, 0x6e, 0x20, 0x74, 0x61, 0x6b,
	0x65, 0x20, 0x69, 0x74, 0x2e, 0x2e, 0x2e, 0x00,
	0x00, 0x4f, 0x6e, 0x63, 0x65, 0x20, 0x61, 0x67,
	0x61, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x73, 0x75, 0x70, 0x65, 0x72, 0x2d, 0x67, 0x6c,
	0x75, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x65, 0x73,
	0x20, 0x69, 0x6e, 0x20, 0x68, 0x61, 0x6e, 0x64,
	0x79, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x54, 0x68,
	0x65, 0x20, 0x73, 0x6f, 0x6f, 0x74, 0x20, 0x67,
	0x69, 0x76, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x70, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x65,
	0x20, 0x61, 0x20, 0x62, 0x72, 0x61, 0x6e, 0x64,
	0x20, 0x6e, 0x65, 0x77, 0x20, 0x6c, 0x6f, 0x6f,
	0x6b, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x4e, 0x6f,
	0x77, 0x20, 0x49, 0x27, 0x6d, 0x20, 0x72, 0x65,
	0x61, 0x64, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x63,
	0x6f, 0x6e, 0x71, 0x75, 0x65, 0x72, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6c, 0x61, 0x6b, 0x65, 0x21,
	0x00, 0x00, 0x49, 0x74, 0x20, 0x6d, 0x61, 0x6b,
	0x65, 0x73, 0x20, 0x6d, 0x65, 0x20, 0x66, 0x65,
	0x65, 0x6c, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x20,
	0x61, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x00,
	0x77, 0x61, 0x6e, 0x6e, 0x61, 0x2d, 0x62, 0x65,
	0x20, 0x63, 0x6c, 0x69, 0x66, 0x66, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x72, 0x2e, 0x00, 0x00, 0x49,
	0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x6e, 0x27,
	0x74, 0x20, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x20, 0x61, 0x6e, 0x79, 0x6f, 0x6e, 0x65,
	0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x73, 0x75,
	0x63, 0x68, 0x20, 0x63, 0x61, 0x6e, 0x64, 0x79,
	0x2e, 0x00, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x20, 0x65,
	0x6e, 0x6f, 0x75, 0x67, 0x68, 0x2e, 0x00, 0x00,
	0x47, 0x72, 0x65, 0x61, 0x74, 0x20, 0x69, 0x64,
	0x65, 0x61, 0x21, 0x20, 0x42, 0x75, 0x74, 0x2c,
	0x20, 0x79, 0x6f, 0x75, 0x20, 0x73, 0x65, 0x65,
	0x2c, 0x20, 0x65, 0x63, 0x6f, 0x6d, 0x61, 0x6e,
	0x69, 0x61, 0x63, 0x73, 0x20, 0x6d, 0x69, 0x67,
	0x68, 0x74, 0x00, 0x62, 0x65, 0x20, 0x77, 0x61,
	0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x2e, 0x2e,
	0x2e, 0x00, 0x00, 0x49, 0x74, 0x20, 0x77, 0x6f,
	0x6e, 0x27, 0x74, 0x20, 0x6c, 0x6f, 0x6f, 0x6b,
	0x20, 0x61, 0x6e, 0x79, 0x20, 0x62, 0x65, 0x74,
	0x74, 0x65, 0x72, 0x20, 0x69, 0x6e, 0x20, 0x61,
	0x20, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x2e, 0x00, 0x00, 0x54, 0x68, 0x65, 0x20, 0x63,
	0x61, 0x6b, 0x65, 0x20, 0x69, 0x73, 0x20, 0x74,
	0x6f, 0x6f, 0x20, 0x62, 0x69, 0x67, 0x20, 0x66,
	0x6f, 0x72, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x2e,
	0x00, 0x00, 0x49, 0x20, 0x64, 0x6f, 0x6e, 0x27,
	0x74, 0x20, 0x77, 0x61, 0x6e, 0x74, 0x20, 0x74,
	0x6f, 0x20, 0x77, 0x61, 0x73, 0x74, 0x65, 0x20,
	0x74, 0x68, 0x69, 0x73, 0x20, 0x63, 0x61, 0x6e,
	0x64, 0x79, 0x2e, 0x00, 0x00, 0x54, 0x68, 0x65,
	0x20, 0x66, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x20,
	0x69, 0x73, 0x20, 0x62, 0x65, 0x61, 0x75, 0x74,
	0x69, 0x66, 0x75, 0x6c, 0x20, 0x65, 0x6e, 0x6f,
	0x75, 0x67, 0x68, 0x20, 0x77, 0x69, 0x74, 0x68,
	0x6f, 0x75, 0x74, 0x00, 0x61, 0x6e, 0x79, 0x20,
	0x66, 0x61, 0x6e, 0x63, 0x79, 0x20, 0x65, 0x78,
	0x74, 0x72, 0x61, 0x73, 0x2e, 0x00, 0x00, 0x47,
	0x6f, 0x6f, 0x64, 0x20, 0x69, 0x64, 0x65, 0x61,
	0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x49, 0x20,
	0x6e, 0x65, 0x65, 0x64, 0x20, 0x73, 0x6f, 0x6d,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20, 0x73,
	0x6d, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x00, 0x74,
	0x68, 0x61, 0x6e, 0x20, 0x74, 0x68, 0x69, 0x73,
	0x20, 0x72, 0x6f, 0x70, 0x65, 0x2e, 0x00, 0x00,
	0x49, 0x20, 0x6d, 0x69, 0x67, 0x68, 0x74, 0x20,
	0x6e, 0x65, 0x65, 0x64, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x63, 0x68, 0x65, 0x65, 0x73, 0x65,
	0x2e, 0x20, 0x41, 0x67, 0x61, 0x69, 0x6e, 0x2e,
	0x00, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x6e,
	0x6f, 0x74, 0x20, 0x44, 0x4f, 0x4f, 0x4d, 0x2e,
	0x20, 0x49, 0x74, 0x27, 0x73, 0x20, 0x61, 0x20,
	0x68, 0x61, 0x72, 0x6d, 0x6c, 0x65, 0x73, 0x73,
	0x20, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63,
	0x20, 0x61, 0x64, 0x76, 0x65, 0x6e, 0x74, 0x75,
	0x72, 0x65, 0x00, 0x66, 0x6f, 0x72, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x77, 0x68, 0x6f, 0x6c, 0x65,
	0x20, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x20,
	0x28, 0x77, 0x65, 0x20, 0x77, 0x61, 0x6e, 0x74,
	0x20, 0x44, 0x4f, 0x4f, 0x4d, 0x21, 0x20, 0x77,
	0x65, 0x20, 0x77, 0x61, 0x6e, 0x74, 0x00, 0x44,
	0x4f, 0x4f, 0x4d, 0x21, 0x29, 0x2e, 0x00, 0x00,
	0x49, 0x20, 0x64, 0x6f, 0x6e, 0x27, 0x74, 0x20,
	0x6e, 0x65, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
	0x6f, 0x70, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x69,
	0x73, 0x20, 0x6e, 0x75, 0x74, 0x2e, 0x00, 0x00,
	0x4c, 0x65, 0x74, 0x27, 0x73, 0x20, 0x6d, 0x61,
	0x6b, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x63, 0x6f, 0x72, 0x6b, 0x20, 0x6c, 0x61, 0x72,
	0x67, 0x65, 0x72, 0x2e, 0x00, 0x00, 0x4f, 0x6e,
	0x63, 0x65, 0x20, 0x61, 0x67, 0x61, 0x69, 0x6e,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x75, 0x70,
	0x65, 0x72, 0x20, 0x67, 0x6c, 0x75, 0x65, 0x20,
	0x63, 0x6f, 0x6d, 0x65, 0x73, 0x20, 0x69, 0x6e,
	0x20, 0x68, 0x61, 0x6e, 0x64, 0x79, 0x2e, 0x00,
	0x00, 0x54, 0x68, 0x65, 0x20, 0x62, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x69, 0x65, 0x73, 0x20, 0x66,
	0x69, 0x74, 0x21, 0x00, 0x00, 0x49, 0x20, 0x74,
	0x69, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x72, 0x6f, 0x70, 0x65, 0x20, 0x74, 0x6f, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x70, 0x69, 0x6e, 0x2e,
	0x00, 0x00, 0x4c, 0x65, 0x74, 0x27, 0x73, 0x20,
	0x6d, 0x61, 0x6b, 0x65, 0x20, 0x69, 0x74, 0x20,
	0x73, 0x70, 0x69, 0x63, 0x79, 0x2e, 0x00, 0x00,
	0x12, 0x16, 0x17, 0xb4, 0xbe, 0x15, 0x18, 0x19,
	0xed, 0xbe, 0x01, 0x1c, 0x1f, 0x35, 0xbf, 0x11,
	0x1c, 0x1e, 0x35, 0xbf, 0x1f, 0x11, 0x20, 0x69,
	0xbf, 0x1e, 0x01, 0x20, 0x69, 0xbf, 0x0d, 0x10,
	0x0e, 0x8d, 0xbf, 0x08, 0x0f, 0x09, 0xe6, 0xbf,
	0x14, 0x21, 0x22, 0x13, 0xc0, 0x27, 0x28, 0x29,
	0x43, 0xc0, 0x26, 0x2a, 0x2b, 0x67, 0xc0, 0x12,
	0x13, 0x00, 0x9c, 0xc0, 0x01, 0x30, 0x00, 0xc8,
	0xc0, 0x10, 0x30, 0x00, 0xdd, 0xc0, 0x12, 0x14,
	0x00, 0x18, 0xc1, 0x12, 0x22, 0x00, 0x18, 0xc1,
	0x12, 0x1a, 0x00, 0x18, 0xc1, 0x12, 0x1c, 0x00,
	0x18, 0xc1, 0x12, 0x31, 0x00, 0x18, 0xc1, 0x12,
	0x13, 0x00, 0x40, 0xc1, 0x13, 0x30, 0x00, 0x67,
	0xc1, 0x18, 0x0a, 0x00, 0x8a, 0xc1, 0x18, 0x0b,
	0x00, 0x8a, 0xc1, 0x15, 0x26, 0x00, 0xc4, 0xc1,
	0x2d, 0x30, 0x00, 0xfd, 0xc1, 0x2c, 0x30, 0x00,
	0x1f, 0xc2, 0x2e, 0x30, 0x00, 0x1f, 0xc2, 0x31,
	0x1a, 0x00, 0x85, 0xc2, 0x31, 0x30, 0x00, 0x1f,
	0xc2, 0x37, 0x3b, 0x3c, 0xa5, 0xc2, 0x41, 0x38,
	0x40, 0xc3, 0xc2, 0x42, 0x34, 0x43, 0xee, 0xc2,
	0x54, 0x58, 0x59, 0x02, 0xc3, 0x57, 0x5a, 0x5b,
	0x1f, 0xc3, 0x00, 0x00, 0x00, 0x55, 0x73, 0x69,
	0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65,
	0x20, 0x74, 0x77, 0x6f, 0x20, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x20, 0x74, 0x6f, 0x67,
	0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x77, 0x6f,
	0x6e, 0x27, 0x74, 0x00, 0x61, 0x63, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x69, 0x73, 0x68, 0x20, 0x61,
	0x6e, 0x79, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x2e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x5e, 0xc5, 0x7b, 0xc5, 0x9a, 0xc5, 0xc3,
	0xc5, 0xcf, 0xc5, 0xfd, 0xc5, 0x2c, 0xc6, 0x3f,
	0xc6, 0x62, 0xc6, 0x93, 0xc6, 0xb9, 0xc6, 0xda,
	0xc6, 0x0a, 0xc7, 0x42, 0xc7, 0x75, 0xc7, 0x96,
	0xc7, 0xcb, 0xc7, 0xf4, 0xc7, 0x60, 0xc8, 0xa0,
	0xc8, 0xd3, 0xc8, 0x21, 0xc9, 0x65, 0xc9, 0xa2,
	0xc9, 0xf2, 0xc9, 0x09, 0xca, 0x22, 0xca, 0x6b,
	0xca, 0xe7, 0xca, 0x2d, 0xcb, 0x61, 0xcb, 0x96,
	0xcb, 0xba, 0xcb, 0xf2, 0xcb, 0x5d, 0xcc, 0x79,
	0xcc, 0xdd, 0xcc, 0x0f, 0xcd, 0x25, 0xcd, 0x54,
	0xcd, 0x95, 0xcd, 0xc8, 0xcd, 0xfe, 0xcd, 0x33,
	0xce, 0x75, 0xce, 0xa6, 0xce, 0xe3, 0xce, 0x4f,
	0xcf, 0x6a, 0xcf, 0x9d, 0xcf, 0xf8, 0xcf, 0x05,
	0xd0, 0x32, 0xd0, 0x5c, 0xd0, 0x7b, 0xd0, 0xb1,
	0xd0, 0xe7, 0xd0, 0x30, 0xd1, 0x4e, 0xd1, 0x73,
	0xd1, 0x9d, 0xd1, 0xf4, 0xd1, 0x41, 0xd2, 0x6f,
	0xd2, 0xa7, 0xd2, 0xcb, 0xd2, 0xf6, 0xd2, 0x46,
	0xd3, 0x8a, 0xd3, 0xb3, 0xd3, 0xfb, 0xd3, 0x16,
	0xd4, 0x49, 0xd4, 0x7b, 0xd4, 0xa4, 0xd4, 0xca,
	0xd4, 0xeb, 0xd4, 0x1f, 0xd5, 0x43, 0xd5, 0x7f,
	0xd5, 0xaa, 0xd5, 0xc6, 0xd5, 0x42, 0xd6, 0xb7,
	0xd6, 0x0a, 0xd7, 0x1d, 0xd7, 0x67, 0xd7, 0x92,
	0xd7, 0xae, 0xd7, 0xe6, 0xd7, 0x35, 0xd8, 0x5e,
	0xd8, 0x01, 0x00, 0x66, 0x65, 0x61, 0x74, 0x68,
	0x65, 0x72, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20,
	0x6b, 0x69, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x20,
	0x61, 0x73, 0x73, 0x21, 0x00, 0x00, 0x02, 0x00,
	0x73, 0x68, 0x6f, 0x74, 0x67, 0x75, 0x6e, 0x00,
	0x4c, 0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x69, 0x6d,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x76, 0x65,
	0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x03, 0x00, 0x74,
	0x6f, 0x6f, 0x6c, 0x62, 0x6f, 0x78, 0x00, 0x44,
	0x6f, 0x65, 0x73, 0x6e, 0x27, 0x74, 0x20, 0x73,
	0x65, 0x65, 0x6d, 0x20, 0x74, 0x6f, 0x20, 0x62,
	0x65, 0x20, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64,
	0x21, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x04, 0x00,
	0x74, 0x6f, 0x6f, 0x6c, 0x62, 0x6f, 0x78, 0x00,
	0x00, 0x00, 0x05, 0x00, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x00, 0x54, 0x68, 0x65, 0x73,
	0x65, 0x20, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
	0x20, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x20,
	0x63, 0x6f, 0x6d, 0x65, 0x20, 0x69, 0x6e, 0x20,
	0x68, 0x61, 0x6e, 0x64, 0x79, 0x2e, 0x00, 0x00,
	0x06, 0x00, 0x63, 0x6f, 0x6d, 0x62, 0x00, 0x49,
	0x27, 0x76, 0x65, 0x20, 0x68, 0x65, 0x61, 0x72,
	0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x73,
	0x6f, 0x6d, 0x65, 0x20, 0x70, 0x65, 0x6f, 0x70,
	0x6c, 0x65, 0x20, 0x75, 0x73, 0x65, 0x20, 0x74,
	0x68, 0x65, 0x73, 0x65, 0x2e, 0x00, 0x00, 0x07,
	0x01, 0x66, 0x61, 0x6e, 0x00, 0x52, 0x65, 0x66,
	0x72, 0x65, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x2e,
	0x00, 0x00, 0x08, 0x00, 0x62, 0x72, 0x6f, 0x6b,
	0x65, 0x6e, 0x20, 0x70, 0x61, 0x64, 0x64, 0x6c,
	0x65, 0x00, 0x54, 0x6f, 0x6f, 0x20, 0x73, 0x68,
	0x6f, 0x72, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x75,
	0x73, 0x65, 0x2e, 0x00, 0x00, 0x09, 0x00, 0x70,
	0x61, 0x64, 0x64, 0x6c, 0x65, 0x00, 0x54, 0x68,
	0x65, 0x20, 0x67, 0x6c, 0x75, 0x65, 0x20, 0x6b,
	0x65, 0x65, 0x70, 0x73, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x00,
	0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x68,
	0x61, 0x72, 0x64, 0x2e, 0x00, 0x00, 0x0a, 0x00,
	0x66, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x00, 0x49,
	0x74, 0x20, 0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79,
	0x20, 0x73, 0x6d, 0x65, 0x6c, 0x6c, 0x73, 0x00,
	0x76, 0x65, 0x72, 0x79, 0x20, 0x6e, 0x69, 0x63,
	0x65, 0x2e, 0x00, 0x00, 0x0b, 0x00, 0x66, 0x6c,
	0x6f, 0x77, 0x65, 0x72, 0x00, 0x49, 0x74, 0x27,
	0x73, 0x20, 0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79,
	0x20, 0x62, 0x65, 0x61, 0x75, 0x74, 0x69, 0x66,
	0x75, 0x6c, 0x2e, 0x00, 0x00, 0x0c, 0x00, 0x66,
	0x65, 0x61, 0x74, 0x68, 0x65, 0x72, 0x20, 0x64,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x00, 0x49, 0x20,
	0x63, 0x61, 0x6e, 0x20, 0x70, 0x6c, 0x61, 0x79,
	0x20, 0x6a, 0x61, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x2e, 0x00, 0x00, 0x0d, 0x00, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x73, 0x61, 0x77, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x69, 0x6e, 0x20,
	0x67, 0x6f, 0x6f, 0x64, 0x20, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20,
	0x62, 0x75, 0x74, 0x20, 0x69, 0x74, 0x20, 0x68,
	0x61, 0x73, 0x20, 0x6e, 0x6f, 0x20, 0x66, 0x75,
	0x65, 0x6c, 0x2e, 0x00, 0x00, 0x0e, 0x01, 0x64,
	0x72, 0x75, 0x6e, 0x6b, 0x65, 0x6e, 0x20, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x73, 0x61, 0x77, 0x00,
	0x41, 0x20, 0x62, 0x69, 0x74, 0x20, 0x75, 0x6e,
	0x73, 0x74, 0x65, 0x61, 0x64, 0x79, 0x2c, 0x20,
	0x62, 0x75, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x6c,
	0x20, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x00, 0x00,
	0x0f, 0x00, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68,
	0x00, 0x54, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x6f,
	0x64, 0x20, 0x69, 0x73, 0x20, 0x76, 0x65, 0x72,
	0x79, 0x20, 0x68, 0x61, 0x72, 0x64, 0x2e, 0x00,
	0x00, 0x10, 0x00, 0x77, 0x68, 0x69, 0x73, 0x6b,
	0x79, 0x00, 0x54, 0x68, 0x65, 0x20, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x20, 0x73, 0x61, 0x79, 0x73,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x77, 0x68,
	0x69, 0x73, 0x6b, 0x79, 0x20, 0x69, 0x73, 0x00,
	0x76, 0x65, 0x72, 0x79, 0x20, 0x73, 0x74, 0x72,
	0x6f, 0x6e, 0x67, 0x2e, 0x00, 0x00, 0x11, 0x00,
	0x6e, 0x65, 0x65, 0x64, 0x6c, 0x65, 0x00, 0x49,
	0x74, 0x27, 0x73, 0x20, 0x71, 0x75, 0x69, 0x74,
	0x65, 0x20, 0x62, 0x69, 0x67, 0x20, 0x66, 0x6f,
	0x72, 0x20, 0x61, 0x20, 0x6e, 0x65, 0x65, 0x64,
	0x6c, 0x65, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x12,
	0x00, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x00, 0x4e, 0x69, 0x63, 0x65, 0x20, 0x64, 0x65,
	0x73, 0x69, 0x67, 0x6e, 0x2e, 0x20, 0x45, 0x73,
	0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x6c, 0x79,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x27, 0x4c,
	0x4f, 0x56, 0x45, 0x20, 0x43, 0x41, 0x4e, 0x44,
	0x59, 0x27, 0x20, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x2e, 0x00, 0x41, 0x6e, 0x64, 0x20, 0x74, 0x68,
	0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x61, 0x20,
	0x68, 0x65, 0x61, 0x72, 0x74, 0x20, 0x70, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x64, 0x20, 0x6f, 0x6e,
	0x20, 0x69, 0x74, 0x2e, 0x00, 0x48, 0x6f, 0x77,
	0x20, 0x53, 0x57, 0x45, 0x45, 0x54, 0x2e, 0x2e,
	0x2e, 0x00, 0x00, 0x13, 0x00, 0x63, 0x68, 0x6f,
	0x63, 0x6f, 0x6c, 0x61, 0x74, 0x65, 0x20, 0x63,
	0x61, 0x6e, 0x64, 0x79, 0x00, 0x49, 0x74, 0x27,
	0x73, 0x20, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20,
	0x63, 0x68, 0x6f, 0x63, 0x6f, 0x6c, 0x61, 0x74,
	0x65, 0x20, 0x63, 0x61, 0x6e, 0x64, 0x79, 0x2e,
	0x00, 0x41, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74,
	0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
	0x2e, 0x00, 0x00, 0x14, 0x00, 0x77, 0x69, 0x6c,
	0x64, 0x20, 0x70, 0x6f, 0x74, 0x61, 0x74, 0x6f,
	0x65, 0x00, 0x57, 0x6f, 0x77, 0x21, 0x20, 0x49,
	0x74, 0x27, 0x73, 0x20, 0x73, 0x68, 0x61, 0x70,
	0x65, 0x64, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x20,
	0x61, 0x20, 0x67, 0x72, 0x65, 0x6e, 0x61, 0x64,
	0x65, 0x21, 0x2e, 0x2e, 0x00, 0x00, 0x15, 0x00,
	0x72, 0x61, 0x6b, 0x65, 0x00, 0x54, 0x68, 0x65,
	0x20, 0x73, 0x70, 0x61, 0x63, 0x65, 0x20, 0x62,
	0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x74, 0x65, 0x65, 0x74, 0x68,
	0x20, 0x69, 0x73, 0x20, 0x74, 0x6f, 0x6f, 0x20,
	0x6c, 0x61, 0x72, 0x67, 0x65, 0x00, 0x74, 0x6f,
	0x20, 0x6d, 0x61, 0x6b, 0x65, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x72, 0x61, 0x6b, 0x65, 0x20,
	0x61, 0x6e, 0x20, 0x75, 0x73, 0x65, 0x66, 0x75,
	0x6c, 0x2e, 0x00, 0x00, 0x16, 0x00, 0x68, 0x65,
	0x61, 0x72, 0x74, 0x2d, 0x73, 0x68, 0x61, 0x70,
	0x65, 0x64, 0x20, 0x63, 0x61, 0x6e, 0x64, 0x79,
	0x00, 0x49, 0x20, 0x64, 0x6f, 0x6e, 0x27, 0x74,
	0x20, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20,
	0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x20, 0x69, 0x73, 0x20, 0x65,
	0x6e, 0x6f, 0x75, 0x67, 0x68, 0x2e, 0x00, 0x00,
	0x17, 0x00, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x64, 0x20, 0x63, 0x61, 0x6e, 0x64, 0x79, 0x00,
	0x42, 0x72, 0x61, 0x6e, 0x64, 0x20, 0x6e, 0x65,
	0x77, 0x20, 0x63, 0x61, 0x6e, 0x64, 0x79, 0x2e,
	0x20, 0x41, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x73,
	0x74, 0x20, 0x69, 0x74, 0x20, 0x6c, 0x6f, 0x6f,
	0x6b, 0x73, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x20,
	0x69, 0x74, 0x2e, 0x00, 0x00, 0x18, 0x00, 0x72,
	0x69, 0x62, 0x62, 0x6f, 0x6e, 0x00, 0x49, 0x74,
	0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x72, 0x65,
	0x6d, 0x69, 0x6e, 0x64, 0x20, 0x6d, 0x65, 0x20,
	0x6f, 0x66, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
	0x62, 0x65, 0x61, 0x74, 0x69, 0x66, 0x75, 0x6c,
	0x20, 0x63, 0x68, 0x69, 0x63, 0x6b, 0x2c, 0x00,
	0x49, 0x20, 0x6d, 0x65, 0x61, 0x6e, 0x2c, 0x20,
	0x66, 0x65, 0x6d, 0x61, 0x6c, 0x65, 0x20, 0x68,
	0x75, 0x6d, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x69,
	0x6e, 0x67, 0x2e, 0x00, 0x00, 0x19, 0x00, 0x72,
	0x61, 0x6b, 0x65, 0x00, 0x52, 0x65, 0x61, 0x64,
	0x79, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x6f, 0x72,
	0x6b, 0x2e, 0x00, 0x00, 0x1a, 0x00, 0x6e, 0x75,
	0x74, 0x00, 0x41, 0x20, 0x72, 0x65, 0x61, 0x6c,
	0x6c, 0x79, 0x20, 0x62, 0x69, 0x67, 0x20, 0x6f,
	0x6e, 0x65, 0x2e, 0x00, 0x00, 0x1b, 0x00, 0x70,
	0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x20, 0x61,
	0x70, 0x70, 0x6c, 0x65, 0x00, 0x49, 0x74, 0x20,
	0x6c, 0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x73, 0x6f,
	0x20, 0x72, 0x65, 0x61, 0x6c, 0x20, 0x74, 0x68,
	0x61, 0x74, 0x20, 0x49, 0x20, 0x63, 0x6f, 0x75,
	0x6c, 0x64, 0x00, 0x65, 0x76, 0x65, 0x6e, 0x20,
	0x73, 0x65, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x70, 0x69, 0x70, 0x73, 0x20, 0x69, 0x6e, 0x73,
	0x69, 0x64, 0x65, 0x2e, 0x00, 0x00, 0x1c, 0x00,
	0x63, 0x6f, 0x6e, 0x65, 0x00, 0x49, 0x74, 0x20,
	0x6c, 0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x6c, 0x69,
	0x6b, 0x65, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f,
	0x66, 0x20, 0x74, 0x68, 0x6f, 0x73, 0x65, 0x20,
	0x48, 0x61, 0x76, 0x61, 0x6e, 0x61, 0x20, 0x67,
	0x6f, 0x6f, 0x64, 0x69, 0x65, 0x73, 0x20, 0x65,
	0x76, 0x65, 0x72, 0x79, 0x00, 0x73, 0x65, 0x6c,
	0x66, 0x2d, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x69, 0x6e, 0x67, 0x20, 0x62, 0x75, 0x73,
	0x69, 0x6e, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e,
	0x20, 0x69, 0x73, 0x20, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
	0x68, 0x61, 0x76, 0x65, 0x00, 0x67, 0x6c, 0x75,
	0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x68, 0x69,
	0x73, 0x20, 0x73, 0x6d, 0x69, 0x6c, 0x65, 0x2e,
	0x00, 0x00, 0x1d, 0x00, 0x73, 0x75, 0x70, 0x65,
	0x72, 0x20, 0x67, 0x6c, 0x75, 0x65, 0x00, 0x49,
	0x74, 0x27, 0x73, 0x20, 0x74, 0x75, 0x72, 0x62,
	0x6f, 0x20, 0x6d, 0x65, 0x67, 0x61, 0x20, 0x67,
	0x69, 0x67, 0x61, 0x20, 0x73, 0x75, 0x70, 0x65,
	0x72, 0x20, 0x75, 0x6c, 0x74, 0x72, 0x61, 0x00,
	0x66, 0x61, 0x73, 0x74, 0x20, 0x64, 0x72, 0x79,
	0x69, 0x6e, 0x67, 0x20, 0x67, 0x6c, 0x75, 0x65,
	0x20, 0x70, 0x6c, 0x75, 0x73, 0x2e, 0x00, 0x00,
	0x1e, 0x00, 0x63, 0x6f, 0x6e, 0x65, 0x20, 0x26,
	0x20, 0x6e, 0x65, 0x65, 0x64, 0x6c, 0x65, 0x00,
	0x53, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x69, 0x6e,
	0x67, 0x20, 0x69, 0x73, 0x20, 0x73, 0x74, 0x69,
	0x6c, 0x6c, 0x20, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x20, 0x68, 0x65, 0x72, 0x65, 0x2e,
	0x2e, 0x2e, 0x00, 0x00, 0x1f, 0x00, 0x63, 0x6f,
	0x6e, 0x65, 0x20, 0x26, 0x20, 0x66, 0x65, 0x61,
	0x74, 0x68, 0x65, 0x72, 0x00, 0x53, 0x6f, 0x6d,
	0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20, 0x69,
	0x73, 0x20, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x20,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x20,
	0x68, 0x65, 0x72, 0x65, 0x2e, 0x2e, 0x2e, 0x00,
	0x00, 0x20, 0x00, 0x64, 0x61, 0x72, 0x74, 0x00,
	0x4e, 0x6f, 0x77, 0x20, 0x61, 0x6c, 0x6c, 0x20,
	0x49, 0x20, 0x6e, 0x65, 0x65, 0x64, 0x20, 0x69,
	0x73, 0x20, 0x61, 0x20, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x21, 0x00, 0x00, 0x21, 0x00, 0x64,
	0x69, 0x72, 0x74, 0x79, 0x20, 0x66, 0x65, 0x61,
	0x74, 0x68, 0x65, 0x72, 0x20, 0x64, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x00, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x63, 0x6c, 0x61, 0x6d, 0x6d, 0x79, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x73, 0x6f, 0x69, 0x6c,
	0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x73, 0x6f,
	0x6f, 0x74, 0x2e, 0x00, 0x00, 0x22, 0x00, 0x70,
	0x61, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x20, 0x70,
	0x6f, 0x74, 0x61, 0x74, 0x6f, 0x65, 0x00, 0x54,
	0x68, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20,
	0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65,
	0x65, 0x6e, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x61, 0x20, 0x67, 0x72,
	0x65, 0x6e, 0x61, 0x64, 0x65, 0x00, 0x69, 0x73,
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x70, 0x6f,
	0x74, 0x61, 0x74, 0x6f, 0x65, 0x65, 0x73, 0x20,
	0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x20,
	0x64, 0x6f, 0x6e, 0x27, 0x74, 0x20, 0x62, 0x6c,
	0x6f, 0x77, 0x20, 0x75, 0x70, 0x2e, 0x00, 0x00,
	0x23, 0x00, 0x63, 0x61, 0x72, 0x20, 0x6a, 0x61,
	0x63, 0x6b, 0x00, 0x4c, 0x6f, 0x6f, 0x6b, 0x73,
	0x20, 0x72, 0x65, 0x6c, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x00, 0x00, 0x24, 0x00, 0x64, 0x69,
	0x6e, 0x6f, 0x20, 0x62, 0x6f, 0x6e, 0x65, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x62, 0x69, 0x67,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x77, 0x65, 0x6c,
	0x6c, 0x20, 0x70, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x64, 0x2e, 0x20, 0x49, 0x74, 0x20,
	0x6d, 0x75, 0x73, 0x74, 0x20, 0x68, 0x61, 0x76,
	0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x00, 0x61,
	0x20, 0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79, 0x20,
	0x62, 0x69, 0x67, 0x2c, 0x20, 0x65, 0x72, 0x2e,
	0x2e, 0x2e, 0x2c, 0x20, 0x61, 0x6e, 0x69, 0x6d,
	0x61, 0x6c, 0x2c, 0x20, 0x49, 0x20, 0x74, 0x68,
	0x69, 0x6e, 0x6b, 0x2e, 0x2e, 0x2e, 0x00, 0x00,
	0x25, 0x00, 0x73, 0x68, 0x6f, 0x76, 0x65, 0x6c,
	0x00, 0x49, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x50,
	0x4c, 0x41, 0x59, 0x20, 0x44, 0x49, 0x47, 0x47,
	0x45, 0x52, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20,
	0x69, 0x74, 0x2e, 0x20, 0x53, 0x6f, 0x20, 0x74,
	0x6f, 0x20, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x2e,
	0x00, 0x00, 0x26, 0x00, 0x72, 0x6f, 0x70, 0x65,
	0x00, 0x4c, 0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x73,
	0x74, 0x72, 0x6f, 0x6e, 0x67, 0x2e, 0x00, 0x00,
	0x27, 0x00, 0x6d, 0x61, 0x73, 0x6b, 0x00, 0x49,
	0x74, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x68,
	0x65, 0x6c, 0x70, 0x20, 0x6d, 0x65, 0x20, 0x73,
	0x65, 0x65, 0x20, 0x62, 0x65, 0x74, 0x74, 0x65,
	0x72, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x77,
	0x61, 0x74, 0x65, 0x72, 0x2e, 0x00, 0x00, 0x28,
	0x00, 0x66, 0x69, 0x6e, 0x73, 0x00, 0x54, 0x68,
	0x65, 0x79, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20,
	0x68, 0x65, 0x6c, 0x70, 0x20, 0x6d, 0x65, 0x20,
	0x66, 0x65, 0x65, 0x6c, 0x20, 0x6d, 0x6f, 0x72,
	0x65, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x20, 0x6d,
	0x79, 0x00, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x77,
	0x61, 0x74, 0x65, 0x72, 0x20, 0x62, 0x72, 0x6f,
	0x74, 0x68, 0x65, 0x72, 0x73, 0x2e, 0x00, 0x00,
	0x29, 0x00, 0x64, 0x69, 0x76, 0x69, 0x6e, 0x67,
	0x20, 0x65, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65,
	0x6e, 0x74, 0x00, 0x57, 0x61, 0x74, 0x63, 0x68,
	0x20, 0x6f, 0x75, 0x74, 0x2c, 0x20, 0x77, 0x61,
	0x74, 0x65, 0x72, 0x21, 0x20, 0x48, 0x65, 0x72,
	0x65, 0x20, 0x49, 0x20, 0x63, 0x6f, 0x6d, 0x65,
	0x21, 0x00, 0x00, 0x2a, 0x00, 0x61, 0x6e, 0x63,
	0x68, 0x6f, 0x72, 0x00, 0x4e, 0x6f, 0x74, 0x20,
	0x62, 0x69, 0x67, 0x2c, 0x20, 0x62, 0x75, 0x74,
	0x20, 0x68, 0x65, 0x61, 0x76, 0x79, 0x20, 0x65,
	0x6e, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x6f,
	0x20, 0x73, 0x69, 0x6e, 0x6b, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x62, 0x6f, 0x61, 0x74, 0x2e, 0x00,
	0x00, 0x2b, 0x00, 0x67, 0x72, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x6e, 0x67, 0x20, 0x68, 0x6f, 0x6f,
	0x6b, 0x00, 0x57, 0x61, 0x74, 0x63, 0x68, 0x20,
	0x6f, 0x75, 0x74, 0x2c, 0x20, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x2c, 0x20,
	0x68, 0x65, 0x72, 0x65, 0x20, 0x49, 0x20, 0x63,
	0x6f, 0x6d, 0x65, 0x21, 0x00, 0x00, 0x2c, 0x00,
	0x73, 0x69, 0x63, 0x6b, 0x6c, 0x65, 0x00, 0x49,
	0x74, 0x27, 0x73, 0x20, 0x73, 0x6f, 0x20, 0x62,
	0x6c, 0x75, 0x6e, 0x74, 0x2c, 0x20, 0x74, 0x68,
	0x61, 0x74, 0x20, 0x49, 0x20, 0x63, 0x6f, 0x75,
	0x6c, 0x64, 0x6e, 0x27, 0x74, 0x20, 0x65, 0x76,
	0x65, 0x6e, 0x20, 0x63, 0x75, 0x74, 0x00, 0x62,
	0x75, 0x74, 0x74, 0x65, 0x72, 0x20, 0x77, 0x69,
	0x74, 0x68, 0x20, 0x69, 0x74, 0x2e, 0x00, 0x00,
	0x2d, 0x00, 0x73, 0x6f, 0x6d, 0x65, 0x77, 0x68,
	0x61, 0x74, 0x20, 0x72, 0x6f, 0x74, 0x74, 0x65,
	0x6e, 0x20, 0x63, 0x68, 0x65, 0x65, 0x73, 0x65,
	0x00, 0x52, 0x65, 0x6d, 0x69, 0x6e, 0x64, 0x73,
	0x20, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x6d,
	0x79, 0x20, 0x72, 0x6f, 0x6f, 0x6d, 0x2e, 0x00,
	0x00, 0x2e, 0x00, 0x73, 0x68, 0x61, 0x72, 0x70,
	0x65, 0x6e, 0x65, 0x64, 0x20, 0x73, 0x69, 0x63,
	0x6b, 0x6c, 0x65, 0x00, 0x4c, 0x61, 0x6d, 0x62,
	0x73, 0x2c, 0x20, 0x62, 0x65, 0x20, 0x73, 0x69,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x20, 0x48, 0x65,
	0x72, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x65, 0x73,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x69,
	0x6e, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x2f, 0x00,
	0x68, 0x61, 0x6e, 0x64, 0x6b, 0x65, 0x72, 0x63,
	0x68, 0x69, 0x65, 0x66, 0x00, 0x54, 0x68, 0x65,
	0x20, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x20, 0x6d,
	0x75, 0x73, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65,
	0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x62, 0x69,
	0x67, 0x20, 0x6e, 0x6f, 0x73, 0x65, 0x20, 0x74,
	0x68, 0x61, 0x74, 0x20, 0x68, 0x65, 0x20, 0x6e,
	0x65, 0x65, 0x64, 0x73, 0x00, 0x74, 0x6f, 0x20,
	0x75, 0x73, 0x65, 0x20, 0x61, 0x20, 0x77, 0x68,
	0x6f, 0x6c, 0x65, 0x20, 0x62, 0x61, 0x72, 0x20,
	0x6f, 0x66, 0x20, 0x73, 0x6f, 0x61, 0x70, 0x20,
	0x6a, 0x75, 0x73, 0x74, 0x20, 0x74, 0x6f, 0x20,
	0x77, 0x61, 0x73, 0x68, 0x20, 0x69, 0x74, 0x2e,
	0x00, 0x00, 0x30, 0x01, 0x6d, 0x6f, 0x75, 0x73,
	0x65, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x76,
	0x65, 0x72, 0x79, 0x20, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x2e, 0x00, 0x00, 0x31, 0x00, 0x72,
	0x6f, 0x63, 0x6b, 0x00, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x76, 0x65, 0x72, 0x79, 0x20, 0x72, 0x65,
	0x67, 0x75, 0x6c, 0x61, 0x72, 0x2c, 0x20, 0x6a,
	0x75, 0x73, 0x74, 0x20, 0x6c, 0x69, 0x6b, 0x65,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x6e, 0x6f,
	0x77, 0x62, 0x61, 0x6c, 0x6c, 0x2e, 0x00, 0x00,
	0x32, 0x01, 0x6e, 0x75, 0x67, 0x67, 0x65, 0x74,
	0x00, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x3a,
	0x20, 0x41, 0x75, 0x2c, 0x20, 0x61, 0x74, 0x6f,
	0x6d, 0x69, 0x63, 0x20, 0x6e, 0x6f, 0x3a, 0x20,
	0x37, 0x39, 0x2c, 0x20, 0x61, 0x74, 0x6f, 0x6d,
	0x69, 0x63, 0x20, 0x77, 0x74, 0x2e, 0x3a, 0x20,
	0x31, 0x39, 0x36, 0x2e, 0x39, 0x37, 0x2e, 0x00,
	0x49, 0x6e, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72,
	0x20, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x3a, 0x20,
	0x47, 0x4f, 0x4c, 0x44, 0x21, 0x21, 0x21, 0x20,
	0x59, 0x65, 0x73, 0x21, 0x20, 0x59, 0x65, 0x73,
	0x21, 0x00, 0x00, 0x33, 0x00, 0x62, 0x61, 0x6e,
	0x6b, 0x6e, 0x6f, 0x74, 0x65, 0x00, 0x00, 0x00,
	0x34, 0x00, 0x64, 0x69, 0x63, 0x74, 0x61, 0x70,
	0x68, 0x6f, 0x6e, 0x65, 0x00, 0x54, 0x68, 0x65,
	0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20, 0x6e,
	0x6f, 0x20, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x20, 0x69, 0x6e, 0x73, 0x69,
	0x64, 0x65, 0x2e, 0x00, 0x00, 0x35, 0x00, 0x70,
	0x6f, 0x6c, 0x61, 0x72, 0x6f, 0x69, 0x64, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x72, 0x65, 0x61,
	0x64, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x61,
	0x6b, 0x65, 0x20, 0x61, 0x20, 0x70, 0x69, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x2e, 0x00, 0x00, 0x36,
	0x00, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x20, 0x74,
	0x61, 0x70, 0x65, 0x00, 0x49, 0x74, 0x20, 0x68,
	0x61, 0x73, 0x20, 0x6e, 0x6f, 0x20, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x2e, 0x00, 0x00, 0x37, 0x00,
	0x73, 0x68, 0x65, 0x65, 0x74, 0x20, 0x6f, 0x66,
	0x20, 0x70, 0x61, 0x70, 0x65, 0x72, 0x00, 0x54,
	0x68, 0x65, 0x72, 0x65, 0x27, 0x73, 0x20, 0x6e,
	0x6f, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74,
	0x20, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x20, 0x69,
	0x74, 0x2e, 0x00, 0x00, 0x38, 0x00, 0x63, 0x6f,
	0x67, 0x6e, 0x61, 0x63, 0x00, 0x46, 0x61, 0x6e,
	0x63, 0x79, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20,
	0x6a, 0x75, 0x73, 0x74, 0x20, 0x66, 0x6f, 0x72,
	0x20, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x63, 0x75,
	0x73, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x64,
	0x72, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x2e,
	0x00, 0x00, 0x39, 0x00, 0x72, 0x65, 0x6d, 0x6f,
	0x74, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72,
	0x6f, 0x6c, 0x00, 0x49, 0x74, 0x20, 0x68, 0x61,
	0x73, 0x20, 0x75, 0x73, 0x65, 0x72, 0x2d, 0x66,
	0x72, 0x69, 0x65, 0x6e, 0x64, 0x6c, 0x79, 0x20,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63,
	0x65, 0x2e, 0x00, 0x4f, 0x6e, 0x65, 0x20, 0x63,
	0x61, 0x6e, 0x20, 0x70, 0x6c, 0x61, 0x79, 0x20,
	0x61, 0x6e, 0x64, 0x20, 0x73, 0x74, 0x6f, 0x70,
	0x2e, 0x00, 0x00, 0x3a, 0x00, 0x69, 0x63, 0x65,
	0x20, 0x74, 0x6f, 0x6e, 0x67, 0x73, 0x00, 0x56,
	0x65, 0x72, 0x79, 0x20, 0x68, 0x61, 0x6e, 0x64,
	0x79, 0x20, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x00,
	0x00, 0x3b, 0x00, 0x63, 0x6f, 0x72, 0x6b, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x61, 0x20, 0x73,
	0x74, 0x6f, 0x70, 0x70, 0x65, 0x72, 0x20, 0x6b,
	0x69, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x63,
	0x6f, 0x72, 0x6b, 0x2e, 0x00, 0x00, 0x3c, 0x00,
	0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x20,
	0x63, 0x6f, 0x72, 0x6b, 0x00, 0x4e, 0x6f, 0x77,
	0x20, 0x69, 0x74, 0x27, 0x73, 0x20, 0x6d, 0x6f,
	0x72, 0x65, 0x20, 0x61, 0x70, 0x70, 0x72, 0x6f,
	0x70, 0x69, 0x61, 0x74, 0x65, 0x2e, 0x00, 0x00,
	0x3d, 0x00, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x00,
	0x49, 0x74, 0x27, 0x73, 0x20, 0x61, 0x20, 0x70,
	0x68, 0x6f, 0x74, 0x6f, 0x20, 0x6f, 0x66, 0x20,
	0x4a, 0x6f, 0x68, 0x6e, 0x20, 0x4e, 0x6f, 0x74,
	0x79, 0x2e, 0x20, 0x49, 0x20, 0x63, 0x61, 0x75,
	0x67, 0x68, 0x74, 0x20, 0x68, 0x69, 0x6d, 0x00,
	0x77, 0x68, 0x65, 0x6e, 0x20, 0x68, 0x65, 0x20,
	0x77, 0x61, 0x73, 0x20, 0x73, 0x69, 0x6e, 0x67,
	0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x68, 0x69, 0x67, 0x68, 0x20, 0x43, 0x2e, 0x20,
	0x59, 0x75, 0x63, 0x6b, 0x21, 0x00, 0x00, 0x3e,
	0x00, 0x63, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x00,
	0x54, 0x68, 0x65, 0x20, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x62, 0x6f, 0x74, 0x74, 0x6c, 0x65, 0x20,
	0x73, 0x61, 0x79, 0x73, 0x20, 0x69, 0x74, 0x27,
	0x73, 0x00, 0x27, 0x4f, 0x52, 0x49, 0x47, 0x49,
	0x4e, 0x41, 0x4c, 0x20, 0x4d, 0x45, 0x58, 0x49,
	0x43, 0x41, 0x4e, 0x20, 0x43, 0x48, 0x49, 0x4c,
	0x4c, 0x49, 0x27, 0x2e, 0x20, 0x53, 0x75, 0x72,
	0x65, 0x2e, 0x00, 0x00, 0x3f, 0x00, 0x70, 0x61,
	0x73, 0x74, 0x72, 0x79, 0x20, 0x72, 0x6f, 0x6c,
	0x6c, 0x65, 0x72, 0x00, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x6f, 0x66,
	0x20, 0x76, 0x65, 0x72, 0x79, 0x20, 0x68, 0x61,
	0x72, 0x64, 0x20, 0x77, 0x6f, 0x6f, 0x64, 0x2e,
	0x00, 0x00, 0x40, 0x00, 0x66, 0x61, 0x6b, 0x65,
	0x20, 0x63, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x00,
	0x4e, 0x6f, 0x77, 0x20, 0x74, 0x68, 0x61, 0x74,
	0x27, 0x73, 0x20, 0x77, 0x68, 0x61, 0x74, 0x20,
	0x49, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x20, 0x73,
	0x74, 0x72, 0x6f, 0x6e, 0x67, 0x20, 0x73, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x00, 0x00, 0x41, 0x00, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x00, 0x27, 0x4f, 0x52, 0x49, 0x47, 0x49,
	0x4e, 0x41, 0x4c, 0x20, 0x4d, 0x45, 0x58, 0x49,
	0x43, 0x41, 0x4e, 0x20, 0x43, 0x48, 0x49, 0x4c,
	0x4c, 0x49, 0x27, 0x2e, 0x00, 0x00, 0x42, 0x00,
	0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20, 0x61,
	0x20, 0x70, 0x61, 0x69, 0x72, 0x20, 0x6f, 0x66,
	0x20, 0x6e, 0x65, 0x77, 0x20, 0x62, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x00,
	0x00, 0x43, 0x00, 0x64, 0x69, 0x63, 0x74, 0x61,
	0x70, 0x68, 0x6f, 0x6e, 0x65, 0x00, 0x27, 0x4f,
	0x6e, 0x65, 0x2d, 0x74, 0x77, 0x6f, 0x2d, 0x6f,
	0x6e, 0x65, 0x2d, 0x74, 0x77, 0x6f, 0x2c, 0x20,
	0x69, 0x74, 0x27, 0x73, 0x20, 0x6d, 0x65, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x65, 0x00,
	0x61, 0x6e, 0x64, 0x20, 0x6f, 0x6e, 0x6c, 0x79,
	0x20, 0x4d, 0x61, 0x72, 0x6b, 0x20, 0x4d, 0x43,
	0x2e, 0x2e, 0x2e, 0x2e, 0x27, 0x00, 0x49, 0x74,
	0x20, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2e, 0x00,
	0x00, 0x44, 0x01, 0x62, 0x75, 0x72, 0x6e, 0x69,
	0x6e, 0x67, 0x20, 0x70, 0x61, 0x70, 0x65, 0x72,
	0x00, 0x41, 0x6d, 0x61, 0x7a, 0x69, 0x6e, 0x67,
	0x2c, 0x20, 0x69, 0x73, 0x6e, 0x27, 0x74, 0x20,
	0x69, 0x74, 0x3f, 0x00, 0x28, 0x4e, 0x6f, 0x74,
	0x20, 0x74, 0x6f, 0x20, 0x6d, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x3a, 0x20, 0x75, 0x6e, 0x62,
	0x65, 0x6c, 0x69, 0x65, 0x76, 0x61, 0x62, 0x6c,
	0x65, 0x29, 0x2e, 0x00, 0x00, 0x45, 0x00, 0x6d,
	0x65, 0x61, 0x74, 0x00, 0x54, 0x68, 0x65, 0x72,
	0x65, 0x27, 0x73, 0x20, 0x76, 0x65, 0x61, 0x6c,
	0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x70, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x20,
	0x62, 0x61, 0x67, 0x2e, 0x00, 0x00, 0x46, 0x00,
	0x70, 0x6c, 0x61, 0x73, 0x74, 0x69, 0x63, 0x20,
	0x62, 0x61, 0x67, 0x00, 0x47, 0x65, 0x65, 0x2c,
	0x20, 0x49, 0x20, 0x68, 0x6f, 0x70, 0x65, 0x20,
	0x69, 0x74, 0x27, 0x73, 0x20, 0x72, 0x65, 0x63,
	0x79, 0x63, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x20, 0x49, 0x20, 0x63, 0x6f, 0x75, 0x6c, 0x64,
	0x6e, 0x27, 0x74, 0x00, 0x73, 0x6c, 0x65, 0x65,
	0x70, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x77,
	0x69, 0x73, 0x65, 0x2e, 0x00, 0x00, 0x47, 0x00,
	0x73, 0x6f, 0x63, 0x6b, 0x73, 0x00, 0x54, 0x68,
	0x65, 0x73, 0x65, 0x20, 0x73, 0x6f, 0x63, 0x6b,
	0x73, 0x20, 0x73, 0x75, 0x63, 0x6b, 0x2e, 0x00,
	0x00, 0x48, 0x00, 0x70, 0x69, 0x6c, 0x6c, 0x73,
	0x00, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61,
	0x72, 0x65, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74,
	0x20, 0x74, 0x77, 0x65, 0x6e, 0x74, 0x79, 0x20,
	0x70, 0x69, 0x6c, 0x6c, 0x73, 0x20, 0x69, 0x6e,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6a, 0x61,
	0x72, 0x2e, 0x00, 0x00, 0x49, 0x00, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x00, 0x49, 0x74, 0x20,
	0x6c, 0x6f, 0x6f, 0x6b, 0x73, 0x20, 0x6c, 0x69,
	0x6b, 0x65, 0x20, 0x61, 0x20, 0x73, 0x74, 0x61,
	0x6e, 0x64, 0x61, 0x72, 0x64, 0x20, 0x64, 0x6f,
	0x6f, 0x72, 0x20, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x4a, 0x00,
	0x63, 0x68, 0x69, 0x6c, 0x6c, 0x69, 0x00, 0x4e,
	0x69, 0x63, 0x65, 0x20, 0x62, 0x6f, 0x74, 0x74,
	0x6c, 0x65, 0x2e, 0x20, 0x49, 0x20, 0x6c, 0x69,
	0x6b, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73,
	0x68, 0x61, 0x70, 0x65, 0x2e, 0x00, 0x00, 0x4b,
	0x00, 0x70, 0x61, 0x73, 0x73, 0x00, 0x22, 0x4c,
	0x65, 0x74, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
	0x67, 0x75, 0x79, 0x20, 0x69, 0x6e, 0x2e, 0x20,
	0x52, 0x47, 0x42, 0x20, 0x43, 0x68, 0x69, 0x65,
	0x66, 0x2e, 0x22, 0x00, 0x00, 0x4c, 0x00, 0x62,
	0x75, 0x6c, 0x62, 0x00, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x65, 0x6c, 0x79, 0x20, 0x75, 0x73, 0x65, 0x6c,
	0x65, 0x73, 0x73, 0x2e, 0x00, 0x00, 0x4d, 0x00,
	0x6a, 0x61, 0x69, 0x6c, 0x20, 0x6b, 0x65, 0x79,
	0x00, 0x53, 0x75, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x69, 0x6e, 0x67, 0x6c, 0x79, 0x2c, 0x20, 0x69,
	0x74, 0x27, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x6b, 0x65, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6a, 0x61, 0x69, 0x6c, 0x2e,
	0x00, 0x00, 0x4e, 0x00, 0x64, 0x65, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x20, 0x70, 0x6c, 0x61,
	0x6e, 0x74, 0x00, 0x57, 0x68, 0x6f, 0x61, 0x2c,
	0x20, 0x69, 0x74, 0x20, 0x74, 0x69, 0x63, 0x6b,
	0x6c, 0x65, 0x73, 0x21, 0x00, 0x00, 0x4f, 0x00,
	0x53, 0x77, 0x69, 0x73, 0x73, 0x20, 0x41, 0x72,
	0x6d, 0x79, 0x20, 0x6b, 0x6e, 0x69, 0x66, 0x65,
	0x00, 0x49, 0x20, 0x77, 0x6f, 0x6e, 0x64, 0x65,
	0x72, 0x20, 0x69, 0x66, 0x20, 0x69, 0x74, 0x27,
	0x73, 0x20, 0x67, 0x6f, 0x74, 0x20, 0x61, 0x20,
	0x54, 0x56, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68,
	0x65, 0x73, 0x65, 0x20, 0x74, 0x6f, 0x6f, 0x2e,
	0x00, 0x00, 0x50, 0x00, 0x73, 0x70, 0x72, 0x69,
	0x6e, 0x67, 0x00, 0x49, 0x20, 0x63, 0x6f, 0x75,
	0x6c, 0x64, 0x20, 0x6c, 0x61, 0x75, 0x6e, 0x63,
	0x68, 0x20, 0x61, 0x20, 0x72, 0x6f, 0x63, 0x6b,
	0x65, 0x74, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20,
	0x69, 0x74, 0x21, 0x00, 0x00, 0x51, 0x00, 0x73,
	0x68, 0x6f, 0x76, 0x65, 0x6c, 0x00, 0x4e, 0x69,
	0x63, 0x65, 0x2c, 0x20, 0x68, 0x61, 0x6e, 0x64,
	0x79, 0x20, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x00,
	0x00, 0x52, 0x00, 0x6b, 0x61, 0x6c, 0x65, 0x69,
	0x64, 0x6f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x00,
	0x49, 0x20, 0x63, 0x6f, 0x75, 0x6c, 0x64, 0x20,
	0x73, 0x70, 0x65, 0x6e, 0x64, 0x20, 0x6d, 0x79,
	0x20, 0x77, 0x68, 0x6f, 0x6c, 0x65, 0x20, 0x6c,
	0x69, 0x66, 0x65, 0x20, 0x6c, 0x6f, 0x6f, 0x6b,
	0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x72, 0x6f,
	0x75, 0x67, 0x68, 0x00, 0x74, 0x68, 0x69, 0x73,
	0x2e, 0x20, 0x57, 0x65, 0x6c, 0x6c, 0x2c, 0x20,
	0x6c, 0x65, 0x74, 0x27, 0x73, 0x20, 0x73, 0x61,
	0x79, 0x20, 0x66, 0x69, 0x76, 0x65, 0x20, 0x6d,
	0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x00,
	0x4f, 0x68, 0x2c, 0x20, 0x61, 0x6c, 0x6c, 0x20,
	0x72, 0x69, 0x67, 0x68, 0x74, 0x2c, 0x20, 0x69,
	0x74, 0x27, 0x73, 0x20, 0x62, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x00, 0x00, 0x53, 0x00, 0x22,
	0x53, 0x6f, 0x6c, 0x64, 0x69, 0x65, 0x72, 0x20,
	0x4e, 0x65, 0x77, 0x73, 0x22, 0x00, 0x49, 0x74,
	0x27, 0x73, 0x20, 0x6a, 0x75, 0x73, 0x74, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65,
	0x20, 0x61, 0x73, 0x20, 0x77, 0x6f, 0x6d, 0x65,
	0x6e, 0x27, 0x73, 0x20, 0x6d, 0x61, 0x67, 0x61,
	0x7a, 0x69, 0x6e, 0x65, 0x73, 0x2c, 0x00, 0x62,
	0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65,
	0x20, 0x61, 0x72, 0x65, 0x20, 0x67, 0x75, 0x6e,
	0x73, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x65, 0x61,
	0x64, 0x20, 0x6f, 0x66, 0x20, 0x70, 0x65, 0x72,
	0x66, 0x75, 0x6d, 0x65, 0x73, 0x2e, 0x00, 0x49,
	0x74, 0x27, 0x73, 0x20, 0x63, 0x6f, 0x6f, 0x6c,
	0x20, 0x61, 0x6e, 0x79, 0x77, 0x61, 0x79, 0x2e,
	0x00, 0x00, 0x54, 0x00, 0x67, 0x72, 0x65, 0x6e,
	0x61, 0x64, 0x65, 0x00, 0x49, 0x20, 0x6d, 0x75,
	0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x63, 0x72,
	0x61, 0x7a, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x70,
	0x75, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x6d, 0x79,
	0x20, 0x70, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x2e,
	0x00, 0x53, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x69,
	0x6e, 0x67, 0x20, 0x68, 0x6f, 0x72, 0x72, 0x69,
	0x62, 0x6c, 0x65, 0x20, 0x6d, 0x69, 0x67, 0x68,
	0x74, 0x20, 0x68, 0x61, 0x70, 0x70, 0x65, 0x6e,
	0x2e, 0x2e, 0x2e, 0x00, 0x00, 0x55, 0x00, 0x6d,
	0x75, 0x67, 0x00, 0x49, 0x74, 0x27, 0x73, 0x20,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x00, 0x00,
	0x56, 0x00, 0x6d, 0x75, 0x67, 0x20, 0x66, 0x75,
	0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x6d, 0x75,
	0x64, 0x00, 0x57, 0x68, 0x79, 0x20, 0x64, 0x69,
	0x64, 0x20, 0x49, 0x20, 0x66, 0x69, 0x6c, 0x6c,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x75, 0x67,
	0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x6d, 0x75,
	0x64, 0x3f, 0x00, 0x00, 0x54, 0x68, 0x61, 0x74,
	0x20, 0x6d, 0x61, 0x6b, 0x65, 0x73, 0x20, 0x6e,
	0x6f, 0x20, 0x73, 0x65, 0x6e, 0x73, 0x65, 0x21,
	0x00, 0x00, 0x57, 0x00, 0x63, 0x72, 0x75, 0x6d,
	0x62, 0x73, 0x00, 0x54, 0x68, 0x65, 0x73, 0x65,
	0x20, 0x61, 0x72, 0x65, 0x20, 0x73, 0x6f, 0x6d,
	0x65, 0x20, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x20, 0x6f, 0x66, 0x20, 0x62, 0x72, 0x65,
	0x61, 0x64, 0x2e, 0x00, 0x00, 0x58, 0x00, 0x72,
	0x6f, 0x70, 0x65, 0x00, 0x49, 0x74, 0x27, 0x73,
	0x20, 0x74, 0x68, 0x69, 0x6e, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x2e, 0x00,
	0x00, 0x59, 0x00, 0x72, 0x6f, 0x70, 0x65, 0x20,
	0x74, 0x69, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
	0x67, 0x72, 0x65, 0x6e, 0x61, 0x64, 0x65, 0x00,
	0x4d, 0x79, 0x20, 0x70, 0x61, 0x74, 0x65, 0x6e,
	0x74, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x20,
	0x62, 0x6f, 0x6d, 0x62, 0x61, 0x73, 0x74, 0x69,
	0x63, 0x20, 0x79, 0x6f, 0x79, 0x6f, 0x2e, 0x00,
	0x00, 0x5a, 0x00, 0x6d, 0x65, 0x64, 0x69, 0x63,
	0x69, 0x6e, 0x65, 0x00, 0x54, 0x68, 0x65, 0x79,
	0x20, 0x6c, 0x6f, 0x6f, 0x6b, 0x20, 0x6c, 0x69,
	0x6b, 0x65, 0x20, 0x73, 0x6c, 0x65, 0x65, 0x70,
	0x69, 0x6e, 0x67, 0x20, 0x70, 0x69, 0x6c, 0x6c,
	0x73, 0x2e, 0x00, 0x41, 0x6c, 0x74, 0x68, 0x6f,
	0x75, 0x67, 0x68, 0x20, 0x49, 0x20, 0x64, 0x6f,
	0x6e, 0x27, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65,
	0x20, 0x61, 0x6e, 0x79, 0x20, 0x69, 0x64, 0x65,
	0x61, 0x20, 0x77, 0x68, 0x79, 0x2e, 0x00, 0x00,
	0x5b, 0x00, 0x64, 0x72, 0x75, 0x67, 0x67, 0x65,
	0x64, 0x20, 0x66, 0x6f, 0x6f, 0x64, 0x00, 0x53,
	0x6d, 0x65, 0x6c, 0x6c, 0x73, 0x20, 0x6c, 0x69,
	0x6b, 0x65, 0x20, 0x54, 0x65, 0x65, 0x6e, 0x20,
	0x53, 0x70, 0x69, 0x72, 0x69, 0x74, 0x2e, 0x00,
	0x00, 0x5c, 0x01, 0x62, 0x69, 0x72, 0x64, 0x00,
	0x49, 0x74, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64,
	0x20, 0x6d, 0x61, 0x6b, 0x65, 0x20, 0x61, 0x20,
	0x67, 0x72, 0x65, 0x61, 0x74, 0x20, 0x64, 0x69,
	0x6e, 0x6e, 0x2e, 0x2e, 0x2e, 0x20, 0x49, 0x20,
	0x6d, 0x65, 0x61, 0x6e, 0x00, 0x66, 0x72, 0x69,
	0x65, 0x6e, 0x64, 0x2c, 0x20, 0x6f, 0x66, 0x20,
	0x63, 0x6f, 0x75, 0x72, 0x73, 0x65, 0x2e, 0x00,
	0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,
	0x00, 0x01, 0xff, 0xff, 0x00, 0xff, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00,
	0x00, 0x01, 0xff, 0x00, 0x00, 0x02, 0xff, 0xff,
	0xff, 0x01, 0xff, 0x00, 0x00, 0x02, 0xff, 0x00,
	0x00, 0x01, 0xff, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x06, 0xff, 0xff, 0x00, 0x02, 0xff, 0x00,
	0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
	0x00, 0x01, 0x02, 0xff, 0x00, 0x04, 0xff, 0x00,
	0x00, 0xff, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00,
	0x00, 0x0a, 0xff, 0x00, 0x00, 0x01, 0x0d, 0x00,
	0x00, 0x01, 0x02, 0xff, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x06, 0x07, 0x00, 0x00, 0xff, 0xff, 0xff,
	0x00, 0x01, 0x04, 0x02, 0x03, 0xff, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff,
	0x00, 0xff, 0xff, 0x00, 0x00, 0x01, 0xff, 0xff,
	0x00, 0x01, 0x02, 0xff, 0x00, 0xff, 0xff, 0x00,
	0x00, 0x04, 0xff, 0xff, 0x00, 0xff, 0xff, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0x01, 0xff, 0x00,
	0x00, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff,
	0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00,
	0x00, 0xf8, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x28, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x67, 0x7c, 0x04, 0x4f, 0x29, 0x00,
	0x00, 0xec, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x2a, 0x66, 0x37, 0x03, 0xca, 0x0c, 0x00,
	0x00, 0x75, 0xbf, 0x91, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x99, 0x5f, 0x87, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x64, 0x34, 0xbe, 0x47, 0xad, 0x03, 0x86,
	0x02, 0x18, 0x20, 0xd4, 0x02, 0x00, 0x00, 0x00,
	0x00, 0xd6, 0x22, 0x58, 0x02, 0x00, 0x00, 0x00,
	0x00, 0x0c, 0x67, 0xac, 0xf3, 0x00, 0x00, 0x00,
	0x00, 0xc3, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xdf, 0x27, 0xc8, 0x4d, 0x64, 0x08, 0x00,
	0x00, 0x4e, 0x7e, 0x5c, 0xe6, 0x00, 0x00, 0x00,
	0x00, 0x69, 0x0d, 0x27, 0x0d, 0x00, 0x00, 0x00,
	0x00, 0x4a, 0x0d, 0x45, 0x0d, 0x00, 0x00, 0x00,
	0x00, 0xb9, 0x48, 0x71, 0x12, 0x04, 0x27, 0x00,
	0x00, 0xdb, 0x73, 0xfe, 0x02, 0x00, 0x00, 0x00,
	0x00, 0xfc, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x5b, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x13, 0x40, 0x51, 0x93, 0x00, 0x00, 0x00,
	0x00, 0x13, 0x4f, 0x4f, 0x05, 0x00, 0x00, 0x00,
	0x00, 0x7a, 0x50, 0x64, 0x5d, 0x6f, 0x04, 0x00,
	0x00, 0xa3, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x88, 0x02, 0x91, 0x02, 0x00, 0x00, 0x00,
	0x00, 0xce, 0x02, 0x77, 0x04, 0x2f, 0x1d, 0x00,
	0x00, 0x08, 0x69, 0x06, 0x23, 0x32, 0x4b, 0x3e,
	0x6c, 0x46, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xf6, 0x16, 0xc5, 0x13, 0x00, 0x00, 0x00,
	0x00, 0xfb, 0x0a, 0x21, 0x73, 0x68, 0x3b, 0x00,
	0x00, 0x9b, 0x15, 0x0d, 0x1a, 0x00, 0x00, 0x00,
	0x00, 0xce, 0xf7, 0x25, 0x6b, 0xcb, 0x13, 0x00,
	0x00, 0x33, 0xa5, 0xbf, 0x01, 0xb3, 0x10, 0x00,
	0x00, 0xcb, 0x13, 0x7c, 0x05, 0x00, 0x00, 0x00,
	0x00, 0x7e, 0x0f, 0x14, 0x59, 0xc5, 0x13, 0x00,
	0x00, 0x95, 0x51, 0xce, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4d, 0x29, 0xfc, 0x14, 0xe1, 0xa4, 0xad,
	0x8e, 0x07, 0x5b, 0x47, 0x02, 0x00, 0x00, 0x00,
	0x00, 0xbf, 0x52, 0x3c, 0x0e, 0xc5, 0x0e, 0x00,
	0x00, 0x44, 0x6b, 0xe0, 0x76, 0x97, 0x00, 0x00,
	0x00, 0x5a, 0x1a, 0xb8, 0xb3, 0x00, 0x00, 0x00,
	0x00, 0x6c, 0x66, 0x8f, 0xdc, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0xb4, 0x01, 0x6f, 0x04, 0xcb,
	0x07, 0x01, 0x09, 0xff, 0xff, 0x36, 0x09, 0x02,
	0x0a, 0x2d, 0x0a, 0xff, 0xff, 0x43, 0x0c, 0x75,
	0x0d, 0x0e, 0x0f, 0xb8, 0x0f, 0xff, 0xff, 0xdb,
	0x10, 0xac, 0x11, 0xd9, 0x12, 0x68, 0x14, 0xff,
	0xff, 0x85, 0x14, 0x28, 0x15, 0xff, 0xff, 0xde,
	0x16, 0x26, 0x17, 0xff, 0xff, 0x52, 0x17, 0x8c,
	0x17, 0x13, 0x19, 0x3e, 0x1a, 0x63, 0x1a, 0x84,
	0x1a, 0xc9, 0x1a, 0xf7, 0x1a, 0x27, 0x1b, 0x4a,
	0x1b, 0xff, 0xff, 0x97, 0x1c, 0xec, 0x1c, 0xff,
	0xff, 0x2c, 0x1d, 0xd8, 0x1d, 0xff, 0xff, 0x41,
	0x20, 0x5f, 0x21, 0xff, 0xff, 0x82, 0x25, 0xfe,
	0x25, 0xff, 0xff, 0x6f, 0x2b, 0xb2, 0x2b, 0xdd,
	0x2b, 0x5d, 0x2c, 0x9b, 0x2c, 0xff, 0xff, 0x02,
	0x31, 0x1b, 0x31, 0x37, 0x31, 0x6f, 0x31, 0xff,
	0xff, 0x7d, 0x31, 0x15, 0x32, 0xff, 0xff, 0x41,
	0x3e, 0xa3, 0x3e, 0x08, 0x3f, 0xea, 0x3f, 0xff,
	0xff, 0x0d, 0x40, 0x39, 0x44, 0x6a, 0x44, 0xff,
	0xff, 0xe2, 0x58, 0xc5, 0x59, 0x9d, 0x5a, 0xd7,
	0x5a, 0xff, 0xff, 0xf3, 0x5a, 0xa9, 0x5b, 0x53,
	0x5c, 0x99, 0x5c, 0x3e, 0x5d, 0xff, 0xff, 0x5b,
	0x5d, 0x0a, 0x5f, 0xae, 0x5f, 0xcf, 0x5f, 0xff,
	0xff, 0xfe, 0x5f, 0x88, 0x60, 0xff, 0xff, 0xf0,
	0x62, 0x18, 0x63, 0x47, 0x63, 0x6b, 0x63, 0x82,
	0x63, 0xff, 0xff, 0xf7, 0x6b, 0x7f, 0x6d, 0x7b,
	0x6e, 0xa4, 0x6e, 0xff, 0xff, 0xc0, 0x6e, 0xe9,
	0x6e, 0x03, 0x6f, 0xff, 0xff, 0x5e, 0x73, 0xb3,
	0x73, 0xe8, 0x73, 0xff, 0xff, 0xfc, 0x64, 0x4c,
	0x65, 0xab, 0x65, 0xff, 0xff, 0x03, 0x74, 0x59,
	0x74, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xdd, 0xec, 0x50,
	0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x73, 0x00, 0x69, 0x41, 0x4e, 0x44,
	0x52, 0x5a, 0x45, 0x4a, 0x20, 0x44, 0x4f, 0x42,
	0x52, 0x5a, 0x59, 0x3b, 0x53, 0x4b, 0x49, 0x00,
	0x00, 0xe3, 0xd2, 0x50, 0x6d, 0x75, 0x73, 0x69,
	0x63, 0x00, 0x69, 0x52, 0x41, 0x44, 0x45, 0x4b,
	0x20, 0x53, 0x5a, 0x41, 0x4d, 0x52, 0x45, 0x4a,
	0x00, 0x00, 0xd7, 0xe6, 0x50, 0x61, 0x6e, 0x69,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x69, 0x63, 0x73, 0x00, 0x69, 0x47, 0x52, 0x5a,
	0x45, 0x47, 0x4f, 0x52, 0x5a, 0x20, 0x4d, 0x49,
	0x45, 0x43, 0x48, 0x4f, 0x57, 0x53, 0x4b, 0x49,
	0x00, 0x00, 0xd9, 0xe8, 0x50, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x6d, 0x69, 0x6e, 0x67,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x00, 0x69, 0x41, 0x44, 0x52,
	0x49, 0x41, 0x4e, 0x20, 0x43, 0x48, 0x4d, 0x49,
	0x45, 0x4c, 0x41, 0x52, 0x5a, 0x00, 0x00, 0xdd,
	0xec, 0x5c, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x72, 0x69,
	0x6e, 0x67, 0x20, 0x6a, 0x6f, 0x75, 0x72, 0x6e,
	0x65, 0x79, 0x2e, 0x2e, 0x2e, 0x00, 0x00, 0xdd,
	0xec, 0x5c, 0x54, 0x48, 0x45, 0x20, 0x45, 0x4e,
	0x44, 0x00, 0x00, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x6d, 0x69, 0x6e, 0x67, 0x00, 0x41,
	0x44, 0x52, 0x49, 0x41, 0x4e, 0x20, 0x43, 0x48,
	0x4d, 0x49, 0x45, 0x4c, 0x41, 0x52, 0x5a, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x61, 0x6e, 0x69, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x00, 0x47, 0x52,
	0x5a, 0x45, 0x47, 0x4f, 0x52, 0x5a, 0x20, 0x4d,
	0x49, 0x45, 0x43, 0x48, 0x4f, 0x57, 0x53, 0x4b,
	0x49, 0x00, 0x20, 0x00, 0x20, 0x00, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x20, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x00, 0x54, 0x4f, 0x4d, 0x41,
	0x53, 0x5a, 0x20, 0x50, 0x49, 0x4c, 0x49, 0x4b,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x62, 0x61, 0x63,
	0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x73,
	0x00, 0x41, 0x4e, 0x44, 0x52, 0x5a, 0x45, 0x4a,
	0x20, 0x44, 0x4f, 0x42, 0x52, 0x5a, 0x59, 0x4e,
	0x53, 0x4b, 0x49, 0x00, 0x20, 0x00, 0x20, 0x00,
	0x6d, 0x75, 0x73, 0x69, 0x63, 0x00, 0x52, 0x41,
	0x44, 0x45, 0x4b, 0x20, 0x53, 0x5a, 0x41, 0x4d,
	0x52, 0x45, 0x4a, 0x00, 0x20, 0x00, 0x20, 0x00,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x20, 0x61, 0x72,
	0x74, 0x00, 0x44, 0x41, 0x52, 0x49, 0x55, 0x53,
	0x5a, 0x20, 0x41, 0x4e, 0x41, 0x43, 0x4b, 0x49,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x20, 0x68, 0x65, 0x6c, 0x70, 0x00, 0x50, 0x45,
	0x54, 0x45, 0x52, 0x20, 0x57, 0x45, 0x4c, 0x4c,
	0x53, 0x00, 0x20, 0x00, 0x20, 0x00, 0x62, 0x65,
	0x74, 0x61, 0x74, 0x65, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x00, 0x54, 0x4f, 0x4d, 0x41, 0x53, 0x5a,
	0x20, 0x46, 0x55, 0x52, 0x4d, 0x41, 0x4e, 0x49,
	0x55, 0x4b, 0x00, 0x50, 0x41, 0x54, 0x52, 0x59,
	0x4b, 0x20, 0x53, 0x41, 0x57, 0x49, 0x43, 0x4b,
	0x49, 0x00, 0x50, 0x41, 0x57, 0x45, 0x4c, 0x20,
	0x4d, 0x49, 0x45, 0x43, 0x48, 0x4f, 0x57, 0x53,
	0x4b, 0x49, 0x00, 0x4d, 0x41, 0x52, 0x45, 0x4b,
	0x20, 0x43, 0x48, 0x4d, 0x49, 0x45, 0x4c, 0x41,
	0x52, 0x5a, 0x00, 0x4a, 0x45, 0x44, 0x52, 0x45,
	0x4b, 0x20, 0x57, 0x49, 0x43, 0x48, 0x41, 0x00,
	0x4d, 0x52, 0x2e, 0x20, 0x4a, 0x4f, 0x48, 0x4e,
	0x20, 0x44, 0x4f, 0x45, 0x00, 0x4d, 0x41, 0x52,
	0x43, 0x49, 0x4e, 0x20, 0x44, 0x52, 0x45, 0x57,
	0x53, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00,
	0x69, 0x64, 0x65, 0x61, 0x73, 0x00, 0x41, 0x44,
	0x52, 0x49, 0x41, 0x4e, 0x20, 0x43, 0x48, 0x4d,
	0x49, 0x45, 0x4c, 0x41, 0x52, 0x5a, 0x00, 0x47,
	0x52, 0x5a, 0x45, 0x47, 0x4f, 0x52, 0x5a, 0x20,
	0x4d, 0x49, 0x45, 0x43, 0x48, 0x4f, 0x57, 0x53,
	0x4b, 0x49, 0x00, 0x41, 0x4e, 0x44, 0x52, 0x5a,
	0x45, 0x4a, 0x20, 0x53, 0x41, 0x57, 0x49, 0x43,
	0x4b, 0x49, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x00, 0x4a,
	0x41, 0x52, 0x4f, 0x53, 0x5d, 0x41, 0x57, 0x20,
	0x57, 0x45, 0x49, 0x53, 0x53, 0x00, 0x41, 0x47,
	0x45, 0x4e, 0x43, 0x4a, 0x41, 0x20, 0x53, 0x54,
	0x59, 0x4c, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x74, 0x68, 0x61, 0x6e, 0x6b, 0x73, 0x00,
	0x48, 0x45, 0x4e, 0x52, 0x59, 0x20, 0x4b, 0x55,
	0x54, 0x54, 0x4e, 0x45, 0x52, 0x00, 0x55, 0x2d,
	0x4b, 0x4e, 0x4f, 0x57, 0x2d, 0x57, 0x48, 0x4f,
	0x2d, 0x55, 0x2d, 0x52, 0x2d, 0x42, 0x55, 0x54,
	0x2d, 0x57, 0x41, 0x4e, 0x54, 0x2d, 0x32, 0x2d,
	0x53, 0x54, 0x41, 0x59, 0x2d, 0x49, 0x4e, 0x2d,
	0x53, 0x48, 0x41, 0x44, 0x4f, 0x57, 0x00, 0x45,
	0x50, 0x49, 0x43, 0x20, 0x4d, 0x45, 0x47, 0x41,
	0x47, 0x41, 0x4d, 0x45, 0x53, 0x00, 0x58, 0x4c,
	0x41, 0x4e, 0x44, 0x20, 0x53, 0x4f, 0x46, 0x54,
	0x57, 0x41, 0x52, 0x45, 0x20, 0x50, 0x55, 0x42,
	0x4c, 0x49, 0x53, 0x48, 0x49, 0x4e, 0x47, 0x00,
	0x4b, 0x41, 0x54, 0x41, 0x52, 0x5a, 0x59, 0x4e,
	0x41, 0x20, 0x4d, 0x49, 0x45, 0x43, 0x48, 0x4f,
	0x57, 0x53, 0x4b, 0x41, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x20, 0x00, 0x73, 0x70, 0x65, 0x63, 0x69,
	0x61, 0x6c, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x6b,
	0x73, 0x00, 0x41, 0x4e, 0x44, 0x52, 0x5a, 0x45,
	0x4a, 0x20, 0x4d, 0x49, 0x43, 0x48, 0x41, 0x4c,
	0x41, 0x4b, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x00,
	0x4d, 0x45, 0x54, 0x52, 0x4f, 0x50, 0x4f, 0x4c,
	0x49, 0x53, 0x20, 0x53, 0x4f, 0x46, 0x54, 0x57,
	0x41, 0x52, 0x45, 0x20, 0x48, 0x4f, 0x55, 0x53,
	0x45, 0x00, 0x28, 0x63, 0x29, 0x20, 0x31, 0x39,
	0x39, 0x34, 0x2d, 0x31, 0x39, 0x39, 0x35, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x41, 0x6c,
	0x6c, 0x20, 0x61, 0x6c, 0x6c, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x70, 0x75, 0x6e, 0x73, 0x00, 0x61, 0x72, 0x65,
	0x20, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x20,
	0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00
};

struct Combination {
	byte _obj1Id;
	byte _obj2Id;
	byte _newObjId;

	void write(FILE *fd) {
		writeByte(fd, _obj1Id);
		writeByte(fd, _obj2Id);
		writeByte(fd, _newObjId);
	}
};

const uint kNumCombinations = 34;

Combination combiningTable[kNumCombinations] = {
	{0x12, 0x16, 0x17},
	{0x15, 0x18, 0x19},
	{0x01, 0x1c, 0x1f},
	{0x11, 0x1c, 0x1e},
	{0x1f, 0x11, 0x20},
	{0x1e, 0x01, 0x20},
	{0x0d, 0x10, 0x0e},
	{0x08, 0x0f, 0x09},
	{0x14, 0x21, 0x22},
	{0x27, 0x28, 0x29},
	{0x26, 0x2a, 0x2b},
	{0x12, 0x13, 0x00},
	{0x01, 0x30, 0x00},
	{0x10, 0x30, 0x00},
	{0x12, 0x14, 0x00},
	{0x12, 0x22, 0x00},
	{0x12, 0x1a, 0x00},
	{0x12, 0x1c, 0x00},
	{0x12, 0x31, 0x00},
	{0x12, 0x13, 0x00},
	{0x13, 0x30, 0x00},
	{0x18, 0x0a, 0x00},
	{0x18, 0x0b, 0x00},
	{0x15, 0x26, 0x00},
	{0x2d, 0x30, 0x00},
	{0x2c, 0x30, 0x00},
	{0x2e, 0x30, 0x00},
	{0x31, 0x1a, 0x00},
	{0x31, 0x30, 0x00},
	{0x37, 0x3b, 0x3c},
	{0x41, 0x38, 0x40},
	{0x42, 0x34, 0x43},
	{0x54, 0x58, 0x59},
	{0x57, 0x5a, 0x5b},
};

const char *englishCombineMessages[kNumCombinations] = {
	"Wow, now it looks like it came straight\nfrom the store!",
	"Tying the ribbon around the rake narrowed\nthe space between the teeth!",
	"With the help of super glue I made...\nsomething...",
	"With the help of super glue I made...\nsomething...",
	"Using the super glue once again...",
	"Using the super glue once again...",
	"The whisky is strong enough to use as\nfuel, but I wonder if the chainsaw\ncan take it...",
	"Once again the super-glue comes in handy...",
	"The soot gives the potatoe a brand new look...",
	"Now I'm ready to conquer the lake!",
	"It makes me feel like another\nwanna-be cliffhanger.",
	"I wouldn't impress anyone with such candy.",
	"It's active enough.",
	"Great idea! But, you see, ecomaniacs might\nbe watching...",
	"It won't look any better in a wrapper.",
	"It won't look any better in a wrapper.",
	"It won't look any better in a wrapper.",
	"It won't look any better in a wrapper.",
	"It won't look any better in a wrapper.",
	"The cake is too big for this wrapper.",
	"I don't want to waste this candy.",
	"The flower is beautiful enough without\nany fancy extras.",
	"The flower is beautiful enough without\nany fancy extras.",
	"Good idea, but I need something smaller\nthan this rope.",
	"I might need this cheese. Again.",
	"It's not DOOM. It's a harmless graphic adventure\nfor the whole family (we want DOOM! we want\nDOOM!).",
	"It's not DOOM. It's a harmless graphic adventure\nfor the whole family (we want DOOM! we want\nDOOM!).",
	"I don't need to open this nut.",
	"It's not DOOM. It's a harmless graphic adventure\nfor the whole family (we want DOOM! we want\nDOOM!).",
	"Let's make this cork larger.",
	"Once again the super glue comes in handy.",
	"The batteries fit!",
	"I tied the rope to the pin.",
	"Let's make it spicy.",
};

const char *polishCombineMessages[kNumCombinations] = {
	"]a%, teraz wygl@da jak prosto ze sklepu!",
	"Obwi@zanie grabi wst@<k@ zw#zi%o odst#py\nmi#dzy z#bami!",
	"Z pomoc@ super kleju zrobi%em...\nco$...",
	"Z pomoc@ super kleju zrobi%em...\nco$...",
	"U<ywam super kleju raz jeszcze...",
	"U<ywam super kleju raz jeszcze...",
	"Whisky jest na tyle mocna, by zast@pi^ paliwo,\nale ciekawe, czy pi%a to prze<yje...",
	"Raz jeszcze super klej si# przydaje...",
	"Sadza nadaje ziemniakowi ca%kiem nowy wygl@d...",
	"Teraz mog# podbi^ ka<de jezioro!",
	"\'Alpinista\', co?...",
	"Takim ciastkiem nikogo nie zainteresuj#.",
	"Jest wystarczaj@co aktywna.",
	"Wspania%y pomys%. Ale, widzisz, ekomaniacy\nmog@ patrze^...",
	"Nie b#dzie wygl@da^ lepiej w celofanie.",
	"Nie b#dzie wygl@da^ lepiej w celofanie.",
	"Nie b#dzie wygl@da^ lepiej w celofanie.",
	"Nie b#dzie wygl@da^ lepiej w celofanie.",
	"Nie b#dzie wygl@da^ lepiej w celofanie.",
	"Ciastko jest za du<e na ten celofan.",
	"Nie chc# zniszczy^ tego ciastka.",
	"Kwiatek jest $liczny bez dodatk*w.",
	"Kwiatek jest $liczny bez dodatk*w.",
	"Dobry pomys%, ale potrzebuj# czego$\nmniejszego ni< ta lina.",
	"Mog# jeszcze potrzebowa^ tego sera. Znowu.",
	"To nie DOOM. To %agodna przygod*wka dla ca%ej\nrodziny (my chcemy DOOMA! my chcemy\nDOOMA!).",
	"To nie DOOM. To %agodna przygod*wka dla ca%ej\nrodziny (my chcemy DOOMA! my chcemy\nDOOMA!).",
	"Nie musz# go otwiera^.",
	"To nie DOOM. To %agodna przygod*wka dla ca%ej\nrodziny (my chcemy DOOMA! my chcemy\nDOOMA!).",
	"Powi#ksz# nieco ten korek.",
	"Kolejny raz u<ywam super kleju.",
	"Baterie pasuj@!",
	"Przywi@za%em lin# do zawleczki.",
	"Dodajmy troch# przypraw...",
};

const char *czechCombineMessages[kNumCombinations] = {
	"No par#da, vypad# to jako $erstv+ koupen*\nv obchod+!",
	"Uta{en; zbyl^ch zub] hr#b; p#skou zmen@ilo\nmezery mezi zuby, hr#b+ jsou ready!",
	"Pou{it;m super lepidla jsem cosi stvo>il.\nN+jak* cosi. Zat;m...",
	"Pou{it;m super lepidla jsem cosi stvo>il.\nN+jak* cosi. Zat;m...",
	"Dal@;m pou{it;m super lepidla...",
	"Dal@;m pou{it;m super lepidla...",
	"Whiska je dost siln#, aby se dala pou{;t\njako palivo, jen aby to ale vydr{ela\nchud#k motorov# pila.",
	"A znovu se hodilo super lepidlo...",
	"Saze m+n; brambor na n+co \\pln+ jin*ho,\nhroziv+j@;ho.",
	"Poslu@n+ hl#s;m, jsem p>ipraven k pot#p+n;!",
	"C;t;m se jako dal@; novope$en^ Cliffhanger.\nSly@;@ Sly?",
	"S takov^mhle ocucan^m bonb=nem nikoho neosln;m.",
	"Mele se, jako by m+la padoucnici.",
	"Bezvadnej n#pad, ale bacha, ekomaniaci \njsou po>#d na pozoru...",
	"Ani takovej p+knej obal tomu zat;m nepom]{e.",
	"Ani takovej p+knej obal tomu zat;m nepom]{e.",
	"Ani takovej p+knej obal tomu zat;m nepom]{e.",
	"Ani takovej p+knej obal tomu zat;m nepom]{e.",
	"Ani takovej p+knej obal tomu zat;m nepom]{e.",
	"M-mm. Moc malej obal na moc velkej bonb=n.",
	"Nechci ten bonb=n jen tak promarnit.",
	"Kv+tina je kr#sn# i tak, nepot>ebuje\n{#dn* vylep@ov#ky.",
	"Kv+tina je kr#sn# i tak, nepot>ebuje\n{#dn* vylep@ov#ky.",
	"Dobrej n#pad, ale pot>ebuju n+co men@;ho\nne{ tenhle provaz.",
	"Fuj. A nav;c se ten s^r m]{e je@t+ hodit.",
	"Nejsme v DOOMu, ale v ne@kodn* adventu>e\npro celou rodinu (My chceme DOOM! my chceme\nDOOM!).",
	"Nejsme v DOOMu, ale v ne@kodn* adventu>e\npro celou rodinu (My chceme DOOM! my chceme\nDOOM!).",
	"Nen; pot>eba o>ech otev;rat.",
	"Nejsme v DOOMu, ale v ne@kodn* adventu>e\npro celou rodinu (My chceme DOOM! my chceme\nDOOM!).",
	"Ano, ud+l#me ten @punt v+t@;, tak!",
	"A je@t+ jednou se super lepidlo hodilo.",
	"Baterky pasovaly!",
	"P>iv#zal jsem lano k tomu, k $emu pat>;.",
	"Trochu to oko>en;me...",
};

const char *russianCombineMessages[kNumCombinations] = {
	"Odo, sfpfq} ona c|dl\200eis kak\npq\200mikom ih madahina!\x1f\x1f\x1f\x1f\x1f",
	"Obc\200hac dqabli lfnsoj, tealor} tmfn}yis}\nhahoq mfget htb}\200mi!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"R pomoz}\177 rtpfqklf\200 \200 reflal...\nxso-so...\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"R pomoz}\177 rtpfqklf\200 \200 reflal...\nxso-so...\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"Rnoca pqimfnic rtpfqklfj...\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"Rnoca pqimfnic rtpfqklfj...\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"Cirki eorsasoxno kqfpkij, xsob|\nrojsi ha soplico, no cos poje>s li\nono el\200 bfnhopil|...",
	"Rtpfqklfj rnoca pqidoeilr\200...\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"Raga pqieala kaqsoykf rocfqyfnno inoj cie...\x1f\x1f",
	"Sfpfq} \200 dosoc pokoqis} ohfqo!\x1f\x1f\x1f\x1f",
	"Oztzfnif, xso ~so rnoca\ndltp|j \"qo\200l} c ktrsav\".\x1f\x1f\x1f",
	"Feca li saka\200 konufsa komt-so ponqacisr\200.\x1f",
	"Sfpfq} poecigna\200.\x1f\x1f",
	"Oslixno! No ha mnoj modts nabl\177eas}\n~kolodi-uanasiki...\x1f\x1f",
	"C ob>qskf ltxyf c|dl\200efs} nf rsanfs.\x1f\x1f",
	"C ob>qskf ltxyf c|dl\200efs} nf rsanfs.\x1f\x1f",
	"C ob>qskf ltxyf c|dl\200efs} nf rsanfs.\x1f\x1f",
	"C ob>qskf ltxyf c|dl\200efs} nf rsanfs.\x1f\x1f",
	"C ob>qskf ltxyf c|dl\200efs} nf rsanfs.\x1f\x1f",
	"Piqod rliykom bol}yoj el\200 ob>qski.\x1f\x1f\x1f",
	"` nf voxt liyis}r\200 ~soj konufs|.\x1f",
	"Wcfsok eorsasoxno kqaric i bfh\nc|xtqn|v ystxfk.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"Wcfsok eorsasoxno kqaric i bfh\nc|xtqn|v ystxfk.\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"Voqoya\200 m|rl}, no ntgno xso-nibte} mfn}yf\n~soj cfq>cki.",
	"R|q mogfs pqidoeis}r\200. Rnoca.\x1f\x1f\x1f",
	"^so nf ETM. ^so bfhobienof pqikl\177xfnif\nel\200 crfj rfm}i (ea>y} ETM! Ea>y}\nETM!).\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"^so nf ETM. ^so bfhobienof pqikl\177xfnif\nel\200 crfj rfm}i (ea>y} ETM! Ea>y}\nETM!).\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"Nf ntgno oskq|cas} ~sos oqfv.\x1f",
	"^so nf ETM. ^so bfhobienof pqikl\177xfnif\nel\200 crfj rfm}i (ea>y} ETM! Ea>y}\nETM!).\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"Eacajsf tcflixim ~st pqobkt.",
	"I rnoca rtpfqklfj mnf pqidoeilr\200!\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	"Basaqfjki poeoyli!",
	"` pqic\200hal cfq>ckt k xfkf.\x1f",
	"Eobacim pfqxinkt.\x1f\x1f\x1f",
};

// Dialog stack arr
const uint16 dialogStacks[] = {
	0, 1, 2, 3, 4, 0xffff, // 0
	6, 7, 8, 0xffff, // 1
	13, 14, 15, 16, 0xffff, // 2
	18, 19, 20, 21, 0xffff, // 3
	22, 23, 0xffff, // 4
	25, 26, 0xffff, // 5
	27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 0xffff, // 6
	39, 40, 0xffff, // 7
	41, 42, 0xffff, // 8
	48, 49, 0xffff, // 9
	58, 59, 0xffff, // 10
	65, 66, 67, 68, 69, 0xffff, // 11
	78, 79, 80, 81, 0xffff, // 12
	82, 83, 0xffff, // 13
	101, 102, 103, 104, 0xffff, // 14
	105, 106, 107, 0xffff, // 15
	131, 132, 133, 134, 0xffff, // 16
	135, 136, 137, 138, 139, 0xffff, // 17
	140, 141, 142, 143, 0xffff, // 18
	145, 146, 0xffff, // 19
	151, 152, 153, 154, 155, 0xffff, // 20
	169, 170, 171, 172, 0xffff, // 21
	173, 174, 175, 0xffff, // 22
	187, 188, 189, 0xffff, // 23
	158, 159, 160, 0xffff, // 24
	190, 191, 0xffff, // 25
};

// Dialog Strings Block

#define ANIM_WAIT        "\xff"
#define NEW_LINE         "\n"
#define DISPLAY_MESSAGE  "\n\n"
#define CHANGE_CHARACTER "\n\n\n"
#define END_DIALOG       "\n\n\n\n"

const uint kNumDialogs = 213;

const static char *englishDialog0[] = {
	ANIM_WAIT,
	"Good day.",
	CHANGE_CHARACTER,
	"Yeah.",
	CHANGE_CHARACTER,
	"Why are you standing here?",
	CHANGE_CHARACTER,
	"It's a question of gravitation.",
	CHANGE_CHARACTER,
	"Extremely funny joke.",
	DISPLAY_MESSAGE,
	"For a soldier.",
	CHANGE_CHARACTER,
	"I'm not a soldier, although I tried",
	NEW_LINE,
	"to be.",
	DISPLAY_MESSAGE,
	"I didn't pass the intell...",
	NEW_LINE,
	"the physical test.",
	DISPLAY_MESSAGE,
	"They ordered me to shoot at",
	NEW_LINE,
	"a thrown coin when jumping",
	NEW_LINE,
	"from the tree onto a horse.",
	CHANGE_CHARACTER,
	"Yep, that seems hard.",
	CHANGE_CHARACTER,
	"Special Forces ain't a piece of cake,",
	NEW_LINE,
	"you know.",
	CHANGE_CHARACTER,
	"I'm sorry you didn't make it.",
	CHANGE_CHARACTER,
	"Yeah, I missed the horse.",
	END_DIALOG
};

const static char *englishDialog1[] = {
	"So...",
	DISPLAY_MESSAGE,
	"What are you doing now?",
	CHANGE_CHARACTER,
	"Wanna hear a funny answer?",
	CHANGE_CHARACTER,
	"Please don't bother.",
	CHANGE_CHARACTER,
	"All right, but you know, there's not much",
	NEW_LINE,
	"entertainment here.",
	DISPLAY_MESSAGE,
	"Sometimes I like to joke a bit.",
	NEW_LINE,
	"Or a byte, heh-heh!",
	CHANGE_CHARACTER,
	"Well then...",
	CHANGE_CHARACTER,
	"I'm guarding this place...",
	CHANGE_CHARACTER,
	"Wow. That's a surprise.",
	CHANGE_CHARACTER,
	"...And I'm told to kill ANYBODY",
	NEW_LINE,
	"who tries to get in.",
	CHANGE_CHARACTER,
	"What about the owner?",
	CHANGE_CHARACTER,
	"He's not just ANYBODY, you know.",
	CHANGE_CHARACTER,
	"I guess you won't let ME in then?",
	CHANGE_CHARACTER,
	"Bingo.",
	CHANGE_CHARACTER,
	"Even if say I please?",
	CHANGE_CHARACTER,
	"No way, kiddo.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"PLEEEEEASE.",
	CHANGE_CHARACTER,
	"Forget it.",
	NEW_LINE,
	"I've got a heart of stone.",
	CHANGE_CHARACTER,
	"Like your brain.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"I don't follow.",
	CHANGE_CHARACTER,
	"Never mind.",
	NEW_LINE,
	"How can I soften your stone heart?",
	CHANGE_CHARACTER,
	"You can't. I'm a really tough guy.",
	DISPLAY_MESSAGE,
	"But come here, I'll give you",
	NEW_LINE,
	"a consolation...",
	END_DIALOG
};

const static char *englishDialog2[] = {
	"Thanks. What is it?",
	CHANGE_CHARACTER,
	"Chocolate candy.",
	DISPLAY_MESSAGE,
	"My employer gave me a few of these",
	NEW_LINE,
	"for lunch and...",
	CHANGE_CHARACTER,
	"Is your employer home?!",
	CHANGE_CHARACTER,
	"Mr. John Noty? Yeah, why?",
	CHANGE_CHARACTER,
	"Oh, nothing...",
	DISPLAY_MESSAGE,
	"John Noty...",
	DISPLAY_MESSAGE,
	"I think I've heard of him...",
	CHANGE_CHARACTER,
	"You should have. He's making big money,",
	NEW_LINE,
	"you know.",
	DISPLAY_MESSAGE,
	"Especially lately...",
	CHANGE_CHARACTER,
	"Yeah?...",
	CHANGE_CHARACTER,
	"Well, I don't know how.",
	DISPLAY_MESSAGE,
	"Maybe it has something to do with",
	NEW_LINE,
	"the mad scientist that came round",
	NEW_LINE,
	"one day...",
	DISPLAY_MESSAGE,
	"Oh, you think you're smart, don't you?!",
	NEW_LINE,
	"Are you a spy?!",
	CHANGE_CHARACTER,
	"Hey, I'm just a common homeboy.",
	DISPLAY_MESSAGE,
	"If you don't wanna talk,",
	NEW_LINE,
	"don't talk.",
	CHANGE_CHARACTER,
	"Mr. Bad Gay told me to watch",
	NEW_LINE,
	"for spies...",
	CHANGE_CHARACTER,
	"Do I really look like a spy?",
	CHANGE_CHARACTER,
	"...And kill them immediately...",
	CHANGE_CHARACTER,
	"Hey, chill...",
	CHANGE_CHARACTER,
	"...And I haven't killed anybody",
	NEW_LINE,
	"for a loooong time...",
	CHANGE_CHARACTER,
	"It's about this candy, isn't it?",
	NEW_LINE,
	"Do you want it back? No problem.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Sorry, I just got carried away.",
	CHANGE_CHARACTER,
	"I understand.",
	NEW_LINE,
	"It's hot around here.",
	CHANGE_CHARACTER,
	"Yeah.",
	END_DIALOG
};

const static char *englishDialog3[] = {
	"Mister guard, I...",
	CHANGE_CHARACTER,
	"Listen, boy.",
	DISPLAY_MESSAGE,
	"A spy or not a spy, it's out of",
	NEW_LINE,
	"the question.",
	DISPLAY_MESSAGE,
	"You won't get in, no matter if you just want",
	NEW_LINE,
	"to visit the place, steal something or",
	NEW_LINE,
	"talk to Mr. John Noty.",
	DISPLAY_MESSAGE,
	"Also you won't make me talk.",
	DISPLAY_MESSAGE,
	"One more try and I'll make a few",
	NEW_LINE,
	"highways for worms.",
	DISPLAY_MESSAGE,
	"In your body.",
	DISPLAY_MESSAGE,
	"Got it?",
	CHANGE_CHARACTER,
	"Got it.",
	END_DIALOG
};

const static char *englishDialog4[] = {
	"Nice suit.",
	CHANGE_CHARACTER,
	"Yeah.",
	END_DIALOG
};

const static char *englishDialog5[] = {
	CHANGE_CHARACTER,
	"Damn!",
	DISPLAY_MESSAGE,
	"It's only you!...",
	END_DIALOG
};

const static char *englishDialog6[] = {
	"Hey!",
	CHANGE_CHARACTER,
	"What?",
	CHANGE_CHARACTER,
	"What's in this bottle?",
	CHANGE_CHARACTER,
	"You can't prove anything!",
	CHANGE_CHARACTER,
	"Something hot, I guess?..",
	CHANGE_CHARACTER,
	"None of your business.",
	CHANGE_CHARACTER,
	"Drinking on duty, huh?",
	CHANGE_CHARACTER,
	"You think you've almost got me,",
	NEW_LINE,
	"don't you?",
	DISPLAY_MESSAGE,
	"Forget it.",
	END_DIALOG
};

const static char *englishDialog7[] = {
	"Hey!",
	CHANGE_CHARACTER,
	"You've seen nothing.",
	DISPLAY_MESSAGE,
	"I'm clean.",
	END_DIALOG
};

const static char *englishDialog8[] = {
	"Hey!",
	CHANGE_CHARACTER,
	"Get lost.",
	END_DIALOG
};

const static char *englishDialog9[] = {
	"What would you say if I gave you some",
	NEW_LINE,
	"gold?...",
	CHANGE_CHARACTER,
	"I'd say thanks.",
	CHANGE_CHARACTER,
	"Would you let me in?",
	CHANGE_CHARACTER,
	"I guess so...",
	CHANGE_CHARACTER,
	"You have to be sure.",
	CHANGE_CHARACTER,
	"OK, I'm sure. I will let you in.",
	CHANGE_CHARACTER,
	"All right. Here we go.",
	END_DIALOG
};

const static char *englishDialog10[] = {
	"Now please open the door.",
	CHANGE_CHARACTER,
	"No way. Now buzz off.",
	CHANGE_CHARACTER,
	"Hey! I gave you the gold, remember?...",
	CHANGE_CHARACTER,
	"What gold?",
	CHANGE_CHARACTER,
	"WHAT GOLD?!?",
	CHANGE_CHARACTER,
	"I don't know nothing 'bout any gold.",
	END_DIALOG
};

const static char *englishDialog11[] = {
	"You... You...",
	CHANGE_CHARACTER,
	"Buzz off.",
	CHANGE_CHARACTER,
	"You said you'd let me in!",
	DISPLAY_MESSAGE,
	"But you've let me down!",
	CHANGE_CHARACTER,
	"Yeah, but I'll let you off.",
	END_DIALOG
};

const static char *englishDialog12[] = {
	"You can't even trust corrupt",
	NEW_LINE,
	"guards these days.",
	END_DIALOG
};

const static char *englishDialog13[] = {
	"Hi.",
	CHANGE_CHARACTER,
	"Hello.",
	CHANGE_CHARACTER,
	"I'm Mark.",
	DISPLAY_MESSAGE,
	"What's your name?",
	CHANGE_CHARACTER,
	"What's my name?",
	CHANGE_CHARACTER,
	"I don't know, you tell me.",
	CHANGE_CHARACTER,
	"Me.",
	CHANGE_CHARACTER,
	"Don't tell me 'me', just say",
	NEW_LINE,
	"your name!",
	CHANGE_CHARACTER,
	"Your na..",
	CHANGE_CHARACTER,
	"Gee!",
	DISPLAY_MESSAGE,
	"What did your dad call you?",
	CHANGE_CHARACTER,
	"Sonny.",
	CHANGE_CHARACTER,
	"Sonny as in the name or sonny",
	NEW_LINE,
	"as in son?",
	CHANGE_CHARACTER,
	"Sonny.",
	CHANGE_CHARACTER,
	"Are you stupid or just rude?",
	CHANGE_CHARACTER,
	"Sonny, I am.",
	CHANGE_CHARACTER,
	"(sigh)",
	END_DIALOG
};

const static char *englishDialog14[] = {
	"Listen, Sonny or whatever.",
	DISPLAY_MESSAGE,
	"What are you trying to do",
	NEW_LINE,
	"with this ball?",
	CHANGE_CHARACTER,
	"Well, grandpa said he'd take",
	NEW_LINE,
	"me to ZOO if I score.",
	CHANGE_CHARACTER,
	"I think you should throw the ball",
	NEW_LINE,
	"a little bit higher.",
	CHANGE_CHARACTER,
	"Yeah, I know.",
	CHANGE_CHARACTER,
	"So?",
	CHANGE_CHARACTER,
	"So what?",
	CHANGE_CHARACTER,
	"So why don't you do it?!",
	CHANGE_CHARACTER,
	"It must be something with",
	NEW_LINE,
	"my eyes.",
	CHANGE_CHARACTER,
	"You should wear glassess?",
	CHANGE_CHARACTER,
	"No, why?",
	CHANGE_CHARACTER,
	"(sigh)",
	DISPLAY_MESSAGE,
	"Maybe you're just too weak to",
	NEW_LINE,
	"send the ball high enough?",
	CHANGE_CHARACTER,
	"No kidding.",
	CHANGE_CHARACTER,
	"(sigh)",
	END_DIALOG
};

const static char *englishDialog15[] = {
	"Hey, kid!",
	DISPLAY_MESSAGE,
	"I've got a great idea!",
	CHANGE_CHARACTER,
	"Yeah?",
	CHANGE_CHARACTER,
	"Go to your grandpa and",
	NEW_LINE,
	"say you've scored!",
	CHANGE_CHARACTER,
	"You mean lie?",
	CHANGE_CHARACTER,
	"Well, sort of...",
	CHANGE_CHARACTER,
	"I NEVER LIE!",
	CHANGE_CHARACTER,
	"Never?!",
	CHANGE_CHARACTER,
	"NEVER!",
	CHANGE_CHARACTER,
	"Good boy.",
	END_DIALOG
};

const static char *englishDialog16[] = {
	"Hey...",
	CHANGE_CHARACTER,
	"Go away.",
	END_DIALOG
};

const static char *englishDialog17[] = {
	"Hey, boy! It's unbelievable!",
	CHANGE_CHARACTER,
	"What?",
	CHANGE_CHARACTER,
	"You might think it's a joke,",
	NEW_LINE,
	"but there's a hand holding",
	NEW_LINE,
	"a sword appearing from the lake!",
	CHANGE_CHARACTER,
	"OK, I'll look but just don't ",
	NEW_LINE,
	"think you've fooled me.",
	NEW_LINE,
	"This hand appears every year.",
	DISPLAY_MESSAGE,
	"Maybe this time will bring me luck",
	NEW_LINE,
	"at basketball...",
	END_DIALOG
};

const static char *englishDialog18[] = {
	"Good day, sir!",
	CHANGE_CHARACTER,
	"And good day to",
	NEW_LINE,
	"you, my son.",
	CHANGE_CHARACTER,
	"My name is Mark, sir.",
	CHANGE_CHARACTER,
	"Great.",
	DISPLAY_MESSAGE,
	"What do you want?",
	CHANGE_CHARACTER,
	"I'm just admiring your arm-chair.",
	DISPLAY_MESSAGE,
	"It's nice.",
	CHANGE_CHARACTER,
	"Nice and pretty",
	NEW_LINE,
	"comfortable.",
	CHANGE_CHARACTER,
	"And big.",
	CHANGE_CHARACTER,
	"2-person model.",
	END_DIALOG
};

const static char *englishDialog19[] = {
	"Do you know the boy",
	NEW_LINE,
	"playing with the ball",
	NEW_LINE,
	"outside?",
	CHANGE_CHARACTER,
	"Of course, he's",
	NEW_LINE,
	"my grandson.",
	CHANGE_CHARACTER,
	"Nice kid.",
	CHANGE_CHARACTER,
	"Nice and smart.",
	CHANGE_CHARACTER,
	"Nice and small.",
	CHANGE_CHARACTER,
	"He'll grow.",
	CHANGE_CHARACTER,
	"And become a very",
	NEW_LINE,
	"famous basketball",
	NEW_LINE,
	"player?...",
	CHANGE_CHARACTER,
	"I hope he won't.",
	CHANGE_CHARACTER,
	"Then tell him to stop playing!",
	CHANGE_CHARACTER,
	"Yeah.",
	DISPLAY_MESSAGE,
	"Later.",
	DISPLAY_MESSAGE,
	"Maybe.",
	DISPLAY_MESSAGE,
	"Right now I need",
	NEW_LINE,
	"some rest.",
	END_DIALOG
};

const static char *englishDialog20[] = {
	"Are you going to sit here",
	NEW_LINE,
	"all day long?",
	CHANGE_CHARACTER,
	"Hope so.",
	CHANGE_CHARACTER,
	"For all of this beautiful day?",
	CHANGE_CHARACTER,
	"Hope so.",
	CHANGE_CHARACTER,
	"Aren't you interested",
	NEW_LINE,
	"in the outside world?!",
	CHANGE_CHARACTER,
	"Not really.",
	CHANGE_CHARACTER,
	"Why's that?",
	CHANGE_CHARACTER,
	"I'm not interested",
	NEW_LINE,
	"in news.",
	CHANGE_CHARACTER,
	"But...",
	CHANGE_CHARACTER,
	"As they say...",
	DISPLAY_MESSAGE,
	"The best news",
	NEW_LINE,
	"is no news.",
	CHANGE_CHARACTER,
	"But people must know about",
	NEW_LINE,
	"progress and stuff!",
	CHANGE_CHARACTER,
	"I won't even bother",
	NEW_LINE,
	"to ask you why...",
	CHANGE_CHARACTER,
	"Because...",
	DISPLAY_MESSAGE,
	"Er...",
	DISPLAY_MESSAGE,
	"Because...",
	DISPLAY_MESSAGE,
	"Uhm...",
	CHANGE_CHARACTER,
	"Right.",
	NEW_LINE,
	"    ",
	END_DIALOG
};

const static char *englishDialog21[] = {
	"Anything new?",
	CHANGE_CHARACTER,
	"Hope not.",
	END_DIALOG
};

const static char *englishDialog22[] = {
	"May I borrow this shotgun?",
	CHANGE_CHARACTER,
	"No.",
	CHANGE_CHARACTER,
	"Pleeeease...",
	CHANGE_CHARACTER,
	"Young man, this weapon is",
	NEW_LINE,
	"very old and dangerous...",
	DISPLAY_MESSAGE,
	"and I'm a responsible man,",
	NEW_LINE,
	"got it?",
	CHANGE_CHARACTER,
	"But I will...",
	CHANGE_CHARACTER,
	"No.",
	END_DIALOG
};

const static char *englishDialog23[] = {
	"Maybe you will change your mind",
	NEW_LINE,
	"about the shotgun?...",
	CHANGE_CHARACTER,
	"No.",
	DISPLAY_MESSAGE,
	"Nope.",
	DISPLAY_MESSAGE,
	"Niet.",
	DISPLAY_MESSAGE,
	"Nein.",
	DISPLAY_MESSAGE,
	"Niente.",
	DISPLAY_MESSAGE,
	"Nie.",
	DISPLAY_MESSAGE,
	"Ne.",
	CHANGE_CHARACTER,
	"OK, I got it.",
	END_DIALOG
};

const static char *englishDialog24[] = {
	"May I search your drawers?",
	CHANGE_CHARACTER,
	"Yes.",
	CHANGE_CHARACTER,
	"YES?!?",
	CHANGE_CHARACTER,
	"Oh, I forgot to tell you they are all",
	NEW_LINE,
	"empty.",
	DISPLAY_MESSAGE,
	"Only the right upper one has a handkerchief",
	NEW_LINE,
	"in it.",
	DISPLAY_MESSAGE,
	"You can take if you want, I don't need it.",
	CHANGE_CHARACTER,
	"Well, thank you.",
	DISPLAY_MESSAGE,
	"You are very... kind...",
	CHANGE_CHARACTER,
	"Just don't think I let you take",
	NEW_LINE,
	"anything else.",
	CHANGE_CHARACTER,
	"Of course, I wouldn't even dream.",
	END_DIALOG
};

const static char *englishDialog25[] = {
	"May I borrow the fan?",
	CHANGE_CHARACTER,
	"No way. It makes this hot day more",
	NEW_LINE,
	"bearable.",
	END_DIALOG
};

const static char *englishDialog26[] = {
	"About this fan...",
	CHANGE_CHARACTER,
	"Come back in winter.",
	END_DIALOG
};

const static char *englishDialog27[] = {
	"Nice weather we have",
	NEW_LINE,
	"today...",
	CHANGE_CHARACTER,
	"Indeed it is,",
	NEW_LINE,
	"my dear.",
	END_DIALOG
};

const static char *englishDialog28[] = {
	"Is it your daughter?",
	CHANGE_CHARACTER,
	"You are very kind,",
	NEW_LINE,
	"my dear, making",
	NEW_LINE,
	"me so young,",
	DISPLAY_MESSAGE,
	"but of course",
	NEW_LINE,
	"that sweetie is my",
	NEW_LINE,
	"grand-daughter.",
	CHANGE_CHARACTER,
	"Oh, yes! She really",
	NEW_LINE,
	"looks grand!",
	CHANGE_CHARACTER,
	"Well, I was once",
	NEW_LINE,
	"like that...",
	CHANGE_CHARACTER,
	"But you still are!",
	CHANGE_CHARACTER,
	"How sweet of you...",
	DISPLAY_MESSAGE,
	"But nobody sings",
	NEW_LINE,
	"at my window",
	NEW_LINE,
	"anymore,",
	DISPLAY_MESSAGE,
	"if you know",
	NEW_LINE,
	"what I mean.",
	CHANGE_CHARACTER,
	"Errr...",
	DISPLAY_MESSAGE,
	"Yes...",
	DISPLAY_MESSAGE,
	"I know...",
	DISPLAY_MESSAGE,
	"I have similar",
	NEW_LINE,
	"feelings myself...",
	DISPLAY_MESSAGE,
	"Sometimes...",
	DISPLAY_MESSAGE,
	"I guess...",
	END_DIALOG
};

const static char *englishDialog29[] = {
	"May I ask what you are",
	NEW_LINE,
	"doing?",
	CHANGE_CHARACTER,
	"Yes, you may,",
	NEW_LINE,
	"my dear.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"What are you doing?",
	CHANGE_CHARACTER,
	"I'm knitting.",
	CHANGE_CHARACTER,
	"I understand.",
	DISPLAY_MESSAGE,
	"What are you knitting?",
	CHANGE_CHARACTER,
	"This time you",
	NEW_LINE,
	"didn't ask if",
	NEW_LINE,
	"you may ask.",
	CHANGE_CHARACTER,
	"Oh, sorry. May I ask?",
	CHANGE_CHARACTER,
	"Ask about what?",
	CHANGE_CHARACTER,
	"About what are you",
	NEW_LINE,
	"knitting.",
	CHANGE_CHARACTER,
	"You asked me",
	NEW_LINE,
	"about that before,",
	NEW_LINE,
	"didn't you?",
	END_DIALOG
};

const static char *englishDialog30[] = {
	"Is everything OK?",
	CHANGE_CHARACTER,
	"Indeed it is.",
	END_DIALOG
};

const static char *englishDialog31[] = {
	"Is everything OK?",
	CHANGE_CHARACTER,
	"You know.",
	END_DIALOG
};

const static char *englishDialog32[] = {
	"Is everything OK?",
	CHANGE_CHARACTER,
	"It's nice you ask,",
	NEW_LINE,
	"but I've told you",
	NEW_LINE,
	"already.",
	END_DIALOG
};

const static char *englishDialog33[] = {
	"Is everything OK?",
	CHANGE_CHARACTER,
	"Don't repeat",
	NEW_LINE,
	"yourself.",
	END_DIALOG
};

const static char *englishDialog34[] = {
	"Is everything OK?",
	CHANGE_CHARACTER,
	"Don't interrupt",
	NEW_LINE,
	"my work.",
	END_DIALOG
};

const static char *englishDialog35[] = {
	"Is everything OK?",
	CHANGE_CHARACTER,
	"Oh shut up.",
	END_DIALOG
};

const static char *englishDialog36[] = {
	"Is everything OK?",
	END_DIALOG
};

const static char *englishDialog37[] = {
	"Excuse my",
	NEW_LINE,
	"immodesty...",
	CHANGE_CHARACTER,
	"Yes?...",
	CHANGE_CHARACTER,
	"...but I thought",
	NEW_LINE,
	"that an innocent",
	NEW_LINE,
	"flower...",
	DISPLAY_MESSAGE,
	"...would express",
	NEW_LINE,
	"my happiness at",
	NEW_LINE,
	"meeting you.",
	END_DIALOG
};

const static char *englishDialog38[] = {
	"I hope you",
	NEW_LINE,
	"like it...",
	CHANGE_CHARACTER,
	"Oh, dear!",
	DISPLAY_MESSAGE,
	"I'm really",
	NEW_LINE,
	"touched...",
	DISPLAY_MESSAGE,
	"That's the nicest",
	NEW_LINE,
	"thing anybody has",
	NEW_LINE,
	"done for me...",
	DISPLAY_MESSAGE,
	"...in last ten",
	NEW_LINE,
	"years!",
	DISPLAY_MESSAGE,
	"Thank you from all",
	NEW_LINE,
	"my heart!",
	CHANGE_CHARACTER,
	"You're welcome.",
	END_DIALOG
};

const static char *englishDialog39[] = {
	"Would you care for",
	NEW_LINE,
	"another flower?",
	CHANGE_CHARACTER,
	"You're very kind,",
	NEW_LINE,
	"my boy, but no,",
	NEW_LINE,
	"thank you.",
	END_DIALOG
};

const static char *englishDialog40[] = {
	"Are you sure you don't",
	NEW_LINE,
	"want another flower?",
	CHANGE_CHARACTER,
	"Yes. I'm sure.",
	END_DIALOG
};

const static char *englishDialog41[] = {
	"May I borrow this",
	NEW_LINE,
	"duster?",
	CHANGE_CHARACTER,
	"We don't know each",
	NEW_LINE,
	"other too well, and",
	NEW_LINE,
	"I don't...",
	DISPLAY_MESSAGE,
	"...lend things to",
	NEW_LINE,
	"anybody who asks",
	NEW_LINE,
	"for them.",
	CHANGE_CHARACTER,
	"Don't I look reliable?",
	CHANGE_CHARACTER,
	"I've said enough.",
	END_DIALOG
};

const static char *englishDialog42[] = {
	"Any chances to borrow the",
	NEW_LINE,
	"feather duster?",
	CHANGE_CHARACTER,
	"I like it where it is.",
	END_DIALOG
};

const static char *englishDialog43[] = {
	"Do you think you could",
	NEW_LINE,
	"lend me the feather duster",
	NEW_LINE,
	"now?",
	CHANGE_CHARACTER,
	"But of course, I can't",
	NEW_LINE,
	"see why I shouldn't...",
	DISPLAY_MESSAGE,
	"...help to such a nice",
	NEW_LINE,
	"young man like you!..",
	CHANGE_CHARACTER,
	"Thank you very much.",
	END_DIALOG
};

const static char *englishDialog44[] = {
	"Ha! I'm even faster than Indy`!",
	CHANGE_CHARACTER,
	"I've seen it all, boy!",
	END_DIALOG
};

const static char *englishDialog45[] = {
	"Er...",
	DISPLAY_MESSAGE,
	"Uh...",
	DISPLAY_MESSAGE,
	"I just...",
	CHANGE_CHARACTER,
	"Don't worry. I hope you killed",
	NEW_LINE,
	"that fly.",
	END_DIALOG
};

const static char *englishDialog46[] = {
	"Excuse me, lady, but I think your",
	NEW_LINE,
	"laundry is dry now...",
	DISPLAY_MESSAGE,
	"...and too much sun will distort",
	NEW_LINE,
	"the clothes...",
	CHANGE_CHARACTER,
	"How come the laundry dried",
	NEW_LINE,
	"out so fast?",
	DISPLAY_MESSAGE,
	"I'd better go and check it.",
	END_DIALOG
};

const static char *englishDialog47[] = {
	CHANGE_CHARACTER,
	"You were right, young man.",
	DISPLAY_MESSAGE,
	"Thank you.",
	CHANGE_CHARACTER,
	"You're welcome.",
	END_DIALOG
};

const static char *englishDialog48[] = {
	"Do you need this fake apple?",
	CHANGE_CHARACTER,
	"It depends. This apple",
	NEW_LINE,
	"has its own story.",
	DISPLAY_MESSAGE,
	"I remember how one day",
	NEW_LINE,
	"my younger sister Mary",
	NEW_LINE,
	"was making...",
	CHANGE_CHARACTER,
	"Er, how long is the story?",
	CHANGE_CHARACTER,
	"Oh, there's no need to rush.",
	DISPLAY_MESSAGE,
	"We do have hours to talk,",
	NEW_LINE,
	"don't we?",
	CHANGE_CHARACTER,
	"I just realised I don't need that",
	NEW_LINE,
	"apple.",
	DISPLAY_MESSAGE,
	"Thanks.",
	END_DIALOG
};

const static char *englishDialog49[] = {
	"This apple...",
	CHANGE_CHARACTER,
	"No story, no apple.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"No apple.",
	END_DIALOG
};

const static char *englishDialog50[] = {
	"Could she be...",
	DISPLAY_MESSAGE,
	"...the most beautiful girl...",
	DISPLAY_MESSAGE,
	"in the world?...",
	END_DIALOG
};

const static char *englishDialog51[] = {
	"I think it's high time to",
	NEW_LINE,
	"introduce myself.",
	DISPLAY_MESSAGE,
	"I'm Mark.",
	CHANGE_CHARACTER,
	"Anne.",
	END_DIALOG
};

const static char *englishDialog52[] = {
	"The moment I saw those eyes",
	NEW_LINE,
	"was the best moment of my entire",
	NEW_LINE,
	"life.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Not counting the time",
	NEW_LINE,
	"I played doctor with",
	NEW_LINE,
	"Susie.",
	END_DIALOG
};

const static char *englishDialog53[] = {
	"Uh...",
	DISPLAY_MESSAGE,
	"Er...",
	DISPLAY_MESSAGE,
	"I wonder...",
	DISPLAY_MESSAGE,
	"I wonder if",
	NEW_LINE,
	"you would like",
	NEW_LINE,
	"to get some...",
	DISPLAY_MESSAGE,
	"Er...",
	DISPLAY_MESSAGE,
	"I mean...",
	DISPLAY_MESSAGE,
	"I have something",
	NEW_LINE,
	"I would like to give",
	NEW_LINE,
	"you, because...",
	DISPLAY_MESSAGE,
	"Uh...",
	DISPLAY_MESSAGE,
	"I think you",
	NEW_LINE,
	"are... And...",
	CHANGE_CHARACTER,
	"Hey! I don't bite!",
	DISPLAY_MESSAGE,
	"I see you want to tell me",
	NEW_LINE,
	"something nice.",
	DISPLAY_MESSAGE,
	"Just use simple",
	NEW_LINE,
	"words...",
	CHANGE_CHARACTER,
	"Simple words?!",
	CHANGE_CHARACTER,
	"Yes, simple words make",
	NEW_LINE,
	"things simple.",
	CHANGE_CHARACTER,
	"Oh, yes.",
	DISPLAY_MESSAGE,
	"OK.",
	DISPLAY_MESSAGE,
	"Simple words.",
	DISPLAY_MESSAGE,
	"OK.",
	DISPLAY_MESSAGE,
	"Here I go.",
	DISPLAY_MESSAGE,
	"Me like you and",
	NEW_LINE,
	"want give flower.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Well, maybe you should",
	NEW_LINE,
	"try something...",
	DISPLAY_MESSAGE,
	"...more complicated.",
	CHANGE_CHARACTER,
	"Uh...",
	DISPLAY_MESSAGE,
	"Sorry...",
	DISPLAY_MESSAGE,
	"I just...",
	DISPLAY_MESSAGE,
	"I just brought you",
	NEW_LINE,
	"a flower.",
	CHANGE_CHARACTER,
	"Oh?...",
	END_DIALOG
};

const static char *englishDialog54[] = {
	"Do you like it?",
	CHANGE_CHARACTER,
	"You're charming.",
	END_DIALOG
};

const static char *englishDialog55[] = {
	"As a matter",
	NEW_LINE,
	"of fact...",
	CHANGE_CHARACTER,
	"Simple words, boy!",
	NEW_LINE,
	"Simple words!",
	END_DIALOG
};

const static char *englishDialog56[] = {
	"Oh,yes...",
	DISPLAY_MESSAGE,
	"I just wanted to say",
	NEW_LINE,
	"that you're charming",
	NEW_LINE,
	"too.",
	CHANGE_CHARACTER,
	"I guess I should say",
	NEW_LINE,
	"thanks.",
	END_DIALOG
};

const static char *englishDialog57[] = {
	"I hate myself.",
	END_DIALOG
};

const static char *englishDialog58[] = {
	"I have another",
	NEW_LINE,
	"flower...",
	CHANGE_CHARACTER,
	"Oh, let's not",
	NEW_LINE,
	"exaggerate.",
	DISPLAY_MESSAGE,
	"And, as you can see, I'm",
	NEW_LINE,
	"not the only...",
	DISPLAY_MESSAGE,
	"...woman in this room...",
	END_DIALOG
};

const static char *englishDialog59[] = {
	"So you don't want",
	NEW_LINE,
	"another flower?",
	CHANGE_CHARACTER,
	"No, thank you.",
	END_DIALOG
};

const static char *englishDialog60[] = {
	"Would you like some candy?",
	CHANGE_CHARACTER,
	"You're nice, but no, thanks.",
	NEW_LINE,
	"I don't want to get fat.",
	CHANGE_CHARACTER,
	"Hey, don't worry. Even Obelix",
	NEW_LINE,
	"has friends.",
	CHANGE_CHARACTER,
	"Who's Obelix?!",
	CHANGE_CHARACTER,
	"Er, never mind. It's just that I found",
	NEW_LINE,
	"this candy...",
	CHANGE_CHARACTER,
	"You FOUND IT?!",
	CHANGE_CHARACTER,
	"...I found it's pretty hard to get,",
	NEW_LINE,
	"of course.",
	DISPLAY_MESSAGE,
	"It's not some cheap pseudo-chocolate,",
	NEW_LINE,
	"but the highest quality goodie!",
	DISPLAY_MESSAGE,
	"It's made only from the things you",
	NEW_LINE,
	"can find in a natural environment.",
	DISPLAY_MESSAGE,
	"No preservatives added.",
	CHANGE_CHARACTER,
	"Oh, all right. If you insist...",
	END_DIALOG
};

const static char *englishDialog61[] = {
	ANIM_WAIT,
	"Khm...",
	CHANGE_CHARACTER,
	"Oh yes, I think I should give you",
	NEW_LINE,
	"something in return...",
	CHANGE_CHARACTER,
	"Oh, no... You really don't",
	NEW_LINE,
	"have to...",
	CHANGE_CHARACTER,
	"OK. Your wish.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Well, on second thoughts...",
	CHANGE_CHARACTER,
	"I knew it. You boys always want",
	NEW_LINE,
	"something.",
	DISPLAY_MESSAGE,
	"You can't do anything for",
	NEW_LINE,
	"free.",
	CHANGE_CHARACTER,
	"I cleaned my room once.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Well...",
	DISPLAY_MESSAGE,
	"Let's forget it.",
	DISPLAY_MESSAGE,
	"Here's my present for",
	NEW_LINE,
	"you.",
	DISPLAY_MESSAGE,
	"It's my ribbon. Think of me",
	NEW_LINE,
	"sometimes.",
	END_DIALOG
};

const static char *englishDialog62[] = {
	"Thanks. I will never",
	NEW_LINE,
	"wash it.",
	END_DIALOG
};

const static char *englishDialog63[] = {
	"I found your name on a banknote",
	NEW_LINE,
	"some fatso gave me. Do you know",
	NEW_LINE,
	"anything about it?",
	CHANGE_CHARACTER,
	"Show me the banknote.",
	END_DIALOG
};

const static char *englishDialog64[] = {
	"Hey, what's up?!",
	CHANGE_CHARACTER,
	"Oh, poor me!...",
	CHANGE_CHARACTER,
	"Why are you crying?!",
	CHANGE_CHARACTER,
	"This... this...",
	DISPLAY_MESSAGE,
	"Oh, poor me!...",
	DISPLAY_MESSAGE,
	"Our... our neighbour, Mr.",
	NEW_LINE,
	"John Noty gave me some",
	NEW_LINE,
	"money one day...",
	DISPLAY_MESSAGE,
	"...and said that if I gave",
	NEW_LINE,
	"him a kiss he'd give",
	NEW_LINE,
	"me more...",
	DISPLAY_MESSAGE,
	"...but I thought it over",
	NEW_LINE,
	"and I gave him all the",
	NEW_LINE,
	"money back.",
	CHANGE_CHARACTER,
	"You mean, that pig tried",
	NEW_LINE,
	"to buy you?!",
	CHANGE_CHARACTER,
	"I'm so unhappy!",
	CHANGE_CHARACTER,
	"Oh, man! That",
	NEW_LINE,
	"does it!",
	END_DIALOG
};

const static char *englishDialog65[] = {
	"Hey, you!",
	DISPLAY_MESSAGE,
	"Would you please give me that nut",
	NEW_LINE,
	"lying next to you?",
	END_DIALOG
};

const static char *englishDialog66[] = {
	"Are you gonna give me that nut or not?!",
	END_DIALOG
};

const static char *englishDialog67[] = {
	"All right.",
	DISPLAY_MESSAGE,
	"That's it.",
	DISPLAY_MESSAGE,
	"Now you'll get what you deserve.",
	DISPLAY_MESSAGE,
	"I'm gonna insult you until I get that nut.",
	DISPLAY_MESSAGE,
	"You ugly squirrel you.",
	END_DIALOG
};

const static char *englishDialog68[] = {
	"Don't you know it's not politically",
	NEW_LINE,
	"correct to wear a fur?",
	END_DIALOG
};

const static char *englishDialog69[] = {
	"Hey, thanks again for the nut.",
	END_DIALOG
};

const static char *englishDialog70[] = {
	"I didn't ask if I could take the rope.",
	DISPLAY_MESSAGE,
	"It's really rude to take someone else's",
	NEW_LINE,
	"property without their permission.",
	DISPLAY_MESSAGE,
	"And I might get caught, of",
	NEW_LINE,
	"course.",
	DISPLAY_MESSAGE,
	"And they will put me in jail and",
	NEW_LINE,
	"nobody will respect me anymore.",
	DISPLAY_MESSAGE,
	"I could really ruin my life doing that.",
	END_DIALOG
};

const static char *englishDialog71[] = {
	"No pain no gain.",
	END_DIALOG
};

const static char *englishDialog72[] = {
	"Listen, guys. I want you to get",
	NEW_LINE,
	"outta here at once!",
	DISPLAY_MESSAGE,
	"Or I'll have to shoot.",
	DISPLAY_MESSAGE,
	"With a real gun.",
	DISPLAY_MESSAGE,
	"I think.",
	END_DIALOG
};

const static char *englishDialog73[] = {
	"I can see...",
	DISPLAY_MESSAGE,
	"...there's a...",
	DISPLAY_MESSAGE,
	"SPIDER!!!",
	END_DIALOG
};

const static char *englishDialog74[] = {
	"Not that I'm chicken.",
	DISPLAY_MESSAGE,
	"It's just that it could be",
	NEW_LINE,
	"a mutant spider and it",
	NEW_LINE,
	"could bite me...",
	DISPLAY_MESSAGE,
	"...and I'd get mutant too...",
	DISPLAY_MESSAGE,
	"...and I'd have to wear those",
	NEW_LINE,
	"funny gloves and stuff...",
	DISPLAY_MESSAGE,
	"...and I'd have a double life...",
	DISPLAY_MESSAGE,
	"...and I'd have to fight with Venom`",
	NEW_LINE,
	"and others and I might get hurt...",
	DISPLAY_MESSAGE,
	"...and everybody would be making",
	NEW_LINE,
	"money on me but me...",
	DISPLAY_MESSAGE,
	"I think I'll pass then.",
	END_DIALOG
};

const static char *englishDialog75[] = {
	"This spider gives me thrills...",
	END_DIALOG
};

const static char *englishDialog76[] = {
	"Hey, little buddy!",
	DISPLAY_MESSAGE,
	"I've got a DECENT PROPOSAL for you.",
	DISPLAY_MESSAGE,
	"A big, fresh and juicy apple for this old cone",
	NEW_LINE,
	"which presses your back.",
	DISPLAY_MESSAGE,
	"If you want to make a deal, stand here",
	NEW_LINE,
	"and shake your muzzle.",
	END_DIALOG
};

const static char *englishDialog77[] = {
	"I should have know",
	NEW_LINE,
	"there's a catch.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"The paddle is broken.",
	END_DIALOG
};

const static char *englishDialog78[] = {
	"Hello there, big boy.",
	END_DIALOG
};

const static char *englishDialog79[] = {
	"Don't ignore me, please.",
	END_DIALOG
};

const static char *englishDialog80[] = {
	"You know, I'm a little bit dog-tired",
	NEW_LINE,
	"talking to you.",
	END_DIALOG
};

const static char *englishDialog81[] = {
	"What's up?",
	END_DIALOG
};

const static char *englishDialog82[] = {
	"Yes, I could take this...",
	DISPLAY_MESSAGE,
	"It's a quiet little village...",
	DISPLAY_MESSAGE,
	"No police...",
	DISPLAY_MESSAGE,
	"No one will hear their screams...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"But I don't have a hockey mask.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"(sigh)",
	END_DIALOG
};

const static char *englishDialog83[] = {
	"I don't want my fingerprints on it.",
	DISPLAY_MESSAGE,
	" Who knows what it was used for.",
	END_DIALOG
};

const static char *englishDialog84[] = {
	"I'm afraid that it's too hard",
	NEW_LINE,
	"to catch a mouse just like",
	NEW_LINE,
	"that.",
	DISPLAY_MESSAGE,
	"And what challenge would it be?",
	END_DIALOG
};

const static char *englishDialog85[] = {
	"I could try to scare these birds myself",
	NEW_LINE,
	"if I hadn't watched that Hitchcock",
	NEW_LINE,
	"movie when I was five.",
	DISPLAY_MESSAGE,
	"My mum should never let me watch that.",
	DISPLAY_MESSAGE,
	"Now I'm CHICKEN even when I eat eggs.",
	END_DIALOG
};

const static char *englishDialog86[] = {
	"Great. Let's GET THE MESSAGE.",
	DISPLAY_MESSAGE,
	"\"Gold awaits at the end of the road.\"",
	END_DIALOG
};

const static char *englishDialog87[] = {
	"Are you Mr. John Noty?",
	CHANGE_CHARACTER,
	"How do you do, my friend.",
	DISPLAY_MESSAGE,
	"My people told me you tried",
	NEW_LINE,
	"to get inside my mansion.",
	NEW_LINE,
	"Why?",
	CHANGE_CHARACTER,
	"Er... You see...",
	DISPLAY_MESSAGE,
	"I'm here to...",
	NEW_LINE,
	"To...",
	DISPLAY_MESSAGE,
	"I mean, I'm here on my vacations,",
	NEW_LINE,
	"but I got sick of all these green",
	NEW_LINE,
	"plants and trees around...",
	DISPLAY_MESSAGE,
	"...and I just wanted to lick some",
	NEW_LINE,
	"civilisation.",
	CHANGE_CHARACTER,
	"Well... I can understand you,",
	NEW_LINE,
	"my friend.",
	DISPLAY_MESSAGE,
	"I also think that the natural",
	NEW_LINE,
	"environment for us, people",
	NEW_LINE,
	"of 20th century...",
	DISPLAY_MESSAGE,
	"is TV and a bag of pop-corn.",
	NEW_LINE,
	"But talking about the green",
	NEW_LINE,
	"stuff...",
	DISPLAY_MESSAGE,
	"I can't allow you to enter",
	NEW_LINE,
	"my house, because... uhm...",
	NEW_LINE,
	"because it's ...being...",
	DISPLAY_MESSAGE,
	"...under renovation, but as",
	NEW_LINE,
	"a rich man I'll give you",
	NEW_LINE,
	"a hundred bucks...",
	DISPLAY_MESSAGE,
	"so you can buy yourself",
	NEW_LINE,
	"something that will help",
	NEW_LINE,
	"you survive here.",
	DISPLAY_MESSAGE,
	"A walkman for example.",
	NEW_LINE,
	"What do you say?",
	CHANGE_CHARACTER,
	"What do you take me for?!",
	END_DIALOG
};

const static char *englishDialog88[] = {
	"I will NEVER take this!",
	DISPLAY_MESSAGE,
	"NEVER!",
	CHANGE_CHARACTER,
	"Don't get so excited.",
	DISPLAY_MESSAGE,
	"Pecunia non olet.",
	DISPLAY_MESSAGE,
	"I'll leave now. Don't be shy",
	NEW_LINE,
	"and pick up the banknote.",
	DISPLAY_MESSAGE,
	"No one has to know...",
	DISPLAY_MESSAGE,
	"Good bye, my friend.",
	END_DIALOG
};

const static char *englishDialog89[] = {
	"I can't believe he treated me",
	NEW_LINE,
	"like that.",
	DISPLAY_MESSAGE,
	"By the way...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Peculiar non omelette?...",
	END_DIALOG
};

const static char *englishDialog90[] = {
	"Boy...",
	DISPLAY_MESSAGE,
	"It's all black...",
	DISPLAY_MESSAGE,
	"...and it looks like a man...",
	DISPLAY_MESSAGE,
	"...with some long pole...",
	DISPLAY_MESSAGE,
	"...and a pot on its head...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"VGA artist shouldn't drink so much.",
	END_DIALOG
};

const static char *englishDialog91[] = {
	"Searching trash cans again?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Oh, all right, there are only some",
	NEW_LINE,
	"papers.",
	END_DIALOG
};

const static char *englishDialog92[] = {
	"The same as usual...",
	DISPLAY_MESSAGE,
	"Disasters...",
	DISPLAY_MESSAGE,
	"Corruption...",
	DISPLAY_MESSAGE,
	"Murders...",
	DISPLAY_MESSAGE,
	"Puzzle...",
	DISPLAY_MESSAGE,
	"Half-naked babes...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"I gotta subscribe.",
	END_DIALOG
};

const static char *englishDialog93[] = {
	ANIM_WAIT,
	"Gee...",
	CHANGE_CHARACTER,
	"...I'm daaaancing...",
	DISPLAY_MESSAGE,
	"...and siiiinging...",
	CHANGE_CHARACTER,
	"It's John Noty...",
	CHANGE_CHARACTER,
	"...raaain!...",
	CHANGE_CHARACTER,
	"...singing to the camera!",
	CHANGE_CHARACTER,
	"...what a beaaaaautifuuuul...",
	CHANGE_CHARACTER,
	"Although he definitely shouldn't.",
	CHANGE_CHARACTER,
	"...feeeliiing...",
	CHANGE_CHARACTER,
	"I can't believe it.",
	CHANGE_CHARACTER,
	"...haaaappy agaaain!..",
	CHANGE_CHARACTER,
	"What a horror.",
	CHANGE_CHARACTER,
	"...just daaancing in the raaain...",
	CHANGE_CHARACTER,
	"My neighbour's dog will do it better.",
	CHANGE_CHARACTER,
	"...la, laaaaa!...",
	CHANGE_CHARACTER,
	"I've had enough.",
	CHANGE_CHARACTER,
	"...la, la! La, laaaa....",
	END_DIALOG
};

const static char *englishDialog94[] = {
	"There's nothing intere...",
	DISPLAY_MESSAGE,
	"No, wait a minute...",
	DISPLAY_MESSAGE,
	"There's something under the couch!",
	END_DIALOG
};

const static char *englishDialog95[] = {
	"Don't you think you",
	NEW_LINE,
	"should add a little",
	NEW_LINE,
	"bit of chilli?",
	CHANGE_CHARACTER,
	"Add?",
	DISPLAY_MESSAGE,
	"Why?",
	CHANGE_CHARACTER,
	"I see you're not happy",
	NEW_LINE,
	"with the stew you're",
	NEW_LINE,
	"cooking.",
	DISPLAY_MESSAGE,
	"Maybe you should try",
	NEW_LINE,
	"to spice it up a",
	NEW_LINE,
	"little?",
	CHANGE_CHARACTER,
	"Well...",
	DISPLAY_MESSAGE,
	"That's good idea.",
	DISPLAY_MESSAGE,
	"Luckily I've got something here.",
	END_DIALOG
};

const static char *englishDialog96[] = {
	CHANGE_CHARACTER,
	"This... hic!...",
	DISPLAY_MESSAGE,
	"This chilllllleeeeee... hep!",
	DISPLAY_MESSAGE,
	"...must have been...",
	DISPLAY_MESSAGE,
	"...fermented...",
	DISPLAY_MESSAGE,
	"The stew yyys spoiled aaand...",
	DISPLAY_MESSAGE,
	"...I'm fired!",
	DISPLAY_MESSAGE,
	"Hic!",
	END_DIALOG
};

const static char *englishDialog97[] = {
	"I don't need this radio, but",
	NEW_LINE,
	"I can use its batteries.",
	DISPLAY_MESSAGE,
	"Unfortunately I never know",
	NEW_LINE,
	"where to open those Japanese",
	NEW_LINE,
	"babies.",
	END_DIALOG
};

const static char *englishDialog98[] = {
	CHANGE_CHARACTER,
	"Security test: voice, scent, view.",
	DISPLAY_MESSAGE,
	"Voice positively identified.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Nice song, man.",
	END_DIALOG
};

const static char *englishDialog99[] = {
	CHANGE_CHARACTER,
	"Security test: voice, scent, view.",
	DISPLAY_MESSAGE,
	"Scent positively identified.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"I don't like water too, bro.",
	END_DIALOG
};

const static char *englishDialog100[] = {
	CHANGE_CHARACTER,
	"Security test: voice, scent, view.",
	DISPLAY_MESSAGE,
	"View positively identified.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Next time stand a bit closer, man.",
	END_DIALOG
};

const static char *englishDialog101[] = {
	"May I talk with...",
	CHANGE_CHARACTER,
	"Go away.",
	DISPLAY_MESSAGE,
	"I'm busy.",
	DISPLAY_MESSAGE,
	"Working.",
	DISPLAY_MESSAGE,
	"Dinner soon.",
	DISPLAY_MESSAGE,
	"Gotta hurry.",
	CHANGE_CHARACTER,
	"Aye, captain.",
	END_DIALOG
};

const static char *englishDialog102[] = {
	"Well, but maybe...",
	CHANGE_CHARACTER,
	"I...",
	DISPLAY_MESSAGE,
	"...AM...",
	DISPLAY_MESSAGE,
	"...BUSY.",
	DISPLAY_MESSAGE,
	"DON'T...",
	DISPLAY_MESSAGE,
	"...DISTURB...",
	DISPLAY_MESSAGE,
	"...ME.",
	DISPLAY_MESSAGE,
	"OK?",
	CHANGE_CHARACTER,
	"Okay, okay.",
	END_DIALOG
};

const static char *englishDialog103[] = {
	"Last time I ask you...",
	CHANGE_CHARACTER,
	"BUSY.",
	DISPLAY_MESSAGE,
	"B like Bill.",
	DISPLAY_MESSAGE,
	"U like Ulrik.",
	DISPLAY_MESSAGE,
	"S like Sean.",
	DISPLAY_MESSAGE,
	"Y like...",
	DISPLAY_MESSAGE,
	"...like...",
	CHANGE_CHARACTER,
	"Yeti?",
	CHANGE_CHARACTER,
	"No. Like...",
	CHANGE_CHARACTER,
	"Yabbadabbadoo?",
	CHANGE_CHARACTER,
	"No, no. Like...",
	CHANGE_CHARACTER,
	"Yoko?",
	CHANGE_CHARACTER,
	"Yoko.",
	DISPLAY_MESSAGE,
	"Leave me alone now, PLEASE!",
	CHANGE_CHARACTER,
	"All right, all right.",
	END_DIALOG
};

const static char *englishDialog104[] = {
	"Er...",
	CHANGE_CHARACTER,
	"Wrrrr...",
	CHANGE_CHARACTER,
	"Oh, nothing.",
	END_DIALOG
};

const static char *englishDialog105[] = {
	"Good day, Mr. Robot.",
	CHANGE_CHARACTER,
	"Hey, yo, wassup my man,",
	NEW_LINE,
	"you know what I'm sayin'?",
	DISPLAY_MESSAGE,
	"Call me Mike, you know",
	NEW_LINE,
	"what I'm sayin'?",
	CHANGE_CHARACTER,
	"Er...",
	DISPLAY_MESSAGE,
	"Are you sure everything's",
	NEW_LINE,
	"all right with your...",
	DISPLAY_MESSAGE,
	"...program?...",
	CHANGE_CHARACTER,
	"What's da problem, man?!",
	DISPLAY_MESSAGE,
	"Neva seen da rappin' robo-safe,",
	NEW_LINE,
	"you know what I'm sayin'?",
	CHANGE_CHARACTER,
	"Actually, never.",
	CHANGE_CHARACTER,
	"I'm brand new, bro.",
	DISPLAY_MESSAGE,
	"Fresh stuff, you know what I mean?",
	DISPLAY_MESSAGE,
	"Smart people sez da robots",
	NEW_LINE,
	"should be for everybody,",
	DISPLAY_MESSAGE,
	"you know what I'm sayin',",
	NEW_LINE,
	"so they gave me human",
	NEW_LINE,
	"personality,",
	DISPLAY_MESSAGE,
	"you know what I mean?",
	NEW_LINE,
	"Cool, ain't that?",
	CHANGE_CHARACTER,
	"Khm... Yeah, great.",
	DISPLAY_MESSAGE,
	"So, you're some kind of safe?",
	CHANGE_CHARACTER,
	"That's right, man.",
	DISPLAY_MESSAGE,
	"Totally reliable, you know",
	NEW_LINE,
	"what I'm sayin'?",
	DISPLAY_MESSAGE,
	"If you wanna get me open, you",
	NEW_LINE,
	"gotta prove you're da owner.",
	DISPLAY_MESSAGE,
	"Now check diz (CENSORED) out:",
	NEW_LINE,
	"I can judge if it's the right",
	NEW_LINE,
	"homie by three things:",
	DISPLAY_MESSAGE,
	"...view, scent and da voice.",
	NEW_LINE,
	"You know what I'm sayin'?",
	CHANGE_CHARACTER,
	"But will you please open",
	NEW_LINE,
	"...yourself... just to let me see",
	NEW_LINE,
	"what you got inside?",
	CHANGE_CHARACTER,
	"Sorry, bro.",
	DISPLAY_MESSAGE,
	"You don't look like da owner...",
	DISPLAY_MESSAGE,
	"...you don't smell like him...",
	DISPLAY_MESSAGE,
	"...and your voice is kinda different.",
	DISPLAY_MESSAGE,
	"Now (CENSORED), you know what I mean?",
	END_DIALOG
};

const static char *englishDialog106[] = {
	"Sesame, open...",
	CHANGE_CHARACTER,
	"(CENSORED), you (CENSORED).",
	END_DIALOG
};

const static char *englishDialog107[] = {
	"Hi there!",
	CHANGE_CHARACTER,
	"(PARENTAL GUIDANCE: EXPLICIT LYRICS)",
	END_DIALOG
};

const static char *englishDialog108[] = {
	"I'm telling you, it's something great.",
	CHANGE_CHARACTER,
	"I remember when you killed my",
	NEW_LINE,
	"servant, testing your bullet-proof",
	NEW_LINE,
	"T-shirt.",
	CHANGE_CHARACTER,
	"That was a long time ago...",
	CHANGE_CHARACTER,
	"Or like you made rapping",
	NEW_LINE,
	"robo-safe, which goes mad",
	NEW_LINE,
	"every time...",
	DISPLAY_MESSAGE,
	"...I ask it to open.",
	CHANGE_CHARACTER,
	"You got a bad attitude...",
	CHANGE_CHARACTER,
	"Or like you sold me",
	NEW_LINE,
	"the recipe for girls'",
	NEW_LINE,
	"heart-breaking.",
	CHANGE_CHARACTER,
	"Money didn't work?",
	CHANGE_CHARACTER,
	"Nope.",
	CHANGE_CHARACTER,
	"Strange. Usually it works.",
	CHANGE_CHARACTER,
	"Or when you...",
	CHANGE_CHARACTER,
	"ALL RIGHT, ALL RIGHT!",
	DISPLAY_MESSAGE,
	"Let's forget this!",
	DISPLAY_MESSAGE,
	"I already tested my new",
	NEW_LINE,
	"invention on myself!",
	CHANGE_CHARACTER,
	"Really?",
	CHANGE_CHARACTER,
	"Really.",
	DISPLAY_MESSAGE,
	"I can demonstrate it.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Ok, I'll take my chance.",
	END_DIALOG
};

const static char *englishDialog109[] = {
	ANIM_WAIT,
	"Great.",
	DISPLAY_MESSAGE,
	"Ultimate gnome-maker.",
	CHANGE_CHARACTER,
	"Khm, it's just a side effect.",
	DISPLAY_MESSAGE,
	"Sometimes I can't control my",
	NEW_LINE,
	"inventions.",
	DISPLAY_MESSAGE,
	"But don't worry, it lasts only",
	NEW_LINE,
	"a second.",
	CHANGE_CHARACTER,
	"I hope so.",
	END_DIALOG
};

const static char *englishDialog110[] = {
	"Here I am.",
	DISPLAY_MESSAGE,
	"Well, have you noticed anything",
	NEW_LINE,
	"else unusual?",
	CHANGE_CHARACTER,
	"Nope.",
	CHANGE_CHARACTER,
	"Great!",
	DISPLAY_MESSAGE,
	"So the pills still work!",
	CHANGE_CHARACTER,
	"Oh yeah?",
	CHANGE_CHARACTER,
	"Yes!",
	DISPLAY_MESSAGE,
	"Check out your wallet!",
	CHANGE_CHARACTER,
	"My wallet is still...",
	END_DIALOG
};

const static char *englishDialog111[] = {
	"Where is my wallet?!",
	DISPLAY_MESSAGE,
	"You thief!",
	DISPLAY_MESSAGE,
	"Give it back!",
	CHANGE_CHARACTER,
	"Take it easy, here's your",
	NEW_LINE,
	"wallet.",
	END_DIALOG
};

const static char *englishDialog112[] = {
	"I demand an explanation.",
	CHANGE_CHARACTER,
	"Hah!",
	DISPLAY_MESSAGE,
	"This is the best thing I have",
	NEW_LINE,
	"ever invented!",
	CHANGE_CHARACTER,
	"What's that?",
	CHANGE_CHARACTER,
	"You didn't see me steal",
	NEW_LINE,
	"your wallet,",
	DISPLAY_MESSAGE,
	"...because I have eaten...",
	DISPLAY_MESSAGE,
	"THE TIME PILL!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"The time pill?",
	CHANGE_CHARACTER,
	"Yes!",
	DISPLAY_MESSAGE,
	"Anyone who eats it, lives",
	NEW_LINE,
	"1000 times faster than the",
	NEW_LINE,
	"rest of the world!",
	CHANGE_CHARACTER,
	"That means...",
	CHANGE_CHARACTER,
	"That means the world for",
	NEW_LINE,
	"this person moves 1000",
	NEW_LINE,
	"times slower!",
	DISPLAY_MESSAGE,
	"Only for a few seconds,",
	NEW_LINE,
	"though...",
	CHANGE_CHARACTER,
	"Well... That's interesting.",
	NEW_LINE,
	"But what's the use?",
	CHANGE_CHARACTER,
	"I don't care.",
	DISPLAY_MESSAGE,
	"Think about it.",
	DISPLAY_MESSAGE,
	"You could, for example, get in",
	NEW_LINE,
	"the cinema without a ticket,",
	NEW_LINE,
	"and nobody would notice you.",
	CHANGE_CHARACTER,
	"Of course!",
	DISPLAY_MESSAGE,
	"Great!",
	DISPLAY_MESSAGE,
	"I want to buy the patent!",
	CHANGE_CHARACTER,
	"That's the problem...",
	DISPLAY_MESSAGE,
	"As you know, my uncel Gallagher,",
	NEW_LINE,
	"used to invent the best things",
	NEW_LINE,
	"when he was ...let's say...",
	CHANGE_CHARACTER,
	"...drunk...",
	CHANGE_CHARACTER,
	"...intoxicated.",
	DISPLAY_MESSAGE,
	"And the same happened to me",
	NEW_LINE,
	"(sigh).",
	DISPLAY_MESSAGE,
	"So last night I woke up with",
	NEW_LINE,
	"a horrible headache and",
	NEW_LINE,
	"found those pills.",
	DISPLAY_MESSAGE,
	"I don't remember how I made them.",
	CHANGE_CHARACTER,
	"Oh no!",
	CHANGE_CHARACTER,
	"But I may try to work on them.",
	DISPLAY_MESSAGE,
	"I need your money for that.",
	DISPLAY_MESSAGE,
	"Let's make a deal.",
	DISPLAY_MESSAGE,
	"You build me a new",
	NEW_LINE,
	"laboratory and stuff...",
	DISPLAY_MESSAGE,
	"...and I'll give you my rights.",
	CHANGE_CHARACTER,
	"You'll give me the patent?!",
	CHANGE_CHARACTER,
	"Yes.",
	DISPLAY_MESSAGE,
	"All I care about is the",
	NEW_LINE,
	"respect of the science",
	NEW_LINE,
	"society respect.",
	DISPLAY_MESSAGE,
	"And Nobel.",
	DISPLAY_MESSAGE,
	"You know, honoris causa here",
	NEW_LINE,
	"and there, interviews...",
	CHANGE_CHARACTER,
	"All right. You got the deal.",
	DISPLAY_MESSAGE,
	"Prepare the list of necessary",
	NEW_LINE,
	"equipment.",
	CHANGE_CHARACTER,
	"Wonderful.",
	END_DIALOG
};

const static char *englishDialog113[] = {
	"This fool trusts me.",
	DISPLAY_MESSAGE,
	"But I will use him...",
	DISPLAY_MESSAGE,
	"The time pills...",
	DISPLAY_MESSAGE,
	"I won't be selling them to",
	NEW_LINE,
	"those stupid people!",
	DISPLAY_MESSAGE,
	"I don't care about the",
	NEW_LINE,
	"patent!",
	DISPLAY_MESSAGE,
	"I could rob any bank",
	NEW_LINE,
	"without being seen!",
	DISPLAY_MESSAGE,
	"Faster than light!",
	DISPLAY_MESSAGE,
	"I need to steal some money",
	NEW_LINE,
	"or gold for this mad man's",
	NEW_LINE,
	"laboratory.",
	END_DIALOG
};

const static char *englishDialog114[] = {
	"But soon...",
	DISPLAY_MESSAGE,
	"I'll get rich.",
	DISPLAY_MESSAGE,
	"Veeeery rich.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"I feel like I could...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"...like I could...",
	END_DIALOG
};

const static char *englishDialog115[] = {
	ANIM_WAIT,
	"TAKE ON THE WORLD!...",
	END_DIALOG
};

const static char *englishDialog116[] = {
	ANIM_WAIT,
	"I always wanted to say that.",
	END_DIALOG
};

const static char *englishDialog117[] = {
	"It's me again.",
	CHANGE_CHARACTER,
	"Goodbye again.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Let's say I haven't heard that.",
	DISPLAY_MESSAGE,
	"Is Mr. John Noty home?",
	CHANGE_CHARACTER,
	"Yeah, but he said you can't get in.",
	CHANGE_CHARACTER,
	"Me?! Why?!",
	CHANGE_CHARACTER,
	"Your last invention cost him",
	NEW_LINE,
	"two walls.",
	CHANGE_CHARACTER,
	"Oh, that time machine...",
	DISPLAY_MESSAGE,
	"But now I have some...",
	CHANGE_CHARACTER,
	"Not to mention the disapearance of his cat.",
	CHANGE_CHARACTER,
	"The cat is happier than",
	NEW_LINE,
	"any of us now!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"If the world still exists in",
	NEW_LINE,
	"XXV century.",
	DISPLAY_MESSAGE,
	"Never mind.",
	DISPLAY_MESSAGE,
	"You just have to let me in.",
	CHANGE_CHARACTER,
	"Oh yeah?",
	CHANGE_CHARACTER,
	"Or I'll tell Mr. John Noty you drink on duty.",
	CHANGE_CHARACTER,
	"You're bluffing. You have no proof.",
	CHANGE_CHARACTER,
	"Yeah, but you never know.",
	END_DIALOG
};

const static char *englishDialog118[] = {
	"Ok, get in, you filthy terrorist.",
	DISPLAY_MESSAGE,
	"Just don't tell anybody.",
	CHANGE_CHARACTER,
	"Of course. Thank you.",
	END_DIALOG
};

const static char *englishDialog119[] = {
	"So...",
	DISPLAY_MESSAGE,
	"That's how it all happened...",
	DISPLAY_MESSAGE,
	"That's why nobody has seen",
	NEW_LINE,
	"how things were",
	NEW_LINE,
	"being stolen...",
	DISPLAY_MESSAGE,
	"It's a really dangerous",
	NEW_LINE,
	"invention!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"I HAVE TO stop John Noty!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Somehow.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Boy! Those pills I took",
	NEW_LINE,
	"from Mike must be...",
	DISPLAY_MESSAGE,
	"Oh, no!",
	DISPLAY_MESSAGE,
	"I can hear somebody coming!",
	END_DIALOG
};

const static char *englishDialog120[] = {
	"I have to hide somewhere!",
	DISPLAY_MESSAGE,
	"Now!",
	END_DIALOG
};

const static char *englishDialog121[] = {
	"I have to buy an old-fashioned safe.",
	DISPLAY_MESSAGE,
	"That stupid robot went mad again.",
	DISPLAY_MESSAGE,
	"I hate it.",
	DISPLAY_MESSAGE,
	"CLOSE, YOU PIECE OF JUNK!",
	END_DIALOG
};

const static char *englishDialog122[] = {
	"Third time this week.",
	DISPLAY_MESSAGE,
	"Oh, all right, all right!...",
	DISPLAY_MESSAGE,
	"I'm coming!...",
	END_DIALOG
};

const static char *englishDialog123[] = {
	"...cover it all.",
	DISPLAY_MESSAGE,
	"I need more money for the security system.",
	DISPLAY_MESSAGE,
	"I've got only two men and...",
	CHANGE_CHARACTER,
	"More and more!",
	DISPLAY_MESSAGE,
	"It's all I hear!",
	CHANGE_CHARACTER,
	"All right, I'll explain again...",
	END_DIALOG
};

const static char *englishDialog124[] = {
	"Mr. John Noty?",
	DISPLAY_MESSAGE,
	"I just received some information from",
	NEW_LINE,
	"the professor.",
	DISPLAY_MESSAGE,
	"He's asked you to come to the laboratory.",
	DISPLAY_MESSAGE,
	"He says he's found out the structure of",
	NEW_LINE,
	"the pills.",
	END_DIALOG
};

const static char *englishDialog125[] = {
	"So this is it?!",
	CHANGE_CHARACTER,
	"Definitely ...hic!... yes.",
	CHANGE_CHARACTER,
	"Great!",
	END_DIALOG
};

const static char *englishDialog126[] = {
	"I have to stop them!",
	DISPLAY_MESSAGE,
	"There's no time to waste!",
	END_DIALOG
};

const static char *englishDialog127[] = {
	"Well, well, well...",
	DISPLAY_MESSAGE,
	"You really play on my nerves.",
	DISPLAY_MESSAGE,
	"It was a good idea not to save money",
	NEW_LINE,
	"on the security system...",
	DISPLAY_MESSAGE,
	"This force field is indestructible!",
	DISPLAY_MESSAGE,
	"Hah!",
	END_DIALOG
};

const static char *englishDialog128[] = {
	"But I have to kill you anyway.",
	CHANGE_CHARACTER,
	"No, no!",
	CHANGE_CHARACTER,
	"Shut up!",
	CHANGE_CHARACTER,
	"It's not worth it!",
	CHANGE_CHARACTER,
	"Oh really?",
	CHANGE_CHARACTER,
	"I don't want to...",
	END_DIALOG
};

const static char *englishDialog129[] = {
	CHANGE_CHARACTER,
	"The poor professor has fainted...",
	CHANGE_CHARACTER,
	"But... How...",
	DISPLAY_MESSAGE,
	"I DON'T UNDERSTAND ANYTHING!!!",
	CHANGE_CHARACTER,
	"It's very easy.",
	DISPLAY_MESSAGE,
	"We attached a secret micro-camera",
	NEW_LINE,
	"to your cap.",
	DISPLAY_MESSAGE,
	"This way we knew all the time what was",
	NEW_LINE,
	"happening.",
	CHANGE_CHARACTER,
	"You have seen when I?...",
	CHANGE_CHARACTER,
	"I don't want to embarrass you.",
	DISPLAY_MESSAGE,
	"You did a good job for the RGB.",
	CHANGE_CHARACTER,
	"But John Noty has escaped!",
	CHANGE_CHARACTER,
	"He's not important.",
	DISPLAY_MESSAGE,
	"We have the professor, you'll give us the pills.",
	DISPLAY_MESSAGE,
	"Sorry, but you can't keep them for yourself.",
	CHANGE_CHARACTER,
	"Okay, but...",
	DISPLAY_MESSAGE,
	"Could you please give me just a minute?",
	DISPLAY_MESSAGE,
	"I have some private business to do with",
	NEW_LINE,
	"this scum.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"All right. But hurry up.",
	END_DIALOG
};

const static char *englishDialog130[] = {
	ANIM_WAIT,
	"(gulp)",
	DISPLAY_MESSAGE,
	"This time-effect really doesn't last",
	NEW_LINE,
	"long...",
	END_DIALOG
};

const static char *englishDialog131[] = {
	"You've lost, mister!",
	DISPLAY_MESSAGE,
	"The police are surrounding the building!",
	CHANGE_CHARACTER,
	"Don't be stupid.",
	DISPLAY_MESSAGE,
	"Didn't you think I'd have",
	NEW_LINE,
	"a secret way out?",
	CHANGE_CHARACTER,
	"Oh yeah?",
	DISPLAY_MESSAGE,
	"What's that?",
	CHANGE_CHARACTER,
	"Like I'm going to tell you...",
	DISPLAY_MESSAGE,
	"Get lost, you little creep.",
	DISPLAY_MESSAGE,
	"I'm busy.",
	END_DIALOG
};

const static char *englishDialog132[] = {
	"I'll have to disarm you.",
	DISPLAY_MESSAGE,
	"Be nice and surrender without problems.",
	CHANGE_CHARACTER,
	"I don't have time for jokes.",
	DISPLAY_MESSAGE,
	"Get the hell out of here,",
	NEW_LINE,
	"before I point my gun at you",
	NEW_LINE,
	"again.",
	CHANGE_CHARACTER,
	"I warn you...",
	CHANGE_CHARACTER,
	"Where do they sell",
	NEW_LINE,
	"bores like you?",
	END_DIALOG
};

const static char *englishDialog133[] = {
	"I won't give you any more chances...",
	CHANGE_CHARACTER,
	"Good.",
	DISPLAY_MESSAGE,
	"And bye.",
	END_DIALOG
};

const static char *englishDialog134[] = {
	"Stop packing that money!",
	END_DIALOG
};

const static char *englishDialog135[] = {
	"Hi, there!",
	CHANGE_CHARACTER,
	"Hi.",
	DISPLAY_MESSAGE,
	"What's your problem?",
	CHANGE_CHARACTER,
	"I was sent here for some training.",
	CHANGE_CHARACTER,
	"Another wanna-be secret agent, huh?",
	CHANGE_CHARACTER,
	"Yep.",
	CHANGE_CHARACTER,
	"Show me your documents and you'll get in.",
	CHANGE_CHARACTER,
	"Okey dokey.",
	END_DIALOG
};

const static char *englishDialog136[] = {
	"Can't you let me in without all that",
	NEW_LINE,
	"bureaucracy?",
	CHANGE_CHARACTER,
	"Sorry, no.",
	DISPLAY_MESSAGE,
	"Rules are rules.",
	CHANGE_CHARACTER,
	"And morons are morons.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"And dead people are dead people.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Have a good day, sir.",
	END_DIALOG
};

const static char *englishDialog137[] = {
	"MAY I PASS, PLEASE?!",
	CHANGE_CHARACTER,
	"YES, YOU MAY!",
	DISPLAY_MESSAGE,
	"JUST SHOW ME YOUR DOCUMENTS!",
	END_DIALOG
};

const static char *englishDialog138[] = {
	"Let me in!",
	CHANGE_CHARACTER,
	"Show your documents!",
	CHANGE_CHARACTER,
	"You take your job really seriously,",
	NEW_LINE,
	"don't you?",
	CHANGE_CHARACTER,
	"Are you blind or what?",
	DISPLAY_MESSAGE,
	"I'm reading a magazine on duty.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Oh, yeah.",
	DISPLAY_MESSAGE,
	"Sorry.",
	END_DIALOG
};

const static char *englishDialog139[] = {
	"I have to...",
	CHANGE_CHARACTER,
	"Documents!",
	END_DIALOG
};

const static char *englishDialog140[] = {
	"What are you reading?",
	CHANGE_CHARACTER,
	"'Soldier News', of course.",
	CHANGE_CHARACTER,
	"You love all that military stuff,",
	NEW_LINE,
	"don't you?",
	CHANGE_CHARACTER,
	"Are you crazy?",
	DISPLAY_MESSAGE,
	"I like pictures of cool babes...",
	DISPLAY_MESSAGE,
	"...crosswords...",
	DISPLAY_MESSAGE,
	"...the humor page...",
	DISPLAY_MESSAGE,
	"...rumors...",
	DISPLAY_MESSAGE,
	"...recipes...",
	CHANGE_CHARACTER,
	"COOKING?!",
	CHANGE_CHARACTER,
	"Yes, they try to raise their profile.",
	DISPLAY_MESSAGE,
	"Gain new readers, you know.",
	CHANGE_CHARACTER,
	"Oh yeah.",
	DISPLAY_MESSAGE,
	"Great idea.",
	DISPLAY_MESSAGE,
	"Is there a knitting page too?",
	CHANGE_CHARACTER,
	"I get the feeling you're",
	NEW_LINE,
	"trying to be funny.",
	CHANGE_CHARACTER,
	"Nah, me?",
	DISPLAY_MESSAGE,
	"Never.",
	CHANGE_CHARACTER,
	"Good.",
	END_DIALOG
};

const static char *englishDialog141[] = {
	"Would you lend me the magazine?",
	CHANGE_CHARACTER,
	"And what am I supposed",
	NEW_LINE,
	"to kill the time with",
	NEW_LINE,
	"then?",
	CHANGE_CHARACTER,
	"Erm...",
	DISPLAY_MESSAGE,
	"You could count the leaves.",
	CHANGE_CHARACTER,
	"There're 11034 leaves here.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Wow.",
	END_DIALOG
};

const static char *englishDialog142[] = {
	"What's up?",
	CHANGE_CHARACTER,
	"The sky, I hope.",
	END_DIALOG
};

const static char *englishDialog143[] = {
	"Keep up the good work.",
	END_DIALOG
};

const static char *englishDialog144[] = {
	CHANGE_CHARACTER,
	"Hey, get back!",
	END_DIALOG
};

const static char *englishDialog145[] = {
	"What's the matter?",
	CHANGE_CHARACTER,
	"You must show me your pass",
	NEW_LINE,
	"before I let you enter the",
	NEW_LINE,
	"camp.",
	CHANGE_CHARACTER,
	"What if I don't?",
	CHANGE_CHARACTER,
	"I'll have to shoot you.",
	CHANGE_CHARACTER,
	"(gulp)",
	END_DIALOG
};

const static char *englishDialog146[] = {
	CHANGE_CHARACTER,
	"I warn you...",
	DISPLAY_MESSAGE,
	"My bullets are faster than you...",
	END_DIALOG
};

const static char *englishDialog147[] = {
	CHANGE_CHARACTER,
	"All right.",
	DISPLAY_MESSAGE,
	"Report to the captain.",
	DISPLAY_MESSAGE,
	"He should be around somewhere.",
	CHANGE_CHARACTER,
	"Thanks, man.",
	END_DIALOG
};

const static char *englishDialog148[] = {
	CHANGE_CHARACTER,
	"We're gonna turn you into a real man,",
	NEW_LINE,
	"right, son?!",
	CHANGE_CHARACTER,
	"Erm...",
	CHANGE_CHARACTER,
	"Best of the best!...",
	CHANGE_CHARACTER,
	"Uh...",
	CHANGE_CHARACTER,
	"By sweat, blood and tears!",
	CHANGE_CHARACTER,
	"I'd rather...",
	CHANGE_CHARACTER,
	"I'm glad to see your enthusiasm, son!",
	DISPLAY_MESSAGE,
	"Let's not waste time!",
	DISPLAY_MESSAGE,
	"I was told to give you some express training.",
	DISPLAY_MESSAGE,
	"All right, son!",
	DISPLAY_MESSAGE,
	"You'll have to pass three trials!",
	DISPLAY_MESSAGE,
	"Let's begin with the easy one!...",
	END_DIALOG
};

const static char *englishDialog149[] = {
	CHANGE_CHARACTER,
	"The task is simple.",
	DISPLAY_MESSAGE,
	"I'll lock up you here...",
	DISPLAY_MESSAGE,
	"...and you must escape.",
	DISPLAY_MESSAGE,
	"Is it clear?!",
	CHANGE_CHARACTER,
	"Sir, I...",
	CHANGE_CHARACTER,
	"GOOD!!!",
	END_DIALOG
};

const static char *englishDialog150[] = {
	ANIM_WAIT,
	"Hello?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Great.",
	END_DIALOG
};

const static char *englishDialog151[] = {
	"OK, that was funny.",
	DISPLAY_MESSAGE,
	"Now let me out!",
	END_DIALOG
};

const static char *englishDialog152[] = {
	"Hey! Is there anybody out",
	NEW_LINE,
	"there?!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"HELP!!!",
	END_DIALOG
};

const static char *englishDialog153[] = {
	"Have mercy!",
	DISPLAY_MESSAGE,
	"I'm gonna die here!",
	END_DIALOG
};

const static char *englishDialog154[] = {
	"I'm getting hungry!",
	END_DIALOG
};

const static char *englishDialog155[] = {
	"I don't know what to say now...",
	END_DIALOG
};

const static char *englishDialog156[] = {
	"I think...",
	DISPLAY_MESSAGE,
	"...you've passed...",
	DISPLAY_MESSAGE,
	"...the first test...",
	DISPLAY_MESSAGE,
	"...Let's get...",
	DISPLAY_MESSAGE,
	"...to the next one...",
	END_DIALOG
};

const static char *englishDialog157[] = {
	CHANGE_CHARACTER,
	"Ok, soldier.",
	DISPLAY_MESSAGE,
	"Let's assume I'm your captive...",
	DISPLAY_MESSAGE,
	"...and I know some secret password.",
	DISPLAY_MESSAGE,
	"Your task is to get it from me.",
	DISPLAY_MESSAGE,
	"CLEAR?!?",
	CHANGE_CHARACTER,
	"Am I restricted?",
	CHANGE_CHARACTER,
	"No.",
	DISPLAY_MESSAGE,
	"Do anything you want.",
	CHANGE_CHARACTER,
	"May I even spit in your eye?",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Yes.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Thanks, just checking.",
	END_DIALOG
};

const static char *englishDialog158[] = {
	"Please tell me the password",
	NEW_LINE,
	"and let's get over it all.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"OK, think about it.",
	END_DIALOG
};

const static char *englishDialog159[] = {
	"Hey, talk to me.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Do you hear me?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"EARTH TO CAPTAIN, EARTH TO CAPTAIN!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"You're hopeless.",
	END_DIALOG
};

const static char *englishDialog160[] = {
	"Are you ready to talk?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"OK, I'll give you some more time.",
	END_DIALOG
};

const static char *englishDialog161[] = {
	"Now, what is the password?",
	CHANGE_CHARACTER,
	"Get lost, you pathetic wimp.",
	CHANGE_CHARACTER,
	"Be nice, or I'll tickle you again.",
	CHANGE_CHARACTER,
	"Go on, that'll be a pleasure.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"You enjoyed that, didn't you?",
	CHANGE_CHARACTER,
	"Well, you know...",
	CHANGE_CHARACTER,
	"Ok, I'll find some other way.",
	END_DIALOG
};

const static char *englishDialog162[] = {
	"I brought you something...",
	CHANGE_CHARACTER,
	"You can't bribe me.",
	CHANGE_CHARACTER,
	"Oh, yeah?",
	END_DIALOG
};

// Note:
// The usage of this in the engine overlaps the previous dialog i.e. the
// starting offset used is two bytes early, thus implicitly changing the
// first command of this dialog from NEW_LINE to CHANGE_CHARACTER.
const static char *englishDialog163[] = {
	NEW_LINE,
	"OH GIMMIE GIMMIE GIMMIE!!!",
	DISPLAY_MESSAGE,
	"I'LL DO ANYTHING!!!",
	CHANGE_CHARACTER,
	"Password...",
	CHANGE_CHARACTER,
	"The password is 'COFFEE'.",
	DISPLAY_MESSAGE,
	"Tell it to the barman and",
	NEW_LINE,
	"he'll give you something.",
	DISPLAY_MESSAGE,
	"Then he'll tell you about the third task.",
	DISPLAY_MESSAGE,
	"NOW FREE ME!!!",
	CHANGE_CHARACTER,
	"I'll think about it.",
	END_DIALOG
};

const static char *englishDialog164[] = {
	"You...",
	DISPLAY_MESSAGE,
	"...you...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"...have passed, sir!",
	END_DIALOG
};

const static char *englishDialog165[] = {
	"Would you care for a wonderful kaleidoscope?",
	CHANGE_CHARACTER,
	"I had one once, but captain saw me",
	NEW_LINE,
	"playing with it and took it from me.",
	DISPLAY_MESSAGE,
	"I think he uses it himself,",
	NEW_LINE,
	"you know.",
	CHANGE_CHARACTER,
	"If you give me the gazette,",
	NEW_LINE,
	"I'll give you that kaleidoscope.",
	CHANGE_CHARACTER,
	"I don't want to know how you got it...",
	CHANGE_CHARACTER,
	"Good.",
	CHANGE_CHARACTER,
	"...but what if the captain sees me again?",
	CHANGE_CHARACTER,
	"Don't worry, he's tied up.",
	CHANGE_CHARACTER,
	"Oh, test number two, I guess?...",
	CHANGE_CHARACTER,
	"Yep.",
	CHANGE_CHARACTER,
	"OK, let's have some fun here.",
	END_DIALOG
};

const static char *englishDialog166[] = {
	"'COFFEE'.",
	END_DIALOG
};

const static char *englishDialog167[] = {
	CHANGE_CHARACTER,
	"Hot, wasn't it?",
	CHANGE_CHARACTER,
	"Uh-huh.",
	DISPLAY_MESSAGE,
	"The captain says you're gonna tell me",
	NEW_LINE,
	"about the third task.",
	CHANGE_CHARACTER,
	"Again...",
	DISPLAY_MESSAGE,
	"Well, it's kinda hide'n'seek.",
	DISPLAY_MESSAGE,
	"The captain hides, you seek.",
	CHANGE_CHARACTER,
	"But I left him tied to a chair!",
	CHANGE_CHARACTER,
	"That man and his sick games...",
	DISPLAY_MESSAGE,
	"He enjoys it more than he should!...",
	DISPLAY_MESSAGE,
	"He cheated you.",
	DISPLAY_MESSAGE,
	"Go and check.",
	DISPLAY_MESSAGE,
	"I'm sure he's already free.",
	CHANGE_CHARACTER,
	"But I took his knife!",
	DISPLAY_MESSAGE,
	"How could he cut the ties?!",
	CHANGE_CHARACTER,
	"Maybe he walked away with the chair",
	NEW_LINE,
	"tied to his...",
	CHANGE_CHARACTER,
	"Never mind.",
	DISPLAY_MESSAGE,
	"Any hints about where he might hide?",
	CHANGE_CHARACTER,
	"None.",
	CHANGE_CHARACTER,
	"Oh, c'mon.",
	CHANGE_CHARACTER,
	"No, boy. Play fair.",
	END_DIALOG
};

const static char *englishDialog168[] = {
	"Time for a little hint?",
	CHANGE_CHARACTER,
	"No.",
	END_DIALOG
};

const static char *englishDialog169[] = {
	"Hello, sir. I'm Mark.",
	CHANGE_CHARACTER,
	"What a pity you're not a dollar.",
	DISPLAY_MESSAGE,
	"What can I do for you?",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"You can give me a lot of money...",
	DISPLAY_MESSAGE,
	"...or you can do a headstand...",
	DISPLAY_MESSAGE,
	"...or...",
	CHANGE_CHARACTER,
	"Okay, okay. It's a tie.",
	DISPLAY_MESSAGE,
	"So?...",
	CHANGE_CHARACTER,
	"Who's else is in the camp?",
	CHANGE_CHARACTER,
	"You're a journalist?",
	CHANGE_CHARACTER,
	"No, I'm a secret agent.",
	CHANGE_CHARACTER,
	"You too?",
	DISPLAY_MESSAGE,
	"Anyway, there are only three men.",
	DISPLAY_MESSAGE,
	"Me, the captain and the guard.",
	CHANGE_CHARACTER,
	"No women?",
	CHANGE_CHARACTER,
	"No cry.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Erm, well...",
	END_DIALOG
};

const static char *englishDialog170[] = {
	"Not much of a rush on, is there?",
	CHANGE_CHARACTER,
	"Do you want to order something or not?",
	CHANGE_CHARACTER,
	"I don't have money.",
	CHANGE_CHARACTER,
	"Today's free.",
	CHANGE_CHARACTER,
	"Really?",
	CHANGE_CHARACTER,
	"Really.",
	CHANGE_CHARACTER,
	"I want a hot-dog.",
	CHANGE_CHARACTER,
	"Miss.",
	CHANGE_CHARACTER,
	"Pizza?",
	CHANGE_CHARACTER,
	"Miss.",
	CHANGE_CHARACTER,
	"Toast?",
	CHANGE_CHARACTER,
	"Miss.",
	CHANGE_CHARACTER,
	"Anything?",
	CHANGE_CHARACTER,
	"Miss.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"No, thank you.",
	DISPLAY_MESSAGE,
	"I'm not hungry.",
	END_DIALOG
};

const static char *englishDialog171[] = {
	"What are you drinking?",
	CHANGE_CHARACTER,
	"Tea.",
	CHANGE_CHARACTER,
	"Sure.",
	END_DIALOG
};

const static char *englishDialog172[] = {
	"Nice weather.",
	CHANGE_CHARACTER,
	"Mhmmm...",
	END_DIALOG
};

const static char *englishDialog173[] = {
	"Sometimes I feel tired.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Very tired.",
	END_DIALOG
};

const static char *englishDialog174[] = {
	"Hey, Woodstock's over!",
	END_DIALOG
};

const static char *englishDialog175[] = {
	"Thanks.",
	END_DIALOG
};

const static char *englishDialog176[] = {
	CHANGE_CHARACTER,
	"What the...",
	END_DIALOG
};

const static char *englishDialog177[] = {
	"Hey, aren't you thirsty?",
	DISPLAY_MESSAGE,
	"Have you forgotten about your cup?",
	END_DIALOG
};

const static char *englishDialog178[] = {
	"Sir, we have been informed that...",
	CHANGE_CHARACTER,
	"Later!",
	DISPLAY_MESSAGE,
	"I'm busy right now!",
	CHANGE_CHARACTER,
	"As you wish, sir.",
	END_DIALOG
};

const static char *englishDialog179[] = {
	"Sir, some young boy tried to get inside",
	NEW_LINE,
	"the mansion.",
	END_DIALOG
};

const static char *englishDialog180[] = {
	"Don't worry.",
	DISPLAY_MESSAGE,
	"Young boys are curious...",
	DISPLAY_MESSAGE,
	"...and my house plays on their imaginations.",
	DISPLAY_MESSAGE,
	"But keep an eye on him.",
	CHANGE_CHARACTER,
	"Yes, sir!",
	END_DIALOG
};

const static char *englishDialog181[] = {
	"Sir, that boy tried to get in again.",
	END_DIALOG
};

const static char *englishDialog182[] = {
	"Do you think it's serious?",
	CHANGE_CHARACTER,
	"Hmmm... No...",
	DISPLAY_MESSAGE,
	"He doesn't look dangerously.",
	DISPLAY_MESSAGE,
	"But maybe we should...",
	CHANGE_CHARACTER,
	"Nah.",
	DISPLAY_MESSAGE,
	"Just keep him out of the mansion.",
	DISPLAY_MESSAGE,
	"But tell me if he appears again.",
	DISPLAY_MESSAGE,
	"Now get back to your job.",
	END_DIALOG
};

const static char *englishDialog183[] = {
	"Don't tell me it's that boy again...",
	CHANGE_CHARACTER,
	"I'm afraid so.",
	DISPLAY_MESSAGE,
	"The guard says the boy's really desperate.",
	END_DIALOG
};

const static char *englishDialog184[] = {
	"He's starting to get on my nerves.",
	DISPLAY_MESSAGE,
	"And what am I paying you for?",
	CHANGE_CHARACTER,
	"Should I...",
	CHANGE_CHARACTER,
	"Not yet.",
	DISPLAY_MESSAGE,
	"Let's give him a last chance.",
	END_DIALOG
};

const static char *englishDialog185[] = {
	"Sir...",
	CHANGE_CHARACTER,
	"Let me guess...",
	DISPLAY_MESSAGE,
	"THE BOY?!?...",
	CHANGE_CHARACTER,
	"Bingo.",
	CHANGE_CHARACTER,
	"Why do I have to do everything?!",
	DISPLAY_MESSAGE,
	"Can't you do anything yourself?",
	CHANGE_CHARACTER,
	"Shall I kill him or just beat him to pieces?",
	CHANGE_CHARACTER,
	"You're stupid.",
	DISPLAY_MESSAGE,
	"There are ...better ways...",
	END_DIALOG
};

const static char *englishDialog186[] = {
	"I'll handle it myself.",
	DISPLAY_MESSAGE,
	"Now get out!",
	DISPLAY_MESSAGE,
	"I have to change my clothes.",
	END_DIALOG
};

const static char *englishDialog187[] = {
	"Hey, you up there!",
	DISPLAY_MESSAGE,
	"Get down at once!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Zero reaction.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Is it deaf or something?",
	END_DIALOG
};

const static char *englishDialog188[] = {
	"Hey, birdy, don't be shy.",
	DISPLAY_MESSAGE,
	"Come to me...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"(sigh)",
	END_DIALOG
};

const static char *englishDialog189[] = {
	"Come here, little bird...",
	END_DIALOG
};

const static char *englishDialog190[] = {
	NEW_LINE,
	"Hey, keep away from this door!",
	CHANGE_CHARACTER,
	"Why?",
	CHANGE_CHARACTER,
	"None of your business.",
	DISPLAY_MESSAGE,
	"Just keep away.",
	END_DIALOG
};

const static char *englishDialog191[] = {
	CHANGE_CHARACTER,
	"I told you to keep away, didn't I?",
	CHANGE_CHARACTER,
	"OK, OK...",
	END_DIALOG
};

const static char *englishDialog192[] = {
	"I've got a new delivery of gold.",
	CHANGE_CHARACTER,
	"Yeah, I know.",
	DISPLAY_MESSAGE,
	"Password?",
	CHANGE_CHARACTER,
	"Bimbo.",
	CHANGE_CHARACTER,
	"All right.",
	DISPLAY_MESSAGE,
	"You can bring the gold in.",
	CHANGE_CHARACTER,
	"Okey dokey.",
	END_DIALOG
};

const static char *englishDialog193[] = {
	"As I told you, our organisation",
	NEW_LINE,
	"takes care of unusual problems.",
	DISPLAY_MESSAGE,
	"Last time we solved the problem of a UFO",
	NEW_LINE,
	"over the White House.",
	CHANGE_CHARACTER,
	"Oh, heally?",
	DISPLAY_MESSAGE,
	"How?",
	CHANGE_CHARACTER,
	"We shot the thing down.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"I undehstand.",
	DISPLAY_MESSAGE,
	"And who oh ...what was inside?",
	CHANGE_CHARACTER,
	"You want to know?",
	CHANGE_CHARACTER,
	"Oh, yes! As a fohtune-telleh",
	NEW_LINE,
	"I'm a cuhious pehson.",
	CHANGE_CHARACTER,
	"Do you REALLY want to know?",
	CHANGE_CHARACTER,
	"YES!",
	CHANGE_CHARACTER,
	"But...",
	DISPLAY_MESSAGE,
	"...REALLY REALLY?",
	CHANGE_CHARACTER,
	"YES!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Sorry, I can't tell you.",
	DISPLAY_MESSAGE,
	"Anyway, we need your help.",
	CHANGE_CHARACTER,
	"I'm not a sechet agent, I'm a fohtune-tell...",
	CHANGE_CHARACTER,
	"I know.",
	DISPLAY_MESSAGE,
	"We have a very difficult case,",
	NEW_LINE,
	"which we haven't been able",
	NEW_LINE,
	"to solve for 6 months.",
	DISPLAY_MESSAGE,
	"We're in a hopeless situation.",
	DISPLAY_MESSAGE,
	"I thought to myself, if we handle",
	NEW_LINE,
	"strange cases...",
	DISPLAY_MESSAGE,
	"...then why not use",
	NEW_LINE,
	"strange means?",
	CHANGE_CHARACTER,
	"And?...",
	CHANGE_CHARACTER,
	"Let me show you the phone-book.",
	DISPLAY_MESSAGE,
	"Use your powers and select a name.",
	DISPLAY_MESSAGE,
	"Maybe a fresh mind will solve the case.",
	CHANGE_CHARACTER,
	"You don't believe it will wohk, do you?",
	CHANGE_CHARACTER,
	"No, I don't.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"This is stupid.",
	CHANGE_CHARACTER,
	"I know.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Okay. Show me the book.",
	END_DIALOG
};

const static char *englishDialog194[] = {
	ANIM_WAIT,
	"The name is...",
	DISPLAY_MESSAGE,
	"...Hoppeh...",
	DISPLAY_MESSAGE,
	"...Mahk Hoppeh...",
	DISPLAY_MESSAGE,
	"Hm...",
	END_DIALOG
};

const static char *englishDialog195[] = {
	"He's coming.",
	END_DIALOG
};

const static char *englishDialog196[] = {
	"Oh, I'm sorry about my men.",
	DISPLAY_MESSAGE,
	"Sometimes they get a bit too nervous...",
	DISPLAY_MESSAGE,
	"But, please...",
	DISPLAY_MESSAGE,
	"Let's talk...",
	END_DIALOG
};

const static char *englishDialog197[] = {
	"Listen, mister...",
	CHANGE_CHARACTER,
	"I know, I know.",
	DISPLAY_MESSAGE,
	"Please, give me five minutes and",
	NEW_LINE,
	"everything will become clear.",
	CHANGE_CHARACTER,
	"Go on, I always liked that conspiracy stuff.",
	CHANGE_CHARACTER,
	"Well...",
	DISPLAY_MESSAGE,
	"I'm head of a secret government organization",
	NEW_LINE,
	"called the RGB.",
	CHANGE_CHARACTER,
	"Why RGB?",
	CHANGE_CHARACTER,
	"Even I don't know.",
	DISPLAY_MESSAGE,
	"It's so secret.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Cool.",
	CHANGE_CHARACTER,
	"The aim of my organization is to solve",
	NEW_LINE,
	"all the extraordinary problems around",
	NEW_LINE,
	"the world.",
	CHANGE_CHARACTER,
	"Like taxes?",
	CHANGE_CHARACTER,
	"No, like UFOs, strange inventions,",
	NEW_LINE,
	"spirits...",
	CHANGE_CHARACTER,
	"Wow!",
	CHANGE_CHARACTER,
	"Yes, when the police, the secret service and so on",
	NEW_LINE,
	"can't solve the problem...",
	DISPLAY_MESSAGE,
	"...it's delivered to us. But...",
	DISPLAY_MESSAGE,
	"You see, six months ago gold and cash",
	NEW_LINE,
	"deposited in bank safes started to",
	NEW_LINE,
	"disappear.",
	DISPLAY_MESSAGE,
	"Literally. Pum! And it's gone!",
	CHANGE_CHARACTER,
	"And?...",
	CHANGE_CHARACTER,
	"Gone - without a trace.",
	DISPLAY_MESSAGE,
	"The whole thing happens in a few seconds.",
	DISPLAY_MESSAGE,
	"We have video recordings but they don't",
	NEW_LINE,
	"show anything.",
	DISPLAY_MESSAGE,
	"That's why we hired the fortune-teller",
	NEW_LINE,
	"to show us someone who could be our",
	NEW_LINE,
	"salvation.",
	DISPLAY_MESSAGE,
	"She has chosen you.",
	CHANGE_CHARACTER,
	"I beg your pardon...",
	DISPLAY_MESSAGE,
	"You said you have hired...",
	DISPLAY_MESSAGE,
	"...A FORTUNE TELLER?!?",
	CHANGE_CHARACTER,
	"Yes, we're desperate and",
	NEW_LINE,
	"we'll try everything once.",
	CHANGE_CHARACTER,
	"This is crazy. Mum, wake me up!",
	CHANGE_CHARACTER,
	"Relax.",
	DISPLAY_MESSAGE,
	"We have a proposal for you.",
	DISPLAY_MESSAGE,
	"Try to help us and you will be rewarded.",
	CHANGE_CHARACTER,
	"What's in it for me?",
	CHANGE_CHARACTER,
	"Self-satisfaction?",
	END_DIALOG
};

const static char *englishDialog198[] = {
	CHANGE_CHARACTER,
	"Our respect?",
	END_DIALOG
};

const static char *englishDialog199[] = {
	CHANGE_CHARACTER,
	"Patriotism?",
	END_DIALOG
};

const static char *englishDialog200[] = {
	CHANGE_CHARACTER,
	"Girls?",
	CHANGE_CHARACTER,
	"What do you mean?",
	CHANGE_CHARACTER,
	"Every girl loves a secret agent.",
	END_DIALOG
};

const static char *englishDialog201[] = {
	"Ok, I agree. What am I supposed to do?",
	CHANGE_CHARACTER,
	"Before you start, I suggest that first",
	NEW_LINE,
	"you get some training in our special",
	NEW_LINE,
	"secret camp.",
	DISPLAY_MESSAGE,
	"I'll issue a pass for you.",
	DISPLAY_MESSAGE,
	"Deal?",
	CHANGE_CHARACTER,
	"Deal!",
	END_DIALOG
};

const static char *englishDialog202[] = {
	"...and it was even fun.",
	CHANGE_CHARACTER,
	"I'm glad you liked our training methods.",
	DISPLAY_MESSAGE,
	"But let's get to the point.",
	DISPLAY_MESSAGE,
	"I must admit I didn't believe you could",
	NEW_LINE,
	"actually help.",
	DISPLAY_MESSAGE,
	"Nothing personal.",
	CHANGE_CHARACTER,
	"I hope so.",
	CHANGE_CHARACTER,
	"But you brought us luck.",
	DISPLAY_MESSAGE,
	"Our people found out that some",
	NEW_LINE,
	"businessman is spending his",
	NEW_LINE,
	"money like crazy...",
	DISPLAY_MESSAGE,
	"...for some strange materials.",
	DISPLAY_MESSAGE,
	"There are three very suspicious things",
	NEW_LINE,
	"about him:",
	DISPLAY_MESSAGE,
	"...He pays in cash, which is very strange",
	NEW_LINE,
	"in a plastic card century...",
	DISPLAY_MESSAGE,
	"...Second, half a year ago he wasn't nearly",
	NEW_LINE,
	"as rich as he is now...",
	DISPLAY_MESSAGE,
	"...Third, what the hell does he need",
	NEW_LINE,
	"100 kg of borax for?",
	CHANGE_CHARACTER,
	"Maybe he's just a weirdo.",
	CHANGE_CHARACTER,
	"Maybe.",
	DISPLAY_MESSAGE,
	"But I want you to fly to the place",
	NEW_LINE,
	"and try to sneak inside his mansion...",
	DISPLAY_MESSAGE,
	"...to find out some more information.",
	DISPLAY_MESSAGE,
	"What do you say?",
	CHANGE_CHARACTER,
	"Well...",
	CHANGE_CHARACTER,
	"I promise you'll be an official secret",
	NEW_LINE,
	"agent after this mission.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Promise?",
	CHANGE_CHARACTER,
	"My word of honour.",
	CHANGE_CHARACTER,
	"Okay. I'm ready.",
	DISPLAY_MESSAGE,
	"Where am I supposed to go?",
	CHANGE_CHARACTER,
	"It's a little village.",
	DISPLAY_MESSAGE,
	"You won't find it on many maps...",
	DISPLAY_MESSAGE,
	"But before you go, let me give you some special",
	NEW_LINE,
	"agent equipment.",
	DISPLAY_MESSAGE,
	"I would give you some boots to make you fly,",
	NEW_LINE,
	"but I've lent them to somebody.",
	DISPLAY_MESSAGE,
	"The mega-power gauntlets are also",
	NEW_LINE,
	"out of stock.",
	DISPLAY_MESSAGE,
	"As a matter of act I only have special",
	NEW_LINE,
	"super glue.",
	DISPLAY_MESSAGE,
	"Well, that's better than nothing...",
	DISPLAY_MESSAGE,
	"Good luck!",
	END_DIALOG
};

const static char *englishDialog203[] = {
	CHANGE_CHARACTER,
	"Don't worry.",
	DISPLAY_MESSAGE,
	"He'll be okay.",
	DISPLAY_MESSAGE,
	"Just... oh, look, here he goes...",
	END_DIALOG
};

const static char *englishDialog204[] = {
	CHANGE_CHARACTER,
	"He got what he deserved.",
	DISPLAY_MESSAGE,
	"But we've wasted enough time. Let's go!",
	CHANGE_CHARACTER,
	"No! Wait!",
	DISPLAY_MESSAGE,
	"I have to see Anne!",
	CHANGE_CHARACTER,
	"Ermm... You can't.",
	CHANGE_CHARACTER,
	"And why is that?!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"You see... Anne was our man.",
	DISPLAY_MESSAGE,
	"She was ordered to keep an eye on you",
	NEW_LINE,
	"in case the microcamera got out of",
	NEW_LINE,
	"order.",
	DISPLAY_MESSAGE,
	"And she was also your motivation...",
	CHANGE_CHARACTER,
	"I don't believe you!",
	CHANGE_CHARACTER,
	"She has already gone off on",
	NEW_LINE,
	"her next mission.",
	DISPLAY_MESSAGE,
	"Sorry.",
	CHANGE_CHARACTER,
	"I guess grandma was involved too?",
	CHANGE_CHARACTER,
	"No, she's from here. We paid her.",
	CHANGE_CHARACTER,
	"Now that's interesting.",
	DISPLAY_MESSAGE,
	"Because if so, why did I have so",
	NEW_LINE,
	"many problems?...",
	CHANGE_CHARACTER,
	"We were pumping up your determination.",
	DISPLAY_MESSAGE,
	"We counted on you to have some strong will.",
	DISPLAY_MESSAGE,
	"We were not wrong, were we?",
	CHANGE_CHARACTER,
	"You treat people like animals in",
	NEW_LINE,
	"an experiment.",
	DISPLAY_MESSAGE,
	"You're ruthless...",
	CHANGE_CHARACTER,
	"It worked, didn't it?",
	CHANGE_CHARACTER,
	"This is all so unbelievable.",
	DISPLAY_MESSAGE,
	"Maybe you're gonna tell me that the dog is",
	NEW_LINE,
	"a masked agent...",
	DISPLAY_MESSAGE,
	"...the old man was my guard...",
	DISPLAY_MESSAGE,
	"...and you are from Mars?!",
	END_DIALOG
};

const static char *englishDialog205[] = {
	CHANGE_CHARACTER,
	"It's not a soap opera, it's",
	NEW_LINE,
	"just usual agent work.",
	DISPLAY_MESSAGE,
	"But hey, join the RGB and you could",
	NEW_LINE,
	"work with Anne there!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Well...",
	DISPLAY_MESSAGE,
	"I'll think about it...",
	CHANGE_CHARACTER,
	"Great.",
	DISPLAY_MESSAGE,
	"It was a pleasure to see you in action!",
	END_DIALOG
};

const static char *englishDialog206[] = {
	CHANGE_CHARACTER,
	"You don't have to tell me.",
	DISPLAY_MESSAGE,
	"I have already read a very detailed report.",
	CHANGE_CHARACTER,
	"But what happened to the professor?",
	CHANGE_CHARACTER,
	"Oh, that poor man has forgotten the pill recipe",
	NEW_LINE,
	"again.",
	DISPLAY_MESSAGE,
	"We'll give him the best laboratory we can.",
	DISPLAY_MESSAGE,
	"Right now we have only those few pills",
	NEW_LINE,
	"you gave us.",
	CHANGE_CHARACTER,
	"And John Noty?",
	CHANGE_CHARACTER,
	"Don't worry, his greediness will be punished.",
	CHANGE_CHARACTER,
	"I hope so...",
	DISPLAY_MESSAGE,
	"And one more little thing...",
	DISPLAY_MESSAGE,
	"You have promised me something...",
	END_DIALOG
};

const static char *englishDialog207[] = {
	CHANGE_CHARACTER,
	"Me?...",
	DISPLAY_MESSAGE,
	"I don't remember...",
	CHANGE_CHARACTER,
	"You said you'll make me an official agent...",
	DISPLAY_MESSAGE,
	"'Girls love secret agents'. Remember?",
	END_DIALOG
};

const static char *englishDialog208[] = {
	CHANGE_CHARACTER,
	"(sigh)",
	DISPLAY_MESSAGE,
	"A promise is a promise...",
	DISPLAY_MESSAGE,
	"Let me think.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"All right. Come here.",
	END_DIALOG
};

const static char *englishDialog209[] = {
	"In the name of...",
	DISPLAY_MESSAGE,
	"...blah...blah...blah...",
	DISPLAY_MESSAGE,
	"...blah...blah...",
	DISPLAY_MESSAGE,
	"...for our country.",
	END_DIALOG
};

const static char *englishDialog210[] = {
	"       Well...       ",
	DISPLAY_MESSAGE,
	"That's all, folks!",
	END_DIALOG
};

const static char *englishDialog211[] = {
	"I found the time pill!",
	DISPLAY_MESSAGE,
	"It must have fallen out of the jar!...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Cool.",
	END_DIALOG
};

const static char *englishDialog212[] = {
	"Wow!",
	DISPLAY_MESSAGE,
	"This is charming!...",
	END_DIALOG
};

const static char *czechDialog0[] = {
	ANIM_WAIT,
	"Dobr^ den.",
	CHANGE_CHARACTER,
	"Jo.",
	CHANGE_CHARACTER,
	"Pro$ tu tak stoj;@?",
	CHANGE_CHARACTER,
	"Zeptej se gravitace.",
	CHANGE_CHARACTER,
	"Docela vtipn^.",
	DISPLAY_MESSAGE,
	"Na voj#ka.",
	CHANGE_CHARACTER,
	"Nejsem voj#k, i kdy{ jsem se",
	NEW_LINE,
	"o to pokou@el.",
	DISPLAY_MESSAGE,
	"Neud+lalt jsem test intel...",
	NEW_LINE,
	"test zdatnosti.",
	DISPLAY_MESSAGE,
	"Na>;dili mi sest>elit let;c;",
	NEW_LINE,
	"minci zat;mco jsem sk#kal",
	NEW_LINE,
	"ze stromu na kon+.",
	CHANGE_CHARACTER,
	"Jo, to zn; komplikovan+.",
	CHANGE_CHARACTER,
	"Speci#ln; Jednotky, to nen; {#dn# sranda,",
	NEW_LINE,
	"v;@?",
	CHANGE_CHARACTER,
	"Je mi l;to, {es\' to nezvl#d.",
	CHANGE_CHARACTER,
	"Jo, minul jsem kon+.",
	END_DIALOG,
};

const static char *czechDialog1[] = {
	"Tak...",
	DISPLAY_MESSAGE,
	"A co d+l#@ te%?",
	CHANGE_CHARACTER,
	"Chce@ sly@et fakt vtipnou odpov+%?",
	CHANGE_CHARACTER,
	"Hele, ani se nenam#hej...",
	CHANGE_CHARACTER,
	"Dob>e, dob>e, ale zn#@ to, nen; tu",
	NEW_LINE,
	"{#dn# z#bava.",
	DISPLAY_MESSAGE,
	"Tak{e si ob$as chci zavtipkovat.",
	NEW_LINE,
	"N+jak# ta le-hegr#cka, v;@? He, he. He.",
	CHANGE_CHARACTER,
	"A-ha. Ha, ehm...",
	CHANGE_CHARACTER,
	"Hl;d#m to tady...",
	CHANGE_CHARACTER,
	"Wow. To je teda p>ekvapen;.",
	CHANGE_CHARACTER,
	"...a >ekli mi, {e m#m zab;t ka{d^ho,",
	NEW_LINE,
	"kdo se pokus; vej;t dovnit>.",
	CHANGE_CHARACTER,
	"Tak{e prvn; tuhej byl majitel domu, ne?",
	CHANGE_CHARACTER,
	"Je{i@, ten neni jen tak n+kdo. P>ece.",
	CHANGE_CHARACTER,
	"J# taky ne, tak{e bych mohl vej;t?",
	CHANGE_CHARACTER,
	"Ne-e.",
	CHANGE_CHARACTER,
	"A co kdy{ p+kn+ poprosim a >eknu \'b#bovka\'?",
	CHANGE_CHARACTER,
	"Ani n#pad, mladej, ani n#pad.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Pros;;;m, b##bovk###.",
	CHANGE_CHARACTER,
	"Ani n#pad.",
	NEW_LINE,
	"M#m srdce z kamene.",
	CHANGE_CHARACTER,
	"Tak{e ze stejn*ho materi#lu",
	NEW_LINE,
	"jako mozek, to je unik#t.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Nech#pu.",
	CHANGE_CHARACTER,
	"Nic si z toho ned+lej.",
	NEW_LINE,
	"Jakpak bych tedy mohl",
	NEW_LINE,
	"obm+k$it tv* srdce?",
	CHANGE_CHARACTER,
	"To nep]jde, sem tvr%#k.",
	DISPLAY_MESSAGE,
	"Ale poj% sem, d#m ti n+co",
	NEW_LINE,
	"abys ne>ekl...",
	END_DIALOG,
};

const static char *czechDialog2[] = {
	"D;ky, co to je?",
	CHANGE_CHARACTER,
	"|okol#dovej bonb=n.",
	DISPLAY_MESSAGE,
	"M]j zam+stnavatel mi jich dal p#r",
	NEW_LINE,
	"k ob+du a...",
	CHANGE_CHARACTER,
	"A je tv]j @*f doma?!",
	CHANGE_CHARACTER,
	"Pan Pankr#c Oblouk?",
	CHANGE_CHARACTER,
	"A#, tak...",
	DISPLAY_MESSAGE,
	"Pankr#c Oblouk...",
	DISPLAY_MESSAGE,
	"Mysl;m, {e jsem o n+m sly@el...",
	CHANGE_CHARACTER,
	"No bodej[. D+l# te% velk^ pen;ze, v;@?",
	NEW_LINE,
	"Hlavn+ v posledn; dob+...",
	CHANGE_CHARACTER,
	"Jo?...",
	CHANGE_CHARACTER,
	"No, j# nevim p>esn+ jak.",
	DISPLAY_MESSAGE,
	"Mo{n# to m# n+co spole$n^ho s takovym",
	NEW_LINE,
	"divnym v+dcem, co takhle jednou",
	NEW_LINE,
	"p>i@el a..",
	DISPLAY_MESSAGE,
	"A#, ty si mysl;@, {e se@ chytrej, co?!",
	NEW_LINE,
	"Nejse@ ty n#hodou @peh?!",
	CHANGE_CHARACTER,
	"Ale pros;mt+, j# a @peh? Nesmysl.",
	DISPLAY_MESSAGE,
	"J# jsem jenom oby$ejnej pas#$ek bobr] z kolchozu",
	NEW_LINE,
	"t#mhle za kopcem. Dru{ba se to tam jmenuje",
	CHANGE_CHARACTER,
	"Aha, pase@ teda bobry. Boss mi >ekl,",
	NEW_LINE,
	"abych si dal na @pi=ny velkej pozor...",
	CHANGE_CHARACTER,
	"Copak vypad#m jako n+jakej @pi=n?",
	CHANGE_CHARACTER,
	"...a abych se zab;jel na potk#n;...",
	CHANGE_CHARACTER,
	"Hele, kl;dek...",
	CHANGE_CHARACTER,
	"...a j# u{ jsem nikoho nezabil",
	NEW_LINE,
	"h===dn+ dlouhou dobu!",
	CHANGE_CHARACTER,
	"Hele to kv]li tomu bomb=nu, {ejo?",
	NEW_LINE,
	"Ty ho chce@ zp#tky, co? ~#dnej probl*m.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Promi<, nechal jsem trochu un*st.",
	CHANGE_CHARACTER,
	"Ch#pu.",
	NEW_LINE,
	"Je tu p+kn^ vedro, co?",
	CHANGE_CHARACTER,
	"Jo, to jo.",
	END_DIALOG,
};

const static char *czechDialog3[] = {
	"Pane str#{n^, j#..",
	CHANGE_CHARACTER,
	"Posly@ mladej:",
	DISPLAY_MESSAGE,
	"@peh ne@peh ned+lej si iluze,",
	NEW_LINE,
	"{e t+ pust;m do domu.",
	DISPLAY_MESSAGE,
	"Postav se t>eba na hlavu,",
	NEW_LINE,
	"ale dovnit> se prost+ nedostane@,",
	NEW_LINE,
	"mohl bys tam n+co ukr#st nebo",
	DISPLAY_MESSAGE,
	"n+jak obt+{ovat pana Oblouka.",
	DISPLAY_MESSAGE,
	"A taky u{ ze mn+ nic nedostane@.",
	DISPLAY_MESSAGE,
	"Je@t+ jeden pokus o takovejhle rozhovor",
	NEW_LINE,
	"a se@ d#lnice pro $ervy.",
	DISPLAY_MESSAGE,
	"Kap]to.",
	DISPLAY_MESSAGE,
	"Jasn^?",
	CHANGE_CHARACTER,
	"Jasn^.",
	END_DIALOG,
};

const static char *czechDialog4[] = {
	"Hezkej oblek. Od Vision?",
	CHANGE_CHARACTER,
	"Jo.",
	END_DIALOG,
};

const static char *czechDialog5[] = {
	CHANGE_CHARACTER,
	"Zatracen+!",
	DISPLAY_MESSAGE,
	"Tos zas ty!",
	END_DIALOG,
};

const static char *czechDialog6[] = {
	"Hej!",
	CHANGE_CHARACTER,
	"Co?",
	CHANGE_CHARACTER,
	"Copak je v t^ lahvi?",
	CHANGE_CHARACTER,
	"Nem]{e@ mi nic dok#zat!",
	CHANGE_CHARACTER,
	"N+jakej tvrdej, {e jo?..",
	CHANGE_CHARACTER,
	"Do toho je ti kulov^.",
	CHANGE_CHARACTER,
	"Ty chlast#@ ve slu{b+? Cha ch#, von chlast# ve slu{b+!",
	CHANGE_CHARACTER,
	"Mysl;@ si, {es\' na m+ vyzr#l, co?",
	NEW_LINE,
	"Je to tak?",
	DISPLAY_MESSAGE,
	"Lejna. M]{e@ se j;t vycpat!",
	END_DIALOG,
};

const static char *czechDialog7[] = {
	"Hej!",
	CHANGE_CHARACTER,
	"Nic si nevid+l.",
	DISPLAY_MESSAGE,
	"Jsem $istej jak cejcha.",
	END_DIALOG,
};

const static char *czechDialog8[] = {
	"Hej!",
	CHANGE_CHARACTER,
	"Vypadni.",
	END_DIALOG,
};

const static char *czechDialog9[] = {
	"Co bys >ekl tomu, kdybych ti",
	NEW_LINE,
	"dal n+jak* zlato?...",
	CHANGE_CHARACTER,
	"}ekl bych \'d+kuju\'.",
	CHANGE_CHARACTER,
	"A pustil bys m+ dovnit>?",
	CHANGE_CHARACTER,
	"}ek bych, {e jo..",
	CHANGE_CHARACTER,
	"Aha, tak a{ si bude@ jist+j@;...",
	CHANGE_CHARACTER,
	"OK, jsem si jistej. Ur$it+, ur$it+ te pust;m dovnit>.",
	CHANGE_CHARACTER,
	"Dob>e, tak tum#@.",
	END_DIALOG,
};

const static char *czechDialog10[] = {
	"Tak a te% otev>i dve>e.",
	CHANGE_CHARACTER,
	"Neexistuje, vypadni.",
	CHANGE_CHARACTER,
	"Sakra co je to? Dal jsem ti zlato!",
	CHANGE_CHARACTER,
	"Jak^ zlato?",
	CHANGE_CHARACTER,
	"Jak^ zlato?!?",
	CHANGE_CHARACTER,
	"Nevim nic o {#dn^m zlat+, vid;@ ho tady n+kde?",
	END_DIALOG,
};

const static char *czechDialog11[] = {
	"Ty... ty sr#goro!",
	CHANGE_CHARACTER,
	"Padej malej.",
	CHANGE_CHARACTER,
	"}ek\' si, {e m+ za zlato pust;@ dovnit>!",
	DISPLAY_MESSAGE,
	"A ty m+ p>itom pou@t;@ k vod+!",
	CHANGE_CHARACTER,
	"To jo, ale m]{e@ bejt aspo< r#d,",
	NEW_LINE,
	"{e k t^ vod+ odejde@ celej.",
	END_DIALOG,
};

const static char *czechDialog12[] = {
	"V dne@n; nechutn^ dob+ nem]{e@ v+>it",
	NEW_LINE,
	"ani dementn;m zkorumpovan^m str#{c]m!",
	END_DIALOG,
};

const static char *czechDialog13[] = {
	"|au.",
	CHANGE_CHARACTER,
	"Ahoj.",
	CHANGE_CHARACTER,
	"J# jsem Kevin.",
	DISPLAY_MESSAGE,
	"}ekni mi, jak se jmenuje@ ty.",
	CHANGE_CHARACTER,
	"Jak se jmenuje@ ty?",
	CHANGE_CHARACTER,
	"No j# to nevim, to pr#v+ mus;@ ty >;ct mn+...",
	CHANGE_CHARACTER,
	"Mn+.",
	CHANGE_CHARACTER,
	"Ne>;kej jenom \'mn+\', >ekni",
	NEW_LINE,
	"svoje jm*no! (Bo{e!)",
	CHANGE_CHARACTER,
	"Svoje jm*..",
	CHANGE_CHARACTER,
	"A#! V@ude jsou tu sam; vypatlanci a dementi!",
	DISPLAY_MESSAGE,
	"A jak ti >;k# tat;nek?",
	CHANGE_CHARACTER,
	"Synku.",
	CHANGE_CHARACTER,
	"Synek jako jm*no a nebo synek jako",
	NEW_LINE,
	"prost+ jenom synek? (U{ mi z toho jebe)",
	CHANGE_CHARACTER,
	"Synek.",
	CHANGE_CHARACTER,
	"Jse@ debiln; nebo jenom drzej?",
	CHANGE_CHARACTER,
	"Synek, to jsem.",
	CHANGE_CHARACTER,
	"(Asi dement, uff, ale m# gr#dy!)",
	END_DIALOG,
};

const static char *czechDialog14[] = {
	"Poslouhej, synku nebo n+co.",
	DISPLAY_MESSAGE,
	"Co se pokou@;@ d+lat s t;m",
	NEW_LINE,
	"basketov^m bal=nem?",
	CHANGE_CHARACTER,
	"D+da >;kal, {e m+ vezme do ZOO,",
	NEW_LINE,
	"kdy{ d#m ko@.",
	CHANGE_CHARACTER,
	"}ekl bych, {e bys m+l ten m;$ h#zet",
	NEW_LINE,
	"o trochu v^@, vej@ jako nahoru, ch#pe@?",
	CHANGE_CHARACTER,
	"Jo, ch#pu.",
	CHANGE_CHARACTER,
	"Tak co?",
	CHANGE_CHARACTER,
	"Co?",
	CHANGE_CHARACTER,
	"Tak pro$ to neud+l#@?! (U{ to zas za$;n#)",
	CHANGE_CHARACTER,
	"Mus;m m;t asi n+co s o$ima.",
	NEW_LINE,
	"Jo, asi ty o$i.",
	CHANGE_CHARACTER,
	"Jako {e bys m+l m;t brejle, ne?",
	CHANGE_CHARACTER,
	"Ne, pro$?",
	CHANGE_CHARACTER,
	"(Sprcha! Kde je?)",
	DISPLAY_MESSAGE,
	"Mo{n# jse@ jenom moc slabej,",
	NEW_LINE,
	"abys hodil m;$ tak vysoko.",
	CHANGE_CHARACTER,
	"Vysoko.",
	CHANGE_CHARACTER,
	"(Aa####, je fakt TVRDEJ!)",
	END_DIALOG,
};

const static char *czechDialog15[] = {
	"Hele, synku!",
	DISPLAY_MESSAGE,
	"M#m bezva n#pad!",
	CHANGE_CHARACTER,
	"Fakt?",
	CHANGE_CHARACTER,
	"Jdi za d+de$kem a >ekni mu,",
	NEW_LINE,
	"{es\' hodil ko@!",
	CHANGE_CHARACTER,
	"To jako mysl;@ lh#t?",
	CHANGE_CHARACTER,
	"No jo, tak n+jak...",
	CHANGE_CHARACTER,
	"J# NIKDY NEL~U!",
	CHANGE_CHARACTER,
	"Nikdy?!",
	CHANGE_CHARACTER,
	"NIKDY!",
	CHANGE_CHARACTER,
	"To se@ teda hodnej kluk (grrr).",
	END_DIALOG,
};

const static char *czechDialog16[] = {
	"Hej...",
	CHANGE_CHARACTER,
	"\'di pry$.",
	END_DIALOG,
};

const static char *czechDialog17[] = {
	"Hele synku, to je neuv+>iteln^!",
	CHANGE_CHARACTER,
	"Co?",
	CHANGE_CHARACTER,
	"Mo{n# si bude@ myslet, {e je to vtip,",
	NEW_LINE,
	"ale z jezera $ouh# ruka a dr{;",
	NEW_LINE,
	"nov* vyd#n; Brava!",
	CHANGE_CHARACTER,
	"OK, jdu se tam pod;vat, ale nemysli si,",
	NEW_LINE,
	"{e m+ obel{e@.",
	NEW_LINE,
	"Norm#ln; utopenej po@[#k.",
	DISPLAY_MESSAGE,
	"Mo{n# te% budu m;t v+t@; @t+st;",
	NEW_LINE,
	"v basketu...",
	END_DIALOG,
};

const static char *czechDialog18[] = {
	"Dobr^ den, pane!",
	CHANGE_CHARACTER,
	"Dobr^ den, synku.",
	CHANGE_CHARACTER,
	"Jmenuju se Kevin, pane.",
	CHANGE_CHARACTER,
	"Skv+l*.",
	DISPLAY_MESSAGE,
	"Co chce@?",
	CHANGE_CHARACTER,
	"P>i@el jsem obdivovat va@e k>eslo.",
	DISPLAY_MESSAGE,
	"P+knej kousek.",
	CHANGE_CHARACTER,
	"P+knej a stylovej",
	NEW_LINE,
	"Taky pohodlnej.",
	CHANGE_CHARACTER,
	"A velkej.",
	CHANGE_CHARACTER,
	"Model pro dva.",
	END_DIALOG,
};

const static char *czechDialog19[] = {
	"Zn#te chlapce hraj;c;ho venku basket?",
	NEW_LINE,
	"Hopsaj;c;ho s m;$em.",
	NEW_LINE,
	"};k# si \'Synek\'",
	CHANGE_CHARACTER,
	"Samoz>ejm+,",
	NEW_LINE,
	"je to m]j vnuk.",
	CHANGE_CHARACTER,
	"P+knej kluk. Trochu jako buk (V hlav+).",
	CHANGE_CHARACTER,
	"Hodnej a chytrej.",
	CHANGE_CHARACTER,
	"Taky trochu malej (A tvrdej po d+dovi).",
	CHANGE_CHARACTER,
	"Vyroste.",
	CHANGE_CHARACTER,
	"A stane se z n+j tak slavnej basketbalovej",
	NEW_LINE,
	"hr#$ jako je Magic Johnson, {e?",
	CHANGE_CHARACTER,
	"No, to se, douf#m, nestane.",
	CHANGE_CHARACTER,
	"Tak mu >ekn+te, a[ p>estane hr#t!",
	CHANGE_CHARACTER,
	"Jo, to jo.",
	DISPLAY_MESSAGE,
	"Pozd+ji.",
	DISPLAY_MESSAGE,
	"Mo{n#.",
	DISPLAY_MESSAGE,
	"Te% si pot>ebuju trochu",
	NEW_LINE,
	"odpo$inout...",
	END_DIALOG,
};

const static char *czechDialog20[] = {
	"Budete tady sed+t celej den?",
	NEW_LINE,
	"Jenom si tak sed+t a d;vat se na vzduch?",
	CHANGE_CHARACTER,
	"To douf#m.",
	CHANGE_CHARACTER,
	"Kdy{ je venku tak kr#snej den?",
	CHANGE_CHARACTER,
	"To douf#m.",
	CHANGE_CHARACTER,
	"Copak v#s sv+t venku",
	NEW_LINE,
	"v]bec nezaj;m#?!",
	CHANGE_CHARACTER,
	"Ani ne.",
	CHANGE_CHARACTER,
	"A co to?",
	CHANGE_CHARACTER,
	"Nezaj;maj; m+ nov* v+ci.",
	CHANGE_CHARACTER,
	"Ale...",
	CHANGE_CHARACTER,
	"Jak se >;k#...",
	DISPLAY_MESSAGE,
	"Nejlep@; zpr#vy -",
	NEW_LINE,
	"{#dn* zpr#vy.",
	CHANGE_CHARACTER,
	"Ale lidi se mus; zaj;mat",
	NEW_LINE,
	"o pokrok nebo tak n+co!",
	CHANGE_CHARACTER,
	"Ani se nebudu obt+{ovat",
	NEW_LINE,
	"pt#t se t+, pro$ by to tak m+lo b^t...",
	CHANGE_CHARACTER,
	"Proto{e...",
	DISPLAY_MESSAGE,
	"Er...",
	DISPLAY_MESSAGE,
	"Proto{e...",
	DISPLAY_MESSAGE,
	"Umm...",
	CHANGE_CHARACTER,
	"Aha.",
	NEW_LINE,
	"    ",
	END_DIALOG,
};

const static char *czechDialog21[] = {
	"N+co nov*ho?",
	CHANGE_CHARACTER,
	"Douf#m, {e ne.",
	END_DIALOG,
};

const static char *czechDialog22[] = {
	"M]{u si p]j$it va@i brokovnici?",
	CHANGE_CHARACTER,
	"Vra[ se do hrobu.",
	CHANGE_CHARACTER,
	"P+kn+ prosim...",
	CHANGE_CHARACTER,
	"Mlad^ mu{i, tato zbra< je",
	NEW_LINE,
	"u{ velmi star# a je tuze nebezpe$n#...",
	DISPLAY_MESSAGE,
	"a j# jsem zodpov+dn^ $lov+k,",
	NEW_LINE,
	"ch#pe@?",
	CHANGE_CHARACTER,
	"Ale j# u{ dohr#l i Doom II...",
	CHANGE_CHARACTER,
	"Ne.",
	END_DIALOG,
};

const static char *czechDialog23[] = {
	"Mo{n# jste si to s tou pu@kou",
	NEW_LINE,
	"u{ rozmyslel, t>eba..",
	CHANGE_CHARACTER,
	"Ne.",
	DISPLAY_MESSAGE,
	"Nope.",
	DISPLAY_MESSAGE,
	"Niet.",
	DISPLAY_MESSAGE,
	"Nein.",
	DISPLAY_MESSAGE,
	"Niente.",
	DISPLAY_MESSAGE,
	"Nie.",
	DISPLAY_MESSAGE,
	"No.",
	CHANGE_CHARACTER,
	"OK, ch#pu to.",
	END_DIALOG,
};

const static char *czechDialog24[] = {
	"M]{u v#m prohledat @uplata?",
	CHANGE_CHARACTER,
	"Ano.",
	CHANGE_CHARACTER,
	"ANO?!?",
	CHANGE_CHARACTER,
	"Oh, zapomn+l jsem ti >;ct, {e jsou v@echna pr#zdn#.",
	DISPLAY_MESSAGE,
	"Jenom v prav*m horn;m je uschov#n kapesn;k.",
	DISPLAY_MESSAGE,
	"Jestli chce@, m]{e@ si ho vz;t, nepot>ebuju ho.",
	CHANGE_CHARACTER,
	"No, tak d+kuju.",
	DISPLAY_MESSAGE,
	"Jste velmi... posoplen..",
	CHANGE_CHARACTER,
	"Ale nemysli si, {e t+ nech#m",
	NEW_LINE,
	"vz;t si n+co dal@;ho.",
	CHANGE_CHARACTER,
	"Samoz>ejm+, to by m+ ani nenapadlo.",
	END_DIALOG,
};

const static char *czechDialog25[] = {
	"M]{u si p]j$it tenhle v+tr#k?",
	CHANGE_CHARACTER,
	"V {#dn*m p>;pad+, pr#v+ ho pou{;v#m.",
	END_DIALOG,
};

const static char *czechDialog26[] = {
	"Tenhleten v+tr#k...",
	CHANGE_CHARACTER,
	"P>ij% se zeptat a{ v zim+.",
	END_DIALOG,
};

const static char *czechDialog27[] = {
	"To m#me dneska p+kn^",
	NEW_LINE,
	"po$as;..",
	CHANGE_CHARACTER,
	"Tak, tak, to m#me,",
	NEW_LINE,
	"m]j mil^.",
	END_DIALOG,
};

const static char *czechDialog28[] = {
	"To je va@e pra.. va@e dcera?",
	CHANGE_CHARACTER,
	"Je od tebe hezk*,",
	NEW_LINE,
	"m]j drah^, {e m+ d+l#@",
	NEW_LINE,
	"tak mladou,",
	DISPLAY_MESSAGE,
	"ale tahle",
	NEW_LINE,
	"d;vka je moje",
	NEW_LINE,
	"vnu$ka.",
	CHANGE_CHARACTER,
	"Aha, tak je to! Opravdu",
	NEW_LINE,
	"vypad# dob>e! (To je kus, co?)",
	CHANGE_CHARACTER,
	"Jednou jsem byla",
	NEW_LINE,
	"tak* takov#...",
	CHANGE_CHARACTER,
	"Ale to vy po>#d je@t+ jste!",
	CHANGE_CHARACTER,
	"To je od tebe sladk*, {e to >;k#@..",
	DISPLAY_MESSAGE,
	"ale nikdo u{ nezp;v#",
	NEW_LINE,
	"pod m^m oknem,",
	DISPLAY_MESSAGE,
	"jestli v;@",
	NEW_LINE,
	"co t;m mysl;m.",
	CHANGE_CHARACTER,
	"Errr...",
	DISPLAY_MESSAGE,
	"Ano...",
	DISPLAY_MESSAGE,
	"To vim...",
	DISPLAY_MESSAGE,
	"N+kdy m#m",
	NEW_LINE,
	"podobn* pocity...",
	DISPLAY_MESSAGE,
	"i j# s#m...",
	DISPLAY_MESSAGE,
	"asi...",
	END_DIALOG,
};

const static char *czechDialog29[] = {
	"M]{u se zeptat, co to",
	NEW_LINE,
	"d+l#te?",
	CHANGE_CHARACTER,
	"Ano, m]{e@,",
	NEW_LINE,
	"m]j drah^.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Co to d+l#te?",
	CHANGE_CHARACTER,
	"Pletu.",
	CHANGE_CHARACTER,
	"Ch#pu.",
	DISPLAY_MESSAGE,
	"Co pletete?",
	CHANGE_CHARACTER,
	"Tentokr#t ses",
	NEW_LINE,
	"m+ nezeptal, zdalipak",
	NEW_LINE,
	"se m]{e@ zeptat.",
	CHANGE_CHARACTER,
	"Oh, promi<te. M]{u se tedy zeptat?",
	CHANGE_CHARACTER,
	"Zeptat na co?",
	CHANGE_CHARACTER,
	"Na to, co pletete.",
	NEW_LINE,
	"(Za$;n# se to komplikovat)",
	CHANGE_CHARACTER,
	"Na to u{ ses",
	NEW_LINE,
	"m+ p>ed chv;l; ptal",
	NEW_LINE,
	"nebo ne?",
	END_DIALOG,
};

const static char *czechDialog30[] = {
	"Je v@echno v po>#dku, nebol; v#s b>icho?",
	CHANGE_CHARACTER,
	"Ano, v@echno je v naprost*m po>#dku.",
	END_DIALOG,
};

const static char *czechDialog31[] = {
	"Je v@echno v po>#dku, netla$; v#s lopatky?",
	CHANGE_CHARACTER,
	"V{dy[ v;@. V@echno je, jak m# b^t.",
	END_DIALOG,
};

const static char *czechDialog32[] = {
	"Je v@echno v po>#dku, nem#te nad^m#n;?",
	CHANGE_CHARACTER,
	"Je hezk*, {e se pt#@,",
	NEW_LINE,
	"ale u{ jsem ti to",
	NEW_LINE,
	">;kala n+kolikr#t.",
	END_DIALOG,
};

const static char *czechDialog33[] = {
	"Je v@echno v po>#dku, nec;t;te se mdle?",
	CHANGE_CHARACTER,
	"Neopakuj se.",
	END_DIALOG,
};

const static char *czechDialog34[] = {
	"Je v@echno v po>#dku, nep#l; v#s",
	NEW_LINE,
	"{#ha nebo nebol; chodidla?",
	CHANGE_CHARACTER,
	"Nep>eru@uj mou pr#ci.",
	END_DIALOG,
};

const static char *czechDialog35[] = {
	"Je v@echno v po>#dku?",
	NEW_LINE,
	"U@i, nos, \\sta, krk, h^{d+,",
	NEW_LINE,
	"n+co takov*ho?",
	CHANGE_CHARACTER,
	"Dr{ ml$.",
	END_DIALOG,
};

const static char *czechDialog36[] = {
	"Je v@echno v po>#dku?",
	END_DIALOG,
};

const static char *czechDialog37[] = {
	"Promi<te moji",
	NEW_LINE,
	"vlezlost...",
	CHANGE_CHARACTER,
	"Ano?...",
	CHANGE_CHARACTER,
	"...ale koupil jsem tuto",
	NEW_LINE,
	"nevinnou",
	NEW_LINE,
	"kv+tinu...",
	DISPLAY_MESSAGE,
	"...kter# symbolizuje",
	NEW_LINE,
	"moje pot+@en;",
	NEW_LINE,
	"{e jsem se s v#mi setkal.",
	END_DIALOG,
};

const static char *czechDialog38[] = {
	"Douf#m,",
	NEW_LINE,
	"{e se v#m bude l;bit...",
	CHANGE_CHARACTER,
	"Oh, mil^!",
	DISPLAY_MESSAGE,
	"C;t;m se opravdu",
	NEW_LINE,
	"@[astna...",
	DISPLAY_MESSAGE,
	"To je nejhez$; v+c,",
	NEW_LINE,
	"co pro mne n+kdo",
	NEW_LINE,
	"za posledn;ch deset let...",
	DISPLAY_MESSAGE,
	"...ud+lal!",
	DISPLAY_MESSAGE,
	"D+kuji ti!",
	CHANGE_CHARACTER,
	"Nen; za$. (ufff)",
	END_DIALOG,
};

const static char *czechDialog39[] = {
	"Cht+la byste je@t+",
	NEW_LINE,
	"jednu kv+tinu?",
	CHANGE_CHARACTER,
	"Jsi velmi hodn^,",
	NEW_LINE,
	"m]j mil^, ale ne,",
	NEW_LINE,
	"d+kuji.",
	END_DIALOG,
};

const static char *czechDialog40[] = {
	"Jste si jist#, {e",
	NEW_LINE,
	"nechcete dal@; kv+tinu?",
	CHANGE_CHARACTER,
	"Ano. Jsem si jist#.",
	END_DIALOG,
};

const static char *czechDialog41[] = {
	"Mohl bych si p]j$it tenhle",
	NEW_LINE,
	"opra@ova$?",
	CHANGE_CHARACTER,
	"Nezn#me se je@t+ tak dob>e,",
	NEW_LINE,
	"abych ti p]j$ovala",
	NEW_LINE,
	"v+ci na dobr* slovo...",
	DISPLAY_MESSAGE,
	"...mo{n# a{ se l*pe pozn#me",
	NEW_LINE,
	"nebudu m;t",
	NEW_LINE,
	"nic proti.",
	CHANGE_CHARACTER,
	"Copak vypad#m nespolehliv+?",
	CHANGE_CHARACTER,
	"U{ jsem >ekla.",
	END_DIALOG,
};

const static char *czechDialog42[] = {
	"Zm+nilo se n+co okolo kausy",
	NEW_LINE,
	"p]j$ov#n; opra@ova$e?",
	CHANGE_CHARACTER,
	"Docela se mi zamlouv# tam, kde je.",
	END_DIALOG,
};

const static char *czechDialog43[] = {
	"Mysl;te, {e bych si mohl",
	NEW_LINE,
	"p]j$it opra@ova$",
	NEW_LINE,
	"te%, kdy{...?",
	CHANGE_CHARACTER,
	"Ale samoz>ejm+,",
	NEW_LINE,
	"nevid;m d]vod, pro$ bych nemohla...",
	DISPLAY_MESSAGE,
	"...vypomoci takov*mu mil*mu",
	NEW_LINE,
	"mlad*mu mu{i jako jse@ ty!..",
	CHANGE_CHARACTER,
	"Mnohokr#t v#m d+kuji. (to ale trvalo, babo!)",
	END_DIALOG,
};

const static char *czechDialog44[] = {
	"Ha! Jsem p>ece rychlej@; ne{ pr]jem!",
	CHANGE_CHARACTER,
	"V@echno jsem to vid+la, chlap$e!",
	END_DIALOG,
};

const static char *czechDialog45[] = {
	"Er...",
	DISPLAY_MESSAGE,
	"Uh...",
	DISPLAY_MESSAGE,
	"J# jenom...",
	CHANGE_CHARACTER,
	"To je v po>#dku, jenom douf#m,",
	NEW_LINE,
	"{es\' tu mouchu alespo< zabil.",
	END_DIALOG,
};

const static char *czechDialog46[] = {
	"Promi<te, pan;, ale >ekl bych,",
	NEW_LINE,
	"{e je va@e pr#dlo u{ such*...",
	DISPLAY_MESSAGE,
	"...tak{e by ho te% slunko mohlo",
	NEW_LINE,
	"zbyte$n+ vykrabatit a nakrabatit...",
	CHANGE_CHARACTER,
	"Jak je mo{n*, {e uschnulo tak rychle?",
	DISPLAY_MESSAGE,
	"Rad@i se na to p]jdu pod;vat.",
	END_DIALOG,
};

const static char *czechDialog47[] = {
	CHANGE_CHARACTER,
	"M+l jsi pravdu chlap$e.",
	DISPLAY_MESSAGE,
	"D+kuji ti.",
	CHANGE_CHARACTER,
	"Nen; za$.",
	END_DIALOG,
};

const static char *czechDialog48[] = {
	"Pot>ebujete to um+l* jablko?",
	CHANGE_CHARACTER,
	"Z#le{; na tom. O tom jablku bych",
	NEW_LINE,
	"toho mohla mnoho vypr#v+t.",
	DISPLAY_MESSAGE,
	"Vzpom;n#m si, jak jednoho dne",
	NEW_LINE,
	"moje mlad@; sestra Marie",
	NEW_LINE,
	"zkou@ela...",
	CHANGE_CHARACTER,
	"Er, jak je to pov;d#n; asi dlouh*?",
	CHANGE_CHARACTER,
	"Oh, nen; p>ece kam sp+chat.",
	DISPLAY_MESSAGE,
	"M#me na mluven; cel* hodiny,",
	NEW_LINE,
	"ne?",
	CHANGE_CHARACTER,
	"Jak tak o tom p>em^@l;m, j# to jablko",
	NEW_LINE,
	"vlastn+ ani nepot>ebuju.",
	DISPLAY_MESSAGE,
	"D+kuju.",
	END_DIALOG,
};

const static char *czechDialog49[] = {
	"To jabko...",
	CHANGE_CHARACTER,
	"~#dn^ p>;b+h, {#dn* jablko.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"~#dn* jablko.",
	END_DIALOG,
};

const static char *czechDialog50[] = {
	"Mohla by to bejt...",
	DISPLAY_MESSAGE,
	"...nev+t@; ko$ka ze v@ech ko$ek...",
	DISPLAY_MESSAGE,
	"na cel*m sv+t+?...",
	END_DIALOG,
};

const static char *czechDialog51[] = {
	"Mysl;m si, {e je nejvy@@; $as,",
	NEW_LINE,
	"abych se p>edstavil.",
	DISPLAY_MESSAGE,
	"J# jsem Kevin.",
	CHANGE_CHARACTER,
	"Anna.",
	END_DIALOG,
};

const static char *czechDialog52[] = {
	"Ten moment, co jsem zahl*dl ty o$i,",
	NEW_LINE,
	"to byla snad nejkr#sn+j@; chv;le",
	NEW_LINE,
	"m*ho {ivota.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Teda kdy{ nepo$;t#m,",
	NEW_LINE,
	"jak jsme hr#li na doktora",
	NEW_LINE,
	"se Zuzanou.",
	END_DIALOG,
};

const static char *czechDialog53[] = {
	"Uh...",
	DISPLAY_MESSAGE,
	"Ehm...",
	DISPLAY_MESSAGE,
	"J# jenom...",
	DISPLAY_MESSAGE,
	"Jenom jestli",
	NEW_LINE,
	"bys necht+la",
	NEW_LINE,
	"n+jak*...",
	DISPLAY_MESSAGE,
	"Er...",
	DISPLAY_MESSAGE,
	"toti{...",
	DISPLAY_MESSAGE,
	"M#m n+co",
	NEW_LINE,
	"co bych dal...",
	NEW_LINE,
	"teda tob+ dal, proto{e...",
	DISPLAY_MESSAGE,
	"Uh...",
	DISPLAY_MESSAGE,
	"Mysl;m, {e",
	NEW_LINE,
	"jsi... A...",
	CHANGE_CHARACTER,
	"Hej! J# nekou@u!",
	DISPLAY_MESSAGE,
	"evidentn+ mi chce@ >;ct n+co hezk^ho,",
	NEW_LINE,
	"tak jen do toho.",
	DISPLAY_MESSAGE,
	"}ekni to prost+ jednoduch^mi",
	NEW_LINE,
	"slovy...",
	CHANGE_CHARACTER,
	"Jednoduch^mi slovy?!",
	CHANGE_CHARACTER,
	"Ano, jednoduch# slova d+laj;",
	NEW_LINE,
	"v+ci jednodu@@;.",
	CHANGE_CHARACTER,
	"Oh, ano.",
	DISPLAY_MESSAGE,
	"OK.",
	DISPLAY_MESSAGE,
	"Jednoduch# slova.",
	DISPLAY_MESSAGE,
	"OK.",
	DISPLAY_MESSAGE,
	"Tak teda jo.",
	DISPLAY_MESSAGE,
	"J# t+ l;bit se a",
	NEW_LINE,
	"cht;t d#t kytku.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"}ekla bych, {e tohle bylo a{ moc",
	NEW_LINE,
	"zjednodu@en*, mohl bys zkusit...",
	DISPLAY_MESSAGE,
	"...n+co trochu komplikovan+j@;ho.",
	CHANGE_CHARACTER,
	"Uh...",
	DISPLAY_MESSAGE,
	"Promi<...",
	DISPLAY_MESSAGE,
	"J# jenom...",
	DISPLAY_MESSAGE,
	"jenom jsem ti donesl",
	NEW_LINE,
	"kytku.",
	CHANGE_CHARACTER,
	"Oh?...",
	END_DIALOG,
};

const static char *czechDialog54[] = {
	"L;b; se ti?",
	CHANGE_CHARACTER,
	"Se@ @armantn;.",
	END_DIALOG,
};

const static char *czechDialog55[] = {
	"J#, vlastn+...",
	CHANGE_CHARACTER,
	"Jednoduch# slova, chlap$e!",
	NEW_LINE,
	"Jednoduch# slova!",
	END_DIALOG,
};

const static char *czechDialog56[] = {
	"Oh, ano...",
	DISPLAY_MESSAGE,
	"Cht+l jsem jenom >;ci,",
	NEW_LINE,
	"{e jse@ velk#",
	NEW_LINE,
	"ko$ka.",
	CHANGE_CHARACTER,
	"No to bych asi m+la pod+kovat za poklonu,",
	NEW_LINE,
	"d+kuju.",
	END_DIALOG,
};

const static char *czechDialog57[] = {
	"(Ve$er bude sebetr^ze<)",
	END_DIALOG,
};

const static char *czechDialog58[] = {
	"M#m je@t+ jednu",
	NEW_LINE,
	"kv+tinu...",
	CHANGE_CHARACTER,
	"No, rad+ji to",
	NEW_LINE,
	"nep>eh#n+jme.",
	DISPLAY_MESSAGE,
	"A jak vid;@, j# tu nejsem jedin# {ena...",
	DISPLAY_MESSAGE,
	"...v tomto pokoji...",
	END_DIALOG,
};

const static char *czechDialog59[] = {
	"Tak{e ty nechce@",
	NEW_LINE,
	"dal@; kytku?",
	CHANGE_CHARACTER,
	"Ne, d+kuju.",
	END_DIALOG,
};

const static char *czechDialog60[] = {
	"Cht+la bys cukr#tko?",
	CHANGE_CHARACTER,
	"Se@ roztomilej, ale chci b^t",
	NEW_LINE,
	"@t;hl#, nej;m sladk*.",
	CHANGE_CHARACTER,
	"Ned+lej si s t;m takov* starosti",
	NEW_LINE,
	"i Hardy a Obelix maj; kamar#dy.",
	CHANGE_CHARACTER,
	"Hardy a Obelix?!",
	CHANGE_CHARACTER,
	"Er, zapome< na to. j# jenom, {e jsem",
	NEW_LINE,
	"tadyten bonb=n na@el...",
	CHANGE_CHARACTER,
	"Tys ho na@el?!",
	CHANGE_CHARACTER,
	"...na@el v jednom luxusn;m obchod+,",
	NEW_LINE,
	"le{el tam vystavenej.",
	DISPLAY_MESSAGE,
	"Nen; to {#dn# levn# pseudo $okol#da,",
	NEW_LINE,
	"ale maxim#ln+ kvalitn; zbo{;!",
	DISPLAY_MESSAGE,
	"Je to jenom z p>;rodn;ch v+c;.",
	NEW_LINE,
	"(A[ u{ si to sakra vezme,",
	NEW_LINE,
	"m#m z toho u{ bolen;).",
	DISPLAY_MESSAGE,
	"~#dn* prezervativy v tom nejsou,",
	NEW_LINE,
	"vlastn+ nen; v tom nic prezerv...",
	CHANGE_CHARACTER,
	"Tak dob>e, kdy{ tolik nal*h#@...",
	END_DIALOG,
};

const static char *czechDialog61[] = {
	ANIM_WAIT,
	"Khm...",
	CHANGE_CHARACTER,
	"Jasn+, asi bych ti m+la",
	NEW_LINE,
	"taky n+co d#t...",
	CHANGE_CHARACTER,
	"Ale to n*... To samoz>ejm+",
	NEW_LINE,
	"nemus;@...",
	CHANGE_CHARACTER,
	"OK. Jak si p>eje@.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"No, kdy{ tak nad t;m p>em^@l;m...",
	CHANGE_CHARACTER,
	"Tu@ila jsem to. Vy kluci v{dycky",
	NEW_LINE,
	"\'n+co\' chcete.",
	DISPLAY_MESSAGE,
	"Zadarmo nehrabete nikdy,",
	NEW_LINE,
	"jste hor@; ne{ ku>ata.",
	CHANGE_CHARACTER,
	"Jednou jsem si uklidil pokoj.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Dob>e...",
	DISPLAY_MESSAGE,
	"Zapome< na to.",
	DISPLAY_MESSAGE,
	"Tady je m]j d#rek pro",
	NEW_LINE,
	"tebe.",
	DISPLAY_MESSAGE,
	"Je to moje stuha na vlasy.",
	NEW_LINE,
	"Mo{n# si na m+ n+kdy vzpomene@.",
	END_DIALOG,
};

const static char *czechDialog62[] = {
	"D+kuju.",
	NEW_LINE,
	"Ur$it+ se bude hodit.",
	END_DIALOG,
};

const static char *czechDialog63[] = {
	"Na@el jsem tvoje jm*no na bankovce,",
	NEW_LINE,
	"kterou mi dal n+jakej tlus[och.",
	NEW_LINE,
	"V;@ o tom n+co?",
	CHANGE_CHARACTER,
	"Uka{ mi tu bankovku.",
	END_DIALOG,
};

const static char *czechDialog64[] = {
	"Copak je?!",
	CHANGE_CHARACTER,
	"Oh, tohle!...",
	CHANGE_CHARACTER,
	"Pro$ bre$;@?!",
	CHANGE_CHARACTER,
	"Tahle... tahle...",
	DISPLAY_MESSAGE,
	"To jsem si nazaslou{ila!...",
	DISPLAY_MESSAGE,
	"N#@... soused, pan.",
	NEW_LINE,
	"Pankr#c Oblouk mi jednoho dne",
	NEW_LINE,
	"p#r pen+z...",
	DISPLAY_MESSAGE,
	"...a >;kal, {e kdy{ mu d#m",
	NEW_LINE,
	"pusu, tak {e mi d#",
	NEW_LINE,
	"v;c...a kdy{ mu d#m kalhotky, tak...",
	DISPLAY_MESSAGE,
	"...ale m+ se to nezd#lo,",
	NEW_LINE,
	"tak jsem mu ty...(smrk)",
	NEW_LINE,
	"pen;ze vr#tila.",
	CHANGE_CHARACTER,
	"Chce@ >;ct, {e se t+ to prase",
	NEW_LINE,
	"pokusilo koupit?!",
	CHANGE_CHARACTER,
	"Jsem tak ne@[astn#!",
	CHANGE_CHARACTER,
	"Tak a je vymalov#no.",
	NEW_LINE,
	"Ten chlap;k skon$il!",
	END_DIALOG,
};

const static char *czechDialog65[] = {
	"Hej, ty!",
	DISPLAY_MESSAGE,
	"Podala bys\' mi, pros;m ten o>ech,",
	NEW_LINE,
	"co le{; vedle tebe?",
	END_DIALOG,
};

const static char *czechDialog66[] = {
	"Tak sakra, pod#@ mi ten o>ech nebo ne?!",
	END_DIALOG,
};

const static char *czechDialog67[] = {
	"Tak jo.",
	DISPLAY_MESSAGE,
	"Dostane@, co si zaslou{;@.",
	DISPLAY_MESSAGE,
	"Budu ti nad#vat tak dlouho, a{ ti.",
	DISPLAY_MESSAGE,
	"studem vyra@; druhej ocas.",
	DISPLAY_MESSAGE,
	"Ty hnusn# veverko debiln; vypatlan#...",
	END_DIALOG,
};

const static char *czechDialog68[] = {
	"Ahoj, j# jsem z laborato>;.",
	NEW_LINE,
	"Sh#n;me vzorky vever$;ch ko{e@in...",
	END_DIALOG,
};

const static char *czechDialog69[] = {
	"Tak d;ky na o>ech, za to t+ neud#m.",
	END_DIALOG,
};

const static char *czechDialog70[] = {
	"Ale j# jsem se nikoho nezeptal,",
	NEW_LINE,
	"jestli si tenhle provaz m]{u p]j$it.",
	DISPLAY_MESSAGE,
	"|etl jsem v novin#ch, {e br#t si n+$; ",
	NEW_LINE,
	"majetek bez dovolen; je trestn*.",
	DISPLAY_MESSAGE,
	"Mohli by m+ p>i tom chytit,",
	NEW_LINE,
	"a bylo by zle.",
	DISPLAY_MESSAGE,
	"Taky by m+ pak @oupli do v+zen;",
	NEW_LINE,
	"a tam by m+ tr^znili malomocn; cik#ni.",
	DISPLAY_MESSAGE,
	"Mohl bych si t;m po[apat celej {ivot.",
	END_DIALOG,
};

const static char *czechDialog71[] = {
	"I kdy{, kdo krade, m# za t>i.",
	END_DIALOG,
};

const static char *czechDialog72[] = {
	"Posly@te, kamar#di, bu% odsud",
	NEW_LINE,
	"okam{it+ vypadnete,",
	DISPLAY_MESSAGE,
	"nebo budu muset st>;let.",
	DISPLAY_MESSAGE,
	"Opravdovou boucha$kou.",
	DISPLAY_MESSAGE,
	"A to bude v#@ Doom.",
	END_DIALOG,
};

const static char *czechDialog73[] = {
	"N+co jsem nachmatal...",
	DISPLAY_MESSAGE,
	"...je to...",
	DISPLAY_MESSAGE,
	"PAVOUK!!!",
	END_DIALOG,
};

const static char *czechDialog74[] = {
	"Ne, {e bych byl n+jakej srab.",
	DISPLAY_MESSAGE,
	"Ale m]{e to bejt n+jakej zmutovanej",
	NEW_LINE,
	"pavouk, kterej by m+ moh\'",
	NEW_LINE,
	"p+kn+ pokousat...",
	DISPLAY_MESSAGE,
	"...a j# bych pak byl taky mutant...",
	DISPLAY_MESSAGE,
	"...a @lo by po mn+ spousta",
	NEW_LINE,
	"mutantobijc]...",
	DISPLAY_MESSAGE,
	"...taky bych musel d+lat takov^ ty obli$eje...",
	DISPLAY_MESSAGE,
	"...co mutanti oby$ejn+ d+l#vaj;",
	NEW_LINE,
	"Vy i J# bych pak mohl p>ij;t k \\razu...",
	DISPLAY_MESSAGE,
	"...a ka{dej by m+ cht+l >ezat",
	NEW_LINE,
	"a pitvat a kr#jet...",
	DISPLAY_MESSAGE,
	"a \\chylov* by m+ dokonce cht+li DO POSTELE!",
	END_DIALOG,
};

const static char *czechDialog75[] = {
	"M#m v;tr z pavouka...",
	END_DIALOG,
};

const static char *czechDialog76[] = {
	"Hal=, mladej je{ku!",
	DISPLAY_MESSAGE,
	"M#m pro tebe jeden slu@nej n#vrh.",
	DISPLAY_MESSAGE,
	"Velk^ $erstv^ @[avnat^ jabko",
	NEW_LINE,
	"ti vym+nim za tu malou zpuch>elou",
	DISPLAY_MESSAGE,
	"@i@ku, co m#@ na z#dech.",
	NEW_LINE,
	"Jestli to bere@, kejvni $um#kem.",
	END_DIALOG,
};

const static char *czechDialog77[] = {
	"M+lo m+ napadnout, {e se n+co ur$it+",
	NEW_LINE,
	"pokaz; - p#dlo je zlomen^.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"A hned je o probl*m v;c.",
	END_DIALOG,
};

const static char *czechDialog78[] = {
	"Jak se m#@, velkej chlupatej P*-Es-E*?",
	END_DIALOG,
};

const static char *czechDialog79[] = {
	"P>esta< m+ laskav+ ignorovat.",
	END_DIALOG,
};

const static char *czechDialog80[] = {
	"Je s tebou t+{k# >e$, asi jsi byl",
	NEW_LINE,
	"v^>e$n+j@; jako @t+n+.",
	END_DIALOG,
};

const static char *czechDialog81[] = {
	"Tak co? Nechce se ti na velkou bobkovou?",
	END_DIALOG,
};

const static char *czechDialog82[] = {
	"Ano, mohl bych si to vz;t...",
	DISPLAY_MESSAGE,
	"Jsem v tich*, klidn* vesni$ce...",
	DISPLAY_MESSAGE,
	"Nikde {#dn# policie...",
	DISPLAY_MESSAGE,
	"Nikdo neusly@; jejich n#>ek...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Ale j# nem#m {#dnou >eznickou z#st+ru.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"(ach jo)",
	END_DIALOG,
};

const static char *czechDialog83[] = {
	"Nedotknu s toho,",
	NEW_LINE,
	" jinak bych dostat amok.",
	DISPLAY_MESSAGE,
	"Nejd>;v bych pobil v@echny tady",
	NEW_LINE,
	"a pak bych vysko$il z obrazovky...",
	END_DIALOG,
};

const static char *czechDialog84[] = {
	"My@ p>ece nechyt;te jen tak.",
	NEW_LINE,
	"Bez sna{en;, b+dov#n; a zoufalstv;,",
	NEW_LINE,
	"to by p>eci nebyla",
	DISPLAY_MESSAGE,
	"{#dn# po>#dn# adventura, ne?",
	END_DIALOG,
};

const static char *czechDialog85[] = {
	"Norm#ln+ byl se pokusil ty pt#ky",
	NEW_LINE,
	"vystra@it ru$n+, ale kdy{ mi bylo",
	NEW_LINE,
	"deset let, vid+l jsem Hitchcook]v film",
	DISPLAY_MESSAGE,
	"\'Pt#ci\'. A od t* doby jsem s pt#ky kamar#d.",
	DISPLAY_MESSAGE,
	"Mus;me spole$n+ p>ij;t",
	NEW_LINE,
	"na n+co jin*ho, na n+jakou fintu.",
	END_DIALOG,
};

const static char *czechDialog86[] = {
	"Hmmm, je tam naps#na divn# v+c.",
	DISPLAY_MESSAGE,
	"\"Na konci d;ry najde@ zlato.\"",
	END_DIALOG,
};

const static char *czechDialog87[] = {
	"Vy jste pan Pankr#c Oblouk?",
	CHANGE_CHARACTER,
	"Ano, jak se m#te, p>;teli.",
	DISPLAY_MESSAGE,
	"Moji lid* m+ upozor<ovali,",
	NEW_LINE,
	"{e jste se pokou@el dostat",
	NEW_LINE,
	"do m* vily. Pro$pak?",
	CHANGE_CHARACTER,
	"Er... v;te...",
	DISPLAY_MESSAGE,
	"p>i@el jsem...",
	NEW_LINE,
	"se pod;vat na interi*ry dom]...",
	DISPLAY_MESSAGE,
	"M#m toti{ pr#zdniny a cht+l jsem",
	NEW_LINE,
	"nafotit n+jak* ty fotky, tak*",
	NEW_LINE,
	"bych t>eba vy$istil okna a ...",
	DISPLAY_MESSAGE,
	"...umyl psa nebo dohodil n+jakej ten",
	NEW_LINE,
	"k@eft s digit#ln;ma hodinkama...",
	CHANGE_CHARACTER,
	"Aha.Hmm.. Ch#pu t+, p>;teli",
	NEW_LINE,
	"je mi to jasn*.",
	DISPLAY_MESSAGE,
	"V;@, mal; $muchalov* mi n+kdy nevad;",
	NEW_LINE,
	"a n+kdy mi zase ned+laj; dob>e.",
	NEW_LINE,
	"Takov^ mal^ $muchal m]{e pracovat...",
	DISPLAY_MESSAGE,
	"t>eba pro n+jakou tajnou agenturu",
	NEW_LINE,
	"jako je t>eba Hurv;nkovo Osv;cen;",
	NEW_LINE,
	"a tak podobn+...",
	DISPLAY_MESSAGE,
	"Nem]{u ti dovolit vstoupit do m*ho",
	NEW_LINE,
	"domu, proto{e se tam pr#v+",
	NEW_LINE,
	"kon# sjezd masochist] a p>ijel",
	DISPLAY_MESSAGE,
	"i mark^z DeSade i se svoj; chot;",
	NEW_LINE,
	"pan; |achtickou, kter* bys jist+ nerad ru@il",
	NEW_LINE,
	"Ud+l#me to jinak.",
	DISPLAY_MESSAGE,
	"J# ti tady d#m n+jakej pen;z",
	NEW_LINE,
	"a ty si m]{e@ j;t koupit t>eba walkmana",
	NEW_LINE,
	"nebo zapou@t+c; $;pky proti",
	NEW_LINE,
	"bolestem hlavy.",
	DISPLAY_MESSAGE,
	"Co tomu >;k#@?",
	CHANGE_CHARACTER,
	"Za co m+ m#te?",
	END_DIALOG,
};

const static char *czechDialog88[] = {
	"No to si teda NIKDY nevezmu!",
	DISPLAY_MESSAGE,
	"NIKDY!",
	CHANGE_CHARACTER,
	"Neroz$iluj se tak.",
	DISPLAY_MESSAGE,
	"Hloupej d#v#, hloup+j@; nebere.",
	DISPLAY_MESSAGE,
	"J# u{ te% mus;m j;t, ty se uklidni",
	NEW_LINE,
	"a seber si ty prachy.",
	DISPLAY_MESSAGE,
	"Nikdo se to nemus; dozv+d+t...",
	DISPLAY_MESSAGE,
	"Sbohem, p>;teli.",
	END_DIALOG,
};

const static char *czechDialog89[] = {
	"Nem]{u uv+>it tomu, jak se mnou",
	NEW_LINE,
	"zach#zel.",
	DISPLAY_MESSAGE,
	"Mimochodem...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"J# ale nejsem hloup+j@;...",
	END_DIALOG,
};

const static char *czechDialog90[] = {
	"~]va...",
	DISPLAY_MESSAGE,
	"je $ern# jak smola...",
	DISPLAY_MESSAGE,
	"...a vypad# jako jednoro{ec,...",
	DISPLAY_MESSAGE,
	"...kter^mu n+kdo ust>ih\' zadn; nohy...",
	DISPLAY_MESSAGE,
	"...a prot#hl mu hlavu zadkem...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Kresli$ pozad; m+l asi t+{k^ den.",
	END_DIALOG,
};

const static char *czechDialog91[] = {
	"U{ zase musim prohled#vat ko@e?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"No dob>e, vy santus#ci, jsou tam",
	NEW_LINE,
	"n+jak^ pap;ry.",
	END_DIALOG,
};

const static char *czechDialog92[] = {
	"Stejn* jako v{dycky...",
	DISPLAY_MESSAGE,
	"Katastrofy...",
	DISPLAY_MESSAGE,
	"Multimedi#ln; b>e$ky...",
	DISPLAY_MESSAGE,
	"Brut#ln; vra{dy...",
	DISPLAY_MESSAGE,
	"Satanistick# kolonka...",
	DISPLAY_MESSAGE,
	"Polonah^ star^ baby...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"To si mus;m p>edplatit.",
	END_DIALOG,
};

const static char *czechDialog93[] = {
	ANIM_WAIT,
	"Je{i@...",
	CHANGE_CHARACTER,
	"...Ja da d#, ja da d#..",
	DISPLAY_MESSAGE,
	"...tada d###, da da d###...",
	CHANGE_CHARACTER,
	"To je Oblouk!",
	CHANGE_CHARACTER,
	"...d*****@[!...",
	CHANGE_CHARACTER,
	"Zp;val n+co do kamery.",
	CHANGE_CHARACTER,
	"...cik####nsk^^^ bar==< jsem j###...",
	CHANGE_CHARACTER,
	"Byl asi \\pln+ namazanej.",
	CHANGE_CHARACTER,
	"...sou{en;;;...",
	CHANGE_CHARACTER,
	"To je ubohost. Je{i@.",
	CHANGE_CHARACTER,
	"...zase @[astn^^^^;;;;;;!..",
	CHANGE_CHARACTER,
	"Hr]za.",
	CHANGE_CHARACTER,
	"...a toho v>**da $apnul d+***da...",
	CHANGE_CHARACTER,
	"D]kaz o neexistenci boha.",
	CHANGE_CHARACTER,
	"...tak, tak, t###k!...",
	CHANGE_CHARACTER,
	"To mi sta$ilo.",
	CHANGE_CHARACTER,
	"...la, la! La, l###....",
	END_DIALOG,
};

const static char *czechDialog94[] = {
	"Sam^ kulov^...",
	DISPLAY_MESSAGE,
	"Toti{, velk^ kulov^, i kdy{, moment...",
	DISPLAY_MESSAGE,
	"N+co tam je! N+co se tam v#l;...",
	END_DIALOG,
};

const static char *czechDialog95[] = {
	"Nemysl;te si, pane kucha>, {e byste",
	NEW_LINE,
	"m+l p>idat malinko tady toho chilli,",
	NEW_LINE,
	"jen tak pro chu[?",
	CHANGE_CHARACTER,
	"P>idat?",
	DISPLAY_MESSAGE,
	"Pro$?",
	CHANGE_CHARACTER,
	"M#m takov^ pocit,",
	NEW_LINE,
	"{e nejste zrovna dvakr#t spokojen^",
	NEW_LINE,
	"s tou pol*vkou,",
	DISPLAY_MESSAGE,
	"kterou va>;te.",
	NEW_LINE,
	"Trochu toho ko>en; neu@kod; tolik",
	NEW_LINE,
	"jako t>eba p#r pan#k] ko<aku, nemysl;te?",
	CHANGE_CHARACTER,
	"N==...",
	DISPLAY_MESSAGE,
	"Nen; to @patnej n#pad.",
	DISPLAY_MESSAGE,
	"N#hodou taky jedno $ili m#m...",
	END_DIALOG,
};

const static char *czechDialog96[] = {
	CHANGE_CHARACTER,
	"Tohle... hik!...",
	DISPLAY_MESSAGE,
	"Tohle chilllllleeeeee... hble!",
	DISPLAY_MESSAGE,
	"...muselo...",
	DISPLAY_MESSAGE,
	"...vykvasit...",
	DISPLAY_MESSAGE,
	"..je puuo puuol;vce...",
	DISPLAY_MESSAGE,
	"...mus;m se j;t proj;t po skle!",
	DISPLAY_MESSAGE,
	"Je to trest bo{;!",
	END_DIALOG,
};

const static char *czechDialog97[] = {
	"To r#dio nepot>ebuju,",
	NEW_LINE,
	"ale mohly by se hodit jeho baterie.",
	DISPLAY_MESSAGE,
	"Bohu{el nikdy nev;m, kudy vniknout",
	NEW_LINE,
	"do \\trob t+hle japonskejch",
	NEW_LINE,
	"ko$i$ek.",
	END_DIALOG,
};

const static char *czechDialog98[] = {
	CHANGE_CHARACTER,
	"Kontroln; test: hlas, obraz, pach",
	DISPLAY_MESSAGE,
	"Hlas pozitivn+ analyzov#n.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Yo, p+kn# p;sni$ka.",
	END_DIALOG,
};

const static char *czechDialog99[] = {
	CHANGE_CHARACTER,
	"Kontroln; test: hlas, obraz, pach.",
	DISPLAY_MESSAGE,
	"Pach pozitivn+ analyzov#n.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"M#lem mi to odpravilo $ichov# $idla.",
	END_DIALOG,
};

const static char *czechDialog100[] = {
	CHANGE_CHARACTER,
	"Kontroln; test: hlas, obraz, pach.",
	DISPLAY_MESSAGE,
	"Obraz pozitivn+ analyzov#n.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"A p>;@t+ si stoupni trochu bl;{, br#cho.",
	END_DIALOG,
};

const static char *czechDialog101[] = {
	"M]{u mluvit s...",
	CHANGE_CHARACTER,
	"Jdi pry$.",
	DISPLAY_MESSAGE,
	"M#m pr#ci.",
	DISPLAY_MESSAGE,
	"Va>;m.",
	DISPLAY_MESSAGE,
	"Ob+d bude brzy.",
	DISPLAY_MESSAGE,
	"Mus;m fachat.",
	CHANGE_CHARACTER,
	"Ano, kapit#ne .",
	END_DIALOG,
};

const static char *czechDialog102[] = {
	"Dob>e, ale mo{n#...",
	CHANGE_CHARACTER,
	"J#...",
	DISPLAY_MESSAGE,
	"...m#m...",
	DISPLAY_MESSAGE,
	"...pr#ci.",
	DISPLAY_MESSAGE,
	"nech...",
	DISPLAY_MESSAGE,
	"...m+...",
	DISPLAY_MESSAGE,
	"...NA POKOJI.",
	DISPLAY_MESSAGE,
	"OK?",
	CHANGE_CHARACTER,
	"Okaj, dokaj.",
	END_DIALOG,
};

const static char *czechDialog103[] = {
	"To je naposled, co se pt#m...",
	CHANGE_CHARACTER,
	"Pr#ce.",
	DISPLAY_MESSAGE,
	"P jako -censored-.",
	DISPLAY_MESSAGE,
	"R jako Rumburak.",
	DISPLAY_MESSAGE,
	"A jako Andrew.",
	DISPLAY_MESSAGE,
	"C jako Cip;sek",
	DISPLAY_MESSAGE,
	"a E jako...",
	CHANGE_CHARACTER,
	"Embl*m?",
	CHANGE_CHARACTER,
	"Ne. Jako...",
	CHANGE_CHARACTER,
	"Evangelium svat^ho Tetsua?",
	CHANGE_CHARACTER,
	"Ne, ne. Jako...",
	CHANGE_CHARACTER,
	"Emocion#ln+ p>et;{en; kucha>i?",
	CHANGE_CHARACTER,
	"Ano, to p>esn+ ono.",
	DISPLAY_MESSAGE,
	"A te% u{ m+ pros;mt+ nech b^t!",
	CHANGE_CHARACTER,
	"Dob>e, dob>e.",
	END_DIALOG,
};

const static char *czechDialog104[] = {
	"Er...",
	CHANGE_CHARACTER,
	"Wrrrr...",
	CHANGE_CHARACTER,
	"Vlastn+ nic.",
	END_DIALOG,
};

const static char *czechDialog105[] = {
	"Dobr^ den, pane robot.",
	CHANGE_CHARACTER,
	"Hej, yo, tak co m]j k#mo,",
	NEW_LINE,
	"sly@;@, co ti pov;d#m?",
	DISPLAY_MESSAGE,
	"V;@, j# jsem Ludv;k, yo,",
	NEW_LINE,
	"Co {e to poud#m?",
	CHANGE_CHARACTER,
	"Er...",
	DISPLAY_MESSAGE,
	"Je ur$it+ v@echno v po>#dku",
	NEW_LINE,
	"s tv^m programem...",
	DISPLAY_MESSAGE,
	"...nepozn#v#@, {e jsem Karel |apek?...",
	CHANGE_CHARACTER,
	"Co m#@ za probl*m, br#cho?!",
	DISPLAY_MESSAGE,
	"Nikdys\' nevid+l repuj;c;ho,",
	NEW_LINE,
	"sejf-robota, YO, pohoda, bahno?",
	CHANGE_CHARACTER,
	"Vlastn+, nikdy.",
	CHANGE_CHARACTER,
	"J# sem nimbl novej.",
	DISPLAY_MESSAGE,
	"Novinka, hork# v+c, jasn^?",
	DISPLAY_MESSAGE,
	"N+jak^ chytr^ lidi >ikaj, {e",
	NEW_LINE,
	"takovej robot m# bejt pro ka{d^ho.",
	DISPLAY_MESSAGE,
	"Je@t+ po>#d m+ st;h#@?",
	NEW_LINE,
	"Tak mi ty lidi dali lidskou",
	NEW_LINE,
	"osobnost, br#cho.",
	DISPLAY_MESSAGE,
	"Sleduje@?",
	NEW_LINE,
	"Cool, {e jo?",
	CHANGE_CHARACTER,
	"Khm... Jo, super.",
	DISPLAY_MESSAGE,
	"Tak{e ty jse@ n+jakj sejf?",
	CHANGE_CHARACTER,
	"Pozitivn;, br#cho.",
	DISPLAY_MESSAGE,
	"Tot#ln+ spolehlivej,",
	NEW_LINE,
	"je to jasn^?",
	DISPLAY_MESSAGE,
	"Kdy{ m+ bude@ cht;t otev>;t,",
	NEW_LINE,
	"mus;@ dok#zat, {e jse@ m]j majitel.",
	DISPLAY_MESSAGE,
	"A te% d#vej trojit^ho bacha:",
	NEW_LINE,
	"J# m]{u ROZSOUDIT, jestli se@",
	NEW_LINE,
	"m]j majitel podle t>ech v+c;:",
	DISPLAY_MESSAGE,
	"...obraz, pach a hlas.",
	NEW_LINE,
	"Ch#pe@ to, br#cho? YO!",
	CHANGE_CHARACTER,
	"A mohl by ses na chvilku otev>;t",
	NEW_LINE,
	"jenom abych se pod;val,",
	NEW_LINE,
	"co v sob+ m#@?",
	CHANGE_CHARACTER,
	"Sor#@, br#cho.",
	DISPLAY_MESSAGE,
	"nevypad#@ jako majitel...",
	DISPLAY_MESSAGE,
	"...nep#chne@ jako majitel...",
	DISPLAY_MESSAGE,
	"...a nezvu$;@ jako majitel.",
	DISPLAY_MESSAGE,
	"Tak{e vem rohy na ramena a vypadni!",
	END_DIALOG,
};

const static char *czechDialog106[] = {
	"Sesame, otev>i se...",
	CHANGE_CHARACTER,
	"Polib si ty -CENSORED-, skapanej -CENSORED-",
	END_DIALOG,
};

const static char *czechDialog107[] = {
	"Nazd#rek!",
	CHANGE_CHARACTER,
	"(Zde bylo tak stra@n* klen;,",
	NEW_LINE,
	" {e jsme ho museli",
	NEW_LINE,
	"p>ekladateli vyjmout - distribuce)",
	END_DIALOG,
};

const static char *czechDialog108[] = {
	"};k#m v#m, {e tentokr#t",
	NEW_LINE,
	"je to n+co velkolep*ho.",
	CHANGE_CHARACTER,
	"Je@t+ si vzpom;n#m, jak p>i@el o {ivot",
	NEW_LINE,
	"m]j slu{ebn^ p>i zkou@en;",
	NEW_LINE,
	"nepr]st>eln*ho tri$ka.",
	CHANGE_CHARACTER,
	"To u{ je d#vno...",
	CHANGE_CHARACTER,
	"Nebo jak jste mi vnutil @;len^",
	NEW_LINE,
	"RAPuj;c; robot-trezor,",
	NEW_LINE,
	"kter^ si >;k# Ludv;k...",
	DISPLAY_MESSAGE,
	"...a odm;t# se otev;rat.",
	CHANGE_CHARACTER,
	"Proto{e se k n+mu chov#te @patn+...",
	CHANGE_CHARACTER,
	"Nebo ten recept na l#m#n;",
	NEW_LINE,
	"{ensk^ch srdc;, co jste",
	NEW_LINE,
	"mi prodal.",
	CHANGE_CHARACTER,
	"Pen;ze nazabraly?",
	CHANGE_CHARACTER,
	"Negativn;.",
	CHANGE_CHARACTER,
	"Zvl#@tn;, v+t@inou zab;raj.",
	CHANGE_CHARACTER,
	"Nebo kdy{ jste...",
	CHANGE_CHARACTER,
	"DOB}E, DOB}E!",
	DISPLAY_MESSAGE,
	"Zapome<me na to!",
	DISPLAY_MESSAGE,
	"Ten novej vyn#lez u{ jsem",
	NEW_LINE,
	"tak jako tak otestovat s#m!",
	CHANGE_CHARACTER,
	"Opravdu?",
	CHANGE_CHARACTER,
	"Opravdu.",
	DISPLAY_MESSAGE,
	"A m]{u to p>edv*st.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Ou kej, jsem sam* oko.",
	END_DIALOG,
};

const static char *czechDialog109[] = {
	ANIM_WAIT,
	"Velkolep*.",
	DISPLAY_MESSAGE,
	"Vyr#b+dlo trpasl;k].",
	CHANGE_CHARACTER,
	"Uh, to je jen postrann; efekt.",
	DISPLAY_MESSAGE,
	"N+kdy se podobn* v+ci st#vaj;,",
	NEW_LINE,
	"tuhle jsem byl na chv;li {ena.",
	DISPLAY_MESSAGE,
	"Ale nem+jte obavy, cel* to trv#",
	NEW_LINE,
	"jen chvili$ku.",
	CHANGE_CHARACTER,
	"To douf#m.",
	END_DIALOG,
};

const static char *czechDialog110[] = {
	"Tak a jsem tady.",
	DISPLAY_MESSAGE,
	"Tak{e mi pov+zte, post>ehl jste",
	NEW_LINE,
	"n+co neobvykl*ho?",
	CHANGE_CHARACTER,
	"Ani co by se za p]l nehtu ve@lo.",
	CHANGE_CHARACTER,
	"Skv+l*!",
	DISPLAY_MESSAGE,
	"Tak{e ty pilulky skute$n+ funguj;!",
	CHANGE_CHARACTER,
	"Nepov;dejte.",
	CHANGE_CHARACTER,
	"Ano!",
	DISPLAY_MESSAGE,
	"Zkuste si zkontrolovat svoji pen+{enku!",
	CHANGE_CHARACTER,
	"Moje pen+{enka se m# dob>e jako v{dy...",
	END_DIALOG,
};

const static char *czechDialog111[] = {
	"Kde m#m pen+{enku?!",
	DISPLAY_MESSAGE,
	"Zlod+ji!",
	DISPLAY_MESSAGE,
	"Vra[ mi ji!",
	CHANGE_CHARACTER,
	"Zachovejte klid, tady ji m#te.",
	END_DIALOG,
};

const static char *czechDialog112[] = {
	"Vypro@uji si vysv+tlen;.",
	CHANGE_CHARACTER,
	"Ha!",
	DISPLAY_MESSAGE,
	"To je nejlep@; v+c, kterou jsem",
	NEW_LINE,
	"kdy vynalezl!",
	CHANGE_CHARACTER,
	"A co je to?",
	CHANGE_CHARACTER,
	"Nevid+l jste m+,",
	NEW_LINE,
	"jak jsem v#m ukradl pen+{enku",
	DISPLAY_MESSAGE,
	"...proto{e jsem spolknul...",
	DISPLAY_MESSAGE,
	"PILULKU |ASU!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Jakou pilulku $asu?",
	CHANGE_CHARACTER,
	"Yes!",
	DISPLAY_MESSAGE,
	"Ten kdo ji spolkne",
	NEW_LINE,
	"{ije tis;ckr#t rychleji",
	NEW_LINE,
	"ne{ zbytek sv+ta!",
	CHANGE_CHARACTER,
	"Co{ znamen#...",
	CHANGE_CHARACTER,
	"To znamen#, {e se sv+t",
	NEW_LINE,
	"pro tohoto $lov+ka h^be",
	NEW_LINE,
	"tis;ckr#t pomaleji!",
	DISPLAY_MESSAGE,
	"Ale jenom na p#r sekund,",
	NEW_LINE,
	"d*le to nevydr{;...",
	CHANGE_CHARACTER,
	"No... to je zaj;mav*.",
	NEW_LINE,
	"Ale na co je to dobr*?",
	CHANGE_CHARACTER,
	"O tom jsem nep>em^@lel.",
	DISPLAY_MESSAGE,
	"Zamyslete se nad t;m vy.",
	DISPLAY_MESSAGE,
	"Nap>;klad byste se mohl dostat",
	NEW_LINE,
	"do kina \\pln+ bez l;stku",
	NEW_LINE,
	"a nikdo by si toho ani nev@iml!",
	CHANGE_CHARACTER,
	"Jo tak, samoz>ejm+!",
	DISPLAY_MESSAGE,
	"Skv+l*!",
	DISPLAY_MESSAGE,
	"R#d bych si koupil patent!",
	CHANGE_CHARACTER,
	"A v tom je pr#v+ probl*m...",
	DISPLAY_MESSAGE,
	"Jak v;te, m]j str^$ek Eisler,",
	NEW_LINE,
	"v{dycky vynal*zal ty nejlep@; v+ci,",
	NEW_LINE,
	"kdy{ byl jaksi...",
	CHANGE_CHARACTER,
	"...namazanej...",
	CHANGE_CHARACTER,
	"...prost+ vo{ralej.",
	DISPLAY_MESSAGE,
	"A to sam* se te% st#v# m+. Bohu{el.",
	DISPLAY_MESSAGE,
	"Tak{e v$era ve$er jsem se vzbudil",
	NEW_LINE,
	"se sta@nou opic; a...",
	NEW_LINE,
	"na@el jsem tyhle pilulky.",
	DISPLAY_MESSAGE,
	"Nepamatuju si ani za m#k,",
	NEW_LINE,
	"jak jsem je vlastn+ vyrobil.",
	CHANGE_CHARACTER,
	"No to snad ne!",
	CHANGE_CHARACTER,
	"Ale mohu se pokusit je znovu vyrobit.",
	DISPLAY_MESSAGE,
	"Na to ale pot>ebuju va@e pen;ze.",
	DISPLAY_MESSAGE,
	"Domluvme se takto:",
	DISPLAY_MESSAGE,
	"vy mi postav;te novou",
	NEW_LINE,
	"laborato> s modern;m vybaven;m...",
	DISPLAY_MESSAGE,
	"...a v#m d#m u{;vac; pr#va.",
	CHANGE_CHARACTER,
	"Vy my tedy d#te patent?!",
	CHANGE_CHARACTER,
	"Ano.",
	DISPLAY_MESSAGE,
	"Jedin*, co m+ zaj;m# je",
	NEW_LINE,
	"respekt k v+d+",
	NEW_LINE,
	"utopenci s cibulkou.",
	DISPLAY_MESSAGE,
	"A Nobelova Cena.",
	DISPLAY_MESSAGE,
	"Ch#pete, v+c profesion#ln; cti",
	NEW_LINE,
	"rozhovory v novin#ch...",
	CHANGE_CHARACTER,
	"Ch#pu. Jsme domluveni.",
	DISPLAY_MESSAGE,
	"P>iprav smlouvu.",
	CHANGE_CHARACTER,
	"To ti V*na p;sk.",
	END_DIALOG,
};

const static char *czechDialog113[] = {
	"Ten bl#zen mi v+>;.",
	DISPLAY_MESSAGE,
	"Ale j# ho vyu{iju...",
	DISPLAY_MESSAGE,
	"A ty pilulky $asu...",
	DISPLAY_MESSAGE,
	"To bych byl magor,",
	NEW_LINE,
	"kdybych je prod#val lidem!",
	DISPLAY_MESSAGE,
	"Na patent se m]{u zvysoka",
	NEW_LINE,
	"vyzvr#tit!",
	DISPLAY_MESSAGE,
	"S pilulkami m]{u vykr#st jakoukoliv banku,",
	NEW_LINE,
	"ani{ by m+ n+kdo v]bec vid+l!",
	DISPLAY_MESSAGE,
	"Rychleji ne{ sv+tlo!",
	DISPLAY_MESSAGE,
	"Nejd>;v ale pot>ebuju ukr#st n+jak^",
	NEW_LINE,
	"pen;ze nebo zlato",
	NEW_LINE,
	"na vybaven; t* laborato>e.",
	END_DIALOG,
};

const static char *czechDialog114[] = {
	"Ale brzo...",
	DISPLAY_MESSAGE,
	"Budu bohatej.",
	DISPLAY_MESSAGE,
	"Stra@n+ bohatej.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Budu moci po>#dat orgie, hody, doprovody...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"...a nebo bych...",
	END_DIALOG,
};

const static char *czechDialog115[] = {
	ANIM_WAIT,
	"MOHL KOUPIT PRAHU!...",
	END_DIALOG,
};

const static char *czechDialog116[] = {
	ANIM_WAIT,
	"To je n#pad!",
	END_DIALOG,
};

const static char *czechDialog117[] = {
	"To u{ jsem zase j#.",
	CHANGE_CHARACTER,
	"Tak zase sbohem.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Dejme tomu, {e jsem tohle nesly@el.",
	DISPLAY_MESSAGE,
	"Je pan Pankr#c Oblouk doma?",
	CHANGE_CHARACTER,
	"Ano, ale >;kal, {e v#s nem#m pou@t+t dovnit>.",
	CHANGE_CHARACTER,
	"M+?! Pro$?!",
	CHANGE_CHARACTER,
	"V#@ posledn; vyn#lez ho st#l",
	NEW_LINE,
	"v@echny hodiny v dom+.",
	CHANGE_CHARACTER,
	"Oh, ten stroj $asu mysl;te...",
	DISPLAY_MESSAGE,
	"Ale te%ko m#m n+co...",
	CHANGE_CHARACTER,
	"A to ani nezmi<uju vypa>enou ko$ku.",
	CHANGE_CHARACTER,
	"Ta ko$ka je te% @[astn+j@; ne{",
	NEW_LINE,
	"my v@ichni ostatn;.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Tedy jestli sv+t je@t+ ve 25. stolet;",
	NEW_LINE,
	"v]bec existuje.",
	DISPLAY_MESSAGE,
	"Ale to je jedno.",
	DISPLAY_MESSAGE,
	"Prost+ m+ mus;te pustit dovnit>.",
	CHANGE_CHARACTER,
	"Mysl;te?",
	CHANGE_CHARACTER,
	"Nebo >eknu panu Obloukovi,",
	NEW_LINE,
	"{e pijete ve slu{b+.",
	CHANGE_CHARACTER,
	"Blafujete, nem#te {#dn^ d]kaz.",
	CHANGE_CHARACTER,
	"To je bohu{el jedna z v+c;,",
	NEW_LINE,
	"kterou si nem]{ete b^t jist^.",
	END_DIALOG,
};

const static char *czechDialog118[] = {
	"Ou Kej, tak teda vejdi ty @pinavej teroristo.",
	DISPLAY_MESSAGE,
	"Hlavn+ to nikomu ne>;kej.",
	CHANGE_CHARACTER,
	"Jasan. M#@ to u m+.",
	END_DIALOG,
};

const static char *czechDialog119[] = {
	"Tak...",
	DISPLAY_MESSAGE,
	"Tak takhle se to v@echno stalo...",
	DISPLAY_MESSAGE,
	"Proto nikdo nevid+l kdo ty v+ci",
	NEW_LINE,
	"vlastn+ krade. Douf#m, {e m+ pr#v+ te%",
	NEW_LINE,
	"n+kdo sexu#ln+ nezneu{;v#...",
	DISPLAY_MESSAGE,
	"To je teda opravdu nebezpe$nej",
	NEW_LINE,
	"vyn#lez!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Musim Oblouka zastavit!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"N+jak.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Je{i@ ty pilulky co jsem na@el",
	NEW_LINE,
	"v Ludv;kovi musej bejt...",
	DISPLAY_MESSAGE,
	"Lejna!",
	DISPLAY_MESSAGE,
	"Sly@im n+koho p>ich#zet!",
	END_DIALOG,
};

const static char *czechDialog120[] = {
	"Mus;m se n+kam uklidit!",
	DISPLAY_MESSAGE,
	"Hned te%!",
	END_DIALOG,
};

const static char *czechDialog121[] = {
	"Budu si muset koupit klasick^ sejf.",
	DISPLAY_MESSAGE,
	"Ludv;kovi u{ zase stra@ilo na mozku.",
	DISPLAY_MESSAGE,
	"Svat# Panno!",
	DISPLAY_MESSAGE,
	"ZAV}I SE ty pod+lan# pixlo!",
	END_DIALOG,
};

const static char *czechDialog122[] = {
	"To u{ je tenhle t^den pot>et;.",
	DISPLAY_MESSAGE,
	"Ale dob>e, dob>e!...",
	DISPLAY_MESSAGE,
	"U{ jdu!...",
	END_DIALOG,
};

const static char *czechDialog123[] = {
	"...a[ je st>e{eno \\pln+ v@echno.",
	DISPLAY_MESSAGE,
	"Pot>ebuju v;c pen+z na bezpe$nostn; syst*m.",
	DISPLAY_MESSAGE,
	"M#m jenom dva mu{e a...",
	CHANGE_CHARACTER,
	"V;ce pen+z, v;c pen+z!",
	DISPLAY_MESSAGE,
	"Nic jin^ho nesly@im jenom v;c pen+z!",
	CHANGE_CHARACTER,
	"Dobr#, vysv+tl;m v#m to je@t+ jednou...",
	END_DIALOG,
};

const static char *czechDialog124[] = {
	"Pan Pankr#c Oblouk?",
	DISPLAY_MESSAGE,
	"Zrovna jsem dostal zpr#vu",
	NEW_LINE,
	"od profesora.",
	DISPLAY_MESSAGE,
	"Pros; v#s, zdalipak byste se",
	NEW_LINE,
	"nestavil v laborato>i.",
	DISPLAY_MESSAGE,
	"};k#, {e znova odhalil strukturu",
	NEW_LINE,
	"t+ch pilulek.",
	END_DIALOG,
};

const static char *czechDialog125[] = {
	"A to je v@echno?!",
	CHANGE_CHARACTER,
	"Jasn+ ...hik!... ano.",
	CHANGE_CHARACTER,
	"Hm, super.",
	END_DIALOG,
};

const static char *czechDialog126[] = {
	"Mus;m je zastavit!",
	DISPLAY_MESSAGE,
	"A nezb^v# u{ moc $asu!",
	END_DIALOG,
};

const static char *czechDialog127[] = {
	"Tak, tak...",
	DISPLAY_MESSAGE,
	"Za$;n#@ mi pomalu ale jist+ l*zt na nervy.",
	DISPLAY_MESSAGE,
	"Nebyl to v]bec @patn^ n#pad utratit",
	NEW_LINE,
	"tolik pen+z za bezpe$nostn; syst*m...",
	DISPLAY_MESSAGE,
	"Tohle silov* pole je nezni$iteln*!",
	DISPLAY_MESSAGE,
	"Cha Cha!",
	END_DIALOG,
};

const static char *czechDialog128[] = {
	"Ale stejn+ t+ musim zab;t.",
	CHANGE_CHARACTER,
	"N*, n*!",
	CHANGE_CHARACTER,
	"Dr{ hubu!",
	CHANGE_CHARACTER,
	"Nestoj; ti to za to!",
	CHANGE_CHARACTER,
	"Fakticky?",
	CHANGE_CHARACTER,
	"Nechci...",
	END_DIALOG,
};

const static char *czechDialog129[] = {
	CHANGE_CHARACTER,
	"Chud#k profesor omdlel...",
	CHANGE_CHARACTER,
	"Ale... Jak...",
	DISPLAY_MESSAGE,
	"Nech#pu v]bec NIC!!!",
	CHANGE_CHARACTER,
	"Je to jednoduch*.",
	DISPLAY_MESSAGE,
	"P>ipevnili jsme malou mikrokameru",
	NEW_LINE,
	"na tvoj; $epici,",
	DISPLAY_MESSAGE,
	"tak{e jsme celou dobu v+d+li,",
	NEW_LINE,
	"co se d+je.",
	CHANGE_CHARACTER,
	"Vy jste vid+li, kdy{ jsem?...",
	CHANGE_CHARACTER,
	"Nechci t+ zbyte$n+ znepokojovat.",
	DISPLAY_MESSAGE,
	"Ud+lal jsi pro n#s dobrou pr#ci.",
	CHANGE_CHARACTER,
	"Ale Pankr#c Oblouk vzal roha!",
	CHANGE_CHARACTER,
	"Nen; dule{it^.",
	DISPLAY_MESSAGE,
	"M#me profesora a ty n#m d#@ pilulky.",
	DISPLAY_MESSAGE,
	"Promi<, ale asi ch#pe@,",
	NEW_LINE,
	" {e si je nem]{e@ nechat.",
	CHANGE_CHARACTER,
	"Dob>e, ale...",
	DISPLAY_MESSAGE,
	"D#te mi alespo< minutku?",
	DISPLAY_MESSAGE,
	"M#m s Pankr#cem je@t+ n+jak* osobn;",
	NEW_LINE,
	"nevy>e@en* \\$ty.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Dob>e, ale d+lej.",
	END_DIALOG,
};

const static char *czechDialog130[] = {
	ANIM_WAIT,
	"(gulp)",
	DISPLAY_MESSAGE,
	"Ten $asovej efekt nevydr{;",
	NEW_LINE,
	"zrovna dvakr#t dlouho...",
	END_DIALOG,
};

const static char *czechDialog131[] = {
	"Prohr#l jste pane!",
	DISPLAY_MESSAGE,
	"Polici pr#v+ obklik$uje budovu!",
	CHANGE_CHARACTER,
	"Naivko.",
	DISPLAY_MESSAGE,
	"Copak ti nedo@lo, {e tu m#m",
	NEW_LINE,
	"tajnou \\nikovou chodbu?",
	CHANGE_CHARACTER,
	"Nepov;dej.",
	DISPLAY_MESSAGE,
	"A ta je jako kde?",
	CHANGE_CHARACTER,
	"To ti tak budu >;kat...",
	DISPLAY_MESSAGE,
	"Vypadni, ty malej srabe.",
	DISPLAY_MESSAGE,
	"M#m pr#ci.",
	END_DIALOG,
};

const static char *czechDialog132[] = {
	"Mus;m v#s odzbrojit.",
	DISPLAY_MESSAGE,
	"Bu%te hodnej a vzdejte se bez pot;{;.",
	CHANGE_CHARACTER,
	"Hele p>esta< s tim, jenom zdr{uje@.",
	DISPLAY_MESSAGE,
	"Prost+ odsud vypadni,",
	NEW_LINE,
	"ne{ na tebe vyt#hnu pu@ku.",
	CHANGE_CHARACTER,
	"Varuju v#s...",
	CHANGE_CHARACTER,
	"Kde se v]bec berou takov; nudn^",
	NEW_LINE,
	"lidi jako ty?",
	END_DIALOG,
};

const static char *czechDialog133[] = {
	"Dal@; @anci u{ nedostanete...",
	CHANGE_CHARACTER,
	"Dob>e.",
	DISPLAY_MESSAGE,
	"Te% vypadni.",
	END_DIALOG,
};

const static char *czechDialog134[] = {
	"Nechte u{ kone$n+ toho sb;r#n; pen+z!",
	END_DIALOG,
};

const static char *czechDialog135[] = {
	"Brej den!",
	CHANGE_CHARACTER,
	"Zdrav;$ko.",
	DISPLAY_MESSAGE,
	"S $;mpak jde@?",
	CHANGE_CHARACTER,
	"Poslali m+ sem na n+jak* @kolen;.",
	CHANGE_CHARACTER,
	"Dal@; r#doby tajn^ agent, co?",
	CHANGE_CHARACTER,
	"Sed;.",
	CHANGE_CHARACTER,
	"Uka{ mi pap;ry a pust;m t+ dovnit>.",
	CHANGE_CHARACTER,
	"Jasn+.",
	END_DIALOG,
};

const static char *czechDialog136[] = {
	"Nem]{e@ m+ pustit dovnit> bez",
	NEW_LINE,
	"t* tup* byrokracie?",
	CHANGE_CHARACTER,
	"Bohu{el ne.",
	DISPLAY_MESSAGE,
	"Pravidla hry plat; (pou{ije@-pohne@ se).",
	CHANGE_CHARACTER,
	"A morousov* jsou morousov* v{dycky.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"A mrtv; lidi jsou mrtv; lidi. V{dycky.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"J=, jasn+. To m#me ale p+knej den, co?",
	END_DIALOG,
};

const static char *czechDialog137[] = {
	"PROSIM, m]{u proj;t?!",
	CHANGE_CHARACTER,
	"Samoz>ejm+!",
	DISPLAY_MESSAGE,
	"JENOM MI UKA~ SVOJE PAP;RY!",
	END_DIALOG,
};

const static char *czechDialog138[] = {
	"Pus[ m+ dovnit>!",
	CHANGE_CHARACTER,
	"Uka{ mi pap;ry!",
	CHANGE_CHARACTER,
	"Ty sv]j d{ob bere@ opravdu v#{n+,",
	NEW_LINE,
	"{e jo?",
	CHANGE_CHARACTER,
	"Jse@ slepej nebo co?",
	DISPLAY_MESSAGE,
	"|tu si p>ece $asopis ve slu{b+.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Oh, to jo.",
	DISPLAY_MESSAGE,
	"Promi<.",
	END_DIALOG,
};

const static char *czechDialog139[] = {
	"Musim...",
	CHANGE_CHARACTER,
	"Pap;ry!",
	END_DIALOG,
};

const static char *czechDialog140[] = {
	"Co to $tete?",
	CHANGE_CHARACTER,
	"\'Vojensk* noviny\', samoz>ejm+.",
	CHANGE_CHARACTER,
	"Vy se v t+ch vojenskejch v+cech,",
	NEW_LINE,
	"p>;mo vy{;v#te, {e?",
	CHANGE_CHARACTER,
	"Se@ bl#zen?",
	DISPLAY_MESSAGE,
	"Prohl;{;m si obr#zky n#dhern^ch mu{]...",
	DISPLAY_MESSAGE,
	"...taky lu@tim k>;{ovky...",
	DISPLAY_MESSAGE,
	"...chlemt#m se vtip]m...",
	DISPLAY_MESSAGE,
	"...$tu drby...",
	DISPLAY_MESSAGE,
	"...poln; a p>espoln; recepty...",
	CHANGE_CHARACTER,
	"Va>en;?!",
	CHANGE_CHARACTER,
	"No, ano. Noviny se t;m sna{;",
	DISPLAY_MESSAGE,
	"z;skat @ir@; okruh $ten#>].",
	CHANGE_CHARACTER,
	"Aha.",
	DISPLAY_MESSAGE,
	"Dobrej n#pad.",
	DISPLAY_MESSAGE,
	"A je tam taky n+co o pleten;?",
	CHANGE_CHARACTER,
	"M#m takov^ pocit, {e to byl pokus",
	NEW_LINE,
	"o n+jak^ trapn^ vtip.",
	CHANGE_CHARACTER,
	"J# a pokou@et se o trapn* vtipy?",
	DISPLAY_MESSAGE,
	"Nikdy.",
	CHANGE_CHARACTER,
	"Dobr#.",
	END_DIALOG,
};

const static char *czechDialog141[] = {
	"P]j$il byste mi ten $asopis pane?",
	CHANGE_CHARACTER,
	"A s $;m si mysl;@, {e potom",
	NEW_LINE,
	"budu zab;jet $as?",
	CHANGE_CHARACTER,
	"Hmmm...n=..",
	DISPLAY_MESSAGE,
	"M#te u sebe alespo< vojenskou kudli$ku, ne?",
	CHANGE_CHARACTER,
	"Str#nky $as#ku jsou ale ost>ej@;.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Oh-oh.",
	END_DIALOG,
};

const static char *czechDialog142[] = {
	"Co se d+je?",
	CHANGE_CHARACTER,
	"~ijeme. Nebo ne?",
	END_DIALOG,
};

const static char *czechDialog143[] = {
	"Jen tak d#l, pokra$uj ve sv* pr#ci.",
	END_DIALOG,
};

const static char *czechDialog144[] = {
	CHANGE_CHARACTER,
	"HEJ! Ho% tam zp#te$ku!",
	END_DIALOG,
};

const static char *czechDialog145[] = {
	"Co je? Ho>; ti v budce?",
	CHANGE_CHARACTER,
	"Mus;@ mi uk#zat povolen; ke vstupu",
	NEW_LINE,
	"ne{ bude@ moci vstoupit",
	NEW_LINE,
	"do t#bora.",
	CHANGE_CHARACTER,
	"Co kdy{ ti uk#{u jenom z#da?",
	CHANGE_CHARACTER,
	"Tak t+ zast>elim.",
	CHANGE_CHARACTER,
	"(oh)",
	END_DIALOG,
};

const static char *czechDialog146[] = {
	CHANGE_CHARACTER,
	"Varuju t+...",
	DISPLAY_MESSAGE,
	"Moje kulky jsou rychlej@; ne{ ty..",
	END_DIALOG,
};

const static char *czechDialog147[] = {
	CHANGE_CHARACTER,
	"V po>#dku.",
	DISPLAY_MESSAGE,
	"Ohla@ se u kapit#na.",
	DISPLAY_MESSAGE,
	"M+l by tu n+kde b^t.",
	CHANGE_CHARACTER,
	"D+kuju. A pozor na datly.",
	NEW_LINE,
	"A[ ti nezaberou budku.",
	END_DIALOG,
};

const static char *czechDialog148[] = {
	CHANGE_CHARACTER,
	"Tak{e my tady z tebe m#me ud+lat mu{e.",
	NEW_LINE,
	"Je to tak, Ml;$<#ku?!",
	CHANGE_CHARACTER,
	"Erm...",
	CHANGE_CHARACTER,
	"Po>#dn^ho tvr%#ka!...",
	CHANGE_CHARACTER,
	"Uh...",
	CHANGE_CHARACTER,
	"Kterej bude potit krev!",
	CHANGE_CHARACTER,
	"J# bych rad@i, t#hle jsou brabci...",
	CHANGE_CHARACTER,
	"R#d vid;m tvoje nad@en;, Ml;$<#ku!",
	DISPLAY_MESSAGE,
	"Ale neztr#cejme $as!",
	DISPLAY_MESSAGE,
	"}ekli mi, {e pot>ebuje@ n+jak* cvi$n* cvi$en;.",
	DISPLAY_MESSAGE,
	"Telefonn; seznam znalost; za$;naj;c;ho agenta!",
	DISPLAY_MESSAGE,
	"Bude@ muset proj;t t>emi zkou@kami!",
	DISPLAY_MESSAGE,
	"Za$neme tou jednodu@@;...",
	END_DIALOG,
};

const static char *czechDialog149[] = {
	CHANGE_CHARACTER,
	"Tv]j \\kol je jednoduch^.",
	DISPLAY_MESSAGE,
	"Zamknu t+ tady...",
	DISPLAY_MESSAGE,
	"...a ty mus;@ ut*ct.",
	DISPLAY_MESSAGE,
	"Je to jasn*?!",
	CHANGE_CHARACTER,
	"Pane, j#...",
	CHANGE_CHARACTER,
	"SNA~ SE!!!",
	END_DIALOG,
};

const static char *czechDialog150[] = {
	ANIM_WAIT,
	"Hal=?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Hm, super.",
	END_DIALOG,
};

const static char *czechDialog151[] = {
	"OK, bylo to vtipn^.",
	DISPLAY_MESSAGE,
	"A te% m+ pus[te ven!",
	END_DIALOG,
};

const static char *czechDialog152[] = {
	"Hej! Je tam n+kdo.",
	NEW_LINE,
	"Hal=, proboha je tam n+kdo?!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"POMOC!!!",
	END_DIALOG,
};

const static char *czechDialog153[] = {
	"M+jte slitov#n;!",
	DISPLAY_MESSAGE,
	"J# tu zhebnu! Hele, u{ heb#m!",
	END_DIALOG,
};

const static char *czechDialog154[] = {
	"Dost#v#m hlad!",
	END_DIALOG,
};

const static char *czechDialog155[] = {
	"U{ m+ nenapad#, co tam m#m je$et...",
	END_DIALOG,
};

const static char *czechDialog156[] = {
	"}ekl bych...",
	DISPLAY_MESSAGE,
	"...{e jsi pro@el prvn;...",
	DISPLAY_MESSAGE,
	"...zkou@kou...",
	DISPLAY_MESSAGE,
	"...hned se pust;me...",
	DISPLAY_MESSAGE,
	"...do zkou@ky dal@;...",
	END_DIALOG,
};

const static char *czechDialog157[] = {
	CHANGE_CHARACTER,
	"Tak{e, voj#ku.",
	DISPLAY_MESSAGE,
	"P>edpokl#dejme,",
	NEW_LINE,
	"{e j# jsem te% tv]j zajatec...",
	DISPLAY_MESSAGE,
	"...a zn#m moc d]le{it* tajn* heslo.",
	DISPLAY_MESSAGE,
	"Tv^m \\kolem je ho ze m+ dostat.",
	DISPLAY_MESSAGE,
	"JASAN?!?",
	CHANGE_CHARACTER,
	"A jsou zde n+jak# omezen; jako...?",
	CHANGE_CHARACTER,
	"Ne.",
	DISPLAY_MESSAGE,
	"M]{e@ d+lat, co se ti zl;b;.",
	CHANGE_CHARACTER,
	"M]{u v#m taky plivat na $elo",
	NEW_LINE,
	"a tahat v#s za...",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Ano.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"D+kuju, jenom si d+l#m ment#ln; pozn#mky.",
	END_DIALOG,
};

const static char *czechDialog158[] = {
	"Tak{e rad+ji mi >ekn+te heslo hned,",
	NEW_LINE,
	"abychom to m+li rychleji za sebou.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Promyslim si to.",
	END_DIALOG,
};

const static char *czechDialog159[] = {
	"Hej, tak mluvte.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Sly@;te m+?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Orel vol# kapit#na, orel vol# kapit#na!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Beznad+jn*.",
	END_DIALOG,
};

const static char *czechDialog160[] = {
	"Jste p>ipraven mluvit?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"OK, d#m v#m je@t+ p#r chvil.",
	END_DIALOG,
};

const static char *czechDialog161[] = {
	"Tak{e, co je to za heslo?",
	CHANGE_CHARACTER,
	"Di se zprznit, patetickej fracku.",
	CHANGE_CHARACTER,
	"Bu%te hezky hodnej nebo v#s polocht#m znova...",
	CHANGE_CHARACTER,
	"Jen do toho, budu jen r#d.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"V#m se to l;bilo, {e ano?",
	CHANGE_CHARACTER,
	"Nebylo te nejhor@;...",
	CHANGE_CHARACTER,
	"Aha, vymysl;m tedy n+co chyt>ej@;ho.",
	END_DIALOG,
};

const static char *czechDialog162[] = {
	"N+co jsem v#m p>inesl...",
	CHANGE_CHARACTER,
	"M+ neuplat;@.",
	CHANGE_CHARACTER,
	"Mysl;te?",
	END_DIALOG,
};

const static char *czechDialog163[] = {
	NEW_LINE,
	"SEM S TIM!!!",
	DISPLAY_MESSAGE,
	"Ud+l#m COKOLIV!!!",
	CHANGE_CHARACTER,
	"Heslo...",
	CHANGE_CHARACTER,
	"Heslo je \'KAFE\'.",
	DISPLAY_MESSAGE,
	"}ekni to barmanovi a on ti n+co d#.",
	DISPLAY_MESSAGE,
	"Pak ti >ekne o t>et;m \\kolu.",
	DISPLAY_MESSAGE,
	"A te% m+ rozva{!!!",
	CHANGE_CHARACTER,
	"Promyslim si to...",
	END_DIALOG,
};

const static char *czechDialog164[] = {
	"Ty...",
	DISPLAY_MESSAGE,
	"...ty...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"...tys to dok#zal!",
	END_DIALOG,
};

const static char *czechDialog165[] = {
	"Zaj;mal by t+ tenhle m==c p+knej",
	NEW_LINE,
	"kaleidoskop?",
	CHANGE_CHARACTER,
	"Jednou jsem takovej taky m;val, ale",
	NEW_LINE,
	"kapit#n mi ho vzal, abych si s n;m",
	DISPLAY_MESSAGE,
	"nehr#l, te% si s n;m asi hraje,",
	NEW_LINE,
	"s#m, zloduch.",
	CHANGE_CHARACTER,
	"Kdy{ tak vid;m ty kr#sn* noviny napad# m+,",
	NEW_LINE,
	"{e bychom mohli ud+lat v^m+nu.",
	CHANGE_CHARACTER,
	"Ale nesm;@ nikomu vyzvonit, odkud je m#@...",
	CHANGE_CHARACTER,
	"Plat;.",
	CHANGE_CHARACTER,
	"...ale co kdy{ m+ s t;m kapit#n zase uvid;?",
	CHANGE_CHARACTER,
	"Neboj se, je p>iv#zanej k {idli.",
	CHANGE_CHARACTER,
	"Aha, test $;slo dv+, p>edpokl#d#m...",
	CHANGE_CHARACTER,
	"Jo.",
	CHANGE_CHARACTER,
	"Dobr#, tak co to v t* trubce m#me te%?",
	END_DIALOG,
};

const static char *czechDialog166[] = {
	"\'KAFE.",
	END_DIALOG,
};

const static char *czechDialog167[] = {
	CHANGE_CHARACTER,
	"Hork*, {e?",
	CHANGE_CHARACTER,
	"Uh-huh.",
	DISPLAY_MESSAGE,
	"Kapit#n >;kal, {e mi pov;te n+co o",
	NEW_LINE,
	"t>et;m \\kolu.",
	CHANGE_CHARACTER,
	"Jsem sam^ ucho...",
	DISPLAY_MESSAGE,
	"No, je to takov# hra na schov#vanou.",
	DISPLAY_MESSAGE,
	"Kapit#n se schov# a ty hled#@.",
	CHANGE_CHARACTER,
	"Ale j# ho nechal p>iv#zan*ho k {idli!",
	CHANGE_CHARACTER,
	"Vy jste se bi$ovali, co?",
	DISPLAY_MESSAGE,
	"V posledn; dob+ to n+jak p>eh#n;!...",
	DISPLAY_MESSAGE,
	"Ale stejn+ - oklamal t+.",
	DISPLAY_MESSAGE,
	"Jdi se tam schv#ln+ pod;vat.",
	DISPLAY_MESSAGE,
	"Vsadim se, {e u{ je pry$.",
	CHANGE_CHARACTER,
	"Ale j# jsem mu sebral n]{!",
	DISPLAY_MESSAGE,
	"|;m by si p>e>ezal provazy?!",
	CHANGE_CHARACTER,
	"Mo{n# odhopsal s {idl; u zadku,",
	NEW_LINE,
	"u{ se to p#rkr#t stalo...",
	CHANGE_CHARACTER,
	"Rozumim.",
	DISPLAY_MESSAGE,
	"Na@ly by se n+jak^ Tipy a Triky?",
	CHANGE_CHARACTER,
	"Nic.",
	CHANGE_CHARACTER,
	"Ale no tak.",
	CHANGE_CHARACTER,
	"Ne, chlap$e. Hraje se f*r.",
	END_DIALOG,
};

const static char *czechDialog168[] = {
	"Na@la by se n+jak# ta rada?",
	CHANGE_CHARACTER,
	"Ne.",
	END_DIALOG,
};

const static char *czechDialog169[] = {
	"Zdrav;$ko pane, j# jsem Kevin.",
	CHANGE_CHARACTER,
	"To je @koda, {e nejse@ rad@i stokoruna.",
	DISPLAY_MESSAGE,
	"Co pro tebe m]{u ud+lat?",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"M]{ete mi d#t velkou spoustu pen+z...",
	DISPLAY_MESSAGE,
	"...nebo se m]{ete postavit na hlavu...",
	DISPLAY_MESSAGE,
	"...nebo mastur...",
	CHANGE_CHARACTER,
	"Dob>e, dob>e. D+l#m si b{undu.",
	DISPLAY_MESSAGE,
	"Tak{e?...",
	CHANGE_CHARACTER,
	"Kdo jin^ je tu je@t+ s n#mi v t#bo>e?",
	CHANGE_CHARACTER,
	"Ty jse@ novin#>?",
	CHANGE_CHARACTER,
	"Ne, jsem tajnej agent.",
	CHANGE_CHARACTER,
	"Ty taky?",
	DISPLAY_MESSAGE,
	"Jsme tady jenom t>i.",
	DISPLAY_MESSAGE,
	"J#, kapit#n a str#{n^.",
	CHANGE_CHARACTER,
	"~#dn* {ensk*?",
	CHANGE_CHARACTER,
	"Ani noha.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Erm, tak to bychom nem+li...",
	END_DIALOG,
};

const static char *czechDialog170[] = {
	"Nen; tu moc velkej provoz, co?",
	CHANGE_CHARACTER,
	"Chce@ si n+co objednat nebo ne?",
	CHANGE_CHARACTER,
	"Nem#m pen;ze.",
	CHANGE_CHARACTER,
	"Dnes je to zdarma.",
	CHANGE_CHARACTER,
	"Fakticky?",
	CHANGE_CHARACTER,
	"Fakticky.",
	CHANGE_CHARACTER,
	"Chci p#rek v rohl;ku.",
	CHANGE_CHARACTER,
	"N+t.",
	CHANGE_CHARACTER,
	"Pizza?",
	CHANGE_CHARACTER,
	"N+t.",
	CHANGE_CHARACTER,
	"Brambor#k?",
	CHANGE_CHARACTER,
	"N+t.",
	CHANGE_CHARACTER,
	"Cokoliv?",
	CHANGE_CHARACTER,
	"N+t.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Ne, d+kuju.",
	DISPLAY_MESSAGE,
	"Nem#m hlad.",
	END_DIALOG,
};

const static char *czechDialog171[] = {
	"Co pijete?",
	CHANGE_CHARACTER,
	"|aj.",
	CHANGE_CHARACTER,
	"Aha.",
	END_DIALOG,
};

const static char *czechDialog172[] = {
	"Hezk^ po$as;.",
	CHANGE_CHARACTER,
	"Mhmmm...",
	END_DIALOG,
};

const static char *czechDialog173[] = {
	"N+kdy se c;t;m unaven+.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Jako kdyby m+ vedla slep# my@ (doslova).",
	END_DIALOG,
};

const static char *czechDialog174[] = {
	"Hele, Woodstock u{ skon$il!",
	END_DIALOG,
};

const static char *czechDialog175[] = {
	"D+kuju.",
	END_DIALOG,
};

const static char *czechDialog176[] = {
	CHANGE_CHARACTER,
	"Co to sakra...",
	END_DIALOG,
};

const static char *czechDialog177[] = {
	"Hej, Nem#te {;ze<?",
	DISPLAY_MESSAGE,
	"Nezapomn+l jste na sv]j @#lek $aje?",
	END_DIALOG,
};

const static char *czechDialog178[] = {
	"Pane, byl jsem informov#n, {e...",
	CHANGE_CHARACTER,
	"Pozd+ji!",
	DISPLAY_MESSAGE,
	"Te% jsem zanepr#zdn+n!",
	CHANGE_CHARACTER,
	"Jak si p>ejete pane.",
	END_DIALOG,
};

const static char *czechDialog179[] = {
	"Pane, n+jak^ mlad^ chlapec se pokou@el",
	NEW_LINE,
	"dostat do vily.",
	END_DIALOG,
};

const static char *czechDialog180[] = {
	"Nem+jte strach.",
	DISPLAY_MESSAGE,
	"Mlad^ chlapci jsou zv+dav;...",
	DISPLAY_MESSAGE,
	"...a m]j d]m v nich zv+davost jenom podn+cuje.",
	DISPLAY_MESSAGE,
	"Ale m+jte ho na o$;ch.",
	CHANGE_CHARACTER,
	"Ano, pane!",
	END_DIALOG,
};

const static char *czechDialog181[] = {
	"Pane, ten chlapec se zase pokou@el dostat dovnit>.",
	END_DIALOG,
};

const static char *czechDialog182[] = {
	"Mysl;@, {e je to v#{n*?",
	CHANGE_CHARACTER,
	"Hmmm... Ne...",
	DISPLAY_MESSAGE,
	"To u{ je zvl#@tn;. Ale snad to bude OK,",
	DISPLAY_MESSAGE,
	"pokud to nen; n+jakej cvok.",
	DISPLAY_MESSAGE,
	"Mo{n# bychom m+li...",
	CHANGE_CHARACTER,
	"Ale n*.",
	DISPLAY_MESSAGE,
	"Jenom ho dr{ pry$ od vily.",
	DISPLAY_MESSAGE,
	"Ale >ekni mi, kdyby se o n+co pokou@el.",
	DISPLAY_MESSAGE,
	"Te% se vra[ do pr#ce.",
	END_DIALOG,
};

const static char *czechDialog183[] = {
	"Ne>;kej mi, {e u{ je to zase ten kluk...",
	CHANGE_CHARACTER,
	"Ob#v#m se, {e ano.",
	DISPLAY_MESSAGE,
	"Str#{n^ u br#ny >;k#,",
	DISPLAY_MESSAGE,
	"{e ten kluk je zoufalej.",
	END_DIALOG,
};

const static char *czechDialog184[] = {
	"U{ my za$;n# l*zt na nervy.",
	DISPLAY_MESSAGE,
	"A za co t+ asi plat;m? Pr#v+ od toho,",
	DISPLAY_MESSAGE,
	"aby pot;{e lezly po nervech tv^ch a ne m^ch!",
	CHANGE_CHARACTER,
	"Tak j# ho...",
	CHANGE_CHARACTER,
	"Je@t+ ne. D#me mu je@t+ posledn; @anci.",
	DISPLAY_MESSAGE,
	"U{ je to opravdu n+jak^ divn^. ",
	END_DIALOG,
};

const static char *czechDialog185[] = {
	"Pane...",
	CHANGE_CHARACTER,
	"Nech m+ h#dat...",
	DISPLAY_MESSAGE,
	"TEN Chlapec?!?...",
	CHANGE_CHARACTER,
	"Z#sah.",
	CHANGE_CHARACTER,
	"Pro$ se mus;m o v@echno starat j#?!",
	DISPLAY_MESSAGE,
	"copak nedok#{e@ nic vy>;dit s#m?",
	CHANGE_CHARACTER,
	"M#m ho zab;t nebo jenom rozb;t na kousky?",
	CHANGE_CHARACTER,
	"Stupidn; housko.",
	DISPLAY_MESSAGE,
	"Jsou zde... lep@; cesty...",
	END_DIALOG,
};

const static char *czechDialog186[] = {
	"Zvl#dnu to s#m.",
	DISPLAY_MESSAGE,
	"Te% vypadni!",
	DISPLAY_MESSAGE,
	"Musim se p>evl*knout.",
	END_DIALOG,
};

const static char *czechDialog187[] = {
	"Hele, ty tam naho>e!",
	DISPLAY_MESSAGE,
	"Okam{it+ slez dol]!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Nulov# reakce.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Je snad hluchej nebo co?",
	END_DIALOG,
};

const static char *czechDialog188[] = {
	"Hej, pt#ku, nesty% se.",
	DISPLAY_MESSAGE,
	"Poj% se sezn#mit...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"(ach jo)",
	END_DIALOG,
};

const static char *czechDialog189[] = {
	"Pu[a Ba[a, malej ope>enej...",
	END_DIALOG,
};

const static char *czechDialog190[] = {
	NEW_LINE,
	"Hej, vypadni od t+ch dve>;!",
	CHANGE_CHARACTER,
	"Pro$?",
	CHANGE_CHARACTER,
	"Ty dve>e t+ nemaj r#dy,",
	NEW_LINE,
	"mohly by se na@tvat a zamknout.",
	DISPLAY_MESSAGE,
	"Prost+ se od nich dr{ d#l.",
	END_DIALOG,
};

const static char *czechDialog191[] = {
	CHANGE_CHARACTER,
	"};kal jsem ti, abys tam ne$muchal!",
	CHANGE_CHARACTER,
	"OK, OK...",
	END_DIALOG,
};

const static char *czechDialog192[] = {
	"M#m pro v#s novou z#silku zlata.",
	CHANGE_CHARACTER,
	"Ano, v;m.",
	DISPLAY_MESSAGE,
	"Heslo?",
	CHANGE_CHARACTER,
	"M+s;$ky.",
	CHANGE_CHARACTER,
	"V po>#dku.",
	DISPLAY_MESSAGE,
	"M]{ete to odn*st dovnit>.",
	CHANGE_CHARACTER,
	"\'si pi@, @*fe.",
	END_DIALOG,
};

const static char *czechDialog193[] = {
	"Jak u{ jsem >ekl, na@e organizace",
	NEW_LINE,
	"se zab^v# nevy>e@iteln^mi z#hadami.",
	DISPLAY_MESSAGE,
	"Nap>;klad ned#vno jsme vy>e@ili spat>en;",
	NEW_LINE,
	"kor#bu UFO nad nudistpl#{i \'Amerika\'",
	NEW_LINE,
	"a{ kdesi v |esk* republice.",
	CHANGE_CHARACTER,
	"Nef;kejte!",
	DISPLAY_MESSAGE,
	"Jak?",
	CHANGE_CHARACTER,
	"Sest>elili jsme je.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Ch#pu.",
	DISPLAY_MESSAGE,
	"A co bylo.. co bylo ufnitf?",
	CHANGE_CHARACTER,
	"Chcete to v+d+t?",
	CHANGE_CHARACTER,
	"O= ano, jako v+ftkyn+ jfem velmi",
	NEW_LINE,
	"zv+dav# a zv;dav# ofobnoft.",
	CHANGE_CHARACTER,
	"OPRAVDU to chcete v+d+t?",
	CHANGE_CHARACTER,
	"ANO!",
	CHANGE_CHARACTER,
	"Ale...",
	DISPLAY_MESSAGE,
	"...opravdu, OPRAVDU?",
	CHANGE_CHARACTER,
	"ANO!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Bohu{el, je to tajn*...",
	DISPLAY_MESSAGE,
	"Ka{dop#dn+, pot>ebujeme va@i pomoc.",
	CHANGE_CHARACTER,
	"J# nejsem {#dn^ agent, ale v+ftkyn+...",
	CHANGE_CHARACTER,
	"J# v;m.",
	DISPLAY_MESSAGE,
	"M#me tu velice slo{it^ p>;pad,",
	NEW_LINE,
	"se kter^m jsme za posledn;ch @est",
	NEW_LINE,
	"m+s;c] nedok#zali v]bec hnout.",
	DISPLAY_MESSAGE,
	"Jsme v beznad+jn* situaci.",
	DISPLAY_MESSAGE,
	"Tak{e jsem si >ekl, kdy{ u{ se zab^v#me",
	NEW_LINE,
	"zvl#@tn;mi p>;pady...",
	DISPLAY_MESSAGE,
	"...tak pro$ bychom nepou{ili",
	NEW_LINE,
	"i trochu nestandardn; metody?",
	CHANGE_CHARACTER,
	"A?...",
	CHANGE_CHARACTER,
	"Pod;vejte, uk#{u v#m Zlat* Str#nky.",
	DISPLAY_MESSAGE,
	"Za pou{it; sv^ch schopnost; vyberte jm*no.",
	DISPLAY_MESSAGE,
	"Mo{n# to bude pr#v+ ON,",
	NEW_LINE,
	"ten, kdo n#m pom]{e celou v+c vy>e@it.",
	CHANGE_CHARACTER,
	"Ale nev+f;te fnad, {e to bude fungovat?",
	CHANGE_CHARACTER,
	"Ne, to v]bec ne.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Fdy[ je to blboft!",
	CHANGE_CHARACTER,
	"J# vim.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Ou key, tak mi ty Zlat^ Stf#nky uka{te.",
	END_DIALOG,
};

const static char *czechDialog194[] = {
	ANIM_WAIT,
	"To jm*no je...",
	DISPLAY_MESSAGE,
	"...Kevin...",
	DISPLAY_MESSAGE,
	"...Kevin Hoppef...",
	END_DIALOG,
};

const static char *czechDialog195[] = {
	"T#mhle je.",
	END_DIALOG,
};

const static char *czechDialog196[] = {
	"Omlouv#m se za svoje mu{e.",
	DISPLAY_MESSAGE,
	"N+kdy jsou mali$ko nerv=zn;...",
	DISPLAY_MESSAGE,
	"Ale pros;m,",
	DISPLAY_MESSAGE,
	"poj%me si promluvit...",
	END_DIALOG,
};

const static char *czechDialog197[] = {
	"Poslouchej ty plesnivej d+dku...",
	CHANGE_CHARACTER,
	"Uklidni se.",
	DISPLAY_MESSAGE,
	"Dej mi p+t minut a j# se budu sna{it",
	NEW_LINE,
	"v@echno vysv+tlit.",
	CHANGE_CHARACTER,
	"Dob>e, p+t minut. Pak za$nu zu>it.",
	CHANGE_CHARACTER,
	"Tak{e...",
	DISPLAY_MESSAGE,
	"J# jsem @*f tajn* @pion#{n; organizace",
	NEW_LINE,
	"Hurv;nkovo spasen;.",
	CHANGE_CHARACTER,
	"Hurv;nkovo spasen;? Proboha pro$?",
	CHANGE_CHARACTER,
	"Ani s#m nev;m.",
	DISPLAY_MESSAGE,
	"Je to tajn*.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Tak to je teda n+co.",
	CHANGE_CHARACTER,
	"C;lem na@; organizace je >e@it v@echny",
	NEW_LINE,
	"z#hadn* a potenci#ln+ nebezpe$n* probl*my sv+ta.",
	CHANGE_CHARACTER,
	"Jako dan+?",
	CHANGE_CHARACTER,
	"Ne, jako UFO, vyn#lezy @;len^ch v+dc],",
	NEW_LINE,
	"o{ivl* mrtv*...",
	CHANGE_CHARACTER,
	"F;ha!",
	CHANGE_CHARACTER,
	"Ano, kdy{ si nev; rady ani policie a speci#ln;",
	NEW_LINE,
	"vl#dn; jednotky...",
	DISPLAY_MESSAGE,
	"...p>ed#v# se to n#m. Ale...",
	DISPLAY_MESSAGE,
	"Jinak. P>ed @esti m+s;ci za$alo mizet p>;mo",
	NEW_LINE,
	"z trezor] bank obrovsk* mno{stv; zlata,",
	NEW_LINE,
	"bankovek a cenn^ch pap;r].",
	DISPLAY_MESSAGE,
	"Doslova! Puf! A je to v@echno pry$.",
	CHANGE_CHARACTER,
	"Jako \'PUF\' a je to pry$...?",
	CHANGE_CHARACTER,
	"P>esn+ tak, zmiz; beze stopy,",
	NEW_LINE,
	" zn; to neuv+>iteln+, {e?",
	DISPLAY_MESSAGE,
	"Cel* se to v{dy odehraje za pouh^ch p#r sekund.",
	DISPLAY_MESSAGE,
	"Jsou tam v@ude kamery, ale neukazuj;",
	NEW_LINE,
	"v]bec nic, pouze miz;c; zlato.",
	DISPLAY_MESSAGE,
	"A proto jsme najmuli vizion#>ku,",
	NEW_LINE,
	"aby n#m na@la n+koho, kdo si s t;m",
	NEW_LINE,
	"bude v+d+t rady.",
	DISPLAY_MESSAGE,
	"Vybrala tebe.",
	CHANGE_CHARACTER,
	"Prosim?!",
	DISPLAY_MESSAGE,
	"};kal jste, {e jste najmuli vizion#>ku...",
	DISPLAY_MESSAGE,
	"...takovou tu, co vykl#d# budoucnost?!?",
	CHANGE_CHARACTER,
	"Ano, jsme v beznad+jn* situaci",
	NEW_LINE,
	"a pokou@;me se o ka{d* mo{n* >e@en;.",
	CHANGE_CHARACTER,
	"(o$i v sloup) Tohle je @;len^! Maminko, vzbu% m+.",
	NEW_LINE,
	"Je tu n+jakej @;lenej buzik a...",
	CHANGE_CHARACTER,
	"Uklidni se.",
	DISPLAY_MESSAGE,
	"M#me pro tebe n#vrh.",
	DISPLAY_MESSAGE,
	"Pokus se n#m pomoci a bude@ @t+d>e odm+n+n.",
	CHANGE_CHARACTER,
	"Jak?",
	CHANGE_CHARACTER,
	"Uspokojen;m z dob>e vykonan* pr#ce?",
	END_DIALOG,
};

const static char *czechDialog198[] = {
	CHANGE_CHARACTER,
	"Slavnostn; poh>eb?",
	END_DIALOG,
};

const static char *czechDialog199[] = {
	CHANGE_CHARACTER,
	"|estn# vyznamen#n;?",
	END_DIALOG,
};

const static char *czechDialog200[] = {
	CHANGE_CHARACTER,
	"Holky?",
	CHANGE_CHARACTER,
	"HOLKY! Kde?.",
	CHANGE_CHARACTER,
	"Ka{d# holka miluje tajn^ agenty.",
	END_DIALOG,
};

const static char *czechDialog201[] = {
	"Dob>e, beru to. Co m#m tedy d+lat?",
	CHANGE_CHARACTER,
	"Ne{ p]jde@ do ostr* mise, doporu$uji",
	NEW_LINE,
	"alespo< kr#tk^ speci#ln; v^cvik",
	NEW_LINE,
	"v na@em tajn*m v^cvikov*m t#bo>e.",
	DISPLAY_MESSAGE,
	"P>iprav;m pro tebe propustku.",
	DISPLAY_MESSAGE,
	"Domluveno?",
	CHANGE_CHARACTER,
	"Domluveno!",
	END_DIALOG,
};

const static char *czechDialog202[] = {
	"...a byla to docela sranda.",
	CHANGE_CHARACTER,
	"To jsem r#d, {e se ti l;bily na@e",
	NEW_LINE,
	"tr*ninkov* metody.",
	DISPLAY_MESSAGE,
	"Ale k v+ci.",
	DISPLAY_MESSAGE,
	"Mus;m se p>iznat, {e jsem nev+>il,",
	NEW_LINE,
	"{e bys mohl b^t skute$n+ u{ite$n^.",
	DISPLAY_MESSAGE,
	"Nic osobn;ho.",
	CHANGE_CHARACTER,
	"To douf#m.",
	CHANGE_CHARACTER,
	"Ale p>inesl jsi n#m @t+st;.",
	DISPLAY_MESSAGE,
	"Na@i lid* zjistili, {e jak^si...",
	DISPLAY_MESSAGE,
	"...byznysnem utr#c; pen;ze jak @;len^",
	NEW_LINE,
	"kupuje nejen stovky prezervativ] a,",
	NEW_LINE,
	"ply@ov^ch medv;dk], ale tak*...",
	DISPLAY_MESSAGE,
	"...n+kter* velice podivn* suroviny.",
	DISPLAY_MESSAGE,
	"Mimoto jsou zde t>i velmi podivn*",
	NEW_LINE,
	"v+ci okolo tohoto chl#pka:",
	DISPLAY_MESSAGE,
	"...v{dy plat; bankovkami, co{ je v dne@n;",
	NEW_LINE,
	"dob+ platebn;ch karet dost divn*...",
	DISPLAY_MESSAGE,
	"...za druh*, p>ed p]l rokem se mu o bohatstv;",
	NEW_LINE,
	"jak* m# te% ani nesnilo...",
	DISPLAY_MESSAGE,
	"...a za t>et;, na co, sakra, pot>ebuje",
	NEW_LINE,
	"100 kilo tampax]?",
	CHANGE_CHARACTER,
	"Mo{n# je to transvestit a mysl; si...",
	CHANGE_CHARACTER,
	"Mo{n#.",
	DISPLAY_MESSAGE,
	"Ale j# chci, abys tam let+l,",
	NEW_LINE,
	"pokusil se dostat do jeho vily...",
	DISPLAY_MESSAGE,
	"...a pod;val se tam po zaj;mav^ch informac;ch.",
	DISPLAY_MESSAGE,
	"Co tomu >;k#@?",
	CHANGE_CHARACTER,
	"No...",
	CHANGE_CHARACTER,
	"Slibuji, {e bude@ ofici#ln; tajn^ agent",
	NEW_LINE,
	"kdy{ se vr#t;@ {iv^ zp#tky, ehm...",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Slibujete?",
	CHANGE_CHARACTER,
	"M#@ moje $estn* slovo.",
	CHANGE_CHARACTER,
	"Dob>e. Jsem p>ipravenej.",
	DISPLAY_MESSAGE,
	"Tak{e kam se to m#m vydat?",
	CHANGE_CHARACTER,
	"Je to mal# vesni$ka.",
	DISPLAY_MESSAGE,
	"Na map#ch ji ani nenajde@...",
	DISPLAY_MESSAGE,
	"Ale p>edt;m ne{ p]jde@, dostane@ jistou speci#ln;",
	NEW_LINE,
	"agentskou v^bavu.",
	DISPLAY_MESSAGE,
	"Dal bych n+jak* l*taj;c; sand#ly,",
	NEW_LINE,
	"ale bohu{el mi s nimi n+kdo ulet+l.",
	DISPLAY_MESSAGE,
	"~v^ka$ky zp]sobuj;c; mozkovou mrtvici",
	NEW_LINE,
	"u{ taky do@ly...",
	DISPLAY_MESSAGE,
	"vlastn+ jedin# speci#ln; v+c, kter# tu pr#v+ je",
	NEW_LINE,
	"je super lepidlo.",
	DISPLAY_MESSAGE,
	"No, lep@; ne{ dr#tem do oka...",
	DISPLAY_MESSAGE,
	"Zlom vaz!",
	END_DIALOG,
};

const static char *czechDialog203[] = {
	CHANGE_CHARACTER,
	"~#dnej strach.",
	DISPLAY_MESSAGE,
	"Bude zase v po>#dku.",
	DISPLAY_MESSAGE,
	"Vida, my o vlku a tady ho pr#v+ vyn#@ej...",
	END_DIALOG,
};

const static char *czechDialog204[] = {
	CHANGE_CHARACTER,
	"Dostal, co si zaslou{il.",
	DISPLAY_MESSAGE,
	"Ale konec tlach#n;, m#me m#lo $asu!",
	CHANGE_CHARACTER,
	"Ne! Po$kejte!",
	DISPLAY_MESSAGE,
	"Musim je@t+ za (P)Ani$kou!",
	CHANGE_CHARACTER,
	"Ermm... to nejde.",
	CHANGE_CHARACTER,
	"Jak to NEJDE?!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"V;@... Anna byla n#@ mu{.",
	DISPLAY_MESSAGE,
	"M+la za \\kol na tebe dohl;{et",
	NEW_LINE,
	"kdyby mikrokamera p>estala",
	NEW_LINE,
	"fungovat.",
	DISPLAY_MESSAGE,
	"A taky to byla tvoje motivace...",
	CHANGE_CHARACTER,
	"To v#m nev+>im!",
	CHANGE_CHARACTER,
	"U{ dokonce odjela na svou dal@; misi",
	NEW_LINE,
	"do Som#lska.",
	DISPLAY_MESSAGE,
	"Je mi l;to.",
	CHANGE_CHARACTER,
	"Chcete mi snad >;ct, {e i ta baba...?",
	CHANGE_CHARACTER,
	"Ne, ta je odtud, zaplatili jsme j;.",
	CHANGE_CHARACTER,
	"No to je teda zaj;mav^.",
	DISPLAY_MESSAGE,
	"Pro$ byste kv]li takov* hlouposti",
	NEW_LINE,
	"zab>edali do tolika probl*m]?...",
	CHANGE_CHARACTER,
	"Jde o tv]j adrenalin. Musel b^t na \\rovni.",
	DISPLAY_MESSAGE,
	"Po$;tali jsme s t;m, {e t+ to na@tve.",
	DISPLAY_MESSAGE,
	"A nem^lili jsme se, {e?",
	CHANGE_CHARACTER,
	"Zach#z;te s lidma jako se zv;>atama",
	NEW_LINE,
	"v pokusn* laborato>i.",
	DISPLAY_MESSAGE,
	"Jste nechutn;...",
	CHANGE_CHARACTER,
	"Ale fungovalo to, ne?",
	CHANGE_CHARACTER,
	"Je to v@echno a{ moc neuv+>iteln^.",
	DISPLAY_MESSAGE,
	"Mo{n# mi je@t+ >eknete, {e i ten pes",
	NEW_LINE,
	"byl maskovanej zakrn+lej agent...",
	DISPLAY_MESSAGE,
	"...{e m+ ten starek d+dek hl;dal...",
	DISPLAY_MESSAGE,
	"...a {e Delvita poskytuje kvalitn; slu{by?!",
	END_DIALOG,
};

const static char *czechDialog205[] = {
	CHANGE_CHARACTER,
	"Nen; to jak v {#dnym b*$kovym filmu,",
	NEW_LINE,
	"prost+ b+{n# agentsk# pr#ce.",
	DISPLAY_MESSAGE,
	"Ale co, ml;$<#ku, p>idej se k n#m a mo{n#",
	NEW_LINE,
	"bude@ n+kdy pracovat s (P)Annou!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"No...",
	DISPLAY_MESSAGE,
	"Promyslim to...",
	CHANGE_CHARACTER,
	"B#je$n*.",
	DISPLAY_MESSAGE,
	"Bylo m^m pot+@en;m vid+t t+ v akci!",
	END_DIALOG,
};

const static char *czechDialog206[] = {
	CHANGE_CHARACTER,
	"Ani mi to nemus;@ popisovat,",
	DISPLAY_MESSAGE,
	"u{ jsem si p>e$etl velice detailn; zpr#vu.",
	CHANGE_CHARACTER,
	"A co se stane s profesorem?",
	CHANGE_CHARACTER,
	"Ten chud#k u{ zase zapomn+l recept.",
	NEW_LINE,
	"Nat#hneme ho na sk>ipec.",
	DISPLAY_MESSAGE,
	"A pak mu d#me nejlep@; laborato>, co m#me.",
	DISPLAY_MESSAGE,
	"Te% m#me jen t+ch p#r pilulek,",
	NEW_LINE,
	"co jsi zachr#nil.",
	CHANGE_CHARACTER,
	"A Pankr#c Oblouk?",
	CHANGE_CHARACTER,
	"Ned+lej si starost, jeho hrabivost bude potrest#na.",
	CHANGE_CHARACTER,
	"To douf#m...",
	DISPLAY_MESSAGE,
	"A je@t+ jedna mali$kost...",
	DISPLAY_MESSAGE,
	"N+co jste mi sl;bil...",
	END_DIALOG,
};

const static char *czechDialog207[] = {
	CHANGE_CHARACTER,
	"J#?...",
	DISPLAY_MESSAGE,
	"To si u{ nepamatuju...",
	CHANGE_CHARACTER,
	"};kal jste, {e m+ ud+l#te offici#ln;m agentem...",
	DISPLAY_MESSAGE,
	"\'Holky maj r#dy tajn^ agenty\'. Vzpom;n#te?",
	END_DIALOG,
};

const static char *czechDialog208[] = {
	CHANGE_CHARACTER,
	"(sigh)",
	DISPLAY_MESSAGE,
	"Slib je slib..",
	DISPLAY_MESSAGE,
	"Mysl;@?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Tak jo, poj% sem.",
	END_DIALOG,
};

const static char *czechDialog209[] = {
	"Ve jm*nu...",
	DISPLAY_MESSAGE,
	"...bla...bla...bla...",
	DISPLAY_MESSAGE,
	"...bla...bla...",
	DISPLAY_MESSAGE,
	"...pro na@; zemi.",
	END_DIALOG,
};

const static char *czechDialog210[] = {
	"       No...       ",
	DISPLAY_MESSAGE,
	"a to je v@echno, chlapci!",
	END_DIALOG,
};

const static char *czechDialog211[] = {
	"Na@el jsem pilulku $asu!",
	DISPLAY_MESSAGE,
	"Musela vypadnout z lahvi$ky, mr@ka..",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"To je @t;gro.",
	END_DIALOG,
};

const static char *czechDialog212[] = {
	"J]ha!",
	DISPLAY_MESSAGE,
	"To je okouzluj;c;!...",
	END_DIALOG,
};	

const static char *polishDialog0[] = {
	ANIM_WAIT,
	"Dzie= dobry.",
	CHANGE_CHARACTER,
	"Taaa.",
	CHANGE_CHARACTER,
	"Dlaczego pan tu stoi?",
	CHANGE_CHARACTER,
	"To kwestia grawitacji.",
	CHANGE_CHARACTER,
	"Niesamowicie $mieszny dowcip...",
	NEW_LINE,
	"Jak na <o%nierza.",
	CHANGE_CHARACTER,
	"Nie jestem <o%nierzem, cho^ kiedy$",
	NEW_LINE,
	"stara%em si# nim zosta^.",
	DISPLAY_MESSAGE,
	"Nie zda%em testu na intel...",
	NEW_LINE,
	"fizycznego.",
	DISPLAY_MESSAGE,
	"Kazali mi strzeli^ w rzucon@",
	NEW_LINE,
	"monet# podczas skoku z drzewa...",
	DISPLAY_MESSAGE,
	"...na konia.",
	CHANGE_CHARACTER,
	"No, kiepska sprawa...",
	CHANGE_CHARACTER,
	"Oddzia%y Specjalne to nie bu%ka",
	NEW_LINE,
	"z mas%em, no wiesz.",
	CHANGE_CHARACTER,
	"Szkoda, <e si# nie uda%o.",
	CHANGE_CHARACTER,
	"Taaa, nie trafi%em w konia.",
	END_DIALOG,
};

const static char *polishDialog1[] = {
	"Wi#c...",
	CHANGE_CHARACTER,
	"Chcesz us%ysze^ $mieszn@ odpowied>?",
	CHANGE_CHARACTER,
	"Odpu$^ pan sobie.",
	CHANGE_CHARACTER,
	"No dobra, ale wiesz, tu w okolicy nie",
	NEW_LINE,
	"ma za wiele rozrywki.",
	DISPLAY_MESSAGE,
	"Czasami lubi# sobie troch# po<artowa^.",
	CHANGE_CHARACTER,
	"Wi#c...",
	CHANGE_CHARACTER,
	"Pilnuj# tej posesji...",
	CHANGE_CHARACTER,
	"]a%. A to niespodzianka.",
	CHANGE_CHARACTER,
	"...i mam rozkaz zabi^ KOGOKOLWIEK,",
	NEW_LINE,
	"kto b#dzie chcia% wej$^.",
	CHANGE_CHARACTER,
	"\377 co z w%a$cicielem?",
	CHANGE_CHARACTER,
	"\377n to nie KTOKOLWIEK, no nie?",
	CHANGE_CHARACTER,
	"To chyba nie pozwoli pan MI wej$^?",
	CHANGE_CHARACTER,
	"Bingo.",
	CHANGE_CHARACTER,
	"Nawet jak poprosz#?",
	CHANGE_CHARACTER,
	"Bez szans, dzieciaku.",
	CHANGE_CHARACTER,
	"\377PROOOOOSZ[.",
	CHANGE_CHARACTER,
	"Zapomnij. Mam serce z kamienia.",
	CHANGE_CHARACTER,
	"Jak i m*zg.",
	CHANGE_CHARACTER,
	"\377Nie %api#.",
	CHANGE_CHARACTER,
	"Niewa<ne... Jak m*g%bym panu",
	NEW_LINE,
	"zmi#kczy^ serce?",
	CHANGE_CHARACTER,
	"Nie dasz rady. Jestem prawdziwym twardzielem.",
	DISPLAY_MESSAGE,
	"Ale podejd> no, mam dla ciebie",
	NEW_LINE,
	"co$ na pocieszenie...",
	END_DIALOG,
};

const static char *polishDialog2[] = {
	"Dzi#ki. Co to jest?",
	CHANGE_CHARACTER,
	"Ciastko z czekolady.",
	DISPLAY_MESSAGE,
	"M*j pracodawca da% mi kilka takich",
	NEW_LINE,
	"na podwieczorek...",
	CHANGE_CHARACTER,
	"To on jest w domu?!",
	CHANGE_CHARACTER,
	"Pan Ci@gwa? Tak, a dlaczego?",
	CHANGE_CHARACTER,
	"Och, nic... Ci@gwa...",
	NEW_LINE,
	"Chyba o nim s%ysza%em...",
	CHANGE_CHARACTER,
	"Musia%e$. Robi du<@ fors#, wiesz.",
	NEW_LINE,
	"Zw%aszcza ostatnio...",
	CHANGE_CHARACTER,
	"Taaa?...",
	CHANGE_CHARACTER,
	"Ale nie wiem jak.",
	DISPLAY_MESSAGE,
	"Mo<e ma to co$ wsp*lnego z tym",
	NEW_LINE,
	"postrzelonym profesorkiem, kt*ry",
	NEW_LINE,
	"wpad% tu pewnego dnia...",
	DISPLAY_MESSAGE,
	"Ah, wydaje ci si#, <e jeste$ cwany, co?!",
	NEW_LINE,
	"Jeste$ szpiegiem?!",
	CHANGE_CHARACTER,
	"Hej, ze mnie normalny go$^.",
	NEW_LINE,
	"Nie chcesz m*wi^, nie m*w.",
	CHANGE_CHARACTER,
	"Pan Ci@gwa kaza% mi uwa<a^",
	NEW_LINE,
	"na szpieg*w...",
	CHANGE_CHARACTER,
	"Czy ja wygl@dam na szpiega?",
	CHANGE_CHARACTER,
	"...I zabija^ ich bez pytania...",
	CHANGE_CHARACTER,
	"Hej, spoko...",
	CHANGE_CHARACTER,
	"...A ja nie zabi%em ju< nikogo",
	NEW_LINE,
	"od baaaaaardzo dawna...",
	CHANGE_CHARACTER,
	"To o to ciasteczko, no nie?",
	NEW_LINE,
	"Chcesz je z powrotem? Nie ma sprawy.",
	CHANGE_CHARACTER,
	"\377Sorry, troch# mnie ponios%o.",
	CHANGE_CHARACTER,
	"Rozumiem.",
	NEW_LINE,
	"Gor@co tutaj.",
	CHANGE_CHARACTER,
	"Taaa.",
	END_DIALOG,
};

const static char *polishDialog3[] = {
	"Panie stra<niku, ja...",
	CHANGE_CHARACTER,
	"Pos%uchaj, ch%opcze.",
	DISPLAY_MESSAGE,
	"Szpieg czy nie szpieg, to nie",
	NEW_LINE,
	"jest pytanie.",
	DISPLAY_MESSAGE,
	"I tak nie wejdziesz, bez wzgl#du na to...",
	DISPLAY_MESSAGE,
	"...czy chcesz sobie pozwiedza^, co$ ukra$^",
	NEW_LINE,
	"czy pogada^ z w%a$cicielem.",
	DISPLAY_MESSAGE,
	"I nie zmusisz mnie do gadania.",
	DISPLAY_MESSAGE,
	"Jeszcze jedna pr*ba, i zrobi# kilka",
	NEW_LINE,
	"autostrad dla robak*w.",
	DISPLAY_MESSAGE,
	"W twoim ciele.",
	NEW_LINE,
	"Ka pe wu?",
	CHANGE_CHARACTER,
	"Ka pe wu.",
	END_DIALOG,
};

const static char *polishDialog4[] = {
	"Fajny mundur.",
	END_DIALOG,
};

const static char *polishDialog5[] = {
	CHANGE_CHARACTER,
	"O kurka! To tylko ty!...",
	END_DIALOG,
};

const static char *polishDialog6[] = {
	"Hej!",
	CHANGE_CHARACTER,
	"Co?",
	CHANGE_CHARACTER,
	"Co jest w tej butelce?",
	CHANGE_CHARACTER,
	"Niczego nie udowodnisz!",
	CHANGE_CHARACTER,
	"Co$ \'gor@cego\', nie?..",
	CHANGE_CHARACTER,
	"Nie tw*j interes.",
	CHANGE_CHARACTER,
	"Pijemy na s%u<bie, co?",
	CHANGE_CHARACTER,
	"Wydaje ci si#, <e prawie mnie",
	NEW_LINE,
	"z%apa%e$, nie?... Zapomnij.",
	END_DIALOG,
};

const static char *polishDialog7[] = {
	"Hej!",
	CHANGE_CHARACTER,
	"Nic nie widzia%e$.",
	NEW_LINE,
	"Jestem czysty.",
	END_DIALOG,
};

const static char *polishDialog8[] = {
	"Hej!",
	CHANGE_CHARACTER,
	"Spadaj.",
	END_DIALOG,
};

const static char *polishDialog9[] = {
	"Co by pan powiedzia%, gdybym da% panu",
	NEW_LINE,
	"troch# z%ota?...",
	CHANGE_CHARACTER,
	"Powiedzia%bym dzi#kuj#.",
	CHANGE_CHARACTER,
	"A wpu$ci%by mnie pan?",
	CHANGE_CHARACTER,
	"No chyba...",
	CHANGE_CHARACTER,
	"Musi pan by^ pewien.",
	CHANGE_CHARACTER,
	"OK, jestem pewien. Wpuszcz# ci#.",
	CHANGE_CHARACTER,
	"W porz@dku. Jedziemy.",
	END_DIALOG,
};

const static char *polishDialog10[] = {
	"A teraz prosz# otworzy^ drzwi.",
	CHANGE_CHARACTER,
	"Nie ma szans. Zmykaj.",
	CHANGE_CHARACTER,
	"Hej! Da%em panu z%oto, pami#ta pan?...",
	CHANGE_CHARACTER,
	"Jakie z%oto?",
	CHANGE_CHARACTER,
	"JAKIE Z]OTO?!?",
	CHANGE_CHARACTER,
	"Nic nie wiem o <adnym z%ocie.",
	END_DIALOG,
};

const static char *polishDialog11[] = {
	"Ty... Ty...",
	CHANGE_CHARACTER,
	"Odjazd.",
	CHANGE_CHARACTER,
	"Mia% mnie pan wpu$ci^!",
	NEW_LINE,
	"Ale nie w maliny!",
	CHANGE_CHARACTER,
	"No tak, ale za to puszczam ci# wolno.",
	END_DIALOG,
};

const static char *polishDialog12[] = {
	"W dzisiejszych czasach nie mo<na wierzy^",
	NEW_LINE,
	"nawet skorumpowanym stra<nikom.",
	END_DIALOG,
};

const static char *polishDialog13[] = {
	"Siamanko.",
	CHANGE_CHARACTER,
	"Cze$^.",
	CHANGE_CHARACTER,
	"Jestem Marek. A ty jak",
	NEW_LINE,
	"masz na imi#?",
	CHANGE_CHARACTER,
	"Jak mam na imi#?",
	CHANGE_CHARACTER,
	"Nie wiem, to ty powiedz jak.",
	CHANGE_CHARACTER,
	"Jak.",
	CHANGE_CHARACTER,
	"Nie m*w \'jak\', tylko powiedz",
	NEW_LINE,
	"swoje imi#!",
	CHANGE_CHARACTER,
	"Swoje im..",
	CHANGE_CHARACTER,
	"Rany!... Jak na ciebie wo%a tata?",
	CHANGE_CHARACTER,
	"Synku.",
	CHANGE_CHARACTER,
	"No tak. A inni ludzie?",
	CHANGE_CHARACTER,
	"A inni ludzie nie.",
	CHANGE_CHARACTER,
	"A jak na ciebie wo%aj@ inni ludzie?",
	CHANGE_CHARACTER,
	"Ch%opczyku.",
	CHANGE_CHARACTER,
	"(westchnienie)",
	END_DIALOG,
};

const static char *polishDialog14[] = {
	"Sluchaj no, ma%y. Co ty pr*bujesz",
	NEW_LINE,
	"zrobi^ z t@ pi%k@?",
	CHANGE_CHARACTER,
	"No, dziadek powiedzia%, <e",
	NEW_LINE,
	"we>mie mnie do ZOO, jak",
	NEW_LINE,
	"trafi# do kosza.",
	CHANGE_CHARACTER,
	"Wydaje mi si#, <e powiniene$",
	NEW_LINE,
	"rzuca^ pi%k# troch# wy<ej.",
	CHANGE_CHARACTER,
	"Tak, wiem.",
	CHANGE_CHARACTER,
	"No wi#c?",
	CHANGE_CHARACTER,
	"No wi#c co?",
	CHANGE_CHARACTER,
	"No wi#c czemu tego nie robisz?!",
	CHANGE_CHARACTER,
	"To chyba co$ z moimi oczami.",
	CHANGE_CHARACTER,
	"Powiniene$ nosi^ okulary?",
	CHANGE_CHARACTER,
	"Nie, a dlaczego?",
	CHANGE_CHARACTER,
	"(westchnienie) A mo<e po prostu jeste$ zbyt...",
	DISPLAY_MESSAGE,
	"...s%aby, by dorzuci^ pi%k#",
	NEW_LINE,
	"wystarczaj@co wysoko?",
	CHANGE_CHARACTER,
	"Na pewno nie.",
	CHANGE_CHARACTER,
	"(westchnienie)",
	END_DIALOG,
};

const static char *polishDialog15[] = {
	"Hej, ma%y! Mam wspania%y pomys%!",
	CHANGE_CHARACTER,
	"Tak?",
	CHANGE_CHARACTER,
	"Id> do dziadka i powiedz",
	NEW_LINE,
	"mu, <e trafi%e$!",
	CHANGE_CHARACTER,
	"Mam sk%ama^?",
	CHANGE_CHARACTER,
	"No, tylko troch#...",
	CHANGE_CHARACTER,
	"NIGDY NIE K]AMI[!",
	CHANGE_CHARACTER,
	"Nigdy?!",
	CHANGE_CHARACTER,
	"NIGDY!",
	CHANGE_CHARACTER,
	"Dobre dziecko.",
	END_DIALOG,
};

const static char *polishDialog16[] = {
	"Hej...",
	CHANGE_CHARACTER,
	"Odejd>.",
	END_DIALOG,
};

const static char *polishDialog17[] = {
	"Ty, mikro! To niesamowite!",
	CHANGE_CHARACTER,
	"Co znowu?",
	CHANGE_CHARACTER,
	"Pomy$lisz, <e to <art, ale",
	NEW_LINE,
	"z jeziora wy%ania si# jaka$",
	NEW_LINE,
	"r#ka z mieczem!",
	CHANGE_CHARACTER,
	"Dobra, popatrz#, ale nie my$l ",
	NEW_LINE,
	"sobie, <e mnie nabra%e$.",
	NEW_LINE,
	"Ona pojawia si# co roku.",
	DISPLAY_MESSAGE,
	"Mo<e tym razem przyniesie",
	NEW_LINE,
	"mi szcz#$cie w koszyk*wce...",
	END_DIALOG,
};

const static char *polishDialog18[] = {
	"Dzie= dobry panu!",
	CHANGE_CHARACTER,
	"I tobie tak<e,",
	NEW_LINE,
	"m*j ch%opcze.",
	CHANGE_CHARACTER,
	"Na imi# mam Marek, prosz# pana.",
	CHANGE_CHARACTER,
	"Wspaniale. Co ci# tu sprowadza?",
	CHANGE_CHARACTER,
	"Tylko podziwiam pa=ski fotel. Fajny.",
	CHANGE_CHARACTER,
	"Fajny i ca%kiem",
	NEW_LINE,
	"komfortowy.",
	CHANGE_CHARACTER,
	"I du<y.",
	CHANGE_CHARACTER,
	"Model dwuosobowy.",
	END_DIALOG,
};

const static char *polishDialog19[] = {
	"Zna pan mo<e ch%opca",
	NEW_LINE,
	"bawi@cego si# na zewn@trz",
	NEW_LINE,
	"pi%k@?",
	CHANGE_CHARACTER,
	"Oczywi$cie, to",
	NEW_LINE,
	"m*j wnuk.",
	CHANGE_CHARACTER,
	"Fajny dzieciak.",
	CHANGE_CHARACTER,
	"Fajny i m@dry.",
	CHANGE_CHARACTER,
	"Fajny i ma%y.",
	CHANGE_CHARACTER,
	"Uro$nie.",
	CHANGE_CHARACTER,
	"I zostanie s%awnym",
	NEW_LINE,
	"graczem w kosza?...",
	CHANGE_CHARACTER,
	"Mam nadziej#, <e nie.",
	CHANGE_CHARACTER,
	"To niech mu pan powie,",
	NEW_LINE,
	"<eby przesta%!",
	CHANGE_CHARACTER,
	"P*>niej... Mo<e... Teraz musz# troch#",
	NEW_LINE,
	"odpocz@^.",
	END_DIALOG,
};

const static char *polishDialog20[] = {
	"Ma pan zamiar przesiedzie^",
	NEW_LINE,
	"tu ca%y dzie=?",
	CHANGE_CHARACTER,
	"Mam nadziej#.",
	CHANGE_CHARACTER,
	"Ca%y ten pi#kny dzionek?",
	CHANGE_CHARACTER,
	"Mam nadziej#.",
	CHANGE_CHARACTER,
	"Nie interesuje pana",
	NEW_LINE,
	"$wiat zewn#trzny?!",
	CHANGE_CHARACTER,
	"Nie za bardzo.",
	CHANGE_CHARACTER,
	"A to dlaczego?",
	CHANGE_CHARACTER,
	"Nie przepadam za",
	NEW_LINE,
	"nowo$ciami.",
	CHANGE_CHARACTER,
	"Ale...",
	CHANGE_CHARACTER,
	"Jak to m*wi@... Najlepsze wiadomo$ci",
	NEW_LINE,
	"to brak wiadomo$ci.",
	CHANGE_CHARACTER,
	"Ale ludzie musz@ wiedzie^",
	NEW_LINE,
	"o post#pie i w og*le!",
	CHANGE_CHARACTER,
	"Nawet nie b#d# si# trudzi%,",
	NEW_LINE,
	"by zapyta^ dlaczego...",
	CHANGE_CHARACTER,
	"Bo... Eeee...",
	NEW_LINE,
	"Bo... Uhm...",
	CHANGE_CHARACTER,
	"Racja.",
	END_DIALOG,
};

const static char *polishDialog21[] = {
	"Co nowego?",
	CHANGE_CHARACTER,
	"Mam nadziej#, <e nic.",
	END_DIALOG,
};

const static char *polishDialog22[] = {
	"Mog# po<yczy^ t# strzelb#?",
	CHANGE_CHARACTER,
	"Nie.",
	CHANGE_CHARACTER,
	"Proooosz#...",
	CHANGE_CHARACTER,
	"M%odzie=cze, ta bro= jest",
	NEW_LINE,
	"bardzo stara i niebezpieczna...",
	DISPLAY_MESSAGE,
	"...a ja jestem odpowiedzialnym",
	NEW_LINE,
	"cz%owiekiem, rozumiesz?",
	CHANGE_CHARACTER,
	"Ale b#d#...",
	CHANGE_CHARACTER,
	"Nie.",
	END_DIALOG,
};

const static char *polishDialog23[] = {
	"Mo<e zmieni pan jednak zdanie co",
	NEW_LINE,
	"do tej strzelby?...",
	CHANGE_CHARACTER,
	"Nie. Nope. Niet. Nein. Niente. No. Ne.",
	CHANGE_CHARACTER,
	"Dobra, rozumiem.",
	END_DIALOG,
};

const static char *polishDialog24[] = {
	"Mog# przeszuka^ sobie szuflady?",
	CHANGE_CHARACTER,
	"Tak.",
	CHANGE_CHARACTER,
	"TAK?!?",
	CHANGE_CHARACTER,
	"Och, zapomnia%em ci powiedzie^,",
	NEW_LINE,
	"<e s@ puste.",
	DISPLAY_MESSAGE,
	"Tylko w prawej g*rnej le<y chusteczka.",
	DISPLAY_MESSAGE,
	"Mo<esz sobie j@ wzi@^, nie potrzebuj# jej.",
	CHANGE_CHARACTER,
	"C*<, dzi#kuj#. Jest pan",
	NEW_LINE,
	"bardzo... uprzejmy...",
	CHANGE_CHARACTER,
	"Tylko sobie nie pomy$l, <e mo<esz",
	NEW_LINE,
	"wzi@^ cokolwiek innego.",
	CHANGE_CHARACTER,
	"Oczywi$cie, nawet o tym nie marz#.",
	END_DIALOG,
};

const static char *polishDialog25[] = {
	"Mog# po<yczy^ wiatraczek?",
	CHANGE_CHARACTER,
	"O, nie. Dzi#ki niemu jako$ znosz#",
	NEW_LINE,
	"takie dni jak ten.",
	END_DIALOG,
};

const static char *polishDialog26[] = {
	"Co do tego wiatraka...",
	CHANGE_CHARACTER,
	"Wr*^ w zimie.",
	END_DIALOG,
};

const static char *polishDialog27[] = {
	"]adn@ pogod# dzi$",
	NEW_LINE,
	"mamy...",
	CHANGE_CHARACTER,
	"W rzeczy samej,",
	NEW_LINE,
	"drogi ch%opcze.",
	END_DIALOG,
};

const static char *polishDialog28[] = {
	"Czy to pani c*rka?",
	CHANGE_CHARACTER,
	"Jeste$ bardzo mi%y,",
	NEW_LINE,
	"cukiereczku, tak",
	NEW_LINE,
	"mnie odm%adzaj@c...",
	DISPLAY_MESSAGE,
	"...ale oczywi$cie",
	NEW_LINE,
	"ta $licznotka to",
	NEW_LINE,
	"moja wnuczka.",
	CHANGE_CHARACTER,
	"O, tak! Naprawd# $licznotka!",
	CHANGE_CHARACTER,
	"C*<, i ja kiedy$",
	NEW_LINE,
	"taka by%am...",
	CHANGE_CHARACTER,
	"Wci@< pani jest!",
	CHANGE_CHARACTER,
	"To mi%o",
	NEW_LINE,
	"z twojej strony...",
	CHANGE_CHARACTER,
	"Eeee...",
	END_DIALOG,
};

const static char *polishDialog29[] = {
	"Mog# zapyta^, co pani",
	NEW_LINE,
	"robi?",
	CHANGE_CHARACTER,
	"Tak, mo<esz,",
	NEW_LINE,
	"cukiereczku.",
	CHANGE_CHARACTER,
	"\377Co pani robi?",
	CHANGE_CHARACTER,
	"Robi# na drutach.",
	CHANGE_CHARACTER,
	"Rozumiem. A co pani robi",
	NEW_LINE,
	"na drutach?",
	CHANGE_CHARACTER,
	"Tym razem nie",
	NEW_LINE,
	"zapyta%e$, czy",
	NEW_LINE,
	"mo<esz zapyta^.",
	CHANGE_CHARACTER,
	"Och, przepraszam. Mog# zapyta^?",
	CHANGE_CHARACTER,
	"Zapyta^ o co?",
	CHANGE_CHARACTER,
	"O to, co pani robi",
	NEW_LINE,
	"na drutach.",
	CHANGE_CHARACTER,
	"Ju< mnie przed chwil@",
	NEW_LINE,
	"o to pyta%e$, czy<",
	NEW_LINE,
	"nie?",
	END_DIALOG,
};

const static char *polishDialog30[] = {
	"Wszystko w porz@dku?",
	CHANGE_CHARACTER,
	"W rzeczy samej.",
	END_DIALOG,
};

const static char *polishDialog31[] = {
	"Wszystko w porz@dku?",
	CHANGE_CHARACTER,
	"Przecie< wiesz.",
	END_DIALOG,
};

const static char *polishDialog32[] = {
	"Wszystko w porz@dku?",
	CHANGE_CHARACTER,
	"Mi%o, <e pytasz,",
	NEW_LINE,
	"ale ju< ci",
	NEW_LINE,
	"odpowiedzia%am.",
	END_DIALOG,
};

const static char *polishDialog33[] = {
	"Wszystko w porz@dku?",
	CHANGE_CHARACTER,
	"Nie powtarzaj",
	NEW_LINE,
	"si#.",
	END_DIALOG,
};

const static char *polishDialog34[] = {
	"Wszystko w porz@dku?",
	CHANGE_CHARACTER,
	"Nie przeszkadzaj",
	NEW_LINE,
	"mi w pracy.",
	END_DIALOG,
};

const static char *polishDialog35[] = {
	"Wszystko w porz@dku?",
	CHANGE_CHARACTER,
	"Zamknij si#.",
	END_DIALOG,
};

const static char *polishDialog36[] = {
	"Wszystko w porz@dku?",
	END_DIALOG,
};

const static char *polishDialog37[] = {
	"Prosz# wybaczy^",
	NEW_LINE,
	"moj@ $mia%o$^...",
	CHANGE_CHARACTER,
	"Tak?...",
	CHANGE_CHARACTER,
	"...ale pomy$la%em,",
	NEW_LINE,
	"<e niewinny kwiat...",
	DISPLAY_MESSAGE,
	"...przeka<e moj@",
	NEW_LINE,
	"rado$^ z okazji",
	NEW_LINE,
	"poznania pani.",
	END_DIALOG,
};

const static char *polishDialog38[] = {
	"Mam nadziej#,",
	NEW_LINE,
	"<e si# spodoba%...",
	CHANGE_CHARACTER,
	"Och, kochanie!",
	NEW_LINE,
	"Jestem wzruszona...",
	DISPLAY_MESSAGE,
	"To najmilsza rzecz,",
	NEW_LINE,
	"jak@ ktokolwiek",
	NEW_LINE,
	"uczyni% dla mnie...",
	DISPLAY_MESSAGE,
	"...od dziesi#ciu lat!",
	DISPLAY_MESSAGE,
	"Dzi#kuj# ci",
	NEW_LINE,
	"z ca%ego serca!",
	CHANGE_CHARACTER,
	"Prosz# bardzo.",
	END_DIALOG,
};

const static char *polishDialog39[] = {
	"Chcia%aby pani jeszcze",
	NEW_LINE,
	"jeden kwiat?",
	CHANGE_CHARACTER,
	"Jeste$ bardzo mi%y,",
	NEW_LINE,
	"cukiereczku, ale nie,",
	NEW_LINE,
	"dzi#kuj#.",
	END_DIALOG,
};

const static char *polishDialog40[] = {
	"Na pewno nie chce pani",
	NEW_LINE,
	"nast#pnego kwiatka?",
	CHANGE_CHARACTER,
	"Na pewno.",
	END_DIALOG,
};

const static char *polishDialog41[] = {
	"Mog# po<yczy^ t#",
	NEW_LINE,
	"miote%k#?",
	CHANGE_CHARACTER,
	"Nie znamy si# zbyt",
	NEW_LINE,
	"dobrze, a ja z regu%y",
	NEW_LINE,
	"nie po<yczam...",
	DISPLAY_MESSAGE,
	"...rzeczy ka<demu,",
	NEW_LINE,
	"kto o to poprosi.",
	CHANGE_CHARACTER,
	"Czy ja nie wygl@dam",
	NEW_LINE,
	"odpowiedzialnie?",
	CHANGE_CHARACTER,
	"Odpowiedzia%am",
	NEW_LINE,
	"wystarczaj@co",
	NEW_LINE,
	"jasno.",
	END_DIALOG,
};

const static char *polishDialog42[] = {
	"Jakie$ szanse na po<yczenie",
	NEW_LINE,
	"zmiotki?",
	CHANGE_CHARACTER,
	"Lubi#, gdy le<y",
	NEW_LINE,
	"tam, gdzie teraz.",
	END_DIALOG,
};

const static char *polishDialog43[] = {
	"Czy teraz mog%aby pani",
	NEW_LINE,
	"po<yczy^ mi t# miote%k#?",
	CHANGE_CHARACTER,
	"Ale< naturalnie, nie",
	NEW_LINE,
	"widz# powodu, dla",
	NEW_LINE,
	"kt*rego...",
	DISPLAY_MESSAGE,
	"...nie mia%abym pom*c tak",
	NEW_LINE,
	"mi%emu m%odzie=cowi!..",
	CHANGE_CHARACTER,
	"Dzi#kuj# pani bardzo.",
	END_DIALOG,
};

const static char *polishDialog44[] = {
	"Ha! Jestem szybszy ni< Indy`!",
	CHANGE_CHARACTER,
	"Wszystko widzia%am!",
	END_DIALOG,
};

const static char *polishDialog45[] = {
	"Eee... Uh... Ja tylko...",
	CHANGE_CHARACTER,
	"Nie martw si#. Mam",
	NEW_LINE,
	"nadziej#, <e zabi%e$",
	NEW_LINE,
	"t# much#.",
	END_DIALOG,
};

const static char *polishDialog46[] = {
	"Przepraszam, ale wydaje mi si#,",
	NEW_LINE,
	"<e pani pranie ju< wysch%o...",
	DISPLAY_MESSAGE,
	"...a za du<o s%o=ca mo<e odbarwi^",
	NEW_LINE,
	"rzeczy...",
	CHANGE_CHARACTER,
	"Jakim cudem wysch%o",
	NEW_LINE,
	"tak szybko?",
	DISPLAY_MESSAGE,
	"Lepiej p*jd#",
	NEW_LINE,
	"i sprawdz#.",
	END_DIALOG,
};

const static char *polishDialog47[] = {
	CHANGE_CHARACTER,
	"Mia%e$ racj#, m%odzie=cze.",
	NEW_LINE,
	"Dzi#kuj#.",
	CHANGE_CHARACTER,
	"Prosz# bardzo.",
	END_DIALOG,
};

const static char *polishDialog48[] = {
	"Czy potrzebuje pani tego",
	NEW_LINE,
	"sztucznego jab%ka?",
	CHANGE_CHARACTER,
	"To zale<y. Ten owoc ma",
	NEW_LINE,
	"swoj@ histori#.",
	DISPLAY_MESSAGE,
	"Pami#tam, jak pewnego",
	NEW_LINE,
	"dnia moja siostra Maria",
	NEW_LINE,
	"robi%a...",
	CHANGE_CHARACTER,
	"Eee, jak d%uga jest ta opowie$^?",
	CHANGE_CHARACTER,
	"Och, nie ma si#",
	NEW_LINE,
	"gdzie spieszy^.",
	DISPLAY_MESSAGE,
	"Mamy ca%e godziny na",
	NEW_LINE,
	"pogaduszki, prawda?",
	CHANGE_CHARACTER,
	"W%a$nie zda%em sobie spraw#, <e nie",
	NEW_LINE,
	"potrzebuj# tego jab%ka.",
	NEW_LINE,
	"Dzi#ki.",
	END_DIALOG,
};

const static char *polishDialog49[] = {
	"To jab%ko...",
	CHANGE_CHARACTER,
	"Nie ma opowie$ci,",
	NEW_LINE,
	"nie ma jab%ka.",
	CHANGE_CHARACTER,
	"\377\377ie ma jab%ka.",
	END_DIALOG,
};

const static char *polishDialog50[] = {
	"\377Could she be ...the most beautiful girl...",
	NEW_LINE,
	"...in the world?...\"",
	END_DIALOG,
};

const static char *polishDialog51[] = {
	"Chyba najwy<szy czas si# przedstawi^.",
	DISPLAY_MESSAGE,
	"Jestem Marek.",
	CHANGE_CHARACTER,
	"Anna.",
	END_DIALOG,
};

const static char *polishDialog52[] = {
	"Moment, w kt*rym ujrza%em",
	NEW_LINE,
	"te oczy, by% najpi#kniejszym",
	NEW_LINE,
	"w moim <yciu.",
	DISPLAY_MESSAGE,
	"\377Nie licz@c czasu, kiedy",
	NEW_LINE,
	"bawi%em si# z Edytk@",
	NEW_LINE,
	"w doktora.",
	END_DIALOG,
};

const static char *polishDialog53[] = {
	"Uh... Eee...",
	NEW_LINE,
	"Zastanawiam si#...",
	DISPLAY_MESSAGE,
	"Zastanawiam si#, czy",
	NEW_LINE,
	"nie zechcia%aby$",
	NEW_LINE,
	"przyj@^...",
	DISPLAY_MESSAGE,
	"Ee... Znaczy...",
	DISPLAY_MESSAGE,
	"Mam co$, co chcia%bym",
	NEW_LINE,
	"ci da^, poniewa<, eee...",
	NEW_LINE,
	"...poniewa<...",
	DISPLAY_MESSAGE,
	"Eh... My$l#, <e jeste$... No i...",
	CHANGE_CHARACTER,
	"Hej! Ja nie gryz#!",
	DISPLAY_MESSAGE,
	"Widz#, <e chcesz powiedzie^",
	NEW_LINE,
	"mi co$ mi%ego.",
	DISPLAY_MESSAGE,
	"Po prostu u<yj",
	NEW_LINE,
	"najprostszych s%*w...",
	CHANGE_CHARACTER,
	"Najprostszych s%*w?!",
	CHANGE_CHARACTER,
	"Tak, proste s%owa czyni@",
	NEW_LINE,
	"rzeczy prostymi.",
	CHANGE_CHARACTER,
	"Och, tak. Okej. Proste s%owa.",
	NEW_LINE,
	"Okej. Uwaga:...",
	DISPLAY_MESSAGE,
	"Ja lubi^ twoja",
	NEW_LINE,
	"i chcie^ da^ kwiat.",
	CHANGE_CHARACTER,
	"\377C*<, mo<e jednak powiniene$",
	NEW_LINE,
	"wyra<a^ si# bardziej...",
	DISPLAY_MESSAGE,
	"...skomplikowanie.",
	CHANGE_CHARACTER,
	"Uh... Sorry...",
	NEW_LINE,
	"Ja po prostu...",
	DISPLAY_MESSAGE,
	"Po prostu przynios%em",
	NEW_LINE,
	"ci kwiatek.",
	CHANGE_CHARACTER,
	"Och?...",
	END_DIALOG,
};

const static char *polishDialog54[] = {
	"Podoba ci si#?",
	CHANGE_CHARACTER,
	"Jeste$ czaruj@cy.",
	END_DIALOG,
};

const static char *polishDialog55[] = {
	"Reasumuj@c fakty...",
	CHANGE_CHARACTER,
	"Proste s%owa,",
	NEW_LINE,
	"ch%opcze!",
	NEW_LINE,
	"Proste s%owa!",
	END_DIALOG,
};

const static char *polishDialog56[] = {
	"Ah, tak... Chcia%em tylko doda^,",
	NEW_LINE,
	"<e i ty jeste$ czaruj@ca.",
	CHANGE_CHARACTER,
	"Chyba powinnam",
	NEW_LINE,
	"powiedzie^ dzi#kuj#.",
	END_DIALOG,
};

const static char *polishDialog57[] = {
	"Nienawidz# si#.",
	END_DIALOG,
};

const static char *polishDialog58[] = {
	"Mam jeszcze jeden",
	NEW_LINE,
	"kwiat...",
	CHANGE_CHARACTER,
	"Nie przesadzajmy.",
	DISPLAY_MESSAGE,
	"Jak %atwo zauwa<y^, nie",
	NEW_LINE,
	"jestem jedyn@...",
	DISPLAY_MESSAGE,
	"...kobiet@ w tym pokoju...",
	END_DIALOG,
};

const static char *polishDialog59[] = {
	"Wi#c nie chcesz jeszcze",
	NEW_LINE,
	"jednego kwiatka?",
	CHANGE_CHARACTER,
	"Nie, dzi#kuj#.",
	END_DIALOG,
};

const static char *polishDialog60[] = {
	"Mo<e ciasteczko?",
	CHANGE_CHARACTER,
	"Raczej nie, dzi#kuj#.",
	NEW_LINE,
	"Nie chc# uty^.",
	CHANGE_CHARACTER,
	"Tam zaraz uty^. Nawet",
	NEW_LINE,
	"Obelix ma przyjaci*%.",
	CHANGE_CHARACTER,
	"A kto to Obelix?!",
	CHANGE_CHARACTER,
	"Ee, niewa<ne. Po prostu mam",
	NEW_LINE,
	"tu ciastko, kt*re znalaz%em...",
	CHANGE_CHARACTER,
	"ZNALAZ]E|?!",
	CHANGE_CHARACTER,
	"...znalaz%em w pewnym",
	NEW_LINE,
	"sklepie, oczywi$cie.",
	DISPLAY_MESSAGE,
	"D%ugo szuka%em. To nie jaki$ wyr*b...",
	DISPLAY_MESSAGE,
	"...czekoladopodobny, ale sama...",
	DISPLAY_MESSAGE,
	"...esencja s%odko$ci! Luksus!",
	DISPLAY_MESSAGE,
	"Naturalne sk%adniki.",
	DISPLAY_MESSAGE,
	"Bez konserwant*w.",
	CHANGE_CHARACTER,
	"No dobra, skoro nalegasz...",
	END_DIALOG,
};

const static char *polishDialog61[] = {
	"\377Khm...",
	CHANGE_CHARACTER,
	"Och tak, chyba powinnam da^",
	NEW_LINE,
	"ci co$ w zamian...",
	CHANGE_CHARACTER,
	"Och, nie... Nie musisz, naprawd#...",
	CHANGE_CHARACTER,
	"Dobra. Jak chcesz.",
	CHANGE_CHARACTER,
	"\377Chocia< z drugiej strony...",
	CHANGE_CHARACTER,
	"Wiedzia%am. Wy ch%opcy zawsze",
	NEW_LINE,
	"czego$ chcecie.",
	DISPLAY_MESSAGE,
	"Nie mo<ecie zrobi^ niczego",
	NEW_LINE,
	"za darmo.",
	CHANGE_CHARACTER,
	"Kiedy$ posprz@ta%em pok*j.",
	DISPLAY_MESSAGE,
	"\377C*<... Zapomnijmy",
	NEW_LINE,
	"o tym.",
	CHANGE_CHARACTER,
	"Oto m*j prezent dla",
	NEW_LINE,
	"ciebie.",
	DISPLAY_MESSAGE,
	"To moja wst@<ka. Pomy$l",
	NEW_LINE,
	"o mnie czasami.",
	END_DIALOG,
};

const static char *polishDialog62[] = {
	"Dzi#ki. Nigdy jej nie",
	NEW_LINE,
	"wypior#.",
	END_DIALOG,
};

const static char *polishDialog63[] = {
	"Znalaz%em do$^ interesuj@c@ notk#...",
	DISPLAY_MESSAGE,
	"...na pewnym banknocie. Wiesz mo<e",
	NEW_LINE,
	"co$ na ten temat?",
	CHANGE_CHARACTER,
	"Poka< mi banknot.",
	END_DIALOG,
};

const static char *polishDialog64[] = {
	"Hej, co jest?!",
	CHANGE_CHARACTER,
	"O, ja nieszcz#$liwa!...",
	CHANGE_CHARACTER,
	"Dlaczego p%aczesz?!",
	CHANGE_CHARACTER,
	"O, ja nieszcz#sna!...",
	DISPLAY_MESSAGE,
	"Nasz... nasz s@siad, pan...",
	DISPLAY_MESSAGE,
	"...Ci@gwa, da% mi wczoraj...",
	DISPLAY_MESSAGE,
	"...troch# pieni#dzy...",
	DISPLAY_MESSAGE,
	"...i powiedzia%, <e jak",
	NEW_LINE,
	"dam mu buziaka to da...",
	DISPLAY_MESSAGE,
	"...mi wi#cej...",
	DISPLAY_MESSAGE,
	"...ale przemy$la%am to",
	NEW_LINE,
	"i odda%am mu ca%@...",
	DISPLAY_MESSAGE,
	"...kwot# z powrotem.",
	CHANGE_CHARACTER,
	"To znaczy, ta $winia",
	NEW_LINE,
	"pr*bowa%a ci# kupi^?!",
	CHANGE_CHARACTER,
	"Jestem taka nieszcz#$liwa!",
	CHANGE_CHARACTER,
	"O, ludzie! Mam",
	NEW_LINE,
	"tego do$^!",
	END_DIALOG,
};

const static char *polishDialog65[] = {
	"Hej, ty! Mo<esz mi z %aski swojej",
	NEW_LINE,
	"poda^ ten orzech le<@cy obok?",
	END_DIALOG,
};

const static char *polishDialog66[] = {
	"Dasz mi ten orzech czy nie?!",
	END_DIALOG,
};

const static char *polishDialog67[] = {
	"W porz@chu. Wystarczy.",
	DISPLAY_MESSAGE,
	"Teraz dostaniesz, na co zas%u<y%a$.",
	DISPLAY_MESSAGE,
	"B#d# ci# wyzywa% tak d%ugo,",
	NEW_LINE,
	"a< dasz mi ten orzech.",
	DISPLAY_MESSAGE,
	"Ty brzydka wiewi*rko ty.",
	END_DIALOG,
};

const static char *polishDialog68[] = {
	"Nie wiesz, <e to noszenie futra nie",
	NEW_LINE,
	"jest politycznie poprawne?",
	END_DIALOG,
};

const static char *polishDialog69[] = {
	"Hej, raz jeszcze dzi#ki za orzech.",
	END_DIALOG,
};

const static char *polishDialog70[] = {
	"Nie zapyta%em, czy mog# j@ wzi@^.",
	DISPLAY_MESSAGE,
	"To naprawd# niegrzeczne bra^ czyj@$",
	NEW_LINE,
	"w%asno$^ bez pozwolenia.",
	DISPLAY_MESSAGE,
	"No i mog@ mnie z%apa^, oczywi$cie.",
	DISPLAY_MESSAGE,
	"I wsadz@ mnie do wi#zienia i nikt",
	NEW_LINE,
	"ju< nie b#dzie mnie szanowa%.",
	DISPLAY_MESSAGE,
	"Naprawd# mog# zmarnowa^ sobie <ycie.",
	END_DIALOG,
};

const static char *polishDialog71[] = {
	"Bez pracy nie ma ko%aczy.",
	END_DIALOG,
};

const static char *polishDialog72[] = {
	"S%uchajcie, wrony. Macie st@d",
	NEW_LINE,
	"spada^, ale ju<!",
	DISPLAY_MESSAGE,
	"Albo b#d# strzela%.",
	DISPLAY_MESSAGE,
	"Z prawdziwej broni.",
	DISPLAY_MESSAGE,
	"Zdaje si#.",
	END_DIALOG,
};

const static char *polishDialog73[] = {
	"Widz# ...<e jest tu... PAJ+K!!!",
	END_DIALOG,
};

const static char *polishDialog74[] = {
	"Nie to, <ebym stch*rzy%.",
	DISPLAY_MESSAGE,
	"Po prostu to m*g% by^",
	NEW_LINE,
	"zmutowany paj@k i m*g%by",
	NEW_LINE,
	"mnie ugry>^...",
	DISPLAY_MESSAGE,
	"...i ja te< zosta%bym mutantem...",
	DISPLAY_MESSAGE,
	"...i nosi%bym takie $mieszne",
	NEW_LINE,
	"r#kawice i w og*le...",
	DISPLAY_MESSAGE,
	"...i mia%bym podw*jne <ycie...",
	DISPLAY_MESSAGE,
	"...i musia%bym walczy^ z Venomem`",
	DISPLAY_MESSAGE,
	"i innymi i m*g%bym zosta^ ranny...",
	DISPLAY_MESSAGE,
	"...i ka<dy robi%by na tym fors#",
	NEW_LINE,
	"opr*cz mnie...",
	DISPLAY_MESSAGE,
	"Wi#c chyba sobie odpuszcz#.",
	END_DIALOG,
};

const static char *polishDialog75[] = {
	"Ten paj@k przyprawia mnie o ciarki...",
	END_DIALOG,
};

const static char *polishDialog76[] = {
	"Hej, ma%y kolego!",
	DISPLAY_MESSAGE,
	"Mam dla ciebie MORALN+ PROPOZYCJ[.",
	DISPLAY_MESSAGE,
	"Du<e, $wie<e i soczyste jab%ko za t@ star@",
	NEW_LINE,
	"szyszk#, co ci uciska plecy.",
	DISPLAY_MESSAGE,
	"Jak masz ochot# na wymian#, to sta=",
	NEW_LINE,
	"tutaj i potrz@$nij pyszczkiem.",
	END_DIALOG,
};

const static char *polishDialog77[] = {
	"Powinieniem wiedzie^,",
	NEW_LINE,
	"ze gdzie$ tkwi haczyk.",
	DISPLAY_MESSAGE,
	"\377Wios%o jest z%amane.",
	END_DIALOG,
};

const static char *polishDialog78[] = {
	"Cze$^, facet.",
	END_DIALOG,
};

const static char *polishDialog79[] = {
	"Nie ignoruj mnie, prosz#.",
	END_DIALOG,
};

const static char *polishDialog80[] = {
	"Pieskie <ycie, co?",
	END_DIALOG,
};

const static char *polishDialog81[] = {
	"Co s%ycha^?",
	END_DIALOG,
};

const static char *polishDialog82[] = {
	"Tak, m*g%bym j@ wzi@^...",
	DISPLAY_MESSAGE,
	"To cicha ma%a wioska...",
	DISPLAY_MESSAGE,
	"Bez policji...",
	DISPLAY_MESSAGE,
	"Nikt nie us%ysza%by ich krzyk*w...",
	DISPLAY_MESSAGE,
	"\377Ale nie mam hokejowej maski.",
	DISPLAY_MESSAGE,
	"\377(westchnienie)",
	END_DIALOG,
};

const static char *polishDialog83[] = {
	"Nie chc# zostawi^ na niej swoich",
	NEW_LINE,
	"odcisk*w palc*w.",
	DISPLAY_MESSAGE,
	"Kto wie, do czego by%a u<ywana.",
	END_DIALOG,
};

const static char *polishDialog84[] = {
	"Obawiam si#, <e troch# za trudno",
	NEW_LINE,
	"z%apa^ sobie mysz ot tak, po",
	NEW_LINE,
	"prostu.",
	DISPLAY_MESSAGE,
	"I co to by%oby za wyzwanie?",
	END_DIALOG,
};

const static char *polishDialog85[] = {
	"M*g%bym spr*bow^ odstraszy^ te ptaki",
	NEW_LINE,
	"samemu, gdybym nie ogl@da% tego filmu...",
	DISPLAY_MESSAGE,
	"...Hitchcocka, kiedy mia%em 5 lat.",
	DISPLAY_MESSAGE,
	"Moja mama nie powinna by%a mi pozwoli^.",
	DISPLAY_MESSAGE,
	"Teraz znosz# jajo nawet gdy widz# go%#bie.",
	END_DIALOG,
};

const static char *polishDialog86[] = {
	"\"Z%oto oczekuje na ko=cu drogi.\"",
	END_DIALOG,
};

const static char *polishDialog87[] = {
	"Czy to pan jest Ci@gwa?",
	CHANGE_CHARACTER,
	"Jak si# masz, m*j przyjacielu.",
	DISPLAY_MESSAGE,
	"Moi ludzie twierdz@, <e",
	NEW_LINE,
	"pr*bujesz wedrze^ si# do",
	NEW_LINE,
	"mojej posiad%o$ci.",
	DISPLAY_MESSAGE,
	"Dlaczego?",
	CHANGE_CHARACTER,
	"Eee... Widzi pan...",
	DISPLAY_MESSAGE,
	"Jestem tu...",
	NEW_LINE,
	"Tu...",
	DISPLAY_MESSAGE,
	"Znaczy, jestem tu na wakacjach,",
	NEW_LINE,
	"ale zrobi%o mi si# niedobrze od...",
	DISPLAY_MESSAGE,
	"...wszystkich tych zielono$ci...",
	DISPLAY_MESSAGE,
	"...i po prostu chcia%em lizn@^",
	NEW_LINE,
	"troch# cywilizacji.",
	CHANGE_CHARACTER,
	"C*<... Dobrze ci# rozumiem,",
	NEW_LINE,
	"przyjacielu.",
	DISPLAY_MESSAGE,
	"Ja tak<e s@dz#, <e naturalne",
	NEW_LINE,
	"$rodowisko dla nas, ludzi...",
	DISPLAY_MESSAGE,
	"...dwudziestego wieku...",
	DISPLAY_MESSAGE,
	"..to telewizor i paczka snack*w.",
	NEW_LINE,
	"Ale m*wi@c o rzeczach zielonych...",
	DISPLAY_MESSAGE,
	"Nie mog# zezwoli^ ci na",
	NEW_LINE,
	"wej$cie do mego domu, bo... uh...",
	DISPLAY_MESSAGE,
	"...poniewa< jest...w%a$nie...",
	DISPLAY_MESSAGE,
	"...w remocie. Ale jako cz%owiek",
	NEW_LINE,
	"maj#tny dam ci sto dolc*w...",
	DISPLAY_MESSAGE,
	"...aby$ m*g% sobie kupi^ co$, co",
	NEW_LINE,
	"pomo<e ci tutaj prze<y^.",
	DISPLAY_MESSAGE,
	"Na przyk%ad walkmana.",
	NEW_LINE,
	"Co ty na to?",
	CHANGE_CHARACTER,
	"Za kogo pan mnie ma?!",
	END_DIALOG,
};

const static char *polishDialog88[] = {
	"NIGDY tego nie wezm#! NIGDY!",
	CHANGE_CHARACTER,
	"Nie podniecaj si# tak. Pecunia non olet.",
	DISPLAY_MESSAGE,
	"Teraz musz# ju< i$^. Nie b@d>",
	NEW_LINE,
	"wstydkiem i podnie$ banknot.",
	DISPLAY_MESSAGE,
	"Nikogo to nie wzburzy...",
	DISPLAY_MESSAGE,
	"Do widzenia, przyjacielu.",
	END_DIALOG,
};

const static char *polishDialog89[] = {
	"Nie mog# uwierzy^, <e mnie tak",
	NEW_LINE,
	"potraktowa%.",
	DISPLAY_MESSAGE,
	"Przy okazji...",
	DISPLAY_MESSAGE,
	"\377Pekunia nie omlet?...",
	END_DIALOG,
};

const static char *polishDialog90[] = {
	"Rany... Jest ca%a czarna ...i wygl@da jak facet...",
	DISPLAY_MESSAGE,
	"...z jak@$ d%ug@ lask@ ...i garnkiem na g%owie...",
	DISPLAY_MESSAGE,
	"\377Go$^ od grafiki powinien mniej pi^.",
	END_DIALOG,
};

const static char *polishDialog91[] = {
	"Znowu szperanko w $mietnikach?",
	DISPLAY_MESSAGE,
	"\377No dobra, na szcz#$cie s@ tu tylko",
	NEW_LINE,
	"jakie$ papiery.",
	END_DIALOG,
};

const static char *polishDialog92[] = {
	"To samo, co zwykle...",
	DISPLAY_MESSAGE,
	"Katastrofy...",
	DISPLAY_MESSAGE,
	"Korupcja...",
	DISPLAY_MESSAGE,
	"Morderstwa...",
	DISPLAY_MESSAGE,
	"Krzy<*wki...",
	DISPLAY_MESSAGE,
	"Rozebrane panienki...",
	DISPLAY_MESSAGE,
	"\377Musz# zaprenumerowa^.",
	END_DIALOG,
};

const static char *polishDialog93[] = {
	"\377S%odki Jezu...",
	CHANGE_CHARACTER,
	"...Sz%aaaaa dzieweczka...",
	DISPLAY_MESSAGE,
	"...doooo laseczka...",
	CHANGE_CHARACTER,
	"To Ci@gwa...",
	CHANGE_CHARACTER,
	"...dooo zielooooonego!...",
	CHANGE_CHARACTER,
	"...$piewaj@cy do kamery!",
	CHANGE_CHARACTER,
	"...doooo zielooonegooooooo!...",
	CHANGE_CHARACTER,
	"Chocia< stanowczo nie powinien.",
	CHANGE_CHARACTER,
	"...ho-ho-hooo...",
	CHANGE_CHARACTER,
	"Nie mog# w to uwierzy^.",
	CHANGE_CHARACTER,
	"...my$liweeeeeczka...",
	CHANGE_CHARACTER,
	"Co za horror.",
	CHANGE_CHARACTER,
	"...baaaaardzo $waaarnegooooo...",
	CHANGE_CHARACTER,
	"Pies mojego s@siada robi to lepiej.",
	CHANGE_CHARACTER,
	"...baaaaardzoooo...",
	CHANGE_CHARACTER,
	"Mam dosy^.",
	CHANGE_CHARACTER,
	"...ho-ho-hoooooooo!....",
	END_DIALOG,
};

const static char *polishDialog94[] = {
	"Nie ma tu nic intere...",
	DISPLAY_MESSAGE,
	"Nie, zaraz...",
	DISPLAY_MESSAGE,
	"Co$ jest pod spodem!",
	END_DIALOG,
};

const static char *polishDialog95[] = {
	"Nie wydaje si# panu,",
	NEW_LINE,
	"<e powinien doda^",
	NEW_LINE,
	">d>iebko chilli?",
	CHANGE_CHARACTER,
	"Doda^? Dlaczego?",
	CHANGE_CHARACTER,
	"Wci@< pan pr*buje swoj@",
	NEW_LINE,
	"potraw#. Co$ jest nie",
	NEW_LINE,
	"tak.",
	DISPLAY_MESSAGE,
	"Mo<e powinien pan j@",
	NEW_LINE,
	"ma%e conieco zaostrzy^?",
	CHANGE_CHARACTER,
	"No c*<... To chyba dobry pomys%.",
	NEW_LINE,
	"Na szcz#$cie mam tu co$.",
	END_DIALOG,
};

const static char *polishDialog96[] = {
	CHANGE_CHARACTER,
	"To... hik!... To chillllllii ...musia%o",
	NEW_LINE,
	"by^ ...sfermentowane...",
	DISPLAY_MESSAGE,
	"Zupka si# schrzani%a iiiiii...",
	DISPLAY_MESSAGE,
	"...jestem zwolniony! Hik!",
	END_DIALOG,
};

const static char *polishDialog97[] = {
	"Radia nie potrzebuj#, ale",
	NEW_LINE,
	"mog# potrzebowa^ baterii.",
	DISPLAY_MESSAGE,
	"Pechowo nie mam poj#cia, jak",
	NEW_LINE,
	"si# otwiera te japo=skie",
	NEW_LINE,
	"cude=ka.",
	END_DIALOG,
};

const static char *polishDialog98[] = {
	CHANGE_CHARACTER,
	"Test bezpiecze=stwa: g%os, zapach, wygl@d.",
	DISPLAY_MESSAGE,
	"G%os rozpoznany pozytywnie.",
	DISPLAY_MESSAGE,
	"\377Fajny kawa%ek, cz%owieku.",
	END_DIALOG,
};

const static char *polishDialog99[] = {
	CHANGE_CHARACTER,
	"Test bezpiecze=stwa: g%os, zapach, wygl@d.",
	DISPLAY_MESSAGE,
	"Zapach rozpoznany pozytywnie.",
	DISPLAY_MESSAGE,
	"\377Ja te< nie lubi# wody, brachu.",
	END_DIALOG,
};

const static char *polishDialog100[] = {
	CHANGE_CHARACTER,
	"Test bezpiecze=stwa: g%os, zapach, wygl@d.",
	DISPLAY_MESSAGE,
	"Wygl@d rozpoznany pozytywnie.",
	DISPLAY_MESSAGE,
	"\377Nast#pnym razem sta= troch# bli<ej.",
	END_DIALOG,
};

const static char *polishDialog101[] = {
	"Mog# rozmawia^ z...",
	CHANGE_CHARACTER,
	"Odejd>.",
	DISPLAY_MESSAGE,
	"Jestem zaj#ty. Praca. Obiad zaraz.",
	NEW_LINE,
	"Si# spiesz#.",
	CHANGE_CHARACTER,
	"Aye, kapitanie.",
	END_DIALOG,
};

const static char *polishDialog102[] = {
	"Ale mo<e...",
	CHANGE_CHARACTER,
	"TERAZ ...JESTEM ...ZAJ[TY.",
	NEW_LINE,
	"NIE ...PRZESZKADZAJ ...MI.",
	NEW_LINE,
	"DOBRZE?",
	CHANGE_CHARACTER,
	"Okej, okej.",
	END_DIALOG,
};

const static char *polishDialog103[] = {
	"Ostatnio chcia%em...",
	CHANGE_CHARACTER,
	"ZAJ[TY. Z jak Zuzanna.",
	NEW_LINE,
	"A jak Artur.",
	NEW_LINE,
	"J jak Jadwiga.",
	DISPLAY_MESSAGE,
	"[ jak Eugeniusz.",
	NEW_LINE,
	"T jak Tomasz.",
	DISPLAY_MESSAGE,
	"Y jak...",
	NEW_LINE,
	"...jak...",
	CHANGE_CHARACTER,
	"Yeti?",
	CHANGE_CHARACTER,
	"Nie. Jak...",
	CHANGE_CHARACTER,
	"Yabbadabbadoo?",
	CHANGE_CHARACTER,
	"Nie, nie, nie. Jak...",
	CHANGE_CHARACTER,
	"Yoko?",
	CHANGE_CHARACTER,
	"Yoko. A teraz zostaw mnie w spokoju,",
	NEW_LINE,
	"PROSZ[!",
	CHANGE_CHARACTER,
	"Dobra ju<, dobra.",
	END_DIALOG,
};

const static char *polishDialog104[] = {
	"Ee...",
	CHANGE_CHARACTER,
	"Wrrrr...",
	END_DIALOG,
};

const static char *polishDialog105[] = {
	"Dzie= dobry, panie robocie.",
	CHANGE_CHARACTER,
	"Siamanko, cz%owieku,",
	NEW_LINE,
	"kumasz czacz#?",
	DISPLAY_MESSAGE,
	"M*w mi Czesiek, ju no% %ot",
	NEW_LINE,
	"ajm sejin?",
	CHANGE_CHARACTER,
	"Eee... Jeste$ pewien, <e wszystko",
	NEW_LINE,
	"w porz@dku z twoim ...programem?...",
	CHANGE_CHARACTER,
	"Masz jaki$ problem, cz%owieku?!",
	DISPLAY_MESSAGE,
	"Sie nie widzia%o nigdy rapuj@cego",
	NEW_LINE,
	"robo-sejfu, frajerze?",
	CHANGE_CHARACTER,
	"W%a$ciwie to nigdy.",
	CHANGE_CHARACTER,
	"Jestem n*wka, brachu.",
	NEW_LINE,
	"Gor@cy towar, jarzysz?",
	DISPLAY_MESSAGE,
	"M*zgole m*wi@, co roboty maj@",
	NEW_LINE,
	"by^ dla ka<dego, kumasz czacz#?",
	DISPLAY_MESSAGE,
	"Dali mi ludzk@ osobowo$^...",
	DISPLAY_MESSAGE,
	"...ju no% %ot aj min?",
	DISPLAY_MESSAGE,
	"Miodzio, no nie?",
	CHANGE_CHARACTER,
	"Khm... Tak, wspaniale.",
	NEW_LINE,
	"Znaczy, jeste$ rodzajem sejfu?",
	CHANGE_CHARACTER,
	"Racja, cz%owieku.",
	DISPLAY_MESSAGE,
	"Totalnie pewny, kumasz czacz#?",
	DISPLAY_MESSAGE,
	"Jak chcesz, cobym si# otworzy%,",
	NEW_LINE,
	"musisz udowodni^, <e$ w%a$ciciel.",
	DISPLAY_MESSAGE,
	"A teraz czek dis (OCENZUROWANE) a%t:",
	NEW_LINE,
	"Mog# os@dzi^, czy$ w%a$ciwy go$^...",
	DISPLAY_MESSAGE,
	"...po trzech rzeczach:",
	DISPLAY_MESSAGE,
	"\377..wygl@dzie, zapachu i g%osie.",
	NEW_LINE,
	"Ju no% %ot ajm sejin?",
	CHANGE_CHARACTER,
	"\377 nie otworzy%by$ ...si#...",
	NEW_LINE,
	"na chwil#, tylko <ebym zobaczy%...",
	DISPLAY_MESSAGE,
	"...co masz w $rodku?",
	CHANGE_CHARACTER,
	"Sorry, brachu.",
	DISPLAY_MESSAGE,
	"Nie wygl@dasz jak w%a$ciciel...",
	DISPLAY_MESSAGE,
	"...nie capisz, jak on...",
	DISPLAY_MESSAGE,
	"...i g%osik te< nie ten.",
	DISPLAY_MESSAGE,
	"Teraz (OCENZUROWANE), kumasz czacz#?",
	END_DIALOG,
};

const static char *polishDialog106[] = {
	"Sezamie, otw*rz si#.",
	CHANGE_CHARACTER,
	"(OCENZUROWANE), ty (OCENZUROWANE).",
	END_DIALOG,
};

const static char *polishDialog107[] = {
	"Cze$^!",
	CHANGE_CHARACTER,
	"(OSTRZE}ENIE DLA RODZIC{W: WULGARNE TEKSTY)",
	END_DIALOG,
};

const static char *polishDialog108[] = {
	"M*wi# ci, to co$ niesamowitego.",
	CHANGE_CHARACTER,
	"Pami#tam, jak zabi%e$ mojego",
	NEW_LINE,
	"s%u<@cego testuj@c kulo-odporny",
	NEW_LINE,
	"szalik.",
	CHANGE_CHARACTER,
	"To by%o dawno temu...",
	CHANGE_CHARACTER,
	"Albo jak zrobi%e$ rapuj@cy",
	NEW_LINE,
	"robo-sejf, kt*ry psuje si#",
	NEW_LINE,
	"$rednio co dwa dni.",
	CHANGE_CHARACTER,
	"Masz uprzedzenia...",
	CHANGE_CHARACTER,
	"Albo jak sprzeda%e$",
	NEW_LINE,
	"mi recept# na %amanie",
	NEW_LINE,
	"dziewcz#cych serc.",
	CHANGE_CHARACTER,
	"Forsa nie dzia%a?",
	CHANGE_CHARACTER,
	"Nie.",
	CHANGE_CHARACTER,
	"Dziwne. Zwykle dzia%a.",
	CHANGE_CHARACTER,
	"Albo jak...",
	CHANGE_CHARACTER,
	"DOBRZE JU}, DOBRZE!",
	DISPLAY_MESSAGE,
	"Zapomnijmy o tym!",
	DISPLAY_MESSAGE,
	"M*j nowy wynalazek sprawdzi%em",
	NEW_LINE,
	"ju< na sobie samym!",
	CHANGE_CHARACTER,
	"Powa<nie?",
	CHANGE_CHARACTER,
	"Powa<nie. Mog# zademonstrowa^.",
	CHANGE_CHARACTER,
	"\377Dobra, zaryzykuj#.",
	END_DIALOG,
};

const static char *polishDialog109[] = {
	"\377Cudownie. Super zamieniacz w gnoma.",
	CHANGE_CHARACTER,
	"Khm, to tylko efekt uboczny.",
	DISPLAY_MESSAGE,
	"Czasami nie kontroluj# swoich",
	NEW_LINE,
	"wynalazk*w.",
	DISPLAY_MESSAGE,
	"Ale nie b*j si#, to trwa tylko",
	NEW_LINE,
	"sekundk#.",
	CHANGE_CHARACTER,
	"No my$l#.",
	END_DIALOG,
};

const static char *polishDialog110[] = {
	"I ju< jestem. Czy zauwa<y%e$ jakie$ inne",
	NEW_LINE,
	"niezwyk%e rzeczy?",
	CHANGE_CHARACTER,
	"Nie.",
	CHANGE_CHARACTER,
	"Wspaniale! Wi#c pigu%ki wci@<",
	NEW_LINE,
	"dzia%aj@!",
	CHANGE_CHARACTER,
	"Taaak?",
	CHANGE_CHARACTER,
	"Tak! Sprawd> sw*j portfel!",
	CHANGE_CHARACTER,
	"M*j porftel jest wci@<...",
	END_DIALOG,
};

const static char *polishDialog111[] = {
	"Gdzie jest portfel?!",
	NEW_LINE,
	"Ty z%odzieju! Oddaj go!",
	CHANGE_CHARACTER,
	"Spokojnie, oto tw*j portfel.",
	END_DIALOG,
};

const static char *polishDialog112[] = {
	"}@dam wyja$nie=.",
	CHANGE_CHARACTER,
	"Ha! To najlepsza rzecz, jak@",
	NEW_LINE,
	"kiedykolwiek wynalaz%em!",
	CHANGE_CHARACTER,
	"Co to jest?",
	CHANGE_CHARACTER,
	"Nie widzia%e$, jak kradn# ci",
	NEW_LINE,
	"portfel,",
	DISPLAY_MESSAGE,
	"...poniewa< zjad%em...",
	NEW_LINE,
	"PIGU]K[ CZASU!",
	CHANGE_CHARACTER,
	"\377Pigu%k# czasu?",
	CHANGE_CHARACTER,
	"Tak! Ka<dy, kto j@ zje, <yje",
	NEW_LINE,
	"1000 razy szybciej ni<...",
	DISPLAY_MESSAGE,
	"...reszta $wiata!",
	CHANGE_CHARACTER,
	"To oznacza...",
	CHANGE_CHARACTER,
	"To oznacza, <e $wiat dla",
	NEW_LINE,
	"tej osoby rusza si# 1000",
	NEW_LINE,
	"razy wolniej!",
	DISPLAY_MESSAGE,
	"Chocia<, niestety, tylko",
	NEW_LINE,
	"przez kilka sekund...",
	CHANGE_CHARACTER,
	"C*<... To interesuj@ce.",
	NEW_LINE,
	"Ale jaki z tego po<ytek?",
	CHANGE_CHARACTER,
	"Nie dbam o to. Wymy$l co$.",
	DISPLAY_MESSAGE,
	"M*g%by$, dla przyk%adu, wchodzi^",
	NEW_LINE,
	"do kina bez biletu, i nikt by...",
	DISPLAY_MESSAGE,
	"...tego nie zauwa<y%.",
	CHANGE_CHARACTER,
	"Oczywi$cie! Wspaniale!",
	NEW_LINE,
	"Kupuj# patent!",
	CHANGE_CHARACTER,
	"To w%a$nie jest problem...",
	DISPLAY_MESSAGE,
	"Jak mo<e pami#tasz, m*j wuj Gallagher",
	NEW_LINE,
	"dokonywa% najlepszych wynalazk*w,",
	DISPLAY_MESSAGE,
	"kiedy by%... powiedzmy...",
	CHANGE_CHARACTER,
	"...pijany...",
	CHANGE_CHARACTER,
	"...zatruty.",
	DISPLAY_MESSAGE,
	"I to samo przydarzy%o si# mnie.",
	NEW_LINE,
	"(westchnienie).",
	DISPLAY_MESSAGE,
	"Tak wi#c ostatniej nocy obudzi%em",
	NEW_LINE,
	"si# z potwornym b*lem g%owy...",
	DISPLAY_MESSAGE,
	"...i z pigu%kami na stole.",
	DISPLAY_MESSAGE,
	"Nie pami#tam, jak je zrobi%em.",
	CHANGE_CHARACTER,
	"Och nie!",
	CHANGE_CHARACTER,
	"Ale mog# nad nimi popracowa^.",
	DISPLAY_MESSAGE,
	"Do tego potrzebuj# twoich pieni#dzy.",
	NEW_LINE,
	"Zawrzyjmy umow#.",
	DISPLAY_MESSAGE,
	"Ty sponsorujesz badania,",
	NEW_LINE,
	"budujesz laboratorium",
	NEW_LINE,
	"i w og*le...",
	DISPLAY_MESSAGE,
	"...a ja ci daj# swoje prawa.",
	CHANGE_CHARACTER,
	"Dasz mi patent?!",
	CHANGE_CHARACTER,
	"Tak. Wszystko, na czym mi zale<y, to",
	NEW_LINE,
	"szacunek $rodowiska naukowego.",
	DISPLAY_MESSAGE,
	"I Nobel.",
	DISPLAY_MESSAGE,
	"No wiesz, honoris causa tu",
	NEW_LINE,
	"i tam, wywiady...",
	CHANGE_CHARACTER,
	"Zgoda. Umowa stoi.",
	DISPLAY_MESSAGE,
	"Przygotuj list# potrzebnego",
	NEW_LINE,
	"wyposa<enia.",
	CHANGE_CHARACTER,
	"Znakomicie.",
	END_DIALOG,
};

const static char *polishDialog113[] = {
	"Ten g%upiec mi ufa.",
	DISPLAY_MESSAGE,
	"Ale wykorzystam go...",
	DISPLAY_MESSAGE,
	"Pigu%ki czasu...",
	DISPLAY_MESSAGE,
	"Nie b#d# ich sprzedawa%",
	NEW_LINE,
	"tym g%upim ludziom!",
	DISPLAY_MESSAGE,
	"Mam gdzie$ patent!",
	DISPLAY_MESSAGE,
	"Mog# obrobi^ bank i nikt",
	NEW_LINE,
	"mnie nie zauwa<y!",
	DISPLAY_MESSAGE,
	"Szybciej ni< $wiat%o!",
	DISPLAY_MESSAGE,
	"Ukradn# najpierw troch# forsy",
	NEW_LINE,
	"lub z%ota na laboratorium",
	NEW_LINE,
	"dla tego szale=ca.",
	END_DIALOG,
};

const static char *polishDialog114[] = {
	"Ale wkr*tce...",
	DISPLAY_MESSAGE,
	"B#d# bogaty. Baaaardzo bogaty.",
	DISPLAY_MESSAGE,
	"\377Czuj#, jakbym m*g%...",
	DISPLAY_MESSAGE,
	"\377...jakbym m*g%...",
	END_DIALOG,
};

const static char *polishDialog115[] = {
	"\377PODBI\\ |WIAT!...",
	END_DIALOG,
};

const static char *polishDialog116[] = {
	"\377Zawsze chcia%em to powiedzie^.",
	END_DIALOG,
};

const static char *polishDialog117[] = {
	"To ja, znowu.",
	CHANGE_CHARACTER,
	"Do widzenia, znowu.",
	CHANGE_CHARACTER,
	"\377Powiedzmy, <e tego nie s%ysza%em.",
	DISPLAY_MESSAGE,
	"Czy  jest w domu?",
	CHANGE_CHARACTER,
	"Tak, ale kaza% mi pana nie wpuszcza^.",
	CHANGE_CHARACTER,
	"Mnie?! Dlaczego?!",
	CHANGE_CHARACTER,
	"Pa=ski ostatni wynalazek kosztowa%",
	NEW_LINE,
	"go dwie $ciany.",
	CHANGE_CHARACTER,
	"Och, ten wehiku% czasu...",
	DISPLAY_MESSAGE,
	"Ale teraz mam...",
	CHANGE_CHARACTER,
	"}e nie wspomn# znikni#cia jego kota.",
	CHANGE_CHARACTER,
	"Kot jest teraz bardziej szcz#$liwy",
	NEW_LINE,
	"ni< ktokolwiek z nas!",
	DISPLAY_MESSAGE,
	"\377O ile $wiat wci@< istnieje",
	NEW_LINE,
	"w XXV wieku.",
	DISPLAY_MESSAGE,
	"Niewa<ne. Musisz mnie wpu$ci^.",
	CHANGE_CHARACTER,
	"Taaak?",
	CHANGE_CHARACTER,
	"Albo powiem Ci@gwie, <e pijesz na s%u<bie.",
	CHANGE_CHARACTER,
	"Blefujesz pan. Nie ma dowod*w.",
	CHANGE_CHARACTER,
	"Niby tak, ale nigdy nie wiesz na pewno.",
	END_DIALOG,
};

const static char *polishDialog118[] = {
	"Dobra, w%a>, ty obrzydliwy terrorysto.",
	NEW_LINE,
	"Tylko nikomu nic nie m*w.",
	CHANGE_CHARACTER,
	"Oczywi$cie. Dzi#kuj#.",
	END_DIALOG,
};

const static char *polishDialog119[] = {
	"Ah... Wi#c to tak si# wszystko sta%o...",
	DISPLAY_MESSAGE,
	"To dlatego nikt nie widzia%,",
	NEW_LINE,
	"jak skarbce by%y ograbiane...",
	DISPLAY_MESSAGE,
	"To naprawd# niebezpieczny",
	NEW_LINE,
	"wynalazek!",
	DISPLAY_MESSAGE,
	"\377MUSZ[ zatrzyma^ Ci@gw#!",
	DISPLAY_MESSAGE,
	"\377Jako$.",
	DISPLAY_MESSAGE,
	"\377O rany! Te pigu%ki, kt*re",
	NEW_LINE,
	"wyj@%em z Cze$ka...",
	DISPLAY_MESSAGE,
	"Och, nie! Kto$ nadchodzi!",
	END_DIALOG,
};

const static char *polishDialog120[] = {
	"Musz# si# gdzie$ schowa^!",
	NEW_LINE,
	"Teraz!",
	END_DIALOG,
};

const static char *polishDialog121[] = {
	"Musz# kupi^ tradycyjny sejf.",
	DISPLAY_MESSAGE,
	"Ten g%upi robot znowu si# popsu%.",
	DISPLAY_MESSAGE,
	"Nienawidz# go. ZAMKNIJ SI[,",
	NEW_LINE,
	"TY KUPO Z]OMU!",
	END_DIALOG,
};

const static char *polishDialog122[] = {
	"Trzeci raz w tym tygodniu.",
	NEW_LINE,
	"Ju< dobrze, dobrze!...",
	NEW_LINE,
	"Id#!...",
	END_DIALOG,
};

const static char *polishDialog123[] = {
	"...pokry^ wszystko. Potrzebuj# wi#cej",
	NEW_LINE,
	"pieni#dzy na system ochronny.",
	DISPLAY_MESSAGE,
	"Mam tylko dw*ch ludzi i...",
	CHANGE_CHARACTER,
	"Wi#cej i wi#cej! Tylko to s%ysz#!",
	CHANGE_CHARACTER,
	"Wyja$ni# raz jeszcze...",
	END_DIALOG,
};

const static char *polishDialog124[] = {
	"Szefie? W%a$nie otrzyma%em informacj#",
	NEW_LINE,
	"od profesora.",
	DISPLAY_MESSAGE,
	"Prosi pana do laboratorium.",
	DISPLAY_MESSAGE,
	"M*wi, <e rozszyfrowa% struktur#",
	NEW_LINE,
	"pigu%ek.",
	END_DIALOG,
};

const static char *polishDialog125[] = {
	"Wi#c to jest to?!",
	CHANGE_CHARACTER,
	"Zdecydowanie ...hik!... tak.",
	CHANGE_CHARACTER,
	"Wspaniale!",
	END_DIALOG,
};

const static char *polishDialog126[] = {
	"Musz# ich powstrzyma^!",
	DISPLAY_MESSAGE,
	"Nie ma czasu do stracenia!",
	END_DIALOG,
};

const static char *polishDialog127[] = {
	"Prosz#, prosz#...",
	DISPLAY_MESSAGE,
	"Naprawd# dzia%asz mi na nerwy.",
	DISPLAY_MESSAGE,
	"Dobrze, <e nie oszcz#dza%em na",
	NEW_LINE,
	"systemie ochronnym...",
	DISPLAY_MESSAGE,
	"To pole si%owe jest niezniszczalne!",
	DISPLAY_MESSAGE,
	"Ha!",
	END_DIALOG,
};

const static char *polishDialog128[] = {
	"Ale i tak musz# ci# zabi^.",
	// END_DIALOG,
	CHANGE_CHARACTER,
	"Nie, nie!",
	CHANGE_CHARACTER,
	"Cisza!",
	CHANGE_CHARACTER,
	"To nie jest tego warte!",
	CHANGE_CHARACTER,
	"Powa<nie?",
	CHANGE_CHARACTER,
	"Ja nie chc#...",
	END_DIALOG,
};

const static char *polishDialog129[] = {
	CHANGE_CHARACTER,
	"Biedny profesor zemdla%...",
	CHANGE_CHARACTER,
	"Ale... Jak...",
	NEW_LINE,
	"NIC Z TEGO NIE ROZUMIEM!!!",
	CHANGE_CHARACTER,
	"To bardzo proste.",
	DISPLAY_MESSAGE,
	"Do twojej czapki przymocowali$my",
	NEW_LINE,
	"mikro-kamer#.",
	DISPLAY_MESSAGE,
	"W ten spos*b przez ca%y czas wiedzieli$my,",
	NEW_LINE,
	"co si# dzieje.",
	CHANGE_CHARACTER,
	"A widzieli$cie, jak ja?...",
	CHANGE_CHARACTER,
	"Nie chc# ci# zawstydza^.",
	DISPLAY_MESSAGE,
	"By%o nie by%o, odwali%e$ dla RGB kawa%",
	NEW_LINE,
	"dobrej roboty.",
	CHANGE_CHARACTER,
	"Ale Ci@gwa uciek%!",
	CHANGE_CHARACTER,
	"On jest niewa<ny. Mamy profesora,",
	NEW_LINE,
	"a ty dasz nam pigu%ki.",
	DISPLAY_MESSAGE,
	"Przepraszam, ale nie mo<esz ich zatrzyma^.",
	CHANGE_CHARACTER,
	"Okej, ale... Niech mi pan",
	NEW_LINE,
	"da tylko minut#...",
	DISPLAY_MESSAGE,
	"Mam pewien interes do za%atwienia",
	NEW_LINE,
	"z tym %ajdakiem.",
	CHANGE_CHARACTER,
	"\377W porz@dku. Ale pospiesz si#.",
	END_DIALOG,
};

const static char *polishDialog130[] = {
	"\377(gulp) Ten efekt czasowy naprawd#",
	NEW_LINE,
	"nie trwa d%ugo...",
	END_DIALOG,
};

const static char *polishDialog131[] = {
	"Przegra%e$, %otrze!",
	NEW_LINE,
	"Policja otacza budynek!",
	CHANGE_CHARACTER,
	"Nie wyg%upiaj si#.",
	NEW_LINE,
	"Chyba nie my$lisz, <e nie mam",
	NEW_LINE,
	"tajnej drogi ucieczki, co?",
	CHANGE_CHARACTER,
	"Taak? Jak@?",
	CHANGE_CHARACTER,
	"Jakbym mia% ci powiedzie^...",
	NEW_LINE,
	"Spadaj, robaku. Jestem zaj#ty.",
	END_DIALOG,
};

const static char *polishDialog132[] = {
	"Musz# pana rozbroi^.",
	NEW_LINE,
	"Prosz# by^ grzecznym i podda^ si#",
	NEW_LINE,
	"bez utrudnie=.",
	CHANGE_CHARACTER,
	"Nie mam czasu na <arty.",
	DISPLAY_MESSAGE,
	"Zje<d<aj st@d, albo znowu",
	NEW_LINE,
	"wyci@gn# sw*j pistolet.",
	CHANGE_CHARACTER,
	"Ostrzegam...",
	CHANGE_CHARACTER,
	"Gdzie oni sprzedaj@ takich",
	NEW_LINE,
	"nudziarzy jak ty?",
	END_DIALOG,
};

const static char *polishDialog133[] = {
	"Nie dam panu kolejnej szansy...",
	CHANGE_CHARACTER,
	"Fajnie. A teraz <egnam.",
	END_DIALOG,
};

const static char *polishDialog134[] = {
	"Niech pan przestanie pakowa^ t# fors#!",
	END_DIALOG,
};

const static char *polishDialog135[] = {
	"Witam.",
	CHANGE_CHARACTER,
	"No. O co chodzi?",
	CHANGE_CHARACTER,
	"Przys%ano mnie, <ebym tu nieco",
	NEW_LINE,
	"potrenowa%.",
	CHANGE_CHARACTER,
	"Kolejny napalony na bycie tajnym agentem,",
	NEW_LINE,
	"co?",
	CHANGE_CHARACTER,
	"U-hm.",
	CHANGE_CHARACTER,
	"Poka< mi jakie$ papiery, to ci# wpuszcz#.",
	CHANGE_CHARACTER,
	"Si# robi.",
	END_DIALOG,
};

const static char *polishDialog136[] = {
	"Nie m*g%bym wle>^ bez ca%ej tej",
	NEW_LINE,
	"biurokracji?",
	CHANGE_CHARACTER,
	"Przykro mi, ale nie.",
	NEW_LINE,
	"Rozkazy to rozkazy.",
	CHANGE_CHARACTER,
	"A barany to barany.",
	CHANGE_CHARACTER,
	"\377A martwi ludzie to martwi ludzie.",
	CHANGE_CHARACTER,
	"\377}ycz# mi%ego dnia, prosz# pana.",
	END_DIALOG,
};

const static char *polishDialog137[] = {
	"PROSZ[, MOG[ WEJ|\?!",
	CHANGE_CHARACTER,
	"TAK, MO}ESZ!",
	NEW_LINE,
	"POKA} TYLKO PRZEPUSTK[!",
	END_DIALOG,
};

const static char *polishDialog138[] = {
	"Wpu$^ mnie!",
	CHANGE_CHARACTER,
	"Poka< dokumenty!",
	CHANGE_CHARACTER,
	"Przejmujesz si# swoj@ prac@, no nie?",
	CHANGE_CHARACTER,
	"|lepy jeste$, czy co?",
	NEW_LINE,
	"Czytam gazet# na s%u<bie.",
	CHANGE_CHARACTER,
	"\377No tak. Sorry.",
	END_DIALOG,
};

const static char *polishDialog139[] = {
	"Musz#...",
	CHANGE_CHARACTER,
	"Dokumenty!",
	END_DIALOG,
};

const static char *polishDialog140[] = {
	"Co czytasz?",
	CHANGE_CHARACTER,
	"\'Tydzie= }o%nierza\', oczywi$cie.",
	CHANGE_CHARACTER,
	"Kochasz te wszystkie militaria,",
	NEW_LINE,
	"no nie?",
	CHANGE_CHARACTER,
	"Zg%upia%e$? Mam tu zdj#cia fajnych babek...",
	DISPLAY_MESSAGE,
	"...krzy<*wki ...stron# z dowcipami...",
	DISPLAY_MESSAGE,
	"...plotki ...przepisy...",
	CHANGE_CHARACTER,
	"PRZEPISY?!",
	CHANGE_CHARACTER,
	"Tak, staraj@ si# zwi#kszy^ nak%ad.",
	NEW_LINE,
	"Zdoby^ nowych czytelnik*w, no wiesz.",
	CHANGE_CHARACTER,
	"Ah tak. |wietny pomys%.",
	NEW_LINE,
	"A jest co$ o szyde%kowaniu?",
	CHANGE_CHARACTER,
	"Mam wra<enie, <e chcesz by^ dowcipny.",
	CHANGE_CHARACTER,
	"Eee, ja? Nigdy.",
	CHANGE_CHARACTER,
	"To dobrze.",
	END_DIALOG,
};

const static char *polishDialog141[] = {
	"Po<yczy%by$ mi to pismo?",
	CHANGE_CHARACTER,
	"A czym ja wtedy b#d# zabija% czas?",
	CHANGE_CHARACTER,
	"Eee... Mo<esz policzy^ li$cie na drzewach.",
	CHANGE_CHARACTER,
	"Jest tu 11034 li$ci.",
	CHANGE_CHARACTER,
	"\377]a%.",
	END_DIALOG,
};

const static char *polishDialog142[] = {
	"Co poza tym?",
	CHANGE_CHARACTER,
	"Nie marud>.",
	END_DIALOG,
};

const static char *polishDialog143[] = {
	"Tak trzymaj.",
	END_DIALOG,
};

const static char *polishDialog144[] = {
	CHANGE_CHARACTER,
	"Ty tam, wracaj!",
	END_DIALOG,
};

const static char *polishDialog145[] = {
	"O co chodzi?",
	CHANGE_CHARACTER,
	"Musisz pokaza^ mi przepustk#.",
	CHANGE_CHARACTER,
	"A jak wejd# na chama?",
	CHANGE_CHARACTER,
	"B#d# musia% ci# zastrzeli^.",
	CHANGE_CHARACTER,
	"(gulp)",
	END_DIALOG,
};

const static char *polishDialog146[] = {
	CHANGE_CHARACTER,
	"Ostrzegam... Moje naboje s@",
	NEW_LINE,
	"szybsze od ciebie...",
	END_DIALOG,
};

const static char *polishDialog147[] = {
	CHANGE_CHARACTER,
	"W porz@dku. Zamelduj si# u kapitana.",
	NEW_LINE,
	"Powinien by^ w pobli<u.",
	CHANGE_CHARACTER,
	"Dzi#ki.",
	END_DIALOG,
};

const static char *polishDialog148[] = {
	CHANGE_CHARACTER,
	"Zrobimy z ciebie m#<czyzn#,",
	NEW_LINE,
	"racja, synu?!",
	CHANGE_CHARACTER,
	"Eee...",
	CHANGE_CHARACTER,
	"Najlepszego z najlepszych!...",
	CHANGE_CHARACTER,
	"Uh...",
	CHANGE_CHARACTER,
	"Przez pot, krew i %zy!",
	CHANGE_CHARACTER,
	"Wola%bym...",
	CHANGE_CHARACTER,
	"Ciesz# si# z twojego entuzjazmu, synu!",
	DISPLAY_MESSAGE,
	"Nie tra^my czasu!",
	DISPLAY_MESSAGE,
	"Kazano mi odby^ z tob@ trening ekspresowy.",
	DISPLAY_MESSAGE,
	"W porz@dku, synu!",
	DISPLAY_MESSAGE,
	"Musisz przej$^ trzy testy!",
	DISPLAY_MESSAGE,
	"Zacznijmy od naj%atwiejszego!...",
	END_DIALOG,
};

const static char *polishDialog149[] = {
	CHANGE_CHARACTER,
	"Zadanie jest proste.",
	DISPLAY_MESSAGE,
	"Zamkn# ci# tutaj...",
	DISPLAY_MESSAGE,
	"...i b#dziesz musia% si# jako$ wydosta^.",
	DISPLAY_MESSAGE,
	"Jasne?!",
	CHANGE_CHARACTER,
	"Prosz# pana, ja...",
	CHANGE_CHARACTER,
	"TO DOBRZE!!!",
	END_DIALOG,
};

const static char *polishDialog150[] = {
	"\377Halo?... Wspaniale.",
	END_DIALOG,
};

const static char *polishDialog151[] = {
	"No dobra, to by%o zabawne.",
	NEW_LINE,
	"Teraz prosz# mnie wypu$ci^!",
	END_DIALOG,
};

const static char *polishDialog152[] = {
	"Hej! Jest tam kto$?!",
	DISPLAY_MESSAGE,
	"\377POMOCY!!!",
	END_DIALOG,
};

const static char *polishDialog153[] = {
	"Lito$ci! Ja tu umr#!",
	END_DIALOG,
};

const static char *polishDialog154[] = {
	"Robi# si# g%odny!",
	END_DIALOG,
};

const static char *polishDialog155[] = {
	"Nie wiem, co teraz powiedzie^...",
	END_DIALOG,
};

const static char *polishDialog156[] = {
	"Chyba ...zda%e$ ...pierwszy test...",
	DISPLAY_MESSAGE,
	"...Przejd>my ...do nast#pnego...",
	END_DIALOG,
};

const static char *polishDialog157[] = {
	CHANGE_CHARACTER,
	"Dobrze, <o%nierzu.",
	DISPLAY_MESSAGE,
	"Za%*<my, <e jestem twoim je=cem...",
	DISPLAY_MESSAGE,
	"\377..i znam jakie$ tajne has%o.",
	DISPLAY_MESSAGE,
	"\377usisz je ode mnie wydosta^.",
	DISPLAY_MESSAGE,
	"JASNE?!?",
	CHANGE_CHARACTER,
	"Jestem jako$ ograniczony?",
	CHANGE_CHARACTER,
	"Nie. R*b, co chcesz.",
	CHANGE_CHARACTER,
	"Mog# nawet splun@^ panu w oko?",
	CHANGE_CHARACTER,
	"\377Tak.",
	CHANGE_CHARACTER,
	"\377Dzi#ki, tylko sprawdza%em.",
	END_DIALOG,
};

const static char *polishDialog158[] = {
	"Prosz# powiedzie^ mi has%o...",
	DISPLAY_MESSAGE,
	"...i miejmy to ju< z g%owy.",
	DISPLAY_MESSAGE,
	"\377OK, niech pan o tym pomy$li.",
	END_DIALOG,
};

const static char *polishDialog159[] = {
	"Hej, przem*w pan do mnie.",
	DISPLAY_MESSAGE,
	"\377S%ycha^ mnie?",
	DISPLAY_MESSAGE,
	"\377ZIEMIA DO KAPITANA, ZIEMIA DO KAPITANA!",
	DISPLAY_MESSAGE,
	"\377Jest pan beznadziejny.",
	END_DIALOG,
};

const static char *polishDialog160[] = {
	"Gotowy do m*wienia?",
	DISPLAY_MESSAGE,
	"\377Dobra, jeszcze poczekam.",
	END_DIALOG,
};

const static char *polishDialog161[] = {
	"No, a teraz, jak brzmi has%o?",
	CHANGE_CHARACTER,
	"Spadaj, <a%osny $mieciu.",
	CHANGE_CHARACTER,
	"B@d> grzeczny, albo po%askocz# znowu.",
	CHANGE_CHARACTER,
	"Dalej, to b#dzie przyjemno$^.",
	CHANGE_CHARACTER,
	"\377Podoba%o si# panu to, no nie?",
	CHANGE_CHARACTER,
	"No wiesz...",
	CHANGE_CHARACTER,
	"Dobra, znajd# jaki$ inny spos*b.",
	END_DIALOG,
};

const static char *polishDialog162[] = {
	"Przynios%em panu co$...",
	CHANGE_CHARACTER,
	"Nie dam si# przekupi^.",
	CHANGE_CHARACTER,
	"Taaak?",
	END_DIALOG,
};

const static char *polishDialog163[] = {
	NEW_LINE,
	"OH DAJMIDAJMIDAJMI!!!",
	DISPLAY_MESSAGE,
	"ZROBI[ WSZYSTKO!!!",
	CHANGE_CHARACTER,
	"Has%o...",
	CHANGE_CHARACTER,
	"Has%o brzmi \'KAWA\'.",
	DISPLAY_MESSAGE,
	"Powiedz je barmanowi, a co$ ci da.",
	DISPLAY_MESSAGE,
	"Potem opowie ci o trzecim te$cie.",
	DISPLAY_MESSAGE,
	"TERAZ UWOLNIJ MNIE!!!",
	CHANGE_CHARACTER,
	"Pomy$l# o tym.",
	END_DIALOG,
};

const static char *polishDialog164[] = {
	"Ty...",
	DISPLAY_MESSAGE,
	"...ty...",
	DISPLAY_MESSAGE,
	"\377...zda%e$!",
	END_DIALOG,
};

const static char *polishDialog165[] = {
	"Co powiesz na cudowny kalejdoskop?",
	CHANGE_CHARACTER,
	"Mia%em kiedy$ jeden, ale kapitan zobaczy%...",
	DISPLAY_MESSAGE,
	"...jak si# nim bawi# i zabra% mi go.",
	DISPLAY_MESSAGE,
	"My$l#, <e sam go chcia%, no wiesz...",
	CHANGE_CHARACTER,
	"Jak dasz mi gazet#, dam ci",
	NEW_LINE,
	"ten kalejdoskop.",
	CHANGE_CHARACTER,
	"Nawet nie chc# wiedzie^, sk@d go masz...",
	CHANGE_CHARACTER,
	"I dobrze.",
	CHANGE_CHARACTER,
	"...ale co, je$li kapitan mnie znowu zobaczy?",
	CHANGE_CHARACTER,
	"Nie martw si#, jest zwi@zany.",
	CHANGE_CHARACTER,
	"Och, test numer dwa, co?...",
	CHANGE_CHARACTER,
	"Yep.",
	CHANGE_CHARACTER,
	"Dobra, dawaj.",
	END_DIALOG,
};

const static char *polishDialog166[] = {
	"\'KAWA\'.",
	END_DIALOG,
};

const static char *polishDialog167[] = {
	"Gor@ca, nie?",
	CHANGE_CHARACTER,
	"Uh-huh.",
	CHANGE_CHARACTER,
	"Kapitan powiedzia%, <e opowie mi pan",
	NEW_LINE,
	"o trzecim te$cie.",
	CHANGE_CHARACTER,
	"Znowu...",
	DISPLAY_MESSAGE,
	"Dobra, to rodzaj chowanego.",
	DISPLAY_MESSAGE,
	"Kapitan si# chowa, ty szukasz.",
	CHANGE_CHARACTER,
	"Ale on jest wci@< przywi@zany do krzes%a!",
	CHANGE_CHARACTER,
	"Ten cz%owiek i te jego gierki...",
	DISPLAY_MESSAGE,
	"Prze<ywa je bardziej, ni< powinien!...",
	DISPLAY_MESSAGE,
	"Oszuka% ci#.",
	DISPLAY_MESSAGE,
	"Id> i sprawd>.",
	DISPLAY_MESSAGE,
	"Na pewno ju< si# uwolni%.",
	CHANGE_CHARACTER,
	"Ale zabra%em mu n*<!",
	DISPLAY_MESSAGE,
	"Jak m*g% rozci@^ wi#zy?!",
	CHANGE_CHARACTER,
	"Mo<e odszed% z krzes%em przywi@zanym do...",
	DISPLAY_MESSAGE,
	"Niewa<ne.",
	CHANGE_CHARACTER,
	"Jakie$ wskaz*wki co do miejsca jego ukrycia?",
	CHANGE_CHARACTER,
	"Nie.",
	CHANGE_CHARACTER,
	"Och, daj pan spok*j.",
	CHANGE_CHARACTER,
	"Nie, ch%opcze. Graj uczciwie.",
	END_DIALOG,
};

const static char *polishDialog168[] = {
	"Czas na ma%@ podpowied>?",
	CHANGE_CHARACTER,
	"Nie.",
	END_DIALOG,
};

const static char *polishDialog169[] = {
	"Dzie= dobry. Jestem Marek.",
	CHANGE_CHARACTER,
	"A ja nie.",
	DISPLAY_MESSAGE,
	"Co mog# dla ciebie zrobi^?",
	CHANGE_CHARACTER,
	"\377Da^ mi mn*stwo forsy...",
	DISPLAY_MESSAGE,
	"...lub stan@^ na g%owie...",
	DISPLAY_MESSAGE,
	"...lub...",
	CHANGE_CHARACTER,
	"Okej, okej. Remis.",
	DISPLAY_MESSAGE,
	"Wi#c?...",
	CHANGE_CHARACTER,
	"Kto jeszcze jest w obozie?",
	CHANGE_CHARACTER,
	"Jeste$ dziennikarzem?",
	CHANGE_CHARACTER,
	"Nie, tajnym agentem.",
	CHANGE_CHARACTER,
	"Ty te<?... W ka<dym razie jest",
	NEW_LINE,
	"tu tylko nas trzech.",
	DISPLAY_MESSAGE,
	"Ja, kapitan i stra<nik.",
	CHANGE_CHARACTER,
	"Bez kobiet?",
	CHANGE_CHARACTER,
	"Bez p%aczu.",
	CHANGE_CHARACTER,
	"\377No c*<...",
	END_DIALOG,
};

const static char *polishDialog170[] = {
	"Ruch nie za wielki, nie?",
	CHANGE_CHARACTER,
	"Zamawiasz co$ czy nie?",
	CHANGE_CHARACTER,
	"Nie mam forsy.",
	CHANGE_CHARACTER,
	"Dzisiaj za darmo.",
	CHANGE_CHARACTER,
	"Powa<nie?",
	CHANGE_CHARACTER,
	"Powa<nie.",
	CHANGE_CHARACTER,
	"Chc# hot-doga.",
	CHANGE_CHARACTER,
	"Pud%o.",
	CHANGE_CHARACTER,
	"Pizz#?",
	CHANGE_CHARACTER,
	"Pud%o.",
	CHANGE_CHARACTER,
	"Tosta?",
	CHANGE_CHARACTER,
	"Pud%o.",
	CHANGE_CHARACTER,
	"Cokolwiek?",
	CHANGE_CHARACTER,
	"Pud%o.",
	CHANGE_CHARACTER,
	"\377Nie, dzi#kuj#. Nie jestem",
	NEW_LINE,
	"g%odny.",
	END_DIALOG,
};

const static char *polishDialog171[] = {
	"Co pan pije?",
	CHANGE_CHARACTER,
	"Herbat#.",
	CHANGE_CHARACTER,
	"Na pewno...",
	END_DIALOG,
};

const static char *polishDialog172[] = {
	"]adna pogoda.",
	CHANGE_CHARACTER,
	"Mhmmm...",
	END_DIALOG,
};

const static char *polishDialog173[] = {
	"Czasem czuj# si# zm#czony.",
	DISPLAY_MESSAGE,
	"\377Bardzo zm#czony.",
	END_DIALOG,
};

const static char *polishDialog174[] = {
	"Hej, Woodstock si# sko=czy%!",
	END_DIALOG,
};

const static char *polishDialog175[] = {
	"Dzi#ki.",
	END_DIALOG,
};

const static char *polishDialog176[] = {
	CHANGE_CHARACTER,
	"Co u licha...",
	END_DIALOG,
};

const static char *polishDialog177[] = {
	"Hej, nie jest pan spraginony?",
	DISPLAY_MESSAGE,
	"Pana kubek le<y od%ogiem...",
	END_DIALOG,
};

const static char *polishDialog178[] = {
	"Sir, mamy sygna%y, <e...",
	CHANGE_CHARACTER,
	"P*<niej! Teraz jestem",
	NEW_LINE,
	"bardzo zaj#ty.",
	CHANGE_CHARACTER,
	"Jak pan sobie <yczy.",
	END_DIALOG,
};

const static char *polishDialog179[] = {
	"Sir, jaki$ %epek pr*bowa% dosta^ si#",
	NEW_LINE,
	"do posiad%o$ci.",
	END_DIALOG,
};

const static char *polishDialog180[] = {
	"Nie przejmuj si#.",
	DISPLAY_MESSAGE,
	"M%odzi ch%opcy zawsze s@ ciekawi...",
	DISPLAY_MESSAGE,
	"...a moje domostwo musi dzia%a^ im na wyobra>ni#.",
	DISPLAY_MESSAGE,
	"Ale trzymaj na niego oko.",
	CHANGE_CHARACTER,
	"Tak jest, sir!",
	END_DIALOG,
};

const static char *polishDialog181[] = {
	"Sir, ten ch%opak zn*w pr*bowa%.",
	END_DIALOG,
};

const static char *polishDialog182[] = {
	"My$lisz, <e to powa<ne?",
	CHANGE_CHARACTER,
	"Hmmm... Nie...",
	DISPLAY_MESSAGE,
	"On nie wygl@da gro>nie.",
	DISPLAY_MESSAGE,
	"Ale mo<e powinni$my...",
	CHANGE_CHARACTER,
	"Nieee.",
	DISPLAY_MESSAGE,
	"Po prostu r*b dalej swoj@ robot#.",
	DISPLAY_MESSAGE,
	"Ale powiedz mi, jak si# znowu pojawi.",
	DISPLAY_MESSAGE,
	"Teraz wracaj do pracy.",
	END_DIALOG,
};

const static char *polishDialog183[] = {
	"Nie m*w mi, <e to znowu ten szczyl...",
	CHANGE_CHARACTER,
	"Obawiam si#, <e tak.",
	DISPLAY_MESSAGE,
	"Stra<nik m*wi, <e ch%opiec jest zdesperowany.",
	END_DIALOG,
};

const static char *polishDialog184[] = {
	"Zaczyna mnie denerwowa^.",
	DISPLAY_MESSAGE,
	"Za co ja wam p%ac#?",
	CHANGE_CHARACTER,
	"Mam go?...",
	CHANGE_CHARACTER,
	"Jeszcze nie. Dajmy mu",
	NEW_LINE,
	"ostatni@ szans#.",
	END_DIALOG,
};

const static char *polishDialog185[] = {
	"Sir...",
	CHANGE_CHARACTER,
	"Niech zgadn#...",
	DISPLAY_MESSAGE,
	"CH]OPAK?!?...",
	CHANGE_CHARACTER,
	"Bingo.",
	CHANGE_CHARACTER,
	"Dlaczego ja musz# troszczy^",
	NEW_LINE,
	"si# o wszystko?!",
	DISPLAY_MESSAGE,
	"Nie mo<esz zrobi^ niczego samemu?",
	CHANGE_CHARACTER,
	"Mam go zabi^, czy tylko st%uc?",
	CHANGE_CHARACTER,
	"Jeste$ g%upi. Istniej@",
	NEW_LINE,
	"...lepsze sposoby...",
	END_DIALOG,
};

const static char *polishDialog186[] = {
	"Zajm# si# tym osobi$cie.",
	DISPLAY_MESSAGE,
	"A teraz wyjd>!",
	DISPLAY_MESSAGE,
	"Musz# si# ubra^.",
	END_DIALOG,
};

const static char *polishDialog187[] = {
	"Ty tam, na g*rze!",
	DISPLAY_MESSAGE,
	"Z%a> natychmiast!",
	DISPLAY_MESSAGE,
	"\377Zero reakcji.",
	DISPLAY_MESSAGE,
	"\377G%uchy czy co?",
	END_DIALOG,
};

const static char *polishDialog188[] = {
	"Ty, ptasiek, nie b*j si#.",
	DISPLAY_MESSAGE,
	"Chod> do tatusia...",
	DISPLAY_MESSAGE,
	"\377(westchnienie)",
	END_DIALOG,
};

const static char *polishDialog189[] = {
	"Chod> tu, ptaszku...",
	END_DIALOG,
};

const static char *polishDialog190[] = {
	NEW_LINE,
	"Trzymaj si# z dala od tamtych drzwi!",
	CHANGE_CHARACTER,
	"Czemu?",
	CHANGE_CHARACTER,
	"Nie tw*j interes.",
	DISPLAY_MESSAGE,
	"Po prostu nie dotykaj ich.",
	END_DIALOG,
};

const static char *polishDialog191[] = {
	CHANGE_CHARACTER,
	"M*wi%em, <eby$ trzyma% si# z dala, nie?",
	CHANGE_CHARACTER,
	"OK, OK...",
	END_DIALOG,
};

const static char *polishDialog192[] = {
	"Przywioz%em now@ dostaw# z%ota.",
	CHANGE_CHARACTER,
	"Tak, wiem. Has%o?",
	CHANGE_CHARACTER,
	"Grzyb.",
	CHANGE_CHARACTER,
	"W porz@dku. Mo<esz zacz@^ wnosi^",
	NEW_LINE,
	"depozyt do $rodka.",
	CHANGE_CHARACTER,
	"Znakomicie.",
	END_DIALOG,
};

const static char *polishDialog193[] = {
	"Jak ju< powiedzia%em, nasza organizacja",
	NEW_LINE,
	"zajmuje si# niezwyk%ymi sprawami.",
	DISPLAY_MESSAGE,
	"Ostatnio na przyk%ad rozwi@zali$my problem",
	NEW_LINE,
	"UFO nad Bia%ym Domem.",
	CHANGE_CHARACTER,
	"Oh, naphawd#? Jak?",
	CHANGE_CHARACTER,
	"Zestrzelili$my go.",
	CHANGE_CHARACTER,
	"\377Hozumiem. I kto ...lub co",
	NEW_LINE,
	"by%o w $hodku?",
	CHANGE_CHARACTER,
	"Chce pani wiedzie^?",
	CHANGE_CHARACTER,
	"O, tak! Jako wh*<ka jestem",
	NEW_LINE,
	"bahdzo ciekawska.",
	CHANGE_CHARACTER,
	"NAPRAWD[ chce pani wiedzie^?",
	CHANGE_CHARACTER,
	"TAK!",
	CHANGE_CHARACTER,
	"Ale ...NAPRAWD[ NAPRAWD[?",
	CHANGE_CHARACTER,
	"TAK!",
	CHANGE_CHARACTER,
	"\377Przepraszam, ale nie mog# powiedzie^.",
	DISPLAY_MESSAGE,
	"W ka<dym razie... Potrzebujemy pani pomocy.",
	CHANGE_CHARACTER,
	"Nie jestem tajnym agentem, tylko wh*<k@...",
	CHANGE_CHARACTER,
	"Wiem. Ale mam tutaj bardzo",
	NEW_LINE,
	"trudn@ spraw#...",
	DISPLAY_MESSAGE,
	"...kt*rej nie mog# rozwi@za^ od p*% roku.",
	DISPLAY_MESSAGE,
	"Jestem w beznadziejnej sytuacji.",
	DISPLAY_MESSAGE,
	"Pomy$la%em wi#c sobie, <e skoro zajmujemy",
	NEW_LINE,
	"si# dziwnymi sprawami...",
	DISPLAY_MESSAGE,
	"...to czemu nie u<y^ dziwnych",
	NEW_LINE,
	"$rodk*w?",
	CHANGE_CHARACTER,
	"I?...",
	CHANGE_CHARACTER,
	"Poka<# pani ksi@<k# telefoniczn@.",
	DISPLAY_MESSAGE,
	"Niech pani u<yje swoich mocy i losowo",
	NEW_LINE,
	"wska<e nazwisko.",
	DISPLAY_MESSAGE,
	"Mo<e $wie<y umys% pomo<e nam w $ledztwie.",
	CHANGE_CHARACTER,
	"Pan nie wierzy, <e to zadzia%a, phawda?",
	CHANGE_CHARACTER,
	"Nie, nie wierz#.",
	CHANGE_CHARACTER,
	"\377To jest g%upie.",
	CHANGE_CHARACTER,
	"Wiem.",
	CHANGE_CHARACTER,
	"\377Dobrze. Phosz# pokaza^ mi ksi@<k#.",
	END_DIALOG,
};

const static char *polishDialog194[] = {
	"\377Nazwisko brzmi...",
	DISPLAY_MESSAGE,
	"...Hoppeh...",
	DISPLAY_MESSAGE,
	"...Mahek Hoppeh...",
	DISPLAY_MESSAGE,
	"Hm...",
	END_DIALOG,
};

const static char *polishDialog195[] = {
	"Nadchodzi.",
	END_DIALOG,
};

const static char *polishDialog196[] = {
	"Och, przepraszam za moich ludzi.",
	DISPLAY_MESSAGE,
	"S@ ostatnio zbyt nerwowi...",
	DISPLAY_MESSAGE,
	"Ale, prosz#... Porozmawiajmy...",
	END_DIALOG,
};

const static char *polishDialog197[] = {
	"S%uchaj pan...",
	CHANGE_CHARACTER,
	"Wiem, wiem.",
	DISPLAY_MESSAGE,
	"Prosz# da^ mi pi#^ minut, a wszystko",
	NEW_LINE,
	"stanie si# jasne.",
	CHANGE_CHARACTER,
	"Wal pan, zawsze lubi%em zabaw#",
	NEW_LINE,
	"w konspiracj#.",
	CHANGE_CHARACTER,
	"C*<...",
	DISPLAY_MESSAGE,
	"Jestem szefem organizacji zwanej RGB.",
	CHANGE_CHARACTER,
	"A czemu RGB?",
	CHANGE_CHARACTER,
	"Nawet ja nie wiem.",
	DISPLAY_MESSAGE,
	"Jest tak tajna.",
	CHANGE_CHARACTER,
	"\377Miodzio.",
	CHANGE_CHARACTER,
	"Celem organizacji jest rozwi@zywanie",
	NEW_LINE,
	"wszystkich nadzwyczajnych problem*w",
	NEW_LINE,
	"$wiata.",
	CHANGE_CHARACTER,
	"Jak podatki?",
	CHANGE_CHARACTER,
	"Nie, jak UFO, dziwne wynalazki,",
	NEW_LINE,
	"duchy...",
	CHANGE_CHARACTER,
	"]a%!",
	CHANGE_CHARACTER,
	"Tak, kiedy policja, wywiad i inne s%u<by",
	NEW_LINE,
	"nie mog@ da^ sobie rady...",
	DISPLAY_MESSAGE,
	"...my wkraczamy. Ale...",
	DISPLAY_MESSAGE,
	"\377Sze$^ miesi#cy temu z%oto i got*wka",
	NEW_LINE,
	"zdeponowane w najlepszych bankach zacz#%y",
	NEW_LINE,
	"znika^.",
	DISPLAY_MESSAGE,
	"Dos%ownie. Pum! I nie ma!",
	CHANGE_CHARACTER,
	"No i?...",
	CHANGE_CHARACTER,
	"Nie mamy <adnych $lad*w.",
	DISPLAY_MESSAGE,
	"Ca%a rzecz odbywa si# w kilka sekund.",
	DISPLAY_MESSAGE,
	"Mamy nagrania wideo, ale one nic nie",
	NEW_LINE,
	"pomagaj@.",
	DISPLAY_MESSAGE,
	"Dlatego wynaj#li$my wr*<k#,",
	NEW_LINE,
	"aby wskaza%a nam kogo$...",
	DISPLAY_MESSAGE,
	"...kto mo<e sta^ si# naszym",
	NEW_LINE,
	"zbawieniem.",
	DISPLAY_MESSAGE,
	"Wybra%a ciebie.",
	CHANGE_CHARACTER,
	"Bardzo przepraszam...",
	DISPLAY_MESSAGE,
	"Pan powiedzia%, <e wynaj#li$cie...",
	NEW_LINE,
	"...WR{}K[?!?",
	CHANGE_CHARACTER,
	"Ton@cy brzytwy si# chwyta.",
	CHANGE_CHARACTER,
	"To jest szalone. Mamo, obud> mnie!",
	CHANGE_CHARACTER,
	"Spokojnie. Mamy dla ciebie",
	NEW_LINE,
	"propozycj#.",
	DISPLAY_MESSAGE,
	"Spr*buj nam pom*c, a zostaniesz nagrodzony.",
	CHANGE_CHARACTER,
	"Nie mam motywacji.",
	CHANGE_CHARACTER,
	"Samozadowolenie?",
	END_DIALOG,
};

const static char *polishDialog198[] = {
	CHANGE_CHARACTER,
	"Nasz szacunek?",
	END_DIALOG,
};

const static char *polishDialog199[] = {
	CHANGE_CHARACTER,
	"Patriotyzm?",
	END_DIALOG,
};

const static char *polishDialog200[] = {
	CHANGE_CHARACTER,
	"Dziewczyny?",
	CHANGE_CHARACTER,
	"To znaczy?...",
	CHANGE_CHARACTER,
	"To proste. Ka<da dziewczyna zakocha si#",
	NEW_LINE,
	"w tajnym agencie.",
	END_DIALOG,
};

const static char *polishDialog201[] = {
	"Dobra, zgadzam si#. Co mam robi^?",
	CHANGE_CHARACTER,
	"Zanim zaczniesz, sugeruj# kr*tki pobyt",
	NEW_LINE,
	"w naszym specjalnym tajnym obozie",
	NEW_LINE,
	"treningowym.",
	DISPLAY_MESSAGE,
	"Wydam ci przepustk#.",
	DISPLAY_MESSAGE,
	"Umowa stoi?",
	CHANGE_CHARACTER,
	"Stoi!",
	END_DIALOG,
};

const static char *polishDialog202[] = {
	"\377..i nawet mia%em niez%y ubaw.",
	CHANGE_CHARACTER,
	"\377iesz# si#, <e podobaj@ ci si# nasze metody.",
	DISPLAY_MESSAGE,
	"Ale przejd>my do rzeczy.",
	DISPLAY_MESSAGE,
	"Musz# przyzna^, i< nie wierzy%em, <e mo<e by^",
	NEW_LINE,
	"z ciebie jaki$ po<ytek.",
	DISPLAY_MESSAGE,
	"Nic osobistego.",
	CHANGE_CHARACTER,
	"Mam nadziej#.",
	CHANGE_CHARACTER,
	"Ale przynios%e$ nam szcz#$cie.",
	DISPLAY_MESSAGE,
	"Nasi ludzie dowiedzieli si#, <e",
	NEW_LINE,
	"pewien przeci#tny biznesmen...",
	DISPLAY_MESSAGE,
	"...niejaki Ci@gwa Jan...",
	DISPLAY_MESSAGE,
	"...wydaje fors# jak szalony...",
	DISPLAY_MESSAGE,
	"...na jakie$ dziwne materia%y.",
	DISPLAY_MESSAGE,
	"Zwi@zane s@ z tym trzy bardzo podejrzane",
	NEW_LINE,
	"rzeczy:",
	DISPLAY_MESSAGE,
	"...P%aci got*wk@...",
	DISPLAY_MESSAGE,
	"...co jest co najmniej bez sensu",
	NEW_LINE,
	"w erze kart kredytowych...",
	DISPLAY_MESSAGE,
	"...Po drugie, jeszcze p*% roku temu nie by% tak",
	NEW_LINE,
	"bogaty, jak jest dzi$...",
	DISPLAY_MESSAGE,
	"...Po trzecie, po diab%a mu sto kilogram*w",
	NEW_LINE,
	"saletry?",
	CHANGE_CHARACTER,
	"Mo<e to jaki$ dziwak.",
	CHANGE_CHARACTER,
	"Mo<e. Jednak chcia%bym, <eby$ w$lizgn@% si#",
	NEW_LINE,
	"jako$ do jego posiad%o$ci...",
	DISPLAY_MESSAGE,
	"...i rozejrza% si# co nieco.",
	DISPLAY_MESSAGE,
	"Co ty na to?",
	CHANGE_CHARACTER,
	"No, nie wiem...",
	CHANGE_CHARACTER,
	"Obiecuj#, <e po twojej misji zrobi# ci#",
	NEW_LINE,
	"oficjalnym tajnym agentem.",
	CHANGE_CHARACTER,
	"\377S%owo?",
	CHANGE_CHARACTER,
	"Moje s%owo honoru.",
	CHANGE_CHARACTER,
	"Okej. Jestem gotowy.",
	NEW_LINE,
	"Gdzie mam si# uda^?",
	CHANGE_CHARACTER,
	"To ma%a wioska. Nie znajdziesz jej",
	NEW_LINE,
	"na wielu mapach...",
	DISPLAY_MESSAGE,
	"Ale przed wyjazdem dam ci specjalne",
	NEW_LINE,
	"wyposa<enie agenta.",
	DISPLAY_MESSAGE,
	"Szkoda, <e lataj@ce buty s@ w%a$nie",
	NEW_LINE,
	"wypo<yczone.",
	DISPLAY_MESSAGE,
	"R#kawice o megamocy te< si# sko=czy%y.",
	DISPLAY_MESSAGE,
	"W%a$ciwie to mam tylko specjalny super klej.",
	DISPLAY_MESSAGE,
	"No, ale lepszy rydz ni< nic...",
	DISPLAY_MESSAGE,
	"Powodzenia!",
	END_DIALOG,
};

const static char *polishDialog203[] = {
	CHANGE_CHARACTER,
	"Nie martw si#. Wyzdrowieje.",
	DISPLAY_MESSAGE,
	"Zreszt@... o, patrz, idzie...",
	END_DIALOG,
};

const static char *polishDialog204[] = {
	CHANGE_CHARACTER,
	"Nale<a%o mu si#. Ale zmarnowali$my",
	NEW_LINE,
	"do$^ czasu. Chod>my!",
	CHANGE_CHARACTER,
	"Nie! Chwila!... Musz# zobaczy^ Ann#!",
	CHANGE_CHARACTER,
	"Eemm... Nie da rady.",
	CHANGE_CHARACTER,
	"A to niby dlaczego?!",
	CHANGE_CHARACTER,
	"\377Widzisz... Anna to nasz cz%owiek.",
	DISPLAY_MESSAGE,
	"Mia%a rozkaz trzyma^ na ciebie oko...",
	DISPLAY_MESSAGE,
	"Na wypadek, gdyby zawiod%a mikrokamera.",
	DISPLAY_MESSAGE,
	"Mia%a by^ tak<e twoim natchnieniem...",
	CHANGE_CHARACTER,
	"Nie wierz# panu!",
	CHANGE_CHARACTER,
	"Ona ju< odlecia%a na",
	NEW_LINE,
	"kolejn@ misj#.",
	NEW_LINE,
	"Sorry.",
	CHANGE_CHARACTER,
	"To babcia pewnie te< by%a w to zamieszana?",
	CHANGE_CHARACTER,
	"To tubylka. Op%acili$my j@.",
	CHANGE_CHARACTER,
	"To ciekawe. Bo skoro tak, to dlaczego",
	NEW_LINE,
	"mia%em tyle trudno$ci?...",
	CHANGE_CHARACTER,
	"Wzbudzali$my twoj@ determinacj#.",
	DISPLAY_MESSAGE,
	"Liczyli$my na to, <e masz charakter.",
	DISPLAY_MESSAGE,
	"No i nie pomylili$my si#.",
	CHANGE_CHARACTER,
	"Traktujecie ludzi jak zwierz@tka",
	NEW_LINE,
	"do$wiadczalne.",
	DISPLAY_MESSAGE,
	"Jeste$cie bez lito$ci...",
	CHANGE_CHARACTER,
	"Ale to dzia%a, nie?",
	CHANGE_CHARACTER,
	"To wszystko jest takie niewiarygodne.",
	DISPLAY_MESSAGE,
	"Mo<e jeszcze zaraz si# dowiem, <e pies to",
	NEW_LINE,
	"zamaskowany ninja...",
	DISPLAY_MESSAGE,
	"...staruszek by% moim gorylem...",
	DISPLAY_MESSAGE,
	"...a pan jest z Marsa?!",
	END_DIALOG,
};

const static char *polishDialog205[] = {
	CHANGE_CHARACTER,
	"To nie \'Dynastia\', to zwyk%a",
	NEW_LINE,
	"praca agenta.",
	DISPLAY_MESSAGE,
	"Ale, ale... Wst@p do RGB i tam",
	NEW_LINE,
	"na pewno spotkasz Ann#!",
	CHANGE_CHARACTER,
	"\377C*<... Pomy$l# o tym...",
	CHANGE_CHARACTER,
	"Wspaniale. W ka<dym razie...",
	DISPLAY_MESSAGE,
	"To by%a przyjemno$^ z tob@ pracowa^!",
	END_DIALOG,
};

const static char *polishDialog206[] = {
	CHANGE_CHARACTER,
	"Nie musisz mi m*wi^. W%a$nie przeczyta%em",
	NEW_LINE,
	"szczeg*%owy raport.",
	CHANGE_CHARACTER,
	"Ale co sta%o si# z profesorem?",
	CHANGE_CHARACTER,
	"Och, ten biedak znowu zapomnia% formu%y.",
	DISPLAY_MESSAGE,
	"Damy mu najlepsze laboratorium, jakie mo<emy.",
	DISPLAY_MESSAGE,
	"Obecnie mamy tylko tych kilka pigu%ek,",
	NEW_LINE,
	"kt*re nam przekaza%e$.",
	CHANGE_CHARACTER,
	"A Ci@gwa?",
	CHANGE_CHARACTER,
	"Nie b*j si#, jego chciwo$^ zostanie ukarana.",
	DISPLAY_MESSAGE,
	"Mam nadziej#...",
	CHANGE_CHARACTER,
	"Jeszcze tylko drobiazg...",
	DISPLAY_MESSAGE,
	"Obieca% mi pan co$...",
	END_DIALOG,
};

const static char *polishDialog207[] = {
	CHANGE_CHARACTER,
	"Ja?... Nie pami#tam...",
	CHANGE_CHARACTER,
	"Powiedzia% pan, <e zrobi mnie",
	NEW_LINE,
	"oficjalnym agentem...",
	DISPLAY_MESSAGE,
	"\'Dziewczyny kochaj@ si# w agentach\'.",
	NEW_LINE,
	"Pami#ta pan?",
	END_DIALOG,
};

const static char *polishDialog208[] = {
	CHANGE_CHARACTER,
	"(westchnienie)",
	DISPLAY_MESSAGE,
	"Obietnica to obietnica...",
	DISPLAY_MESSAGE,
	"Niech pomy$l#.",
	DISPLAY_MESSAGE,
	"\377W porz@dku. Podejd> tutaj.",
	END_DIALOG,
};

const static char *polishDialog209[] = {
	"W imieniu...",
	DISPLAY_MESSAGE,
	"...ple...ple...ple...",
	NEW_LINE,
	"...ple...ple...",
	DISPLAY_MESSAGE,
	"...dla naszego kraju.",
	END_DIALOG,
};

const static char *polishDialog210[] = {
	"       C*<...       ",
	NEW_LINE,
	"To wszystko, kochani!",
	END_DIALOG,
};

const static char *polishDialog211[] = {
	"Znalaz%em pigu%k# czasu!",
	DISPLAY_MESSAGE,
	"Musia%a wypa$^ ze s%oika!...",
	DISPLAY_MESSAGE,
	"\377Miodzio.",
	END_DIALOG,
};

const static char *polishDialog212[] = {
	"]a%! Uroczo",
	NEW_LINE,
	"tutaj!...",
	END_DIALOG
};

const static char *russianDialog0[] = {
	ANIM_WAIT,
	"Eobq|j efn}.",
	CHANGE_CHARACTER,
	"Ada.",
	CHANGE_CHARACTER,
	"Poxfmt c| hefr} rsoisf?",
	CHANGE_CHARACTER,
	"Eflo c dqacisawii.",
	CHANGE_CHARACTER,
	"Oxfn} rmfyna\200 ytska.",
	DISPLAY_MESSAGE,
	"El\200 roleasa.",
	CHANGE_CHARACTER,
	"` nf roleas, no vosfl",
	NEW_LINE,
	"im rsas}.",
	DISPLAY_MESSAGE,
	"Nf pqoy>l sfrs na tmrs...",
	NEW_LINE,
	"uihpoedosockt.",
	DISPLAY_MESSAGE,
	"Mnf pqikahali poersqflis}",
	NEW_LINE,
	"poebqoyfnnt\177 monfskt c pq|gkf",
	NEW_LINE,
	"r efqfca na loyae}.",
	CHANGE_CHARACTER,
	"Odo, s\200gflocaso.",
	CHANGE_CHARACTER,
	"Rpfwnah - ~so sfbf nf",
	NEW_LINE,
	"vtvq|-mtvq|.",
	CHANGE_CHARACTER,
	"Roxtcrsct\177, xso nf c|ylo.",
	CHANGE_CHARACTER,
	"Ada, pqolfsfl mimo loyaei.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog1[] = {
	"Nt i...",
	DISPLAY_MESSAGE,
	"Xfm rfjxar hanimafsfr}?",
	CHANGE_CHARACTER,
	"Voxfy} rmfynoj oscfs?",
	CHANGE_CHARACTER,
	"Nf tsqtgeajsfr}.",
	CHANGE_CHARACTER,
	"Laeno, no voxt sfbf rkahas},",
	NEW_LINE,
	"sts nf avsi rkol}ko qahclfxfnij.",
	DISPLAY_MESSAGE,
	"L\177bl\177, kodea qahdocoq ytskami nabis.",
	NEW_LINE,
	"Ili na bajs, vf-vf!",
	CHANGE_CHARACTER,
	"Nt konfxno...",
	CHANGE_CHARACTER,
	"` ovqan\200\177 ~so mfrso...",
	CHANGE_CHARACTER,
	"Odo. Kaka\200 nfogieannors}.",
	CHANGE_CHARACTER,
	"I pqirsqfl\177 l\177bodo, kso",
	NEW_LINE,
	"r\177ea rtnfsr\200.",
	CHANGE_CHARACTER,
	"A frli ~so claeflfw?",
	CHANGE_CHARACTER,
	"Sak on gf nf l\177boj, ram ponimafy}.",
	CHANGE_CHARACTER,
	"Polada\177, mfn\200 c| sogf nf ptrsisf?",
	CHANGE_CHARACTER,
	"Soxno.",
	CHANGE_CHARACTER,
	"A frli \200 rkagt \"pogaltjrsa\"?",
	CHANGE_CHARACTER,
	"Nf pqokasis, paqfn>k.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"POGA-A-ALTJRSA.",
	CHANGE_CHARACTER,
	"Habte}.",
	NEW_LINE,
	"T mfn\200 kamfnnof rfqewf.",
	CHANGE_CHARACTER,
	"Kak i mohdi.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Nf pon\200l.",
	CHANGE_CHARACTER,
	"Pqofvali.",
	NEW_LINE,
	"Kak \200 modt rm\200dxis} cayf kamfnnof rfqewf?",
	CHANGE_CHARACTER,
	"Nikak. ` kqfmfn}.",
	DISPLAY_MESSAGE,
	"No poeojei,",
	NEW_LINE,
	"\200 sfb\200 tsfyt...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog2[] = {
	"Rparibo. Xso ~so?",
	CHANGE_CHARACTER,
	"Yokolaena\200 konufsa.",
	DISPLAY_MESSAGE,
	"Moj qabosoeasfl} eal mnf paqoxkt",
	NEW_LINE,
	"na obfe i...",
	CHANGE_CHARACTER,
	"Cay qabosoeasfl} eoma?!",
	CHANGE_CHARACTER,
	"Mirsfq Egon Nosi? Ea, a xso?",
	CHANGE_CHARACTER,
	"O, nixfdo...",
	DISPLAY_MESSAGE,
	"Egon Nosi...",
	DISPLAY_MESSAGE,
	"Kagfsr\200, \200 o n>m rl|yal...",
	CHANGE_CHARACTER,
	"Nacfqn\200ka.",
	NEW_LINE,
	"On eflafs odqomn|f efn}di.",
	DISPLAY_MESSAGE,
	"Orobfnno c porlfenff cqfm\200...",
	CHANGE_CHARACTER,
	"Ea?..",
	CHANGE_CHARACTER,
	"Pqacea, \200 nf hna\177 kak.",
	DISPLAY_MESSAGE,
	"Mogfs, ~so kak-so rc\200hano",
	NEW_LINE,
	"r bfhtmn|m tx>n|m, kosoq|j",
	NEW_LINE,
	"havoeil na en\200v...",
	DISPLAY_MESSAGE,
	"O, etmafy}, s| ram|j tmn|j, ea?!",
	NEW_LINE,
	"S| ypion?!",
	CHANGE_CHARACTER,
	"^j, \200 ob|xn|j paqfn}.",
	DISPLAY_MESSAGE,
	"Nf vosisf docoqis} -",
	NEW_LINE,
	"nf naeo.",
	CHANGE_CHARACTER,
	"Mirsfq Hloefj cflfl mnf",
	NEW_LINE,
	"c|rmasqicas} ypionoc...",
	CHANGE_CHARACTER,
	"Nftgfli \200 povog na ypiona?",
	CHANGE_CHARACTER,
	"...I rsqfl\200s} iv na mfrsf...",
	CHANGE_CHARACTER,
	"^j, polfdxf...",
	CHANGE_CHARACTER,
	"...A \200 o-o-oxfn} eacno",
	NEW_LINE,
	"nikodo nf tbical...",
	CHANGE_CHARACTER,
	"^so ih-ha konufs|, ea?",
	NEW_LINE,
	"Oseas} f>? Nf copqor.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Pqorsi, nfmnodo qahdoq\200xilr\200.",
	CHANGE_CHARACTER,
	"Ponima\177.",
	NEW_LINE,
	"Sts eocol}no gaqko.",
	CHANGE_CHARACTER,
	"Ada.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog3[] = {
	"Mirsfq ovqannik, \200...",
	CHANGE_CHARACTER,
	"Rltyaj, paqfn}.",
	DISPLAY_MESSAGE,
	"Ypion s| ili nfs -",
	NEW_LINE,
	"bfh qahniw|.",
	DISPLAY_MESSAGE,
	"` sfb\200 nf ptzt, i nf cagno, pqiy>l s|",
	NEW_LINE,
	"pqodtl\200s}r\200, xso-nibte} tkqars} ili",
	NEW_LINE,
	"pobolsas} r mirsfqom Nosi.",
	DISPLAY_MESSAGE,
	"I sfbf mfn\200 nf habolsas}.",
	DISPLAY_MESSAGE,
	"Fz> pop|ska, i \200 pqoefla\177 paqt",
	NEW_LINE,
	"noqok el\200 xfqcfj.",
	DISPLAY_MESSAGE,
	"C sco>m sflf.",
	DISPLAY_MESSAGE,
	"Pon\200l?",
	CHANGE_CHARACTER,
	"Pon\200l.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog4[] = {
	"R idoloxki.",
	CHANGE_CHARACTER,
	"Ada.",
	END_DIALOG
};

const static char *russianDialog5[] = {
	CHANGE_CHARACTER,
	"X>qs!",
	DISPLAY_MESSAGE,
	"A, ~so s|!..",
	"\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog6[] = {
	"Pqicfs!",
	CHANGE_CHARACTER,
	"Xso?",
	CHANGE_CHARACTER,
	"Xso c bts|lkf?",
	CHANGE_CHARACTER,
	"S| nixfdo nf eokagfy}!",
	CHANGE_CHARACTER,
	"Xso pokqfpxf, polada\177?..",
	CHANGE_CHARACTER,
	"Nf sco> eflo.",
	CHANGE_CHARACTER,
	"P}>sf na porst, a?",
	CHANGE_CHARACTER,
	"Etmafy}, harstkal mfn\200,",
	NEW_LINE,
	"ea?",
	DISPLAY_MESSAGE,
	"Nf mfxsaj.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog7[] = {
	"Pqicfs!",
	CHANGE_CHARACTER,
	"S| nixfdo nf ciefl.",
	DISPLAY_MESSAGE,
	"` xirs.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog8[] = {
	"Pqicfs!",
	CHANGE_CHARACTER,
	"Rcali.",
	END_DIALOG
};

const static char *russianDialog9[] = {
	"Xso rkagfsf, frli \200 eam cam nfmnodo",
	NEW_LINE,
	"holosa?..",
	CHANGE_CHARACTER,
	"Rkagt rparibo.",
	CHANGE_CHARACTER,
	"A cojsi eaeisf?",
	CHANGE_CHARACTER,
	"Nacfqnof...",
	CHANGE_CHARACTER,
	"Rkagisf soxno.",
	CHANGE_CHARACTER,
	"Laeno, soxno. ` eam sfbf cojsi.",
	CHANGE_CHARACTER,
	"Oslixno. Cos.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog10[] = {
	"Sfpfq} oskqojsf, pogaltjrsa, ecfq}.",
	CHANGE_CHARACTER,
	"Ni ha xso. Tvoei.",
	CHANGE_CHARACTER,
	"^! ` g holoso eal, pomnisf?..",
	CHANGE_CHARACTER,
	"Kakof holoso?",
	CHANGE_CHARACTER,
	"KAKOF HOLOSO?!",
	CHANGE_CHARACTER,
	"Nixfdo nf hna\177 ni o kakom holosf.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog11[] = {
	"C|... C|...",
	CHANGE_CHARACTER,
	"Pqox}.",
	CHANGE_CHARACTER,
	"C| obfzali mfn\200 cptrsis}!",
	DISPLAY_MESSAGE,
	"No qfyili optrsis}!",
	CHANGE_CHARACTER,
	"Haso modt sfb\200 osptrsis}.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog12[] = {
	"N|nxf nfl}h\200 cfqis} eagf",
	NEW_LINE,
	"pqoeagn|m ovqannikam.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog13[] = {
	"Pqicfs.",
	CHANGE_CHARACTER,
	"Pqicfs.",
	CHANGE_CHARACTER,
	"` Maqk.",
	DISPLAY_MESSAGE,
	"Kak sfb\200 hocts?",
	CHANGE_CHARACTER,
	"Kak mfn\200 hocts?",
	CHANGE_CHARACTER,
	"Nf hna\177, s| rkagi mnf.",
	CHANGE_CHARACTER,
	"Mnf.",
	CHANGE_CHARACTER,
	"Nf docoqi mnf \"mnf\", pqorso rkagi",
	NEW_LINE,
	"rco> im\200!",
	CHANGE_CHARACTER,
	"Rco> i...",
	CHANGE_CHARACTER,
	"Ut s|!",
	DISPLAY_MESSAGE,
	"Kak sfb\200 hoc>s osfw?",
	CHANGE_CHARACTER,
	"R|na.",
	CHANGE_CHARACTER,
	"R|na c rm|rlf im\200 ili r|na",
	NEW_LINE,
	"c rm|rlf r|n?",
	CHANGE_CHARACTER,
	"R|na.",
	CHANGE_CHARACTER,
	"S| etqak ili pqiscoq\200fy}r\200?",
	CHANGE_CHARACTER,
	"` R|na.",
	CHANGE_CHARACTER,
	"(cheov)",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog14[] = {
	"Rl|y}, R|na ili kak sam sfb\200.",
	DISPLAY_MESSAGE,
	"Xso s| eflafy}",
	NEW_LINE,
	"r ~sim m\200xom?",
	CHANGE_CHARACTER,
	"Efetyka rkahal, xso rcoeis mfn\200 c hoopaqk,",
	NEW_LINE,
	"frli \200 popaet c koqhint.",
	CHANGE_CHARACTER,
	"Etma\177, sfbf ntgno poebqar|cas} m\200x",
	NEW_LINE,
	"nfmnodo c|yf.",
	CHANGE_CHARACTER,
	"Ram hna\177.",
	CHANGE_CHARACTER,
	"Nt i?",
	CHANGE_CHARACTER,
	"Nt i xso?",
	CHANGE_CHARACTER,
	"Nt i poxfmt s| sak nf eflafy}?!",
	CHANGE_CHARACTER,
	"Nacfqnof, ro hqfnifm",
	NEW_LINE,
	"xso-so.",
	CHANGE_CHARACTER,
	"S| oxki noriy}?",
	CHANGE_CHARACTER,
	"Nfs, haxfm?",
	CHANGE_CHARACTER,
	"(cheov)",
	DISPLAY_MESSAGE,
	"Mogfs, s| pqorso rlabocas, xsob",
	NEW_LINE,
	"eobqoris} m\200x poc|yf?",
	CHANGE_CHARACTER,
	"Nf pqikal|cajr\200.",
	CHANGE_CHARACTER,
	"(cheov)",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog15[] = {
	"^, pawan!",
	DISPLAY_MESSAGE,
	"Frs} klarrna\200 ief\200!",
	CHANGE_CHARACTER,
	"Ea?",
	CHANGE_CHARACTER,
	"Iei rkagi,",
	NEW_LINE,
	"xso popal c koqhint!",
	CHANGE_CHARACTER,
	"So frs} rocqas}?",
	CHANGE_CHARACTER,
	"Sipa sodo...",
	CHANGE_CHARACTER,
	"` NIKODEA NF CQT!",
	CHANGE_CHARACTER,
	"Nikodea?!",
	CHANGE_CHARACTER,
	"NIKODEA!",
	CHANGE_CHARACTER,
	"Voqoyij mal}xik.",
	END_DIALOG
};

const static char *russianDialog16[] = {
	"Pqicfs...",
	CHANGE_CHARACTER,
	"Tjei.",
	END_DIALOG
};

const static char *russianDialog17[] = {
	"^j, paqfn}! Pqorso nfcfqo\200sno!",
	CHANGE_CHARACTER,
	"Xso?",
	CHANGE_CHARACTER,
	"^so mogfs pokahas}r\200 ytskoj,",
	NEW_LINE,
	"no ih ohfqa po\200cilar}",
	NEW_LINE,
	"qtka, rgima\177za\200 mfx!",
	CHANGE_CHARACTER,
	"Laeno, \200 chdl\200nt, no nf etmaj,",
	NEW_LINE,
	"xso oetqaxil mfn\200.",
	NEW_LINE,
	"^sa qtka kage|j doe po\200cl\200fsr\200.",
	DISPLAY_MESSAGE,
	"Mogfs, vos} c ~sos qah",
	NEW_LINE,
	"pocfh>s...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog18[] = {
	"Eobq|j efn}, r~q!",
	CHANGE_CHARACTER,
	"I sfbf eobq|j,",
	NEW_LINE,
	"r|nok.",
	CHANGE_CHARACTER,
	"Mfn\200 hocts Maqk, r~q.",
	CHANGE_CHARACTER,
	"Heoqoco.",
	DISPLAY_MESSAGE,
	"Xfdo s| voxfy}?",
	CHANGE_CHARACTER,
	"Pqorso l\177bt\177r} cayim kqfrlom.",
	DISPLAY_MESSAGE,
	"Voqoyff.",
	CHANGE_CHARACTER,
	"Voqoyff i cfr}ma",
	NEW_LINE,
	"teobnof.",
	CHANGE_CHARACTER,
	"I bol}yof.",
	CHANGE_CHARACTER,
	"Ectvmfrsnof.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog19[] = {
	"Hnafsf paqn\200, idqa\177zfdo",
	NEW_LINE,
	"r m\200xom",
	NEW_LINE,
	"na tliwf?",
	CHANGE_CHARACTER,
	"Konfxno, ~so",
	NEW_LINE,
	"moj cntk.",
	CHANGE_CHARACTER,
	"Voqoyij paqfn>k.",
	CHANGE_CHARACTER,
	"Voqoyij i tmn|j.",
	CHANGE_CHARACTER,
	"Voqoyij i malfn}kij.",
	CHANGE_CHARACTER,
	"On poeqars>s.",
	CHANGE_CHARACTER,
	"I rsanfs ram|m",
	NEW_LINE,
	"hnamfnis|m",
	NEW_LINE,
	"barkfsbolirsom?..",
	CHANGE_CHARACTER,
	"Naef\177r}, nfs.",
	CHANGE_CHARACTER,
	"Sodea rkagisf fmt, xso vcasis idqas}!",
	CHANGE_CHARACTER,
	"Ea.",
	DISPLAY_MESSAGE,
	"Pohgf.",
	DISPLAY_MESSAGE,
	"Cohmogno.",
	DISPLAY_MESSAGE,
	"Rfjxar \200 voxt",
	NEW_LINE,
	"oseovnts}.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog20[] = {
	"C| robiqafsfr} riefs} hefr}",
	NEW_LINE,
	"cfr} efn}?",
	CHANGE_CHARACTER,
	"Vosflor} b|.",
	CHANGE_CHARACTER,
	"Cfr} ~sos hamfxasfl}n|j efn}?",
	CHANGE_CHARACTER,
	"Vosflor} b|.",
	CHANGE_CHARACTER,
	"Cam nf insfqfrfn",
	NEW_LINE,
	"okqtga\177zij miq?!",
	CHANGE_CHARACTER,
	"Nf oxfn}.",
	CHANGE_CHARACTER,
	"Poxfmt sak?",
	CHANGE_CHARACTER,
	"Mnf nf insfqfrn|",
	NEW_LINE,
	"nocorsi.",
	CHANGE_CHARACTER,
	"No...",
	CHANGE_CHARACTER,
	"Kak docoqisr\200...",
	DISPLAY_MESSAGE,
	"Ltxyif nocorsi -",
	NEW_LINE,
	"iv osrtsrscif.",
	CHANGE_CHARACTER,
	"No l\177ei eolgn| hnas} o",
	NEW_LINE,
	"pqodqfrrf i pqoxfm!",
	CHANGE_CHARACTER,
	"Eagf nf rsant",
	NEW_LINE,
	"rpqayicas} poxfmt...",
	CHANGE_CHARACTER,
	"Posomt xso...",
	DISPLAY_MESSAGE,
	"^...",
	DISPLAY_MESSAGE,
	"Posomt xso...",
	DISPLAY_MESSAGE,
	"^m...",
	CHANGE_CHARACTER,
	"Cfqno.",
	NEW_LINE,
"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog21[] = {
	"Kakif nocorsi?",
	CHANGE_CHARACTER,
	"Nikakiv.",
	END_DIALOG
};

const static char *russianDialog22[] = {
	"Mogno ch\200s} ~so qtg}>?",
	CHANGE_CHARACTER,
	"Nfs.",
	CHANGE_CHARACTER,
	"Poga-a-altjrsa...",
	CHANGE_CHARACTER,
	"Moloeoj xflocfk, ~so oxfn}",
	NEW_LINE,
	"rsaqof i oparnof oqtgif...",
	DISPLAY_MESSAGE,
	"...a \200 oscfsrscfnn|j xflocfk,",
	NEW_LINE,
	"\200rno?",
	CHANGE_CHARACTER,
	"No \200...",
	CHANGE_CHARACTER,
	"Nfs.",
	END_DIALOG
};

const static char *russianDialog23[] = {
	"Mogfs, pfqfetmafsf",
	NEW_LINE,
	"narx>s qtg}\200?...",
	CHANGE_CHARACTER,
	"Nfs.",
	DISPLAY_MESSAGE,
	"Not.",
	DISPLAY_MESSAGE,
	"Najn.",
	DISPLAY_MESSAGE,
	"No.",
	DISPLAY_MESSAGE,
	"Naj.",
	DISPLAY_MESSAGE,
	"Nf.",
	DISPLAY_MESSAGE,
	"Ni.",
	CHANGE_CHARACTER,
	"Laeno, \200 pon\200l.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog24[] = {
	"Mogno pokopas}r\200 c cayiv ykauxikav?",
	CHANGE_CHARACTER,
	"Ea.",
	CHANGE_CHARACTER,
	"EA?!",
	CHANGE_CHARACTER,
	"O, hab|l tsoxnis}, xso oni",
	NEW_LINE,
	"ptrs|f.",
	DISPLAY_MESSAGE,
	"Sol}ko norocoj plasok c",
	NEW_LINE,
	"cfqvnfm pqacom.",
	DISPLAY_MESSAGE,
	"Mogfy} ch\200s}, frli voxfy}, mnf on nf ntgfn.",
	CHANGE_CHARACTER,
	"Laeno, rparibo.",
	DISPLAY_MESSAGE,
	"C| oxfn}... eobq|...",
	CHANGE_CHARACTER,
	"Sol}ko nf poetmaj, xso \200 pohcol\177 pqikaqmanis}",
	NEW_LINE,
	"xso-nibte} fz>.",
	CHANGE_CHARACTER,
	"Konfxno, i c m|rl\200v nf b|lo.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog25[] = {
	"` coh}mt cfsqoetj?",
	CHANGE_CHARACTER,
	"Ni ha xso. R nim gaqa rfdoen\200",
	NEW_LINE,
	"xtska sfqpimff.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog26[] = {
	"Narx>s cfsqoet\200...",
	CHANGE_CHARACTER,
	"Pqivoei himoj.",
	"\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog27[] = {
	"Voqoya\200 rfdoen\200",
	NEW_LINE,
	"podoeka...",
	CHANGE_CHARACTER,
	"Rodlarna,",
	NEW_LINE,
	"eoqodtya.",
	"\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog28[] = {
	"^so caya eox}?",
	CHANGE_CHARACTER,
	"Rparibo,",
	NEW_LINE,
	"pohcolil mnf rnoca oztsis}",
	NEW_LINE,
	"rfb\200 moloeoj..",
	DISPLAY_MESSAGE,
	"...no, ramo roboj,",
	NEW_LINE,
	"~sa qaeors} -",
	NEW_LINE,
	"mo\200 cntxka.",
	CHANGE_CHARACTER,
	"O, soxno! I kak gf \200",
	NEW_LINE,
	"nf eodaealr\200!",
	CHANGE_CHARACTER,
	"Kodea-so i \200 b|la",
	NEW_LINE,
	"sakoj gf...",
	CHANGE_CHARACTER,
	"C| i rfjxar saka\200!",
	CHANGE_CHARACTER,
	"O, kak milo r scofj rsoqon|...",
	DISPLAY_MESSAGE,
	"Nikso bol}yf",
	NEW_LINE,
	"nf po>s",
	NEW_LINE,
	"mnf poe oknom.",
	DISPLAY_MESSAGE,
	"Frli ponimafy},",
	NEW_LINE,
	"o x>m \200.",
	CHANGE_CHARACTER,
	"^-~-~...",
	DISPLAY_MESSAGE,
	"Ea...",
	DISPLAY_MESSAGE,
	"Ponima\177...",
	DISPLAY_MESSAGE,
	"T mfn\200 sf gf",
	NEW_LINE,
	"xtcrsca...",
	DISPLAY_MESSAGE,
	"Inodea...",
	DISPLAY_MESSAGE,
	"Nacfqnof...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog29[] = {
	"Modt \200 rpqoris}, xfm c|",
	NEW_LINE,
	"hanimafsfr}?",
	CHANGE_CHARACTER,
	"Ea, mogfy},",
	NEW_LINE,
	"eoqodtya.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Xfm c| hanimafsfr}?",
	CHANGE_CHARACTER,
	"` c\200gt.",
	CHANGE_CHARACTER,
	"^so pon\200sno.",
	DISPLAY_MESSAGE,
	"Xso c| c\200gfsf?",
	CHANGE_CHARACTER,
	"A rfjxar s|",
	NEW_LINE,
	"nf rpqoril,",
	NEW_LINE,
	"mogno li rpqoris}.",
	CHANGE_CHARACTER,
	"Oj, pqorsisf. Modt \200 rpqoris}?",
	CHANGE_CHARACTER,
	"O x>m?",
	CHANGE_CHARACTER,
	"O som, xso c|",
	NEW_LINE,
	"c\200gfsf.",
	CHANGE_CHARACTER,
	"S| tgf rpqayical",
	NEW_LINE,
	"mfn\200 ob ~som,",
	NEW_LINE,
	"qahcf nfs?",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog30[] = {
	"Cr> voqoyo?",
	CHANGE_CHARACTER,
	"Ea, cpolnf.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog31[] = {
	"Cr> voqoyo?",
	CHANGE_CHARACTER,
	"S| ram hnafy}.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog32[] = {
	"Cr> voqoyo?",
	CHANGE_CHARACTER,
	"Rparibo, xso rpqorili,",
	NEW_LINE,
	"no \200 tgf cam",
	NEW_LINE,
	"oscfxala.",
	"\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog33[] = {
	"Cr> voqoyo?",
	CHANGE_CHARACTER,
	"Nf",
	NEW_LINE,
	"pocsoq\200jr\200.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog34[] = {
	"Cr> voqoyo?",
	CHANGE_CHARACTER,
	"Nf osclfkaj",
	NEW_LINE,
	"mfn\200.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog35[] = {
	"Cr> voqoyo?",
	CHANGE_CHARACTER,
	"Ea hamolxi tgf.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog36[] = {
	"Cr> voqoyo?",
	"\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog37[] = {
	"Pqorsisf",
	NEW_LINE,
	"mo\177 nadlors}...",
	CHANGE_CHARACTER,
	"Ea?..",
	CHANGE_CHARACTER,
	"...no \200 poetmal,",
	NEW_LINE,
	"xso ~sos nfcinn|j",
	NEW_LINE,
	"wcfsok...",
	DISPLAY_MESSAGE,
	"...c|qahis,",
	NEW_LINE,
	"narkol}ko \200 qae",
	NEW_LINE,
	"nayfj crsqfxf.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog38[] = {
	"Naef\177r},",
	NEW_LINE,
	"on cam ponqacisr\200...",
	CHANGE_CHARACTER,
	"O, pqflfrs}!",
	DISPLAY_MESSAGE,
	"` oxfn}",
	NEW_LINE,
	"sqontsa...",
	DISPLAY_MESSAGE,
	"Mnf nikso",
	NEW_LINE,
	"nf eflal",
	NEW_LINE,
	"sak pqi\200sno...",
	DISPLAY_MESSAGE,
	"...cos tgf",
	NEW_LINE,
	"efr\200s} lfs!",
	DISPLAY_MESSAGE,
	"Rparibo",
	NEW_LINE,
	"os crfj etyi!",
	CHANGE_CHARACTER,
	"Pogaltjrsa.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog39[] = {
	"Nf vosisf fz> oein",
	NEW_LINE,
	"wcfsok?",
	CHANGE_CHARACTER,
	"S| oxfn} eobq,",
	NEW_LINE,
	"moj mal}xik, no nfs,",
	NEW_LINE,
	"rparibo.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog40[] = {
	"Tcfqfn|, xso nf vosisf",
	NEW_LINE,
	"fz> wcfsok?",
	CHANGE_CHARACTER,
	"Ea, tcfqfna.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog41[] = {
	"Modt \200 oeolgis}",
	NEW_LINE,
	"mfs>lkt?",
	CHANGE_CHARACTER,
	"M| nfeorsasoxno voqoyo",
	NEW_LINE,
	"hnakom|, k somt gf",
	NEW_LINE,
	"\200 nf...",
	DISPLAY_MESSAGE,
	"...oealgica\177 cfzi",
	NEW_LINE,
	"crfm,",
	NEW_LINE,
	"kso popqoris.",
	CHANGE_CHARACTER,
	"` nf c|h|ca\177 eocfqi\200?",
	CHANGE_CHARACTER,
	"Qahdocoq okonxfn.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog42[] = {
	"Frs} yanr cr> gf",
	NEW_LINE,
	"oeolgis} mfs>lkt?",
	CHANGE_CHARACTER,
	"Mnf nqacisr\200, kak ona lfgis.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog43[] = {
	"A sfpfq} c|",
	NEW_LINE,
	"mnf mfs>lkt",
	NEW_LINE,
	"nf oeolgisf?",
	CHANGE_CHARACTER,
	"Konfxno, poxfmt",
	NEW_LINE,
	"b| i nf...",
	DISPLAY_MESSAGE,
	"...pomox} sakomt milomt",
	NEW_LINE,
	"\177noyf, kak s|!..",
	CHANGE_CHARACTER,
	"Bol}yof rparibo.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog44[] = {
	"Va! ` eagf b|rsqff Inei!",
	CHANGE_CHARACTER,
	"` cr> ciefla, mal}xik!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog45[] = {
	"^-~-~...",
	DISPLAY_MESSAGE,
	"M-m-m...",
	DISPLAY_MESSAGE,
	"`...",
	CHANGE_CHARACTER,
	"Trpokojr\200. Naef\177r}, s| tbil",
	NEW_LINE,
	"~st mtvt.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog46[] = {
	"Pqorsisf, lfei, mnf kagfsr\200, xso cayf",
	NEW_LINE,
	"bfl}> tgf c|rovlo...",
	DISPLAY_MESSAGE,
	"...i na sakom rolnwf b|rsqo",
	NEW_LINE,
	"c|wcfsfs...",
	CHANGE_CHARACTER,
	"Kak bfl}> modlo c|rovnts}",
	NEW_LINE,
	"sak b|rsqo?",
	DISPLAY_MESSAGE,
	"Ltxyf rvogt pqocfq\177.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog47[] = {
	CHANGE_CHARACTER,
	"C| b|li pqac|, moloeoj xflocfk.",
	DISPLAY_MESSAGE,
	"Rparibo.",
	CHANGE_CHARACTER,
	"Nf ha xso.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog48[] = {
	"Cam ntgno ~so corkocof \200bloko?",
	CHANGE_CHARACTER,
	"Kak rkahas}. T nfdo",
	NEW_LINE,
	"rco\200 irsoqi\200.",
	DISPLAY_MESSAGE,
	"Pomn\177, oenage|",
	NEW_LINE,
	"mo\200 mlaeya\200 rfrsqa M~qi",
	NEW_LINE,
	"hanimalar}...",
	CHANGE_CHARACTER,
	"A narkol}ko irsoqi\200 elinna\200?",
	CHANGE_CHARACTER,
	"O, nam nfktea rpfyis}.",
	DISPLAY_MESSAGE,
	"T nar gf rsol}ko cqfmfni,",
	NEW_LINE,
	"xsob| pobolsas}, cfqno?",
	CHANGE_CHARACTER,
	"` sol}ko xso pon\200l, mnf nf ntgno",
	NEW_LINE,
	"\200bloko.",
	DISPLAY_MESSAGE,
	"Rparibo.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog49[] = {
	"`bloko...",
	CHANGE_CHARACTER,
	"Bfh irsoqii nfs \200bloka.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Nf ntgno.",
	END_DIALOG
};

const static char *russianDialog50[] = {
	"Nftgfli crsqfsil...",
	DISPLAY_MESSAGE,
	"...ramt\177 kqarict\177 efctykt...",
	DISPLAY_MESSAGE,
	"...c miqf?..",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog51[] = {
	"Etma\177, pqiylo cqfm\200",
	NEW_LINE,
	"pqfersacis}r\200.",
	DISPLAY_MESSAGE,
	"` Maqk.",
	CHANGE_CHARACTER,
	"Anna.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog52[] = {
	"Sos momfns, kodea \200 tciefl f> dlaha,",
	NEW_LINE,
	"rsal ltxyim",
	NEW_LINE,
	"c mofj gihni.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Nf rxisa\200 sodo, kak \200",
	NEW_LINE,
	"idqal c eoksoqa",
	NEW_LINE,
	"r R}\177hi.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog53[] = {
	"^m...",
	DISPLAY_MESSAGE,
	"Mnf...",
	DISPLAY_MESSAGE,
	"`...",
	DISPLAY_MESSAGE,
	"` sts poetmal,",
	NEW_LINE,
	"nf voxfy}",
	NEW_LINE,
	"kof-xfdo...",
	DISPLAY_MESSAGE,
	"^m...",
	DISPLAY_MESSAGE,
	"C rm|rlf...",
	DISPLAY_MESSAGE,
	"T mfn\200 kof-xso frs},",
	NEW_LINE,
	"i \200 vosfl b| eas}",
	NEW_LINE,
	"~so sfbf, posomt xso...",
	DISPLAY_MESSAGE,
	"^-~...",
	DISPLAY_MESSAGE,
	"` etma\177,",
	NEW_LINE,
	"s|... i...",
	CHANGE_CHARACTER,
	"^j! ` nf ktra\177r}!",
	DISPLAY_MESSAGE,
	"Cigt, s| p|safy}r\200 rkahas} mnf",
	NEW_LINE,
	"xso-so pqi\200snof.",
	DISPLAY_MESSAGE,
	"Docoqi pqors|mi",
	NEW_LINE,
	"rlocami...",
	CHANGE_CHARACTER,
	"Pqors|mi rlocami?!",
	CHANGE_CHARACTER,
	"Ea, pqors|f rloca",
	NEW_LINE,
	"cr> tpqoza\177s.",
	CHANGE_CHARACTER,
	"Nt ea.",
	DISPLAY_MESSAGE,
	"Soxno.",
	DISPLAY_MESSAGE,
	"Pqors|f rloca.",
	DISPLAY_MESSAGE,
	"Laeno.",
	DISPLAY_MESSAGE,
	"Naxal.",
	DISPLAY_MESSAGE,
	"` nqaciy}r\200 s|,",
	NEW_LINE,
	"i voxt eas} wcfsok.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Cohmogno, sfbf rsois",
	NEW_LINE,
	"docoqis}...",
	DISPLAY_MESSAGE,
	"...nfrkol}ko rlognff.",
	CHANGE_CHARACTER,
	"Ov...",
	DISPLAY_MESSAGE,
	"Pqorsi...",
	DISPLAY_MESSAGE,
	"Pqorso \200...",
	DISPLAY_MESSAGE,
	"Pqorso \200 pqin>r sfbf",
	NEW_LINE,
	"wcfsok.",
	CHANGE_CHARACTER,
	"O?..",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog54[] = {
	"Nqacisr\200?",
	CHANGE_CHARACTER,
	"S| ramo oxaqocanif.",
	"\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog55[] = {
	"Coobzf,",
	NEW_LINE,
	"xfrsno docoq\200...",
	CHANGE_CHARACTER,
	"Pqors|f rloca, pomni!",
	NEW_LINE,
	"Pqors|f!",
	END_DIALOG
};

const static char *russianDialog56[] = {
	"Soxno...",
	DISPLAY_MESSAGE,
	"Pqorso vosfl rkahas},",
	NEW_LINE,
	"xso s| sogf",
	NEW_LINE,
	"oxaqocasfl}na\200.",
	CHANGE_CHARACTER,
	"Nt, rparibo,",
	NEW_LINE,
	"nacfqnof.",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog57[] = {
	"Nfnacigt rfb\200.",
	END_DIALOG
};

const static char *russianDialog58[] = {
	"T mfn\200 frs}",
	NEW_LINE,
	"fz> wcfsok...",
	CHANGE_CHARACTER,
	"O, ~so tgf",
	NEW_LINE,
	"liynff.",
	DISPLAY_MESSAGE,
	"Kak cieiy},",
	NEW_LINE,
	"\200 hefr}...",
	DISPLAY_MESSAGE,
	"...nf feinrscfnna\200 gfnzina...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog59[] = {
	"Hnaxis, nf voxfy} fz>",
	NEW_LINE,
	"wcfsoxfk?",
	CHANGE_CHARACTER,
	"Nfs, rparibo.",
	"\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog60[] = {
	"Voxfy} konufskt?",
	CHANGE_CHARACTER,
	"Oxfn} milo, no nfs, rparibo.",
	NEW_LINE,
	"Nf voxt qarsolrsfs}.",
	CHANGE_CHARACTER,
	"^j, nf pfqfgicaj. Eagf t Obflikra",
	NEW_LINE,
	"b|li eqth}\200.",
	CHANGE_CHARACTER,
	"Kso sakoj Obflikr?!",
	CHANGE_CHARACTER,
	"M-m, habte}. Pqorso \200 nay>l",
	NEW_LINE,
	"konufst...",
	CHANGE_CHARACTER,
	"NAY<L?!",
	CHANGE_CHARACTER,
	"Nay>l f> oxfn} cktrnoj,",
	NEW_LINE,
	"qahtmffsr\200.",
	DISPLAY_MESSAGE,
	"^so nf kakoj-so efy>c|j yokolaeohamfnisfl},",
	NEW_LINE,
	"a pqoetks c|ryfdo kaxfrsca!",
	DISPLAY_MESSAGE,
	"Ihdosoclfn sol}ko ih",
	NEW_LINE,
	"nastqal}n|v komponfnsoc.",
	DISPLAY_MESSAGE,
	"Bfh konrfqcansoc.",
	CHANGE_CHARACTER,
	"O, laeno. Frli narsaicafy}...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog61[] = {
	ANIM_WAIT,
	"Kvm...",
	CHANGE_CHARACTER,
	"A, nt ea, polada\177, naeo eas} sfbf",
	NEW_LINE,
	"xso-nibte} chamfn...",
	CHANGE_CHARACTER,
	"Nfs-nfs... Cocrf",
	NEW_LINE,
	"nf ob\200hasfl}no...",
	CHANGE_CHARACTER,
	"Laeno, kak voxfy}.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Vos\200 r eqtdoj rsoqon|...",
	CHANGE_CHARACTER,
	"` sak i hnala. Paqni crfdea xfdo-so",
	NEW_LINE,
	"vos\200s.",
	DISPLAY_MESSAGE,
	"Nixfdo nf efla\177s",
	NEW_LINE,
	"pqorso sak.",
	CHANGE_CHARACTER,
	"Oenage| \200 tbqalr\200 c komnasf.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Ada...",
	DISPLAY_MESSAGE,
	"Laeno, hab|li.",
	DISPLAY_MESSAGE,
	"Cos sfbf moj",
	NEW_LINE,
	"poeaqok.",
	DISPLAY_MESSAGE,
	"^so mo\200 lfnsa. Inodea",
	NEW_LINE,
	"crpominaj obo mnf.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog62[] = {
	"Parib. Crfdea btet",
	NEW_LINE,
	"noris}.",
	"\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog63[] = {
	"` nay>l sco> im\200 na banknosf,",
	NEW_LINE,
	"kosoqt\177 mnf eal oein solrs\200k.",
	NEW_LINE,
	"Xso rkagfy}?",
	CHANGE_CHARACTER,
	"Pokagi mnf banknost.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog64[] = {
	"^j, c x>m eflo?!",
	CHANGE_CHARACTER,
	"O, doqf mnf!..",
	CHANGE_CHARACTER,
	"Poxfmt s| plaxfy}?!",
	CHANGE_CHARACTER,
	"Poso... posomt...",
	DISPLAY_MESSAGE,
	"O, doqf mnf!..",
	DISPLAY_MESSAGE,
	"Nay... nay rorfe, mirsfq",
	NEW_LINE,
	"Egon Nosi, oenage| eal mnf",
	NEW_LINE,
	"nfmnodo efnfd...",
	DISPLAY_MESSAGE,
	"...i rkahal, xso frli",
	NEW_LINE,
	"\200 fdo powflt\177,",
	NEW_LINE,
	"so on ears mnf fz>...",
	DISPLAY_MESSAGE,
	"...no \200 oskahalar}",
	NEW_LINE,
	"i cfqntla fmt",
	NEW_LINE,
	"crf efn}di obqasno.",
	CHANGE_CHARACTER,
	"So frs} ~sa rcin}\200 p|salar}",
	NEW_LINE,
	"ktpis} sfb\200?!",
	CHANGE_CHARACTER,
	"` sak nfrxarsna!",
	CHANGE_CHARACTER,
	"Cos blin!",
	NEW_LINE,
	"Nt cr>!",
	"\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog65[] = {
	"^j s|!",
	DISPLAY_MESSAGE,
	"Nf btefy} sak eobqa pfqfeas} mnf",
	NEW_LINE,
	"con sos oqfv?",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog66[] = {
	"Sak s| eay} mnf oqfv ili nfs?!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog67[] = {
	"Laeno.",
	DISPLAY_MESSAGE,
	"Cr> \200rno.",
	DISPLAY_MESSAGE,
	"Rfjxar s| poltxiy} po harltdam.",
	DISPLAY_MESSAGE,
	"Btet obh|cas} sfb\200, poka nf poltxt oqfv.",
	DISPLAY_MESSAGE,
	"Mfqhka\200 bflka.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog68[] = {
	"Qahcf s| nf hnafy}, xso noris} mfv",
	NEW_LINE,
	"nfpoliskoqqfksno, a?",
	"\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog69[] = {
	"^j, fz> qah rparibo ha oqfv!",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog70[] = {
	"` nf rpqoril na ~so qahqfyfni\200.",
	DISPLAY_MESSAGE,
	"Oxfn} plovo bqas} xtgt\177 cfz}",
	NEW_LINE,
	"bfh qahqfyfni\200.",
	DISPLAY_MESSAGE,
	"Mfn\200 modts pojmas} ha",
	NEW_LINE,
	"~sim eflom.",
	DISPLAY_MESSAGE,
	"I bqoris} c s\177q\200dt. Sodea crf",
	NEW_LINE,
	"pfqfrsants mfn\200 tcagas}.",
	DISPLAY_MESSAGE,
	"^sim porstpkom \200 modt tdqobis} rco\177 gihn}.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog71[] = {
	"Bfh qirka...",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog72[] = {
	"Sak, qfb\200sa. Eqtgno crf",
	NEW_LINE,
	"irxfhli osr\177ea!",
	DISPLAY_MESSAGE,
	"Ili mnf pqie>sr\200 rsqfl\200s}.",
	DISPLAY_MESSAGE,
	"Ih narso\200zfdo oqtgi\200.",
	DISPLAY_MESSAGE,
	"Nacfqnof.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog73[] = {
	"` cigt...",
	DISPLAY_MESSAGE,
	"...sam...",
	DISPLAY_MESSAGE,
	"PATKA!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog74[] = {
	"Nf so xsob| \200 bo\177r}.",
	DISPLAY_MESSAGE,
	"Pqorso ~so mogfs okahas}r\200",
	NEW_LINE,
	"patk-mtsans, i frli on mfn\200",
	NEW_LINE,
	"tktris...",
	DISPLAY_MESSAGE,
	"...\200 sogf mtsiqt\177...",
	DISPLAY_MESSAGE,
	"...mnf pqie>sr\200 noris} habacn|f",
	NEW_LINE,
	"kors\177m| i pqoxt\177 miytqt...",
	DISPLAY_MESSAGE,
	"...cfrsi ecojnt\177 gihn}...",
	DISPLAY_MESSAGE,
	"...rqagas}r\200 r Cfnomom i eqtdimi,",
	NEW_LINE,
	"oni mfn\200 qanis} modts...",
	DISPLAY_MESSAGE,
	"...crf btets na mnf",
	NEW_LINE,
	"haqabas|cas}, a \200...",
	DISPLAY_MESSAGE,
	"Etma\177, \200 par.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog75[] = {
	"Os ~sodo patka pqorso gtsko...",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog76[] = {
	"^j, eqtgok!",
	DISPLAY_MESSAGE,
	"T mfn\200 k sfbf xfrsnof pqfelogfnif.",
	DISPLAY_MESSAGE,
	"Bol}yof, rcfgff, roxnof \200bloko ha rsaqt\177 yiykt",
	NEW_LINE,
	"t sfb\200 na rpinf.",
	DISPLAY_MESSAGE,
	"Frli rodlarfn, so crsan} i",
	NEW_LINE,
	"posq\200ri moqeoxkoj.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog77[] = {
	"Naeo b|lo eodaeas}r\200,",
	NEW_LINE,
	"xso ~so qahcoe.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Cfrlo rlomano.",
	"\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog78[] = {
	"Pqicfs, eqtgok.",
	"\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog79[] = {
	"Nt pormosqi gf na mfn\200.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog80[] = {
	"Hnafy}, \200 trsal kak robaka",
	NEW_LINE,
	"bolsas} r soboj.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog81[] = {
	"Kak efla?",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog82[] = {
	"Ea, \200 mod b| fdo ch\200s}...",
	DISPLAY_MESSAGE,
	"Siva\200 efqfcfn}ka...",
	DISPLAY_MESSAGE,
	"Nikakoj poliwii...",
	DISPLAY_MESSAGE,
	"Nikso nf trl|yis iv kqiki...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"No t mfn\200 nfs vokkfjnoj marki.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"(cheov)",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog83[] = {
	"Nf voxt orsacl\200s} rcoi ospfxaski.",
	DISPLAY_MESSAGE,
	"Kso hnafs, xso im eflali.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog84[] = {
	"Bo\177r}, sak",
	NEW_LINE,
	"pojmas} m|ykt",
	NEW_LINE,
	"rliykom rlogno.",
	DISPLAY_MESSAGE,
	"I kakoj pqok c napqarn|v trili\200v?",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog85[] = {
	"` b| pop|salr\200 pqodnas} psiw,",
	NEW_LINE,
	"frli b| c p\200s} lfs nf pormosqfl",
	NEW_LINE,
	"sos uil}m Vixkoka.",
	DISPLAY_MESSAGE,
	"Hq\200 mama mnf ~so pohcolila.",
	DISPLAY_MESSAGE,
	"Mnf sfpfq} eagf \200jwa frs} rsqayno.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog86[] = {
	"Heoqoco. Naeo pon\200s} nam>k.",
	DISPLAY_MESSAGE,
	"\"Holoso ogieafs c konwf eoqodi\".",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog87[] = {
	"C| mirsfq Egon Nosi?",
	CHANGE_CHARACTER,
	"Kak pogicafy}, eqtd moj?",
	DISPLAY_MESSAGE,
	"Moi l\177ei rkahali, xso s| p|salr\200",
	NEW_LINE,
	"pqoniknts} c orobn\200k.",
	NEW_LINE,
	"Haxfm?",
	CHANGE_CHARACTER,
	"`... Ponimafsf...",
	DISPLAY_MESSAGE,
	"` sts,",
	NEW_LINE,
	"xsob|...",
	DISPLAY_MESSAGE,
	"C rm|rlf, \200 sts na kaniktlav,",
	NEW_LINE,
	"no mfn\200 tgf soynis os hflfni",
	NEW_LINE,
	"i efqfc}fc...",
	DISPLAY_MESSAGE,
	"...i mnf havosflor} cktris} nfmnodo",
	NEW_LINE,
	"wicilihawii.",
	CHANGE_CHARACTER,
	"Nt xso gf... ` ponima\177 sfb\200,",
	NEW_LINE,
	"\177n|j eqtd.",
	DISPLAY_MESSAGE,
	"Mnf sogf kagfsr\200, xso",
	NEW_LINE,
	"frsfrscfnna\200 rqfea el\200 nar,",
	NEW_LINE,
	"l\177efj 20-do cfka...",
	DISPLAY_MESSAGE,
	"...sflfcihoq i popkoqn.",
	NEW_LINE,
	"No k rloct o",
	NEW_LINE,
	"hflfni...",
	DISPLAY_MESSAGE,
	"` nf modt ptrsis} sfb\200",
	NEW_LINE,
	"c eom, posomt xso... ~m...",
	NEW_LINE,
	"posomt xso c n>m... ie>s...",
	DISPLAY_MESSAGE,
	"...qfmons, no kak rorso\200sfl}n|j",
	NEW_LINE,
	"xflocfk \200 eam sfbf",
	NEW_LINE,
	"rso bakroc...",
	DISPLAY_MESSAGE,
	"...mogfy} ktpis}",
	NEW_LINE,
	"xso-nibte}, xso pomogfs",
	NEW_LINE,
	"sfbf hefr} c|gis}.",
	DISPLAY_MESSAGE,
	"Plffq, napqimfq.",
	NEW_LINE,
	"Xso rkagfy}?",
	CHANGE_CHARACTER,
	"Ha kodo c| mfn\200 pqinimafsf?!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog88[] = {
	"` nikodea iv nf coh}mt!",
	DISPLAY_MESSAGE,
	"Nikodea!",
	CHANGE_CHARACTER,
	"Nf nfqcnixaj sak.",
	DISPLAY_MESSAGE,
	"Pfktni\200 non olfs.",
	DISPLAY_MESSAGE,
	"` pojet, a s| nf rsfrn\200jr\200",
	NEW_LINE,
	"i coh}mi banknost.",
	DISPLAY_MESSAGE,
	"Nikso nf thnafs...",
	DISPLAY_MESSAGE,
	"Eo rcieani\200, eqtd moj.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog89[] = {
	"Pocfqis} nf modt, kak on ro mnoj",
	NEW_LINE,
	"obqazalr\200.",
	DISPLAY_MESSAGE,
	"Krsasi...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Pfkt \200 omlfs?..",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog90[] = {
	"O-o-o...",
	DISPLAY_MESSAGE,
	"Cr> x>qnof...",
	DISPLAY_MESSAGE,
	"...i povogf na xflocfka...",
	DISPLAY_MESSAGE,
	"...r elinnoj palkoj...",
	DISPLAY_MESSAGE,
	"...i r doqykom na dolocf...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Nf rsoilo eihajnfqt rsol}ko pis}.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog91[] = {
	"Rnoca kopas}r\200 c mtroqf?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"A, nt laeno, sts sol}ko kakif-so",
	NEW_LINE,
	"btmagki.",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog92[] = {
	"Cr> kak ob|xno...",
	DISPLAY_MESSAGE,
	"Kasarsqou|...",
	DISPLAY_MESSAGE,
	"Rkaneal|...",
	DISPLAY_MESSAGE,
	"Insqidi...",
	DISPLAY_MESSAGE,
	"Qarrlfeocani\200...",
	DISPLAY_MESSAGE,
	"Poltdol|f bab|...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Naeo poepiras}r\200.",
	END_DIALOG
};

const static char *russianDialog93[] = {
	ANIM_WAIT,
	"Odo...",
	CHANGE_CHARACTER,
	"...\200 sanwt-t-t\177...",
	DISPLAY_MESSAGE,
	"...i po\177-\177-\177...",
	CHANGE_CHARACTER,
	"^so Egon Nosi...",
	CHANGE_CHARACTER,
	"...eoge>->->m!...",
	CHANGE_CHARACTER,
	"...po>s na kamfqt!",
	CHANGE_CHARACTER,
	"...kakof hamfxa-a-asfl}nof...",
	CHANGE_CHARACTER,
	"Vos\200 fmt \200cno nf rsoilo.",
	CHANGE_CHARACTER,
	"...xt-t-tcrsco...",
	CHANGE_CHARACTER,
	"Tyam nf cfq\177.",
	CHANGE_CHARACTER,
	"...rnoca rxa-a-arslic!..",
	CHANGE_CHARACTER,
	"Kakoj tgar.",
	CHANGE_CHARACTER,
	"...pqorso sanwt\200 poe eoge>->->m...",
	CHANGE_CHARACTER,
	"Rorferka\200 robaka rpo>s ltxyf.",
	CHANGE_CHARACTER,
	"...la-a-a-la-a-a!...",
	CHANGE_CHARACTER,
	"Vcasis tgf.",
	CHANGE_CHARACTER,
	"...la-la! La-la-a-a....",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog94[] = {
	"Nixfdo insfqf...",
	DISPLAY_MESSAGE,
	"Rfktneoxkt...",
	DISPLAY_MESSAGE,
	"Poe eicanom xso-so frs}!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog95[] = {
	"Cam nf kagfsr\200, xso",
	NEW_LINE,
	"rsois eobacis}",
	NEW_LINE,
	"nfmnodo xili?",
	CHANGE_CHARACTER,
	"Eobacis}?",
	DISPLAY_MESSAGE,
	"Haxfm?",
	CHANGE_CHARACTER,
	"Povogf, c| nf c corsoqdf",
	NEW_LINE,
	"os dosoc\200zfdor\200",
	NEW_LINE,
	"qadt.",
	DISPLAY_MESSAGE,
	"Cohmogno, rlfetfs",
	NEW_LINE,
	"pqibacis} fmt",
	NEW_LINE,
	"orsqos|?",
	CHANGE_CHARACTER,
	"Nt...",
	DISPLAY_MESSAGE,
	"Voqoya\200 m|rl}.",
	DISPLAY_MESSAGE,
	"K rxars}\177, t mfn\200 hefr} frs} nfmnodo.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog96[] = {
	CHANGE_CHARACTER,
	"^sos... ik!..",
	DISPLAY_MESSAGE,
	"^sos xi-i-ili... ik!",
	DISPLAY_MESSAGE,
	"...cieimo...",
	DISPLAY_MESSAGE,
	"...habqoeil...",
	DISPLAY_MESSAGE,
	"Qadt irpoqxfno, i...",
	DISPLAY_MESSAGE,
	"...\200 tcolfn!",
	DISPLAY_MESSAGE,
	"Ik!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog97[] = {
	"Qaeio mnf nf ntgno, a cos",
	NEW_LINE,
	"basaqfjki modts pqidoeis}r\200.",
	DISPLAY_MESSAGE,
	"K rogalfni\177, \200 nf tmf\177",
	NEW_LINE,
	"oskq|cas} ~si \200ponrkif",
	NEW_LINE,
	"ystki.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog98[] = {
	CHANGE_CHARACTER,
	"Pqocfqka bfhoparnorsi: dolor, hapav, cnfynors}.",
	DISPLAY_MESSAGE,
	"Dolor poescfqge>n.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Kqtso rpfl.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog99[] = {
	CHANGE_CHARACTER,
	"Pqocfqka bfhoparnorsi: dolor, hapav, cnfynors}.",
	DISPLAY_MESSAGE,
	"Hapav poescfqge>n.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"` sogf bo\177r} coe|, bqo.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog100[] = {
	CHANGE_CHARACTER,
	"Pqocfqka bfhoparnorsi: dolor, hapav, cnfynors}.",
	DISPLAY_MESSAGE,
	"Cnfynors} poescfqgefna.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"C eqtdoj qah rsoj bligf.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog101[] = {
	"Mogno rpqoris}...",
	CHANGE_CHARACTER,
	"Tvoei.",
	DISPLAY_MESSAGE,
	"` han\200s.",
	DISPLAY_MESSAGE,
	"Qabosa\177.",
	DISPLAY_MESSAGE,
	"Rkoqo obfe.",
	DISPLAY_MESSAGE,
	"Naeo rpfyis}.",
	CHANGE_CHARACTER,
	"Frs}, kapisan.",
	"\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog102[] = {
	"Nt a mogfs...",
	CHANGE_CHARACTER,
	"`...",
	DISPLAY_MESSAGE,
	"...OXFN]...",
	DISPLAY_MESSAGE,
	"...HAN`S.",
	DISPLAY_MESSAGE,
	"NF...",
	DISPLAY_MESSAGE,
	"...MFYAJ...",
	DISPLAY_MESSAGE,
	"...MNF.",
	DISPLAY_MESSAGE,
	"LAENO?",
	CHANGE_CHARACTER,
	"Laeno, laeno.",
	END_DIALOG
};

const static char *russianDialog103[] = {
	"Porlfenij qah pqoyt...",
	CHANGE_CHARACTER,
	"CON.",
	DISPLAY_MESSAGE,
	"C kak cali.",
	DISPLAY_MESSAGE,
	"O kak osr\177ea.",
	DISPLAY_MESSAGE,
	"N kak...",
	DISPLAY_MESSAGE,
	"Kak...",
	DISPLAY_MESSAGE,
	"Kak na...",
	CHANGE_CHARACTER,
	"Nacrfdea?",
	CHANGE_CHARACTER,
	"Nfs. Kak...",
	CHANGE_CHARACTER,
	"Nacfki?",
	CHANGE_CHARACTER,
	"Nfs, nfs. Kak...",
	CHANGE_CHARACTER,
	"Nfmfelfnno?",
	CHANGE_CHARACTER,
	"Nfmfelfnno.",
	DISPLAY_MESSAGE,
	"Pogaltjrsa, orsac} mfn\200 oenodo!",
	CHANGE_CHARACTER,
	"Laeno, laeno.",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog104[] = {
	"^m...",
	CHANGE_CHARACTER,
	"Dq-q-q...",
	CHANGE_CHARACTER,
	"Ea nixfdo.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog105[] = {
	"Eobq|j efn}, mirsfq Qobos.",
	CHANGE_CHARACTER,
	"^j, heoqoc, x> kak,",
	NEW_LINE,
	"rfx>y}?",
	DISPLAY_MESSAGE,
	"Hoci mfn\200 Majk, nt x>,",
	NEW_LINE,
	"rfx>y}?",
	CHANGE_CHARACTER,
	"^...",
	DISPLAY_MESSAGE,
	"S| tcfqfn, xso t sfb\200 cr>",
	NEW_LINE,
	"c poq\200ekf r...",
	DISPLAY_MESSAGE,
	"...pqodqammoj?..",
	CHANGE_CHARACTER,
	"A x> nf sak, xtcak?!",
	DISPLAY_MESSAGE,
	"Nikodea nf ciefl q~pt\177zij qobo-rfju,",
	NEW_LINE,
	"rfx>y}?",
	CHANGE_CHARACTER,
	"Xfrsno docoq\200, nikodea.",
	CHANGE_CHARACTER,
	"` nocinka, bqo.",
	DISPLAY_MESSAGE,
	"Rcfgak, rfx>y}?",
	DISPLAY_MESSAGE,
	"Tmn|f l\177ei dcq\200s,",
	NEW_LINE,
	"qobos| eolgn| b|s} crfm pon\200sn|.",
	DISPLAY_MESSAGE,
	"Rfx>y},",
	NEW_LINE,
	"cos mnf i pqieali xflocfxfrkt\177",
	NEW_LINE,
	"lixnors}.",
	DISPLAY_MESSAGE,
	"Rfx>y}?",
	NEW_LINE,
	"Kqtso, ea?",
	CHANGE_CHARACTER,
	"Kvm... Ada, heoqoco.",
	DISPLAY_MESSAGE,
	"So frs} s| sipa rfju, ea?",
	CHANGE_CHARACTER,
	"Cfqno, xtcak.",
	DISPLAY_MESSAGE,
	"Rcfqvnae>gn|j, rfx>y},",
	NEW_LINE,
	"ea?",
	DISPLAY_MESSAGE,
	"Frli voy}, xsob oskq|lr\200,",
	NEW_LINE,
	"eokagi, xso s| claeflfw.",
	DISPLAY_MESSAGE,
	"Sfq} hawfni ~st (WFNHTQA):",
	NEW_LINE,
	"` opqfefl\200\177, sos li",
	NEW_LINE,
	"s| xfl, po sq>m cfzam:",
	DISPLAY_MESSAGE,
	"...cnfynors}, hapav i dolor.",
	NEW_LINE,
	"Rfx>y}?",
	CHANGE_CHARACTER,
	"A nf btefy} sak eobq oskq|s}",
	NEW_LINE,
	"...rfb\200... i \200 pqorso hadl\200nt,",
	NEW_LINE,
	"xso sam cntsqi?",
	CHANGE_CHARACTER,
	"Pqorsi, bqo.",
	DISPLAY_MESSAGE,
	"Nf povog s| na claefl}wa...",
	DISPLAY_MESSAGE,
	"...nf pavnfy}, kak on...",
	DISPLAY_MESSAGE,
	"...i dolor t sfb\200 eqtdoj.",
	DISPLAY_MESSAGE,
	"Sfpfq}, (WFNHTQA), rfx>y}?",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog106[] = {
	"Rfham, oskqojr\200...",
	CHANGE_CHARACTER,
	"(WFNHTQA), s| (WFNHTQA).",
	END_DIALOG
};

const static char *russianDialog107[] = {
	"Vaj!",
	CHANGE_CHARACTER,
	"(QOEISFL]RKIJ KONSQOL]: DQTBA` LFKRIKA)",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog108[] = {
	"Docoq\177 sfbf, ~so pqorso nfxso.",
	CHANGE_CHARACTER,
	"` pomn\177, kak s| tbil mofdo rltdt,",
	NEW_LINE,
	"sfrsiqt\200 ptlfnfpqobicafmt\177",
	NEW_LINE,
	"utsbolkt.",
	CHANGE_CHARACTER,
	"^so b|lo oxfn} eacno...",
	CHANGE_CHARACTER,
	"Ili kak s| reflal xisa\177zij",
	NEW_LINE,
	"q~p qobo-rfju, kosoq|j cfxno",
	NEW_LINE,
	"rvoeis r tma...",
	DISPLAY_MESSAGE,
	"...kodea \200 pqoyt fdo oskq|s}r\200.",
	CHANGE_CHARACTER,
	"Pqorso s| narsqofn na nfdasic...",
	CHANGE_CHARACTER,
	"Ili kak s| pqoeal",
	NEW_LINE,
	"mnf kl\177x k efcix}im",
	NEW_LINE,
	"rfqewam.",
	CHANGE_CHARACTER,
	"Efn}di nf rqabosali?",
	CHANGE_CHARACTER,
	"Nfs.",
	CHANGE_CHARACTER,
	"Rsqanno. Crfdea poltxalor}.",
	CHANGE_CHARACTER,
	"A kodea s|...",
	CHANGE_CHARACTER,
	"LAENO, LAENO!",
	DISPLAY_MESSAGE,
	"Hab|li!",
	DISPLAY_MESSAGE,
	"` tgf irp|sal nocof",
	NEW_LINE,
	"ihobqfsfnif na rfbf!",
	CHANGE_CHARACTER,
	"Pqacea?",
	CHANGE_CHARACTER,
	"Pqacea.",
	DISPLAY_MESSAGE,
	"Modt pqoefmonrsqiqocas}.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Laeno, qirkn>m.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog109[] = {
	ANIM_WAIT,
	"Heoqoco.",
	DISPLAY_MESSAGE,
	"Rocfqyfnn|j dnomoefl.",
	CHANGE_CHARACTER,
	"Vm, ~so poboxn|j ~uufks.",
	DISPLAY_MESSAGE,
	"Poqoj \200 nf konsqoliqt\177 rcoi",
	NEW_LINE,
	"ihobqfsfni\200.",
	DISPLAY_MESSAGE,
	"No nf colntjr\200, ~so elisr\200",
	NEW_LINE,
	"crfdo rfktnet.",
	CHANGE_CHARACTER,
	"Naef\177r}.",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog110[] = {
	"Cos i \200.",
	DISPLAY_MESSAGE,
	"Nt, hamfsil xso-nibte}",
	NEW_LINE,
	"nfob|xnof?",
	CHANGE_CHARACTER,
	"Nfs.",
	CHANGE_CHARACTER,
	"Heoqoco!",
	DISPLAY_MESSAGE,
	"Sablfski qabosa\177s!",
	CHANGE_CHARACTER,
	"Ea nftgfli?",
	CHANGE_CHARACTER,
	"Ea!",
	DISPLAY_MESSAGE,
	"Pqocfq} rcoj btmagnik!",
	CHANGE_CHARACTER,
	"Moj btmagnik pqi...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog111[] = {
	"Def moj btmagnik?!",
	DISPLAY_MESSAGE,
	"Coqiyka!",
	DISPLAY_MESSAGE,
	"Cfqni fdo!",
	CHANGE_CHARACTER,
	"Polfdxf, cos scoj",
	NEW_LINE,
	"btmagnik.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog112[] = {
	"` sqfbt\177 ob{\200rnfnij.",
	CHANGE_CHARACTER,
	"Va!",
	DISPLAY_MESSAGE,
	"^so mo> ramof",
	NEW_LINE,
	"ltxyff ihobqfsfnif!",
	CHANGE_CHARACTER,
	"Xso imfnno?",
	CHANGE_CHARACTER,
	"S| nf ciefl, kak \200 tkqal",
	NEW_LINE,
	"scoj btmagnik...",
	DISPLAY_MESSAGE,
	"...posomt xso \200 pqin\200l...",
	DISPLAY_MESSAGE,
	"SABLFSKI CQFMFNI!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Sablfski cqfmfni?",
	CHANGE_CHARACTER,
	"Ea!",
	DISPLAY_MESSAGE,
	"Sos, kso iv pqimfs, gic>s",
	NEW_LINE,
	"c 1000 qah b|rsqfj,",
	NEW_LINE,
	"xfm orsal}noj miq!",
	CHANGE_CHARACTER,
	"^so ohnaxafs...",
	CHANGE_CHARACTER,
	"^so ohnaxafs, xso miq el\200 nfdo",
	NEW_LINE,
	"ecigfsr\200 c 1000",
	NEW_LINE,
	"qah mfelfnnfj!",
	DISPLAY_MESSAGE,
	"Pqacea, liy} na",
	NEW_LINE,
	"nfrkol}ko rfktne...",
	CHANGE_CHARACTER,
	"Nt... Insfqfrno, konfxno.",
	NEW_LINE,
	"No haxfm ~so?",
	CHANGE_CHARACTER,
	"X>qs fdo hnafs.",
	DISPLAY_MESSAGE,
	"Ram poetmaj.",
	DISPLAY_MESSAGE,
	"Mogno, napqimfq, pqojsi",
	NEW_LINE,
	"c kino bfh bilfsa, i nikso",
	NEW_LINE,
	"sfb\200 nf hamfsis.",
	CHANGE_CHARACTER,
	"Cos ~so ea!",
	DISPLAY_MESSAGE,
	"Heoqoco!",
	DISPLAY_MESSAGE,
	"` voxt ktpis} pasfns!",
	CHANGE_CHARACTER,
	"A cos sts pqoblfma...",
	DISPLAY_MESSAGE,
	"Kak s| hnafy}, moj e\200e\200 Dalladfq",
	NEW_LINE,
	"pqietm|cal ltxyif ihobqfsfni\200,",
	NEW_LINE,
	"kodea b|l... rkagfm sak...",
	CHANGE_CHARACTER,
	"...p}\200n...",
	CHANGE_CHARACTER,
	"...c rorso\200nii insokrikawii.",
	DISPLAY_MESSAGE,
	"I so gf ramof ro mnoj",
	NEW_LINE,
	"(cheov).",
	DISPLAY_MESSAGE,
	"Pqoyloj nox}\177 \200 pqorntlr\200",
	NEW_LINE,
	"os tgarnoj dolocnoj boli i",
	NEW_LINE,
	"nay>l ~si sablfski.",
	DISPLAY_MESSAGE,
	"` nf pomn\177, kak ihdosocil iv.",
	CHANGE_CHARACTER,
	"O nfs!",
	CHANGE_CHARACTER,
	"No modt pop|sas}r\200 poqabosas} nae nimi.",
	DISPLAY_MESSAGE,
	"El\200 ~sodo mnf ntgn| scoi efn}di.",
	DISPLAY_MESSAGE,
	"Eacaj hakl\177xim reflkt.",
	DISPLAY_MESSAGE,
	"S| porsqoiy} mnf noct\177",
	NEW_LINE,
	"laboqasoqi\177...",
	DISPLAY_MESSAGE,
	"...a \200 pfqfeam sfbf pqaca.",
	CHANGE_CHARACTER,
	"S| eay} mnf pasfns?!",
	CHANGE_CHARACTER,
	"Ea.",
	DISPLAY_MESSAGE,
	"Mfn\200 insfqfrtfs sol}ko",
	NEW_LINE,
	"tcagfnif crfmiqnodo",
	NEW_LINE,
	"natxnodo roobzfrsca.",
	DISPLAY_MESSAGE,
	"I Nobflfcrka\200.",
	DISPLAY_MESSAGE,
	"Ram ponimafy}, crfobzij pox>s",
	NEW_LINE,
	"i tcagfnif, insfqc}\177...",
	CHANGE_CHARACTER,
	"Laeno. Ie>s.",
	DISPLAY_MESSAGE,
	"Poedosoc} rpirok nfobvoeimodo",
	NEW_LINE,
	"oboqteocani\200.",
	CHANGE_CHARACTER,
	"Xtefrno.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog113[] = {
	"^sos etqak mnf cfqis.",
	DISPLAY_MESSAGE,
	"No \200 fdo irpol}ht\177...",
	DISPLAY_MESSAGE,
	"Sablfski cqfmfni...",
	DISPLAY_MESSAGE,
	"` nf rsant pqoeacas} iv",
	NEW_LINE,
	"dltp|m l\177eiykam!",
	DISPLAY_MESSAGE,
	"Plfcas} mnf na",
	NEW_LINE,
	"pasfns!",
	DISPLAY_MESSAGE,
	"` modt nfhamfsno",
	NEW_LINE,
	"dqabis} banki!",
	DISPLAY_MESSAGE,
	"B|rsqff rcfsa!",
	DISPLAY_MESSAGE,
	"Naeo tkqars} efnfd ili holosa",
	NEW_LINE,
	"na laboqasoqi\177 ~sodo",
	NEW_LINE,
	"bfhtmwa.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog114[] = {
	"No rkoqo...",
	DISPLAY_MESSAGE,
	"\200 qahbodasf\177.",
	DISPLAY_MESSAGE,
	"Oxfn} ril}no.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"` xtcrsct\177, xso rmodt...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"...xso rmodt...",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog115[] = {
	ANIM_WAIT,
	"HAVCASIS] MIQ!..",
	"\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog116[] = {
	ANIM_WAIT,
	"Crfdea vosfl ~so rkahas}.",
	"\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog117[] = {
	"Rnoca \200.",
	CHANGE_CHARACTER,
	"Rnoca poka.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Reflafm cie, xso \200 nf rl|yal.",
	DISPLAY_MESSAGE,
	"Mirsfq Egon Nosi eoma?",
	CHANGE_CHARACTER,
	"Ea, no on cflfl nf ptrkas} sfb\200.",
	CHANGE_CHARACTER,
	"Mfn\200?! Poxfmt?!",
	CHANGE_CHARACTER,
	"Scoj porlfenij cihis rsoil fmt",
	NEW_LINE,
	"ectv rsfn.",
	CHANGE_CHARACTER,
	"A, sa mayina cqfmfni...",
	DISPLAY_MESSAGE,
	"No rfjxar \200...",
	CHANGE_CHARACTER,
	"Nf docoq\200 tgf o fdo koykf.",
	CHANGE_CHARACTER,
	"Koyka rfjxar rxarslicfj",
	NEW_LINE,
	"l\177bodo ih nar!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Frli miq fz> rtzfrsctfs c",
	NEW_LINE,
	"VV% cfkf.",
	DISPLAY_MESSAGE,
	"Nf bfqisf c doloct.",
	DISPLAY_MESSAGE,
	"C| ob\200han| mfn\200 cptrsis}.",
	CHANGE_CHARACTER,
	"Nftgfli?",
	CHANGE_CHARACTER,
	"` qarrkagt mirsfqt Nosi, xso c| p}>sf.",
	CHANGE_CHARACTER,
	"S| blfutfy}. T sfb\200 nfs eokahasfl}rsc.",
	CHANGE_CHARACTER,
	"Kak hnas}, kak hnas}.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog118[] = {
	"Laeno, cvoei, dq\200hn|j sfqqoqirs.",
	DISPLAY_MESSAGE,
	"Sol}ko nikomt ni rloca.",
	CHANGE_CHARACTER,
	"Konfxno. Rparibo.",
	"\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog119[] = {
	"Hnaxis...",
	DISPLAY_MESSAGE,
	"Cos kak cr> pqoirvoeilo...",
	DISPLAY_MESSAGE,
	"Po~somt nikso nf ciefl,",
	NEW_LINE,
	"kak tkqali",
	NEW_LINE,
	"wfnnorsi...",
	DISPLAY_MESSAGE,
	"^so oxfn} oparnof",
	NEW_LINE,
	"ihobqfsfnif!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Mnf ntgno orsanocis} Egona Nosi!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Kak-so.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"^j! ^si sablfski, xso \200 habqal",
	NEW_LINE,
	"t Majka, cieimo...",
	DISPLAY_MESSAGE,
	"O nfs!",
	DISPLAY_MESSAGE,
	"` rl|yt x}i-so yadi!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog120[] = {
	"Ntgno def-so tkq|s}r\200!",
	DISPLAY_MESSAGE,
	"B|rsqo!",
	END_DIALOG
};

const static char *russianDialog121[] = {
	"Pqie>sr\200 ktpis} ob|xn|j rfju.",
	DISPLAY_MESSAGE,
	"^sos etqawkij qobos op\200s} rp\200sil.",
	DISPLAY_MESSAGE,
	"Nfnacigt fdo.",
	DISPLAY_MESSAGE,
	"HAKQOJR`, VLAMA KTROK!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog122[] = {
	"Sqfsij qah ha nfefl\177.",
	DISPLAY_MESSAGE,
	"Ov, laeno, laeno!...",
	DISPLAY_MESSAGE,
	"Iet!..",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog123[] = {
	"...cr> pokq|s}.",
	DISPLAY_MESSAGE,
	"Mnf ntgno bol}yf efnfd na ovqannt\177 rirsfmt.",
	DISPLAY_MESSAGE,
	"T mfn\200 crfdo eca xflocfka i...",
	CHANGE_CHARACTER,
	"Bol}yf, bol}yf!",
	DISPLAY_MESSAGE,
	"^so cr>, xso rl|yt!",
	CHANGE_CHARACTER,
	"Laeno, ob{\200rn\177 fz> qah...",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog124[] = {
	"Mirsfq Egon Nosi?",
	DISPLAY_MESSAGE,
	"` pqin>r roobzfnif",
	NEW_LINE,
	"os pqoufrroqa.",
	DISPLAY_MESSAGE,
	"On pqoris car hajsi c laboqasoqi\177.",
	DISPLAY_MESSAGE,
	"Docoqis, xso nay>l",
	NEW_LINE,
	"qfwfps sablfsok.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog125[] = {
	"Tgf cr>?!",
	CHANGE_CHARACTER,
	"Opqfefl>nno... ik!.. ea.",
	CHANGE_CHARACTER,
	"Heoqoco!",
	"\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog126[] = {
	"Naeo iv orsanocis}!",
	DISPLAY_MESSAGE,
	"Nfl}h\200 sfq\200s} cqfmfni!",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog127[] = {
	"Sak-sak-sak...",
	DISPLAY_MESSAGE,
	"S| efjrsctfy} mnf na nfqc|.",
	DISPLAY_MESSAGE,
	"Nf galfs} efnfd na ovqannt\177 rirsfmt",
	NEW_LINE,
	"okahalor} pqacil}noj m|rl}\177...",
	DISPLAY_MESSAGE,
	"^so rilocof polf nftnixsogimo!",
	DISPLAY_MESSAGE,
	"Va!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog128[] = {
	"No mnf cr> qacno pqie>sr\200 sfb\200 tbis}.",
	CHANGE_CHARACTER,
	"Nfs, nfs!",
	CHANGE_CHARACTER,
	"Hasknir}!",
	CHANGE_CHARACTER,
	"Ono sodo nf rsois!",
	CHANGE_CHARACTER,
	"Ea nt?",
	CHANGE_CHARACTER,
	"` nf voxt...",
	END_DIALOG
};

const static char *russianDialog129[] = {
	CHANGE_CHARACTER,
	"Bfen\200da pqoufrroq liyilr\200 xtcrsc...",
	CHANGE_CHARACTER,
	"No... kak...",
	DISPLAY_MESSAGE,
	"` NIXFDO NF PONIMA_!",
	CHANGE_CHARACTER,
	"Oxfn} pqorso.",
	DISPLAY_MESSAGE,
	"M| pqikqfpili rfkqfsnt\177 mikqokamfqt",
	NEW_LINE,
	"k scofj kfpkf.",
	DISPLAY_MESSAGE,
	"Po~somt crfdea b|li c ktqrf",
	NEW_LINE,
	"pqoirvoe\200zfdo.",
	CHANGE_CHARACTER,
	"C| ciefli, kak \200?..",
	CHANGE_CHARACTER,
	"Nf voxt sfb\200 rmtzas}.",
	DISPLAY_MESSAGE,
	"S| ril}no pomod KCE.",
	CHANGE_CHARACTER,
	"No Egon Nosi rbfgal!",
	CHANGE_CHARACTER,
	"On nf pqfersacl\200fs insfqfra.",
	DISPLAY_MESSAGE,
	"Pqoufrroq t nar, a s| eay} nam sablfski.",
	DISPLAY_MESSAGE,
	"Pqorsi, no rfbf s| iv orsacis} nf mogfy}.",
	CHANGE_CHARACTER,
	"Laeno, no...",
	DISPLAY_MESSAGE,
	"Mogfsf eas} mnf mintskt?",
	DISPLAY_MESSAGE,
	"T mfn\200 k ~somt mfqhacwt",
	NEW_LINE,
	"lixnof eflo.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Voqoyo. No porpfyi.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog130[] = {
	ANIM_WAIT,
	"(rdlosntl)",
	DISPLAY_MESSAGE,
	"A cqfmfnnoj ~uufks i pqacea",
	NEW_LINE,
	"nfeoldij...",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog131[] = {
	"C| pqoidqali, mirsfq!",
	DISPLAY_MESSAGE,
	"Poliwi\200 okqtgafs heanif!",
	CHANGE_CHARACTER,
	"Nf bte} etqakom.",
	DISPLAY_MESSAGE,
	"Nf etmal, xso t mfn\200 frs}",
	NEW_LINE,
	"caqians pqo hapar?",
	CHANGE_CHARACTER,
	"Av sak?",
	DISPLAY_MESSAGE,
	"I kakoj gf?",
	CHANGE_CHARACTER,
	"Sak \200 sfbf i qarrkahal...",
	DISPLAY_MESSAGE,
	"Oscali, btkayka.",
	DISPLAY_MESSAGE,
	"` han\200s.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog132[] = {
	"Mnf pqie>sr\200 car qahoqtgis}.",
	DISPLAY_MESSAGE,
	"Bte}sf eobq|, reajsfr} eobqocol}no.",
	CHANGE_CHARACTER,
	"T mfn\200 nfs cqfmfni na ytski.",
	DISPLAY_MESSAGE,
	"Pqocalicaj osr\177ea,",
	NEW_LINE,
	"poka rnoca na sfb\200 ptykt",
	NEW_LINE,
	"nf narsacil.",
	CHANGE_CHARACTER,
	"Pqfetpqfgea\177...",
	CHANGE_CHARACTER,
	"Osktea bfqtsr\200 sakif",
	NEW_LINE,
	"hante|, kak s|?",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog133[] = {
	"Bol}yf cohmognorsi nf btefs...",
	CHANGE_CHARACTER,
	"Oslixno.",
	DISPLAY_MESSAGE,
	"I pqozaj.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog134[] = {
	"Vcasis pakocas} efn}di!",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog135[] = {
	"Pqicfsik!",
	CHANGE_CHARACTER,
	"Pqicfs.",
	DISPLAY_MESSAGE,
	"Sfbf xfdo?",
	CHANGE_CHARACTER,
	"Mfn\200 napqacili r\177ea na sqfniqockt.",
	CHANGE_CHARACTER,
	"Oxfqfenoj c|rkoxka, mfs\200zij c adfns|?",
	CHANGE_CHARACTER,
	"Ada.",
	CHANGE_CHARACTER,
	"Pokagi eoktmfns|, i mogfy} cojsi.",
	CHANGE_CHARACTER,
	"Laetyki.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog136[] = {
	"Mogfy} mfn\200 cptrsis} bfh crfj ~soj",
	NEW_LINE,
	"b\177qokqasii?",
	CHANGE_CHARACTER,
	"Pqorsi, nfs.",
	DISPLAY_MESSAGE,
	"Pqacila frs} pqacila.",
	CHANGE_CHARACTER,
	"Bolcan| frs} bolcan|.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"A mfqscfw| frs} mfqscfw|.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Voqoyfdo en\200, r~q.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog137[] = {
	"MOGNO COJSI, POGALTJRSA?!",
	CHANGE_CHARACTER,
	"EA, MOGNO!",
	DISPLAY_MESSAGE,
	"PQORSO POKAGI EOKTMFNS\\!",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog138[] = {
	"Pqoptrsi mfn\200!",
	CHANGE_CHARACTER,
	"Pokagi tgf eoktmfns|!",
	CHANGE_CHARACTER,
	"S| rliykom rfq}>hno osnoriy}r\200 k qabosf,",
	NEW_LINE,
	"nf kagfsr\200?",
	CHANGE_CHARACTER,
	"S| rlfpoj, xso li?",
	DISPLAY_MESSAGE,
	"` xisa\177 gtqnal na porst.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Soxno.",
	DISPLAY_MESSAGE,
	"Pqorsi.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog139[] = {
	"Mnf naeo...",
	CHANGE_CHARACTER,
	"Eoktmfns|!",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog140[] = {
	"Xso xisafy}?",
	CHANGE_CHARACTER,
	"\"Roleasrkif nocorsi\".",
	CHANGE_CHARACTER,
	"Nqac\200sr\200 crf ~si cofnn|f ystxki,",
	NEW_LINE,
	"ea?",
	CHANGE_CHARACTER,
	"Rp\200sil?",
	DISPLAY_MESSAGE,
	"Mnf nqac\200sr\200 uoski klarrn|v efcxonok...",
	DISPLAY_MESSAGE,
	"...kqorrcoqe|...",
	DISPLAY_MESSAGE,
	"...rsqanixka r \177moqom...",
	DISPLAY_MESSAGE,
	"...rplfsni...",
	DISPLAY_MESSAGE,
	"...qfwfps|...",
	CHANGE_CHARACTER,
	"KTLINAQN\\F?!",
	CHANGE_CHARACTER,
	"Ea, oni p|sa\177sr\200 poen\200s} rcoj pqfrsig.",
	DISPLAY_MESSAGE,
	"Pqiclfx} noc|v xisasflfj.",
	CHANGE_CHARACTER,
	"O ea.",
	DISPLAY_MESSAGE,
	"Klarrna\200 ief\200.",
	DISPLAY_MESSAGE,
	"Rsqanixka r c\200hanifm sogf frs}?",
	CHANGE_CHARACTER,
	"Mnf kagfsr\200, s|",
	NEW_LINE,
	"p|safy}r\200 ytsis}.",
	CHANGE_CHARACTER,
	"Kso, \200?",
	DISPLAY_MESSAGE,
	"Ea nikodea.",
	CHANGE_CHARACTER,
	"Oslixno.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog141[] = {
	"Nf oeolgiy} mnf gtqnal?",
	CHANGE_CHARACTER,
	"I kak sodea",
	NEW_LINE,
	"\200 btet",
	NEW_LINE,
	"tbicas} cqfm\200?",
	CHANGE_CHARACTER,
	"^m...",
	DISPLAY_MESSAGE,
	"Mogfy} rxisas} lirs}\200.",
	CHANGE_CHARACTER,
	"Hefr} 11034 lirsa.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Odo.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog142[] = {
	"Xso eflafy}?",
	CHANGE_CHARACTER,
	"Sfbf oscfxa\177.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog143[] = {
	"Sak efqgas}, moloefw.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog144[] = {
	CHANGE_CHARACTER,
	"^j, nahae!",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog145[] = {
	"A xso sakof?",
	CHANGE_CHARACTER,
	"S| eolgfn pokahas} pqoptrk,",
	NEW_LINE,
	"pqfgef xfm \200 cptzt",
	NEW_LINE,
	"sfb\200 c ladfq}.",
	CHANGE_CHARACTER,
	"A inaxf?",
	CHANGE_CHARACTER,
	"Mnf pqie>sr\200 sfb\200 harsqflis}.",
	CHANGE_CHARACTER,
	"(rdlosntl)",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog146[] = {
	CHANGE_CHARACTER,
	"Pqfetpqfgea\177...",
	DISPLAY_MESSAGE,
	"Moi ptli b|rsqff sfb\200...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog147[] = {
	CHANGE_CHARACTER,
	"Laeno.",
	DISPLAY_MESSAGE,
	"Osxisajr\200 kapisant.",
	DISPLAY_MESSAGE,
	"On def-so poblihorsi.",
	CHANGE_CHARACTER,
	"Rparibo.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog148[] = {
	CHANGE_CHARACTER,
	"M| reflafm ih sfb\200 narso\200zfdo mtgxint,",
	NEW_LINE,
	"cfqno, r|nok?!",
	CHANGE_CHARACTER,
	"^...",
	CHANGE_CHARACTER,
	"Ltxyfdo ih ltxyiv!..",
	CHANGE_CHARACTER,
	"A...",
	CHANGE_CHARACTER,
	"Rkcoh} pos, kqoc} i rl>h|!",
	CHANGE_CHARACTER,
	"` pqfepox>l b|...",
	CHANGE_CHARACTER,
	"Qae scofmt ~nsthiahmt, r|nok!",
	DISPLAY_MESSAGE,
	"Nf btefm sfq\200s} cqfmfni!",
	DISPLAY_MESSAGE,
	"Mnf pqikahali pqocfrsi trkoqfnnt\177 poedosockt.",
	DISPLAY_MESSAGE,
	"Isak, r|nok!",
	DISPLAY_MESSAGE,
	"S| eolgfn pqojsi sqi irp|sani\200!",
	DISPLAY_MESSAGE,
	"Naxn>m r l>dkodo!..",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog149[] = {
	CHANGE_CHARACTER,
	"Haeaxa pqorsa.",
	DISPLAY_MESSAGE,
	"` hapqt sfb\200 hefr}...",
	DISPLAY_MESSAGE,
	"...a s| eolgfn c|bqas}r\200.",
	DISPLAY_MESSAGE,
	"Cr> \200rno?!",
	CHANGE_CHARACTER,
	"R~q, \200...",
	CHANGE_CHARACTER,
	"OSLIXNO!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog150[] = {
	ANIM_WAIT,
	"^j?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Heoqoco.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog151[] = {
	"Pohabacilir} i vcasis.",
	DISPLAY_MESSAGE,
	"C|ptrsisf!",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog152[] = {
	"^j! Frs} kso",
	NEW_LINE,
	"rnaqtgi?!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"POMODISF!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog153[] = {
	"Pozaeisf!",
	DISPLAY_MESSAGE,
	"` hefr} pomqt!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog154[] = {
	"` pqodoloealr\200!",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog155[] = {
	"` nf hna\177, xso fz> rkahas}...",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog156[] = {
	"Etma\177...",
	DISPLAY_MESSAGE,
	"...s| pqoy>l...",
	DISPLAY_MESSAGE,
	"...pfqc|j sfrs...",
	DISPLAY_MESSAGE,
	"...Pfqfje>m...",
	DISPLAY_MESSAGE,
	"...k rlfet\177zfmt...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog157[] = {
	CHANGE_CHARACTER,
	"Voqoyo, roleas.",
	DISPLAY_MESSAGE,
	"Pqfersacim, xso \200 scoj plfnnik...",
	DISPLAY_MESSAGE,
	"...i hna\177 rfkqfsn|j paqol}.",
	DISPLAY_MESSAGE,
	"Sco\200 wfl} - c|cfeas} fdo t mfn\200.",
	DISPLAY_MESSAGE,
	"`RNO?!",
	CHANGE_CHARACTER,
	"` xfm-nibte} odqanixfn?",
	CHANGE_CHARACTER,
	"Nfs.",
	DISPLAY_MESSAGE,
	"Eflaj xso voxfy}.",
	CHANGE_CHARACTER,
	"Modt eagf c dlah pl\177nts}?",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Ea.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Rparibo, pqorso tsoxnil.",
	"\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog158[] = {
	"Pogaltjrsa, rkagisf paqol},",
	NEW_LINE,
	"i pokonxim r ~sim.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Ea\177 cqfm\200 poetmas}.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog159[] = {
	"^j, podocoqisf ro mnoj.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"C| mfn\200 rl|yisf?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"HFML` C\\H\\CAFS KAPISANA, PQI<M!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Ea nt car.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog160[] = {
	"Rohqfli el\200 qahdocoqa?",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Laeno, eam cam fz> cqfmfni.",
	"\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog161[] = {
	"Nt sak kakoj paqol}?",
	CHANGE_CHARACTER,
	"Oscali, galkij n|sik.",
	CHANGE_CHARACTER,
	"Bte}sf pocfglicfj, a so rnoca hazfkoxt.",
	CHANGE_CHARACTER,
	"Eacaj, mnf eagf pqi\200sno.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Cam ~so nqacisr\200, ea?",
	CHANGE_CHARACTER,
	"Hnafy}...",
	CHANGE_CHARACTER,
	"Laeno, najet eqtdoj rporob.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog162[] = {
	"` cam kof-xso pqin>r...",
	CHANGE_CHARACTER,
	"S| mfn\200 nf poektpiy}.",
	CHANGE_CHARACTER,
	"Cos kak?",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog163[] = {
	NEW_LINE,
	"O, VOXT-VOXT-VOXT!",
	DISPLAY_MESSAGE,
	"` REFLA_ XSO TDOENO!",
	CHANGE_CHARACTER,
	"Paqol}...",
	CHANGE_CHARACTER,
	"Paqol} \"KOUF\".",
	DISPLAY_MESSAGE,
	"Rkagi fdo baqmfnt,",
	NEW_LINE,
	"i on sfbf kof-xso ears.",
	DISPLAY_MESSAGE,
	"A posom qarrkagfs o sqfs}fm haeanii.",
	DISPLAY_MESSAGE,
	"SFPFQ] ORCOBOEI!",
	CHANGE_CHARACTER,
	"` fz> poetma\177.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog164[] = {
	"S|...",
	DISPLAY_MESSAGE,
	"...c|...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"...pqoyli, r~q!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog165[] = {
	"Voxfy} hamfxasfl}n|j kalfjeorkop?",
	CHANGE_CHARACTER,
	"T mfn\200 b|l sakoj, no kapisan tciefl,",
	NEW_LINE,
	"kak \200 r nim idqa\177, i habqal fdo.",
	DISPLAY_MESSAGE,
	"Kak mnf kagfsr\200,",
	NEW_LINE,
	"el\200 lixnodo pol}hocani\200.",
	CHANGE_CHARACTER,
	"Frli eay} mnf gtqnal,",
	NEW_LINE,
	"\200 eam sfbf kalfjeorkop.",
	CHANGE_CHARACTER,
	"Nf voxt hnas}, kak s| fdo eorsal...",
	CHANGE_CHARACTER,
	"Voqoyo.",
	CHANGE_CHARACTER,
	"...no ceqtd kapisan mfn\200 rnoca harstkafs?",
	CHANGE_CHARACTER,
	"Nf pfqfgicaj, t nfdo qtki rc\200han|.",
	CHANGE_CHARACTER,
	"O, sfrs nomfq eca, polada\177?..",
	CHANGE_CHARACTER,
	"Ada.",
	CHANGE_CHARACTER,
	"Laeno, eacaj pocfrflimr\200.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog166[] = {
	"KOUF.",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog167[] = {
	CHANGE_CHARACTER,
	"Doq\200xij, ea?",
	CHANGE_CHARACTER,
	"Oj-oj.",
	DISPLAY_MESSAGE,
	"Kapisan docoqil, c| eolgn| qarrkahas} mnf",
	NEW_LINE,
	"o sqfs}fm haeanii.",
	CHANGE_CHARACTER,
	"Op\200s}...",
	DISPLAY_MESSAGE,
	"Nt, ~so cqoef idq| c pq\200ski.",
	DISPLAY_MESSAGE,
	"Kapisan pq\200xfsr\200, a s| izfy}.",
	CHANGE_CHARACTER,
	"No on rieis pqic\200hann|j k rstlt!",
	CHANGE_CHARACTER,
	"Mtgik ro rcoimi bol}n|mi idqami...",
	DISPLAY_MESSAGE,
	"On tgf nfvilo c niv haidqalr\200!..",
	DISPLAY_MESSAGE,
	"On sfb\200 obmantl.",
	DISPLAY_MESSAGE,
	"Iei pqocfq}.",
	DISPLAY_MESSAGE,
	"Tcfqfn, on tgf orcoboeilr\200.",
	CHANGE_CHARACTER,
	"No \200 habqal fdo nog!",
	DISPLAY_MESSAGE,
	"Kak on mod pfqfqfhas} cfq>ckt?!",
	CHANGE_CHARACTER,
	"Mogfs, on sak i ty>l,",
	NEW_LINE,
	"pqic\200hann|j k rstlt...",
	CHANGE_CHARACTER,
	"Nf bfea!",
	DISPLAY_MESSAGE,
	"Nf c ktqrf, def on mogfs pq\200sas}r\200?",
	CHANGE_CHARACTER,
	"Nfs.",
	CHANGE_CHARACTER,
	"Oj, ea laeno.",
	CHANGE_CHARACTER,
	"Nfs, paqfn}. Idqaj xfrsno.",
	END_DIALOG
};

const static char *russianDialog168[] = {
	"Cqfm\200 el\200 poerkahki?",
	CHANGE_CHARACTER,
	"Nfs.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog169[] = {
	"Pqicfs, r~q. ` Maqk.",
	CHANGE_CHARACTER,
	"Gal}, xso maqki nf eollaq|.",
	DISPLAY_MESSAGE,
	"Xso modt reflas}?",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Mogfsf eas} mnf ktxt efnfd...",
	DISPLAY_MESSAGE,
	"...ili crsas} na doloct...",
	DISPLAY_MESSAGE,
	"...ili...",
	CHANGE_CHARACTER,
	"Laeno, laeno. Kcis|.",
	DISPLAY_MESSAGE,
	"Nt?..",
	CHANGE_CHARACTER,
	"Kso fz> frs} c ladfqf?",
	CHANGE_CHARACTER,
	"S| gtqnalirs?",
	CHANGE_CHARACTER,
	"Nfs, \200 rfkqfsn|j adfns.",
	CHANGE_CHARACTER,
	"I s| sogf?",
	DISPLAY_MESSAGE,
	"Nt ea laeno, hefr} crfdo sqi xflocfka.",
	DISPLAY_MESSAGE,
	"`, kapisan i ovqannik.",
	CHANGE_CHARACTER,
	"Nfs gfnzin?",
	CHANGE_CHARACTER,
	"Nf plax}.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"^-~-~, laeno...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog170[] = {
	"Ronnof waqrsco sts, a?",
	CHANGE_CHARACTER,
	"Voxfy} xso-nibte} hakahas} ili nfs?",
	CHANGE_CHARACTER,
	"T mfn\200 nfs efnfd.",
	CHANGE_CHARACTER,
	"Rfdoen\200 bfrplasno.",
	CHANGE_CHARACTER,
	"Pqacea?",
	CHANGE_CHARACTER,
	"Pqacea.",
	CHANGE_CHARACTER,
	"Eajsf vos-eod.",
	CHANGE_CHARACTER,
	"Nfst.",
	CHANGE_CHARACTER,
	"Piwwt?",
	CHANGE_CHARACTER,
	"Nfst.",
	CHANGE_CHARACTER,
	"Sors|?",
	CHANGE_CHARACTER,
	"Nfst.",
	CHANGE_CHARACTER,
	"Xfdo tdoeno?",
	CHANGE_CHARACTER,
	"Nfst.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Nfs, rparibo.",
	DISPLAY_MESSAGE,
	"` nf doloefn.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog171[] = {
	"Xso c| p}>sf?",
	CHANGE_CHARACTER,
	"Xaj.",
	CHANGE_CHARACTER,
	"Nt ea.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog172[] = {
	"Voqoya\200 podoeka.",
	CHANGE_CHARACTER,
	"Vm...",
	END_DIALOG
};

const static char *russianDialog173[] = {
	"Poqoj \200 sak trsa\177.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Oxfn} trsa\177.",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog174[] = {
	"^, Ctersok tgf pqoy>l!",
	END_DIALOG
};

const static char *russianDialog175[] = {
	"Rparib.",
	END_DIALOG
};

const static char *russianDialog176[] = {
	CHANGE_CHARACTER,
	"Xso ha...",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog177[] = {
	"^j, pis} nf vosisf?",
	DISPLAY_MESSAGE,
	"Hab|li o rcofj kqtgkf?",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog178[] = {
	"R~q, nam roobzili, xso...",
	CHANGE_CHARACTER,
	"Pohgf!",
	DISPLAY_MESSAGE,
	"` rfjxar han\200s!",
	CHANGE_CHARACTER,
	"Kak rkagfsf, r~q.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog179[] = {
	"R~q, kakoj-so poeqorsok p|safsr\200 halfhs}",
	NEW_LINE,
	"c orobn\200k.",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog180[] = {
	"Nixfdo rsqaynodo.",
	DISPLAY_MESSAGE,
	"_noyi l\177bop|sn|...",
	DISPLAY_MESSAGE,
	"...a moj eom poqagafs iv coobqagfnif.",
	DISPLAY_MESSAGE,
	"No cr> qacno pqirmasqicaj ha nim.",
	CHANGE_CHARACTER,
	"Ea, r~q!",
	END_DIALOG
};

const static char *russianDialog181[] = {
	"R~q, paqfn} op\200s} p|salr\200 halfhs}.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog182[] = {
	"Etmafy}, ~so oparno?",
	CHANGE_CHARACTER,
	"Vm-m-m... Nfs...",
	DISPLAY_MESSAGE,
	"On c|dl\200eis bfhobieno.",
	DISPLAY_MESSAGE,
	"No, cohmogno, rsois fdo...",
	CHANGE_CHARACTER,
	"Nfs.",
	DISPLAY_MESSAGE,
	"Pqorso nf poeptrkaj.",
	DISPLAY_MESSAGE,
	"No roobzi, frli on rnoca po\200cisr\200.",
	DISPLAY_MESSAGE,
	"A sfpfq} ha qabost.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog183[] = {
	"Sol}ko nf docoqi, xso rnoca mal}xiyka...",
	CHANGE_CHARACTER,
	"Bo\177r}, xso sak.",
	DISPLAY_MESSAGE,
	"Ovqannik docoqis, on oxfn} nars|qn|j.",
	END_DIALOG
};

const static char *russianDialog184[] = {
	"On naxinafs mfn\200 bfris}.",
	DISPLAY_MESSAGE,
	"I ha xso \200 sfbf plaxt?",
	CHANGE_CHARACTER,
	"Mnf fdo...",
	CHANGE_CHARACTER,
	"Poka nfs.",
	DISPLAY_MESSAGE,
	"Eaeim fmt porlfenij yanr.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog185[] = {
	"R~q...",
	CHANGE_CHARACTER,
	"Eaj tdaea\177...",
	DISPLAY_MESSAGE,
	"MAL]XIYKA?!",
	CHANGE_CHARACTER,
	"Soxno.",
	CHANGE_CHARACTER,
	"Poxfmt cr> pqivoeisr\200 eflas} mnf?!",
	DISPLAY_MESSAGE,
	"Mogfy} vos} xso-so reflas} ramorso\200sfl}no?",
	CHANGE_CHARACTER,
	"Mnf tbis} fdo ili pqorso na ktrki poqcas}?",
	CHANGE_CHARACTER,
	"S| ieios.",
	DISPLAY_MESSAGE,
	"Frs}... mfsoe| ltxyf...",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog186[] = {
	"` ram qahbfqtr}.",
	DISPLAY_MESSAGE,
	"Sfpfq} tjei!",
	DISPLAY_MESSAGE,
	"Mnf ntgno pfqfoefs}r\200.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog187[] = {
	"^j sam, nacfqvt!",
	DISPLAY_MESSAGE,
	"Rptrkajr\200!",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Nikakoj qfakwii.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Ona dltva\200, xso li?",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog188[] = {
	"^j, psixka, nf rsfrn\200jr\200.",
	DISPLAY_MESSAGE,
	"Iei r\177ea...",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"(cheov)",
	"\x1f",
	END_DIALOG
};

const static char *russianDialog189[] = {
	"R\177ea, psayka...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog190[] = {
	NEW_LINE,
	"^j, nf poevoei k ~soj ecfqi!",
	CHANGE_CHARACTER,
	"Poxfmt?",
	CHANGE_CHARACTER,
	"Nf sco> eflo.",
	DISPLAY_MESSAGE,
	"Pqorso nf poevoei.",
	"\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog191[] = {
	CHANGE_CHARACTER,
	"` cqoef rkahal nf poevoeis}?",
	CHANGE_CHARACTER,
	"Laeno, laeno...",
	END_DIALOG
};

const static char *russianDialog192[] = {
	"` pqic>h noct\177 paqsi\177 holosa.",
	CHANGE_CHARACTER,
	"Ea, \200 c ktqrf.",
	DISPLAY_MESSAGE,
	"Paqol}?",
	CHANGE_CHARACTER,
	"Bimbo.",
	CHANGE_CHARACTER,
	"Cfqno.",
	DISPLAY_MESSAGE,
	"Hanorisf cntsq}.",
	CHANGE_CHARACTER,
	"Lae|.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog193[] = {
	"Kak \200 tgf docoqil, naya oqdanihawi\200",
	NEW_LINE,
	"qfyafs nfrsaneaqsn|f pqoblfm|.",
	DISPLAY_MESSAGE,
	"Porlfenfj b|l NLO",
	NEW_LINE,
	"nae Bfl|m eomom.",
	CHANGE_CHARACTER,
	"Placea?",
	DISPLAY_MESSAGE,
	"I xso c|?",
	CHANGE_CHARACTER,
	"Rbili ~st ystkocint.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Pon\200sno.",
	DISPLAY_MESSAGE,
	"I kso... xso b|lo cntsli?",
	CHANGE_CHARACTER,
	"Vosisf hnas}?",
	CHANGE_CHARACTER,
	"O ea! ` gf ~krslarfnr,",
	NEW_LINE,
	"mnf oxfn} l\177bop|sno.",
	CHANGE_CHARACTER,
	"C| OXFN] vosisf hnas}?",
	CHANGE_CHARACTER,
	"EA!",
	CHANGE_CHARACTER,
	"No...",
	DISPLAY_MESSAGE,
	"OXFN]-OXFN]?",
	CHANGE_CHARACTER,
	"EA!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Pqorsisf, \200 nf modt qarrkahas}.",
	DISPLAY_MESSAGE,
	"C obzfm, nam ntgna caya pomoz}.",
	CHANGE_CHARACTER,
	"` nf rfklfsn|j adfns, \200 ~krslarfnr...",
	CHANGE_CHARACTER,
	"Hna\177.",
	DISPLAY_MESSAGE,
	"T nar oxfn} rlognof eflo,",
	NEW_LINE,
	"m| b}>mr\200 r nim",
	NEW_LINE,
	"tgf poldoea.",
	DISPLAY_MESSAGE,
	"M| c bfhc|voenom pologfnii.",
	DISPLAY_MESSAGE,
	"` sts poetmal, qah m| hanimafmr\200",
	NEW_LINE,
	"rsqann|mi eflami...",
	DISPLAY_MESSAGE,
	"...sak poxfmt b| nf irpol}hocas}",
	NEW_LINE,
	"rsqann|f mfsoe|?",
	CHANGE_CHARACTER,
	"I?..",
	CHANGE_CHARACTER,
	"Pohcol}sf, \200 eam cam sflfuonn|j rpqacoxnik.",
	DISPLAY_MESSAGE,
	"Corpol}htjsfr} rporobnors\200mi i c|bfqisf im\200.",
	DISPLAY_MESSAGE,
	"Cohmogno, rcfga\200 doloca qarkqofs ~so eflo.",
	CHANGE_CHARACTER,
	"C| cfe} nf cflisf, xso poltxisr\200?",
	CHANGE_CHARACTER,
	"Nfs.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"^so dltpo.",
	CHANGE_CHARACTER,
	"Hna\177.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Laeno. Eacajsf rplacoxnik.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog194[] = {
	ANIM_WAIT,
	"Im\200...",
	DISPLAY_MESSAGE,
	"...Voppfl...",
	DISPLAY_MESSAGE,
	"...Malk Voppfl...",
	DISPLAY_MESSAGE,
	"Vm...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog195[] = {
	"On ie>s.",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog196[] = {
	"O, \200 ihcin\200\177r} ha rcoiv l\177efj.",
	DISPLAY_MESSAGE,
	"Poqoj oni rliykom nfqcn|f...",
	DISPLAY_MESSAGE,
	"Pogaltjrsa...",
	DISPLAY_MESSAGE,
	"Eacaj podocoqim...",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog197[] = {
	"Porltyajsf, mirsfq...",
	CHANGE_CHARACTER,
	"Hna\177, hna\177.",
	DISPLAY_MESSAGE,
	"Pqoyt, eaj mnf p\200s} mints,",
	NEW_LINE,
	"i \200 cr> ob{\200rn\177.",
	CHANGE_CHARACTER,
	"Cal\200jsf, mnf crfdea nqacilir} rfkqfsn|f ystxki.",
	CHANGE_CHARACTER,
	"Isak...",
	DISPLAY_MESSAGE,
	"` dlaca rfkqfsnoj pqacisfl}rscfnnoj",
	NEW_LINE,
	"oqdanihawii poe nahcanifm KCE.",
	CHANGE_CHARACTER,
	"Xso hnaxis KCE?",
	CHANGE_CHARACTER,
	"` i ram nf hna\177.",
	DISPLAY_MESSAGE,
	"Narsol}ko ~so rfkqfsno.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Kqtso.",
	CHANGE_CHARACTER,
	"Haeaxa mofj oqdanihawii - qfyas}",
	NEW_LINE,
	"ram|f nfrsaneaqsn|f pqoblfm|",
	NEW_LINE,
	"po crfmt miqt.",
	CHANGE_CHARACTER,
	"Cqoef nalodoc?",
	CHANGE_CHARACTER,
	"Nfs, cqoef NLO, rsqann|v ihobqfsfnij,",
	NEW_LINE,
	"pqiciefnij...",
	CHANGE_CHARACTER,
	"Odo!",
	CHANGE_CHARACTER,
	"Ea, kodea poliwi\200, rfkqfsna\200 rltgba i pqoxif",
	NEW_LINE,
	"nf modts rpqacis}r\200...",
	DISPLAY_MESSAGE,
	"...oni ospqacl\200\177sr\200 k nam. No...",
	DISPLAY_MESSAGE,
	"Cieiy} li, poldoea nahae",
	NEW_LINE,
	"ih bankocrkiv rfjuoc naxali",
	NEW_LINE,
	"irxfhas} holoso i nalixka.",
	DISPLAY_MESSAGE,
	"C pq\200mom rm|rlf. Bav! I kak nf b|calo!",
	CHANGE_CHARACTER,
	"I?..",
	CHANGE_CHARACTER,
	"Pqopali bfh rlfea.",
	DISPLAY_MESSAGE,
	"Cr> pqoirvoeilo ha rfktne|.",
	DISPLAY_MESSAGE,
	"T nar frs} ciefohapiri, no na niv",
	NEW_LINE,
	"nixfdo nf cieno.",
	DISPLAY_MESSAGE,
	"Po~somt m| nan\200li ~krsqarfnra,",
	NEW_LINE,
	"xsob| ona tkahala na sodo, kso mod b| rsas}",
	NEW_LINE,
	"nayim rparisflfm.",
	DISPLAY_MESSAGE,
	"Ona c|bqala sfb\200.",
	CHANGE_CHARACTER,
	"Pqorsisf...",
	DISPLAY_MESSAGE,
	"C| rkahali, xso nan\200li...",
	DISPLAY_MESSAGE,
	"...^KRSQARFNRA?!",
	CHANGE_CHARACTER,
	"Ea, m| c osxa\200nii i",
	NEW_LINE,
	"dosoc| na cr>.",
	CHANGE_CHARACTER,
	"Bqfe kakoj-so. Mam, qahbtei mfn\200!",
	CHANGE_CHARACTER,
	"Trpokojr\200.",
	DISPLAY_MESSAGE,
	"T nar k sfbf pqfelogfnif.",
	DISPLAY_MESSAGE,
	"Pomodi i poltxiy} nadqaet.",
	CHANGE_CHARACTER,
	"R xfdo mnf pomodas}?",
	CHANGE_CHARACTER,
	"Xtcrsco robrscfnnodo eorsoinrsca?",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog198[] = {
	CHANGE_CHARACTER,
	"Pqihnanif?",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog199[] = {
	CHANGE_CHARACTER,
	"Pasqiosihm?",
	END_DIALOG
};

const static char *russianDialog200[] = {
	CHANGE_CHARACTER,
	"Efcxonki?",
	CHANGE_CHARACTER,
	"C| o x>m?",
	CHANGE_CHARACTER,
	"Efctyki oboga\177s adfnsoc.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog201[] = {
	"Laeno, rodlarfn. Xso eflas}?",
	CHANGE_CHARACTER,
	"Pqfgef crfdo, pqfelada\177 sfbf",
	NEW_LINE,
	"rpfqca pqojsi poedosockt c nayfm",
	NEW_LINE,
	"orobom rfkqfsnom ladfqf.",
	DISPLAY_MESSAGE,
	"` c|eam sfbf pqoptrk.",
	DISPLAY_MESSAGE,
	"Ie>s?",
	CHANGE_CHARACTER,
	"Ie>s!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog202[] = {
	"...i ~so eagf b|lo cfrflo.",
	CHANGE_CHARACTER,
	"Qae, xso sfbf ponqacilir} nayi mfsoe| obtxfni\200.",
	DISPLAY_MESSAGE,
	"No pfqfje>m k eflt.",
	DISPLAY_MESSAGE,
	"Eolgfn pqihnas}r\200, \200 nf cfq\177,",
	NEW_LINE,
	"xso s| rmogfy} pomox}.",
	DISPLAY_MESSAGE,
	"Nixfdo lixnodo.",
	CHANGE_CHARACTER,
	"Naef\177r}.",
	CHANGE_CHARACTER,
	"No s| pqin>r nam teaxt.",
	DISPLAY_MESSAGE,
	"Nayi l\177ei c|yli na oenodo",
	NEW_LINE,
	"bihnfrmfna, kosoq|j nf rxisafs",
	NEW_LINE,
	"efn}di pqi poktpkf...",
	DISPLAY_MESSAGE,
	"...cfr}ma nfob|xn|v cfzfj.",
	DISPLAY_MESSAGE,
	"Sqi momfnsa c|h|ca\177s poeohqfni\200",
	NEW_LINE,
	"na fdo rx>s:",
	DISPLAY_MESSAGE,
	"...On plasis nalixkoj, xso rsqanno",
	NEW_LINE,
	"c cfk plarsikoc|v kaqs...",
	DISPLAY_MESSAGE,
	"...Co-csoq|v, poldoea nahae on i blihko nf b|l",
	NEW_LINE,
	"sak bodas, kak rfjxar...",
	DISPLAY_MESSAGE,
	"...C-sqfs}iv, na koj x>qs fmt",
	NEW_LINE,
	"ponaeobilor} 100 kd btq|?",
	CHANGE_CHARACTER,
	"Cohmogno, on pqorso xteak.",
	CHANGE_CHARACTER,
	"Cohmogno.",
	DISPLAY_MESSAGE,
	"No s| eolgfn c|lfsfs} na mfrso",
	NEW_LINE,
	"i pop|sas}r\200 pqoniknts} c fdo orobn\200k...",
	DISPLAY_MESSAGE,
	"...xsob| qaheob|s} bol}yf inuoqmawii.",
	DISPLAY_MESSAGE,
	"Xso rkagfy}?",
	CHANGE_CHARACTER,
	"Nt...",
	CHANGE_CHARACTER,
	"Obfza\177, xso porlf ~sodo haeani\200 s|",
	NEW_LINE,
	"ouiwial}no rsanfy} rfkqfsn|m adfnsom.",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Obfzafsf?",
	CHANGE_CHARACTER,
	"Xfrsnof rloco.",
	CHANGE_CHARACTER,
	"Laeno, \200 dosoc.",
	DISPLAY_MESSAGE,
	"Ktea ospqacl\200s}r\200?",
	CHANGE_CHARACTER,
	"C malfn}kt\177 efqfctykt.",
	DISPLAY_MESSAGE,
	"F> eagf na kaqsav nf naje>y}...",
	DISPLAY_MESSAGE,
	"No rpfqca \200 c|eam sfbf ornazfnif",
	NEW_LINE,
	"rpfwial}nodo adfnsa.",
	DISPLAY_MESSAGE,
	"` b| eal sfbf qfaksicn|f bosinki el\200 pol>soc,",
	NEW_LINE,
	"no tgf oseal iv komt-so.",
	DISPLAY_MESSAGE,
	"Mfdamozn|v pfqxasok",
	NEW_LINE,
	"sogf nf orsalor}.",
	DISPLAY_MESSAGE,
	"El\200 nayfdo efla t mfn\200 orsalr\200 sol}ko",
	NEW_LINE,
	"orob|j rtpfqklfj.",
	DISPLAY_MESSAGE,
	"Cr>-saki ~so ltxyf, xfm nixfdo...",
	DISPLAY_MESSAGE,
	"Teaxi!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog203[] = {
	CHANGE_CHARACTER,
	"Nf colntjr\200.",
	DISPLAY_MESSAGE,
	"On oklfmafsr\200.",
	DISPLAY_MESSAGE,
	"Con ~so stlocizf...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog204[] = {
	CHANGE_CHARACTER,
	"On poltxil po harltdam.",
	DISPLAY_MESSAGE,
	"No m| tgf posfq\200li tjmt cqfmfni. Cpfq>e!",
	CHANGE_CHARACTER,
	"Nfs! Rsojsf!",
	DISPLAY_MESSAGE,
	"Mnf ntgno tciefs}r\200 r Annoj!",
	CHANGE_CHARACTER,
	"^m... S| nf mogfy}.",
	CHANGE_CHARACTER,
	"^so fz> poxfmt?!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Cieiy} li... Anna b|la nayim adfnsom.",
	DISPLAY_MESSAGE,
	"Fj b|lo poqtxfno rlfeis} ha soboj,",
	NEW_LINE,
	"frli mikqokamfqa",
	NEW_LINE,
	"ceqtd rlomafsr\200.",
	DISPLAY_MESSAGE,
	"A fz> ona sfb\200 mosiciqocala...",
	CHANGE_CHARACTER,
	"` cam nf cfq\177!",
	CHANGE_CHARACTER,
	"Ona tgf ospqacilar}",
	NEW_LINE,
	"na eqtdof haeanif.",
	DISPLAY_MESSAGE,
	"Pqorsi.",
	CHANGE_CHARACTER,
	"Babtl\200, sak polada\177, sogf r cami?",
	CHANGE_CHARACTER,
	"Nfs, ona sam gic>s. M| fj haplasili.",
	CHANGE_CHARACTER,
	"A cos ~so insfqfrno.",
	DISPLAY_MESSAGE,
	"Frli cr> sak, poxfmt t mfn\200 b|lo",
	NEW_LINE,
	"rsol}ko sqtenorsfj?...",
	CHANGE_CHARACTER,
	"M| poers>dicali sco\177 qfyimors}.",
	DISPLAY_MESSAGE,
	"M| qarrxis|cali, xso t sfb\200 ril}na\200 col\200.",
	DISPLAY_MESSAGE,
	"M| cfe} nf oyiblir}?",
	CHANGE_CHARACTER,
	"C| osnorisfr} k l\177e\200m kak k poeop|sn|m",
	NEW_LINE,
	"kqolikam.",
	DISPLAY_MESSAGE,
	"C| gfrsokij...",
	CHANGE_CHARACTER,
	"No cfe} efjrsctfs?",
	CHANGE_CHARACTER,
	"^so pqorso nfm|rlimo.",
	DISPLAY_MESSAGE,
	"Mogfs, fz> rkagfsf, xso robaka -",
	NEW_LINE,
	"hamarkiqocann|j adfns...",
	DISPLAY_MESSAGE,
	"...rsaqixok - moj ovqannik...",
	DISPLAY_MESSAGE,
	"...a rami c| r Maqra?!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog205[] = {
	CHANGE_CHARACTER,
	"^so nf sflfrfqial, ~so",
	NEW_LINE,
	"ob|xn|f bteni adfnsa.",
	DISPLAY_MESSAGE,
	"No crstpaj c KCE i rmogfy}",
	NEW_LINE,
	"qabosas} r Annoj t nar!",
	CHANGE_CHARACTER,
	ANIM_WAIT,
	"Nt...",
	DISPLAY_MESSAGE,
	"` poetma\177...",
	CHANGE_CHARACTER,
	"Heoqoco.",
	DISPLAY_MESSAGE,
	"Pqi\200sno b|lo nabl\177eas} ha scofj qabosoj!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog206[] = {
	CHANGE_CHARACTER,
	"Nixfdo nf qarrkah|caj.",
	DISPLAY_MESSAGE,
	"` tgf pqoxisal efsal}n|j osx>s.",
	CHANGE_CHARACTER,
	"A xso r pqoufrroqom?",
	CHANGE_CHARACTER,
	"O, bfen\200da rnoca hab|l qfwfps",
	NEW_LINE,
	"sablfsok.",
	DISPLAY_MESSAGE,
	"M| eaeim fmt nayt ltxyt\177 laboqasoqi\177.",
	DISPLAY_MESSAGE,
	"Rfjxar t nar liy} paqa sablfsok,",
	NEW_LINE,
	"kosoq|f s| nam eal.",
	CHANGE_CHARACTER,
	"A Egon Nosi?",
	CHANGE_CHARACTER,
	"Nf bfrpokojr\200, on poplasisr\200 ha rco\177 gaenors}.",
	CHANGE_CHARACTER,
	"Naef\177r}...",
	DISPLAY_MESSAGE,
	"I fz> oena mflox}...",
	DISPLAY_MESSAGE,
	"C| mnf kof-xso obfzali...",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog207[] = {
	CHANGE_CHARACTER,
	"`?..",
	DISPLAY_MESSAGE,
	"Nf pomn\177...",
	CHANGE_CHARACTER,
	"C| rkahali, \200 rsant narso\200zim adfnsom...",
	DISPLAY_MESSAGE,
	"\"Efctyki oboga\177s adfnsoc\". Pomnisf?",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog208[] = {
	CHANGE_CHARACTER,
	"(cheov)",
	DISPLAY_MESSAGE,
	"Obfzanif frs} obfzanif...",
	DISPLAY_MESSAGE,
	"Eaj poetmas}.",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Laeno. Poeojei.",
	"\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog209[] = {
	"Imfnfm...",
	DISPLAY_MESSAGE,
	"...bla-bla-bla...",
	DISPLAY_MESSAGE,
	"...bla-bla...",
	DISPLAY_MESSAGE,
	"...ha nayt rsqant.",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog210[] = {
	"Nt...",
	DISPLAY_MESSAGE,
	"Cos i cr>, qfb\200sa!",
	"\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog211[] = {
	"` nay>l sablfskt cqfmfni!",
	DISPLAY_MESSAGE,
	"Nacfqnof, c|calilar} ih banki!..",
	DISPLAY_MESSAGE,
	ANIM_WAIT,
	"Kqtso.",
	"\x1f\x1f",
	END_DIALOG
};

const static char *russianDialog212[] = {
	"Odo!",
	DISPLAY_MESSAGE,
	"Oxaqocasfl}no!..",
	"\x1f\x1f\x1f\x1f",
	END_DIALOG
};

const static char **englishDialogs[] = {
	englishDialog0,
	englishDialog1,
	englishDialog2,
	englishDialog3,
	englishDialog4,
	englishDialog5,
	englishDialog6,
	englishDialog7,
	englishDialog8,
	englishDialog9,
	englishDialog10,
	englishDialog11,
	englishDialog12,
	englishDialog13,
	englishDialog14,
	englishDialog15,
	englishDialog16,
	englishDialog17,
	englishDialog18,
	englishDialog19,
	englishDialog20,
	englishDialog21,
	englishDialog22,
	englishDialog23,
	englishDialog24,
	englishDialog25,
	englishDialog26,
	englishDialog27,
	englishDialog28,
	englishDialog29,
	englishDialog30,
	englishDialog31,
	englishDialog32,
	englishDialog33,
	englishDialog34,
	englishDialog35,
	englishDialog36,
	englishDialog37,
	englishDialog38,
	englishDialog39,
	englishDialog40,
	englishDialog41,
	englishDialog42,
	englishDialog43,
	englishDialog44,
	englishDialog45,
	englishDialog46,
	englishDialog47,
	englishDialog48,
	englishDialog49,
	englishDialog50,
	englishDialog51,
	englishDialog52,
	englishDialog53,
	englishDialog54,
	englishDialog55,
	englishDialog56,
	englishDialog57,
	englishDialog58,
	englishDialog59,
	englishDialog60,
	englishDialog61,
	englishDialog62,
	englishDialog63,
	englishDialog64,
	englishDialog65,
	englishDialog66,
	englishDialog67,
	englishDialog68,
	englishDialog69,
	englishDialog70,
	englishDialog71,
	englishDialog72,
	englishDialog73,
	englishDialog74,
	englishDialog75,
	englishDialog76,
	englishDialog77,
	englishDialog78,
	englishDialog79,
	englishDialog80,
	englishDialog81,
	englishDialog82,
	englishDialog83,
	englishDialog84,
	englishDialog85,
	englishDialog86,
	englishDialog87,
	englishDialog88,
	englishDialog89,
	englishDialog90,
	englishDialog91,
	englishDialog92,
	englishDialog93,
	englishDialog94,
	englishDialog95,
	englishDialog96,
	englishDialog97,
	englishDialog98,
	englishDialog99,
	englishDialog100,
	englishDialog101,
	englishDialog102,
	englishDialog103,
	englishDialog104,
	englishDialog105,
	englishDialog106,
	englishDialog107,
	englishDialog108,
	englishDialog109,
	englishDialog110,
	englishDialog111,
	englishDialog112,
	englishDialog113,
	englishDialog114,
	englishDialog115,
	englishDialog116,
	englishDialog117,
	englishDialog118,
	englishDialog119,
	englishDialog120,
	englishDialog121,
	englishDialog122,
	englishDialog123,
	englishDialog124,
	englishDialog125,
	englishDialog126,
	englishDialog127,
	englishDialog128,
	englishDialog129,
	englishDialog130,
	englishDialog131,
	englishDialog132,
	englishDialog133,
	englishDialog134,
	englishDialog135,
	englishDialog136,
	englishDialog137,
	englishDialog138,
	englishDialog139,
	englishDialog140,
	englishDialog141,
	englishDialog142,
	englishDialog143,
	englishDialog144,
	englishDialog145,
	englishDialog146,
	englishDialog147,
	englishDialog148,
	englishDialog149,
	englishDialog150,
	englishDialog151,
	englishDialog152,
	englishDialog153,
	englishDialog154,
	englishDialog155,
	englishDialog156,
	englishDialog157,
	englishDialog158,
	englishDialog159,
	englishDialog160,
	englishDialog161,
	englishDialog162,
	englishDialog163,
	englishDialog164,
	englishDialog165,
	englishDialog166,
	englishDialog167,
	englishDialog168,
	englishDialog169,
	englishDialog170,
	englishDialog171,
	englishDialog172,
	englishDialog173,
	englishDialog174,
	englishDialog175,
	englishDialog176,
	englishDialog177,
	englishDialog178,
	englishDialog179,
	englishDialog180,
	englishDialog181,
	englishDialog182,
	englishDialog183,
	englishDialog184,
	englishDialog185,
	englishDialog186,
	englishDialog187,
	englishDialog188,
	englishDialog189,
	englishDialog190,
	englishDialog191,
	englishDialog192,
	englishDialog193,
	englishDialog194,
	englishDialog195,
	englishDialog196,
	englishDialog197,
	englishDialog198,
	englishDialog199,
	englishDialog200,
	englishDialog201,
	englishDialog202,
	englishDialog203,
	englishDialog204,
	englishDialog205,
	englishDialog206,
	englishDialog207,
	englishDialog208,
	englishDialog209,
	englishDialog210,
	englishDialog211,
	englishDialog212
};

const static char **polishDialogs[] = {
	polishDialog0,
	polishDialog1,
	polishDialog2,
	polishDialog3,
	polishDialog4,
	polishDialog5,
	polishDialog6,
	polishDialog7,
	polishDialog8,
	polishDialog9,
	polishDialog10,
	polishDialog11,
	polishDialog12,
	polishDialog13,
	polishDialog14,
	polishDialog15,
	polishDialog16,
	polishDialog17,
	polishDialog18,
	polishDialog19,
	polishDialog20,
	polishDialog21,
	polishDialog22,
	polishDialog23,
	polishDialog24,
	polishDialog25,
	polishDialog26,
	polishDialog27,
	polishDialog28,
	polishDialog29,
	polishDialog30,
	polishDialog31,
	polishDialog32,
	polishDialog33,
	polishDialog34,
	polishDialog35,
	polishDialog36,
	polishDialog37,
	polishDialog38,
	polishDialog39,
	polishDialog40,
	polishDialog41,
	polishDialog42,
	polishDialog43,
	polishDialog44,
	polishDialog45,
	polishDialog46,
	polishDialog47,
	polishDialog48,
	polishDialog49,
	polishDialog50,
	polishDialog51,
	polishDialog52,
	polishDialog53,
	polishDialog54,
	polishDialog55,
	polishDialog56,
	polishDialog57,
	polishDialog58,
	polishDialog59,
	polishDialog60,
	polishDialog61,
	polishDialog62,
	polishDialog63,
	polishDialog64,
	polishDialog65,
	polishDialog66,
	polishDialog67,
	polishDialog68,
	polishDialog69,
	polishDialog70,
	polishDialog71,
	polishDialog72,
	polishDialog73,
	polishDialog74,
	polishDialog75,
	polishDialog76,
	polishDialog77,
	polishDialog78,
	polishDialog79,
	polishDialog80,
	polishDialog81,
	polishDialog82,
	polishDialog83,
	polishDialog84,
	polishDialog85,
	polishDialog86,
	polishDialog87,
	polishDialog88,
	polishDialog89,
	polishDialog90,
	polishDialog91,
	polishDialog92,
	polishDialog93,
	polishDialog94,
	polishDialog95,
	polishDialog96,
	polishDialog97,
	polishDialog98,
	polishDialog99,
	polishDialog100,
	polishDialog101,
	polishDialog102,
	polishDialog103,
	polishDialog104,
	polishDialog105,
	polishDialog106,
	polishDialog107,
	polishDialog108,
	polishDialog109,
	polishDialog110,
	polishDialog111,
	polishDialog112,
	polishDialog113,
	polishDialog114,
	polishDialog115,
	polishDialog116,
	polishDialog117,
	polishDialog118,
	polishDialog119,
	polishDialog120,
	polishDialog121,
	polishDialog122,
	polishDialog123,
	polishDialog124,
	polishDialog125,
	polishDialog126,
	polishDialog127,
	polishDialog128,
	polishDialog129,
	polishDialog130,
	polishDialog131,
	polishDialog132,
	polishDialog133,
	polishDialog134,
	polishDialog135,
	polishDialog136,
	polishDialog137,
	polishDialog138,
	polishDialog139,
	polishDialog140,
	polishDialog141,
	polishDialog142,
	polishDialog143,
	polishDialog144,
	polishDialog145,
	polishDialog146,
	polishDialog147,
	polishDialog148,
	polishDialog149,
	polishDialog150,
	polishDialog151,
	polishDialog152,
	polishDialog153,
	polishDialog154,
	polishDialog155,
	polishDialog156,
	polishDialog157,
	polishDialog158,
	polishDialog159,
	polishDialog160,
	polishDialog161,
	polishDialog162,
	polishDialog163,
	polishDialog164,
	polishDialog165,
	polishDialog166,
	polishDialog167,
	polishDialog168,
	polishDialog169,
	polishDialog170,
	polishDialog171,
	polishDialog172,
	polishDialog173,
	polishDialog174,
	polishDialog175,
	polishDialog176,
	polishDialog177,
	polishDialog178,
	polishDialog179,
	polishDialog180,
	polishDialog181,
	polishDialog182,
	polishDialog183,
	polishDialog184,
	polishDialog185,
	polishDialog186,
	polishDialog187,
	polishDialog188,
	polishDialog189,
	polishDialog190,
	polishDialog191,
	polishDialog192,
	polishDialog193,
	polishDialog194,
	polishDialog195,
	polishDialog196,
	polishDialog197,
	polishDialog198,
	polishDialog199,
	polishDialog200,
	polishDialog201,
	polishDialog202,
	polishDialog203,
	polishDialog204,
	polishDialog205,
	polishDialog206,
	polishDialog207,
	polishDialog208,
	polishDialog209,
	polishDialog210,
	polishDialog211,
	polishDialog212
};

const static char **czechDialogs[] = {
	czechDialog0,
	czechDialog1,
	czechDialog2,
	czechDialog3,
	czechDialog4,
	czechDialog5,
	czechDialog6,
	czechDialog7,
	czechDialog8,
	czechDialog9,
	czechDialog10,
	czechDialog11,
	czechDialog12,
	czechDialog13,
	czechDialog14,
	czechDialog15,
	czechDialog16,
	czechDialog17,
	czechDialog18,
	czechDialog19,
	czechDialog20,
	czechDialog21,
	czechDialog22,
	czechDialog23,
	czechDialog24,
	czechDialog25,
	czechDialog26,
	czechDialog27,
	czechDialog28,
	czechDialog29,
	czechDialog30,
	czechDialog31,
	czechDialog32,
	czechDialog33,
	czechDialog34,
	czechDialog35,
	czechDialog36,
	czechDialog37,
	czechDialog38,
	czechDialog39,
	czechDialog40,
	czechDialog41,
	czechDialog42,
	czechDialog43,
	czechDialog44,
	czechDialog45,
	czechDialog46,
	czechDialog47,
	czechDialog48,
	czechDialog49,
	czechDialog50,
	czechDialog51,
	czechDialog52,
	czechDialog53,
	czechDialog54,
	czechDialog55,
	czechDialog56,
	czechDialog57,
	czechDialog58,
	czechDialog59,
	czechDialog60,
	czechDialog61,
	czechDialog62,
	czechDialog63,
	czechDialog64,
	czechDialog65,
	czechDialog66,
	czechDialog67,
	czechDialog68,
	czechDialog69,
	czechDialog70,
	czechDialog71,
	czechDialog72,
	czechDialog73,
	czechDialog74,
	czechDialog75,
	czechDialog76,
	czechDialog77,
	czechDialog78,
	czechDialog79,
	czechDialog80,
	czechDialog81,
	czechDialog82,
	czechDialog83,
	czechDialog84,
	czechDialog85,
	czechDialog86,
	czechDialog87,
	czechDialog88,
	czechDialog89,
	czechDialog90,
	czechDialog91,
	czechDialog92,
	czechDialog93,
	czechDialog94,
	czechDialog95,
	czechDialog96,
	czechDialog97,
	czechDialog98,
	czechDialog99,
	czechDialog100,
	czechDialog101,
	czechDialog102,
	czechDialog103,
	czechDialog104,
	czechDialog105,
	czechDialog106,
	czechDialog107,
	czechDialog108,
	czechDialog109,
	czechDialog110,
	czechDialog111,
	czechDialog112,
	czechDialog113,
	czechDialog114,
	czechDialog115,
	czechDialog116,
	czechDialog117,
	czechDialog118,
	czechDialog119,
	czechDialog120,
	czechDialog121,
	czechDialog122,
	czechDialog123,
	czechDialog124,
	czechDialog125,
	czechDialog126,
	czechDialog127,
	czechDialog128,
	czechDialog129,
	czechDialog130,
	czechDialog131,
	czechDialog132,
	czechDialog133,
	czechDialog134,
	czechDialog135,
	czechDialog136,
	czechDialog137,
	czechDialog138,
	czechDialog139,
	czechDialog140,
	czechDialog141,
	czechDialog142,
	czechDialog143,
	czechDialog144,
	czechDialog145,
	czechDialog146,
	czechDialog147,
	czechDialog148,
	czechDialog149,
	czechDialog150,
	czechDialog151,
	czechDialog152,
	czechDialog153,
	czechDialog154,
	czechDialog155,
	czechDialog156,
	czechDialog157,
	czechDialog158,
	czechDialog159,
	czechDialog160,
	czechDialog161,
	czechDialog162,
	czechDialog163,
	czechDialog164,
	czechDialog165,
	czechDialog166,
	czechDialog167,
	czechDialog168,
	czechDialog169,
	czechDialog170,
	czechDialog171,
	czechDialog172,
	czechDialog173,
	czechDialog174,
	czechDialog175,
	czechDialog176,
	czechDialog177,
	czechDialog178,
	czechDialog179,
	czechDialog180,
	czechDialog181,
	czechDialog182,
	czechDialog183,
	czechDialog184,
	czechDialog185,
	czechDialog186,
	czechDialog187,
	czechDialog188,
	czechDialog189,
	czechDialog190,
	czechDialog191,
	czechDialog192,
	czechDialog193,
	czechDialog194,
	czechDialog195,
	czechDialog196,
	czechDialog197,
	czechDialog198,
	czechDialog199,
	czechDialog200,
	czechDialog201,
	czechDialog202,
	czechDialog203,
	czechDialog204,
	czechDialog205,
	czechDialog206,
	czechDialog207,
	czechDialog208,
	czechDialog209,
	czechDialog210,
	czechDialog211,
	czechDialog212
};

const static char **russianDialogs[] = {
	russianDialog0,
	russianDialog1,
	russianDialog2,
	russianDialog3,
	russianDialog4,
	russianDialog5,
	russianDialog6,
	russianDialog7,
	russianDialog8,
	russianDialog9,
	russianDialog10,
	russianDialog11,
	russianDialog12,
	russianDialog13,
	russianDialog14,
	russianDialog15,
	russianDialog16,
	russianDialog17,
	russianDialog18,
	russianDialog19,
	russianDialog20,
	russianDialog21,
	russianDialog22,
	russianDialog23,
	russianDialog24,
	russianDialog25,
	russianDialog26,
	russianDialog27,
	russianDialog28,
	russianDialog29,
	russianDialog30,
	russianDialog31,
	russianDialog32,
	russianDialog33,
	russianDialog34,
	russianDialog35,
	russianDialog36,
	russianDialog37,
	russianDialog38,
	russianDialog39,
	russianDialog40,
	russianDialog41,
	russianDialog42,
	russianDialog43,
	russianDialog44,
	russianDialog45,
	russianDialog46,
	russianDialog47,
	russianDialog48,
	russianDialog49,
	russianDialog50,
	russianDialog51,
	russianDialog52,
	russianDialog53,
	russianDialog54,
	russianDialog55,
	russianDialog56,
	russianDialog57,
	russianDialog58,
	russianDialog59,
	russianDialog60,
	russianDialog61,
	russianDialog62,
	russianDialog63,
	russianDialog64,
	russianDialog65,
	russianDialog66,
	russianDialog67,
	russianDialog68,
	russianDialog69,
	russianDialog70,
	russianDialog71,
	russianDialog72,
	russianDialog73,
	russianDialog74,
	russianDialog75,
	russianDialog76,
	russianDialog77,
	russianDialog78,
	russianDialog79,
	russianDialog80,
	russianDialog81,
	russianDialog82,
	russianDialog83,
	russianDialog84,
	russianDialog85,
	russianDialog86,
	russianDialog87,
	russianDialog88,
	russianDialog89,
	russianDialog90,
	russianDialog91,
	russianDialog92,
	russianDialog93,
	russianDialog94,
	russianDialog95,
	russianDialog96,
	russianDialog97,
	russianDialog98,
	russianDialog99,
	russianDialog100,
	russianDialog101,
	russianDialog102,
	russianDialog103,
	russianDialog104,
	russianDialog105,
	russianDialog106,
	russianDialog107,
	russianDialog108,
	russianDialog109,
	russianDialog110,
	russianDialog111,
	russianDialog112,
	russianDialog113,
	russianDialog114,
	russianDialog115,
	russianDialog116,
	russianDialog117,
	russianDialog118,
	russianDialog119,
	russianDialog120,
	russianDialog121,
	russianDialog122,
	russianDialog123,
	russianDialog124,
	russianDialog125,
	russianDialog126,
	russianDialog127,
	russianDialog128,
	russianDialog129,
	russianDialog130,
	russianDialog131,
	russianDialog132,
	russianDialog133,
	russianDialog134,
	russianDialog135,
	russianDialog136,
	russianDialog137,
	russianDialog138,
	russianDialog139,
	russianDialog140,
	russianDialog141,
	russianDialog142,
	russianDialog143,
	russianDialog144,
	russianDialog145,
	russianDialog146,
	russianDialog147,
	russianDialog148,
	russianDialog149,
	russianDialog150,
	russianDialog151,
	russianDialog152,
	russianDialog153,
	russianDialog154,
	russianDialog155,
	russianDialog156,
	russianDialog157,
	russianDialog158,
	russianDialog159,
	russianDialog160,
	russianDialog161,
	russianDialog162,
	russianDialog163,
	russianDialog164,
	russianDialog165,
	russianDialog166,
	russianDialog167,
	russianDialog168,
	russianDialog169,
	russianDialog170,
	russianDialog171,
	russianDialog172,
	russianDialog173,
	russianDialog174,
	russianDialog175,
	russianDialog176,
	russianDialog177,
	russianDialog178,
	russianDialog179,
	russianDialog180,
	russianDialog181,
	russianDialog182,
	russianDialog183,
	russianDialog184,
	russianDialog185,
	russianDialog186,
	russianDialog187,
	russianDialog188,
	russianDialog189,
	russianDialog190,
	russianDialog191,
	russianDialog192,
	russianDialog193,
	russianDialog194,
	russianDialog195,
	russianDialog196,
	russianDialog197,
	russianDialog198,
	russianDialog199,
	russianDialog200,
	russianDialog201,
	russianDialog202,
	russianDialog203,
	russianDialog204,
	russianDialog205,
	russianDialog206,
	russianDialog207,
	russianDialog208,
	russianDialog209,
	russianDialog210,
	russianDialog211,
	russianDialog212
};

const static char *englishItem0[] = {
	"feather",
	"\n",
	"It\'s kicking ass!",
	"\n\n",
};

const static char *englishItem1[] = {
	"shotgun",
	"\n",
	"Looks impressive...",
	"\n\n",
};

const static char *englishItem2[] = {
	"toolbox",
	"\n",
	"Doesn\'t seem to be locked!...",
	"\n\n",
};

const static char *englishItem3[] = {
	"toolbox",
	// No description
	"\n\n",
};

const static char *englishItem4[] = {
	"spanner",
	"\n",
	"These things always come in handy.",
	"\n\n",
};

const static char *englishItem5[] = {
	"comb",
	"\n",
	"I\'ve heard that some people use these.",
	"\n\n",
};

const static char *englishItem6[] = {
	"fan",
	"\n",
	"Refreshing.",
	"\n\n",
};

const static char *englishItem7[] = {
	"broken paddle",
	"\n",
	"Too short to use.",
	"\n\n",
};

const static char *englishItem8[] = {
	"paddle",
	"\n",
	"The glue keeps the branch",
	"\n",
	"really hard.",
	"\n\n",
};

const static char *englishItem9[] = {
	"flower",
	"\n",
	"It really smells",
	"\n",
	"very nice.",
	"\n\n",
};

const static char *englishItem10[] = {
	"flower",
	"\n",
	"It\'s really beautiful.",
	"\n\n",
};

const static char *englishItem11[] = {
	"feather duster",
	"\n",
	"I can play janitor with this.",
	"\n\n",
};

const static char *englishItem12[] = {
	"chainsaw",
	"\n",
	"It\'s in good condition, but it has no fuel.",
	"\n\n",
};

const static char *englishItem13[] = {
	"drunken chainsaw",
	"\n",
	"A bit unsteady, but will work.",
	"\n\n",
};

const static char *englishItem14[] = {
	"branch",
	"\n",
	"The wood is very hard.",
	"\n\n",
};

const static char *englishItem15[] = {
	"whisky",
	"\n",
	"The label says this whisky is",
	"\n",
	"very strong.",
	"\n\n",
};

const static char *englishItem16[] = {
	"needle",
	"\n",
	"It\'s quite big for a needle...",
	"\n\n",
};

const static char *englishItem17[] = {
	"wrapper",
	"\n",
	"Nice design. Especially that \'LOVE CANDY\' label.",
	"\n",
	"And there\'s a heart painted on it.",
	"\n",
	"How SWEET...",
	"\n\n",
};

const static char *englishItem18[] = {
	"chocolate candy",
	"\n",
	"It\'s round chocolate candy.",
	"\n",
	"A great present.",
	"\n\n",
};

const static char *englishItem19[] = {
	"wild potatoe",
	"\n",
	"Wow! It\'s shaped like a grenade!..",
	"\n\n",
};

const static char *englishItem20[] = {
	"rake",
	"\n",
	"The space between the teeth is too large",
	"\n",
	"to make this rake an useful.",
	"\n\n",
};

const static char *englishItem21[] = {
	"heart-shaped candy",
	"\n",
	"I don\'t think this one improvement is enough.",
	"\n\n",
};

const static char *englishItem22[] = {
	"wrapped candy",
	"\n",
	"Brand new candy. At least it looks like it.",
	"\n\n",
};

const static char *englishItem23[] = {
	"ribbon",
	"\n",
	"It will remind me of that beatiful chick,",
	"\n",
	"I mean, female human being.",
	"\n\n",
};

const static char *englishItem24[] = {
	"rake",
	"\n",
	"Ready to work.",
	"\n\n",
};

const static char *englishItem25[] = {
	"nut",
	"\n",
	"A really big one.",
	"\n\n",
};

const static char *englishItem26[] = {
	"plastic apple",
	"\n",
	"It looks so real that I could",
	"\n",
	"even see the pips inside.",
	"\n\n",
};

const static char *englishItem27[] = {
	"cone",
	"\n",
	"It looks like one of those Havana goodies every",
	"\n",
	"self-respecting businessman is supposed to have",
	"\n",
	"glued to his smile.",
	"\n\n",
};

const static char *englishItem28[] = {
	"super glue",
	"\n",
	"It\'s turbo mega giga super ultra",
	"\n",
	"fast drying glue plus.",
	"\n\n",
};

const static char *englishItem29[] = {
	"cone & needle",
	"\n",
	"Something is still missing here...",
	"\n\n",
};

const static char *englishItem30[] = {
	"cone & feather",
	"\n",
	"Something is still missing here...",
	"\n\n",
};

const static char *englishItem31[] = {
	"dart",
	"\n",
	"Now all I need is a target!",
	"\n\n",
};

const static char *englishItem32[] = {
	"dirty feather duster",
	"\n",
	"It\'s clammy and soiled by soot.",
	"\n\n",
};

const static char *englishItem33[] = {
	"painted potatoe",
	"\n",
	"The only difference between this and a grenade",
	"\n",
	"is that potatoees usually don\'t blow up.",
	"\n\n",
};

const static char *englishItem34[] = {
	"car jack",
	"\n",
	"Looks reliable.",
	"\n\n",
};

const static char *englishItem35[] = {
	"dino bone",
	"\n",
	"It\'s big and well preserved. It must have been",
	"\n",
	"a really big, er..., animal, I think...",
	"\n\n",
};

const static char *englishItem36[] = {
	"shovel",
	"\n",
	"I can PLAY DIGGER with it. So to speak.",
	"\n\n",
};

const static char *englishItem37[] = {
	"rope",
	"\n",
	"Looks strong.",
	"\n\n",
};

const static char *englishItem38[] = {
	"mask",
	"\n",
	"It will help me see better underwater.",
	"\n\n",
};

const static char *englishItem39[] = {
	"fins",
	"\n",
	"They will help me feel more like my",
	"\n",
	"underwater brothers.",
	"\n\n",
};

const static char *englishItem40[] = {
	"diving equipment",
	"\n",
	"Watch out, water! Here I come!",
	"\n\n",
};

const static char *englishItem41[] = {
	"anchor",
	"\n",
	"Not big, but heavy enough to sink the boat.",
	"\n\n",
};

const static char *englishItem42[] = {
	"grappling hook",
	"\n",
	"Watch out, mountains, here I come!",
	"\n\n",
};

const static char *englishItem43[] = {
	"sickle",
	"\n",
	"It\'s so blunt, that I couldn\'t even cut",
	"\n",
	"butter with it.",
	"\n\n",
};

const static char *englishItem44[] = {
	"somewhat rotten cheese",
	"\n",
	"Reminds me of my room.",
	"\n\n",
};

const static char *englishItem45[] = {
	"sharpened sickle",
	"\n",
	"Lambs, be silent. Here comes the pain...",
	"\n\n",
};

const static char *englishItem46[] = {
	"handkerchief",
	"\n",
	"The owner must have such big nose that he needs",
	"\n",
	"to use a whole bar of soap just to wash it.",
	"\n\n",
};

const static char *englishItem47[] = {
	"mouse",
	"\n",
	"It\'s very active.",
	"\n\n",
};

const static char *englishItem48[] = {
	"rock",
	"\n",
	"It\'s very regular, just like the snowball.",
	"\n\n",
};

const static char *englishItem49[] = {
	"nugget",
	"\n",
	"Symbol: Au, atomic no: 79, atomic wt.: 196.97.",
	"\n",
	"In other words: GOLD!!! Yes! Yes!",
	"\n\n",
};

const static char *englishItem50[] = {
	"banknote",
	// No description
	"\n\n",
};

const static char *englishItem51[] = {
	"dictaphone",
	"\n",
	"There are no batteries inside.",
	"\n\n",
};

const static char *englishItem52[] = {
	"polaroid",
	"\n",
	"It\'s ready to take a picture.",
	"\n\n",
};

const static char *englishItem53[] = {
	"video tape",
	"\n",
	"It has no label.",
	"\n\n",
};

const static char *englishItem54[] = {
	"sheet of paper",
	"\n",
	"There\'s nothing important about it.",
	"\n\n",
};

const static char *englishItem55[] = {
	"cognac",
	"\n",
	"Fancy name just for an excuse for drinking.",
	"\n\n",
};

const static char *englishItem56[] = {
	"remote control",
	"\n",
	"It has user-friendly interface.",
	"\n",
	"One can play and stop.",
	"\n\n",
};

const static char *englishItem57[] = {
	"ice tongs",
	"\n",
	"Very handy tool.",
	"\n\n",
};

const static char *englishItem58[] = {
	"cork",
	"\n",
	"It\'s a stopper kind of cork.",
	"\n\n",
};

const static char *englishItem59[] = {
	"wrapped cork",
	"\n",
	"Now it\'s more appropiate.",
	"\n\n",
};

const static char *englishItem60[] = {
	"photo",
	"\n",
	"It\'s a photo of John Noty. I caught him",
	"\n",
	"when he was singing the high C. Yuck!",
	"\n\n",
};

const static char *englishItem61[] = {
	"chilli",
	"\n",
	"The label on the bottle says it\'s",
	"\n",
	"\'ORIGINAL MEXICAN CHILLI\'. Sure.",
	"\n\n",
};

const static char *englishItem62[] = {
	"pastry roller",
	"\n",
	"It\'s made of very hard wood.",
	"\n\n",
};

const static char *englishItem63[] = {
	"fake chilli",
	"\n",
	"Now that\'s what I call strong seasoning.",
	"\n\n",
};

const static char *englishItem64[] = {
	"label",
	"\n",
	"\'ORIGINAL MEXICAN CHILLI\'.",
	"\n\n",
};

const static char *englishItem65[] = {
	"batteries",
	"\n",
	"It\'s a pair of new batteries.",
	"\n\n",
};

const static char *englishItem66[] = {
	"dictaphone",
	"\n",
	"\'One-two-one-two, it\'s me the one",
	"\n",
	"and only Mark MC....\'",
	"\n",
	"It works.",
	"\n\n",
};

const static char *englishItem67[] = {
	"burning paper",
	"\n",
	"Amazing, isn\'t it?",
	"\n",
	"(Not to mention: unbelievable).",
	"\n\n",
};

const static char *englishItem68[] = {
	"meat",
	"\n",
	"There\'s veal in the plastic bag.",
	"\n\n",
};

const static char *englishItem69[] = {
	"plastic bag",
	"\n",
	"Gee, I hope it\'s recyclable. I couldn\'t",
	"\n",
	"sleep otherwise.",
	"\n\n",
};

const static char *englishItem70[] = {
	"socks",
	"\n",
	"These socks suck.",
	"\n\n",
};

const static char *englishItem71[] = {
	"pills",
	"\n",
	"There are about twenty pills in this jar.",
	"\n\n",
};

const static char *englishItem72[] = {
	"handle",
	"\n",
	"It looks like a standard door handle...",
	"\n\n",
};

const static char *englishItem73[] = {
	"chilli",
	"\n",
	"Nice bottle. I like the shape.",
	"\n\n",
};

const static char *englishItem74[] = {
	"pass",
	"\n",
	"\"Let this guy in. RGB Chief.\"",
	"\n\n",
};

const static char *englishItem75[] = {
	"bulb",
	"\n",
	"It\'s completely useless.",
	"\n\n",
};

const static char *englishItem76[] = {
	"jail key",
	"\n",
	"Surprisingly, it\'s the key to the jail.",
	"\n\n",
};

const static char *englishItem77[] = {
	"delicate plant",
	"\n",
	"Whoa, it tickles!",
	"\n\n",
};

const static char *englishItem78[] = {
	"Swiss Army knife",
	"\n",
	"I wonder if it\'s got a TV on these too.",
	"\n\n",
};

const static char *englishItem79[] = {
	"spring",
	"\n",
	"I could launch a rocket with it!",
	"\n\n",
};

const static char *englishItem80[] = {
	"shovel",
	"\n",
	"Nice, handy tool.",
	"\n\n",
};

const static char *englishItem81[] = {
	"kaleidoscope",
	"\n",
	"I could spend my whole life looking through",
	"\n",
	"this. Well, let\'s say five minutes.",
	"\n",
	"Oh, all right, it\'s boring.",
	"\n\n",
};

const static char *englishItem82[] = {
	"\"Soldier News\"",
	"\n",
	"It\'s just the same as women\'s magazines,",
	"\n",
	"but there are guns instead of perfumes.",
	"\n",
	"It\'s cool anyway.",
	"\n\n",
};

const static char *englishItem83[] = {
	"grenade",
	"\n",
	"I must be crazy to put in my pocket.",
	"\n",
	"Something horrible might happen...",
	"\n\n",
};

const static char *englishItem84[] = {
	"mug",
	"\n",
	"It\'s empty.",
	"\n\n",
};

const static char *englishItem85[] = {
	"mug full of mud",
	"\n",
	"Why did I fill the mug with mud?",
	// Remove extra byte
	// "\n",
	"\n",
	"That makes no sense!",
	"\n\n",
};

const static char *englishItem86[] = {
	"crumbs",
	"\n",
	"These are some remains of bread.",
	"\n\n",
};

const static char *englishItem87[] = {
	"rope",
	"\n",
	"It\'s thin and long.",
	"\n\n",
};

const static char *englishItem88[] = {
	"rope tied to grenade",
	"\n",
	"My patent for a bombastic yoyo.",
	"\n\n",
};

const static char *englishItem89[] = {
	"medicine",
	"\n",
	"They look like sleeping pills.",
	"\n",
	"Although I don\'t have any idea why.",
	"\n\n",
};

const static char *englishItem90[] = {
	"drugged food",
	"\n",
	"Smells like Teen Spirit.",
	"\n\n",
};

const static char *englishItem91[] = {
	"bird",
	"\n",
	"It would make a great dinn... I mean",
	"\n",
	"friend, of course.",
	"\n\n",
};

const static char *polishItem0[] = {
	"pi*ro",
	"\n",
	"Troch# puszu i zostan# wodzem!",
	"\n\n",
};

const static char *polishItem1[] = {
	"strzelba",
	"\n",
	"Lufa jak tr@bka...",
	"\n\n",
};

const static char *polishItem2[] = {
	"skrzynka",
	"\n",
	"Chyba nie jest zamkni#ta na klucz!...",
	"\n\n",
