<h1 align="center">
  <img src="https://www.hackmanit.de/images/beitragsbilder/blog/Web-Cache-Vulnerability-Scanner-Banner.png" width="100%" alt=""/>
</h1>

[![Release](https://img.shields.io/github/release/Hackmanit/Web-Cache-Vulnerability-Scanner.svg?color=brightgreen)](https://github.com/Hackmanit/Web-Cache-Vulnerability-Scanner/releases/latest)
[![Go Report Card](https://goreportcard.com/badge/github.com/Hackmanit/Web-Cache-Vulnerability-Scanner)](https://goreportcard.com/report/github.com/Hackmanit/Web-Cache-Vulnerability-Scanner)
[![GitHub go.mod Go version](https://img.shields.io/github/go-mod/go-version/Hackmanit/Web-Cache-Vulnerability-Scanner)](https://golang.org/)
[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://www.apache.org/licenses/LICENSE-2.0)

Web Cache Vulnerability Scanner (WCVS) is a fast and versatile CLI scanner for [web cache poisoning](#background-information) and web cache deception developed by [Hackmanit](https://hackmanit.de) and [Maximilian Hildebrand](https://www.github.com/m10x).

The scanner supports many different web cache poisoning and web cache deception techniques, includes a crawler to identify further URLs to test,
and can adapt to a specific web cache for more efficient testing. It is highly customizable and can be easily integrated into existing CI/CD pipelines.

- [Features](#features)
- [Installation](#installation)
  - [Option 1: Pre-built Binary](#option-1-pre-built-binary)
  - [Option 2: Kali Linux / BlackArch Repository](#option-2-kali-linux--blackarch-repository)
  - [Option 3: Install Using Go](#option-3-install-using-go)
  - [Option 4: Docker](#option-4-docker)
- [Usage](#usage)
  - [Specify Headers, Parameters, Cookies, and More](#specify-headers-parameters-cookies-and-more)
  - [Generate a JSON Report](#generate-a-json-report)
  - [Crawl for URLs](#crawl-for-urls)
  - [Use a Proxy](#use-a-proxy)
  - [Throttle or Accelerate](#throttle-or-accelerate)
  - [Further Flags](#further-flags)
- [Background Information](#background-information)
- [License](#license)

# Features
- Support for 10 web cache poisoning techniques:
  1. Unkeyed header poisoning
  2. Unkeyed parameter poisoning
  3. Parameter cloaking
  4. Fat GET
  5. HTTP response splitting
  6. HTTP request smuggling
  7. HTTP header oversize (HHO)
  8. HTTP meta character (HMC)
  9. HTTP method override (HMO)
  10. Parameter pollution
- Support for multiple web cache deception techniques:
  1. Path Parameter
  2. Path Traversal (.css file, /static directory and /robots.txt)
  3. Appended special characters (both encoded and not encoded)
- Analyzing a web cache before testing and adapting to it for more efficient testing
- Generating a report in JSON format
- Crawling websites for further URLs to scan
- Routing traffic through a proxy (e.g., Burp Suite)
- Limiting requests per second to bypass rate limiting

# Installation
## Option 1: Pre-built Binary
Prebuilt binaries of WCVS are provided on the [releases page](https://github.com/Hackmanit/Web-Cache-Vulnerability-Scanner/releases).
## Option 2: Kali Linux / BlackArch Repository
- Kali Linux: `apt install web-cache-vulnerability-scanner`
- BlackArch: `pacman -S wcvs`
## Option 3: Install Using Go
The repository can be installed using Go.

go1.21 and higher
```
go install -v github.com/Hackmanit/Web-Cache-Vulnerability-Scanner@latest
```

## Option 4: Docker
### 1. Clone repository or download the [latest source code release](https://github.com/Hackmanit/Web-Cache-Vulnerability-Scanner/releases/latest)
### 2. Build image (the wordlists folder will also be copied)
```
$ docker build .
Sending build context to Docker daemon  29.54MB
Step 1/10 : FROM golang:latest AS builder
 ---> 05c8f6d2538a
Step 2/10 : WORKDIR /go/src/app
 ---> Using cache
 ---> f591f24be8cf
Step 3/10 : COPY . .
 ---> 38b358dd3472
Step 4/10 : RUN go get -d -v ./...
 ---> Running in 41f53de436c5
....
Removing intermediate container 9e2e84d14ff3
 ---> 1668edcf6ee3
Successfully built 1668edcf6ee3
```

### 3. Run wcvs
```
$ docker run -it 1668edcf6ee3 /wcvs --help
https://github.com/Hackmanit/Web-Cache-Vulnerability-Scanner
version 1.0.0
```

# Usage
WCVS is highly customizable using its flags. Many of the flags can either contain a value directly or the path to a file.

The only mandatory flag is `-u/--url` to provide the target URL which should be tested for web cache poisoning/deception. The target URL can be provided in different formats,

WCVS needs two wordlists in order to test for the first 5 techniques - one wordlist with header names and one with parameter names. The wordlists can either be present in the same directory WCVS is executed from or specified using the `--headerwordlist/-hw` and `--parameterwordlist/-pw` flags.

### Examples:
```
wcvs -u 127.0.0.1
wcvs -u http://127.0.0.1
wcvs -u https://example.com
wcvs -u file:path/to/url_list

wcvs -u https://example.com -hw "file:/home/user/Documents/wordlist-header.txt"
wcvs -u https://example.com -pw "file:/home/user/Documents/wordlist-parameter.txt"
wcvs -u https://example.com -hw "file:/home/user/Documents/wordlist-header.txt" -pw "file:/home/user/Documents/wordlist-parameter.txt"
```

## Specify Headers, Parameters, Cookies, and More
- `--cacheheader/-ch` specifies a custom cache header which will be checked for cache hits and misses
- `--setcookies/-sc` specifies cookies which shall be added to the request
- `--setheaders/-sh` specifies headers which shall be added to the request
- `--setparameters/-sp` specifies parameters which shall be added to the request. While it is also possible to simply add them to the URL, it might be more useful in some cases to add them via this flag.
- `--post/-post` changes the HTTP method from GET to POST
- `--setbody/-sb` specifies the body which shall be added to the request
- `--contenttype/-ct` specifies the value of the Content-Type header
- `--useragentchrome/-uac` changes the User-Agent from `WebCacheVulnerabilityScanner v{Version-Number}` to `Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.131 Safari/537.36`. While the same can be achieved with e.g. `-sh "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) ...`, this flag provides a quicker way.
- `--cacheheader/-ch` specify a custom cache header (case-insensitive)

#### If you want to specify more than 1 cookie, parameter or header you need to specify a file which contains them. Take a look at the [available templates](https://github.com/Hackmanit/Web-Cache-Vulnerability-Scanner/tree/master/templates).

### Examples:
```
wcvs -u https://example.com -ch "X-Custom-Header-ABC"

wcvs -u https://example.com -sc "PHPSESSID=123"
wcvs -u https://example.com -sc "file:/home/user/Documents/cookies.txt"

wcvs -u https://example.com -sh "Referer: localhost"
wcvs -u https://example.com -sh "file:/home/user/Documents/headers.txt"

wcvs -u https://example.com -sp "admin=true"
wcvs -u https://example.com -sp "file:/home/user/Documents/parameters.txt"

wcvs -u https://example.com -post -sb "admin=true"
wcvs -u https://example.com -post -sb "file:/home/user/Documents/body.txt"

wcvs -u https://example.com -post -sb "{}" -ct "application/json"

wcvs -u https://example.com -uac

wcvs -u https://example.com -ch "X-Custom-Cache-Header"
```

## Generate a JSON Report
A JSON report is generated and updated after each scanned URL if the flag `--generatereport/-gr` is set.
The report is written, just like a log file, into the same directory WCVS is executed from. In order to change the directory for all output files use `--generatepath/-gp`.
If HTML special chars shall be encoded in the report, use `--escapejson/-ej`.

### Examples:
```
wcvs -u https://example.com -gr
wcvs -u https://example.com -gr -ej
wcvs -u https://example.com -gr -gp /home/user/Documents
wcvs -u https://example.com -gr -gp /home/user/Documents -ej
```

## Crawl for URLs
In order to crawl for URLs, `--recursivity/-r` needs to be set. It specifies how deep the crawler shall go recursion-wise.
By default WCVS only crawls for URLs of the same domain. To also crawl for other domains, `--recdomains/red` can be used.
To only crawl URLs which inherit a specific string, `--recinclude/-rin` can be used.
`--reclimit/-rl` limits how many URLs are crawled for each recursion depth.
Also, a list with URLs which shall not be crawled can be specified with `--recexclude/-rex`. `--generatecompleted/-gc` can, for example, be used to generate a list with all already tested URLs. If a scan is repeated, but WCVS shall not crawl and test again the same URLs, this list can be used for `--recexclude/-rex`.
### Examples:
```
wcvs -u https://example.com -r 5
wcvs -u https://example.com -r 5 -red /home/user/Documents/mydomains.txt
wcvs -u https://example.com -r 5 -rl 2
wcvs -u https://example.com -r 5 -rex /home/user/Documents/donttest.txt
```

## Use a Proxy
To use a proxy, a CA certificate of the proxy in PEM format is needed.
Burp Suite certificates are provided in DER format, for example. To convert them, the following command can be used:
`openssl x509 -inform DER -outform PEM -text -in cacert.der -out cacert.pem`.
The path to the certificate can be specified with `--proxycertpath/-ppath`.
The default URL for the proxy is `http://127.0.0.1:8080`. In order to change it, use `--proxyurl/-purl`.

### Examples:
```
wcvs -u https://example.com -ppath /home/user/Documents/cacert.pem
wcvs -u https://example.com -ppath /home/user/Documents/cacert.pem -purl http://127.0.0.1:8081
```

## Throttle or Accelerate
The number of maximum allowed requests per second can be set with `--reqrate/-rr`. By default, this number is unrestricted.
Contrary, the number of requests per second can be increased potentially, if `--threads/-t` is used to increase the number of concurrent threads WCVS utilizes. The default value is 20.

### Examples:
```
wcvs -u https://example.com -rr 10
wcvs -u https://example.com -rr 1
wcvs -u https://example.com -rr 0.5
wcvs -u https://example.com -t 50
```

## Further Flags
WCVS provides even more than the beforehand mentioned flags and options. `--help/-h` provides a list of each flag, its meaning, and how to use it.

### Example:
```
wcvs -h
```

## Background Information
A short series of blog posts giving more information about web cache poisoning and WCVS can be found here:

1. [Is Your Application Vulnerable to Web Cache Poisoning?](https://www.hackmanit.de/en/blog-en/142-is-your-application-vulnerable-to-web-cache-poisoning)
2. [Web Cache Vulnerability Scanner (WCVS) - Free, Customizable, Easy-To-Use](https://www.hackmanit.de/en/blog-en/145-web-cache-vulnerability-scanner-wcvs-free-customizable-easy-to-use)

The Web Cache Vulnerability Scanner (WCVS) was developed as a part of a [bachelor's thesis by Maximilian Hildebrand](https://hackmanit.de/images/download/thesis/Automated-Scanning-for-Web-Cache-Poisoning-Vulnerabilities.pdf).
## License
WCVS is developed by [Hackmanit](https://hackmanit.de) and [Maximilian Hildebrand](https://www.github.com/m10x) and licensed under the [Apache License, Version 2.0](license.txt).

<a href="https://hackmanit.de"><img src="https://www.hackmanit.de/templates/hackmanit-v2/img/wbm_hackmanit.png" width="30%"></a>
