/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.imex;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.ui.DefaultMappingRegistry;
import com.paterva.maltego.graph.table.ui.imex.MappingConfig;
import com.paterva.maltego.graph.table.ui.imex.MappingExistInfo;
import com.paterva.maltego.graph.table.ui.imex.MappingImporter;
import com.paterva.maltego.graph.table.ui.imex.SelectableMapping;
import com.paterva.maltego.graph.table.ui.imex.Util;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openide.filesystems.FileObject;

public class MappingConfigImporter
extends ConfigImporter {
    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        MappingImporter importer = new MappingImporter();
        List<TabularGraph> mappings = importer.read(reader);
        return this.createConfig(mappings);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        DefaultMappingRegistry registry = new DefaultMappingRegistry(configRoot);
        ArrayList<TabularGraph> mappings = new ArrayList<TabularGraph>(registry.getAll());
        return this.createConfig(mappings);
    }

    private Config createConfig(List<TabularGraph> mappings) {
        if (mappings.isEmpty()) {
            return null;
        }
        List<SelectableMapping> selectables = Util.createSelectables(mappings);
        MappingExistInfo existInfo = new MappingExistInfo();
        for (SelectableMapping selectable : selectables) {
            selectable.setSelected(!existInfo.exist(selectable.getMapping()));
        }
        return new MappingConfig(selectables);
    }

    public int applyConfig(Config config) {
        MappingImporter importer = new MappingImporter();
        MappingConfig mappingConfig = (MappingConfig)config;
        HashSet<TabularGraph> mappings = new HashSet<TabularGraph>();
        for (SelectableMapping selectable : mappingConfig.getSelectedMappings()) {
            mappings.add(selectable.getMapping());
        }
        return importer.apply(mappings);
    }
}

