/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.protocol.v2api.AbstractTransformAdapterV2;
import com.paterva.maltego.transform.protocol.v2api.LocalTransformRunner;
import com.paterva.maltego.transform.protocol.v2api.TransformRunnerV2;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformRunException;
import com.paterva.maltego.transform.runner.api.TransformRunRestrictedException;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.Args;
import java.io.File;

public class LocalTransformAdapterV2
extends AbstractTransformAdapterV2 {
    private static final PropertyDescriptor COMMAND = new PropertyDescriptor(String.class, "transform.local.command");
    private static final PropertyDescriptor PARAMS = new PropertyDescriptor(String.class, "transform.local.parameters");
    private static final PropertyDescriptor WORKING_DIR = new PropertyDescriptor(String.class, "transform.local.working-directory");
    private static final PropertyDescriptor DEBUG = new PropertyDescriptor(Boolean.TYPE, "transform.local.debug");

    @Override
    protected TransformRunnerV2 runner(TransformRunContext ctx) throws TransformRunException, TransformRunRestrictedException {
        if (!A.C()) {
            throw TransformRunRestrictedException.forLocal();
        }
        Args.notNull((Object)ctx, (String)"ctx");
        DataSource transformInputs = ctx.getTransformInputs();
        String command = (String)transformInputs.getValue(COMMAND);
        String params = (String)transformInputs.getValue(PARAMS);
        String workingDir = (String)transformInputs.getValue(WORKING_DIR);
        Object debugO = transformInputs.getValue(DEBUG);
        boolean debug = false;
        if (debugO != null) {
            debug = (Boolean)debugO;
        }
        GraphID graphID = ctx.getTargetGraphID();
        TransformDefinition transform = ctx.getTransform();
        EntityFactory factory = ctx.getEntityFactory();
        EntityRegistry registry = ctx.getEntityRegistry();
        LocalTransformRunner runner = new LocalTransformRunner(graphID, (TransformDescriptor)transform, factory, registry, command);
        runner.setParameters(params);
        runner.setWorkingDir(new File(workingDir));
        runner.setDebug(debug);
        return runner;
    }

    @Override
    protected boolean applyAdvancedProperties() {
        return true;
    }
}

