/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.util.Set;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import yguard.A.A.D;
import yguard.A.A.K;
import yguard.A.J.SA;

public class GraphDataUtils {
    private GraphDataUtils() {
    }

    public static D getModelGraph(D viewGraph) {
        K dataProvider = viewGraph.B((Object)"y.view.ModelViewManager.MODEL_KEY");
        if (dataProvider != null) {
            return (D)dataProvider.get(null);
        }
        return viewGraph;
    }

    public static synchronized GraphDataObject getGraphDataObjectForModel(D modelGraph) {
        return GraphDataUtils.getGraphDataObject(modelGraph);
    }

    public static synchronized GraphDataObject getGraphDataObject(GraphID graphID) {
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            if (graphStore.isInMemory()) {
                return null;
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        String key = GraphDataObject.class.getName();
        GraphDataObject gdo = (GraphDataObject)gud.get((Object)key);
        if (gdo == null && (gdo = GraphDataUtils.findGraphDataObject(graphID)) != null) {
            gud.put((Object)key, (Object)gdo);
        }
        return gdo;
    }

    public static synchronized GraphDataObject getGraphDataObject(D viewGraph) {
        GraphID graphID = GraphViewManager.getDefault().getGraphID((SA)viewGraph);
        return GraphDataUtils.getGraphDataObject(graphID);
    }

    public static GraphDataObject getGraphDataObject(TopComponent tc) {
        GraphCookie cookie = (GraphCookie)tc.getLookup().lookup(GraphCookie.class);
        if (cookie != null) {
            return (GraphDataObject)cookie;
        }
        return null;
    }

    public static TopComponent getTopComponent(GraphID graphID) {
        Set<TopComponent> openTCs = GraphEditorRegistry.getDefault().getOpen();
        for (TopComponent tc : openTCs) {
            GraphCookie cookie = (GraphCookie)tc.getLookup().lookup(GraphCookie.class);
            if (cookie == null || !cookie.isLoaded() || !graphID.equals((Object)cookie.getGraphID())) continue;
            return tc;
        }
        return null;
    }

    private static GraphDataObject findGraphDataObjectForModel(GraphID graphID) {
        Set<TopComponent> openTCs = GraphEditorRegistry.getDefault().getOpen();
        for (TopComponent tc : openTCs) {
            GraphCookie cookie = (GraphCookie)tc.getLookup().lookup(GraphCookie.class);
            if (cookie == null || !cookie.isLoaded() || !graphID.equals((Object)cookie.getGraphID())) continue;
            return (GraphDataObject)cookie;
        }
        return null;
    }

    private static GraphDataObject findGraphDataObject(GraphID graphID) {
        return GraphDataUtils.findGraphDataObjectForModel(graphID);
    }
}

