/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.util.XMLEscapeUtils;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import yguard.A.H.B.A.H;
import yguard.A.H.B.B.Z;

class IOHelper {
    IOHelper() {
    }

    public static Element findElement(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !name.equals(child.getLocalName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static String getRequiredAttribute(Node node, String name) throws Z {
        String s2;
        Node n2;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (n2 = attrs.getNamedItem(name)) != null && (s2 = n2.getTextContent()) != null) {
            return s2;
        }
        throw new Z("Mandatory attribute does not exist: " + name);
    }

    public static String getOptionalAttribute(Node node, String name, String defaultValue) {
        String s2;
        Node n2;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (n2 = attrs.getNamedItem(name)) != null && (s2 = n2.getTextContent()) != null) {
            return s2;
        }
        return defaultValue;
    }

    public static boolean getBooleanAttribute(Node node, String name, boolean defaultValue) {
        String s2;
        Node n2;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (n2 = attrs.getNamedItem(name)) != null && (s2 = n2.getTextContent()) != null) {
            return s2.toLowerCase().equals("true");
        }
        return defaultValue;
    }

    public static String getStringAttribute(Node node, String name) {
        Node n2;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (n2 = attrs.getNamedItem(name)) != null) {
            return n2.getTextContent();
        }
        return null;
    }

    public static String getValue(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"Value".equals(child.getLocalName())) continue;
            return child.getTextContent();
        }
        return null;
    }

    public static String findCData(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 4) continue;
            String str = XMLEscapeUtils.unescapeUnicode((String)child.getNodeValue());
            return str != null ? str : "";
        }
        return null;
    }

    public static void writeProperty(H writer, MaltegoPart<? extends Guid> part, PropertyDescriptor pd) {
        writer.A("mtg", "Property", "http://maltego.paterva.com/xml/mtgx");
        Object value = part.getValue(pd);
        writer.B("name", pd.getName());
        TypeDescriptor td = TypeRegistry.getDefault().getType(pd.getType());
        writer.B("type", td.getTypeName());
        writer.A("nullable", pd.isNullable());
        writer.A("hidden", pd.isHidden());
        writer.A("readonly", pd.isReadonly());
        writer.B("displayName", pd.getDisplayName());
        writer.A("mtg", "Value", "http://maltego.paterva.com/xml/mtgx");
        String text = td.convert(value);
        writer.A(text != null ? text : "");
        writer.C();
        writer.C();
    }

    public static void writeProperty(XMLStreamWriter writer, MaltegoPart<? extends Guid> part, PropertyDescriptor pd) throws XMLStreamException {
        writer.writeStartElement("mtg", "Property", "http://maltego.paterva.com/xml/mtgx");
        Object value = part.getValue(pd);
        writer.writeAttribute("displayName", pd.getDisplayName());
        writer.writeAttribute("hidden", Boolean.toString(pd.isHidden()));
        writer.writeAttribute("name", pd.getName());
        writer.writeAttribute("nullable", Boolean.toString(pd.isNullable()));
        writer.writeAttribute("readonly", Boolean.toString(pd.isReadonly()));
        TypeDescriptor td = TypeRegistry.getDefault().getType(pd.getType());
        writer.writeAttribute("type", td.getTypeName());
        writer.writeStartElement("mtg", "Value", "http://maltego.paterva.com/xml/mtgx");
        String text = td.convert(value);
        writer.writeCharacters(text != null ? text : "");
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

