/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import yguard.A.J.SA;
import yguard.A.J.U;

public class MouseWheelListenerProxy
implements MouseWheelListener {
    private final GraphID _graphID;
    private final List<MouseWheelListener> _delegates = new ArrayList<MouseWheelListener>();

    public static synchronized MouseWheelListenerProxy forGraph(GraphID graphID) {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        MouseWheelListenerProxy proxy = (MouseWheelListenerProxy)gud.get((Object)(key = MouseWheelListenerProxy.class.getName()));
        if (proxy == null) {
            proxy = new MouseWheelListenerProxy(graphID);
            gud.put((Object)key, (Object)proxy);
        }
        return proxy;
    }

    private MouseWheelListenerProxy(GraphID graphID) {
        this._graphID = graphID;
        this.moveDelegatesToProxy();
    }

    private void moveDelegatesToProxy() {
        SA graph = (SA)MaltegoGraphManager.getWrapper((GraphID)this._graphID).getGraph();
        U view = (U)graph.\u00f1();
        JComponent canvas = view.getCanvasComponent();
        MouseWheelListener[] mouseWheelListeners = canvas.getMouseWheelListeners();
        this._delegates.addAll(Arrays.asList(mouseWheelListeners));
        for (MouseWheelListener mouseWheelListener : mouseWheelListeners) {
            canvas.removeMouseWheelListener(mouseWheelListener);
        }
        canvas.addMouseWheelListener(this);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this._delegates.add(0, listener);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        for (MouseWheelListener mouseWheelListener : this._delegates) {
            mouseWheelListener.mouseWheelMoved(e2);
            if (!e2.isConsumed()) continue;
            break;
        }
    }
}

