/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.dialog.UIRunQueue;
import com.paterva.maltego.util.ui.dialog.WizardSegment;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import com.paterva.maltego.util.ui.dnd.MaltegoGlobalDropTarget;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import com.paterva.maltego.util.ui.laf.debug.MaltegoLAFDebug;
import com.paterva.maltego.util.ui.privacymode.PrivacyModeFactory;
import java.awt.Frame;
import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private static final String RIBBON_PATH = "Ribbon/TaskPanes/Investigate";
    private static final String SUBFOLDER_NAME = "Debug";
    private static final String SHADOW_NAME = "LAFShadow";
    private static final String SHADOW_EXT = "shadow";

    public void restored() {
        MaltegoLAF laf = MaltegoLAF.getDefault();
        if ("true".equalsIgnoreCase(laf.getString("0-debug-laf-ribbon-button"))) {
            MaltegoLAFDebug.load();
            try {
                FileObject shadowFile;
                FileObject manageFolder = FileUtil.getConfigFile((String)RIBBON_PATH);
                FileObject subFolder = manageFolder.getFileObject(SUBFOLDER_NAME);
                if (subFolder == null || !subFolder.isValid()) {
                    subFolder = manageFolder.createFolder(SUBFOLDER_NAME);
                    subFolder.setAttribute("position", (Object)1);
                }
                if ((shadowFile = subFolder.getFileObject(SHADOW_NAME, SHADOW_EXT)) == null || !shadowFile.isValid()) {
                    shadowFile = subFolder.createData(SHADOW_NAME, SHADOW_EXT);
                    shadowFile.setAttribute("originalFile", (Object)"Actions/Edit/com-paterva-maltego-util-ui-laf-debug-MaltegoLAFDebugAction.instance");
                    shadowFile.setAttribute("position", (Object)100);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            Frame main = WindowUtil.getMainWindow();
            main.setDropTarget(new MaltegoGlobalDropTarget(main));
        });
        UIRunQueue.instance().queue(200, "Possibly show Privacy Mode options in seperate wizard - 1", () -> UIRunQueue.instance().queue(200, "Possibly show Privacy Mode options in seperate wizard - 2", () -> {
            WizardSegment segment = new PrivacyModeFactory().createSegment();
            if (segment != null) {
                WizardUtilities.runWizard(segment);
            }
        }));
    }

    public void close() {
        try {
            FileObject manageFolder = FileUtil.getConfigFile((String)RIBBON_PATH);
            FileObject subFolder = manageFolder.getFileObject(SUBFOLDER_NAME);
            if (subFolder != null && subFolder.isValid()) {
                subFolder.delete();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        super.close();
    }
}

