/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import com.paterva.maltego.util.ui.dialog.DefaultFloatingWindowDisplayer;
import com.paterva.maltego.util.ui.dialog.DefaultWindowHandle;
import com.paterva.maltego.util.ui.dialog.FloatingWindowDescriptor;
import com.paterva.maltego.util.ui.dialog.FloatingWindowDisplayer;
import com.paterva.maltego.util.ui.dialog.FullScreenManager;
import com.paterva.maltego.util.ui.dialog.WindowHandle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openide.util.WeakListeners;

public class FullScreenAwareWindowDisplayer
extends FloatingWindowDisplayer {
    @Override
    public WindowHandle create(Window parent, FloatingWindowDescriptor descriptor) {
        return new FullScreenAwareWindowHandle(parent, descriptor);
    }

    private static Window createWindow(Window parent, FloatingWindowDescriptor descriptor) {
        DefaultFloatingWindowDisplayer displayer = new DefaultFloatingWindowDisplayer();
        if (FullScreenManager.getDefault().isFullScreen()) {
            return displayer.create(FullScreenManager.getDefault().getFullScreenWindow(), descriptor).getWindow();
        }
        return displayer.create(parent, descriptor).getWindow();
    }

    private class FullScreenAwareWindowHandle
    extends DefaultWindowHandle
    implements PropertyChangeListener {
        private Window _originalParent;
        private PropertyChangeListener _pcl;
        private FloatingWindowDescriptor _descriptor;
        private boolean _visible;

        private FullScreenAwareWindowHandle(Window parent, FloatingWindowDescriptor descriptor) {
            super(FullScreenAwareWindowDisplayer.createWindow(parent, descriptor));
            this._descriptor = descriptor;
            this._originalParent = parent;
            FullScreenManager manager = FullScreenManager.getDefault();
            this._pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)manager);
            FullScreenManager.getDefault().addPropertyChangeListener(this._pcl);
            this._visible = this.isVisible();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this._visible) {
                Window oldWindow = this.getWindow();
                Window newWindow = FullScreenAwareWindowDisplayer.createWindow(this._originalParent, this._descriptor);
                this.setWindow(newWindow);
                this.copyWindowState(oldWindow, newWindow);
                oldWindow.setVisible(false);
                newWindow.setVisible(true);
            }
        }

        private void copyWindowState(Window old, Window nue) {
            nue.setLocation(old.getLocation());
            nue.setSize(old.getSize());
        }

        @Override
        public void setVisible(boolean value) {
            super.setVisible(value);
            this._visible = value;
        }
    }
}

