/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.actions.userfilter;

import com.paterva.maltego.automation.actions.userfilter.EntityNodeHelper;
import com.paterva.maltego.util.ui.ComponentFlasher;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import com.paterva.maltego.util.ui.outline.OutlineViewPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIDefaults;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.CheckableNode;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class UserFilterControl
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private final OutlineViewPanel _entities;
    private final ExplorerManager _explorer = new ExplorerManager();
    private ActionListener _continueListener;
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final Color backgroundColor = LAF.getColor("machine-user-filter-bg");
    private final Color headerPanelBackground = LAF.getColor("machine-user-filter-header-panel-bg");
    private final Color headingForeground = LAF.getColor("machine-user-filter-heading-fg");
    private final Color descriptionForeground = LAF.getColor("machine-user-filter-description-fg");
    private final Color flashColour = LAF.getColor("machine-user-filter-flash-colour");
    private JCheckBox _deleteCheckbox;
    private JTextArea _description;
    private JPanel _footerPanel;
    private JPanel _headerPanel;
    private JLabel _heading;
    private JLabel _icon;
    private JButton _proceedButton;

    public UserFilterControl(String columnHeading, boolean showIncoming, boolean showOutgoing, boolean showTransformName) {
        this.initComponents();
        this._entities = new OutlineViewPanel(columnHeading);
        OutlineView outline = this._entities.getView();
        outline.addPropertyColumn("maltego.fixed.type", "Type", "The type of entity");
        if (showIncoming) {
            outline.addPropertyColumn("maltego.fixed.incominglinks", "In", "The number of incoming links");
        }
        if (showOutgoing) {
            outline.addPropertyColumn("maltego.fixed.outgoinglinks", "Out", "The number of outgoing links");
        }
        if (showTransformName) {
            // empty if block
        }
        outline.getOutline().setAutoResizeMode(2);
        TableColumnModel columns = outline.getOutline().getColumnModel();
        columns.getColumn(0).setPreferredWidth(150);
        columns.getColumn(1).setPreferredWidth(50);
        if (columns.getColumnCount() > 2) {
            columns.getColumn(2).setPreferredWidth(15);
        }
        if (columns.getColumnCount() > 3) {
            columns.getColumn(3).setPreferredWidth(15);
        }
        outline.getOutline().setRootVisible(false);
        this._entities.addToToolbarLeft(this.createSelectAllAction());
        this._entities.addToToolbarLeft(this.createSelectNoneAction());
        this.add((Component)this._entities, "Center");
        this._explorer.addPropertyChangeListener((PropertyChangeListener)this);
        this.flashHeader();
    }

    public String getDescription() {
        return this._description.getText();
    }

    public void setDescription(String description) {
        this._description.setText(description);
    }

    public String getHeading() {
        return this._heading.getText();
    }

    public void setHeading(String heading) {
        this._heading.setText(heading);
    }

    private void initComponents() {
        this._footerPanel = new JPanel();
        this._proceedButton = new JButton();
        this._deleteCheckbox = new JCheckBox();
        this._headerPanel = new JPanel();
        this._heading = new JLabel();
        this._icon = new JLabel();
        this._description = new JTextArea();
        this.setBackground(this.backgroundColor);
        this.setLayout(new BorderLayout(1, 1));
        this._footerPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._proceedButton.setText(NbBundle.getMessage(UserFilterControl.class, (String)"UserFilterControl._proceedButton.text"));
        this._proceedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserFilterControl.this._proceedButtonActionPerformed(evt);
            }
        });
        this._deleteCheckbox.setSelected(true);
        this._deleteCheckbox.setText(NbBundle.getMessage(UserFilterControl.class, (String)"UserFilterControl._deleteCheckbox.text"));
        GroupLayout _footerPanelLayout = new GroupLayout(this._footerPanel);
        this._footerPanel.setLayout(_footerPanelLayout);
        _footerPanelLayout.setHorizontalGroup(_footerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, _footerPanelLayout.createSequentialGroup().addComponent(this._deleteCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 70, Short.MAX_VALUE).addComponent(this._proceedButton)));
        _footerPanelLayout.setVerticalGroup(_footerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(_footerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._proceedButton).addComponent(this._deleteCheckbox)));
        this.add((Component)this._footerPanel, "South");
        this._headerPanel.setBackground(this.headerPanelBackground);
        this._headerPanel.setBorder(BorderFactory.createEmptyBorder(5, 3, 3, 3));
        this._heading.setFont(FontUtils.defaultStyledScaled((int)1, (float)1.0f));
        this._heading.setForeground(this.headingForeground);
        this._heading.setText(NbBundle.getMessage(UserFilterControl.class, (String)"UserFilterControl._heading.text"));
        this._icon.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/automation/resources/RobotFilter24.png")));
        this._icon.setText(NbBundle.getMessage(UserFilterControl.class, (String)"UserFilterControl._icon.text"));
        this._description.setEditable(false);
        this._description.setColumns(20);
        this._description.setForeground(this.descriptionForeground);
        this._description.setLineWrap(true);
        this._description.setRows(2);
        this._description.setText(NbBundle.getMessage(UserFilterControl.class, (String)"UserFilterControl._description.text"));
        this._description.setWrapStyleWord(true);
        this._description.setBorder(null);
        this._description.setFocusable(false);
        this._description.setOpaque(false);
        GroupLayout _headerPanelLayout = new GroupLayout(this._headerPanel);
        this._headerPanel.setLayout(_headerPanelLayout);
        _headerPanelLayout.setHorizontalGroup(_headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(_headerPanelLayout.createSequentialGroup().addComponent(this._icon).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(_headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._heading, -1, -1, Short.MAX_VALUE).addGroup(_headerPanelLayout.createSequentialGroup().addComponent(this._description, -2, 0, Short.MAX_VALUE).addContainerGap()))));
        _headerPanelLayout.setVerticalGroup(_headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(_headerPanelLayout.createSequentialGroup().addComponent(this._icon).addContainerGap(-1, Short.MAX_VALUE)).addGroup(_headerPanelLayout.createSequentialGroup().addComponent(this._heading).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._description)));
        this.add((Component)this._headerPanel, "North");
    }

    private void _proceedButtonActionPerformed(ActionEvent evt) {
        if (this._continueListener != null) {
            this._continueListener.actionPerformed(evt);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this._explorer;
    }

    private void selectAll() {
        this.applySelection(true);
    }

    private void selectNone() {
        this.applySelection(false);
    }

    private void applySelection(boolean value) {
        List<Node> nodes = this.getFilteredNodes();
        for (Node node : nodes) {
            CheckableNode checkable = (CheckableNode)node.getLookup().lookup(CheckableNode.class);
            if (checkable == null) continue;
            checkable.setSelected(Boolean.valueOf(value));
        }
    }

    private List<Node> getFilteredNodes() {
        ArrayList<Node> filteredNodes = new ArrayList<Node>();
        Outline outline = this._entities.getView().getOutline();
        int numRows = outline.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            Object itemInZerothColumn = outline.getValueAt(i, 0);
            Node aNodeShownInFilter = Visualizer.findNode((Object)itemInZerothColumn);
            filteredNodes.add(aNodeShownInFilter);
        }
        return filteredNodes;
    }

    public void setActionListener(ActionListener listener) {
        this._continueListener = listener;
    }

    public ActionListener getContinueListener() {
        return this._continueListener;
    }

    private Action createSelectAllAction() {
        AbstractAction selectAll = new AbstractAction("", new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/Check.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserFilterControl.this.selectAll();
            }
        };
        selectAll.putValue("ShortDescription", "Select All");
        return selectAll;
    }

    private Action createSelectNoneAction() {
        AbstractAction selectNone = new AbstractAction("", new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/automation/resources/Uncheck.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserFilterControl.this.selectNone();
            }
        };
        selectNone.putValue("ShortDescription", "Deselect All");
        return selectNone;
    }

    public boolean deleteUnselected() {
        return this._deleteCheckbox.isSelected();
    }

    public void setButtonText(String buttonText) {
        this._proceedButton.setText(buttonText);
    }

    public String getButtonText() {
        return this._proceedButton.getText();
    }

    public Icon getIcon() {
        return this._icon.getIcon();
    }

    public void setIcon(Icon icon) {
        this._icon.setIcon(icon);
    }

    public void setRemovePromptText(String text) {
        this._deleteCheckbox.setText(text);
    }

    public String getRemovePromptText() {
        return this._deleteCheckbox.getText();
    }

    public void setRemovePromptChecked(boolean checked) {
        this._deleteCheckbox.setSelected(checked);
    }

    public boolean getRemovePromptChecked() {
        return this._deleteCheckbox.isSelected();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            EntityNodeHelper.selectOnView(this.getExplorerManager().getSelectedNodes());
        }
    }

    private void flashHeader() {
        ComponentFlasher.flash((Component)this._headerPanel, (Color)this.flashColour);
    }

    public void setSelectionState(boolean selected) {
        if (selected) {
            this.selectAll();
        } else {
            this.selectNone();
        }
    }
}

