/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.impl;

import com.paterva.maltego.automation.AutomationContext;
import com.paterva.maltego.automation.Logger;
import com.paterva.maltego.automation.MachineMessageHandler;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.util.Set;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

public class AutomationContexts {
    private AutomationContexts() {
    }

    public static class ReadOnly
    implements AutomationContext,
    Logger {
        private DataObject _target;
        private Payload _initialPayload;

        public ReadOnly(DataObject target, Payload payload) {
            this._target = target;
            this._initialPayload = payload;
        }

        @Override
        public GraphID getTargetGraphID() {
            return ((GraphDataObject)this._target).getGraphID();
        }

        @Override
        public DataObject getTarget() {
            return this._target;
        }

        @Override
        public Payload getInitialPayload() {
            return this._initialPayload;
        }

        @Override
        public Object getGlobal(Object key) {
            return null;
        }

        @Override
        public void setGlobal(Object key, Object value) {
        }

        @Override
        public Object getProperty(EntityID entityID, Object key) {
            return null;
        }

        @Override
        public void setProperty(EntityID entityID, Object key, Object value) {
        }

        @Override
        public void setProperty(EntityID entityID, Object key, Object value, boolean overwrite) {
        }

        @Override
        public void clearProperties(EntityID entityID) {
        }

        @Override
        public EntityRegistry getEntityRegistry() {
            GraphID graphID = this.getTargetGraphID();
            EntityRegistry registry = null;
            if (graphID == null) {
                registry = EntityRegistry.forGraphID((GraphID)graphID);
            }
            if (registry == null) {
                registry = EntityRegistry.getDefault();
            }
            return registry;
        }

        @Override
        public void progress(String message) {
            this.progress(message, -1);
        }

        @Override
        public void progress(int percent) {
            this.progress(null, percent);
        }

        @Override
        public void progress(String message, int percent) {
        }

        @Override
        public TopComponent getTopComponent() {
            GraphCookie graphCookie = this.getGraphCookie();
            if (graphCookie != null) {
                Set openTCs = GraphEditorRegistry.getDefault().getOpen();
                for (TopComponent topComponent : openTCs) {
                    GraphCookie cookie = (GraphCookie)topComponent.getLookup().lookup(GraphCookie.class);
                    if (!graphCookie.equals(cookie)) continue;
                    return topComponent;
                }
            }
            return null;
        }

        private GraphCookie getGraphCookie() {
            return (GraphCookie)this.getTarget().getLookup().lookup(GraphCookie.class);
        }

        @Override
        public Logger getLogger() {
            return this;
        }

        @Override
        public void debug(String message, Object ... args) {
            MachineMessageHandler.getDefault().debug(this.getTarget(), message, args);
        }

        @Override
        public void info(String message, Object ... args) {
            MachineMessageHandler.getDefault().info(this.getTarget(), message, args);
        }

        @Override
        public void note(String message, Object ... args) {
            MachineMessageHandler.getDefault().note(this.getTarget(), message, args);
        }

        @Override
        public void warn(String message, Object ... args) {
            MachineMessageHandler.getDefault().warning(this.getTarget(), message, args);
        }

        @Override
        public void error(Exception e) {
            MachineMessageHandler.getDefault().error(this.getTarget(), e);
        }

        @Override
        public void error(String message, Object ... args) {
            MachineMessageHandler.getDefault().error(this.getTarget(), message, args);
        }

        @Override
        public void error(String message, Exception e, Object ... args) {
            MachineMessageHandler.getDefault().error(this.getTarget(), message, e, args);
        }
    }
}

