/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.descriptor.TransformServerAuthentication;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.repository.serializer.TransformServerInfoStub;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.util.Exceptions;

public class TransformServerInfoSerializer {
    public TransformServerInfo read(InputStream stream) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformServerInfoStub stub = (TransformServerInfoStub)serializer.read(TransformServerInfoStub.class, stream);
        return TransformServerInfoSerializer.translate(stub);
    }

    private static TransformServerInfo translate(TransformServerInfoStub from) {
        FastURL v3Url = null;
        if (from.getV3Url() != null) {
            v3Url = new FastURL(from.getV3Url().toString());
        }
        TransformServerInfo to = new TransformServerInfo(from.getSeedUrls(), new FastURL(from.getUrl().toString()), v3Url, from.getName(), from.getDescription());
        to.setEnabled(from.isEnabled());
        to.setProtocolVersion(ProtocolVersion.get((String)from.getProtocolVersion()));
        to.getTransforms().addAll(from.getTransforms());
        to.setLastSync(from.getLastSync());
        if (from.getAuthentication() != null) {
            to.setAuthentication(TransformServerAuthentication.get((String)from.getAuthentication().getType()));
        }
        to.markClean();
        return to;
    }

    private static URL getUrl(String url) {
        if (!StringUtilities.isNullOrEmpty((String)url)) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static void write(TransformServerInfo server, OutputStream out) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        TransformServerInfoStub stub = TransformServerInfoSerializer.translate(server);
        serializer.write((Object)stub, out);
    }

    private static TransformServerInfoStub translate(TransformServerInfo from) {
        TransformServerInfoStub to = new TransformServerInfoStub();
        to.setEnabled(from.isEnabled());
        to.setName(from.getDisplayName());
        try {
            to.setUrl(from.getUrl().getURL());
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        try {
            FastURL v3Url = from.getV3Url();
            if (v3Url != null) {
                to.setV3Url(from.getV3Url().getURL());
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        to.setDescription(from.getDescription());
        to.setProtocolVersion(from.getProtocolVersion() == null ? "0.0" : from.getProtocolVersion().toString());
        if (from.getTransforms() != null) {
            for (String t : from.getTransforms()) {
                to.addTransform(t);
            }
        }
        to.setLastSync(from.getLastSync());
        to.setAuthentication(new TransformServerInfoStub.Authentication(from.getAuthentication().getTypeName()));
        to.setSeedUrls(from.getSeedUrls());
        return to;
    }
}

