/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.main;

import com.paterva.maltego.imgfactoryapi.ImageFactory;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.table.RowTableModel;
import com.paterva.maltego.view.customization.api.Viewlet;
import java.awt.Image;

public class ViewletTableModel
extends RowTableModel<Viewlet> {
    private static final String[] COLUMNS = new String[]{"", "Viewlet", "Active", "In Toolbar", "In Menu", "Read-only"};
    public static final int COLUMN_ICON = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_ACTIVE = 2;
    public static final int COLUMN_TOOLBAR = 3;
    public static final int COLUMN_MENU = 4;
    public static final int COLUMN_READONLY = 5;
    private Viewlet _active;

    public ViewletTableModel() {
        super(COLUMNS);
    }

    public Viewlet getActive() {
        return this._active;
    }

    public void setActive(Viewlet active) {
        this._active = active;
    }

    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Image.class;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int row, int column) {
        return column == 2 || column == 3 || column == 4;
    }

    public Object getValueFor(Viewlet viewlet, int column) {
        switch (column) {
            case 0: {
                String iconResource = viewlet.getIcon();
                if (iconResource == null) {
                    return null;
                }
                int iconSize = IconSize.TINY.getSize();
                return ImageFactory.getDefault().getImage((Object)iconResource, iconSize, iconSize, null);
            }
            case 1: {
                return viewlet.getName();
            }
            case 2: {
                return viewlet.equals(this._active);
            }
            case 3: {
                return viewlet.isInToolbar();
            }
            case 4: {
                return viewlet.isInMenu();
            }
            case 5: {
                return viewlet.isReadOnly();
            }
        }
        return null;
    }

    public void setValueFor(Viewlet viewlet, int column, Object value) {
        if (column == 2) {
            Viewlet previous = this._active;
            this._active = !viewlet.equals(this._active) ? viewlet : null;
            if (previous != null) {
                int row = this.getRows().indexOf(previous);
                this.fireTableCellUpdated(row, column);
            }
        } else if (column == 3) {
            viewlet.setInToolbar(!viewlet.isInToolbar());
        } else if (column == 4) {
            viewlet.setInMenu(!viewlet.isInMenu());
        }
    }
}

