/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub;

import com.bulenkov.darcula.ui.DarculaButtonUI;
import com.paterva.maltego.certificates.ui.CertificateDisplayer;
import com.paterva.maltego.imgfactory.impl.ImageFromUrlCallback;
import com.paterva.maltego.imgfactory.impl.ImageFromUrlThread;
import com.paterva.maltego.seeds.api.HubSeedBadge;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedIcon;
import com.paterva.maltego.seeds.api.HubSeedPricing;
import com.paterva.maltego.seeds.api.HubSeedProvider;
import com.paterva.maltego.seeds.api.HubSeedRegistration;
import com.paterva.maltego.seeds.api.HubSeedTag;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.seeds.ui.HubSeedUtils;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.HtmlUtils;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.WrapLayout;
import com.paterva.maltego.util.ui.components.RoundRectLabel;
import com.paterva.maltego.util.ui.components.ScrollablePanel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import com.paterva.maltego.util.ui.privacymode.PrivacyMode;
import com.paterva.maltego.util.ui.privacymode.PrivacyModeSettings;
import com.paterva.maltego.util.ui.privacymode.PrivacyModeStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HubSeedDetailsPanel
extends JPanel
implements ImageFromUrlCallback {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private static final Color DETAILS_BG = LAF.getColor("hub-item-details-bg");
    private static final Color TAG_FG = LAF.getColor("hub-item-details-tag-fg");
    private static final Color TAG_BG = LAF.getColor("hub-item-details-tag-bg");
    private static final int MAX_WIDTH = 1020;
    private static final int MAX_HEIGHT = Integer.MAX_VALUE;
    private static final int MAX_PREVIEW_WIDTH = 640;
    private static final int MAX_PREVIEW_HEIGHT = 360;
    private final HubSeedDescriptor _seed;
    private final LinkedHashMap<String, String> _urls = new LinkedHashMap();
    private int _singleRowComponentHeightEstimate = 25;
    private JComboBox<String> _certsCombo;
    private JLabel _certsLabel;
    private JPanel _contactPanel;
    private JPanel _descriptionPanel;
    private JScrollPane _descriptionScrollPane;
    private JTextPane _descriptionTextPane;
    private JScrollPane _detailsScrollPane;
    private JTextPane _detailsTextPane;
    private JLabel _displayNameLabel;
    private Box.Filler _filler1;
    private Box.Filler _filler2;
    private Box.Filler _filler3;
    private JPanel _hubNameDivider;
    private JLabel _iconLabel;
    private JPanel _infoPanel;
    private JScrollPane _infoScrollPane;
    private ScrollablePanel _infoScrollablePanel;
    private JLabel _leftBadgeLabel;
    private JLabel _modifiedLabel;
    private JPanel _namePanel;
    private JLabel _previewImageLabel;
    private JLabel _pricingInfoLabel;
    private JScrollPane _pricingInfoScrollPane;
    private JTextPane _pricingInfoTextPane;
    private JPanel _pricingPanel;
    private JLabel _providerContactLabel;
    private JScrollPane _providerEmailScrollPane;
    private JTextPane _providerEmailTextPane;
    private JLabel _providerNameLabel;
    private JScrollPane _providerWebsiteScrollPane;
    private JTextPane _providerWebsiteTextPane;
    private JPanel _registerPanel;
    private JLabel _registerWebsiteLabel;
    private JScrollPane _registerWebsiteScrollPane;
    private JTextPane _registerWebsiteTextPane;
    private JLabel _rightBadgeLabel;
    private JButton _settingsButton;
    private JPanel _statsPanel;
    private JPanel _tagsPanel;
    private JPanel _tagsStatsParent;
    private JTextField _tempTextField;
    private JLabel _txEntityCountLabel;
    private JButton _viewCertButton;
    private JPanel buttonPanel;
    private JPanel filler;
    private JPanel fillerPanel;

    public HubSeedDetailsPanel(HubSeedDescriptor seed) {
        this._seed = seed;
        this.initComponents();
        int height = this._tempTextField.getPreferredSize().height;
        this._namePanel.remove(this._tempTextField);
        if (height > this._singleRowComponentHeightEstimate) {
            this._singleRowComponentHeightEstimate = height;
        }
        this.updateName();
        this.updateIcon();
        this.updateLeftBadge();
        this.updateRightBadge();
        this.updateDescriptionDetails();
        this.updateTags();
        this.updateStats();
        this.updatePricingInfo();
        this.updateProviderContact();
        this.updateRegistration();
        this.updatePreviewImage();
        this.updateCertsCombo();
        this.updateCertButton();
        this.updateSettingsButton();
        this.resizeInfoScrollPane();
        this._infoScrollPane.getViewport().setBackground(DETAILS_BG);
        this._infoScrollablePanel.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        this._infoScrollablePanel.setScrollableHeight(ScrollablePanel.ScrollableSizeHint.NONE);
    }

    private void resizeInfoScrollPane() {
        Dimension preferredSize = this._infoPanel.getPreferredSize();
        int maxInfoHeight = 400;
        if (preferredSize.height > maxInfoHeight) {
            this._infoScrollPane.getViewport().setPreferredSize(new Dimension(preferredSize.width, maxInfoHeight));
        }
    }

    private void updateName() {
        this._displayNameLabel.setFont(HubSeedUtils.getFontScaled("hub-item-details-title-font"));
        this._displayNameLabel.setText(this._seed.getDisplayName());
        this._hubNameDivider.setBackground(LAF.getColor("hub-item-details-divider-bg"));
    }

    private void updateDescriptionDetails() {
        this._descriptionScrollPane.getViewport().setBackground(DETAILS_BG);
        this._detailsScrollPane.getViewport().setBackground(DETAILS_BG);
        int wrappedLines1 = this.update(this._seed.getDescription(), this._descriptionTextPane, true, 1020, false, new JComponent[0]);
        int wrappedLines2 = this.update(this._seed.getDetails(), this._detailsTextPane, false, 1020, false, new JComponent[0]);
        this._descriptionScrollPane.getViewport().setPreferredSize(new Dimension(1020, this._singleRowComponentHeightEstimate));
        HubSeedDetailsPanel.updateHeight(this._descriptionScrollPane, this._singleRowComponentHeightEstimate, 1020, Integer.MAX_VALUE, wrappedLines1);
        this._detailsScrollPane.getViewport().setPreferredSize(new Dimension(1020, this._singleRowComponentHeightEstimate));
        HubSeedDetailsPanel.updateHeight(this._detailsScrollPane, this._singleRowComponentHeightEstimate, 1020, Integer.MAX_VALUE, wrappedLines2);
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._descriptionScrollPane, (JPanel)this._descriptionPanel, (boolean)false);
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._detailsScrollPane, (JPanel)this._descriptionPanel, (boolean)false);
    }

    private static void updateHeight(JScrollPane scrollPane, int singleRowHeight, int maxWidth, int maxHeight, int wrappedLines) {
        int currentWidth;
        Component comp;
        int newHeight = 0;
        int height = scrollPane.getPreferredSize().height;
        if (height > maxHeight) {
            newHeight = maxHeight;
        }
        if ((comp = scrollPane.getViewport().getComponent(0)) instanceof JTextPane && ((currentWidth = comp.getPreferredSize().width) > maxWidth || wrappedLines > 1)) {
            FontMetrics fm = comp.getFontMetrics(comp.getFont());
            int rowHeight = fm.getHeight();
            newHeight = Math.max(1, wrappedLines) * rowHeight;
            int padding = singleRowHeight - rowHeight;
            if (padding > 0) {
                newHeight += padding;
            }
        }
        if (newHeight > 0) {
            if (newHeight > maxHeight) {
                newHeight = maxHeight;
            }
            scrollPane.setPreferredSize(new Dimension(maxWidth, newHeight));
            SwingUtilities.invokeLater(() -> scrollPane.getVerticalScrollBar().setValue(0));
        }
    }

    private void updateCertsCombo() {
        this._certsLabel.setFont(this._certsLabel.getFont().deriveFont(1));
        this._urls.clear();
        this._certsCombo.removeAllItems();
        List grantedHubSeedUrls = this._seed.getGrantedHubSeedUrls();
        for (HubSeedUrl hubSeedUrl : grantedHubSeedUrls) {
            if (hubSeedUrl == null || !hubSeedUrl.getUrl().startsWith("https:")) continue;
            String hubSeedUrlString = hubSeedUrl.getUrl();
            String display = StringUtilities.getSeedUrlName((String)hubSeedUrlString);
            if (StringUtilities.isNullOrEmpty((String)display)) {
                this._urls.put(hubSeedUrlString, hubSeedUrlString);
                this._certsCombo.addItem(hubSeedUrlString);
                continue;
            }
            if (this._urls.get(display) == null) {
                this._urls.put(display, hubSeedUrlString);
                this._certsCombo.addItem(display);
                continue;
            }
            this._urls.put(hubSeedUrlString, hubSeedUrlString);
            this._certsCombo.addItem(hubSeedUrlString);
        }
        boolean visible = this._certsCombo.getItemCount() > 1;
        this._certsLabel.setVisible(visible);
        this._filler1.setVisible(visible);
        this._certsCombo.setVisible(visible);
        this._filler2.setVisible(visible);
    }

    private void updateCertButton() {
        this._viewCertButton.setForeground(DarculaButtonUI.getButtonColorHubTitle());
        this._viewCertButton.putClientProperty("buttonBg", "hub-item-details-button_bg");
        this._viewCertButton.putClientProperty("inHubDetailsPanel", Boolean.TRUE);
        boolean visible = this._certsCombo.getItemCount() > 0;
        this._viewCertButton.setVisible(visible);
        this._filler3.setVisible(visible);
    }

    private void updateSettingsButton() {
        boolean installed = HubSeedSettings.getDefault().isInstalled(this._seed);
        DisplayDescriptorCollection globalTxProps = HubSeedSettings.getDefault().getGlobalTransformProperties(this._seed);
        this._settingsButton.setForeground(DarculaButtonUI.getButtonColorHubTitle());
        this._settingsButton.putClientProperty("buttonBg", "hub-item-details-button_bg");
        this._settingsButton.putClientProperty("inHubDetailsPanel", Boolean.TRUE);
        this._settingsButton.setVisible(!this._seed.isCustom() && installed && globalTxProps != null && !globalTxProps.isEmpty());
    }

    private void updateTags() {
        this._tagsPanel.removeAll();
        this._tagsPanel.setLayout((LayoutManager)new WrapLayout(0));
        int tagsWidth = 1020 - this._statsPanel.getPreferredSize().width;
        this._tagsPanel.setSize(new Dimension(tagsWidth, 1));
        List tags = this._seed.getTags();
        if (tags != null) {
            for (HubSeedTag tag : tags) {
                String value = tag.getValue();
                if (value == null) continue;
                RoundRectLabel tagLabel = new RoundRectLabel(value, TAG_BG, TAG_FG, true);
                this._tagsPanel.add((Component)tagLabel);
            }
        }
    }

    private void updateStats() {
        String statsText = HubSeedUtils.getTxEntityCounts(this._seed);
        this._txEntityCountLabel.setText(statsText);
        String modifiedText = HubSeedUtils.getDateModifiedText(this._seed);
        this._modifiedLabel.setText(modifiedText);
        this._modifiedLabel.setForeground(LAF.getColor("hub-item-date-modified-fg"));
    }

    private void updateLeftBadge() {
        this._leftBadgeLabel.setVisible(false);
        String location = "SouthWest";
        HubSeedBadge locationBadge = HubSeedUtils.getLocationBadge(this._seed, location);
        if (locationBadge != null) {
            this._leftBadgeLabel.setVisible(true);
            this._leftBadgeLabel.setOpaque(true);
            this._leftBadgeLabel.setFont(HubSeedUtils.getFontScaled("hub-item-installed-font"));
            this._leftBadgeLabel.setForeground(HubSeedUtils.getBadgeFgColor(this, locationBadge));
            this._leftBadgeLabel.setBackground(HubSeedUtils.getBadgeBgColor(this, locationBadge));
            this._leftBadgeLabel.setText(locationBadge.getValue());
        }
    }

    private void updateRightBadge() {
        this._rightBadgeLabel.setVisible(false);
        String location = "SouthEast";
        HubSeedBadge locationBadge = HubSeedUtils.getLocationBadge(this._seed, location);
        if (locationBadge != null) {
            this._rightBadgeLabel.setVisible(true);
            this._rightBadgeLabel.setOpaque(true);
            this._rightBadgeLabel.setFont(HubSeedUtils.getFontScaled("hub-item-installed-font"));
            this._rightBadgeLabel.setForeground(HubSeedUtils.getBadgeFgColor(this, locationBadge));
            this._rightBadgeLabel.setBackground(HubSeedUtils.getBadgeBgColor(this, locationBadge));
            this._rightBadgeLabel.setText(locationBadge.getValue());
        }
    }

    private void updateIcon() {
        this._iconLabel.setText("");
        HubSeedIcon seedIcon = this._seed.getIcon();
        if (seedIcon != null) {
            Image image = seedIcon.getImage((ImageCallback)new SeedIconCallback());
            this.setSeedIcon(ImageUtils.toIcon((Image)image));
        }
    }

    private void setSeedIcon(ImageIcon icon) {
        if (icon != null) {
            this._iconLabel.setIcon(icon);
        }
    }

    private void updatePreviewImage() {
        this._previewImageLabel.setText("");
        this.requestPreviewImage(this._seed.getPreviewImageUrl());
    }

    private void requestPreviewImage(String previewImageUrl) {
        boolean requestMade = false;
        if (previewImageUrl != null && !StringUtilities.isNullOrEmpty((String)(previewImageUrl = StringUtilities.trim((String)previewImageUrl))) && FastURL.isFastURL((String)previewImageUrl)) {
            try {
                FastURL fastUrl = new FastURL(previewImageUrl);
                if (PrivacyModeSettings.getInstance().getPrivacyMode() != PrivacyMode.STEALTH || PrivacyModeStrategy.mayDownload((FastURL)fastUrl)) {
                    ImageFromUrlThread imageFromUrl = new ImageFromUrlThread(fastUrl.getURL(), (ImageFromUrlCallback)this, false);
                    imageFromUrl.start();
                    requestMade = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!requestMade) {
            this.imageFromUrlFailed(null, null);
        }
    }

    public void imageFromUrlReady(ImageFromUrlThread sender, Image image) {
        this.setPreviewImage(ImageUtils.toIcon(image instanceof BufferedImage ? ImageUtils.smartSize((BufferedImage)((BufferedImage)image), (double)640.0, (double)360.0, (boolean)true) : null));
    }

    public void imageFromUrlFailed(ImageFromUrlThread sender, Exception ex) {
        this._previewImageLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._previewImageLabel.setPreferredSize(new Dimension(this._previewImageLabel.getPreferredSize().width, 1));
        this.resizeInfoScrollPane();
    }

    private void setPreviewImage(ImageIcon icon) {
        if (icon == null) {
            this.imageFromUrlFailed(null, null);
        } else {
            this._previewImageLabel.setIcon(icon);
        }
    }

    private void updateProviderContact() {
        this._providerContactLabel.setFont(this._providerContactLabel.getFont().deriveFont(1));
        this._providerWebsiteScrollPane.getViewport().setBackground(DETAILS_BG);
        this._providerEmailScrollPane.getViewport().setBackground(DETAILS_BG);
        int maxWidth = 1020 - this._previewImageLabel.getPreferredSize().width;
        HubSeedProvider provider = this._seed.getProvider();
        int wrappedLines1 = 0;
        int wrappedLines2 = 0;
        if (provider == null) {
            this._contactPanel.setVisible(false);
        } else {
            String name = provider.getName();
            if (!StringUtilities.isNullOrEmpty((String)name)) {
                name = "by " + name;
                this._providerNameLabel.setText(name);
            } else {
                this._providerNameLabel.setVisible(false);
            }
            wrappedLines1 = this.update(provider.getWebsite(), this._providerWebsiteTextPane, false, maxWidth, true, new JComponent[0]);
            String email = provider.getEmail();
            if (!StringUtilities.isNullOrEmpty((String)email)) {
                email = StringUtilities.trim((String)email);
                email = HtmlUtils.mailTo((String)email, (String)this._seed.getDisplayName(), (boolean)false);
            }
            wrappedLines2 = this.update(email, this._providerEmailTextPane, false, maxWidth, false, new JComponent[0]);
            if (!this._providerWebsiteTextPane.isVisible() && !this._providerEmailTextPane.isVisible()) {
                this._contactPanel.setVisible(false);
            }
        }
        this._providerWebsiteScrollPane.getViewport().setPreferredSize(new Dimension(maxWidth, this._singleRowComponentHeightEstimate));
        HubSeedDetailsPanel.updateHeight(this._providerWebsiteScrollPane, this._singleRowComponentHeightEstimate, maxWidth, Integer.MAX_VALUE, wrappedLines1);
        this._providerEmailScrollPane.getViewport().setPreferredSize(new Dimension(maxWidth, this._singleRowComponentHeightEstimate));
        HubSeedDetailsPanel.updateHeight(this._providerEmailScrollPane, this._singleRowComponentHeightEstimate, maxWidth, Integer.MAX_VALUE, wrappedLines2);
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._providerWebsiteScrollPane, (JPanel)this._contactPanel, (boolean)false);
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._providerEmailScrollPane, (JPanel)this._contactPanel, (boolean)false);
    }

    private void updateRegistration() {
        this._registerWebsiteLabel.setFont(this._registerWebsiteLabel.getFont().deriveFont(1));
        this._registerWebsiteScrollPane.getViewport().setBackground(DETAILS_BG);
        int maxWidth = 1020 - this._previewImageLabel.getPreferredSize().width;
        int wrappedLines = 0;
        HubSeedRegistration registration = this._seed.getRegistration();
        if (registration == null) {
            this._registerPanel.setVisible(false);
        } else {
            wrappedLines = this.update(registration.getWebsite(), this._registerWebsiteTextPane, false, maxWidth, true, this._registerWebsiteLabel);
        }
        this._registerWebsiteScrollPane.getViewport().setPreferredSize(new Dimension(maxWidth, this._singleRowComponentHeightEstimate));
        HubSeedDetailsPanel.updateHeight(this._registerWebsiteScrollPane, this._singleRowComponentHeightEstimate, maxWidth, Integer.MAX_VALUE, wrappedLines);
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._registerWebsiteScrollPane, (JPanel)this._registerPanel, (boolean)false);
    }

    private void updatePricingInfo() {
        this._pricingInfoLabel.setFont(this._pricingInfoLabel.getFont().deriveFont(1));
        this._pricingInfoScrollPane.getViewport().setBackground(DETAILS_BG);
        HubSeedPricing pricing = this._seed.getPricing();
        int maxWidth = 1020 - this._previewImageLabel.getPreferredSize().width;
        int wrappedLines = 0;
        if (pricing == null) {
            this._pricingPanel.setVisible(false);
        } else {
            wrappedLines = this.update(pricing.getInfo(), this._pricingInfoTextPane, false, maxWidth, false, this._pricingInfoLabel);
        }
        this._pricingInfoScrollPane.getViewport().setPreferredSize(new Dimension(maxWidth, this._singleRowComponentHeightEstimate));
        HubSeedDetailsPanel.updateHeight(this._pricingInfoScrollPane, this._singleRowComponentHeightEstimate, maxWidth, Integer.MAX_VALUE, wrappedLines);
        ScrollablePanel.makeScrollpaneParentAware((JScrollPane)this._pricingInfoScrollPane, (JPanel)this._pricingPanel, (boolean)false);
    }

    private int update(String text, JTextComponent textComponent, boolean bold, int maxWidth, boolean wrapLink, JComponent ... otherControls) {
        int wrappedLines = 0;
        if (!StringUtilities.isNullOrEmpty((String)text)) {
            if (textComponent instanceof JTextPane) {
                text = text.trim();
                FontMetrics fm = textComponent.getFontMetrics(bold ? textComponent.getFont().deriveFont(1) : textComponent.getFont());
                wrappedLines = StringUtilities.getWrappedLines((String)text, (FontMetrics)fm, (Insets)textComponent.getInsets(), (int)maxWidth);
                if (!HtmlUtils.containsHtmlLink((String)(text = text.replaceAll("\\r?\\n", "\n<br>")))) {
                    text = HtmlUtils.getClickableText((String)text, (FontMetrics)fm, (Insets)textComponent.getInsets(), (int)maxWidth, (boolean)wrapLink);
                }
                Color linkColor = LAF.getColor("hub-item-details-link-color-fg");
                String linkColorString = String.format("#%02x%02x%02x", linkColor.getRed(), linkColor.getGreen(), linkColor.getBlue());
                String styles = "<style>\na {\n   color: " + linkColorString + ";\n   text-decoration: none;\n}</style>";
                text = bold ? "<html><head>" + styles + "</head><body style='font-weight: bold; color: black'>" + text + "</body></html>" : "<html><head>" + styles + "</head><body style='color: black'>" + text + "</body></html>";
                textComponent.setText(text);
                ((JTextPane)textComponent).addHyperlinkListener(event -> HtmlUtils.registerHyperlinkEvents((HyperlinkEvent)event));
            } else {
                textComponent.setText(text);
            }
        } else {
            textComponent.setVisible(false);
            for (JComponent control : otherControls) {
                control.setVisible(false);
            }
        }
        return wrappedLines;
    }

    private void initComponents() {
        this._namePanel = new JPanel();
        this._iconLabel = new JLabel();
        this._displayNameLabel = new JLabel();
        this._providerNameLabel = new JLabel();
        this.filler = new JPanel();
        this._leftBadgeLabel = new JLabel();
        this._rightBadgeLabel = new JLabel();
        this._hubNameDivider = new JPanel();
        this._tempTextField = new JTextField();
        this._tagsStatsParent = new JPanel();
        this._tagsPanel = new JPanel();
        this._statsPanel = new JPanel();
        this._txEntityCountLabel = new JLabel();
        this._modifiedLabel = new JLabel();
        this._infoScrollPane = new JScrollPane();
        this._infoScrollablePanel = new ScrollablePanel();
        this._infoPanel = new JPanel();
        this._descriptionPanel = new JPanel();
        this._descriptionScrollPane = new JScrollPane();
        this._descriptionTextPane = new JTextPane();
        this._detailsScrollPane = new JScrollPane();
        this._detailsTextPane = new JTextPane();
        this._pricingPanel = new JPanel();
        this._pricingInfoLabel = new JLabel();
        this._pricingInfoScrollPane = new JScrollPane();
        this._pricingInfoTextPane = new JTextPane();
        this._contactPanel = new JPanel();
        this._providerContactLabel = new JLabel();
        this._providerWebsiteScrollPane = new JScrollPane();
        this._providerWebsiteTextPane = new JTextPane();
        this._providerEmailScrollPane = new JScrollPane();
        this._providerEmailTextPane = new JTextPane();
        this._registerPanel = new JPanel();
        this._registerWebsiteLabel = new JLabel();
        this._registerWebsiteScrollPane = new JScrollPane();
        this._registerWebsiteTextPane = new JTextPane();
        this._previewImageLabel = new JLabel();
        this.fillerPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this._certsLabel = new JLabel();
        this._filler1 = new Box.Filler(new Dimension(6, 0), new Dimension(6, 0), new Dimension(6, Short.MAX_VALUE));
        this._certsCombo = new JComboBox();
        this._filler2 = new Box.Filler(new Dimension(6, 0), new Dimension(6, 0), new Dimension(6, Short.MAX_VALUE));
        this._viewCertButton = new JButton();
        this._filler3 = new Box.Filler(new Dimension(6, 0), new Dimension(6, 0), new Dimension(6, Short.MAX_VALUE));
        this._settingsButton = new JButton();
        this.setBackground(DETAILS_BG);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this._namePanel.setOpaque(false);
        this._namePanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._iconLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._iconLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        this._namePanel.add((Component)this._iconLabel, gridBagConstraints);
        this._displayNameLabel.setVerticalAlignment(3);
        this._displayNameLabel.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 10, 6, 0);
        this._namePanel.add((Component)this._displayNameLabel, gridBagConstraints);
        this._providerNameLabel.setVerticalAlignment(3);
        this._providerNameLabel.setVerticalTextPosition(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 10, 6, 0);
        this._namePanel.add((Component)this._providerNameLabel, gridBagConstraints);
        this.filler.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this._namePanel.add((Component)this.filler, gridBagConstraints);
        this._leftBadgeLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this._leftBadgeLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._leftBadgeLabel.text"));
        this._leftBadgeLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this._namePanel.add((Component)this._leftBadgeLabel, gridBagConstraints);
        this._rightBadgeLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this._rightBadgeLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._rightBadgeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this._namePanel.add((Component)this._rightBadgeLabel, gridBagConstraints);
        this._hubNameDivider.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this._hubNameDivider.setMinimumSize(new Dimension(10, 2));
        this._hubNameDivider.setPreferredSize(new Dimension(10, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this._namePanel.add((Component)this._hubNameDivider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this._namePanel.add((Component)this._tempTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._namePanel, gridBagConstraints);
        this._tagsStatsParent.setOpaque(false);
        this._tagsStatsParent.setLayout(new BorderLayout());
        this._tagsPanel.setBackground(DETAILS_BG);
        this._tagsStatsParent.add((Component)this._tagsPanel, "Center");
        this._statsPanel.setOpaque(false);
        this._statsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._txEntityCountLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._txEntityCountLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this._statsPanel.add((Component)this._txEntityCountLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._modifiedLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._modifiedLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this._statsPanel.add((Component)this._modifiedLabel, gridBagConstraints);
        this._tagsStatsParent.add((Component)this._statsPanel, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 4, 0);
        this.add((Component)this._tagsStatsParent, gridBagConstraints);
        this._infoScrollPane.setBorder(null);
        this._infoScrollablePanel.setLayout((LayoutManager)new BorderLayout());
        this._infoPanel.setBackground(DETAILS_BG);
        this._infoPanel.setLayout(new GridBagLayout());
        this._descriptionPanel.setOpaque(false);
        this._descriptionPanel.setLayout(new BorderLayout());
        this._descriptionScrollPane.setOpaque(false);
        this._descriptionTextPane.setEditable(false);
        this._descriptionTextPane.setBackground(DETAILS_BG);
        this._descriptionTextPane.setContentType("text/html");
        this._descriptionTextPane.setMargin(new Insets(4, 0, 4, 0));
        this._descriptionScrollPane.setViewportView(this._descriptionTextPane);
        this._descriptionPanel.add((Component)this._descriptionScrollPane, "North");
        this._detailsScrollPane.setOpaque(false);
        this._detailsTextPane.setEditable(false);
        this._detailsTextPane.setBackground(DETAILS_BG);
        this._detailsTextPane.setContentType("text/html");
        this._detailsTextPane.setMargin(new Insets(4, 0, 0, 0));
        this._detailsScrollPane.setViewportView(this._detailsTextPane);
        this._descriptionPanel.add((Component)this._detailsScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this._infoPanel.add((Component)this._descriptionPanel, gridBagConstraints);
        this._pricingPanel.setOpaque(false);
        this._pricingPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._pricingInfoLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._pricingInfoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 2, 0);
        this._pricingPanel.add((Component)this._pricingInfoLabel, gridBagConstraints);
        this._pricingInfoScrollPane.setOpaque(false);
        this._pricingInfoTextPane.setEditable(false);
        this._pricingInfoTextPane.setBackground(DETAILS_BG);
        this._pricingInfoTextPane.setContentType("text/html");
        this._pricingInfoTextPane.setMargin(new Insets(4, 0, 4, 0));
        this._pricingInfoScrollPane.setViewportView(this._pricingInfoTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this._pricingPanel.add((Component)this._pricingInfoScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this._infoPanel.add((Component)this._pricingPanel, gridBagConstraints);
        this._contactPanel.setOpaque(false);
        this._contactPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._providerContactLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._providerContactLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 2, 0);
        this._contactPanel.add((Component)this._providerContactLabel, gridBagConstraints);
        this._providerWebsiteScrollPane.setOpaque(false);
        this._providerWebsiteTextPane.setEditable(false);
        this._providerWebsiteTextPane.setBackground(DETAILS_BG);
        this._providerWebsiteTextPane.setContentType("text/html");
        this._providerWebsiteTextPane.setMargin(new Insets(4, 0, 0, 0));
        this._providerWebsiteScrollPane.setViewportView(this._providerWebsiteTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this._contactPanel.add((Component)this._providerWebsiteScrollPane, gridBagConstraints);
        this._providerEmailScrollPane.setOpaque(false);
        this._providerEmailTextPane.setEditable(false);
        this._providerEmailTextPane.setBackground(DETAILS_BG);
        this._providerEmailTextPane.setContentType("text/html");
        this._providerEmailTextPane.setMargin(new Insets(0, 0, 4, 0));
        this._providerEmailScrollPane.setViewportView(this._providerEmailTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this._contactPanel.add((Component)this._providerEmailScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this._infoPanel.add((Component)this._contactPanel, gridBagConstraints);
        this._registerPanel.setOpaque(false);
        this._registerPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this._registerWebsiteLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._registerWebsiteLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 2, 0);
        this._registerPanel.add((Component)this._registerWebsiteLabel, gridBagConstraints);
        this._registerWebsiteScrollPane.setOpaque(false);
        this._registerWebsiteTextPane.setEditable(false);
        this._registerWebsiteTextPane.setBackground(DETAILS_BG);
        this._registerWebsiteTextPane.setContentType("text/html");
        this._registerWebsiteTextPane.setMargin(new Insets(4, 0, 4, 0));
        this._registerWebsiteScrollPane.setViewportView(this._registerWebsiteTextPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this._registerPanel.add((Component)this._registerWebsiteScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this._infoPanel.add((Component)this._registerPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this._previewImageLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._previewImageLabel.text"));
        this._previewImageLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this._previewImageLabel.setMaximumSize(new Dimension(640, 360));
        this._previewImageLabel.setMinimumSize(new Dimension(640, 360));
        this._previewImageLabel.setPreferredSize(new Dimension(640, 360));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        this._infoPanel.add((Component)this._previewImageLabel, gridBagConstraints);
        this.fillerPanel.setOpaque(false);
        this.fillerPanel.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this._infoPanel.add((Component)this.fillerPanel, gridBagConstraints);
        this._infoScrollablePanel.add((Component)this._infoPanel, (Object)"Center");
        this._infoScrollPane.setViewportView((Component)this._infoScrollablePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this._infoScrollPane, gridBagConstraints);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayout(new FlowLayout(0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this._certsLabel, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._certsLabel.text"));
        this.buttonPanel.add(this._certsLabel);
        this.buttonPanel.add(this._filler1);
        this._certsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonPanel.add(this._certsCombo);
        this.buttonPanel.add(this._filler2);
        Mnemonics.setLocalizedText((AbstractButton)this._viewCertButton, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._viewCertButton.text"));
        this._viewCertButton.setBorderPainted(false);
        this._viewCertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HubSeedDetailsPanel.this._viewCertButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this._viewCertButton);
        this.buttonPanel.add(this._filler3);
        Mnemonics.setLocalizedText((AbstractButton)this._settingsButton, (String)NbBundle.getMessage(HubSeedDetailsPanel.class, (String)"HubSeedDetailsPanel._settingsButton.text"));
        this._settingsButton.setBorderPainted(false);
        this._settingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HubSeedDetailsPanel.this._settingsButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this._settingsButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void _viewCertButtonActionPerformed(ActionEvent evt) {
        String selectedUrl = null;
        if (this._certsCombo.getSelectedItem() != null) {
            selectedUrl = this._urls.get(this._certsCombo.getSelectedItem().toString());
        }
        CertificateDisplayer.showCertificate((JComponent)this, (HubSeedDescriptor)this._seed, selectedUrl);
    }

    private void _settingsButtonActionPerformed(ActionEvent evt) {
        HubSeedSettings.getDefault().show(this._seed);
    }

    private class SeedIconCallback
    implements ImageCallback {
        private SeedIconCallback() {
        }

        public void imageReady(Image image) {
            HubSeedDetailsPanel.this.setSeedIcon(this.toIcon(image));
        }
    }
}

