/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jws;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.keycloak.jose.JOSEHeader;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.Algorithm;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JWSHeader
implements JOSEHeader {
    @JsonProperty(value="alg")
    private Algorithm algorithm;
    @JsonProperty(value="typ")
    private String type;
    @JsonProperty(value="cty")
    private String contentType;
    @JsonProperty(value="kid")
    private String keyId;
    @JsonProperty(value="jwk")
    private JWK key;
    private static final ObjectMapper mapper = new ObjectMapper();

    public JWSHeader() {
    }

    public JWSHeader(Algorithm algorithm, String type, String contentType) {
        this.algorithm = algorithm;
        this.type = type;
        this.contentType = contentType;
    }

    public JWSHeader(Algorithm algorithm, String type, String keyId, JWK key) {
        this.algorithm = algorithm;
        this.type = type;
        this.keyId = keyId;
        this.key = key;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @JsonIgnore
    public String getRawAlgorithm() {
        return this.getAlgorithm().name();
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    public JWK getKey() {
        return this.key;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

