/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.previous;

import com.paterva.maltego.util.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.modules.Places;

public class PreviousConfigDirs {
    private static final boolean TEST1 = false;
    private static final boolean TEST2 = false;

    public static File detectLatest() throws IOException {
        File maltegoConfDir = PreviousConfigDirs.getMaltegoConfigParent();
        if (maltegoConfDir.isDirectory()) {
            return PreviousConfigDirs.getPreviousConfigDir(maltegoConfDir);
        }
        return null;
    }

    public static File getMaltegoConfigParent() throws IOException {
        File userDir = Places.getUserDirectory();
        File curConfDir = userDir.getAbsoluteFile();
        if (!curConfDir.isDirectory()) {
            throw new IOException("Current user directory not a directory: " + curConfDir);
        }
        File maltegoConfDir = curConfDir.getParentFile();
        if (!maltegoConfDir.isDirectory()) {
            throw new IOException("Maltego user directory not a directory: " + maltegoConfDir);
        }
        return maltegoConfDir;
    }

    public static List<String> getPreviousConfigDirs(File maltegoConfDir) {
        List<String> confDirs = PreviousConfigDirs.removeCurrentConfigDir(maltegoConfDir, maltegoConfDir.list());
        confDirs = PreviousConfigDirs.filterHasConfigs(maltegoConfDir, confDirs);
        confDirs = PreviousConfigDirs.filterNewerThan(confDirs, 1, 0, 0);
        confDirs = PreviousConfigDirs.filterSameDistro(confDirs);
        return confDirs;
    }

    private static File getPreviousConfigDir(File maltegoConfDir) {
        File newestFile;
        List<String> confDirs = PreviousConfigDirs.getPreviousConfigDirs(maltegoConfDir);
        String newest = PreviousConfigDirs.newest(confDirs);
        File file = newestFile = newest == null ? null : new File(maltegoConfDir, newest).getAbsoluteFile();
        if (newestFile == null) {
            File oldMaltegoConfDir;
            File maltegoConfDirParent;
            String appnameConf;
            String newMaltegoId = appnameConf = Version.getCurrent().getAppnameConf();
            if (maltegoConfDir.toString().endsWith(File.separator)) {
                newMaltegoId = newMaltegoId + File.separator;
            }
            if (maltegoConfDir.toString().endsWith(newMaltegoId) && (maltegoConfDirParent = maltegoConfDir.getParentFile()) != null && maltegoConfDirParent.isDirectory() && (oldMaltegoConfDir = new File(maltegoConfDirParent, "." + appnameConf)).isDirectory() && oldMaltegoConfDir.canWrite()) {
                List<String> oldConfDirs = PreviousConfigDirs.getPreviousConfigDirs(oldMaltegoConfDir);
                newest = PreviousConfigDirs.newest(oldConfDirs);
                newestFile = newest == null ? null : new File(oldMaltegoConfDir, newest).getAbsoluteFile();
            }
        }
        return newestFile;
    }

    private static List<String> removeCurrentConfigDir(File maltegoConfDir, String[] confDirs) {
        ArrayList<String> dirs = new ArrayList<String>();
        File userDir = Places.getUserDirectory();
        File curConfDir = userDir.getAbsoluteFile();
        for (String dir : confDirs) {
            File confDir = new File(maltegoConfDir, dir).getAbsoluteFile();
            if (confDir.equals(curConfDir)) continue;
            dirs.add(dir);
        }
        return dirs;
    }

    private static List<String> filterHasConfigs(File maltegoConfDir, List<String> confDirs) {
        ArrayList<String> dirs = new ArrayList<String>();
        for (String confDir : confDirs) {
            File file = new File(new File(new File(maltegoConfDir, confDir), "config"), "Maltego");
            if (!file.isDirectory()) continue;
            dirs.add(confDir);
        }
        return dirs;
    }

    private static List<String> filterNewerThan(List<String> confDirs, int release, int major, int minor) {
        Version minVersion = new Version(release, major, minor);
        ArrayList<String> dirs = new ArrayList<String>();
        for (String dir : confDirs) {
            Version version = PreviousConfigDirs.getVersion(dir);
            if (version == null || version.compareTo(minVersion) < 0) continue;
            dirs.add(dir);
        }
        return dirs;
    }

    private static List<String> filterSameDistro(List<String> confDirs) {
        ArrayList<String> dirs = new ArrayList<String>();
        String currentDistro = PreviousConfigDirs.getUserDirDistro(Places.getUserDirectory().getName());
        for (String dir : confDirs) {
            if (!currentDistro.equals(PreviousConfigDirs.getUserDirDistro(dir))) continue;
            dirs.add(dir);
        }
        return dirs;
    }

    private static String getUserDirDistro(String dir) {
        return dir.replaceAll("\\d|[.]", "");
    }

    private static String newest(List<String> dirs) {
        String newest = null;
        Version newestVersion = null;
        for (String dir : dirs) {
            Version version = PreviousConfigDirs.getVersion(dir);
            if (version == null) continue;
            boolean isNewer = false;
            if (newest == null) {
                isNewer = true;
            } else {
                int compareTo = version.compareTo(newestVersion);
                if (compareTo > 0) {
                    isNewer = true;
                } else if (compareTo == 0 && dir.length() < newest.length()) {
                    isNewer = true;
                }
            }
            if (!isNewer) continue;
            newest = dir;
            newestVersion = version;
        }
        return newest;
    }

    public static Version getVersion(String dir) {
        Pattern p;
        Matcher m;
        Version version = null;
        if (dir.matches("^v[.\\d]+.*$") && (m = (p = Pattern.compile("[.\\d]+")).matcher(dir)).find()) {
            String group = m.group();
            version = Version.parse((String)group);
        }
        return version;
    }

    private static List<String> testDirs() {
        String[] dirs = new String[]{"dev", "v2.43.5", "v3.4.5BETA", "v3.4.5RC3", "v3.4.5", "v4.4.5.2342", "v10.2.4"};
        return Arrays.asList(dirs);
    }
}

