/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl.tools;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.NeighbourMode;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CollectionUtils {
    private static final boolean CHECK_ARGS = false;

    private static Set<LinkID> getLinksViewLink(Map<EntityID, ViewEntity> entities, EntityID entityId, Direction dir) {
        ViewEntity viewEntity = entities.get(entityId);
        switch (dir) {
            case INCOMING: {
                return viewEntity.getAllLinks().getViewIncomingLinks();
            }
            case OUTGOING: {
                return viewEntity.getAllLinks().getViewOutgoingLinks();
            }
            case BOTH: {
                return viewEntity.getAllLinks().getViewLinks();
            }
        }
        throw new IllegalArgumentException("Invalid direction");
    }

    private static int getLinksViewLinksCount(Map<EntityID, ViewEntity> entities, EntityID entityId, Direction dir) {
        ViewEntity viewEntity = entities.get(entityId);
        switch (dir) {
            case INCOMING: {
                return viewEntity.getAllLinks().getViewIncomingCount();
            }
            case OUTGOING: {
                return viewEntity.getAllLinks().getViewOutgoingCount();
            }
            case BOTH: {
                return viewEntity.getAllLinks().getViewLinkCount();
            }
        }
        throw new IllegalArgumentException("Invalid direction");
    }

    private static boolean hasLinksViewLinks(Map<EntityID, ViewEntity> entities, EntityID entityId, Direction dir) {
        ViewEntity viewEntity = entities.get(entityId);
        switch (dir) {
            case INCOMING: {
                return viewEntity.getAllLinks().hasViewIncomingLinks();
            }
            case OUTGOING: {
                return viewEntity.getAllLinks().hasViewOutgoingLinks();
            }
            case BOTH: {
                return viewEntity.getAllLinks().hasViewLinks();
            }
        }
        throw new IllegalArgumentException("Invalid direction");
    }

    private static Set<EntityID> getNeighbors(Set<LinkID> incomingLinks, Map<LinkID, ViewLink> links, Direction dir) {
        HashSet<EntityID> neighbors = new HashSet<EntityID>();
        for (LinkID incomingLink : incomingLinks) {
            LinkEntityIDs ids = links.get(incomingLink).getEntities();
            switch (dir) {
                case INCOMING: {
                    neighbors.add(ids.getSourceID());
                    break;
                }
                case OUTGOING: {
                    neighbors.add(ids.getTargetID());
                    break;
                }
                case BOTH: {
                    neighbors.add(ids.getSourceID());
                    neighbors.add(ids.getTargetID());
                }
            }
        }
        return neighbors;
    }

    private static Set<EntityID> getNeighborsLinkEntityIds(Set<LinkID> incomingLinks, Map<LinkID, LinkEntityIDs> links, Direction dir) {
        HashSet<EntityID> neighbors = new HashSet<EntityID>();
        for (LinkID incomingLink : incomingLinks) {
            LinkEntityIDs ids = links.get(incomingLink);
            switch (dir) {
                case INCOMING: {
                    neighbors.add(ids.getSourceID());
                    break;
                }
                case OUTGOING: {
                    neighbors.add(ids.getTargetID());
                    break;
                }
                case BOTH: {
                    neighbors.add(ids.getSourceID());
                    neighbors.add(ids.getTargetID());
                }
            }
        }
        return neighbors;
    }

    public static boolean isCollectable(ModelSnapshotData msd, EntityID modelEntity, int maxNeighbours) throws GraphStoreException {
        boolean hasNotes;
        if (msd.collectedViewEntitiesContains(modelEntity)) {
            return false;
        }
        boolean pinned = msd.isEntityPinned(modelEntity);
        if (pinned) {
            return false;
        }
        MaltegoEntity entitySkeleton = msd.getEntitySkeleton(modelEntity);
        if (entitySkeleton == null) {
            throw new GraphStoreException("MaltegoEntity returned from EntitySkeletonProvider is null");
        }
        boolean bl = hasNotes = !StringUtilities.isNullOrEmpty((String)entitySkeleton.getNotes());
        if (hasNotes) {
            return false;
        }
        if (entitySkeleton.hasAttachments()) {
            return false;
        }
        Map<EntityID, EntityLinks> modelEntitiesToCollect = msd.getModelEntitiesToCollect();
        Set<LinkID> modelIncomingLinks = modelEntitiesToCollect.get(modelEntity).getModelIncomingLinks();
        Set<LinkID> modelOutgoingLinks = modelEntitiesToCollect.get(modelEntity).getModelOutgoingLinks();
        Integer neighbourCount = msd.getNeighbourCount(modelEntity);
        if (neighbourCount == null) {
            Set<EntityID> neighbours = CollectionUtils.getNeighbours(msd, modelIncomingLinks, modelOutgoingLinks);
            neighbourCount = neighbours.size();
            msd.setNeighbourCount(modelEntity, neighbourCount);
        }
        if (neighbourCount > maxNeighbours) {
            return false;
        }
        Map<LinkID, LinkEntityIDs> modelLinksToCollect = msd.getModelLinksToCollect();
        Set<LinkID> keySet = modelLinksToCollect.keySet();
        if (!keySet.containsAll(modelIncomingLinks)) {
            return false;
        }
        return keySet.containsAll(modelOutgoingLinks);
    }

    private static Set<EntityID> getNeighbours(ModelSnapshotData msd, Set<LinkID> modelIncomingLinks, Set<LinkID> modelOutgoingLinks) {
        LinkEntityIDs linkEntities;
        ArrayList<EntityID> neighbours = new ArrayList<EntityID>();
        for (LinkID link : modelIncomingLinks) {
            linkEntities = msd.getModelLinksToCollect().get(link);
            neighbours.add(linkEntities.getSourceID());
        }
        for (LinkID link : modelOutgoingLinks) {
            linkEntities = msd.getModelLinksToCollect().get(link);
            neighbours.add(linkEntities.getTargetID());
        }
        return new HashSet<EntityID>(neighbours);
    }

    static String getFirstValidEntityType(GraphDataStoreReader dataReader, Set<EntityID> entities) throws GraphStoreException {
        for (EntityID entity : entities) {
            String entityType = dataReader.getEntityType(entity);
            if (entityType == null) continue;
            return entityType;
        }
        throw new GraphStoreException("Failed to get entity type");
    }

    public static Set<LinkID> getLinks(Map<EntityID, ViewEntity> entities, EntityID entityId) {
        return CollectionUtils.getLinksViewLink(entities, entityId, Direction.BOTH);
    }

    public static Set<LinkID> getIncoming(Map<EntityID, ViewEntity> entities, EntityID entityId) {
        return CollectionUtils.getLinksViewLink(entities, entityId, Direction.INCOMING);
    }

    public static Set<LinkID> getOutgoing(Map<EntityID, ViewEntity> entities, EntityID entityId) {
        return CollectionUtils.getLinksViewLink(entities, entityId, Direction.OUTGOING);
    }

    public static Set<LinkID> getLinks(Map<EntityID, ViewEntity> entities, Set<EntityID> entityIds) {
        HashSet<LinkID> returnLinks = new HashSet<LinkID>();
        for (EntityID entityId : entityIds) {
            returnLinks.addAll(CollectionUtils.getLinks(entities, entityId));
        }
        return returnLinks;
    }

    public static Set<LinkID> getIncoming(Map<EntityID, ViewEntity> entities, Set<EntityID> entityIds) {
        HashSet<LinkID> returnLinks = new HashSet<LinkID>();
        for (EntityID entityId : entityIds) {
            returnLinks.addAll(CollectionUtils.getIncoming(entities, entityId));
        }
        return returnLinks;
    }

    public static Set<LinkID> getOutgoing(Map<EntityID, ViewEntity> entities, Set<EntityID> entityIds) {
        HashSet<LinkID> returnLinks = new HashSet<LinkID>();
        for (EntityID entityId : entityIds) {
            returnLinks.addAll(CollectionUtils.getOutgoing(entities, entityId));
        }
        return returnLinks;
    }

    public static int getLinkCount(Map<EntityID, ViewEntity> entities, EntityID entityId) {
        return CollectionUtils.getLinksViewLinksCount(entities, entityId, Direction.BOTH);
    }

    public static int getIncomingLinkCount(Map<EntityID, ViewEntity> entities, EntityID entityId) {
        return CollectionUtils.getLinksViewLinksCount(entities, entityId, Direction.INCOMING);
    }

    public static int getOutgoingLinkCount(Map<EntityID, ViewEntity> entities, EntityID entityId) {
        return CollectionUtils.getLinksViewLinksCount(entities, entityId, Direction.OUTGOING);
    }

    public static boolean hasLinks(Map<EntityID, ViewEntity> entities, EntityID entityId) {
        return CollectionUtils.hasLinksViewLinks(entities, entityId, Direction.BOTH);
    }

    static boolean hasIncomingLinks(Map<EntityID, ViewEntity> entities, EntityID entityId) {
        return CollectionUtils.hasLinksViewLinks(entities, entityId, Direction.INCOMING);
    }

    static boolean hasOutgoingLinks(Map<EntityID, ViewEntity> entities, EntityID entityId) {
        return CollectionUtils.hasLinksViewLinks(entities, entityId, Direction.OUTGOING);
    }

    static Set<EntityID> getParents(Set<LinkID> incomingLinks, Map<LinkID, ViewLink> links) {
        Direction dir = Direction.INCOMING;
        return CollectionUtils.getNeighbors(incomingLinks, links, dir);
    }

    static Set<EntityID> getChildren(Set<LinkID> outgoingLinks, Map<LinkID, ViewLink> links) {
        Direction dir = Direction.OUTGOING;
        return CollectionUtils.getNeighbors(outgoingLinks, links, dir);
    }

    static Set<EntityID> getNeighbors(Set<LinkID> allLinks, Map<LinkID, ViewLink> links) {
        Direction dir = Direction.BOTH;
        return CollectionUtils.getNeighbors(allLinks, links, dir);
    }

    public static Set<EntityID> getParents(Map<EntityID, ViewEntity> entities, Map<LinkID, ViewLink> links, EntityID entity) {
        Direction dir = Direction.INCOMING;
        Set<LinkID> incomingLinks = CollectionUtils.getLinksViewLink(entities, entity, dir);
        return CollectionUtils.getParents(incomingLinks, links);
    }

    public static Set<EntityID> getChildren(Map<EntityID, ViewEntity> entities, Map<LinkID, ViewLink> links, EntityID entity) {
        Direction dir = Direction.OUTGOING;
        Set<LinkID> outgoingLinks = CollectionUtils.getLinksViewLink(entities, entity, dir);
        return CollectionUtils.getChildren(outgoingLinks, links);
    }

    static Set<EntityID> getNeighbors(Map<EntityID, ViewEntity> entities, Map<LinkID, ViewLink> links, EntityID entity) {
        Direction dir = Direction.BOTH;
        Set<LinkID> allLinks = CollectionUtils.getLinksViewLink(entities, entity, dir);
        return CollectionUtils.getNeighbors(allLinks, links);
    }

    public static Point getMean(Collection<Point> points) {
        int s = 0;
        double x = 0.0;
        double y = 0.0;
        for (Point point : points) {
            if (point == null) continue;
            x += (double)point.x;
            y += (double)point.y;
            ++s;
        }
        return s == 0 ? null : new Point((int)Math.round(x / (double)s), (int)Math.round(y / (double)s));
    }

    private static LinkEntityIDs getLinkEntityIDs(ModelSnapshotData msd, Map<LinkID, LinkEntityIDs> links, LinkID modelLinkID) {
        LinkEntityIDs linkEntIDs = links.get(modelLinkID);
        if (linkEntIDs == null && msd.isRecollectingEntireGraph()) {
            throw new IllegalStateException("Model Link " + modelLinkID + " does not exist in the Link snapshot");
        }
        return linkEntIDs;
    }

    public static Set<EntityID> getEntities(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links, EntityID entity, NeighbourMode mode) throws GraphStoreException {
        return CollectionUtils.getEntities(msd, entities, links, entity, mode, false, 0);
    }

    public static Set<EntityID> getEntities(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links, EntityID entity, NeighbourMode mode, int maxNeighbours) throws GraphStoreException {
        return CollectionUtils.getEntities(msd, entities, links, entity, mode, true, maxNeighbours);
    }

    private static Set<EntityID> getEntities(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links, EntityID entity, NeighbourMode mode, boolean checkCollectable, int maxNeighbours) throws GraphStoreException {
        EntityLinks entityLinks = entities.get(entity);
        Set<LinkID> modelLinks = null;
        if (entityLinks == null) {
            if (msd.isRecollectingEntireGraph()) {
                throw new IllegalStateException("No entity '" + entity + "' exists");
            }
            return Collections.EMPTY_SET;
        }
        switch (mode) {
            case PARENTS: {
                modelLinks = entityLinks.getModelIncomingLinks();
                break;
            }
            case CHILDREN: {
                modelLinks = entityLinks.getModelOutgoingLinks();
            }
        }
        ArrayList<EntityID> ents = new ArrayList<EntityID>(modelLinks.size());
        for (LinkID link : modelLinks) {
            LinkEntityIDs linkEntities = CollectionUtils.getLinkEntityIDs(msd, links, link);
            if (linkEntities == null) continue;
            EntityID ent = null;
            switch (mode) {
                case PARENTS: {
                    ent = linkEntities.getSourceID();
                    break;
                }
                case CHILDREN: {
                    ent = linkEntities.getTargetID();
                }
            }
            if (checkCollectable && !CollectionUtils.isCollectable(msd, ent, maxNeighbours)) continue;
            ents.add(ent);
        }
        return new HashSet<EntityID>(ents);
    }

    static enum Direction {
        INCOMING,
        OUTGOING,
        BOTH;

    }
}

