/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.sets;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.descriptor.TransformSetRepository;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetConfig;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetEntryFactory;
import com.paterva.maltego.transform.manager.imex.sets.TransformSetExistInfo;
import com.paterva.maltego.transform.repository.FSTransformSetRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openide.filesystems.FileObject;

public class TransformSetImporter
extends ConfigImporter {
    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        List<TransformSet> setsAll = this.readSets(reader);
        return this.createConfig(setsAll);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        FSTransformSetRepository oldRepository = new FSTransformSetRepository(configRoot);
        Set setsAll = oldRepository.allSets();
        return this.createConfig(setsAll);
    }

    public List<TransformSet> readSets(MaltegoArchiveReader reader) throws IOException {
        return reader.readAll((EntryFactory)new TransformSetEntryFactory(), "Graph1");
    }

    private Config createConfig(Collection<TransformSet> setsAll) {
        ArrayList<TransformSet> setsSelected = new ArrayList<TransformSet>();
        TransformSetExistInfo existInfo = new TransformSetExistInfo();
        for (TransformSet set : setsAll) {
            if (existInfo.exist(set)) continue;
            setsSelected.add(set);
        }
        if (setsAll.size() > 0) {
            TransformSet[] all = setsAll.toArray(new TransformSet[setsAll.size()]);
            TransformSet[] selected = setsSelected.toArray(new TransformSet[setsSelected.size()]);
            return new TransformSetConfig(all, selected);
        }
        return null;
    }

    public int applyConfig(Config config) {
        TransformSetConfig setConfig = (TransformSetConfig)config;
        TransformSet[] sets = (TransformSet[])setConfig.getSelected();
        this.applySets(Arrays.asList(sets));
        return sets.length;
    }

    public void applySets(Collection<TransformSet> sets) {
        TransformSetRepository repo = TransformSetRepository.getDefault();
        for (TransformSet set : sets) {
            repo.put(set);
        }
    }
}

