/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form;

import com.paterva.maltego.typing.HighlightStyle;
import com.paterva.maltego.typing.editing.form.ControlAdapter;
import com.paterva.maltego.typing.editing.form.UserEditState;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public abstract class Input {
    private final ValueUpdater _updater = new ValueUpdater();
    private Component _input;
    private ControlAdapter _adapter;
    private boolean _isEditing = false;

    public Input(ControlAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Control adapter cannot be null");
        }
        this._adapter = adapter;
    }

    public Component getEditingComponent() {
        if (this._input == null) {
            this._input = this.createEditingComponent();
        }
        return this._input;
    }

    public boolean isEditing() {
        return this._isEditing;
    }

    public ControlAdapter getAdapter() {
        return this._adapter;
    }

    public Object getValue() {
        Object value = this._adapter.getValue(this.getEditingComponent());
        if (value instanceof String) {
            value = StringUtilities.trimIfNotBlank((Object)value);
            value = StringUtilities.escapeRTLBidiText((String)((String)value));
        }
        return value;
    }

    public void setValue(Object value) {
        if (!this._isEditing) {
            value = StringUtilities.trimIfNotBlank((Object)value);
            this._adapter.setValue(this.getEditingComponent(), value);
        }
    }

    public abstract Class getType();

    public abstract String getName();

    public String getDisplayName() {
        return this.getName();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public boolean isHidden() {
        return false;
    }

    public boolean canWrite() {
        return true;
    }

    public boolean isRequired() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getGroupName() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    public Object getSampleValue() {
        return null;
    }

    public void resetToDefault() {
        this.setValue(this.getDefaultValue());
    }

    public boolean isDefaultValue() {
        Object value = this.getValue();
        if (value == null) {
            return this.getDefaultValue() == null;
        }
        return value.equals(this.getDefaultValue());
    }

    protected Component createEditingComponent() {
        Component component = this._adapter.createComponent();
        component.addFocusListener(this._updater);
        component.addHierarchyListener(this._updater);
        this._adapter.setValue(component, this.getInitialValue());
        this._adapter.addActionListener(this._updater);
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            textComponent.getDocument().addDocumentListener(this._updater);
        }
        return component;
    }

    protected boolean validate(Object value) {
        return !this.isRequired() || value != null && !value.toString().isEmpty();
    }

    protected Object getInitialValue() {
        return this.getDefaultValue();
    }

    public HighlightStyle getHighlight() {
        return HighlightStyle.Normal;
    }

    private class ValueUpdater
    implements FocusListener,
    ActionListener,
    HierarchyListener,
    DocumentListener {
        private ValueUpdater() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.updateValue();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            this.updateValue();
        }

        private void updateValue() {
            if (!Input.this._isEditing) {
                Input.this._isEditing = true;
                SwingUtilities.invokeLater(() -> {
                    try {
                        UserEditState.setUserEditing(true);
                        Object value = Input.this.getValue();
                        if (Input.this.validate(value)) {
                            Input.this.getAdapter().setError(Input.this.getEditingComponent(), null);
                        } else {
                            Input.this.getAdapter().setError(Input.this.getEditingComponent(), "Value is required");
                        }
                    }
                    catch (Exception ex) {
                        Input.this.getAdapter().setError(Input.this.getEditingComponent(), "Invalid value");
                    }
                    finally {
                        UserEditState.setUserEditing(false);
                        Input.this._isEditing = false;
                    }
                });
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateValue();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateValue();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateValue();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateValue();
        }
    }
}

