/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class CenterLayout
implements LayoutManager {
    private static CenterLayout instance = new CenterLayout();

    @Override
    public void addLayoutComponent(String arg0, Component arg1) {
    }

    @Override
    public void removeLayoutComponent(Component arg0) {
    }

    @Override
    public Dimension preferredLayoutSize(Container arg0) {
        Insets insets = arg0.getInsets();
        int count = arg0.getComponentCount();
        if (count > 0) {
            Dimension d = arg0.getComponent(0).getPreferredSize();
            return new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container arg0) {
        Insets insets = arg0.getInsets();
        int count = arg0.getComponentCount();
        if (count > 0) {
            Dimension d = arg0.getComponent(0).getMinimumSize();
            return new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
    }

    @Override
    public void layoutContainer(Container container) {
        int count = container.getComponentCount();
        if (count > 0) {
            int height;
            int y;
            int width;
            int x;
            Component child = container.getComponent(0);
            Insets insets = container.getInsets();
            int availWidth = container.getWidth() - insets.left - insets.right;
            int availHeight = container.getHeight() - insets.top - insets.bottom;
            Dimension preferredSize = child.getPreferredSize();
            double preferredWidth = preferredSize.getWidth();
            double preferredHeight = preferredSize.getHeight();
            if (preferredWidth < (double)availWidth) {
                x = (int)Math.round((double)insets.left + ((double)availWidth - preferredWidth) / 2.0);
                width = (int)Math.round(preferredWidth);
            } else {
                x = insets.left;
                width = availWidth;
            }
            if (preferredHeight < (double)availHeight) {
                y = (int)Math.round((double)insets.top + ((double)availHeight - preferredHeight) / 2.0);
                height = (int)Math.round(preferredHeight);
            } else {
                y = insets.top;
                height = availHeight;
            }
            child.setBounds(x, y, width, height);
        }
    }

    public static CenterLayout getInstance() {
        return instance;
    }
}

