#!/usr/bin/python3
# SPDX-License-Identifier: GPL-2.0-only
import os
import sysconfig
from os.path import isfile, relpath
from setuptools import setup

if isfile("MANIFEST"):
    os.unlink("MANIFEST")

SCHEME = 'rpm_prefix'
if SCHEME not in sysconfig.get_scheme_names():
    SCHEME = 'posix_prefix'

# Get PYTHONLIB with no prefix so --prefix installs work.
PYTHONLIB = relpath(sysconfig.get_path('platlib', SCHEME), '/usr')

setup(name="tuna",
      version = "0.20",
      description = "Application tuning GUI",
      author = "Arnaldo Carvalho de Melo, John Kacur",
      author_email = "acme@redhat.com, jkacur@redhat.com",
      maintainer = "John Kacur",
      maintainer_email = "jkacur@redhat.com",
      url = "https://www.kernel.org/pub/software/utils/tuna",
      project_urls = {
          "Source": "git.kernel.org/pub/scm/utils/tuna/tuna.git/",
      },
      license = "GPLv2",
      packages = ["tuna", "tuna/gui"],
)
