#pragma clang diagnostic ignored "-Wsign-compare"
#pragma clang diagnostic ignored "-Wshadow"
#pragma clang diagnostic ignored "-Wassign-enum"
#pragma clang diagnostic ignored "-Wcomma"
#pragma clang diagnostic ignored "-Wconversion"
/* entities.c -- recognize HTML ISO entities

  (c) 1998-2008 (W3C) MIT, ERCIM, Keio University
  See tidy.h for the copyright notice.

  Entity handling can be static because there are no config or
  document-specific values.  Lookup table is 100% defined at 
  compile time.

*/

#include <stdio.h>
#include "entities.h"
#include "tidy-int.h"
#include "tmbstr.h"

struct _entity;
typedef struct _entity entity;

struct _entity
{
    ctmbstr name;
    uint    versions;
    uint    code;
};

#ifndef VERS_CHECK
#define VERS_CHECK VERS_HTML5
#endif

/*
** Issue #643 - list increased to
** 2032 known entities.
** Note also stuct /not/ padded to 
** keep source weight down, 79K vs 149K,
** and is strictly alphabetic to optimize 
** the searching.
** All new entities have been given VERS_CHECK
** This should be replaced if versioning can
** successfully be established.
*/

static const entity entities[] =
{
    { "AElig", VERS_ALL, 198 },
    { "AMP", VERS_CHECK, 38 },
    { "Aacute", VERS_ALL, 193 },
    { "Abreve", VERS_CHECK, 258 },
    { "Acirc", VERS_ALL, 194 },
    { "Acy", VERS_CHECK, 1040 },
    { "Afr", VERS_CHECK, 120068 },
    { "Agrave", VERS_ALL, 192 },
    { "Alpha", VERS_FROM40, 913 },
    { "Amacr", VERS_CHECK, 256 },
    { "And", VERS_CHECK, 10835 },
    { "Aogon", VERS_CHECK, 260 },
    { "Aopf", VERS_CHECK, 120120 },
    { "ApplyFunction", VERS_CHECK, 8289 },
    { "Aring", VERS_ALL, 197 },
    { "Ascr", VERS_CHECK, 119964 },
    { "Assign", VERS_CHECK, 8788 },
    { "Atilde", VERS_ALL, 195 },
    { "Auml", VERS_ALL, 196 },
    { "Backslash", VERS_CHECK, 8726 },
    { "Barv", VERS_CHECK, 10983 },
    { "Barwed", VERS_CHECK, 8966 },
    { "Bcy", VERS_CHECK, 1041 },
    { "Because", VERS_CHECK, 8757 },
    { "Bernoullis", VERS_CHECK, 8492 },
    { "Beta", VERS_FROM40, 914 },
    { "Bfr", VERS_CHECK, 120069 },
    { "Bopf", VERS_CHECK, 120121 },
    { "Breve", VERS_CHECK, 728 },
    { "Bscr", VERS_CHECK, 8492 },
    { "Bumpeq", VERS_CHECK, 8782 },
    { "CHcy", VERS_CHECK, 1063 },
    { "COPY", VERS_CHECK, 169 },
    { "Cacute", VERS_CHECK, 262 },
    { "Cap", VERS_CHECK, 8914 },
    { "CapitalDifferentialD", VERS_CHECK, 8517 },
    { "Cayleys", VERS_CHECK, 8493 },
    { "Ccaron", VERS_CHECK, 268 },
    { "Ccedil", VERS_ALL, 199 },
    { "Ccirc", VERS_CHECK, 264 },
    { "Cconint", VERS_CHECK, 8752 },
    { "Cdot", VERS_CHECK, 266 },
    { "Cedilla", VERS_CHECK, 184 },
    { "CenterDot", VERS_CHECK, 183 },
    { "Cfr", VERS_CHECK, 8493 },
    { "Chi", VERS_FROM40, 935 },
    { "CircleDot", VERS_CHECK, 8857 },
    { "CircleMinus", VERS_CHECK, 8854 },
    { "CirclePlus", VERS_CHECK, 8853 },
    { "CircleTimes", VERS_CHECK, 8855 },
    { "ClockwiseContourIntegral", VERS_CHECK, 8754 },
    { "CloseCurlyDoubleQuote", VERS_CHECK, 8221 },
    { "CloseCurlyQuote", VERS_CHECK, 8217 },
    { "Colon", VERS_CHECK, 8759 },
    { "Colone", VERS_CHECK, 10868 },
    { "Congruent", VERS_CHECK, 8801 },
    { "Conint", VERS_CHECK, 8751 },
    { "ContourIntegral", VERS_CHECK, 8750 },
    { "Copf", VERS_CHECK, 8450 },
    { "Coproduct", VERS_CHECK, 8720 },
    { "CounterClockwiseContourIntegral", VERS_CHECK, 8755 },
    { "Cross", VERS_CHECK, 10799 },
    { "Cscr", VERS_CHECK, 119966 },
    { "Cup", VERS_CHECK, 8915 },
    { "CupCap", VERS_CHECK, 8781 },
    { "DD", VERS_CHECK, 8517 },
    { "DDotrahd", VERS_CHECK, 10513 },
    { "DJcy", VERS_CHECK, 1026 },
    { "DScy", VERS_CHECK, 1029 },
    { "DZcy", VERS_CHECK, 1039 },
    { "Dagger", VERS_FROM40, 8225 },
    { "Darr", VERS_CHECK, 8609 },
    { "Dashv", VERS_CHECK, 10980 },
    { "Dcaron", VERS_CHECK, 270 },
    { "Dcy", VERS_CHECK, 1044 },
    { "Del", VERS_CHECK, 8711 },
    { "Delta", VERS_FROM40, 916 },
    { "Dfr", VERS_CHECK, 120071 },
    { "DiacriticalAcute", VERS_CHECK, 180 },
    { "DiacriticalDot", VERS_CHECK, 729 },
    { "DiacriticalDoubleAcute", VERS_CHECK, 733 },
    { "DiacriticalGrave", VERS_CHECK, 96 },
    { "DiacriticalTilde", VERS_CHECK, 732 },
    { "Diamond", VERS_CHECK, 8900 },
    { "DifferentialD", VERS_CHECK, 8518 },
    { "Dopf", VERS_CHECK, 120123 },
    { "Dot", VERS_CHECK, 168 },
    { "DotDot", VERS_CHECK, 8412 },
    { "DotEqual", VERS_CHECK, 8784 },
    { "DoubleContourIntegral", VERS_CHECK, 8751 },
    { "DoubleDot", VERS_CHECK, 168 },
    { "DoubleDownArrow", VERS_CHECK, 8659 },
    { "DoubleLeftArrow", VERS_CHECK, 8656 },
    { "DoubleLeftRightArrow", VERS_CHECK, 8660 },
    { "DoubleLeftTee", VERS_CHECK, 10980 },
    { "DoubleLongLeftArrow", VERS_CHECK, 10232 },
    { "DoubleLongLeftRightArrow", VERS_CHECK, 10234 },
    { "DoubleLongRightArrow", VERS_CHECK, 10233 },
    { "DoubleRightArrow", VERS_CHECK, 8658 },
    { "DoubleRightTee", VERS_CHECK, 8872 },
    { "DoubleUpArrow", VERS_CHECK, 8657 },
    { "DoubleUpDownArrow", VERS_CHECK, 8661 },
    { "DoubleVerticalBar", VERS_CHECK, 8741 },
    { "DownArrow", VERS_CHECK, 8595 },
    { "DownArrowBar", VERS_CHECK, 10515 },
    { "DownArrowUpArrow", VERS_CHECK, 8693 },
    { "DownBreve", VERS_CHECK, 785 },
    { "DownLeftRightVector", VERS_CHECK, 10576 },
    { "DownLeftTeeVector", VERS_CHECK, 10590 },
    { "DownLeftVector", VERS_CHECK, 8637 },
    { "DownLeftVectorBar", VERS_CHECK, 10582 },
    { "DownRightTeeVector", VERS_CHECK, 10591 },
    { "DownRightVector", VERS_CHECK, 8641 },
    { "DownRightVectorBar", VERS_CHECK, 10583 },
    { "DownTee", VERS_CHECK, 8868 },
    { "DownTeeArrow", VERS_CHECK, 8615 },
    { "Downarrow", VERS_CHECK, 8659 },
    { "Dscr", VERS_CHECK, 119967 },
    { "Dstrok", VERS_CHECK, 272 },
    { "ENG", VERS_CHECK, 330 },
    { "ETH", VERS_ALL, 208 },
    { "Eacute", VERS_ALL, 201 },
    { "Ecaron", VERS_CHECK, 282 },
    { "Ecirc", VERS_ALL, 202 },
    { "Ecy", VERS_CHECK, 1069 },
    { "Edot", VERS_CHECK, 278 },
    { "Efr", VERS_CHECK, 120072 },
    { "Egrave", VERS_ALL, 200 },
    { "Element", VERS_CHECK, 8712 },
    { "Emacr", VERS_CHECK, 274 },
    { "EmptySmallSquare", VERS_CHECK, 9723 },
    { "EmptyVerySmallSquare", VERS_CHECK, 9643 },
    { "Eogon", VERS_CHECK, 280 },
    { "Eopf", VERS_CHECK, 120124 },
    { "Epsilon", VERS_FROM40, 917 },
    { "Equal", VERS_CHECK, 10869 },
    { "EqualTilde", VERS_CHECK, 8770 },
    { "Equilibrium", VERS_CHECK, 8652 },
    { "Escr", VERS_CHECK, 8496 },
    { "Esim", VERS_CHECK, 10867 },
    { "Eta", VERS_FROM40, 919 },
    { "Euml", VERS_ALL, 203 },
    { "Exists", VERS_CHECK, 8707 },
    { "ExponentialE", VERS_CHECK, 8519 },
    { "Fcy", VERS_CHECK, 1060 },
    { "Ffr", VERS_CHECK, 120073 },
    { "FilledSmallSquare", VERS_CHECK, 9724 },
    { "FilledVerySmallSquare", VERS_CHECK, 9642 },
    { "Fopf", VERS_CHECK, 120125 },
    { "ForAll", VERS_CHECK, 8704 },
    { "Fouriertrf", VERS_CHECK, 8497 },
    { "Fscr", VERS_CHECK, 8497 },
    { "GJcy", VERS_CHECK, 1027 },
    { "GT", VERS_CHECK, 62 },
    { "Gamma", VERS_FROM40, 915 },
    { "Gammad", VERS_CHECK, 988 },
    { "Gbreve", VERS_CHECK, 286 },
    { "Gcedil", VERS_CHECK, 290 },
    { "Gcirc", VERS_CHECK, 284 },
    { "Gcy", VERS_CHECK, 1043 },
    { "Gdot", VERS_CHECK, 288 },
    { "Gfr", VERS_CHECK, 120074 },
    { "Gg", VERS_CHECK, 8921 },
    { "Gopf", VERS_CHECK, 120126 },
    { "GreaterEqual", VERS_CHECK, 8805 },
    { "GreaterEqualLess", VERS_CHECK, 8923 },
    { "GreaterFullEqual", VERS_CHECK, 8807 },
    { "GreaterGreater", VERS_CHECK, 10914 },
    { "GreaterLess", VERS_CHECK, 8823 },
    { "GreaterSlantEqual", VERS_CHECK, 10878 },
    { "GreaterTilde", VERS_CHECK, 8819 },
    { "Gscr", VERS_CHECK, 119970 },
    { "Gt", VERS_CHECK, 8811 },
    { "HARDcy", VERS_CHECK, 1066 },
    { "Hacek", VERS_CHECK, 711 },
    { "Hat", VERS_CHECK, 94 },
    { "Hcirc", VERS_CHECK, 292 },
    { "Hfr", VERS_CHECK, 8460 },
    { "HilbertSpace", VERS_CHECK, 8459 },
    { "Hopf", VERS_CHECK, 8461 },
    { "HorizontalLine", VERS_CHECK, 9472 },
    { "Hscr", VERS_CHECK, 8459 },
    { "Hstrok", VERS_CHECK, 294 },
    { "HumpDownHump", VERS_CHECK, 8782 },
    { "HumpEqual", VERS_CHECK, 8783 },
    { "IEcy", VERS_CHECK, 1045 },
    { "IJlig", VERS_CHECK, 306 },
    { "IOcy", VERS_CHECK, 1025 },
    { "Iacute", VERS_ALL, 205 },
    { "Icirc", VERS_ALL, 206 },
    { "Icy", VERS_CHECK, 1048 },
    { "Idot", VERS_CHECK, 304 },
    { "Ifr", VERS_CHECK, 8465 },
    { "Igrave", VERS_ALL, 204 },
    { "Im", VERS_CHECK, 8465 },
    { "Imacr", VERS_CHECK, 298 },
    { "ImaginaryI", VERS_CHECK, 8520 },
    { "Implies", VERS_CHECK, 8658 },
    { "Int", VERS_CHECK, 8748 },
    { "Integral", VERS_CHECK, 8747 },
    { "Intersection", VERS_CHECK, 8898 },
    { "InvisibleComma", VERS_CHECK, 8291 },
    { "InvisibleTimes", VERS_CHECK, 8290 },
    { "Iogon", VERS_CHECK, 302 },
    { "Iopf", VERS_CHECK, 120128 },
    { "Iota", VERS_FROM40, 921 },
    { "Iscr", VERS_CHECK, 8464 },
    { "Itilde", VERS_CHECK, 296 },
    { "Iukcy", VERS_CHECK, 1030 },
    { "Iuml", VERS_ALL, 207 },
    { "Jcirc", VERS_CHECK, 308 },
    { "Jcy", VERS_CHECK, 1049 },
    { "Jfr", VERS_CHECK, 120077 },
    { "Jopf", VERS_CHECK, 120129 },
    { "Jscr", VERS_CHECK, 119973 },
    { "Jsercy", VERS_CHECK, 1032 },
    { "Jukcy", VERS_CHECK, 1028 },
    { "KHcy", VERS_CHECK, 1061 },
    { "KJcy", VERS_CHECK, 1036 },
    { "Kappa", VERS_FROM40, 922 },
    { "Kcedil", VERS_CHECK, 310 },
    { "Kcy", VERS_CHECK, 1050 },
    { "Kfr", VERS_CHECK, 120078 },
    { "Kopf", VERS_CHECK, 120130 },
    { "Kscr", VERS_CHECK, 119974 },
    { "LJcy", VERS_CHECK, 1033 },
    { "LT", VERS_CHECK, 60 },
    { "Lacute", VERS_CHECK, 313 },
    { "Lambda", VERS_FROM40, 923 },
    { "Lang", VERS_CHECK, 10218 },
    { "Laplacetrf", VERS_CHECK, 8466 },
    { "Larr", VERS_CHECK, 8606 },
    { "Lcaron", VERS_CHECK, 317 },
    { "Lcedil", VERS_CHECK, 315 },
    { "Lcy", VERS_CHECK, 1051 },
    { "LeftAngleBracket", VERS_CHECK, 10216 },
    { "LeftArrow", VERS_CHECK, 8592 },
    { "LeftArrowBar", VERS_CHECK, 8676 },
    { "LeftArrowRightArrow", VERS_CHECK, 8646 },
    { "LeftCeiling", VERS_CHECK, 8968 },
    { "LeftDoubleBracket", VERS_CHECK, 10214 },
    { "LeftDownTeeVector", VERS_CHECK, 10593 },
    { "LeftDownVector", VERS_CHECK, 8643 },
    { "LeftDownVectorBar", VERS_CHECK, 10585 },
    { "LeftFloor", VERS_CHECK, 8970 },
    { "LeftRightArrow", VERS_CHECK, 8596 },
    { "LeftRightVector", VERS_CHECK, 10574 },
    { "LeftTee", VERS_CHECK, 8867 },
    { "LeftTeeArrow", VERS_CHECK, 8612 },
    { "LeftTeeVector", VERS_CHECK, 10586 },
    { "LeftTriangle", VERS_CHECK, 8882 },
    { "LeftTriangleBar", VERS_CHECK, 10703 },
    { "LeftTriangleEqual", VERS_CHECK, 8884 },
    { "LeftUpDownVector", VERS_CHECK, 10577 },
    { "LeftUpTeeVector", VERS_CHECK, 10592 },
    { "LeftUpVector", VERS_CHECK, 8639 },
    { "LeftUpVectorBar", VERS_CHECK, 10584 },
    { "LeftVector", VERS_CHECK, 8636 },
    { "LeftVectorBar", VERS_CHECK, 10578 },
    { "Leftarrow", VERS_CHECK, 8656 },
    { "Leftrightarrow", VERS_CHECK, 8660 },
    { "LessEqualGreater", VERS_CHECK, 8922 },
    { "LessFullEqual", VERS_CHECK, 8806 },
    { "LessGreater", VERS_CHECK, 8822 },
    { "LessLess", VERS_CHECK, 10913 },
    { "LessSlantEqual", VERS_CHECK, 10877 },
    { "LessTilde", VERS_CHECK, 8818 },
    { "Lfr", VERS_CHECK, 120079 },
    { "Ll", VERS_CHECK, 8920 },
    { "Lleftarrow", VERS_CHECK, 8666 },
    { "Lmidot", VERS_CHECK, 319 },
    { "LongLeftArrow", VERS_CHECK, 10229 },
    { "LongLeftRightArrow", VERS_CHECK, 10231 },
    { "LongRightArrow", VERS_CHECK, 10230 },
    { "Longleftarrow", VERS_CHECK, 10232 },
    { "Longleftrightarrow", VERS_CHECK, 10234 },
    { "Longrightarrow", VERS_CHECK, 10233 },
    { "Lopf", VERS_CHECK, 120131 },
    { "LowerLeftArrow", VERS_CHECK, 8601 },
    { "LowerRightArrow", VERS_CHECK, 8600 },
    { "Lscr", VERS_CHECK, 8466 },
    { "Lsh", VERS_CHECK, 8624 },
    { "Lstrok", VERS_CHECK, 321 },
    { "Lt", VERS_CHECK, 8810 },
    { "Map", VERS_CHECK, 10501 },
    { "Mcy", VERS_CHECK, 1052 },
    { "MediumSpace", VERS_CHECK, 8287 },
    { "Mellintrf", VERS_CHECK, 8499 },
    { "Mfr", VERS_CHECK, 120080 },
    { "MinusPlus", VERS_CHECK, 8723 },
    { "Mopf", VERS_CHECK, 120132 },
    { "Mscr", VERS_CHECK, 8499 },
    { "Mu", VERS_FROM40, 924 },
    { "NJcy", VERS_CHECK, 1034 },
    { "Nacute", VERS_CHECK, 323 },
    { "Ncaron", VERS_CHECK, 327 },
    { "Ncedil", VERS_CHECK, 325 },
    { "Ncy", VERS_CHECK, 1053 },
    { "NegativeMediumSpace", VERS_CHECK, 8203 },
    { "NegativeThickSpace", VERS_CHECK, 8203 },
    { "NegativeThinSpace", VERS_CHECK, 8203 },
    { "NegativeVeryThinSpace", VERS_CHECK, 8203 },
    { "NestedGreaterGreater", VERS_CHECK, 8811 },
    { "NestedLessLess", VERS_CHECK, 8810 },
    { "NewLine", VERS_CHECK, 10 },
    { "Nfr", VERS_CHECK, 120081 },
    { "NoBreak", VERS_CHECK, 8288 },
    { "NonBreakingSpace", VERS_CHECK, 160 },
    { "Nopf", VERS_CHECK, 8469 },
    { "Not", VERS_CHECK, 10988 },
    { "NotCongruent", VERS_CHECK, 8802 },
    { "NotCupCap", VERS_CHECK, 8813 },
    { "NotDoubleVerticalBar", VERS_CHECK, 8742 },
    { "NotElement", VERS_CHECK, 8713 },
    { "NotEqual", VERS_CHECK, 8800 },
    { "NotExists", VERS_CHECK, 8708 },
    { "NotGreater", VERS_CHECK, 8815 },
    { "NotGreaterEqual", VERS_CHECK, 8817 },
    { "NotGreaterLess", VERS_CHECK, 8825 },
    { "NotGreaterTilde", VERS_CHECK, 8821 },
    { "NotLeftTriangle", VERS_CHECK, 8938 },
    { "NotLeftTriangleEqual", VERS_CHECK, 8940 },
    { "NotLess", VERS_CHECK, 8814 },
    { "NotLessEqual", VERS_CHECK, 8816 },
    { "NotLessGreater", VERS_CHECK, 8824 },
    { "NotLessTilde", VERS_CHECK, 8820 },
    { "NotPrecedes", VERS_CHECK, 8832 },
    { "NotPrecedesSlantEqual", VERS_CHECK, 8928 },
    { "NotReverseElement", VERS_CHECK, 8716 },
    { "NotRightTriangle", VERS_CHECK, 8939 },
    { "NotRightTriangleEqual", VERS_CHECK, 8941 },
    { "NotSquareSubsetEqual", VERS_CHECK, 8930 },
    { "NotSquareSupersetEqual", VERS_CHECK, 8931 },
    { "NotSubsetEqual", VERS_CHECK, 8840 },
    { "NotSucceeds", VERS_CHECK, 8833 },
    { "NotSucceedsSlantEqual", VERS_CHECK, 8929 },
    { "NotSupersetEqual", VERS_CHECK, 8841 },
    { "NotTilde", VERS_CHECK, 8769 },
    { "NotTildeEqual", VERS_CHECK, 8772 },
    { "NotTildeFullEqual", VERS_CHECK, 8775 },
    { "NotTildeTilde", VERS_CHECK, 8777 },
    { "NotVerticalBar", VERS_CHECK, 8740 },
    { "Nscr", VERS_CHECK, 119977 },
    { "Ntilde", VERS_ALL, 209 },
    { "Nu", VERS_FROM40, 925 },
    { "OElig", VERS_FROM40, 338 },
    { "Oacute", VERS_ALL, 211 },
    { "Ocirc", VERS_ALL, 212 },
    { "Ocy", VERS_CHECK, 1054 },
    { "Odblac", VERS_CHECK, 336 },
    { "Ofr", VERS_CHECK, 120082 },
    { "Ograve", VERS_ALL, 210 },
    { "Omacr", VERS_CHECK, 332 },
    { "Omega", VERS_FROM40, 937 },
    { "Omicron", VERS_FROM40, 927 },
    { "Oopf", VERS_CHECK, 120134 },
    { "OpenCurlyDoubleQuote", VERS_CHECK, 8220 },
    { "OpenCurlyQuote", VERS_CHECK, 8216 },
    { "Or", VERS_CHECK, 10836 },
    { "Oscr", VERS_CHECK, 119978 },
    { "Oslash", VERS_ALL, 216 },
    { "Otilde", VERS_ALL, 213 },
    { "Otimes", VERS_CHECK, 10807 },
    { "Ouml", VERS_ALL, 214 },
    { "OverBar", VERS_CHECK, 8254 },
    { "OverBrace", VERS_CHECK, 9182 },
    { "OverBracket", VERS_CHECK, 9140 },
    { "OverParenthesis", VERS_CHECK, 9180 },
    { "PartialD", VERS_CHECK, 8706 },
    { "Pcy", VERS_CHECK, 1055 },
    { "Pfr", VERS_CHECK, 120083 },
    { "Phi", VERS_FROM40, 934 },
    { "Pi", VERS_FROM40, 928 },
    { "PlusMinus", VERS_CHECK, 177 },
    { "Poincareplane", VERS_CHECK, 8460 },
    { "Popf", VERS_CHECK, 8473 },
    { "Pr", VERS_CHECK, 10939 },
    { "Precedes", VERS_CHECK, 8826 },
    { "PrecedesEqual", VERS_CHECK, 10927 },
    { "PrecedesSlantEqual", VERS_CHECK, 8828 },
    { "PrecedesTilde", VERS_CHECK, 8830 },
    { "Prime", VERS_FROM40, 8243 },
    { "Product", VERS_CHECK, 8719 },
    { "Proportion", VERS_CHECK, 8759 },
    { "Proportional", VERS_CHECK, 8733 },
    { "Pscr", VERS_CHECK, 119979 },
    { "Psi", VERS_FROM40, 936 },
    { "QUOT", VERS_CHECK, 34 },
    { "Qfr", VERS_CHECK, 120084 },
    { "Qopf", VERS_CHECK, 8474 },
    { "Qscr", VERS_CHECK, 119980 },
    { "RBarr", VERS_CHECK, 10512 },
    { "REG", VERS_CHECK, 174 },
    { "Racute", VERS_CHECK, 340 },
    { "Rang", VERS_CHECK, 10219 },
    { "Rarr", VERS_CHECK, 8608 },
    { "Rarrtl", VERS_CHECK, 10518 },
    { "Rcaron", VERS_CHECK, 344 },
    { "Rcedil", VERS_CHECK, 342 },
    { "Rcy", VERS_CHECK, 1056 },
    { "Re", VERS_CHECK, 8476 },
    { "ReverseElement", VERS_CHECK, 8715 },
    { "ReverseEquilibrium", VERS_CHECK, 8651 },
    { "ReverseUpEquilibrium", VERS_CHECK, 10607 },
    { "Rfr", VERS_CHECK, 8476 },
    { "Rho", VERS_FROM40, 929 },
    { "RightAngleBracket", VERS_CHECK, 10217 },
    { "RightArrow", VERS_CHECK, 8594 },
    { "RightArrowBar", VERS_CHECK, 8677 },
    { "RightArrowLeftArrow", VERS_CHECK, 8644 },
    { "RightCeiling", VERS_CHECK, 8969 },
    { "RightDoubleBracket", VERS_CHECK, 10215 },
    { "RightDownTeeVector", VERS_CHECK, 10589 },
    { "RightDownVector", VERS_CHECK, 8642 },
    { "RightDownVectorBar", VERS_CHECK, 10581 },
    { "RightFloor", VERS_CHECK, 8971 },
    { "RightTee", VERS_CHECK, 8866 },
    { "RightTeeArrow", VERS_CHECK, 8614 },
    { "RightTeeVector", VERS_CHECK, 10587 },
    { "RightTriangle", VERS_CHECK, 8883 },
    { "RightTriangleBar", VERS_CHECK, 10704 },
    { "RightTriangleEqual", VERS_CHECK, 8885 },
    { "RightUpDownVector", VERS_CHECK, 10575 },
    { "RightUpTeeVector", VERS_CHECK, 10588 },
    { "RightUpVector", VERS_CHECK, 8638 },
    { "RightUpVectorBar", VERS_CHECK, 10580 },
    { "RightVector", VERS_CHECK, 8640 },
    { "RightVectorBar", VERS_CHECK, 10579 },
    { "Rightarrow", VERS_CHECK, 8658 },
    { "Ropf", VERS_CHECK, 8477 },
    { "RoundImplies", VERS_CHECK, 10608 },
    { "Rrightarrow", VERS_CHECK, 8667 },
    { "Rscr", VERS_CHECK, 8475 },
    { "Rsh", VERS_CHECK, 8625 },
    { "RuleDelayed", VERS_CHECK, 10740 },
    { "SHCHcy", VERS_CHECK, 1065 },
    { "SHcy", VERS_CHECK, 1064 },
    { "SOFTcy", VERS_CHECK, 1068 },
    { "Sacute", VERS_CHECK, 346 },
    { "Sc", VERS_CHECK, 10940 },
    { "Scaron", VERS_FROM40, 352 },
    { "Scedil", VERS_CHECK, 350 },
    { "Scirc", VERS_CHECK, 348 },
    { "Scy", VERS_CHECK, 1057 },
    { "Sfr", VERS_CHECK, 120086 },
    { "ShortDownArrow", VERS_CHECK, 8595 },
    { "ShortLeftArrow", VERS_CHECK, 8592 },
    { "ShortRightArrow", VERS_CHECK, 8594 },
    { "ShortUpArrow", VERS_CHECK, 8593 },
    { "Sigma", VERS_FROM40, 931 },
    { "SmallCircle", VERS_CHECK, 8728 },
    { "Sopf", VERS_CHECK, 120138 },
    { "Sqrt", VERS_CHECK, 8730 },
    { "Square", VERS_CHECK, 9633 },
    { "SquareIntersection", VERS_CHECK, 8851 },
    { "SquareSubset", VERS_CHECK, 8847 },
    { "SquareSubsetEqual", VERS_CHECK, 8849 },
    { "SquareSuperset", VERS_CHECK, 8848 },
    { "SquareSupersetEqual", VERS_CHECK, 8850 },
    { "SquareUnion", VERS_CHECK, 8852 },
    { "Sscr", VERS_CHECK, 119982 },
    { "Star", VERS_CHECK, 8902 },
    { "Sub", VERS_CHECK, 8912 },
    { "Subset", VERS_CHECK, 8912 },
    { "SubsetEqual", VERS_CHECK, 8838 },
    { "Succeeds", VERS_CHECK, 8827 },
    { "SucceedsEqual", VERS_CHECK, 10928 },
    { "SucceedsSlantEqual", VERS_CHECK, 8829 },
    { "SucceedsTilde", VERS_CHECK, 8831 },
    { "SuchThat", VERS_CHECK, 8715 },
    { "Sum", VERS_CHECK, 8721 },
    { "Sup", VERS_CHECK, 8913 },
    { "Superset", VERS_CHECK, 8835 },
    { "SupersetEqual", VERS_CHECK, 8839 },
    { "Supset", VERS_CHECK, 8913 },
    { "THORN", VERS_ALL, 222 },
    { "TRADE", VERS_CHECK, 8482 },
    { "TSHcy", VERS_CHECK, 1035 },
    { "TScy", VERS_CHECK, 1062 },
    { "Tab", VERS_CHECK, 9 },
    { "Tau", VERS_FROM40, 932 },
    { "Tcaron", VERS_CHECK, 356 },
    { "Tcedil", VERS_CHECK, 354 },
    { "Tcy", VERS_CHECK, 1058 },
    { "Tfr", VERS_CHECK, 120087 },
    { "Therefore", VERS_CHECK, 8756 },
    { "Theta", VERS_FROM40, 920 },
    { "ThinSpace", VERS_CHECK, 8201 },
    { "Tilde", VERS_CHECK, 8764 },
    { "TildeEqual", VERS_CHECK, 8771 },
    { "TildeFullEqual", VERS_CHECK, 8773 },
    { "TildeTilde", VERS_CHECK, 8776 },
    { "Topf", VERS_CHECK, 120139 },
    { "TripleDot", VERS_CHECK, 8411 },
    { "Tscr", VERS_CHECK, 119983 },
    { "Tstrok", VERS_CHECK, 358 },
    { "Uacute", VERS_ALL, 218 },
    { "Uarr", VERS_CHECK, 8607 },
    { "Uarrocir", VERS_CHECK, 10569 },
    { "Ubrcy", VERS_CHECK, 1038 },
    { "Ubreve", VERS_CHECK, 364 },
    { "Ucirc", VERS_ALL, 219 },
    { "Ucy", VERS_CHECK, 1059 },
    { "Udblac", VERS_CHECK, 368 },
    { "Ufr", VERS_CHECK, 120088 },
    { "Ugrave", VERS_ALL, 217 },
    { "Umacr", VERS_CHECK, 362 },
    { "UnderBar", VERS_CHECK, 95 },
    { "UnderBrace", VERS_CHECK, 9183 },
    { "UnderBracket", VERS_CHECK, 9141 },
    { "UnderParenthesis", VERS_CHECK, 9181 },
    { "Union", VERS_CHECK, 8899 },
    { "UnionPlus", VERS_CHECK, 8846 },
    { "Uogon", VERS_CHECK, 370 },
    { "Uopf", VERS_CHECK, 120140 },
    { "UpArrow", VERS_CHECK, 8593 },
    { "UpArrowBar", VERS_CHECK, 10514 },
    { "UpArrowDownArrow", VERS_CHECK, 8645 },
    { "UpDownArrow", VERS_CHECK, 8597 },
    { "UpEquilibrium", VERS_CHECK, 10606 },
    { "UpTee", VERS_CHECK, 8869 },
    { "UpTeeArrow", VERS_CHECK, 8613 },
    { "Uparrow", VERS_CHECK, 8657 },
    { "Updownarrow", VERS_CHECK, 8661 },
    { "UpperLeftArrow", VERS_CHECK, 8598 },
    { "UpperRightArrow", VERS_CHECK, 8599 },
    { "Upsi", VERS_CHECK, 978 },
    { "Upsilon", VERS_FROM40, 933 },
    { "Uring", VERS_CHECK, 366 },
    { "Uscr", VERS_CHECK, 119984 },
    { "Utilde", VERS_CHECK, 360 },
    { "Uuml", VERS_ALL, 220 },
    { "VDash", VERS_CHECK, 8875 },
    { "Vbar", VERS_CHECK, 10987 },
    { "Vcy", VERS_CHECK, 1042 },
    { "Vdash", VERS_CHECK, 8873 },
    { "Vdashl", VERS_CHECK, 10982 },
    { "Vee", VERS_CHECK, 8897 },
    { "Verbar", VERS_CHECK, 8214 },
    { "Vert", VERS_CHECK, 8214 },
    { "VerticalBar", VERS_CHECK, 8739 },
    { "VerticalLine", VERS_CHECK, 124 },
    { "VerticalSeparator", VERS_CHECK, 10072 },
    { "VerticalTilde", VERS_CHECK, 8768 },
    { "VeryThinSpace", VERS_CHECK, 8202 },
    { "Vfr", VERS_CHECK, 120089 },
    { "Vopf", VERS_CHECK, 120141 },
    { "Vscr", VERS_CHECK, 119985 },
    { "Vvdash", VERS_CHECK, 8874 },
    { "Wcirc", VERS_CHECK, 372 },
    { "Wedge", VERS_CHECK, 8896 },
    { "Wfr", VERS_CHECK, 120090 },
    { "Wopf", VERS_CHECK, 120142 },
    { "Wscr", VERS_CHECK, 119986 },
    { "Xfr", VERS_CHECK, 120091 },
    { "Xi", VERS_FROM40, 926 },
    { "Xopf", VERS_CHECK, 120143 },
    { "Xscr", VERS_CHECK, 119987 },
    { "YAcy", VERS_CHECK, 1071 },
    { "YIcy", VERS_CHECK, 1031 },
    { "YUcy", VERS_CHECK, 1070 },
    { "Yacute", VERS_ALL, 221 },
    { "Ycirc", VERS_CHECK, 374 },
    { "Ycy", VERS_CHECK, 1067 },
    { "Yfr", VERS_CHECK, 120092 },
    { "Yopf", VERS_CHECK, 120144 },
    { "Yscr", VERS_CHECK, 119988 },
    { "Yuml", VERS_FROM40, 376 },
    { "ZHcy", VERS_CHECK, 1046 },
    { "Zacute", VERS_CHECK, 377 },
    { "Zcaron", VERS_CHECK, 381 },
    { "Zcy", VERS_CHECK, 1047 },
    { "Zdot", VERS_CHECK, 379 },
    { "ZeroWidthSpace", VERS_CHECK, 8203 },
    { "Zeta", VERS_FROM40, 918 },
    { "Zfr", VERS_CHECK, 8488 },
    { "Zopf", VERS_CHECK, 8484 },
    { "Zscr", VERS_CHECK, 119989 },
    { "aacute", VERS_ALL, 225 },
    { "abreve", VERS_CHECK, 259 },
    { "ac", VERS_CHECK, 8766 },
    { "acd", VERS_CHECK, 8767 },
    { "acirc", VERS_ALL, 226 },
    { "acute", VERS_ALL, 180 },
    { "acy", VERS_CHECK, 1072 },
    { "aelig", VERS_ALL, 230 },
    { "af", VERS_CHECK, 8289 },
    { "afr", VERS_CHECK, 120094 },
    { "agrave", VERS_ALL, 224 },
    { "alefsym", VERS_FROM40, 8501 },
    { "aleph", VERS_CHECK, 8501 },
    { "alpha", VERS_FROM40, 945 },
    { "amacr", VERS_CHECK, 257 },
    { "amalg", VERS_CHECK, 10815 },
    { "amp", VERS_ALL | VERS_XML, 38 },
    { "and", VERS_FROM40, 8743 },
    { "andand", VERS_CHECK, 10837 },
    { "andd", VERS_CHECK, 10844 },
    { "andslope", VERS_CHECK, 10840 },
    { "andv", VERS_CHECK, 10842 },
    { "ang", VERS_FROM40, 8736 },
    { "ange", VERS_CHECK, 10660 },
    { "angle", VERS_CHECK, 8736 },
    { "angmsd", VERS_CHECK, 8737 },
    { "angmsdaa", VERS_CHECK, 10664 },
    { "angmsdab", VERS_CHECK, 10665 },
    { "angmsdac", VERS_CHECK, 10666 },
    { "angmsdad", VERS_CHECK, 10667 },
    { "angmsdae", VERS_CHECK, 10668 },
    { "angmsdaf", VERS_CHECK, 10669 },
    { "angmsdag", VERS_CHECK, 10670 },
    { "angmsdah", VERS_CHECK, 10671 },
    { "angrt", VERS_CHECK, 8735 },
    { "angrtvb", VERS_CHECK, 8894 },
    { "angrtvbd", VERS_CHECK, 10653 },
    { "angsph", VERS_CHECK, 8738 },
    { "angst", VERS_CHECK, 197 },
    { "angzarr", VERS_CHECK, 9084 },
    { "aogon", VERS_CHECK, 261 },
    { "aopf", VERS_CHECK, 120146 },
    { "ap", VERS_CHECK, 8776 },
    { "apE", VERS_CHECK, 10864 },
    { "apacir", VERS_CHECK, 10863 },
    { "ape", VERS_CHECK, 8778 },
    { "apid", VERS_CHECK, 8779 },
    { "apos", VERS_FROM40 | VERS_XML, 39 },
    { "approx", VERS_CHECK, 8776 },
    { "approxeq", VERS_CHECK, 8778 },
    { "aring", VERS_ALL, 229 },
    { "ascr", VERS_CHECK, 119990 },
    { "ast", VERS_CHECK, 42 },
    { "asymp", VERS_FROM40, 8776 },
    { "asympeq", VERS_CHECK, 8781 },
    { "atilde", VERS_ALL, 227 },
    { "auml", VERS_ALL, 228 },
    { "awconint", VERS_CHECK, 8755 },
    { "awint", VERS_CHECK, 10769 },
    { "bNot", VERS_CHECK, 10989 },
    { "backcong", VERS_CHECK, 8780 },
    { "backepsilon", VERS_CHECK, 1014 },
    { "backprime", VERS_CHECK, 8245 },
    { "backsim", VERS_CHECK, 8765 },
    { "backsimeq", VERS_CHECK, 8909 },
    { "barvee", VERS_CHECK, 8893 },
    { "barwed", VERS_CHECK, 8965 },
    { "barwedge", VERS_CHECK, 8965 },
    { "bbrk", VERS_CHECK, 9141 },
    { "bbrktbrk", VERS_CHECK, 9142 },
    { "bcong", VERS_CHECK, 8780 },
    { "bcy", VERS_CHECK, 1073 },
    { "bdquo", VERS_FROM40, 8222 },
    { "becaus", VERS_CHECK, 8757 },
    { "because", VERS_CHECK, 8757 },
    { "bemptyv", VERS_CHECK, 10672 },
    { "bepsi", VERS_CHECK, 1014 },
    { "bernou", VERS_CHECK, 8492 },
    { "beta", VERS_FROM40, 946 },
    { "beth", VERS_CHECK, 8502 },
    { "between", VERS_CHECK, 8812 },
    { "bfr", VERS_CHECK, 120095 },
    { "bigcap", VERS_CHECK, 8898 },
    { "bigcirc", VERS_CHECK, 9711 },
    { "bigcup", VERS_CHECK, 8899 },
    { "bigodot", VERS_CHECK, 10752 },
    { "bigoplus", VERS_CHECK, 10753 },
    { "bigotimes", VERS_CHECK, 10754 },
    { "bigsqcup", VERS_CHECK, 10758 },
    { "bigstar", VERS_CHECK, 9733 },
    { "bigtriangledown", VERS_CHECK, 9661 },
    { "bigtriangleup", VERS_CHECK, 9651 },
    { "biguplus", VERS_CHECK, 10756 },
    { "bigvee", VERS_CHECK, 8897 },
    { "bigwedge", VERS_CHECK, 8896 },
    { "bkarow", VERS_CHECK, 10509 },
    { "blacklozenge", VERS_CHECK, 10731 },
    { "blacksquare", VERS_CHECK, 9642 },
    { "blacktriangle", VERS_CHECK, 9652 },
    { "blacktriangledown", VERS_CHECK, 9662 },
    { "blacktriangleleft", VERS_CHECK, 9666 },
    { "blacktriangleright", VERS_CHECK, 9656 },
    { "blank", VERS_CHECK, 9251 },
    { "blk12", VERS_CHECK, 9618 },
    { "blk14", VERS_CHECK, 9617 },
    { "blk34", VERS_CHECK, 9619 },
    { "block", VERS_CHECK, 9608 },
    { "bnot", VERS_CHECK, 8976 },
    { "bopf", VERS_CHECK, 120147 },
    { "bot", VERS_CHECK, 8869 },
    { "bottom", VERS_CHECK, 8869 },
    { "bowtie", VERS_CHECK, 8904 },
    { "boxDL", VERS_CHECK, 9559 },
    { "boxDR", VERS_CHECK, 9556 },
    { "boxDl", VERS_CHECK, 9558 },
    { "boxDr", VERS_CHECK, 9555 },
    { "boxH", VERS_CHECK, 9552 },
    { "boxHD", VERS_CHECK, 9574 },
    { "boxHU", VERS_CHECK, 9577 },
    { "boxHd", VERS_CHECK, 9572 },
    { "boxHu", VERS_CHECK, 9575 },
    { "boxUL", VERS_CHECK, 9565 },
    { "boxUR", VERS_CHECK, 9562 },
    { "boxUl", VERS_CHECK, 9564 },
    { "boxUr", VERS_CHECK, 9561 },
    { "boxV", VERS_CHECK, 9553 },
    { "boxVH", VERS_CHECK, 9580 },
    { "boxVL", VERS_CHECK, 9571 },
    { "boxVR", VERS_CHECK, 9568 },
    { "boxVh", VERS_CHECK, 9579 },
    { "boxVl", VERS_CHECK, 9570 },
    { "boxVr", VERS_CHECK, 9567 },
    { "boxbox", VERS_CHECK, 10697 },
    { "boxdL", VERS_CHECK, 9557 },
    { "boxdR", VERS_CHECK, 9554 },
    { "boxdl", VERS_CHECK, 9488 },
    { "boxdr", VERS_CHECK, 9484 },
    { "boxh", VERS_CHECK, 9472 },
    { "boxhD", VERS_CHECK, 9573 },
    { "boxhU", VERS_CHECK, 9576 },
    { "boxhd", VERS_CHECK, 9516 },
    { "boxhu", VERS_CHECK, 9524 },
    { "boxminus", VERS_CHECK, 8863 },
    { "boxplus", VERS_CHECK, 8862 },
    { "boxtimes", VERS_CHECK, 8864 },
    { "boxuL", VERS_CHECK, 9563 },
    { "boxuR", VERS_CHECK, 9560 },
    { "boxul", VERS_CHECK, 9496 },
    { "boxur", VERS_CHECK, 9492 },
    { "boxv", VERS_CHECK, 9474 },
    { "boxvH", VERS_CHECK, 9578 },
    { "boxvL", VERS_CHECK, 9569 },
    { "boxvR", VERS_CHECK, 9566 },
    { "boxvh", VERS_CHECK, 9532 },
    { "boxvl", VERS_CHECK, 9508 },
    { "boxvr", VERS_CHECK, 9500 },
    { "bprime", VERS_CHECK, 8245 },
    { "breve", VERS_CHECK, 728 },
    { "brvbar", VERS_ALL, 166 },
    { "bscr", VERS_CHECK, 119991 },
    { "bsemi", VERS_CHECK, 8271 },
    { "bsim", VERS_CHECK, 8765 },
    { "bsime", VERS_CHECK, 8909 },
    { "bsol", VERS_CHECK, 92 },
    { "bsolb", VERS_CHECK, 10693 },
    { "bsolhsub", VERS_CHECK, 10184 },
    { "bull", VERS_FROM40, 8226 },
    { "bullet", VERS_CHECK, 8226 },
    { "bump", VERS_CHECK, 8782 },
    { "bumpE", VERS_CHECK, 10926 },
    { "bumpe", VERS_CHECK, 8783 },
    { "bumpeq", VERS_CHECK, 8783 },
    { "cacute", VERS_CHECK, 263 },
    { "cap", VERS_FROM40, 8745 },
    { "capand", VERS_CHECK, 10820 },
    { "capbrcup", VERS_CHECK, 10825 },
    { "capcap", VERS_CHECK, 10827 },
    { "capcup", VERS_CHECK, 10823 },
    { "capdot", VERS_CHECK, 10816 },
    { "caret", VERS_CHECK, 8257 },
    { "caron", VERS_CHECK, 711 },
    { "ccaps", VERS_CHECK, 10829 },
    { "ccaron", VERS_CHECK, 269 },
    { "ccedil", VERS_ALL, 231 },
    { "ccirc", VERS_CHECK, 265 },
    { "ccups", VERS_CHECK, 10828 },
    { "ccupssm", VERS_CHECK, 10832 },
    { "cdot", VERS_CHECK, 267 },
    { "cedil", VERS_ALL, 184 },
    { "cemptyv", VERS_CHECK, 10674 },
    { "cent", VERS_ALL, 162 },
    { "centerdot", VERS_CHECK, 183 },
    { "cfr", VERS_CHECK, 120096 },
    { "chcy", VERS_CHECK, 1095 },
    { "check", VERS_CHECK, 10003 },
    { "checkmark", VERS_CHECK, 10003 },
    { "chi", VERS_FROM40, 967 },
    { "cir", VERS_CHECK, 9675 },
    { "cirE", VERS_CHECK, 10691 },
    { "circ", VERS_FROM40, 710 },
    { "circeq", VERS_CHECK, 8791 },
    { "circlearrowleft", VERS_CHECK, 8634 },
    { "circlearrowright", VERS_CHECK, 8635 },
    { "circledR", VERS_CHECK, 174 },
    { "circledS", VERS_CHECK, 9416 },
    { "circledast", VERS_CHECK, 8859 },
    { "circledcirc", VERS_CHECK, 8858 },
    { "circleddash", VERS_CHECK, 8861 },
    { "cire", VERS_CHECK, 8791 },
    { "cirfnint", VERS_CHECK, 10768 },
    { "cirmid", VERS_CHECK, 10991 },
    { "cirscir", VERS_CHECK, 10690 },
    { "clubs", VERS_FROM40, 9827 },
    { "clubsuit", VERS_CHECK, 9827 },
    { "colon", VERS_CHECK, 58 },
    { "colone", VERS_CHECK, 8788 },
    { "coloneq", VERS_CHECK, 8788 },
    { "comma", VERS_CHECK, 44 },
    { "commat", VERS_CHECK, 64 },
    { "comp", VERS_CHECK, 8705 },
    { "compfn", VERS_CHECK, 8728 },
    { "complement", VERS_CHECK, 8705 },
    { "complexes", VERS_CHECK, 8450 },
    { "cong", VERS_FROM40, 8773 },
    { "congdot", VERS_CHECK, 10861 },
    { "conint", VERS_CHECK, 8750 },
    { "copf", VERS_CHECK, 120148 },
    { "coprod", VERS_CHECK, 8720 },
    { "copy", VERS_ALL, 169 },
    { "copysr", VERS_CHECK, 8471 },
    { "crarr", VERS_FROM40, 8629 },
    { "cross", VERS_CHECK, 10007 },
    { "cscr", VERS_CHECK, 119992 },
    { "csub", VERS_CHECK, 10959 },
    { "csube", VERS_CHECK, 10961 },
    { "csup", VERS_CHECK, 10960 },
    { "csupe", VERS_CHECK, 10962 },
    { "ctdot", VERS_CHECK, 8943 },
    { "cudarrl", VERS_CHECK, 10552 },
    { "cudarrr", VERS_CHECK, 10549 },
    { "cuepr", VERS_CHECK, 8926 },
    { "cuesc", VERS_CHECK, 8927 },
    { "cularr", VERS_CHECK, 8630 },
    { "cularrp", VERS_CHECK, 10557 },
    { "cup", VERS_FROM40, 8746 },
    { "cupbrcap", VERS_CHECK, 10824 },
    { "cupcap", VERS_CHECK, 10822 },
    { "cupcup", VERS_CHECK, 10826 },
    { "cupdot", VERS_CHECK, 8845 },
    { "cupor", VERS_CHECK, 10821 },
    { "curarr", VERS_CHECK, 8631 },
    { "curarrm", VERS_CHECK, 10556 },
    { "curlyeqprec", VERS_CHECK, 8926 },
    { "curlyeqsucc", VERS_CHECK, 8927 },
    { "curlyvee", VERS_CHECK, 8910 },
    { "curlywedge", VERS_CHECK, 8911 },
    { "curren", VERS_ALL, 164 },
    { "curvearrowleft", VERS_CHECK, 8630 },
    { "curvearrowright", VERS_CHECK, 8631 },
    { "cuvee", VERS_CHECK, 8910 },
    { "cuwed", VERS_CHECK, 8911 },
    { "cwconint", VERS_CHECK, 8754 },
    { "cwint", VERS_CHECK, 8753 },
    { "cylcty", VERS_CHECK, 9005 },
    { "dArr", VERS_FROM40, 8659 },
    { "dHar", VERS_CHECK, 10597 },
    { "dagger", VERS_FROM40, 8224 },
    { "daleth", VERS_CHECK, 8504 },
    { "darr", VERS_FROM40, 8595 },
    { "dash", VERS_CHECK, 8208 },
    { "dashv", VERS_CHECK, 8867 },
    { "dbkarow", VERS_CHECK, 10511 },
    { "dblac", VERS_CHECK, 733 },
    { "dcaron", VERS_CHECK, 271 },
    { "dcy", VERS_CHECK, 1076 },
    { "dd", VERS_CHECK, 8518 },
    { "ddagger", VERS_CHECK, 8225 },
    { "ddarr", VERS_CHECK, 8650 },
    { "ddotseq", VERS_CHECK, 10871 },
    { "deg", VERS_ALL, 176 },
    { "delta", VERS_FROM40, 948 },
    { "demptyv", VERS_CHECK, 10673 },
    { "dfisht", VERS_CHECK, 10623 },
    { "dfr", VERS_CHECK, 120097 },
    { "dharl", VERS_CHECK, 8643 },
    { "dharr", VERS_CHECK, 8642 },
    { "diam", VERS_CHECK, 8900 },
    { "diamond", VERS_CHECK, 8900 },
    { "diamondsuit", VERS_CHECK, 9830 },
    { "diams", VERS_FROM40, 9830 },
    { "die", VERS_CHECK, 168 },
    { "digamma", VERS_CHECK, 989 },
    { "disin", VERS_CHECK, 8946 },
    { "div", VERS_CHECK, 247 },
    { "divide", VERS_ALL, 247 },
    { "divideontimes", VERS_CHECK, 8903 },
    { "divonx", VERS_CHECK, 8903 },
    { "djcy", VERS_CHECK, 1106 },
    { "dlcorn", VERS_CHECK, 8990 },
    { "dlcrop", VERS_CHECK, 8973 },
    { "dollar", VERS_CHECK, 36 },
    { "dopf", VERS_CHECK, 120149 },
    { "dot", VERS_CHECK, 729 },
    { "doteq", VERS_CHECK, 8784 },
    { "doteqdot", VERS_CHECK, 8785 },
    { "dotminus", VERS_CHECK, 8760 },
    { "dotplus", VERS_CHECK, 8724 },
    { "dotsquare", VERS_CHECK, 8865 },
    { "doublebarwedge", VERS_CHECK, 8966 },
    { "downarrow", VERS_CHECK, 8595 },
    { "downdownarrows", VERS_CHECK, 8650 },
    { "downharpoonleft", VERS_CHECK, 8643 },
    { "downharpoonright", VERS_CHECK, 8642 },
    { "drbkarow", VERS_CHECK, 10512 },
    { "drcorn", VERS_CHECK, 8991 },
    { "drcrop", VERS_CHECK, 8972 },
    { "dscr", VERS_CHECK, 119993 },
    { "dscy", VERS_CHECK, 1109 },
    { "dsol", VERS_CHECK, 10742 },
    { "dstrok", VERS_CHECK, 273 },
    { "dtdot", VERS_CHECK, 8945 },
    { "dtri", VERS_CHECK, 9663 },
    { "dtrif", VERS_CHECK, 9662 },
    { "duarr", VERS_CHECK, 8693 },
    { "duhar", VERS_CHECK, 10607 },
    { "dwangle", VERS_CHECK, 10662 },
    { "dzcy", VERS_CHECK, 1119 },
    { "dzigrarr", VERS_CHECK, 10239 },
    { "eDDot", VERS_CHECK, 10871 },
    { "eDot", VERS_CHECK, 8785 },
    { "eacute", VERS_ALL, 233 },
    { "easter", VERS_CHECK, 10862 },
    { "ecaron", VERS_CHECK, 283 },
    { "ecir", VERS_CHECK, 8790 },
    { "ecirc", VERS_ALL, 234 },
    { "ecolon", VERS_CHECK, 8789 },
    { "ecy", VERS_CHECK, 1101 },
    { "edot", VERS_CHECK, 279 },
    { "ee", VERS_CHECK, 8519 },
    { "efDot", VERS_CHECK, 8786 },
    { "efr", VERS_CHECK, 120098 },
    { "eg", VERS_CHECK, 10906 },
    { "egrave", VERS_ALL, 232 },
    { "egs", VERS_CHECK, 10902 },
    { "egsdot", VERS_CHECK, 10904 },
    { "el", VERS_CHECK, 10905 },
    { "elinters", VERS_CHECK, 9191 },
    { "ell", VERS_CHECK, 8467 },
    { "els", VERS_CHECK, 10901 },
    { "elsdot", VERS_CHECK, 10903 },
    { "emacr", VERS_CHECK, 275 },
    { "empty", VERS_FROM40, 8709 },
    { "emptyset", VERS_CHECK, 8709 },
    { "emptyv", VERS_CHECK, 8709 },
    { "emsp", VERS_FROM40, 8195 },
    { "emsp13", VERS_CHECK, 8196 },
    { "emsp14", VERS_CHECK, 8197 },
    { "eng", VERS_CHECK, 331 },
    { "ensp", VERS_FROM40, 8194 },
    { "eogon", VERS_CHECK, 281 },
    { "eopf", VERS_CHECK, 120150 },
    { "epar", VERS_CHECK, 8917 },
    { "eparsl", VERS_CHECK, 10723 },
    { "eplus", VERS_CHECK, 10865 },
    { "epsi", VERS_CHECK, 949 },
    { "epsilon", VERS_FROM40, 949 },
    { "epsiv", VERS_CHECK, 1013 },
    { "eqcirc", VERS_CHECK, 8790 },
    { "eqcolon", VERS_CHECK, 8789 },
    { "eqsim", VERS_CHECK, 8770 },
    { "eqslantgtr", VERS_CHECK, 10902 },
    { "eqslantless", VERS_CHECK, 10901 },
    { "equals", VERS_CHECK, 61 },
    { "equest", VERS_CHECK, 8799 },
    { "equiv", VERS_FROM40, 8801 },
    { "equivDD", VERS_CHECK, 10872 },
    { "eqvparsl", VERS_CHECK, 10725 },
    { "erDot", VERS_CHECK, 8787 },
    { "erarr", VERS_CHECK, 10609 },
    { "escr", VERS_CHECK, 8495 },
    { "esdot", VERS_CHECK, 8784 },
    { "esim", VERS_CHECK, 8770 },
    { "eta", VERS_FROM40, 951 },
    { "eth", VERS_ALL, 240 },
    { "euml", VERS_ALL, 235 },
    { "euro", VERS_FROM40, 8364 },
    { "excl", VERS_CHECK, 33 },
    { "exist", VERS_FROM40, 8707 },
    { "expectation", VERS_CHECK, 8496 },
    { "exponentiale", VERS_CHECK, 8519 },
    { "fallingdotseq", VERS_CHECK, 8786 },
    { "fcy", VERS_CHECK, 1092 },
    { "female", VERS_CHECK, 9792 },
    { "ffilig", VERS_CHECK, 64259 },
    { "fflig", VERS_CHECK, 64256 },
    { "ffllig", VERS_CHECK, 64260 },
    { "ffr", VERS_CHECK, 120099 },
    { "filig", VERS_CHECK, 64257 },
    { "flat", VERS_CHECK, 9837 },
    { "fllig", VERS_CHECK, 64258 },
    { "fltns", VERS_CHECK, 9649 },
    { "fnof", VERS_FROM40, 402 },
    { "fopf", VERS_CHECK, 120151 },
    { "forall", VERS_FROM40, 8704 },
    { "fork", VERS_CHECK, 8916 },
    { "forkv", VERS_CHECK, 10969 },
    { "fpartint", VERS_CHECK, 10765 },
    { "frac12", VERS_ALL, 189 },
    { "frac13", VERS_CHECK, 8531 },
    { "frac14", VERS_ALL, 188 },
    { "frac15", VERS_CHECK, 8533 },
    { "frac16", VERS_CHECK, 8537 },
    { "frac18", VERS_CHECK, 8539 },
    { "frac23", VERS_CHECK, 8532 },
    { "frac25", VERS_CHECK, 8534 },
    { "frac34", VERS_ALL, 190 },
    { "frac35", VERS_CHECK, 8535 },
    { "frac38", VERS_CHECK, 8540 },
    { "frac45", VERS_CHECK, 8536 },
    { "frac56", VERS_CHECK, 8538 },
    { "frac58", VERS_CHECK, 8541 },
    { "frac78", VERS_CHECK, 8542 },
    { "frasl", VERS_FROM40, 8260 },
    { "frown", VERS_CHECK, 8994 },
    { "fscr", VERS_CHECK, 119995 },
    { "gE", VERS_CHECK, 8807 },
    { "gEl", VERS_CHECK, 10892 },
    { "gacute", VERS_CHECK, 501 },
    { "gamma", VERS_FROM40, 947 },
    { "gammad", VERS_CHECK, 989 },
    { "gap", VERS_CHECK, 10886 },
    { "gbreve", VERS_CHECK, 287 },
    { "gcirc", VERS_CHECK, 285 },
    { "gcy", VERS_CHECK, 1075 },
    { "gdot", VERS_CHECK, 289 },
    { "ge", VERS_FROM40, 8805 },
    { "gel", VERS_CHECK, 8923 },
    { "geq", VERS_CHECK, 8805 },
    { "geqq", VERS_CHECK, 8807 },
    { "geqslant", VERS_CHECK, 10878 },
    { "ges", VERS_CHECK, 10878 },
    { "gescc", VERS_CHECK, 10921 },
    { "gesdot", VERS_CHECK, 10880 },
    { "gesdoto", VERS_CHECK, 10882 },
    { "gesdotol", VERS_CHECK, 10884 },
    { "gesles", VERS_CHECK, 10900 },
    { "gfr", VERS_CHECK, 120100 },
    { "gg", VERS_CHECK, 8811 },
    { "ggg", VERS_CHECK, 8921 },
    { "gimel", VERS_CHECK, 8503 },
    { "gjcy", VERS_CHECK, 1107 },
    { "gl", VERS_CHECK, 8823 },
    { "glE", VERS_CHECK, 10898 },
    { "gla", VERS_CHECK, 10917 },
    { "glj", VERS_CHECK, 10916 },
    { "gnE", VERS_CHECK, 8809 },
    { "gnap", VERS_CHECK, 10890 },
    { "gnapprox", VERS_CHECK, 10890 },
    { "gne", VERS_CHECK, 10888 },
    { "gneq", VERS_CHECK, 10888 },
    { "gneqq", VERS_CHECK, 8809 },
    { "gnsim", VERS_CHECK, 8935 },
    { "gopf", VERS_CHECK, 120152 },
    { "grave", VERS_CHECK, 96 },
    { "gscr", VERS_CHECK, 8458 },
    { "gsim", VERS_CHECK, 8819 },
    { "gsime", VERS_CHECK, 10894 },
    { "gsiml", VERS_CHECK, 10896 },
    { "gt", VERS_ALL | VERS_XML, 62 },
    { "gtcc", VERS_CHECK, 10919 },
    { "gtcir", VERS_CHECK, 10874 },
    { "gtdot", VERS_CHECK, 8919 },
    { "gtlPar", VERS_CHECK, 10645 },
    { "gtquest", VERS_CHECK, 10876 },
    { "gtrapprox", VERS_CHECK, 10886 },
    { "gtrarr", VERS_CHECK, 10616 },
    { "gtrdot", VERS_CHECK, 8919 },
    { "gtreqless", VERS_CHECK, 8923 },
    { "gtreqqless", VERS_CHECK, 10892 },
    { "gtrless", VERS_CHECK, 8823 },
    { "gtrsim", VERS_CHECK, 8819 },
    { "hArr", VERS_FROM40, 8660 },
    { "hairsp", VERS_CHECK, 8202 },
    { "half", VERS_CHECK, 189 },
    { "hamilt", VERS_CHECK, 8459 },
    { "hardcy", VERS_CHECK, 1098 },
    { "harr", VERS_FROM40, 8596 },
    { "harrcir", VERS_CHECK, 10568 },
    { "harrw", VERS_CHECK, 8621 },
    { "hbar", VERS_CHECK, 8463 },
    { "hcirc", VERS_CHECK, 293 },
    { "hearts", VERS_FROM40, 9829 },
    { "heartsuit", VERS_CHECK, 9829 },
    { "hellip", VERS_FROM40, 8230 },
    { "hercon", VERS_CHECK, 8889 },
    { "hfr", VERS_CHECK, 120101 },
    { "hksearow", VERS_CHECK, 10533 },
    { "hkswarow", VERS_CHECK, 10534 },
    { "hoarr", VERS_CHECK, 8703 },
    { "homtht", VERS_CHECK, 8763 },
    { "hookleftarrow", VERS_CHECK, 8617 },
    { "hookrightarrow", VERS_CHECK, 8618 },
    { "hopf", VERS_CHECK, 120153 },
    { "horbar", VERS_CHECK, 8213 },
    { "hscr", VERS_CHECK, 119997 },
    { "hslash", VERS_CHECK, 8463 },
    { "hstrok", VERS_CHECK, 295 },
    { "hybull", VERS_CHECK, 8259 },
    { "hyphen", VERS_CHECK, 8208 },
    { "iacute", VERS_ALL, 237 },
    { "ic", VERS_CHECK, 8291 },
    { "icirc", VERS_ALL, 238 },
    { "icy", VERS_CHECK, 1080 },
    { "iecy", VERS_CHECK, 1077 },
    { "iexcl", VERS_ALL, 161 },
    { "iff", VERS_CHECK, 8660 },
    { "ifr", VERS_CHECK, 120102 },
    { "igrave", VERS_ALL, 236 },
    { "ii", VERS_CHECK, 8520 },
    { "iiiint", VERS_CHECK, 10764 },
    { "iiint", VERS_CHECK, 8749 },
    { "iinfin", VERS_CHECK, 10716 },
    { "iiota", VERS_CHECK, 8489 },
    { "ijlig", VERS_CHECK, 307 },
    { "imacr", VERS_CHECK, 299 },
    { "image", VERS_FROM40, 8465 },
    { "imagline", VERS_CHECK, 8464 },
    { "imagpart", VERS_CHECK, 8465 },
    { "imath", VERS_CHECK, 305 },
    { "imof", VERS_CHECK, 8887 },
    { "imped", VERS_CHECK, 437 },
    { "in", VERS_CHECK, 8712 },
    { "incare", VERS_CHECK, 8453 },
    { "infin", VERS_FROM40, 8734 },
    { "infintie", VERS_CHECK, 10717 },
    { "inodot", VERS_CHECK, 305 },
    { "int", VERS_FROM40, 8747 },
    { "intcal", VERS_CHECK, 8890 },
    { "integers", VERS_CHECK, 8484 },
    { "intercal", VERS_CHECK, 8890 },
    { "intlarhk", VERS_CHECK, 10775 },
    { "intprod", VERS_CHECK, 10812 },
    { "iocy", VERS_CHECK, 1105 },
    { "iogon", VERS_CHECK, 303 },
    { "iopf", VERS_CHECK, 120154 },
    { "iota", VERS_FROM40, 953 },
    { "iprod", VERS_CHECK, 10812 },
    { "iquest", VERS_ALL, 191 },
    { "iscr", VERS_CHECK, 119998 },
    { "isin", VERS_FROM40, 8712 },
    { "isinE", VERS_CHECK, 8953 },
    { "isindot", VERS_CHECK, 8949 },
    { "isins", VERS_CHECK, 8948 },
    { "isinsv", VERS_CHECK, 8947 },
    { "isinv", VERS_CHECK, 8712 },
    { "it", VERS_CHECK, 8290 },
    { "itilde", VERS_CHECK, 297 },
    { "iukcy", VERS_CHECK, 1110 },
    { "iuml", VERS_ALL, 239 },
    { "jcirc", VERS_CHECK, 309 },
    { "jcy", VERS_CHECK, 1081 },
    { "jfr", VERS_CHECK, 120103 },
    { "jmath", VERS_CHECK, 567 },
    { "jopf", VERS_CHECK, 120155 },
    { "jscr", VERS_CHECK, 119999 },
    { "jsercy", VERS_CHECK, 1112 },
    { "jukcy", VERS_CHECK, 1108 },
    { "kappa", VERS_FROM40, 954 },
    { "kappav", VERS_CHECK, 1008 },
    { "kcedil", VERS_CHECK, 311 },
    { "kcy", VERS_CHECK, 1082 },
    { "kfr", VERS_CHECK, 120104 },
    { "kgreen", VERS_CHECK, 312 },
    { "khcy", VERS_CHECK, 1093 },
    { "kjcy", VERS_CHECK, 1116 },
    { "kopf", VERS_CHECK, 120156 },
    { "kscr", VERS_CHECK, 120000 },
    { "lAarr", VERS_CHECK, 8666 },
    { "lArr", VERS_FROM40, 8656 },
    { "lAtail", VERS_CHECK, 10523 },
    { "lBarr", VERS_CHECK, 10510 },
    { "lE", VERS_CHECK, 8806 },
    { "lEg", VERS_CHECK, 10891 },
    { "lHar", VERS_CHECK, 10594 },
    { "lacute", VERS_CHECK, 314 },
    { "laemptyv", VERS_CHECK, 10676 },
    { "lagran", VERS_CHECK, 8466 },
    { "lambda", VERS_FROM40, 955 },
    { "lang", VERS_FROM40, 10216 },
    { "langd", VERS_CHECK, 10641 },
    { "langle", VERS_CHECK, 10216 },
    { "lap", VERS_CHECK, 10885 },
    { "laquo", VERS_ALL, 171 },
    { "larr", VERS_FROM40, 8592 },
    { "larrb", VERS_CHECK, 8676 },
    { "larrbfs", VERS_CHECK, 10527 },
    { "larrfs", VERS_CHECK, 10525 },
    { "larrhk", VERS_CHECK, 8617 },
    { "larrlp", VERS_CHECK, 8619 },
    { "larrpl", VERS_CHECK, 10553 },
    { "larrsim", VERS_CHECK, 10611 },
    { "larrtl", VERS_CHECK, 8610 },
    { "lat", VERS_CHECK, 10923 },
    { "latail", VERS_CHECK, 10521 },
    { "late", VERS_CHECK, 10925 },
    { "lbarr", VERS_CHECK, 10508 },
    { "lbbrk", VERS_CHECK, 10098 },
    { "lbrace", VERS_CHECK, 123 },
    { "lbrack", VERS_CHECK, 91 },
    { "lbrke", VERS_CHECK, 10635 },
    { "lbrksld", VERS_CHECK, 10639 },
    { "lbrkslu", VERS_CHECK, 10637 },
    { "lcaron", VERS_CHECK, 318 },
    { "lcedil", VERS_CHECK, 316 },
    { "lceil", VERS_FROM40, 8968 },
    { "lcub", VERS_CHECK, 123 },
    { "lcy", VERS_CHECK, 1083 },
    { "ldca", VERS_CHECK, 10550 },
    { "ldquo", VERS_FROM40, 8220 },
    { "ldquor", VERS_CHECK, 8222 },
    { "ldrdhar", VERS_CHECK, 10599 },
    { "ldrushar", VERS_CHECK, 10571 },
    { "ldsh", VERS_CHECK, 8626 },
    { "le", VERS_FROM40, 8804 },
    { "leftarrow", VERS_CHECK, 8592 },
    { "leftarrowtail", VERS_CHECK, 8610 },
    { "leftharpoondown", VERS_CHECK, 8637 },
    { "leftharpoonup", VERS_CHECK, 8636 },
    { "leftleftarrows", VERS_CHECK, 8647 },
    { "leftrightarrow", VERS_CHECK, 8596 },
    { "leftrightarrows", VERS_CHECK, 8646 },
    { "leftrightharpoons", VERS_CHECK, 8651 },
    { "leftrightsquigarrow", VERS_CHECK, 8621 },
    { "leftthreetimes", VERS_CHECK, 8907 },
    { "leg", VERS_CHECK, 8922 },
    { "leq", VERS_CHECK, 8804 },
    { "leqq", VERS_CHECK, 8806 },
    { "leqslant", VERS_CHECK, 10877 },
    { "les", VERS_CHECK, 10877 },
    { "lescc", VERS_CHECK, 10920 },
    { "lesdot", VERS_CHECK, 10879 },
    { "lesdoto", VERS_CHECK, 10881 },
    { "lesdotor", VERS_CHECK, 10883 },
    { "lesges", VERS_CHECK, 10899 },
    { "lessapprox", VERS_CHECK, 10885 },
    { "lessdot", VERS_CHECK, 8918 },
    { "lesseqgtr", VERS_CHECK, 8922 },
    { "lesseqqgtr", VERS_CHECK, 10891 },
    { "lessgtr", VERS_CHECK, 8822 },
    { "lesssim", VERS_CHECK, 8818 },
    { "lfisht", VERS_CHECK, 10620 },
    { "lfloor", VERS_FROM40, 8970 },
    { "lfr", VERS_CHECK, 120105 },
    { "lg", VERS_CHECK, 8822 },
    { "lgE", VERS_CHECK, 10897 },
    { "lhard", VERS_CHECK, 8637 },
    { "lharu", VERS_CHECK, 8636 },
    { "lharul", VERS_CHECK, 10602 },
    { "lhblk", VERS_CHECK, 9604 },
    { "ljcy", VERS_CHECK, 1113 },
    { "ll", VERS_CHECK, 8810 },
    { "llarr", VERS_CHECK, 8647 },
    { "llcorner", VERS_CHECK, 8990 },
    { "llhard", VERS_CHECK, 10603 },
    { "lltri", VERS_CHECK, 9722 },
    { "lmidot", VERS_CHECK, 320 },
    { "lmoust", VERS_CHECK, 9136 },
    { "lmoustache", VERS_CHECK, 9136 },
    { "lnE", VERS_CHECK, 8808 },
    { "lnap", VERS_CHECK, 10889 },
    { "lnapprox", VERS_CHECK, 10889 },
    { "lne", VERS_CHECK, 10887 },
    { "lneq", VERS_CHECK, 10887 },
    { "lneqq", VERS_CHECK, 8808 },
    { "lnsim", VERS_CHECK, 8934 },
    { "loang", VERS_CHECK, 10220 },
    { "loarr", VERS_CHECK, 8701 },
    { "lobrk", VERS_CHECK, 10214 },
    { "longleftarrow", VERS_CHECK, 10229 },
    { "longleftrightarrow", VERS_CHECK, 10231 },
    { "longmapsto", VERS_CHECK, 10236 },
    { "longrightarrow", VERS_CHECK, 10230 },
    { "looparrowleft", VERS_CHECK, 8619 },
    { "looparrowright", VERS_CHECK, 8620 },
    { "lopar", VERS_CHECK, 10629 },
    { "lopf", VERS_CHECK, 120157 },
    { "loplus", VERS_CHECK, 10797 },
    { "lotimes", VERS_CHECK, 10804 },
    { "lowast", VERS_FROM40, 8727 },
    { "lowbar", VERS_CHECK, 95 },
    { "loz", VERS_FROM40, 9674 },
    { "lozenge", VERS_CHECK, 9674 },
    { "lozf", VERS_CHECK, 10731 },
    { "lpar", VERS_CHECK, 40 },
    { "lparlt", VERS_CHECK, 10643 },
    { "lrarr", VERS_CHECK, 8646 },
    { "lrcorner", VERS_CHECK, 8991 },
    { "lrhar", VERS_CHECK, 8651 },
    { "lrhard", VERS_CHECK, 10605 },
    { "lrm", VERS_FROM40, 8206 },
    { "lrtri", VERS_CHECK, 8895 },
    { "lsaquo", VERS_FROM40, 8249 },
    { "lscr", VERS_CHECK, 120001 },
    { "lsh", VERS_CHECK, 8624 },
    { "lsim", VERS_CHECK, 8818 },
    { "lsime", VERS_CHECK, 10893 },
    { "lsimg", VERS_CHECK, 10895 },
    { "lsqb", VERS_CHECK, 91 },
    { "lsquo", VERS_FROM40, 8216 },
    { "lsquor", VERS_CHECK, 8218 },
    { "lstrok", VERS_CHECK, 322 },
    { "lt", VERS_ALL | VERS_XML, 60 },
    { "ltcc", VERS_CHECK, 10918 },
    { "ltcir", VERS_CHECK, 10873 },
    { "ltdot", VERS_CHECK, 8918 },
    { "lthree", VERS_CHECK, 8907 },
    { "ltimes", VERS_CHECK, 8905 },
    { "ltlarr", VERS_CHECK, 10614 },
    { "ltquest", VERS_CHECK, 10875 },
    { "ltrPar", VERS_CHECK, 10646 },
    { "ltri", VERS_CHECK, 9667 },
    { "ltrie", VERS_CHECK, 8884 },
    { "ltrif", VERS_CHECK, 9666 },
    { "lurdshar", VERS_CHECK, 10570 },
    { "luruhar", VERS_CHECK, 10598 },
    { "mDDot", VERS_CHECK, 8762 },
    { "macr", VERS_ALL, 175 },
    { "male", VERS_CHECK, 9794 },
    { "malt", VERS_CHECK, 10016 },
    { "maltese", VERS_CHECK, 10016 },
    { "map", VERS_CHECK, 8614 },
    { "mapsto", VERS_CHECK, 8614 },
    { "mapstodown", VERS_CHECK, 8615 },
    { "mapstoleft", VERS_CHECK, 8612 },
    { "mapstoup", VERS_CHECK, 8613 },
    { "marker", VERS_CHECK, 9646 },
    { "mcomma", VERS_CHECK, 10793 },
    { "mcy", VERS_CHECK, 1084 },
    { "mdash", VERS_FROM40, 8212 },
    { "measuredangle", VERS_CHECK, 8737 },
    { "mfr", VERS_CHECK, 120106 },
    { "mho", VERS_CHECK, 8487 },
    { "micro", VERS_ALL, 181 },
    { "mid", VERS_CHECK, 8739 },
    { "midast", VERS_CHECK, 42 },
    { "midcir", VERS_CHECK, 10992 },
    { "middot", VERS_ALL, 183 },
    { "minus", VERS_FROM40, 8722 },
    { "minusb", VERS_CHECK, 8863 },
    { "minusd", VERS_CHECK, 8760 },
    { "minusdu", VERS_CHECK, 10794 },
    { "mlcp", VERS_CHECK, 10971 },
    { "mldr", VERS_CHECK, 8230 },
    { "mnplus", VERS_CHECK, 8723 },
    { "models", VERS_CHECK, 8871 },
    { "mopf", VERS_CHECK, 120158 },
    { "mp", VERS_CHECK, 8723 },
    { "mscr", VERS_CHECK, 120002 },
    { "mstpos", VERS_CHECK, 8766 },
    { "mu", VERS_FROM40, 956 },
    { "multimap", VERS_CHECK, 8888 },
    { "mumap", VERS_CHECK, 8888 },
    { "nLeftarrow", VERS_CHECK, 8653 },
    { "nLeftrightarrow", VERS_CHECK, 8654 },
    { "nRightarrow", VERS_CHECK, 8655 },
    { "nVDash", VERS_CHECK, 8879 },
    { "nVdash", VERS_CHECK, 8878 },
    { "nabla", VERS_FROM40, 8711 },
    { "nacute", VERS_CHECK, 324 },
    { "nap", VERS_CHECK, 8777 },
    { "napos", VERS_CHECK, 329 },
    { "napprox", VERS_CHECK, 8777 },
    { "natur", VERS_CHECK, 9838 },
    { "natural", VERS_CHECK, 9838 },
    { "naturals", VERS_CHECK, 8469 },
    { "nbsp", VERS_ALL, 160 },
    { "ncap", VERS_CHECK, 10819 },
    { "ncaron", VERS_CHECK, 328 },
    { "ncedil", VERS_CHECK, 326 },
    { "ncong", VERS_CHECK, 8775 },
    { "ncup", VERS_CHECK, 10818 },
    { "ncy", VERS_CHECK, 1085 },
    { "ndash", VERS_FROM40, 8211 },
    { "ne", VERS_FROM40, 8800 },
    { "neArr", VERS_CHECK, 8663 },
    { "nearhk", VERS_CHECK, 10532 },
    { "nearr", VERS_CHECK, 8599 },
    { "nearrow", VERS_CHECK, 8599 },
    { "nequiv", VERS_CHECK, 8802 },
    { "nesear", VERS_CHECK, 10536 },
    { "nexist", VERS_CHECK, 8708 },
    { "nexists", VERS_CHECK, 8708 },
    { "nfr", VERS_CHECK, 120107 },
    { "nge", VERS_CHECK, 8817 },
    { "ngeq", VERS_CHECK, 8817 },
    { "ngsim", VERS_CHECK, 8821 },
    { "ngt", VERS_CHECK, 8815 },
    { "ngtr", VERS_CHECK, 8815 },
    { "nhArr", VERS_CHECK, 8654 },
    { "nharr", VERS_CHECK, 8622 },
    { "nhpar", VERS_CHECK, 10994 },
    { "ni", VERS_FROM40, 8715 },
    { "nis", VERS_CHECK, 8956 },
    { "nisd", VERS_CHECK, 8954 },
    { "niv", VERS_CHECK, 8715 },
    { "njcy", VERS_CHECK, 1114 },
    { "nlArr", VERS_CHECK, 8653 },
    { "nlarr", VERS_CHECK, 8602 },
    { "nldr", VERS_CHECK, 8229 },
    { "nle", VERS_CHECK, 8816 },
    { "nleftarrow", VERS_CHECK, 8602 },
    { "nleftrightarrow", VERS_CHECK, 8622 },
    { "nleq", VERS_CHECK, 8816 },
    { "nless", VERS_CHECK, 8814 },
    { "nlsim", VERS_CHECK, 8820 },
    { "nlt", VERS_CHECK, 8814 },
    { "nltri", VERS_CHECK, 8938 },
    { "nltrie", VERS_CHECK, 8940 },
    { "nmid", VERS_CHECK, 8740 },
    { "nopf", VERS_CHECK, 120159 },
    { "not", VERS_ALL, 172 },
    { "notin", VERS_FROM40, 8713 },
    { "notinva", VERS_CHECK, 8713 },
    { "notinvb", VERS_CHECK, 8951 },
    { "notinvc", VERS_CHECK, 8950 },
    { "notni", VERS_CHECK, 8716 },
    { "notniva", VERS_CHECK, 8716 },
    { "notnivb", VERS_CHECK, 8958 },
    { "notnivc", VERS_CHECK, 8957 },
    { "npar", VERS_CHECK, 8742 },
    { "nparallel", VERS_CHECK, 8742 },
    { "npolint", VERS_CHECK, 10772 },
    { "npr", VERS_CHECK, 8832 },
    { "nprcue", VERS_CHECK, 8928 },
    { "nprec", VERS_CHECK, 8832 },
    { "nrArr", VERS_CHECK, 8655 },
    { "nrarr", VERS_CHECK, 8603 },
    { "nrightarrow", VERS_CHECK, 8603 },
    { "nrtri", VERS_CHECK, 8939 },
    { "nrtrie", VERS_CHECK, 8941 },
    { "nsc", VERS_CHECK, 8833 },
    { "nsccue", VERS_CHECK, 8929 },
    { "nscr", VERS_CHECK, 120003 },
    { "nshortmid", VERS_CHECK, 8740 },
    { "nshortparallel", VERS_CHECK, 8742 },
    { "nsim", VERS_CHECK, 8769 },
    { "nsime", VERS_CHECK, 8772 },
    { "nsimeq", VERS_CHECK, 8772 },
    { "nsmid", VERS_CHECK, 8740 },
    { "nspar", VERS_CHECK, 8742 },
    { "nsqsube", VERS_CHECK, 8930 },
    { "nsqsupe", VERS_CHECK, 8931 },
    { "nsub", VERS_FROM40, 8836 },
    { "nsube", VERS_CHECK, 8840 },
    { "nsubseteq", VERS_CHECK, 8840 },
    { "nsucc", VERS_CHECK, 8833 },
    { "nsup", VERS_CHECK, 8837 },
    { "nsupe", VERS_CHECK, 8841 },
    { "nsupseteq", VERS_CHECK, 8841 },
    { "ntgl", VERS_CHECK, 8825 },
    { "ntilde", VERS_ALL, 241 },
    { "ntlg", VERS_CHECK, 8824 },
    { "ntriangleleft", VERS_CHECK, 8938 },
    { "ntrianglelefteq", VERS_CHECK, 8940 },
    { "ntriangleright", VERS_CHECK, 8939 },
    { "ntrianglerighteq", VERS_CHECK, 8941 },
    { "nu", VERS_FROM40, 957 },
    { "num", VERS_CHECK, 35 },
    { "numero", VERS_CHECK, 8470 },
    { "numsp", VERS_CHECK, 8199 },
    { "nvDash", VERS_CHECK, 8877 },
    { "nvHarr", VERS_CHECK, 10500 },
    { "nvdash", VERS_CHECK, 8876 },
    { "nvinfin", VERS_CHECK, 10718 },
    { "nvlArr", VERS_CHECK, 10498 },
    { "nvrArr", VERS_CHECK, 10499 },
    { "nwArr", VERS_CHECK, 8662 },
    { "nwarhk", VERS_CHECK, 10531 },
    { "nwarr", VERS_CHECK, 8598 },
    { "nwarrow", VERS_CHECK, 8598 },
    { "nwnear", VERS_CHECK, 10535 },
    { "oS", VERS_CHECK, 9416 },
    { "oacute", VERS_ALL, 243 },
    { "oast", VERS_CHECK, 8859 },
    { "ocir", VERS_CHECK, 8858 },
    { "ocirc", VERS_ALL, 244 },
    { "ocy", VERS_CHECK, 1086 },
    { "odash", VERS_CHECK, 8861 },
    { "odblac", VERS_CHECK, 337 },
    { "odiv", VERS_CHECK, 10808 },
    { "odot", VERS_CHECK, 8857 },
    { "odsold", VERS_CHECK, 10684 },
    { "oelig", VERS_FROM40, 339 },
    { "ofcir", VERS_CHECK, 10687 },
    { "ofr", VERS_CHECK, 120108 },
    { "ogon", VERS_CHECK, 731 },
    { "ograve", VERS_ALL, 242 },
    { "ogt", VERS_CHECK, 10689 },
    { "ohbar", VERS_CHECK, 10677 },
    { "ohm", VERS_CHECK, 937 },
    { "oint", VERS_CHECK, 8750 },
    { "olarr", VERS_CHECK, 8634 },
    { "olcir", VERS_CHECK, 10686 },
    { "olcross", VERS_CHECK, 10683 },
    { "oline", VERS_FROM40, 8254 },
    { "olt", VERS_CHECK, 10688 },
    { "omacr", VERS_CHECK, 333 },
    { "omega", VERS_FROM40, 969 },
    { "omicron", VERS_FROM40, 959 },
    { "omid", VERS_CHECK, 10678 },
    { "ominus", VERS_CHECK, 8854 },
    { "oopf", VERS_CHECK, 120160 },
    { "opar", VERS_CHECK, 10679 },
    { "operp", VERS_CHECK, 10681 },
    { "oplus", VERS_FROM40, 8853 },
    { "or", VERS_FROM40, 8744 },
    { "orarr", VERS_CHECK, 8635 },
    { "ord", VERS_CHECK, 10845 },
    { "order", VERS_CHECK, 8500 },
    { "orderof", VERS_CHECK, 8500 },
    { "ordf", VERS_ALL, 170 },
    { "ordm", VERS_ALL, 186 },
    { "origof", VERS_CHECK, 8886 },
    { "oror", VERS_CHECK, 10838 },
    { "orslope", VERS_CHECK, 10839 },
    { "orv", VERS_CHECK, 10843 },
    { "oscr", VERS_CHECK, 8500 },
    { "oslash", VERS_ALL, 248 },
    { "osol", VERS_CHECK, 8856 },
    { "otilde", VERS_ALL, 245 },
    { "otimes", VERS_FROM40, 8855 },
    { "otimesas", VERS_CHECK, 10806 },
    { "ouml", VERS_ALL, 246 },
    { "ovbar", VERS_CHECK, 9021 },
    { "par", VERS_CHECK, 8741 },
    { "para", VERS_ALL, 182 },
    { "parallel", VERS_CHECK, 8741 },
    { "parsim", VERS_CHECK, 10995 },
    { "parsl", VERS_CHECK, 11005 },
    { "part", VERS_FROM40, 8706 },
    { "pcy", VERS_CHECK, 1087 },
    { "percnt", VERS_CHECK, 37 },
    { "period", VERS_CHECK, 46 },
    { "permil", VERS_FROM40, 8240 },
    { "perp", VERS_FROM40, 8869 },
    { "pertenk", VERS_CHECK, 8241 },
    { "pfr", VERS_CHECK, 120109 },
    { "phi", VERS_FROM40, 966 },
    { "phiv", VERS_CHECK, 981 },
    { "phmmat", VERS_CHECK, 8499 },
    { "phone", VERS_CHECK, 9742 },
    { "pi", VERS_FROM40, 960 },
    { "pitchfork", VERS_CHECK, 8916 },
    { "piv", VERS_FROM40, 982 },
    { "planck", VERS_CHECK, 8463 },
    { "planckh", VERS_CHECK, 8462 },
    { "plankv", VERS_CHECK, 8463 },
    { "plus", VERS_CHECK, 43 },
    { "plusacir", VERS_CHECK, 10787 },
    { "plusb", VERS_CHECK, 8862 },
    { "pluscir", VERS_CHECK, 10786 },
    { "plusdo", VERS_CHECK, 8724 },
    { "plusdu", VERS_CHECK, 10789 },
    { "pluse", VERS_CHECK, 10866 },
    { "plusmn", VERS_ALL, 177 },
    { "plussim", VERS_CHECK, 10790 },
    { "plustwo", VERS_CHECK, 10791 },
    { "pm", VERS_CHECK, 177 },
    { "pointint", VERS_CHECK, 10773 },
    { "popf", VERS_CHECK, 120161 },
    { "pound", VERS_ALL, 163 },
    { "pr", VERS_CHECK, 8826 },
    { "prE", VERS_CHECK, 10931 },
    { "prap", VERS_CHECK, 10935 },
    { "prcue", VERS_CHECK, 8828 },
    { "pre", VERS_CHECK, 10927 },
    { "prec", VERS_CHECK, 8826 },
    { "precapprox", VERS_CHECK, 10935 },
    { "preccurlyeq", VERS_CHECK, 8828 },
    { "preceq", VERS_CHECK, 10927 },
    { "precnapprox", VERS_CHECK, 10937 },
    { "precneqq", VERS_CHECK, 10933 },
    { "precnsim", VERS_CHECK, 8936 },
    { "precsim", VERS_CHECK, 8830 },
    { "prime", VERS_FROM40, 8242 },
    { "primes", VERS_CHECK, 8473 },
    { "prnE", VERS_CHECK, 10933 },
    { "prnap", VERS_CHECK, 10937 },
    { "prnsim", VERS_CHECK, 8936 },
    { "prod", VERS_FROM40, 8719 },
    { "profalar", VERS_CHECK, 9006 },
    { "profline", VERS_CHECK, 8978 },
    { "profsurf", VERS_CHECK, 8979 },
    { "prop", VERS_FROM40, 8733 },
    { "propto", VERS_CHECK, 8733 },
    { "prsim", VERS_CHECK, 8830 },
    { "prurel", VERS_CHECK, 8880 },
    { "pscr", VERS_CHECK, 120005 },
    { "psi", VERS_FROM40, 968 },
    { "puncsp", VERS_CHECK, 8200 },
    { "qfr", VERS_CHECK, 120110 },
    { "qint", VERS_CHECK, 10764 },
    { "qopf", VERS_CHECK, 120162 },
    { "qprime", VERS_CHECK, 8279 },
    { "qscr", VERS_CHECK, 120006 },
    { "quaternions", VERS_CHECK, 8461 },
    { "quatint", VERS_CHECK, 10774 },
    { "quest", VERS_CHECK, 63 },
    { "questeq", VERS_CHECK, 8799 },
    { "quot", VERS_ALL | VERS_XML, 34 },
    { "rAarr", VERS_CHECK, 8667 },
    { "rArr", VERS_FROM40, 8658 },
    { "rAtail", VERS_CHECK, 10524 },
    { "rBarr", VERS_CHECK, 10511 },
    { "rHar", VERS_CHECK, 10596 },
    { "racute", VERS_CHECK, 341 },
    { "radic", VERS_FROM40, 8730 },
    { "raemptyv", VERS_CHECK, 10675 },
    { "rang", VERS_FROM40, 10217 },
    { "rangd", VERS_CHECK, 10642 },
    { "range", VERS_CHECK, 10661 },
    { "rangle", VERS_CHECK, 10217 },
    { "raquo", VERS_ALL, 187 },
    { "rarr", VERS_FROM40, 8594 },
    { "rarrap", VERS_CHECK, 10613 },
    { "rarrb", VERS_CHECK, 8677 },
    { "rarrbfs", VERS_CHECK, 10528 },
    { "rarrc", VERS_CHECK, 10547 },
    { "rarrfs", VERS_CHECK, 10526 },
    { "rarrhk", VERS_CHECK, 8618 },
    { "rarrlp", VERS_CHECK, 8620 },
    { "rarrpl", VERS_CHECK, 10565 },
    { "rarrsim", VERS_CHECK, 10612 },
    { "rarrtl", VERS_CHECK, 8611 },
    { "rarrw", VERS_CHECK, 8605 },
    { "ratail", VERS_CHECK, 10522 },
    { "ratio", VERS_CHECK, 8758 },
    { "rationals", VERS_CHECK, 8474 },
    { "rbarr", VERS_CHECK, 10509 },
    { "rbbrk", VERS_CHECK, 10099 },
    { "rbrace", VERS_CHECK, 125 },
    { "rbrack", VERS_CHECK, 93 },
    { "rbrke", VERS_CHECK, 10636 },
    { "rbrksld", VERS_CHECK, 10638 },
    { "rbrkslu", VERS_CHECK, 10640 },
    { "rcaron", VERS_CHECK, 345 },
    { "rcedil", VERS_CHECK, 343 },
    { "rceil", VERS_FROM40, 8969 },
    { "rcub", VERS_CHECK, 125 },
    { "rcy", VERS_CHECK, 1088 },
    { "rdca", VERS_CHECK, 10551 },
    { "rdldhar", VERS_CHECK, 10601 },
    { "rdquo", VERS_FROM40, 8221 },
    { "rdquor", VERS_CHECK, 8221 },
    { "rdsh", VERS_CHECK, 8627 },
    { "real", VERS_FROM40, 8476 },
    { "realine", VERS_CHECK, 8475 },
    { "realpart", VERS_CHECK, 8476 },
    { "reals", VERS_CHECK, 8477 },
    { "rect", VERS_CHECK, 9645 },
    { "reg", VERS_ALL, 174 },
    { "rfisht", VERS_CHECK, 10621 },
    { "rfloor", VERS_FROM40, 8971 },
    { "rfr", VERS_CHECK, 120111 },
    { "rhard", VERS_CHECK, 8641 },
    { "rharu", VERS_CHECK, 8640 },
    { "rharul", VERS_CHECK, 10604 },
    { "rho", VERS_FROM40, 961 },
    { "rhov", VERS_CHECK, 1009 },
    { "rightarrow", VERS_CHECK, 8594 },
    { "rightarrowtail", VERS_CHECK, 8611 },
    { "rightharpoondown", VERS_CHECK, 8641 },
    { "rightharpoonup", VERS_CHECK, 8640 },
    { "rightleftarrows", VERS_CHECK, 8644 },
    { "rightleftharpoons", VERS_CHECK, 8652 },
    { "rightrightarrows", VERS_CHECK, 8649 },
    { "rightsquigarrow", VERS_CHECK, 8605 },
    { "rightthreetimes", VERS_CHECK, 8908 },
    { "ring", VERS_CHECK, 730 },
    { "risingdotseq", VERS_CHECK, 8787 },
    { "rlarr", VERS_CHECK, 8644 },
    { "rlhar", VERS_CHECK, 8652 },
    { "rlm", VERS_FROM40, 8207 },
    { "rmoust", VERS_CHECK, 9137 },
    { "rmoustache", VERS_CHECK, 9137 },
    { "rnmid", VERS_CHECK, 10990 },
    { "roang", VERS_CHECK, 10221 },
    { "roarr", VERS_CHECK, 8702 },
    { "robrk", VERS_CHECK, 10215 },
    { "ropar", VERS_CHECK, 10630 },
    { "ropf", VERS_CHECK, 120163 },
    { "roplus", VERS_CHECK, 10798 },
    { "rotimes", VERS_CHECK, 10805 },
    { "rpar", VERS_CHECK, 41 },
    { "rpargt", VERS_CHECK, 10644 },
    { "rppolint", VERS_CHECK, 10770 },
    { "rrarr", VERS_CHECK, 8649 },
    { "rsaquo", VERS_FROM40, 8250 },
    { "rscr", VERS_CHECK, 120007 },
    { "rsh", VERS_CHECK, 8625 },
    { "rsqb", VERS_CHECK, 93 },
    { "rsquo", VERS_FROM40, 8217 },
    { "rsquor", VERS_CHECK, 8217 },
    { "rthree", VERS_CHECK, 8908 },
    { "rtimes", VERS_CHECK, 8906 },
    { "rtri", VERS_CHECK, 9657 },
    { "rtrie", VERS_CHECK, 8885 },
    { "rtrif", VERS_CHECK, 9656 },
    { "rtriltri", VERS_CHECK, 10702 },
    { "ruluhar", VERS_CHECK, 10600 },
    { "rx", VERS_CHECK, 8478 },
    { "sacute", VERS_CHECK, 347 },
    { "sbquo", VERS_FROM40, 8218 },
    { "sc", VERS_CHECK, 8827 },
    { "scE", VERS_CHECK, 10932 },
    { "scap", VERS_CHECK, 10936 },
    { "scaron", VERS_FROM40, 353 },
    { "sccue", VERS_CHECK, 8829 },
    { "sce", VERS_CHECK, 10928 },
    { "scedil", VERS_CHECK, 351 },
    { "scirc", VERS_CHECK, 349 },
    { "scnE", VERS_CHECK, 10934 },
    { "scnap", VERS_CHECK, 10938 },
    { "scnsim", VERS_CHECK, 8937 },
    { "scpolint", VERS_CHECK, 10771 },
    { "scsim", VERS_CHECK, 8831 },
    { "scy", VERS_CHECK, 1089 },
    { "sdot", VERS_FROM40, 8901 },
    { "sdotb", VERS_CHECK, 8865 },
    { "sdote", VERS_CHECK, 10854 },
    { "seArr", VERS_CHECK, 8664 },
    { "searhk", VERS_CHECK, 10533 },
    { "searr", VERS_CHECK, 8600 },
    { "searrow", VERS_CHECK, 8600 },
    { "sect", VERS_ALL, 167 },
    { "semi", VERS_CHECK, 59 },
    { "seswar", VERS_CHECK, 10537 },
    { "setminus", VERS_CHECK, 8726 },
    { "setmn", VERS_CHECK, 8726 },
    { "sext", VERS_CHECK, 10038 },
    { "sfr", VERS_CHECK, 120112 },
    { "sfrown", VERS_CHECK, 8994 },
    { "sharp", VERS_CHECK, 9839 },
    { "shchcy", VERS_CHECK, 1097 },
    { "shcy", VERS_CHECK, 1096 },
    { "shortmid", VERS_CHECK, 8739 },
    { "shortparallel", VERS_CHECK, 8741 },
    { "shy", VERS_ALL, 173 },
    { "sigma", VERS_FROM40, 963 },
    { "sigmaf", VERS_FROM40, 962 },
    { "sigmav", VERS_CHECK, 962 },
    { "sim", VERS_FROM40, 8764 },
    { "simdot", VERS_CHECK, 10858 },
    { "sime", VERS_CHECK, 8771 },
    { "simeq", VERS_CHECK, 8771 },
    { "simg", VERS_CHECK, 10910 },
    { "simgE", VERS_CHECK, 10912 },
    { "siml", VERS_CHECK, 10909 },
    { "simlE", VERS_CHECK, 10911 },
    { "simne", VERS_CHECK, 8774 },
    { "simplus", VERS_CHECK, 10788 },
    { "simrarr", VERS_CHECK, 10610 },
    { "slarr", VERS_CHECK, 8592 },
    { "smallsetminus", VERS_CHECK, 8726 },
    { "smashp", VERS_CHECK, 10803 },
    { "smeparsl", VERS_CHECK, 10724 },
    { "smid", VERS_CHECK, 8739 },
    { "smile", VERS_CHECK, 8995 },
    { "smt", VERS_CHECK, 10922 },
    { "smte", VERS_CHECK, 10924 },
    { "softcy", VERS_CHECK, 1100 },
    { "sol", VERS_CHECK, 47 },
    { "solb", VERS_CHECK, 10692 },
    { "solbar", VERS_CHECK, 9023 },
    { "sopf", VERS_CHECK, 120164 },
    { "spades", VERS_FROM40, 9824 },
    { "spadesuit", VERS_CHECK, 9824 },
    { "spar", VERS_CHECK, 8741 },
    { "sqcap", VERS_CHECK, 8851 },
    { "sqcup", VERS_CHECK, 8852 },
    { "sqsub", VERS_CHECK, 8847 },
    { "sqsube", VERS_CHECK, 8849 },
    { "sqsubset", VERS_CHECK, 8847 },
    { "sqsubseteq", VERS_CHECK, 8849 },
    { "sqsup", VERS_CHECK, 8848 },
    { "sqsupe", VERS_CHECK, 8850 },
    { "sqsupset", VERS_CHECK, 8848 },
    { "sqsupseteq", VERS_CHECK, 8850 },
    { "squ", VERS_CHECK, 9633 },
    { "square", VERS_CHECK, 9633 },
    { "squarf", VERS_CHECK, 9642 },
    { "squf", VERS_CHECK, 9642 },
    { "srarr", VERS_CHECK, 8594 },
    { "sscr", VERS_CHECK, 120008 },
    { "ssetmn", VERS_CHECK, 8726 },
    { "ssmile", VERS_CHECK, 8995 },
    { "sstarf", VERS_CHECK, 8902 },
    { "star", VERS_CHECK, 9734 },
    { "starf", VERS_CHECK, 9733 },
    { "straightepsilon", VERS_CHECK, 1013 },
    { "straightphi", VERS_CHECK, 981 },
    { "strns", VERS_CHECK, 175 },
    { "sub", VERS_FROM40, 8834 },
    { "subE", VERS_CHECK, 10949 },
    { "subdot", VERS_CHECK, 10941 },
    { "sube", VERS_FROM40, 8838 },
    { "subedot", VERS_CHECK, 10947 },
    { "submult", VERS_CHECK, 10945 },
    { "subnE", VERS_CHECK, 10955 },
    { "subne", VERS_CHECK, 8842 },
    { "subplus", VERS_CHECK, 10943 },
    { "subrarr", VERS_CHECK, 10617 },
    { "subset", VERS_CHECK, 8834 },
    { "subseteq", VERS_CHECK, 8838 },
    { "subseteqq", VERS_CHECK, 10949 },
    { "subsetneq", VERS_CHECK, 8842 },
    { "subsetneqq", VERS_CHECK, 10955 },
    { "subsim", VERS_CHECK, 10951 },
    { "subsub", VERS_CHECK, 10965 },
    { "subsup", VERS_CHECK, 10963 },
    { "succ", VERS_CHECK, 8827 },
    { "succapprox", VERS_CHECK, 10936 },
    { "succcurlyeq", VERS_CHECK, 8829 },
    { "succeq", VERS_CHECK, 10928 },
    { "succnapprox", VERS_CHECK, 10938 },
    { "succneqq", VERS_CHECK, 10934 },
    { "succnsim", VERS_CHECK, 8937 },
    { "succsim", VERS_CHECK, 8831 },
    { "sum", VERS_FROM40, 8721 },
    { "sung", VERS_CHECK, 9834 },
    { "sup", VERS_FROM40, 8835 },
    { "sup1", VERS_ALL, 185 },
    { "sup2", VERS_ALL, 178 },
    { "sup3", VERS_ALL, 179 },
    { "supE", VERS_CHECK, 10950 },
    { "supdot", VERS_CHECK, 10942 },
    { "supdsub", VERS_CHECK, 10968 },
    { "supe", VERS_FROM40, 8839 },
    { "supedot", VERS_CHECK, 10948 },
    { "suphsol", VERS_CHECK, 10185 },
    { "suphsub", VERS_CHECK, 10967 },
    { "suplarr", VERS_CHECK, 10619 },
    { "supmult", VERS_CHECK, 10946 },
    { "supnE", VERS_CHECK, 10956 },
    { "supne", VERS_CHECK, 8843 },
    { "supplus", VERS_CHECK, 10944 },
    { "supset", VERS_CHECK, 8835 },
    { "supseteq", VERS_CHECK, 8839 },
    { "supseteqq", VERS_CHECK, 10950 },
    { "supsetneq", VERS_CHECK, 8843 },
    { "supsetneqq", VERS_CHECK, 10956 },
    { "supsim", VERS_CHECK, 10952 },
    { "supsub", VERS_CHECK, 10964 },
    { "supsup", VERS_CHECK, 10966 },
    { "swArr", VERS_CHECK, 8665 },
    { "swarhk", VERS_CHECK, 10534 },
    { "swarr", VERS_CHECK, 8601 },
    { "swarrow", VERS_CHECK, 8601 },
    { "swnwar", VERS_CHECK, 10538 },
    { "szlig", VERS_ALL, 223 },
    { "target", VERS_CHECK, 8982 },
    { "tau", VERS_FROM40, 964 },
    { "tbrk", VERS_CHECK, 9140 },
    { "tcaron", VERS_CHECK, 357 },
    { "tcedil", VERS_CHECK, 355 },
    { "tcy", VERS_CHECK, 1090 },
    { "tdot", VERS_CHECK, 8411 },
    { "telrec", VERS_CHECK, 8981 },
    { "tfr", VERS_CHECK, 120113 },
    { "there4", VERS_FROM40, 8756 },
    { "therefore", VERS_CHECK, 8756 },
    { "theta", VERS_FROM40, 952 },
    { "thetasym", VERS_FROM40, 977 },
    { "thetav", VERS_CHECK, 977 },
    { "thickapprox", VERS_CHECK, 8776 },
    { "thicksim", VERS_CHECK, 8764 },
    { "thinsp", VERS_FROM40, 8201 },
    { "thkap", VERS_CHECK, 8776 },
    { "thksim", VERS_CHECK, 8764 },
    { "thorn", VERS_ALL, 254 },
    { "tilde", VERS_FROM40, 732 },
    { "times", VERS_ALL, 215 },
    { "timesb", VERS_CHECK, 8864 },
    { "timesbar", VERS_CHECK, 10801 },
    { "timesd", VERS_CHECK, 10800 },
    { "tint", VERS_CHECK, 8749 },
    { "toea", VERS_CHECK, 10536 },
    { "top", VERS_CHECK, 8868 },
    { "topbot", VERS_CHECK, 9014 },
    { "topcir", VERS_CHECK, 10993 },
    { "topf", VERS_CHECK, 120165 },
    { "topfork", VERS_CHECK, 10970 },
    { "tosa", VERS_CHECK, 10537 },
    { "tprime", VERS_CHECK, 8244 },
    { "trade", VERS_FROM40, 8482 },
    { "triangle", VERS_CHECK, 9653 },
    { "triangledown", VERS_CHECK, 9663 },
    { "triangleleft", VERS_CHECK, 9667 },
    { "trianglelefteq", VERS_CHECK, 8884 },
    { "triangleq", VERS_CHECK, 8796 },
    { "triangleright", VERS_CHECK, 9657 },
    { "trianglerighteq", VERS_CHECK, 8885 },
    { "tridot", VERS_CHECK, 9708 },
    { "trie", VERS_CHECK, 8796 },
    { "triminus", VERS_CHECK, 10810 },
    { "triplus", VERS_CHECK, 10809 },
    { "trisb", VERS_CHECK, 10701 },
    { "tritime", VERS_CHECK, 10811 },
    { "trpezium", VERS_CHECK, 9186 },
    { "tscr", VERS_CHECK, 120009 },
    { "tscy", VERS_CHECK, 1094 },
    { "tshcy", VERS_CHECK, 1115 },
    { "tstrok", VERS_CHECK, 359 },
    { "twixt", VERS_CHECK, 8812 },
    { "twoheadleftarrow", VERS_CHECK, 8606 },
    { "twoheadrightarrow", VERS_CHECK, 8608 },
    { "uArr", VERS_FROM40, 8657 },
    { "uHar", VERS_CHECK, 10595 },
    { "uacute", VERS_ALL, 250 },
    { "uarr", VERS_FROM40, 8593 },
    { "ubrcy", VERS_CHECK, 1118 },
    { "ubreve", VERS_CHECK, 365 },
    { "ucirc", VERS_ALL, 251 },
    { "ucy", VERS_CHECK, 1091 },
    { "udarr", VERS_CHECK, 8645 },
    { "udblac", VERS_CHECK, 369 },
    { "udhar", VERS_CHECK, 10606 },
    { "ufisht", VERS_CHECK, 10622 },
    { "ufr", VERS_CHECK, 120114 },
    { "ugrave", VERS_ALL, 249 },
    { "uharl", VERS_CHECK, 8639 },
    { "uharr", VERS_CHECK, 8638 },
    { "uhblk", VERS_CHECK, 9600 },
    { "ulcorn", VERS_CHECK, 8988 },
    { "ulcorner", VERS_CHECK, 8988 },
    { "ulcrop", VERS_CHECK, 8975 },
    { "ultri", VERS_CHECK, 9720 },
    { "umacr", VERS_CHECK, 363 },
    { "uml", VERS_ALL, 168 },
    { "uogon", VERS_CHECK, 371 },
    { "uopf", VERS_CHECK, 120166 },
    { "uparrow", VERS_CHECK, 8593 },
    { "updownarrow", VERS_CHECK, 8597 },
    { "upharpoonleft", VERS_CHECK, 8639 },
    { "upharpoonright", VERS_CHECK, 8638 },
    { "uplus", VERS_CHECK, 8846 },
    { "upsi", VERS_CHECK, 965 },
    { "upsih", VERS_FROM40, 978 },
    { "upsilon", VERS_FROM40, 965 },
    { "upuparrows", VERS_CHECK, 8648 },
    { "urcorn", VERS_CHECK, 8989 },
    { "urcorner", VERS_CHECK, 8989 },
    { "urcrop", VERS_CHECK, 8974 },
    { "uring", VERS_CHECK, 367 },
    { "urtri", VERS_CHECK, 9721 },
    { "uscr", VERS_CHECK, 120010 },
    { "utdot", VERS_CHECK, 8944 },
    { "utilde", VERS_CHECK, 361 },
    { "utri", VERS_CHECK, 9653 },
    { "utrif", VERS_CHECK, 9652 },
    { "uuarr", VERS_CHECK, 8648 },
    { "uuml", VERS_ALL, 252 },
    { "uwangle", VERS_CHECK, 10663 },
    { "vArr", VERS_CHECK, 8661 },
    { "vBar", VERS_CHECK, 10984 },
    { "vBarv", VERS_CHECK, 10985 },
    { "vDash", VERS_CHECK, 8872 },
    { "vangrt", VERS_CHECK, 10652 },
    { "varepsilon", VERS_CHECK, 1013 },
    { "varkappa", VERS_CHECK, 1008 },
    { "varnothing", VERS_CHECK, 8709 },
    { "varphi", VERS_CHECK, 981 },
    { "varpi", VERS_CHECK, 982 },
    { "varpropto", VERS_CHECK, 8733 },
    { "varr", VERS_CHECK, 8597 },
    { "varrho", VERS_CHECK, 1009 },
    { "varsigma", VERS_CHECK, 962 },
    { "vartheta", VERS_CHECK, 977 },
    { "vartriangleleft", VERS_CHECK, 8882 },
    { "vartriangleright", VERS_CHECK, 8883 },
    { "vcy", VERS_CHECK, 1074 },
    { "vdash", VERS_CHECK, 8866 },
    { "vee", VERS_CHECK, 8744 },
    { "veebar", VERS_CHECK, 8891 },
    { "veeeq", VERS_CHECK, 8794 },
    { "vellip", VERS_CHECK, 8942 },
    { "verbar", VERS_CHECK, 124 },
    { "vert", VERS_CHECK, 124 },
    { "vfr", VERS_CHECK, 120115 },
    { "vltri", VERS_CHECK, 8882 },
    { "vopf", VERS_CHECK, 120167 },
    { "vprop", VERS_CHECK, 8733 },
    { "vrtri", VERS_CHECK, 8883 },
    { "vscr", VERS_CHECK, 120011 },
    { "vzigzag", VERS_CHECK, 10650 },
    { "wcirc", VERS_CHECK, 373 },
    { "wedbar", VERS_CHECK, 10847 },
    { "wedge", VERS_CHECK, 8743 },
    { "wedgeq", VERS_CHECK, 8793 },
    { "weierp", VERS_FROM40, 8472 },
    { "wfr", VERS_CHECK, 120116 },
    { "wopf", VERS_CHECK, 120168 },
    { "wp", VERS_CHECK, 8472 },
    { "wr", VERS_CHECK, 8768 },
    { "wreath", VERS_CHECK, 8768 },
    { "wscr", VERS_CHECK, 120012 },
    { "xcap", VERS_CHECK, 8898 },
    { "xcirc", VERS_CHECK, 9711 },
    { "xcup", VERS_CHECK, 8899 },
    { "xdtri", VERS_CHECK, 9661 },
    { "xfr", VERS_CHECK, 120117 },
    { "xhArr", VERS_CHECK, 10234 },
    { "xharr", VERS_CHECK, 10231 },
    { "xi", VERS_FROM40, 958 },
    { "xlArr", VERS_CHECK, 10232 },
    { "xlarr", VERS_CHECK, 10229 },
    { "xmap", VERS_CHECK, 10236 },
    { "xnis", VERS_CHECK, 8955 },
    { "xodot", VERS_CHECK, 10752 },
    { "xopf", VERS_CHECK, 120169 },
    { "xoplus", VERS_CHECK, 10753 },
    { "xotime", VERS_CHECK, 10754 },
    { "xrArr", VERS_CHECK, 10233 },
    { "xrarr", VERS_CHECK, 10230 },
    { "xscr", VERS_CHECK, 120013 },
    { "xsqcup", VERS_CHECK, 10758 },
    { "xuplus", VERS_CHECK, 10756 },
    { "xutri", VERS_CHECK, 9651 },
    { "xvee", VERS_CHECK, 8897 },
    { "xwedge", VERS_CHECK, 8896 },
    { "yacute", VERS_ALL, 253 },
    { "yacy", VERS_CHECK, 1103 },
    { "ycirc", VERS_CHECK, 375 },
    { "ycy", VERS_CHECK, 1099 },
    { "yen", VERS_ALL, 165 },
    { "yfr", VERS_CHECK, 120118 },
    { "yicy", VERS_CHECK, 1111 },
    { "yopf", VERS_CHECK, 120170 },
    { "yscr", VERS_CHECK, 120014 },
    { "yucy", VERS_CHECK, 1102 },
    { "yuml", VERS_ALL, 255 },
    { "zacute", VERS_CHECK, 378 },
    { "zcaron", VERS_CHECK, 382 },
    { "zcy", VERS_CHECK, 1079 },
    { "zdot", VERS_CHECK, 380 },
    { "zeetrf", VERS_CHECK, 8488 },
    { "zeta", VERS_FROM40, 950 },
    { "zfr", VERS_CHECK, 120119 },
    { "zhcy", VERS_CHECK, 1078 },
    { "zigrarr", VERS_CHECK, 8669 },
    { "zopf", VERS_CHECK, 120171 },
    { "zscr", VERS_CHECK, 120015 },
    { "zwj", VERS_FROM40, 8205 },
    { "zwnj", VERS_FROM40, 8204 },
    { NULL, VERS_UNKNOWN, 0 },
};

/* 
** Pure static implementation.  Trades off lookup speed
** for faster setup time (well, none actually).
** Optimization of comparing 1st character buys enough
** speed that hash doesn't improve things without > 500
** items in list.
** Issue #643 - Keep list fully alphabetic for more 
** optimization, now that the list has grown to 2031
** entries. Perhaps hashing setup should be now considered.
**
*/
static const entity* entitiesLookup( ctmbstr s )
{
    tmbchar ch = (tmbchar)( s ? *s : 0 );
    const entity *np = entities;
    if (ch == 0)
        return NULL;
    while (np->name)
    {
        if (ch == *np->name)
            break;  /* stop when first letter matches */
        np++;
    }
    while (np->name)
    {
        if (ch != *np->name)
            break;  /* stop when first letter does not match */
        if (TY_(tmbstrcmp)(s, np->name) == 0)
            return np;
        np++;
    }
    return NULL;
}

Bool TY_(EntityInfo)( ctmbstr name, Bool isXml, uint* code, uint* versions )
{
    const entity* np;
    int res;

    /* numeric entitity: name = "&#" followed by number */
    if ( name[1] == '#' )
    {
        uint c = 0;  /* zero on missing/bad number */

        /* 'x' prefix denotes hexadecimal number format */
        if ( name[2] == 'x' || (!isXml && name[2] == 'X') )
            res = sscanf( name+3, "%x", &c );
        else
            res = sscanf( name+2, "%u", &c );

        /*  Issue #373 - Null Char in XML result doc - sf905 2009 */
        if ( res == 1 )
        {
            *code = c;
            *versions = VERS_ALL;
            return yes;
        }
        else
        {
            *code = 0;
            *versions = ( isXml ? VERS_XML : VERS_PROPRIETARY );
            return no;
        }
    }

    /* Named entity: name ="&" followed by a name */
    if ( NULL != (np = entitiesLookup(name+1)) )
    {
        *code = np->code;
        *versions = np->versions;
        return yes;
    }

    *code = 0;
    *versions = ( isXml ? VERS_XML : VERS_PROPRIETARY );
    return no;
}

/*
**
** Issue #643 - Now that the list has been enlarged to 
** 2031 entries, including multiple case entries for some
** like &amp; & &AMP;, the value can be repeated several
** time, so this lookup will now only return the first.
**
*/
ctmbstr TY_(EntityName)( uint ch, uint versions )
{
    ctmbstr entnam = NULL;
    const entity *ep;

    for ( ep = entities; ep->name != NULL; ++ep )
    {
        if ( ep->code == ch )
        {
            if (ep->versions & versions)
            {
                entnam = ep->name;
                break; /* Issue #643 - Found code and version. Stop search? */
            }
        }
    }
    return entnam;
}

/*
 * local variables:
 * mode: c
 * indent-tabs-mode: nil
 * c-basic-offset: 4
 * eval: (c-set-offset 'substatement-open 0)
 * end:
 */
