#include "runcommandforparsing.h"

#include <array>
#include <memory>
#include <functional>
#include <iostream>
#include <stdexcept>
#include <string>

namespace NApplication {

void runCommandForParsing(const string& command, const std::function<void(const std::string&)>& lineProcessor) {
    std::array<char, 256> buffer;
    std::string line;

    std::unique_ptr<FILE, decltype(&pclose)> pipe(popen(command.c_str(), "r"), pclose);
    if (!pipe) {
        throw std::runtime_error("popen() failed!");
    }

    while (fgets(buffer.data(), buffer.size(), pipe.get()) != nullptr) {
        line += buffer.data(); // Zeilenstücke zusammenfügen

        // Prüfen, ob die Zeile abgeschlossen ist (endet auf '\n')
        if (!line.empty() && line.back() == '\n') {
            line.pop_back();
            lineProcessor(line);
            line.clear();      // Puffer für die nächste Zeile leeren
        }
    }

    // Falls eine Zeile am Ende nicht abgeschlossen wurde
    if (!line.empty()) {
        lineProcessor(line);
    }
}

}


