// SPDX-License-Identifier: GPL-2.0
// Copyright (C) 2020 Martin Whitaker.

#include <stdint.h>

#include "io.h"

#include "keyboard.h"

//------------------------------------------------------------------------------
// Private Variables
//------------------------------------------------------------------------------

// Convert set 1 scancodes to characters.
static const char keymap[] = {
    /* 0x00 */   0,
    /* 0x01 */ ESC,
    /* 0x02 */ '1',
    /* 0x03 */ '2',
    /* 0x04 */ '3',
    /* 0x05 */ '4',
    /* 0x06 */ '5',
    /* 0x07 */ '6',
    /* 0x08 */ '7',
    /* 0x09 */ '8',
    /* 0x0a */ '9',
    /* 0x0b */ '0',
    /* 0x0c */ '-',
    /* 0x0d */ '+',
    /* 0x0e */ '\b',
    /* 0x0f */ '\t',
    /* 0x10 */ 'q',
    /* 0x11 */ 'w',
    /* 0x12 */ 'e',
    /* 0x13 */ 'r',
    /* 0x14 */ 't',
    /* 0x15 */ 'y',
    /* 0x16 */ 'u',
    /* 0x17 */ 'i',
    /* 0x18 */ 'o',
    /* 0x19 */ 'p',
    /* 0x1a */ '[',
    /* 0x1b */ ']',
    /* 0x1c */ '\n',
    /* 0x1d */   0,
    /* 0x1e */ 'a',
    /* 0x1f */ 's',
    /* 0x20 */ 'd',
    /* 0x21 */ 'f',
    /* 0x22 */ 'g',
    /* 0x23 */ 'h',
    /* 0x24 */ 'j',
    /* 0x25 */ 'k',
    /* 0x26 */ 'l',
    /* 0x27 */ ';',
    /* 0x28 */ '\'',
    /* 0x29 */ '`',
    /* 0x2a */   0,
    /* 0x2b */ '\\',
    /* 0x2c */ 'z',
    /* 0x2d */ 'x',
    /* 0x2e */ 'c',
    /* 0x2f */ 'v',
    /* 0x30 */ 'b',
    /* 0x31 */ 'n',
    /* 0x32 */ 'm',
    /* 0x33 */ ',',
    /* 0x34 */ '.',
    /* 0x35 */ '/',
    /* 0x36 */   0,
    /* 0x37 */ '*',  // keypad
    /* 0x38 */   0,
    /* 0x39 */ ' ',
    /* 0x3a */   0,
    /* 0x3b */ '1',
    /* 0x3c */ '2',
    /* 0x3d */ '3',
    /* 0x3e */ '4',
    /* 0x3f */ '5',
    /* 0x40 */ '6',
    /* 0x41 */ '7',
    /* 0x42 */ '8',
    /* 0x43 */ '9',
    /* 0x44 */ '0',
    /* 0x45 */   0,
    /* 0x46 */   0,
    /* 0x47 */ '7',  // keypad
    /* 0x48 */ '8',  // keypad
    /* 0x49 */ '9',  // keypad
    /* 0x4a */ '-',  // keypad
    /* 0x4b */ '4',  // keypad
    /* 0x4c */ '5',  // keypad
    /* 0x4d */ '6',  // keypad
    /* 0x4e */ '+',  // keypad
    /* 0x4f */ '1',  // keypad
    /* 0x50 */ '2',  // keypad
    /* 0x51 */ '3',  // keypad
    /* 0x52 */ '0',  // keypad
    /* 0x53 */ '.',  // keypad
};

//------------------------------------------------------------------------------
// Public Functions
//------------------------------------------------------------------------------

char get_key(void)
{
    uint8_t c = inb(0x64);
    if (c & 0x01) {
        c = inb(0x60);
        if (c < sizeof(keymap)) {
            return keymap[c];
        }
        // Ignore keys we don't recognise and key up codes
    }
    return '\0';
}
