/*	Percent_Bar_UI

PIRL CVS ID: Percent_Bar_UI.java,v 1.5 2012/04/16 06:22:59 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package	PIRL.Viewers;

import	javax.swing.JComponent;
import	javax.swing.plaf.ComponentUI;
import	java.awt.Color;
import	java.awt.Insets;
import	java.awt.Graphics;
import	java.awt.geom.Rectangle2D;

/**	A <i>Percent_Bar_UI</i> provides a ComponentUI delegate for the
	Percent_Bar component.
<p>
	@author		Bradford Castalia, UA/PIRL
	@version	1.5
	@see		Percent_Bar
*/
public class Percent_Bar_UI
	extends Percent_BarUI
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Viewers.Percent_Bar_UI (1.5 2012/04/16 06:22:59)";


//  DEBUG control.
private static final int
	DEBUG_OFF			= 0,
	DEBUG_CONSTRUCTORS	= 1 << 0,
	DEBUG_PAINT			= 1 << 1,
	DEBUG_ALL			= -1,

	DEBUG		    	= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
/**	Construct a Percent_Bar_UI object.
*/
public Percent_Bar_UI ()
{
if ((DEBUG & DEBUG_CONSTRUCTORS) != 0)
	System.out.println (">-< Percent_Bar_UI.Constructor");
}

/**	Construct a Percent_Bar_UI object for the specified JComponent.
<p>
	@param	component	The JComponent for which ComponentUI delegation
		is to be provided.
	@return	A Percent_Bar_UI object.
*/
public static ComponentUI createUI
	(
	JComponent	component
	)
{
if ((DEBUG & DEBUG_CONSTRUCTORS) != 0)
	System.out.println (">-< Percent_Bar_UI.createUI");
return new Percent_Bar_UI ();
}

/*==============================================================================
	Component Painting
*/
/**	Paint the component on the graphics display device.
<p>
	@param	graphics	The Graphics on which to paint the component.
	@param	component	The JComponent to be painted.
*/
public void paint
	(
	Graphics	graphics,
	JComponent	component
	)
{
if ((DEBUG & DEBUG_PAINT) != 0)
	System.out.println (">>> Percent_Bar_UI.paint");
Percent_Bar
	bar = (Percent_Bar)component;

//	Canvas.

Insets
	insets = component.getInsets ();
int
	canvas_width  = bar.getWidth () - insets.left - insets.right,
	canvas_height = bar.getHeight () - insets.top - insets.bottom;
if ((DEBUG & DEBUG_PAINT) != 0)
	System.out.println
		("     canvas_width = " + canvas_width + '\n'
		+"    canvas_height = " + canvas_height);

//	Set 0,0 at the upper-left corner of the bar.
graphics.translate (insets.left, insets.top);

//	Bar.
int
	x,
	y,
	width,
	height,
	orientation = bar.Orientation ();
if ((orientation & 1) == 0)
	{
	//	Horizontal orientation.
	width = (int)((bar.Percent () / 100.0) * canvas_width);
	height = canvas_height;
	y = 0;
	if (orientation == Percent_Bar.LEFT)
		x = 0;
	else
		x = canvas_width - width;
	}
else
	{
	//	Vertical orientation.
	height = (int)((bar.Percent () / 100.0) * canvas_height);
	width = canvas_width;
	x = 0;
	if (orientation == Percent_Bar.TOP)
		y = 0;
	else
		y = canvas_height - height;
	}
if ((DEBUG & DEBUG_PAINT) != 0)
	System.out.println
		("      orientation = " + orientation + '\n'
		+"          percent = " + bar.Percent () + '\n'
		+"                x = " + x + '\n'
		+"                y = " + y + '\n'
		+"            width = " + width + '\n'
		+"           height = " + height + '\n'
		+"       fore color = " + bar.getForeground () + '\n'
		+"       back color = " + bar.getBackground () + '\n'
		+"           opaque = " + bar.isOpaque ());
graphics.setColor (bar.getForeground ());
graphics.fillRect (x, y, width, height);

if (bar.isOpaque ())
	{
	//	Background.
	if ((orientation & 1) == 0)
		{
		if (x == 0)
			x = width;
		else
			x = 0;
		width = canvas_width - width;
		}
	else
		{
		if (y == 0)
			y = height;
		else
			y = 0;
		height = canvas_height - height;
		}
	graphics.setColor (bar.getBackground ());
	graphics.fillRect (x, y, width, height);
	}

//	Restore the graphics origin.
graphics.translate (-insets.left, -insets.top);
if ((DEBUG & DEBUG_PAINT) != 0)
	System.out.println ("<<< Percent_Bar_UI.paint");
}


}	//	End of Percent_Bar_UI class.
