/***************************************************************************
                          runonboot.c  -  description
                             -------------------
    begin                : Mar 13 1999
    copyright            : (C) 2000 by Gabriel Montenegro
    email                : johnpetrucci@users.sourceforge.net
 
 ***************************************************************************
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the Free Software            *
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,  *
 *  USA.                                                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>


#define VERSION "PPPStatus v0.4.2"

#define RC_PPPS "/etc/rc.PPPStatus"

int system(const char * string);

void usage(char *name)
{
   fprintf(stderr, "usage %s [-t] [-d]\n"
	   "  -t\t\tTTY to start " VERSION " on BOOT (1, 2, 3, ..., 12)\n"
	   "  -d\t\tLinux Distribution (slack, rh or debian)\n\n", name);
}

int main(int argc, char *argv[])
{
   FILE *fpa, *fpb;
   char init[64], buf[256], tty[] = "arg", conter[2];
   char command_line[80] = "/usr/local/bin/pppstatus";
   int exists = 0, rtrn = 0;
   int i, x, dist = 0, term = 0;

   fprintf(stdout, VERSION " BOOT INITIALIZER\n\n");
   if(argc < 3)
     {
	usage(argv[0]);
	exit(0);
     }
   for(i = 1; i < argc; i++){
      char *argumment = argv[i];
      if(*argumment == '-')
	switch(argumment[1]){
	 case 't':
	   if(!(argv[i+1])){
	      usage(argv[0]);
	      exit(0);
	   }
	   
	   for(x = 0; x != 13; x++)
	     {
		sprintf(conter, "%d", x);
		if(!strncmp(argv[i+1], conter, strlen(argv[i+1])))
		  {
		     sprintf(tty, "%s", argv[i+1]);
		     rtrn = 1;
		     break;
		  }
	     }
	   if(!rtrn)
	     {
		usage(argv[0]);
		exit(0);
	     }
	   term++;
	   break;
	 case 'd':
	   if(!argv[i+1]) {
	      usage(argv[0]);
	      exit(0);
	   }
	   if(!strncmp(argv[i+1], "slack", 5))
	     sprintf(init, "/etc/rc.d/rc.M");
	   else if(!strncmp(argv[i+1], "debian", 6))
	     sprintf(init, "/etc/init.d/rc.PPPStatus");
	   else if(!strncmp(argv[i+1], "rh", 2))
	     sprintf(init, "/etc/rc.d/rc.local");
	   else
	     {
	        usage(argv[0]);
		exit(0);
	     }
	   dist++;
	   break;
	 default: 
	   usage(argv[0]);
	   exit(0);
	}
   }
   if (!dist || !term)
     {
	usage(argv[0]);
	exit(0);
     }
   if((fpa = fopen(init, "a+")) == NULL || (fpb = fopen(RC_PPPS, "w")) == NULL) {
      fprintf(stderr, "Can't open file... \n"
	      "Maybe because you're not logged as root.\n"
	      "Exiting!\n\n");
      exit(0);
     }
   rewind(fpa);
   while(fgets(buf, sizeof(buf), fpa))
      if(strstr(buf, "rc.PPPStatus"))
	exists = 1;
   if(!exists)
     {
	fprintf(stdout, "Updating %s file...\n", init);
	fprintf(fpa, "\n# This will start PPPStatus at your\n"
	      "# machine boot...\n\n");
	fprintf(fpa, "if [ -x /etc/rc.PPPStatus ] ; then\n");
	fprintf(fpa, " . /etc/rc.PPPStatus start\n");
	fprintf(fpa, "fi\n");
	fclose(fpa);
     }
   else
     fprintf(stdout, "%s is already added in your %s file\n", RC_PPPS, init);
   
   fprintf(fpb, "#!/bin/sh\n"
	   "#\n"
	   "# /etc/rc.d/rc.PPPStatus initialization script.\n"
	   "#\n\n");
   fprintf(stdout, "Updating %s file...\n", RC_PPPS);
   strcat(command_line, " > /dev/tty");
   strcat(command_line, tty);
   strcat(command_line, " &\n");
   fprintf(fpb, command_line);
   fclose(fpb);
   chmod(RC_PPPS, 0755);
   if(!strcmp(init, "/etc/init.d/rc.PPPStatus"))
     {
        chmod(init, 0755);
        system("update-rc.d rc.PPPStatus defaults");
     }
   fprintf(stdout, "DONE!\n\nPPPStatus will start in your machine's boot on tty%d\n\n", atoi(tty));
   return(1);
}
