# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementNetworkSecurityPerimetersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeters_get(self, resource_group):
        response = self.client.network_security_perimeters.get(
            resource_group_name=resource_group.name,
            network_security_perimeter_name="str",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeters_create_or_update(self, resource_group):
        response = self.client.network_security_perimeters.create_or_update(
            resource_group_name=resource_group.name,
            network_security_perimeter_name="str",
            parameters={
                "location": "str",
                "id": "str",
                "name": "str",
                "perimeterGuid": "str",
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeters_begin_delete(self, resource_group):
        response = self.client.network_security_perimeters.begin_delete(
            resource_group_name=resource_group.name,
            network_security_perimeter_name="str",
            api_version="2024-10-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeters_patch(self, resource_group):
        response = self.client.network_security_perimeters.patch(
            resource_group_name=resource_group.name,
            network_security_perimeter_name="str",
            parameters={"id": "str", "tags": {"str": "str"}},
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeters_list_by_subscription(self, resource_group):
        response = self.client.network_security_perimeters.list_by_subscription(
            api_version="2024-10-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeters_list(self, resource_group):
        response = self.client.network_security_perimeters.list(
            resource_group_name=resource_group.name,
            api_version="2024-10-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
