// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{Pixbuf, ffi};
use glib::{prelude::*, translate::*};
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "GdkPixbufAnimation")]
    pub struct PixbufAnimation(Object<ffi::GdkPixbufAnimation, ffi::GdkPixbufAnimationClass>);

    match fn {
        type_ => || ffi::gdk_pixbuf_animation_get_type(),
    }
}

impl PixbufAnimation {
    pub const NONE: Option<&'static PixbufAnimation> = None;

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "gdk_pixbuf_animation_new_from_file")]
    #[doc(alias = "new_from_file")]
    pub fn from_file(
        filename: impl AsRef<std::path::Path>,
    ) -> Result<PixbufAnimation, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gdk_pixbuf_animation_new_from_file(
                filename.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "gdk_pixbuf_animation_new_from_resource")]
    #[doc(alias = "new_from_resource")]
    pub fn from_resource(resource_path: &str) -> Result<PixbufAnimation, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gdk_pixbuf_animation_new_from_resource(
                resource_path.to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "gdk_pixbuf_animation_new_from_stream")]
    #[doc(alias = "new_from_stream")]
    pub fn from_stream(
        stream: &impl IsA<gio::InputStream>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
    ) -> Result<PixbufAnimation, glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gdk_pixbuf_animation_new_from_stream(
                stream.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "gdk_pixbuf_animation_new_from_stream_async")]
    #[doc(alias = "new_from_stream_async")]
    pub fn from_stream_async<P: FnOnce(Result<PixbufAnimation, glib::Error>) + 'static>(
        stream: &impl IsA<gio::InputStream>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn from_stream_async_trampoline<
            P: FnOnce(Result<PixbufAnimation, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            unsafe {
                let mut error = std::ptr::null_mut();
                let ret = ffi::gdk_pixbuf_animation_new_from_stream_finish(res, &mut error);
                let result = if error.is_null() {
                    Ok(from_glib_full(ret))
                } else {
                    Err(from_glib_full(error))
                };
                let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                    Box_::from_raw(user_data as *mut _);
                let callback: P = callback.into_inner();
                callback(result);
            }
        }
        let callback = from_stream_async_trampoline::<P>;
        unsafe {
            ffi::gdk_pixbuf_animation_new_from_stream_async(
                stream.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]

    pub fn from_stream_future(
        stream: &(impl IsA<gio::InputStream> + Clone + 'static),
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<PixbufAnimation, glib::Error>> + 'static>>
    {
        let stream = stream.clone();
        Box_::pin(gio::GioFuture::new(&(), move |_obj, cancellable, send| {
            Self::from_stream_async(&stream, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }
}

pub trait PixbufAnimationExt: IsA<PixbufAnimation> + 'static {
    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "gdk_pixbuf_animation_get_height")]
    #[doc(alias = "get_height")]
    fn height(&self) -> i32 {
        unsafe { ffi::gdk_pixbuf_animation_get_height(self.as_ref().to_glib_none().0) }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "gdk_pixbuf_animation_get_static_image")]
    #[doc(alias = "get_static_image")]
    fn static_image(&self) -> Option<Pixbuf> {
        unsafe {
            from_glib_none(ffi::gdk_pixbuf_animation_get_static_image(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "gdk_pixbuf_animation_get_width")]
    #[doc(alias = "get_width")]
    fn width(&self) -> i32 {
        unsafe { ffi::gdk_pixbuf_animation_get_width(self.as_ref().to_glib_none().0) }
    }

    #[cfg_attr(feature = "v2_44", deprecated = "Since 2.44")]
    #[allow(deprecated)]
    #[doc(alias = "gdk_pixbuf_animation_is_static_image")]
    fn is_static_image(&self) -> bool {
        unsafe {
            from_glib(ffi::gdk_pixbuf_animation_is_static_image(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl<O: IsA<PixbufAnimation>> PixbufAnimationExt for O {}
