#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# South Scrimshaw, Part One
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250930.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='south-scrimshaw-part-1'
GAME_NAME='South Scrimshaw, Part One'

ARCHIVE_BASE_0_NAME='south_scrimshaw_part_one_1_0_66489.sh'
ARCHIVE_BASE_0_MD5='b68e7e8fa9491d38a55f007911b94da0'
ARCHIVE_BASE_0_SIZE='1694858'
ARCHIVE_BASE_0_VERSION='1.0-gog66489'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/south_scrimshaw_part_one'

CONTENT_PATH_DEFAULT='data/noarch/game/game'
CONTENT_GAME_MAIN_FILES='
cache
video
archive.rpa
script_version.txt'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICON='../SouthScrimshaw.exe'

## Easier upgrades from pre-20250930.1 packages.
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
south-scrimshaw-part-1-data"

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
