{-# OPTIONS_GHC -fno-warn-unused-binds -fno-warn-missing-signatures #-}
{-# LANGUAGE CPP,MagicHash #-}
{-# LINE 1 "HOpenPGP/Tools/Lexer.x" #-}

{-# OPTIONS -w #-}
module HOpenPGP.Tools.Lexer
( alexEOF
, alexSetInput
, alexGetInput
, alexError
, alexScan
, ignorePendingBytes
, alexGetStartCode
, runAlex
, Alex(..)
, Token(..)
, AlexReturn(..)
, AlexPosn(..)
) where

import Prelude hiding (lex)
import Numeric (readHex)
import Codec.Encryption.OpenPGP.Types (TwentyOctetFingerprint(..), EightOctetKeyId(..))


#if __GLASGOW_HASKELL__ >= 603
#include "ghcconfig.h"
#elif defined(__GLASGOW_HASKELL__)
#include "config.h"
#endif
#if __GLASGOW_HASKELL__ >= 503
import Data.Array
#else
import Array
#endif
#if __GLASGOW_HASKELL__ >= 503
import Data.Array.Base (unsafeAt)
import GHC.Exts
#else
import GlaExts
#endif
{-# LINE 1 "templates/wrappers.hs" #-}
-- -----------------------------------------------------------------------------
-- Alex wrapper code.
--
-- This code is in the PUBLIC DOMAIN; you may copy it freely and use
-- it for any purpose whatsoever.


import Control.Applicative as App (Applicative (..))


import Data.Word (Word8)
















import Data.Char (ord)
import qualified Data.Bits

-- | Encode a Haskell String to a list of Word8 values, in UTF8 format.
utf8Encode :: Char -> [Word8]
utf8Encode = uncurry (:) . utf8Encode'

utf8Encode' :: Char -> (Word8, [Word8])
utf8Encode' c = case go (ord c) of
                  (x, xs) -> (fromIntegral x, map fromIntegral xs)
 where
  go oc
   | oc <= 0x7f       = ( oc
                        , [
                        ])

   | oc <= 0x7ff      = ( 0xc0 + (oc `Data.Bits.shiftR` 6)
                        , [0x80 + oc Data.Bits..&. 0x3f
                        ])

   | oc <= 0xffff     = ( 0xe0 + (oc `Data.Bits.shiftR` 12)
                        , [0x80 + ((oc `Data.Bits.shiftR` 6) Data.Bits..&. 0x3f)
                        , 0x80 + oc Data.Bits..&. 0x3f
                        ])
   | otherwise        = ( 0xf0 + (oc `Data.Bits.shiftR` 18)
                        , [0x80 + ((oc `Data.Bits.shiftR` 12) Data.Bits..&. 0x3f)
                        , 0x80 + ((oc `Data.Bits.shiftR` 6) Data.Bits..&. 0x3f)
                        , 0x80 + oc Data.Bits..&. 0x3f
                        ])



type Byte = Word8

-- -----------------------------------------------------------------------------
-- The input type


type AlexInput = (AlexPosn,     -- current position,
                  Char,         -- previous char
                  [Byte],       -- pending bytes on current char
                  String)       -- current input string

ignorePendingBytes :: AlexInput -> AlexInput
ignorePendingBytes (p,c,_ps,s) = (p,c,[],s)

alexInputPrevChar :: AlexInput -> Char
alexInputPrevChar (_p,c,_bs,_s) = c

alexGetByte :: AlexInput -> Maybe (Byte,AlexInput)
alexGetByte (p,c,(b:bs),s) = Just (b,(p,c,bs,s))
alexGetByte (_,_,[],[]) = Nothing
alexGetByte (p,_,[],(c:s))  = let p' = alexMove p c
                              in case utf8Encode' c of
                                   (b, bs) -> p' `seq`  Just (b, (p', c, bs, s))





























































-- -----------------------------------------------------------------------------
-- Token positions

-- `Posn' records the location of a token in the input text.  It has three
-- fields: the address (number of chacaters preceding the token), line number
-- and column of a token within the file. `start_pos' gives the position of the
-- start of the file and `eof_pos' a standard encoding for the end of file.
-- `move_pos' calculates the new position after traversing a given character,
-- assuming the usual eight character tab stops.


data AlexPosn = AlexPn !Int !Int !Int
        deriving (Eq,Show)

alexStartPos :: AlexPosn
alexStartPos = AlexPn 0 1 1

alexMove :: AlexPosn -> Char -> AlexPosn
alexMove (AlexPn a l c) '\t' = AlexPn (a+1)  l     (c+alex_tab_size-((c-1) `mod` alex_tab_size))
alexMove (AlexPn a l _) '\n' = AlexPn (a+1) (l+1)   1
alexMove (AlexPn a l c) _    = AlexPn (a+1)  l     (c+1)


-- -----------------------------------------------------------------------------
-- Monad (default and with ByteString input)


data AlexState = AlexState {
        alex_pos :: !AlexPosn,  -- position at current input location

        alex_inp :: String,     -- the current input
        alex_chr :: !Char,      -- the character before the input
        alex_bytes :: [Byte],





        alex_scd :: !Int        -- the current startcode



    }

-- Compile with -funbox-strict-fields for best results!


runAlex :: String -> Alex a -> Either String a
runAlex input__ (Alex f)
   = case f (AlexState {alex_bytes = [],





                        alex_pos = alexStartPos,
                        alex_inp = input__,
                        alex_chr = '\n',



                        alex_scd = 0}) of Left msg -> Left msg
                                          Right ( _, a ) -> Right a

newtype Alex a = Alex { unAlex :: AlexState -> Either String (AlexState, a) }

instance Functor Alex where
  fmap f a = Alex $ \s -> case unAlex a s of
                            Left msg -> Left msg
                            Right (s', a') -> Right (s', f a')

instance Applicative Alex where
  pure a   = Alex $ \s -> Right (s, a)
  fa <*> a = Alex $ \s -> case unAlex fa s of
                            Left msg -> Left msg
                            Right (s', f) -> case unAlex a s' of
                                               Left msg -> Left msg
                                               Right (s'', b) -> Right (s'', f b)

instance Monad Alex where
  m >>= k  = Alex $ \s -> case unAlex m s of
                                Left msg -> Left msg
                                Right (s',a) -> unAlex (k a) s'
  return = App.pure

alexGetInput :: Alex AlexInput
alexGetInput

 = Alex $ \s@AlexState{alex_pos=pos,alex_chr=c,alex_bytes=bs,alex_inp=inp__} ->
        Right (s, (pos,c,bs,inp__))





alexSetInput :: AlexInput -> Alex ()

alexSetInput (pos,c,bs,inp__)
 = Alex $ \s -> case s{alex_pos=pos,alex_chr=c,alex_bytes=bs,alex_inp=inp__} of







                  state__@(AlexState{}) -> Right (state__, ())

alexError :: String -> Alex a
alexError message = Alex $ const $ Left message

alexGetStartCode :: Alex Int
alexGetStartCode = Alex $ \s@AlexState{alex_scd=sc} -> Right (s, sc)

alexSetStartCode :: Int -> Alex ()
alexSetStartCode sc = Alex $ \s -> Right (s{alex_scd=sc}, ())









alexMonadScan = do

  inp__ <- alexGetInput



  sc <- alexGetStartCode
  case alexScan inp__ sc of
    AlexEOF -> alexEOF
    AlexError ((AlexPn _ line column),_,_,_) -> alexError $ "lexical error at line " ++ (show line) ++ ", column " ++ (show column)
    AlexSkip  inp__' _len -> do
        alexSetInput inp__'
        alexMonadScan

    AlexToken inp__' len action -> do



        alexSetInput inp__'
        action (ignorePendingBytes inp__) len

-- -----------------------------------------------------------------------------
-- Useful token actions


type AlexAction result = AlexInput -> Int -> Alex result




-- just ignore this token and scan another one
-- skip :: AlexAction result
skip _input _len = alexMonadScan

-- ignore this token, but set the start code to a new value
-- begin :: Int -> AlexAction result
begin code _input _len = do alexSetStartCode code; alexMonadScan

-- perform an action for this token, and set the start code to a new value
andBegin :: AlexAction result -> Int -> AlexAction result
(action `andBegin` code) input__ len = do
  alexSetStartCode code
  action input__ len


token :: (AlexInput -> Int -> token) -> AlexAction token



token t input__ len = return (t input__ len)



-- -----------------------------------------------------------------------------
-- Basic wrapper
























-- -----------------------------------------------------------------------------
-- Basic wrapper, ByteString version
































-- -----------------------------------------------------------------------------
-- Posn wrapper

-- Adds text positions to the basic model.













-- -----------------------------------------------------------------------------
-- Posn wrapper, ByteString version














-- -----------------------------------------------------------------------------
-- GScan wrapper

-- For compatibility with previous versions of Alex, and because we can.














alex_tab_size :: Int
alex_tab_size = 8
alex_base :: AlexAddr
alex_base = AlexA#
  "\xf8\xff\xff\xff\x8d\xff\xff\xff\xa2\xff\xff\xff\x8f\xff\xff\xff\xa3\xff\xff\xff\x96\xff\xff\xff\x98\xff\xff\xff\xa7\xff\xff\xff\x9e\xff\xff\xff\x9f\xff\xff\xff\xa0\xff\xff\xff\xd1\xff\xff\xff\xd2\xff\xff\xff\xd6\xff\xff\xff\x97\xff\xff\xff\xac\xff\xff\xff\xad\xff\xff\xff\xae\xff\xff\xff\x9d\xff\xff\xff\xb2\xff\xff\xff\xb4\xff\xff\xff\xb5\xff\xff\xff\xb6\xff\xff\xff\xe9\xff\xff\xff\xf1\xff\xff\xff\xc5\xff\xff\xff\xba\xff\xff\xff\xc0\xff\xff\xff\xb8\xff\xff\xff\xdc\xff\xff\xff\xe5\xff\xff\xff\xd3\xff\xff\xff\xd5\xff\xff\xff\xe0\xff\xff\xff\xe2\xff\xff\xff\xe8\xff\xff\xff\x0e\x00\x00\x00\xef\xff\xff\xff\xea\xff\xff\xff\xeb\xff\xff\xff\xec\xff\xff\xff\xed\xff\xff\xff\xf9\xff\xff\xff\x05\x00\x00\x00\x06\x00\x00\x00\x11\x00\x00\x00\x23\x00\x00\x00\x38\x00\x00\x00\x03\x00\x00\x00\x1f\x00\x00\x00\x07\x00\x00\x00\x10\x00\x00\x00\x08\x00\x00\x00\x15\x00\x00\x00\x0f\x00\x00\x00\x12\x00\x00\x00\x13\x00\x00\x00\x01\x00\x00\x00\x0c\x00\x00\x00\x1c\x00\x00\x00\x19\x00\x00\x00\x14\x00\x00\x00\x1a\x00\x00\x00\x1b\x00\x00\x00\x1d\x00\x00\x00\x20\x00\x00\x00\x31\x00\x00\x00\x33\x00\x00\x00\x3c\x00\x00\x00\x36\x00\x00\x00\x37\x00\x00\x00\x39\x00\x00\x00\x3a\x00\x00\x00\x5a\x00\x00\x00\x45\x00\x00\x00\x26\x00\x00\x00\x29\x00\x00\x00\x32\x00\x00\x00\x2b\x00\x00\x00\x1e\x00\x00\x00\x2c\x00\x00\x00\x2f\x00\x00\x00\x21\x00\x00\x00\x3b\x00\x00\x00\x25\x00\x00\x00\x27\x00\x00\x00\xee\x00\x00\x00\xef\x00\x00\x00\xf0\x00\x00\x00\xf1\x00\x00\x00\x3d\x00\x00\x00\xf2\x00\x00\x00\xf3\x00\x00\x00\xf4\x00\x00\x00\xf5\x00\x00\x00\x34\x00\x00\x00\x3e\x00\x00\x00\xf8\x00\x00\x00\x43\x00\x00\x00\xe6\x00\x00\x00\x44\x00\x00\x00\xcc\x00\x00\x00\x9b\x01\x00\x00\x9c\x01\x00\x00\xe9\x00\x00\x00\xf6\x00\x00\x00\x3f\x00\x00\x00\x40\x00\x00\x00\x41\x00\x00\x00\xd5\x00\x00\x00\x2a\x00\x00\x00\x2e\x00\x00\x00\x30\x00\x00\x00\xce\x00\x00\x00\xf7\x00\x00\x00\xd7\x00\x00\x00\xcb\x00\x00\x00\xda\x00\x00\x00\xdb\x00\x00\x00\xcf\x00\x00\x00\xe0\x00\x00\x00\xdc\x00\x00\x00\xe2\x00\x00\x00\xdd\x00\x00\x00\xde\x00\x00\x00\x99\x01\x00\x00\xdf\x00\x00\x00\xe1\x00\x00\x00\xe3\x00\x00\x00\xe8\x00\x00\x00\xa4\x01\x00\x00\xf9\x00\x00\x00\xe4\x00\x00\x00\xea\x00\x00\x00\xeb\x00\x00\x00\xec\x00\x00\x00\xd8\x00\x00\x00\xfa\x00\x00\x00\x28\x00\x00\x00\xed\x00\x00\x00\xfb\x00\x00\x00\x81\x01\x00\x00\x82\x01\x00\x00\xfe\x00\x00\x00\xfc\x00\x00\x00\x79\x01\x00\x00\x01\x01\x00\x00\x8c\x01\x00\x00\x8d\x01\x00\x00\x7c\x01\x00\x00\x89\x01\x00\x00\x88\x01\x00\x00\x8a\x01\x00\x00\x8b\x01\x00\x00\x8f\x01\x00\x00\x92\x01\x00\x00\x93\x01\x00\x00\x94\x01\x00\x00\x96\x01\x00\x00\x8e\x01\x00\x00\x95\x01\x00\x00\x85\x01\x00\x00\x98\x01\x00\x00\x90\x01\x00\x00\x9d\x01\x00\x00\xa0\x01\x00\x00\x91\x01\x00\x00\x97\x01\x00\x00\x9a\x01\x00\x00\x9e\x01\x00\x00\x9f\x01\x00\x00\xa7\x01\x00\x00\xac\x01\x00\x00\xad\x01\x00\x00\xaf\x01\x00\x00\xb0\x01\x00\x00\xb1\x01\x00\x00\xae\x01\x00\x00\xb7\x01\x00\x00\xb2\x01\x00\x00\xa1\x01\x00\x00\xa3\x01\x00\x00\xb3\x01\x00\x00\xb8\x01\x00\x00\xa2\x01\x00\x00\xb4\x01\x00\x00\xe7\x00\x00\x00\xb5\x01\x00\x00\xbe\x01\x00\x00\xb6\x01\x00\x00\xb9\x01\x00\x00\xba\x01\x00\x00\xbb\x01\x00\x00\xc1\x01\x00\x00\xc2\x01\x00\x00\xce\x01\x00\x00\xd1\x01\x00\x00\xbc\x01\x00\x00\xbf\x01\x00\x00\xbd\x01\x00\x00\xc0\x01\x00\x00\xc3\x01\x00\x00\xe4\x01\x00\x00\xe5\x01\x00\x00\xc4\x01\x00\x00\xc6\x01\x00\x00\xc9\x01\x00\x00\xc7\x01\x00\x00\xca\x01\x00\x00\xc8\x01\x00\x00\xd2\x01\x00\x00\xcf\x01\x00\x00\xd3\x01\x00\x00\xcb\x01\x00\x00\xd8\x01\x00\x00\xd0\x01\x00\x00\xd5\x01\x00\x00\xd6\x01\x00\x00\xd7\x01\x00\x00\xc5\x01\x00\x00\xcc\x01\x00\x00\xda\x01\x00\x00\xd4\x01\x00\x00\xdb\x01\x00\x00\xd9\x01\x00\x00\xe0\x01\x00\x00\xe1\x01\x00\x00\xe2\x01\x00\x00\xe3\x01\x00\x00\xe6\x01\x00\x00\xe7\x01\x00\x00\xea\x01\x00\x00\xeb\x01\x00\x00\xe8\x01\x00\x00\xee\x01\x00\x00\xf3\x01\x00\x00\xec\x01\x00\x00\xed\x01\x00\x00\xde\x01\x00\x00\x00\x00\x00\x00\xdc\x01\x00\x00\x88\x02\x00\x00\xef\x01\x00\x00\xdf\x01\x00\x00\xf2\x01\x00\x00\x99\x02\x00\x00\xf4\x01\x00\x00\xf5\x01\x00\x00\xf7\x01\x00\x00\xf8\x01\x00\x00\xf0\x01\x00\x00\x8a\x02\x00\x00\xf9\x01\x00\x00\x9c\x02\x00\x00\x9d\x02\x00\x00\xfb\x01\x00\x00\x00\x00\x00\x00\x55\x02\x00\x00\x9a\x02\x00\x00\x0d\x03\x00\x00\xf6\x01\x00\x00\xfc\x01\x00\x00\xfd\x01\x00\x00\x83\x03\x00\x00\x43\x03\x00\x00\x00\x00\x00\x00\x73\x02\x00\x00\x6f\x02\x00\x00\x6a\x02\x00\x00\xa1\x02\x00\x00\x32\x02\x00\x00\xfe\x01\x00\x00\xa2\x02\x00\x00\x75\x02\x00\x00\x76\x02\x00\x00\x77\x02\x00\x00\x78\x02\x00\x00\x7d\x02\x00\x00\x7a\x02\x00\x00\x7c\x02\x00\x00\x7f\x02\x00\x00\x85\x02\x00\x00\x89\x02\x00\x00\x82\x02\x00\x00\x39\x04\x00\x00\x14\x04\x00\x00\x92\x02\x00\x00\x83\x02\x00\x00\x8b\x02\x00\x00\x90\x02\x00\x00\xc5\x02\x00\x00\xc8\x02\x00\x00\xcd\x02\x00\x00\xce\x02\x00\x00\xd7\x02\x00\x00\x94\x02\x00\x00\x95\x02\x00\x00\x9e\x02\x00\x00\xe2\x02\x00\x00\xe3\x02\x00\x00\xec\x02\x00\x00\xeb\x02\x00\x00\xed\x02\x00\x00\xf4\x02\x00\x00\xe8\x02\x00\x00\xf9\x02\x00\x00\x5e\x03\x00\x00\x2c\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09\x05\x00\x00\x20\x05\x00\x00\x46\x05\x00\x00\x5d\x05\x00\x00\x83\x05\x00\x00\x9a\x05\x00\x00\xc0\x05\x00\x00\xd7\x05\x00\x00\xfd\x05\x00\x00\x14\x06\x00\x00\x3a\x06\x00\x00\x51\x06\x00\x00\x77\x06\x00\x00\x8e\x06\x00\x00\xb4\x06\x00\x00\xcb\x06\x00\x00\xf1\x06\x00\x00\x09\x07\x00\x00\x2f\x07\x00\x00\x46\x07\x00\x00\x6c\x07\x00\x00\x83\x07\x00\x00\xa9\x07\x00\x00\xc0\x07\x00\x00\xe6\x07\x00\x00\xfd\x07\x00\x00\x23\x08\x00\x00\x3a\x08\x00\x00\x60\x08\x00\x00\x77\x08\x00\x00\x9d\x08\x00\x00\xb4\x08\x00\x00\xda\x08\x00\x00\xf1\x08\x00\x00\x17\x09\x00\x00\x2e\x09\x00\x00\x54\x09\x00\x00\x6b\x09\x00\x00\x91\x09\x00\x00\xa8\x09\x00\x00\xce\x09\x00\x00\xe5\x09\x00\x00\x0b\x0a\x00\x00\x22\x0a\x00\x00\x48\x0a\x00\x00\x5f\x0a\x00\x00\x85\x0a\x00\x00\x9c\x0a\x00\x00\xe3\x0a\x00\x00\xfa\x0a\x00\x00\x20\x0b\x00\x00\x37\x0b\x00\x00\x5d\x0b\x00\x00\x74\x0b\x00\x00\x9a\x0b\x00\x00\xb1\x0b\x00\x00\xd7\x0b\x00\x00\xee\x0b\x00\x00\x28\x0c\x00\x00\x3f\x0c\x00\x00\x76\x0c\x00\x00\x8d\x0c\x00\x00\xb3\x0c\x00\x00\xca\x0c\x00\x00\xf0\x0c\x00\x00\x16\x0d\x00\x00\x2d\x0d\x00\x00\x64\x0d\x00\x00\x7b\x0d\x00\x00\xa1\x0d\x00\x00\xb8\x0d\x00\x00\xde\x0d\x00\x00\xf5\x0d\x00\x00\x1b\x0e\x00\x00\x32\x0e\x00\x00\x58\x0e\x00\x00\x6f\x0e\x00\x00\x95\x0e\x00\x00\xac\x0e\x00\x00\xd2\x0e\x00\x00\xe9\x0e\x00\x00\x0f\x0f\x00\x00\x26\x0f\x00\x00\x4c\x0f\x00\x00\x63\x0f\x00\x00\x89\x0f\x00\x00\xa0\x0f\x00\x00\xc6\x0f\x00\x00\xdd\x0f\x00\x00\x03\x10\x00\x00\x1a\x10\x00\x00\x40\x10\x00\x00\x57\x10\x00\x00\x7d\x10\x00\x00\x94\x10\x00\x00\xcd\x10\x00\x00\xe6\x10\x00\x00\x1d\x11\x00\x00\x34\x11\x00\x00\x5a\x11\x00\x00\x71\x11\x00\x00\x97\x11\x00\x00\xae\x11\x00\x00\xd4\x11\x00\x00\xeb\x11\x00\x00\x11\x12\x00\x00\x28\x12\x00\x00\x4e\x12\x00\x00\x65\x12\x00\x00\x8b\x12\x00\x00\xa2\x12\x00\x00\xc8\x12\x00\x00\xdf\x12\x00\x00\x05\x13\x00\x00\x1c\x13\x00\x00\x42\x13\x00\x00\x59\x13\x00\x00\x7f\x13\x00\x00\x96\x13\x00\x00\xbc\x13\x00\x00\xd3\x13\x00\x00\xf9\x13\x00\x00\x10\x14\x00\x00\x36\x14\x00\x00\x4d\x14\x00\x00\x73\x14\x00\x00\x8a\x14\x00\x00\xb0\x14\x00\x00\xc7\x14\x00\x00\xed\x14\x00\x00\x04\x15\x00\x00\x2a\x15\x00\x00\x41\x15\x00\x00\x67\x15\x00\x00\x7e\x15\x00\x00\x71\x15\x00\x00"#

alex_table :: AlexAddr
alex_table = AlexA#
  "\x00\x00\x32\x01\x32\x01\x32\x01\x32\x01\x32\x01\x36\x01\x39\x01\x3b\x01\x40\x01\x3c\x01\x45\x01\x48\x01\x49\x01\x4a\x01\x4b\x01\x52\x01\x54\x01\x4c\x01\x4d\x01\x59\x01\x5a\x01\x5b\x01\x4f\x01\x32\x01\x5c\x01\x1c\x01\x5d\x01\x5e\x01\x5f\x01\x60\x01\x68\x01\x43\x01\x44\x01\x61\x01\x2e\x00\x0e\x01\x6d\x01\x2f\x00\x30\x01\x7e\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x7d\x01\x4c\x01\x4d\x01\x41\x01\x3f\x01\x42\x01\x4f\x01\x67\x01\xab\x01\xa7\x01\xa9\x01\xcc\x01\x9c\x01\xab\x01\xa0\x00\x85\x00\x03\x00\x2e\x01\xb7\x00\x2d\x01\x10\x01\x04\x00\x08\x00\x66\x00\x09\x00\x24\x00\x03\x01\xab\x00\x4a\x00\x8b\x00\x0a\x00\x2c\x01\x12\x00\x18\x00\x10\x00\x11\x00\x22\x01\x13\x00\xd6\x00\x25\x01\x33\x01\xa7\x01\xa8\x01\xcc\x01\x9d\x01\xaa\x01\xa0\x00\x85\x00\x0b\x00\x14\x00\x62\x00\x73\x00\x10\x01\x1c\x00\x2f\x01\x67\x00\x23\x01\x24\x00\x02\x01\x1e\x00\x4a\x00\x15\x00\x16\x00\x20\x01\xae\x00\x18\x00\x1d\x00\x1b\x00\x1b\x01\x1a\x01\xd6\x00\x19\x01\x25\x00\x18\x01\x1f\x00\x20\x00\x17\x01\x16\x01\x14\x01\x13\x01\x0b\x00\x12\x01\x15\x01\x26\x00\x11\x01\x27\x00\x28\x00\x1e\x01\x29\x00\x2a\x00\x0f\x01\x2b\x00\x2c\x00\x0d\x01\x0c\x01\x0b\x01\xae\x00\x4b\x00\x30\x00\x0a\x01\x32\x00\x35\x00\x31\x00\x37\x00\xf9\x00\x38\x00\x42\x00\x36\x00\xf8\x00\x3a\x00\xf7\x00\xfa\x00\x7d\x00\x5c\x00\x5b\x00\x26\x00\x43\x00\x27\x00\x28\x00\x4f\x00\x29\x00\x2a\x00\xfd\x00\x2b\x00\x2c\x00\x0d\x01\x07\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x06\x01\x06\x01\x05\x01\x04\x01\xfe\x00\x58\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x44\x00\x5e\x00\xf6\x00\xf4\x00\x5a\x00\xf3\x00\xed\x00\xec\x00\xea\x00\xeb\x00\xe9\x00\xf5\x00\x6b\x00\xe8\x00\xe7\x00\x6e\x00\x71\x00\x6f\x00\x77\x00\x70\x00\x7a\x00\x78\x00\x06\x01\x06\x01\x05\x01\x04\x01\xe4\x00\x58\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x44\x00\x83\x00\xe1\x00\xbe\x00\x5a\x00\x74\x00\xde\x00\xdf\x00\xdd\x00\xda\x00\xe0\x00\xf5\x00\x75\x00\x51\x00\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x56\x00\x56\x00\xe6\x00\x72\x00\x84\x00\x86\x00\x87\x00\xd9\x00\xd8\x00\xd7\x00\x8c\x00\xd5\x00\x92\x00\xd4\x00\xd3\x00\x93\x00\x94\x00\xd1\x00\x97\x00\x95\x00\xcf\x00\xcd\x00\x9e\x00\xd0\x00\x9d\x00\x9a\x00\xce\x00\xce\x00\xad\x00\xbf\x00\xa2\x00\xb3\x00\x56\x00\x57\x00\xe6\x00\x72\x00\xa1\x00\xa1\x00\x9b\x00\xbb\x00\xbb\x00\x9c\x00\xa6\x00\xa8\x00\xa9\x00\xcb\x00\xc9\x00\xc8\x00\xc7\x00\xca\x00\xc1\x00\xac\x00\xb2\x00\xc5\x00\xc4\x00\xb5\x00\xb9\x00\xbd\x00\xb0\x00\xb8\x00\xad\x00\xae\x00\xb1\x00\xb3\x00\x99\x00\x98\x00\x82\x00\x7c\x00\xba\x00\xb6\x00\xb4\x00\x00\x00\xaa\x00\xc3\x00\x7b\x00\xa7\x00\x96\x00\xa5\x00\x26\x01\x90\x00\xa4\x00\xaf\x00\x8e\x00\xa3\x00\xd2\x00\x91\x00\x8d\x00\xdb\x00\x8a\x00\x89\x00\xb0\x00\xdc\x00\xe2\x00\xae\x00\x81\x00\x6a\x00\x99\x00\x98\x00\x82\x00\x80\x00\x7f\x00\x7e\x00\x79\x00\xe5\x00\x6c\x00\x6d\x00\xee\x00\xf1\x00\x53\x00\x4d\x00\x5d\x00\x61\x00\xf2\x00\xaf\x00\x60\x00\x5f\x00\xfb\x00\x59\x00\x3d\x00\x34\x00\x55\x00\x54\x00\x4c\x00\x4e\x00\x23\x00\x47\x00\x48\x00\x46\x00\x45\x00\x3b\x00\x22\x00\x21\x00\x24\x01\x01\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x50\x00\x49\x00\x3c\x00\xc6\x00\xc6\x00\x1f\x01\x2d\x00\x21\x01\x1a\x00\x19\x00\x17\x00\x27\x01\x28\x01\x29\x01\x2a\x01\x0f\x00\x68\x00\x68\x00\x0e\x00\x07\x00\x39\x00\x39\x00\x2b\x01\x06\x00\x01\x00\x05\x00\x6c\x01\x6b\x01\x69\x01\x66\x01\x65\x01\x6a\x01\x50\x00\x49\x00\x3c\x00\xc6\x00\xc6\x00\x64\x01\x2d\x00\x65\x00\x63\x01\x19\x00\x17\x00\x62\x01\x58\x01\x57\x01\xbc\x00\xbc\x00\x68\x00\x68\x00\x8f\x00\xff\x00\x39\x00\x39\x00\x56\x01\x76\x00\x08\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2d\x00\x55\x01\x53\x01\x4e\x01\x47\x01\x3d\x01\x46\x01\x37\x01\x34\x01\x3e\x01\x38\x01\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x3a\x01\x32\x01\x32\x01\x32\x01\x32\x01\x32\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x35\x01\x00\x00\x00\x00\x2d\x00\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x32\x01\x00\x00\x00\x00\x8f\x00\xc2\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x00\x00\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xf5\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x2c\x00\x00\x00\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xd7\x01\xaf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x01\xaf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x07\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x08\x01\x51\x00\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x01\x01\x63\x00\xef\x00\xef\x00\xef\x00\xf0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x00\x00\x00\x00\x00\x00\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\x00\x00\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x00\x00\x00\x00\x00\x00\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x75\x01\x00\x00\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\x00\x00\x00\x00\x00\x00\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x9f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x74\x01\x00\x00\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\xcf\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x76\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\x00\x00\x00\x00\x00\x00\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x77\x01\x00\x00\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x78\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x79\x01\x00\x00\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x7a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\x00\x00\x00\x00\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x7b\x01\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x7c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x00\x00\x00\x00\x00\x00\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x7f\x01\x00\x00\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x80\x01\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x81\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x82\x01\x1d\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x83\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\x00\x00\x00\x00\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x84\x01\x00\x00\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x85\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\x00\x00\x00\x00\x00\x00\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x86\x01\x00\x00\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x87\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\x00\x00\x00\x00\x00\x00\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x88\x01\x00\x00\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x89\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\x00\x00\x00\x00\x00\x00\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x8a\x01\x00\x00\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x8b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\x00\x00\x00\x00\x00\x00\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x8c\x01\x00\x00\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x8d\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\x00\x00\x00\x00\x00\x00\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x8e\x01\x00\x00\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\x8f\x01\x8f\x01\x8f\x01\x8f\x01\x8f\x01\x8f\x01\x8f\x01\x8f\x01\x8f\x01\x8f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\x00\x00\x00\x00\x00\x00\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x01\x90\x01\x90\x01\x90\x01\x90\x01\x90\x01\x90\x01\x90\x01\x90\x01\x90\x01\x00\x00\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x91\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\x00\x00\x00\x00\x00\x00\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x92\x01\x00\x00\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x93\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\x00\x00\x00\x00\x00\x00\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x94\x01\x00\x00\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x95\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\x00\x00\x00\x00\x00\x00\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x96\x01\x00\x00\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x97\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\x00\x00\x00\x00\x00\x00\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x98\x01\x00\x00\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x99\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\x00\x00\x00\x00\x00\x00\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x01\x9a\x01\x9a\x01\x9a\x01\x9a\x01\x9a\x01\x9a\x01\x9a\x01\x9a\x01\x9a\x01\x00\x00\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\x9b\x01\x9b\x01\x9b\x01\x9b\x01\x9b\x01\x9b\x01\x9b\x01\x9b\x01\x9b\x01\x9b\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\x00\x00\x00\x00\x00\x00\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x72\x01\x00\x00\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x6f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x00\x00\x00\x00\x00\x00\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\xae\x01\xae\x01\xc9\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xc9\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xc9\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xc9\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x69\x00\x00\x00\x00\x00\x00\x00\x00\x00\x52\x00\x00\x00\x00\x00\x00\x00\x00\x00\x33\x00\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\x00\x00\x00\x00\x00\x00\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x9e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa0\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\x00\x00\x00\x00\x00\x00\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\xa1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\x00\x00\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa2\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\x00\x00\x00\x00\x00\x00\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\xa3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\x00\x00\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa4\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\x00\x00\x00\x00\x00\x00\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\xa5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\x00\x00\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xa6\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\xac\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\xfc\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\xad\x01\xae\x01\xae\x01\xae\x01\xaf\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xad\x01\xae\x01\xae\x01\xae\x01\xaf\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\xcc\x00\x00\x00\x00\x00\x00\x00\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\x00\x00\x00\x00\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\xb0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\x00\x00\x88\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\x00\x00\x00\x00\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb2\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\x00\x00\x00\x00\x00\x00\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\x00\x00\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb4\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\x00\x00\x00\x00\x00\x00\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\xb5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\x00\x00\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb6\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\x00\x00\x00\x00\x00\x00\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\xb7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\x00\x00\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb8\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\x00\x00\x00\x00\x00\x00\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\xb9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\x00\x00\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xba\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\x00\x00\x00\x00\x00\x00\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\xbb\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\x00\x00\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbc\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\x00\x00\x00\x00\x00\x00\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\xbd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\x00\x00\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbe\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\x00\x00\x00\x00\x00\x00\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\xbf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\x00\x00\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc0\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\x00\x00\x00\x00\x00\x00\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\xc1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\x00\x00\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc2\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\x00\x00\x00\x00\x00\x00\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\xc3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\x00\x00\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc4\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\x00\x00\x00\x00\x00\x00\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\xc5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\x00\x00\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc6\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\x00\x00\x00\x00\x00\x00\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\xc7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\x00\x00\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xc8\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\x00\x00\x00\x00\x00\x00\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\xca\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\xb1\x01\x00\x00\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xcb\x01\xb1\x01\xb1\x01\xb1\x01\xcd\x01\xb1\x01\xb1\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x00\x00\x00\x00\x00\x00\xb1\x01\xb1\x01\xb1\x01\xcd\x01\xb1\x01\xb1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x00\x00\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x71\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x51\x01\x00\x00\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x6e\x01\x00\x00\x00\x00\x00\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\xae\x01\x00\x00\x51\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x0c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x00\x00\x50\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\x00\x00\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\xb3\x01\x00\x00\x50\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xce\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\x00\x00\x00\x00\x00\x00\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\xd0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\x00\x00\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd1\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\x00\x00\x00\x00\x00\x00\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\xd2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\x00\x00\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd3\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\x00\x00\x00\x00\x00\x00\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\xd4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\x00\x00\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd5\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\x00\x00\x00\x00\x00\x00\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\xd6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\x00\x00\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd8\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\x00\x00\x00\x00\x00\x00\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\xd9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\x00\x00\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xda\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\x00\x00\x00\x00\x00\x00\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\xdb\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\x00\x00\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdc\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\x00\x00\x00\x00\x00\x00\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\xdd\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\x00\x00\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xde\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\x00\x00\x00\x00\x00\x00\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\xdf\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\x00\x00\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe0\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\x00\x00\x00\x00\x00\x00\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\xe1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\x00\x00\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe2\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\x00\x00\x00\x00\x00\x00\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\xe3\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\x00\x00\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe4\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\x00\x00\x00\x00\x00\x00\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\xe5\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\x00\x00\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe6\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\x00\x00\x00\x00\x00\x00\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\xe7\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\x00\x00\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe8\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\x00\x00\x00\x00\x00\x00\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\xe9\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\x00\x00\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\xea\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\x00\x00\x00\x00\x00\x00\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\xeb\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\x00\x00\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\xec\x01\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\x00\x00\x00\x00\x00\x00\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\xed\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\x00\x00\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\xee\x01\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\x00\x00\x00\x00\x00\x00\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\xef\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\x00\x00\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf0\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\x00\x00\x00\x00\x00\x00\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\xf1\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\x00\x00\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf2\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\x00\x00\x00\x00\x00\x00\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\xf3\x01\x00\x00\x00\x00\xf5\x01\x00\x00\x00\x00\x00\x00\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x00\x00\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\xf4\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x00\x00\x00\x00\x00\x00\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x73\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x70\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x07\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x09\x01\x08\x01\x51\x00\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x01\x01\x63\x00\xef\x00\xef\x00\xef\x00\xf0\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

alex_check :: AlexAddr
alex_check = AlexA#
  "\xff\xff\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x79\x00\x65\x00\x79\x00\x73\x00\x67\x00\x73\x00\x65\x00\x6f\x00\x6f\x00\x6f\x00\x79\x00\x65\x00\x41\x00\x41\x00\x67\x00\x67\x00\x79\x00\x41\x00\x20\x00\x67\x00\x22\x00\x67\x00\x67\x00\x67\x00\x35\x00\x65\x00\x28\x00\x29\x00\x31\x00\x32\x00\x33\x00\x65\x00\x35\x00\x6f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x61\x00\x61\x00\x3c\x00\x3d\x00\x3e\x00\x61\x00\x73\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x65\x00\x6f\x00\x4b\x00\x6f\x00\x4d\x00\x61\x00\x67\x00\x50\x00\x67\x00\x52\x00\x53\x00\x54\x00\x55\x00\x69\x00\x67\x00\x61\x00\x65\x00\x41\x00\x69\x00\x69\x00\x32\x00\x69\x00\x49\x00\x35\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x53\x00\x69\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x31\x00\x72\x00\x73\x00\x74\x00\x75\x00\x69\x00\x69\x00\x6d\x00\x52\x00\x61\x00\x6b\x00\x6d\x00\x65\x00\x61\x00\x69\x00\x69\x00\x6d\x00\x79\x00\x69\x00\x69\x00\x61\x00\x65\x00\x65\x00\x65\x00\x73\x00\x65\x00\x6f\x00\x53\x00\x65\x00\x53\x00\x4b\x00\x69\x00\x53\x00\x53\x00\x31\x00\x53\x00\x53\x00\x49\x00\x69\x00\x67\x00\x72\x00\x73\x00\x61\x00\x69\x00\x69\x00\x75\x00\x79\x00\x73\x00\x6f\x00\x73\x00\x67\x00\x61\x00\x6f\x00\x61\x00\x6f\x00\x61\x00\x79\x00\x61\x00\x63\x00\x73\x00\x67\x00\x73\x00\x6b\x00\x65\x00\x73\x00\x73\x00\x67\x00\x73\x00\x73\x00\x69\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x41\x00\x41\x00\x41\x00\x41\x00\x67\x00\x4b\x00\x43\x00\x43\x00\x43\x00\x43\x00\x41\x00\x65\x00\x6d\x00\x65\x00\x47\x00\x73\x00\x65\x00\x65\x00\x61\x00\x73\x00\x61\x00\x4d\x00\x69\x00\x69\x00\x69\x00\x69\x00\x61\x00\x69\x00\x61\x00\x69\x00\x75\x00\x63\x00\x61\x00\x61\x00\x61\x00\x61\x00\x6f\x00\x6b\x00\x63\x00\x63\x00\x63\x00\x63\x00\x61\x00\x6d\x00\x6f\x00\x75\x00\x67\x00\x65\x00\x61\x00\x65\x00\x65\x00\x61\x00\x69\x00\x6d\x00\x76\x00\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x4b\x00\x4b\x00\x4f\x00\x45\x00\x69\x00\x69\x00\x73\x00\x61\x00\x61\x00\x73\x00\x67\x00\x69\x00\x63\x00\x69\x00\x69\x00\x63\x00\x63\x00\x61\x00\x73\x00\x65\x00\x65\x00\x63\x00\x65\x00\x6f\x00\x6d\x00\x6f\x00\x65\x00\x65\x00\x4b\x00\x61\x00\x65\x00\x44\x00\x6b\x00\x6b\x00\x6f\x00\x65\x00\x6f\x00\x6f\x00\x6f\x00\x72\x00\x72\x00\x6f\x00\x69\x00\x65\x00\x65\x00\x79\x00\x65\x00\x65\x00\x65\x00\x79\x00\x65\x00\x6b\x00\x79\x00\x69\x00\x79\x00\x65\x00\x69\x00\x61\x00\x52\x00\x6d\x00\x6b\x00\x52\x00\x62\x00\x64\x00\x42\x00\x42\x00\x50\x00\x64\x00\x74\x00\x72\x00\x72\x00\xff\xff\x72\x00\x74\x00\x64\x00\x72\x00\x6e\x00\x76\x00\x36\x00\x6e\x00\x76\x00\x52\x00\x6e\x00\x76\x00\x74\x00\x72\x00\x74\x00\x6e\x00\x6c\x00\x74\x00\x72\x00\x6e\x00\x6e\x00\x72\x00\x74\x00\x64\x00\x62\x00\x62\x00\x70\x00\x74\x00\x74\x00\x74\x00\x72\x00\x72\x00\x6e\x00\x76\x00\x6e\x00\x6e\x00\x74\x00\x74\x00\x6c\x00\x6e\x00\x70\x00\x72\x00\x6e\x00\x6e\x00\x6c\x00\x68\x00\x6c\x00\x62\x00\x72\x00\x72\x00\x6e\x00\x72\x00\x6c\x00\x6e\x00\x70\x00\x6e\x00\x6e\x00\x6e\x00\x6c\x00\x6c\x00\x38\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x54\x00\x44\x00\x54\x00\x43\x00\x43\x00\x6e\x00\x48\x00\x74\x00\x7a\x00\x44\x00\x44\x00\x72\x00\x72\x00\x72\x00\x72\x00\x6e\x00\x50\x00\x50\x00\x72\x00\x70\x00\x54\x00\x54\x00\x78\x00\x6e\x00\x72\x00\x6c\x00\x64\x00\x74\x00\x68\x00\x34\x00\x32\x00\x70\x00\x74\x00\x64\x00\x74\x00\x63\x00\x63\x00\x34\x00\x68\x00\x69\x00\x36\x00\x64\x00\x64\x00\x30\x00\x74\x00\x74\x00\x6e\x00\x6e\x00\x70\x00\x70\x00\x74\x00\x75\x00\x74\x00\x74\x00\x74\x00\x76\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x48\x00\x74\x00\x74\x00\x6c\x00\x6e\x00\x66\x00\x6e\x00\x74\x00\x64\x00\x3d\x00\x77\x00\xff\xff\xff\xff\x6e\x00\xff\xff\xff\xff\xff\xff\x72\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x79\x00\xff\xff\xff\xff\x68\x00\x69\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\x74\x00\x75\x00\x00\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x13\x00\x14\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\x2a\x00\x2b\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x6a\x00\x6b\x00\x6c\x00\x6d\x00\x6e\x00\x6f\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x78\x00\x79\x00\x7a\x00\x7b\x00\x7c\x00\x7d\x00\x7e\x00\x7f\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x0a\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x53\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x22\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x42\x00\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x73\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x52\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x62\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6e\x00\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x78\x00\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x71\x00\xff\xff\xff\xff\xff\xff\xff\xff\x76\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\x69\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x6f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\x69\x00\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x6e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x72\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x73\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x53\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\x68\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x73\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\x22\x00\xff\xff\xff\xff\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x46\x00\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x61\x00\x62\x00\x63\x00\x64\x00\x65\x00\x66\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x80\x00\x81\x00\x82\x00\x83\x00\x84\x00\x85\x00\x86\x00\x87\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x93\x00\x94\x00\x95\x00\x96\x00\x97\x00\x98\x00\x99\x00\x9a\x00\x9b\x00\x9c\x00\x9d\x00\x9e\x00\x9f\x00\xa0\x00\xa1\x00\xa2\x00\xa3\x00\xa4\x00\xa5\x00\xa6\x00\xa7\x00\xa8\x00\xa9\x00\xaa\x00\xab\x00\xac\x00\xad\x00\xae\x00\xaf\x00\xb0\x00\xb1\x00\xb2\x00\xb3\x00\xb4\x00\xb5\x00\xb6\x00\xb7\x00\xb8\x00\xb9\x00\xba\x00\xbb\x00\xbc\x00\xbd\x00\xbe\x00\xbf\x00\xc0\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\xc9\x00\xca\x00\xcb\x00\xcc\x00\xcd\x00\xce\x00\xcf\x00\xd0\x00\xd1\x00\xd2\x00\xd3\x00\xd4\x00\xd5\x00\xd6\x00\xd7\x00\xd8\x00\xd9\x00\xda\x00\xdb\x00\xdc\x00\xdd\x00\xde\x00\xdf\x00\xe0\x00\xe1\x00\xe2\x00\xe3\x00\xe4\x00\xe5\x00\xe6\x00\xe7\x00\xe8\x00\xe9\x00\xea\x00\xeb\x00\xec\x00\xed\x00\xee\x00\xef\x00\xf0\x00\xf1\x00\xf2\x00\xf3\x00\xf4\x00\xf5\x00\xf6\x00\xf7\x00\xf8\x00\xf9\x00\xfa\x00\xfb\x00\xfc\x00\xfd\x00\xfe\x00\xff\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

alex_deflt :: AlexAddr
alex_deflt = AlexA#
  "\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x00\x01\x00\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x09\x01\x09\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x01\x1c\x01\x1c\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x01\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x1c\x01"#

alex_accept = listArray (0 :: Int, 501)
  [ AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccSkip
  , AlexAcc 194
  , AlexAcc 193
  , AlexAcc 192
  , AlexAcc 191
  , AlexAcc 190
  , AlexAcc 189
  , AlexAcc 188
  , AlexAcc 187
  , AlexAcc 186
  , AlexAcc 185
  , AlexAcc 184
  , AlexAcc 183
  , AlexAcc 182
  , AlexAcc 181
  , AlexAcc 180
  , AlexAcc 179
  , AlexAcc 178
  , AlexAcc 177
  , AlexAcc 176
  , AlexAcc 175
  , AlexAcc 174
  , AlexAcc 173
  , AlexAcc 172
  , AlexAcc 171
  , AlexAcc 170
  , AlexAcc 169
  , AlexAcc 168
  , AlexAcc 167
  , AlexAcc 166
  , AlexAcc 165
  , AlexAcc 164
  , AlexAcc 163
  , AlexAcc 162
  , AlexAcc 161
  , AlexAcc 160
  , AlexAcc 159
  , AlexAcc 158
  , AlexAcc 157
  , AlexAcc 156
  , AlexAcc 155
  , AlexAcc 154
  , AlexAcc 153
  , AlexAcc 152
  , AlexAcc 151
  , AlexAcc 150
  , AlexAcc 149
  , AlexAcc 148
  , AlexAcc 147
  , AlexAcc 146
  , AlexAcc 145
  , AlexAcc 144
  , AlexAcc 143
  , AlexAcc 142
  , AlexAcc 141
  , AlexAcc 140
  , AlexAcc 139
  , AlexAcc 138
  , AlexAcc 137
  , AlexAcc 136
  , AlexAcc 135
  , AlexAcc 134
  , AlexAcc 133
  , AlexAcc 132
  , AlexAcc 131
  , AlexAcc 130
  , AlexAcc 129
  , AlexAcc 128
  , AlexAcc 127
  , AlexAcc 126
  , AlexAcc 125
  , AlexAcc 124
  , AlexAcc 123
  , AlexAcc 122
  , AlexAcc 121
  , AlexAcc 120
  , AlexAcc 119
  , AlexAcc 118
  , AlexAcc 117
  , AlexAcc 116
  , AlexAcc 115
  , AlexAcc 114
  , AlexAcc 113
  , AlexAcc 112
  , AlexAcc 111
  , AlexAcc 110
  , AlexAcc 109
  , AlexAcc 108
  , AlexAcc 107
  , AlexAcc 106
  , AlexAcc 105
  , AlexAcc 104
  , AlexAcc 103
  , AlexAcc 102
  , AlexAcc 101
  , AlexAcc 100
  , AlexAcc 99
  , AlexAcc 98
  , AlexAcc 97
  , AlexAcc 96
  , AlexAcc 95
  , AlexAcc 94
  , AlexAcc 93
  , AlexAcc 92
  , AlexAcc 91
  , AlexAcc 90
  , AlexAcc 89
  , AlexAcc 88
  , AlexAcc 87
  , AlexAcc 86
  , AlexAcc 85
  , AlexAcc 84
  , AlexAcc 83
  , AlexAcc 82
  , AlexAcc 81
  , AlexAcc 80
  , AlexAcc 79
  , AlexAcc 78
  , AlexAcc 77
  , AlexAcc 76
  , AlexAcc 75
  , AlexAcc 74
  , AlexAcc 73
  , AlexAcc 72
  , AlexAcc 71
  , AlexAcc 70
  , AlexAcc 69
  , AlexAcc 68
  , AlexAcc 67
  , AlexAcc 66
  , AlexAcc 65
  , AlexAcc 64
  , AlexAcc 63
  , AlexAcc 62
  , AlexAcc 61
  , AlexAcc 60
  , AlexAcc 59
  , AlexAcc 58
  , AlexAcc 57
  , AlexAcc 56
  , AlexAcc 55
  , AlexAcc 54
  , AlexAcc 53
  , AlexAcc 52
  , AlexAcc 51
  , AlexAcc 50
  , AlexAcc 49
  , AlexAcc 48
  , AlexAcc 47
  , AlexAcc 46
  , AlexAcc 45
  , AlexAcc 44
  , AlexAcc 43
  , AlexAcc 42
  , AlexAcc 41
  , AlexAcc 40
  , AlexAcc 39
  , AlexAcc 38
  , AlexAcc 37
  , AlexAcc 36
  , AlexAcc 35
  , AlexAcc 34
  , AlexAcc 33
  , AlexAcc 32
  , AlexAcc 31
  , AlexAcc 30
  , AlexAcc 29
  , AlexAcc 28
  , AlexAcc 27
  , AlexAcc 26
  , AlexAcc 25
  , AlexAcc 24
  , AlexAcc 23
  , AlexAcc 22
  , AlexAcc 21
  , AlexAcc 20
  , AlexAcc 19
  , AlexAcc 18
  , AlexAcc 17
  , AlexAcc 16
  , AlexAcc 15
  , AlexAcc 14
  , AlexAcc 13
  , AlexAcc 12
  , AlexAcc 11
  , AlexAcc 10
  , AlexAcc 9
  , AlexAcc 8
  , AlexAcc 7
  , AlexAcc 6
  , AlexAcc 5
  , AlexAcc 4
  , AlexAcc 3
  , AlexAcc 2
  , AlexAcc 1
  , AlexAcc 0
  ]

alex_actions = array (0 :: Int, 195)
  [ (194,alex_action_1)
  , (193,alex_action_2)
  , (192,alex_action_3)
  , (191,alex_action_4)
  , (190,alex_action_5)
  , (189,alex_action_6)
  , (188,alex_action_7)
  , (187,alex_action_8)
  , (186,alex_action_9)
  , (185,alex_action_10)
  , (184,alex_action_11)
  , (183,alex_action_12)
  , (182,alex_action_13)
  , (181,alex_action_14)
  , (180,alex_action_15)
  , (179,alex_action_16)
  , (178,alex_action_17)
  , (177,alex_action_18)
  , (176,alex_action_19)
  , (175,alex_action_20)
  , (174,alex_action_21)
  , (173,alex_action_22)
  , (172,alex_action_23)
  , (171,alex_action_24)
  , (170,alex_action_25)
  , (169,alex_action_26)
  , (168,alex_action_27)
  , (167,alex_action_28)
  , (166,alex_action_29)
  , (165,alex_action_30)
  , (164,alex_action_31)
  , (163,alex_action_32)
  , (162,alex_action_33)
  , (161,alex_action_34)
  , (160,alex_action_35)
  , (159,alex_action_36)
  , (158,alex_action_37)
  , (157,alex_action_38)
  , (156,alex_action_39)
  , (155,alex_action_40)
  , (154,alex_action_41)
  , (153,alex_action_42)
  , (152,alex_action_43)
  , (151,alex_action_44)
  , (150,alex_action_45)
  , (149,alex_action_46)
  , (148,alex_action_47)
  , (147,alex_action_48)
  , (146,alex_action_49)
  , (145,alex_action_50)
  , (144,alex_action_51)
  , (143,alex_action_52)
  , (142,alex_action_53)
  , (141,alex_action_54)
  , (140,alex_action_55)
  , (139,alex_action_56)
  , (138,alex_action_57)
  , (137,alex_action_58)
  , (136,alex_action_59)
  , (135,alex_action_60)
  , (134,alex_action_60)
  , (133,alex_action_61)
  , (132,alex_action_62)
  , (131,alex_action_62)
  , (130,alex_action_63)
  , (129,alex_action_64)
  , (128,alex_action_64)
  , (127,alex_action_64)
  , (126,alex_action_64)
  , (125,alex_action_64)
  , (124,alex_action_64)
  , (123,alex_action_64)
  , (122,alex_action_64)
  , (121,alex_action_64)
  , (120,alex_action_64)
  , (119,alex_action_64)
  , (118,alex_action_64)
  , (117,alex_action_64)
  , (116,alex_action_64)
  , (115,alex_action_64)
  , (114,alex_action_64)
  , (113,alex_action_64)
  , (112,alex_action_64)
  , (111,alex_action_64)
  , (110,alex_action_64)
  , (109,alex_action_64)
  , (108,alex_action_64)
  , (107,alex_action_64)
  , (106,alex_action_64)
  , (105,alex_action_64)
  , (104,alex_action_64)
  , (103,alex_action_64)
  , (102,alex_action_64)
  , (101,alex_action_64)
  , (100,alex_action_64)
  , (99,alex_action_64)
  , (98,alex_action_64)
  , (97,alex_action_64)
  , (96,alex_action_64)
  , (95,alex_action_64)
  , (94,alex_action_64)
  , (93,alex_action_64)
  , (92,alex_action_64)
  , (91,alex_action_64)
  , (90,alex_action_64)
  , (89,alex_action_65)
  , (88,alex_action_65)
  , (87,alex_action_65)
  , (86,alex_action_65)
  , (85,alex_action_65)
  , (84,alex_action_65)
  , (83,alex_action_65)
  , (82,alex_action_65)
  , (81,alex_action_65)
  , (80,alex_action_65)
  , (79,alex_action_65)
  , (78,alex_action_65)
  , (77,alex_action_65)
  , (76,alex_action_65)
  , (75,alex_action_65)
  , (74,alex_action_65)
  , (73,alex_action_65)
  , (72,alex_action_65)
  , (71,alex_action_65)
  , (70,alex_action_65)
  , (69,alex_action_65)
  , (68,alex_action_65)
  , (67,alex_action_65)
  , (66,alex_action_65)
  , (65,alex_action_65)
  , (64,alex_action_65)
  , (63,alex_action_65)
  , (62,alex_action_65)
  , (61,alex_action_65)
  , (60,alex_action_65)
  , (59,alex_action_65)
  , (58,alex_action_65)
  , (57,alex_action_65)
  , (56,alex_action_65)
  , (55,alex_action_65)
  , (54,alex_action_65)
  , (53,alex_action_65)
  , (52,alex_action_65)
  , (51,alex_action_65)
  , (50,alex_action_65)
  , (49,alex_action_65)
  , (48,alex_action_65)
  , (47,alex_action_65)
  , (46,alex_action_65)
  , (45,alex_action_65)
  , (44,alex_action_65)
  , (43,alex_action_65)
  , (42,alex_action_65)
  , (41,alex_action_65)
  , (40,alex_action_65)
  , (39,alex_action_66)
  , (38,alex_action_66)
  , (37,alex_action_66)
  , (36,alex_action_66)
  , (35,alex_action_66)
  , (34,alex_action_66)
  , (33,alex_action_66)
  , (32,alex_action_66)
  , (31,alex_action_66)
  , (30,alex_action_66)
  , (29,alex_action_66)
  , (28,alex_action_66)
  , (27,alex_action_66)
  , (26,alex_action_66)
  , (25,alex_action_66)
  , (24,alex_action_66)
  , (23,alex_action_66)
  , (22,alex_action_66)
  , (21,alex_action_66)
  , (20,alex_action_66)
  , (19,alex_action_66)
  , (18,alex_action_66)
  , (17,alex_action_66)
  , (16,alex_action_66)
  , (15,alex_action_66)
  , (14,alex_action_66)
  , (13,alex_action_66)
  , (12,alex_action_66)
  , (11,alex_action_66)
  , (10,alex_action_66)
  , (9,alex_action_66)
  , (8,alex_action_66)
  , (7,alex_action_66)
  , (6,alex_action_66)
  , (5,alex_action_66)
  , (4,alex_action_66)
  , (3,alex_action_66)
  , (2,alex_action_66)
  , (1,alex_action_66)
  , (0,alex_action_67)
  ]

{-# LINE 99 "HOpenPGP/Tools/Lexer.x" #-}

data Token
  = TokenTag
  | TokenAfter
  | TokenAnd
  | TokenAny
  | TokenBefore
  | TokenNot
  | TokenNow
  | TokenOr
  | TokenInt Integer
  | TokenEq
  | TokenLt
  | TokenGt
  | TokenLParen
  | TokenRParen
  | TokenEOF
  | TokenPKVersion
  | TokenSigVersion
  | TokenSigType
  | TokenPKAlgo
  | TokenSigPKAlgo
  | TokenHashAlgo
  | TokenRSA
  | TokenDSA
  | TokenElgamal
  | TokenECDSA
  | TokenECDH
  | TokenDH
  | TokenBinary
  | TokenCanonicalText
  | TokenStandalone
  | TokenGenericCert
  | TokenPersonaCert
  | TokenCasualCert
  | TokenPositiveCert
  | TokenSubkeyBindingSig
  | TokenPrimaryKeyBindingSig
  | TokenSignatureDirectlyOnAKey
  | TokenKeyRevocationSig
  | TokenSubkeyRevocationSig
  | TokenCertRevocationSig
  | TokenTimestampSig
  | TokenMD5
  | TokenSHA1
  | TokenRIPEMD160
  | TokenSHA256
  | TokenSHA384
  | TokenSHA512
  | TokenSHA224
  | TokenKeysize
  | TokenTimestamp
  | TokenFingerprint
  | TokenKeyID
  | TokenFpr TwentyOctetFingerprint
  | TokenLongID (Either String EightOctetKeyId)
  | TokenLength
  | TokenEvery
  | TokenOne
  | TokenOf
  | TokenContains
  | TokenUids
  | TokenStr String
  | TokenA
  | TokenSubkey
  | TokenSigCreationTime
  deriving (Eq,Show)

alexEOF = return TokenEOF

lex :: (String -> a) -> AlexAction a
lex f = \(_,_,_,s) i -> return (f (take i s))

lex' :: a -> AlexAction a
lex' = lex . const


alex_action_1 =  lex' TokenA 
alex_action_2 =  lex' TokenAnd 
alex_action_3 =  lex' TokenAny 
alex_action_4 =  lex' TokenEvery 
alex_action_5 =  lex' TokenNot 
alex_action_6 =  lex' TokenNow 
alex_action_7 =  lex' TokenOne 
alex_action_8 =  lex' TokenOr 
alex_action_9 =  lex' TokenSubkey 
alex_action_10 =  lex' TokenTag 
alex_action_11 =  lex' TokenOf 
alex_action_12 =  lex' TokenEq 
alex_action_13 =  lex' TokenEq 
alex_action_14 =  lex' TokenEq 
alex_action_15 =  lex' TokenLt 
alex_action_16 =  lex' TokenGt 
alex_action_17 =  lex' TokenLParen 
alex_action_18 =  lex' TokenRParen 
alex_action_19 =  lex' TokenContains 
alex_action_20 =  lex' TokenPKVersion 
alex_action_21 =  lex' TokenSigVersion 
alex_action_22 =  lex' TokenSigType 
alex_action_23 =  lex' TokenPKAlgo 
alex_action_24 =  lex' TokenSigPKAlgo 
alex_action_25 =  lex' TokenHashAlgo 
alex_action_26 =  lex' TokenRSA 
alex_action_27 =  lex' TokenDSA 
alex_action_28 =  lex' TokenElgamal 
alex_action_29 =  lex' TokenECDSA 
alex_action_30 =  lex' TokenECDH 
alex_action_31 =  lex' TokenDH 
alex_action_32 =  lex' TokenBinary 
alex_action_33 =  lex' TokenCanonicalText 
alex_action_34 =  lex' TokenStandalone 
alex_action_35 =  lex' TokenGenericCert 
alex_action_36 =  lex' TokenPersonaCert 
alex_action_37 =  lex' TokenCasualCert 
alex_action_38 =  lex' TokenPositiveCert 
alex_action_39 =  lex' TokenSubkeyBindingSig 
alex_action_40 =  lex' TokenPrimaryKeyBindingSig 
alex_action_41 =  lex' TokenSignatureDirectlyOnAKey 
alex_action_42 =  lex' TokenKeyRevocationSig 
alex_action_43 =  lex' TokenSubkeyRevocationSig 
alex_action_44 =  lex' TokenCertRevocationSig 
alex_action_45 =  lex' TokenTimestampSig 
alex_action_46 =  lex' TokenMD5 
alex_action_47 =  lex' TokenSHA1 
alex_action_48 =  lex' TokenRIPEMD160 
alex_action_49 =  lex' TokenSHA256 
alex_action_50 =  lex' TokenSHA384 
alex_action_51 =  lex' TokenSHA512 
alex_action_52 =  lex' TokenSHA224 
alex_action_53 =  lex' TokenUids 
alex_action_54 =  lex' TokenKeysize 
alex_action_55 =  lex' TokenLength 
alex_action_56 =  lex' TokenTimestamp 
alex_action_57 =  lex' TokenFingerprint 
alex_action_58 =  lex' TokenKeyID 
alex_action_59 =  lex' TokenSigCreationTime 
alex_action_60 =  lex (TokenFpr . read) 
alex_action_61 =  lex (TokenFpr . read . drop 2) 
alex_action_62 =  lex (TokenLongID . Right . read) 
alex_action_63 =  lex (TokenLongID . Right . read . drop 2) 
alex_action_64 =  lex (TokenInt  . fromIntegral . read) 
alex_action_65 =  lex (TokenInt  . fromIntegral . fst . head . readHex) 
alex_action_66 =  lex (TokenInt  . fromIntegral . fst . head . readHex . drop 2) 
alex_action_67 =  lex (TokenStr . ((zipWith const . drop 1) <*> (drop 2))) 
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- -----------------------------------------------------------------------------
-- ALEX TEMPLATE
--
-- This code is in the PUBLIC DOMAIN; you may copy it freely and use
-- it for any purpose whatsoever.

-- -----------------------------------------------------------------------------
-- INTERNALS and main scanner engine

















-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define GTE(n,m) (tagToEnum# (n >=# m))
#define EQ(n,m) (tagToEnum# (n ==# m))
#else
#define GTE(n,m) (n >=# m)
#define EQ(n,m) (n ==# m)
#endif



















data AlexAddr = AlexA# Addr#
-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ < 503
uncheckedShiftL# = shiftL#
#endif

{-# INLINE alexIndexInt16OffAddr #-}
alexIndexInt16OffAddr (AlexA# arr) off =
#ifdef WORDS_BIGENDIAN
  narrow16Int# i
  where
        i    = word2Int# ((high `uncheckedShiftL#` 8#) `or#` low)
        high = int2Word# (ord# (indexCharOffAddr# arr (off' +# 1#)))
        low  = int2Word# (ord# (indexCharOffAddr# arr off'))
        off' = off *# 2#
#else
  indexInt16OffAddr# arr off
#endif





{-# INLINE alexIndexInt32OffAddr #-}
alexIndexInt32OffAddr (AlexA# arr) off =
#ifdef WORDS_BIGENDIAN
  narrow32Int# i
  where
   i    = word2Int# ((b3 `uncheckedShiftL#` 24#) `or#`
                     (b2 `uncheckedShiftL#` 16#) `or#`
                     (b1 `uncheckedShiftL#` 8#) `or#` b0)
   b3   = int2Word# (ord# (indexCharOffAddr# arr (off' +# 3#)))
   b2   = int2Word# (ord# (indexCharOffAddr# arr (off' +# 2#)))
   b1   = int2Word# (ord# (indexCharOffAddr# arr (off' +# 1#)))
   b0   = int2Word# (ord# (indexCharOffAddr# arr off'))
   off' = off *# 4#
#else
  indexInt32OffAddr# arr off
#endif






#if __GLASGOW_HASKELL__ < 503
quickIndex arr i = arr ! i
#else
-- GHC >= 503, unsafeAt is available from Data.Array.Base.
quickIndex = unsafeAt
#endif




-- -----------------------------------------------------------------------------
-- Main lexing routines

data AlexReturn a
  = AlexEOF
  | AlexError  !AlexInput
  | AlexSkip   !AlexInput !Int
  | AlexToken  !AlexInput !Int a

-- alexScan :: AlexInput -> StartCode -> AlexReturn a
alexScan input__ (I# (sc))
  = alexScanUser undefined input__ (I# (sc))

alexScanUser user__ input__ (I# (sc))
  = case alex_scan_tkn user__ input__ 0# input__ sc AlexNone of
  (AlexNone, input__') ->
    case alexGetByte input__ of
      Nothing ->



                                   AlexEOF
      Just _ ->



                                   AlexError input__'

  (AlexLastSkip input__'' len, _) ->



    AlexSkip input__'' len

  (AlexLastAcc k input__''' len, _) ->



    AlexToken input__''' len (alex_actions ! k)


-- Push the input through the DFA, remembering the most recent accepting
-- state it encountered.

alex_scan_tkn user__ orig_input len input__ s last_acc =
  input__ `seq` -- strict in the input
  let
  new_acc = (check_accs (alex_accept `quickIndex` (I# (s))))
  in
  new_acc `seq`
  case alexGetByte input__ of
     Nothing -> (new_acc, input__)
     Just (c, new_input) ->



      case fromIntegral c of { (I# (ord_c)) ->
        let
                base   = alexIndexInt32OffAddr alex_base s
                offset = (base +# ord_c)
                check  = alexIndexInt16OffAddr alex_check offset

                new_s = if GTE(offset,0#) && EQ(check,ord_c)
                          then alexIndexInt16OffAddr alex_table offset
                          else alexIndexInt16OffAddr alex_deflt s
        in
        case new_s of
            -1# -> (new_acc, input__)
                -- on an error, we want to keep the input *before* the
                -- character that failed, not after.
            _ -> alex_scan_tkn user__ orig_input (if c < 0x80 || c >= 0xC0 then (len +# 1#) else len)
                                                -- note that the length is increased ONLY if this is the 1st byte in a char encoding)
                        new_input new_s new_acc
      }
  where
        check_accs (AlexAccNone) = last_acc
        check_accs (AlexAcc a  ) = AlexLastAcc a input__ (I# (len))
        check_accs (AlexAccSkip) = AlexLastSkip  input__ (I# (len))













data AlexLastAcc
  = AlexNone
  | AlexLastAcc !Int !AlexInput !Int
  | AlexLastSkip     !AlexInput !Int

data AlexAcc user
  = AlexAccNone
  | AlexAcc Int
  | AlexAccSkip





























