SET(MINGW_PREFIX "i686-w64-mingw32")

SET(CMAKE_SYSTEM_NAME Windows)
SET(CMAKE_EXECUTABLE_SUFFIX ".exe")
SET(CMAKE_EXE_LINKER_FLAGS "-static")
SET(CMAKE_EXE_LINKER_FLAGS_RELEASE "-s")

SET(CMAKE_C_COMPILER ccache ${MINGW_PREFIX}-gcc)
SET(CMAKE_CXX_COMPILER ccache ${MINGW_PREFIX}-g++)
SET(CMAKE_C_FLAGS "-fno-keep-inline-dllexport")
SET(CMAKE_CXX_FLAGS "${CMAKE_C_FLAGS} ${CMAKE_CXX_FLAGS_RELEASE} -march=pentium4 -mtune=pentium4 -mwindows -O2")
SET(CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS "-Wl,--no-undefined -static-libgcc -static-libstdc++ -Wl,-O1 -Wl,--as-needed -Wl,--sort-common -s")
SET(CMAKE_RC_COMPILER /usr/bin/${MINGW_PREFIX}-windres)

SET(CMAKE_FIND_ROOT_PATH /usr/${MINGW_PREFIX}/sys-root/mingw)
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)

SET(QT_QMAKE_EXECUTABLE /usr/${MINGW_PREFIX}/bin/qmake CACHE INTERNAL "" FORCE)
SET(QT_MOC_EXECUTABLE /usr/${MINGW_PREFIX}/bin/moc CACHE INTERNAL "" FORCE)
SET(QT_RCC_EXECUTABLE /usr/${MINGW_PREFIX}/bin/rcc CACHE INTERNAL "" FORCE)
SET(QT_UIC_EXECUTABLE /usr/${MINGW_PREFIX}/bin/uic CACHE INTERNAL "" FORCE)
SET(QT_LIBRARY_DIR /usr/${MINGW_PREFIX}/bin)
SET(QT_PLUGINS_DIR ${CMAKE_FIND_ROOT_PATH}/lib/qt4/plugins/)

SET(APP_ICON_RC ${CMAKE_CURRENT_SOURCE_DIR}/qt/win32_icon.rc)
SET(WIN32_ICON_O ${CMAKE_CURRENT_BINARY_DIR}/_app_icon.o)
ADD_CUSTOM_COMMAND( OUTPUT ${WIN32_ICON_O}
                    COMMAND ${MINGW_PREFIX}windres
                    -I${CMAKE_CURRENT_SOURCE_DIR}
                    -o${WIN32_ICON_O}
                    -i${APP_ICON_RC}
                  )
