/*
  bdf2exkanji.c  2022.6.26 version
    convert .bdf font file to EXKANJI format for PC-6001 series
    by AKIKAWA, Hisashi
    This software is redistributable under the LGPLv2.1 or any later version.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BDFSIZE 64
#define DEBUG 0

#define NCHR 0x10000
#define SIZEX 16
#define SIZEY 16

#define SEMIVOICED_MARK 0x309a

enum {JIS, UNI};

int getbdfpar(FILE *fp, int use_ascent, int *pixel_x, int *pixel_y, int *over_baseline);
void convert(FILE *fp, unsigned int bmpout[16], int size_x_out, int size_y_out, int pixel_x, int pixel_y, int over_baseline, int code_is_ambiguous);
int isnodata(unsigned int *bmpout);
void calcchr(unsigned char bmp80[][8]);
int uni2jis(int uni);
int isambiguous(int code, int charset);

const int jisunitbl[][2] = {
  {0x2121, 0x3000}, {0x2122, 0x3001}, {0x2123, 0x3002}, {0x2124, 0xff0c},
  {0x2125, 0xff0e}, {0x2126, 0x30fb}, {0x2127, 0xff1a}, {0x2128, 0xff1b},
  {0x2129, 0xff1f}, {0x212a, 0xff01}, {0x212b, 0x309b}, {0x212c, 0x309c},
  {0x212d, 0x00b4}, {0x212e, 0xff40}, {0x212f, 0x00a8}, {0x2130, 0xff3e},
  {0x2131, 0xffe3}, {0x2132, 0xff3f}, {0x2133, 0x30fd}, {0x2134, 0x30fe},
  {0x2135, 0x309d}, {0x2136, 0x309e}, {0x2137, 0x3003}, {0x2138, 0x4edd},
  {0x2139, 0x3005}, {0x213a, 0x3006}, {0x213b, 0x3007}, {0x213c, 0x30fc},
  {0x213d, 0x2015}, {0x213e, 0x2010}, {0x213f, 0xff0f}, {0x2140, 0xff3c},
  {0x2141, 0x301c}, {0x2142, 0x2016}, {0x2143, 0xff5c}, {0x2144, 0x2026},
  {0x2145, 0x2025}, {0x2146, 0x2018}, {0x2147, 0x2019}, {0x2148, 0x201c},
  {0x2149, 0x201d}, {0x214a, 0xff08}, {0x214b, 0xff09}, {0x214c, 0x3014},
  {0x214d, 0x3015}, {0x214e, 0xff3b}, {0x214f, 0xff3d}, {0x2150, 0xff5b},
  {0x2151, 0xff5d}, {0x2152, 0x3008}, {0x2153, 0x3009}, {0x2154, 0x300a},
  {0x2155, 0x300b}, {0x2156, 0x300c}, {0x2157, 0x300d}, {0x2158, 0x300e},
  {0x2159, 0x300f}, {0x215a, 0x3010}, {0x215b, 0x3011}, {0x215c, 0xff0b},
  {0x215d, 0xff0d}, {0x215e, 0x00b1}, {0x215f, 0x00d7}, {0x2160, 0x00f7},
  {0x2161, 0xff1d}, {0x2162, 0x2260}, {0x2163, 0xff1c}, {0x2164, 0xff1e},
  {0x2165, 0x2266}, {0x2166, 0x2267}, {0x2167, 0x221e}, {0x2168, 0x2234},
  {0x2169, 0x2642}, {0x216a, 0x2640}, {0x216b, 0x00b0}, {0x216c, 0x2032},
  {0x216d, 0x2033}, {0x216e, 0x2103}, {0x216f, 0xffe5}, {0x2170, 0xff04},
  {0x2171, 0xffe0}, {0x2172, 0xffe1}, {0x2173, 0xff05}, {0x2174, 0xff03},
  {0x2175, 0xff06}, {0x2176, 0xff0a}, {0x2177, 0xff20}, {0x2178, 0x00a7},
  {0x2179, 0x2606}, {0x217a, 0x2605}, {0x217b, 0x25cb}, {0x217c, 0x25cf},
  {0x217d, 0x25ce}, {0x217e, 0x25c7}, {0x2221, 0x25c6}, {0x2222, 0x25a1},
  {0x2223, 0x25a0}, {0x2224, 0x25b3}, {0x2225, 0x25b2}, {0x2226, 0x25bd},
  {0x2227, 0x25bc}, {0x2228, 0x203b}, {0x2229, 0x3012}, {0x222a, 0x2192},
  {0x222b, 0x2190}, {0x222c, 0x2191}, {0x222d, 0x2193}, {0x222e, 0x3013},
  {0x223a, 0x2208}, {0x223b, 0x220b}, {0x223c, 0x2286}, {0x223d, 0x2287},
  {0x223e, 0x2282}, {0x223f, 0x2283}, {0x2240, 0x222a}, {0x2241, 0x2229},
  {0x224a, 0x2227}, {0x224b, 0x2228}, {0x224c, 0xffe2}, {0x224d, 0x21d2},
  {0x224e, 0x21d4}, {0x224f, 0x2200}, {0x2250, 0x2203}, {0x225c, 0x2220},
  {0x225d, 0x22a5}, {0x225e, 0x2312}, {0x225f, 0x2202}, {0x2260, 0x2207},
  {0x2261, 0x2261}, {0x2262, 0x2252}, {0x2263, 0x226a}, {0x2264, 0x226b},
  {0x2265, 0x221a}, {0x2266, 0x223d}, {0x2267, 0x221d}, {0x2268, 0x2235},
  {0x2269, 0x222b}, {0x226a, 0x222c}, {0x2272, 0x212b}, {0x2273, 0x2030},
  {0x2274, 0x266f}, {0x2275, 0x266d}, {0x2276, 0x266a}, {0x2277, 0x2020},
  {0x2278, 0x2021}, {0x2279, 0x00b6}, {0x227e, 0x25ef}, {0x2330, 0xff10},
  {0x2331, 0xff11}, {0x2332, 0xff12}, {0x2333, 0xff13}, {0x2334, 0xff14},
  {0x2335, 0xff15}, {0x2336, 0xff16}, {0x2337, 0xff17}, {0x2338, 0xff18},
  {0x2339, 0xff19}, {0x2341, 0xff21}, {0x2342, 0xff22}, {0x2343, 0xff23},
  {0x2344, 0xff24}, {0x2345, 0xff25}, {0x2346, 0xff26}, {0x2347, 0xff27},
  {0x2348, 0xff28}, {0x2349, 0xff29}, {0x234a, 0xff2a}, {0x234b, 0xff2b},
  {0x234c, 0xff2c}, {0x234d, 0xff2d}, {0x234e, 0xff2e}, {0x234f, 0xff2f},
  {0x2350, 0xff30}, {0x2351, 0xff31}, {0x2352, 0xff32}, {0x2353, 0xff33},
  {0x2354, 0xff34}, {0x2355, 0xff35}, {0x2356, 0xff36}, {0x2357, 0xff37},
  {0x2358, 0xff38}, {0x2359, 0xff39}, {0x235a, 0xff3a}, {0x2361, 0xff41},
  {0x2362, 0xff42}, {0x2363, 0xff43}, {0x2364, 0xff44}, {0x2365, 0xff45},
  {0x2366, 0xff46}, {0x2367, 0xff47}, {0x2368, 0xff48}, {0x2369, 0xff49},
  {0x236a, 0xff4a}, {0x236b, 0xff4b}, {0x236c, 0xff4c}, {0x236d, 0xff4d},
  {0x236e, 0xff4e}, {0x236f, 0xff4f}, {0x2370, 0xff50}, {0x2371, 0xff51},
  {0x2372, 0xff52}, {0x2373, 0xff53}, {0x2374, 0xff54}, {0x2375, 0xff55},
  {0x2376, 0xff56}, {0x2377, 0xff57}, {0x2378, 0xff58}, {0x2379, 0xff59},
  {0x237a, 0xff5a}, {0x2421, 0x3041}, {0x2422, 0x3042}, {0x2423, 0x3043},
  {0x2424, 0x3044}, {0x2425, 0x3045}, {0x2426, 0x3046}, {0x2427, 0x3047},
  {0x2428, 0x3048}, {0x2429, 0x3049}, {0x242a, 0x304a}, {0x242b, 0x304b},
  {0x242c, 0x304c}, {0x242d, 0x304d}, {0x242e, 0x304e}, {0x242f, 0x304f},
  {0x2430, 0x3050}, {0x2431, 0x3051}, {0x2432, 0x3052}, {0x2433, 0x3053},
  {0x2434, 0x3054}, {0x2435, 0x3055}, {0x2436, 0x3056}, {0x2437, 0x3057},
  {0x2438, 0x3058}, {0x2439, 0x3059}, {0x243a, 0x305a}, {0x243b, 0x305b},
  {0x243c, 0x305c}, {0x243d, 0x305d}, {0x243e, 0x305e}, {0x243f, 0x305f},
  {0x2440, 0x3060}, {0x2441, 0x3061}, {0x2442, 0x3062}, {0x2443, 0x3063},
  {0x2444, 0x3064}, {0x2445, 0x3065}, {0x2446, 0x3066}, {0x2447, 0x3067},
  {0x2448, 0x3068}, {0x2449, 0x3069}, {0x244a, 0x306a}, {0x244b, 0x306b},
  {0x244c, 0x306c}, {0x244d, 0x306d}, {0x244e, 0x306e}, {0x244f, 0x306f},
  {0x2450, 0x3070}, {0x2451, 0x3071}, {0x2452, 0x3072}, {0x2453, 0x3073},
  {0x2454, 0x3074}, {0x2455, 0x3075}, {0x2456, 0x3076}, {0x2457, 0x3077},
  {0x2458, 0x3078}, {0x2459, 0x3079}, {0x245a, 0x307a}, {0x245b, 0x307b},
  {0x245c, 0x307c}, {0x245d, 0x307d}, {0x245e, 0x307e}, {0x245f, 0x307f},
  {0x2460, 0x3080}, {0x2461, 0x3081}, {0x2462, 0x3082}, {0x2463, 0x3083},
  {0x2464, 0x3084}, {0x2465, 0x3085}, {0x2466, 0x3086}, {0x2467, 0x3087},
  {0x2468, 0x3088}, {0x2469, 0x3089}, {0x246a, 0x308a}, {0x246b, 0x308b},
  {0x246c, 0x308c}, {0x246d, 0x308d}, {0x246e, 0x308e}, {0x246f, 0x308f},
  {0x2470, 0x3090}, {0x2471, 0x3091}, {0x2472, 0x3092}, {0x2473, 0x3093},
  {0x2521, 0x30a1}, {0x2522, 0x30a2}, {0x2523, 0x30a3}, {0x2524, 0x30a4},
  {0x2525, 0x30a5}, {0x2526, 0x30a6}, {0x2527, 0x30a7}, {0x2528, 0x30a8},
  {0x2529, 0x30a9}, {0x252a, 0x30aa}, {0x252b, 0x30ab}, {0x252c, 0x30ac},
  {0x252d, 0x30ad}, {0x252e, 0x30ae}, {0x252f, 0x30af}, {0x2530, 0x30b0},
  {0x2531, 0x30b1}, {0x2532, 0x30b2}, {0x2533, 0x30b3}, {0x2534, 0x30b4},
  {0x2535, 0x30b5}, {0x2536, 0x30b6}, {0x2537, 0x30b7}, {0x2538, 0x30b8},
  {0x2539, 0x30b9}, {0x253a, 0x30ba}, {0x253b, 0x30bb}, {0x253c, 0x30bc},
  {0x253d, 0x30bd}, {0x253e, 0x30be}, {0x253f, 0x30bf}, {0x2540, 0x30c0},
  {0x2541, 0x30c1}, {0x2542, 0x30c2}, {0x2543, 0x30c3}, {0x2544, 0x30c4},
  {0x2545, 0x30c5}, {0x2546, 0x30c6}, {0x2547, 0x30c7}, {0x2548, 0x30c8},
  {0x2549, 0x30c9}, {0x254a, 0x30ca}, {0x254b, 0x30cb}, {0x254c, 0x30cc},
  {0x254d, 0x30cd}, {0x254e, 0x30ce}, {0x254f, 0x30cf}, {0x2550, 0x30d0},
  {0x2551, 0x30d1}, {0x2552, 0x30d2}, {0x2553, 0x30d3}, {0x2554, 0x30d4},
  {0x2555, 0x30d5}, {0x2556, 0x30d6}, {0x2557, 0x30d7}, {0x2558, 0x30d8},
  {0x2559, 0x30d9}, {0x255a, 0x30da}, {0x255b, 0x30db}, {0x255c, 0x30dc},
  {0x255d, 0x30dd}, {0x255e, 0x30de}, {0x255f, 0x30df}, {0x2560, 0x30e0},
  {0x2561, 0x30e1}, {0x2562, 0x30e2}, {0x2563, 0x30e3}, {0x2564, 0x30e4},
  {0x2565, 0x30e5}, {0x2566, 0x30e6}, {0x2567, 0x30e7}, {0x2568, 0x30e8},
  {0x2569, 0x30e9}, {0x256a, 0x30ea}, {0x256b, 0x30eb}, {0x256c, 0x30ec},
  {0x256d, 0x30ed}, {0x256e, 0x30ee}, {0x256f, 0x30ef}, {0x2570, 0x30f0},
  {0x2571, 0x30f1}, {0x2572, 0x30f2}, {0x2573, 0x30f3}, {0x2574, 0x30f4},
  {0x2575, 0x30f5}, {0x2576, 0x30f6}, {0x2621, 0x0391}, {0x2622, 0x0392},
  {0x2623, 0x0393}, {0x2624, 0x0394}, {0x2625, 0x0395}, {0x2626, 0x0396},
  {0x2627, 0x0397}, {0x2628, 0x0398}, {0x2629, 0x0399}, {0x262a, 0x039a},
  {0x262b, 0x039b}, {0x262c, 0x039c}, {0x262d, 0x039d}, {0x262e, 0x039e},
  {0x262f, 0x039f}, {0x2630, 0x03a0}, {0x2631, 0x03a1}, {0x2632, 0x03a3},
  {0x2633, 0x03a4}, {0x2634, 0x03a5}, {0x2635, 0x03a6}, {0x2636, 0x03a7},
  {0x2637, 0x03a8}, {0x2638, 0x03a9}, {0x2641, 0x03b1}, {0x2642, 0x03b2},
  {0x2643, 0x03b3}, {0x2644, 0x03b4}, {0x2645, 0x03b5}, {0x2646, 0x03b6},
  {0x2647, 0x03b7}, {0x2648, 0x03b8}, {0x2649, 0x03b9}, {0x264a, 0x03ba},
  {0x264b, 0x03bb}, {0x264c, 0x03bc}, {0x264d, 0x03bd}, {0x264e, 0x03be},
  {0x264f, 0x03bf}, {0x2650, 0x03c0}, {0x2651, 0x03c1}, {0x2652, 0x03c3},
  {0x2653, 0x03c4}, {0x2654, 0x03c5}, {0x2655, 0x03c6}, {0x2656, 0x03c7},
  {0x2657, 0x03c8}, {0x2658, 0x03c9}, {0x2721, 0x0410}, {0x2722, 0x0411},
  {0x2723, 0x0412}, {0x2724, 0x0413}, {0x2725, 0x0414}, {0x2726, 0x0415},
  {0x2727, 0x0401}, {0x2728, 0x0416}, {0x2729, 0x0417}, {0x272a, 0x0418},
  {0x272b, 0x0419}, {0x272c, 0x041a}, {0x272d, 0x041b}, {0x272e, 0x041c},
  {0x272f, 0x041d}, {0x2730, 0x041e}, {0x2731, 0x041f}, {0x2732, 0x0420},
  {0x2733, 0x0421}, {0x2734, 0x0422}, {0x2735, 0x0423}, {0x2736, 0x0424},
  {0x2737, 0x0425}, {0x2738, 0x0426}, {0x2739, 0x0427}, {0x273a, 0x0428},
  {0x273b, 0x0429}, {0x273c, 0x042a}, {0x273d, 0x042b}, {0x273e, 0x042c},
  {0x273f, 0x042d}, {0x2740, 0x042e}, {0x2741, 0x042f}, {0x2751, 0x0430},
  {0x2752, 0x0431}, {0x2753, 0x0432}, {0x2754, 0x0433}, {0x2755, 0x0434},
  {0x2756, 0x0435}, {0x2757, 0x0451}, {0x2758, 0x0436}, {0x2759, 0x0437},
  {0x275a, 0x0438}, {0x275b, 0x0439}, {0x275c, 0x043a}, {0x275d, 0x043b},
  {0x275e, 0x043c}, {0x275f, 0x043d}, {0x2760, 0x043e}, {0x2761, 0x043f},
  {0x2762, 0x0440}, {0x2763, 0x0441}, {0x2764, 0x0442}, {0x2765, 0x0443},
  {0x2766, 0x0444}, {0x2767, 0x0445}, {0x2768, 0x0446}, {0x2769, 0x0447},
  {0x276a, 0x0448}, {0x276b, 0x0449}, {0x276c, 0x044a}, {0x276d, 0x044b},
  {0x276e, 0x044c}, {0x276f, 0x044d}, {0x2770, 0x044e}, {0x2771, 0x044f},
  {0x2821, 0x2500}, {0x2822, 0x2502}, {0x2823, 0x250c}, {0x2824, 0x2510},
  {0x2825, 0x2518}, {0x2826, 0x2514}, {0x2827, 0x251c}, {0x2828, 0x252c},
  {0x2829, 0x2524}, {0x282a, 0x2534}, {0x282b, 0x253c}, {0x282c, 0x2501},
  {0x282d, 0x2503}, {0x282e, 0x250f}, {0x282f, 0x2513}, {0x2830, 0x251b},
  {0x2831, 0x2517}, {0x2832, 0x2523}, {0x2833, 0x2533}, {0x2834, 0x252b},
  {0x2835, 0x253b}, {0x2836, 0x254b}, {0x2837, 0x2520}, {0x2838, 0x252f},
  {0x2839, 0x2528}, {0x283a, 0x2537}, {0x283b, 0x253f}, {0x283c, 0x251d},
  {0x283d, 0x2530}, {0x283e, 0x2525}, {0x283f, 0x2538}, {0x2840, 0x2542},
  {0x3021, 0x4e9c}, {0x3022, 0x5516}, {0x3023, 0x5a03}, {0x3024, 0x963f},
  {0x3025, 0x54c0}, {0x3026, 0x611b}, {0x3027, 0x6328}, {0x3028, 0x59f6},
  {0x3029, 0x9022}, {0x302a, 0x8475}, {0x302b, 0x831c}, {0x302c, 0x7a50},
  {0x302d, 0x60aa}, {0x302e, 0x63e1}, {0x302f, 0x6e25}, {0x3030, 0x65ed},
  {0x3031, 0x8466}, {0x3032, 0x82a6}, {0x3033, 0x9bf5}, {0x3034, 0x6893},
  {0x3035, 0x5727}, {0x3036, 0x65a1}, {0x3037, 0x6271}, {0x3038, 0x5b9b},
  {0x3039, 0x59d0}, {0x303a, 0x867b}, {0x303b, 0x98f4}, {0x303c, 0x7d62},
  {0x303d, 0x7dbe}, {0x303e, 0x9b8e}, {0x303f, 0x6216}, {0x3040, 0x7c9f},
  {0x3041, 0x88b7}, {0x3042, 0x5b89}, {0x3043, 0x5eb5}, {0x3044, 0x6309},
  {0x3045, 0x6697}, {0x3046, 0x6848}, {0x3047, 0x95c7}, {0x3048, 0x978d},
  {0x3049, 0x674f}, {0x304a, 0x4ee5}, {0x304b, 0x4f0a}, {0x304c, 0x4f4d},
  {0x304d, 0x4f9d}, {0x304e, 0x5049}, {0x304f, 0x56f2}, {0x3050, 0x5937},
  {0x3051, 0x59d4}, {0x3052, 0x5a01}, {0x3053, 0x5c09}, {0x3054, 0x60df},
  {0x3055, 0x610f}, {0x3056, 0x6170}, {0x3057, 0x6613}, {0x3058, 0x6905},
  {0x3059, 0x70ba}, {0x305a, 0x754f}, {0x305b, 0x7570}, {0x305c, 0x79fb},
  {0x305d, 0x7dad}, {0x305e, 0x7def}, {0x305f, 0x80c3}, {0x3060, 0x840e},
  {0x3061, 0x8863}, {0x3062, 0x8b02}, {0x3063, 0x9055}, {0x3064, 0x907a},
  {0x3065, 0x533b}, {0x3066, 0x4e95}, {0x3067, 0x4ea5}, {0x3068, 0x57df},
  {0x3069, 0x80b2}, {0x306a, 0x90c1}, {0x306b, 0x78ef}, {0x306c, 0x4e00},
  {0x306d, 0x58f1}, {0x306e, 0x6ea2}, {0x306f, 0x9038}, {0x3070, 0x7a32},
  {0x3071, 0x8328}, {0x3072, 0x828b}, {0x3073, 0x9c2f}, {0x3074, 0x5141},
  {0x3075, 0x5370}, {0x3076, 0x54bd}, {0x3077, 0x54e1}, {0x3078, 0x56e0},
  {0x3079, 0x59fb}, {0x307a, 0x5f15}, {0x307b, 0x98f2}, {0x307c, 0x6deb},
  {0x307d, 0x80e4}, {0x307e, 0x852d}, {0x3121, 0x9662}, {0x3122, 0x9670},
  {0x3123, 0x96a0}, {0x3124, 0x97fb}, {0x3125, 0x540b}, {0x3126, 0x53f3},
  {0x3127, 0x5b87}, {0x3128, 0x70cf}, {0x3129, 0x7fbd}, {0x312a, 0x8fc2},
  {0x312b, 0x96e8}, {0x312c, 0x536f}, {0x312d, 0x9d5c}, {0x312e, 0x7aba},
  {0x312f, 0x4e11}, {0x3130, 0x7893}, {0x3131, 0x81fc}, {0x3132, 0x6e26},
  {0x3133, 0x5618}, {0x3134, 0x5504}, {0x3135, 0x6b1d}, {0x3136, 0x851a},
  {0x3137, 0x9c3b}, {0x3138, 0x59e5}, {0x3139, 0x53a9}, {0x313a, 0x6d66},
  {0x313b, 0x74dc}, {0x313c, 0x958f}, {0x313d, 0x5642}, {0x313e, 0x4e91},
  {0x313f, 0x904b}, {0x3140, 0x96f2}, {0x3141, 0x834f}, {0x3142, 0x990c},
  {0x3143, 0x53e1}, {0x3144, 0x55b6}, {0x3145, 0x5b30}, {0x3146, 0x5f71},
  {0x3147, 0x6620}, {0x3148, 0x66f3}, {0x3149, 0x6804}, {0x314a, 0x6c38},
  {0x314b, 0x6cf3}, {0x314c, 0x6d29}, {0x314d, 0x745b}, {0x314e, 0x76c8},
  {0x314f, 0x7a4e}, {0x3150, 0x9834}, {0x3151, 0x82f1}, {0x3152, 0x885b},
  {0x3153, 0x8a60}, {0x3154, 0x92ed}, {0x3155, 0x6db2}, {0x3156, 0x75ab},
  {0x3157, 0x76ca}, {0x3158, 0x99c5}, {0x3159, 0x60a6}, {0x315a, 0x8b01},
  {0x315b, 0x8d8a}, {0x315c, 0x95b2}, {0x315d, 0x698e}, {0x315e, 0x53ad},
  {0x315f, 0x5186}, {0x3160, 0x5712}, {0x3161, 0x5830}, {0x3162, 0x5944},
  {0x3163, 0x5bb4}, {0x3164, 0x5ef6}, {0x3165, 0x6028}, {0x3166, 0x63a9},
  {0x3167, 0x63f4}, {0x3168, 0x6cbf}, {0x3169, 0x6f14}, {0x316a, 0x708e},
  {0x316b, 0x7114}, {0x316c, 0x7159}, {0x316d, 0x71d5}, {0x316e, 0x733f},
  {0x316f, 0x7e01}, {0x3170, 0x8276}, {0x3171, 0x82d1}, {0x3172, 0x8597},
  {0x3173, 0x9060}, {0x3174, 0x925b}, {0x3175, 0x9d1b}, {0x3176, 0x5869},
  {0x3177, 0x65bc}, {0x3178, 0x6c5a}, {0x3179, 0x7525}, {0x317a, 0x51f9},
  {0x317b, 0x592e}, {0x317c, 0x5965}, {0x317d, 0x5f80}, {0x317e, 0x5fdc},
  {0x3221, 0x62bc}, {0x3222, 0x65fa}, {0x3223, 0x6a2a}, {0x3224, 0x6b27},
  {0x3225, 0x6bb4}, {0x3226, 0x738b}, {0x3227, 0x7fc1}, {0x3228, 0x8956},
  {0x3229, 0x9d2c}, {0x322a, 0x9d0e}, {0x322b, 0x9ec4}, {0x322c, 0x5ca1},
  {0x322d, 0x6c96}, {0x322e, 0x837b}, {0x322f, 0x5104}, {0x3230, 0x5c4b},
  {0x3231, 0x61b6}, {0x3232, 0x81c6}, {0x3233, 0x6876}, {0x3234, 0x7261},
  {0x3235, 0x4e59}, {0x3236, 0x4ffa}, {0x3237, 0x5378}, {0x3238, 0x6069},
  {0x3239, 0x6e29}, {0x323a, 0x7a4f}, {0x323b, 0x97f3}, {0x323c, 0x4e0b},
  {0x323d, 0x5316}, {0x323e, 0x4eee}, {0x323f, 0x4f55}, {0x3240, 0x4f3d},
  {0x3241, 0x4fa1}, {0x3242, 0x4f73}, {0x3243, 0x52a0}, {0x3244, 0x53ef},
  {0x3245, 0x5609}, {0x3246, 0x590f}, {0x3247, 0x5ac1}, {0x3248, 0x5bb6},
  {0x3249, 0x5be1}, {0x324a, 0x79d1}, {0x324b, 0x6687}, {0x324c, 0x679c},
  {0x324d, 0x67b6}, {0x324e, 0x6b4c}, {0x324f, 0x6cb3}, {0x3250, 0x706b},
  {0x3251, 0x73c2}, {0x3252, 0x798d}, {0x3253, 0x79be}, {0x3254, 0x7a3c},
  {0x3255, 0x7b87}, {0x3256, 0x82b1}, {0x3257, 0x82db}, {0x3258, 0x8304},
  {0x3259, 0x8377}, {0x325a, 0x83ef}, {0x325b, 0x83d3}, {0x325c, 0x8766},
  {0x325d, 0x8ab2}, {0x325e, 0x5629}, {0x325f, 0x8ca8}, {0x3260, 0x8fe6},
  {0x3261, 0x904e}, {0x3262, 0x971e}, {0x3263, 0x868a}, {0x3264, 0x4fc4},
  {0x3265, 0x5ce8}, {0x3266, 0x6211}, {0x3267, 0x7259}, {0x3268, 0x753b},
  {0x3269, 0x81e5}, {0x326a, 0x82bd}, {0x326b, 0x86fe}, {0x326c, 0x8cc0},
  {0x326d, 0x96c5}, {0x326e, 0x9913}, {0x326f, 0x99d5}, {0x3270, 0x4ecb},
  {0x3271, 0x4f1a}, {0x3272, 0x89e3}, {0x3273, 0x56de}, {0x3274, 0x584a},
  {0x3275, 0x58ca}, {0x3276, 0x5efb}, {0x3277, 0x5feb}, {0x3278, 0x602a},
  {0x3279, 0x6094}, {0x327a, 0x6062}, {0x327b, 0x61d0}, {0x327c, 0x6212},
  {0x327d, 0x62d0}, {0x327e, 0x6539}, {0x3321, 0x9b41}, {0x3322, 0x6666},
  {0x3323, 0x68b0}, {0x3324, 0x6d77}, {0x3325, 0x7070}, {0x3326, 0x754c},
  {0x3327, 0x7686}, {0x3328, 0x7d75}, {0x3329, 0x82a5}, {0x332a, 0x87f9},
  {0x332b, 0x958b}, {0x332c, 0x968e}, {0x332d, 0x8c9d}, {0x332e, 0x51f1},
  {0x332f, 0x52be}, {0x3330, 0x5916}, {0x3331, 0x54b3}, {0x3332, 0x5bb3},
  {0x3333, 0x5d16}, {0x3334, 0x6168}, {0x3335, 0x6982}, {0x3336, 0x6daf},
  {0x3337, 0x788d}, {0x3338, 0x84cb}, {0x3339, 0x8857}, {0x333a, 0x8a72},
  {0x333b, 0x93a7}, {0x333c, 0x9ab8}, {0x333d, 0x6d6c}, {0x333e, 0x99a8},
  {0x333f, 0x86d9}, {0x3340, 0x57a3}, {0x3341, 0x67ff}, {0x3342, 0x86ce},
  {0x3343, 0x920e}, {0x3344, 0x5283}, {0x3345, 0x5687}, {0x3346, 0x5404},
  {0x3347, 0x5ed3}, {0x3348, 0x62e1}, {0x3349, 0x64b9}, {0x334a, 0x683c},
  {0x334b, 0x6838}, {0x334c, 0x6bbb}, {0x334d, 0x7372}, {0x334e, 0x78ba},
  {0x334f, 0x7a6b}, {0x3350, 0x899a}, {0x3351, 0x89d2}, {0x3352, 0x8d6b},
  {0x3353, 0x8f03}, {0x3354, 0x90ed}, {0x3355, 0x95a3}, {0x3356, 0x9694},
  {0x3357, 0x9769}, {0x3358, 0x5b66}, {0x3359, 0x5cb3}, {0x335a, 0x697d},
  {0x335b, 0x984d}, {0x335c, 0x984e}, {0x335d, 0x639b}, {0x335e, 0x7b20},
  {0x335f, 0x6a2b}, {0x3360, 0x6a7f}, {0x3361, 0x68b6}, {0x3362, 0x9c0d},
  {0x3363, 0x6f5f}, {0x3364, 0x5272}, {0x3365, 0x559d}, {0x3366, 0x6070},
  {0x3367, 0x62ec}, {0x3368, 0x6d3b}, {0x3369, 0x6e07}, {0x336a, 0x6ed1},
  {0x336b, 0x845b}, {0x336c, 0x8910}, {0x336d, 0x8f44}, {0x336e, 0x4e14},
  {0x336f, 0x9c39}, {0x3370, 0x53f6}, {0x3371, 0x691b}, {0x3372, 0x6a3a},
  {0x3373, 0x9784}, {0x3374, 0x682a}, {0x3375, 0x515c}, {0x3376, 0x7ac3},
  {0x3377, 0x84b2}, {0x3378, 0x91dc}, {0x3379, 0x938c}, {0x337a, 0x565b},
  {0x337b, 0x9d28}, {0x337c, 0x6822}, {0x337d, 0x8305}, {0x337e, 0x8431},
  {0x3421, 0x7ca5}, {0x3422, 0x5208}, {0x3423, 0x82c5}, {0x3424, 0x74e6},
  {0x3425, 0x4e7e}, {0x3426, 0x4f83}, {0x3427, 0x51a0}, {0x3428, 0x5bd2},
  {0x3429, 0x520a}, {0x342a, 0x52d8}, {0x342b, 0x52e7}, {0x342c, 0x5dfb},
  {0x342d, 0x559a}, {0x342e, 0x582a}, {0x342f, 0x59e6}, {0x3430, 0x5b8c},
  {0x3431, 0x5b98}, {0x3432, 0x5bdb}, {0x3433, 0x5e72}, {0x3434, 0x5e79},
  {0x3435, 0x60a3}, {0x3436, 0x611f}, {0x3437, 0x6163}, {0x3438, 0x61be},
  {0x3439, 0x63db}, {0x343a, 0x6562}, {0x343b, 0x67d1}, {0x343c, 0x6853},
  {0x343d, 0x68fa}, {0x343e, 0x6b3e}, {0x343f, 0x6b53}, {0x3440, 0x6c57},
  {0x3441, 0x6f22}, {0x3442, 0x6f97}, {0x3443, 0x6f45}, {0x3444, 0x74b0},
  {0x3445, 0x7518}, {0x3446, 0x76e3}, {0x3447, 0x770b}, {0x3448, 0x7aff},
  {0x3449, 0x7ba1}, {0x344a, 0x7c21}, {0x344b, 0x7de9}, {0x344c, 0x7f36},
  {0x344d, 0x7ff0}, {0x344e, 0x809d}, {0x344f, 0x8266}, {0x3450, 0x839e},
  {0x3451, 0x89b3}, {0x3452, 0x8acc}, {0x3453, 0x8cab}, {0x3454, 0x9084},
  {0x3455, 0x9451}, {0x3456, 0x9593}, {0x3457, 0x9591}, {0x3458, 0x95a2},
  {0x3459, 0x9665}, {0x345a, 0x97d3}, {0x345b, 0x9928}, {0x345c, 0x8218},
  {0x345d, 0x4e38}, {0x345e, 0x542b}, {0x345f, 0x5cb8}, {0x3460, 0x5dcc},
  {0x3461, 0x73a9}, {0x3462, 0x764c}, {0x3463, 0x773c}, {0x3464, 0x5ca9},
  {0x3465, 0x7feb}, {0x3466, 0x8d0b}, {0x3467, 0x96c1}, {0x3468, 0x9811},
  {0x3469, 0x9854}, {0x346a, 0x9858}, {0x346b, 0x4f01}, {0x346c, 0x4f0e},
  {0x346d, 0x5371}, {0x346e, 0x559c}, {0x346f, 0x5668}, {0x3470, 0x57fa},
  {0x3471, 0x5947}, {0x3472, 0x5b09}, {0x3473, 0x5bc4}, {0x3474, 0x5c90},
  {0x3475, 0x5e0c}, {0x3476, 0x5e7e}, {0x3477, 0x5fcc}, {0x3478, 0x63ee},
  {0x3479, 0x673a}, {0x347a, 0x65d7}, {0x347b, 0x65e2}, {0x347c, 0x671f},
  {0x347d, 0x68cb}, {0x347e, 0x68c4}, {0x3521, 0x6a5f}, {0x3522, 0x5e30},
  {0x3523, 0x6bc5}, {0x3524, 0x6c17}, {0x3525, 0x6c7d}, {0x3526, 0x757f},
  {0x3527, 0x7948}, {0x3528, 0x5b63}, {0x3529, 0x7a00}, {0x352a, 0x7d00},
  {0x352b, 0x5fbd}, {0x352c, 0x898f}, {0x352d, 0x8a18}, {0x352e, 0x8cb4},
  {0x352f, 0x8d77}, {0x3530, 0x8ecc}, {0x3531, 0x8f1d}, {0x3532, 0x98e2},
  {0x3533, 0x9a0e}, {0x3534, 0x9b3c}, {0x3535, 0x4e80}, {0x3536, 0x507d},
  {0x3537, 0x5100}, {0x3538, 0x5993}, {0x3539, 0x5b9c}, {0x353a, 0x622f},
  {0x353b, 0x6280}, {0x353c, 0x64ec}, {0x353d, 0x6b3a}, {0x353e, 0x72a0},
  {0x353f, 0x7591}, {0x3540, 0x7947}, {0x3541, 0x7fa9}, {0x3542, 0x87fb},
  {0x3543, 0x8abc}, {0x3544, 0x8b70}, {0x3545, 0x63ac}, {0x3546, 0x83ca},
  {0x3547, 0x97a0}, {0x3548, 0x5409}, {0x3549, 0x5403}, {0x354a, 0x55ab},
  {0x354b, 0x6854}, {0x354c, 0x6a58}, {0x354d, 0x8a70}, {0x354e, 0x7827},
  {0x354f, 0x6775}, {0x3550, 0x9ecd}, {0x3551, 0x5374}, {0x3552, 0x5ba2},
  {0x3553, 0x811a}, {0x3554, 0x8650}, {0x3555, 0x9006}, {0x3556, 0x4e18},
  {0x3557, 0x4e45}, {0x3558, 0x4ec7}, {0x3559, 0x4f11}, {0x355a, 0x53ca},
  {0x355b, 0x5438}, {0x355c, 0x5bae}, {0x355d, 0x5f13}, {0x355e, 0x6025},
  {0x355f, 0x6551}, {0x3560, 0x673d}, {0x3561, 0x6c42}, {0x3562, 0x6c72},
  {0x3563, 0x6ce3}, {0x3564, 0x7078}, {0x3565, 0x7403}, {0x3566, 0x7a76},
  {0x3567, 0x7aae}, {0x3568, 0x7b08}, {0x3569, 0x7d1a}, {0x356a, 0x7cfe},
  {0x356b, 0x7d66}, {0x356c, 0x65e7}, {0x356d, 0x725b}, {0x356e, 0x53bb},
  {0x356f, 0x5c45}, {0x3570, 0x5de8}, {0x3571, 0x62d2}, {0x3572, 0x62e0},
  {0x3573, 0x6319}, {0x3574, 0x6e20}, {0x3575, 0x865a}, {0x3576, 0x8a31},
  {0x3577, 0x8ddd}, {0x3578, 0x92f8}, {0x3579, 0x6f01}, {0x357a, 0x79a6},
  {0x357b, 0x9b5a}, {0x357c, 0x4ea8}, {0x357d, 0x4eab}, {0x357e, 0x4eac},
  {0x3621, 0x4f9b}, {0x3622, 0x4fa0}, {0x3623, 0x50d1}, {0x3624, 0x5147},
  {0x3625, 0x7af6}, {0x3626, 0x5171}, {0x3627, 0x51f6}, {0x3628, 0x5354},
  {0x3629, 0x5321}, {0x362a, 0x537f}, {0x362b, 0x53eb}, {0x362c, 0x55ac},
  {0x362d, 0x5883}, {0x362e, 0x5ce1}, {0x362f, 0x5f37}, {0x3630, 0x5f4a},
  {0x3631, 0x602f}, {0x3632, 0x6050}, {0x3633, 0x606d}, {0x3634, 0x631f},
  {0x3635, 0x6559}, {0x3636, 0x6a4b}, {0x3637, 0x6cc1}, {0x3638, 0x72c2},
  {0x3639, 0x72ed}, {0x363a, 0x77ef}, {0x363b, 0x80f8}, {0x363c, 0x8105},
  {0x363d, 0x8208}, {0x363e, 0x854e}, {0x363f, 0x90f7}, {0x3640, 0x93e1},
  {0x3641, 0x97ff}, {0x3642, 0x9957}, {0x3643, 0x9a5a}, {0x3644, 0x4ef0},
  {0x3645, 0x51dd}, {0x3646, 0x5c2d}, {0x3647, 0x6681}, {0x3648, 0x696d},
  {0x3649, 0x5c40}, {0x364a, 0x66f2}, {0x364b, 0x6975}, {0x364c, 0x7389},
  {0x364d, 0x6850}, {0x364e, 0x7c81}, {0x364f, 0x50c5}, {0x3650, 0x52e4},
  {0x3651, 0x5747}, {0x3652, 0x5dfe}, {0x3653, 0x9326}, {0x3654, 0x65a4},
  {0x3655, 0x6b23}, {0x3656, 0x6b3d}, {0x3657, 0x7434}, {0x3658, 0x7981},
  {0x3659, 0x79bd}, {0x365a, 0x7b4b}, {0x365b, 0x7dca}, {0x365c, 0x82b9},
  {0x365d, 0x83cc}, {0x365e, 0x887f}, {0x365f, 0x895f}, {0x3660, 0x8b39},
  {0x3661, 0x8fd1}, {0x3662, 0x91d1}, {0x3663, 0x541f}, {0x3664, 0x9280},
  {0x3665, 0x4e5d}, {0x3666, 0x5036}, {0x3667, 0x53e5}, {0x3668, 0x533a},
  {0x3669, 0x72d7}, {0x366a, 0x7396}, {0x366b, 0x77e9}, {0x366c, 0x82e6},
  {0x366d, 0x8eaf}, {0x366e, 0x99c6}, {0x366f, 0x99c8}, {0x3670, 0x99d2},
  {0x3671, 0x5177}, {0x3672, 0x611a}, {0x3673, 0x865e}, {0x3674, 0x55b0},
  {0x3675, 0x7a7a}, {0x3676, 0x5076}, {0x3677, 0x5bd3}, {0x3678, 0x9047},
  {0x3679, 0x9685}, {0x367a, 0x4e32}, {0x367b, 0x6adb}, {0x367c, 0x91e7},
  {0x367d, 0x5c51}, {0x367e, 0x5c48}, {0x3721, 0x6398}, {0x3722, 0x7a9f},
  {0x3723, 0x6c93}, {0x3724, 0x9774}, {0x3725, 0x8f61}, {0x3726, 0x7aaa},
  {0x3727, 0x718a}, {0x3728, 0x9688}, {0x3729, 0x7c82}, {0x372a, 0x6817},
  {0x372b, 0x7e70}, {0x372c, 0x6851}, {0x372d, 0x936c}, {0x372e, 0x52f2},
  {0x372f, 0x541b}, {0x3730, 0x85ab}, {0x3731, 0x8a13}, {0x3732, 0x7fa4},
  {0x3733, 0x8ecd}, {0x3734, 0x90e1}, {0x3735, 0x5366}, {0x3736, 0x8888},
  {0x3737, 0x7941}, {0x3738, 0x4fc2}, {0x3739, 0x50be}, {0x373a, 0x5211},
  {0x373b, 0x5144}, {0x373c, 0x5553}, {0x373d, 0x572d}, {0x373e, 0x73ea},
  {0x373f, 0x578b}, {0x3740, 0x5951}, {0x3741, 0x5f62}, {0x3742, 0x5f84},
  {0x3743, 0x6075}, {0x3744, 0x6176}, {0x3745, 0x6167}, {0x3746, 0x61a9},
  {0x3747, 0x63b2}, {0x3748, 0x643a}, {0x3749, 0x656c}, {0x374a, 0x666f},
  {0x374b, 0x6842}, {0x374c, 0x6e13}, {0x374d, 0x7566}, {0x374e, 0x7a3d},
  {0x374f, 0x7cfb}, {0x3750, 0x7d4c}, {0x3751, 0x7d99}, {0x3752, 0x7e4b},
  {0x3753, 0x7f6b}, {0x3754, 0x830e}, {0x3755, 0x834a}, {0x3756, 0x86cd},
  {0x3757, 0x8a08}, {0x3758, 0x8a63}, {0x3759, 0x8b66}, {0x375a, 0x8efd},
  {0x375b, 0x981a}, {0x375c, 0x9d8f}, {0x375d, 0x82b8}, {0x375e, 0x8fce},
  {0x375f, 0x9be8}, {0x3760, 0x5287}, {0x3761, 0x621f}, {0x3762, 0x6483},
  {0x3763, 0x6fc0}, {0x3764, 0x9699}, {0x3765, 0x6841}, {0x3766, 0x5091},
  {0x3767, 0x6b20}, {0x3768, 0x6c7a}, {0x3769, 0x6f54}, {0x376a, 0x7a74},
  {0x376b, 0x7d50}, {0x376c, 0x8840}, {0x376d, 0x8a23}, {0x376e, 0x6708},
  {0x376f, 0x4ef6}, {0x3770, 0x5039}, {0x3771, 0x5026}, {0x3772, 0x5065},
  {0x3773, 0x517c}, {0x3774, 0x5238}, {0x3775, 0x5263}, {0x3776, 0x55a7},
  {0x3777, 0x570f}, {0x3778, 0x5805}, {0x3779, 0x5acc}, {0x377a, 0x5efa},
  {0x377b, 0x61b2}, {0x377c, 0x61f8}, {0x377d, 0x62f3}, {0x377e, 0x6372},
  {0x3821, 0x691c}, {0x3822, 0x6a29}, {0x3823, 0x727d}, {0x3824, 0x72ac},
  {0x3825, 0x732e}, {0x3826, 0x7814}, {0x3827, 0x786f}, {0x3828, 0x7d79},
  {0x3829, 0x770c}, {0x382a, 0x80a9}, {0x382b, 0x898b}, {0x382c, 0x8b19},
  {0x382d, 0x8ce2}, {0x382e, 0x8ed2}, {0x382f, 0x9063}, {0x3830, 0x9375},
  {0x3831, 0x967a}, {0x3832, 0x9855}, {0x3833, 0x9a13}, {0x3834, 0x9e78},
  {0x3835, 0x5143}, {0x3836, 0x539f}, {0x3837, 0x53b3}, {0x3838, 0x5e7b},
  {0x3839, 0x5f26}, {0x383a, 0x6e1b}, {0x383b, 0x6e90}, {0x383c, 0x7384},
  {0x383d, 0x73fe}, {0x383e, 0x7d43}, {0x383f, 0x8237}, {0x3840, 0x8a00},
  {0x3841, 0x8afa}, {0x3842, 0x9650}, {0x3843, 0x4e4e}, {0x3844, 0x500b},
  {0x3845, 0x53e4}, {0x3846, 0x547c}, {0x3847, 0x56fa}, {0x3848, 0x59d1},
  {0x3849, 0x5b64}, {0x384a, 0x5df1}, {0x384b, 0x5eab}, {0x384c, 0x5f27},
  {0x384d, 0x6238}, {0x384e, 0x6545}, {0x384f, 0x67af}, {0x3850, 0x6e56},
  {0x3851, 0x72d0}, {0x3852, 0x7cca}, {0x3853, 0x88b4}, {0x3854, 0x80a1},
  {0x3855, 0x80e1}, {0x3856, 0x83f0}, {0x3857, 0x864e}, {0x3858, 0x8a87},
  {0x3859, 0x8de8}, {0x385a, 0x9237}, {0x385b, 0x96c7}, {0x385c, 0x9867},
  {0x385d, 0x9f13}, {0x385e, 0x4e94}, {0x385f, 0x4e92}, {0x3860, 0x4f0d},
  {0x3861, 0x5348}, {0x3862, 0x5449}, {0x3863, 0x543e}, {0x3864, 0x5a2f},
  {0x3865, 0x5f8c}, {0x3866, 0x5fa1}, {0x3867, 0x609f}, {0x3868, 0x68a7},
  {0x3869, 0x6a8e}, {0x386a, 0x745a}, {0x386b, 0x7881}, {0x386c, 0x8a9e},
  {0x386d, 0x8aa4}, {0x386e, 0x8b77}, {0x386f, 0x9190}, {0x3870, 0x4e5e},
  {0x3871, 0x9bc9}, {0x3872, 0x4ea4}, {0x3873, 0x4f7c}, {0x3874, 0x4faf},
  {0x3875, 0x5019}, {0x3876, 0x5016}, {0x3877, 0x5149}, {0x3878, 0x516c},
  {0x3879, 0x529f}, {0x387a, 0x52b9}, {0x387b, 0x52fe}, {0x387c, 0x539a},
  {0x387d, 0x53e3}, {0x387e, 0x5411}, {0x3921, 0x540e}, {0x3922, 0x5589},
  {0x3923, 0x5751}, {0x3924, 0x57a2}, {0x3925, 0x597d}, {0x3926, 0x5b54},
  {0x3927, 0x5b5d}, {0x3928, 0x5b8f}, {0x3929, 0x5de5}, {0x392a, 0x5de7},
  {0x392b, 0x5df7}, {0x392c, 0x5e78}, {0x392d, 0x5e83}, {0x392e, 0x5e9a},
  {0x392f, 0x5eb7}, {0x3930, 0x5f18}, {0x3931, 0x6052}, {0x3932, 0x614c},
  {0x3933, 0x6297}, {0x3934, 0x62d8}, {0x3935, 0x63a7}, {0x3936, 0x653b},
  {0x3937, 0x6602}, {0x3938, 0x6643}, {0x3939, 0x66f4}, {0x393a, 0x676d},
  {0x393b, 0x6821}, {0x393c, 0x6897}, {0x393d, 0x69cb}, {0x393e, 0x6c5f},
  {0x393f, 0x6d2a}, {0x3940, 0x6d69}, {0x3941, 0x6e2f}, {0x3942, 0x6e9d},
  {0x3943, 0x7532}, {0x3944, 0x7687}, {0x3945, 0x786c}, {0x3946, 0x7a3f},
  {0x3947, 0x7ce0}, {0x3948, 0x7d05}, {0x3949, 0x7d18}, {0x394a, 0x7d5e},
  {0x394b, 0x7db1}, {0x394c, 0x8015}, {0x394d, 0x8003}, {0x394e, 0x80af},
  {0x394f, 0x80b1}, {0x3950, 0x8154}, {0x3951, 0x818f}, {0x3952, 0x822a},
  {0x3953, 0x8352}, {0x3954, 0x884c}, {0x3955, 0x8861}, {0x3956, 0x8b1b},
  {0x3957, 0x8ca2}, {0x3958, 0x8cfc}, {0x3959, 0x90ca}, {0x395a, 0x9175},
  {0x395b, 0x9271}, {0x395c, 0x783f}, {0x395d, 0x92fc}, {0x395e, 0x95a4},
  {0x395f, 0x964d}, {0x3960, 0x9805}, {0x3961, 0x9999}, {0x3962, 0x9ad8},
  {0x3963, 0x9d3b}, {0x3964, 0x525b}, {0x3965, 0x52ab}, {0x3966, 0x53f7},
  {0x3967, 0x5408}, {0x3968, 0x58d5}, {0x3969, 0x62f7}, {0x396a, 0x6fe0},
  {0x396b, 0x8c6a}, {0x396c, 0x8f5f}, {0x396d, 0x9eb9}, {0x396e, 0x514b},
  {0x396f, 0x523b}, {0x3970, 0x544a}, {0x3971, 0x56fd}, {0x3972, 0x7a40},
  {0x3973, 0x9177}, {0x3974, 0x9d60}, {0x3975, 0x9ed2}, {0x3976, 0x7344},
  {0x3977, 0x6f09}, {0x3978, 0x8170}, {0x3979, 0x7511}, {0x397a, 0x5ffd},
  {0x397b, 0x60da}, {0x397c, 0x9aa8}, {0x397d, 0x72db}, {0x397e, 0x8fbc},
  {0x3a21, 0x6b64}, {0x3a22, 0x9803}, {0x3a23, 0x4eca}, {0x3a24, 0x56f0},
  {0x3a25, 0x5764}, {0x3a26, 0x58be}, {0x3a27, 0x5a5a}, {0x3a28, 0x6068},
  {0x3a29, 0x61c7}, {0x3a2a, 0x660f}, {0x3a2b, 0x6606}, {0x3a2c, 0x6839},
  {0x3a2d, 0x68b1}, {0x3a2e, 0x6df7}, {0x3a2f, 0x75d5}, {0x3a30, 0x7d3a},
  {0x3a31, 0x826e}, {0x3a32, 0x9b42}, {0x3a33, 0x4e9b}, {0x3a34, 0x4f50},
  {0x3a35, 0x53c9}, {0x3a36, 0x5506}, {0x3a37, 0x5d6f}, {0x3a38, 0x5de6},
  {0x3a39, 0x5dee}, {0x3a3a, 0x67fb}, {0x3a3b, 0x6c99}, {0x3a3c, 0x7473},
  {0x3a3d, 0x7802}, {0x3a3e, 0x8a50}, {0x3a3f, 0x9396}, {0x3a40, 0x88df},
  {0x3a41, 0x5750}, {0x3a42, 0x5ea7}, {0x3a43, 0x632b}, {0x3a44, 0x50b5},
  {0x3a45, 0x50ac}, {0x3a46, 0x518d}, {0x3a47, 0x6700}, {0x3a48, 0x54c9},
  {0x3a49, 0x585e}, {0x3a4a, 0x59bb}, {0x3a4b, 0x5bb0}, {0x3a4c, 0x5f69},
  {0x3a4d, 0x624d}, {0x3a4e, 0x63a1}, {0x3a4f, 0x683d}, {0x3a50, 0x6b73},
  {0x3a51, 0x6e08}, {0x3a52, 0x707d}, {0x3a53, 0x91c7}, {0x3a54, 0x7280},
  {0x3a55, 0x7815}, {0x3a56, 0x7826}, {0x3a57, 0x796d}, {0x3a58, 0x658e},
  {0x3a59, 0x7d30}, {0x3a5a, 0x83dc}, {0x3a5b, 0x88c1}, {0x3a5c, 0x8f09},
  {0x3a5d, 0x969b}, {0x3a5e, 0x5264}, {0x3a5f, 0x5728}, {0x3a60, 0x6750},
  {0x3a61, 0x7f6a}, {0x3a62, 0x8ca1}, {0x3a63, 0x51b4}, {0x3a64, 0x5742},
  {0x3a65, 0x962a}, {0x3a66, 0x583a}, {0x3a67, 0x698a}, {0x3a68, 0x80b4},
  {0x3a69, 0x54b2}, {0x3a6a, 0x5d0e}, {0x3a6b, 0x57fc}, {0x3a6c, 0x7895},
  {0x3a6d, 0x9dfa}, {0x3a6e, 0x4f5c}, {0x3a6f, 0x524a}, {0x3a70, 0x548b},
  {0x3a71, 0x643e}, {0x3a72, 0x6628}, {0x3a73, 0x6714}, {0x3a74, 0x67f5},
  {0x3a75, 0x7a84}, {0x3a76, 0x7b56}, {0x3a77, 0x7d22}, {0x3a78, 0x932f},
  {0x3a79, 0x685c}, {0x3a7a, 0x9bad}, {0x3a7b, 0x7b39}, {0x3a7c, 0x5319},
  {0x3a7d, 0x518a}, {0x3a7e, 0x5237}, {0x3b21, 0x5bdf}, {0x3b22, 0x62f6},
  {0x3b23, 0x64ae}, {0x3b24, 0x64e6}, {0x3b25, 0x672d}, {0x3b26, 0x6bba},
  {0x3b27, 0x85a9}, {0x3b28, 0x96d1}, {0x3b29, 0x7690}, {0x3b2a, 0x9bd6},
  {0x3b2b, 0x634c}, {0x3b2c, 0x9306}, {0x3b2d, 0x9bab}, {0x3b2e, 0x76bf},
  {0x3b2f, 0x6652}, {0x3b30, 0x4e09}, {0x3b31, 0x5098}, {0x3b32, 0x53c2},
  {0x3b33, 0x5c71}, {0x3b34, 0x60e8}, {0x3b35, 0x6492}, {0x3b36, 0x6563},
  {0x3b37, 0x685f}, {0x3b38, 0x71e6}, {0x3b39, 0x73ca}, {0x3b3a, 0x7523},
  {0x3b3b, 0x7b97}, {0x3b3c, 0x7e82}, {0x3b3d, 0x8695}, {0x3b3e, 0x8b83},
  {0x3b3f, 0x8cdb}, {0x3b40, 0x9178}, {0x3b41, 0x9910}, {0x3b42, 0x65ac},
  {0x3b43, 0x66ab}, {0x3b44, 0x6b8b}, {0x3b45, 0x4ed5}, {0x3b46, 0x4ed4},
  {0x3b47, 0x4f3a}, {0x3b48, 0x4f7f}, {0x3b49, 0x523a}, {0x3b4a, 0x53f8},
  {0x3b4b, 0x53f2}, {0x3b4c, 0x55e3}, {0x3b4d, 0x56db}, {0x3b4e, 0x58eb},
  {0x3b4f, 0x59cb}, {0x3b50, 0x59c9}, {0x3b51, 0x59ff}, {0x3b52, 0x5b50},
  {0x3b53, 0x5c4d}, {0x3b54, 0x5e02}, {0x3b55, 0x5e2b}, {0x3b56, 0x5fd7},
  {0x3b57, 0x601d}, {0x3b58, 0x6307}, {0x3b59, 0x652f}, {0x3b5a, 0x5b5c},
  {0x3b5b, 0x65af}, {0x3b5c, 0x65bd}, {0x3b5d, 0x65e8}, {0x3b5e, 0x679d},
  {0x3b5f, 0x6b62}, {0x3b60, 0x6b7b}, {0x3b61, 0x6c0f}, {0x3b62, 0x7345},
  {0x3b63, 0x7949}, {0x3b64, 0x79c1}, {0x3b65, 0x7cf8}, {0x3b66, 0x7d19},
  {0x3b67, 0x7d2b}, {0x3b68, 0x80a2}, {0x3b69, 0x8102}, {0x3b6a, 0x81f3},
  {0x3b6b, 0x8996}, {0x3b6c, 0x8a5e}, {0x3b6d, 0x8a69}, {0x3b6e, 0x8a66},
  {0x3b6f, 0x8a8c}, {0x3b70, 0x8aee}, {0x3b71, 0x8cc7}, {0x3b72, 0x8cdc},
  {0x3b73, 0x96cc}, {0x3b74, 0x98fc}, {0x3b75, 0x6b6f}, {0x3b76, 0x4e8b},
  {0x3b77, 0x4f3c}, {0x3b78, 0x4f8d}, {0x3b79, 0x5150}, {0x3b7a, 0x5b57},
  {0x3b7b, 0x5bfa}, {0x3b7c, 0x6148}, {0x3b7d, 0x6301}, {0x3b7e, 0x6642},
  {0x3c21, 0x6b21}, {0x3c22, 0x6ecb}, {0x3c23, 0x6cbb}, {0x3c24, 0x723e},
  {0x3c25, 0x74bd}, {0x3c26, 0x75d4}, {0x3c27, 0x78c1}, {0x3c28, 0x793a},
  {0x3c29, 0x800c}, {0x3c2a, 0x8033}, {0x3c2b, 0x81ea}, {0x3c2c, 0x8494},
  {0x3c2d, 0x8f9e}, {0x3c2e, 0x6c50}, {0x3c2f, 0x9e7f}, {0x3c30, 0x5f0f},
  {0x3c31, 0x8b58}, {0x3c32, 0x9d2b}, {0x3c33, 0x7afa}, {0x3c34, 0x8ef8},
  {0x3c35, 0x5b8d}, {0x3c36, 0x96eb}, {0x3c37, 0x4e03}, {0x3c38, 0x53f1},
  {0x3c39, 0x57f7}, {0x3c3a, 0x5931}, {0x3c3b, 0x5ac9}, {0x3c3c, 0x5ba4},
  {0x3c3d, 0x6089}, {0x3c3e, 0x6e7f}, {0x3c3f, 0x6f06}, {0x3c40, 0x75be},
  {0x3c41, 0x8cea}, {0x3c42, 0x5b9f}, {0x3c43, 0x8500}, {0x3c44, 0x7be0},
  {0x3c45, 0x5072}, {0x3c46, 0x67f4}, {0x3c47, 0x829d}, {0x3c48, 0x5c61},
  {0x3c49, 0x854a}, {0x3c4a, 0x7e1e}, {0x3c4b, 0x820e}, {0x3c4c, 0x5199},
  {0x3c4d, 0x5c04}, {0x3c4e, 0x6368}, {0x3c4f, 0x8d66}, {0x3c50, 0x659c},
  {0x3c51, 0x716e}, {0x3c52, 0x793e}, {0x3c53, 0x7d17}, {0x3c54, 0x8005},
  {0x3c55, 0x8b1d}, {0x3c56, 0x8eca}, {0x3c57, 0x906e}, {0x3c58, 0x86c7},
  {0x3c59, 0x90aa}, {0x3c5a, 0x501f}, {0x3c5b, 0x52fa}, {0x3c5c, 0x5c3a},
  {0x3c5d, 0x6753}, {0x3c5e, 0x707c}, {0x3c5f, 0x7235}, {0x3c60, 0x914c},
  {0x3c61, 0x91c8}, {0x3c62, 0x932b}, {0x3c63, 0x82e5}, {0x3c64, 0x5bc2},
  {0x3c65, 0x5f31}, {0x3c66, 0x60f9}, {0x3c67, 0x4e3b}, {0x3c68, 0x53d6},
  {0x3c69, 0x5b88}, {0x3c6a, 0x624b}, {0x3c6b, 0x6731}, {0x3c6c, 0x6b8a},
  {0x3c6d, 0x72e9}, {0x3c6e, 0x73e0}, {0x3c6f, 0x7a2e}, {0x3c70, 0x816b},
  {0x3c71, 0x8da3}, {0x3c72, 0x9152}, {0x3c73, 0x9996}, {0x3c74, 0x5112},
  {0x3c75, 0x53d7}, {0x3c76, 0x546a}, {0x3c77, 0x5bff}, {0x3c78, 0x6388},
  {0x3c79, 0x6a39}, {0x3c7a, 0x7dac}, {0x3c7b, 0x9700}, {0x3c7c, 0x56da},
  {0x3c7d, 0x53ce}, {0x3c7e, 0x5468}, {0x3d21, 0x5b97}, {0x3d22, 0x5c31},
  {0x3d23, 0x5dde}, {0x3d24, 0x4fee}, {0x3d25, 0x6101}, {0x3d26, 0x62fe},
  {0x3d27, 0x6d32}, {0x3d28, 0x79c0}, {0x3d29, 0x79cb}, {0x3d2a, 0x7d42},
  {0x3d2b, 0x7e4d}, {0x3d2c, 0x7fd2}, {0x3d2d, 0x81ed}, {0x3d2e, 0x821f},
  {0x3d2f, 0x8490}, {0x3d30, 0x8846}, {0x3d31, 0x8972}, {0x3d32, 0x8b90},
  {0x3d33, 0x8e74}, {0x3d34, 0x8f2f}, {0x3d35, 0x9031}, {0x3d36, 0x914b},
  {0x3d37, 0x916c}, {0x3d38, 0x96c6}, {0x3d39, 0x919c}, {0x3d3a, 0x4ec0},
  {0x3d3b, 0x4f4f}, {0x3d3c, 0x5145}, {0x3d3d, 0x5341}, {0x3d3e, 0x5f93},
  {0x3d3f, 0x620e}, {0x3d40, 0x67d4}, {0x3d41, 0x6c41}, {0x3d42, 0x6e0b},
  {0x3d43, 0x7363}, {0x3d44, 0x7e26}, {0x3d45, 0x91cd}, {0x3d46, 0x9283},
  {0x3d47, 0x53d4}, {0x3d48, 0x5919}, {0x3d49, 0x5bbf}, {0x3d4a, 0x6dd1},
  {0x3d4b, 0x795d}, {0x3d4c, 0x7e2e}, {0x3d4d, 0x7c9b}, {0x3d4e, 0x587e},
  {0x3d4f, 0x719f}, {0x3d50, 0x51fa}, {0x3d51, 0x8853}, {0x3d52, 0x8ff0},
  {0x3d53, 0x4fca}, {0x3d54, 0x5cfb}, {0x3d55, 0x6625}, {0x3d56, 0x77ac},
  {0x3d57, 0x7ae3}, {0x3d58, 0x821c}, {0x3d59, 0x99ff}, {0x3d5a, 0x51c6},
  {0x3d5b, 0x5faa}, {0x3d5c, 0x65ec}, {0x3d5d, 0x696f}, {0x3d5e, 0x6b89},
  {0x3d5f, 0x6df3}, {0x3d60, 0x6e96}, {0x3d61, 0x6f64}, {0x3d62, 0x76fe},
  {0x3d63, 0x7d14}, {0x3d64, 0x5de1}, {0x3d65, 0x9075}, {0x3d66, 0x9187},
  {0x3d67, 0x9806}, {0x3d68, 0x51e6}, {0x3d69, 0x521d}, {0x3d6a, 0x6240},
  {0x3d6b, 0x6691}, {0x3d6c, 0x66d9}, {0x3d6d, 0x6e1a}, {0x3d6e, 0x5eb6},
  {0x3d6f, 0x7dd2}, {0x3d70, 0x7f72}, {0x3d71, 0x66f8}, {0x3d72, 0x85af},
  {0x3d73, 0x85f7}, {0x3d74, 0x8af8}, {0x3d75, 0x52a9}, {0x3d76, 0x53d9},
  {0x3d77, 0x5973}, {0x3d78, 0x5e8f}, {0x3d79, 0x5f90}, {0x3d7a, 0x6055},
  {0x3d7b, 0x92e4}, {0x3d7c, 0x9664}, {0x3d7d, 0x50b7}, {0x3d7e, 0x511f},
  {0x3e21, 0x52dd}, {0x3e22, 0x5320}, {0x3e23, 0x5347}, {0x3e24, 0x53ec},
  {0x3e25, 0x54e8}, {0x3e26, 0x5546}, {0x3e27, 0x5531}, {0x3e28, 0x5617},
  {0x3e29, 0x5968}, {0x3e2a, 0x59be}, {0x3e2b, 0x5a3c}, {0x3e2c, 0x5bb5},
  {0x3e2d, 0x5c06}, {0x3e2e, 0x5c0f}, {0x3e2f, 0x5c11}, {0x3e30, 0x5c1a},
  {0x3e31, 0x5e84}, {0x3e32, 0x5e8a}, {0x3e33, 0x5ee0}, {0x3e34, 0x5f70},
  {0x3e35, 0x627f}, {0x3e36, 0x6284}, {0x3e37, 0x62db}, {0x3e38, 0x638c},
  {0x3e39, 0x6377}, {0x3e3a, 0x6607}, {0x3e3b, 0x660c}, {0x3e3c, 0x662d},
  {0x3e3d, 0x6676}, {0x3e3e, 0x677e}, {0x3e3f, 0x68a2}, {0x3e40, 0x6a1f},
  {0x3e41, 0x6a35}, {0x3e42, 0x6cbc}, {0x3e43, 0x6d88}, {0x3e44, 0x6e09},
  {0x3e45, 0x6e58}, {0x3e46, 0x713c}, {0x3e47, 0x7126}, {0x3e48, 0x7167},
  {0x3e49, 0x75c7}, {0x3e4a, 0x7701}, {0x3e4b, 0x785d}, {0x3e4c, 0x7901},
  {0x3e4d, 0x7965}, {0x3e4e, 0x79f0}, {0x3e4f, 0x7ae0}, {0x3e50, 0x7b11},
  {0x3e51, 0x7ca7}, {0x3e52, 0x7d39}, {0x3e53, 0x8096}, {0x3e54, 0x83d6},
  {0x3e55, 0x848b}, {0x3e56, 0x8549}, {0x3e57, 0x885d}, {0x3e58, 0x88f3},
  {0x3e59, 0x8a1f}, {0x3e5a, 0x8a3c}, {0x3e5b, 0x8a54}, {0x3e5c, 0x8a73},
  {0x3e5d, 0x8c61}, {0x3e5e, 0x8cde}, {0x3e5f, 0x91a4}, {0x3e60, 0x9266},
  {0x3e61, 0x937e}, {0x3e62, 0x9418}, {0x3e63, 0x969c}, {0x3e64, 0x9798},
  {0x3e65, 0x4e0a}, {0x3e66, 0x4e08}, {0x3e67, 0x4e1e}, {0x3e68, 0x4e57},
  {0x3e69, 0x5197}, {0x3e6a, 0x5270}, {0x3e6b, 0x57ce}, {0x3e6c, 0x5834},
  {0x3e6d, 0x58cc}, {0x3e6e, 0x5b22}, {0x3e6f, 0x5e38}, {0x3e70, 0x60c5},
  {0x3e71, 0x64fe}, {0x3e72, 0x6761}, {0x3e73, 0x6756}, {0x3e74, 0x6d44},
  {0x3e75, 0x72b6}, {0x3e76, 0x7573}, {0x3e77, 0x7a63}, {0x3e78, 0x84b8},
  {0x3e79, 0x8b72}, {0x3e7a, 0x91b8}, {0x3e7b, 0x9320}, {0x3e7c, 0x5631},
  {0x3e7d, 0x57f4}, {0x3e7e, 0x98fe}, {0x3f21, 0x62ed}, {0x3f22, 0x690d},
  {0x3f23, 0x6b96}, {0x3f24, 0x71ed}, {0x3f25, 0x7e54}, {0x3f26, 0x8077},
  {0x3f27, 0x8272}, {0x3f28, 0x89e6}, {0x3f29, 0x98df}, {0x3f2a, 0x8755},
  {0x3f2b, 0x8fb1}, {0x3f2c, 0x5c3b}, {0x3f2d, 0x4f38}, {0x3f2e, 0x4fe1},
  {0x3f2f, 0x4fb5}, {0x3f30, 0x5507}, {0x3f31, 0x5a20}, {0x3f32, 0x5bdd},
  {0x3f33, 0x5be9}, {0x3f34, 0x5fc3}, {0x3f35, 0x614e}, {0x3f36, 0x632f},
  {0x3f37, 0x65b0}, {0x3f38, 0x664b}, {0x3f39, 0x68ee}, {0x3f3a, 0x699b},
  {0x3f3b, 0x6d78}, {0x3f3c, 0x6df1}, {0x3f3d, 0x7533}, {0x3f3e, 0x75b9},
  {0x3f3f, 0x771f}, {0x3f40, 0x795e}, {0x3f41, 0x79e6}, {0x3f42, 0x7d33},
  {0x3f43, 0x81e3}, {0x3f44, 0x82af}, {0x3f45, 0x85aa}, {0x3f46, 0x89aa},
  {0x3f47, 0x8a3a}, {0x3f48, 0x8eab}, {0x3f49, 0x8f9b}, {0x3f4a, 0x9032},
  {0x3f4b, 0x91dd}, {0x3f4c, 0x9707}, {0x3f4d, 0x4eba}, {0x3f4e, 0x4ec1},
  {0x3f4f, 0x5203}, {0x3f50, 0x5875}, {0x3f51, 0x58ec}, {0x3f52, 0x5c0b},
  {0x3f53, 0x751a}, {0x3f54, 0x5c3d}, {0x3f55, 0x814e}, {0x3f56, 0x8a0a},
  {0x3f57, 0x8fc5}, {0x3f58, 0x9663}, {0x3f59, 0x976d}, {0x3f5a, 0x7b25},
  {0x3f5b, 0x8acf}, {0x3f5c, 0x9808}, {0x3f5d, 0x9162}, {0x3f5e, 0x56f3},
  {0x3f5f, 0x53a8}, {0x3f60, 0x9017}, {0x3f61, 0x5439}, {0x3f62, 0x5782},
  {0x3f63, 0x5e25}, {0x3f64, 0x63a8}, {0x3f65, 0x6c34}, {0x3f66, 0x708a},
  {0x3f67, 0x7761}, {0x3f68, 0x7c8b}, {0x3f69, 0x7fe0}, {0x3f6a, 0x8870},
  {0x3f6b, 0x9042}, {0x3f6c, 0x9154}, {0x3f6d, 0x9310}, {0x3f6e, 0x9318},
  {0x3f6f, 0x968f}, {0x3f70, 0x745e}, {0x3f71, 0x9ac4}, {0x3f72, 0x5d07},
  {0x3f73, 0x5d69}, {0x3f74, 0x6570}, {0x3f75, 0x67a2}, {0x3f76, 0x8da8},
  {0x3f77, 0x96db}, {0x3f78, 0x636e}, {0x3f79, 0x6749}, {0x3f7a, 0x6919},
  {0x3f7b, 0x83c5}, {0x3f7c, 0x9817}, {0x3f7d, 0x96c0}, {0x3f7e, 0x88fe},
  {0x4021, 0x6f84}, {0x4022, 0x647a}, {0x4023, 0x5bf8}, {0x4024, 0x4e16},
  {0x4025, 0x702c}, {0x4026, 0x755d}, {0x4027, 0x662f}, {0x4028, 0x51c4},
  {0x4029, 0x5236}, {0x402a, 0x52e2}, {0x402b, 0x59d3}, {0x402c, 0x5f81},
  {0x402d, 0x6027}, {0x402e, 0x6210}, {0x402f, 0x653f}, {0x4030, 0x6574},
  {0x4031, 0x661f}, {0x4032, 0x6674}, {0x4033, 0x68f2}, {0x4034, 0x6816},
  {0x4035, 0x6b63}, {0x4036, 0x6e05}, {0x4037, 0x7272}, {0x4038, 0x751f},
  {0x4039, 0x76db}, {0x403a, 0x7cbe}, {0x403b, 0x8056}, {0x403c, 0x58f0},
  {0x403d, 0x88fd}, {0x403e, 0x897f}, {0x403f, 0x8aa0}, {0x4040, 0x8a93},
  {0x4041, 0x8acb}, {0x4042, 0x901d}, {0x4043, 0x9192}, {0x4044, 0x9752},
  {0x4045, 0x9759}, {0x4046, 0x6589}, {0x4047, 0x7a0e}, {0x4048, 0x8106},
  {0x4049, 0x96bb}, {0x404a, 0x5e2d}, {0x404b, 0x60dc}, {0x404c, 0x621a},
  {0x404d, 0x65a5}, {0x404e, 0x6614}, {0x404f, 0x6790}, {0x4050, 0x77f3},
  {0x4051, 0x7a4d}, {0x4052, 0x7c4d}, {0x4053, 0x7e3e}, {0x4054, 0x810a},
  {0x4055, 0x8cac}, {0x4056, 0x8d64}, {0x4057, 0x8de1}, {0x4058, 0x8e5f},
  {0x4059, 0x78a9}, {0x405a, 0x5207}, {0x405b, 0x62d9}, {0x405c, 0x63a5},
  {0x405d, 0x6442}, {0x405e, 0x6298}, {0x405f, 0x8a2d}, {0x4060, 0x7a83},
  {0x4061, 0x7bc0}, {0x4062, 0x8aac}, {0x4063, 0x96ea}, {0x4064, 0x7d76},
  {0x4065, 0x820c}, {0x4066, 0x8749}, {0x4067, 0x4ed9}, {0x4068, 0x5148},
  {0x4069, 0x5343}, {0x406a, 0x5360}, {0x406b, 0x5ba3}, {0x406c, 0x5c02},
  {0x406d, 0x5c16}, {0x406e, 0x5ddd}, {0x406f, 0x6226}, {0x4070, 0x6247},
  {0x4071, 0x64b0}, {0x4072, 0x6813}, {0x4073, 0x6834}, {0x4074, 0x6cc9},
  {0x4075, 0x6d45}, {0x4076, 0x6d17}, {0x4077, 0x67d3}, {0x4078, 0x6f5c},
  {0x4079, 0x714e}, {0x407a, 0x717d}, {0x407b, 0x65cb}, {0x407c, 0x7a7f},
  {0x407d, 0x7bad}, {0x407e, 0x7dda}, {0x4121, 0x7e4a}, {0x4122, 0x7fa8},
  {0x4123, 0x817a}, {0x4124, 0x821b}, {0x4125, 0x8239}, {0x4126, 0x85a6},
  {0x4127, 0x8a6e}, {0x4128, 0x8cce}, {0x4129, 0x8df5}, {0x412a, 0x9078},
  {0x412b, 0x9077}, {0x412c, 0x92ad}, {0x412d, 0x9291}, {0x412e, 0x9583},
  {0x412f, 0x9bae}, {0x4130, 0x524d}, {0x4131, 0x5584}, {0x4132, 0x6f38},
  {0x4133, 0x7136}, {0x4134, 0x5168}, {0x4135, 0x7985}, {0x4136, 0x7e55},
  {0x4137, 0x81b3}, {0x4138, 0x7cce}, {0x4139, 0x564c}, {0x413a, 0x5851},
  {0x413b, 0x5ca8}, {0x413c, 0x63aa}, {0x413d, 0x66fe}, {0x413e, 0x66fd},
  {0x413f, 0x695a}, {0x4140, 0x72d9}, {0x4141, 0x758f}, {0x4142, 0x758e},
  {0x4143, 0x790e}, {0x4144, 0x7956}, {0x4145, 0x79df}, {0x4146, 0x7c97},
  {0x4147, 0x7d20}, {0x4148, 0x7d44}, {0x4149, 0x8607}, {0x414a, 0x8a34},
  {0x414b, 0x963b}, {0x414c, 0x9061}, {0x414d, 0x9f20}, {0x414e, 0x50e7},
  {0x414f, 0x5275}, {0x4150, 0x53cc}, {0x4151, 0x53e2}, {0x4152, 0x5009},
  {0x4153, 0x55aa}, {0x4154, 0x58ee}, {0x4155, 0x594f}, {0x4156, 0x723d},
  {0x4157, 0x5b8b}, {0x4158, 0x5c64}, {0x4159, 0x531d}, {0x415a, 0x60e3},
  {0x415b, 0x60f3}, {0x415c, 0x635c}, {0x415d, 0x6383}, {0x415e, 0x633f},
  {0x415f, 0x63bb}, {0x4160, 0x64cd}, {0x4161, 0x65e9}, {0x4162, 0x66f9},
  {0x4163, 0x5de3}, {0x4164, 0x69cd}, {0x4165, 0x69fd}, {0x4166, 0x6f15},
  {0x4167, 0x71e5}, {0x4168, 0x4e89}, {0x4169, 0x75e9}, {0x416a, 0x76f8},
  {0x416b, 0x7a93}, {0x416c, 0x7cdf}, {0x416d, 0x7dcf}, {0x416e, 0x7d9c},
  {0x416f, 0x8061}, {0x4170, 0x8349}, {0x4171, 0x8358}, {0x4172, 0x846c},
  {0x4173, 0x84bc}, {0x4174, 0x85fb}, {0x4175, 0x88c5}, {0x4176, 0x8d70},
  {0x4177, 0x9001}, {0x4178, 0x906d}, {0x4179, 0x9397}, {0x417a, 0x971c},
  {0x417b, 0x9a12}, {0x417c, 0x50cf}, {0x417d, 0x5897}, {0x417e, 0x618e},
  {0x4221, 0x81d3}, {0x4222, 0x8535}, {0x4223, 0x8d08}, {0x4224, 0x9020},
  {0x4225, 0x4fc3}, {0x4226, 0x5074}, {0x4227, 0x5247}, {0x4228, 0x5373},
  {0x4229, 0x606f}, {0x422a, 0x6349}, {0x422b, 0x675f}, {0x422c, 0x6e2c},
  {0x422d, 0x8db3}, {0x422e, 0x901f}, {0x422f, 0x4fd7}, {0x4230, 0x5c5e},
  {0x4231, 0x8cca}, {0x4232, 0x65cf}, {0x4233, 0x7d9a}, {0x4234, 0x5352},
  {0x4235, 0x8896}, {0x4236, 0x5176}, {0x4237, 0x63c3}, {0x4238, 0x5b58},
  {0x4239, 0x5b6b}, {0x423a, 0x5c0a}, {0x423b, 0x640d}, {0x423c, 0x6751},
  {0x423d, 0x905c}, {0x423e, 0x4ed6}, {0x423f, 0x591a}, {0x4240, 0x592a},
  {0x4241, 0x6c70}, {0x4242, 0x8a51}, {0x4243, 0x553e}, {0x4244, 0x5815},
  {0x4245, 0x59a5}, {0x4246, 0x60f0}, {0x4247, 0x6253}, {0x4248, 0x67c1},
  {0x4249, 0x8235}, {0x424a, 0x6955}, {0x424b, 0x9640}, {0x424c, 0x99c4},
  {0x424d, 0x9a28}, {0x424e, 0x4f53}, {0x424f, 0x5806}, {0x4250, 0x5bfe},
  {0x4251, 0x8010}, {0x4252, 0x5cb1}, {0x4253, 0x5e2f}, {0x4254, 0x5f85},
  {0x4255, 0x6020}, {0x4256, 0x614b}, {0x4257, 0x6234}, {0x4258, 0x66ff},
  {0x4259, 0x6cf0}, {0x425a, 0x6ede}, {0x425b, 0x80ce}, {0x425c, 0x817f},
  {0x425d, 0x82d4}, {0x425e, 0x888b}, {0x425f, 0x8cb8}, {0x4260, 0x9000},
  {0x4261, 0x902e}, {0x4262, 0x968a}, {0x4263, 0x9edb}, {0x4264, 0x9bdb},
  {0x4265, 0x4ee3}, {0x4266, 0x53f0}, {0x4267, 0x5927}, {0x4268, 0x7b2c},
  {0x4269, 0x918d}, {0x426a, 0x984c}, {0x426b, 0x9df9}, {0x426c, 0x6edd},
  {0x426d, 0x7027}, {0x426e, 0x5353}, {0x426f, 0x5544}, {0x4270, 0x5b85},
  {0x4271, 0x6258}, {0x4272, 0x629e}, {0x4273, 0x62d3}, {0x4274, 0x6ca2},
  {0x4275, 0x6fef}, {0x4276, 0x7422}, {0x4277, 0x8a17}, {0x4278, 0x9438},
  {0x4279, 0x6fc1}, {0x427a, 0x8afe}, {0x427b, 0x8338}, {0x427c, 0x51e7},
  {0x427d, 0x86f8}, {0x427e, 0x53ea}, {0x4321, 0x53e9}, {0x4322, 0x4f46},
  {0x4323, 0x9054}, {0x4324, 0x8fb0}, {0x4325, 0x596a}, {0x4326, 0x8131},
  {0x4327, 0x5dfd}, {0x4328, 0x7aea}, {0x4329, 0x8fbf}, {0x432a, 0x68da},
  {0x432b, 0x8c37}, {0x432c, 0x72f8}, {0x432d, 0x9c48}, {0x432e, 0x6a3d},
  {0x432f, 0x8ab0}, {0x4330, 0x4e39}, {0x4331, 0x5358}, {0x4332, 0x5606},
  {0x4333, 0x5766}, {0x4334, 0x62c5}, {0x4335, 0x63a2}, {0x4336, 0x65e6},
  {0x4337, 0x6b4e}, {0x4338, 0x6de1}, {0x4339, 0x6e5b}, {0x433a, 0x70ad},
  {0x433b, 0x77ed}, {0x433c, 0x7aef}, {0x433d, 0x7baa}, {0x433e, 0x7dbb},
  {0x433f, 0x803d}, {0x4340, 0x80c6}, {0x4341, 0x86cb}, {0x4342, 0x8a95},
  {0x4343, 0x935b}, {0x4344, 0x56e3}, {0x4345, 0x58c7}, {0x4346, 0x5f3e},
  {0x4347, 0x65ad}, {0x4348, 0x6696}, {0x4349, 0x6a80}, {0x434a, 0x6bb5},
  {0x434b, 0x7537}, {0x434c, 0x8ac7}, {0x434d, 0x5024}, {0x434e, 0x77e5},
  {0x434f, 0x5730}, {0x4350, 0x5f1b}, {0x4351, 0x6065}, {0x4352, 0x667a},
  {0x4353, 0x6c60}, {0x4354, 0x75f4}, {0x4355, 0x7a1a}, {0x4356, 0x7f6e},
  {0x4357, 0x81f4}, {0x4358, 0x8718}, {0x4359, 0x9045}, {0x435a, 0x99b3},
  {0x435b, 0x7bc9}, {0x435c, 0x755c}, {0x435d, 0x7af9}, {0x435e, 0x7b51},
  {0x435f, 0x84c4}, {0x4360, 0x9010}, {0x4361, 0x79e9}, {0x4362, 0x7a92},
  {0x4363, 0x8336}, {0x4364, 0x5ae1}, {0x4365, 0x7740}, {0x4366, 0x4e2d},
  {0x4367, 0x4ef2}, {0x4368, 0x5b99}, {0x4369, 0x5fe0}, {0x436a, 0x62bd},
  {0x436b, 0x663c}, {0x436c, 0x67f1}, {0x436d, 0x6ce8}, {0x436e, 0x866b},
  {0x436f, 0x8877}, {0x4370, 0x8a3b}, {0x4371, 0x914e}, {0x4372, 0x92f3},
  {0x4373, 0x99d0}, {0x4374, 0x6a17}, {0x4375, 0x7026}, {0x4376, 0x732a},
  {0x4377, 0x82e7}, {0x4378, 0x8457}, {0x4379, 0x8caf}, {0x437a, 0x4e01},
  {0x437b, 0x5146}, {0x437c, 0x51cb}, {0x437d, 0x558b}, {0x437e, 0x5bf5},
  {0x4421, 0x5e16}, {0x4422, 0x5e33}, {0x4423, 0x5e81}, {0x4424, 0x5f14},
  {0x4425, 0x5f35}, {0x4426, 0x5f6b}, {0x4427, 0x5fb4}, {0x4428, 0x61f2},
  {0x4429, 0x6311}, {0x442a, 0x66a2}, {0x442b, 0x671d}, {0x442c, 0x6f6e},
  {0x442d, 0x7252}, {0x442e, 0x753a}, {0x442f, 0x773a}, {0x4430, 0x8074},
  {0x4431, 0x8139}, {0x4432, 0x8178}, {0x4433, 0x8776}, {0x4434, 0x8abf},
  {0x4435, 0x8adc}, {0x4436, 0x8d85}, {0x4437, 0x8df3}, {0x4438, 0x929a},
  {0x4439, 0x9577}, {0x443a, 0x9802}, {0x443b, 0x9ce5}, {0x443c, 0x52c5},
  {0x443d, 0x6357}, {0x443e, 0x76f4}, {0x443f, 0x6715}, {0x4440, 0x6c88},
  {0x4441, 0x73cd}, {0x4442, 0x8cc3}, {0x4443, 0x93ae}, {0x4444, 0x9673},
  {0x4445, 0x6d25}, {0x4446, 0x589c}, {0x4447, 0x690e}, {0x4448, 0x69cc},
  {0x4449, 0x8ffd}, {0x444a, 0x939a}, {0x444b, 0x75db}, {0x444c, 0x901a},
  {0x444d, 0x585a}, {0x444e, 0x6802}, {0x444f, 0x63b4}, {0x4450, 0x69fb},
  {0x4451, 0x4f43}, {0x4452, 0x6f2c}, {0x4453, 0x67d8}, {0x4454, 0x8fbb},
  {0x4455, 0x8526}, {0x4456, 0x7db4}, {0x4457, 0x9354}, {0x4458, 0x693f},
  {0x4459, 0x6f70}, {0x445a, 0x576a}, {0x445b, 0x58f7}, {0x445c, 0x5b2c},
  {0x445d, 0x7d2c}, {0x445e, 0x722a}, {0x445f, 0x540a}, {0x4460, 0x91e3},
  {0x4461, 0x9db4}, {0x4462, 0x4ead}, {0x4463, 0x4f4e}, {0x4464, 0x505c},
  {0x4465, 0x5075}, {0x4466, 0x5243}, {0x4467, 0x8c9e}, {0x4468, 0x5448},
  {0x4469, 0x5824}, {0x446a, 0x5b9a}, {0x446b, 0x5e1d}, {0x446c, 0x5e95},
  {0x446d, 0x5ead}, {0x446e, 0x5ef7}, {0x446f, 0x5f1f}, {0x4470, 0x608c},
  {0x4471, 0x62b5}, {0x4472, 0x633a}, {0x4473, 0x63d0}, {0x4474, 0x68af},
  {0x4475, 0x6c40}, {0x4476, 0x7887}, {0x4477, 0x798e}, {0x4478, 0x7a0b},
  {0x4479, 0x7de0}, {0x447a, 0x8247}, {0x447b, 0x8a02}, {0x447c, 0x8ae6},
  {0x447d, 0x8e44}, {0x447e, 0x9013}, {0x4521, 0x90b8}, {0x4522, 0x912d},
  {0x4523, 0x91d8}, {0x4524, 0x9f0e}, {0x4525, 0x6ce5}, {0x4526, 0x6458},
  {0x4527, 0x64e2}, {0x4528, 0x6575}, {0x4529, 0x6ef4}, {0x452a, 0x7684},
  {0x452b, 0x7b1b}, {0x452c, 0x9069}, {0x452d, 0x93d1}, {0x452e, 0x6eba},
  {0x452f, 0x54f2}, {0x4530, 0x5fb9}, {0x4531, 0x64a4}, {0x4532, 0x8f4d},
  {0x4533, 0x8fed}, {0x4534, 0x9244}, {0x4535, 0x5178}, {0x4536, 0x586b},
  {0x4537, 0x5929}, {0x4538, 0x5c55}, {0x4539, 0x5e97}, {0x453a, 0x6dfb},
  {0x453b, 0x7e8f}, {0x453c, 0x751c}, {0x453d, 0x8cbc}, {0x453e, 0x8ee2},
  {0x453f, 0x985b}, {0x4540, 0x70b9}, {0x4541, 0x4f1d}, {0x4542, 0x6bbf},
  {0x4543, 0x6fb1}, {0x4544, 0x7530}, {0x4545, 0x96fb}, {0x4546, 0x514e},
  {0x4547, 0x5410}, {0x4548, 0x5835}, {0x4549, 0x5857}, {0x454a, 0x59ac},
  {0x454b, 0x5c60}, {0x454c, 0x5f92}, {0x454d, 0x6597}, {0x454e, 0x675c},
  {0x454f, 0x6e21}, {0x4550, 0x767b}, {0x4551, 0x83df}, {0x4552, 0x8ced},
  {0x4553, 0x9014}, {0x4554, 0x90fd}, {0x4555, 0x934d}, {0x4556, 0x7825},
  {0x4557, 0x783a}, {0x4558, 0x52aa}, {0x4559, 0x5ea6}, {0x455a, 0x571f},
  {0x455b, 0x5974}, {0x455c, 0x6012}, {0x455d, 0x5012}, {0x455e, 0x515a},
  {0x455f, 0x51ac}, {0x4560, 0x51cd}, {0x4561, 0x5200}, {0x4562, 0x5510},
  {0x4563, 0x5854}, {0x4564, 0x5858}, {0x4565, 0x5957}, {0x4566, 0x5b95},
  {0x4567, 0x5cf6}, {0x4568, 0x5d8b}, {0x4569, 0x60bc}, {0x456a, 0x6295},
  {0x456b, 0x642d}, {0x456c, 0x6771}, {0x456d, 0x6843}, {0x456e, 0x68bc},
  {0x456f, 0x68df}, {0x4570, 0x76d7}, {0x4571, 0x6dd8}, {0x4572, 0x6e6f},
  {0x4573, 0x6d9b}, {0x4574, 0x706f}, {0x4575, 0x71c8}, {0x4576, 0x5f53},
  {0x4577, 0x75d8}, {0x4578, 0x7977}, {0x4579, 0x7b49}, {0x457a, 0x7b54},
  {0x457b, 0x7b52}, {0x457c, 0x7cd6}, {0x457d, 0x7d71}, {0x457e, 0x5230},
  {0x4621, 0x8463}, {0x4622, 0x8569}, {0x4623, 0x85e4}, {0x4624, 0x8a0e},
  {0x4625, 0x8b04}, {0x4626, 0x8c46}, {0x4627, 0x8e0f}, {0x4628, 0x9003},
  {0x4629, 0x900f}, {0x462a, 0x9419}, {0x462b, 0x9676}, {0x462c, 0x982d},
  {0x462d, 0x9a30}, {0x462e, 0x95d8}, {0x462f, 0x50cd}, {0x4630, 0x52d5},
  {0x4631, 0x540c}, {0x4632, 0x5802}, {0x4633, 0x5c0e}, {0x4634, 0x61a7},
  {0x4635, 0x649e}, {0x4636, 0x6d1e}, {0x4637, 0x77b3}, {0x4638, 0x7ae5},
  {0x4639, 0x80f4}, {0x463a, 0x8404}, {0x463b, 0x9053}, {0x463c, 0x9285},
  {0x463d, 0x5ce0}, {0x463e, 0x9d07}, {0x463f, 0x533f}, {0x4640, 0x5f97},
  {0x4641, 0x5fb3}, {0x4642, 0x6d9c}, {0x4643, 0x7279}, {0x4644, 0x7763},
  {0x4645, 0x79bf}, {0x4646, 0x7be4}, {0x4647, 0x6bd2}, {0x4648, 0x72ec},
  {0x4649, 0x8aad}, {0x464a, 0x6803}, {0x464b, 0x6a61}, {0x464c, 0x51f8},
  {0x464d, 0x7a81}, {0x464e, 0x6934}, {0x464f, 0x5c4a}, {0x4650, 0x9cf6},
  {0x4651, 0x82eb}, {0x4652, 0x5bc5}, {0x4653, 0x9149}, {0x4654, 0x701e},
  {0x4655, 0x5678}, {0x4656, 0x5c6f}, {0x4657, 0x60c7}, {0x4658, 0x6566},
  {0x4659, 0x6c8c}, {0x465a, 0x8c5a}, {0x465b, 0x9041}, {0x465c, 0x9813},
  {0x465d, 0x5451}, {0x465e, 0x66c7}, {0x465f, 0x920d}, {0x4660, 0x5948},
  {0x4661, 0x90a3}, {0x4662, 0x5185}, {0x4663, 0x4e4d}, {0x4664, 0x51ea},
  {0x4665, 0x8599}, {0x4666, 0x8b0e}, {0x4667, 0x7058}, {0x4668, 0x637a},
  {0x4669, 0x934b}, {0x466a, 0x6962}, {0x466b, 0x99b4}, {0x466c, 0x7e04},
  {0x466d, 0x7577}, {0x466e, 0x5357}, {0x466f, 0x6960}, {0x4670, 0x8edf},
  {0x4671, 0x96e3}, {0x4672, 0x6c5d}, {0x4673, 0x4e8c}, {0x4674, 0x5c3c},
  {0x4675, 0x5f10}, {0x4676, 0x8fe9}, {0x4677, 0x5302}, {0x4678, 0x8cd1},
  {0x4679, 0x8089}, {0x467a, 0x8679}, {0x467b, 0x5eff}, {0x467c, 0x65e5},
  {0x467d, 0x4e73}, {0x467e, 0x5165}, {0x4721, 0x5982}, {0x4722, 0x5c3f},
  {0x4723, 0x97ee}, {0x4724, 0x4efb}, {0x4725, 0x598a}, {0x4726, 0x5fcd},
  {0x4727, 0x8a8d}, {0x4728, 0x6fe1}, {0x4729, 0x79b0}, {0x472a, 0x7962},
  {0x472b, 0x5be7}, {0x472c, 0x8471}, {0x472d, 0x732b}, {0x472e, 0x71b1},
  {0x472f, 0x5e74}, {0x4730, 0x5ff5}, {0x4731, 0x637b}, {0x4732, 0x649a},
  {0x4733, 0x71c3}, {0x4734, 0x7c98}, {0x4735, 0x4e43}, {0x4736, 0x5efc},
  {0x4737, 0x4e4b}, {0x4738, 0x57dc}, {0x4739, 0x56a2}, {0x473a, 0x60a9},
  {0x473b, 0x6fc3}, {0x473c, 0x7d0d}, {0x473d, 0x80fd}, {0x473e, 0x8133},
  {0x473f, 0x81bf}, {0x4740, 0x8fb2}, {0x4741, 0x8997}, {0x4742, 0x86a4},
  {0x4743, 0x5df4}, {0x4744, 0x628a}, {0x4745, 0x64ad}, {0x4746, 0x8987},
  {0x4747, 0x6777}, {0x4748, 0x6ce2}, {0x4749, 0x6d3e}, {0x474a, 0x7436},
  {0x474b, 0x7834}, {0x474c, 0x5a46}, {0x474d, 0x7f75}, {0x474e, 0x82ad},
  {0x474f, 0x99ac}, {0x4750, 0x4ff3}, {0x4751, 0x5ec3}, {0x4752, 0x62dd},
  {0x4753, 0x6392}, {0x4754, 0x6557}, {0x4755, 0x676f}, {0x4756, 0x76c3},
  {0x4757, 0x724c}, {0x4758, 0x80cc}, {0x4759, 0x80ba}, {0x475a, 0x8f29},
  {0x475b, 0x914d}, {0x475c, 0x500d}, {0x475d, 0x57f9}, {0x475e, 0x5a92},
  {0x475f, 0x6885}, {0x4760, 0x6973}, {0x4761, 0x7164}, {0x4762, 0x72fd},
  {0x4763, 0x8cb7}, {0x4764, 0x58f2}, {0x4765, 0x8ce0}, {0x4766, 0x966a},
  {0x4767, 0x9019}, {0x4768, 0x877f}, {0x4769, 0x79e4}, {0x476a, 0x77e7},
  {0x476b, 0x8429}, {0x476c, 0x4f2f}, {0x476d, 0x5265}, {0x476e, 0x535a},
  {0x476f, 0x62cd}, {0x4770, 0x67cf}, {0x4771, 0x6cca}, {0x4772, 0x767d},
  {0x4773, 0x7b94}, {0x4774, 0x7c95}, {0x4775, 0x8236}, {0x4776, 0x8584},
  {0x4777, 0x8feb}, {0x4778, 0x66dd}, {0x4779, 0x6f20}, {0x477a, 0x7206},
  {0x477b, 0x7e1b}, {0x477c, 0x83ab}, {0x477d, 0x99c1}, {0x477e, 0x9ea6},
  {0x4821, 0x51fd}, {0x4822, 0x7bb1}, {0x4823, 0x7872}, {0x4824, 0x7bb8},
  {0x4825, 0x8087}, {0x4826, 0x7b48}, {0x4827, 0x6ae8}, {0x4828, 0x5e61},
  {0x4829, 0x808c}, {0x482a, 0x7551}, {0x482b, 0x7560}, {0x482c, 0x516b},
  {0x482d, 0x9262}, {0x482e, 0x6e8c}, {0x482f, 0x767a}, {0x4830, 0x9197},
  {0x4831, 0x9aea}, {0x4832, 0x4f10}, {0x4833, 0x7f70}, {0x4834, 0x629c},
  {0x4835, 0x7b4f}, {0x4836, 0x95a5}, {0x4837, 0x9ce9}, {0x4838, 0x567a},
  {0x4839, 0x5859}, {0x483a, 0x86e4}, {0x483b, 0x96bc}, {0x483c, 0x4f34},
  {0x483d, 0x5224}, {0x483e, 0x534a}, {0x483f, 0x53cd}, {0x4840, 0x53db},
  {0x4841, 0x5e06}, {0x4842, 0x642c}, {0x4843, 0x6591}, {0x4844, 0x677f},
  {0x4845, 0x6c3e}, {0x4846, 0x6c4e}, {0x4847, 0x7248}, {0x4848, 0x72af},
  {0x4849, 0x73ed}, {0x484a, 0x7554}, {0x484b, 0x7e41}, {0x484c, 0x822c},
  {0x484d, 0x85e9}, {0x484e, 0x8ca9}, {0x484f, 0x7bc4}, {0x4850, 0x91c6},
  {0x4851, 0x7169}, {0x4852, 0x9812}, {0x4853, 0x98ef}, {0x4854, 0x633d},
  {0x4855, 0x6669}, {0x4856, 0x756a}, {0x4857, 0x76e4}, {0x4858, 0x78d0},
  {0x4859, 0x8543}, {0x485a, 0x86ee}, {0x485b, 0x532a}, {0x485c, 0x5351},
  {0x485d, 0x5426}, {0x485e, 0x5983}, {0x485f, 0x5e87}, {0x4860, 0x5f7c},
  {0x4861, 0x60b2}, {0x4862, 0x6249}, {0x4863, 0x6279}, {0x4864, 0x62ab},
  {0x4865, 0x6590}, {0x4866, 0x6bd4}, {0x4867, 0x6ccc}, {0x4868, 0x75b2},
  {0x4869, 0x76ae}, {0x486a, 0x7891}, {0x486b, 0x79d8}, {0x486c, 0x7dcb},
  {0x486d, 0x7f77}, {0x486e, 0x80a5}, {0x486f, 0x88ab}, {0x4870, 0x8ab9},
  {0x4871, 0x8cbb}, {0x4872, 0x907f}, {0x4873, 0x975e}, {0x4874, 0x98db},
  {0x4875, 0x6a0b}, {0x4876, 0x7c38}, {0x4877, 0x5099}, {0x4878, 0x5c3e},
  {0x4879, 0x5fae}, {0x487a, 0x6787}, {0x487b, 0x6bd8}, {0x487c, 0x7435},
  {0x487d, 0x7709}, {0x487e, 0x7f8e}, {0x4921, 0x9f3b}, {0x4922, 0x67ca},
  {0x4923, 0x7a17}, {0x4924, 0x5339}, {0x4925, 0x758b}, {0x4926, 0x9aed},
  {0x4927, 0x5f66}, {0x4928, 0x819d}, {0x4929, 0x83f1}, {0x492a, 0x8098},
  {0x492b, 0x5f3c}, {0x492c, 0x5fc5}, {0x492d, 0x7562}, {0x492e, 0x7b46},
  {0x492f, 0x903c}, {0x4930, 0x6867}, {0x4931, 0x59eb}, {0x4932, 0x5a9b},
  {0x4933, 0x7d10}, {0x4934, 0x767e}, {0x4935, 0x8b2c}, {0x4936, 0x4ff5},
  {0x4937, 0x5f6a}, {0x4938, 0x6a19}, {0x4939, 0x6c37}, {0x493a, 0x6f02},
  {0x493b, 0x74e2}, {0x493c, 0x7968}, {0x493d, 0x8868}, {0x493e, 0x8a55},
  {0x493f, 0x8c79}, {0x4940, 0x5edf}, {0x4941, 0x63cf}, {0x4942, 0x75c5},
  {0x4943, 0x79d2}, {0x4944, 0x82d7}, {0x4945, 0x9328}, {0x4946, 0x92f2},
  {0x4947, 0x849c}, {0x4948, 0x86ed}, {0x4949, 0x9c2d}, {0x494a, 0x54c1},
  {0x494b, 0x5f6c}, {0x494c, 0x658c}, {0x494d, 0x6d5c}, {0x494e, 0x7015},
  {0x494f, 0x8ca7}, {0x4950, 0x8cd3}, {0x4951, 0x983b}, {0x4952, 0x654f},
  {0x4953, 0x74f6}, {0x4954, 0x4e0d}, {0x4955, 0x4ed8}, {0x4956, 0x57e0},
  {0x4957, 0x592b}, {0x4958, 0x5a66}, {0x4959, 0x5bcc}, {0x495a, 0x51a8},
  {0x495b, 0x5e03}, {0x495c, 0x5e9c}, {0x495d, 0x6016}, {0x495e, 0x6276},
  {0x495f, 0x6577}, {0x4960, 0x65a7}, {0x4961, 0x666e}, {0x4962, 0x6d6e},
  {0x4963, 0x7236}, {0x4964, 0x7b26}, {0x4965, 0x8150}, {0x4966, 0x819a},
  {0x4967, 0x8299}, {0x4968, 0x8b5c}, {0x4969, 0x8ca0}, {0x496a, 0x8ce6},
  {0x496b, 0x8d74}, {0x496c, 0x961c}, {0x496d, 0x9644}, {0x496e, 0x4fae},
  {0x496f, 0x64ab}, {0x4970, 0x6b66}, {0x4971, 0x821e}, {0x4972, 0x8461},
  {0x4973, 0x856a}, {0x4974, 0x90e8}, {0x4975, 0x5c01}, {0x4976, 0x6953},
  {0x4977, 0x98a8}, {0x4978, 0x847a}, {0x4979, 0x8557}, {0x497a, 0x4f0f},
  {0x497b, 0x526f}, {0x497c, 0x5fa9}, {0x497d, 0x5e45}, {0x497e, 0x670d},
  {0x4a21, 0x798f}, {0x4a22, 0x8179}, {0x4a23, 0x8907}, {0x4a24, 0x8986},
  {0x4a25, 0x6df5}, {0x4a26, 0x5f17}, {0x4a27, 0x6255}, {0x4a28, 0x6cb8},
  {0x4a29, 0x4ecf}, {0x4a2a, 0x7269}, {0x4a2b, 0x9b92}, {0x4a2c, 0x5206},
  {0x4a2d, 0x543b}, {0x4a2e, 0x5674}, {0x4a2f, 0x58b3}, {0x4a30, 0x61a4},
  {0x4a31, 0x626e}, {0x4a32, 0x711a}, {0x4a33, 0x596e}, {0x4a34, 0x7c89},
  {0x4a35, 0x7cde}, {0x4a36, 0x7d1b}, {0x4a37, 0x96f0}, {0x4a38, 0x6587},
  {0x4a39, 0x805e}, {0x4a3a, 0x4e19}, {0x4a3b, 0x4f75}, {0x4a3c, 0x5175},
  {0x4a3d, 0x5840}, {0x4a3e, 0x5e63}, {0x4a3f, 0x5e73}, {0x4a40, 0x5f0a},
  {0x4a41, 0x67c4}, {0x4a42, 0x4e26}, {0x4a43, 0x853d}, {0x4a44, 0x9589},
  {0x4a45, 0x965b}, {0x4a46, 0x7c73}, {0x4a47, 0x9801}, {0x4a48, 0x50fb},
  {0x4a49, 0x58c1}, {0x4a4a, 0x7656}, {0x4a4b, 0x78a7}, {0x4a4c, 0x5225},
  {0x4a4d, 0x77a5}, {0x4a4e, 0x8511}, {0x4a4f, 0x7b86}, {0x4a50, 0x504f},
  {0x4a51, 0x5909}, {0x4a52, 0x7247}, {0x4a53, 0x7bc7}, {0x4a54, 0x7de8},
  {0x4a55, 0x8fba}, {0x4a56, 0x8fd4}, {0x4a57, 0x904d}, {0x4a58, 0x4fbf},
  {0x4a59, 0x52c9}, {0x4a5a, 0x5a29}, {0x4a5b, 0x5f01}, {0x4a5c, 0x97ad},
  {0x4a5d, 0x4fdd}, {0x4a5e, 0x8217}, {0x4a5f, 0x92ea}, {0x4a60, 0x5703},
  {0x4a61, 0x6355}, {0x4a62, 0x6b69}, {0x4a63, 0x752b}, {0x4a64, 0x88dc},
  {0x4a65, 0x8f14}, {0x4a66, 0x7a42}, {0x4a67, 0x52df}, {0x4a68, 0x5893},
  {0x4a69, 0x6155}, {0x4a6a, 0x620a}, {0x4a6b, 0x66ae}, {0x4a6c, 0x6bcd},
  {0x4a6d, 0x7c3f}, {0x4a6e, 0x83e9}, {0x4a6f, 0x5023}, {0x4a70, 0x4ff8},
  {0x4a71, 0x5305}, {0x4a72, 0x5446}, {0x4a73, 0x5831}, {0x4a74, 0x5949},
  {0x4a75, 0x5b9d}, {0x4a76, 0x5cf0}, {0x4a77, 0x5cef}, {0x4a78, 0x5d29},
  {0x4a79, 0x5e96}, {0x4a7a, 0x62b1}, {0x4a7b, 0x6367}, {0x4a7c, 0x653e},
  {0x4a7d, 0x65b9}, {0x4a7e, 0x670b}, {0x4b21, 0x6cd5}, {0x4b22, 0x6ce1},
  {0x4b23, 0x70f9}, {0x4b24, 0x7832}, {0x4b25, 0x7e2b}, {0x4b26, 0x80de},
  {0x4b27, 0x82b3}, {0x4b28, 0x840c}, {0x4b29, 0x84ec}, {0x4b2a, 0x8702},
  {0x4b2b, 0x8912}, {0x4b2c, 0x8a2a}, {0x4b2d, 0x8c4a}, {0x4b2e, 0x90a6},
  {0x4b2f, 0x92d2}, {0x4b30, 0x98fd}, {0x4b31, 0x9cf3}, {0x4b32, 0x9d6c},
  {0x4b33, 0x4e4f}, {0x4b34, 0x4ea1}, {0x4b35, 0x508d}, {0x4b36, 0x5256},
  {0x4b37, 0x574a}, {0x4b38, 0x59a8}, {0x4b39, 0x5e3d}, {0x4b3a, 0x5fd8},
  {0x4b3b, 0x5fd9}, {0x4b3c, 0x623f}, {0x4b3d, 0x66b4}, {0x4b3e, 0x671b},
  {0x4b3f, 0x67d0}, {0x4b40, 0x68d2}, {0x4b41, 0x5192}, {0x4b42, 0x7d21},
  {0x4b43, 0x80aa}, {0x4b44, 0x81a8}, {0x4b45, 0x8b00}, {0x4b46, 0x8c8c},
  {0x4b47, 0x8cbf}, {0x4b48, 0x927e}, {0x4b49, 0x9632}, {0x4b4a, 0x5420},
  {0x4b4b, 0x982c}, {0x4b4c, 0x5317}, {0x4b4d, 0x50d5}, {0x4b4e, 0x535c},
  {0x4b4f, 0x58a8}, {0x4b50, 0x64b2}, {0x4b51, 0x6734}, {0x4b52, 0x7267},
  {0x4b53, 0x7766}, {0x4b54, 0x7a46}, {0x4b55, 0x91e6}, {0x4b56, 0x52c3},
  {0x4b57, 0x6ca1}, {0x4b58, 0x6b86}, {0x4b59, 0x5800}, {0x4b5a, 0x5e4c},
  {0x4b5b, 0x5954}, {0x4b5c, 0x672c}, {0x4b5d, 0x7ffb}, {0x4b5e, 0x51e1},
  {0x4b5f, 0x76c6}, {0x4b60, 0x6469}, {0x4b61, 0x78e8}, {0x4b62, 0x9b54},
  {0x4b63, 0x9ebb}, {0x4b64, 0x57cb}, {0x4b65, 0x59b9}, {0x4b66, 0x6627},
  {0x4b67, 0x679a}, {0x4b68, 0x6bce}, {0x4b69, 0x54e9}, {0x4b6a, 0x69d9},
  {0x4b6b, 0x5e55}, {0x4b6c, 0x819c}, {0x4b6d, 0x6795}, {0x4b6e, 0x9baa},
  {0x4b6f, 0x67fe}, {0x4b70, 0x9c52}, {0x4b71, 0x685d}, {0x4b72, 0x4ea6},
  {0x4b73, 0x4fe3}, {0x4b74, 0x53c8}, {0x4b75, 0x62b9}, {0x4b76, 0x672b},
  {0x4b77, 0x6cab}, {0x4b78, 0x8fc4}, {0x4b79, 0x4fad}, {0x4b7a, 0x7e6d},
  {0x4b7b, 0x9ebf}, {0x4b7c, 0x4e07}, {0x4b7d, 0x6162}, {0x4b7e, 0x6e80},
  {0x4c21, 0x6f2b}, {0x4c22, 0x8513}, {0x4c23, 0x5473}, {0x4c24, 0x672a},
  {0x4c25, 0x9b45}, {0x4c26, 0x5df3}, {0x4c27, 0x7b95}, {0x4c28, 0x5cac},
  {0x4c29, 0x5bc6}, {0x4c2a, 0x871c}, {0x4c2b, 0x6e4a}, {0x4c2c, 0x84d1},
  {0x4c2d, 0x7a14}, {0x4c2e, 0x8108}, {0x4c2f, 0x5999}, {0x4c30, 0x7c8d},
  {0x4c31, 0x6c11}, {0x4c32, 0x7720}, {0x4c33, 0x52d9}, {0x4c34, 0x5922},
  {0x4c35, 0x7121}, {0x4c36, 0x725f}, {0x4c37, 0x77db}, {0x4c38, 0x9727},
  {0x4c39, 0x9d61}, {0x4c3a, 0x690b}, {0x4c3b, 0x5a7f}, {0x4c3c, 0x5a18},
  {0x4c3d, 0x51a5}, {0x4c3e, 0x540d}, {0x4c3f, 0x547d}, {0x4c40, 0x660e},
  {0x4c41, 0x76df}, {0x4c42, 0x8ff7}, {0x4c43, 0x9298}, {0x4c44, 0x9cf4},
  {0x4c45, 0x59ea}, {0x4c46, 0x725d}, {0x4c47, 0x6ec5}, {0x4c48, 0x514d},
  {0x4c49, 0x68c9}, {0x4c4a, 0x7dbf}, {0x4c4b, 0x7dec}, {0x4c4c, 0x9762},
  {0x4c4d, 0x9eba}, {0x4c4e, 0x6478}, {0x4c4f, 0x6a21}, {0x4c50, 0x8302},
  {0x4c51, 0x5984}, {0x4c52, 0x5b5f}, {0x4c53, 0x6bdb}, {0x4c54, 0x731b},
  {0x4c55, 0x76f2}, {0x4c56, 0x7db2}, {0x4c57, 0x8017}, {0x4c58, 0x8499},
  {0x4c59, 0x5132}, {0x4c5a, 0x6728}, {0x4c5b, 0x9ed9}, {0x4c5c, 0x76ee},
  {0x4c5d, 0x6762}, {0x4c5e, 0x52ff}, {0x4c5f, 0x9905}, {0x4c60, 0x5c24},
  {0x4c61, 0x623b}, {0x4c62, 0x7c7e}, {0x4c63, 0x8cb0}, {0x4c64, 0x554f},
  {0x4c65, 0x60b6}, {0x4c66, 0x7d0b}, {0x4c67, 0x9580}, {0x4c68, 0x5301},
  {0x4c69, 0x4e5f}, {0x4c6a, 0x51b6}, {0x4c6b, 0x591c}, {0x4c6c, 0x723a},
  {0x4c6d, 0x8036}, {0x4c6e, 0x91ce}, {0x4c6f, 0x5f25}, {0x4c70, 0x77e2},
  {0x4c71, 0x5384}, {0x4c72, 0x5f79}, {0x4c73, 0x7d04}, {0x4c74, 0x85ac},
  {0x4c75, 0x8a33}, {0x4c76, 0x8e8d}, {0x4c77, 0x9756}, {0x4c78, 0x67f3},
  {0x4c79, 0x85ae}, {0x4c7a, 0x9453}, {0x4c7b, 0x6109}, {0x4c7c, 0x6108},
  {0x4c7d, 0x6cb9}, {0x4c7e, 0x7652}, {0x4d21, 0x8aed}, {0x4d22, 0x8f38},
  {0x4d23, 0x552f}, {0x4d24, 0x4f51}, {0x4d25, 0x512a}, {0x4d26, 0x52c7},
  {0x4d27, 0x53cb}, {0x4d28, 0x5ba5}, {0x4d29, 0x5e7d}, {0x4d2a, 0x60a0},
  {0x4d2b, 0x6182}, {0x4d2c, 0x63d6}, {0x4d2d, 0x6709}, {0x4d2e, 0x67da},
  {0x4d2f, 0x6e67}, {0x4d30, 0x6d8c}, {0x4d31, 0x7336}, {0x4d32, 0x7337},
  {0x4d33, 0x7531}, {0x4d34, 0x7950}, {0x4d35, 0x88d5}, {0x4d36, 0x8a98},
  {0x4d37, 0x904a}, {0x4d38, 0x9091}, {0x4d39, 0x90f5}, {0x4d3a, 0x96c4},
  {0x4d3b, 0x878d}, {0x4d3c, 0x5915}, {0x4d3d, 0x4e88}, {0x4d3e, 0x4f59},
  {0x4d3f, 0x4e0e}, {0x4d40, 0x8a89}, {0x4d41, 0x8f3f}, {0x4d42, 0x9810},
  {0x4d43, 0x50ad}, {0x4d44, 0x5e7c}, {0x4d45, 0x5996}, {0x4d46, 0x5bb9},
  {0x4d47, 0x5eb8}, {0x4d48, 0x63da}, {0x4d49, 0x63fa}, {0x4d4a, 0x64c1},
  {0x4d4b, 0x66dc}, {0x4d4c, 0x694a}, {0x4d4d, 0x69d8}, {0x4d4e, 0x6d0b},
  {0x4d4f, 0x6eb6}, {0x4d50, 0x7194}, {0x4d51, 0x7528}, {0x4d52, 0x7aaf},
  {0x4d53, 0x7f8a}, {0x4d54, 0x8000}, {0x4d55, 0x8449}, {0x4d56, 0x84c9},
  {0x4d57, 0x8981}, {0x4d58, 0x8b21}, {0x4d59, 0x8e0a}, {0x4d5a, 0x9065},
  {0x4d5b, 0x967d}, {0x4d5c, 0x990a}, {0x4d5d, 0x617e}, {0x4d5e, 0x6291},
  {0x4d5f, 0x6b32}, {0x4d60, 0x6c83}, {0x4d61, 0x6d74}, {0x4d62, 0x7fcc},
  {0x4d63, 0x7ffc}, {0x4d64, 0x6dc0}, {0x4d65, 0x7f85}, {0x4d66, 0x87ba},
  {0x4d67, 0x88f8}, {0x4d68, 0x6765}, {0x4d69, 0x83b1}, {0x4d6a, 0x983c},
  {0x4d6b, 0x96f7}, {0x4d6c, 0x6d1b}, {0x4d6d, 0x7d61}, {0x4d6e, 0x843d},
  {0x4d6f, 0x916a}, {0x4d70, 0x4e71}, {0x4d71, 0x5375}, {0x4d72, 0x5d50},
  {0x4d73, 0x6b04}, {0x4d74, 0x6feb}, {0x4d75, 0x85cd}, {0x4d76, 0x862d},
  {0x4d77, 0x89a7}, {0x4d78, 0x5229}, {0x4d79, 0x540f}, {0x4d7a, 0x5c65},
  {0x4d7b, 0x674e}, {0x4d7c, 0x68a8}, {0x4d7d, 0x7406}, {0x4d7e, 0x7483},
  {0x4e21, 0x75e2}, {0x4e22, 0x88cf}, {0x4e23, 0x88e1}, {0x4e24, 0x91cc},
  {0x4e25, 0x96e2}, {0x4e26, 0x9678}, {0x4e27, 0x5f8b}, {0x4e28, 0x7387},
  {0x4e29, 0x7acb}, {0x4e2a, 0x844e}, {0x4e2b, 0x63a0}, {0x4e2c, 0x7565},
  {0x4e2d, 0x5289}, {0x4e2e, 0x6d41}, {0x4e2f, 0x6e9c}, {0x4e30, 0x7409},
  {0x4e31, 0x7559}, {0x4e32, 0x786b}, {0x4e33, 0x7c92}, {0x4e34, 0x9686},
  {0x4e35, 0x7adc}, {0x4e36, 0x9f8d}, {0x4e37, 0x4fb6}, {0x4e38, 0x616e},
  {0x4e39, 0x65c5}, {0x4e3a, 0x865c}, {0x4e3b, 0x4e86}, {0x4e3c, 0x4eae},
  {0x4e3d, 0x50da}, {0x4e3e, 0x4e21}, {0x4e3f, 0x51cc}, {0x4e40, 0x5bee},
  {0x4e41, 0x6599}, {0x4e42, 0x6881}, {0x4e43, 0x6dbc}, {0x4e44, 0x731f},
  {0x4e45, 0x7642}, {0x4e46, 0x77ad}, {0x4e47, 0x7a1c}, {0x4e48, 0x7ce7},
  {0x4e49, 0x826f}, {0x4e4a, 0x8ad2}, {0x4e4b, 0x907c}, {0x4e4c, 0x91cf},
  {0x4e4d, 0x9675}, {0x4e4e, 0x9818}, {0x4e4f, 0x529b}, {0x4e50, 0x7dd1},
  {0x4e51, 0x502b}, {0x4e52, 0x5398}, {0x4e53, 0x6797}, {0x4e54, 0x6dcb},
  {0x4e55, 0x71d0}, {0x4e56, 0x7433}, {0x4e57, 0x81e8}, {0x4e58, 0x8f2a},
  {0x4e59, 0x96a3}, {0x4e5a, 0x9c57}, {0x4e5b, 0x9e9f}, {0x4e5c, 0x7460},
  {0x4e5d, 0x5841}, {0x4e5e, 0x6d99}, {0x4e5f, 0x7d2f}, {0x4e60, 0x985e},
  {0x4e61, 0x4ee4}, {0x4e62, 0x4f36}, {0x4e63, 0x4f8b}, {0x4e64, 0x51b7},
  {0x4e65, 0x52b1}, {0x4e66, 0x5dba}, {0x4e67, 0x601c}, {0x4e68, 0x73b2},
  {0x4e69, 0x793c}, {0x4e6a, 0x82d3}, {0x4e6b, 0x9234}, {0x4e6c, 0x96b7},
  {0x4e6d, 0x96f6}, {0x4e6e, 0x970a}, {0x4e6f, 0x9e97}, {0x4e70, 0x9f62},
  {0x4e71, 0x66a6}, {0x4e72, 0x6b74}, {0x4e73, 0x5217}, {0x4e74, 0x52a3},
  {0x4e75, 0x70c8}, {0x4e76, 0x88c2}, {0x4e77, 0x5ec9}, {0x4e78, 0x604b},
  {0x4e79, 0x6190}, {0x4e7a, 0x6f23}, {0x4e7b, 0x7149}, {0x4e7c, 0x7c3e},
  {0x4e7d, 0x7df4}, {0x4e7e, 0x806f}, {0x4f21, 0x84ee}, {0x4f22, 0x9023},
  {0x4f23, 0x932c}, {0x4f24, 0x5442}, {0x4f25, 0x9b6f}, {0x4f26, 0x6ad3},
  {0x4f27, 0x7089}, {0x4f28, 0x8cc2}, {0x4f29, 0x8def}, {0x4f2a, 0x9732},
  {0x4f2b, 0x52b4}, {0x4f2c, 0x5a41}, {0x4f2d, 0x5eca}, {0x4f2e, 0x5f04},
  {0x4f2f, 0x6717}, {0x4f30, 0x697c}, {0x4f31, 0x6994}, {0x4f32, 0x6d6a},
  {0x4f33, 0x6f0f}, {0x4f34, 0x7262}, {0x4f35, 0x72fc}, {0x4f36, 0x7bed},
  {0x4f37, 0x8001}, {0x4f38, 0x807e}, {0x4f39, 0x874b}, {0x4f3a, 0x90ce},
  {0x4f3b, 0x516d}, {0x4f3c, 0x9e93}, {0x4f3d, 0x7984}, {0x4f3e, 0x808b},
  {0x4f3f, 0x9332}, {0x4f40, 0x8ad6}, {0x4f41, 0x502d}, {0x4f42, 0x548c},
  {0x4f43, 0x8a71}, {0x4f44, 0x6b6a}, {0x4f45, 0x8cc4}, {0x4f46, 0x8107},
  {0x4f47, 0x60d1}, {0x4f48, 0x67a0}, {0x4f49, 0x9df2}, {0x4f4a, 0x4e99},
  {0x4f4b, 0x4e98}, {0x4f4c, 0x9c10}, {0x4f4d, 0x8a6b}, {0x4f4e, 0x85c1},
  {0x4f4f, 0x8568}, {0x4f50, 0x6900}, {0x4f51, 0x6e7e}, {0x4f52, 0x7897},
  {0x4f53, 0x8155},

  /* JIS X 0213 */
  {0x222f, 0xff07}, {0x2230, 0xff02}, {0x2231, 0xff0d}, {0x2232, 0xff5e},
  {0x2233, 0x3033}, {0x2234, 0x3034}, {0x2235, 0x3035}, {0x2236, 0x303b},
  {0x2237, 0x303c}, {0x2238, 0x30ff}, {0x2239, 0x309f}, {0x2242, 0x2284},
  {0x2243, 0x2285}, {0x2244, 0x228a}, {0x2245, 0x228b}, {0x2246, 0x2209},
  {0x2247, 0x2205}, {0x2248, 0x2305}, {0x2249, 0x2306}, {0x2251, 0x2295},
  {0x2252, 0x2296}, {0x2253, 0x2297}, {0x2254, 0x2225}, {0x2255, 0x2226},
  {0x2256, 0xff5f}, {0x2257, 0xff60}, {0x2258, 0x3018}, {0x2259, 0x3019},
  {0x225a, 0x3016}, {0x225b, 0x3017}, {0x226b, 0x2262}, {0x226c, 0x2243},
  {0x226d, 0x2245}, {0x226e, 0x2248}, {0x226f, 0x2276}, {0x2270, 0x2277},
  {0x2271, 0x2194}, {0x227a, 0x266e}, {0x227b, 0x266b}, {0x227c, 0x266c},
  {0x227d, 0x2669}, {0x2321, 0x25b7}, {0x2322, 0x25b6}, {0x2323, 0x25c1},
  {0x2324, 0x25c0}, {0x2325, 0x2197}, {0x2326, 0x2198}, {0x2327, 0x2196},
  {0x2328, 0x2199}, {0x2329, 0x21c4}, {0x232a, 0x21e8}, {0x232b, 0x21e6},
  {0x232c, 0x21e7}, {0x232d, 0x21e9}, {0x232e, 0x2934}, {0x232f, 0x2935},
  {0x233a, 0x29bf}, {0x233b, 0x25c9}, {0x233c, 0x303d}, {0x233d, 0xfe46},
  {0x233e, 0xfe45}, {0x233f, 0x25e6}, {0x2340, 0x2022}, {0x235b, 0x2213},
  {0x235c, 0x2135}, {0x235d, 0x210f}, {0x235e, 0x33cb}, {0x235f, 0x2113},
  {0x2360, 0x2127}, {0x237b, 0x30a0}, {0x237c, 0x2013}, {0x237d, 0x29fa},
  {0x237e, 0x29fb}, {0x2474, 0x3094}, {0x2475, 0x3095}, {0x2476, 0x3096},
  {0x2477, 0x0000}, {0x2478, 0x0000}, {0x2479, 0x0000}, {0x247a, 0x0000},
  {0x247b, 0x0000}, {0x2577, 0x0000}, {0x2578, 0x0000}, {0x2579, 0x0000},
  {0x257a, 0x0000}, {0x257b, 0x0000}, {0x257c, 0x0000}, {0x257d, 0x0000},
  {0x257e, 0x0000}, {0x2678, 0x0000}, {0x2925, 0xffe4},

  {0x2639, 0x2664}, {0x263a, 0x2660}, {0x263b, 0x2662}, {0x263c, 0x2666},
  {0x263d, 0x2661}, {0x263e, 0x2665}, {0x263f, 0x2667}, {0x2640, 0x2663},
  {0x2659, 0x03c2}, {0x265a, 0x24f5}, {0x265b, 0x24f6}, {0x265c, 0x24f7},
  {0x265d, 0x24f8}, {0x265e, 0x24f9}, {0x265f, 0x24fa}, {0x2660, 0x24fb},
  {0x2661, 0x24fc}, {0x2662, 0x24fd}, {0x2663, 0x24fe}, {0x2664, 0x2616},
  {0x2665, 0x2617}, {0x2666, 0x3020}, {0x2667, 0x260e}, {0x2668, 0x2600},
  {0x2669, 0x2601}, {0x266a, 0x2602}, {0x266b, 0x2603}, {0x266c, 0x2668},
  {0x266d, 0x25b1}, {0x266e, 0x31f0}, {0x266f, 0x31f1}, {0x2670, 0x31f2},
  {0x2671, 0x31f3}, {0x2672, 0x31f4}, {0x2673, 0x31f5}, {0x2674, 0x31f6},
  {0x2675, 0x31f7}, {0x2676, 0x31f8}, {0x2677, 0x31f9},
  {0x2679, 0x31fa}, {0x267a, 0x31fb}, {0x267b, 0x31fc}, {0x267c, 0x31fd},
  {0x267d, 0x31fe}, {0x267e, 0x31ff}, {0x2742, 0x23be}, {0x2743, 0x23bf},
  {0x2744, 0x23c0}, {0x2745, 0x23c1}, {0x2746, 0x23c2}, {0x2747, 0x23c3},
  {0x2748, 0x23c4}, {0x2749, 0x23c5}, {0x274a, 0x23c6}, {0x274b, 0x23c7},
  {0x274c, 0x23c8}, {0x274d, 0x23c9}, {0x274e, 0x23ca}, {0x274f, 0x23cb},
  {0x2750, 0x23cc}, {0x2772, 0x30f7}, {0x2773, 0x30f8}, {0x2774, 0x30f9},
  {0x2775, 0x30fa}, {0x2776, 0x22da}, {0x2777, 0x22db}, {0x2778, 0x2153},
  {0x2779, 0x2154}, {0x277a, 0x2155}, {0x277b, 0x2713}, {0x277c, 0x2318},
  {0x277d, 0x2423}, {0x277e, 0x23ce}, {0x4f54, 0x20b9f},{0x4f55, 0x5b41},
  {0x4f56, 0x5b56}, {0x4f57, 0x5b7d}, {0x4f58, 0x5b93}, {0x4f59, 0x5bd8},
  {0x4f5a, 0x5bec}, {0x4f5b, 0x5c12}, {0x4f5c, 0x5c1e}, {0x4f5d, 0x5c23},
  {0x4f5e, 0x5c2b}, {0x4f5f, 0x378d}, {0x4f60, 0x5c62}, {0x4f61, 0xfa3b},
  {0x4f62, 0xfa3c}, {0x4f63, 0x216b4},{0x4f64, 0x5c7a}, {0x4f65, 0x5c8f},
  {0x4f66, 0x5c9f}, {0x4f67, 0x5ca3}, {0x4f68, 0x5caa}, {0x4f69, 0x5cba},
  {0x4f6a, 0x5ccb}, {0x4f6b, 0x5cd0}, {0x4f6c, 0x5cd2}, {0x4f6d, 0x5cf4},
  {0x4f6e, 0x21e34},{0x4f6f, 0x37e2}, {0x4f70, 0x5d0d}, {0x4f71, 0x5d27},
  {0x4f72, 0xfa11}, {0x4f73, 0x5d46}, {0x4f74, 0x5d47}, {0x4f75, 0x5d53},
  {0x4f76, 0x5d4a}, {0x4f77, 0x5d6d}, {0x4f78, 0x5d81}, {0x4f79, 0x5da0},
  {0x4f7a, 0x5da4}, {0x4f7b, 0x5da7}, {0x4f7c, 0x5db8}, {0x4f7d, 0x5dcb},
  {0x4f7e, 0x541e},

  /* eight spoked asterisk */
  {0xfffe, 0x2733},
  /* combining semi-voiced sound mark */
  {0xffff, SEMIVOICED_MARK},
};


int main(int argc, char *argv[])
{
  long i, j, k;
  int opt;
  int for_n66 = 0, put_jisx0213 = 0, use_ascent = 0;
  int code, chr;
  int code_is_ambiguous;
  int pixel_x = 16, pixel_y = 16, over_baseline = 16;
  int charset;
  char line[100];
  char pc8001file[FILENAME_MAX + 1] = "";
  char outfile[FILENAME_MAX + 1];
  unsigned char bmpbdf[BDFSIZE][BDFSIZE];
  unsigned char bmp60[256][16];
  unsigned char bmp80[256][8];
  static unsigned int bmpout[NCHR][16];
  long fpos;
  FILE *fp;

  const int jisx0213tbl[] = {
    0x222f, 0x2230, 0x2231, 0x2232, 0x2233, 0x2234, 0x2235, 0x2236,
    0x2237, 0x2238, 0x2239, 0x2242, 0x2243, 0x2244, 0x2245, 0x2246,
    0x2247, 0x2248, 0x2249, 0x2251, 0x2252, 0x2253, 0x2254, 0x2255,
    0x2256, 0x2257, 0x2258, 0x2259, 0x225a, 0x225b, 0x226b, 0x226c,
    0x226d, 0x226e, 0x226f, 0x2270, 0x2271, 0x227a, 0x227b, 0x227c,
    0x227d, 0x2321, 0x2322, 0x2323, 0x2324, 0x2325, 0x2326, 0x2327,
    0x2328, 0x2329, 0x232a, 0x232b, 0x232c, 0x232d, 0x232e, 0x232f,
    0x233a, 0x233b, 0x233c, 0x233d, 0x233e, 0x233f, 0x2340, 0x235b,
    0x235c, 0x235d, 0x235e, 0x235f, 0x2360, 0x237b, 0x237c, 0x237d,
    0x237e, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479, 0x247a,
    0x247b, 0x2577, 0x2578, 0x2579, 0x257a, 0x257b, 0x257c, 0x257d,
    0x257e, 0x2639, 0x263a, 0x263b, 0x263c, 0x263d, 0x263e, 0x263f,
    0x2640, 0x2659, 0x265a, 0x265b, 0x265c, 0x265d, 0x265e, 0x265f,
    0x2660, 0x2661, 0x2662, 0x2663, 0x2664, 0x2665, 0x2666, 0x2667,
    0x2668, 0x2669, 0x266a, 0x266b, 0x266c, 0x266d, 0x266e, 0x266f,
    0x2670, 0x2671, 0x2672, 0x2673, 0x2674, 0x2675, 0x2676, 0x2677,
    0x2678, 0x2679, 0x267a, 0x267b, 0x267c, 0x267d, 0x267e, 0x2742,
    0x2743, 0x2744, 0x2745, 0x2746, 0x2747, 0x2748, 0x2749, 0x274a,
    0x274b, 0x274c, 0x274d, 0x274e, 0x274f, 0x2750, 0x2772, 0x2773,
    0x2774, 0x2775, 0x2776, 0x2777, 0x2778, 0x2779, 0x277a, 0x277b,
    0x277c, 0x277d, 0x277e, 0x4f54, 0x4f55, 0x4f56, 0x4f57, 0x4f58,
    0x4f59, 0x4f5a, 0x4f5b, 0x4f5c, 0x4f5d, 0x4f5e, 0x4f5f, 0x4f60,
    0x4f61, 0x4f62, 0x4f63, 0x4f64, 0x4f65, 0x4f66, 0x4f67, 0x4f68,
    0x4f69, 0x4f6a, 0x4f6b, 0x4f6c, 0x4f6d, 0x4f6e, 0x4f6f, 0x4f70,
    0x4f71, 0x4f72, 0x4f73, 0x4f74, 0x4f75, 0x4f76, 0x4f77, 0x4f78,
    0x4f79, 0x4f7a, 0x4f7b, 0x4f7c, 0x4f7d, 0x4f7e,
  };

  const int combine[][2] = {
    {0x2477, 0x242b}, {0x2478, 0x242d}, {0x2479, 0x242f}, {0x247a, 0x2431},
    {0x247b, 0x2433}, {0x2577, 0x252b}, {0x2578, 0x252d}, {0x2579, 0x252f},
    {0x257a, 0x2531}, {0x257b, 0x2533}, {0x257c, 0x253b}, {0x257d, 0x2544},
    {0x257e, 0x2548}, {0x2678, 0x2675},
  };

  const int pc6001tbl[] = {
    0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, /* 00 */
    0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121,
    0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, /* 10 */
    0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121, 0x2121,
    0x2121, 0x212a, 0x2149, 0x2274, 0x2170, 0x2173, 0x2175, 0x2147, /* 20 */
    0x214a, 0x214b, 0x2176, 0x215c, 0x2124, 0x2231, 0x2125, 0x213f,
    0x2330, 0x2331, 0x2332, 0x2333, 0x2334, 0x2335, 0x2336, 0x2337, /* 30 */
    0x2338, 0x2339, 0x2127, 0x2128, 0x2163, 0x2161, 0x2164, 0x2129,
    0x2177, 0x2341, 0x2342, 0x2343, 0x2344, 0x2345, 0x2346, 0x2347, /* 40 */
    0x2348, 0x2349, 0x234a, 0x234b, 0x234c, 0x234d, 0x234e, 0x234f,
    0x2350, 0x2351, 0x2352, 0x2353, 0x2354, 0x2355, 0x2356, 0x2357, /* 50 */
    0x2358, 0x2359, 0x235a, 0x214e, 0x216f, 0x214f, 0x2130, 0x2132,
    0x2121, 0x2361, 0x2362, 0x2363, 0x2364, 0x2365, 0x2366, 0x2367, /* 60 */
    0x2368, 0x2369, 0x236a, 0x236b, 0x236c, 0x236d, 0x236e, 0x236f,
    0x2370, 0x2371, 0x2372, 0x2373, 0x2374, 0x2375, 0x2376, 0x2377, /* 70 */
    0x2378, 0x2379, 0x237a, 0x2150, 0x2925, 0x2151, 0x2232, 0x2121,
    0x2121, 0x2123, 0x2156, 0x2157, 0x2122, 0x2126, 0x2472, 0x2421, /* 80 */
    0x2423, 0x2425, 0x2427, 0x2429, 0x2463, 0x2465, 0x2467, 0x2443,
    0x2121, 0x2422, 0x2424, 0x2426, 0x2428, 0x242a, 0x242b, 0x242d, /* 90 */
    0x242f, 0x2431, 0x2433, 0x2435, 0x2437, 0x2439, 0x243b, 0x243d,
    0x2121, 0x2123, 0x2156, 0x2157, 0x2122, 0x2126, 0x2572, 0x2521, /* a0 */
    0x2523, 0x2525, 0x2527, 0x2529, 0x2563, 0x2565, 0x2567, 0x2543,
    0x213c, 0x2522, 0x2524, 0x2526, 0x2528, 0x252a, 0x252b, 0x252d, /* b0 */
    0x252f, 0x2531, 0x2533, 0x2535, 0x2537, 0x2539, 0x253b, 0x253d,
    0x253f, 0x2541, 0x2544, 0x2546, 0x2548, 0x254a, 0x254b, 0x254c, /* c0 */
    0x254d, 0x254e, 0x254f, 0x2552, 0x2555, 0x2558, 0x255b, 0x255e,
    0x255f, 0x2560, 0x2561, 0x2562, 0x2564, 0x2566, 0x2568, 0x2569, /* d0 */
    0x256a, 0x256b, 0x256c, 0x256d, 0x256f, 0x2573, 0x212b, 0x212c,
    0x243f, 0x2441, 0x2444, 0x2446, 0x2448, 0x244a, 0x244b, 0x244c, /* e0 */
    0x244d, 0x244e, 0x244f, 0x2452, 0x2455, 0x2458, 0x245b, 0x245e,
    0x245f, 0x2460, 0x2461, 0x2462, 0x2464, 0x2466, 0x2468, 0x2469, /* f0 */
    0x246a, 0x246b, 0x246c, 0x246d, 0x246f, 0x2473, 0x212b, 0x212c
  };

  const int pc8001tbl[] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 00 */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 10 */
    0x0000, 0x0000, 0x0000, 0x0000, 0x222a, 0x222b, 0x222c, 0x222d,
    0x2121, 0x212a, 0x2230, 0x2174, 0x2170, 0x2173, 0x2175, 0x2147, /* 20 */
    0x214a, 0x214b, 0xfffe, 0x215c, 0x2124, 0x2231, 0x2125, 0x213f,
    0x2330, 0x2331, 0x2332, 0x2333, 0x2334, 0x2335, 0x2336, 0x2337, /* 30 */
    0x2338, 0x2339, 0x2127, 0x2128, 0x2163, 0x2161, 0x2164, 0x2129,
    0x2177, 0x2341, 0x2342, 0x2343, 0x2344, 0x2345, 0x2346, 0x2347, /* 40 */
    0x2348, 0x2349, 0x234a, 0x234b, 0x234c, 0x234d, 0x234e, 0x234f,
    0x2350, 0x2351, 0x2352, 0x2353, 0x2354, 0x2355, 0x2356, 0x2357, /* 50 */
    0x2358, 0x2359, 0x235a, 0x214e, 0x216f, 0x214f, 0x2130, 0x2132,
    0x2121, 0x2361, 0x2362, 0x2363, 0x2364, 0x2365, 0x2366, 0x2367, /* 60 */
    0x2368, 0x2369, 0x236a, 0x236b, 0x236c, 0x236d, 0x236e, 0x236f,
    0x2370, 0x2371, 0x2372, 0x2373, 0x2374, 0x2375, 0x2376, 0x2377, /* 70 */
    0x2378, 0x2379, 0x237a, 0x2150, 0x2925, 0x2151, 0x2232, 0x2121,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 80 */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* 90 */
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x2121, 0x2123, 0x2156, 0x2157, 0x2122, 0x2126, 0x2572, 0x2521, /* a0 */
    0x2523, 0x2525, 0x2527, 0x2529, 0x2563, 0x2565, 0x2567, 0x2543,
    0x213c, 0x2522, 0x2524, 0x2526, 0x2528, 0x252a, 0x252b, 0x252d, /* b0 */
    0x252f, 0x2531, 0x2533, 0x2535, 0x2537, 0x2539, 0x253b, 0x253d,
    0x253f, 0x2541, 0x2544, 0x2546, 0x2548, 0x254a, 0x254b, 0x254c, /* c0 */
    0x254d, 0x254e, 0x254f, 0x2552, 0x2555, 0x2558, 0x255b, 0x255e,
    0x255f, 0x2560, 0x2561, 0x2562, 0x2564, 0x2566, 0x2568, 0x2569, /* d0 */
    0x256a, 0x256b, 0x256c, 0x256d, 0x256f, 0x2573, 0x212b, 0x212c,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, /* e0 */
    0x263a, 0x263e, 0x263c, 0x2640, 0x217c, 0x217b, 0x0000, 0x0000,
    0x0000, 0x315f, 0x472f, 0x376e, 0x467c, 0x3b7e, 0x4a2c, 0x4943, /* f0 */
    0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000, 0x3000
  };

  const int alttbl[][2] = {
    /* double quotation mark */
    {0x2230, 0x2149}, {0x2149, 0x216d}, {0x216d, 0x0022},
    /* apostrophe */
    {0x2147, 0x2222f}, {0x222f, 0x216c}, {0x216c, 0x0027},
    /* eight spoked asterisk */
    {0xfffe, 0x2176},
    /* hyphen-minus */
    {0x2231, 0x215d}, {0x215d, 0x213d}, {0x213d, 0x002d},
    /* square bracket */
    {0x214e, 0x214c},
    {0x214f, 0x214d},
    /* broken bar */
    {0x2925, 0x2143}, {0x2143, 0x007c},
    /* tilde */
    {0x2232, 0x2141}, {0x2141, 0x007e},
    /* suits of playing cards */
    {0x263a, 0x2225},
    {0x2640, 0x217a},
    {0x263e, 0x2227},
    {0x263c, 0x2221},
  };

  /* options */
  for (opt = 1; opt < argc && argv[opt][0] == '-'; opt++) {
    if (strcmp(argv[opt], "-f") == 0) {
      for_n66 = 1;
    } else if (strcmp(argv[opt], "-jisx0213") == 0) {
      put_jisx0213 = 1;
    } else if (strcmp(argv[opt], "-8") == 0) {
      strncpy(pc8001file, argv[++opt], sizeof(pc8001file));
    } else if (strcmp(argv[opt], "-ascent") == 0) {
      use_ascent = 1;
    } else {
      argc = 0;
      break;
    }
  }

  if (argc < opt + 2) {
    printf("usage: bdf2exkanji [-f] [-jisx0213] [-ascent] [-8 PC-8001.chr] fontfile.bdf outfile\n");
    exit(1);
  }

  if (strcmp(argv[opt], "-") == 0) {
    fp = stdin;
  } else {
    fp = fopen(argv[opt], "rb");
    if (fp == NULL) {
      printf("cannot open %s\n", argv[opt]);
      exit(1);
    }
  }

  /* read bdf file */
  charset = getbdfpar(fp, use_ascent, &pixel_x, &pixel_y, &over_baseline);
  while (fgets(line, sizeof(line), fp)) {
    if (sscanf(line, "ENCODING %d", &code) != 1 || code == 0) continue;
    if (charset == UNI) {
      chr = uni2jis(code);
      if (chr == -1) continue;
    } else if (charset == JIS && code < NCHR) {
      chr = code;
    }
    fpos = ftell(fp);
    code_is_ambiguous = isambiguous(code, charset);
    memset(bmpbdf, 0, sizeof(bmpbdf));
    convert(fp, bmpout[chr], 16, 16, pixel_x, pixel_y, over_baseline, code_is_ambiguous);
    fseek(fp, fpos, SEEK_SET);
  }
  fclose(fp);
  if (for_n66) {
    bmp60[0x59][2] = 0x41;
    bmp60[0x59][3] = 0x41;
  }

  /* PC-6001 character set */
  for (i = 0; i < 0x100; i++) {
    chr = pc6001tbl[i];
    for (j = 0; j < sizeof(alttbl) / sizeof(alttbl[0][0]) / 2; j++) {
      if (!isnodata(bmpout[chr])) break;
      if (chr == alttbl[j][0]) {
	chr = alttbl[j][1];
      }
    }

    for (j = 0; j < 16; j++) {
      if (pixel_x <= 8) {
	bmp60[i][j] = (bmpout[chr][j] >> 4) & 0xff;
      } else {
	bmp60[i][j] =
	  ((bmpout[chr][j] & 0xc000) ? 0x80 : 0x00) |
	  ((bmpout[chr][j] & 0x3000) ? 0x40 : 0x00) |
	  ((bmpout[chr][j] & 0x0c00) ? 0x20 : 0x00) |
	  ((bmpout[chr][j] & 0x0300) ? 0x10 : 0x00) |
	  ((bmpout[chr][j] & 0x00c0) ? 0x08 : 0x00) |
	  ((bmpout[chr][j] & 0x0030) ? 0x04 : 0x00) |
	  ((bmpout[chr][j] & 0x000c) ? 0x02 : 0x00) |
	  ((bmpout[chr][j] & 0x0003) ? 0x01 : 0x00);
      }
    }
  }

  /* PC-8001 character set */
  if (strlen(pc8001file)) {
    fp = fopen(pc8001file, "rb");
    if (fp == NULL) {
      printf("cannot open %s\n", pc8001file);
      exit(1);
    }
    for (i = 0x100; i < 0x200; i++) {
      for (j = 0; j < 8; j++) {
	bmp80[i][j] = fgetc(fp);
      }
    }
    fclose(fp);
  } else {
    unsigned int data;

    /* normal character */
    for (i = 0x1c; i < 0x100; i++) {
      chr = pc8001tbl[i];
      for (j = 0; j < sizeof(alttbl) / sizeof(alttbl[0][0]) / 2; j++) {
	if (!isnodata(bmpout[chr])) break;
	if (chr == alttbl[j][0]) {
	  chr = alttbl[j][1];
	}
      }

      for (j = 0; j < 8; j++) {
	if (pixel_y <= 8) {
	  data = bmpout[chr][j + 4];
	} else {
	  data = bmpout[chr][j * 2] | bmpout[chr][j * 2 + 1];
	}
	if (pixel_x <= 8) {
	  bmp80[i][j] = (data >> 4) & 0xff;
	} else {
	  bmp80[i][j] =
	    ((data & 0xc000) ? 0x80 : 0x00) |
	    ((data & 0x3000) ? 0x40 : 0x00) |
	    ((data & 0x0c00) ? 0x20 : 0x00) |
	    ((data & 0x0300) ? 0x10 : 0x00) |
	    ((data & 0x00c0) ? 0x08 : 0x00) |
	    ((data & 0x0030) ? 0x04 : 0x00) |
	    ((data & 0x000c) ? 0x02 : 0x00) |
	    ((data & 0x0003) ? 0x01 : 0x00);
	}
      }
    }

    /* calculate */
    calcchr(bmp80);

  }
  /* PC-8001 character set end */

  /* JIS X 0213 character */
  for (i = 0x2120; i < NCHR; i++) {
    if (put_jisx0213) {
      if (charset == UNI) {
	for (j = 0; j < sizeof(combine) / sizeof(combine[0][0]) / 2; j++) {
	  if (i == combine[j][0]) {
	    chr = uni2jis(SEMIVOICED_MARK);
	    for (k = 0; k < 16; k++) {
	      bmpout[i][k] =
		bmpout[combine[j][1]][k] | bmpout[chr][k];
	    }
	    break;
	  }
	}
      }
    } else {
      for (j = 0; j < sizeof(jisx0213tbl) / sizeof(jisx0213tbl[0]); j++) {
	if (i == jisx0213tbl[j]) {
	  for (k = 0; k < 16; k++) {
	    bmpout[i][k] = 0;
	  }
	  break;
	}
      }
    }
  }

  /* output */
  strncpy(outfile, argv[opt + 1], sizeof(outfile));
  if (strcmp(outfile, "-") == 0) {
    fp = stdout;
  } else {
    fp = fopen(outfile, "wb");
    if (fp == NULL) {
      printf("cannot open %s\n", outfile);
      exit(1);
    }
  }

  for (i = 0; i < 0x100; i++) {
    for (j = 0; j < 16; j++) {
      fputc(bmp60[i][j], fp);
    }
  }
  for (i = 0; i < 0x100; i++) {
    for (j = 0; j < 8; j++) {
      fputc(bmp80[i][j], fp);
    }
  }
  for (i = 0x0c00; i < 0x1200; i++) {
    fputc(0, fp);
    fputc(0, fp);
  }
  for (i = 0x1200; i < 0x4000; i += 0x10) {
    chr = 0x2000 + ((i & 0x01f0) >> 4) + ((i & 0x0e00) >> 1) + ((i & 0x3000) >> 7);
    for (j = 0; j < 16; j++) {
      fputc((bmpout[chr][j] >> 8) & 0xff, fp);
      fputc(bmpout[chr][j] & 0xff, fp);
    }
  }
  for (i = 0x4000; i < 0x10000; i += 0x10) {
    chr = ((i & 0x01f0) >> 4) + ((i & 0x3e00) >> 1) + ((i & 0xc000) >> 9);
    if (chr < 0x1000) {
      chr += 0x4000;
    } else {
      chr += 0x2000;
    }
    for (j = 0; j < 16; j++) {
      fputc((bmpout[chr][j] >> 8) & 0xff, fp);
      fputc(bmpout[chr][j] & 0xff, fp);
    }
  }

  fclose(fp);

  return 0;
}


int getbdfpar(FILE *fp, int use_ascent, int *pixel_x, int *pixel_y, int *over_baseline)
{
  int code = 0;
  int xmin = 999, xmax = -1;
  int ymin = 999, ymax = -1;
  int ascent, descent;
  int size_x, size_y;
  int offset_x = 0, offset_y = 0;
  int result = JIS;
  char line[100] = "";
  char charset[100] = "";

  ascent = -1;
  descent = -1;

  while (fgets(line, sizeof(line), fp)) {
    if (sscanf(line, "FONTBOUNDINGBOX %d %d %d %d", pixel_x, pixel_y, &offset_x, &offset_y) == 4) {
      *over_baseline = *pixel_y + offset_y;
    }
    sscanf(line, "FONT_ASCENT %d", &ascent);
    sscanf(line, "FONT_DESCENT %d", &descent);
    if (sscanf(line, "CHARSET_REGISTRY %s", charset) == 1) {
      if (strncasecmp(charset, "\"JISX0208", 9) == 0 ||
	  strncasecmp(charset, "\"JISX0213", 9) == 0) {
	result = JIS;
      } else if (strcasecmp(charset, "\"ISO10646\"") == 0) {
	result = UNI;
      } else {
	printf("cannot convert for charset %s\n", charset);
	exit(1);
      }
    }
    sscanf(line, "ENCODING %d", &code);
    if (sscanf(line, "BBX %d %d %d %d", &size_x, &size_y, &offset_x, &offset_y) == 4) {
      if (result != UNI ||
	  (0x0000 <= code && code <= 0x03ff) ||
	  (0x2000 <= code && code <= 0x2e39) ||  /* 2e3a = 2-em dash */
	  (0x2e3c <= code && code <= 0x9fff) ||  /* 2e3b = 3-em dash */
	  (0xf900 <= code && code <= 0xfaff) ||
	  (0xff00 <= code && code <= 0xffff)
	  ) {
	if (offset_x < xmin) {
	  xmin = offset_x;
	}
	if (offset_x + size_x > xmax) {
	  xmax = offset_x + size_x;
	}
	if (offset_y < ymin) {
	  ymin = offset_y;
	}
	if (offset_y + size_y > ymax) {
	  ymax = offset_y + size_y;
	}
      }
    }
  }

  *pixel_x = xmax - xmin;
  *pixel_y = ymax - ymin;
  if (use_ascent) {
    *pixel_y = ascent + descent;
    *over_baseline = ascent;
  }
  if (*pixel_x < 0 || *pixel_y < 0 || *over_baseline < 0 || strlen(charset) == 0) {
    printf("illegal bdf\n");
    exit(1);
  }
  rewind(fp);

  return result;
}


void convert(FILE *fp, unsigned int bmpout[16], int size_x_out, int size_y_out, int pixel_x, int pixel_y, int over_baseline, int code_is_ambiguous)
{
  int i, j;
  int x, y;
  int size_x, size_y;
  int offset_x, offset_y;
  unsigned long long data;
  double ratio_x, ratio_y;
  char line[100];
  unsigned char bmpbdf[BDFSIZE][BDFSIZE];

  memset(bmpbdf, 0, sizeof(bmpbdf));
  do {
    if (fgets(line, sizeof(line), fp) == NULL) break;
  } while (sscanf(line, "BBX %d %d %d %d", &size_x, &size_y, &offset_x, &offset_y) != 4);

  if (code_is_ambiguous && size_x + offset_x <= pixel_x / 2) {
    pixel_x /= 2;
  }

  if (pixel_x > size_x_out) {
    ratio_x = (double)pixel_x / size_x_out;
  } else {
    ratio_x = 1;
    offset_x += (size_x_out - pixel_x) / 2;
  }
  if (pixel_y > size_y_out) {
    ratio_y = (double)pixel_y / size_y_out;
  } else {
    ratio_y = 1;
    offset_y -= (size_y_out - pixel_y) / 2;
  }

  if (offset_x < 0) {
    offset_x = 0;
  }

  do {
    if (fgets(line, sizeof(line), fp) == NULL) break;
  } while (strncmp(line, "BITMAP", 6) != 0);

  for (i = 0; i < size_y; i++) {
    if (fgets(line, sizeof(line), fp) == NULL) break;
    while (sscanf(line, "%llx", &data) != 1) {
      ;
    }
    for (j = 0; j < size_x; j++) {
      x = j + offset_x;
      y = i + over_baseline - size_y - offset_y;
      if (0 <= x && x <= BDFSIZE && 0 <= y && y <= BDFSIZE) {
	bmpbdf[x][y] = (data >> ((BDFSIZE - size_x) % 8 + size_x - j - 1)) & 1;
      }
    }
  }

  if (size_y > 0) {
    for (i = 0; i < size_y_out; i++) {
      bmpout[i] = 0;
      for (j = 0; j < size_x_out; j++) {
	data = 0;
	for (x = j * ratio_x; x < (int)((j + 1) * ratio_x + .01) && x < BDFSIZE; x++) {
	  for (y = i * ratio_y; y < (int)((i + 1) * ratio_y + .01) && y < BDFSIZE; y++) {
	    data += bmpbdf[x][y];
	  }
	}
	if ((double)data / (x - (int)(j * ratio_x)) * (y - (int)(i * ratio_y)) > 0) {
	  bmpout[i] |= 1 << (size_x_out - j - 1);
	}
      }
    }
  }
}


int isnodata(unsigned int *bmpout)
{
  int i;
  for (i = 0; i < 16; i++) {
    if (bmpout[i]) return 0;
  }
  return 1;
}


int uni2jis(int uni)
{
  int i;
  for (i = 0; i < sizeof(jisunitbl) / sizeof(jisunitbl[0][0]) / 2; i++) {
    if (jisunitbl[i][1] == uni) {
      return jisunitbl[i][0];
    }
  }
  return -1;
}


int isambiguous(int code, int charset)
{
  int i;
  const int eawtbl[] = {
    /* greek letter */
    0x0393, 0x0394, 0x039b, 0x03a0, 0x03a3, 0x03a9, 0x03b1, 0x03b2,
    0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7, 0x03b8, 0x03b9, 0x03ba,
    0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf, 0x03c0, 0x03c1, 0x03c3,
    0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8, 0x03c9,
    0x0392, 0x03a6, 0x03d5,
    /* box drawing */
    0x2501, 0x2503, 0x250f, 0x2513, 0x2517, 0x251b, 0x2523, 0x252b,
    0x2533, 0x253b, 0x254b,
    /* math symbols */
    0x00b1, 0x00d7, 0x2190, 0x2191, 0x2192, 0x2193, 0x2211, 0x221a,
    0x221e, 0x2248, 0x2295, 0x2260, 0x2264, 0x2265, 0x2266, 0x2267,
    0x22bf, 0x23a7, 0x23ad, 0x23b0, 0x23b1,
    0x27f2, 0x27f3, 0x2197, 0x2199, 0x2196, 0x2198, 0x221d, 0x2252,
    0x2202, 0x2213, 0x222a, 0x2234, 0x2235, 0x2299, 0x229d, 0x2295,
    0x2296, 0x2297, 0x2298, 0x2228, 0x2227,
    /* latin */
    0x00e2, 0x00ee, 0x00fb, 0x00ea, 0x00e8, 0x00e9, 0x0153, 0x00e4,
    0x00fc, 0x00f6, 0x0251, 0x028c, 0x0259, 0x00e6, 0x025a, 0x0254,
    0x028f, 0x026a, 0x014b, 0x0292, 0x0283, 0x00f0, 0x0272, 0x0281,
    0x00e7, 0x026f, 0x0265, 0x028a, 0x00e3, 0x00d7, 0x00f7, 0x00b1,
    /* final punctuation */
    0x2019, 0x201d,
    /* modifier symbol */
    0x00a8,
    /* other number */
    0x00bc, 0x00bd,
    0x2492, 0x2493, 
    /* other punctuation */
    0x00b7, 0x2015,
    0x203b, 0x00a7, 0x2016, 0x203e,
    /* other symbols */
    0x00b0, 0x25b3, 0x25bd, 0x25a0, 0x25a1, 0x25b2, 0x25bc, 0x25c6,
    0x25cb, 0x25cf, 0x2605, 0x2660, 0x2663, 0x2665, 0x2666,
    0x25aa, 0x25a3, 0x260e, 0x2733, 0x1d10b, 0x1d10c, 0x2642, 0x2640,
    0x25ce, 0x29b6, 0x26eb, 0x26e8, 0x26fb, 0x25c7, 0x2b59, 0x26e3,
    0x1f6e7,
  };
    
  if (charset == JIS) return 0;

  for (i = 0; i < sizeof(eawtbl) / sizeof(eawtbl[0]); i++) {
    if (code == eawtbl[i]) {
      return 1;
    }
  }
  return 0;
}


void calcchr(unsigned char bmp80[][8])
{
  int i, j;
  int chr;
  unsigned char data;
  const unsigned char dots1 = 0x01;
  const unsigned char dots4 = 0x0f;
  const char control[][3] = {
    "  ", "SH", "SX", "EX", "ET", "EQ", "AK", "BL",
    "BS", "HT", "LF", "HM", "CL", "CR", "SO", "SI",
    "DE", "D1", "D2", "D3", "D4", "NK", "SN", "EB",
    "CN", "EM", "SB", "EC"
  };
  const int line_shape[][4] = {
    /* left, right, up, down */
    {1, 1, 1, 1}, /* 8f */
    {1, 1, 1, 0}, {1, 1, 0, 1}, {1, 0, 1, 1}, {0, 1, 1, 1}, /* 90-93 */
    {0, 0, 0, 0}, {1, 1, 0, 0}, {0, 0, 1, 1}, {0, 0, 0, 0}, /* 94-97 */
    {0, 1, 0, 1}, {1, 0, 0, 1}, {0, 1, 1, 0}, {1, 0, 1, 0}, /* 98-9b */
  };

  /* control code character */
  for (i = 0x00; i < 0x1c; i++) {
    chr = (unsigned)control[i][0];
    for (j = 0; j < 4; j++) {
      data =
	bmp80[chr][j * 2] |
	bmp80[chr][j * 2 + 1];
      bmp80[i][j] =
	((data & 0xc0) ? 0x80 : 0x00) |
	((data & 0x30) ? 0x40 : 0x00) |
	((data & 0x0c) ? 0x20 : 0x00) |
	((data & 0x03) ? 0x10 : 0x00);
    }
    chr = (unsigned)control[i][1];
    for (j = 0; j < 4; j++) {
      data =
	bmp80[chr][j * 2] |
	bmp80[chr][j * 2 + 1];
      bmp80[i][j + 4] |=
	((data & 0xc0) ? 0x08 : 0x00) |
	((data & 0x30) ? 0x04 : 0x00) |
	((data & 0x0c) ? 0x02 : 0x00) |
	((data & 0x03) ? 0x01 : 0x00);
    }
  }

  /* lower n/8 block character */
  for (i = 0; i < 8; i++) {
    chr = i + 0x80;
    for (j = 0; j <= i; j++) {
      bmp80[chr][7 - j] = 0xff;
    }
  }

  /* left n/8 block character */
  for (i = 0; i < 7; i++) {
    chr = i + 0x88;
    for (j = 0; j < 8; j++) {
      bmp80[chr][j] = 0x100 - (0x80 >> i);
    }
  }

  /* box drawings */
  for (i = 0; i < sizeof(line_shape) / sizeof(line_shape[0][0]) / 4; i++) {
    chr = 0x8f + i;
    for (j = 0; j < 8; j++) {
      bmp80[chr][j] = 0;
    }
    bmp80[chr][4] =
      (line_shape[i][0] ? (dots4 << 4) : 0) |
      (line_shape[i][1] ? dots4 : 0);
    for (j = 0; j < 5; j++) {
      bmp80[chr][j] |= line_shape[i][2] ? (dots1 << 3) : 0;
    }
    for (j = 4; j < 8; j++) {
      bmp80[chr][j] |= line_shape[i][3] ? (dots1 << 3) : 0;
    }
  }

  /* upper 1/8 block character */
  bmp80[0x94][0] = 0xff;

  /* right 1/8 block character */
  for (i = 0; i < 8; i++) {
    bmp80[0x97][i] = 0x01;
  }

  /* 1/4 arc character */
  for (i = 0x9c; i < 0xa0; i++) {
    for (j = 0; j < 3; j++) {
      bmp80[i][j] = (i & 0x02) ? 0x08 : 0x00;
    }
    for (j = 6; j < 8; j++) {
      bmp80[i][j] = (i & 0x02) ? 0x00 : 0x08;
    }
    bmp80[i][4] = (i & 0x01) ? 0xe0 : 0x03;
    bmp80[i][5 - (i & 0x02)] = (i & 0x01) ? 0x10 : 0x04;
  }

  /* double horizontal character */
  for (i = 0xe0; i < 0xe4; i++) {
    for (j = 0; j < 8; j++) {
      bmp80[i][j] = (i == 0xe0 ? 0x00 : bmp80[0x96][j]);
    }
    bmp80[i][2] |= (i == 0xe1? 0x00 : 0xf0);
    bmp80[i][2] |= (i == 0xe3? 0x00 : 0x0f);
    bmp80[i][5] |= (i == 0xe1? 0x00 : 0xf0);
    bmp80[i][5] |= (i == 0xe3? 0x00 : 0x0f);
  }

  /* triangle character */
  for (i = 0; i < 8; i++) {
    bmp80[0xe4][i] = (0x02 << i) - 0x01;
    bmp80[0xe5][i] = 0x100 - (0x80 >> i);
    bmp80[0xe6][i] = (0x100 >> i) - 0x01;
    bmp80[0xe7][i] = 0x100 - (0x01 << i);
  }

  /* box drawing character */
  for (i = 0; i < 8; i++) {
    bmp80[0xee][i] = 0x01 << i;
    bmp80[0xef][i] = 0x80 >> i;
    bmp80[0xf0][i] = (0x01 << i) | (0x80 >> i);
  }

}
