/////////////////////////////////////////////////////////////////////////////
//  P C 6 0 0 1 V
//  Copyright 1999 Yumitaro
/////////////////////////////////////////////////////////////////////////////
#include <stdexcept>

#include "breakpoint.h"


#ifndef NOMONITOR	// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

/////////////////////////////////////////////////////////////////////////////
// Constructor
/////////////////////////////////////////////////////////////////////////////
BPoint::BPoint( void )
{
}


/////////////////////////////////////////////////////////////////////////////
// Destructor
/////////////////////////////////////////////////////////////////////////////
BPoint::~BPoint( void )
{
}


/////////////////////////////////////////////////////////////////////////////
// ブレークポイントを設定
/////////////////////////////////////////////////////////////////////////////
void BPoint::Set( const BPtype type, const WORD addr )
{
	BreakPoint bp;
	bp.Type  = type;
	bp.Addr  = addr;
	bp.Break = false;
	
	BP.emplace_back( bp );
}


/////////////////////////////////////////////////////////////////////////////
// ブレークポイントを削除
/////////////////////////////////////////////////////////////////////////////
void BPoint::Delete( const int num )
{
	if( num ){
		BP.erase( BP.begin() + num - 1 );
	}else{
		BP.clear();
	}
}


/////////////////////////////////////////////////////////////////////////////
// ブレークポイントのタイプを取得
/////////////////////////////////////////////////////////////////////////////
BPoint::BPtype BPoint::GetType( const int num ) const
{
	try{
		return BP.at( num - 1 ).Type;
	}
	catch( std::out_of_range& ){
		return BP_NONE;
	}
}


/////////////////////////////////////////////////////////////////////////////
// ブレークポイントのアドレスを取得
/////////////////////////////////////////////////////////////////////////////
WORD BPoint::GetAddr( const int num ) const
{
	try{
		return BP.at( num - 1 ).Addr;
	}
	catch( std::out_of_range& ){
		return 0;
	}
}


/////////////////////////////////////////////////////////////////////////////
// ブレークポイント登録数取得
/////////////////////////////////////////////////////////////////////////////
int BPoint::GetNum( void ) const
{
	return BP.size();
}


/////////////////////////////////////////////////////////////////////////////
// ブレークポイントをチェック
/////////////////////////////////////////////////////////////////////////////
bool BPoint::Check( const BPtype type, const WORD addr )
{
	for( auto &i : BP ){
		if( i.Type == type && i.Addr == addr ){
			i.Break = true;
			return true;
		}
	}
	return false;
}


/////////////////////////////////////////////////////////////////////////////
// ブレーク要求のあったブレークポイントNo.を取得
/////////////////////////////////////////////////////////////////////////////
int BPoint::GetReqNum( void ) const
{
	int num = 1;
	for( auto &i : BP ){
		if( i.Break ){
			return num;
		}
		num++;
	}
	return 0;
}


/////////////////////////////////////////////////////////////////////////////
// ブレーク要求キャンセル
/////////////////////////////////////////////////////////////////////////////
void BPoint::Reset( void )
{
	for( auto &i : BP ){
		i.Break = false;
	}
}


#endif				// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
