/* -*- Mode: IDL; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * The origin of this IDL file is
 * http://dev.w3.org/fxtf/web-animations/#the-animatable-interface
 *
 * Copyright © 2014 W3C® (MIT, ERCIM, Keio), All Rights Reserved. W3C
 * liability, trademark and document use rules apply.
 */

dictionary KeyframeAnimationOptions : KeyframeEffectOptions {
  DOMString id = "";
};

dictionary AnimationFilter {
  boolean subtree = false;
};

[NoInterfaceObject]
interface Animatable {
  [Func="nsDocument::IsElementAnimateEnabled", Throws]
  Animation animate(object? frames,
                    optional (unrestricted double or KeyframeAnimationOptions)
                      options);
  [Func="nsDocument::IsWebAnimationsEnabled"]
  sequence<Animation> getAnimations(optional AnimationFilter filter);
};
