/*
 * Copyright 2015 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifndef SkSpinlock_DEFINED
#define SkSpinlock_DEFINED

#include "SkTypes.h"
#include "SkAtomics.h"

class SkSpinlock {
public:
    void acquire() {
        // To act as a mutex, we need an acquire barrier when we acquire the lock.
        if (fLocked.exchange(true, sk_memory_order_acquire)) {
            // Lock was contended.  Fall back to an out-of-line spin loop.
            this->contendedAcquire();
        }
    }

    void release() {
        // To act as a mutex, we need a release barrier when we release the lock.
        fLocked.store(false, sk_memory_order_release);
    }

private:
    SK_API void contendedAcquire();

    SkAtomic<bool> fLocked{false};
};

#endif//SkSpinlock_DEFINED
