/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.NewpagedDiagram;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.html.CucaDiagramHtmlMaker;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class PSystemUtils {
    public static List<File> exportDiagrams(Diagram system, File suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        if (system instanceof UmlDiagram) {
            ISkinParam skinParam = ((UmlDiagram)system).getSkinParam();
            fileFormatOption = fileFormatOption.withSvgLinkTarget(skinParam.getSvgLinkTarget());
        }
        if (system instanceof NewpagedDiagram) {
            return PSystemUtils.exportDiagramsNewpaged((NewpagedDiagram)system, suggestedFile, fileFormatOption);
        }
        if (system instanceof SequenceDiagram) {
            return PSystemUtils.exportDiagramsSequence((SequenceDiagram)system, suggestedFile, fileFormatOption);
        }
        if (system instanceof CucaDiagram) {
            return PSystemUtils.exportDiagramsCuca((CucaDiagram)system, suggestedFile, fileFormatOption);
        }
        if (system instanceof ActivityDiagram3) {
            return PSystemUtils.exportDiagramsActivityDiagram3((ActivityDiagram3)system, suggestedFile, fileFormatOption);
        }
        return PSystemUtils.exportDiagramsDefault(system, suggestedFile, fileFormatOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> exportDiagramsNewpaged(NewpagedDiagram system, File suggestedFile, FileFormatOption fileFormat) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        int nbImages = system.getNbImages();
        for (int i = 0; i < nbImages; ++i) {
            File f = fileFormat.getFileFormat().computeFilename(suggestedFile, i);
            if (!PSystemUtils.canFileBeWritten(f)) {
                return result;
            }
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));
            try {
                system.exportDiagram(fos, i, fileFormat);
            }
            finally {
                ((OutputStream)fos).close();
            }
            Log.info("File size : " + f.length());
            result.add(f);
        }
        return result;
    }

    public static boolean canFileBeWritten(File f) {
        Log.info("Creating file: " + f);
        if (f.exists() && !f.canWrite()) {
            if (OptionFlags.getInstance().isOverwrite()) {
                Log.info("Overwrite " + f);
                f.setWritable(true);
                f.delete();
                return true;
            }
            Log.error("Cannot write to file " + f);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> exportDiagramsDefault(Diagram system, File suggestedFile, FileFormatOption fileFormat) throws IOException {
        if (suggestedFile.exists() && suggestedFile.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        OutputStream os = null;
        try {
            if (!PSystemUtils.canFileBeWritten(suggestedFile)) {
                List<File> list = Collections.emptyList();
                return list;
            }
            os = new BufferedOutputStream(new FileOutputStream(suggestedFile));
            system.exportDiagram(os, 0, fileFormat);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        return Arrays.asList(suggestedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> exportDiagramsActivityDiagram3(ActivityDiagram3 system, File suggestedFile, FileFormatOption fileFormat) throws IOException {
        if (suggestedFile.exists() && suggestedFile.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        OutputStream os = null;
        ImageData cmap = null;
        try {
            if (!PSystemUtils.canFileBeWritten(suggestedFile)) {
                List<File> list = Collections.emptyList();
                return list;
            }
            os = new BufferedOutputStream(new FileOutputStream(suggestedFile));
            cmap = system.exportDiagram(os, 0, fileFormat);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        if (cmap != null && cmap.containsCMapData()) {
            system.exportCmap(suggestedFile, cmap);
        }
        return Arrays.asList(suggestedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> exportDiagramsSequence(SequenceDiagram system, File suggestedFile, FileFormatOption fileFormat) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        int nbImages = system.getNbImages();
        for (int i = 0; i < nbImages; ++i) {
            File f = fileFormat.getFileFormat().computeFilename(suggestedFile, i);
            if (!PSystemUtils.canFileBeWritten(suggestedFile)) {
                return result;
            }
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));
            ImageData cmap = null;
            try {
                cmap = system.exportDiagram(fos, i, fileFormat);
            }
            finally {
                ((OutputStream)fos).close();
            }
            if (cmap != null && cmap.containsCMapData()) {
                system.exportCmap(suggestedFile, cmap);
            }
            Log.info("File size : " + f.length());
            result.add(f);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> exportDiagramsCuca(CucaDiagram system, File suggestedFile, FileFormatOption fileFormat) throws IOException {
        if (suggestedFile.exists() && suggestedFile.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + suggestedFile);
        }
        if (fileFormat.getFileFormat() == FileFormat.HTML) {
            return PSystemUtils.createFilesHtml(system, suggestedFile);
        }
        ImageData cmap = null;
        OutputStream os = null;
        try {
            if (!PSystemUtils.canFileBeWritten(suggestedFile)) {
                List<File> list = Collections.emptyList();
                return list;
            }
            os = new BufferedOutputStream(new FileOutputStream(suggestedFile));
            cmap = system.exportDiagram(os, 0, fileFormat);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        List<File> result = Arrays.asList(suggestedFile);
        if (cmap != null && cmap.containsCMapData()) {
            system.exportCmap(suggestedFile, cmap);
        }
        if (fileFormat.getFileFormat() == FileFormat.PNG) {
            result = new PngSplitter(suggestedFile, system.getHorizontalPages(), system.getVerticalPages(), system.getMetadata(), system.getDpi(fileFormat), fileFormat.isWithMetadata()).getFiles();
        }
        return result;
    }

    private static List<File> createFilesHtml(CucaDiagram system, File suggestedFile) throws IOException {
        String name = suggestedFile.getName();
        int idx = name.lastIndexOf(46);
        File dir = new File(suggestedFile.getParentFile(), name.substring(0, idx));
        CucaDiagramHtmlMaker maker = new CucaDiagramHtmlMaker(system, dir);
        return maker.create();
    }
}

