/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.Position;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class AtomTable
implements Atom {
    private final List<Line> lines = new ArrayList<Line>();
    private final Map<Atom, Position> positions = new HashMap<Atom, Position>();
    private final HtmlColor lineColor;

    public AtomTable(HtmlColor lineColor) {
        this.lineColor = lineColor;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        this.initMap(stringBounder);
        double width = this.getEndingX(this.getNbCols() - 1);
        double height = this.getEndingY(this.getNbLines() - 1);
        return new Dimension2DDouble(width, height);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        this.initMap(ug.getStringBounder());
        for (Line line : this.lines) {
            for (Atom cell : line.cells) {
                Position pos = this.positions.get(cell);
                cell.drawU(ug.apply(pos.getTranslate()));
            }
        }
        ug = ug.apply(new UChangeColor(this.lineColor));
        ULine hline = new ULine(this.getEndingX(this.getNbCols() - 1), 0.0);
        for (int i = 0; i <= this.getNbLines(); ++i) {
            ug.apply(new UTranslate(0.0, this.getStartingY(i))).draw(hline);
        }
        ULine vline = new ULine(0.0, this.getEndingY(this.getNbLines() - 1));
        for (int i = 0; i <= this.getNbCols(); ++i) {
            ug.apply(new UTranslate(this.getStartingX(i), 0.0)).draw(vline);
        }
    }

    private void initMap(StringBounder stringBounder) {
        if (this.positions.size() > 0) {
            return;
        }
        for (Line line : this.lines) {
            for (Atom cell : line.cells) {
                Dimension2D dim = cell.calculateDimension(stringBounder);
                Position pos = new Position(0.0, 0.0, dim);
                this.positions.put(cell, pos);
            }
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            for (int j = 0; j < this.lines.get(i).size(); ++j) {
                Atom cell = (Atom)this.lines.get(i).cells.get(j);
                Dimension2D dim = cell.calculateDimension(stringBounder);
                double x = this.getStartingX(j);
                double y = this.getStartingY(i);
                Position pos = new Position(x, y, dim);
                this.positions.put(cell, pos);
            }
        }
    }

    private double getStartingX(int col) {
        double result = 0.0;
        for (int i = 0; i < col; ++i) {
            result += this.getColWidth(i);
        }
        return result;
    }

    private double getEndingX(int col) {
        double result = 0.0;
        for (int i = 0; i <= col; ++i) {
            result += this.getColWidth(i);
        }
        return result;
    }

    private double getStartingY(int line) {
        double result = 0.0;
        for (int i = 0; i < line; ++i) {
            result += this.getLineHeight(i);
        }
        return result;
    }

    private double getEndingY(int line) {
        double result = 0.0;
        for (int i = 0; i <= line; ++i) {
            result += this.getLineHeight(i);
        }
        return result;
    }

    private double getColWidth(int col) {
        double result = 0.0;
        for (int i = 0; i < this.getNbLines(); ++i) {
            Position position = this.getPosition(i, col);
            if (position == null) continue;
            double width = position.getWidth();
            result = Math.max(result, width);
        }
        return result;
    }

    private double getLineHeight(int line) {
        double result = 0.0;
        for (int i = 0; i < this.getNbCols(); ++i) {
            Position position = this.getPosition(line, i);
            if (position == null) continue;
            double height = position.getHeight();
            result = Math.max(result, height);
        }
        return result;
    }

    private Position getPosition(int line, int col) {
        if (line >= this.lines.size()) {
            return null;
        }
        Line l = this.lines.get(line);
        if (col >= l.cells.size()) {
            return null;
        }
        Atom atom = (Atom)l.cells.get(col);
        return this.positions.get(atom);
    }

    private int getNbCols() {
        return this.lines.get(0).size();
    }

    private int getNbLines() {
        return this.lines.size();
    }

    private Line lastLine() {
        return this.lines.get(this.lines.size() - 1);
    }

    public void addCell(Atom cell) {
        this.lastLine().add(cell);
        this.positions.clear();
    }

    public void newLine() {
        this.lines.add(new Line());
    }

    class Line {
        private final List<Atom> cells = new ArrayList<Atom>();

        Line() {
        }

        public void add(Atom cell) {
            this.cells.add(cell);
        }

        public int size() {
            return this.cells.size();
        }

        public String toString() {
            return super.toString() + " " + this.cells.size();
        }
    }
}

