/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomTable;
import net.sourceforge.plantuml.creole.AtomWithMargin;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.StripeStyle;
import net.sourceforge.plantuml.creole.StripeStyleType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class StripeTable
implements Stripe {
    private FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final AtomTable table;
    private final Atom marged;
    private final StripeStyle stripeStyle = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');

    public StripeTable(FontConfiguration fontConfiguration, ISkinSimple skinParam, String line) {
        this.fontConfiguration = fontConfiguration;
        this.skinParam = skinParam;
        this.table = new AtomTable(fontConfiguration.getColor());
        this.marged = new AtomWithMargin(this.table, 2.0, 2.0);
        this.analyzeAndAddInternal(line, Mode.HEADER);
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this.marged);
    }

    static Atom asAtom(List<StripeSimple> cells, double padding) {
        Sheet sheet = new Sheet(HorizontalAlignment.LEFT);
        for (StripeSimple cell : cells) {
            sheet.add(cell);
        }
        return new SheetBlock1(sheet, 0.0, padding);
    }

    private void analyzeAndAddInternal(String line, Mode mode) {
        this.table.newLine();
        StringTokenizer st = new StringTokenizer(line, "|");
        while (st.hasMoreTokens()) {
            String v = st.nextToken();
            if (mode == Mode.HEADER && v.startsWith("=")) {
                v = v.substring(1);
            }
            List<String> lines = StripeTable.getWithNewlinesInternal(v);
            ArrayList<StripeSimple> cells = new ArrayList<StripeSimple>();
            for (String s : lines) {
                StripeSimple cell = new StripeSimple(this.getFontConfiguration(mode), this.stripeStyle, new CreoleContext(), this.skinParam, CreoleMode.FULL);
                cell.analyzeAndAdd(s);
                cells.add(cell);
            }
            this.table.addCell(StripeTable.asAtom(cells, this.skinParam.getPadding()));
        }
    }

    static List<String> getWithNewlinesInternal(String s) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < s.length() - 1) {
                char c2 = s.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    result.add(current.toString());
                    current.setLength(0);
                    continue;
                }
                if (c2 == '\\') {
                    current.append(c2);
                    continue;
                }
                current.append(c);
                current.append(c2);
                continue;
            }
            current.append(c);
        }
        result.add(current.toString());
        return result;
    }

    private FontConfiguration getFontConfiguration(Mode mode) {
        if (mode == Mode.NORMAL) {
            return this.fontConfiguration;
        }
        return this.fontConfiguration.bold();
    }

    public void analyzeAndAddNormal(String line) {
        this.analyzeAndAddInternal(line, Mode.NORMAL);
    }

    static enum Mode {
        HEADER,
        NORMAL;

    }
}

